# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 common_name: pulumi.Input[_builtins.str],
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_dn: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 csr_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 csr_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ecdsa_curve: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_window: Optional[pulumi.Input[_builtins.int]] = None,
                 issuer_hint: Optional[pulumi.Input[_builtins.str]] = None,
                 key_password: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pkcs12: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 rsa_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 san_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valid_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[_builtins.str] common_name: The common name of the certificate.
        :param pulumi.Input[_builtins.str] algorithm: Key encryption algorithm, either RSA or ECDSA. Defaults to `RSA`.
        :param pulumi.Input[_builtins.str] country: Country of the certificate (C)
        :param pulumi.Input[_builtins.str] csr_origin: Whether key-pair generation will be `local` or `service` generated. Default is 
               `local`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_fields: Collection of Custom Field name-value pairs to assign to the certificate.
        :param pulumi.Input[_builtins.str] ecdsa_curve: ECDSA curve to use when generating a key
        :param pulumi.Input[_builtins.int] expiration_window: Number of hours before certificate expiry to request a new certificate. 
               Defaults to `168`.
        :param pulumi.Input[_builtins.str] issuer_hint: Used with `valid_days` to indicate the target issuer when using Trust Protection 
               Platform. Relevant values are: `DigiCert`, `Entrust`, and `Microsoft`.
        :param pulumi.Input[_builtins.str] key_password: The password used to encrypt the private key.
        :param pulumi.Input[_builtins.str] locality: Locality/City of the certificate (L)
        :param pulumi.Input[_builtins.str] nickname: Use to specify a name for the new certificate object that will be created and placed 
               in a policy. Only valid for Trust Protection Platform.
        :param pulumi.Input[_builtins.str] organization: Organization of the certificate (O)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_units: List of Organizational Units of the certificate (OU)
        :param pulumi.Input[_builtins.str] pkcs12: A base64-encoded PKCS#12 keystore secured by the `key_password`. Useful when working with resources like 
               azure key_vault_certificate.
        :param pulumi.Input[_builtins.str] private_key_pem: The private key in PEM format.
        :param pulumi.Input[_builtins.bool] renew_required: Indicates the certificate should be reissued. This means the resource will destroyed and recreated
        :param pulumi.Input[_builtins.int] rsa_bits: Number of bits to use when generating an RSA key. Applies when algorithm is `RSA`. 
               Defaults to `2048`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_dns: List of DNS names to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_emails: List of email addresses to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_ips: List of IP addresses to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_uris: List of Uniform Resource Identifiers (URIs) to use as alternative subjects of 
               the certificate.
        :param pulumi.Input[_builtins.str] state: State of the certificate (S)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of Certificate Tags defined in Venafi Control Plane.
        :param pulumi.Input[_builtins.int] valid_days: Desired number of days for which the new certificate will be valid.
        """
        pulumi.set(__self__, "common_name", common_name)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if certificate_dn is not None:
            pulumi.set(__self__, "certificate_dn", certificate_dn)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if csr_origin is not None:
            pulumi.set(__self__, "csr_origin", csr_origin)
        if csr_pem is not None:
            pulumi.set(__self__, "csr_pem", csr_pem)
        if custom_fields is not None:
            pulumi.set(__self__, "custom_fields", custom_fields)
        if ecdsa_curve is not None:
            pulumi.set(__self__, "ecdsa_curve", ecdsa_curve)
        if expiration_window is not None:
            pulumi.set(__self__, "expiration_window", expiration_window)
        if issuer_hint is not None:
            pulumi.set(__self__, "issuer_hint", issuer_hint)
        if key_password is not None:
            pulumi.set(__self__, "key_password", key_password)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if nickname is not None:
            pulumi.set(__self__, "nickname", nickname)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_units is not None:
            pulumi.set(__self__, "organizational_units", organizational_units)
        if pkcs12 is not None:
            pulumi.set(__self__, "pkcs12", pkcs12)
        if private_key_pem is not None:
            pulumi.set(__self__, "private_key_pem", private_key_pem)
        if renew_required is not None:
            pulumi.set(__self__, "renew_required", renew_required)
        if rsa_bits is not None:
            pulumi.set(__self__, "rsa_bits", rsa_bits)
        if san_dns is not None:
            pulumi.set(__self__, "san_dns", san_dns)
        if san_emails is not None:
            pulumi.set(__self__, "san_emails", san_emails)
        if san_ips is not None:
            pulumi.set(__self__, "san_ips", san_ips)
        if san_uris is not None:
            pulumi.set(__self__, "san_uris", san_uris)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if valid_days is not None:
            pulumi.set(__self__, "valid_days", valid_days)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[_builtins.str]:
        """
        The common name of the certificate.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key encryption algorithm, either RSA or ECDSA. Defaults to `RSA`.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="certificateDn")
    def certificate_dn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "certificate_dn")

    @certificate_dn.setter
    def certificate_dn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_dn", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Country of the certificate (C)
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter(name="csrOrigin")
    def csr_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether key-pair generation will be `local` or `service` generated. Default is 
        `local`.
        """
        return pulumi.get(self, "csr_origin")

    @csr_origin.setter
    def csr_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr_origin", value)

    @_builtins.property
    @pulumi.getter(name="csrPem")
    def csr_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "csr_pem")

    @csr_pem.setter
    def csr_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr_pem", value)

    @_builtins.property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Collection of Custom Field name-value pairs to assign to the certificate.
        """
        return pulumi.get(self, "custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_fields", value)

    @_builtins.property
    @pulumi.getter(name="ecdsaCurve")
    def ecdsa_curve(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ECDSA curve to use when generating a key
        """
        return pulumi.get(self, "ecdsa_curve")

    @ecdsa_curve.setter
    def ecdsa_curve(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecdsa_curve", value)

    @_builtins.property
    @pulumi.getter(name="expirationWindow")
    def expiration_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of hours before certificate expiry to request a new certificate. 
        Defaults to `168`.
        """
        return pulumi.get(self, "expiration_window")

    @expiration_window.setter
    def expiration_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_window", value)

    @_builtins.property
    @pulumi.getter(name="issuerHint")
    def issuer_hint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used with `valid_days` to indicate the target issuer when using Trust Protection 
        Platform. Relevant values are: `DigiCert`, `Entrust`, and `Microsoft`.
        """
        return pulumi.get(self, "issuer_hint")

    @issuer_hint.setter
    def issuer_hint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_hint", value)

    @_builtins.property
    @pulumi.getter(name="keyPassword")
    def key_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password used to encrypt the private key.
        """
        return pulumi.get(self, "key_password")

    @key_password.setter
    def key_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_password", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Locality/City of the certificate (L)
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Use to specify a name for the new certificate object that will be created and placed 
        in a policy. Only valid for Trust Protection Platform.
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization of the certificate (O)
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Organizational Units of the certificate (OU)
        """
        return pulumi.get(self, "organizational_units")

    @organizational_units.setter
    def organizational_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organizational_units", value)

    @_builtins.property
    @pulumi.getter
    def pkcs12(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A base64-encoded PKCS#12 keystore secured by the `key_password`. Useful when working with resources like 
        azure key_vault_certificate.
        """
        return pulumi.get(self, "pkcs12")

    @pkcs12.setter
    def pkcs12(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pkcs12", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key in PEM format.
        """
        return pulumi.get(self, "private_key_pem")

    @private_key_pem.setter
    def private_key_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_pem", value)

    @_builtins.property
    @pulumi.getter(name="renewRequired")
    def renew_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates the certificate should be reissued. This means the resource will destroyed and recreated
        """
        return pulumi.get(self, "renew_required")

    @renew_required.setter
    def renew_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renew_required", value)

    @_builtins.property
    @pulumi.getter(name="rsaBits")
    def rsa_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of bits to use when generating an RSA key. Applies when algorithm is `RSA`. 
        Defaults to `2048`.
        """
        return pulumi.get(self, "rsa_bits")

    @rsa_bits.setter
    def rsa_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rsa_bits", value)

    @_builtins.property
    @pulumi.getter(name="sanDns")
    def san_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DNS names to use as alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_dns")

    @san_dns.setter
    def san_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "san_dns", value)

    @_builtins.property
    @pulumi.getter(name="sanEmails")
    def san_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses to use as alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_emails")

    @san_emails.setter
    def san_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "san_emails", value)

    @_builtins.property
    @pulumi.getter(name="sanIps")
    def san_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses to use as alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_ips")

    @san_ips.setter
    def san_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "san_ips", value)

    @_builtins.property
    @pulumi.getter(name="sanUris")
    def san_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Uniform Resource Identifiers (URIs) to use as alternative subjects of 
        the certificate.
        """
        return pulumi.get(self, "san_uris")

    @san_uris.setter
    def san_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "san_uris", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the certificate (S)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Certificate Tags defined in Venafi Control Plane.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="validDays")
    def valid_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Desired number of days for which the new certificate will be valid.
        """
        return pulumi.get(self, "valid_days")

    @valid_days.setter
    def valid_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "valid_days", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_dn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 chain: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 csr_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 csr_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ecdsa_curve: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_window: Optional[pulumi.Input[_builtins.int]] = None,
                 issuer_hint: Optional[pulumi.Input[_builtins.str]] = None,
                 key_password: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pkcs12: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 rsa_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 san_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valid_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[_builtins.str] algorithm: Key encryption algorithm, either RSA or ECDSA. Defaults to `RSA`.
        :param pulumi.Input[_builtins.str] certificate: The X509 certificate in PEM format.
        :param pulumi.Input[_builtins.str] certificate_id: ID of the issued certificate
        :param pulumi.Input[_builtins.str] chain: The trust chain of X509 certificate authority certificates in PEM format concatenated together.
        :param pulumi.Input[_builtins.str] common_name: The common name of the certificate.
        :param pulumi.Input[_builtins.str] country: Country of the certificate (C)
        :param pulumi.Input[_builtins.str] csr_origin: Whether key-pair generation will be `local` or `service` generated. Default is 
               `local`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_fields: Collection of Custom Field name-value pairs to assign to the certificate.
        :param pulumi.Input[_builtins.str] ecdsa_curve: ECDSA curve to use when generating a key
        :param pulumi.Input[_builtins.int] expiration_window: Number of hours before certificate expiry to request a new certificate. 
               Defaults to `168`.
        :param pulumi.Input[_builtins.str] issuer_hint: Used with `valid_days` to indicate the target issuer when using Trust Protection 
               Platform. Relevant values are: `DigiCert`, `Entrust`, and `Microsoft`.
        :param pulumi.Input[_builtins.str] key_password: The password used to encrypt the private key.
        :param pulumi.Input[_builtins.str] locality: Locality/City of the certificate (L)
        :param pulumi.Input[_builtins.str] nickname: Use to specify a name for the new certificate object that will be created and placed 
               in a policy. Only valid for Trust Protection Platform.
        :param pulumi.Input[_builtins.str] organization: Organization of the certificate (O)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_units: List of Organizational Units of the certificate (OU)
        :param pulumi.Input[_builtins.str] pkcs12: A base64-encoded PKCS#12 keystore secured by the `key_password`. Useful when working with resources like 
               azure key_vault_certificate.
        :param pulumi.Input[_builtins.str] private_key_pem: The private key in PEM format.
        :param pulumi.Input[_builtins.bool] renew_required: Indicates the certificate should be reissued. This means the resource will destroyed and recreated
        :param pulumi.Input[_builtins.int] rsa_bits: Number of bits to use when generating an RSA key. Applies when algorithm is `RSA`. 
               Defaults to `2048`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_dns: List of DNS names to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_emails: List of email addresses to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_ips: List of IP addresses to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_uris: List of Uniform Resource Identifiers (URIs) to use as alternative subjects of 
               the certificate.
        :param pulumi.Input[_builtins.str] state: State of the certificate (S)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of Certificate Tags defined in Venafi Control Plane.
        :param pulumi.Input[_builtins.int] valid_days: Desired number of days for which the new certificate will be valid.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_dn is not None:
            pulumi.set(__self__, "certificate_dn", certificate_dn)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if csr_origin is not None:
            pulumi.set(__self__, "csr_origin", csr_origin)
        if csr_pem is not None:
            pulumi.set(__self__, "csr_pem", csr_pem)
        if custom_fields is not None:
            pulumi.set(__self__, "custom_fields", custom_fields)
        if ecdsa_curve is not None:
            pulumi.set(__self__, "ecdsa_curve", ecdsa_curve)
        if expiration_window is not None:
            pulumi.set(__self__, "expiration_window", expiration_window)
        if issuer_hint is not None:
            pulumi.set(__self__, "issuer_hint", issuer_hint)
        if key_password is not None:
            pulumi.set(__self__, "key_password", key_password)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if nickname is not None:
            pulumi.set(__self__, "nickname", nickname)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_units is not None:
            pulumi.set(__self__, "organizational_units", organizational_units)
        if pkcs12 is not None:
            pulumi.set(__self__, "pkcs12", pkcs12)
        if private_key_pem is not None:
            pulumi.set(__self__, "private_key_pem", private_key_pem)
        if renew_required is not None:
            pulumi.set(__self__, "renew_required", renew_required)
        if rsa_bits is not None:
            pulumi.set(__self__, "rsa_bits", rsa_bits)
        if san_dns is not None:
            pulumi.set(__self__, "san_dns", san_dns)
        if san_emails is not None:
            pulumi.set(__self__, "san_emails", san_emails)
        if san_ips is not None:
            pulumi.set(__self__, "san_ips", san_ips)
        if san_uris is not None:
            pulumi.set(__self__, "san_uris", san_uris)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if valid_days is not None:
            pulumi.set(__self__, "valid_days", valid_days)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key encryption algorithm, either RSA or ECDSA. Defaults to `RSA`.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The X509 certificate in PEM format.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="certificateDn")
    def certificate_dn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "certificate_dn")

    @certificate_dn.setter
    def certificate_dn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_dn", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the issued certificate
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trust chain of X509 certificate authority certificates in PEM format concatenated together.
        """
        return pulumi.get(self, "chain")

    @chain.setter
    def chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chain", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The common name of the certificate.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Country of the certificate (C)
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter(name="csrOrigin")
    def csr_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether key-pair generation will be `local` or `service` generated. Default is 
        `local`.
        """
        return pulumi.get(self, "csr_origin")

    @csr_origin.setter
    def csr_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr_origin", value)

    @_builtins.property
    @pulumi.getter(name="csrPem")
    def csr_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "csr_pem")

    @csr_pem.setter
    def csr_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr_pem", value)

    @_builtins.property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Collection of Custom Field name-value pairs to assign to the certificate.
        """
        return pulumi.get(self, "custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_fields", value)

    @_builtins.property
    @pulumi.getter(name="ecdsaCurve")
    def ecdsa_curve(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ECDSA curve to use when generating a key
        """
        return pulumi.get(self, "ecdsa_curve")

    @ecdsa_curve.setter
    def ecdsa_curve(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecdsa_curve", value)

    @_builtins.property
    @pulumi.getter(name="expirationWindow")
    def expiration_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of hours before certificate expiry to request a new certificate. 
        Defaults to `168`.
        """
        return pulumi.get(self, "expiration_window")

    @expiration_window.setter
    def expiration_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_window", value)

    @_builtins.property
    @pulumi.getter(name="issuerHint")
    def issuer_hint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used with `valid_days` to indicate the target issuer when using Trust Protection 
        Platform. Relevant values are: `DigiCert`, `Entrust`, and `Microsoft`.
        """
        return pulumi.get(self, "issuer_hint")

    @issuer_hint.setter
    def issuer_hint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_hint", value)

    @_builtins.property
    @pulumi.getter(name="keyPassword")
    def key_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password used to encrypt the private key.
        """
        return pulumi.get(self, "key_password")

    @key_password.setter
    def key_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_password", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Locality/City of the certificate (L)
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Use to specify a name for the new certificate object that will be created and placed 
        in a policy. Only valid for Trust Protection Platform.
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization of the certificate (O)
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Organizational Units of the certificate (OU)
        """
        return pulumi.get(self, "organizational_units")

    @organizational_units.setter
    def organizational_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "organizational_units", value)

    @_builtins.property
    @pulumi.getter
    def pkcs12(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A base64-encoded PKCS#12 keystore secured by the `key_password`. Useful when working with resources like 
        azure key_vault_certificate.
        """
        return pulumi.get(self, "pkcs12")

    @pkcs12.setter
    def pkcs12(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pkcs12", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key in PEM format.
        """
        return pulumi.get(self, "private_key_pem")

    @private_key_pem.setter
    def private_key_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_pem", value)

    @_builtins.property
    @pulumi.getter(name="renewRequired")
    def renew_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates the certificate should be reissued. This means the resource will destroyed and recreated
        """
        return pulumi.get(self, "renew_required")

    @renew_required.setter
    def renew_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renew_required", value)

    @_builtins.property
    @pulumi.getter(name="rsaBits")
    def rsa_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of bits to use when generating an RSA key. Applies when algorithm is `RSA`. 
        Defaults to `2048`.
        """
        return pulumi.get(self, "rsa_bits")

    @rsa_bits.setter
    def rsa_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rsa_bits", value)

    @_builtins.property
    @pulumi.getter(name="sanDns")
    def san_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DNS names to use as alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_dns")

    @san_dns.setter
    def san_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "san_dns", value)

    @_builtins.property
    @pulumi.getter(name="sanEmails")
    def san_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses to use as alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_emails")

    @san_emails.setter
    def san_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "san_emails", value)

    @_builtins.property
    @pulumi.getter(name="sanIps")
    def san_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses to use as alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_ips")

    @san_ips.setter
    def san_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "san_ips", value)

    @_builtins.property
    @pulumi.getter(name="sanUris")
    def san_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Uniform Resource Identifiers (URIs) to use as alternative subjects of 
        the certificate.
        """
        return pulumi.get(self, "san_uris")

    @san_uris.setter
    def san_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "san_uris", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the certificate (S)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Certificate Tags defined in Venafi Control Plane.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="validDays")
    def valid_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Desired number of days for which the new certificate will be valid.
        """
        return pulumi.get(self, "valid_days")

    @valid_days.setter
    def valid_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "valid_days", value)


@pulumi.type_token("venafi:index/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_dn: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 csr_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 csr_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ecdsa_curve: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_window: Optional[pulumi.Input[_builtins.int]] = None,
                 issuer_hint: Optional[pulumi.Input[_builtins.str]] = None,
                 key_password: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pkcs12: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 rsa_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 san_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valid_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a Certificate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: Key encryption algorithm, either RSA or ECDSA. Defaults to `RSA`.
        :param pulumi.Input[_builtins.str] common_name: The common name of the certificate.
        :param pulumi.Input[_builtins.str] country: Country of the certificate (C)
        :param pulumi.Input[_builtins.str] csr_origin: Whether key-pair generation will be `local` or `service` generated. Default is 
               `local`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_fields: Collection of Custom Field name-value pairs to assign to the certificate.
        :param pulumi.Input[_builtins.str] ecdsa_curve: ECDSA curve to use when generating a key
        :param pulumi.Input[_builtins.int] expiration_window: Number of hours before certificate expiry to request a new certificate. 
               Defaults to `168`.
        :param pulumi.Input[_builtins.str] issuer_hint: Used with `valid_days` to indicate the target issuer when using Trust Protection 
               Platform. Relevant values are: `DigiCert`, `Entrust`, and `Microsoft`.
        :param pulumi.Input[_builtins.str] key_password: The password used to encrypt the private key.
        :param pulumi.Input[_builtins.str] locality: Locality/City of the certificate (L)
        :param pulumi.Input[_builtins.str] nickname: Use to specify a name for the new certificate object that will be created and placed 
               in a policy. Only valid for Trust Protection Platform.
        :param pulumi.Input[_builtins.str] organization: Organization of the certificate (O)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_units: List of Organizational Units of the certificate (OU)
        :param pulumi.Input[_builtins.str] pkcs12: A base64-encoded PKCS#12 keystore secured by the `key_password`. Useful when working with resources like 
               azure key_vault_certificate.
        :param pulumi.Input[_builtins.str] private_key_pem: The private key in PEM format.
        :param pulumi.Input[_builtins.bool] renew_required: Indicates the certificate should be reissued. This means the resource will destroyed and recreated
        :param pulumi.Input[_builtins.int] rsa_bits: Number of bits to use when generating an RSA key. Applies when algorithm is `RSA`. 
               Defaults to `2048`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_dns: List of DNS names to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_emails: List of email addresses to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_ips: List of IP addresses to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_uris: List of Uniform Resource Identifiers (URIs) to use as alternative subjects of 
               the certificate.
        :param pulumi.Input[_builtins.str] state: State of the certificate (S)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of Certificate Tags defined in Venafi Control Plane.
        :param pulumi.Input[_builtins.int] valid_days: Desired number of days for which the new certificate will be valid.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Certificate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_dn: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 csr_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 csr_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ecdsa_curve: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_window: Optional[pulumi.Input[_builtins.int]] = None,
                 issuer_hint: Optional[pulumi.Input[_builtins.str]] = None,
                 key_password: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pkcs12: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 rsa_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 san_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 san_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valid_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["algorithm"] = algorithm
            __props__.__dict__["certificate_dn"] = certificate_dn
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            __props__.__dict__["country"] = country
            __props__.__dict__["csr_origin"] = csr_origin
            __props__.__dict__["csr_pem"] = csr_pem
            __props__.__dict__["custom_fields"] = custom_fields
            __props__.__dict__["ecdsa_curve"] = ecdsa_curve
            __props__.__dict__["expiration_window"] = expiration_window
            __props__.__dict__["issuer_hint"] = issuer_hint
            __props__.__dict__["key_password"] = None if key_password is None else pulumi.Output.secret(key_password)
            __props__.__dict__["locality"] = locality
            __props__.__dict__["nickname"] = nickname
            __props__.__dict__["organization"] = organization
            __props__.__dict__["organizational_units"] = organizational_units
            __props__.__dict__["pkcs12"] = pkcs12
            __props__.__dict__["private_key_pem"] = None if private_key_pem is None else pulumi.Output.secret(private_key_pem)
            __props__.__dict__["renew_required"] = renew_required
            __props__.__dict__["rsa_bits"] = rsa_bits
            __props__.__dict__["san_dns"] = san_dns
            __props__.__dict__["san_emails"] = san_emails
            __props__.__dict__["san_ips"] = san_ips
            __props__.__dict__["san_uris"] = san_uris
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            __props__.__dict__["valid_days"] = valid_days
            __props__.__dict__["certificate"] = None
            __props__.__dict__["certificate_id"] = None
            __props__.__dict__["chain"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["keyPassword", "privateKeyPem"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'venafi:index/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_dn: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            chain: Optional[pulumi.Input[_builtins.str]] = None,
            common_name: Optional[pulumi.Input[_builtins.str]] = None,
            country: Optional[pulumi.Input[_builtins.str]] = None,
            csr_origin: Optional[pulumi.Input[_builtins.str]] = None,
            csr_pem: Optional[pulumi.Input[_builtins.str]] = None,
            custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ecdsa_curve: Optional[pulumi.Input[_builtins.str]] = None,
            expiration_window: Optional[pulumi.Input[_builtins.int]] = None,
            issuer_hint: Optional[pulumi.Input[_builtins.str]] = None,
            key_password: Optional[pulumi.Input[_builtins.str]] = None,
            locality: Optional[pulumi.Input[_builtins.str]] = None,
            nickname: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            pkcs12: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_pem: Optional[pulumi.Input[_builtins.str]] = None,
            renew_required: Optional[pulumi.Input[_builtins.bool]] = None,
            rsa_bits: Optional[pulumi.Input[_builtins.int]] = None,
            san_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            san_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            san_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            san_uris: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            valid_days: Optional[pulumi.Input[_builtins.int]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: Key encryption algorithm, either RSA or ECDSA. Defaults to `RSA`.
        :param pulumi.Input[_builtins.str] certificate: The X509 certificate in PEM format.
        :param pulumi.Input[_builtins.str] certificate_id: ID of the issued certificate
        :param pulumi.Input[_builtins.str] chain: The trust chain of X509 certificate authority certificates in PEM format concatenated together.
        :param pulumi.Input[_builtins.str] common_name: The common name of the certificate.
        :param pulumi.Input[_builtins.str] country: Country of the certificate (C)
        :param pulumi.Input[_builtins.str] csr_origin: Whether key-pair generation will be `local` or `service` generated. Default is 
               `local`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_fields: Collection of Custom Field name-value pairs to assign to the certificate.
        :param pulumi.Input[_builtins.str] ecdsa_curve: ECDSA curve to use when generating a key
        :param pulumi.Input[_builtins.int] expiration_window: Number of hours before certificate expiry to request a new certificate. 
               Defaults to `168`.
        :param pulumi.Input[_builtins.str] issuer_hint: Used with `valid_days` to indicate the target issuer when using Trust Protection 
               Platform. Relevant values are: `DigiCert`, `Entrust`, and `Microsoft`.
        :param pulumi.Input[_builtins.str] key_password: The password used to encrypt the private key.
        :param pulumi.Input[_builtins.str] locality: Locality/City of the certificate (L)
        :param pulumi.Input[_builtins.str] nickname: Use to specify a name for the new certificate object that will be created and placed 
               in a policy. Only valid for Trust Protection Platform.
        :param pulumi.Input[_builtins.str] organization: Organization of the certificate (O)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] organizational_units: List of Organizational Units of the certificate (OU)
        :param pulumi.Input[_builtins.str] pkcs12: A base64-encoded PKCS#12 keystore secured by the `key_password`. Useful when working with resources like 
               azure key_vault_certificate.
        :param pulumi.Input[_builtins.str] private_key_pem: The private key in PEM format.
        :param pulumi.Input[_builtins.bool] renew_required: Indicates the certificate should be reissued. This means the resource will destroyed and recreated
        :param pulumi.Input[_builtins.int] rsa_bits: Number of bits to use when generating an RSA key. Applies when algorithm is `RSA`. 
               Defaults to `2048`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_dns: List of DNS names to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_emails: List of email addresses to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_ips: List of IP addresses to use as alternative subjects of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] san_uris: List of Uniform Resource Identifiers (URIs) to use as alternative subjects of 
               the certificate.
        :param pulumi.Input[_builtins.str] state: State of the certificate (S)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of Certificate Tags defined in Venafi Control Plane.
        :param pulumi.Input[_builtins.int] valid_days: Desired number of days for which the new certificate will be valid.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificate_dn"] = certificate_dn
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["chain"] = chain
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["country"] = country
        __props__.__dict__["csr_origin"] = csr_origin
        __props__.__dict__["csr_pem"] = csr_pem
        __props__.__dict__["custom_fields"] = custom_fields
        __props__.__dict__["ecdsa_curve"] = ecdsa_curve
        __props__.__dict__["expiration_window"] = expiration_window
        __props__.__dict__["issuer_hint"] = issuer_hint
        __props__.__dict__["key_password"] = key_password
        __props__.__dict__["locality"] = locality
        __props__.__dict__["nickname"] = nickname
        __props__.__dict__["organization"] = organization
        __props__.__dict__["organizational_units"] = organizational_units
        __props__.__dict__["pkcs12"] = pkcs12
        __props__.__dict__["private_key_pem"] = private_key_pem
        __props__.__dict__["renew_required"] = renew_required
        __props__.__dict__["rsa_bits"] = rsa_bits
        __props__.__dict__["san_dns"] = san_dns
        __props__.__dict__["san_emails"] = san_emails
        __props__.__dict__["san_ips"] = san_ips
        __props__.__dict__["san_uris"] = san_uris
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["valid_days"] = valid_days
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Key encryption algorithm, either RSA or ECDSA. Defaults to `RSA`.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The X509 certificate in PEM format.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="certificateDn")
    def certificate_dn(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "certificate_dn")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the issued certificate
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def chain(self) -> pulumi.Output[_builtins.str]:
        """
        The trust chain of X509 certificate authority certificates in PEM format concatenated together.
        """
        return pulumi.get(self, "chain")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[_builtins.str]:
        """
        The common name of the certificate.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Country of the certificate (C)
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter(name="csrOrigin")
    def csr_origin(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether key-pair generation will be `local` or `service` generated. Default is 
        `local`.
        """
        return pulumi.get(self, "csr_origin")

    @_builtins.property
    @pulumi.getter(name="csrPem")
    def csr_pem(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "csr_pem")

    @_builtins.property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Collection of Custom Field name-value pairs to assign to the certificate.
        """
        return pulumi.get(self, "custom_fields")

    @_builtins.property
    @pulumi.getter(name="ecdsaCurve")
    def ecdsa_curve(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ECDSA curve to use when generating a key
        """
        return pulumi.get(self, "ecdsa_curve")

    @_builtins.property
    @pulumi.getter(name="expirationWindow")
    def expiration_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of hours before certificate expiry to request a new certificate. 
        Defaults to `168`.
        """
        return pulumi.get(self, "expiration_window")

    @_builtins.property
    @pulumi.getter(name="issuerHint")
    def issuer_hint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Used with `valid_days` to indicate the target issuer when using Trust Protection 
        Platform. Relevant values are: `DigiCert`, `Entrust`, and `Microsoft`.
        """
        return pulumi.get(self, "issuer_hint")

    @_builtins.property
    @pulumi.getter(name="keyPassword")
    def key_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password used to encrypt the private key.
        """
        return pulumi.get(self, "key_password")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Locality/City of the certificate (L)
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Use to specify a name for the new certificate object that will be created and placed 
        in a policy. Only valid for Trust Protection Platform.
        """
        return pulumi.get(self, "nickname")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Organization of the certificate (O)
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Organizational Units of the certificate (OU)
        """
        return pulumi.get(self, "organizational_units")

    @_builtins.property
    @pulumi.getter
    def pkcs12(self) -> pulumi.Output[_builtins.str]:
        """
        A base64-encoded PKCS#12 keystore secured by the `key_password`. Useful when working with resources like 
        azure key_vault_certificate.
        """
        return pulumi.get(self, "pkcs12")

    @_builtins.property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> pulumi.Output[_builtins.str]:
        """
        The private key in PEM format.
        """
        return pulumi.get(self, "private_key_pem")

    @_builtins.property
    @pulumi.getter(name="renewRequired")
    def renew_required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates the certificate should be reissued. This means the resource will destroyed and recreated
        """
        return pulumi.get(self, "renew_required")

    @_builtins.property
    @pulumi.getter(name="rsaBits")
    def rsa_bits(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of bits to use when generating an RSA key. Applies when algorithm is `RSA`. 
        Defaults to `2048`.
        """
        return pulumi.get(self, "rsa_bits")

    @_builtins.property
    @pulumi.getter(name="sanDns")
    def san_dns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of DNS names to use as alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_dns")

    @_builtins.property
    @pulumi.getter(name="sanEmails")
    def san_emails(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of email addresses to use as alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_emails")

    @_builtins.property
    @pulumi.getter(name="sanIps")
    def san_ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of IP addresses to use as alternative subjects of the certificate.
        """
        return pulumi.get(self, "san_ips")

    @_builtins.property
    @pulumi.getter(name="sanUris")
    def san_uris(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Uniform Resource Identifiers (URIs) to use as alternative subjects of 
        the certificate.
        """
        return pulumi.get(self, "san_uris")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        State of the certificate (S)
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Certificate Tags defined in Venafi Control Plane.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="validDays")
    def valid_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Desired number of days for which the new certificate will be valid.
        """
        return pulumi.get(self, "valid_days")

