# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudKeystoreInstallationArgs', 'CloudKeystoreInstallation']

@pulumi.input_type
class CloudKeystoreInstallationArgs:
    def __init__(__self__, *,
                 certificate_id: pulumi.Input[_builtins.str],
                 cloud_keystore_id: pulumi.Input[_builtins.str],
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gcm_cert_scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CloudKeystoreInstallation resource.
        :param pulumi.Input[_builtins.str] certificate_id: ID of the certificate to be provisioned to the given `keystore_id`.
        :param pulumi.Input[_builtins.str] cloud_keystore_id: ID of the cloud keystore where the certificate will be provisioned.
        :param pulumi.Input[_builtins.str] arn: ARN of the AWS certificate. Use it to provision the VCP certificate to an existing ACM certificate, instead of a new one. Only valid for ACM keystores.
        :param pulumi.Input[_builtins.str] cloud_certificate_name: Name for the provisioned certificate in the keystore. If the name already exists, the provisioning will replace the previous certificate with the one from `certificate_id`. Only valid for AKV and GCM keystores.
        :param pulumi.Input[_builtins.str] gcm_cert_scope: The GCM certificate scope of the certificate. Only valid for GCM keystores. Supported values from GCM API documentation: DEFAULT, EDGE_CACHE, ALL_REGIONS.
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "cloud_keystore_id", cloud_keystore_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cloud_certificate_name is not None:
            pulumi.set(__self__, "cloud_certificate_name", cloud_certificate_name)
        if gcm_cert_scope is not None:
            pulumi.set(__self__, "gcm_cert_scope", gcm_cert_scope)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the certificate to be provisioned to the given `keystore_id`.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudKeystoreId")
    def cloud_keystore_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the cloud keystore where the certificate will be provisioned.
        """
        return pulumi.get(self, "cloud_keystore_id")

    @cloud_keystore_id.setter
    def cloud_keystore_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_keystore_id", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the AWS certificate. Use it to provision the VCP certificate to an existing ACM certificate, instead of a new one. Only valid for ACM keystores.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="cloudCertificateName")
    def cloud_certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the provisioned certificate in the keystore. If the name already exists, the provisioning will replace the previous certificate with the one from `certificate_id`. Only valid for AKV and GCM keystores.
        """
        return pulumi.get(self, "cloud_certificate_name")

    @cloud_certificate_name.setter
    def cloud_certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="gcmCertScope")
    def gcm_cert_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCM certificate scope of the certificate. Only valid for GCM keystores. Supported values from GCM API documentation: DEFAULT, EDGE_CACHE, ALL_REGIONS.
        """
        return pulumi.get(self, "gcm_cert_scope")

    @gcm_cert_scope.setter
    def gcm_cert_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcm_cert_scope", value)


@pulumi.input_type
class _CloudKeystoreInstallationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_certificate_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_keystore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcm_cert_scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudKeystoreInstallation resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the AWS certificate. Use it to provision the VCP certificate to an existing ACM certificate, instead of a new one. Only valid for ACM keystores.
        :param pulumi.Input[_builtins.str] certificate_id: ID of the certificate to be provisioned to the given `keystore_id`.
        :param pulumi.Input[_builtins.str] cloud_certificate_id: The ID of the provisioned certificate within the Cloud Keystore
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] cloud_certificate_metadata: Metadata of the provisioned certificate from the Cloud Keystore
        :param pulumi.Input[_builtins.str] cloud_certificate_name: Name for the provisioned certificate in the keystore. If the name already exists, the provisioning will replace the previous certificate with the one from `certificate_id`. Only valid for AKV and GCM keystores.
        :param pulumi.Input[_builtins.str] cloud_keystore_id: ID of the cloud keystore where the certificate will be provisioned.
        :param pulumi.Input[_builtins.str] gcm_cert_scope: The GCM certificate scope of the certificate. Only valid for GCM keystores. Supported values from GCM API documentation: DEFAULT, EDGE_CACHE, ALL_REGIONS.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if cloud_certificate_id is not None:
            pulumi.set(__self__, "cloud_certificate_id", cloud_certificate_id)
        if cloud_certificate_metadata is not None:
            pulumi.set(__self__, "cloud_certificate_metadata", cloud_certificate_metadata)
        if cloud_certificate_name is not None:
            pulumi.set(__self__, "cloud_certificate_name", cloud_certificate_name)
        if cloud_keystore_id is not None:
            pulumi.set(__self__, "cloud_keystore_id", cloud_keystore_id)
        if gcm_cert_scope is not None:
            pulumi.set(__self__, "gcm_cert_scope", gcm_cert_scope)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the AWS certificate. Use it to provision the VCP certificate to an existing ACM certificate, instead of a new one. Only valid for ACM keystores.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the certificate to be provisioned to the given `keystore_id`.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudCertificateId")
    def cloud_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the provisioned certificate within the Cloud Keystore
        """
        return pulumi.get(self, "cloud_certificate_id")

    @cloud_certificate_id.setter
    def cloud_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudCertificateMetadata")
    def cloud_certificate_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata of the provisioned certificate from the Cloud Keystore
        """
        return pulumi.get(self, "cloud_certificate_metadata")

    @cloud_certificate_metadata.setter
    def cloud_certificate_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cloud_certificate_metadata", value)

    @_builtins.property
    @pulumi.getter(name="cloudCertificateName")
    def cloud_certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the provisioned certificate in the keystore. If the name already exists, the provisioning will replace the previous certificate with the one from `certificate_id`. Only valid for AKV and GCM keystores.
        """
        return pulumi.get(self, "cloud_certificate_name")

    @cloud_certificate_name.setter
    def cloud_certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="cloudKeystoreId")
    def cloud_keystore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the cloud keystore where the certificate will be provisioned.
        """
        return pulumi.get(self, "cloud_keystore_id")

    @cloud_keystore_id.setter
    def cloud_keystore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_keystore_id", value)

    @_builtins.property
    @pulumi.getter(name="gcmCertScope")
    def gcm_cert_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCM certificate scope of the certificate. Only valid for GCM keystores. Supported values from GCM API documentation: DEFAULT, EDGE_CACHE, ALL_REGIONS.
        """
        return pulumi.get(self, "gcm_cert_scope")

    @gcm_cert_scope.setter
    def gcm_cert_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcm_cert_scope", value)


@pulumi.type_token("venafi:index/cloudKeystoreInstallation:CloudKeystoreInstallation")
class CloudKeystoreInstallation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_keystore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcm_cert_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provisions a certificate from Venafi Control Plane's inventory to any of the supported Cloud Providers: Amazon
        Certificate Manager, Azure KeyVault or Google Certificate Manager. Exports the ID of the provisioned certificate:
        certificate name for AKV and GCM or ARN for ACM.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_venafi as venafi

        # Provision a certificate to cloud keystore with static values
        ck_installation_example_by_id = venafi.CloudKeystoreInstallation("ck_installation_example_by_id",
            cloud_keystore_id="e48897d0-2762-11ef-198k-79ac590dd358",
            certificate_id="1877af16-2762-11ef-8fab-cc123456ff7",
            cloud_certificate_name="com-terraform-example-com")
        # Provision a certificate to cloud keystore
        ck_installation_example = venafi.CloudKeystoreInstallation("ck_installation_example",
            cloud_keystore_id=ck_example["id"],
            certificate_id=certificate_example["certificateId"],
            cloud_certificate_name=certificate_example["commonName"])
        ```

        ## Import

        Using `pulumi import`, import a Machine Identity from Venafi Control Plane using their ID. For example:

        console

        ```sh
        $ pulumi import venafi:index/cloudKeystoreInstallation:CloudKeystoreInstallation example 2155bd32-2234-22ac-7cfd-ff1198845aa2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the AWS certificate. Use it to provision the VCP certificate to an existing ACM certificate, instead of a new one. Only valid for ACM keystores.
        :param pulumi.Input[_builtins.str] certificate_id: ID of the certificate to be provisioned to the given `keystore_id`.
        :param pulumi.Input[_builtins.str] cloud_certificate_name: Name for the provisioned certificate in the keystore. If the name already exists, the provisioning will replace the previous certificate with the one from `certificate_id`. Only valid for AKV and GCM keystores.
        :param pulumi.Input[_builtins.str] cloud_keystore_id: ID of the cloud keystore where the certificate will be provisioned.
        :param pulumi.Input[_builtins.str] gcm_cert_scope: The GCM certificate scope of the certificate. Only valid for GCM keystores. Supported values from GCM API documentation: DEFAULT, EDGE_CACHE, ALL_REGIONS.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudKeystoreInstallationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provisions a certificate from Venafi Control Plane's inventory to any of the supported Cloud Providers: Amazon
        Certificate Manager, Azure KeyVault or Google Certificate Manager. Exports the ID of the provisioned certificate:
        certificate name for AKV and GCM or ARN for ACM.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_venafi as venafi

        # Provision a certificate to cloud keystore with static values
        ck_installation_example_by_id = venafi.CloudKeystoreInstallation("ck_installation_example_by_id",
            cloud_keystore_id="e48897d0-2762-11ef-198k-79ac590dd358",
            certificate_id="1877af16-2762-11ef-8fab-cc123456ff7",
            cloud_certificate_name="com-terraform-example-com")
        # Provision a certificate to cloud keystore
        ck_installation_example = venafi.CloudKeystoreInstallation("ck_installation_example",
            cloud_keystore_id=ck_example["id"],
            certificate_id=certificate_example["certificateId"],
            cloud_certificate_name=certificate_example["commonName"])
        ```

        ## Import

        Using `pulumi import`, import a Machine Identity from Venafi Control Plane using their ID. For example:

        console

        ```sh
        $ pulumi import venafi:index/cloudKeystoreInstallation:CloudKeystoreInstallation example 2155bd32-2234-22ac-7cfd-ff1198845aa2
        ```

        :param str resource_name: The name of the resource.
        :param CloudKeystoreInstallationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudKeystoreInstallationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_keystore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 gcm_cert_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudKeystoreInstallationArgs.__new__(CloudKeystoreInstallationArgs)

            __props__.__dict__["arn"] = arn
            if certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_id'")
            __props__.__dict__["certificate_id"] = certificate_id
            __props__.__dict__["cloud_certificate_name"] = cloud_certificate_name
            if cloud_keystore_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_keystore_id'")
            __props__.__dict__["cloud_keystore_id"] = cloud_keystore_id
            __props__.__dict__["gcm_cert_scope"] = gcm_cert_scope
            __props__.__dict__["cloud_certificate_id"] = None
            __props__.__dict__["cloud_certificate_metadata"] = None
        super(CloudKeystoreInstallation, __self__).__init__(
            'venafi:index/cloudKeystoreInstallation:CloudKeystoreInstallation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_certificate_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            cloud_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_keystore_id: Optional[pulumi.Input[_builtins.str]] = None,
            gcm_cert_scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudKeystoreInstallation':
        """
        Get an existing CloudKeystoreInstallation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the AWS certificate. Use it to provision the VCP certificate to an existing ACM certificate, instead of a new one. Only valid for ACM keystores.
        :param pulumi.Input[_builtins.str] certificate_id: ID of the certificate to be provisioned to the given `keystore_id`.
        :param pulumi.Input[_builtins.str] cloud_certificate_id: The ID of the provisioned certificate within the Cloud Keystore
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] cloud_certificate_metadata: Metadata of the provisioned certificate from the Cloud Keystore
        :param pulumi.Input[_builtins.str] cloud_certificate_name: Name for the provisioned certificate in the keystore. If the name already exists, the provisioning will replace the previous certificate with the one from `certificate_id`. Only valid for AKV and GCM keystores.
        :param pulumi.Input[_builtins.str] cloud_keystore_id: ID of the cloud keystore where the certificate will be provisioned.
        :param pulumi.Input[_builtins.str] gcm_cert_scope: The GCM certificate scope of the certificate. Only valid for GCM keystores. Supported values from GCM API documentation: DEFAULT, EDGE_CACHE, ALL_REGIONS.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudKeystoreInstallationState.__new__(_CloudKeystoreInstallationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["cloud_certificate_id"] = cloud_certificate_id
        __props__.__dict__["cloud_certificate_metadata"] = cloud_certificate_metadata
        __props__.__dict__["cloud_certificate_name"] = cloud_certificate_name
        __props__.__dict__["cloud_keystore_id"] = cloud_keystore_id
        __props__.__dict__["gcm_cert_scope"] = gcm_cert_scope
        return CloudKeystoreInstallation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the AWS certificate. Use it to provision the VCP certificate to an existing ACM certificate, instead of a new one. Only valid for ACM keystores.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the certificate to be provisioned to the given `keystore_id`.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="cloudCertificateId")
    def cloud_certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the provisioned certificate within the Cloud Keystore
        """
        return pulumi.get(self, "cloud_certificate_id")

    @_builtins.property
    @pulumi.getter(name="cloudCertificateMetadata")
    def cloud_certificate_metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Metadata of the provisioned certificate from the Cloud Keystore
        """
        return pulumi.get(self, "cloud_certificate_metadata")

    @_builtins.property
    @pulumi.getter(name="cloudCertificateName")
    def cloud_certificate_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name for the provisioned certificate in the keystore. If the name already exists, the provisioning will replace the previous certificate with the one from `certificate_id`. Only valid for AKV and GCM keystores.
        """
        return pulumi.get(self, "cloud_certificate_name")

    @_builtins.property
    @pulumi.getter(name="cloudKeystoreId")
    def cloud_keystore_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the cloud keystore where the certificate will be provisioned.
        """
        return pulumi.get(self, "cloud_keystore_id")

    @_builtins.property
    @pulumi.getter(name="gcmCertScope")
    def gcm_cert_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The GCM certificate scope of the certificate. Only valid for GCM keystores. Supported values from GCM API documentation: DEFAULT, EDGE_CACHE, ALL_REGIONS.
        """
        return pulumi.get(self, "gcm_cert_scope")

