#!/usr/bin/env python3
"""Common filtering code to be used by various submodules"""

# Do not hand edit!
#
# This list is generated programmatically from CLDR data:
# See opuscleaner/scripts/build_chars.py

CHARS = {
    # Afar
    'aa': r'[a-ik-oq-uw-y]',
    # Abkhazian
    'ab': r'[а-ик-шы-ьџқҟҩҭҳҵҷҽҿәӡӷԥ]',
    # Afrikaans
    'af': r'[a-zá-âè-ëî-ïôöû]',
    # Aghem
    'agq': r'[a-ik-ps-wy-zàâèêìîòôùûāēěīŋōūǎǐǒǔɔɛɨʉʔ\u0300\u0302\u0304\u030C]',
    # Akan
    'ak': r'[a-bd-ik-pr-uwyɔɛ]',
    # Amharic
    'am': r'[ሀ-ሆለ-ቆቈቊ-ቍበ-ኆኈኊ-ኍነ-ኮኰኲ-ኵኸ-ኾወ-ዎዐ-ዖዘ-ዮደ-ዷጀ-ጎጐጒ-ጕጠ-ፆፈ-ፗ]',
    # Aragonese
    'an': r'[a-záéíóúü]',
    # ann
    'ann': r'[a-pr-wy-zàâèêìîòôùûǹ\u0300\u0304ọộ]',
    # apc
    'apc': r'[ء-غف-\u0652\u0670]',
    # Arabic
    'ar': r'[ء-غف-\u0652\u0670]',
    # Mapuche
    'arn': r'[ac-ik-pr-uwyñüḻṉṯ]',
    # Assamese
    'as': r'[\u0981-\u0983অ-ঋএ-ঐও-নপ-যলশ-হ\u09BC\u09BE-\u09C3\u09C7-\u09C8\u09CB-\u09CDৰ-ৱ]',
    # Asu
    'asa': r'[a-pr-wy-z]',
    # Asturian
    'ast': r'[a-il-vx-záéíñóúüḥḷ]',
    # Azerbaijani
    'az': r'[a-vx-zçöüğİ-ışə]',
    # Azerbaijani (Arabic)
    'az_Arab': r'[آؤا-بت-غؽف-قل-وپچژکگۆ-ۇی]',
    # Azerbaijani (Cyrillic)
    'az_Cyrl': r'[а-хч-шыјғҝүҹһәө]',
    # Bashkir
    'ba': r'[а-яёғҙҡңҫүһәө]',
    # Baluchi
    'bal': r'[آئ-بتجدر-شل-و\u064E-\u0652ٹپچڈڑژکگۆیێے]',
    # Baluchi (Latin)
    'bal_Latn': r'[a-pr-uwy-záéó]',
    # Basaa
    'bas': r'[a-pr-wy-zà-âè-êì-îò-ôù-ûāēěīńŋōūǎǐǒǔǹɓ-ɔɛ\u0300-\u0302\u0304\u030C\u1DC6-\u1DC7]',
    # Belarusian
    'be': r'[а-зй-шы-яёіў]',
    # Belarusian (Taraskievica orthography)
    'be_TARASK': r'[а-зй-шы-яёіўґ]',
    # Bemba
    'bem': r'[a-ce-ps-uwy]',
    # Betawi
    'bew': r'[a-zè-éĕ]',
    # Bena
    'bez': r'[a-wy-z]',
    # Bulgarian
    'bg': r'[а-ъью-я]',
    # bgc
    'bgc': r'[\u0901\u0903अ-ऋए-ऐओ-नप-रलव-ह\u093E-\u0943\u0945\u0947-\u0948\u094B-\u094D]',
    # Western Balochi
    'bgn': r'[آئ-بت-در-ظغف-قل-نوٹپچڈڑژکگھۆیێ]',
    # Bhojpuri
    'bho': r'[\u0901-\u0903क-घच-नप-रलव-ह\u093C\u093E-\u0943\u0945\u0947-\u0948\u094B-\u094D]',
    # blo
    'blo': r'[a-ce-pr-uwyà-âè-êì-îò-ôù-ûńŋǝǹɔɖɛɩʊ\u0300-\u0302ḿ]',
    # blt
    'blt': r'[ꪀ-ꪁꪄ-ꪋꪎ-ꪝꪠ-ꫂꫛ-ꫝ]',
    # Bambara
    'bm': r'[a-pr-uwy-zŋɔɛɲ]',
    # Bambara (N’Ko)
    'bm_Nkoo': r'[ߊ-ߐߒ-ߟߡ-ߦ]',
    # Bangla
    'bn': r'[\u0981-\u0983অ-ঌএ-ঐও-নপ-রলশ-হ\u09BC-\u09C4\u09C7-\u09C8\u09CB-ৎ\u09D7ৠ-\u09E3৺]',
    # Tibetan
    'bo': r'[ཀ-གང-ཇཉ-ཌཎ-དན-བམ-ཛཝ-ཨཪ\u0F71-\u0F72\u0F74\u0F77\u0F79-\u0F80\u0F84\u0F90-\u0F92\u0F94-\u0F97\u0F99-\u0F9C\u0F9E-\u0FA1\u0FA3-\u0FA6\u0FA8-\u0FAB\u0FAD-\u0FB8\u0FBA-\u0FBC]',
    # Bakhtiari
    'bqi': r'[ء-ؤئ-غف-قل-و\u064B-\u064D\u0651\u0654پچژکگی]',
    # Breton
    'br': r'[a-pr-zêñùʼ]',
    # Bodo
    'brx': r'[\u0901-\u0902अ-ऊऍए-ऑओ-घच-नप-रल-ळव-ह\u093C\u093E-\u0943\u0945\u0947-\u0949\u094B-\u094D]',
    # Bosnian
    'bs': r'[a-pr-vzćčđšž]',
    # Bosnian (Cyrillic)
    'bs_Cyrl': r'[а-ик-шђј-ћџ]',
    # Akoose
    'bss': r'[a-eg-ps-uwy-zá-âé-êí-îó-ôú-ûāēěīńŋōūǎǐǒǔɔəɛʼ\u0301-\u0302\u0304\u030Cḿ]',
    # Buriat
    'bua': r'[а-яёүһө]',
    # Blin
    'byn': r'[ሀ-ሆለ-ሟረ-ቆቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኆኈኊ-ኍነ-ኮኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዎዐ-ዖዘ-ዮደ-ዷጀ-ጎጐጒ-ጕጘ-ጯጸ-ጿፈ-ፗ\u135Fⶓ-ⶖ]',
    # Catalan
    'ca': r'[a-z·àç-éíïò-óúü]',
    # Caddo
    'cad': r'[a-eh-ikm-ps-uwyà-áè-éì-íò-óù-úʼˀː]',
    # Atsam
    'cch': r'[a-pr-wy-zʼ\u0331ḵṉ]',
    # Chakma
    'ccp': r'[\U00011100-\U00011134]',
    # Chechen
    'ce': r'[а-яёӏ]',
    # Cebuano
    'ceb': r'[a-bd-eg-ik-pr-uwy]',
    # Chiga
    'cgg': r'[a-z]',
    # Choctaw
    'cho': r'[a-ce-fh-ik-ps-wyʋ\u0331]',
    # Cherokee
    'chr': r'[ᏸ-ᏼꭰ-ꮿ]',
    # Chickasaw
    'cic': r'[a-cf-ik-ps-twyʼ\u0331]',
    # Central Kurdish
    'ckb': r'[ئ-بتج-در-شع-غف-قل-وپچڕژڤکگڵۆیێە]',
    # Corsican
    'co': r'[a-jl-vzàèìïòùü]',
    # Coptic
    'cop': r'[ϣϥϧϩϫϭϯⲁⲃⲅⲇⲉⲋⲍⲏⲑⲓⲕⲗⲙⲛⲝⲟⲡⲣⲥⲧⲩⲫⲭⲯⲱ]',
    # Czech
    'cs': r'[a-záéíóúýčďěňřšťůž]',
    # csw
    'csw': r'[ᐁᐃ-ᐆᐊ-ᐋᐍᐏᐑᐓᐕᐘᐚᐟ-ᐠᐢ-ᐤᐦᐨᐯᐱ-ᐴᐸ-ᐹᑊᑌᑎ-ᑑᑕ-ᑖᑫᑭ-ᑰᑲ-ᑳᒉᒋ-ᒎᒐ-ᒑᒣᒥ-ᒨᒪ-ᒫᒼᓀᓂ-ᓅᓇ-ᓈᓓᓕ-ᓘᓚ-ᓛᓫᓭᓯ-ᓲᓴ-ᓵᔦᔨ-ᔫᔭ-ᔮᕀᕃᕆ-ᕉᕋ-ᕌᕑᕽ]',
    # Church Slavic
    'cu': r'[а-ьює-їѡѣѧѫѯѱѳѵѷѻѽѿ҂-\u0483\u0487\u2DE0-\u2DEA\u2DEC-\u2DED\u2DEF\u2DF1\u2DF4ⸯꙁꙋꙍꙗ\uA67Dꙿ]',
    # Chuvash
    'cv': r'[а-яёҫӑӗӳ]',
    # Welsh
    'cy': r'[a-jl-pr-uwyà-âäè-ïò-ôöù-ýÿŵŷẁẃẅỳ]',
    # Danish
    'da': r'[a-zå-æø]',
    # Taita
    'dav': r'[a-pr-wy-z]',
    # German
    'de': r'[a-zßäöü]',
    # German (Switzerland)
    'de_CH': r'[a-zäöü]',
    # Zarma
    'dje': r'[a-uw-zãõŋšžɲẽ]',
    # Dogri
    'doi': r'[\u0901-\u0903अ-ऌए-ऐओ-नप-रल-ळव-ह\u093C-\u0944\u0947-\u0948\u094B-\u094Dॐ-\u0952ॠ-\u0963]',
    # Lower Sorbian
    'dsb': r'[a-zóćčěłńŕśšźž]',
    # Duala
    'dua': r'[a-gi-pr-uwyáéíóúŋūɓ-ɔɗɛ\u0301]',
    # Divehi
    'dv': r'[ހ-ޗ\u07A6-\u07B0]',
    # Jola-Fonyi
    'dyo': r'[a-yáéíñóúŋ]',
    # Dzongkha
    'dz': r'[ཀ-གང-ཇཉཏ-དན-བམ-ཛཝ-ཤས-ཨ\u0F72\u0F74\u0F7A\u0F7C\u0F90-\u0F92\u0F94\u0F97\u0F99\u0F9F-\u0FA1\u0FA3-\u0FA6\u0FA8-\u0FAB\u0FAD\u0FB1-\u0FB3\u0FB5-\u0FB7]',
    # Embu
    'ebu': r'[a-zĩũ]',
    # Ewe
    'ee': r'[a-bd-ik-pr-zà-áãè-éì-íò-óõù-úĩŋũƒɔɖɛɣʋ\u0300-\u0301\u0303ẽ]',
    # Greek
    'el': r'[ΐά-ώ]',
    # Greek (Polytonic)
    'el_POLYTON': r'[ΐά-ώἀ-ἇἐ-ἕἠ-ἧἰ-ἷὂ-ὄὐ-ὗὢ-ὧὰὲὴὶὸὺὼᾶῆῒῖ-ῗῢῦ-ῧῶ]',
    # English
    'en': r'[a-z]',
    # English (Deseret)
    'en_Dsrt': r'[𐐨-𐑏]',
    # English (Shavian)
    'en_Shaw': r'[𐑐-𐑿]',
    # Esperanto
    'eo': r'[a-pr-vzĉĝĥĵŝŭ]',
    # Spanish
    'es': r'[a-záéíñóúü]',
    # Estonian
    'et': r'[a-zäõ-öüšž]',
    # Basque
    'eu': r'[a-zçñ]',
    # Ewondo
    'ewo': r'[a-bd-ik-pr-wy-zà-âè-êì-îò-ôù-ûěńŋǎǐǒǔǹɔəɛ\u0300-\u0302\u030C]',
    # Persian
    'fa': r'[ء-ؤئ-غف-قل-و\u064B-\u064D\u0651\u0654پچژکگی]',
    # Fulah
    'ff': r'[a-pr-uwyñŋƴɓɗ]',
    # Fulah (Adlam)
    'ff_Adlm': r'[𞤢-𞤽\U0001E944-\U0001E946𞥋]',
    # Finnish
    'fi': r'[a-zä-åöšž]',
    # Filipino
    'fil': r'[a-zñ]',
    # Faroese
    'fo': r'[a-bd-pr-vyáæíðóøúý]',
    # French
    'fr': r'[a-zàâæ-ëî-ïôùû-üÿœ]',
    # Northern Frisian
    'frr': r'[a-pr-uwä-åöüāđē]',
    # Friulian
    'fur': r'[a-zàâç-èêìîòôùû]',
    # Western Frisian
    'fy': r'[a-pr-wy-zà-âäè-ëíïó-ôöú-ý\u0301]',
    # Irish
    'ga': r'[a-il-pr-uáéíóú]',
    # Ga
    'gaa': r'[a-bd-pr-wy-zŋɔɛ]',
    # Scottish Gaelic
    'gd': r'[a-il-pr-uàèìòù]',
    # Geez
    'gez': r'[ሀ-ሆለ-ሎሐ-ሖመ-ሞሠ-ሦረ-ሮሰ-ሶቀ-ቆቈቊ-ቍበ-ቦተ-ቶኀ-ኆኈኊ-ኍነ-ኖአ-ኦከ-ኮኰኲ-ኵወ-ዎዐ-ዖዘ-ዞየ-ዮደ-ዶገ-ጎጐጒ-ጕጠ-ጦጰ-ጶጸ-ጾፀ-ፆፈ-ፎፐ-ፖ\u135F᎐-᎙]',
    # Galician
    'gl': r'[a-záéíïñóúü]',
    # Guarani
    'gn': r'[a-eg-pr-vyãñõĩũʼ\u0303ẽỹ]',
    # Swiss German
    'gsw': r'[a-zäöü]',
    # Gujarati
    'gu': r'[\u0A81-\u0A83અ-ઋઍએ-ઑઓ-નપ-રલ-ળવ-હ\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACDૐૠ]',
    # Gusii
    'guz': r'[a-pr-wy-z]',
    # Manx
    'gv': r'[a-zç]',
    # Hausa
    'ha': r'[a-or-uwy-zƙƴɓɗʼ]',
    # Hausa (Arabic)
    'ha_Arab': r'[ا-بت-غفك-نڢ]',
    # Hausa (Niger)
    'ha_NE': r'[a-or-uwy-zƙƴɓɗʼ]',
    # Hawaiian
    'haw': r'[aeh-ik-puwāēīōūʻ]',
    # Hebrew
    'he': r'[א-ת]',
    # Hindi
    'hi': r'[\u0901-\u0903अ-ऍए-ऑओ-नप-रल-ळव-ह\u093C-\u0943\u0945\u0947-\u0949\u094B-\u094Dॐ]',
    # hnj
    'hnj': r'[𞄀-𞄬\U0001E130-\U0001E136𞄼-𞄽𞅎-𞅏]',
    # Croatian
    'hr': r'[a-pr-vzćčđšž]',
    # Upper Sorbian
    'hsb': r'[a-zóćčěłńřšźž]',
    # Haitian Creole
    'ht': r'[a-pr-wy-zèò]',
    # Hungarian
    'hu': r'[a-pr-vy-záéíóöúüőű]',
    # Armenian
    'hy': r'[ա-ֆ]',
    # Interlingua
    'ia': r'[a-z]',
    # Indonesian
    'id': r'[a-z]',
    # Interlingue
    'ie': r'[a-záéíóú]',
    # Igbo
    'ig': r'[a-pr-wy-zṅịọụ]',
    # Sichuan Yi
    'ii': r'[ꀀ-ꒌ]',
    # Ido
    'io': r'[a-z]',
    # Icelandic
    'is': r'[a-bd-pr-vx-yáæéíðóöúý-þ]',
    # Italian
    'it': r'[a-zàè-éìòù]',
    # Inuktitut
    'iu': r'[ᐃ-ᐆᐊ-ᐋᐱ-ᐴᐸ-ᐹᑉᑎ-ᑑᑕ-ᑖᑦᑭ-ᑰᑲ-ᑳᒃᒋ-ᒎᒐ-ᒑᒡᒥ-ᒨᒪ-ᒫᒻᓂ-ᓅᓇ-ᓈᓐᓕ-ᓘᓚ-ᓛᓪᓯ-ᓲᓴ-ᓵᔅᔨ-ᔫᔭ-ᔮᔾᕆ-ᕉᕋ-ᕌᕐᕕ-ᕚᕝᕿ-ᖃᖅᖏᖑ-ᖖᖠ-ᖦᙱ-ᙶ]',
    # Inuktitut (Latin)
    'iu_Latn': r'[agi-np-vł]',
    # Japanese
    'ja': r'[々ぁ-んゝ-ゞァ-ヶー-ヾ一-丁七万-下不-与且世丘-丙両並中串丸-丹主-丼久乏乗乙九-乞乱乳乾亀了予-争事-二互五-井亜亡交享-亭人仁今-介仏仕-他付-仙代-以仮仰仲件任企伎-休会伝伯伴伸伺似但位-佐体何余作佳併使例侍供依価侮-侯侵-侶便係-促俊俗保信修俳俵俸俺倉個倍倒候借倣-値倫倹偉偏停健側-偶偽傍傑傘-備催傲債傷傾僅働像僕僚僧儀億儒償優元-兆先-光克免児党入全八-六共兵具-典兼内-円冊再冒冗写冠冥冬冶-冷凄准凍凝凡処凶凸-出刀刃分-刈刊刑列初判-別利到制-刻則削前剖剛剣-剥副-剰割創劇力功-加劣助-努励労効劾勃勅勇勉動勘-務勝募勢勤勧勲勾匂包化-北匠匹-医匿十千升-午半卑-協南-単博占印-危即-卵卸厄厘厚原厳去参又及-収叔取-受叙口-句叫-召可-右号-司各合-吉同-向君吟否含吸-吹呂呈-告周呪味呼-命和咲咽哀-品員哲哺唄唆-唇唐唯唱唾商問啓善喉喚喜-喝喩-喫営嗅嗣嘆嘱-嘲器噴嚇囚-四回因団困囲-図固国圏園土圧-在地坂均坊坑坪垂型垣埋城域執培-基埼堀堂堅-堆堕堤堪報場塀-塁塊塑塔塗塚塞塩填塾境墓増墜墨墳墾壁壇壊壌士壮声-売変夏夕-外多夜夢大天-夫央失奇-奉奏契奔奥奨奪奮女-奴好如-妄妊妖妙妥妨妬妹妻姉始姓-委姫姻姿威娘娠娯婆婚婦婿媒媛嫁嫉嫌嫡嬢子孔字-存孝季-孤学孫宅宇-安完宗-宝実客-室宮宰害-家容宿寂寄密富寒寛寝察寡寧審寮寸寺対-寿封-専射将尉-尋導-小少尚就尺-局居屈届-屋展属層-履屯山岐岡岩岬岳岸峠-峡峰島崇崎崖崩嵐川-州巡巣工-巨差己巻巾市-布帆希帝帥師席帯-帰帳常帽幅幕幣干-年幸-幹幻-幾庁広床序底店府度-座庫庭庶-庸廃廉-廊延-廷建弁弄弊式-弐弓-引弟弥-弧弱張強弾当彙形彩彫彰-影役彼往-征径-待律-後徐徒-従得御復-循微徳-徴徹心必忌-忍志-忙応忠快念怒怖思怠急性-怨怪恋恐恒恣恥恨-恩恭息恵悔悟-悠患悦悩-悪悲悼情惑惜惧-惨惰想愁愉意愚-愛感慄慈態-慌慎慕慢-慣慨慮慰慶憂憎憤憧憩憬憲憶憾懇懐懲懸成-戒戚戦戯戴戸戻房-所扇扉手才打払扱扶批承-技抄把抑投抗-折抜択披抱抵抹押-抽担拉拍拐拒-拓拘-拙招拝拠-拡括-拭拳拶-拷拾持指挑挙挟挨挫振挿捉捕捗捜捨据捻掃授掌排掘掛採-探接控-推措掲描-提揚-換握揮援揺損搬-搭携搾摂摘摩摯撃撤撮撲擁操擦擬支改攻放-政故敏救敗教敢-散敬数整-敵敷文斉斎斑斗料斜斤-斥斬-断新方施旅旋族旗既日-早旬旺昆-昇明易-昔星-映春昧-昨昭是昼時晩普-景晴晶暁暇暑暖-暗暦暫暮暴曇曖曜曲更書-曹曽替-最月-有服朕朗望朝期木未-札朱朴机朽杉材-村束条来杯東松-板析枕林枚果-枝枠枢枯架柄某染-柔柱柳柵査柿栃-栄栓校株核-根格-栽桁桃案桑桜桟梅梗梨械棄棋棒棚棟森棺椅植-椎検業極楷楼-楽概構様槽標模権-横樹橋機欄欠-次欧欲欺款歌歓止-正武歩歯歳-歴死殉-残殖殴-段殺-殻殿-毀母-毎毒比毛氏民気水氷-永氾汁-求汎汗汚江-池汰決汽沃沈沖沙没-沢河沸-油治-沼沿況泉-泊泌法泡-泣泥注泰泳洋洗洞津洪活派流浄-浅浜浦浪浮浴海-浸消涙涯液涼淑淡淫深混添清渇-渉渋渓減渡渦温測港湖湧湯湾-満源準溝溶溺滅滋滑滝-滞滴漁-漂漆漏演漠漢漫-漬漸潔潜潟潤潮潰澄激-濁濃濫濯瀬火灯-灰災炉-炊炎炭点-為烈無焦然焼煎煙照煩煮熊熟熱燃燥爆爪爵-父爽片-版牙牛牧物牲特犠犬犯状狂狙狩独-狭猛猟猫献猶猿獄獣獲玄率玉王玩珍珠班現球理琴瑠璃璧環璽瓦瓶甘甚生産用田-申男町-画界畏畑畔留畜-畝略番異畳畿疎疑疫疲疾病症痕痘痛痢痩痴瘍療癒癖発-登白-百的皆-皇皮皿盆益盗盛盟監-盤目盲直相盾省眉看-県真-眠眺眼着睡督睦瞬-瞭瞳矛矢知短矯石砂研-砕砲破硝硫-硬碁碑確磁磨礁礎示礼社祈-祉祖祝-神祥票祭禁禅禍福秀-私秋科-秒秘租秩称移程税稚種稲稼-稽稿-穀穂積穏穫穴究空突窃窒-窓窟窮-窯立竜章童端競竹笑笛符第筆等筋筒答策箇箋算管箱箸節範築篤簡簿籍籠米粉粋粒粗-粘粛粧精糖糧糸系糾紀約-紅紋納純紙-紛素-索紫累-細紳紹-紺終組経結絞絡給統絵-絶絹継-続維綱-網綻綿緊総緑-緒線締編-緩緯練緻縁縄縛縦縫縮績繁繊織-繕繭繰缶罪置罰署罵罷羅羊美羞群羨-義羽翁翌習翻-翼老考者耐耕耗耳聖聞聴職肉肌肖肘肝股-肢肥肩-肪肯育肺胃胆背胎胞胴胸能脂脅脇-脈脊脚脱脳腎腐腕腫腰腸-腺膚膜-膝膨膳臆臓臣臨自臭至-致臼興舌舎舗舞-舟航般舶-舷船艇艦良色艶芋芝芯花芳芸芽苗苛若-苦英茂茎茨茶草荒荘荷菊菌菓菜華萎落葉著葛葬蒸蓄蓋蔑蔵蔽薄薦薪-薬藍藤藩藻虎虐虚虜虞虫虹蚊蚕蛇蛍蛮蜂蜜融血衆行術街衛衝衡衣表衰衷袋袖被裁-裂装裏裕補裸製-裾複褐褒襟襲西要覆-覇見規視覚覧親観角解触言訂-訃計討訓託-記訟訪設許訳-訴診証詐詔-評詞詠詣試詩詮詰-詳誇誉誌-認誓誕誘語誠誤説-読誰課調談請論諦-諧諭-諮諸諾謀-謁謄謎謙講謝謡謹識譜警議譲護谷豆豊豚象豪貌貝-貞負-貢貧-責貯貴買-貸費-貼貿-賀賂-賄資賊賓賛-賜賞賠賢賦質賭購贈赤赦走赴起超越趣足距跡路跳践踊踏踪蹴躍身車軌-軍軒軟転軸軽較載輝輩-輪輸轄辛辞辣辱-農辺込迅迎近返迫迭述迷追退-送逃逆透-逐逓-途通逝速-造連逮週-進逸遂遅遇遊-運遍-過道-違遜遠-遡遣適遭-遮遵遷-選遺避還那邦邪邸郊郎郡部郭郵郷都酌-酎酒酔酢酪酬酵酷-酸醒醜醸采-釈里-量金釜-針釣鈍鈴鉄鉛鉢鉱銀銃銅銘銭鋭鋳鋼錠錦錬錮-錯録鍋鍛鍵鎌鎖鎮鏡鐘鑑長門閉開閑間関-閣閥閲闇闘阜阪防阻附降限陛院-陥陪陰陳陵-陶陸険陽隅-隆隊階-随隔隙際-障隠隣隷隻雄-雇雌雑離-難雨雪雰雲零-雷電需震霊霜霧露青静非面革靴韓音韻響頂-頃項-順須預-頓領頬-頭頻-頼題-顎顔-顕願類顧風飛食飢飯飲飼-飾餅養餌餓館首香馬駄-駆駐駒騎騒-験騰驚骨骸髄高髪鬱鬼魂魅魔魚鮮鯨鳥鳴鶏鶴鹿麓麗麦麺-麻黄黒黙鼓鼻齢]',
    # Lojban
    'jbo': r'[a-pr-vx-z]',
    # Ngomba
    'jgo': r'[a-df-nps-wy-zá-âí-îú-ûńŋǎǐǔǹɔɛʉ\u0300-\u0302\u0304\u0308\u030Cḿẅꞌ]',
    # Machame
    'jmc': r'[a-pr-wy-z]',
    # Javanese
    'jv': r'[a-eg-pr-uwyâåè-êìòù]',
    # Georgian
    'ka': r'[ა-ჰ]',
    # Kara-Kalpak
    'kaa': r'[а-яёўғқңүҳәө]',
    # Kara-Kalpak (Latin)
    'kaa_Latn': r'[a-záóúıńǵ]',
    # Kabyle
    'kab': r'[a-np-uw-zčǧɛɣḍḥṛṣṭẓ]',
    # Jju
    'kaj': r'[a-z]',
    # Kamba
    'kam': r'[a-wy-zĩũ]',
    # Tyap
    'kcg': r'[a-pr-wy-z\u0331]',
    # Makonde
    'kde': r'[a-z]',
    # Kabuverdianu
    'kea': r'[a-bd-pr-vx-zñ]',
    # kek
    'kek': r'[a-ceh-uw-zʼ’]',
    # Kenyang
    'ken': r'[a-km-pr-uwyà-áè-éò-óù-úěŋǎǒǔɔɛɨʉ\u0300-\u0301\u030C]',
    # Kaingang
    'kgp': r'[ae-km-pr-vyáãéóĩũẽỹ]',
    # Koyra Chiini
    'khq': r'[a-uw-zãõŋšžɲẽ]',
    # Kikuyu
    'ki': r'[a-eg-km-ort-uwyĩũ]',
    # Kazakh
    'kk': r'[а-яёіғқңүұһәө]',
    # Kazakh (Arabic)
    'kk_Arab': r'[ءا-بتج-حدر-شعف-نو-يپچڭگھۆ-ۇۋە]',
    # Kako
    'kkj': r'[a-pr-wyà-âè-êì-îò-ôù-ûŋɓ-ɔɗɛ\u0300-\u0302\u0327]',
    # Kalaallisut
    'kl': r'[a-zå-æø]',
    # Kalenjin
    'kln': r'[a-eg-pr-uwy]',
    # Khmer
    'km': r'[ក-វស-អឥ-ឧឩ-ឳ\u17B6-\u17CB\u17CD\u17D0\u17D2]',
    # Kannada
    'kn': r'[\u0C82-\u0C83ಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹ\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5-\u0CD6ೠ-ೡ]',
    # Korean
    'ko': r'[가-힣]',
    # Konkani
    'kok': r'[\u0901-\u0903अ-ऍए-ऑओ-नप-रल-ळव-ह\u093C-\u0943\u0945\u0947-\u0949\u094B-\u094Dॐ०-९]',
    # Konkani (Latin)
    'kok_Latn': r'[a-zãçêñô-õĩẽ]',
    # Kpelle
    'kpe': r'[a-bd-pt-wy-zĝŋɓ-ɔəɛɣɲ]',
    # Kashmiri
    'ks': r'[ؠ-ؤا-بت-غف-قل-نوٲٹپچڈڑژکگںھہۄۆیے]',
    # Kashmiri (Devanagari)
    'ks_Deva': r'[\u0901-\u0902अ-ऊएऑओक-गच-जट-डत-दनप-बम-रलव-शस-ह\u093C\u093E-\u0945\u0947-\u0949\u094B-\u094D]',
    # Shambala
    'ksb': r'[a-ps-wy-z]',
    # Bafia
    'ksf': r'[a-pr-wy-záéíóúŋǝɔɛ\u0301]',
    # Colognian
    'ksh': r'[a-zßä-æëöüėœů]',
    # Kurdish
    'ku': r'[a-zçêîûş]',
    # Kurdish (Arabic)
    'ku_Arab': r'[ئ-بتج-در-شع-غف-قل-وپچڕژڤکگڵۆیێە]',
    # Cornish
    'kw': r'[a-z]',
    # kxv
    'kxv': r'[a-eg-pr-vyñāēīōūḍḷṅṇṛṭ]',
    # kxv (Devanagari)
    'kxv_Deva': r'[\u0901-\u0903अ-ऊएओकगङ-चजञ-टडण-तदनपबम-रल-ळवस-ह\u093C-\u0942\u0947\u094B\u094D]',
    # kxv (Odia)
    'kxv_Orya': r'[:\\\u0B01-\u0B03ଅ-ଊଏକଗଙ-ଚଜଞ-ଟଡଣ-ତଦନପବମରଲ-ଳସ-ହ\u0B3C\u0B3E-\u0B42\u0B47\u0B4Dୟୱ]',
    # kxv (Telugu)
    'kxv_Telu': r'[\u0C01-\u0C03అ-ఊఎ-ఏఒ-ఓకగచజఞ-టడణ-తదనపబమ-రలవస-హ఼\u0C3E-\u0C42\u0C46-\u0C47\u0C4A-\u0C4B\u0C4D]',
    # Kyrgyz
    'ky': r'[а-бг-ухч-шъ-ыэ-яёңүө]',
    # Latin
    'la': r'[a-z]',
    # Langi
    'lag': r'[a-záéíóúɨʉ]',
    # Luxembourgish
    'lb': r'[a-zäéë]',
    # Ganda
    'lg': r'[a-gi-pr-wy-zŋ]',
    # Ligurian
    'lij': r'[a-zàâäæ-ìî-ïñ-ôöùû-ü]',
    # Lakota
    'lkt': r'[a-beg-ik-ps-uwy-záéíóúčŋšžǧȟʼ]',
    # lld
    'lld': r'[a-zà-âè-ëí-îó-ôöúüć]',
    # Lombard
    'lmo': r'[a-z]',
    # Lingala
    'ln': r'[a-ik-pr-wy-zá-âé-êí-îó-ôúěǎǐǒɔɛ\u0301-\u0302\u030C]',
    # Lao
    'lo': r'[ກ-ຂຄງ-ຈຊຍດ-ທນ-ຟມ-ຣລວສ-ຫອ-\u0EB9\u0EBB-ຽເ-ໄໆ\u0EC8-\u0ECDໜ-ໝ]',
    # Northern Luri
    'lrc': r'[آ-ؤئ-بت-غؽف-قل-نو\u0659\u065Bپچژڤکگھۉ-ۊیە]',
    # Lithuanian
    'lt': r'[a-pr-vy-ząčėęįšūųž]',
    # Latgalian
    'ltg': r'[a-pr-vy-zāčēģīķļņōšūž]',
    # Luba-Katanga
    'lu': r'[a-qs-wy-zà-áè-éì-íò-óù-úɔɛ\u0300-\u0301]',
    # Luo
    'luo': r'[a-pr-wy]',
    # Luyia
    'luy': r'[a-z]',
    # Latvian
    'lv': r'[a-pr-vzāčēģīķļņšūž]',
    # Laz
    'lzz': r'[a-vx-zçğİşǩ\u0306\u030C]',
    # Maithili
    'mai': r'[\u0902-\u0903क-घच-नप-रलव-ह\u093C\u093E-\u0942\u0947-\u0948\u094B-\u094D]',
    # Masai
    'mas': r'[a-eg-pr-uwyà-âè-êì-îò-ôù-ûāēīŋōūɔɛɨʉ\u0301]',
    # Moksha
    'mdf': r'[а-яё]',
    # Meru
    'mer': r'[a-zĩũ]',
    # Morisyen
    'mfe': r'[a-pr-z]',
    # Malagasy
    'mg': r'[a-bd-pr-tvy-zàâè-ìî-ïñô]',
    # Makhuwa-Meetto
    'mgh': r'[a-pr-wy-z]',
    # Metaʼ
    'mgo': r'[a-km-pr-uwy-zàèìòùŋɔəʼ\u0300]',
    # mhn
    'mhn': r'[a-zà-áè-éë-íò-óù-ú]',
    # Māori
    'mi': r'[aeg-ikm-prt-uwāēīōū]',
    # Mi'kmaq
    'mic': r'[aei-qs-uwyáéóúɨʼ]',
    # Macedonian
    'mk': r'[а-ик-шѓѕј-њќџ]',
    # Malayalam
    'ml': r'[\u0D02-\u0D03അ-ഋഎ-ഐഒ-നപ-ഹ]',
    # Mongolian
    'mn': r'[а-яёүө]',
    # Mongolian (Mongolian)
    'mn_Mong': r'[᠐-᠙ᠠ-ᡂ]',
    # Manipuri
    'mni': r'[\u0981-\u0983অ-ঋএ-ঐও-নপ-রলশ-হ\u09BC\u09BE-\u09C3\u09C7-\u09C8\u09CB-\u09CDৱ]',
    # Manipuri (Meitei Mayek)
    'mni_Mtei': r'[ꯀ-\uABEA\uABEC-\uABED]',
    # Mohawk
    'moh': r'[:\\aeh-ikn-or-twyà-áè-éì-íò-óʼ]',
    # Marathi
    'mr': r'[\u0902-\u0903अ-ऌए-ऑओ-नप-रल-ळव-हऽ-\u0943\u0945\u0947-\u0949\u094B-\u094Dॐ]',
    # Malay
    'ms': r'[a-z]',
    # Malay (Arabic)
    'ms_Arab': r'[ء-غف-يچڠڤکڽۏݢ]',
    # Maltese
    'mt': r'[a-bd-xzàèìòùċġħż]',
    # Mundang
    'mua': r'[a-pr-wy-zãëõĩŋǝɓɗṽ]',
    # Muscogee
    'mus': r'[ace-fh-ik-pr-wyēʼ]',
    # Burmese
    'my': r'[က-အဣ-ဧဩ-\u1032\u1036-ဿ၏]',
    # Erzya
    'myv': r'[а-яё]',
    # Mazanderani
    'mzn': r'[ء-ؤئ-غف-قل-و\u064B-\u064D\u0651\u0654پچژکگی]',
    # Nama
    'naq': r'[a-ikm-uw-zâîôûǀ-ǃ]',
    # North Ndebele
    'nd': r'[a-qs-z]',
    # Low German
    'nds': r'[a-zä-åöü]',
    # Low German (Netherlands)
    'nds_NL': r'[a-z]',
    # Nepali
    'ne': r'[\u0901-\u0903अ-ऍए-ऑओ-नप-रल-ळव-ह\u093C-\u0943\u0945\u0947-\u0949\u094B-\u094Dॐ]',
    # Dutch
    'nl': r'[a-záäéëíïóöúü\u0301]',
    # Kwasio
    'nmg': r'[a-pr-wyá-âäé-êí-ïó-ôöú-ûāēěīńŋōŕūǎǐǒǔǝɓ-ɔɛ\u0301-\u0302\u0304\u030C]',
    # Ngiemboon
    'nnh': r'[a-ps-wy-zà-âè-êì-íò-ôù-ûÿěńŋǎǒǔɔɛʉʼ\u0300-\u0302\u030Cḿẅ]',
    # Norwegian
    'no': r'[a-zàå-æéò-ôø]',
    # N’Ko
    'nqo': r'[ߊ-ߧ\u07EB-ߵ]',
    # South Ndebele
    'nr': r'[a-qs-z]',
    # Northern Sotho
    'nso': r'[a-bd-pr-uw-yêôš]',
    # Nuer
    'nus': r'[a-zäëïöŋɔɛɣ\u0308\u0331]',
    # Navajo
    'nv': r'[a-eg-os-tw-záéíóąęįłǫ\u0301’]',
    # Nyanja
    'ny': r'[a-pr-uwy-zŵ]',
    # Nyankole
    'nyn': r'[a-z]',
    # Occitan
    'oc': r'[a-zà-áç-éíïò-óúü]',
    # Oromo
    'om': r'[a-z]',
    # Odia
    'or': r'[\u0B01-\u0B03ଅ-ଋଏ-ଐଓ-ନପ-ରଲ-ଳଵ-ହ\u0B3C\u0B3E-\u0B43\u0B47-\u0B48\u0B4B-\u0B4Dୟୱ]',
    # Ossetic
    'os': r'[а-яёӕ]',
    # Osage
    'osa': r'[\u0301\u0304\u030B\u0358𐓘-𐓻]',
    # Punjabi
    'pa': r'[ਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲਵਸ-ਹ\u0A3C\u0A3E-\u0A42\u0A47-\u0A48\u0A4B-\u0A4Dੜ੦-ੴ]',
    # Punjabi (Arabic)
    'pa_Arab': r'[ء-آؤئ-بت-غف-قل-و\u064Fٹپچڈڑژکگںھہیے]',
    # Papiamento
    'pap': r'[a-zèñ-òùü]',
    # Nigerian Pidgin
    'pcm': r'[a-pr-wy-záéíóú\u0301ẹọ]',
    # Pali
    'pi': r'[a-zñāīŋśūḍḷṁṃṅṇṣṭ]',
    # pis
    'pis': r'[a-bd-pr-wy]',
    # Polish
    'pl': r'[a-pr-uwy-zóąćęłńśźż]',
    # Piedmontese
    'pms': r'[\-\\a-jl-vzàè-éë-ìòù]',
    # Prussian
    'prg': r'[a-zāēģīķņōŗšūžțḑ]',
    # Pashto
    'ps': r'[ء-ؤئ-غف-قل-وي-\u0652\u0654\u0670ټپځڅ-چډړږژښکګگڼی-ۍې]',
    # Pashto (Pakistan)
    'ps_PK': r'[ء-ؤئ-غف-قل-وي-\u0652\u0654\u0670ټپځڅ-چډړږژښکګگڼی-ۍېے]',
    # Portuguese
    'pt': r'[a-zà-ãçé-êíò-õú]',
    # Quechua
    'qu': r'[ach-ik-np-qs-uwyñʼ]',
    # Kʼicheʼ
    'quc': r'[a-ceh-zäʼ]',
    # Rajasthani
    'raj': r'[\u0901-\u0903अक-नप-रलव-ह\u093E-\u0943\u0945\u0947-\u0948\u094B-\u094D]',
    # Rohingya
    'rhg': r'[𐴀-𐴛𐴝-\U00010D27]',
    # Riffian
    'rif': r'[a-np-uw-zɛɣḍḥṣṭẓ]',
    # Romansh
    'rm': r'[a-zàè-éìòù]',
    # Rundi
    'rn': r'[a-z]',
    # Romanian
    'ro': r'[a-zâîășț]',
    # Rombo
    'rof': r'[a-pr-wy-z]',
    # Russian
    'ru': r'[а-яё]',
    # Kinyarwanda
    'rw': r'[a-z]',
    # Rwa
    'rwk': r'[a-pr-wy-z]',
    # Sanskrit
    'sa': r'[\u0901-\u0903अ-ऌए-ऐओ-नप-रल-ळव-ह\u093C-\u0944\u0947-\u0948\u094B-\u094Dॐ-\u0952ॠ-\u0963]',
    # Sakha
    'sah': r'[а-бг-ди-ухчы-эҕҥүһө]',
    # Samburu
    'saq': r'[a-eg-pr-wy]',
    # Santali
    'sat': r'[ᱚ-ᱽ]',
    # Santali (Devanagari)
    'sat_Deva': r'[\u0902अ-आई-उएओकगचजञ-टडण-तदनपबम-रलवस-ह\u093C\u093E\u0940-\u0941\u0947\u094B]',
    # Sangu
    'sbp': r'[a-ps-wy]',
    # Sardinian
    'sc': r'[a-jl-pr-vzàèìòù]',
    # Sicilian
    'scn': r'[a-jl-vzàâèêìîòôùûḍ]',
    # Sindhi
    'sd': r'[ء-آا-بت-غف-قل-ويٺ-ٻٽ-ڀڃ-ڄچ-ڇڊڌ-ڍڏڙڦک-ڪگڱڳڻھ]',
    # Sindhi (Devanagari)
    'sd_Deva': r'[\u0902अ-ऊए-ऐओ-नप-रलव-ह\u093C\u093E-\u0945\u0947-\u0949\u094B-\u094Dॻ-ॼॾ-ॿ]',
    # Southern Kurdish
    'sdh': r'[ئ-بتج-در-شع-غف-قل-نوپچڕژڤکگڵھۆۊیێە]',
    # Northern Sami
    'se': r'[a-pr-vzáčđŋšŧž]',
    # Sena
    'seh': r'[a-zà-ãçé-êíò-õú]',
    # Koyraboro Senni
    'ses': r'[a-uw-zãõŋšžɲẽ]',
    # Sango
    'sg': r'[a-bd-pr-wy-zâäê-ëî-ïôöùû-ü]',
    # Samogitian
    'sgs': r'[a-pr-vzāčēėīōšūž\u0304]',
    # Tachelhit
    'shi': r'[ⴰ-ⴱⴳⴷⴹⴻ-ⴽⵀⵃ-ⵅⵇⵉ-ⵊⵍ-ⵏⵓ-ⵖⵙ-ⵜⵟⵡ-ⵣⵥⵯ]',
    # Tachelhit (Latin)
    'shi_Latn': r'[a-nq-uw-zɛɣʷḍḥṛṣṭ]',
    # Shan
    'shn': r'[02B\\uငတ-ထပမ-သဢ\u102D-\u1031\u1038\u103A-\u103Dၵ-ၸၺ-\u1084\u1087-\u108A႞-႟ꧣ-\uA9E5]',
    # Sinhala
    'si': r'[\u0D82-\u0D83අ-ඍඑ-ඖක-ඥට-නඳ-රලව-ෆ\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DF2]',
    # Sidamo
    'sid': r'[a-z]',
    # Slovak
    'sk': r'[a-záäéíó-ôúýčďĺľňŕšťž]',
    # skr
    'skr': r'[ء-آؤئ-بت-غف-قل-نوٹٻپڄچڈڊڑژکگڳںھہۃیےݙݨ]',
    # Slovenian
    'sl': r'[a-pr-vzčšž]',
    # Southern Sami
    'sma': r'[a-bd-pr-vyä-åö]',
    # Southern Sami (Norway)
    'sma_NO': r'[a-bd-pr-vyå-æø]',
    # Lule Sami
    'smj': r'[a-bd-pr-váä-åń]',
    # Inari Sami
    'smn': r'[a-pr-vy-zá-âäčđŋšž]',
    # Skolt Sami
    'sms': r'[a-pr-vzâä-åõčđŋšžǥǧǩǯʒ]',
    # Shona
    'sn': r'[a-pr-wy-z]',
    # Somali
    'so': r'[b-df-hj-nq-tw-y]',
    # Albanian
    'sq': r'[a-vx-zçë]',
    # Serbian
    'sr': r'[а-ик-шђј-ћџ]',
    # Serbian (Latin)
    'sr_Latn': r'[a-pr-vzćčđšž]',
    # Swati
    'ss': r'[a-z]',
    # Saho
    'ssy': r'[a-ik-oq-uw-y]',
    # Southern Sotho
    'st': r'[a-bd-uwy]',
    # Sundanese
    'su': r'[a-zé]',
    # Swedish
    'sv': r'[a-zàä-åéö]',
    # Swahili
    'sw': r'[a-pr-wy-z]',
    # Swahili (Congo - Kinshasa)
    'sw_CD': r'[a-pr-wy-z]',
    # Swahili (Kenya)
    'sw_KE': r'[a-z]',
    # Syriac
    'syr': r'[܀-܍ܐ-ܬ\u0730-\u074A]',
    # Silesian
    'szl': r'[a-pr-uwy-zãô-õćłńōŏśźż]',
    # Tamil
    'ta': r'[ஃஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-வஷ-ஹ\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD]',
    # Telugu
    'te': r'[\u0C01-\u0C03అ-ఌఎ-ఐఒ-నప-ళవ-హ\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55-\u0C56ౠ-ౡ]',
    # Teso
    'teo': r'[a-eg-pr-y]',
    # Tajik
    'tg': r'[а-хч-шъэ-яёғқҳҷӣӯ]',
    # Thai
    'th': r'[ก-\u0E3Aเ-\u0E4E]',
    # Tigrinya
    'ti': r'[ሀ-ሆለ-ቆቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኆኈኊ-ኍነ-ኮኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዎዐ-ዖዘ-ዮደ-ዷጀ-ጎጐጒ-ጕጠ-ፗ\u135F]',
    # Tigrinya (Eritrea)
    'ti_ER': r'[ሀ-ሆለ-ሟረ-ቆቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኆኈኊ-ኍነ-ኮኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዎዐ-ዖዘ-ዮደ-ዷጀ-ጎጐጒ-ጕጠ-ጯጸ-ጿፈ-ፗ\u135F-፼]',
    # Tigre
    'tig': r'[ሀ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚ\u135F-፨፲-፼ᎀ-᎙ⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞ]',
    # Turkmen
    'tk': r'[a-bd-pr-uwy-zäçöü-ýňşž]',
    # Tswana
    'tn': r'[a-bd-pr-uwyêô]',
    # Tongan
    'to': r'[ae-ik-ps-váéíóúāēīōūʻ]',
    # tok
    'tok': r'[aei-ps-uw]',
    # Tok Pisin
    'tpi': r'[a-bd-pr-uwy]',
    # Turkish
    'tr': r'[a-pr-vy-zçöüğİ-ış]',
    # Taroko
    'trv': r'[a-eg-uw-y]',
    # trw
    'trw': r'[ء-أئ-بت-غف-قل-نوٶٹپڅ-ڈڑژ-ڙکگںھہیےݜݲ]',
    # Tsonga
    'ts': r'[a-z]',
    # Tatar
    'tt': r'[а-яёҗңүһәө]',
    # Tasawaq
    'twq': r'[a-uw-zãõŋšžɲẽ]',
    # Tuvinian
    'tyv': r'[а-яёңүө]',
    # Central Atlas Tamazight
    'tzm': r'[a-nq-uw-zɛɣʷḍḥṛṣṭ]',
    # Uyghur
    'ug': r'[ئ-بتجخ-در-شغف-يپچژڭگھۆ-ۈۋېە]',
    # Ukrainian
    'uk': r'[ʼа-щью-яєі-їґ]',
    # Urdu
    'ur': r'[ءا-بت-غف-قل-نوٹپچڈڑژکگھہیے]',
    # Uzbek
    'uz': r'[a-vx-zʻ-ʼ]',
    # Uzbek (Arabic)
    'uz_Arab': r'[ء-ؤئ-غف-قل-و\u064B-\u0652\u0654\u0670پچژکگۇۉی]',
    # Uzbek (Cyrillic)
    'uz_Cyrl': r'[а-хч-шъэ-яёўғқҳ]',
    # Vai
    'vai': r'[ꔀ-ꘌꘐ-ꘒꘪ-ꘫ]',
    # Vai (Latin)
    'vai_Latn': r'[a-záãéíóõúĩŋũɓ-ɔɗɛ\u0301\u0303ẽ]',
    # Venda
    've': r'[a-bd-ik-pr-zḓḽṅṋṱ]',
    # Venetian
    'vec': r'[a-jl-pr-vxzàè-éìò-óù]',
    # Vietnamese
    'vi': r'[a-eg-ik-vx-yà-ãè-êì-íò-õù-úýăđĩũơưạảấầẩẫậắằẳẵặẹẻẽếềểễệỉịọỏốồổỗộớờởỡợụủứừửữựỳỵỷỹ]',
    # vmw
    'vmw': r'[ace-fh-pr-z]',
    # Volapük
    'vo': r'[a-pr-vx-zäöü]',
    # Vunjo
    'vun': r'[a-pr-wy-z]',
    # Walloon
    'wa': r'[a-zàâå-ëî-ïôùû-üÿœ]',
    # Walser
    'wae': r'[a-záã-äéíóõ-öúüčšũ]',
    # Wolaytta
    'wal': r'[ሀ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚ\u135Fᎀ-᎙ⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞ]',
    # Warlpiri
    'wbp': r'[adgi-nprt-uwy]',
    # Wolof
    'wo': r'[a-gi-uw-yàéëñóŋ]',
    # Xhosa
    'xh': r'[a-z]',
    # xnr
    'xnr': r'[02C-D\\u\u0901-\u0903अ-ऊऍए-ऑओ-नप-रल-ळव-शस-ह\u093C-\u0943\u0945\u0947-\u0949\u094B-\u094Dॐ]',
    # Soga
    'xog': r'[a-z]',
    # Yangben
    'yav': r'[a-ik-ps-wyà-âè-éì-îò-ôù-ûāīŋōūǎǒǔɔɛ\u0300-\u0301]',
    # Yiddish
    'yi': r'[\u05B4\u05B7-\u05B8\u05BC\u05BF\u05C2א-תײ]',
    # Yoruba
    'yo': r'[a-bd-pr-uwyà-áè-éì-íò-óù-úńǹ\u0300-\u0301\u0304ḿṣẹọ]',
    # Yoruba (Benin)
    'yo_BJ': r'[a-bd-pr-uwyà-áè-éì-íò-óù-úɔɛ\u0300-\u0301]',
    # Nheengatu
    'yrl': r'[a-bd-egikm-npr-uw-yãĩũẽ]',
    # Cantonese
    'yue': r'[一-丁七丈-不丑且世丘-丙丟並中串丸-丹主乃久么之乎-乏乖乘-乙九也乾亂了予事-二于云-互五-井些亞亡交-亦亨享-京亮人什-仁仇今-介仍仔他付-仙代-以仰仲件任份企伊伍伐-休伙伯-估伴伸似-伽但佈-佉位-住佔-何余佛-作你佩佳使來例供依侯侵便係-俄俊俏俗保俠-信修俱俾倉個倍們-倒候-倚借倫值假偉偏做停健側-偷偽傅傑傘-備傢-傣傲-傳傷傻傾僅像僑僧價儀億儒儘優允元-充兇-光克免兒兔入內-兩八-兮共兵-典兼冊再冒冠冬冰冷准凋-凍凝凡凰-凱出函刀分-切刊列初判-別刨-刪刮到制-刷刺-刻剃則剌-前剛剩-剪副割創劃劇劉劍力功-加助-劫勁勇勉勒動務勝-勞勢勤勵勸勾-勿包匈化-北匯匹區-十千升-午半卒-協南博卜卡卯-危即卷卹卻厄厘厚原厭厲去參又及-友反叔取-受口-另只-叭可-台史-右司吃-各合-吊同-后吐-吒君吝-吠否-吧含吳吵吸-吹吾呀呂呆告呢周味呵呼-命和咖咦-咧咪咬咱哀-品哇-哉哎員哥-哦哩-哪哭哲唇唉唐唔唬售-唯唱唵唷-唸商啊問啟啡啤-啦啪喀喂善喇喊喔喜-喝喪喬單喲喵嗎嗚嗨嗯嘆嘉嘗嘛嘴嘻嘿噁噓器噴嚇嚏嚴囉四回因困固圈國圍園-圓圖團圜土在圭地圾址均坎坐-坑坡坤坦坪垂-垃型埃城埔域執培-基堂堅-堆堡堪報場塊塔塗塞填塵境墅墓增-墟墨墮墳壁壇壓壘壞壢壩士-壬壯壺壽夏夕-外多夜夠夢夥大天-夫央失夷-夸夾奇-奉奎-奏契奔套奧奪奮女-奴奶她好如妙妝妥妨妮妳妹妻姆姊-始姐-姑姓-委姿威娃娘娛婁婆婚婦媒媽嫌嫩子孔-孕字-存孝孟季-孤孩孫孵學它宅宇-安宋-完宏宗-宜客-室宮害家容宿寂寄-密富寒寞-察寢實-審寫-寬寮寵-寶寺封射將-專尊-尋對-小少尖尚尤就尺尼尾-屁居-屆屋屍屏屑展屠層屬山岡岩岸峰島峽崇崙崴嵐嶺川-州巡工-巨巫差己-巴巷市-布希帕-帖帚-帛帝帥師席帳帶常帽幅幕幟幣幫干-年幸-幹幻-幾庇床序底店庚府度-座庫庭康-庸廈-廉廖廟-廠廢-廣廳延-廷建弄式引弗-弘弟弦弱張強彈彊彌彎彝-彞形彥彩彬-彭彰-影役彼往-征待很律-後徐-徒得從復微徵德徹心必忌-忍志-忙忠-忡快念忽怎怒怕-怖思怡急性-怨怪恆恐恢恥恨-恩恭息-恰悅悉悔悟-悠您悲悶情惑惜惠-惡惱想惹愁愈-愉意愚-愛感慈態慕慘慢-慣慧慮慰慶慾憂憊憐-憑憲憶憾懂應懨懶-懷懼戀戈戊戌成-戒或截戰戲戴戶房-扁扇手才-扎打托扣扥扭-扯批找-技抄把抓投抗-折披-抬抱抵抹抽拆拉拋拍拏拒拔拖招-拜括拳拼拾-拿持指按挑挖挪振挺捏-捐捕捧-捨捲捷掃授-掉掌排掛掠-探接控-推措掰描-提插揚-換握揮援揹損搏搖搜搞搬-搭搶摀摘摩摸撐撒撕撞撣撥播撲撾-撿擁擇擊-擋操-擎擔據擠擦擬擴擺擾攀攝攤支收改攻放-政故效敍敏救敗-教敝-敞敢-散敦敬整-敵數文斐-斑斗料斜斧斯-新斷方於-施旁旅旋族旗既日-旦早旭旺昂昆-昇昌明-昏易星-映春昨昭是時晉晒晚晨普-景晴晶智暑暖-暗暫暮暴曆-曇曉曬曰曲-更書曼曾-最會月-有朋服朔朗望朝期木未-札朱朵杉李材-村杖杜束杯-東松-板析林果-枝枯架柏-某染-柔查柬柯柳-柴栓校核-根格-栽桃案桌桑梁梅條梨梯-械梵棄棉棋棍棒棕棚森棺椅植椒椰楊楓楚業極概榜榮構-槍樂樓標樞模樣樹橄橇橋橘-橙機橫檀檔檢檬檸櫚櫻欄權欖欠-次欣欲欺欽-款歉歌歐歡-武歲歷-歸死殊-残殘殭段殺殼毀毅母每毒比毛毫氏民氣水永汁-求汗汝江-污汪汶決汽沃沈-沉沒沖沙沫沮河油治沿況泉-泊法泡-泣泥注泰泳洋洗洛洞洩-洪洲活洽-派流浣浦浩-浪浮浴海涇-涉涎涮-涯液涵涼淇淋淑淚淡淨深混淺清減渡測港游湖湘湯源準溜-溝溪-溫滄-滅滋滑滴滾-滿漂漏演漠漢漫漲漸漿潔潘潛潮澡澤澳激濃濕濟濤濫濱瀏灌灣火灰災炎炮炸為烈烏烘烤烹焊焙無焦焰然煙煞照煩煮熊熟熱燃燈燒燙營爆爍爐爛爪爬-爭爵-父爸爺爽-爾牆-版牌牙牛牠牧物牲特牽犀犧犬犯狀狂狐狗狠-狡狸狼猛-猜猩猴猶猾-猿獄-獅獎獨獲獸獺-獻獾玄率玉王玩玫玲玻珊珍珠珥班現球理琉琪琴瑙瑜瑞-瑟瑤瑪瑰環瓜瓢瓦瓶甕甘甚甜生產用田-申男-甸界留畢略番-畫異當疆疏疑疲疼疾病痕痛痴瘋瘦-瘧療癡癸登-百皂的皆-皇皮皿盃盆盈益盔盛-盜盟盡監-盥盧目盲直相盼盾省眉看真-眠眼眾睏睛睡督瞇瞌瞧瞪瞭矛矣知短石砂砍研砲破硬碎碗碟碧碩碰確碼磁磚磨磯礎礙礫示社祈祕-祖祚-祛祝-神祥票祿禁禍-福禪禮禱禿-私秋科-秒秘租秤秦移稅程稍種稱稻稿-穀穆穌-積穩究穹-空穿突窄窗窩窮窶立站竟-章童端競竹竿笑笛符笨第筆等筋答策筷箏箔算管箭箱節範篇築篷簡簫簽簿籃籌-籍籠籤米粉粗粵精糊糕-糖糟糥系糾紀約-紅紉納紐純紙-紛素索紫紮-細紳紹終組結絕絡給統-絲經綜綠維綱-網綽綿緊緒線緣編-緩緬緯練縛縣縫縮縱總-績繁繃繆織繞繡繩-繪繳繼續纖缸缺罈罐罕罩-罪置罰署罵罷羅羊美羞群義羽翁習翔翰翹翻-翼耀-老考者而-耍耐耗耳耶聊聖聚聞聯-聰聲職聽-聾肉肌肚股肥肩肯育肺背胎胖胞胡胸能脆脈脖脫腐腓-腔腦腰腳腹腿膚膠膽臂臉臘臟臣臥臨自臭至-致臺與-舊舌-舍舒舞-舟航般船艦良色艾芙芝芬-芭花芳芽苣若-苦英茄-茅茫茲茵-茶茸草荒荷荼莉-莊莎莓莖莫菇菌菜菩華菲萄萊萎萬萵落葉著葛葡葵蒂蒙蒜蒲蒸蒼蓄蓉蓋蓮蔔-蔕蔡蔣蔥蔬蕉蕭蕾薄薑薦薩-薪薯藉藍藏藝藤-藥蘆-蘇蘋蘑蘭蘿虎處虛號虧蚊蚓蚯蛇蛋蛙蜂蜜蜥蜴蝙蝟-蝠蝦蝶螂-螃融螞螢螺蟀蟄蟋蟑蟲-蟳蟹蟻蠅蠍蠕蠣蠻血行術街衛衝衡衣表衫袋袍被裁-裂裏裕補-裝裡裱裹製複褐褲襪襯西要覆見規視親覺覽觀角解觸言訂計訊討訓託-記訝訥訪設許訴診-証評詞詢試詩話-詳誇誌-認誓誕語誠誤說誰課誼調談請諒論諸諺諾謀謂謎講謝證識譜警譯-議護譽讀變讓讚谷豆豈豎豐豔象豪豬豹貌貓貝-貞負-貢貨貪-責貴買費-貼賀資-賈賓賜賞賢-賤賦質賭賴賺購-賽贈贊贏贛赤赫走起超越趕趙趣趨足跆跌跎跑距跟跡跪路跳踏踢踩蹟蹤躍身躲車軌-軍軒軟軸較載輔-輕輛輝輩-輪輯輸轉轎轟辛-辜辣辦辨辭辯-農迅迎近返迦迪-迫述迴迷追退-送逃逆透-逐途這-逛逝速-造逢-連週-進逸逼遇遊-運遍-過道-違遙遜遠適遭-遮遲遷-選遺避-邁還邊邏那邦邪邱郎部郭郵都鄂鄉鄙鄭鄰酉配酒酪酷-酸醉醒醜醫-醬采釋-量金針釣鈴鉅鉢鉤銀銅銖銘銳銷鋁鋒鋼錄錢錦錨錫錯錶鍊-鍋鍵鍾鎊鎖鎮鏈鏡-鏢鐘鐡鐵鑑鑿長門閃閉開閏閒-間閣閩閱闆闊闍闐關闡阱-防阻阿-陀附降限院-除陪陰陳陵-陸陽隆隊階隔際-障隨險隱隻雄-集雉雌雖雙雜雞離-難雨雪雲零-雷電需震霍霜霧露霸-霹靂靈青靖静靜非靠面革靴靼鞋鞭韃韋韓音韻響頁-頂項-順須頌預-頑頓頗-領頞頭頸頻顆題-額顏願顛類顧顯風颱飄飆飛食飪飯飲飽-飾餃餅養餌餐餘餚館餾首香馬駐駕駛駝駱騎騙騷驅驕驗驚骨體高髮鬆鬍鬥鬧鬱鬼魁-魂魅魔魚魯魷鮑鮮鯊鯨鱷鳥鳩鳳-鳴鴨鴻鵝鵡鶴鷹鸚鹽鹿麗麥麵麻-麼黃黎黑默黛點黨鼓鼠鼬鼻齊-齋齒齡龍龐龜]',
    # Cantonese (Simplified)
    'yue_Hans': r'[一-丁七万-与丑专-且世丘-业东-丝丢两-严个中丰串临丸-主丽-举乃久么-义之-乌乎-乐乔乖乘-乙九也-乡书买-乱了予-争事-二于-亏云-互五-井亚-些亡交-亨享-京亮亲人亿-仁仅仇今-介仍-从仑仔他付-仙代-以仪们仰仲件-价任份企伊伍伐-休众-会伟-传伤伦伯-估伴伸似-伽但佉位-住体何余佛-作你佩佳使例供依侠侦-侨侯侵便促-俄俊俗保信修俾倍倒候-倚借值倾假偏做停健偶-偷傣傲傻像僧儒儿允元-充先-光克免兔党入全八-兮兰-共关-兹养-兽内冈册-再冒写军-农冠冬冰冲-决况冷净准凉凌减凝几-凡凤凭凯-凰凶出-击函刀分-切刊划列-创初删判利别到制-刷刺-刻剌-前剑剧剩-剪副割力劝-务动-劫励-劳势勇勉勒勤勿包匈化-北匹-医十千升-午半华-协卒-卓单-南博卜占-卢卧卫卯-危即-却卷厂厄-历厉压-厌厘厚原去县参又及-反发叔取-叙口-另只-叭可-台史-右叶-叹吃-各合-吊同-后吐-向吓吕吗君吝-吠否-吧含-听启吴-吵吸-吹吾呀呆告员呜呢周味呵呼-命和咖咤咦-咧咪咬咱哀-品哇-哉响-哎哥-哦哩-哪哭哲唉唐唔唬售-唯唱唷商啊啡啥-啦啪啰喀喂善喇喊喔喜-喝喵喷嗨嗯嘉嘛嘴嘻嘿器四回因团园困围固国-图圆圈圜土圣在圭地场圾址均坎-坐块坚-坜坡坤坦坪垂-垃型垒埃城埔域培-基堂堆堕堡堪塔塞填境墙增墨壁士-壬壮声壳处备复夏夕-外多夜够大天-夫央失头夷-夺奇-奉奋奎-奏契奔奖-套奥女-奴奶她好如妆-妈妙妥妨妮妳妹妻姆始姐-姑姓-委姿威娃-娄娘娱婆婚媒嫌嫩子孔字-孙孝孟季-孤学孩宁它宅宇-安宋-完宏宗-实宠-室宪-宫害家容宽-宿寂寄-密富寒寝-察寨寮对寻-导寿封射将尊小少尔尖尘尚尝尤就尺尼-尾局-层居届-屋屏展属屠山岁-岂岚-岛岩岭岸峡峰崇崴川-州巡工-巨巫差己-巴巷币-布帅师希帐帕-帖帛帝带席-帮常帽幅幕干-年并幸幻-幽广庄庆-庇床序库-底店庚府废度-座庭康-庸廉廖延-廷建开异-弄式引弗-弘弟-张弥-弦弯弱弹-强彊归-当录彝形彦彩彬-彭彰-影役彻-彼往-征径-待很律徐徒得微德心必-忆忌-忍志-忙忠忧快念忽怀-态怎怒怕-怖怜-思怡急性-怨怪总恋恐恒恢恨-恩恭息-恰恶恼悉悔悟-悠悦您悲情惊惑惜惠惧-惨惯想惹愁愈-愉意愚感愿慈慕慢慧慰憾懂懒戈戊戌戏-戒或战截戴户房-扁扇手才-扎打托扣扥执扩扫-扭扯-扰批找-技抄把抓投抗-折抛抢护-报披-抬抱抵抹抽担-拆拉拍拏拒拔拖招-拜拟拥拨-择括拳拼拾-拿持-挂指按挑挖挝挡挤-挥挪振挺捐捕损捡-换据捷授-掉掌排探接控-推措掸描-提插握援搜搞搬-搭摄摆-摇摘摩摸撑-撒撞播操-擎擦支收改攻放-政故效敌-敍敏救教敝敢-散敦敬数整文斋斐斗料断斯-新方施旁旅旋族旗无既日-旧早旭时旺昂昆昌明-昏易星-映春昨昭是显晋晒-晓晚晨普-景晴晶智暂暑暖-暗暴曰曲更曼曾-最月-有朋服朗望朝期木未-札术朱朵机杀杂-权杉李材-村杜束条来杨杯-杰松-板极构析林果-枝枢枪-枫架柏-某染-柔查柬柯柳-柴标栏树校样-根格桃案桌桑档桥梁梅梦梨梯-械梵检棉棋棒棚森椅植椰楚楼概榜模横檀次-欣欧欲欺款歉歌止-武死殊-残段毁毅母每毒比-毕毛毫氏民气水永求汉汗汝江-污汤汪汶汽沃沈-沉沙沟没沧河油治沿泄泉-泊法泡-波泥注泪泰泳泽-泾洁洋洗洛洞洪洲活洽-派流浅测济-浏浓浦浩-浪浮海涂消-涉涛涨涯液涵淑淡深混清渐渡温港游湖湾源溪滋滑滚满滥滨滴漂漏演漠漫潘潜潮澳激灌火灭灯-灰灵灾炉炎炮炸-点烂烈烟烤烦-烧热焦然煞照熊熟燃爆爪爬爱爵-爸爽片-版牌牙牛牠牧物牲牵特-牺犯状犹狂狐狗狠独狮狱狼猛-猜猪-猫献猴玄率玉王玛玩玫环-现玲玻珊珍珠珥班球理琉琪琴瑙瑜瑞-瑟瑰瑶瓜瓦瓶甘甚甜生用田-申电男-甸画界留略番疆疏疑疗疯疼病痕痛痴癸登白-百的皆-皇皮益监盖-盘盛盟目盲直相盼盾省眉看真-眠眼着睛睡督瞧矛矣知短石矶码-砂砍研破础硕硬确碍-碎碗碟碧碰磁磨示礼社祖祚-祛祝-神祥票祯祸禁禄-禅福离秀-私秋种科-秒秘租秤秦积-称移程稍-税稣稳稿穆究-穷穹-空穿突窗窝窭立站竞-章童端竹笑笔笛符笨第等筋筑答策筹签简算管箫箭箱篇篮簿籍米类粉粗粤精糊糕糟系素索紧紫累繁纠红约-级纪纬纯纲-纳纵纷-纸纽线练-组细-终绍经结绕绘-给络-绝统继绩-绪续维综绿缅缓编缘缚缩-缪缴缸缺网罕罗罚罢罪置署羊美羞群羽翁翔翘翰翻-翼耀-老考者而-耍耐耗耳耶耻聊职联聚聪肉肚股肥肩肯育胆背胎胖胜胞胡胸能脆脑脚脱脸腊腓-腔腰腿臣自臭至-致舌-舍舒舞-舟航般舰船良色艺艾节芝芦芬花芳苍苏若-苦英范茅茫茶草荐荒荣药荷荼莉莎莫莱-莲获菜菩菲萄萤-营萧-萨落葛葡蒂蒋蒙蒲蓝蔕蔡薄薪藏藤虎虑虚虫虽蛇蛋蛙蛮蜂蜜蝎蝶融蟹血行街衡衣补表袋被裁-裂装裕裤西要覆见-观规视览-觉角解触言誉誓警计-订认讨-让训-记讲讷-许论设-访证评识诉词译试诗诚话-诞询该-详语误说请-诸诺-读课谁调谅谈谊-谋谓谚谢谱谷豆象豪貌贝-负贡-败货-质贪购贯贱贴-贵费-贺贾资赋-赌赏-赐赖赚-赛赞赠赢赤赫走赵-起超越-趋趣足跃跌跎跑距跟路跳踏踢踪身躲车轨-轩转轮-轰轻载较辅-辆辈-辉辑输辛辞辨-辩辰-辱边达迁迅过-迈迎运-近返还-这进-迟迦迪-迫述迷迹追退-逃逆选-逊透-逐途通-逛逝速-造逢逸逻-逼遇遍道遗遥遭-遮避-邀那邦邪邮邱邻郁郎郑部郭都鄂酉配酒酷-酸醉醒采释里-量金鉴针钓钟钢钦钱钵铁铃铜铢铭银销-锁锅锋锐错锡锦键镇镑镜长门闪闭-问闰闲间闷闹闻阁阅阇阐阔阗队防-阶阻阿-陀附-陆陈降限院除险-陪陵-陷隆随-隐隔障难雄-集雉雨雪雳零-雷雾需震霍露霸-霹青靖静非靠面革靼鞋鞑韦韩音韵頞页-顶项-须顽-顿预领-颇频颗-题颜-额风飘飞-食餐饭-饮饰-饱饼馆首香马驱驶驻驾骂验骑骗骚骨高鬼魁-魂魅魔鱼鲁鲜鸟鸡鸣鸿鹅鹰鹿麦麻黄黎黑默鼓鼠鼻齐齿龄龙龟]',
    # Zhuang
    'za': r'[a-z]',
    # Standard Moroccan Tamazight
    'zgh': r'[ⴰ-ⴱⴳⴷⴹⴻ-ⴽⵀⵃ-ⵅⵇⵉ-ⵊⵍ-ⵏⵓ-ⵖⵙ-ⵜⵟⵡ-ⵣⵥⵯ]',
    # Chinese
    'zh': r'[一-丁七万-与丑专-且世丘-业东-丝丢两-严丧个中丰串临丸-主丽-举乃久么-义之-乐乔乖乘-乙九也-乡书买-乱乾了予-争事-二于-亏云-互五-井亚-些亡交-亨享-京亮亲人亿-仁仅仇今-介仍-从仔他付-仙代-以仪们仰仲件-价任份仿企伊伍伏-休众-会伟-传伤伦伯-估伴伸似-伽但位-佑体何余佛-作你佤佩佳使例供依侠侦-侨侬侯侵便促-俄俊俗保信俩修俱俾倍倒候-倚借倦值倾假偌偏做停健偶-偷储催傲傻像僧儒儿允元-兆先-光克免兑兔党入全八-兮兰-共关-兹养-兽内冈册-再冒写军-农冠冬冰冲-决况冷准凌减凝几-凡凤凭凯-凰出-击函刀分-切刊刑-划列-创初判利别到制-券刺-刻剂前剑剧剩-剪副割力劝-务劣动-劫励-劳势勇勉勋勒勤勾-勿包-匆匈化-北匙匹-医十千升-午半华-协卒-卓单-南博占-卢卫卯-危即-却卷厂厄-历厉压-厍厚原去县参又-反发叔取-叙口-另只-叭可-台史-右叶-叹吃-各合-吊同-后吐-向吓吗君吝吟否-吧含-听启吵吸-吹吻吾呀呆呈告呐员呜呢呦周味呵呼-命和咖咦-咨咪咬咯咱哀-品哇-哉响-哎哟哥-哦哩-哪哭哲唉唐唤唬售-唯唱唷商啊啡啥-啦啪喀喂善喇喊喏喔喜-喝喵喷喻嗒嗨嗯嘉嘛嘴嘻嘿器四回因团园困围固国-图圆圈土圣在圭地圳场圾址均坎坐-坑块坚-坜坡坤坦坪垂-垃型垒埃埋城埔域培-基堂堆堕堡堪塑塔塞填境增墨壁壤士-壬壮声处备复夏夕-外多夜够夥大天-夫央失头夷-夺奇-奉奋奏契奔奖-套奥女-奴奶她好如妇-妈妖妙妥妨妮妹妻姆姊-始姐-姑姓-委姿威娃-娄娘娜娟娱婆婚媒嫁嫌嫩子孔-孕字-孙孜-孝孟季-孤学孩宁它宇-安宋-完宏宗-实审-室宪害-宴家容宽-宿寂寄-寇富寒寝-察寡寨寸-对寻-导寿封射将尊小少尔尖尘尚尝尤就尺尼-尾局-层居屋屏展属屠山岁-岂岗-岘岚-岛岳岸峡峰崇崩崴川-州巡工-巨巫差己-巴巷币-布帅师希帐帕-帖帝带席-帮常帽幅幕干-年并幸幻-幽广庆床序库-底店庙-庚府庞-废度-座庭康-庸廉廖延-廷建开异-弄弊式引弗-弘弟-张弥-弦弯弱弹-强归-当录彝形彩彬-彭彰-影彷役彻-彼往-征径-待很律-後徐徒得循微徵德心必-忆忌-忍志-忙忠忧快念忽怀-态怎怒怕-怖思怡急性-怨怪总恋恐恢恨-恩恭息-恰恶恼悄悉悔悟-悠患您悲情惑惜惠惧-惨惯想惹愁愈-愉意愚感愧慈慎慕慢慧慰憾懂懒戈戊戌戏-戒或战截戴户房-扁扇手才-扎扑打托扣执扩扫-扯批找-技抄把抑抓投抗-折抢护-报披-抬抱抵抹抽担-拆拉拍拒拔拖拘招-拜拟拥-拦拨-择括拳拷拼拾-拿持指按挑挖挝挡挤-挥挪振挺捉捐捕损捡-换据捷授-掉掌排探接控-措掸描-提插握援搜搞搬-搭摄摆摊摔摘摩摸撒撞播操-擎擦支收改攻放-政故效敌敏救教敝敢-散敦敬数敲整文斋斐斗料斜斥断斯-新方於-施旁旅旋族旗无既日-早旭时旺昂昆昌明-昏易星-映春昨昭是显晃晋晒-晓晚晨普-景晴晶智暂暑暖-暗暮暴曰曲更曹曼曾-最月-有朋服朗望朝期木未-札术朱朵机杀杂-权杉李材-村杜束条来杨杯-杰松-板极构析林果-枝枢枪-枫架柏-某染-柔查柬柯柳-柴标栋栏树校样-根格桃框案桌桑档桥梁梅梦梯-械梵检棉棋棒棚森椅植椰楚楼概榜模樱檀欠-欣欧欲欺款歉歌止-武歪死殊-残段毅母每毒比-毕毛毫氏民气氛水永求汇汉汗汝江-污汤汪汶汽沃沈-沉沙沟没沧河油治沿泉-泊法泛泡-泣泥注泰泳泽洋洗洛洞津洪洲活洽-派流浅测济-浏浑浓浙浦浩-浪浮浴海涅消-涉涛涨涯液涵淋淑淘淡深混添清渐渡渣温港渴游湖湾源溜溪滋滑满滥滨滴漂漏演漠漫潘潜潮澎澳激灌火灭灯-灰灵灿炉炎炮炸-点烂烈烤烦-烧热焦然煌煞照煮熊熟燃燕爆爪爬爱爵-爸爽片-版牌牙牛牡-牢牧物牲牵特-牺犯状犹狂狐狗狠独狮狱狼猛-猜猪献猴玄率玉王玛玩玫环-现玲玻珀珊珍珠班球理琊琪琳-琴琼瑙瑜瑞-瑟瑰瑶璃瓜瓦瓶甘甚甜生用田-申电男-甸画畅界留略番疆疏疑疗疯疲疼疾病痕痛痴癸登白-百的皆-皇皮盈益监-盒盖盘盛盟目直相盼盾省眉看真-眠眼着睛睡督瞧矛矣知短石矶码-砂砍研破础硕硬确碍-碎碗碟碧碰磁磅磨示礼社祖祚祝-神祥票祯祸禁禅福离秀-私秋种科-秒秘租秤秦秩积-称移稀程稍-税稣稳稿穆究-穷穹-空穿突窗窝立站竞-章童端竹笑笔笛符笨第等筋筑答策筹签简算管箭箱篇篮簿籍米类粉粒粗粤粹精糊糕-糖糟系素索紧紫累繁红约-级纪纯纲-纳纵纷-纸纽线练-组细-终绍经结绕绘-给络-绝统继绩-绪续维-绵综绿缅缓编缘缠缩缴缶缸缺罐-网罕罗罚罢罪置署羊美羞群羯羽翁翅翔翘翠翰翻-翼耀-老考者而-耍耐耗耳耶聊职联聘聚聪肉肖肚股肤-肥肩肯育胁胆背胎胖胜胞胡胶胸能脆脑脱脸腊腐腓腰腹腾-腿臂臣自臭至-致舌-舍舒舞-舟航般舰船良色艺艾节芒芝芦芬-芭花芳苍苏苗若-苦英茂-范茨茫茶草荐荒荣药荷莉莎莪-莫莱-莲获菜菩菲萄萍萤-营萧-萨落著葛葡蒂蒋蒙蓉蓝蓬蔑蔡薄薪藉藏藤虎虑虫虹虽-虾蚁蛇蛋蛙蛮蜂蜜蝶融蟹蠢血行街衡衣补表袋被袭裁-裂装裕裤西要覆见-观规视览-觉角解言誉誓警计-订认讨-让训-记讲讷-许论设-访证评识诉词译试诗诚话-诞询该-详语误说请-诸诺-读课谁调谅谈谊-谋谓谜谢谨谱谷豆象豪貌贝-负贡-败货-贪购贯贱贴-贵贸-贺贼贾资赋-赌赏-赐赔赖赚-赛赞赠赢赤赫走赵起趁超越-趋趣足跃跌跑距跟路跳踏踢踩身躲车轨-轩转轮-轰轻载较辅-辆辈-辉辑输辛辞辨-辩辰-辱边达迁迅过-迈迎运-近返还-这进-迟迦迪-迫述迷追退-逃逆选-逊透-逐递途通-逛逝速-造逢逸逻-逼遇遍道遗遭-遮遵避-邀邓那邦邪邮邱邻郎郑部郭都鄂酉酋配酒酷-酸醉醒采释里-量金针钓钟钢钦钱钻铁铃铜铢铭银铺链销-锁锅锋错锡锦键锺镇镜镭长门闪闭-问闰闲间闷闹闻阁阅阐阔队阮防-阶阻阿-陀附-陆陈降限院除险-陪陵-陷隆随-隐隔障难雄-集雉雨雪雯雳零-雷雾需震霍霖露霸-霹青靖静非靠面革靼鞋鞑韦韩音页-顶项-须顽-顿预领-颇频颗-题额风飘-飙飞-食餐饭-饮饰-饱饼馆首香馨马驱驶驻驾验骑骗骚骤骨高鬼魂魅魔鱼鲁鲜鸟鸡鸣鸭鸿鹅鹤鹰鹿麦麻黄黎黑默鼓鼠鼻齐齿龄龙龟]',
    # Chinese (Traditional)
    'zh_Hant': r'[一-丁七丈-不丑且世丘-丙丟並中串丸-丹主乃久么之乎-乏乖乘-乙九也乾亂了予事-二于云-互五-井些亞亡交-亦亨享-京亮人什-仁仇今-介仍仔他付-仙代-以仰仲件任份企伊伍伐-休伙伯-估伴伸似-伽但佈-佉位-住佔-何余佛-作你佩佳使來例供依侯侵便係-俄俊俗保俠-信修俱俾個倍們-倒候-倚借倫值假偉偏做停健側-偷傑備傢-傣傲-傳傷傻傾僅像僑僧價儀億儒儘優允元-充兇-光克免兒兔入內-兩八-兮共兵-典兼冊再冒冠冬冰冷准凌凝凡凰-凱出函刀分-切刊列初判-別利-刪到制-刷刺-刻則剌-前剛剩-剪副割創劃劇劉劍力功-加助-劫勁勇勉勒動務勝-勞勢勤勵勸勿包匈化-北匹區-十千升-午半卒-協南博卜卡卯-危即卷卻厄厘厚原厭厲去參又及-友反叔取-受口-另只-叭可-台史-右司吃-各合-吊同-后吐-吒君吝-吠否-吧含吳吵吸-吹吾呀呂呆告呢周味呵呼-命和咖咦-咧咪咬咱哀-品哇-哉哎員哥-哦哩-哪哭哲唉唐唔唬售-唯唱唷-唸商啊問啟啡啥-啦啪喀喂善喇喊喔喜-喝喬單喵嗎嗚嗨嗯嘆嘉嘗嘛嘴嘻嘿器噴嚇嚴囉四回因困固圈國圍園-圓圖團圜土在圭地圾址均坎坐坡坤坦坪垂-垃型埃城埔域執培-基堂堅-堆堡堪報場塊塔塗塞填塵境增墨墮壁壇壓壘壞壢士-壬壯壽夏夕-外多夜夠夢夥大天-夫央失夷-夸夾奇-奉奎-奏契奔套奧奪奮女-奴奶她好如妙妝妥妨妮妳妹妻姆姊-始姐-姑姓-委姿威娃娘娛婁婆婚婦媒媽嫌嫩子孔字-存孝孟季-孤孩孫學它宅宇-安宋-完宏宗-宜客-室宮害家容宿寂寄-密富寒寞-察寢實-審寫-寬寮寵-寶封射將-專尊-尋對-小少尖尚尤就尺尼尾局-屁居-屆屋屏展屠層屬山岡岩岸峰島峽崇崙崴嵐嶺川-州巡工-巨巫差己-巴巷市-布希帕-帖帛帝帥師席帳帶常帽幅幕幣幫干-年幸-幹幻-幾庇床序底店庚府度-座庫庭康-庸廉廖廠廢-廣廳延-廷建弄式引弗-弘弟弦弱張強彈彊彌彎彝-彞形彥彩彬-彭彰-影役彼往-征待很律-後徐-徒得從復微徵德徹心必忌-忍志-忙忠快念忽怎怒怕-怖思怡急性-怨怪恆恐恢恥恨-恩恭息-恰悅悉悔悟-悠您悲悶情惑惜惠-惡惱想惹愁愈-愉意愚-愛感慈態慕慘慢-慣慧慮慰慶慾憂憐-憑憲憶憾懂應懶-懷懼戀戈戊戌成-戒或截戰戲戴戶房-扁扇手才-扎打托扣扥扭扯批找-技抄把抓投抗-折披-抬抱抵抹抽拆拉拋拍拏拒拔拖招-拜括拳拼拾-拿持指按挑挖挪振挺捐捕捨捲捷掃授-掉掌排掛採-探接控-推措描-提插揚-換握揮援損搖搜搞搬-搭搶摘摩摸撐撒撞撣撥播撾-撿擁擇擊-擋操-擎擔據擠擦擬擴擺擾攝支收改攻放-政故效敍敏救敗-教敝敢-散敦敬整-敵數文斐斗料斯-新斷方於-施旁旅旋族旗既日-旦早旭旺昂昆-昇昌明-昏易星-映春昨昭是時晉晒晚晨普-景晴晶智暑暖-暗暫暴曆曉曰曲更書曼曾-最會月-有朋服朗望朝期木未-札朱朵杉李材-村杜束杯-東松-板析林果-枝架柏-某染-柔查柬柯柳-柴校核-根格桃案桌桑梁梅條梨梯-械梵棄棉棋棒棚森椅植椰楊楓楚業極概榜榮構槍樂樓標樞模樣樹橋機橫檀檔檢欄權次欣欲欺欽-款歉歌歐歡-武歲歷-歸死殊殘段殺殼毀毅母每毒比毛毫氏民氣水永求汗汝江-污汪汶決汽沃沈-沉沒沖沙河油治沿況泉-泊法泡-波泥注泰泳洋洗洛洞洩-洪洲活洽-派流浦浩-浪浮海涇-涉涯液涵涼淑淚淡淨深混淺清減渡測港游湖湯源準溝溪-溫滄-滅滋滑滴滾-滿漂漏演漠漢漫漲漸潔潘潛潮澤澳激濃濟濤濫濱瀏灌灣火灰災炎炮炸為烈烏烤無焦然煙煞照煩熊熟熱燃燈燒營爆爐爛爪爬-爭爵-父爸爺爽-爾牆-版牌牙牛牠牧物牲特牽犧犯狀狂狐狗狠狼猛-猜猴猶獄-獅獎獨獲獸獻玄率玉王玩玫玲玻珊珍珠珥班現球理琉琪琴瑙瑜瑞-瑟瑤瑪瑰環瓜瓦瓶甘甚甜生產用田-申男-甸界留畢略番-畫異當疆疏疑疼病痕痛痴瘋療癡癸登-百的皆-皇皮盃益盛-盜盟盡監-盤盧目盲直相盼盾省眉看真-眠眼眾睛睡督瞧瞭矛矣知短石砂砍研砲破硬碎碗碟碧碩碰確碼磁磨磯礎礙示社祕-祖祚-祛祝-神祥票祿禁禍-福禪禮秀-私秋科-秒秘租秤秦移稅程稍種稱稿穆穌-積穩究穹-空穿突窗窩窮窶立站竟-章童端競竹笑笛符笨第筆等筋答策算管箭箱節範篇築簡簫簽簿籃籌-籍籤米粉粗粵精糊糕糟系糾紀約-紅納紐純紙-紛素索紫累-細紹終組結絕絡給統-絲經綜綠維綱-網緊緒線緣編-緩緬緯練縛縣縮縱總-績繁繆織繞繪繳繼續缸缺罕罪置罰署罵罷羅羊美羞群義羽翁習翔翰翹翻-翼耀-老考者而-耍耐耗耳耶聊聖聚聞聯-聰聲職聽肉肚股肥肩肯育背胎胖胞胡胸能脆脫腓-腔腦腰腳腿膽臉臘臣臥臨自臭至-致臺與-舊舌-舍舒舞-舟航般船艦良色艾芝芬花芳若-苦英茅茫茲茶草荒荷荼莉-莊莎莫菜菩華菲萄萊萬落葉著葛葡蒂蒙蒲蒼蓋蓮蔕蔡蔣蕭薄薦薩-薪藉藍藏藝藤-藥蘆-蘇蘭虎處虛號虧蛇蛋蛙蜂蜜蝶融螢蟲蟹蠍蠻血行術街衛衝衡衣表袋被裁-裂裕補-裝裡製複褲西要覆見規視親覺覽觀角解觸言訂計訊討訓託-記訥訪設許訴註-証評詞詢試詩話-詳誇誌-認誓誕語誠誤說誰課誼調談請諒論諸諺諾謀謂講謝證識譜警譯-議護譽讀變讓讚谷豆豈豐象豪豬貌貓貝-貞負-貢貨貪-責貴買費-貼賀資-賈賓賜賞賢-賤賦質賭賴賺購-賽贈贊贏赤赫走起超越趕趙趣趨足跌跎跑距跟跡路跳踏踢蹟蹤躍身躲車軌-軍軒軟較載輔-輕輛輝輩-輪輯輸轉轟辛辦辨辭辯-農迅迎近返迦迪-迫述迴迷追退-送逃逆透-逐途這-逛逝速-造逢-連週-進逸逼遇遊-運遍-過道-違遙遜遠適遭-遮遲遷-選遺避-邁還邊邏那邦邪邱郎部郭郵都鄂鄉鄭鄰酉配酒酷-酸醉醒醜醫采釋-量金針釣鈴鉢銀銅銖銘銳銷鋒鋼錄錢錦錫錯鍋鍵鍾鎊鎖鎮鏡鐘鐵鑑長門閃閉開閏閒-間閣閱闆闊闍闐關闡防阻阿-陀附降限院-除陪陰陳陵-陸陽隆隊階隔際-障隨險隱隻雄-集雉雖雙雜雞離-難雨雪雲零-雷電需震霍霧露霸-霹靂靈青靖靜非靠面革靼鞋韃韋韓音韻響頁-頂項-順須預-頑頓頗-領頞頭頻顆題-額顏願類顧顯風飄飛食飯飲飽-飾餅養餐餘館首香馬駐駕駛騎騙騷驅驗驚骨體高髮鬆鬥鬧鬱鬼魁-魂魅魔魚魯鮮鳥鳳-鳴鴻鵝鷹鹿麗麥麵麻-麼黃黎黑默點黨鼓鼠鼻齊-齋齒齡龍龜]',
    # Chinese (Latin)
    'zh_Latn': r'[a-uw-zà-áè-êì-íò-óù-úüāĉēěīńňŋōŝūǎǐǒǔǖǘǚǜǹ\u0300\u0304\u030Cḿẑếề]',
    # Zulu
    'zu': r'[a-z]',
}
