---
layout: default
---

# Applications Programming Interface

The publically callable functions of libsamplerate are all listed in the
**\<samplerate.h\>** header file. In order to use any of the functionality of
libsamplerate, you need to add

```c
#include <samplerate.h>
```

to the top of any function that call any of the following functions. You will
also need to link you binary with the libsamplerate library.

The API allows three methods for accessing the capabilities of the library:

- A [simple interface](api_simple.md) which can sample rate convert a single
  block of samples (one or more channels) in one go. The simple API is less
  capable than the full API.
- A [more fully featured interface](api_full.md) which allows time varying
  sample rate conversion on streaming data (again one or more channels).
- A [callback interface](api_callback.md) which has the same functionality as
  the interface above but allows the details of input and output to be
  separated. The output is generated by call a read function and the library
  calls a user supplied callback function to obtain its input. This interface is
  particularly well suited to applications where the output sample rate is
  varied with time.

**NB :** All three access methods are able to process multi channel interleaved
data.

The parts of the API which are common to all three interfaces are:

- The [error reporting](api_misc.md#error-reporting) mechanisim.
- The available [converter](api_misc.md#converters) types.
- The [SRC_DATA](api_misc.md#src_data) struct.

All three versions of the API are restricted to operating on buffers of ISO C
Standard **float** data. However, there are two [auxiliary functions](api_misc.md#auxiliary-functions)
for converting arrays of float data to and from short data.

**Note:** The **tests/** and **examples/** directories of the source code
distribution contain numerous example programs showing the use of the library.
