#include <string>
#include <iostream>
#include <cstddef>
#include <cstdint>
#include <cstdio>

#include "prestosynth/sequence.h"
#include "prestosynth/synthesizer.h"

int main(int argc, char const *argv[])
{
    psynth::Synthesizer synth(std::string("../example/MuseScore_General.sf3"), 44100, 0, 1);
    psynth::Track track;
    track.preset = 40;
    track.notes = {{0., 1., 67, 100},
                    {1., .5, 67, 100},
                    {1.5, .5, 70, 100},
                    {2., .5, 72, 100},
                    {2.5, .5, 75, 100},
                    {3., .5, 75, 100},
                    {3.5, .5, 72, 100},
                    {4., 1., 70, 100},
                    {5., .5, 70, 100},
                    {5.5, .5, 72, 100},
                    {6., 2., 70, 100},
                    {8., 1., 67, 100},
                    {9., .5, 67, 100},
                    {9.5, .5, 70, 100},
                    {10., .5, 72, 100},
                    {10.5, .5, 75, 100},
                    {11., .5, 75, 100},
                    {11.5, .5, 72, 100},
                    {12., 1., 70, 100},
                    {13., .5, 70, 100},
                    {13.5, .5, 72, 100},
                    {14., 2., 70, 100},
                    {16., 1., 70, 100},
                    {17., 1., 70, 100},
                    {18., 1., 70, 100},
                    {19., .5, 67, 100},
                    {19.5, .5, 70, 100},
                    {20., 1., 72, 100},
                    {21., 1., 72, 100},
                    {22., 2., 70, 100},
                    {24., 1., 67, 100},
                    {25., .5, 65, 100},
                    {25.5, .5, 67, 100},
                    {26., 1., 70, 100},
                    {27., .5, 67, 100},
                    {27.5, .5, 65, 100},
                    {28., 1., 63, 100},
                    {29., .5, 63, 100},
                    {29.5, .5, 65, 100},
                    {30., 2., 63, 100},
                    {32., .5, 67, 100},
                    {32.5, .5, 65, 100},
                    {33., 1., 63, 100},
                    {34., 1.5, 65, 100},
                    {35.5, .5, 67, 100},
                    {36., 1., 70, 100},
                    {37., .5, 72, 100},
                    {37.5, .5, 75, 100},
                    {38., 1.5, 70, 100},
                    {39.5, .5, 67, 100},
                    {40., 1., 65, 100},
                    {41., .5, 67, 100},
                    {41.5, .5, 70, 100},
                    {42., .5, 65, 100},
                    {42.5, .5, 67, 100},
                    {43., .5, 63, 100},
                    {43.5, .5, 60, 100},
                    {44., 2., 58, 100},
                    {46., 1., 60, 100},
                    {47., 1., 63, 100},
                    {48., 1.5, 65, 100},
                    {49.5, .5, 67, 100},
                    {50., .5, 63, 100},
                    {50.5, .5, 65, 100},
                    {51., .5, 63, 100},
                    {51.5, .5, 60, 100},
                    {52., 2., 58, 100}};
    psynth::Sequence sequence;
    sequence.tracks = { track };
    // psynth::AudioData audio = synth.render(sequence, true);
    psynth::AudioData audio = synth.render(sequence, true);

    psynth::write_audio("test.wav", audio, 44100, false);
    return 0;
};