## batch_img

Batch processing (**resize, rotate, remove GPS, add border, set transparency,
auto do all**) image files (**HEIC, JPG, PNG**) by utilizing
**[Pillow / PIL](https://github.com/python-pillow/Pillow)** library.
Resize, remove GPS, rotate, set transparency, add border to a single image file
or all image files in a folder / dir. Tested on **macOS** and **Windows**.

### Installation

#### One-time Setup

Install the [`uv`](https://github.com/astral-sh/uv) tool one-time to prepare for
**all** Python tools and packages installation. Install
[`uv`](https://github.com/astral-sh/uv) by its standalone installers:

```
# On macOS and Linux.
curl -LsSf https://astral.sh/uv/install.sh | sh
```

```
# On Windows (PowerShell).
powershell -ExecutionPolicy ByPass -c "irm https://astral.sh/uv/install.ps1 | iex"

$env:Path = "C:\Users\{your_user_name}\.local\bin:$env:Path"

uv venv

.venv\Scripts\activate
```

#### Install the `batch_img` tool

Install the `batch_img` tool from PyPI by the
[`uv`](https://github.com/astral-sh/uv) command:

```
uv pip install --upgrade batch_img
```

### Usage

#### Sample command lines:

```
✗ batch_img --version
0.0.8

✗ batch_img rotate --angle 90 ~/Downloads/IMG_0070.HEIC
...
✅ Processed the image file(s)
```

### Help

#### Top level commands help:

```
✗ batch_img --help
Usage: batch_img [OPTIONS] COMMAND [ARGS]...

Options:
  --update   Update the tool to the latest version.
  --version  Show the tool's version.
  --help     Show this message and exit.

Commands:
  auto         Auto process (resize to 1920, remove GPS, add border)...
  border       Add internal border to image file(s), not expand the size.
  no-gps       Remove GPS location info in image file(s).
  resize       Resize image file(s).
  rotate       Rotate image file(s).
  transparent  Set transparency on image file(s).
```

#### The `auto` sub-command CLI options:

```
✗ batch_img auto --help
Usage: batch_img auto [OPTIONS] SRC_PATH

  Auto process (resize to 1920, remove GPS, add border) image file(s).

Options:
  -ar, --auto_rotate  Auto-rotate image (experimental)
  -o, --output TEXT   Output file path. If not specified, replace the input
                      file.  [default: ""]
  --help              Show this message and exit.
```

#### The `border` sub-command CLI options:

```
✗ batch_img border --help
Usage: batch_img border [OPTIONS] SRC_PATH

  Add internal border to image file(s), not expand the size.

Options:
  -bw, --border_width INTEGER RANGE
                                  Add border to image file(s) with the
                                  border_width. 0 - no border.  [default: 5;
                                  0<=x<=30]
  -bc, --border_color TEXT        Add border to image file(s) with the
                                  border_color string.  [default: gray]
  -o, --output TEXT               Output file path. If not specified, replace
                                  the input file.  [default: ""]
  --help                          Show this message and exit.
```

#### The `no-gps` sub-command CLI options:

```
✗ batch_img no-gps --help
Usage: batch_img no-gps [OPTIONS] SRC_PATH

  Remove GPS location info in image file(s).

Options:
  -o, --output TEXT  Output file path. If not specified, replace the input
                     file.  [default: ""]
  --help             Show this message and exit.
```

#### The `resize` sub-command CLI options:

```
✗ batch_img resize --help
Usage: batch_img resize [OPTIONS] SRC_PATH

  Resize image file(s).

Options:
  -l, --length INTEGER RANGE  Resize image file(s) on original aspect ratio to
                              the max side length. 0 - no resize.  [default:
                              0; x>=0]
  -o, --output TEXT           Output file path. If not specified, replace the
                              input file.  [default: ""]
  --help                      Show this message and exit.
```

#### The `rotate` sub-command CLI options:

```
✗ batch_img rotate --help
Usage: batch_img rotate [OPTIONS] SRC_PATH

  Rotate image file(s).

Options:
  -a, --angle [0|90|180|270]  Rotate image file(s) to the clockwise angle. 0 -
                              no rotate.  [default: 0]
  -o, --output TEXT           Output file path. If not specified, replace the
                              input file.  [default: ""]
  --help                      Show this message and exit.
```

#### The `transparent` sub-command CLI options:

```
✗ batch_img transparent --help
Usage: batch_img transparent [OPTIONS] SRC_PATH

  Set transparency on image file(s).

Options:
  -o, --output TEXT               Output file path. If not specified, replace
                                  the input file. If the input file is JPEG,
                                  it will be saved as PNG file because JPEG
                                  does not support transparency  [default: ""]
  -t, --transparency INTEGER RANGE
                                  Set transparency on image file(s). 0 - fully
                                  transparent, 255 - completely opaque.
                                  [default: 127; 0<=x<=255]
  -w, --white                     Make white pixels fully transparent.
  --help                          Show this message and exit.
```
