# TelegramTextApp
**TelegramTextApp** — это надстройка над [telebot](https://github.com/aiogram/aiogram), которая упрощает создание бота в **telegram**

## 🌟 Особенности
- Создание всех меню в одном файле
- Для запуска, нужен только API-ключ
- Быстрое создание макета бота

## ⚙️ Установка и настройка

### Требования
- Python 3.10 или новее
- Аккаунт Telegram

### Шаги:
#### Установка библиотеки
```bash
pip install TelegramTextApp
```
#### Первый запуск
```python
import TelegramTextApp
if __name__ == "__main__":
    TelegramTextApp.start(
        token="bot_token",
        json_file="путь_к_json_файлу.json",
        database="путь_к_базе_данных.db",
        debug=False
        )
```
# Минимальная структура бота

## Структура для хранения атрибутов
```json
{
    "bot":{},
    "menu":{},
    "mini_menu":{},
    "buttons":{},
    "commands":{}
}
```

## Создание меню
```json
"название_меню":{
  "row":2, // ширина клавиатуры,

  "text":"Любой текст. *Можно* _использовать_ __markdown__ ||разметку|| [telegram](telegram.com)",

  "keyboard":{
    "название_меню_которое_нужно_открыть":"Текст_кнопки",
    "menu_name|{динамическая_вставка_данных}":"Текст_кнопки"
  },
  "keyboard":"название_вашей_функции", // создание своей клавиатуры 

  "return":"название_меню", // кнопка возврата в указаное меню

  "function":"название_вашей функции", // выполнение вашей функции, при открытии меню (можно передавать динамические параметры)

  "input": { // ожидание отправки сообщения от пользователя с последующим выполнением
    "function":"название_вашей_функции",
    "menu":"название_меню_которое_откроется",
    "data":"название динамического параматра"
  }
}
```

## Создание команды
```json
"название_команды":{
  "menu":"название_меню_которое_откроется",
  "description":"Краткое описание команды"
},
```

## Обязательные кнопки
```json
"buttons":{
    "return":"🔙 Назад",
    "notification":"Прочитано"
},
```

# Кастомные функции

## Функция для создания кнопок
```python
async def create_my_buttons(tta_data):
    buttons = {}
    buttons['название_меню'] = "Текст кнопки"
    return {"название_меню_которое_нужно_открыть":"Текст_кнопки"}
```

## Функция с возвратом динамического параметра
```python
def my_text(tta_data=None):
    text = "Это мой текст"
    return {"название_параметра":"значение параметра"}
```

# 🤝 Как внести вклад
- Форкните репозиторий
- Создайте ветку с фичей/исправлением:
- Зафиксируйте изменения и отправьте в форк
- Создайте Pull Request с описанием изменений

# 📬 Обратная связь
- **Автор:** [falbue](https://github.com/falbue)
- **Баги и предложения:** [Issues](https://github.com/falpin/TelegramTextApp/issues)
