# Tutorials

A gallery of fully worked out tutorials analyzing neural recordings from different brain regions and recording modalities.

:::{dropdown} Additional requirements
:color: warning
:icon: alert
To run the tutorials, you may need to install some additional packages used for plotting and data fetching.
You can install all of the required packages with the following command:
```
pip install nemos[examples]
```
:::

::::{grid} 1 2 3 3

:::{grid-item-card}

<figure>
<img src="../_static/thumbnails/tutorials/plot_01_current_injection.svg" style="height: 100px", alt="Current Injection."/>
</figure>

```{toctree}
:maxdepth: 2

plot_01_current_injection.md
```
:::

:::{grid-item-card}

<figure>
<img src="../_static/thumbnails/tutorials/plot_02_head_direction.svg" style="height: 100px", alt="Head direction."/>
</figure>

```{toctree}
:maxdepth: 2

plot_02_head_direction.md
```
:::

:::{grid-item-card}

<figure>
<img src="../_static/thumbnails/tutorials/plot_03_grid_cells.svg" style="height: 100px", alt="Grid Cells."/>
</figure>

```{toctree}
:maxdepth: 2

plot_03_grid_cells.md
```

:::

:::{grid-item-card}

<figure>
<img src="../_static/thumbnails/tutorials/plot_04_v1_cells.svg" style="height: 100px", alt="V1 cells."/>
</figure>

```{toctree}
:maxdepth: 2

plot_04_v1_cells.md
```
:::

:::{grid-item-card}

<figure>
<img src="../_static/thumbnails/tutorials/plot_05_place_cells.svg" style="height: 100px", alt="Place cells."/>
</figure>

```{toctree}
:maxdepth: 2

plot_05_place_cells.md
```
:::

:::{grid-item-card}

<figure>
<img src="../_static/thumbnails/tutorials/plot_06_calcium_imaging.svg" style="height: 100px", alt="Calcium immaging."/>
</figure>

```{toctree}
:maxdepth: 2
plot_06_calcium_imaging.md
```
:::

::::
