# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretImpersonatedAccountArgs', 'SecretImpersonatedAccount']

@pulumi.input_type
class SecretImpersonatedAccountArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 impersonated_account: pulumi.Input[_builtins.str],
                 service_account_email: pulumi.Input[_builtins.str],
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 token_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretImpersonatedAccount resource.
        :param pulumi.Input[_builtins.str] backend: Path where the GCP Secrets Engine is mounted
        :param pulumi.Input[_builtins.str] impersonated_account: Name of the Impersonated Account to create
        :param pulumi.Input[_builtins.str] service_account_email: Email of the GCP service account to impersonate.
        :param pulumi.Input[_builtins.str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_scopes: List of OAuth scopes to assign to access tokens generated under this impersonated account.
        :param pulumi.Input[_builtins.str] ttl: Specifies the default TTL for service principals generated using this role.
               Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "impersonated_account", impersonated_account)
        pulumi.set(__self__, "service_account_email", service_account_email)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if token_scopes is not None:
            pulumi.set(__self__, "token_scopes", token_scopes)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        Path where the GCP Secrets Engine is mounted
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="impersonatedAccount")
    def impersonated_account(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Impersonated Account to create
        """
        return pulumi.get(self, "impersonated_account")

    @impersonated_account.setter
    def impersonated_account(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "impersonated_account", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Input[_builtins.str]:
        """
        Email of the GCP service account to impersonate.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target namespace. (requires Enterprise)
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="tokenScopes")
    def token_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of OAuth scopes to assign to access tokens generated under this impersonated account.
        """
        return pulumi.get(self, "token_scopes")

    @token_scopes.setter
    def token_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_scopes", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default TTL for service principals generated using this role.
        Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _SecretImpersonatedAccountState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 impersonated_account: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_project: Optional[pulumi.Input[_builtins.str]] = None,
                 token_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretImpersonatedAccount resources.
        :param pulumi.Input[_builtins.str] backend: Path where the GCP Secrets Engine is mounted
        :param pulumi.Input[_builtins.str] impersonated_account: Name of the Impersonated Account to create
        :param pulumi.Input[_builtins.str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[_builtins.str] service_account_email: Email of the GCP service account to impersonate.
        :param pulumi.Input[_builtins.str] service_account_project: Project the service account belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_scopes: List of OAuth scopes to assign to access tokens generated under this impersonated account.
        :param pulumi.Input[_builtins.str] ttl: Specifies the default TTL for service principals generated using this role.
               Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if impersonated_account is not None:
            pulumi.set(__self__, "impersonated_account", impersonated_account)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if service_account_project is not None:
            pulumi.set(__self__, "service_account_project", service_account_project)
        if token_scopes is not None:
            pulumi.set(__self__, "token_scopes", token_scopes)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path where the GCP Secrets Engine is mounted
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="impersonatedAccount")
    def impersonated_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Impersonated Account to create
        """
        return pulumi.get(self, "impersonated_account")

    @impersonated_account.setter
    def impersonated_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "impersonated_account", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target namespace. (requires Enterprise)
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email of the GCP service account to impersonate.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountProject")
    def service_account_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project the service account belongs to.
        """
        return pulumi.get(self, "service_account_project")

    @service_account_project.setter
    def service_account_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_project", value)

    @_builtins.property
    @pulumi.getter(name="tokenScopes")
    def token_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of OAuth scopes to assign to access tokens generated under this impersonated account.
        """
        return pulumi.get(self, "token_scopes")

    @token_scopes.setter
    def token_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_scopes", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default TTL for service principals generated using this role.
        Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("vault:gcp/secretImpersonatedAccount:SecretImpersonatedAccount")
class SecretImpersonatedAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 impersonated_account: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 token_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a Impersonated Account in the [GCP Secrets Engine](https://www.vaultproject.io/docs/secrets/gcp/index.html) for Vault.

        Each [impersonated account](https://www.vaultproject.io/docs/secrets/gcp/index.html#impersonated-accounts) is tied to a separately managed
        Service Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_google as google
        import pulumi_std as std
        import pulumi_vault as vault

        this = google.index.ServiceAccount("this", account_id=my-awesome-account)
        gcp = vault.gcp.SecretBackend("gcp",
            path="gcp",
            credentials=std.file(input="credentials.json").result)
        impersonated_account = vault.gcp.SecretImpersonatedAccount("impersonated_account",
            backend=gcp.path,
            impersonated_account="this",
            service_account_email=this["email"],
            token_scopes=["https://www.googleapis.com/auth/cloud-platform"])
        ```

        ## Import

        A impersonated account can be imported using its Vault Path. For example, referencing the example above,

        ```sh
        $ pulumi import vault:gcp/secretImpersonatedAccount:SecretImpersonatedAccount impersonated_account gcp/impersonated-account/project_viewer
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: Path where the GCP Secrets Engine is mounted
        :param pulumi.Input[_builtins.str] impersonated_account: Name of the Impersonated Account to create
        :param pulumi.Input[_builtins.str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[_builtins.str] service_account_email: Email of the GCP service account to impersonate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_scopes: List of OAuth scopes to assign to access tokens generated under this impersonated account.
        :param pulumi.Input[_builtins.str] ttl: Specifies the default TTL for service principals generated using this role.
               Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretImpersonatedAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Impersonated Account in the [GCP Secrets Engine](https://www.vaultproject.io/docs/secrets/gcp/index.html) for Vault.

        Each [impersonated account](https://www.vaultproject.io/docs/secrets/gcp/index.html#impersonated-accounts) is tied to a separately managed
        Service Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_google as google
        import pulumi_std as std
        import pulumi_vault as vault

        this = google.index.ServiceAccount("this", account_id=my-awesome-account)
        gcp = vault.gcp.SecretBackend("gcp",
            path="gcp",
            credentials=std.file(input="credentials.json").result)
        impersonated_account = vault.gcp.SecretImpersonatedAccount("impersonated_account",
            backend=gcp.path,
            impersonated_account="this",
            service_account_email=this["email"],
            token_scopes=["https://www.googleapis.com/auth/cloud-platform"])
        ```

        ## Import

        A impersonated account can be imported using its Vault Path. For example, referencing the example above,

        ```sh
        $ pulumi import vault:gcp/secretImpersonatedAccount:SecretImpersonatedAccount impersonated_account gcp/impersonated-account/project_viewer
        ```

        :param str resource_name: The name of the resource.
        :param SecretImpersonatedAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretImpersonatedAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 impersonated_account: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 token_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretImpersonatedAccountArgs.__new__(SecretImpersonatedAccountArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if impersonated_account is None and not opts.urn:
                raise TypeError("Missing required property 'impersonated_account'")
            __props__.__dict__["impersonated_account"] = impersonated_account
            __props__.__dict__["namespace"] = namespace
            if service_account_email is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_email'")
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["token_scopes"] = token_scopes
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["service_account_project"] = None
        super(SecretImpersonatedAccount, __self__).__init__(
            'vault:gcp/secretImpersonatedAccount:SecretImpersonatedAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            impersonated_account: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_project: Optional[pulumi.Input[_builtins.str]] = None,
            token_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ttl: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretImpersonatedAccount':
        """
        Get an existing SecretImpersonatedAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: Path where the GCP Secrets Engine is mounted
        :param pulumi.Input[_builtins.str] impersonated_account: Name of the Impersonated Account to create
        :param pulumi.Input[_builtins.str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[_builtins.str] service_account_email: Email of the GCP service account to impersonate.
        :param pulumi.Input[_builtins.str] service_account_project: Project the service account belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] token_scopes: List of OAuth scopes to assign to access tokens generated under this impersonated account.
        :param pulumi.Input[_builtins.str] ttl: Specifies the default TTL for service principals generated using this role.
               Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretImpersonatedAccountState.__new__(_SecretImpersonatedAccountState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["impersonated_account"] = impersonated_account
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["service_account_email"] = service_account_email
        __props__.__dict__["service_account_project"] = service_account_project
        __props__.__dict__["token_scopes"] = token_scopes
        __props__.__dict__["ttl"] = ttl
        return SecretImpersonatedAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        Path where the GCP Secrets Engine is mounted
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="impersonatedAccount")
    def impersonated_account(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Impersonated Account to create
        """
        return pulumi.get(self, "impersonated_account")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Target namespace. (requires Enterprise)
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[_builtins.str]:
        """
        Email of the GCP service account to impersonate.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter(name="serviceAccountProject")
    def service_account_project(self) -> pulumi.Output[_builtins.str]:
        """
        Project the service account belongs to.
        """
        return pulumi.get(self, "service_account_project")

    @_builtins.property
    @pulumi.getter(name="tokenScopes")
    def token_scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of OAuth scopes to assign to access tokens generated under this impersonated account.
        """
        return pulumi.get(self, "token_scopes")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the default TTL for service principals generated using this role.
        Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        return pulumi.get(self, "ttl")

