# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecretsListResult',
    'AwaitableGetSecretsListResult',
    'get_secrets_list',
    'get_secrets_list_output',
]

@pulumi.output_type
class GetSecretsListResult:
    """
    A collection of values returned by getSecretsList.
    """
    def __init__(__self__, id=None, names=None, namespace=None, path=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        List of all secret names listed under the given path.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")


class AwaitableGetSecretsListResult(GetSecretsListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretsListResult(
            id=self.id,
            names=self.names,
            namespace=self.namespace,
            path=self.path)


def get_secrets_list(namespace: Optional[_builtins.str] = None,
                     path: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretsListResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_vault as vault

    kvv1 = vault.Mount("kvv1",
        path="kvv1",
        type="kv",
        options={
            "version": "1",
        },
        description="KV Version 1 secret engine mount")
    aws_secret = vault.kv.Secret("aws_secret",
        path=kvv1.path.apply(lambda path: f"{path}/aws-secret"),
        data_json=json.dumps({
            "zip": "zap",
        }))
    azure_secret = vault.kv.Secret("azure_secret",
        path=kvv1.path.apply(lambda path: f"{path}/azure-secret"),
        data_json=json.dumps({
            "foo": "bar",
        }))
    secrets = vault.kv.get_secrets_list_output(path=kvv1.path)
    ```

    ## Required Vault Capabilities

    Use of this resource requires the `read` capability on the given path.


    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.str path: Full KV-V1 path where secrets will be listed.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['path'] = path
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:kv/getSecretsList:getSecretsList', __args__, opts=opts, typ=GetSecretsListResult).value

    return AwaitableGetSecretsListResult(
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'),
        namespace=pulumi.get(__ret__, 'namespace'),
        path=pulumi.get(__ret__, 'path'))
def get_secrets_list_output(namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            path: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretsListResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_vault as vault

    kvv1 = vault.Mount("kvv1",
        path="kvv1",
        type="kv",
        options={
            "version": "1",
        },
        description="KV Version 1 secret engine mount")
    aws_secret = vault.kv.Secret("aws_secret",
        path=kvv1.path.apply(lambda path: f"{path}/aws-secret"),
        data_json=json.dumps({
            "zip": "zap",
        }))
    azure_secret = vault.kv.Secret("azure_secret",
        path=kvv1.path.apply(lambda path: f"{path}/azure-secret"),
        data_json=json.dumps({
            "foo": "bar",
        }))
    secrets = vault.kv.get_secrets_list_output(path=kvv1.path)
    ```

    ## Required Vault Capabilities

    Use of this resource requires the `read` capability on the given path.


    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.str path: Full KV-V1 path where secrets will be listed.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['path'] = path
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:kv/getSecretsList:getSecretsList', __args__, opts=opts, typ=GetSecretsListResult)
    return __ret__.apply(lambda __response__: GetSecretsListResult(
        id=pulumi.get(__response__, 'id'),
        names=pulumi.get(__response__, 'names'),
        namespace=pulumi.get(__response__, 'namespace'),
        path=pulumi.get(__response__, 'path')))
