# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendCertArgs', 'SecretBackendCert']

@pulumi.input_type
class SecretBackendCertArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 common_name: pulumi.Input[_builtins.str],
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 revoke: Optional[pulumi.Input[_builtins.bool]] = None,
                 revoke_with_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecretBackendCert resource.
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] common_name: CN of certificate to create
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[_builtins.str] cert_metadata: A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request.
        :param pulumi.Input[_builtins.int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[_builtins.str] name: Name of the role to create the certificate against
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.bool] revoke: If set to `true`, the certificate will be revoked on resource destruction using the `revoke` PKI API. Conflicts with `revoke_with_key`. Default `false`.
        :param pulumi.Input[_builtins.bool] revoke_with_key: If set to `true`, the certificate will be revoked on resource destruction using the `revoke-with-key` PKI API. Conflicts with `revoke`. Default `false`
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_ids: List of Subject User IDs
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "common_name", common_name)
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if cert_metadata is not None:
            pulumi.set(__self__, "cert_metadata", cert_metadata)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if min_seconds_remaining is not None:
            pulumi.set(__self__, "min_seconds_remaining", min_seconds_remaining)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if private_key_format is not None:
            pulumi.set(__self__, "private_key_format", private_key_format)
        if revoke is not None:
            pulumi.set(__self__, "revoke", revoke)
        if revoke_with_key is not None:
            pulumi.set(__self__, "revoke_with_key", revoke_with_key)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[_builtins.str]:
        """
        CN of certificate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alt_names", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="certMetadata")
    def cert_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        """
        return pulumi.get(self, "cert_metadata")

    @cert_metadata.setter
    def cert_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_metadata", value)

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default issuer of this request.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_ref", value)

    @_builtins.property
    @pulumi.getter(name="minSecondsRemaining")
    def min_seconds_remaining(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        """
        return pulumi.get(self, "min_seconds_remaining")

    @min_seconds_remaining.setter
    def min_seconds_remaining(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_seconds_remaining", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the role to create the certificate against
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_after", value)

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "other_sans", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @private_key_format.setter
    def private_key_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_format", value)

    @_builtins.property
    @pulumi.getter
    def revoke(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the certificate will be revoked on resource destruction using the `revoke` PKI API. Conflicts with `revoke_with_key`. Default `false`.
        """
        return pulumi.get(self, "revoke")

    @revoke.setter
    def revoke(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "revoke", value)

    @_builtins.property
    @pulumi.getter(name="revokeWithKey")
    def revoke_with_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the certificate will be revoked on resource destruction using the `revoke-with-key` PKI API. Conflicts with `revoke`. Default `false`
        """
        return pulumi.get(self, "revoke_with_key")

    @revoke_with_key.setter
    def revoke_with_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "revoke_with_key", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uri_sans", value)

    @_builtins.property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Subject User IDs
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_ids", value)


@pulumi.input_type
class _SecretBackendCertState:
    def __init__(__self__, *,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 issuing_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_pending: Optional[pulumi.Input[_builtins.bool]] = None,
                 revoke: Optional[pulumi.Input[_builtins.bool]] = None,
                 revoke_with_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SecretBackendCert resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] ca_chain: The CA chain
        :param pulumi.Input[_builtins.str] cert_metadata: A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        :param pulumi.Input[_builtins.str] certificate: The certificate
        :param pulumi.Input[_builtins.str] common_name: CN of certificate to create
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.int] expiration: The expiration date of the certificate in unix epoch format
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request.
        :param pulumi.Input[_builtins.str] issuing_ca: The issuing CA
        :param pulumi.Input[_builtins.int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[_builtins.str] name: Name of the role to create the certificate against
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] private_key: The private key
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] private_key_type: The private key type
        :param pulumi.Input[_builtins.bool] renew_pending: `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        :param pulumi.Input[_builtins.bool] revoke: If set to `true`, the certificate will be revoked on resource destruction using the `revoke` PKI API. Conflicts with `revoke_with_key`. Default `false`.
        :param pulumi.Input[_builtins.bool] revoke_with_key: If set to `true`, the certificate will be revoked on resource destruction using the `revoke-with-key` PKI API. Conflicts with `revoke`. Default `false`
        :param pulumi.Input[_builtins.str] serial_number: The serial number
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_ids: List of Subject User IDs
        """
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if ca_chain is not None:
            pulumi.set(__self__, "ca_chain", ca_chain)
        if cert_metadata is not None:
            pulumi.set(__self__, "cert_metadata", cert_metadata)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if issuer_ref is not None:
            pulumi.set(__self__, "issuer_ref", issuer_ref)
        if issuing_ca is not None:
            pulumi.set(__self__, "issuing_ca", issuing_ca)
        if min_seconds_remaining is not None:
            pulumi.set(__self__, "min_seconds_remaining", min_seconds_remaining)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_format is not None:
            pulumi.set(__self__, "private_key_format", private_key_format)
        if private_key_type is not None:
            pulumi.set(__self__, "private_key_type", private_key_type)
        if renew_pending is not None:
            pulumi.set(__self__, "renew_pending", renew_pending)
        if revoke is not None:
            pulumi.set(__self__, "revoke", revoke)
        if revoke_with_key is not None:
            pulumi.set(__self__, "revoke_with_key", revoke_with_key)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alt_names", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="caChain")
    def ca_chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA chain
        """
        return pulumi.get(self, "ca_chain")

    @ca_chain.setter
    def ca_chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_chain", value)

    @_builtins.property
    @pulumi.getter(name="certMetadata")
    def cert_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        """
        return pulumi.get(self, "cert_metadata")

    @cert_metadata.setter
    def cert_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_metadata", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CN of certificate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The expiration date of the certificate in unix epoch format
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default issuer of this request.
        """
        return pulumi.get(self, "issuer_ref")

    @issuer_ref.setter
    def issuer_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_ref", value)

    @_builtins.property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The issuing CA
        """
        return pulumi.get(self, "issuing_ca")

    @issuing_ca.setter
    def issuing_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuing_ca", value)

    @_builtins.property
    @pulumi.getter(name="minSecondsRemaining")
    def min_seconds_remaining(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        """
        return pulumi.get(self, "min_seconds_remaining")

    @min_seconds_remaining.setter
    def min_seconds_remaining(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_seconds_remaining", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the role to create the certificate against
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_after", value)

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "other_sans", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @private_key_format.setter
    def private_key_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_format", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyType")
    def private_key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key type
        """
        return pulumi.get(self, "private_key_type")

    @private_key_type.setter
    def private_key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_type", value)

    @_builtins.property
    @pulumi.getter(name="renewPending")
    def renew_pending(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        """
        return pulumi.get(self, "renew_pending")

    @renew_pending.setter
    def renew_pending(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "renew_pending", value)

    @_builtins.property
    @pulumi.getter
    def revoke(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the certificate will be revoked on resource destruction using the `revoke` PKI API. Conflicts with `revoke_with_key`. Default `false`.
        """
        return pulumi.get(self, "revoke")

    @revoke.setter
    def revoke(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "revoke", value)

    @_builtins.property
    @pulumi.getter(name="revokeWithKey")
    def revoke_with_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the certificate will be revoked on resource destruction using the `revoke-with-key` PKI API. Conflicts with `revoke`. Default `false`
        """
        return pulumi.get(self, "revoke_with_key")

    @revoke_with_key.setter
    def revoke_with_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "revoke_with_key", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The serial number
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uri_sans", value)

    @_builtins.property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Subject User IDs
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_ids", value)


@pulumi.type_token("vault:pkiSecret/secretBackendCert:SecretBackendCert")
class SecretBackendCert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 revoke: Optional[pulumi.Input[_builtins.bool]] = None,
                 revoke_with_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        app = vault.pkisecret.SecretBackendCert("app",
            backend=intermediate["path"],
            name=test["name"],
            common_name="app.my.domain",
            opts = pulumi.ResourceOptions(depends_on=[admin]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] cert_metadata: A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        :param pulumi.Input[_builtins.str] common_name: CN of certificate to create
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request.
        :param pulumi.Input[_builtins.int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[_builtins.str] name: Name of the role to create the certificate against
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.bool] revoke: If set to `true`, the certificate will be revoked on resource destruction using the `revoke` PKI API. Conflicts with `revoke_with_key`. Default `false`.
        :param pulumi.Input[_builtins.bool] revoke_with_key: If set to `true`, the certificate will be revoked on resource destruction using the `revoke-with-key` PKI API. Conflicts with `revoke`. Default `false`
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_ids: List of Subject User IDs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendCertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        app = vault.pkisecret.SecretBackendCert("app",
            backend=intermediate["path"],
            name=test["name"],
            common_name="app.my.domain",
            opts = pulumi.ResourceOptions(depends_on=[admin]))
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendCertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendCertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 revoke: Optional[pulumi.Input[_builtins.bool]] = None,
                 revoke_with_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendCertArgs.__new__(SecretBackendCertArgs)

            __props__.__dict__["alt_names"] = alt_names
            __props__.__dict__["auto_renew"] = auto_renew
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["cert_metadata"] = cert_metadata
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
            __props__.__dict__["format"] = format
            __props__.__dict__["ip_sans"] = ip_sans
            __props__.__dict__["issuer_ref"] = issuer_ref
            __props__.__dict__["min_seconds_remaining"] = min_seconds_remaining
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["not_after"] = not_after
            __props__.__dict__["other_sans"] = other_sans
            __props__.__dict__["private_key_format"] = private_key_format
            __props__.__dict__["revoke"] = revoke
            __props__.__dict__["revoke_with_key"] = revoke_with_key
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["uri_sans"] = uri_sans
            __props__.__dict__["user_ids"] = user_ids
            __props__.__dict__["ca_chain"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["expiration"] = None
            __props__.__dict__["issuing_ca"] = None
            __props__.__dict__["private_key"] = None
            __props__.__dict__["private_key_type"] = None
            __props__.__dict__["renew_pending"] = None
            __props__.__dict__["serial_number"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretBackendCert, __self__).__init__(
            'vault:pkiSecret/secretBackendCert:SecretBackendCert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            ca_chain: Optional[pulumi.Input[_builtins.str]] = None,
            cert_metadata: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            common_name: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
            expiration: Optional[pulumi.Input[_builtins.int]] = None,
            format: Optional[pulumi.Input[_builtins.str]] = None,
            ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            issuer_ref: Optional[pulumi.Input[_builtins.str]] = None,
            issuing_ca: Optional[pulumi.Input[_builtins.str]] = None,
            min_seconds_remaining: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            not_after: Optional[pulumi.Input[_builtins.str]] = None,
            other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_type: Optional[pulumi.Input[_builtins.str]] = None,
            renew_pending: Optional[pulumi.Input[_builtins.bool]] = None,
            revoke: Optional[pulumi.Input[_builtins.bool]] = None,
            revoke_with_key: Optional[pulumi.Input[_builtins.bool]] = None,
            serial_number: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.str]] = None,
            uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SecretBackendCert':
        """
        Get an existing SecretBackendCert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] ca_chain: The CA chain
        :param pulumi.Input[_builtins.str] cert_metadata: A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        :param pulumi.Input[_builtins.str] certificate: The certificate
        :param pulumi.Input[_builtins.str] common_name: CN of certificate to create
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[_builtins.int] expiration: The expiration date of the certificate in unix epoch format
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_ref: Specifies the default issuer of this request.
        :param pulumi.Input[_builtins.str] issuing_ca: The issuing CA
        :param pulumi.Input[_builtins.int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[_builtins.str] name: Name of the role to create the certificate against
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] private_key: The private key
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] private_key_type: The private key type
        :param pulumi.Input[_builtins.bool] renew_pending: `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        :param pulumi.Input[_builtins.bool] revoke: If set to `true`, the certificate will be revoked on resource destruction using the `revoke` PKI API. Conflicts with `revoke_with_key`. Default `false`.
        :param pulumi.Input[_builtins.bool] revoke_with_key: If set to `true`, the certificate will be revoked on resource destruction using the `revoke-with-key` PKI API. Conflicts with `revoke`. Default `false`
        :param pulumi.Input[_builtins.str] serial_number: The serial number
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_ids: List of Subject User IDs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendCertState.__new__(_SecretBackendCertState)

        __props__.__dict__["alt_names"] = alt_names
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["backend"] = backend
        __props__.__dict__["ca_chain"] = ca_chain
        __props__.__dict__["cert_metadata"] = cert_metadata
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["format"] = format
        __props__.__dict__["ip_sans"] = ip_sans
        __props__.__dict__["issuer_ref"] = issuer_ref
        __props__.__dict__["issuing_ca"] = issuing_ca
        __props__.__dict__["min_seconds_remaining"] = min_seconds_remaining
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["not_after"] = not_after
        __props__.__dict__["other_sans"] = other_sans
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_format"] = private_key_format
        __props__.__dict__["private_key_type"] = private_key_type
        __props__.__dict__["renew_pending"] = renew_pending
        __props__.__dict__["revoke"] = revoke
        __props__.__dict__["revoke_with_key"] = revoke_with_key
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["uri_sans"] = uri_sans
        __props__.__dict__["user_ids"] = user_ids
        return SecretBackendCert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="caChain")
    def ca_chain(self) -> pulumi.Output[_builtins.str]:
        """
        The CA chain
        """
        return pulumi.get(self, "ca_chain")

    @_builtins.property
    @pulumi.getter(name="certMetadata")
    def cert_metadata(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A base 64 encoded value or an empty string to associate with the certificate's serial number. The role's no_store_metadata must be set to false, otherwise an error is returned when specified.
        """
        return pulumi.get(self, "cert_metadata")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[_builtins.str]:
        """
        CN of certificate to create
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[_builtins.int]:
        """
        The expiration date of the certificate in unix epoch format
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @_builtins.property
    @pulumi.getter(name="issuerRef")
    def issuer_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the default issuer of this request.
        """
        return pulumi.get(self, "issuer_ref")

    @_builtins.property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> pulumi.Output[_builtins.str]:
        """
        The issuing CA
        """
        return pulumi.get(self, "issuing_ca")

    @_builtins.property
    @pulumi.getter(name="minSecondsRemaining")
    def min_seconds_remaining(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        """
        return pulumi.get(self, "min_seconds_remaining")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the role to create the certificate against
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @_builtins.property
    @pulumi.getter(name="privateKeyType")
    def private_key_type(self) -> pulumi.Output[_builtins.str]:
        """
        The private key type
        """
        return pulumi.get(self, "private_key_type")

    @_builtins.property
    @pulumi.getter(name="renewPending")
    def renew_pending(self) -> pulumi.Output[_builtins.bool]:
        """
        `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        """
        return pulumi.get(self, "renew_pending")

    @_builtins.property
    @pulumi.getter
    def revoke(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, the certificate will be revoked on resource destruction using the `revoke` PKI API. Conflicts with `revoke_with_key`. Default `false`.
        """
        return pulumi.get(self, "revoke")

    @_builtins.property
    @pulumi.getter(name="revokeWithKey")
    def revoke_with_key(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, the certificate will be revoked on resource destruction using the `revoke-with-key` PKI API. Conflicts with `revoke`. Default `false`
        """
        return pulumi.get(self, "revoke_with_key")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[_builtins.str]:
        """
        The serial number
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @_builtins.property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Subject User IDs
        """
        return pulumi.get(self, "user_ids")

