# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 add_address_to_env: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_login: Optional[pulumi.Input['ProviderAuthLoginArgs']] = None,
                 auth_login_aws: Optional[pulumi.Input['ProviderAuthLoginAwsArgs']] = None,
                 auth_login_azure: Optional[pulumi.Input['ProviderAuthLoginAzureArgs']] = None,
                 auth_login_cert: Optional[pulumi.Input['ProviderAuthLoginCertArgs']] = None,
                 auth_login_gcp: Optional[pulumi.Input['ProviderAuthLoginGcpArgs']] = None,
                 auth_login_jwt: Optional[pulumi.Input['ProviderAuthLoginJwtArgs']] = None,
                 auth_login_kerberos: Optional[pulumi.Input['ProviderAuthLoginKerberosArgs']] = None,
                 auth_login_oci: Optional[pulumi.Input['ProviderAuthLoginOciArgs']] = None,
                 auth_login_oidc: Optional[pulumi.Input['ProviderAuthLoginOidcArgs']] = None,
                 auth_login_radius: Optional[pulumi.Input['ProviderAuthLoginRadiusArgs']] = None,
                 auth_login_token_file: Optional[pulumi.Input['ProviderAuthLoginTokenFileArgs']] = None,
                 auth_login_userpass: Optional[pulumi.Input['ProviderAuthLoginUserpassArgs']] = None,
                 ca_cert_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 client_auth: Optional[pulumi.Input['ProviderClientAuthArgs']] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries_ccc: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 set_namespace_from_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_child_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_get_vault_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_tls_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_version_override: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] address: URL of the root of the target Vault server.
        :param pulumi.Input['ProviderAuthLoginArgs'] auth_login: Login to vault with an existing auth method using auth/<mount>/login
        :param pulumi.Input['ProviderAuthLoginAwsArgs'] auth_login_aws: Login to vault using the AWS method
        :param pulumi.Input['ProviderAuthLoginAzureArgs'] auth_login_azure: Login to vault using the azure method
        :param pulumi.Input['ProviderAuthLoginCertArgs'] auth_login_cert: Login to vault using the cert method
        :param pulumi.Input['ProviderAuthLoginGcpArgs'] auth_login_gcp: Login to vault using the gcp method
        :param pulumi.Input['ProviderAuthLoginJwtArgs'] auth_login_jwt: Login to vault using the jwt method
        :param pulumi.Input['ProviderAuthLoginKerberosArgs'] auth_login_kerberos: Login to vault using the kerberos method
        :param pulumi.Input['ProviderAuthLoginOciArgs'] auth_login_oci: Login to vault using the OCI method
        :param pulumi.Input['ProviderAuthLoginOidcArgs'] auth_login_oidc: Login to vault using the oidc method
        :param pulumi.Input['ProviderAuthLoginRadiusArgs'] auth_login_radius: Login to vault using the radius method
        :param pulumi.Input['ProviderAuthLoginTokenFileArgs'] auth_login_token_file: Login to vault using
        :param pulumi.Input['ProviderAuthLoginUserpassArgs'] auth_login_userpass: Login to vault using the userpass method
        :param pulumi.Input[_builtins.str] ca_cert_dir: Path to directory containing CA certificate files to validate the server's certificate.
        :param pulumi.Input[_builtins.str] ca_cert_file: Path to a CA certificate file to validate the server's certificate.
        :param pulumi.Input['ProviderClientAuthArgs'] client_auth: Client authentication credentials.
        :param pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]] headers: The headers to send with each Vault request.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum TTL for secret leases requested by this provider.
        :param pulumi.Input[_builtins.int] max_retries: Maximum number of retries when a 5xx error code is encountered.
        :param pulumi.Input[_builtins.int] max_retries_ccc: Maximum number of retries for Client Controlled Consistency related operations
        :param pulumi.Input[_builtins.str] namespace: The namespace to use. Available only for Vault Enterprise.
        :param pulumi.Input[_builtins.bool] set_namespace_from_token: In the case where the Vault token is for a specific namespace and the provider namespace is not configured, use the
               token namespace as the root namespace for all resources.
        :param pulumi.Input[_builtins.bool] skip_child_token: Set this to true to prevent the creation of ephemeral child token used by this provider.
        :param pulumi.Input[_builtins.bool] skip_get_vault_version: Skip the dynamic fetching of the Vault server version.
        :param pulumi.Input[_builtins.bool] skip_tls_verify: Set this to true only if the target Vault server is an insecure development instance.
        :param pulumi.Input[_builtins.str] tls_server_name: Name to use as the SNI host when connecting via TLS.
        :param pulumi.Input[_builtins.str] token: Token to use to authenticate to Vault.
        :param pulumi.Input[_builtins.str] token_name: Token name to use for creating the Vault child token.
        :param pulumi.Input[_builtins.str] vault_version_override: Override the Vault server version, which is normally determined dynamically from the target Vault server
        """
        if add_address_to_env is not None:
            pulumi.set(__self__, "add_address_to_env", add_address_to_env)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if auth_login is not None:
            pulumi.set(__self__, "auth_login", auth_login)
        if auth_login_aws is not None:
            pulumi.set(__self__, "auth_login_aws", auth_login_aws)
        if auth_login_azure is not None:
            pulumi.set(__self__, "auth_login_azure", auth_login_azure)
        if auth_login_cert is not None:
            pulumi.set(__self__, "auth_login_cert", auth_login_cert)
        if auth_login_gcp is not None:
            pulumi.set(__self__, "auth_login_gcp", auth_login_gcp)
        if auth_login_jwt is not None:
            pulumi.set(__self__, "auth_login_jwt", auth_login_jwt)
        if auth_login_kerberos is not None:
            pulumi.set(__self__, "auth_login_kerberos", auth_login_kerberos)
        if auth_login_oci is not None:
            pulumi.set(__self__, "auth_login_oci", auth_login_oci)
        if auth_login_oidc is not None:
            pulumi.set(__self__, "auth_login_oidc", auth_login_oidc)
        if auth_login_radius is not None:
            pulumi.set(__self__, "auth_login_radius", auth_login_radius)
        if auth_login_token_file is not None:
            pulumi.set(__self__, "auth_login_token_file", auth_login_token_file)
        if auth_login_userpass is not None:
            pulumi.set(__self__, "auth_login_userpass", auth_login_userpass)
        if ca_cert_dir is not None:
            pulumi.set(__self__, "ca_cert_dir", ca_cert_dir)
        if ca_cert_file is not None:
            pulumi.set(__self__, "ca_cert_file", ca_cert_file)
        if client_auth is not None:
            pulumi.set(__self__, "client_auth", client_auth)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if max_lease_ttl_seconds is None:
            max_lease_ttl_seconds = (_utilities.get_env_int('TERRAFORM_VAULT_MAX_TTL') or 1200)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if max_retries is None:
            max_retries = (_utilities.get_env_int('VAULT_MAX_RETRIES') or 2)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if max_retries_ccc is not None:
            pulumi.set(__self__, "max_retries_ccc", max_retries_ccc)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if set_namespace_from_token is not None:
            pulumi.set(__self__, "set_namespace_from_token", set_namespace_from_token)
        if skip_child_token is not None:
            pulumi.set(__self__, "skip_child_token", skip_child_token)
        if skip_get_vault_version is not None:
            pulumi.set(__self__, "skip_get_vault_version", skip_get_vault_version)
        if skip_tls_verify is None:
            skip_tls_verify = _utilities.get_env_bool('VAULT_SKIP_VERIFY')
        if skip_tls_verify is not None:
            pulumi.set(__self__, "skip_tls_verify", skip_tls_verify)
        if tls_server_name is not None:
            pulumi.set(__self__, "tls_server_name", tls_server_name)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_name is not None:
            pulumi.set(__self__, "token_name", token_name)
        if vault_version_override is not None:
            pulumi.set(__self__, "vault_version_override", vault_version_override)

    @_builtins.property
    @pulumi.getter(name="addAddressToEnv")
    def add_address_to_env(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "add_address_to_env")

    @add_address_to_env.setter
    def add_address_to_env(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "add_address_to_env", value)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the root of the target Vault server.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="authLogin")
    def auth_login(self) -> Optional[pulumi.Input['ProviderAuthLoginArgs']]:
        """
        Login to vault with an existing auth method using auth/<mount>/login
        """
        return pulumi.get(self, "auth_login")

    @auth_login.setter
    def auth_login(self, value: Optional[pulumi.Input['ProviderAuthLoginArgs']]):
        pulumi.set(self, "auth_login", value)

    @_builtins.property
    @pulumi.getter(name="authLoginAws")
    def auth_login_aws(self) -> Optional[pulumi.Input['ProviderAuthLoginAwsArgs']]:
        """
        Login to vault using the AWS method
        """
        return pulumi.get(self, "auth_login_aws")

    @auth_login_aws.setter
    def auth_login_aws(self, value: Optional[pulumi.Input['ProviderAuthLoginAwsArgs']]):
        pulumi.set(self, "auth_login_aws", value)

    @_builtins.property
    @pulumi.getter(name="authLoginAzure")
    def auth_login_azure(self) -> Optional[pulumi.Input['ProviderAuthLoginAzureArgs']]:
        """
        Login to vault using the azure method
        """
        return pulumi.get(self, "auth_login_azure")

    @auth_login_azure.setter
    def auth_login_azure(self, value: Optional[pulumi.Input['ProviderAuthLoginAzureArgs']]):
        pulumi.set(self, "auth_login_azure", value)

    @_builtins.property
    @pulumi.getter(name="authLoginCert")
    def auth_login_cert(self) -> Optional[pulumi.Input['ProviderAuthLoginCertArgs']]:
        """
        Login to vault using the cert method
        """
        return pulumi.get(self, "auth_login_cert")

    @auth_login_cert.setter
    def auth_login_cert(self, value: Optional[pulumi.Input['ProviderAuthLoginCertArgs']]):
        pulumi.set(self, "auth_login_cert", value)

    @_builtins.property
    @pulumi.getter(name="authLoginGcp")
    def auth_login_gcp(self) -> Optional[pulumi.Input['ProviderAuthLoginGcpArgs']]:
        """
        Login to vault using the gcp method
        """
        return pulumi.get(self, "auth_login_gcp")

    @auth_login_gcp.setter
    def auth_login_gcp(self, value: Optional[pulumi.Input['ProviderAuthLoginGcpArgs']]):
        pulumi.set(self, "auth_login_gcp", value)

    @_builtins.property
    @pulumi.getter(name="authLoginJwt")
    def auth_login_jwt(self) -> Optional[pulumi.Input['ProviderAuthLoginJwtArgs']]:
        """
        Login to vault using the jwt method
        """
        return pulumi.get(self, "auth_login_jwt")

    @auth_login_jwt.setter
    def auth_login_jwt(self, value: Optional[pulumi.Input['ProviderAuthLoginJwtArgs']]):
        pulumi.set(self, "auth_login_jwt", value)

    @_builtins.property
    @pulumi.getter(name="authLoginKerberos")
    def auth_login_kerberos(self) -> Optional[pulumi.Input['ProviderAuthLoginKerberosArgs']]:
        """
        Login to vault using the kerberos method
        """
        return pulumi.get(self, "auth_login_kerberos")

    @auth_login_kerberos.setter
    def auth_login_kerberos(self, value: Optional[pulumi.Input['ProviderAuthLoginKerberosArgs']]):
        pulumi.set(self, "auth_login_kerberos", value)

    @_builtins.property
    @pulumi.getter(name="authLoginOci")
    def auth_login_oci(self) -> Optional[pulumi.Input['ProviderAuthLoginOciArgs']]:
        """
        Login to vault using the OCI method
        """
        return pulumi.get(self, "auth_login_oci")

    @auth_login_oci.setter
    def auth_login_oci(self, value: Optional[pulumi.Input['ProviderAuthLoginOciArgs']]):
        pulumi.set(self, "auth_login_oci", value)

    @_builtins.property
    @pulumi.getter(name="authLoginOidc")
    def auth_login_oidc(self) -> Optional[pulumi.Input['ProviderAuthLoginOidcArgs']]:
        """
        Login to vault using the oidc method
        """
        return pulumi.get(self, "auth_login_oidc")

    @auth_login_oidc.setter
    def auth_login_oidc(self, value: Optional[pulumi.Input['ProviderAuthLoginOidcArgs']]):
        pulumi.set(self, "auth_login_oidc", value)

    @_builtins.property
    @pulumi.getter(name="authLoginRadius")
    def auth_login_radius(self) -> Optional[pulumi.Input['ProviderAuthLoginRadiusArgs']]:
        """
        Login to vault using the radius method
        """
        return pulumi.get(self, "auth_login_radius")

    @auth_login_radius.setter
    def auth_login_radius(self, value: Optional[pulumi.Input['ProviderAuthLoginRadiusArgs']]):
        pulumi.set(self, "auth_login_radius", value)

    @_builtins.property
    @pulumi.getter(name="authLoginTokenFile")
    def auth_login_token_file(self) -> Optional[pulumi.Input['ProviderAuthLoginTokenFileArgs']]:
        """
        Login to vault using
        """
        return pulumi.get(self, "auth_login_token_file")

    @auth_login_token_file.setter
    def auth_login_token_file(self, value: Optional[pulumi.Input['ProviderAuthLoginTokenFileArgs']]):
        pulumi.set(self, "auth_login_token_file", value)

    @_builtins.property
    @pulumi.getter(name="authLoginUserpass")
    def auth_login_userpass(self) -> Optional[pulumi.Input['ProviderAuthLoginUserpassArgs']]:
        """
        Login to vault using the userpass method
        """
        return pulumi.get(self, "auth_login_userpass")

    @auth_login_userpass.setter
    def auth_login_userpass(self, value: Optional[pulumi.Input['ProviderAuthLoginUserpassArgs']]):
        pulumi.set(self, "auth_login_userpass", value)

    @_builtins.property
    @pulumi.getter(name="caCertDir")
    def ca_cert_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to directory containing CA certificate files to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_dir")

    @ca_cert_dir.setter
    def ca_cert_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert_dir", value)

    @_builtins.property
    @pulumi.getter(name="caCertFile")
    def ca_cert_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to a CA certificate file to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_file")

    @ca_cert_file.setter
    def ca_cert_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert_file", value)

    @_builtins.property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> Optional[pulumi.Input['ProviderClientAuthArgs']]:
        """
        Client authentication credentials.
        """
        return pulumi.get(self, "client_auth")

    @client_auth.setter
    def client_auth(self, value: Optional[pulumi.Input['ProviderClientAuthArgs']]):
        pulumi.set(self, "client_auth", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]:
        """
        The headers to send with each Vault request.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum TTL for secret leases requested by this provider.
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of retries when a 5xx error code is encountered.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter(name="maxRetriesCcc")
    def max_retries_ccc(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of retries for Client Controlled Consistency related operations
        """
        return pulumi.get(self, "max_retries_ccc")

    @max_retries_ccc.setter
    def max_retries_ccc(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries_ccc", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to use. Available only for Vault Enterprise.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="setNamespaceFromToken")
    def set_namespace_from_token(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        In the case where the Vault token is for a specific namespace and the provider namespace is not configured, use the
        token namespace as the root namespace for all resources.
        """
        return pulumi.get(self, "set_namespace_from_token")

    @set_namespace_from_token.setter
    def set_namespace_from_token(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "set_namespace_from_token", value)

    @_builtins.property
    @pulumi.getter(name="skipChildToken")
    def skip_child_token(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this to true to prevent the creation of ephemeral child token used by this provider.
        """
        return pulumi.get(self, "skip_child_token")

    @skip_child_token.setter
    def skip_child_token(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_child_token", value)

    @_builtins.property
    @pulumi.getter(name="skipGetVaultVersion")
    def skip_get_vault_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip the dynamic fetching of the Vault server version.
        """
        return pulumi.get(self, "skip_get_vault_version")

    @skip_get_vault_version.setter
    def skip_get_vault_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_get_vault_version", value)

    @_builtins.property
    @pulumi.getter(name="skipTlsVerify")
    def skip_tls_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this to true only if the target Vault server is an insecure development instance.
        """
        return pulumi.get(self, "skip_tls_verify")

    @skip_tls_verify.setter
    def skip_tls_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_tls_verify", value)

    @_builtins.property
    @pulumi.getter(name="tlsServerName")
    def tls_server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name to use as the SNI host when connecting via TLS.
        """
        return pulumi.get(self, "tls_server_name")

    @tls_server_name.setter
    def tls_server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_server_name", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token to use to authenticate to Vault.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="tokenName")
    def token_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token name to use for creating the Vault child token.
        """
        return pulumi.get(self, "token_name")

    @token_name.setter
    def token_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_name", value)

    @_builtins.property
    @pulumi.getter(name="vaultVersionOverride")
    def vault_version_override(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Override the Vault server version, which is normally determined dynamically from the target Vault server
        """
        return pulumi.get(self, "vault_version_override")

    @vault_version_override.setter
    def vault_version_override(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_version_override", value)


@pulumi.type_token("pulumi:providers:vault")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_address_to_env: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_login: Optional[pulumi.Input[Union['ProviderAuthLoginArgs', 'ProviderAuthLoginArgsDict']]] = None,
                 auth_login_aws: Optional[pulumi.Input[Union['ProviderAuthLoginAwsArgs', 'ProviderAuthLoginAwsArgsDict']]] = None,
                 auth_login_azure: Optional[pulumi.Input[Union['ProviderAuthLoginAzureArgs', 'ProviderAuthLoginAzureArgsDict']]] = None,
                 auth_login_cert: Optional[pulumi.Input[Union['ProviderAuthLoginCertArgs', 'ProviderAuthLoginCertArgsDict']]] = None,
                 auth_login_gcp: Optional[pulumi.Input[Union['ProviderAuthLoginGcpArgs', 'ProviderAuthLoginGcpArgsDict']]] = None,
                 auth_login_jwt: Optional[pulumi.Input[Union['ProviderAuthLoginJwtArgs', 'ProviderAuthLoginJwtArgsDict']]] = None,
                 auth_login_kerberos: Optional[pulumi.Input[Union['ProviderAuthLoginKerberosArgs', 'ProviderAuthLoginKerberosArgsDict']]] = None,
                 auth_login_oci: Optional[pulumi.Input[Union['ProviderAuthLoginOciArgs', 'ProviderAuthLoginOciArgsDict']]] = None,
                 auth_login_oidc: Optional[pulumi.Input[Union['ProviderAuthLoginOidcArgs', 'ProviderAuthLoginOidcArgsDict']]] = None,
                 auth_login_radius: Optional[pulumi.Input[Union['ProviderAuthLoginRadiusArgs', 'ProviderAuthLoginRadiusArgsDict']]] = None,
                 auth_login_token_file: Optional[pulumi.Input[Union['ProviderAuthLoginTokenFileArgs', 'ProviderAuthLoginTokenFileArgsDict']]] = None,
                 auth_login_userpass: Optional[pulumi.Input[Union['ProviderAuthLoginUserpassArgs', 'ProviderAuthLoginUserpassArgsDict']]] = None,
                 ca_cert_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 client_auth: Optional[pulumi.Input[Union['ProviderClientAuthArgs', 'ProviderClientAuthArgsDict']]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderHeaderArgs', 'ProviderHeaderArgsDict']]]]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries_ccc: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 set_namespace_from_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_child_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_get_vault_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_tls_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_version_override: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the vault package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: URL of the root of the target Vault server.
        :param pulumi.Input[Union['ProviderAuthLoginArgs', 'ProviderAuthLoginArgsDict']] auth_login: Login to vault with an existing auth method using auth/<mount>/login
        :param pulumi.Input[Union['ProviderAuthLoginAwsArgs', 'ProviderAuthLoginAwsArgsDict']] auth_login_aws: Login to vault using the AWS method
        :param pulumi.Input[Union['ProviderAuthLoginAzureArgs', 'ProviderAuthLoginAzureArgsDict']] auth_login_azure: Login to vault using the azure method
        :param pulumi.Input[Union['ProviderAuthLoginCertArgs', 'ProviderAuthLoginCertArgsDict']] auth_login_cert: Login to vault using the cert method
        :param pulumi.Input[Union['ProviderAuthLoginGcpArgs', 'ProviderAuthLoginGcpArgsDict']] auth_login_gcp: Login to vault using the gcp method
        :param pulumi.Input[Union['ProviderAuthLoginJwtArgs', 'ProviderAuthLoginJwtArgsDict']] auth_login_jwt: Login to vault using the jwt method
        :param pulumi.Input[Union['ProviderAuthLoginKerberosArgs', 'ProviderAuthLoginKerberosArgsDict']] auth_login_kerberos: Login to vault using the kerberos method
        :param pulumi.Input[Union['ProviderAuthLoginOciArgs', 'ProviderAuthLoginOciArgsDict']] auth_login_oci: Login to vault using the OCI method
        :param pulumi.Input[Union['ProviderAuthLoginOidcArgs', 'ProviderAuthLoginOidcArgsDict']] auth_login_oidc: Login to vault using the oidc method
        :param pulumi.Input[Union['ProviderAuthLoginRadiusArgs', 'ProviderAuthLoginRadiusArgsDict']] auth_login_radius: Login to vault using the radius method
        :param pulumi.Input[Union['ProviderAuthLoginTokenFileArgs', 'ProviderAuthLoginTokenFileArgsDict']] auth_login_token_file: Login to vault using
        :param pulumi.Input[Union['ProviderAuthLoginUserpassArgs', 'ProviderAuthLoginUserpassArgsDict']] auth_login_userpass: Login to vault using the userpass method
        :param pulumi.Input[_builtins.str] ca_cert_dir: Path to directory containing CA certificate files to validate the server's certificate.
        :param pulumi.Input[_builtins.str] ca_cert_file: Path to a CA certificate file to validate the server's certificate.
        :param pulumi.Input[Union['ProviderClientAuthArgs', 'ProviderClientAuthArgsDict']] client_auth: Client authentication credentials.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProviderHeaderArgs', 'ProviderHeaderArgsDict']]]] headers: The headers to send with each Vault request.
        :param pulumi.Input[_builtins.int] max_lease_ttl_seconds: Maximum TTL for secret leases requested by this provider.
        :param pulumi.Input[_builtins.int] max_retries: Maximum number of retries when a 5xx error code is encountered.
        :param pulumi.Input[_builtins.int] max_retries_ccc: Maximum number of retries for Client Controlled Consistency related operations
        :param pulumi.Input[_builtins.str] namespace: The namespace to use. Available only for Vault Enterprise.
        :param pulumi.Input[_builtins.bool] set_namespace_from_token: In the case where the Vault token is for a specific namespace and the provider namespace is not configured, use the
               token namespace as the root namespace for all resources.
        :param pulumi.Input[_builtins.bool] skip_child_token: Set this to true to prevent the creation of ephemeral child token used by this provider.
        :param pulumi.Input[_builtins.bool] skip_get_vault_version: Skip the dynamic fetching of the Vault server version.
        :param pulumi.Input[_builtins.bool] skip_tls_verify: Set this to true only if the target Vault server is an insecure development instance.
        :param pulumi.Input[_builtins.str] tls_server_name: Name to use as the SNI host when connecting via TLS.
        :param pulumi.Input[_builtins.str] token: Token to use to authenticate to Vault.
        :param pulumi.Input[_builtins.str] token_name: Token name to use for creating the Vault child token.
        :param pulumi.Input[_builtins.str] vault_version_override: Override the Vault server version, which is normally determined dynamically from the target Vault server
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the vault package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_address_to_env: Optional[pulumi.Input[_builtins.str]] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_login: Optional[pulumi.Input[Union['ProviderAuthLoginArgs', 'ProviderAuthLoginArgsDict']]] = None,
                 auth_login_aws: Optional[pulumi.Input[Union['ProviderAuthLoginAwsArgs', 'ProviderAuthLoginAwsArgsDict']]] = None,
                 auth_login_azure: Optional[pulumi.Input[Union['ProviderAuthLoginAzureArgs', 'ProviderAuthLoginAzureArgsDict']]] = None,
                 auth_login_cert: Optional[pulumi.Input[Union['ProviderAuthLoginCertArgs', 'ProviderAuthLoginCertArgsDict']]] = None,
                 auth_login_gcp: Optional[pulumi.Input[Union['ProviderAuthLoginGcpArgs', 'ProviderAuthLoginGcpArgsDict']]] = None,
                 auth_login_jwt: Optional[pulumi.Input[Union['ProviderAuthLoginJwtArgs', 'ProviderAuthLoginJwtArgsDict']]] = None,
                 auth_login_kerberos: Optional[pulumi.Input[Union['ProviderAuthLoginKerberosArgs', 'ProviderAuthLoginKerberosArgsDict']]] = None,
                 auth_login_oci: Optional[pulumi.Input[Union['ProviderAuthLoginOciArgs', 'ProviderAuthLoginOciArgsDict']]] = None,
                 auth_login_oidc: Optional[pulumi.Input[Union['ProviderAuthLoginOidcArgs', 'ProviderAuthLoginOidcArgsDict']]] = None,
                 auth_login_radius: Optional[pulumi.Input[Union['ProviderAuthLoginRadiusArgs', 'ProviderAuthLoginRadiusArgsDict']]] = None,
                 auth_login_token_file: Optional[pulumi.Input[Union['ProviderAuthLoginTokenFileArgs', 'ProviderAuthLoginTokenFileArgsDict']]] = None,
                 auth_login_userpass: Optional[pulumi.Input[Union['ProviderAuthLoginUserpassArgs', 'ProviderAuthLoginUserpassArgsDict']]] = None,
                 ca_cert_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 client_auth: Optional[pulumi.Input[Union['ProviderClientAuthArgs', 'ProviderClientAuthArgsDict']]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderHeaderArgs', 'ProviderHeaderArgsDict']]]]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries_ccc: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 set_namespace_from_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_child_token: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_get_vault_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_tls_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_server_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_version_override: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["add_address_to_env"] = add_address_to_env
            __props__.__dict__["address"] = address
            __props__.__dict__["auth_login"] = pulumi.Output.from_input(auth_login).apply(pulumi.runtime.to_json) if auth_login is not None else None
            __props__.__dict__["auth_login_aws"] = pulumi.Output.from_input(auth_login_aws).apply(pulumi.runtime.to_json) if auth_login_aws is not None else None
            __props__.__dict__["auth_login_azure"] = pulumi.Output.from_input(auth_login_azure).apply(pulumi.runtime.to_json) if auth_login_azure is not None else None
            __props__.__dict__["auth_login_cert"] = pulumi.Output.from_input(auth_login_cert).apply(pulumi.runtime.to_json) if auth_login_cert is not None else None
            __props__.__dict__["auth_login_gcp"] = pulumi.Output.from_input(auth_login_gcp).apply(pulumi.runtime.to_json) if auth_login_gcp is not None else None
            __props__.__dict__["auth_login_jwt"] = pulumi.Output.from_input(auth_login_jwt).apply(pulumi.runtime.to_json) if auth_login_jwt is not None else None
            __props__.__dict__["auth_login_kerberos"] = pulumi.Output.from_input(auth_login_kerberos).apply(pulumi.runtime.to_json) if auth_login_kerberos is not None else None
            __props__.__dict__["auth_login_oci"] = pulumi.Output.from_input(auth_login_oci).apply(pulumi.runtime.to_json) if auth_login_oci is not None else None
            __props__.__dict__["auth_login_oidc"] = pulumi.Output.from_input(auth_login_oidc).apply(pulumi.runtime.to_json) if auth_login_oidc is not None else None
            __props__.__dict__["auth_login_radius"] = pulumi.Output.from_input(auth_login_radius).apply(pulumi.runtime.to_json) if auth_login_radius is not None else None
            __props__.__dict__["auth_login_token_file"] = pulumi.Output.from_input(auth_login_token_file).apply(pulumi.runtime.to_json) if auth_login_token_file is not None else None
            __props__.__dict__["auth_login_userpass"] = pulumi.Output.from_input(auth_login_userpass).apply(pulumi.runtime.to_json) if auth_login_userpass is not None else None
            __props__.__dict__["ca_cert_dir"] = ca_cert_dir
            __props__.__dict__["ca_cert_file"] = ca_cert_file
            __props__.__dict__["client_auth"] = pulumi.Output.from_input(client_auth).apply(pulumi.runtime.to_json) if client_auth is not None else None
            __props__.__dict__["headers"] = pulumi.Output.from_input(headers).apply(pulumi.runtime.to_json) if headers is not None else None
            if max_lease_ttl_seconds is None:
                max_lease_ttl_seconds = (_utilities.get_env_int('TERRAFORM_VAULT_MAX_TTL') or 1200)
            __props__.__dict__["max_lease_ttl_seconds"] = pulumi.Output.from_input(max_lease_ttl_seconds).apply(pulumi.runtime.to_json) if max_lease_ttl_seconds is not None else None
            if max_retries is None:
                max_retries = (_utilities.get_env_int('VAULT_MAX_RETRIES') or 2)
            __props__.__dict__["max_retries"] = pulumi.Output.from_input(max_retries).apply(pulumi.runtime.to_json) if max_retries is not None else None
            __props__.__dict__["max_retries_ccc"] = pulumi.Output.from_input(max_retries_ccc).apply(pulumi.runtime.to_json) if max_retries_ccc is not None else None
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["set_namespace_from_token"] = pulumi.Output.from_input(set_namespace_from_token).apply(pulumi.runtime.to_json) if set_namespace_from_token is not None else None
            __props__.__dict__["skip_child_token"] = pulumi.Output.from_input(skip_child_token).apply(pulumi.runtime.to_json) if skip_child_token is not None else None
            __props__.__dict__["skip_get_vault_version"] = pulumi.Output.from_input(skip_get_vault_version).apply(pulumi.runtime.to_json) if skip_get_vault_version is not None else None
            if skip_tls_verify is None:
                skip_tls_verify = _utilities.get_env_bool('VAULT_SKIP_VERIFY')
            __props__.__dict__["skip_tls_verify"] = pulumi.Output.from_input(skip_tls_verify).apply(pulumi.runtime.to_json) if skip_tls_verify is not None else None
            __props__.__dict__["tls_server_name"] = tls_server_name
            __props__.__dict__["token"] = token
            __props__.__dict__["token_name"] = token_name
            __props__.__dict__["vault_version_override"] = vault_version_override
        super(Provider, __self__).__init__(
            'vault',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="addAddressToEnv")
    def add_address_to_env(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "add_address_to_env")

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL of the root of the target Vault server.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="caCertDir")
    def ca_cert_dir(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to directory containing CA certificate files to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_dir")

    @_builtins.property
    @pulumi.getter(name="caCertFile")
    def ca_cert_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to a CA certificate file to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_file")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to use. Available only for Vault Enterprise.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="tlsServerName")
    def tls_server_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name to use as the SNI host when connecting via TLS.
        """
        return pulumi.get(self, "tls_server_name")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Token to use to authenticate to Vault.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="tokenName")
    def token_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Token name to use for creating the Vault child token.
        """
        return pulumi.get(self, "token_name")

    @_builtins.property
    @pulumi.getter(name="vaultVersionOverride")
    def vault_version_override(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Override the Vault server version, which is normally determined dynamically from the target Vault server
        """
        return pulumi.get(self, "vault_version_override")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:vault/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

