import abc
import datetime
import enum
import typing

import jsii
import jsii.compat
import publication

from jsii.python import classproperty
__jsii_assembly__ = jsii.JSIIAssembly.load("@aws-cdk/cx-api", "0.38.0", __name__, "cx-api@0.38.0.jsii.tgz")
@jsii.data_type(jsii_type="@aws-cdk/cx-api.ArtifactManifest", jsii_struct_bases=[], name_mapping={'environment': 'environment', 'type': 'type', 'dependencies': 'dependencies', 'metadata': 'metadata', 'properties': 'properties'})
class ArtifactManifest():
    def __init__(self, *, environment: str, type: "ArtifactType", dependencies: typing.Optional[typing.List[str]]=None, metadata: typing.Optional[typing.Mapping[str,typing.List["MetadataEntry"]]]=None, properties: typing.Optional[typing.Mapping[str,typing.Any]]=None):
        """A manifest for a single artifact within the cloud assembly.

        :param environment: The environment into which this artifact is deployed.
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact.
        :param metadata: Associated metadata.
        :param properties: The set of properties for this artifact (depends on type).

        stability
        :stability: experimental
        """
        self._values = {
            'environment': environment,
            'type': type,
        }
        if dependencies is not None: self._values["dependencies"] = dependencies
        if metadata is not None: self._values["metadata"] = metadata
        if properties is not None: self._values["properties"] = properties

    @property
    def environment(self) -> str:
        """The environment into which this artifact is deployed.

        stability
        :stability: experimental
        """
        return self._values.get('environment')

    @property
    def type(self) -> "ArtifactType":
        """The type of artifact.

        stability
        :stability: experimental
        """
        return self._values.get('type')

    @property
    def dependencies(self) -> typing.Optional[typing.List[str]]:
        """IDs of artifacts that must be deployed before this artifact.

        stability
        :stability: experimental
        """
        return self._values.get('dependencies')

    @property
    def metadata(self) -> typing.Optional[typing.Mapping[str,typing.List["MetadataEntry"]]]:
        """Associated metadata.

        stability
        :stability: experimental
        """
        return self._values.get('metadata')

    @property
    def properties(self) -> typing.Optional[typing.Mapping[str,typing.Any]]:
        """The set of properties for this artifact (depends on type).

        stability
        :stability: experimental
        """
        return self._values.get('properties')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'ArtifactManifest(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.enum(jsii_type="@aws-cdk/cx-api.ArtifactType")
class ArtifactType(enum.Enum):
    """Type of cloud artifact.

    stability
    :stability: experimental
    """
    NONE = "NONE"
    """
    stability
    :stability: experimental
    """
    AWS_CLOUDFORMATION_STACK = "AWS_CLOUDFORMATION_STACK"
    """The artifact is an AWS CloudFormation stack.

    stability
    :stability: experimental
    """

@jsii.data_type(jsii_type="@aws-cdk/cx-api.AssemblyBuildOptions", jsii_struct_bases=[], name_mapping={'runtime_info': 'runtimeInfo'})
class AssemblyBuildOptions():
    def __init__(self, *, runtime_info: typing.Optional["RuntimeInfo"]=None):
        """
        :param runtime_info: Include the specified runtime information (module versions) in manifest. Default: - if this option is not specified, runtime info will not be included

        stability
        :stability: experimental
        """
        self._values = {
        }
        if runtime_info is not None: self._values["runtime_info"] = runtime_info

    @property
    def runtime_info(self) -> typing.Optional["RuntimeInfo"]:
        """Include the specified runtime information (module versions) in manifest.

        default
        :default: - if this option is not specified, runtime info will not be included

        stability
        :stability: experimental
        """
        return self._values.get('runtime_info')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AssemblyBuildOptions(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.AssemblyManifest", jsii_struct_bases=[], name_mapping={'version': 'version', 'artifacts': 'artifacts', 'missing': 'missing', 'runtime': 'runtime'})
class AssemblyManifest():
    def __init__(self, *, version: str, artifacts: typing.Optional[typing.Mapping[str,"ArtifactManifest"]]=None, missing: typing.Optional[typing.List["MissingContext"]]=None, runtime: typing.Optional["RuntimeInfo"]=None):
        """A manifest which describes the cloud assembly.

        :param version: Protocol version.
        :param artifacts: The set of artifacts in this assembly.
        :param missing: Missing context information. If this field has values, it means that the cloud assembly is not complete and should not be deployed.
        :param runtime: Runtime information.

        stability
        :stability: experimental
        """
        self._values = {
            'version': version,
        }
        if artifacts is not None: self._values["artifacts"] = artifacts
        if missing is not None: self._values["missing"] = missing
        if runtime is not None: self._values["runtime"] = runtime

    @property
    def version(self) -> str:
        """Protocol version.

        stability
        :stability: experimental
        """
        return self._values.get('version')

    @property
    def artifacts(self) -> typing.Optional[typing.Mapping[str,"ArtifactManifest"]]:
        """The set of artifacts in this assembly.

        stability
        :stability: experimental
        """
        return self._values.get('artifacts')

    @property
    def missing(self) -> typing.Optional[typing.List["MissingContext"]]:
        """Missing context information.

        If this field has values, it means that the
        cloud assembly is not complete and should not be deployed.

        stability
        :stability: experimental
        """
        return self._values.get('missing')

    @property
    def runtime(self) -> typing.Optional["RuntimeInfo"]:
        """Runtime information.

        stability
        :stability: experimental
        """
        return self._values.get('runtime')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AssemblyManifest(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.AvailabilityZonesContextQuery", jsii_struct_bases=[], name_mapping={'account': 'account', 'region': 'region'})
class AvailabilityZonesContextQuery():
    def __init__(self, *, account: typing.Optional[str]=None, region: typing.Optional[str]=None):
        """Query to hosted zone context provider.

        :param account: Query account.
        :param region: Query region.

        stability
        :stability: experimental
        """
        self._values = {
        }
        if account is not None: self._values["account"] = account
        if region is not None: self._values["region"] = region

    @property
    def account(self) -> typing.Optional[str]:
        """Query account.

        stability
        :stability: experimental
        """
        return self._values.get('account')

    @property
    def region(self) -> typing.Optional[str]:
        """Query region.

        stability
        :stability: experimental
        """
        return self._values.get('region')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AvailabilityZonesContextQuery(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.AwsCloudFormationStackProperties", jsii_struct_bases=[], name_mapping={'template_file': 'templateFile', 'parameters': 'parameters'})
class AwsCloudFormationStackProperties():
    def __init__(self, *, template_file: str, parameters: typing.Optional[typing.Mapping[str,str]]=None):
        """Artifact properties for CloudFormation stacks.

        :param template_file: A file relative to the assembly root which contains the CloudFormation template for this stack.
        :param parameters: Values for CloudFormation stack parameters that should be passed when the stack is deployed.

        stability
        :stability: experimental
        """
        self._values = {
            'template_file': template_file,
        }
        if parameters is not None: self._values["parameters"] = parameters

    @property
    def template_file(self) -> str:
        """A file relative to the assembly root which contains the CloudFormation template for this stack.

        stability
        :stability: experimental
        """
        return self._values.get('template_file')

    @property
    def parameters(self) -> typing.Optional[typing.Mapping[str,str]]:
        """Values for CloudFormation stack parameters that should be passed when the stack is deployed.

        stability
        :stability: experimental
        """
        return self._values.get('parameters')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AwsCloudFormationStackProperties(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudArtifact(metaclass=jsii.JSIIMeta, jsii_type="@aws-cdk/cx-api.CloudArtifact"):
    """Represents an artifact within a cloud assembly.

    stability
    :stability: experimental
    """
    def __init__(self, assembly: "CloudAssembly", id: str, *, environment: str, type: "ArtifactType", dependencies: typing.Optional[typing.List[str]]=None, metadata: typing.Optional[typing.Mapping[str,typing.List["MetadataEntry"]]]=None, properties: typing.Optional[typing.Mapping[str,typing.Any]]=None) -> None:
        """
        :param assembly: -
        :param id: -
        :param manifest: -
        :param environment: The environment into which this artifact is deployed.
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact.
        :param metadata: Associated metadata.
        :param properties: The set of properties for this artifact (depends on type).

        stability
        :stability: experimental
        """
        manifest = ArtifactManifest(environment=environment, type=type, dependencies=dependencies, metadata=metadata, properties=properties)

        jsii.create(CloudArtifact, self, [assembly, id, manifest])

    @jsii.member(jsii_name="from")
    @classmethod
    def from_(cls, assembly: "CloudAssembly", id: str, *, environment: str, type: "ArtifactType", dependencies: typing.Optional[typing.List[str]]=None, metadata: typing.Optional[typing.Mapping[str,typing.List["MetadataEntry"]]]=None, properties: typing.Optional[typing.Mapping[str,typing.Any]]=None) -> "CloudArtifact":
        """Returns a subclass of ``CloudArtifact`` based on the artifact type defined in the artifact manifest.

        :param assembly: The cloud assembly from which to load the artifact.
        :param id: The artifact ID.
        :param artifact: The artifact manifest.
        :param environment: The environment into which this artifact is deployed.
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact.
        :param metadata: Associated metadata.
        :param properties: The set of properties for this artifact (depends on type).

        stability
        :stability: experimental
        """
        artifact = ArtifactManifest(environment=environment, type=type, dependencies=dependencies, metadata=metadata, properties=properties)

        return jsii.sinvoke(cls, "from", [assembly, id, artifact])

    @jsii.member(jsii_name="findMetadataByType")
    def find_metadata_by_type(self, type: str) -> typing.List["MetadataEntryResult"]:
        """
        :param type: -

        return
        :return: all the metadata entries of a specific type in this artifact.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "findMetadataByType", [type])

    @property
    @jsii.member(jsii_name="assembly")
    def assembly(self) -> "CloudAssembly":
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "assembly")

    @property
    @jsii.member(jsii_name="dependencies")
    def dependencies(self) -> typing.List["CloudArtifact"]:
        """Returns all the artifacts that this artifact depends on.

        stability
        :stability: experimental
        """
        return jsii.get(self, "dependencies")

    @property
    @jsii.member(jsii_name="environment")
    def environment(self) -> "Environment":
        """The environment into which to deploy this artifact.

        stability
        :stability: experimental
        """
        return jsii.get(self, "environment")

    @property
    @jsii.member(jsii_name="id")
    def id(self) -> str:
        """
        stability
        :stability: experimental
        """
        return jsii.get(self, "id")

    @property
    @jsii.member(jsii_name="manifest")
    def manifest(self) -> "ArtifactManifest":
        """The artifact's manifest.

        stability
        :stability: experimental
        """
        return jsii.get(self, "manifest")

    @property
    @jsii.member(jsii_name="messages")
    def messages(self) -> typing.List["SynthesisMessage"]:
        """The set of messages extracted from the artifact's metadata.

        stability
        :stability: experimental
        """
        return jsii.get(self, "messages")


class CloudAssembly(metaclass=jsii.JSIIMeta, jsii_type="@aws-cdk/cx-api.CloudAssembly"):
    """Represents a deployable cloud application.

    stability
    :stability: experimental
    """
    def __init__(self, directory: str) -> None:
        """Reads a cloud assembly from the specified directory.

        :param directory: The root directory of the assembly.

        stability
        :stability: experimental
        """
        jsii.create(CloudAssembly, self, [directory])

    @jsii.member(jsii_name="getStack")
    def get_stack(self, stack_name: str) -> "CloudFormationStackArtifact":
        """Returns a CloudFormation stack artifact from this assembly.

        :param stack_name: the name of the CloudFormation stack.

        return
        :return: a ``CloudFormationStackArtifact`` object.

        stability
        :stability: experimental
        throws:
        :throws:: if there is no stack artifact by that name
        """
        return jsii.invoke(self, "getStack", [stack_name])

    @jsii.member(jsii_name="tryGetArtifact")
    def try_get_artifact(self, id: str) -> typing.Optional["CloudArtifact"]:
        """Attempts to find an artifact with a specific identity.

        :param id: The artifact ID.

        return
        :return: A ``CloudArtifact`` object or ``undefined`` if the artifact does not exist in this assembly.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "tryGetArtifact", [id])

    @property
    @jsii.member(jsii_name="artifacts")
    def artifacts(self) -> typing.List["CloudArtifact"]:
        """All artifacts included in this assembly.

        stability
        :stability: experimental
        """
        return jsii.get(self, "artifacts")

    @property
    @jsii.member(jsii_name="directory")
    def directory(self) -> str:
        """The root directory of the cloud assembly.

        stability
        :stability: experimental
        """
        return jsii.get(self, "directory")

    @property
    @jsii.member(jsii_name="manifest")
    def manifest(self) -> "AssemblyManifest":
        """The raw assembly manifest.

        stability
        :stability: experimental
        """
        return jsii.get(self, "manifest")

    @property
    @jsii.member(jsii_name="runtime")
    def runtime(self) -> "RuntimeInfo":
        """Runtime information such as module versions used to synthesize this assembly.

        stability
        :stability: experimental
        """
        return jsii.get(self, "runtime")

    @property
    @jsii.member(jsii_name="stacks")
    def stacks(self) -> typing.List["CloudFormationStackArtifact"]:
        """
        return
        :return: all the CloudFormation stack artifacts that are included in this assembly.

        stability
        :stability: experimental
        """
        return jsii.get(self, "stacks")

    @property
    @jsii.member(jsii_name="version")
    def version(self) -> str:
        """The schema version of the assembly manifest.

        stability
        :stability: experimental
        """
        return jsii.get(self, "version")


class CloudAssemblyBuilder(metaclass=jsii.JSIIMeta, jsii_type="@aws-cdk/cx-api.CloudAssemblyBuilder"):
    """Can be used to build a cloud assembly.

    stability
    :stability: experimental
    """
    def __init__(self, outdir: typing.Optional[str]=None) -> None:
        """Initializes a cloud assembly builder.

        :param outdir: The output directory, uses temporary directory if undefined.

        stability
        :stability: experimental
        """
        jsii.create(CloudAssemblyBuilder, self, [outdir])

    @jsii.member(jsii_name="addArtifact")
    def add_artifact(self, id: str, *, environment: str, type: "ArtifactType", dependencies: typing.Optional[typing.List[str]]=None, metadata: typing.Optional[typing.Mapping[str,typing.List["MetadataEntry"]]]=None, properties: typing.Optional[typing.Mapping[str,typing.Any]]=None) -> None:
        """Adds an artifact into the cloud assembly.

        :param id: The ID of the artifact.
        :param manifest: The artifact manifest.
        :param environment: The environment into which this artifact is deployed.
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact.
        :param metadata: Associated metadata.
        :param properties: The set of properties for this artifact (depends on type).

        stability
        :stability: experimental
        """
        manifest = ArtifactManifest(environment=environment, type=type, dependencies=dependencies, metadata=metadata, properties=properties)

        return jsii.invoke(self, "addArtifact", [id, manifest])

    @jsii.member(jsii_name="addMissing")
    def add_missing(self, *, key: str, props: typing.Mapping[str,typing.Any], provider: str) -> None:
        """Reports that some context is missing in order for this cloud assembly to be fully synthesized.

        :param missing: Missing context information.
        :param key: The missing context key.
        :param props: A set of provider-specific options.
        :param provider: The provider from which we expect this context key to be obtained.

        stability
        :stability: experimental
        """
        missing = MissingContext(key=key, props=props, provider=provider)

        return jsii.invoke(self, "addMissing", [missing])

    @jsii.member(jsii_name="build")
    def build(self, *, runtime_info: typing.Optional["RuntimeInfo"]=None) -> "CloudAssembly":
        """Finalizes the cloud assembly into the output directory returns a ``CloudAssembly`` object that can be used to inspect the assembly.

        :param options: -
        :param runtime_info: Include the specified runtime information (module versions) in manifest. Default: - if this option is not specified, runtime info will not be included

        stability
        :stability: experimental
        """
        options = AssemblyBuildOptions(runtime_info=runtime_info)

        return jsii.invoke(self, "build", [options])

    @property
    @jsii.member(jsii_name="outdir")
    def outdir(self) -> str:
        """The root directory of the resulting cloud assembly.

        stability
        :stability: experimental
        """
        return jsii.get(self, "outdir")


class CloudFormationStackArtifact(CloudArtifact, metaclass=jsii.JSIIMeta, jsii_type="@aws-cdk/cx-api.CloudFormationStackArtifact"):
    """
    stability
    :stability: experimental
    """
    def __init__(self, assembly: "CloudAssembly", name: str, *, environment: str, type: "ArtifactType", dependencies: typing.Optional[typing.List[str]]=None, metadata: typing.Optional[typing.Mapping[str,typing.List["MetadataEntry"]]]=None, properties: typing.Optional[typing.Mapping[str,typing.Any]]=None) -> None:
        """
        :param assembly: -
        :param name: -
        :param artifact: -
        :param environment: The environment into which this artifact is deployed.
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact.
        :param metadata: Associated metadata.
        :param properties: The set of properties for this artifact (depends on type).

        stability
        :stability: experimental
        """
        artifact = ArtifactManifest(environment=environment, type=type, dependencies=dependencies, metadata=metadata, properties=properties)

        jsii.create(CloudFormationStackArtifact, self, [assembly, name, artifact])

    @property
    @jsii.member(jsii_name="assets")
    def assets(self) -> typing.List[typing.Union["FileAssetMetadataEntry", "ContainerImageAssetMetadataEntry"]]:
        """Any assets associated with this stack.

        stability
        :stability: experimental
        """
        return jsii.get(self, "assets")

    @property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        """The name of this stack.

        stability
        :stability: experimental
        """
        return jsii.get(self, "name")

    @property
    @jsii.member(jsii_name="originalName")
    def original_name(self) -> str:
        """The original name as defined in the CDK app.

        stability
        :stability: experimental
        """
        return jsii.get(self, "originalName")

    @property
    @jsii.member(jsii_name="parameters")
    def parameters(self) -> typing.Mapping[str,str]:
        """CloudFormation parameters to pass to the stack.

        stability
        :stability: experimental
        """
        return jsii.get(self, "parameters")

    @property
    @jsii.member(jsii_name="template")
    def template(self) -> typing.Any:
        """The CloudFormation template for this stack.

        stability
        :stability: experimental
        """
        return jsii.get(self, "template")

    @property
    @jsii.member(jsii_name="templateFile")
    def template_file(self) -> str:
        """The file name of the template.

        stability
        :stability: experimental
        """
        return jsii.get(self, "templateFile")


@jsii.data_type(jsii_type="@aws-cdk/cx-api.ContainerImageAssetMetadataEntry", jsii_struct_bases=[], name_mapping={'id': 'id', 'image_name_parameter': 'imageNameParameter', 'packaging': 'packaging', 'path': 'path', 'source_hash': 'sourceHash', 'build_args': 'buildArgs', 'repository_name': 'repositoryName'})
class ContainerImageAssetMetadataEntry():
    def __init__(self, *, id: str, image_name_parameter: str, packaging: str, path: str, source_hash: str, build_args: typing.Optional[typing.Mapping[str,str]]=None, repository_name: typing.Optional[str]=None):
        """
        :param id: Logical identifier for the asset.
        :param image_name_parameter: ECR Repository name and repo digest (separated by "@sha256:") where this image is stored.
        :param packaging: Type of asset.
        :param path: Path on disk to the asset.
        :param source_hash: The hash of the source directory used to build the asset.
        :param build_args: Build args to pass to the ``docker build`` command. Default: no build args are passed
        :param repository_name: ECR repository name, if omitted a default name based on the asset's ID is used instead. Specify this property if you need to statically address the image, e.g. from a Kubernetes Pod. Note, this is only the repository name, without the registry and the tag parts. Default: automatically derived from the asset's ID.

        stability
        :stability: experimental
        """
        self._values = {
            'id': id,
            'image_name_parameter': image_name_parameter,
            'packaging': packaging,
            'path': path,
            'source_hash': source_hash,
        }
        if build_args is not None: self._values["build_args"] = build_args
        if repository_name is not None: self._values["repository_name"] = repository_name

    @property
    def id(self) -> str:
        """Logical identifier for the asset.

        stability
        :stability: experimental
        """
        return self._values.get('id')

    @property
    def image_name_parameter(self) -> str:
        """ECR Repository name and repo digest (separated by "@sha256:") where this image is stored.

        stability
        :stability: experimental
        """
        return self._values.get('image_name_parameter')

    @property
    def packaging(self) -> str:
        """Type of asset.

        stability
        :stability: experimental
        """
        return self._values.get('packaging')

    @property
    def path(self) -> str:
        """Path on disk to the asset.

        stability
        :stability: experimental
        """
        return self._values.get('path')

    @property
    def source_hash(self) -> str:
        """The hash of the source directory used to build the asset.

        stability
        :stability: experimental
        """
        return self._values.get('source_hash')

    @property
    def build_args(self) -> typing.Optional[typing.Mapping[str,str]]:
        """Build args to pass to the ``docker build`` command.

        default
        :default: no build args are passed

        stability
        :stability: experimental
        """
        return self._values.get('build_args')

    @property
    def repository_name(self) -> typing.Optional[str]:
        """ECR repository name, if omitted a default name based on the asset's ID is used instead.

        Specify this property if you need to statically
        address the image, e.g. from a Kubernetes Pod.
        Note, this is only the repository name, without the registry and
        the tag parts.

        default
        :default: automatically derived from the asset's ID.

        stability
        :stability: experimental
        """
        return self._values.get('repository_name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'ContainerImageAssetMetadataEntry(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.Environment", jsii_struct_bases=[], name_mapping={'account': 'account', 'name': 'name', 'region': 'region'})
class Environment():
    def __init__(self, *, account: str, name: str, region: str):
        """Models an AWS execution environment, for use within the CDK toolkit.

        :param account: The AWS account this environment deploys into.
        :param name: The arbitrary name of this environment (user-set, or at least user-meaningful).
        :param region: The AWS region name where this environment deploys into.

        stability
        :stability: experimental
        """
        self._values = {
            'account': account,
            'name': name,
            'region': region,
        }

    @property
    def account(self) -> str:
        """The AWS account this environment deploys into.

        stability
        :stability: experimental
        """
        return self._values.get('account')

    @property
    def name(self) -> str:
        """The arbitrary name of this environment (user-set, or at least user-meaningful).

        stability
        :stability: experimental
        """
        return self._values.get('name')

    @property
    def region(self) -> str:
        """The AWS region name where this environment deploys into.

        stability
        :stability: experimental
        """
        return self._values.get('region')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'Environment(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class EnvironmentUtils(metaclass=jsii.JSIIMeta, jsii_type="@aws-cdk/cx-api.EnvironmentUtils"):
    """
    stability
    :stability: experimental
    """
    def __init__(self) -> None:
        jsii.create(EnvironmentUtils, self, [])

    @jsii.member(jsii_name="format")
    @classmethod
    def format(cls, account: str, region: str) -> str:
        """
        :param account: -
        :param region: -

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "format", [account, region])

    @jsii.member(jsii_name="parse")
    @classmethod
    def parse(cls, environment: str) -> "Environment":
        """
        :param environment: -

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "parse", [environment])


@jsii.data_type(jsii_type="@aws-cdk/cx-api.FileAssetMetadataEntry", jsii_struct_bases=[], name_mapping={'artifact_hash_parameter': 'artifactHashParameter', 'id': 'id', 'packaging': 'packaging', 'path': 'path', 's3_bucket_parameter': 's3BucketParameter', 's3_key_parameter': 's3KeyParameter', 'source_hash': 'sourceHash'})
class FileAssetMetadataEntry():
    def __init__(self, *, artifact_hash_parameter: str, id: str, packaging: str, path: str, s3_bucket_parameter: str, s3_key_parameter: str, source_hash: str):
        """
        :param artifact_hash_parameter: The name of the parameter where the hash of the bundled asset should be passed in.
        :param id: Logical identifier for the asset.
        :param packaging: Requested packaging style.
        :param path: Path on disk to the asset.
        :param s3_bucket_parameter: Name of parameter where S3 bucket should be passed in.
        :param s3_key_parameter: Name of parameter where S3 key should be passed in.
        :param source_hash: The hash of the source directory used to build the asset.

        stability
        :stability: experimental
        """
        self._values = {
            'artifact_hash_parameter': artifact_hash_parameter,
            'id': id,
            'packaging': packaging,
            'path': path,
            's3_bucket_parameter': s3_bucket_parameter,
            's3_key_parameter': s3_key_parameter,
            'source_hash': source_hash,
        }

    @property
    def artifact_hash_parameter(self) -> str:
        """The name of the parameter where the hash of the bundled asset should be passed in.

        stability
        :stability: experimental
        """
        return self._values.get('artifact_hash_parameter')

    @property
    def id(self) -> str:
        """Logical identifier for the asset.

        stability
        :stability: experimental
        """
        return self._values.get('id')

    @property
    def packaging(self) -> str:
        """Requested packaging style.

        stability
        :stability: experimental
        """
        return self._values.get('packaging')

    @property
    def path(self) -> str:
        """Path on disk to the asset.

        stability
        :stability: experimental
        """
        return self._values.get('path')

    @property
    def s3_bucket_parameter(self) -> str:
        """Name of parameter where S3 bucket should be passed in.

        stability
        :stability: experimental
        """
        return self._values.get('s3_bucket_parameter')

    @property
    def s3_key_parameter(self) -> str:
        """Name of parameter where S3 key should be passed in.

        stability
        :stability: experimental
        """
        return self._values.get('s3_key_parameter')

    @property
    def source_hash(self) -> str:
        """The hash of the source directory used to build the asset.

        stability
        :stability: experimental
        """
        return self._values.get('source_hash')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'FileAssetMetadataEntry(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.HostedZoneContextQuery", jsii_struct_bases=[], name_mapping={'domain_name': 'domainName', 'account': 'account', 'private_zone': 'privateZone', 'region': 'region', 'vpc_id': 'vpcId'})
class HostedZoneContextQuery():
    def __init__(self, *, domain_name: str, account: typing.Optional[str]=None, private_zone: typing.Optional[bool]=None, region: typing.Optional[str]=None, vpc_id: typing.Optional[str]=None):
        """Query to hosted zone context provider.

        :param domain_name: The domain name e.g. example.com to lookup.
        :param account: Query account.
        :param private_zone: True if the zone you want to find is a private hosted zone.
        :param region: Query region.
        :param vpc_id: The VPC ID to that the private zone must be associated with. If you provide VPC ID and privateZone is false, this will return no results and raise an error.

        stability
        :stability: experimental
        """
        self._values = {
            'domain_name': domain_name,
        }
        if account is not None: self._values["account"] = account
        if private_zone is not None: self._values["private_zone"] = private_zone
        if region is not None: self._values["region"] = region
        if vpc_id is not None: self._values["vpc_id"] = vpc_id

    @property
    def domain_name(self) -> str:
        """The domain name e.g. example.com to lookup.

        stability
        :stability: experimental
        """
        return self._values.get('domain_name')

    @property
    def account(self) -> typing.Optional[str]:
        """Query account.

        stability
        :stability: experimental
        """
        return self._values.get('account')

    @property
    def private_zone(self) -> typing.Optional[bool]:
        """True if the zone you want to find is a private hosted zone.

        stability
        :stability: experimental
        """
        return self._values.get('private_zone')

    @property
    def region(self) -> typing.Optional[str]:
        """Query region.

        stability
        :stability: experimental
        """
        return self._values.get('region')

    @property
    def vpc_id(self) -> typing.Optional[str]:
        """The VPC ID to that the private zone must be associated with.

        If you provide VPC ID and privateZone is false, this will return no results
        and raise an error.

        stability
        :stability: experimental
        """
        return self._values.get('vpc_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'HostedZoneContextQuery(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.MetadataEntry", jsii_struct_bases=[], name_mapping={'type': 'type', 'data': 'data', 'trace': 'trace'})
class MetadataEntry():
    def __init__(self, *, type: str, data: typing.Any=None, trace: typing.Optional[typing.List[str]]=None):
        """An metadata entry in the construct.

        :param type: The type of the metadata entry.
        :param data: The data.
        :param trace: A stack trace for when the entry was created.

        stability
        :stability: experimental
        """
        self._values = {
            'type': type,
        }
        if data is not None: self._values["data"] = data
        if trace is not None: self._values["trace"] = trace

    @property
    def type(self) -> str:
        """The type of the metadata entry.

        stability
        :stability: experimental
        """
        return self._values.get('type')

    @property
    def data(self) -> typing.Any:
        """The data.

        stability
        :stability: experimental
        """
        return self._values.get('data')

    @property
    def trace(self) -> typing.Optional[typing.List[str]]:
        """A stack trace for when the entry was created.

        stability
        :stability: experimental
        """
        return self._values.get('trace')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'MetadataEntry(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.MetadataEntryResult", jsii_struct_bases=[MetadataEntry], name_mapping={'type': 'type', 'data': 'data', 'trace': 'trace', 'path': 'path'})
class MetadataEntryResult(MetadataEntry):
    def __init__(self, *, type: str, data: typing.Any=None, trace: typing.Optional[typing.List[str]]=None, path: str):
        """
        :param type: The type of the metadata entry.
        :param data: The data.
        :param trace: A stack trace for when the entry was created.
        :param path: The path in which this entry was defined.

        stability
        :stability: experimental
        """
        self._values = {
            'type': type,
            'path': path,
        }
        if data is not None: self._values["data"] = data
        if trace is not None: self._values["trace"] = trace

    @property
    def type(self) -> str:
        """The type of the metadata entry.

        stability
        :stability: experimental
        """
        return self._values.get('type')

    @property
    def data(self) -> typing.Any:
        """The data.

        stability
        :stability: experimental
        """
        return self._values.get('data')

    @property
    def trace(self) -> typing.Optional[typing.List[str]]:
        """A stack trace for when the entry was created.

        stability
        :stability: experimental
        """
        return self._values.get('trace')

    @property
    def path(self) -> str:
        """The path in which this entry was defined.

        stability
        :stability: experimental
        """
        return self._values.get('path')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'MetadataEntryResult(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.MissingContext", jsii_struct_bases=[], name_mapping={'key': 'key', 'props': 'props', 'provider': 'provider'})
class MissingContext():
    def __init__(self, *, key: str, props: typing.Mapping[str,typing.Any], provider: str):
        """Represents a missing piece of context.

        :param key: The missing context key.
        :param props: A set of provider-specific options.
        :param provider: The provider from which we expect this context key to be obtained.

        stability
        :stability: experimental
        """
        self._values = {
            'key': key,
            'props': props,
            'provider': provider,
        }

    @property
    def key(self) -> str:
        """The missing context key.

        stability
        :stability: experimental
        """
        return self._values.get('key')

    @property
    def props(self) -> typing.Mapping[str,typing.Any]:
        """A set of provider-specific options.

        stability
        :stability: experimental
        """
        return self._values.get('props')

    @property
    def provider(self) -> str:
        """The provider from which we expect this context key to be obtained.

        stability
        :stability: experimental
        """
        return self._values.get('provider')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'MissingContext(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.RuntimeInfo", jsii_struct_bases=[], name_mapping={'libraries': 'libraries'})
class RuntimeInfo():
    def __init__(self, *, libraries: typing.Mapping[str,str]):
        """Information about the application's runtime components.

        :param libraries: The list of libraries loaded in the application, associated with their versions.

        stability
        :stability: experimental
        """
        self._values = {
            'libraries': libraries,
        }

    @property
    def libraries(self) -> typing.Mapping[str,str]:
        """The list of libraries loaded in the application, associated with their versions.

        stability
        :stability: experimental
        """
        return self._values.get('libraries')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'RuntimeInfo(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.SSMParameterContextQuery", jsii_struct_bases=[], name_mapping={'account': 'account', 'parameter_name': 'parameterName', 'region': 'region'})
class SSMParameterContextQuery():
    def __init__(self, *, account: typing.Optional[str]=None, parameter_name: typing.Optional[str]=None, region: typing.Optional[str]=None):
        """Query to hosted zone context provider.

        :param account: Query account.
        :param parameter_name: Parameter name to query.
        :param region: Query region.

        stability
        :stability: experimental
        """
        self._values = {
        }
        if account is not None: self._values["account"] = account
        if parameter_name is not None: self._values["parameter_name"] = parameter_name
        if region is not None: self._values["region"] = region

    @property
    def account(self) -> typing.Optional[str]:
        """Query account.

        stability
        :stability: experimental
        """
        return self._values.get('account')

    @property
    def parameter_name(self) -> typing.Optional[str]:
        """Parameter name to query.

        stability
        :stability: experimental
        """
        return self._values.get('parameter_name')

    @property
    def region(self) -> typing.Optional[str]:
        """Query region.

        stability
        :stability: experimental
        """
        return self._values.get('region')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'SSMParameterContextQuery(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.SynthesisMessage", jsii_struct_bases=[], name_mapping={'entry': 'entry', 'id': 'id', 'level': 'level'})
class SynthesisMessage():
    def __init__(self, *, entry: "MetadataEntry", id: str, level: "SynthesisMessageLevel"):
        """
        :param entry: 
        :param id: 
        :param level: 

        stability
        :stability: experimental
        """
        self._values = {
            'entry': entry,
            'id': id,
            'level': level,
        }

    @property
    def entry(self) -> "MetadataEntry":
        """
        stability
        :stability: experimental
        """
        return self._values.get('entry')

    @property
    def id(self) -> str:
        """
        stability
        :stability: experimental
        """
        return self._values.get('id')

    @property
    def level(self) -> "SynthesisMessageLevel":
        """
        stability
        :stability: experimental
        """
        return self._values.get('level')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'SynthesisMessage(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.enum(jsii_type="@aws-cdk/cx-api.SynthesisMessageLevel")
class SynthesisMessageLevel(enum.Enum):
    """
    stability
    :stability: experimental
    """
    INFO = "INFO"
    """
    stability
    :stability: experimental
    """
    WARNING = "WARNING"
    """
    stability
    :stability: experimental
    """
    ERROR = "ERROR"
    """
    stability
    :stability: experimental
    """

@jsii.data_type(jsii_type="@aws-cdk/cx-api.VpcContextQuery", jsii_struct_bases=[], name_mapping={'filter': 'filter', 'account': 'account', 'region': 'region'})
class VpcContextQuery():
    def __init__(self, *, filter: typing.Mapping[str,str], account: typing.Optional[str]=None, region: typing.Optional[str]=None):
        """Query input for looking up a VPC.

        :param filter: Filters to apply to the VPC. Filter parameters are the same as passed to DescribeVpcs.
        :param account: Query account.
        :param region: Query region.

        stability
        :stability: experimental
        """
        self._values = {
            'filter': filter,
        }
        if account is not None: self._values["account"] = account
        if region is not None: self._values["region"] = region

    @property
    def filter(self) -> typing.Mapping[str,str]:
        """Filters to apply to the VPC.

        Filter parameters are the same as passed to DescribeVpcs.

        see
        :see: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
        stability
        :stability: experimental
        """
        return self._values.get('filter')

    @property
    def account(self) -> typing.Optional[str]:
        """Query account.

        stability
        :stability: experimental
        """
        return self._values.get('account')

    @property
    def region(self) -> typing.Optional[str]:
        """Query region.

        stability
        :stability: experimental
        """
        return self._values.get('region')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'VpcContextQuery(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@aws-cdk/cx-api.VpcContextResponse", jsii_struct_bases=[], name_mapping={'availability_zones': 'availabilityZones', 'vpc_id': 'vpcId', 'isolated_subnet_ids': 'isolatedSubnetIds', 'isolated_subnet_names': 'isolatedSubnetNames', 'private_subnet_ids': 'privateSubnetIds', 'private_subnet_names': 'privateSubnetNames', 'public_subnet_ids': 'publicSubnetIds', 'public_subnet_names': 'publicSubnetNames', 'vpn_gateway_id': 'vpnGatewayId'})
class VpcContextResponse():
    def __init__(self, *, availability_zones: typing.List[str], vpc_id: str, isolated_subnet_ids: typing.Optional[typing.List[str]]=None, isolated_subnet_names: typing.Optional[typing.List[str]]=None, private_subnet_ids: typing.Optional[typing.List[str]]=None, private_subnet_names: typing.Optional[typing.List[str]]=None, public_subnet_ids: typing.Optional[typing.List[str]]=None, public_subnet_names: typing.Optional[typing.List[str]]=None, vpn_gateway_id: typing.Optional[str]=None):
        """Properties of a discovered VPC.

        :param availability_zones: AZs.
        :param vpc_id: VPC id.
        :param isolated_subnet_ids: IDs of all isolated subnets. Element count: #(availabilityZones) · #(isolatedGroups)
        :param isolated_subnet_names: Name of isolated subnet groups. Element count: #(isolatedGroups)
        :param private_subnet_ids: IDs of all private subnets. Element count: #(availabilityZones) · #(privateGroups)
        :param private_subnet_names: Name of private subnet groups. Element count: #(privateGroups)
        :param public_subnet_ids: IDs of all public subnets. Element count: #(availabilityZones) · #(publicGroups)
        :param public_subnet_names: Name of public subnet groups. Element count: #(publicGroups)
        :param vpn_gateway_id: The VPN gateway ID.

        stability
        :stability: experimental
        """
        self._values = {
            'availability_zones': availability_zones,
            'vpc_id': vpc_id,
        }
        if isolated_subnet_ids is not None: self._values["isolated_subnet_ids"] = isolated_subnet_ids
        if isolated_subnet_names is not None: self._values["isolated_subnet_names"] = isolated_subnet_names
        if private_subnet_ids is not None: self._values["private_subnet_ids"] = private_subnet_ids
        if private_subnet_names is not None: self._values["private_subnet_names"] = private_subnet_names
        if public_subnet_ids is not None: self._values["public_subnet_ids"] = public_subnet_ids
        if public_subnet_names is not None: self._values["public_subnet_names"] = public_subnet_names
        if vpn_gateway_id is not None: self._values["vpn_gateway_id"] = vpn_gateway_id

    @property
    def availability_zones(self) -> typing.List[str]:
        """AZs.

        stability
        :stability: experimental
        """
        return self._values.get('availability_zones')

    @property
    def vpc_id(self) -> str:
        """VPC id.

        stability
        :stability: experimental
        """
        return self._values.get('vpc_id')

    @property
    def isolated_subnet_ids(self) -> typing.Optional[typing.List[str]]:
        """IDs of all isolated subnets.

        Element count: #(availabilityZones) · #(isolatedGroups)

        stability
        :stability: experimental
        """
        return self._values.get('isolated_subnet_ids')

    @property
    def isolated_subnet_names(self) -> typing.Optional[typing.List[str]]:
        """Name of isolated subnet groups.

        Element count: #(isolatedGroups)

        stability
        :stability: experimental
        """
        return self._values.get('isolated_subnet_names')

    @property
    def private_subnet_ids(self) -> typing.Optional[typing.List[str]]:
        """IDs of all private subnets.

        Element count: #(availabilityZones) · #(privateGroups)

        stability
        :stability: experimental
        """
        return self._values.get('private_subnet_ids')

    @property
    def private_subnet_names(self) -> typing.Optional[typing.List[str]]:
        """Name of private subnet groups.

        Element count: #(privateGroups)

        stability
        :stability: experimental
        """
        return self._values.get('private_subnet_names')

    @property
    def public_subnet_ids(self) -> typing.Optional[typing.List[str]]:
        """IDs of all public subnets.

        Element count: #(availabilityZones) · #(publicGroups)

        stability
        :stability: experimental
        """
        return self._values.get('public_subnet_ids')

    @property
    def public_subnet_names(self) -> typing.Optional[typing.List[str]]:
        """Name of public subnet groups.

        Element count: #(publicGroups)

        stability
        :stability: experimental
        """
        return self._values.get('public_subnet_names')

    @property
    def vpn_gateway_id(self) -> typing.Optional[str]:
        """The VPN gateway ID.

        stability
        :stability: experimental
        """
        return self._values.get('vpn_gateway_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'VpcContextResponse(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


__all__ = ["ArtifactManifest", "ArtifactType", "AssemblyBuildOptions", "AssemblyManifest", "AvailabilityZonesContextQuery", "AwsCloudFormationStackProperties", "CloudArtifact", "CloudAssembly", "CloudAssemblyBuilder", "CloudFormationStackArtifact", "ContainerImageAssetMetadataEntry", "Environment", "EnvironmentUtils", "FileAssetMetadataEntry", "HostedZoneContextQuery", "MetadataEntry", "MetadataEntryResult", "MissingContext", "RuntimeInfo", "SSMParameterContextQuery", "SynthesisMessage", "SynthesisMessageLevel", "VpcContextQuery", "VpcContextResponse", "__jsii_assembly__"]

publication.publish()
