"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ASSET_METADATA = 'aws:cdk:asset';
/**
 * If this is set in the context, the aws:asset:xxx metadata entries will not be
 * added to the template. This is used, for example, when we run integrationt
 * tests.
 */
exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = 'aws:cdk:enable-asset-metadata';
/**
 * Metadata added to the CloudFormation template entries that map local assets
 * to resources.
 */
exports.ASSET_RESOURCE_METADATA_PATH_KEY = 'aws:asset:path';
exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = 'aws:asset:property';
/**
 * Separator string that separates the prefix separator from the object key separator.
 *
 * Asset keys will look like:
 *
 *    /assets/MyConstruct12345678/||abcdef12345.zip
 *
 * This allows us to encode both the prefix and the full location in a single
 * CloudFormation Template Parameter.
 */
exports.ASSET_PREFIX_SEPARATOR = '||';
//# sourceMappingURL=data:application/json;base64,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