import { AssetMetadataEntry } from './assets';
import { ArtifactManifest, CloudArtifact } from './cloud-artifact';
import { CloudAssembly } from './cloud-assembly';
export declare class CloudFormationStackArtifact extends CloudArtifact {
    /**
     * The CloudFormation template for this stack.
     */
    readonly template: any;
    /**
     * The file name of the template.
     */
    readonly templateFile: string;
    /**
     * The original name as defined in the CDK app.
     */
    readonly originalName: string;
    /**
     * Any assets associated with this stack.
     */
    readonly assets: AssetMetadataEntry[];
    /**
     * CloudFormation parameters to pass to the stack.
     */
    readonly parameters: {
        [id: string]: string;
    };
    /**
     * The name of this stack.
     */
    readonly name: string;
    constructor(assembly: CloudAssembly, name: string, artifact: ArtifactManifest);
}
