"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const assets_1 = require("./assets");
const cloud_artifact_1 = require("./cloud-artifact");
class CloudFormationStackArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        if (!artifact.properties || !artifact.properties.templateFile) {
            throw new Error(`Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest`);
        }
        const properties = (this.manifest.properties || {});
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters || {};
        this.name = this.originalName = name;
        this.template = JSON.parse(fs.readFileSync(path.join(this.assembly.directory, this.templateFile), 'utf-8'));
        this.assets = this.findMetadataByType(assets_1.ASSET_METADATA).map(e => e.data);
    }
}
exports.CloudFormationStackArtifact = CloudFormationStackArtifact;
//# sourceMappingURL=data:application/json;base64,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