"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// output directory into which to emit synthesis outputs. CDK doesn't allow outdir
// to be specified both through the CDK_OUTDIR environment variable and the through
// aws:cdk:outdir context.
exports.OUTDIR_ENV = 'CDK_OUTDIR';
exports.CONTEXT_ENV = 'CDK_CONTEXT_JSON';
/**
 * Environment variable set by the CDK CLI with the default AWS account ID.
 */
exports.DEFAULT_ACCOUNT_ENV = 'CDK_DEFAULT_ACCOUNT';
/**
 * Environment variable set by the CDK CLI with the default AWS region.
 */
exports.DEFAULT_REGION_ENV = 'CDK_DEFAULT_REGION';
/**
 * Enables the embedding of the "aws:cdk:path" in CloudFormation template metadata.
 */
exports.PATH_METADATA_ENABLE_CONTEXT = 'aws:cdk:enable-path-metadata';
/**
 * Disable the collection and reporting of version information.
 */
exports.DISABLE_VERSION_REPORTING = 'aws:cdk:disable-version-reporting';
/**
 * If this is set, asset staging is disabled. This means that assets will not be copied to
 * the output directory and will be referenced with absolute source paths.
 */
exports.DISABLE_ASSET_STAGING_CONTEXT = 'aws:cdk:disable-asset-staging';
/**
 * If this context key is set, the CDK will stage assets under the specified
 * directory. Otherwise, assets will not be staged.
 * Omits stack traces from construct metadata entries.
 */
exports.DISABLE_METADATA_STACK_TRACE = 'aws:cdk:disable-stack-trace';
//# sourceMappingURL=data:application/json;base64,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