"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Parser for the artifact environment field.
 *
 * Account validation is relaxed to allow account aliasing in the future.
 */
const AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
exports.UNKNOWN_ACCOUNT = 'unknown-account';
exports.UNKNOWN_REGION = 'unknown-region';
class EnvironmentUtils {
    static parse(environment) {
        const env = AWS_ENV_REGEX.exec(environment);
        if (!env) {
            throw new Error(`Unable to parse environment specification "${environment}". ` +
                `Expected format: aws://account/region`);
        }
        const [, account, region] = env;
        if (!account || !region) {
            throw new Error(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
    }
    static format(account, region) {
        return `aws://${account}/${region}`;
    }
}
exports.EnvironmentUtils = EnvironmentUtils;
//# sourceMappingURL=data:application/json;base64,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