"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
 */
exports.INFO_METADATA_KEY = 'aws:cdk:info';
/**
 * Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
 */
exports.WARNING_METADATA_KEY = 'aws:cdk:warning';
/**
 * Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
 */
exports.ERROR_METADATA_KEY = 'aws:cdk:error';
/**
 * The key used when CDK path is embedded in **CloudFormation template** metadata (not cdk metadata).
 */
exports.PATH_METADATA_KEY = 'aws:cdk:path';
/**
 * Represents the CloudFormation logical ID of a resource at a certain path.
 */
exports.LOGICAL_ID_METADATA_KEY = 'aws:cdk:logicalId';
/**
 * Tag metadata key.
 */
exports.STACK_TAGS_METADATA_KEY = 'aws:cdk:stack-tags';
var SynthesisMessageLevel;
(function (SynthesisMessageLevel) {
    SynthesisMessageLevel["INFO"] = "info";
    SynthesisMessageLevel["WARNING"] = "warning";
    SynthesisMessageLevel["ERROR"] = "error";
})(SynthesisMessageLevel = exports.SynthesisMessageLevel || (exports.SynthesisMessageLevel = {}));
//# sourceMappingURL=data:application/json;base64,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