# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictInt, StrictStr, constr 

class ColumnStateType(BaseModel):
    """
    Representation of a column within the grid  # noqa: E501
    """
    col_id:  StrictStr = Field(...,alias="colId", description="Unique identifier for the column") 
    hide: StrictBool = Field(..., description="Flag to determine whether the column is visible in the grid")
    sort:  Optional[StrictStr] = Field(None,alias="sort", description="The sort order (asc or desc)") 
    sort_index: Optional[StrictInt] = Field(None, alias="sortIndex", description="The index of the sort to determine the order in which the sorts are applied")
    __properties = ["colId", "hide", "sort", "sortIndex"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ColumnStateType:
        """Create an instance of ColumnStateType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if sort (nullable) is None
        # and __fields_set__ contains the field
        if self.sort is None and "sort" in self.__fields_set__:
            _dict['sort'] = None

        # set to None if sort_index (nullable) is None
        # and __fields_set__ contains the field
        if self.sort_index is None and "sort_index" in self.__fields_set__:
            _dict['sortIndex'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ColumnStateType:
        """Create an instance of ColumnStateType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ColumnStateType.parse_obj(obj)

        _obj = ColumnStateType.parse_obj({
            "col_id": obj.get("colId"),
            "hide": obj.get("hide"),
            "sort": obj.get("sort"),
            "sort_index": obj.get("sortIndex")
        })
        return _obj
