# mypy-boto3-cloudhsmv2

[![PyPI - mypy-boto3-cloudhsmv2](https://img.shields.io/pypi/v/mypy-boto3-cloudhsmv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudhsmv2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudhsmv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudhsmv2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CloudHSMV2 1.16.23](https://boto3.amazonaws.com/v1/documentation/api/1.16.23/reference/services/cloudhsmv2.html#CloudHSMV2) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.3.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-cloudhsmv2](#mypy-boto3-cloudhsmv2)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CloudHSMV2` service.

```bash
python -m pip install boto3-stubs[cloudhsmv2]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[cloudhsmv2]` in your environment: `python -m pip install 'boto3-stubs[cloudhsmv2]'`

Both type checking and auto-complete should work for `CloudHSMV2` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[cloudhsmv2]` in your environment: `python -m pip install 'boto3-stubs[cloudhsmv2]'`

Both type checking and auto-complete should work for `CloudHSMV2` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[cloudhsmv2]` in your environment: `python -m pip install 'boto3-stubs[cloudhsmv2]'`
- Run `mypy` as usual

Type checking should work for `CloudHSMV2` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[cloudhsmv2]` in your environment: `python -m pip install 'boto3-stubs[cloudhsmv2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CloudHSMV2` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CloudHSMV2Client` provides annotations for `boto3.client("cloudhsmv2")`.

```python
import boto3

from mypy_boto3_cloudhsmv2 import CloudHSMV2Client

client: CloudHSMV2Client = boto3.client("cloudhsmv2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudHSMV2Client = session.client("cloudhsmv2")
```

### Paginators annotations

`mypy_boto3_cloudhsmv2.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_cloudhsmv2 import CloudHSMV2Client
from mypy_boto3_cloudhsmv2.paginator import (
    DescribeBackupsPaginator,
    DescribeClustersPaginator,
    ListTagsPaginator,
)

client: CloudHSMV2Client = boto3.client("cloudhsmv2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_backups_paginator: DescribeBackupsPaginator = client.get_paginator("describe_backups")
describe_clusters_paginator: DescribeClustersPaginator = client.get_paginator("describe_clusters")
list_tags_paginator: ListTagsPaginator = client.get_paginator("list_tags")
```







### Typed dictionations

`mypy_boto3_cloudhsmv2.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_cloudhsmv2.type_defs import (
    BackupRetentionPolicyTypeDef,
    BackupTypeDef,
    CertificatesTypeDef,
    ClusterTypeDef,
    CopyBackupToRegionResponseTypeDef,
    CreateClusterResponseTypeDef,
    CreateHsmResponseTypeDef,
    DeleteBackupResponseTypeDef,
    DeleteClusterResponseTypeDef,
    DeleteHsmResponseTypeDef,
    DescribeBackupsResponseTypeDef,
    DescribeClustersResponseTypeDef,
    DestinationBackupTypeDef,
    HsmTypeDef,
    InitializeClusterResponseTypeDef,
    ListTagsResponseTypeDef,
    ModifyBackupAttributesResponseTypeDef,
    ModifyClusterResponseTypeDef,
    PaginatorConfigTypeDef,
    RestoreBackupResponseTypeDef,
    TagTypeDef,
)

def get_structure() -> BackupRetentionPolicyTypeDef:
    return {
      ...
    }
```
