"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const backup = require("@aws-cdk/aws-backup");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const aws_events_1 = require("@aws-cdk/aws-events");
const iam = require("@aws-cdk/aws-iam");
// import { Stream } from '@aws-cdk/aws-kinesis';
// import * as kms from '@aws-cdk/aws-kms';
const cdk = require("@aws-cdk/core");
// export class CompliantDynamoDb extends cdk.Construct {
/**
 * Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery enabled by default.
 *
 * @stability stable
 */
class CompliantDynamoDb extends dynamodb.Table {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id, props);
        this.dynamodbTable = new dynamodb.Table(this, 'DynamoDBTable', {
            tableName: props.tableName,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            partitionKey: (_b = props.partitionKey) !== null && _b !== void 0 ? _b : {
                name: 'id',
                type: dynamodb.AttributeType.STRING,
            },
            sortKey: props.sortKey,
            pointInTimeRecovery: true,
            encryption: dynamodb.TableEncryption.CUSTOMER_MANAGED,
            encryptionKey: props.encryptionKey,
            contributorInsightsEnabled: props.contributorInsightsEnabled,
            kinesisStream: props.kinesisStream,
            replicationRegions: props.replicationRegions,
            replicationTimeout: props.replicationTimeout,
            timeToLiveAttribute: props.timeToLiveAttribute,
        });
        const backupPlan = new backup.BackupPlan(this, 'DynamoDbBackupPlan', {
            backupPlanName: `${this.dynamodbTable.tableName}-backup-plan`,
            backupVault: new backup.BackupVault(this, 'BackupVault', {
                backupVaultName: (_c = props.backupVaultName) !== null && _c !== void 0 ? _c : `${props.tableName}-backup-vault`,
                accessPolicy: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'backup-recovery-point-manual-deletion-disabled',
                            effect: iam.Effect.DENY,
                            principals: [new iam.AnyPrincipal()],
                            actions: [
                                'backup:DeleteRecoveryPoint',
                                'backup:PutBackupVaultAccessPolicy',
                                'backup:UpdateRecoveryPointLifecycle',
                            ],
                            resources: ['*'],
                        }),
                    ],
                }),
            }),
            backupPlanRules: [
                new backup.BackupPlanRule({
                    ruleName: 'daily-dynamodb-backup',
                    scheduleExpression: (_d = props.backupPlanStartTime) !== null && _d !== void 0 ? _d : aws_events_1.Schedule.cron({
                        hour: '21',
                        minute: '0',
                    }),
                    deleteAfter: cdk.Duration.days(35),
                }),
            ],
        });
        backupPlan.addSelection('DynamoDB', {
            resources: [backup.BackupResource.fromDynamoDbTable(this.dynamodbTable)],
        });
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "compliantdynamodb.CompliantDynamoDb", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw4Q0FBOEM7QUFDOUMsa0RBQWtEO0FBQ2xELG9EQUErQztBQUMvQyx3Q0FBd0M7QUFDeEMsaURBQWlEO0FBQ2pELDJDQUEyQztBQUMzQyxxQ0FBcUM7QUFrQnJDLHlEQUF5RDs7Ozs7O0FBQ3pELE1BQWEsaUJBQWtCLFNBQVEsUUFBUSxDQUFDLEtBQUs7Ozs7SUFFbkQsWUFDRSxLQUFvQixFQUNwQixFQUFVLEVBQ1YsS0FBNkI7O1FBRTdCLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7WUFDN0QsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLFdBQVcsRUFBRSxRQUFRLENBQUMsV0FBVyxDQUFDLGVBQWU7WUFDakQsWUFBWSxRQUFFLEtBQUssQ0FBQyxZQUFZLG1DQUFJO2dCQUNsQyxJQUFJLEVBQUUsSUFBSTtnQkFDVixJQUFJLEVBQUUsUUFBUSxDQUFDLGFBQWEsQ0FBQyxNQUFNO2FBQ3BDO1lBQ0QsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLG1CQUFtQixFQUFFLElBQUk7WUFDekIsVUFBVSxFQUFFLFFBQVEsQ0FBQyxlQUFlLENBQUMsZ0JBQWdCO1lBQ3JELGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQywwQkFBMEIsRUFBRSxLQUFLLENBQUMsMEJBQTBCO1lBQzVELGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQzVDLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDNUMsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtTQUMvQyxDQUFDLENBQUM7UUFFSCxNQUFNLFVBQVUsR0FBRyxJQUFJLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLG9CQUFvQixFQUFFO1lBQ25FLGNBQWMsRUFBRSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsU0FBUyxjQUFjO1lBQzdELFdBQVcsRUFBRSxJQUFJLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtnQkFDdkQsZUFBZSxRQUNiLEtBQUssQ0FBQyxlQUFlLG1DQUFJLEdBQUcsS0FBSyxDQUFDLFNBQVMsZUFBZTtnQkFDNUQsWUFBWSxFQUFFLElBQUksR0FBRyxDQUFDLGNBQWMsQ0FBQztvQkFDbkMsVUFBVSxFQUFFO3dCQUNWLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQzs0QkFDdEIsR0FBRyxFQUFFLGdEQUFnRDs0QkFDckQsTUFBTSxFQUFFLEdBQUcsQ0FBQyxNQUFNLENBQUMsSUFBSTs0QkFDdkIsVUFBVSxFQUFFLENBQUMsSUFBSSxHQUFHLENBQUMsWUFBWSxFQUFFLENBQUM7NEJBQ3BDLE9BQU8sRUFBRTtnQ0FDUCw0QkFBNEI7Z0NBQzVCLG1DQUFtQztnQ0FDbkMscUNBQXFDOzZCQUN0Qzs0QkFDRCxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7eUJBQ2pCLENBQUM7cUJBQ0g7aUJBQ0YsQ0FBQzthQUNILENBQUM7WUFDRixlQUFlLEVBQUU7Z0JBQ2YsSUFBSSxNQUFNLENBQUMsY0FBYyxDQUFDO29CQUN4QixRQUFRLEVBQUUsdUJBQXVCO29CQUNqQyxrQkFBa0IsUUFDaEIsS0FBSyxDQUFDLG1CQUFtQixtQ0FDekIscUJBQVEsQ0FBQyxJQUFJLENBQUM7d0JBQ1osSUFBSSxFQUFFLElBQUk7d0JBQ1YsTUFBTSxFQUFFLEdBQUc7cUJBQ1osQ0FBQztvQkFDSixXQUFXLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO2lCQUNuQyxDQUFDO2FBQ0g7U0FDRixDQUFDLENBQUM7UUFDSCxVQUFVLENBQUMsWUFBWSxDQUFDLFVBQVUsRUFBRTtZQUNsQyxTQUFTLEVBQUUsQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztTQUN6RSxDQUFDLENBQUM7SUFDTCxDQUFDOztBQWhFSCw4Q0FpRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBiYWNrdXAgZnJvbSAnQGF3cy1jZGsvYXdzLWJhY2t1cCc7XG5pbXBvcnQgKiBhcyBkeW5hbW9kYiBmcm9tICdAYXdzLWNkay9hd3MtZHluYW1vZGInO1xuaW1wb3J0IHsgU2NoZWR1bGUgfSBmcm9tICdAYXdzLWNkay9hd3MtZXZlbnRzJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbi8vIGltcG9ydCB7IFN0cmVhbSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzJztcbi8vIGltcG9ydCAqIGFzIGttcyBmcm9tICdAYXdzLWNkay9hd3Mta21zJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuZXhwb3J0IGludGVyZmFjZSBDb21wbGlhbnREeW5hbW9EYlByb3BzIGV4dGVuZHMgZHluYW1vZGIuVGFibGVQcm9wcyB7XG4gIC8vIHJlYWRvbmx5IHBhcnRpdGlvbktleT86IGR5bmFtb2RiLkF0dHJpYnV0ZTtcbiAgLy8gcmVhZG9ubHkgc29ydEtleT86IGR5bmFtb2RiLkF0dHJpYnV0ZTtcbiAgLy8gcmVhZG9ubHkgdGFibGVOYW1lPzogc3RyaW5nO1xuICAvLyByZWFkb25seSBlbmNyeXB0aW9uS2V5Pzoga21zLktleTtcbiAgLy8gcmVhZG9ubHkgY29udHJpYnV0b3JJbnNpZ2h0c0VuYWJsZWQ/OiBib29sZWFuO1xuICByZWFkb25seSBiYWNrdXBWYXVsdE5hbWU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGJhY2t1cFBsYW5TdGFydFRpbWU/OiBTY2hlZHVsZTtcbiAgLy8gcmVhZG9ubHkga2luZXNpc1N0cmVhbT86IFN0cmVhbTtcbiAgLy8gcmVhZG9ubHkgcmVwbGljYXRpb25SZWdpb25zPzogc3RyaW5nW107XG4gIC8vIHJlYWRvbmx5IHJlcGxpY2F0aW9uVGltZW91dD86IGNkay5EdXJhdGlvbjtcbiAgLy8gLy8gcmVhZG9ubHkgdGltZVRvTGl2ZUF0dHJpYnV0ZT86IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG4vLyBleHBvcnQgY2xhc3MgQ29tcGxpYW50RHluYW1vRGIgZXh0ZW5kcyBjZGsuQ29uc3RydWN0IHtcbmV4cG9ydCBjbGFzcyBDb21wbGlhbnREeW5hbW9EYiBleHRlbmRzIGR5bmFtb2RiLlRhYmxlIHtcbiAgcmVhZG9ubHkgZHluYW1vZGJUYWJsZTogZHluYW1vZGIuVGFibGU7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHNjb3BlOiBjZGsuQ29uc3RydWN0LFxuICAgIGlkOiBzdHJpbmcsXG4gICAgcHJvcHM6IENvbXBsaWFudER5bmFtb0RiUHJvcHMsXG4gICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgdGhpcy5keW5hbW9kYlRhYmxlID0gbmV3IGR5bmFtb2RiLlRhYmxlKHRoaXMsICdEeW5hbW9EQlRhYmxlJywge1xuICAgICAgdGFibGVOYW1lOiBwcm9wcy50YWJsZU5hbWUsXG4gICAgICBiaWxsaW5nTW9kZTogZHluYW1vZGIuQmlsbGluZ01vZGUuUEFZX1BFUl9SRVFVRVNULFxuICAgICAgcGFydGl0aW9uS2V5OiBwcm9wcy5wYXJ0aXRpb25LZXkgPz8ge1xuICAgICAgICBuYW1lOiAnaWQnLFxuICAgICAgICB0eXBlOiBkeW5hbW9kYi5BdHRyaWJ1dGVUeXBlLlNUUklORyxcbiAgICAgIH0sXG4gICAgICBzb3J0S2V5OiBwcm9wcy5zb3J0S2V5LFxuICAgICAgcG9pbnRJblRpbWVSZWNvdmVyeTogdHJ1ZSxcbiAgICAgIGVuY3J5cHRpb246IGR5bmFtb2RiLlRhYmxlRW5jcnlwdGlvbi5DVVNUT01FUl9NQU5BR0VELFxuICAgICAgZW5jcnlwdGlvbktleTogcHJvcHMuZW5jcnlwdGlvbktleSxcbiAgICAgIGNvbnRyaWJ1dG9ySW5zaWdodHNFbmFibGVkOiBwcm9wcy5jb250cmlidXRvckluc2lnaHRzRW5hYmxlZCxcbiAgICAgIGtpbmVzaXNTdHJlYW06IHByb3BzLmtpbmVzaXNTdHJlYW0sXG4gICAgICByZXBsaWNhdGlvblJlZ2lvbnM6IHByb3BzLnJlcGxpY2F0aW9uUmVnaW9ucyxcbiAgICAgIHJlcGxpY2F0aW9uVGltZW91dDogcHJvcHMucmVwbGljYXRpb25UaW1lb3V0LFxuICAgICAgdGltZVRvTGl2ZUF0dHJpYnV0ZTogcHJvcHMudGltZVRvTGl2ZUF0dHJpYnV0ZSxcbiAgICB9KTtcblxuICAgIGNvbnN0IGJhY2t1cFBsYW4gPSBuZXcgYmFja3VwLkJhY2t1cFBsYW4odGhpcywgJ0R5bmFtb0RiQmFja3VwUGxhbicsIHtcbiAgICAgIGJhY2t1cFBsYW5OYW1lOiBgJHt0aGlzLmR5bmFtb2RiVGFibGUudGFibGVOYW1lfS1iYWNrdXAtcGxhbmAsXG4gICAgICBiYWNrdXBWYXVsdDogbmV3IGJhY2t1cC5CYWNrdXBWYXVsdCh0aGlzLCAnQmFja3VwVmF1bHQnLCB7XG4gICAgICAgIGJhY2t1cFZhdWx0TmFtZTpcbiAgICAgICAgICBwcm9wcy5iYWNrdXBWYXVsdE5hbWUgPz8gYCR7cHJvcHMudGFibGVOYW1lfS1iYWNrdXAtdmF1bHRgLFxuICAgICAgICBhY2Nlc3NQb2xpY3k6IG5ldyBpYW0uUG9saWN5RG9jdW1lbnQoe1xuICAgICAgICAgIHN0YXRlbWVudHM6IFtcbiAgICAgICAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICAgICAgc2lkOiAnYmFja3VwLXJlY292ZXJ5LXBvaW50LW1hbnVhbC1kZWxldGlvbi1kaXNhYmxlZCcsXG4gICAgICAgICAgICAgIGVmZmVjdDogaWFtLkVmZmVjdC5ERU5ZLFxuICAgICAgICAgICAgICBwcmluY2lwYWxzOiBbbmV3IGlhbS5BbnlQcmluY2lwYWwoKV0sXG4gICAgICAgICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICAgICAgICAnYmFja3VwOkRlbGV0ZVJlY292ZXJ5UG9pbnQnLFxuICAgICAgICAgICAgICAgICdiYWNrdXA6UHV0QmFja3VwVmF1bHRBY2Nlc3NQb2xpY3knLFxuICAgICAgICAgICAgICAgICdiYWNrdXA6VXBkYXRlUmVjb3ZlcnlQb2ludExpZmVjeWNsZScsXG4gICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICBdLFxuICAgICAgICB9KSxcbiAgICAgIH0pLFxuICAgICAgYmFja3VwUGxhblJ1bGVzOiBbXG4gICAgICAgIG5ldyBiYWNrdXAuQmFja3VwUGxhblJ1bGUoe1xuICAgICAgICAgIHJ1bGVOYW1lOiAnZGFpbHktZHluYW1vZGItYmFja3VwJyxcbiAgICAgICAgICBzY2hlZHVsZUV4cHJlc3Npb246XG4gICAgICAgICAgICBwcm9wcy5iYWNrdXBQbGFuU3RhcnRUaW1lID8/XG4gICAgICAgICAgICBTY2hlZHVsZS5jcm9uKHtcbiAgICAgICAgICAgICAgaG91cjogJzIxJyxcbiAgICAgICAgICAgICAgbWludXRlOiAnMCcsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICBkZWxldGVBZnRlcjogY2RrLkR1cmF0aW9uLmRheXMoMzUpLFxuICAgICAgICB9KSxcbiAgICAgIF0sXG4gICAgfSk7XG4gICAgYmFja3VwUGxhbi5hZGRTZWxlY3Rpb24oJ0R5bmFtb0RCJywge1xuICAgICAgcmVzb3VyY2VzOiBbYmFja3VwLkJhY2t1cFJlc291cmNlLmZyb21EeW5hbW9EYlRhYmxlKHRoaXMuZHluYW1vZGJUYWJsZSldLFxuICAgIH0pO1xuICB9XG59XG4iXX0=