"""prompt response table

Revision ID: 3759d9b2bed9
Revises: 59f54c221f16
Create Date: 2024-04-11 17:54:29.637441

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = '3759d9b2bed9'
down_revision: Union[str, None] = '59f54c221f16'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('prompt_response',
    sa.Column('prompt_id', sa.String(), nullable=False),
    sa.Column('given_id', sa.String(), nullable=False),
    sa.Column('text_id', sa.String(), nullable=False),
    sa.Column('input_text', sa.String(), nullable=False),
    sa.Column('response_full', postgresql.JSONB(astext_type=sa.Text()), nullable=False),
    sa.Column('response_text', sa.String(), nullable=True),
    sa.Column('num_errors', sa.Integer(), nullable=True),
    sa.Column('date_added', sa.DateTime(), nullable=True),
    sa.Column('date_updated', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['prompt_id'], ['prompt.id'], ),
    sa.PrimaryKeyConstraint('prompt_id', 'given_id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('prompt_response')
    # ### end Alembic commands ###
