"""linkedin_orgs

Revision ID: 4005e1076c66
Revises: f1f762f43b92
Create Date: 2024-04-08 16:53:35.585680

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = '4005e1076c66'
down_revision: Union[str, None] = 'f1f762f43b92'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('linkedin_organization',
    sa.Column('linkedin_id', sa.String(), nullable=False),
    sa.Column('original_id', sa.String(), nullable=True),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('image', sa.String(), nullable=True),
    sa.Column('url', sa.String(), nullable=True),
    sa.Column('summary', sa.String(), nullable=True),
    sa.Column('about', sa.String(), nullable=True),
    sa.Column('website', sa.String(), nullable=True),
    sa.Column('industry', sa.String(), nullable=True),
    sa.Column('specialties', postgresql.ARRAY(sa.String()), nullable=True),
    sa.Column('company_size', sa.String(), nullable=True),
    sa.Column('hq', sa.String(), nullable=True),
    sa.Column('company_type', sa.String(), nullable=True),
    sa.Column('founded', sa.String(), nullable=True),
    sa.Column('locations', postgresql.ARRAY(sa.String()), nullable=True),
    sa.Column('raw_html', sa.String(), nullable=True),
    sa.Column('num_errors', sa.Integer(), nullable=True),
    sa.Column('date_added', sa.DateTime(), nullable=True),
    sa.Column('date_updated', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('linkedin_id')
    )
    op.create_index(op.f('ix_linkedin_organization_url'), 'linkedin_organization', ['url'], unique=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_linkedin_organization_url'), table_name='linkedin_organization')
    op.drop_table('linkedin_organization')
    # ### end Alembic commands ###
