"""adding datasource to linkedin orgs

Revision ID: 8b77bcd64de3
Revises: aaabae0f8808
Create Date: 2024-05-07 13:04:26.418090

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '8b77bcd64de3'
down_revision: Union[str, None] = 'aaabae0f8808'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('linkedin_organization', sa.Column('datasource', sa.String(), nullable=True))
    op.create_index(op.f('ix_linkedin_organization_datasource'), 'linkedin_organization', ['datasource'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_linkedin_organization_datasource'), table_name='linkedin_organization')
    op.drop_column('linkedin_organization', 'datasource')
    # ### end Alembic commands ###
