"""fixing netzero startup table

Revision ID: bcc160f796fd
Revises: e71d8c6b9ea0
Create Date: 2025-04-30 15:57:07.622836

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = 'bcc160f796fd'
down_revision: Union[str, None] = 'e71d8c6b9ea0'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('startups', sa.Column('fundRaising', sa.Boolean(), nullable=True))
    op.add_column('startups', sa.Column('revenueEuro', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('revenueYear', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('revenuesRangeID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('linkedInRevenuesRangeID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('countryCode', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('yoYEmployeesGrowth', sa.Float(), nullable=True))
    op.add_column('startups', sa.Column('qoQEmployeesGrowth', sa.Float(), nullable=True))
    op.add_column('startups', sa.Column('yoYCorrespondingQuarter', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('qoQCorrespondingQuarter', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('trl', sa.JSON(), nullable=True))
    op.add_column('startups', sa.Column('trlID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('trlAcquisitionDate', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('actorTypes', sa.JSON(), nullable=True))
    op.add_column('startups', sa.Column('tbFinancialStage', sa.JSON(), nullable=True))
    op.add_column('startups', sa.Column('tagSourceMap', sa.JSON(), nullable=True))
    op.alter_column('startups', 'fundingAmount',
               existing_type=sa.INTEGER(),
               type_=sa.Float(),
               existing_nullable=True)
    op.alter_column('startups', 'fundingAmountUSD',
               existing_type=sa.INTEGER(),
               type_=sa.Float(),
               existing_nullable=True)
    op.alter_column('startups', 'lastRoundDate',
               existing_type=postgresql.TIMESTAMP(),
               type_=sa.String(),
               existing_nullable=True)
    op.alter_column('startups', 'acquisitionDate',
               existing_type=postgresql.TIMESTAMP(),
               type_=sa.String(),
               existing_nullable=True)
    op.alter_column('startups', 'reviewDate',
               existing_type=postgresql.TIMESTAMP(),
               type_=sa.String(),
               existing_nullable=True)
    op.alter_column('startups', 'lastSeenDate',
               existing_type=postgresql.TIMESTAMP(),
               type_=sa.String(),
               existing_nullable=True)
    op.alter_column('startups', 'employeesGrowthJSON',
               existing_type=postgresql.JSON(astext_type=sa.Text()),
               type_=sa.String(),
               existing_nullable=True)
    op.drop_column('startups', 'numberOfGrants')
    op.drop_column('startups', 'facebookURL')
    op.drop_column('startups', 'phone')
    op.drop_column('startups', 'email')
    op.drop_column('startups', 'trls')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('startups', sa.Column('trls', postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('email', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('phone', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('facebookURL', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('numberOfGrants', sa.INTEGER(), autoincrement=False, nullable=True))
    op.alter_column('startups', 'employeesGrowthJSON',
               existing_type=sa.String(),
               type_=postgresql.JSON(astext_type=sa.Text()),
               existing_nullable=True)
    op.alter_column('startups', 'lastSeenDate',
               existing_type=sa.String(),
               type_=postgresql.TIMESTAMP(),
               existing_nullable=True)
    op.alter_column('startups', 'reviewDate',
               existing_type=sa.String(),
               type_=postgresql.TIMESTAMP(),
               existing_nullable=True)
    op.alter_column('startups', 'acquisitionDate',
               existing_type=sa.String(),
               type_=postgresql.TIMESTAMP(),
               existing_nullable=True)
    op.alter_column('startups', 'lastRoundDate',
               existing_type=sa.String(),
               type_=postgresql.TIMESTAMP(),
               existing_nullable=True)
    op.alter_column('startups', 'fundingAmountUSD',
               existing_type=sa.Float(),
               type_=sa.INTEGER(),
               existing_nullable=True)
    op.alter_column('startups', 'fundingAmount',
               existing_type=sa.Float(),
               type_=sa.INTEGER(),
               existing_nullable=True)
    op.drop_column('startups', 'tagSourceMap')
    op.drop_column('startups', 'tbFinancialStage')
    op.drop_column('startups', 'actorTypes')
    op.drop_column('startups', 'trlAcquisitionDate')
    op.drop_column('startups', 'trlID')
    op.drop_column('startups', 'trl')
    op.drop_column('startups', 'qoQCorrespondingQuarter')
    op.drop_column('startups', 'yoYCorrespondingQuarter')
    op.drop_column('startups', 'qoQEmployeesGrowth')
    op.drop_column('startups', 'yoYEmployeesGrowth')
    op.drop_column('startups', 'countryCode')
    op.drop_column('startups', 'linkedInRevenuesRangeID')
    op.drop_column('startups', 'revenuesRangeID')
    op.drop_column('startups', 'revenueYear')
    op.drop_column('startups', 'revenueEuro')
    op.drop_column('startups', 'fundRaising')
    # ### end Alembic commands ###
