"""embedding table

Revision ID: cbd7c32798d8
Revises: 8b77bcd64de3
Create Date: 2024-06-19 13:55:32.114586

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = 'cbd7c32798d8'
down_revision: Union[str, None] = '240baaf1ed96'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('embedding',
    sa.Column('model_name', sa.String(), nullable=False),
    sa.Column('text_id', sa.String(), nullable=False),
    sa.Column('given_id', sa.String(), nullable=True),
    sa.Column('input_text', sa.String(), nullable=False),
    sa.Column('response_full', postgresql.JSONB(astext_type=sa.Text()), nullable=False),
    sa.Column('embedding', postgresql.ARRAY(sa.Float()), nullable=True),
    sa.Column('num_errors', sa.Integer(), nullable=True),
    sa.Column('date_added', sa.DateTime(), nullable=True),
    sa.Column('date_updated', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('model_name', 'text_id'),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('embedding')
    # ### end Alembic commands ###
