"""fixing netzero startup table

Revision ID: e71d8c6b9ea0
Revises: cb081e639c14
Create Date: 2025-04-30 15:47:01.569808

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = 'e71d8c6b9ea0'
down_revision: Union[str, None] = 'cb081e639c14'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('startups', sa.Column('clientID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('pitchLine', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('fundingAmount', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('fundingString', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('fundingAmountUSD', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('fundingStringUSD', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('fundingRangeID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('fundingRange', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('fundingRangeUSD', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('fundingRangeIDUSD', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('lastRoundAmount', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('lastRoundAmountUSD', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('lastRoundAmountString', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('lastRoundAmountStringUSD', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('lastRoundType', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('roundCount', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('numberOfEquityRounds', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('numberOfGrants', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('lastRoundDate', sa.DateTime(), nullable=True))
    op.add_column('startups', sa.Column('acquisitionDate', sa.DateTime(), nullable=True))
    op.add_column('startups', sa.Column('foundedDate', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('reviewDate', sa.DateTime(), nullable=True))
    op.add_column('startups', sa.Column('lastSeenDate', sa.DateTime(), nullable=True))
    op.add_column('startups', sa.Column('georowID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('countryID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('linkedinURL', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('twitterURL', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('facebookURL', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('directURL', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('sizeID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('stageID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('sustainabilityMetric', sa.Float(), nullable=True))
    op.add_column('startups', sa.Column('sustainabilityMetricID', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('sustainabilityMetricLabel', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('revenuesRange', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('currentEmployeesCount', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('employeesGrowthJSON', sa.JSON(), nullable=True))
    op.add_column('startups', sa.Column('eutopiaScore', sa.Integer(), nullable=True))
    op.add_column('startups', sa.Column('lastReviewer', sa.String(), nullable=True))
    op.add_column('startups', sa.Column('piFrameworks', sa.JSON(), nullable=True))
    op.add_column('startups', sa.Column('fundingTypes', sa.JSON(), nullable=True))
    op.drop_constraint('startups_client_id_key', 'startups', type_='unique')
    op.create_unique_constraint(None, 'startups', ['clientID'])
    op.drop_column('startups', 'funding_amount')
    op.drop_column('startups', 'employees_growth_json')
    op.drop_column('startups', 'linkedin_url')
    op.drop_column('startups', 'number_of_grants')
    op.drop_column('startups', 'acquisition_date')
    op.drop_column('startups', 'funding_range')
    op.drop_column('startups', 'last_reviewer')
    op.drop_column('startups', 'sustainability_metric_id')
    op.drop_column('startups', 'last_round_date')
    op.drop_column('startups', 'client_id')
    op.drop_column('startups', 'sustainability_metric')
    op.drop_column('startups', 'size_id')
    op.drop_column('startups', 'funding_range_id')
    op.drop_column('startups', 'country_id')
    op.drop_column('startups', 'revenues_range')
    op.drop_column('startups', 'last_round_amount_usd')
    op.drop_column('startups', 'pitch_line')
    op.drop_column('startups', 'round_count')
    op.drop_column('startups', 'facebook_url')
    op.drop_column('startups', 'funding_amount_usd')
    op.drop_column('startups', 'pi_frameworks')
    op.drop_column('startups', 'funding_types')
    op.drop_column('startups', 'review_date')
    op.drop_column('startups', 'stage_id')
    op.drop_column('startups', 'funding_string_usd')
    op.drop_column('startups', 'last_round_amount_string_usd')
    op.drop_column('startups', 'last_round_amount')
    op.drop_column('startups', 'last_seen_date')
    op.drop_column('startups', 'direct_url')
    op.drop_column('startups', 'funding_range_id_usd')
    op.drop_column('startups', 'georow_id')
    op.drop_column('startups', 'founded_date')
    op.drop_column('startups', 'eutopia_score')
    op.drop_column('startups', 'sustainability_metric_label')
    op.drop_column('startups', 'funding_string')
    op.drop_column('startups', 'twitter_url')
    op.drop_column('startups', 'current_employees_count')
    op.drop_column('startups', 'last_round_amount_string')
    op.drop_column('startups', 'number_of_equity_rounds')
    op.drop_column('startups', 'funding_range_usd')
    op.drop_column('startups', 'last_round_type')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('startups', sa.Column('last_round_type', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('funding_range_usd', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('number_of_equity_rounds', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('last_round_amount_string', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('current_employees_count', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('twitter_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('funding_string', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('sustainability_metric_label', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('eutopia_score', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('founded_date', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('georow_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('funding_range_id_usd', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('direct_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('last_seen_date', postgresql.TIMESTAMP(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('last_round_amount', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('last_round_amount_string_usd', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('funding_string_usd', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('stage_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('review_date', postgresql.TIMESTAMP(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('funding_types', postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('pi_frameworks', postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('funding_amount_usd', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('facebook_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('round_count', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('pitch_line', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('last_round_amount_usd', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('revenues_range', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('country_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('funding_range_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('size_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('sustainability_metric', sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('last_round_date', postgresql.TIMESTAMP(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('sustainability_metric_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('last_reviewer', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('funding_range', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('acquisition_date', postgresql.TIMESTAMP(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('number_of_grants', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('linkedin_url', sa.VARCHAR(), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('employees_growth_json', postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=True))
    op.add_column('startups', sa.Column('funding_amount', sa.INTEGER(), autoincrement=False, nullable=True))
    op.drop_constraint(None, 'startups', type_='unique')
    op.create_unique_constraint('startups_client_id_key', 'startups', ['client_id'])
    op.drop_column('startups', 'fundingTypes')
    op.drop_column('startups', 'piFrameworks')
    op.drop_column('startups', 'lastReviewer')
    op.drop_column('startups', 'eutopiaScore')
    op.drop_column('startups', 'employeesGrowthJSON')
    op.drop_column('startups', 'currentEmployeesCount')
    op.drop_column('startups', 'revenuesRange')
    op.drop_column('startups', 'sustainabilityMetricLabel')
    op.drop_column('startups', 'sustainabilityMetricID')
    op.drop_column('startups', 'sustainabilityMetric')
    op.drop_column('startups', 'stageID')
    op.drop_column('startups', 'sizeID')
    op.drop_column('startups', 'directURL')
    op.drop_column('startups', 'facebookURL')
    op.drop_column('startups', 'twitterURL')
    op.drop_column('startups', 'linkedinURL')
    op.drop_column('startups', 'countryID')
    op.drop_column('startups', 'georowID')
    op.drop_column('startups', 'lastSeenDate')
    op.drop_column('startups', 'reviewDate')
    op.drop_column('startups', 'foundedDate')
    op.drop_column('startups', 'acquisitionDate')
    op.drop_column('startups', 'lastRoundDate')
    op.drop_column('startups', 'numberOfGrants')
    op.drop_column('startups', 'numberOfEquityRounds')
    op.drop_column('startups', 'roundCount')
    op.drop_column('startups', 'lastRoundType')
    op.drop_column('startups', 'lastRoundAmountStringUSD')
    op.drop_column('startups', 'lastRoundAmountString')
    op.drop_column('startups', 'lastRoundAmountUSD')
    op.drop_column('startups', 'lastRoundAmount')
    op.drop_column('startups', 'fundingRangeIDUSD')
    op.drop_column('startups', 'fundingRangeUSD')
    op.drop_column('startups', 'fundingRange')
    op.drop_column('startups', 'fundingRangeID')
    op.drop_column('startups', 'fundingStringUSD')
    op.drop_column('startups', 'fundingAmountUSD')
    op.drop_column('startups', 'fundingString')
    op.drop_column('startups', 'fundingAmount')
    op.drop_column('startups', 'pitchLine')
    op.drop_column('startups', 'clientID')
    # ### end Alembic commands ###
