"""webscraping table

Revision ID: f1f762f43b92
Revises: 
Create Date: 2024-04-05 14:50:26.467061

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'f1f762f43b92'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('web_pages_scraped',
    sa.Column('cleaned_key', sa.String(), nullable=False),
    sa.Column('full_path', sa.String(), nullable=True),
    sa.Column('home_url', sa.String(), nullable=False),
    sa.Column('subpath', sa.String(), nullable=False),
    sa.Column('raw_html', sa.String(), nullable=True),
    sa.Column('parsed_html', sa.String(), nullable=True),
    sa.Column('page_type', sa.String(), nullable=False),
    sa.Column('response_status_code', sa.Integer(), nullable=True),
    sa.Column('num_errors', sa.Integer(), nullable=True),
    sa.Column('date_added', sa.DateTime(), nullable=True),
    sa.Column('date_updated', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('cleaned_key')
    )
    op.create_index(op.f('ix_web_pages_scraped_full_path'), 'web_pages_scraped', ['full_path'], unique=False)
    op.create_index(op.f('ix_web_pages_scraped_home_url'), 'web_pages_scraped', ['home_url'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_web_pages_scraped_home_url'), table_name='web_pages_scraped')
    op.drop_index(op.f('ix_web_pages_scraped_full_path'), table_name='web_pages_scraped')
    op.drop_table('web_pages_scraped')
    # ### end Alembic commands ###
