# mypy-boto3-ecs

[![PyPI - mypy-boto3-ecs](https://img.shields.io/pypi/v/mypy-boto3-ecs.svg?color=blue)](https://pypi.org/project/mypy-boto3-ecs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ecs.svg?color=blue)](https://pypi.org/project/mypy-boto3-ecs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ECS 1.12.31](https://boto3.amazonaws.com/v1/documentation/api/1.12.31/reference/services/ecs.html#ECS) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.6](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-ecs](#mypy-boto3-ecs)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ECS` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-ecs]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import ecs
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_ecs as ecs

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("ecs")
client: ecs.ECSClient = boto3.client("ecs")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ecs.ECSClient = session.client("ecs")


# Waiters need type annotation on creation
services_inactive_waiter: ecs.ServicesInactiveWaiter = client.get_waiter("services_inactive")
services_stable_waiter: ecs.ServicesStableWaiter = client.get_waiter("services_stable")
tasks_running_waiter: ecs.TasksRunningWaiter = client.get_waiter("tasks_running")
tasks_stopped_waiter: ecs.TasksStoppedWaiter = client.get_waiter("tasks_stopped")

# Paginators need type annotation on creation
list_account_settings_paginator: ecs.ListAccountSettingsPaginator = client.get_paginator("list_account_settings")
list_attributes_paginator: ecs.ListAttributesPaginator = client.get_paginator("list_attributes")
list_clusters_paginator: ecs.ListClustersPaginator = client.get_paginator("list_clusters")
list_container_instances_paginator: ecs.ListContainerInstancesPaginator = client.get_paginator("list_container_instances")
list_services_paginator: ecs.ListServicesPaginator = client.get_paginator("list_services")
list_task_definition_families_paginator: ecs.ListTaskDefinitionFamiliesPaginator = client.get_paginator("list_task_definition_families")
list_task_definitions_paginator: ecs.ListTaskDefinitionsPaginator = client.get_paginator("list_task_definitions")
list_tasks_paginator: ecs.ListTasksPaginator = client.get_paginator("list_tasks")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.