# initialize API
from sumit_sdk.api import APIClient
from sumit_sdk.summary_api import SummaryApi, SummaryTypes
from sumit_sdk.storage import Storage  
import time

api = APIClient("api-sa-prod.json")  # create client
summary = SummaryApi(api)
storage = Storage(api)

summary_type = SummaryTypes.BULLETS  # or short_paragraph
language = "he-IL"  # The language you would like the summary to be in.

## Example of a summary with text.
# context = text to summarize
context = """**התמנון: פלא ביולוגי בעל שמונה זרועות**

התמנון הוא רכיכה ימית מסדרת הראשרגליים, השייכת למחלקת הצפודיים. יצורים אלה מאכלסים את האוקיינוסים כבר למעלה מ-300 מיליון שנה, והם נחשבים לחסרי החוליות האינטליגנטיים ביותר על פני כדור הארץ. עם כ-300 מינים שונים הפרוסים ברחבי האוקיינוסים, מהמים הרדודים ועד לתהומות העמוקים ביותר, התמנון מציג מגוון מדהים של התאמות אבולוציוניות.

המבנה הגופני של התמנון הוא ייחודי ומרתק. בניגוד לבעלי חוליות, לתמנון אין שלד פנימי או חיצוני קשיח, למעט מקור קשה הנקרא "ביק". המבנה הרך הזה מאפשר לו להשתחל דרך חרכים זעירים - כל פתח שהמקור יכול לעבור דרכו, כל הגוף יכול להיכנס אליו. שמונה הזרועות שלו מכוסות בכפתורי יניקה - בסך הכל כ-2,000 כפתורים בתמנון בוגר - וכל אחד מהם יכול לפעול באופן עצמאי. הכפתורים האלה לא רק מאפשרים אחיזה חזקה, אלא גם מכילים קולטנים כימיים המאפשרים לתמנון "לטעום" את מה שהוא נוגע בו.

המערכת העצבית של התמנון היא נס הנדסי של הטבע. בעוד שלבני אדם יש מוח מרכזי אחד, לתמנון יש מוח מרכזי ועוד שמונה "מוחות" קטנים - אחד בכל זרוע. כשני שלישים מהנוירונים של התמנון נמצאים בזרועות, מה שמאפשר להן לפעול באופן חצי-עצמאי. זרוע שנחתכה יכולה להמשיך לזוז ולתפוס דברים למשך שעה לאחר הניתוק. המוח המרכזי מתאם את הפעילות הכללית, אך כל זרוע יכולה לקבל החלטות מקומיות, מה שמאפשר לתמנון לבצע משימות מורכבות במקביל.

היכולת הקוגניטיבית של התמנון מפתיעה ומרשימה. מחקרים הוכיחו שתמנונים מסוגלים לפתור בעיות מורכבות, להשתמש בכלים, ולזכור פתרונות לאורך זמן. הם יכולים ללמוד על ידי צפייה בתמנונים אחרים, להבחין בין אנשים שונים, ואפילו לפתח "אישיות" ייחודית. תמנונים במעבדה למדו לפתוח צנצנות מבורגות מבפנים ומבחוץ, לנווט במבוכים, ולשחק עם צעצועים. יש דיווחים על תמנונים בשבי שלמדו להתגנב מהאקווריום שלהם בלילה כדי לאכול דגים באקווריום סמוך ולחזור לפני הבוקר.

מערכת ההסוואה של התמנון היא אולי התכונה המרשימה ביותר שלו. בעורו יש מיליוני תאים מיוחדים הנקראים כרומטופורים, המכילים פיגמנטים בצבעים שונים. כל כרומטופור מוקף בשרירים זעירים שיכולים להתכווץ או להתרחב, ובכך לשנות את כמות הצבע הנראית. מתחת לכרומטופורים יש שכבות של אירידופורים ולוקופורים, המחזירים ומפזרים אור. השילוב המורכב הזה מאפשר לתמנון לשנות לא רק את צבעו אלא גם את המרקם והדפוס של עורו תוך שברירי שנייה. הם יכולים לחקות סלעים, אלמוגים, אצות, ואפילו בעלי חיים אחרים כמו דגי פלנדר או נחשי ים.

מערכת הראייה של התמנון מתוחכמת במיוחד. למרות שהם עיוורי צבעים (יש להם רק סוג אחד של קולטן צבע), הם מצליחים להבחין בצבעים באמצעות האופן שבו האישון המוזר שלהם - בצורת חריץ אופקי - מפרק את האור. העיניים שלהם יכולות לזוז באופן עצמאי זו מזו, והם יכולים לראות אור מקוטב, מה שעוזר להם לזהות טרף מוסווה. החדות הראייה שלהם מרשימה, והם יכולים לזהות אובייקטים קטנים ממרחק ניכר.

מחזור החיים של התמנון קצר באופן מפתיע ביחס לאינטליגנציה שלו. רוב המינים חיים רק שנה עד שנתיים, ומינים גדולים יותר עד 5 שנים. ההתרבות היא אירוע חד-פעמי וטרגי: הזכר מת זמן קצר לאחר ההזדווגות, והנקבה מפסיקה לאכול כדי לשמור על הביצים שלה עד שהן בוקעות, ואז מתה גם היא. במהלך תקופת הדגירה, שיכולה להימשך חודשים, הנקבה מנקה את הביצים ללא הרף, מזרימה עליהן מים עשירים בחמצן, ומגנה עליהן מטורפים. הגורים הזעירים שבוקעים הם עצמאיים לחלוטין מרגע הלידה.

התמנון משחק תפקיד חשוב במערכת האקולוגית הימית. הוא טורף יעיל שניזון מסרטנים, דגים ורכיכות אחרות, ובמקביל מהווה טרף לכרישים, לווייתנים ודגים גדולים. שיטות הציד שלו מגוונות: מארב, מרדף אקטיבי, או שימוש בזרועות כ"רשת" לתפיסת טרף קטן. הארס שלו, המוזרק דרך המקור, משתק את הטרף במהירות. מין אחד, התמנון הכחול-טבעתי, מייצר ארס חזק מספיק כדי להרוג אדם תוך דקות.

ההתנהגות החברתית של התמנון מורכבת יותר ממה שחשבו בעבר. למרות שהם נחשבים ליצורים בודדים, תצפיות אחרונות גילו "ערי תמנונים" - אזורים שבהם עשרות תמנונים חיים בסמיכות זה לזה, מתקשרים ואף מקימים היררכיות חברתיות. התקשורת ביניהם מתבצעת באמצעות שינויי צבע ותנוחות גוף. דפוסי צבע מסוימים מסמנים אגרסיביות, אחרים מסמנים כניעה או נכונות להזדווגות.

בתרבויות שונות, התמנון תופס מקום מיוחד. במיתולוגיה היוונית הוא מופיע כמפלצת ימית, בתרבות היפנית הוא סמל לאומנות ולגמישות, ובמטבח הים תיכוני הוא מעדן מבוקש. המחקר המדעי על תמנונים תרם להבנתנו על אבולוציה של אינטליגנציה, לפיתוח חומרים ביו-מימטיים (כמו דבקים וחומרי הסוואה), וליצירת רובוטים רכים בהשראת מבנה גופם.

האיומים על אוכלוסיות התמנונים כוללים דיג יתר, זיהום ימי, והתחממות האוקיינוסים. שינויי האקלים משפיעים על זרמי האוקיינוס ועל רמת החומציות במים, מה שמשפיע על מקורות המזון של התמנון ועל יכולתו להתרבות. חלק מהמינים נמצאים בסכנת הכחדה, במיוחד אלה החיים בבתי גידול ספציפיים או באזורים מוגבלים גיאוגרפית.

בהצלחה עם תרגיל הסיכום! הטקסט הזה מכיל מידע רב על היבטים שונים של חיי התמנון - מהאנטומיה והפיזיולוגיה שלו, דרך ההתנהגות והאינטליגנציה, ועד למקומו במערכת האקולוגית ובתרבות האנושית.
"""

output_path = "summary_test.json"
payload = summary.build_request(summary_type=summary_type, language=language, content=context, output_blob_path=output_path)
res = summary.execute(payload)
print(res)
# wait to summary to finish. 
# usually should use callback to get notified, but for this example we will just wait until file is ready
for i in range(3):
    try:
        time.sleep(10)  
        res = storage.download_as_json(output_path)
        break
    except:
        time.sleep(60)
print(res)

# ----------------------------------------------------------------------------------------------------------------------
## Example of a summary with file from the buket.
# filename = "<PATH_TO_FILE_IN_STORAGE>"  # The path + and the name of the file that will appear in the storage.

# output_blob_path = "<PATH_TO_FILE_IN_STORAGE>"  # The path + and the name of the file that will save  the result in the storage.

# sync = True  # with for the result if true
# language = "he-IL"  # The language you would like the summary to be in.

# payload = summary.build_request(summary_type=summary_type, language=language input_blob_path=filename,
#                                 output_blob_path=output_blob_path)

# res = summary.execute(payload)
# print(res['results']['summary'])
