3      }(	documents]llama_index.schemaDocument)}(__dict__}(id_$0e7dbdfd-0c61-4fc7-8a96-b22ae7241fdf	embeddingNmetadata}(	file_path&data/paul_graham/paul_graham_essay.txt	file_namepaul_graham_essay.txt	file_type
text/plain	file_sizeJ"% 
creation_date
2024-01-02last_modified_date
2024-01-02last_accessed_date
2024-01-02uexcluded_embed_metadata_keys](hhhhhheexcluded_llm_metadata_keys](hhhhhhe
relationships}hash@1f9cffbde74b85f4cd1dbc238e5492895800c1357305967fa98e81420cbc89fctextX"% 

What I Worked On

February 2021

Before college the two main things I worked on, outside of school, were writing and programming. I didn't write essays. I wrote what beginning writers were supposed to write then, and probably still are: short stories. My stories were awful. They had hardly any plot, just characters with strong feelings, which I imagined made them deep.

The first programs I tried writing were on the IBM 1401 that our school district used for what was then called "data processing." This was in 9th grade, so I was 13 or 14. The school district's 1401 happened to be in the basement of our junior high school, and my friend Rich Draves and I got permission to use it. It was like a mini Bond villain's lair down there, with all these alien-looking machines — CPU, disk drives, printer, card reader — sitting up on a raised floor under bright fluorescent lights.

The language we used was an early version of Fortran. You had to type programs on punch cards, then stack them in the card reader and press a button to load the program into memory and run it. The result would ordinarily be to print something on the spectacularly loud printer.

I was puzzled by the 1401. I couldn't figure out what to do with it. And in retrospect there's not much I could have done with it. The only form of input to programs was data stored on punched cards, and I didn't have any data stored on punched cards. The only other option was to do things that didn't rely on any input, like calculate approximations of pi, but I didn't know enough math to do anything interesting of that type. So I'm not surprised I can't remember any programs I wrote, because they can't have done much. My clearest memory is of the moment I learned it was possible for programs not to terminate, when one of mine didn't. On a machine without time-sharing, this was a social as well as a technical error, as the data center manager's expression made clear.

With microcomputers, everything changed. Now you could have a computer sitting right in front of you, on a desk, that could respond to your keystrokes as it was running instead of just churning through a stack of punch cards and then stopping. [1]

The first of my friends to get a microcomputer built it himself. It was sold as a kit by Heathkit. I remember vividly how impressed and envious I felt watching him sitting in front of it, typing programs right into the computer.

Computers were expensive in those days and it took me years of nagging before I convinced my father to buy one, a TRS-80, in about 1980. The gold standard then was the Apple II, but a TRS-80 was good enough. This was when I really started programming. I wrote simple games, a program to predict how high my model rockets would fly, and a word processor that my father used to write at least one book. There was only room in memory for about 2 pages of text, so he'd write 2 pages at a time and then print them out, but it was a lot better than a typewriter.

Though I liked programming, I didn't plan to study it in college. In college I was going to study philosophy, which sounded much more powerful. It seemed, to my naive high school self, to be the study of the ultimate truths, compared to which the things studied in other fields would be mere domain knowledge. What I discovered when I got to college was that the other fields took up so much of the space of ideas that there wasn't much left for these supposed ultimate truths. All that seemed left for philosophy were edge cases that people in other fields felt could safely be ignored.

I couldn't have put this into words when I was 18. All I knew at the time was that I kept taking philosophy courses and they kept being boring. So I decided to switch to AI.

AI was in the air in the mid 1980s, but there were two things especially that made me want to work on it: a novel by Heinlein called The Moon is a Harsh Mistress, which featured an intelligent computer called Mike, and a PBS documentary that showed Terry Winograd using SHRDLU. I haven't tried rereading The Moon is a Harsh Mistress, so I don't know how well it has aged, but when I read it I was drawn entirely into its world. It seemed only a matter of time before we'd have Mike, and when I saw Winograd using SHRDLU, it seemed like that time would be a few years at most. All you had to do was teach SHRDLU more words.

There weren't any classes in AI at Cornell then, not even graduate classes, so I started trying to teach myself. Which meant learning Lisp, since in those days Lisp was regarded as the language of AI. The commonly used programming languages then were pretty primitive, and programmers' ideas correspondingly so. The default language at Cornell was a Pascal-like language called PL/I, and the situation was similar elsewhere. Learning Lisp expanded my concept of a program so fast that it was years before I started to have a sense of where the new limits were. This was more like it; this was what I had expected college to do. It wasn't happening in a class, like it was supposed to, but that was ok. For the next couple years I was on a roll. I knew what I was going to do.

For my undergraduate thesis, I reverse-engineered SHRDLU. My God did I love working on that program. It was a pleasing bit of code, but what made it even more exciting was my belief — hard to imagine now, but not unique in 1985 — that it was already climbing the lower slopes of intelligence.

I had gotten into a program at Cornell that didn't make you choose a major. You could take whatever classes you liked, and choose whatever you liked to put on your degree. I of course chose "Artificial Intelligence." When I got the actual physical diploma, I was dismayed to find that the quotes had been included, which made them read as scare-quotes. At the time this bothered me, but now it seems amusingly accurate, for reasons I was about to discover.

I applied to 3 grad schools: MIT and Yale, which were renowned for AI at the time, and Harvard, which I'd visited because Rich Draves went there, and was also home to Bill Woods, who'd invented the type of parser I used in my SHRDLU clone. Only Harvard accepted me, so that was where I went.

I don't remember the moment it happened, or if there even was a specific moment, but during the first year of grad school I realized that AI, as practiced at the time, was a hoax. By which I mean the sort of AI in which a program that's told "the dog is sitting on the chair" translates this into some formal representation and adds it to the list of things it knows.

What these programs really showed was that there's a subset of natural language that's a formal language. But a very proper subset. It was clear that there was an unbridgeable gap between what they could do and actually understanding natural language. It was not, in fact, simply a matter of teaching SHRDLU more words. That whole way of doing AI, with explicit data structures representing concepts, was not going to work. Its brokenness did, as so often happens, generate a lot of opportunities to write papers about various band-aids that could be applied to it, but it was never going to get us Mike.

So I looked around to see what I could salvage from the wreckage of my plans, and there was Lisp. I knew from experience that Lisp was interesting for its own sake and not just for its association with AI, even though that was the main reason people cared about it at the time. So I decided to focus on Lisp. In fact, I decided to write a book about Lisp hacking. It's scary to think how little I knew about Lisp hacking when I started writing that book. But there's nothing like writing a book about something to help you learn it. The book, On Lisp, wasn't published till 1993, but I wrote much of it in grad school.

Computer Science is an uneasy alliance between two halves, theory and systems. The theory people prove things, and the systems people build things. I wanted to build things. I had plenty of respect for theory — indeed, a sneaking suspicion that it was the more admirable of the two halves — but building things seemed so much more exciting.

The problem with systems work, though, was that it didn't last. Any program you wrote today, no matter how good, would be obsolete in a couple decades at best. People might mention your software in footnotes, but no one would actually use it. And indeed, it would seem very feeble work. Only people with a sense of the history of the field would even realize that, in its time, it had been good.

There were some surplus Xerox Dandelions floating around the computer lab at one point. Anyone who wanted one to play around with could have one. I was briefly tempted, but they were so slow by present standards; what was the point? No one else wanted one either, so off they went. That was what happened to systems work.

I wanted not just to build things, but to build things that would last.

In this dissatisfied state I went in 1988 to visit Rich Draves at CMU, where he was in grad school. One day I went to visit the Carnegie Institute, where I'd spent a lot of time as a kid. While looking at a painting there I realized something that might seem obvious, but was a big surprise to me. There, right on the wall, was something you could make that would last. Paintings didn't become obsolete. Some of the best ones were hundreds of years old.

And moreover this was something you could make a living doing. Not as easily as you could by writing software, of course, but I thought if you were really industrious and lived really cheaply, it had to be possible to make enough to survive. And as an artist you could be truly independent. You wouldn't have a boss, or even need to get research funding.

I had always liked looking at paintings. Could I make them? I had no idea. I'd never imagined it was even possible. I knew intellectually that people made art — that it didn't just appear spontaneously — but it was as if the people who made it were a different species. They either lived long ago or were mysterious geniuses doing strange things in profiles in Life magazine. The idea of actually being able to make art, to put that verb before that noun, seemed almost miraculous.

That fall I started taking art classes at Harvard. Grad students could take classes in any department, and my advisor, Tom Cheatham, was very easy going. If he even knew about the strange classes I was taking, he never said anything.

So now I was in a PhD program in computer science, yet planning to be an artist, yet also genuinely in love with Lisp hacking and working away at On Lisp. In other words, like many a grad student, I was working energetically on multiple projects that were not my thesis.

I didn't see a way out of this situation. I didn't want to drop out of grad school, but how else was I going to get out? I remember when my friend Robert Morris got kicked out of Cornell for writing the internet worm of 1988, I was envious that he'd found such a spectacular way to get out of grad school.

Then one day in April 1990 a crack appeared in the wall. I ran into professor Cheatham and he asked if I was far enough along to graduate that June. I didn't have a word of my dissertation written, but in what must have been the quickest bit of thinking in my life, I decided to take a shot at writing one in the 5 weeks or so that remained before the deadline, reusing parts of On Lisp where I could, and I was able to respond, with no perceptible delay "Yes, I think so. I'll give you something to read in a few days."

I picked applications of continuations as the topic. In retrospect I should have written about macros and embedded languages. There's a whole world there that's barely been explored. But all I wanted was to get out of grad school, and my rapidly written dissertation sufficed, just barely.

Meanwhile I was applying to art schools. I applied to two: RISD in the US, and the Accademia di Belli Arti in Florence, which, because it was the oldest art school, I imagined would be good. RISD accepted me, and I never heard back from the Accademia, so off to Providence I went.

I'd applied for the BFA program at RISD, which meant in effect that I had to go to college again. This was not as strange as it sounds, because I was only 25, and art schools are full of people of different ages. RISD counted me as a transfer sophomore and said I had to do the foundation that summer. The foundation means the classes that everyone has to take in fundamental subjects like drawing, color, and design.

Toward the end of the summer I got a big surprise: a letter from the Accademia, which had been delayed because they'd sent it to Cambridge England instead of Cambridge Massachusetts, inviting me to take the entrance exam in Florence that fall. This was now only weeks away. My nice landlady let me leave my stuff in her attic. I had some money saved from consulting work I'd done in grad school; there was probably enough to last a year if I lived cheaply. Now all I had to do was learn Italian.

Only stranieri (foreigners) had to take this entrance exam. In retrospect it may well have been a way of excluding them, because there were so many stranieri attracted by the idea of studying art in Florence that the Italian students would otherwise have been outnumbered. I was in decent shape at painting and drawing from the RISD foundation that summer, but I still don't know how I managed to pass the written exam. I remember that I answered the essay question by writing about Cezanne, and that I cranked up the intellectual level as high as I could to make the most of my limited vocabulary. [2]

I'm only up to age 25 and already there are such conspicuous patterns. Here I was, yet again about to attend some august institution in the hopes of learning about some prestigious subject, and yet again about to be disappointed. The students and faculty in the painting department at the Accademia were the nicest people you could imagine, but they had long since arrived at an arrangement whereby the students wouldn't require the faculty to teach anything, and in return the faculty wouldn't require the students to learn anything. And at the same time all involved would adhere outwardly to the conventions of a 19th century atelier. We actually had one of those little stoves, fed with kindling, that you see in 19th century studio paintings, and a nude model sitting as close to it as possible without getting burned. Except hardly anyone else painted her besides me. The rest of the students spent their time chatting or occasionally trying to imitate things they'd seen in American art magazines.

Our model turned out to live just down the street from me. She made a living from a combination of modelling and making fakes for a local antique dealer. She'd copy an obscure old painting out of a book, and then he'd take the copy and maltreat it to make it look old. [3]

While I was a student at the Accademia I started painting still lives in my bedroom at night. These paintings were tiny, because the room was, and because I painted them on leftover scraps of canvas, which was all I could afford at the time. Painting still lives is different from painting people, because the subject, as its name suggests, can't move. People can't sit for more than about 15 minutes at a time, and when they do they don't sit very still. So the traditional m.o. for painting people is to know how to paint a generic person, which you then modify to match the specific person you're painting. Whereas a still life you can, if you want, copy pixel by pixel from what you're seeing. You don't want to stop there, of course, or you get merely photographic accuracy, and what makes a still life interesting is that it's been through a head. You want to emphasize the visual cues that tell you, for example, that the reason the color changes suddenly at a certain point is that it's the edge of an object. By subtly emphasizing such things you can make paintings that are more realistic than photographs not just in some metaphorical sense, but in the strict information-theoretic sense. [4]

I liked painting still lives because I was curious about what I was seeing. In everyday life, we aren't consciously aware of much we're seeing. Most visual perception is handled by low-level processes that merely tell your brain "that's a water droplet" without telling you details like where the lightest and darkest points are, or "that's a bush" without telling you the shape and position of every leaf. This is a feature of brains, not a bug. In everyday life it would be distracting to notice every leaf on every bush. But when you have to paint something, you have to look more closely, and when you do there's a lot to see. You can still be noticing new things after days of trying to paint something people usually take for granted, just as you can after days of trying to write an essay about something people usually take for granted.

This is not the only way to paint. I'm not 100% sure it's even a good way to paint. But it seemed a good enough bet to be worth trying.

Our teacher, professor Ulivi, was a nice guy. He could see I worked hard, and gave me a good grade, which he wrote down in a sort of passport each student had. But the Accademia wasn't teaching me anything except Italian, and my money was running out, so at the end of the first year I went back to the US.

I wanted to go back to RISD, but I was now broke and RISD was very expensive, so I decided to get a job for a year and then return to RISD the next fall. I got one at a company called Interleaf, which made software for creating documents. You mean like Microsoft Word? Exactly. That was how I learned that low end software tends to eat high end software. But Interleaf still had a few years to live yet. [5]

Interleaf had done something pretty bold. Inspired by Emacs, they'd added a scripting language, and even made the scripting language a dialect of Lisp. Now they wanted a Lisp hacker to write things in it. This was the closest thing I've had to a normal job, and I hereby apologize to my boss and coworkers, because I was a bad employee. Their Lisp was the thinnest icing on a giant C cake, and since I didn't know C and didn't want to learn it, I never understood most of the software. Plus I was terribly irresponsible. This was back when a programming job meant showing up every day during certain working hours. That seemed unnatural to me, and on this point the rest of the world is coming around to my way of thinking, but at the time it caused a lot of friction. Toward the end of the year I spent much of my time surreptitiously working on On Lisp, which I had by this time gotten a contract to publish.

The good part was that I got paid huge amounts of money, especially by art student standards. In Florence, after paying my part of the rent, my budget for everything else had been $7 a day. Now I was getting paid more than 4 times that every hour, even when I was just sitting in a meeting. By living cheaply I not only managed to save enough to go back to RISD, but also paid off my college loans.

I learned some useful things at Interleaf, though they were mostly about what not to do. I learned that it's better for technology companies to be run by product people than sales people (though sales is a real skill and people who are good at it are really good at it), that it leads to bugs when code is edited by too many people, that cheap office space is no bargain if it's depressing, that planned meetings are inferior to corridor conversations, that big, bureaucratic customers are a dangerous source of money, and that there's not much overlap between conventional office hours and the optimal time for hacking, or conventional offices and the optimal place for it.

But the most important thing I learned, and which I used in both Viaweb and Y Combinator, is that the low end eats the high end: that it's good to be the "entry level" option, even though that will be less prestigious, because if you're not, someone else will be, and will squash you against the ceiling. Which in turn means that prestige is a danger sign.

When I left to go back to RISD the next fall, I arranged to do freelance work for the group that did projects for customers, and this was how I survived for the next several years. When I came back to visit for a project later on, someone told me about a new thing called HTML, which was, as he described it, a derivative of SGML. Markup language enthusiasts were an occupational hazard at Interleaf and I ignored him, but this HTML thing later became a big part of my life.

In the fall of 1992 I moved back to Providence to continue at RISD. The foundation had merely been intro stuff, and the Accademia had been a (very civilized) joke. Now I was going to see what real art school was like. But alas it was more like the Accademia than not. Better organized, certainly, and a lot more expensive, but it was now becoming clear that art school did not bear the same relationship to art that medical school bore to medicine. At least not the painting department. The textile department, which my next door neighbor belonged to, seemed to be pretty rigorous. No doubt illustration and architecture were too. But painting was post-rigorous. Painting students were supposed to express themselves, which to the more worldly ones meant to try to cook up some sort of distinctive signature style.

A signature style is the visual equivalent of what in show business is known as a "schtick": something that immediately identifies the work as yours and no one else's. For example, when you see a painting that looks like a certain kind of cartoon, you know it's by Roy Lichtenstein. So if you see a big painting of this type hanging in the apartment of a hedge fund manager, you know he paid millions of dollars for it. That's not always why artists have a signature style, but it's usually why buyers pay a lot for such work. [6]

There were plenty of earnest students too: kids who "could draw" in high school, and now had come to what was supposed to be the best art school in the country, to learn to draw even better. They tended to be confused and demoralized by what they found at RISD, but they kept going, because painting was what they did. I was not one of the kids who could draw in high school, but at RISD I was definitely closer to their tribe than the tribe of signature style seekers.

I learned a lot in the color class I took at RISD, but otherwise I was basically teaching myself to paint, and I could do that for free. So in 1993 I dropped out. I hung around Providence for a bit, and then my college friend Nancy Parmet did me a big favor. A rent-controlled apartment in a building her mother owned in New York was becoming vacant. Did I want it? It wasn't much more than my current place, and New York was supposed to be where the artists were. So yes, I wanted it! [7]

Asterix comics begin by zooming in on a tiny corner of Roman Gaul that turns out not to be controlled by the Romans. You can do something similar on a map of New York City: if you zoom in on the Upper East Side, there's a tiny corner that's not rich, or at least wasn't in 1993. It's called Yorkville, and that was my new home. Now I was a New York artist — in the strictly technical sense of making paintings and living in New York.

I was nervous about money, because I could sense that Interleaf was on the way down. Freelance Lisp hacking work was very rare, and I didn't want to have to program in another language, which in those days would have meant C++ if I was lucky. So with my unerring nose for financial opportunity, I decided to write another book on Lisp. This would be a popular book, the sort of book that could be used as a textbook. I imagined myself living frugally off the royalties and spending all my time painting. (The painting on the cover of this book, ANSI Common Lisp, is one that I painted around this time.)

The best thing about New York for me was the presence of Idelle and Julian Weber. Idelle Weber was a painter, one of the early photorealists, and I'd taken her painting class at Harvard. I've never known a teacher more beloved by her students. Large numbers of former students kept in touch with her, including me. After I moved to New York I became her de facto studio assistant.

She liked to paint on big, square canvases, 4 to 5 feet on a side. One day in late 1994 as I was stretching one of these monsters there was something on the radio about a famous fund manager. He wasn't that much older than me, and was super rich. The thought suddenly occurred to me: why don't I become rich? Then I'll be able to work on whatever I want.

Meanwhile I'd been hearing more and more about this new thing called the World Wide Web. Robert Morris showed it to me when I visited him in Cambridge, where he was now in grad school at Harvard. It seemed to me that the web would be a big deal. I'd seen what graphical user interfaces had done for the popularity of microcomputers. It seemed like the web would do the same for the internet.

If I wanted to get rich, here was the next train leaving the station. I was right about that part. What I got wrong was the idea. I decided we should start a company to put art galleries online. I can't honestly say, after reading so many Y Combinator applications, that this was the worst startup idea ever, but it was up there. Art galleries didn't want to be online, and still don't, not the fancy ones. That's not how they sell. I wrote some software to generate web sites for galleries, and Robert wrote some to resize images and set up an http server to serve the pages. Then we tried to sign up galleries. To call this a difficult sale would be an understatement. It was difficult to give away. A few galleries let us make sites for them for free, but none paid us.

Then some online stores started to appear, and I realized that except for the order buttons they were identical to the sites we'd been generating for galleries. This impressive-sounding thing called an "internet storefront" was something we already knew how to build.

So in the summer of 1995, after I submitted the camera-ready copy of ANSI Common Lisp to the publishers, we started trying to write software to build online stores. At first this was going to be normal desktop software, which in those days meant Windows software. That was an alarming prospect, because neither of us knew how to write Windows software or wanted to learn. We lived in the Unix world. But we decided we'd at least try writing a prototype store builder on Unix. Robert wrote a shopping cart, and I wrote a new site generator for stores — in Lisp, of course.

We were working out of Robert's apartment in Cambridge. His roommate was away for big chunks of time, during which I got to sleep in his room. For some reason there was no bed frame or sheets, just a mattress on the floor. One morning as I was lying on this mattress I had an idea that made me sit up like a capital L. What if we ran the software on the server, and let users control it by clicking on links? Then we'd never have to write anything to run on users' computers. We could generate the sites on the same server we'd serve them from. Users wouldn't need anything more than a browser.

This kind of software, known as a web app, is common now, but at the time it wasn't clear that it was even possible. To find out, we decided to try making a version of our store builder that you could control through the browser. A couple days later, on August 12, we had one that worked. The UI was horrible, but it proved you could build a whole store through the browser, without any client software or typing anything into the command line on the server.

Now we felt like we were really onto something. I had visions of a whole new generation of software working this way. You wouldn't need versions, or ports, or any of that crap. At Interleaf there had been a whole group called Release Engineering that seemed to be at least as big as the group that actually wrote the software. Now you could just update the software right on the server.

We started a new company we called Viaweb, after the fact that our software worked via the web, and we got $10,000 in seed funding from Idelle's husband Julian. In return for that and doing the initial legal work and giving us business advice, we gave him 10% of the company. Ten years later this deal became the model for Y Combinator's. We knew founders needed something like this, because we'd needed it ourselves.

At this stage I had a negative net worth, because the thousand dollars or so I had in the bank was more than counterbalanced by what I owed the government in taxes. (Had I diligently set aside the proper proportion of the money I'd made consulting for Interleaf? No, I had not.) So although Robert had his graduate student stipend, I needed that seed funding to live on.

We originally hoped to launch in September, but we got more ambitious about the software as we worked on it. Eventually we managed to build a WYSIWYG site builder, in the sense that as you were creating pages, they looked exactly like the static ones that would be generated later, except that instead of leading to static pages, the links all referred to closures stored in a hash table on the server.

It helped to have studied art, because the main goal of an online store builder is to make users look legit, and the key to looking legit is high production values. If you get page layouts and fonts and colors right, you can make a guy running a store out of his bedroom look more legit than a big company.

(If you're curious why my site looks so old-fashioned, it's because it's still made with this software. It may look clunky today, but in 1996 it was the last word in slick.)

In September, Robert rebelled. "We've been working on this for a month," he said, "and it's still not done." This is funny in retrospect, because he would still be working on it almost 3 years later. But I decided it might be prudent to recruit more programmers, and I asked Robert who else in grad school with him was really good. He recommended Trevor Blackwell, which surprised me at first, because at that point I knew Trevor mainly for his plan to reduce everything in his life to a stack of notecards, which he carried around with him. But Rtm was right, as usual. Trevor turned out to be a frighteningly effective hacker.

It was a lot of fun working with Robert and Trevor. They're the two most independent-minded people I know, and in completely different ways. If you could see inside Rtm's brain it would look like a colonial New England church, and if you could see inside Trevor's it would look like the worst excesses of Austrian Rococo.

We opened for business, with 6 stores, in January 1996. It was just as well we waited a few months, because although we worried we were late, we were actually almost fatally early. There was a lot of talk in the press then about ecommerce, but not many people actually wanted online stores. [8]

There were three main parts to the software: the editor, which people used to build sites and which I wrote, the shopping cart, which Robert wrote, and the manager, which kept track of orders and statistics, and which Trevor wrote. In its time, the editor was one of the best general-purpose site builders. I kept the code tight and didn't have to integrate with any other software except Robert's and Trevor's, so it was quite fun to work on. If all I'd had to do was work on this software, the next 3 years would have been the easiest of my life. Unfortunately I had to do a lot more, all of it stuff I was worse at than programming, and the next 3 years were instead the most stressful.

There were a lot of startups making ecommerce software in the second half of the 90s. We were determined to be the Microsoft Word, not the Interleaf. Which meant being easy to use and inexpensive. It was lucky for us that we were poor, because that caused us to make Viaweb even more inexpensive than we realized. We charged $100 a month for a small store and $300 a month for a big one. This low price was a big attraction, and a constant thorn in the sides of competitors, but it wasn't because of some clever insight that we set the price low. We had no idea what businesses paid for things. $300 a month seemed like a lot of money to us.

We did a lot of things right by accident like that. For example, we did what's now called "doing things that don't scale," although at the time we would have described it as "being so lame that we're driven to the most desperate measures to get users." The most common of which was building stores for them. This seemed particularly humiliating, since the whole raison d'etre of our software was that people could use it to make their own stores. But anything to get users.

We learned a lot more about retail than we wanted to know. For example, that if you could only have a small image of a man's shirt (and all images were small then by present standards), it was better to have a closeup of the collar than a picture of the whole shirt. The reason I remember learning this was that it meant I had to rescan about 30 images of men's shirts. My first set of scans were so beautiful too.

Though this felt wrong, it was exactly the right thing to be doing. Building stores for users taught us about retail, and about how it felt to use our software. I was initially both mystified and repelled by "business" and thought we needed a "business person" to be in charge of it, but once we started to get users, I was converted, in much the same way I was converted to fatherhood once I had kids. Whatever users wanted, I was all theirs. Maybe one day we'd have so many users that I couldn't scan their images for them, but in the meantime there was nothing more important to do.

Another thing I didn't get at the time is that growth rate is the ultimate test of a startup. Our growth rate was fine. We had about 70 stores at the end of 1996 and about 500 at the end of 1997. I mistakenly thought the thing that mattered was the absolute number of users. And that is the thing that matters in the sense that that's how much money you're making, and if you're not making enough, you might go out of business. But in the long term the growth rate takes care of the absolute number. If we'd been a startup I was advising at Y Combinator, I would have said: Stop being so stressed out, because you're doing fine. You're growing 7x a year. Just don't hire too many more people and you'll soon be profitable, and then you'll control your own destiny.

Alas I hired lots more people, partly because our investors wanted me to, and partly because that's what startups did during the Internet Bubble. A company with just a handful of employees would have seemed amateurish. So we didn't reach breakeven until about when Yahoo bought us in the summer of 1998. Which in turn meant we were at the mercy of investors for the entire life of the company. And since both we and our investors were noobs at startups, the result was a mess even by startup standards.

It was a huge relief when Yahoo bought us. In principle our Viaweb stock was valuable. It was a share in a business that was profitable and growing rapidly. But it didn't feel very valuable to me; I had no idea how to value a business, but I was all too keenly aware of the near-death experiences we seemed to have every few months. Nor had I changed my grad student lifestyle significantly since we started. So when Yahoo bought us it felt like going from rags to riches. Since we were going to California, I bought a car, a yellow 1998 VW GTI. I remember thinking that its leather seats alone were by far the most luxurious thing I owned.

The next year, from the summer of 1998 to the summer of 1999, must have been the least productive of my life. I didn't realize it at the time, but I was worn out from the effort and stress of running Viaweb. For a while after I got to California I tried to continue my usual m.o. of programming till 3 in the morning, but fatigue combined with Yahoo's prematurely aged culture and grim cube farm in Santa Clara gradually dragged me down. After a few months it felt disconcertingly like working at Interleaf.

Yahoo had given us a lot of options when they bought us. At the time I thought Yahoo was so overvalued that they'd never be worth anything, but to my astonishment the stock went up 5x in the next year. I hung on till the first chunk of options vested, then in the summer of 1999 I left. It had been so long since I'd painted anything that I'd half forgotten why I was doing this. My brain had been entirely full of software and men's shirts for 4 years. But I had done this to get rich so I could paint, I reminded myself, and now I was rich, so I should go paint.

When I said I was leaving, my boss at Yahoo had a long conversation with me about my plans. I told him all about the kinds of pictures I wanted to paint. At the time I was touched that he took such an interest in me. Now I realize it was because he thought I was lying. My options at that point were worth about $2 million a month. If I was leaving that kind of money on the table, it could only be to go and start some new startup, and if I did, I might take people with me. This was the height of the Internet Bubble, and Yahoo was ground zero of it. My boss was at that moment a billionaire. Leaving then to start a new startup must have seemed to him an insanely, and yet also plausibly, ambitious plan.

But I really was quitting to paint, and I started immediately. There was no time to lose. I'd already burned 4 years getting rich. Now when I talk to founders who are leaving after selling their companies, my advice is always the same: take a vacation. That's what I should have done, just gone off somewhere and done nothing for a month or two, but the idea never occurred to me.

So I tried to paint, but I just didn't seem to have any energy or ambition. Part of the problem was that I didn't know many people in California. I'd compounded this problem by buying a house up in the Santa Cruz Mountains, with a beautiful view but miles from anywhere. I stuck it out for a few more months, then in desperation I went back to New York, where unless you understand about rent control you'll be surprised to hear I still had my apartment, sealed up like a tomb of my old life. Idelle was in New York at least, and there were other people trying to paint there, even though I didn't know any of them.

When I got back to New York I resumed my old life, except now I was rich. It was as weird as it sounds. I resumed all my old patterns, except now there were doors where there hadn't been. Now when I was tired of walking, all I had to do was raise my hand, and (unless it was raining) a taxi would stop to pick me up. Now when I walked past charming little restaurants I could go in and order lunch. It was exciting for a while. Painting started to go better. I experimented with a new kind of still life where I'd paint one painting in the old way, then photograph it and print it, blown up, on canvas, and then use that as the underpainting for a second still life, painted from the same objects (which hopefully hadn't rotted yet).

Meanwhile I looked for an apartment to buy. Now I could actually choose what neighborhood to live in. Where, I asked myself and various real estate agents, is the Cambridge of New York? Aided by occasional visits to actual Cambridge, I gradually realized there wasn't one. Huh.

Around this time, in the spring of 2000, I had an idea. It was clear from our experience with Viaweb that web apps were the future. Why not build a web app for making web apps? Why not let people edit code on our server through the browser, and then host the resulting applications for them? [9] You could run all sorts of services on the servers that these applications could use just by making an API call: making and receiving phone calls, manipulating images, taking credit card payments, etc.

I got so excited about this idea that I couldn't think about anything else. It seemed obvious that this was the future. I didn't particularly want to start another company, but it was clear that this idea would have to be embodied as one, so I decided to move to Cambridge and start it. I hoped to lure Robert into working on it with me, but there I ran into a hitch. Robert was now a postdoc at MIT, and though he'd made a lot of money the last time I'd lured him into working on one of my schemes, it had also been a huge time sink. So while he agreed that it sounded like a plausible idea, he firmly refused to work on it.

Hmph. Well, I'd do it myself then. I recruited Dan Giffin, who had worked for Viaweb, and two undergrads who wanted summer jobs, and we got to work trying to build what it's now clear is about twenty companies and several open source projects worth of software. The language for defining applications would of course be a dialect of Lisp. But I wasn't so naive as to assume I could spring an overt Lisp on a general audience; we'd hide the parentheses, like Dylan did.

By then there was a name for the kind of company Viaweb was, an "application service provider," or ASP. This name didn't last long before it was replaced by "software as a service," but it was current for long enough that I named this new company after it: it was going to be called Aspra.

I started working on the application builder, Dan worked on network infrastructure, and the two undergrads worked on the first two services (images and phone calls). But about halfway through the summer I realized I really didn't want to run a company — especially not a big one, which it was looking like this would have to be. I'd only started Viaweb because I needed the money. Now that I didn't need money anymore, why was I doing this? If this vision had to be realized as a company, then screw the vision. I'd build a subset that could be done as an open source project.

Much to my surprise, the time I spent working on this stuff was not wasted after all. After we started Y Combinator, I would often encounter startups working on parts of this new architecture, and it was very useful to have spent so much time thinking about it and even trying to write some of it.

The subset I would build as an open source project was the new Lisp, whose parentheses I now wouldn't even have to hide. A lot of Lisp hackers dream of building a new Lisp, partly because one of the distinctive features of the language is that it has dialects, and partly, I think, because we have in our minds a Platonic form of Lisp that all existing dialects fall short of. I certainly did. So at the end of the summer Dan and I switched to working on this new dialect of Lisp, which I called Arc, in a house I bought in Cambridge.

The following spring, lightning struck. I was invited to give a talk at a Lisp conference, so I gave one about how we'd used Lisp at Viaweb. Afterward I put a postscript file of this talk online, on paulgraham.com, which I'd created years before using Viaweb but had never used for anything. In one day it got 30,000 page views. What on earth had happened? The referring urls showed that someone had posted it on Slashdot. [10]

Wow, I thought, there's an audience. If I write something and put it on the web, anyone can read it. That may seem obvious now, but it was surprising then. In the print era there was a narrow channel to readers, guarded by fierce monsters known as editors. The only way to get an audience for anything you wrote was to get it published as a book, or in a newspaper or magazine. Now anyone could publish anything.

This had been possible in principle since 1993, but not many people had realized it yet. I had been intimately involved with building the infrastructure of the web for most of that time, and a writer as well, and it had taken me 8 years to realize it. Even then it took me several years to understand the implications. It meant there would be a whole new generation of essays. [11]

In the print era, the channel for publishing essays had been vanishingly small. Except for a few officially anointed thinkers who went to the right parties in New York, the only people allowed to publish essays were specialists writing about their specialties. There were so many essays that had never been written, because there had been no way to publish them. Now they could be, and I was going to write them. [12]

I've worked on several different things, but to the extent there was a turning point where I figured out what to work on, it was when I started publishing essays online. From then on I knew that whatever else I did, I'd always write essays too.

I knew that online essays would be a marginal medium at first. Socially they'd seem more like rants posted by nutjobs on their GeoCities sites than the genteel and beautifully typeset compositions published in The New Yorker. But by this point I knew enough to find that encouraging instead of discouraging.

One of the most conspicuous patterns I've noticed in my life is how well it has worked, for me at least, to work on things that weren't prestigious. Still life has always been the least prestigious form of painting. Viaweb and Y Combinator both seemed lame when we started them. I still get the glassy eye from strangers when they ask what I'm writing, and I explain that it's an essay I'm going to publish on my web site. Even Lisp, though prestigious intellectually in something like the way Latin is, also seems about as hip.

It's not that unprestigious types of work are good per se. But when you find yourself drawn to some kind of work despite its current lack of prestige, it's a sign both that there's something real to be discovered there, and that you have the right kind of motives. Impure motives are a big danger for the ambitious. If anything is going to lead you astray, it will be the desire to impress people. So while working on things that aren't prestigious doesn't guarantee you're on the right track, it at least guarantees you're not on the most common type of wrong one.

Over the next several years I wrote lots of essays about all kinds of different topics. O'Reilly reprinted a collection of them as a book, called Hackers & Painters after one of the essays in it. I also worked on spam filters, and did some more painting. I used to have dinners for a group of friends every thursday night, which taught me how to cook for groups. And I bought another building in Cambridge, a former candy factory (and later, twas said, porn studio), to use as an office.

One night in October 2003 there was a big party at my house. It was a clever idea of my friend Maria Daniels, who was one of the thursday diners. Three separate hosts would all invite their friends to one party. So for every guest, two thirds of the other guests would be people they didn't know but would probably like. One of the guests was someone I didn't know but would turn out to like a lot: a woman called Jessica Livingston. A couple days later I asked her out.

Jessica was in charge of marketing at a Boston investment bank. This bank thought it understood startups, but over the next year, as she met friends of mine from the startup world, she was surprised how different reality was. And how colorful their stories were. So she decided to compile a book of interviews with startup founders.

When the bank had financial problems and she had to fire half her staff, she started looking for a new job. In early 2005 she interviewed for a marketing job at a Boston VC firm. It took them weeks to make up their minds, and during this time I started telling her about all the things that needed to be fixed about venture capital. They should make a larger number of smaller investments instead of a handful of giant ones, they should be funding younger, more technical founders instead of MBAs, they should let the founders remain as CEO, and so on.

One of my tricks for writing essays had always been to give talks. The prospect of having to stand up in front of a group of people and tell them something that won't waste their time is a great spur to the imagination. When the Harvard Computer Society, the undergrad computer club, asked me to give a talk, I decided I would tell them how to start a startup. Maybe they'd be able to avoid the worst of the mistakes we'd made.

So I gave this talk, in the course of which I told them that the best sources of seed funding were successful startup founders, because then they'd be sources of advice too. Whereupon it seemed they were all looking expectantly at me. Horrified at the prospect of having my inbox flooded by business plans (if I'd only known), I blurted out "But not me!" and went on with the talk. But afterward it occurred to me that I should really stop procrastinating about angel investing. I'd been meaning to since Yahoo bought us, and now it was 7 years later and I still hadn't done one angel investment.

Meanwhile I had been scheming with Robert and Trevor about projects we could work on together. I missed working with them, and it seemed like there had to be something we could collaborate on.

As Jessica and I were walking home from dinner on March 11, at the corner of Garden and Walker streets, these three threads converged. Screw the VCs who were taking so long to make up their minds. We'd start our own investment firm and actually implement the ideas we'd been talking about. I'd fund it, and Jessica could quit her job and work for it, and we'd get Robert and Trevor as partners too. [13]

Once again, ignorance worked in our favor. We had no idea how to be angel investors, and in Boston in 2005 there were no Ron Conways to learn from. So we just made what seemed like the obvious choices, and some of the things we did turned out to be novel.

There are multiple components to Y Combinator, and we didn't figure them all out at once. The part we got first was to be an angel firm. In those days, those two words didn't go together. There were VC firms, which were organized companies with people whose job it was to make investments, but they only did big, million dollar investments. And there were angels, who did smaller investments, but these were individuals who were usually focused on other things and made investments on the side. And neither of them helped founders enough in the beginning. We knew how helpless founders were in some respects, because we remembered how helpless we'd been. For example, one thing Julian had done for us that seemed to us like magic was to get us set up as a company. We were fine writing fairly difficult software, but actually getting incorporated, with bylaws and stock and all that stuff, how on earth did you do that? Our plan was not only to make seed investments, but to do for startups everything Julian had done for us.

YC was not organized as a fund. It was cheap enough to run that we funded it with our own money. That went right by 99% of readers, but professional investors are thinking "Wow, that means they got all the returns." But once again, this was not due to any particular insight on our part. We didn't know how VC firms were organized. It never occurred to us to try to raise a fund, and if it had, we wouldn't have known where to start. [14]

The most distinctive thing about YC is the batch model: to fund a bunch of startups all at once, twice a year, and then to spend three months focusing intensively on trying to help them. That part we discovered by accident, not merely implicitly but explicitly due to our ignorance about investing. We needed to get experience as investors. What better way, we thought, than to fund a whole bunch of startups at once? We knew undergrads got temporary jobs at tech companies during the summer. Why not organize a summer program where they'd start startups instead? We wouldn't feel guilty for being in a sense fake investors, because they would in a similar sense be fake founders. So while we probably wouldn't make much money out of it, we'd at least get to practice being investors on them, and they for their part would probably have a more interesting summer than they would working at Microsoft.

We'd use the building I owned in Cambridge as our headquarters. We'd all have dinner there once a week — on tuesdays, since I was already cooking for the thursday diners on thursdays — and after dinner we'd bring in experts on startups to give talks.

We knew undergrads were deciding then about summer jobs, so in a matter of days we cooked up something we called the Summer Founders Program, and I posted an announcement on my site, inviting undergrads to apply. I had never imagined that writing essays would be a way to get "deal flow," as investors call it, but it turned out to be the perfect source. [15] We got 225 applications for the Summer Founders Program, and we were surprised to find that a lot of them were from people who'd already graduated, or were about to that spring. Already this SFP thing was starting to feel more serious than we'd intended.

We invited about 20 of the 225 groups to interview in person, and from those we picked 8 to fund. They were an impressive group. That first batch included reddit, Justin Kan and Emmett Shear, who went on to found Twitch, Aaron Swartz, who had already helped write the RSS spec and would a few years later become a martyr for open access, and Sam Altman, who would later become the second president of YC. I don't think it was entirely luck that the first batch was so good. You had to be pretty bold to sign up for a weird thing like the Summer Founders Program instead of a summer job at a legit place like Microsoft or Goldman Sachs.

The deal for startups was based on a combination of the deal we did with Julian ($10k for 10%) and what Robert said MIT grad students got for the summer ($6k). We invested $6k per founder, which in the typical two-founder case was $12k, in return for 6%. That had to be fair, because it was twice as good as the deal we ourselves had taken. Plus that first summer, which was really hot, Jessica brought the founders free air conditioners. [16]

Fairly quickly I realized that we had stumbled upon the way to scale startup funding. Funding startups in batches was more convenient for us, because it meant we could do things for a lot of startups at once, but being part of a batch was better for the startups too. It solved one of the biggest problems faced by founders: the isolation. Now you not only had colleagues, but colleagues who understood the problems you were facing and could tell you how they were solving them.

As YC grew, we started to notice other advantages of scale. The alumni became a tight community, dedicated to helping one another, and especially the current batch, whose shoes they remembered being in. We also noticed that the startups were becoming one another's customers. We used to refer jokingly to the "YC GDP," but as YC grows this becomes less and less of a joke. Now lots of startups get their initial set of customers almost entirely from among their batchmates.

I had not originally intended YC to be a full-time job. I was going to do three things: hack, write essays, and work on YC. As YC grew, and I grew more excited about it, it started to take up a lot more than a third of my attention. But for the first few years I was still able to work on other things.

In the summer of 2006, Robert and I started working on a new version of Arc. This one was reasonably fast, because it was compiled into Scheme. To test this new Arc, I wrote Hacker News in it. It was originally meant to be a news aggregator for startup founders and was called Startup News, but after a few months I got tired of reading about nothing but startups. Plus it wasn't startup founders we wanted to reach. It was future startup founders. So I changed the name to Hacker News and the topic to whatever engaged one's intellectual curiosity.

HN was no doubt good for YC, but it was also by far the biggest source of stress for me. If all I'd had to do was select and help founders, life would have been so easy. And that implies that HN was a mistake. Surely the biggest source of stress in one's work should at least be something close to the core of the work. Whereas I was like someone who was in pain while running a marathon not from the exertion of running, but because I had a blister from an ill-fitting shoe. When I was dealing with some urgent problem during YC, there was about a 60% chance it had to do with HN, and a 40% chance it had do with everything else combined. [17]

As well as HN, I wrote all of YC's internal software in Arc. But while I continued to work a good deal in Arc, I gradually stopped working on Arc, partly because I didn't have time to, and partly because it was a lot less attractive to mess around with the language now that we had all this infrastructure depending on it. So now my three projects were reduced to two: writing essays and working on YC.

YC was different from other kinds of work I've done. Instead of deciding for myself what to work on, the problems came to me. Every 6 months there was a new batch of startups, and their problems, whatever they were, became our problems. It was very engaging work, because their problems were quite varied, and the good founders were very effective. If you were trying to learn the most you could about startups in the shortest possible time, you couldn't have picked a better way to do it.

There were parts of the job I didn't like. Disputes between cofounders, figuring out when people were lying to us, fighting with people who maltreated the startups, and so on. But I worked hard even at the parts I didn't like. I was haunted by something Kevin Hale once said about companies: "No one works harder than the boss." He meant it both descriptively and prescriptively, and it was the second part that scared me. I wanted YC to be good, so if how hard I worked set the upper bound on how hard everyone else worked, I'd better work very hard.

One day in 2010, when he was visiting California for interviews, Robert Morris did something astonishing: he offered me unsolicited advice. I can only remember him doing that once before. One day at Viaweb, when I was bent over double from a kidney stone, he suggested that it would be a good idea for him to take me to the hospital. That was what it took for Rtm to offer unsolicited advice. So I remember his exact words very clearly. "You know," he said, "you should make sure Y Combinator isn't the last cool thing you do."

At the time I didn't understand what he meant, but gradually it dawned on me that he was saying I should quit. This seemed strange advice, because YC was doing great. But if there was one thing rarer than Rtm offering advice, it was Rtm being wrong. So this set me thinking. It was true that on my current trajectory, YC would be the last thing I did, because it was only taking up more of my attention. It had already eaten Arc, and was in the process of eating essays too. Either YC was my life's work or I'd have to leave eventually. And it wasn't, so I would.

In the summer of 2012 my mother had a stroke, and the cause turned out to be a blood clot caused by colon cancer. The stroke destroyed her balance, and she was put in a nursing home, but she really wanted to get out of it and back to her house, and my sister and I were determined to help her do it. I used to fly up to Oregon to visit her regularly, and I had a lot of time to think on those flights. On one of them I realized I was ready to hand YC over to someone else.

I asked Jessica if she wanted to be president, but she didn't, so we decided we'd try to recruit Sam Altman. We talked to Robert and Trevor and we agreed to make it a complete changing of the guard. Up till that point YC had been controlled by the original LLC we four had started. But we wanted YC to last for a long time, and to do that it couldn't be controlled by the founders. So if Sam said yes, we'd let him reorganize YC. Robert and I would retire, and Jessica and Trevor would become ordinary partners.

When we asked Sam if he wanted to be president of YC, initially he said no. He wanted to start a startup to make nuclear reactors. But I kept at it, and in October 2013 he finally agreed. We decided he'd take over starting with the winter 2014 batch. For the rest of 2013 I left running YC more and more to Sam, partly so he could learn the job, and partly because I was focused on my mother, whose cancer had returned.

She died on January 15, 2014. We knew this was coming, but it was still hard when it did.

I kept working on YC till March, to help get that batch of startups through Demo Day, then I checked out pretty completely. (I still talk to alumni and to new startups working on things I'm interested in, but that only takes a few hours a week.)

What should I do next? Rtm's advice hadn't included anything about that. I wanted to do something completely different, so I decided I'd paint. I wanted to see how good I could get if I really focused on it. So the day after I stopped working on YC, I started painting. I was rusty and it took a while to get back into shape, but it was at least completely engaging. [18]

I spent most of the rest of 2014 painting. I'd never been able to work so uninterruptedly before, and I got to be better than I had been. Not good enough, but better. Then in November, right in the middle of a painting, I ran out of steam. Up till that point I'd always been curious to see how the painting I was working on would turn out, but suddenly finishing this one seemed like a chore. So I stopped working on it and cleaned my brushes and haven't painted since. So far anyway.

I realize that sounds rather wimpy. But attention is a zero sum game. If you can choose what to work on, and you choose a project that's not the best one (or at least a good one) for you, then it's getting in the way of another project that is. And at 50 there was some opportunity cost to screwing around.

I started writing essays again, and wrote a bunch of new ones over the next few months. I even wrote a couple that weren't about startups. Then in March 2015 I started working on Lisp again.

The distinctive thing about Lisp is that its core is a language defined by writing an interpreter in itself. It wasn't originally intended as a programming language in the ordinary sense. It was meant to be a formal model of computation, an alternative to the Turing machine. If you want to write an interpreter for a language in itself, what's the minimum set of predefined operators you need? The Lisp that John McCarthy invented, or more accurately discovered, is an answer to that question. [19]

McCarthy didn't realize this Lisp could even be used to program computers till his grad student Steve Russell suggested it. Russell translated McCarthy's interpreter into IBM 704 machine language, and from that point Lisp started also to be a programming language in the ordinary sense. But its origins as a model of computation gave it a power and elegance that other languages couldn't match. It was this that attracted me in college, though I didn't understand why at the time.

McCarthy's 1960 Lisp did nothing more than interpret Lisp expressions. It was missing a lot of things you'd want in a programming language. So these had to be added, and when they were, they weren't defined using McCarthy's original axiomatic approach. That wouldn't have been feasible at the time. McCarthy tested his interpreter by hand-simulating the execution of programs. But it was already getting close to the limit of interpreters you could test that way — indeed, there was a bug in it that McCarthy had overlooked. To test a more complicated interpreter, you'd have had to run it, and computers then weren't powerful enough.

Now they are, though. Now you could continue using McCarthy's axiomatic approach till you'd defined a complete programming language. And as long as every change you made to McCarthy's Lisp was a discoveredness-preserving transformation, you could, in principle, end up with a complete language that had this quality. Harder to do than to talk about, of course, but if it was possible in principle, why not try? So I decided to take a shot at it. It took 4 years, from March 26, 2015 to October 12, 2019. It was fortunate that I had a precisely defined goal, or it would have been hard to keep at it for so long.

I wrote this new Lisp, called Bel, in itself in Arc. That may sound like a contradiction, but it's an indication of the sort of trickery I had to engage in to make this work. By means of an egregious collection of hacks I managed to make something close enough to an interpreter written in itself that could actually run. Not fast, but fast enough to test.

I had to ban myself from writing essays during most of this time, or I'd never have finished. In late 2015 I spent 3 months writing essays, and when I went back to working on Bel I could barely understand the code. Not so much because it was badly written as because the problem is so convoluted. When you're working on an interpreter written in itself, it's hard to keep track of what's happening at what level, and errors can be practically encrypted by the time you get them.

So I said no more essays till Bel was done. But I told few people about Bel while I was working on it. So for years it must have seemed that I was doing nothing, when in fact I was working harder than I'd ever worked on anything. Occasionally after wrestling for hours with some gruesome bug I'd check Twitter or HN and see someone asking "Does Paul Graham still code?"

Working on Bel was hard but satisfying. I worked on it so intensively that at any given time I had a decent chunk of the code in my head and could write more there. I remember taking the boys to the coast on a sunny day in 2015 and figuring out how to deal with some problem involving continuations while I watched them play in the tide pools. It felt like I was doing life right. I remember that because I was slightly dismayed at how novel it felt. The good news is that I had more moments like this over the next few years.

In the summer of 2016 we moved to England. We wanted our kids to see what it was like living in another country, and since I was a British citizen by birth, that seemed the obvious choice. We only meant to stay for a year, but we liked it so much that we still live there. So most of Bel was written in England.

In the fall of 2019, Bel was finally finished. Like McCarthy's original Lisp, it's a spec rather than an implementation, although like McCarthy's Lisp it's a spec expressed as code.

Now that I could write essays again, I wrote a bunch about topics I'd had stacked up. I kept writing essays through 2020, but I also started to think about other things I could work on. How should I choose what to do? Well, how had I chosen what to work on in the past? I wrote an essay for myself to answer that question, and I was surprised how long and messy the answer turned out to be. If this surprised me, who'd lived it, then I thought perhaps it would be interesting to other people, and encouraging to those with similarly messy lives. So I wrote a more detailed version for others to read, and this is the last sentence of it.









Notes

[1] My experience skipped a step in the evolution of computers: time-sharing machines with interactive OSes. I went straight from batch processing to microcomputers, which made microcomputers seem all the more exciting.

[2] Italian words for abstract concepts can nearly always be predicted from their English cognates (except for occasional traps like polluzione). It's the everyday words that differ. So if you string together a lot of abstract concepts with a few simple verbs, you can make a little Italian go a long way.

[3] I lived at Piazza San Felice 4, so my walk to the Accademia went straight down the spine of old Florence: past the Pitti, across the bridge, past Orsanmichele, between the Duomo and the Baptistery, and then up Via Ricasoli to Piazza San Marco. I saw Florence at street level in every possible condition, from empty dark winter evenings to sweltering summer days when the streets were packed with tourists.

[4] You can of course paint people like still lives if you want to, and they're willing. That sort of portrait is arguably the apex of still life painting, though the long sitting does tend to produce pained expressions in the sitters.

[5] Interleaf was one of many companies that had smart people and built impressive technology, and yet got crushed by Moore's Law. In the 1990s the exponential growth in the power of commodity (i.e. Intel) processors rolled up high-end, special-purpose hardware and software companies like a bulldozer.

[6] The signature style seekers at RISD weren't specifically mercenary. In the art world, money and coolness are tightly coupled. Anything expensive comes to be seen as cool, and anything seen as cool will soon become equally expensive.

[7] Technically the apartment wasn't rent-controlled but rent-stabilized, but this is a refinement only New Yorkers would know or care about. The point is that it was really cheap, less than half market price.

[8] Most software you can launch as soon as it's done. But when the software is an online store builder and you're hosting the stores, if you don't have any users yet, that fact will be painfully obvious. So before we could launch publicly we had to launch privately, in the sense of recruiting an initial set of users and making sure they had decent-looking stores.

[9] We'd had a code editor in Viaweb for users to define their own page styles. They didn't know it, but they were editing Lisp expressions underneath. But this wasn't an app editor, because the code ran when the merchants' sites were generated, not when shoppers visited them.

[10] This was the first instance of what is now a familiar experience, and so was what happened next, when I read the comments and found they were full of angry people. How could I claim that Lisp was better than other languages? Weren't they all Turing complete? People who see the responses to essays I write sometimes tell me how sorry they feel for me, but I'm not exaggerating when I reply that it has always been like this, since the very beginning. It comes with the territory. An essay must tell readers things they don't already know, and some people dislike being told such things.

[11] People put plenty of stuff on the internet in the 90s of course, but putting something online is not the same as publishing it online. Publishing online means you treat the online version as the (or at least a) primary version.

[12] There is a general lesson here that our experience with Y Combinator also teaches: Customs continue to constrain you long after the restrictions that caused them have disappeared. Customary VC practice had once, like the customs about publishing essays, been based on real constraints. Startups had once been much more expensive to start, and proportionally rare. Now they could be cheap and common, but the VCs' customs still reflected the old world, just as customs about writing essays still reflected the constraints of the print era.

Which in turn implies that people who are independent-minded (i.e. less influenced by custom) will have an advantage in fields affected by rapid change (where customs are more likely to be obsolete).

Here's an interesting point, though: you can't always predict which fields will be affected by rapid change. Obviously software and venture capital will be, but who would have predicted that essay writing would be?

[13] Y Combinator was not the original name. At first we were called Cambridge Seed. But we didn't want a regional name, in case someone copied us in Silicon Valley, so we renamed ourselves after one of the coolest tricks in the lambda calculus, the Y combinator.

I picked orange as our color partly because it's the warmest, and partly because no VC used it. In 2005 all the VCs used staid colors like maroon, navy blue, and forest green, because they were trying to appeal to LPs, not founders. The YC logo itself is an inside joke: the Viaweb logo had been a white V on a red circle, so I made the YC logo a white Y on an orange square.

[14] YC did become a fund for a couple years starting in 2009, because it was getting so big I could no longer afford to fund it personally. But after Heroku got bought we had enough money to go back to being self-funded.

[15] I've never liked the term "deal flow," because it implies that the number of new startups at any given time is fixed. This is not only false, but it's the purpose of YC to falsify it, by causing startups to be founded that would not otherwise have existed.

[16] She reports that they were all different shapes and sizes, because there was a run on air conditioners and she had to get whatever she could, but that they were all heavier than she could carry now.

[17] Another problem with HN was a bizarre edge case that occurs when you both write essays and run a forum. When you run a forum, you're assumed to see if not every conversation, at least every conversation involving you. And when you write essays, people post highly imaginative misinterpretations of them on forums. Individually these two phenomena are tedious but bearable, but the combination is disastrous. You actually have to respond to the misinterpretations, because the assumption that you're present in the conversation means that not responding to any sufficiently upvoted misinterpretation reads as a tacit admission that it's correct. But that in turn encourages more; anyone who wants to pick a fight with you senses that now is their chance.

[18] The worst thing about leaving YC was not working with Jessica anymore. We'd been working on YC almost the whole time we'd known each other, and we'd neither tried nor wanted to separate it from our personal lives, so leaving was like pulling up a deeply rooted tree.

[19] One way to get more precise about the concept of invented vs discovered is to talk about space aliens. Any sufficiently advanced alien civilization would certainly know about the Pythagorean theorem, for example. I believe, though with less certainty, that they would also know about the Lisp in McCarthy's 1960 paper.

But if so there's no reason to suppose that this is the limit of the language that might be known to them. Presumably aliens need numbers and errors and I/O too. So it seems likely there exists at least one path out of McCarthy's Lisp along which discoveredness is preserved.



Thanks to Trevor Blackwell, John Collison, Patrick Collison, Daniel Gackle, Ralph Hazell, Jessica Livingston, Robert Morris, and Harj Taggar for reading drafts of this.
-     start_char_idxNend_char_idxN
text_template{metadata_str}

{content}metadata_template{key}: {value}metadata_seperator
u__fields_set__(h
h$__private_attribute_values__}uballmllama_index.llms.openaiOpenAI)}(h}(callback_managerllama_index.callbacks.baseCallbackManager)}(handlers]
_trace_mapcollectionsdefaultdictbuiltinslistRroot]($3ca01958-dc0c-4606-9b8b-2519b32b2b18$8f6cf6fd-9bef-4e3b-8d94-944f9ddc337c$6d8f09dc-25fc-4a52-af0d-267a4025deaf$bc09f7ca-f786-4ac9-95e1-f01d6cf7c367$c2645982-316b-45c6-afd5-afb6e8911a00$06f156b0-d55f-484b-8026-377099c908a1$94cb388e-d13c-4e3a-8a52-56dc17d6de70$3a61b1be-f076-431f-89ed-7dd68b0ac5f3$78b86b5b-68d6-428f-ad5a-da2131886fde$9fc8e136-44dd-4429-a9e3-2dd69e2e7c9f$270820f6-34a6-4a79-8452-468ee9563cf9$2904f674-67ab-4761-b293-bd0d286d7234$1af3bd44-9de2-4b2d-848f-7dc7c9cb3047$cb226272-fa3f-4252-adc5-dc9d1ce85f27$414ece46-5a58-4bc1-8014-2b7c21bb8e14$bbf78b97-d9db-4938-a53f-18913e8ebb86$6ebcb363-f118-49a9-9dd9-88985046257a$f2e5a866-421b-43dc-b213-e4e4835c0fb7$321f4a8b-1dc4-4bf0-a987-3438c3300b1e$48f5f443-b779-4ad8-8b1b-354dfe017a41$b1704be9-a84f-4134-b73a-a5f0c8287e04$a2fcc2d3-3234-48d2-a6c2-be7bf5fa5b23$4c02e70d-1348-44a6-b2dc-1c1ccfbd3729$0f7f534f-b516-4701-bb8b-0c850bd9e485$5d9e663d-3377-468d-becc-b9c0f80939f4$4340f31f-8fe1-4acf-b3b8-e1ee1aafb770$d6e546a0-cf31-466d-a2ac-d28e4efb61d3$bafed2a7-83a7-49b2-a16b-e7daf380aaa4$7a8c5b89-59cd-467d-bad2-7fb48505eb0e$f046e9ef-d3cd-4c30-9c16-66c893a576cd$a371cd0a-a458-4e95-8b51-d4fb5f13c364$57cc453b-c92a-4015-a06f-dbf26ea2f550$eadf4a0c-b9c1-416f-aeb7-072808865e57$4f86513e-88dc-47cd-928d-fabc0cf359dd$9e5f7bc5-9d0d-4334-8e13-26063b874f8c$aa08bb2b-b1b3-47f6-8ca3-5684ef66c7a9$fd004167-043e-49ea-9050-5bb962dac426$81eab5cf-6efc-45a7-803a-b8f8e82b9a85$b59bbf3f-25ef-47b4-bd42-c9b0289450cd$db4c521b-23d5-492a-afea-4c48212abe42$95ef3942-0bdb-4283-a4db-5977d0955efc$212ed9b6-7cea-4783-8b83-fcb259de2e9c$eef93f85-8ce0-4f91-ba68-b877c47cf18c$c45dd65d-c677-494c-ba51-b5780fc9db70$e1c7f96d-61e9-4ef5-b8c4-32841b370d23$bd8431dc-fd53-4f50-b066-b8b08dc597d1$8dcf9ab8-cf6f-42b6-b2f5-a64679ea7ccc$570eb6a4-d213-420d-a4aa-524a4343fdaf$44643c3e-f3c5-4f5f-93d7-ffc966917798$c1495154-efb1-4117-b18f-40c19cb4f946$c090e8ba-3850-4b70-a254-640928d1af0b$d793c5f1-ba79-45cc-8463-8ddcdd31f4fd$a47d8a99-150a-49ab-b356-0da96b62be1c$73c8f2bf-57b2-46b2-b70d-3abdcc8d6891$0932b1b7-db4a-43f4-a36f-de1c1d5104d8$a8edba18-92f8-4939-b378-21ded44d9fe6$3852425f-f98d-4bcd-98c2-8f9388770a57$bbedd22e-3531-4007-8cec-e0a83119cd43esub
system_promptNmessages_to_promptllama_index.llms.generic_utilshcompletion_to_promptllama_index.llms.llmdefault_completion_to_prompt
output_parserNpydantic_program_modellama_index.typesPydanticProgramModedefaultRquery_wrapper_promptNmodel
gpt-3.5-turbotemperatureG?
max_tokensNadditional_kwargs}max_retriesKtimeoutG@N      default_headersNreuse_clientapi_key3sk-RsPbMHvziYCQzL94Or2WT3BlbkFJRlwYg3NeOwMdGmBYV43Fapi_basehttps://api.openai.com/v1api_version uh.(hhhhhhhhhhhhhhh9hhh0}ubnode_parser%llama_index.node_parser.text.sentenceSentenceSplitter)}(h}(include_metadatainclude_prev_next_relh9h<)}(h?]hAhDhGR(hJ]$f287abf9-9296-46c9-a50f-36c2b49de92eah]$5c2040c7-d947-49b1-a32b-0a8dc412c010auubid_func"llama_index.node_parser.node_utilsdefault_id_func
chunk_sizeM 
chunk_overlapKȌ	separator paragraph_separator


secondary_chunking_regex[^,.;。？！]+[,.;。？！]?uh.(hhhhhhhhh9h0}ubnodes](hTextNode)}(h}(h
$d4394ebb-57b9-462b-9c40-f1fb891146b7hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hNodeRelationship1RhRelatedNodeInfo)}(h}(node_idh	node_typeh
ObjectType4Rh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubh֌3Rh)}(h}(hߌ$f67769b3-3c1d-4fa2-abea-1e360d6e9545hh1Rh
}h"@409416dd5fb4dfe99dc3faee1c8d5bd29f3d16751f08c0723bf647ad39898421uh.(h
hhh"h0}ubuh"@52adc6b6edc58cae05c58ecda1e394e15258c1f52b8cdf380d314b3f99826356h$X  What I Worked On

February 2021

Before college the two main things I worked on, outside of school, were writing and programming. I didn't write essays. I wrote what beginning writers were supposed to write then, and probably still are: short stories. My stories were awful. They had hardly any plot, just characters with strong feelings, which I imagined made them deep.

The first programs I tried writing were on the IBM 1401 that our school district used for what was then called "data processing." This was in 9th grade, so I was 13 or 14. The school district's 1401 happened to be in the basement of our junior high school, and my friend Rich Draves and I got permission to use it. It was like a mini Bond villain's lair down there, with all these alien-looking machines — CPU, disk drives, printer, card reader — sitting up on a raised floor under bright fluorescent lights.

The language we used was an early version of Fortran. You had to type programs on punch cards, then stack them in the card reader and press a button to load the program into memory and run it. The result would ordinarily be to print something on the spectacularly loud printer.

I was puzzled by the 1401. I couldn't figure out what to do with it. And in retrospect there's not much I could have done with it. The only form of input to programs was data stored on punched cards, and I didn't have any data stored on punched cards. The only other option was to do things that didn't rely on any input, like calculate approximations of pi, but I didn't know enough math to do anything interesting of that type. So I'm not surprised I can't remember any programs I wrote, because they can't have done much. My clearest memory is of the moment I learned it was possible for programs not to terminate, when one of mine didn't. On a machine without time-sharing, this was a social as well as a technical error, as the data center manager's expression made clear.

With microcomputers, everything changed.h&Kh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
hhNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubh֌2Rh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"huh.(h
hhh"h0}ubhh)}(h}(hߌ$341696b9-fc22-4e98-9aff-29314d9727f4hhh
}h"@4836b1b7aa41f560d2f59555a6d8616f59f9131feae2649e5d5bb1929cbc729cuh.(h
hhh"h0}ubuh"hh$X  I was puzzled by the 1401. I couldn't figure out what to do with it. And in retrospect there's not much I could have done with it. The only form of input to programs was data stored on punched cards, and I didn't have any data stored on punched cards. The only other option was to do things that didn't rely on any input, like calculate approximations of pi, but I didn't know enough math to do anything interesting of that type. So I'm not surprised I can't remember any programs I wrote, because they can't have done much. My clearest memory is of the moment I learned it was possible for programs not to terminate, when one of mine didn't. On a machine without time-sharing, this was a social as well as a technical error, as the data center manager's expression made clear.

With microcomputers, everything changed. Now you could have a computer sitting right in front of you, on a desk, that could respond to your keystrokes as it was running instead of just churning through a stack of punch cards and then stopping. [1]

The first of my friends to get a microcomputer built it himself. It was sold as a kit by Heathkit. I remember vividly how impressed and envious I felt watching him sitting in front of it, typing programs right into the computer.

Computers were expensive in those days and it took me years of nagging before I convinced my father to buy one, a TRS-80, in about 1980. The gold standard then was the Apple II, but a TRS-80 was good enough. This was when I really started programming. I wrote simple games, a program to predict how high my model rockets would fly, and a word processor that my father used to write at least one book. There was only room in memory for about 2 pages of text, so he'd write 2 pages at a time and then print them out, but it was a lot better than a typewriter.

Though I liked programming, I didn't plan to study it in college. In college I was going to study philosophy, which sounded much more powerful.h&Mh'M4h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"huh.(h
hhh"h0}ubhh)}(h}(hߌ$bcb7136a-68c8-456a-994d-2b23290d4a8ahhh
}h"@7bb9dace5a0afb93c8540026ca65872fd579cbf46020137b9796ee12c16733b6uh.(h
hhh"h0}ubuh"j  h$X  I remember vividly how impressed and envious I felt watching him sitting in front of it, typing programs right into the computer.

Computers were expensive in those days and it took me years of nagging before I convinced my father to buy one, a TRS-80, in about 1980. The gold standard then was the Apple II, but a TRS-80 was good enough. This was when I really started programming. I wrote simple games, a program to predict how high my model rockets would fly, and a word processor that my father used to write at least one book. There was only room in memory for about 2 pages of text, so he'd write 2 pages at a time and then print them out, but it was a lot better than a typewriter.

Though I liked programming, I didn't plan to study it in college. In college I was going to study philosophy, which sounded much more powerful. It seemed, to my naive high school self, to be the study of the ultimate truths, compared to which the things studied in other fields would be mere domain knowledge. What I discovered when I got to college was that the other fields took up so much of the space of ideas that there wasn't much left for these supposed ultimate truths. All that seemed left for philosophy were edge cases that people in other fields felt could safely be ignored.

I couldn't have put this into words when I was 18. All I knew at the time was that I kept taking philosophy courses and they kept being boring. So I decided to switch to AI.

AI was in the air in the mid 1980s, but there were two things especially that made me want to work on it: a novel by Heinlein called The Moon is a Harsh Mistress, which featured an intelligent computer called Mike, and a PBS documentary that showed Terry Winograd using SHRDLU. I haven't tried rereading The Moon is a Harsh Mistress, so I don't know how well it has aged, but when I read it I was drawn entirely into its world. It seemed only a matter of time before we'd have Mike, and when I saw Winograd using SHRDLU, it seemed like that time would be a few years at most. All you had to do was teach SHRDLU more words.h&Mh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j2  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$83a6dc9c-4922-4344-a657-e4675eead4f0hhh
}h"@5995399a51bd8b8c3b7072413526fb499983be9ae56d7628558617dcb51b3406uh.(h
hhh"h0}ubuh"j4  h$X*  I couldn't have put this into words when I was 18. All I knew at the time was that I kept taking philosophy courses and they kept being boring. So I decided to switch to AI.

AI was in the air in the mid 1980s, but there were two things especially that made me want to work on it: a novel by Heinlein called The Moon is a Harsh Mistress, which featured an intelligent computer called Mike, and a PBS documentary that showed Terry Winograd using SHRDLU. I haven't tried rereading The Moon is a Harsh Mistress, so I don't know how well it has aged, but when I read it I was drawn entirely into its world. It seemed only a matter of time before we'd have Mike, and when I saw Winograd using SHRDLU, it seemed like that time would be a few years at most. All you had to do was teach SHRDLU more words.

There weren't any classes in AI at Cornell then, not even graduate classes, so I started trying to teach myself. Which meant learning Lisp, since in those days Lisp was regarded as the language of AI. The commonly used programming languages then were pretty primitive, and programmers' ideas correspondingly so. The default language at Cornell was a Pascal-like language called PL/I, and the situation was similar elsewhere. Learning Lisp expanded my concept of a program so fast that it was years before I started to have a sense of where the new limits were. This was more like it; this was what I had expected college to do. It wasn't happening in a class, like it was supposed to, but that was ok. For the next couple years I was on a roll. I knew what I was going to do.

For my undergraduate thesis, I reverse-engineered SHRDLU. My God did I love working on that program. It was a pleasing bit of code, but what made it even more exciting was my belief — hard to imagine now, but not unique in 1985 — that it was already climbing the lower slopes of intelligence.

I had gotten into a program at Cornell that didn't make you choose a major. You could take whatever classes you liked, and choose whatever you liked to put on your degree. I of course chose "Artificial Intelligence."h&M
h'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jP  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj2  hhh
}(hhhhhhhJ"% hhhhhhuh"j4  uh.(h
hhh"h0}ubhh)}(h}(hߌ$020ec7ba-d535-490a-a88d-d9b13f3a4eb8hhh
}h"@5447c6d173f62130a7827451e50954578341ca5165095947ab0bac1364f76a59uh.(h
hhh"h0}ubuh"jR  h$X	  This was more like it; this was what I had expected college to do. It wasn't happening in a class, like it was supposed to, but that was ok. For the next couple years I was on a roll. I knew what I was going to do.

For my undergraduate thesis, I reverse-engineered SHRDLU. My God did I love working on that program. It was a pleasing bit of code, but what made it even more exciting was my belief — hard to imagine now, but not unique in 1985 — that it was already climbing the lower slopes of intelligence.

I had gotten into a program at Cornell that didn't make you choose a major. You could take whatever classes you liked, and choose whatever you liked to put on your degree. I of course chose "Artificial Intelligence." When I got the actual physical diploma, I was dismayed to find that the quotes had been included, which made them read as scare-quotes. At the time this bothered me, but now it seems amusingly accurate, for reasons I was about to discover.

I applied to 3 grad schools: MIT and Yale, which were renowned for AI at the time, and Harvard, which I'd visited because Rich Draves went there, and was also home to Bill Woods, who'd invented the type of parser I used in my SHRDLU clone. Only Harvard accepted me, so that was where I went.

I don't remember the moment it happened, or if there even was a specific moment, but during the first year of grad school I realized that AI, as practiced at the time, was a hoax. By which I mean the sort of AI in which a program that's told "the dog is sitting on the chair" translates this into some formal representation and adds it to the list of things it knows.

What these programs really showed was that there's a subset of natural language that's a formal language. But a very proper subset. It was clear that there was an unbridgeable gap between what they could do and actually understanding natural language. It was not, in fact, simply a matter of teaching SHRDLU more words. That whole way of doing AI, with explicit data structures representing concepts, was not going to work.h&MBh'MGh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jn  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjP  hhh
}(hhhhhhhJ"% hhhhhhuh"jR  uh.(h
hhh"h0}ubhh)}(h}(hߌ$5ea941cf-fdb3-4b3e-ad7d-f4432bd94021hhh
}h"@835855cdbe431b751fff47c73fcc36c4d54afe37ef7566d97d9cafee531b0ed0uh.(h
hhh"h0}ubuh"jp  h$Xi  Only Harvard accepted me, so that was where I went.

I don't remember the moment it happened, or if there even was a specific moment, but during the first year of grad school I realized that AI, as practiced at the time, was a hoax. By which I mean the sort of AI in which a program that's told "the dog is sitting on the chair" translates this into some formal representation and adds it to the list of things it knows.

What these programs really showed was that there's a subset of natural language that's a formal language. But a very proper subset. It was clear that there was an unbridgeable gap between what they could do and actually understanding natural language. It was not, in fact, simply a matter of teaching SHRDLU more words. That whole way of doing AI, with explicit data structures representing concepts, was not going to work. Its brokenness did, as so often happens, generate a lot of opportunities to write papers about various band-aids that could be applied to it, but it was never going to get us Mike.

So I looked around to see what I could salvage from the wreckage of my plans, and there was Lisp. I knew from experience that Lisp was interesting for its own sake and not just for its association with AI, even though that was the main reason people cared about it at the time. So I decided to focus on Lisp. In fact, I decided to write a book about Lisp hacking. It's scary to think how little I knew about Lisp hacking when I started writing that book. But there's nothing like writing a book about something to help you learn it. The book, On Lisp, wasn't published till 1993, but I wrote much of it in grad school.

Computer Science is an uneasy alliance between two halves, theory and systems. The theory people prove things, and the systems people build things. I wanted to build things. I had plenty of respect for theory — indeed, a sneaking suspicion that it was the more admirable of the two halves — but building things seemed so much more exciting.

The problem with systems work, though, was that it didn't last. Any program you wrote today, no matter how good, would be obsolete in a couple decades at best.h&Mh'M_ h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjn  hhh
}(hhhhhhhJ"% hhhhhhuh"jp  uh.(h
hhh"h0}ubhh)}(h}(hߌ$dbdf8d6f-1d5c-48bb-9803-f2ee1fa2b9fchhh
}h"@72d39d97ff5070f40a64f2ed1fc1b581f27dec776bbecda26227722e9363dd7auh.(h
hhh"h0}ubuh"j  h$X  So I decided to focus on Lisp. In fact, I decided to write a book about Lisp hacking. It's scary to think how little I knew about Lisp hacking when I started writing that book. But there's nothing like writing a book about something to help you learn it. The book, On Lisp, wasn't published till 1993, but I wrote much of it in grad school.

Computer Science is an uneasy alliance between two halves, theory and systems. The theory people prove things, and the systems people build things. I wanted to build things. I had plenty of respect for theory — indeed, a sneaking suspicion that it was the more admirable of the two halves — but building things seemed so much more exciting.

The problem with systems work, though, was that it didn't last. Any program you wrote today, no matter how good, would be obsolete in a couple decades at best. People might mention your software in footnotes, but no one would actually use it. And indeed, it would seem very feeble work. Only people with a sense of the history of the field would even realize that, in its time, it had been good.

There were some surplus Xerox Dandelions floating around the computer lab at one point. Anyone who wanted one to play around with could have one. I was briefly tempted, but they were so slow by present standards; what was the point? No one else wanted one either, so off they went. That was what happened to systems work.

I wanted not just to build things, but to build things that would last.

In this dissatisfied state I went in 1988 to visit Rich Draves at CMU, where he was in grad school. One day I went to visit the Carnegie Institute, where I'd spent a lot of time as a kid. While looking at a painting there I realized something that might seem obvious, but was a big surprise to me. There, right on the wall, was something you could make that would last. Paintings didn't become obsolete. Some of the best ones were hundreds of years old.

And moreover this was something you could make a living doing.h&Mh'M$h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$37dd7c37-a6d1-4043-9769-cb5304c33125hhh
}h"@803fc1ca1f552fbe481cb6a5732c3dcf690cd1e77c0b994cbc5814d75cc12992uh.(h
hhh"h0}ubuh"j  h$Xj  Anyone who wanted one to play around with could have one. I was briefly tempted, but they were so slow by present standards; what was the point? No one else wanted one either, so off they went. That was what happened to systems work.

I wanted not just to build things, but to build things that would last.

In this dissatisfied state I went in 1988 to visit Rich Draves at CMU, where he was in grad school. One day I went to visit the Carnegie Institute, where I'd spent a lot of time as a kid. While looking at a painting there I realized something that might seem obvious, but was a big surprise to me. There, right on the wall, was something you could make that would last. Paintings didn't become obsolete. Some of the best ones were hundreds of years old.

And moreover this was something you could make a living doing. Not as easily as you could by writing software, of course, but I thought if you were really industrious and lived really cheaply, it had to be possible to make enough to survive. And as an artist you could be truly independent. You wouldn't have a boss, or even need to get research funding.

I had always liked looking at paintings. Could I make them? I had no idea. I'd never imagined it was even possible. I knew intellectually that people made art — that it didn't just appear spontaneously — but it was as if the people who made it were a different species. They either lived long ago or were mysterious geniuses doing strange things in profiles in Life magazine. The idea of actually being able to make art, to put that verb before that noun, seemed almost miraculous.

That fall I started taking art classes at Harvard. Grad students could take classes in any department, and my advisor, Tom Cheatham, was very easy going. If he even knew about the strange classes I was taking, he never said anything.

So now I was in a PhD program in computer science, yet planning to be an artist, yet also genuinely in love with Lisp hacking and working away at On Lisp. In other words, like many a grad student, I was working energetically on multiple projects that were not my thesis.

I didn't see a way out of this situation.h&M!h'M*h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$eebbb4de-21a2-4e16-989a-c7e35371e8d9hhh
}h"@7a835a90d718c4a890432dd4e66dcfcd41931507d20f73ee3b86f72a954fc5d3uh.(h
hhh"h0}ubuh"j  h$X  I knew intellectually that people made art — that it didn't just appear spontaneously — but it was as if the people who made it were a different species. They either lived long ago or were mysterious geniuses doing strange things in profiles in Life magazine. The idea of actually being able to make art, to put that verb before that noun, seemed almost miraculous.

That fall I started taking art classes at Harvard. Grad students could take classes in any department, and my advisor, Tom Cheatham, was very easy going. If he even knew about the strange classes I was taking, he never said anything.

So now I was in a PhD program in computer science, yet planning to be an artist, yet also genuinely in love with Lisp hacking and working away at On Lisp. In other words, like many a grad student, I was working energetically on multiple projects that were not my thesis.

I didn't see a way out of this situation. I didn't want to drop out of grad school, but how else was I going to get out? I remember when my friend Robert Morris got kicked out of Cornell for writing the internet worm of 1988, I was envious that he'd found such a spectacular way to get out of grad school.

Then one day in April 1990 a crack appeared in the wall. I ran into professor Cheatham and he asked if I was far enough along to graduate that June. I didn't have a word of my dissertation written, but in what must have been the quickest bit of thinking in my life, I decided to take a shot at writing one in the 5 weeks or so that remained before the deadline, reusing parts of On Lisp where I could, and I was able to respond, with no perceptible delay "Yes, I think so. I'll give you something to read in a few days."

I picked applications of continuations as the topic. In retrospect I should have written about macros and embedded languages. There's a whole world there that's barely been explored. But all I wanted was to get out of grad school, and my rapidly written dissertation sufficed, just barely.

Meanwhile I was applying to art schools.h&Mx&h'Mj.h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$14a3e2be-e55a-4eeb-8c62-7e3277fdcafdhhh
}h"@2e13644eec07e6dd0c4d637dabf80bb1e634147d5066a43c282b0c90d833de27uh.(h
hhh"h0}ubuh"j  h$X  Then one day in April 1990 a crack appeared in the wall. I ran into professor Cheatham and he asked if I was far enough along to graduate that June. I didn't have a word of my dissertation written, but in what must have been the quickest bit of thinking in my life, I decided to take a shot at writing one in the 5 weeks or so that remained before the deadline, reusing parts of On Lisp where I could, and I was able to respond, with no perceptible delay "Yes, I think so. I'll give you something to read in a few days."

I picked applications of continuations as the topic. In retrospect I should have written about macros and embedded languages. There's a whole world there that's barely been explored. But all I wanted was to get out of grad school, and my rapidly written dissertation sufficed, just barely.

Meanwhile I was applying to art schools. I applied to two: RISD in the US, and the Accademia di Belli Arti in Florence, which, because it was the oldest art school, I imagined would be good. RISD accepted me, and I never heard back from the Accademia, so off to Providence I went.

I'd applied for the BFA program at RISD, which meant in effect that I had to go to college again. This was not as strange as it sounds, because I was only 25, and art schools are full of people of different ages. RISD counted me as a transfer sophomore and said I had to do the foundation that summer. The foundation means the classes that everyone has to take in fundamental subjects like drawing, color, and design.

Toward the end of the summer I got a big surprise: a letter from the Accademia, which had been delayed because they'd sent it to Cambridge England instead of Cambridge Massachusetts, inviting me to take the entrance exam in Florence that fall. This was now only weeks away. My nice landlady let me leave my stuff in her attic. I had some money saved from consulting work I'd done in grad school; there was probably enough to last a year if I lived cheaply. Now all I had to do was learn Italian.

Only stranieri (foreigners) had to take this entrance exam.h&M+h'M+3h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$e0b06852-83d0-43c1-82ee-86cb3efd67echhh
}h"@07de3e963df457009a95db8c3095566a0d4bcce86d03c7245cf7074dbf504a72uh.(h
hhh"h0}ubuh"j  h$X  This was not as strange as it sounds, because I was only 25, and art schools are full of people of different ages. RISD counted me as a transfer sophomore and said I had to do the foundation that summer. The foundation means the classes that everyone has to take in fundamental subjects like drawing, color, and design.

Toward the end of the summer I got a big surprise: a letter from the Accademia, which had been delayed because they'd sent it to Cambridge England instead of Cambridge Massachusetts, inviting me to take the entrance exam in Florence that fall. This was now only weeks away. My nice landlady let me leave my stuff in her attic. I had some money saved from consulting work I'd done in grad school; there was probably enough to last a year if I lived cheaply. Now all I had to do was learn Italian.

Only stranieri (foreigners) had to take this entrance exam. In retrospect it may well have been a way of excluding them, because there were so many stranieri attracted by the idea of studying art in Florence that the Italian students would otherwise have been outnumbered. I was in decent shape at painting and drawing from the RISD foundation that summer, but I still don't know how I managed to pass the written exam. I remember that I answered the essay question by writing about Cezanne, and that I cranked up the intellectual level as high as I could to make the most of my limited vocabulary. [2]

I'm only up to age 25 and already there are such conspicuous patterns. Here I was, yet again about to attend some august institution in the hopes of learning about some prestigious subject, and yet again about to be disappointed. The students and faculty in the painting department at the Accademia were the nicest people you could imagine, but they had long since arrived at an arrangement whereby the students wouldn't require the faculty to teach anything, and in return the faculty wouldn't require the students to learn anything. And at the same time all involved would adhere outwardly to the conventions of a 19th century atelier. We actually had one of those little stoves, fed with kindling, that you see in 19th century studio paintings, and a nude model sitting as close to it as possible without getting burned.h&M/h'M8h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j"  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$206d76b8-ae27-4d66-af21-dd5879cb7504hhh
}h"@3d420893823f3984960145cf39e11ada9b9f40e38e547becacbaf1d4f8631f83uh.(h
hhh"h0}ubuh"j$  h$XZ  [2]

I'm only up to age 25 and already there are such conspicuous patterns. Here I was, yet again about to attend some august institution in the hopes of learning about some prestigious subject, and yet again about to be disappointed. The students and faculty in the painting department at the Accademia were the nicest people you could imagine, but they had long since arrived at an arrangement whereby the students wouldn't require the faculty to teach anything, and in return the faculty wouldn't require the students to learn anything. And at the same time all involved would adhere outwardly to the conventions of a 19th century atelier. We actually had one of those little stoves, fed with kindling, that you see in 19th century studio paintings, and a nude model sitting as close to it as possible without getting burned. Except hardly anyone else painted her besides me. The rest of the students spent their time chatting or occasionally trying to imitate things they'd seen in American art magazines.

Our model turned out to live just down the street from me. She made a living from a combination of modelling and making fakes for a local antique dealer. She'd copy an obscure old painting out of a book, and then he'd take the copy and maltreat it to make it look old. [3]

While I was a student at the Accademia I started painting still lives in my bedroom at night. These paintings were tiny, because the room was, and because I painted them on leftover scraps of canvas, which was all I could afford at the time. Painting still lives is different from painting people, because the subject, as its name suggests, can't move. People can't sit for more than about 15 minutes at a time, and when they do they don't sit very still. So the traditional m.o. for painting people is to know how to paint a generic person, which you then modify to match the specific person you're painting. Whereas a still life you can, if you want, copy pixel by pixel from what you're seeing. You don't want to stop there, of course, or you get merely photographic accuracy, and what makes a still life interesting is that it's been through a head.h&MG5h'M=h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j@  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj"  hhh
}(hhhhhhhJ"% hhhhhhuh"j$  uh.(h
hhh"h0}ubhh)}(h}(hߌ$c2e030d2-d356-41a4-9743-f08d846202cchhh
}h"@b49635ad99a25d398fc61fe8bbf9221ca7620cb5f979a159bdfb2fdcb144216cuh.(h
hhh"h0}ubuh"jB  h$X  [3]

While I was a student at the Accademia I started painting still lives in my bedroom at night. These paintings were tiny, because the room was, and because I painted them on leftover scraps of canvas, which was all I could afford at the time. Painting still lives is different from painting people, because the subject, as its name suggests, can't move. People can't sit for more than about 15 minutes at a time, and when they do they don't sit very still. So the traditional m.o. for painting people is to know how to paint a generic person, which you then modify to match the specific person you're painting. Whereas a still life you can, if you want, copy pixel by pixel from what you're seeing. You don't want to stop there, of course, or you get merely photographic accuracy, and what makes a still life interesting is that it's been through a head. You want to emphasize the visual cues that tell you, for example, that the reason the color changes suddenly at a certain point is that it's the edge of an object. By subtly emphasizing such things you can make paintings that are more realistic than photographs not just in some metaphorical sense, but in the strict information-theoretic sense. [4]

I liked painting still lives because I was curious about what I was seeing. In everyday life, we aren't consciously aware of much we're seeing. Most visual perception is handled by low-level processes that merely tell your brain "that's a water droplet" without telling you details like where the lightest and darkest points are, or "that's a bush" without telling you the shape and position of every leaf. This is a feature of brains, not a bug. In everyday life it would be distracting to notice every leaf on every bush. But when you have to paint something, you have to look more closely, and when you do there's a lot to see. You can still be noticing new things after days of trying to paint something people usually take for granted, just as you can after days of trying to write an essay about something people usually take for granted.

This is not the only way to paint. I'm not 100% sure it's even a good way to paint. But it seemed a good enough bet to be worth trying.h&MG:h'MBh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j^  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj@  hhh
}(hhhhhhhJ"% hhhhhhuh"jB  uh.(h
hhh"h0}ubhh)}(h}(hߌ$65d8cf4a-626c-403c-9e7b-5e79644d5417hhh
}h"@ffb53f4a635414ee788cf9ac3ae5f9f8ee287c08b6aa789b0dfc5ee429aa5e8duh.(h
hhh"h0}ubuh"j`  h$X  Most visual perception is handled by low-level processes that merely tell your brain "that's a water droplet" without telling you details like where the lightest and darkest points are, or "that's a bush" without telling you the shape and position of every leaf. This is a feature of brains, not a bug. In everyday life it would be distracting to notice every leaf on every bush. But when you have to paint something, you have to look more closely, and when you do there's a lot to see. You can still be noticing new things after days of trying to paint something people usually take for granted, just as you can after days of trying to write an essay about something people usually take for granted.

This is not the only way to paint. I'm not 100% sure it's even a good way to paint. But it seemed a good enough bet to be worth trying.

Our teacher, professor Ulivi, was a nice guy. He could see I worked hard, and gave me a good grade, which he wrote down in a sort of passport each student had. But the Accademia wasn't teaching me anything except Italian, and my money was running out, so at the end of the first year I went back to the US.

I wanted to go back to RISD, but I was now broke and RISD was very expensive, so I decided to get a job for a year and then return to RISD the next fall. I got one at a company called Interleaf, which made software for creating documents. You mean like Microsoft Word? Exactly. That was how I learned that low end software tends to eat high end software. But Interleaf still had a few years to live yet. [5]

Interleaf had done something pretty bold. Inspired by Emacs, they'd added a scripting language, and even made the scripting language a dialect of Lisp. Now they wanted a Lisp hacker to write things in it. This was the closest thing I've had to a normal job, and I hereby apologize to my boss and coworkers, because I was a bad employee. Their Lisp was the thinnest icing on a giant C cake, and since I didn't know C and didn't want to learn it, I never understood most of the software. Plus I was terribly irresponsible.h&M?h'MGh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j|  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj^  hhh
}(hhhhhhhJ"% hhhhhhuh"j`  uh.(h
hhh"h0}ubhh)}(h}(hߌ$26007248-ab0a-4027-81d7-d50390629284hhh
}h"@c3e8901bbe1c4c9596b9f2d495ad080eb4479db2808658c4019fb111ddb5f501uh.(h
hhh"h0}ubuh"j~  h$Xw  I got one at a company called Interleaf, which made software for creating documents. You mean like Microsoft Word? Exactly. That was how I learned that low end software tends to eat high end software. But Interleaf still had a few years to live yet. [5]

Interleaf had done something pretty bold. Inspired by Emacs, they'd added a scripting language, and even made the scripting language a dialect of Lisp. Now they wanted a Lisp hacker to write things in it. This was the closest thing I've had to a normal job, and I hereby apologize to my boss and coworkers, because I was a bad employee. Their Lisp was the thinnest icing on a giant C cake, and since I didn't know C and didn't want to learn it, I never understood most of the software. Plus I was terribly irresponsible. This was back when a programming job meant showing up every day during certain working hours. That seemed unnatural to me, and on this point the rest of the world is coming around to my way of thinking, but at the time it caused a lot of friction. Toward the end of the year I spent much of my time surreptitiously working on On Lisp, which I had by this time gotten a contract to publish.

The good part was that I got paid huge amounts of money, especially by art student standards. In Florence, after paying my part of the rent, my budget for everything else had been $7 a day. Now I was getting paid more than 4 times that every hour, even when I was just sitting in a meeting. By living cheaply I not only managed to save enough to go back to RISD, but also paid off my college loans.

I learned some useful things at Interleaf, though they were mostly about what not to do.h&MDh'MKh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj|  hhh
}(hhhhhhhJ"% hhhhhhuh"j~  uh.(h
hhh"h0}ubhh)}(h}(hߌ$9924e84f-edd1-43c2-814a-d18601952cb5hhh
}h"@8e5c423aacdd6b2c4cc8ea0cf1548a23d367223224bf8752e52ffc503b09fa26uh.(h
hhh"h0}ubuh"j  h$X  That seemed unnatural to me, and on this point the rest of the world is coming around to my way of thinking, but at the time it caused a lot of friction. Toward the end of the year I spent much of my time surreptitiously working on On Lisp, which I had by this time gotten a contract to publish.

The good part was that I got paid huge amounts of money, especially by art student standards. In Florence, after paying my part of the rent, my budget for everything else had been $7 a day. Now I was getting paid more than 4 times that every hour, even when I was just sitting in a meeting. By living cheaply I not only managed to save enough to go back to RISD, but also paid off my college loans.

I learned some useful things at Interleaf, though they were mostly about what not to do. I learned that it's better for technology companies to be run by product people than sales people (though sales is a real skill and people who are good at it are really good at it), that it leads to bugs when code is edited by too many people, that cheap office space is no bargain if it's depressing, that planned meetings are inferior to corridor conversations, that big, bureaucratic customers are a dangerous source of money, and that there's not much overlap between conventional office hours and the optimal time for hacking, or conventional offices and the optimal place for it.

But the most important thing I learned, and which I used in both Viaweb and Y Combinator, is that the low end eats the high end: that it's good to be the "entry level" option, even though that will be less prestigious, because if you're not, someone else will be, and will squash you against the ceiling. Which in turn means that prestige is a danger sign.

When I left to go back to RISD the next fall, I arranged to do freelance work for the group that did projects for customers, and this was how I survived for the next several years. When I came back to visit for a project later on, someone told me about a new thing called HTML, which was, as he described it, a derivative of SGML. Markup language enthusiasts were an occupational hazard at Interleaf and I ignored him, but this HTML thing later became a big part of my life.h&MHh'MPh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$a7e4652c-7f7a-4fb7-8d17-4fcaa80e4d2bhhh
}h"@5c42d2aaeb03cf50770f147f3f9f335de8dc0446e3e025e205f4d61e1c3e9840uh.(h
hhh"h0}ubuh"j  h$X  But the most important thing I learned, and which I used in both Viaweb and Y Combinator, is that the low end eats the high end: that it's good to be the "entry level" option, even though that will be less prestigious, because if you're not, someone else will be, and will squash you against the ceiling. Which in turn means that prestige is a danger sign.

When I left to go back to RISD the next fall, I arranged to do freelance work for the group that did projects for customers, and this was how I survived for the next several years. When I came back to visit for a project later on, someone told me about a new thing called HTML, which was, as he described it, a derivative of SGML. Markup language enthusiasts were an occupational hazard at Interleaf and I ignored him, but this HTML thing later became a big part of my life.

In the fall of 1992 I moved back to Providence to continue at RISD. The foundation had merely been intro stuff, and the Accademia had been a (very civilized) joke. Now I was going to see what real art school was like. But alas it was more like the Accademia than not. Better organized, certainly, and a lot more expensive, but it was now becoming clear that art school did not bear the same relationship to art that medical school bore to medicine. At least not the painting department. The textile department, which my next door neighbor belonged to, seemed to be pretty rigorous. No doubt illustration and architecture were too. But painting was post-rigorous. Painting students were supposed to express themselves, which to the more worldly ones meant to try to cook up some sort of distinctive signature style.

A signature style is the visual equivalent of what in show business is known as a "schtick": something that immediately identifies the work as yours and no one else's. For example, when you see a painting that looks like a certain kind of cartoon, you know it's by Roy Lichtenstein. So if you see a big painting of this type hanging in the apartment of a hedge fund manager, you know he paid millions of dollars for it. That's not always why artists have a signature style, but it's usually why buyers pay a lot for such work.h&MiMh'MUh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$45cf1910-e4fa-49bc-898f-384448636befhhh
}h"@e1a6008a745a16e3900f79b5bb44cc571ee8513cc08bc523e911a9ee00e0cb63uh.(h
hhh"h0}ubuh"j  h$X  At least not the painting department. The textile department, which my next door neighbor belonged to, seemed to be pretty rigorous. No doubt illustration and architecture were too. But painting was post-rigorous. Painting students were supposed to express themselves, which to the more worldly ones meant to try to cook up some sort of distinctive signature style.

A signature style is the visual equivalent of what in show business is known as a "schtick": something that immediately identifies the work as yours and no one else's. For example, when you see a painting that looks like a certain kind of cartoon, you know it's by Roy Lichtenstein. So if you see a big painting of this type hanging in the apartment of a hedge fund manager, you know he paid millions of dollars for it. That's not always why artists have a signature style, but it's usually why buyers pay a lot for such work. [6]

There were plenty of earnest students too: kids who "could draw" in high school, and now had come to what was supposed to be the best art school in the country, to learn to draw even better. They tended to be confused and demoralized by what they found at RISD, but they kept going, because painting was what they did. I was not one of the kids who could draw in high school, but at RISD I was definitely closer to their tribe than the tribe of signature style seekers.

I learned a lot in the color class I took at RISD, but otherwise I was basically teaching myself to paint, and I could do that for free. So in 1993 I dropped out. I hung around Providence for a bit, and then my college friend Nancy Parmet did me a big favor. A rent-controlled apartment in a building her mother owned in New York was becoming vacant. Did I want it? It wasn't much more than my current place, and New York was supposed to be where the artists were. So yes, I wanted it! [7]

Asterix comics begin by zooming in on a tiny corner of Roman Gaul that turns out not to be controlled by the Romans.h&MlRh'M%Zh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$eb2ce7e3-435d-4f72-a387-6e99a52dd412hhh
}h"@67e06f21e611255d72efc4847c46e4eb924ebdacc6836cc8a94e759c762b7945uh.(h
hhh"h0}ubuh"j  h$X  I was not one of the kids who could draw in high school, but at RISD I was definitely closer to their tribe than the tribe of signature style seekers.

I learned a lot in the color class I took at RISD, but otherwise I was basically teaching myself to paint, and I could do that for free. So in 1993 I dropped out. I hung around Providence for a bit, and then my college friend Nancy Parmet did me a big favor. A rent-controlled apartment in a building her mother owned in New York was becoming vacant. Did I want it? It wasn't much more than my current place, and New York was supposed to be where the artists were. So yes, I wanted it! [7]

Asterix comics begin by zooming in on a tiny corner of Roman Gaul that turns out not to be controlled by the Romans. You can do something similar on a map of New York City: if you zoom in on the Upper East Side, there's a tiny corner that's not rich, or at least wasn't in 1993. It's called Yorkville, and that was my new home. Now I was a New York artist — in the strictly technical sense of making paintings and living in New York.

I was nervous about money, because I could sense that Interleaf was on the way down. Freelance Lisp hacking work was very rare, and I didn't want to have to program in another language, which in those days would have meant C++ if I was lucky. So with my unerring nose for financial opportunity, I decided to write another book on Lisp. This would be a popular book, the sort of book that could be used as a textbook. I imagined myself living frugally off the royalties and spending all my time painting. (The painting on the cover of this book, ANSI Common Lisp, is one that I painted around this time.)

The best thing about New York for me was the presence of Idelle and Julian Weber. Idelle Weber was a painter, one of the early photorealists, and I'd taken her painting class at Harvard. I've never known a teacher more beloved by her students. Large numbers of former students kept in touch with her, including me. After I moved to New York I became her de facto studio assistant.h&M.Wh'M=_h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$8fea57fe-420f-4a0f-a61c-ecf77fa5630chhh
}h"@82f486d54e3827b309b244fe115575f127b01f66c7489a42e285ba30f1ba8ba9uh.(h
hhh"h0}ubuh"j  h$X9  So with my unerring nose for financial opportunity, I decided to write another book on Lisp. This would be a popular book, the sort of book that could be used as a textbook. I imagined myself living frugally off the royalties and spending all my time painting. (The painting on the cover of this book, ANSI Common Lisp, is one that I painted around this time.)

The best thing about New York for me was the presence of Idelle and Julian Weber. Idelle Weber was a painter, one of the early photorealists, and I'd taken her painting class at Harvard. I've never known a teacher more beloved by her students. Large numbers of former students kept in touch with her, including me. After I moved to New York I became her de facto studio assistant.

She liked to paint on big, square canvases, 4 to 5 feet on a side. One day in late 1994 as I was stretching one of these monsters there was something on the radio about a famous fund manager. He wasn't that much older than me, and was super rich. The thought suddenly occurred to me: why don't I become rich? Then I'll be able to work on whatever I want.

Meanwhile I'd been hearing more and more about this new thing called the World Wide Web. Robert Morris showed it to me when I visited him in Cambridge, where he was now in grad school at Harvard. It seemed to me that the web would be a big deal. I'd seen what graphical user interfaces had done for the popularity of microcomputers. It seemed like the web would do the same for the internet.

If I wanted to get rich, here was the next train leaving the station. I was right about that part. What I got wrong was the idea. I decided we should start a company to put art galleries online. I can't honestly say, after reading so many Y Combinator applications, that this was the worst startup idea ever, but it was up there. Art galleries didn't want to be online, and still don't, not the fancy ones. That's not how they sell. I wrote some software to generate web sites for galleries, and Robert wrote some to resize images and set up an http server to serve the pages. Then we tried to sign up galleries.h&MW\h'Mdh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j0  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$f98fe61b-a529-4544-ac66-bd8d92fce10bhhh
}h"@da5a9ace5562b6379ec4e70894e5df024a4334625f1ed620e215f8087f215239uh.(h
hhh"h0}ubuh"j2  h$X  It seemed to me that the web would be a big deal. I'd seen what graphical user interfaces had done for the popularity of microcomputers. It seemed like the web would do the same for the internet.

If I wanted to get rich, here was the next train leaving the station. I was right about that part. What I got wrong was the idea. I decided we should start a company to put art galleries online. I can't honestly say, after reading so many Y Combinator applications, that this was the worst startup idea ever, but it was up there. Art galleries didn't want to be online, and still don't, not the fancy ones. That's not how they sell. I wrote some software to generate web sites for galleries, and Robert wrote some to resize images and set up an http server to serve the pages. Then we tried to sign up galleries. To call this a difficult sale would be an understatement. It was difficult to give away. A few galleries let us make sites for them for free, but none paid us.

Then some online stores started to appear, and I realized that except for the order buttons they were identical to the sites we'd been generating for galleries. This impressive-sounding thing called an "internet storefront" was something we already knew how to build.

So in the summer of 1995, after I submitted the camera-ready copy of ANSI Common Lisp to the publishers, we started trying to write software to build online stores. At first this was going to be normal desktop software, which in those days meant Windows software. That was an alarming prospect, because neither of us knew how to write Windows software or wanted to learn. We lived in the Unix world. But we decided we'd at least try writing a prototype store builder on Unix. Robert wrote a shopping cart, and I wrote a new site generator for stores — in Lisp, of course.

We were working out of Robert's apartment in Cambridge. His roommate was away for big chunks of time, during which I got to sleep in his room. For some reason there was no bed frame or sheets, just a mattress on the floor.h&Mgah'MZih(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jN  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj0  hhh
}(hhhhhhhJ"% hhhhhhuh"j2  uh.(h
hhh"h0}ubhh)}(h}(hߌ$ba2f0ce1-59d2-4595-91e6-1dab043ee60chhh
}h"@272dcca94fcd0081c2aded0050e48391fa3e2aaf362e3e23f9b05a204acae71euh.(h
hhh"h0}ubuh"jP  h$XM  This impressive-sounding thing called an "internet storefront" was something we already knew how to build.

So in the summer of 1995, after I submitted the camera-ready copy of ANSI Common Lisp to the publishers, we started trying to write software to build online stores. At first this was going to be normal desktop software, which in those days meant Windows software. That was an alarming prospect, because neither of us knew how to write Windows software or wanted to learn. We lived in the Unix world. But we decided we'd at least try writing a prototype store builder on Unix. Robert wrote a shopping cart, and I wrote a new site generator for stores — in Lisp, of course.

We were working out of Robert's apartment in Cambridge. His roommate was away for big chunks of time, during which I got to sleep in his room. For some reason there was no bed frame or sheets, just a mattress on the floor. One morning as I was lying on this mattress I had an idea that made me sit up like a capital L. What if we ran the software on the server, and let users control it by clicking on links? Then we'd never have to write anything to run on users' computers. We could generate the sites on the same server we'd serve them from. Users wouldn't need anything more than a browser.

This kind of software, known as a web app, is common now, but at the time it wasn't clear that it was even possible. To find out, we decided to try making a version of our store builder that you could control through the browser. A couple days later, on August 12, we had one that worked. The UI was horrible, but it proved you could build a whole store through the browser, without any client software or typing anything into the command line on the server.

Now we felt like we were really onto something. I had visions of a whole new generation of software working this way. You wouldn't need versions, or ports, or any of that crap. At Interleaf there had been a whole group called Release Engineering that seemed to be at least as big as the group that actually wrote the software. Now you could just update the software right on the server.h&Meh'Mnh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jl  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjN  hhh
}(hhhhhhhJ"% hhhhhhuh"jP  uh.(h
hhh"h0}ubhh)}(h}(hߌ$b44a328f-9f46-4d22-b255-fe7035ffed41hhh
}h"@3b0115b430db026a54c1ed5da34e6df5f4b569bc05513fb60783c5bcc1b92951uh.(h
hhh"h0}ubuh"jn  h$X,  Users wouldn't need anything more than a browser.

This kind of software, known as a web app, is common now, but at the time it wasn't clear that it was even possible. To find out, we decided to try making a version of our store builder that you could control through the browser. A couple days later, on August 12, we had one that worked. The UI was horrible, but it proved you could build a whole store through the browser, without any client software or typing anything into the command line on the server.

Now we felt like we were really onto something. I had visions of a whole new generation of software working this way. You wouldn't need versions, or ports, or any of that crap. At Interleaf there had been a whole group called Release Engineering that seemed to be at least as big as the group that actually wrote the software. Now you could just update the software right on the server.

We started a new company we called Viaweb, after the fact that our software worked via the web, and we got $10,000 in seed funding from Idelle's husband Julian. In return for that and doing the initial legal work and giving us business advice, we gave him 10% of the company. Ten years later this deal became the model for Y Combinator's. We knew founders needed something like this, because we'd needed it ourselves.

At this stage I had a negative net worth, because the thousand dollars or so I had in the bank was more than counterbalanced by what I owed the government in taxes. (Had I diligently set aside the proper proportion of the money I'd made consulting for Interleaf? No, I had not.) So although Robert had his graduate student stipend, I needed that seed funding to live on.

We originally hoped to launch in September, but we got more ambitious about the software as we worked on it. Eventually we managed to build a WYSIWYG site builder, in the sense that as you were creating pages, they looked exactly like the static ones that would be generated later, except that instead of leading to static pages, the links all referred to closures stored in a hash table on the server.h&Mjh'Mrh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjl  hhh
}(hhhhhhhJ"% hhhhhhuh"jn  uh.(h
hhh"h0}ubhh)}(h}(hߌ$614aaa5e-c96c-4229-8521-54a4bd46f64fhhh
}h"@094691e82a7190e2fa93007debfc6ec39f2e4f3ef124b234310b52de79744845uh.(h
hhh"h0}ubuh"j  h$X|  Ten years later this deal became the model for Y Combinator's. We knew founders needed something like this, because we'd needed it ourselves.

At this stage I had a negative net worth, because the thousand dollars or so I had in the bank was more than counterbalanced by what I owed the government in taxes. (Had I diligently set aside the proper proportion of the money I'd made consulting for Interleaf? No, I had not.) So although Robert had his graduate student stipend, I needed that seed funding to live on.

We originally hoped to launch in September, but we got more ambitious about the software as we worked on it. Eventually we managed to build a WYSIWYG site builder, in the sense that as you were creating pages, they looked exactly like the static ones that would be generated later, except that instead of leading to static pages, the links all referred to closures stored in a hash table on the server.

It helped to have studied art, because the main goal of an online store builder is to make users look legit, and the key to looking legit is high production values. If you get page layouts and fonts and colors right, you can make a guy running a store out of his bedroom look more legit than a big company.

(If you're curious why my site looks so old-fashioned, it's because it's still made with this software. It may look clunky today, but in 1996 it was the last word in slick.)

In September, Robert rebelled. "We've been working on this for a month," he said, "and it's still not done." This is funny in retrospect, because he would still be working on it almost 3 years later. But I decided it might be prudent to recruit more programmers, and I asked Robert who else in grad school with him was really good. He recommended Trevor Blackwell, which surprised me at first, because at that point I knew Trevor mainly for his plan to reduce everything in his life to a stack of notecards, which he carried around with him. But Rtm was right, as usual. Trevor turned out to be a frighteningly effective hacker.

It was a lot of fun working with Robert and Trevor. They're the two most independent-minded people I know, and in completely different ways.;     h&M4oh'Mwh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$9b74842e-ed16-444c-b6ff-884fab4eaaddhhh
}h"@38f9d47d8b0a30a99233f2e1392aa763f3ab51d6a803b00e00c1655cc47bbdecuh.(h
hhh"h0}ubuh"j  h$X0  It may look clunky today, but in 1996 it was the last word in slick.)

In September, Robert rebelled. "We've been working on this for a month," he said, "and it's still not done." This is funny in retrospect, because he would still be working on it almost 3 years later. But I decided it might be prudent to recruit more programmers, and I asked Robert who else in grad school with him was really good. He recommended Trevor Blackwell, which surprised me at first, because at that point I knew Trevor mainly for his plan to reduce everything in his life to a stack of notecards, which he carried around with him. But Rtm was right, as usual. Trevor turned out to be a frighteningly effective hacker.

It was a lot of fun working with Robert and Trevor. They're the two most independent-minded people I know, and in completely different ways. If you could see inside Rtm's brain it would look like a colonial New England church, and if you could see inside Trevor's it would look like the worst excesses of Austrian Rococo.

We opened for business, with 6 stores, in January 1996. It was just as well we waited a few months, because although we worried we were late, we were actually almost fatally early. There was a lot of talk in the press then about ecommerce, but not many people actually wanted online stores. [8]

There were three main parts to the software: the editor, which people used to build sites and which I wrote, the shopping cart, which Robert wrote, and the manager, which kept track of orders and statistics, and which Trevor wrote. In its time, the editor was one of the best general-purpose site builders. I kept the code tight and didn't have to integrate with any other software except Robert's and Trevor's, so it was quite fun to work on. If all I'd had to do was work on this software, the next 3 years would have been the easiest of my life. Unfortunately I had to do a lot more, all of it stuff I was worse at than programming, and the next 3 years were instead the most stressful.

There were a lot of startups making ecommerce software in the second half of the 90s.h&Mgth'M|h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$6d39fde6-1050-46f1-9040-64654d278cdbhhh
}h"@d64bc291dce44910900e30a49335151f397d9427ca210b60f95a95e64a3858a7uh.(h
hhh"h0}ubuh"j  h$X   [8]

There were three main parts to the software: the editor, which people used to build sites and which I wrote, the shopping cart, which Robert wrote, and the manager, which kept track of orders and statistics, and which Trevor wrote. In its time, the editor was one of the best general-purpose site builders. I kept the code tight and didn't have to integrate with any other software except Robert's and Trevor's, so it was quite fun to work on. If all I'd had to do was work on this software, the next 3 years would have been the easiest of my life. Unfortunately I had to do a lot more, all of it stuff I was worse at than programming, and the next 3 years were instead the most stressful.

There were a lot of startups making ecommerce software in the second half of the 90s. We were determined to be the Microsoft Word, not the Interleaf. Which meant being easy to use and inexpensive. It was lucky for us that we were poor, because that caused us to make Viaweb even more inexpensive than we realized. We charged $100 a month for a small store and $300 a month for a big one. This low price was a big attraction, and a constant thorn in the sides of competitors, but it wasn't because of some clever insight that we set the price low. We had no idea what businesses paid for things. $300 a month seemed like a lot of money to us.

We did a lot of things right by accident like that. For example, we did what's now called "doing things that don't scale," although at the time we would have described it as "being so lame that we're driven to the most desperate measures to get users." The most common of which was building stores for them. This seemed particularly humiliating, since the whole raison d'etre of our software was that people could use it to make their own stores. But anything to get users.

We learned a lot more about retail than we wanted to know. For example, that if you could only have a small image of a man's shirt (and all images were small then by present standards), it was better to have a closeup of the collar than a picture of the whole shirt.h&Myh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$fccfa5d0-2a24-44e8-afe9-81976be51fc5hhh
}h"@f4bc492e228ffcd81d7de1f86920c874b6c74028e4ec0634d133b674f632a789uh.(h
hhh"h0}ubuh"j  h$X  We had no idea what businesses paid for things. $300 a month seemed like a lot of money to us.

We did a lot of things right by accident like that. For example, we did what's now called "doing things that don't scale," although at the time we would have described it as "being so lame that we're driven to the most desperate measures to get users." The most common of which was building stores for them. This seemed particularly humiliating, since the whole raison d'etre of our software was that people could use it to make their own stores. But anything to get users.

We learned a lot more about retail than we wanted to know. For example, that if you could only have a small image of a man's shirt (and all images were small then by present standards), it was better to have a closeup of the collar than a picture of the whole shirt. The reason I remember learning this was that it meant I had to rescan about 30 images of men's shirts. My first set of scans were so beautiful too.

Though this felt wrong, it was exactly the right thing to be doing. Building stores for users taught us about retail, and about how it felt to use our software. I was initially both mystified and repelled by "business" and thought we needed a "business person" to be in charge of it, but once we started to get users, I was converted, in much the same way I was converted to fatherhood once I had kids. Whatever users wanted, I was all theirs. Maybe one day we'd have so many users that I couldn't scan their images for them, but in the meantime there was nothing more important to do.

Another thing I didn't get at the time is that growth rate is the ultimate test of a startup. Our growth rate was fine. We had about 70 stores at the end of 1996 and about 500 at the end of 1997. I mistakenly thought the thing that mattered was the absolute number of users. And that is the thing that matters in the sense that that's how much money you're making, and if you're not making enough, you might go out of business. But in the long term the growth rate takes care of the absolute number.h&Me~h'M~h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$9f3e7e7e-8309-4949-be45-ba7c10fd38f6hhh
}h"@f9faf050160dc6d18950ddb3af9f0e78244c86acfb0c9fe8b4b5ac42a67fc12cuh.(h
hhh"h0}ubuh"j  h$X.  Whatever users wanted, I was all theirs. Maybe one day we'd have so many users that I couldn't scan their images for them, but in the meantime there was nothing more important to do.

Another thing I didn't get at the time is that growth rate is the ultimate test of a startup. Our growth rate was fine. We had about 70 stores at the end of 1996 and about 500 at the end of 1997. I mistakenly thought the thing that mattered was the absolute number of users. And that is the thing that matters in the sense that that's how much money you're making, and if you're not making enough, you might go out of business. But in the long term the growth rate takes care of the absolute number. If we'd been a startup I was advising at Y Combinator, I would have said: Stop being so stressed out, because you're doing fine. You're growing 7x a year. Just don't hire too many more people and you'll soon be profitable, and then you'll control your own destiny.

Alas I hired lots more people, partly because our investors wanted me to, and partly because that's what startups did during the Internet Bubble. A company with just a handful of employees would have seemed amateurish. So we didn't reach breakeven until about when Yahoo bought us in the summer of 1998. Which in turn meant we were at the mercy of investors for the entire life of the company. And since both we and our investors were noobs at startups, the result was a mess even by startup standards.

It was a huge relief when Yahoo bought us. In principle our Viaweb stock was valuable. It was a share in a business that was profitable and growing rapidly. But it didn't feel very valuable to me; I had no idea how to value a business, but I was all too keenly aware of the near-death experiences we seemed to have every few months. Nor had I changed my grad student lifestyle significantly since we started. So when Yahoo bought us it felt like going from rags to riches. Since we were going to California, I bought a car, a yellow 1998 VW GTI. I remember thinking that its leather seats alone were by far the most luxurious thing I owned.h&MӃh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j   hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$efdd6692-0742-4c5e-a680-cbf46b33a201hhh
}h"@75fc389458dc64184d704a799ebf4495c1ca88cbd7633be9e612cffe95ad8fb4uh.(h
hhh"h0}ubuh"j"  h$X  Which in turn meant we were at the mercy of investors for the entire life of the company. And since both we and our investors were noobs at startups, the result was a mess even by startup standards.

It was a huge relief when Yahoo bought us. In principle our Viaweb stock was valuable. It was a share in a business that was profitable and growing rapidly. But it didn't feel very valuable to me; I had no idea how to value a business, but I was all too keenly aware of the near-death experiences we seemed to have every few months. Nor had I changed my grad student lifestyle significantly since we started. So when Yahoo bought us it felt like going from rags to riches. Since we were going to California, I bought a car, a yellow 1998 VW GTI. I remember thinking that its leather seats alone were by far the most luxurious thing I owned.

The next year, from the summer of 1998 to the summer of 1999, must have been the least productive of my life. I didn't realize it at the time, but I was worn out from the effort and stress of running Viaweb. For a while after I got to California I tried to continue my usual m.o. of programming till 3 in the morning, but fatigue combined with Yahoo's prematurely aged culture and grim cube farm in Santa Clara gradually dragged me down. After a few months it felt disconcertingly like working at Interleaf.

Yahoo had given us a lot of options when they bought us. At the time I thought Yahoo was so overvalued that they'd never be worth anything, but to my astonishment the stock went up 5x in the next year. I hung on till the first chunk of options vested, then in the summer of 1999 I left. It had been so long since I'd painted anything that I'd half forgotten why I was doing this. My brain had been entirely full of software and men's shirts for 4 years. But I had done this to get rich so I could paint, I reminded myself, and now I was rich, so I should go paint.

When I said I was leaving, my boss at Yahoo had a long conversation with me about my plans. I told him all about the kinds of pictures I wanted to paint.h&Mh'Mϐh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j>  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj   hhh
}(hhhhhhhJ"% hhhhhhuh"j"  uh.(h
hhh"h0}ubhh)}(h}(hߌ$4479895b-09cd-4f8e-a990-033638ccdadahhh
}h"@440e142a5ff60468e4db38346ae4e23e9b808d7832d590d920f9b3ec17f1e1ecuh.(h
hhh"h0}ubuh"j@  h$X  After a few months it felt disconcertingly like working at Interleaf.

Yahoo had given us a lot of options when they bought us. At the time I thought Yahoo was so overvalued that they'd never be worth anything, but to my astonishment the stock went up 5x in the next year. I hung on till the first chunk of options vested, then in the summer of 1999 I left. It had been so long since I'd painted anything that I'd half forgotten why I was doing this. My brain had been entirely full of software and men's shirts for 4 years. But I had done this to get rich so I could paint, I reminded myself, and now I was rich, so I should go paint.

When I said I was leaving, my boss at Yahoo had a long conversation with me about my plans. I told him all about the kinds of pictures I wanted to paint. At the time I was touched that he took such an interest in me. Now I realize it was because he thought I was lying. My options at that point were worth about $2 million a month. If I was leaving that kind of money on the table, it could only be to go and start some new startup, and if I did, I might take people with me. This was the height of the Internet Bubble, and Yahoo was ground zero of it. My boss was at that moment a billionaire. Leaving then to start a new startup must have seemed to him an insanely, and yet also plausibly, ambitious plan.

But I really was quitting to paint, and I started immediately. There was no time to lose. I'd already burned 4 years getting rich. Now when I talk to founders who are leaving after selling their companies, my advice is always the same: take a vacation. That's what I should have done, just gone off somewhere and done nothing for a month or two, but the idea never occurred to me.

So I tried to paint, but I just didn't seem to have any energy or ambition. Part of the problem was that I didn't know many people in California. I'd compounded this problem by buying a house up in the Santa Cruz Mountains, with a beautiful view but miles from anywhere.h&Mh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j\  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj>  hhh
}(hhhhhhhJ"% hhhhhhuh"j@  uh.(h
hhh"h0}ubhh)}(h}(hߌ$1f963bbd-9479-48e0-ba90-0b9c16f55304hhh
}h"@0c6f2ecbed3bd90d8d8d437b79a4c2325267e3df230ad41170a738c5048c6cd2uh.(h
hhh"h0}ubuh"j^  h$X  My boss was at that moment a billionaire. Leaving then to start a new startup must have seemed to him an insanely, and yet also plausibly, ambitious plan.

But I really was quitting to paint, and I started immediately. There was no time to lose. I'd already burned 4 years getting rich. Now when I talk to founders who are leaving after selling their companies, my advice is always the same: take a vacation. That's what I should have done, just gone off somewhere and done nothing for a month or two, but the idea never occurred to me.

So I tried to paint, but I just didn't seem to have any energy or ambition. Part of the problem was that I didn't know many people in California. I'd compounded this problem by buying a house up in the Santa Cruz Mountains, with a beautiful view but miles from anywhere. I stuck it out for a few more months, then in desperation I went back to New York, where unless you understand about rent control you'll be surprised to hear I still had my apartment, sealed up like a tomb of my old life. Idelle was in New York at least, and there were other people trying to paint there, even though I didn't know any of them.

When I got back to New York I resumed my old life, except now I was rich. It was as weird as it sounds. I resumed all my old patterns, except now there were doors where there hadn't been. Now when I was tired of walking, all I had to do was raise my hand, and (unless it was raining) a taxi would stop to pick me up. Now when I walked past charming little restaurants I could go in and order lunch. It was exciting for a while. Painting started to go better. I experimented with a new kind of still life where I'd paint one painting in the old way, then photograph it and print it, blown up, on canvas, and then use that as the underpainting for a second still life, painted from the same objects (which hopefully hadn't rotted yet).

Meanwhile I looked for an apartment to buy. Now I could actually choose what neighborhood to live in. Where, I asked myself and various real estate agents, is the Cambridge of New York?h&M_h'Mzh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jz  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj\  hhh
}(hhhhhhhJ"% hhhhhhuh"j^  uh.(h
hhh"h0}ubhh)}(h}(hߌ$e9496b22-7029-49e9-8ef5-06021a568e3bhhh
}h"@5619fe7765a517a585145d964dd3a10fd29a84fe2eb41a33ab976fd16e63a180uh.(h
hhh"h0}ubuh"j|  h$X  It was as weird as it sounds. I resumed all my old patterns, except now there were doors where there hadn't been. Now when I was tired of walking, all I had to do was raise my hand, and (unless it was raining) a taxi would stop to pick me up. Now when I walked past charming little restaurants I could go in and order lunch. It was exciting for a while. Painting started to go better. I experimented with a new kind of still life where I'd paint one painting in the old way, then photograph it and print it, blown up, on canvas, and then use that as the underpainting for a second still life, painted from the same objects (which hopefully hadn't rotted yet).

Meanwhile I looked for an apartment to buy. Now I could actually choose what neighborhood to live in. Where, I asked myself and various real estate agents, is the Cambridge of New York? Aided by occasional visits to actual Cambridge, I gradually realized there wasn't one. Huh.

Around this time, in the spring of 2000, I had an idea. It was clear from our experience with Viaweb that web apps were the future. Why not build a web app for making web apps? Why not let people edit code on our server through the browser, and then host the resulting applications for them? [9] You could run all sorts of services on the servers that these applications could use just by making an API call: making and receiving phone calls, manipulating images, taking credit card payments, etc.

I got so excited about this idea that I couldn't think about anything else. It seemed obvious that this was the future. I didn't particularly want to start another company, but it was clear that this idea would have to be embodied as one, so I decided to move to Cambridge and start it. I hoped to lure Robert into working on it with me, but there I ran into a hitch. Robert was now a postdoc at MIT, and though he'd made a lot of money the last time I'd lured him into working on one of my schemes, it had also been a huge time sink. So while he agreed that it sounded like a plausible idea, he firmly refused to work on it.

Hmph.h&M,h'MCh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjz  hhh
}(hhhhhhhJ"% hhhhhhuh"j|  uh.(h
hhh"h0}ubhh)}(h}(hߌ$7468c747-026d-4627-ac1c-3e1ce6016cc5hhh
}h"@564c5be63e47fb9e442868c49c7e46e4de213d8ce6395e446fc99ad604e06051uh.(h
hhh"h0}ubuh"j  h$X<  [9] You could run all sorts of services on the servers that these applications could use just by making an API call: making and receiving phone calls, manipulating images, taking credit card payments, etc.

I got so excited about this idea that I couldn't think about anything else. It seemed obvious that this was the future. I didn't particularly want to start another company, but it was clear that this idea would have to be embodied as one, so I decided to move to Cambridge and start it. I hoped to lure Robert into working on it with me, but there I ran into a hitch. Robert was now a postdoc at MIT, and though he'd made a lot of money the last time I'd lured him into working on one of my schemes, it had also been a huge time sink. So while he agreed that it sounded like a plausible idea, he firmly refused to work on it.

Hmph. Well, I'd do it myself then. I recruited Dan Giffin, who had worked for Viaweb, and two undergrads who wanted summer jobs, and we got to work trying to build what it's now clear is about twenty companies and several open source projects worth of software. The language for defining applications would of course be a dialect of Lisp. But I wasn't so naive as to assume I could spring an overt Lisp on a general audience; we'd hide the parentheses, like Dylan did.

By then there was a name for the kind of company Viaweb was, an "application service provider," or ASP. This name didn't last long before it was replaced by "software as a service," but it was current for long enough that I named this new company after it: it was going to be called Aspra.

I started working on the application builder, Dan worked on network infrastructure, and the two undergrads worked on the first two services (images and phone calls). But about halfway through the summer I realized I really didn't want to run a company — especially not a big one, which it was looking like this would have to be. I'd only started Viaweb because I needed the money. Now that I didn't need money anymore, why was I doing this? If this vision had to be realized as a company, then screw the vision.h&Mh'M6h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$6b85a6d2-65bb-4022-9ff4-fe3261f0097ehhh
}h"@73e62600bfa1fe27f052e3de540fce9410b8ff1524d06ce3c79ecc76da00bf65uh.(h
hhh"h0}ubuh"j  h$XP  By then there was a name for the kind of company Viaweb was, an "application service provider," or ASP. This name didn't last long before it was replaced by "software as a service," but it was current for long enough that I named this new company after it: it was going to be called Aspra.

I started working on the application builder, Dan worked on network infrastructure, and the two undergrads worked on the first two services (images and phone calls). But about halfway through the summer I realized I really didn't want to run a company — especially not a big one, which it was looking like this would have to be. I'd only started Viaweb because I needed the money. Now that I didn't need money anymore, why was I doing this? If this vision had to be realized as a company, then screw the vision. I'd build a subset that could be done as an open source project.

Much to my surprise, the time I spent working on this stuff was not wasted after all. After we started Y Combinator, I would often encounter startups working on parts of this new architecture, and it was very useful to have spent so much time thinking about it and even trying to write some of it.

The subset I would build as an open source project was the new Lisp, whose parentheses I now wouldn't even have to hide. A lot of Lisp hackers dream of building a new Lisp, partly because one of the distinctive features of the language is that it has dialects, and partly, I think, because we have in our minds a Platonic form of Lisp that all existing dialects fall short of. I certainly did. So at the end of the summer Dan and I switched to working on this new dialect of Lisp, which I called Arc, in a house I bought in Cambridge.

The following spring, lightning struck. I was invited to give a talk at a Lisp conference, so I gave one about how we'd used Lisp at Viaweb. Afterward I put a postscript file of this talk online, on paulgraham.com, which I'd created years before using Viaweb but had never used for anything. In one day it got 30,000 page views. What on earth had happened? The referring urls showed that someone had posted it on Slashdot.h&Mh'Mbh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$991ae7da-d5dd-4d7b-9508-86d591222af4hhh
}h"@ee5402e1f789072a4ec849dc2b38659c438ed6bc5c8c38a12ba1b6c72e9eee3euh.(h
hhh"h0}ubuh"j  h$X@  I certainly did. So at the end of the summer Dan and I switched to working on this new dialect of Lisp, which I called Arc, in a house I bought in Cambridge.

The following spring, lightning struck. I was invited to give a talk at a Lisp conference, so I gave one about how we'd used Lisp at Viaweb. Afterward I put a postscript file of this talk online, on paulgraham.com, which I'd created years before using Viaweb but had never used for anything. In one day it got 30,000 page views. What on earth had happened? The referring urls showed that someone had posted it on Slashdot. [10]

Wow, I thought, there's an audience. If I write something and put it on the web, anyone can read it. That may seem obvious now, but it was surprising then. In the print era there was a narrow channel to readers, guarded by fierce monsters known as editors. The only way to get an audience for anything you wrote was to get it published as a book, or in a newspaper or magazine. Now anyone could publish anything.

This had been possible in principle since 1993, but not many people had realized it yet. I had been intimately involved with building the infrastructure of the web for most of that time, and a writer as well, and it had taken me 8 years to realize it. Even then it took me several years to understand the implications. It meant there would be a whole new generation of essays. [11]

In the print era, the channel for publishing essays had been vanishingly small. Except for a few officially anointed thinkers who went to the right parties in New York, the only people allowed to publish essays were specialists writing about their specialties. There were so many essays that had never been written, because there had been no way to publish them. Now they could be, and I was going to write them. [12]

I've worked on several different things, but to the extent there was a turning point where I figured out what to work on, it was when I started publishing essays online. From then on I knew that whatever else I did, I'd always write essays too.

I knew that online essays would be a marginal medium at first.h&Mh'M]h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$2152d559-8dca-4df8-b57e-e2c6efa5cb80hhh
}h"@69a1032f151a3c25f30f448c501f8af514a1939426a2b48307fa0cbb1a08f011uh.(h
hhh"h0}ubuh"j  h$X  Even then it took me several years to understand the implications. It meant there would be a whole new generation of essays. [11]

In the print era, the channel for publishing essays had been vanishingly small. Except for a few officially anointed thinkers who went to the right parties in New York, the only people allowed to publish essays were specialists writing about their specialties. There were so many essays that had never been written, because there had been no way to publish them. Now they could be, and I was going to write them. [12]

I've worked on several different things, but to the extent there was a turning point where I figured out what to work on, it was when I started publishing essays online. From then on I knew that whatever else I did, I'd always write essays too.

I knew that online essays would be a marginal medium at first. Socially they'd seem more like rants posted by nutjobs on their GeoCities sites than the genteel and beautifully typeset compositions published in The New Yorker. But by this point I knew enough to find that encouraging instead of discouraging.

One of the most conspicuous patterns I've noticed in my life is how well it has worked, for me at least, to work on things that weren't prestigious. Still life has always been the least prestigious form of painting. Viaweb and Y Combinator both seemed lame when we started them. I still get the glassy eye from strangers when they ask what I'm writing, and I explain that it's an essay I'm going to publish on my web site. Even Lisp, though prestigious intellectually in something like the way Latin is, also seems about as hip.

It's not that unprestigious types of work are good per se. But when you find yourself drawn to some kind of work despite its current lack of prestige, it's a sign both that there's something real to be discovered there, and that you have the right kind of motives. Impure motives are a big danger for the ambitious. If anything is going to lead you astray, it will be the desire to impress people. So while working on things that aren't prestigious doesn't guarantee you're on the right track, it at least guarantees you're not on the most common type of wrong one.h&Mh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$ea17b41e-29d5-4a2f-a9c4-3cfd70331941hhh
}h"@f77d7239e370a15d40c8ba65d691236866db9a1f32f8e3641b59f602f3da9cd4uh.(h
hhh"h0}ubuh"j  h$X?  I still get the glassy eye from strangers when they ask what I'm writing, and I explain that it's an essay I'm going to publish on my web site. Even Lisp, though prestigious intellectually in something like the way Latin is, also seems about as hip.

It's not that unprestigious types of work are good per se. But when you find yourself drawn to some kind of work despite its current lack of prestige, it's a sign both that there's something real to be discovered there, and that you have the right kind of motives. Impure motives are a big danger for the ambitious. If anything is going to lead you astray, it will be the desire to impress people. So while working on things that aren't prestigious doesn't guarantee you're on the right track, it at least guarantees you're not on the most common type of wrong one.

Over the next several years I wrote lots of essays about all kinds of different topics. O'Reilly reprinted a collection of them as a book, called Hackers & Painters after one of the essays in it. I also worked on spam filters, and did some more painting. I used to have dinners for a group of friends every thursday night, which taught me how to cook for groups. And I bought another building in Cambridge, a former candy factory (and later, twas said, porn studio), to use as an office.

One night in October 2003 there was a big party at my house. It was a clever idea of my friend Maria Daniels, who was one of the thursday diners. Three separate hosts would all invite their friends to one party. So for every guest, two thirds of the other guests would be people they didn't know but would probably like. One of the guests was someone I didn't know but would turn out to like a lot: a woman called Jessica Livingston. A couple days later I asked her out.

Jessica was in charge of marketing at a Boston investment bank. This bank thought it understood startups, but over the next year, as she met friends of mine from the startup world, she was surprised how different reality was. And how colorful their stories were. So she decided to compile a book of interviews with startup founders.h&Mkh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j.  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$361d8c1b-db16-4cfb-84ea-89db87ec6c62hhh
}h"@6e74efd8c7a21ae160f6dd55a3e991c1b7406e69b1ecc291e9eb6a55a7a7a91cuh.(h
hhh"h0}ubuh"j0  h$Xz  One night in October 2003 there was a big party at my house. It was a clever idea of my friend Maria Daniels, who was one of the thursday diners. Three separate hosts would all invite their friends to one party. So for every guest, two thirds of the other guests would be people they didn't know but would probably like. One of the guests was someone I didn't know but would turn out to like a lot: a woman called Jessica Livingston. A couple days later I asked her out.

Jessica was in charge of marketing at a Boston investment bank. This bank thought it understood startups, but over the next year, as she met friends of mine from the startup world, she was surprised how different reality was. And how colorful their stories were. So she decided to compile a book of interviews with startup founders.

When the bank had financial problems and she had to fire half her staff, she started looking for a new job. In early 2005 she interviewed for a marketing job at a Boston VC firm. It took them weeks to make up their minds, and during this time I started telling her about all the things that needed to be fixed about venture capital. They should make a larger number of smaller investments instead of a handful of giant ones, they should be funding younger, more technical founders instead of MBAs, they should let the founders remain as CEO, and so on.

One of my tricks for writing essays had always been to give talks. The prospect of having to stand up in front of a group of people and tell them something that won't waste their time is a great spur to the imagination. When the Harvard Computer Society, the undergrad computer club, asked me to give a talk, I decided I would tell them how to start a startup. Maybe they'd be able to avoid the worst of the mistakes we'd made.

So I gave this talk, in the course of which I told them that the best sources of seed funding were successful startup founders, because then they'd be sources of advice too. Whereupon it seemed they were all looking expectantly at me. Horrified at the prospect of having my inbox flooded by business plans (if I'd only known), I blurted out "But not me!" and went on with the talk.h&Mh'M h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jL  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj.  hhh
}(hhhhhhhJ"% hhhhhhuh"j0  uh.(h
hhh"h0}ubhh)}(h}(hߌ$5fd3917f-201b-4435-b398-90495222015chhh
}h"@f382ef199b17c454dc8b669a900362a46bf12e239c012451aa74ebce711bb4e9uh.(h
hhh"h0}ubuh"jN  h$X  One of my tricks for writing essays had always been to give talks. The prospect of having to stand up in front of a group of people and tell them something that won't waste their time is a great spur to the imagination. When the Harvard Computer Society, the undergrad computer club, asked me to give a talk, I decided I would tell them how to start a startup. Maybe they'd be able to avoid the worst of the mistakes we'd made.

So I gave this talk, in the course of which I told them that the best sources of seed funding were successful startup founders, because then they'd be sources of advice too. Whereupon it seemed they were all looking expectantly at me. Horrified at the prospect of having my inbox flooded by business plans (if I'd only known), I blurted out "But not me!" and went on with the talk. But afterward it occurred to me that I should really stop procrastinating about angel investing. I'd been meaning to since Yahoo bought us, and now it was 7 years later and I still hadn't done one angel investment.

Meanwhile I had been scheming with Robert and Trevor about projects we could work on together. I missed working with them, and it seemed like there had to be something we could collaborate on.

As Jessica and I were walking home from dinner on March 11, at the corner of Garden and Walker streets, these three threads converged. Screw the VCs who were taking so long to make up their minds. We'd start our own investment firm and actually implement the ideas we'd been talking about. I'd fund it, and Jessica could quit her job and work for it, and we'd get Robert and Trevor as partners too. [13]

Once again, ignorance worked in our favor. We had no idea how to be angel investors, and in Boston in 2005 there were no Ron Conways to learn from. So we just made what seemed like the obvious choices, and some of the things we did turned out to be novel.

There are multiple components to Y Combinator, and we didn't figure them all out at once. The part we got first was to be an angel firm. In those days, those two words didn't go together.h&Mֻh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jj  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjL  hhh
}(hhhhhhhJ"% hhhhhhuh"jN  uh.(h
hhh"h0}ubhh)}(h}(hߌ$fac2a14a-18d9-4b19-9c53-5abc8fbe3386hhh
}h"@d91f5de177a4d90e4a4c540117675682a22e8e1eb9b14329d2679fd596a02caauh.(h
hhh"h0}ubuh"jl  h$X  Screw the VCs who were taking so long to make up their minds. We'd start our own investment firm and actually implement the ideas we'd been talking about. I'd fund it, and Jessica could quit her job and work for it, and we'd get Robert and Trevor as partners too. [13]

Once again, ignorance worked in our favor. We had no idea how to be angel investors, and in Boston in 2005 there were no Ron Conways to learn from. So we just made what seemed like the obvious choices, and some of the things we did turned out to be novel.

There are multiple components to Y Combinator, and we didn't figure them all out at once. The part we got first was to be an angel firm. In those days, those two words didn't go together. There were VC firms, which were organized companies with people whose job it was to make investments, but they only did big, million dollar investments. And there were angels, who did smaller investments, but these were individuals who were usually focused on other things and made investments on the side. And neither of them helped founders enough in the beginning. We knew how helpless founders were in some respects, because we remembered how helpless we'd been. For example, one thing Julian had done for us that seemed to us like magic was to get us set up as a company. We were fine writing fairly difficult software, but actually getting incorporated, with bylaws and stock and all that stuff, how on earth did you do that? Our plan was not only to make seed investments, but to do for startups everything Julian had done for us.

YC was not organized as a fund. It was cheap enough to run that we funded it with our own money. That went right by 99% of readers, but professional investors are thinking "Wow, that means they got all the returns." But once again, this was not due to any particular insight on our part. We didn't know how VC firms were organized. It never occurred to us to try to raise a fund, and if it had, we wouldn't have known where to start.h&M"h'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjj  hhh
}(hhhhhhhJ"% hhhhhhuh"jl  uh.(h
hhh"h0}ubhh)}(h}(hߌ$f62fdbca-fcc0-4984-9aaa-f50a22839206hhh
}h"@a126787371545fbb272ccf761a953fbe254c8aab764472cde8ebebbaddbc2c15uh.(h
hhh"h0}ubuh"j  h$X  For example, one thing Julian had done for us that seemed to us like magic was to get us set up as a company. We were fine writing fairly difficult software, but actually getting incorporated, with bylaws and stock and all that stuff, how on earth did you do that? Our plan was not only to make seed investments, but to do for startups everything Julian had done for us.

YC was not organized as a fund. It was cheap enough to run that we funded it with our own money. That went right by 99% of readers, but professional investors are thinking "Wow, that means they got all the returns." But once again, this was not due to any particular insight on our part. We didn't know how VC firms were organized. It never occurred to us to try to raise a fund, and if it had, we wouldn't have known where to start. [14]

The most distinctive thing about YC is the batch model: to fund a bunch of startups all at once, twice a year, and then to spend three months focusing intensively on trying to help them. That part we discovered by accident, not merely implicitly but explicitly due to our ignorance about investing. We needed to get experience as investors. What better way, we thought, than to fund a whole bunch of startups at once? We knew undergrads got temporary jobs at tech companies during the summer. Why not organize a summer program where they'd start startups instead? We wouldn't feel guilty for being in a sense fake investors, because they would in a similar sense be fake founders. So while we probably wouldn't make much money out of it, we'd at least get to practice being investors on them, and they for their part would probably have a more interesting summer than they would working at Microsoft.

We'd use the building I owned in Cambridge as our headquarters. We'd all have dinner there once a week — on tuesdays, since I was already cooking for the thursday diners on thursdays — and after dinner we'd bring in experts on startups to give talks.

We knew undergrads were deciding then about summer jobs, so in a matter of days we cooked up something we called the Summer Founders Program, and I posted an announcement on my site, inviting undergrads to apply.h&Mh'MBh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$684ecd98-2d23-421e-b0a1-0b76ea409070hhh
}h"@680cdace38347e144d9928c9ffde0f2082092a1bf8a4a5dd9f36b42e40f838b6uh.(h
hhh"h0}ubuh"j  h$X|  Why not organize a summer program where they'd start startups instead? We wouldn't feel guilty for being in a sense fake investors, because they would in a similar sense be fake founders. So while we probably wouldn't make much money out of it, we'd at least get to practice being investors on them, and they for their part would probably have a more interesting summer than they would working at Microsoft.

We'd use the building I owned in Cambridge as our headquarters. We'd all have dinner there once a week — on tuesdays, since I was already cooking for the thursday diners on thursdays — and after dinner we'd bring in experts on startups to give talks.

We knew undergrads were deciding then about summer jobs, so in a matter of days we cooked up something we called the Summer Founders Program, and I posted an announcement on my site, inviting undergrads to apply. I had never imagined that writing essays would be a way to get "deal flow," as investors call it, but it turned out to be the perfect source. [15] We got 225 applications for the Summer Founders Program, and we were surprised to find that a lot of them were from people who'd already graduated, or were about to that spring. Already this SFP thing was starting to feel more serious than we'd intended.

We invited about 20 of the 225 groups to interview in person, and from those we picked 8 to fund. They were an impressive group. That first batch included reddit, Justin Kan and Emmett Shear, who went on to found Twitch, Aaron Swartz, who had already helped write the RSS spec and would a few years later become a martyr for open access, and Sam Altman, who would later become the second president of YC. I don't think it was entirely luck that the first batch was so good. You had to be pretty bold to sign up for a weird thing like the Summer Founders Program instead of a summer job at a legit place like Microsoft or Goldman Sachs.

The deal for startups was based on a combination of the deal we did with Julian ($10k for 10%) and what Robert said MIT grad students got for the summer ($6k). We invested $6k per founder, which in the typical two-founder case was $12k, in return for 6%.h&Mh'MQh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$9cdb48ed-6d69-455e-a897-3d0d90e4a71ahhh
}h"@a42a3346e0982826444a3c353a6cef6e60a06422c963e3f61b50285079cb78c1uh.(h
hhh"h0}ubuh"j  h$X{  They were an impressive group. That first batch included reddit, Justin Kan and Emmett Shear, who went on to found Twitch, Aaron Swartz, who had already helped write the RSS spec and would a few years later become a martyr for open access, and Sam Altman, who would later become the second president of YC. I don't think it was entirely luck that the first batch was so good. You had to be pretty bold to sign up for a weird thing like the Summer Founders Program instead of a summer job at a legit place like Microsoft or Goldman Sachs.

The deal for startups was based on a combination of the deal we did with Julian ($10k for 10%) and what Robert said MIT grad students got for the summer ($6k). We invested $6k per founder, which in the typical two-founder case was $12k, in return for 6%. That had to be fair, because it was twice as good as the deal we ourselves had taken. Plus that first summer, which was really hot, Jessica brought the founders free air conditioners. [16]

Fairly quickly I realized that we had stumbled upon the way to scale startup funding. Funding startups in batches was more convenient for us, because it meant we could do things for a lot of startups at once, but being part of a batch was better for the startups too. It solved one of the biggest problems faced by founders: the isolation. Now you not only had colleagues, but colleagues who understood the problems you were facing and could tell you how they were solving them.

As YC grew, we started to notice other advantages of scale. The alumni became a tight community, dedicated to helping one another, and especially the current batch, whose shoes they remembered being in. We also noticed that the startups were becoming one another's customers. We used to refer jokingly to the "YC GDP," but as YC grows this becomes less and less of a joke. Now lots of startups get their initial set of customers almost entirely from among their batchmates.

I had not originally intended YC to be a full-time job. I was going to do three things: hack, write essays, and work on YC. As YC grew, and I grew more excited about it, it started to take up a lot more than a third of my attention.h&M8h'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$a663a4b1-2049-44f9-b21b-c4dcefa0a996hhh
}h"@7d51bac2866f79a1b873c3bb5caff95fca81cc16ecd8591941b66e9e20b73c68uh.(h
hhh"h0}ubuh"j  h$X=  Now you not only had colleagues, but colleagues who understood the problems you were facing and could tell you how they were solving them.

As YC grew, we started to notice other advantages of scale. The alumni became a tight community, dedicated to helping one another, and especially the current batch, whose shoes they remembered being in. We also noticed that the startups were becoming one another's customers. We used to refer jokingly to the "YC GDP," but as YC grows this becomes less and less of a joke. Now lots of startups get their initial set of customers almost entirely from among their batchmates.

I had not originally intended YC to be a full-time job. I was going to do three things: hack, write essays, and work on YC. As YC grew, and I grew more excited about it, it started to take up a lot more than a third of my attention. But for the first few years I was still able to work on other things.

In the summer of 2006, Robert and I started working on a new version of Arc. This one was reasonably fast, because it was compiled into Scheme. To test this new Arc, I wrote Hacker News in it. It was originally meant to be a news aggregator for startup founders and was called Startup News, but after a few months I got tired of reading about nothing but startups. Plus it wasn't startup founders we wanted to reach. It was future startup founders. So I changed the name to Hacker News and the topic to whatever engaged one's intellectual curiosity.

HN was no doubt good for YC, but it was also by far the biggest source of stress for me. If all I'd had to do was select and help founders, life would have been so easy. And that implies that HN was a mistake. Surely the biggest source of stress in one's work should at least be something close to the core of the work. Whereas I was like someone who was in pain while running a marathon not from the exertion of running, but because I had a blister from an ill-fitting shoe. When I was dealing with some urgent problem during YC, there was about a 60% chance it had to do with HN, and a 40% chance it had do with everything else combined.h&Mdh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j   hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$d979ff5d-829c-475c-ba69-e9a6c94a136fhhh
}h"@b50b7cc5bb944825bbe97edf07c4515288c74bbd7949f0b8bcc539e4be96f96cuh.(h
hhh"h0}ubuh"j  h$X  Plus it wasn't startup founders we wanted to reach. It was future startup founders. So I changed the name to Hacker News and the topic to whatever engaged one's intellectual curiosity.

HN was no doubt good for YC, but it was also by far the biggest source of stress for me. If all I'd had to do was select and help founders, life would have been so easy. And that implies that HN was a mistake. Surely the biggest source of stress in one's work should at least be something close to the core of the work. Whereas I was like someone who was in pain while running a marathon not from the exertion of running, but because I had a blister from an ill-fitting shoe. When I was dealing with some urgent problem during YC, there was about a 60% chance it had to do with HN, and a 40% chance it had do with everything else combined. [17]

As well as HN, I wrote all of YC's internal software in Arc. But while I continued to work a good deal in Arc, I gradually stopped working on Arc, partly because I didn't have time to, and partly because it was a lot less attractive to mess around with the language now that we had all this infrastructure depending on it. So now my three projects were reduced to two: writing essays and working on YC.

YC was different from other kinds of work I've done. Instead of deciding for myself what to work on, the problems came to me. Every 6 months there was a new batch of startups, and their problems, whatever they were, became our problems. It was very engaging work, because their problems were quite varied, and the good founders were very effective. If you were trying to learn the most you could about startups in the shortest possible time, you couldn't have picked a better way to do it.

There were parts of the job I didn't like. Disputes between cofounders, figuring out when people were lying to us, fighting with people who maltreated the startups, and so on. But I worked hard even at the parts I didn't like. I was haunted by something Kevin Hale once said about companies: "No one works harder than the boss."h&Mhh'Moh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj   hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$3de654b3-062f-4805-b8e1-6d0509fb5b4fhhh
}h"@e5954dcdae6075f8a4ae630b08d8e7abc3ad22c1936bf4881c55bd3d75ea03cfuh.(h
hhh"h0}ubuh"j   h$X  YC was different from other kinds of work I've done. Instead of deciding for myself what to work on, the problems came to me. Every 6 months there was a new batch of startups, and their problems, whatever they were, became our problems. It was very engaging work, because their problems were quite varied, and the good founders were very effective. If you were trying to learn the most you could about startups in the shortest possible time, you couldn't have picked a better way to do it.

There were parts of the job I didn't like. Disputes between cofounders, figuring out when people were lying to us, fighting with people who maltreated the startups, and so on. But I worked hard even at the parts I didn't like. I was haunted by something Kevin Hale once said about companies: "No one works harder than the boss." He meant it both descriptively and prescriptively, and it was the second part that scared me. I wanted YC to be good, so if how hard I worked set the upper bound on how hard everyone else worked, I'd better work very hard.

One day in 2010, when he was visiting California for interviews, Robert Morris did something astonishing: he offered me unsolicited advice. I can only remember him doing that once before. One day at Viaweb, when I was bent over double from a kidney stone, he suggested that it would be a good idea for him to take me to the hospital. That was what it took for Rtm to offer unsolicited advice. So I remember his exact words very clearly. "You know," he said, "you should make sure Y Combinator isn't the last cool thing you do."

At the time I didn't understand what he meant, but gradually it dawned on me that he was saying I should quit. This seemed strange advice, because YC was doing great. But if there was one thing rarer than Rtm offering advice, it was Rtm being wrong. So this set me thinking. It was true that on my current trajectory, YC would be the last thing I did, because it was only taking up more of my attention. It had already eaten Arc, and was in the process of eating essays too.h&M<h'M;h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j<  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j   uh.(h
hhh"h0}ubhh)}(h}(hߌ$a1b94fdd-8b6b-4dab-aa43-f80637447397hhh
}h"@2e208be78d850cfef42cd0dfd565078122bae0791bb957e0506c63ed83f1f726uh.(h
hhh"h0}ubuh"j>  h$X  That was what it took for Rtm to offer unsolicited advice. So I remember his exact words very clearly. "You know," he said, "you should make sure Y Combinator isn't the last cool thing you do."

At the time I didn't understand what he meant, but gradually it dawned on me that he was saying I should quit. This seemed strange advice, because YC was doing great. But if there was one thing rarer than Rtm offering advice, it was Rtm being wrong. So this set me thinking. It was true that on my current trajectory, YC would be the last thing I did, because it was only taking up more of my attention. It had already eaten Arc, and was in the process of eating essays too. Either YC was my life's work or I'd have to leave eventually. And it wasn't, so I would.

In the summer of 2012 my mother had a stroke, and the cause turned out to be a blood clot caused by colon cancer. The stroke destroyed her balance, and she was put in a nursing home, but she really wanted to get out of it and back to her house, and my sister and I were determined to help her do it. I used to fly up to Oregon to visit her regularly, and I had a lot of time to think on those flights. On one of them I realized I was ready to hand YC over to someone else.

I asked Jessica if she wanted to be president, but she didn't, so we decided we'd try to recruit Sam Altman. We talked to Robert and Trevor and we agreed to make it a complete changing of the guard. Up till that point YC had been controlled by the original LLC we four had started. But we wanted YC to last for a long time, and to do that it couldn't be controlled by the founders. So if Sam said yes, we'd let him reorganize YC. Robert and I would retire, and Jessica and Trevor would become ordinary partners.

When we asked Sam if he wanted to be president of YC, initially he said no. He wanted to start a startup to make nuclear reactors. But I kept at it, and in October 2013 he finally agreed.h&Mh'M,h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jZ  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj<  hhh
}(hhhhhhhJ"% hhhhhhuh"j>  uh.(h
hhh"h0}ubhh)}(h}(hߌ$be2cb1eb-48bd-477e-be6e-1cb31b2c1139hhh
}h"@04fe99348c3e573d06e6c120a3daa42c2546ee5e124a5b6e382d2888914306e2uh.(h
hhh"h0}ubuh"j\  h$X  On one of them I realized I was ready to hand YC over to someone else.

I asked Jessica if she wanted to be president, but she didn't, so we decided we'd try to recruit Sam Altman. We talked to Robert and Trevor and we agreed to make it a complete changing of the guard. Up till that point YC had been controlled by the original LLC we four had started. But we wanted YC to last for a long time, and to do that it couldn't be controlled by the founders. So if Sam said yes, we'd let him reorganize YC. Robert and I would retire, and Jessica and Trevor would become ordinary partners.

When we asked Sam if he wanted to be president of YC, initially he said no. He wanted to start a startup to make nuclear reactors. But I kept at it, and in October 2013 he finally agreed. We decided he'd take over starting with the winter 2014 batch. For the rest of 2013 I left running YC more and more to Sam, partly so he could learn the job, and partly because I was focused on my mother, whose cancer had returned.

She died on January 15, 2014. We knew this was coming, but it was still hard when it did.

I kept working on YC till March, to help get that batch of startups through Demo Day, then I checked out pretty completely. (I still talk to alumni and to new startups working on things I'm interested in, but that only takes a few hours a week.)

What should I do next? Rtm's advice hadn't included anything about that. I wanted to do something completely different, so I decided I'd paint. I wanted to see how good I could get if I really focused on it. So the day after I stopped working on YC, I started painting. I was rusty and it took a while to get back into shape, but it was at least completely engaging. [18]

I spent most of the rest of 2014 painting. I'd never been able to work so uninterruptedly before, and I got to be better than I had been. Not good enough, but better. Then in November, right in the middle of a painting, I ran out of steam.h&M(h'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jx  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjZ  hhh
}(hhhhhhhJ"% hhhhhhuh"j\  uh.(h
hhh"h0}ubhh)}(h}(hߌ$6c749475-d296-4f5e-864c-e0ee03b9de77hhh
}h"@89e93b82c98523fcefd80bd1b90fedc83e3214061aa58376d58fcf2e00105e01uh.(h
hhh"h0}ubuh"jz  h$X:  (I still talk to alumni and to new startups working on things I'm interested in, but that only takes a few hours a week.)

What should I do next? Rtm's advice hadn't included anything about that. I wanted to do something completely different, so I decided I'd paint. I wanted to see how good I could get if I really focused on it. So the day after I stopped working on YC, I started painting. I was rusty and it took a while to get back into shape, but it was at least completely engaging. [18]

I spent most of the rest of 2014 painting. I'd never been able to work so uninterruptedly before, and I got to be better than I had been. Not good enough, but better. Then in November, right in the middle of a painting, I ran out of steam. Up till that point I'd always been curious to see how the painting I was working on would turn out, but suddenly finishing this one seemed like a chore. So I stopped working on it and cleaned my brushes and haven't painted since. So far anyway.

I realize that sounds rather wimpy. But attention is a zero sum game. If you can choose what to work on, and you choose a project that's not the best one (or at least a good one) for you, then it's getting in the way of another project that is. And at 50 there was some opportunity cost to screwing around.

I started writing essays again, and wrote a bunch of new ones over the next few months. I even wrote a couple that weren't about startups. Then in March 2015 I started working on Lisp again.

The distinctive thing about Lisp is that its core is a language defined by writing an interpreter in itself. It wasn't originally intended as a programming language in the ordinary sense. It was meant to be a formal model of computation, an alternative to the Turing machine. If you want to write an interpreter for a language in itself, what's the minimum set of predefined operators you need? The Lisp that John McCarthy invented, or more accurately discovered, is an answer to that question. [19]

McCarthy didn't realize this Lisp could even be used to program computers till his grad student Steve Russell suggested it.h&Mh'M'h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjx  hhh
}(hhhhhhhJ"% hhhhhhuh"jz  uh.(h
hhh"h0}ubhh)}(h}(hߌ$84d70d50-9f91-46a0-8048-65c78ea78dbehhh
}h"@1b9a0b7e1762b200ae7e7c07d0a270b47b4c6e489fcab598629d7d7d13c57a96uh.(h
hhh"h0}ubuh"j  h$X  And at 50 there was some opportunity cost to screwing around.

I started writing essays again, and wrote a bunch of new ones over the next few months. I even wrote a couple that weren't about startups. Then in March 2015 I started working on Lisp again.

The distinctive thing about Lisp is that its core is a language defined by writing an interpreter in itself. It wasn't originally intended as a programming language in the ordinary sense. It was meant to be a formal model of computation, an alternative to the Turing machine. If you want to write an interpreter for a language in itself, what's the minimum set of predefined operators you need? The Lisp that John McCarthy invented, or more accurately discovered, is an answer to that question. [19]

McCarthy didn't realize this Lisp could even be used to program computers till his grad student Steve Russell suggested it. Russell translated McCarthy's interpreter into IBM 704 machine language, and from that point Lisp started also to be a programming language in the ordinary sense. But its origins as a model of computation gave it a power and elegance that other languages couldn't match. It was this that attracted me in college, though I didn't understand why at the time.

McCarthy's 1960 Lisp did nothing more than interpret Lisp expressions. It was missing a lot of things you'd want in a programming language. So these had to be added, and when they were, they weren't defined using McCarthy's original axiomatic approach. That wouldn't have been feasible at the time. McCarthy tested his interpreter by hand-simulating the execution of programs. But it was already getting close to the limit of interpreters you could test that way — indeed, there was a bug in it that McCarthy had overlooked. To test a more complicated interpreter, you'd have had to run it, and computers then weren't powerful enough.

Now they are, though. Now you could continue using McCarthy's axiomatic approach till you'd defined a complete programming language. And as long as every change you made to McCarthy's Lisp was a discoveredness-preserving transformation, you could, in principle, end up with a complete language that had this quality. Harder to do than to talk about, of course, but if it was possible in principle, why not try?      h&Mh'Mh(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$508cf6b7-0c1c-483d-a36a-dc3cc46bc98ehhh
}h"@6ee6318fa8968c3c8291cdff48373a67b308c53d12d1d63a8272efbd2747f8e4uh.(h
hhh"h0}ubuh"j  h$X  So these had to be added, and when they were, they weren't defined using McCarthy's original axiomatic approach. That wouldn't have been feasible at the time. McCarthy tested his interpreter by hand-simulating the execution of programs. But it was already getting close to the limit of interpreters you could test that way — indeed, there was a bug in it that McCarthy had overlooked. To test a more complicated interpreter, you'd have had to run it, and computers then weren't powerful enough.

Now they are, though. Now you could continue using McCarthy's axiomatic approach till you'd defined a complete programming language. And as long as every change you made to McCarthy's Lisp was a discoveredness-preserving transformation, you could, in principle, end up with a complete language that had this quality. Harder to do than to talk about, of course, but if it was possible in principle, why not try? So I decided to take a shot at it. It took 4 years, from March 26, 2015 to October 12, 2019. It was fortunate that I had a precisely defined goal, or it would have been hard to keep at it for so long.

I wrote this new Lisp, called Bel, in itself in Arc. That may sound like a contradiction, but it's an indication of the sort of trickery I had to engage in to make this work. By means of an egregious collection of hacks I managed to make something close enough to an interpreter written in itself that could actually run. Not fast, but fast enough to test.

I had to ban myself from writing essays during most of this time, or I'd never have finished. In late 2015 I spent 3 months writing essays, and when I went back to working on Bel I could barely understand the code. Not so much because it was badly written as because the problem is so convoluted. When you're working on an interpreter written in itself, it's hard to keep track of what's happening at what level, and errors can be practically encrypted by the time you get them.

So I said no more essays till Bel was done. But I told few people about Bel while I was working on it.h&Mh'J  h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$fc0ff159-0387-46a8-acff-a89233be9f89hhh
}h"@9ee651ff61b2a9ee1749d7796b8c2dfa004937508e4bbe8e2c82cfc9cf7aa970uh.(h
hhh"h0}ubuh"j  h$X_  By means of an egregious collection of hacks I managed to make something close enough to an interpreter written in itself that could actually run. Not fast, but fast enough to test.

I had to ban myself from writing essays during most of this time, or I'd never have finished. In late 2015 I spent 3 months writing essays, and when I went back to working on Bel I could barely understand the code. Not so much because it was badly written as because the problem is so convoluted. When you're working on an interpreter written in itself, it's hard to keep track of what's happening at what level, and errors can be practically encrypted by the time you get them.

So I said no more essays till Bel was done. But I told few people about Bel while I was working on it. So for years it must have seemed that I was doing nothing, when in fact I was working harder than I'd ever worked on anything. Occasionally after wrestling for hours with some gruesome bug I'd check Twitter or HN and see someone asking "Does Paul Graham still code?"

Working on Bel was hard but satisfying. I worked on it so intensively that at any given time I had a decent chunk of the code in my head and could write more there. I remember taking the boys to the coast on a sunny day in 2015 and figuring out how to deal with some problem involving continuations while I watched them play in the tide pools. It felt like I was doing life right. I remember that because I was slightly dismayed at how novel it felt. The good news is that I had more moments like this over the next few years.

In the summer of 2016 we moved to England. We wanted our kids to see what it was like living in another country, and since I was a British citizen by birth, that seemed the obvious choice. We only meant to stay for a year, but we liked it so much that we still live there. So most of Bel was written in England.

In the fall of 2019, Bel was finally finished. Like McCarthy's original Lisp, it's a spec rather than an implementation, although like McCarthy's Lisp it's a spec expressed as code.

Now that I could write essays again, I wrote a bunch about topics I'd had stacked up.h&Mh'J} h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$54f0abd6-f0ab-4c7f-a2cc-e711c70b851ahhh
}h"@7492559551410a9347e4a2a36f0036075e1e16bd04263f8f1e2819496ffa4a8auh.(h
hhh"h0}ubuh"j  h$X=  It felt like I was doing life right. I remember that because I was slightly dismayed at how novel it felt. The good news is that I had more moments like this over the next few years.

In the summer of 2016 we moved to England. We wanted our kids to see what it was like living in another country, and since I was a British citizen by birth, that seemed the obvious choice. We only meant to stay for a year, but we liked it so much that we still live there. So most of Bel was written in England.

In the fall of 2019, Bel was finally finished. Like McCarthy's original Lisp, it's a spec rather than an implementation, although like McCarthy's Lisp it's a spec expressed as code.

Now that I could write essays again, I wrote a bunch about topics I'd had stacked up. I kept writing essays through 2020, but I also started to think about other things I could work on. How should I choose what to do? Well, how had I chosen what to work on in the past? I wrote an essay for myself to answer that question, and I was surprised how long and messy the answer turned out to be. If this surprised me, who'd lived it, then I thought perhaps it would be interesting to other people, and encouraging to those with similarly messy lives. So I wrote a more detailed version for others to read, and this is the last sentence of it.









Notes

[1] My experience skipped a step in the evolution of computers: time-sharing machines with interactive OSes. I went straight from batch processing to microcomputers, which made microcomputers seem all the more exciting.

[2] Italian words for abstract concepts can nearly always be predicted from their English cognates (except for occasional traps like polluzione). It's the everyday words that differ. So if you string together a lot of abstract concepts with a few simple verbs, you can make a little Italian go a long way.

[3] I lived at Piazza San Felice 4, so my walk to the Accademia went straight down the spine of old Florence: past the Pitti, across the bridge, past Orsanmichele, between the Duomo and the Baptistery, and then up Via Ricasoli to Piazza San Marco.h&J h'J
 h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$5ef5201d-7441-4f53-8f9c-ee42399a7048hhh
}h"@3fd9a470c4e737c8d28263f5e89a9b50d541ba7878f627b6045ce31a0ec8427auh.(h
hhh"h0}ubuh"j  h$X\  Notes

[1] My experience skipped a step in the evolution of computers: time-sharing machines with interactive OSes. I went straight from batch processing to microcomputers, which made microcomputers seem all the more exciting.

[2] Italian words for abstract concepts can nearly always be predicted from their English cognates (except for occasional traps like polluzione). It's the everyday words that differ. So if you string together a lot of abstract concepts with a few simple verbs, you can make a little Italian go a long way.

[3] I lived at Piazza San Felice 4, so my walk to the Accademia went straight down the spine of old Florence: past the Pitti, across the bridge, past Orsanmichele, between the Duomo and the Baptistery, and then up Via Ricasoli to Piazza San Marco. I saw Florence at street level in every possible condition, from empty dark winter evenings to sweltering summer days when the streets were packed with tourists.

[4] You can of course paint people like still lives if you want to, and they're willing. That sort of portrait is arguably the apex of still life painting, though the long sitting does tend to produce pained expressions in the sitters.

[5] Interleaf was one of many companies that had smart people and built impressive technology, and yet got crushed by Moore's Law. In the 1990s the exponential growth in the power of commodity (i.e. Intel) processors rolled up high-end, special-purpose hardware and software companies like a bulldozer.

[6] The signature style seekers at RISD weren't specifically mercenary. In the art world, money and coolness are tightly coupled. Anything expensive comes to be seen as cool, and anything seen as cool will soon become equally expensive.

[7] Technically the apartment wasn't rent-controlled but rent-stabilized, but this is a refinement only New Yorkers would know or care about. The point is that it was really cheap, less than half market price.

[8] Most software you can launch as soon as it's done. But when the software is an online store builder and you're hosting the stores, if you don't have any users yet, that fact will be painfully obvious.h&J h'J h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j,  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj  hhh
}(hhhhhhhJ"% hhhhhhuh"j  uh.(h
hhh"h0}ubhh)}(h}(hߌ$79ff893e-6147-4cfa-8dd9-9cb1404e45d2hhh
}h"@b6a4cd35cffab911ca51438b76f739577f777dd84757d84f51d6ef5a68a87f27uh.(h
hhh"h0}ubuh"j.  h$X.  In the 1990s the exponential growth in the power of commodity (i.e. Intel) processors rolled up high-end, special-purpose hardware and software companies like a bulldozer.

[6] The signature style seekers at RISD weren't specifically mercenary. In the art world, money and coolness are tightly coupled. Anything expensive comes to be seen as cool, and anything seen as cool will soon become equally expensive.

[7] Technically the apartment wasn't rent-controlled but rent-stabilized, but this is a refinement only New Yorkers would know or care about. The point is that it was really cheap, less than half market price.

[8] Most software you can launch as soon as it's done. But when the software is an online store builder and you're hosting the stores, if you don't have any users yet, that fact will be painfully obvious. So before we could launch publicly we had to launch privately, in the sense of recruiting an initial set of users and making sure they had decent-looking stores.

[9] We'd had a code editor in Viaweb for users to define their own page styles. They didn't know it, but they were editing Lisp expressions underneath. But this wasn't an app editor, because the code ran when the merchants' sites were generated, not when shoppers visited them.

[10] This was the first instance of what is now a familiar experience, and so was what happened next, when I read the comments and found they were full of angry people. How could I claim that Lisp was better than other languages? Weren't they all Turing complete? People who see the responses to essays I write sometimes tell me how sorry they feel for me, but I'm not exaggerating when I reply that it has always been like this, since the very beginning. It comes with the territory. An essay must tell readers things they don't already know, and some people dislike being told such things.

[11] People put plenty of stuff on the internet in the 90s of course, but putting something online is not the same as publishing it online. Publishing online means you treat the online version as the (or at least a) primary version.h&J h'J h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jJ  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hj,  hhh
}(hhhhhhhJ"% hhhhhhuh"j.  uh.(h
hhh"h0}ubhh)}(h}(hߌ$00af6072-a563-4aa3-a238-bf8a634deaa1hhh
}h"@40e22b8d6ddace6a75b0377cf0c3c3e71ad9c2e17a58d09cae45e346260bb430uh.(h
hhh"h0}ubuh"jL  h$X  [10] This was the first instance of what is now a familiar experience, and so was what happened next, when I read the comments and found they were full of angry people. How could I claim that Lisp was better than other languages? Weren't they all Turing complete? People who see the responses to essays I write sometimes tell me how sorry they feel for me, but I'm not exaggerating when I reply that it has always been like this, since the very beginning. It comes with the territory. An essay must tell readers things they don't already know, and some people dislike being told such things.

[11] People put plenty of stuff on the internet in the 90s of course, but putting something online is not the same as publishing it online. Publishing online means you treat the online version as the (or at least a) primary version.

[12] There is a general lesson here that our experience with Y Combinator also teaches: Customs continue to constrain you long after the restrictions that caused them have disappeared. Customary VC practice had once, like the customs about publishing essays, been based on real constraints. Startups had once been much more expensive to start, and proportionally rare. Now they could be cheap and common, but the VCs' customs still reflected the old world, just as customs about writing essays still reflected the constraints of the print era.

Which in turn implies that people who are independent-minded (i.e. less influenced by custom) will have an advantage in fields affected by rapid change (where customs are more likely to be obsolete).

Here's an interesting point, though: you can't always predict which fields will be affected by rapid change. Obviously software and venture capital will be, but who would have predicted that essay writing would be?

[13] Y Combinator was not the original name. At first we were called Cambridge Seed. But we didn't want a regional name, in case someone copied us in Silicon Valley, so we renamed ourselves after one of the coolest tricks in the lambda calculus, the Y combinator.

I picked orange as our color partly because it's the warmest, and partly because no VC used it. In 2005 all the VCs used staid colors like maroon, navy blue, and forest green, because they were trying to appeal to LPs, not founders.h&J h'J h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
jh  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjJ  hhh
}(hhhhhhhJ"% hhhhhhuh"jL  uh.(h
hhh"h0}ubhh)}(h}(hߌ$3f0835be-e5a6-466e-adf3-564ce16def73hhh
}h"@6df5024bc4a7ba3d70654aecbd50142a8b38021e87be31e795c77103472f492duh.(h
hhh"h0}ubuh"jj  h$X/  less influenced by custom) will have an advantage in fields affected by rapid change (where customs are more likely to be obsolete).

Here's an interesting point, though: you can't always predict which fields will be affected by rapid change. Obviously software and venture capital will be, but who would have predicted that essay writing would be?

[13] Y Combinator was not the original name. At first we were called Cambridge Seed. But we didn't want a regional name, in case someone copied us in Silicon Valley, so we renamed ourselves after one of the coolest tricks in the lambda calculus, the Y combinator.

I picked orange as our color partly because it's the warmest, and partly because no VC used it. In 2005 all the VCs used staid colors like maroon, navy blue, and forest green, because they were trying to appeal to LPs, not founders. The YC logo itself is an inside joke: the Viaweb logo had been a white V on a red circle, so I made the YC logo a white Y on an orange square.

[14] YC did become a fund for a couple years starting in 2009, because it was getting so big I could no longer afford to fund it personally. But after Heroku got bought we had enough money to go back to being self-funded.

[15] I've never liked the term "deal flow," because it implies that the number of new startups at any given time is fixed. This is not only false, but it's the purpose of YC to falsify it, by causing startups to be founded that would not otherwise have existed.

[16] She reports that they were all different shapes and sizes, because there was a run on air conditioners and she had to get whatever she could, but that they were all heavier than she could carry now.

[17] Another problem with HN was a bizarre edge case that occurs when you both write essays and run a forum. When you run a forum, you're assumed to see if not every conversation, at least every conversation involving you. And when you write essays, people post highly imaginative misinterpretations of them on forums. Individually these two phenomena are tedious but bearable, but the combination is disastrous.h&Je h'J h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ubh)}(h}(h
j  hNh
}(hhhhhhhJ"% hhhhhhuh](hhhhhheh](hhhhhheh }(hh)}(h}(hhhhh
}(hhhhhhhJ"% hhhhhhuh"h#uh.(h
hhh"h0}ubj
  h)}(h}(hjh  hhh
}(hhhhhhhJ"% hhhhhhuh"jj  uh.(h
hhh"h0}ubuh"j  h$X  [15] I've never liked the term "deal flow," because it implies that the number of new startups at any given time is fixed. This is not only false, but it's the purpose of YC to falsify it, by causing startups to be founded that would not otherwise have existed.

[16] She reports that they were all different shapes and sizes, because there was a run on air conditioners and she had to get whatever she could, but that they were all heavier than she could carry now.

[17] Another problem with HN was a bizarre edge case that occurs when you both write essays and run a forum. When you run a forum, you're assumed to see if not every conversation, at least every conversation involving you. And when you write essays, people post highly imaginative misinterpretations of them on forums. Individually these two phenomena are tedious but bearable, but the combination is disastrous. You actually have to respond to the misinterpretations, because the assumption that you're present in the conversation means that not responding to any sufficiently upvoted misinterpretation reads as a tacit admission that it's correct. But that in turn encourages more; anyone who wants to pick a fight with you senses that now is their chance.

[18] The worst thing about leaving YC was not working with Jessica anymore. We'd been working on YC almost the whole time we'd known each other, and we'd neither tried nor wanted to separate it from our personal lives, so leaving was like pulling up a deeply rooted tree.

[19] One way to get more precise about the concept of invented vs discovered is to talk about space aliens. Any sufficiently advanced alien civilization would certainly know about the Pythagorean theorem, for example. I believe, though with less certainty, that they would also know about the Lisp in McCarthy's 1960 paper.

But if so there's no reason to suppose that this is the limit of the language that might be known to them. Presumably aliens need numbers and errors and I/O too. So it seems likely there exists at least one path out of McCarthy's Lisp along which discoveredness is preserved.



Thanks to Trevor Blackwell, John Collison, Patrick Collison, Daniel Gackle, Ralph Hazell, Jessica Livingston, Robert Morris, and Harj Taggar for reading drafts of this.h&J$ h'J% h(h)h*h+h,h-uh.(hh h&h(hh
hh$h'h*h,h0}ube
qa_dataset(llama_index.finetuning.embeddings.commonEmbeddingQAFinetuneDataset)}(h}(queries}($82b9d879-8804-4878-814b-91b138137757How did the author's experience with writing short stories in their early years contribute to their development as a writer? Provide specific examples from the context information to support your answer.$5dab21b2-6dca-480a-970c-621e8c5ca89cDescribe the author's initial encounter with programming on the IBM 1401. What challenges did they face and what limitations did they encounter? Use details from the context information to support your response.$8a205039-5e1d-4dd4-82d3-28c99a5d1464In the context of the 1401 computer, what limitations did the author face in terms of input and program functionality? How did this experience shape their understanding of programming?$9406d8d6-0627-4114-8b92-a20d3c276900Compare and contrast the author's experiences with the 1401 computer and microcomputers. How did the introduction of microcomputers change the author's approach to programming and their overall experience with computers?$13b6d31e-cf5f-497a-921f-9864758ee289hHow did the author's experience with his father's TRS-80 computer influence his interest in programming?$4a78ce2d-2b5b-4085-b851-a1f066aeec99NWhat factors led the author to switch from studying philosophy to pursuing AI?$cd8cae00-8240-4d4b-b0ba-b4479f3d6edaHow did the novel "The Moon is a Harsh Mistress" and the PBS documentary featuring SHRDLU influence the author's decision to work on AI?$a02faa15-1540-41f1-b54c-b9e487703308What programming language did the author learn in order to teach themselves AI, and how did it expand their concept of a program?$7471d430-68c9-4647-aa0b-57ee4eb75f3aIn the context of the author's undergraduate thesis, what was the significance of reverse-engineering SHRDLU? How did the author feel about working on this program?$a661f94d-ac91-400a-9e64-04e4ceda038cHow did the author's perception of artificial intelligence (AI) change during their first year of grad school? What realization did they come to about the limitations of AI as practiced at the time?$c3f677d4-220b-41cf-a5d7-2c5c23599ac4How did the author's experience in grad school lead them to realize that the traditional approach to AI was flawed? Provide examples from the text to support your answer.$0a48099b-d725-4c10-a47f-7df55c32c227Explain the author's decision to focus on Lisp and write a book about Lisp hacking. How did this decision contribute to their understanding of AI?$976155d0-c560-4b97-90d5-84243b1d984aaHow did the author's experience of writing a book about Lisp hacking help them learn the subject?$c21151b8-686f-4e91-bf57-e9c8949a8a74What realization did the author have while visiting the Carnegie Institute and how did it impact their perspective on building things in computer science?$d75cecc5-4e14-4dce-8895-7ba62cf65358aHow did the author's visit to the Carnegie Institute influence their career path and aspirations?$14b72379-6e95-43e6-bec0-bd46bcd40723]What challenges did the author face in pursuing both computer science and art simultaneously?$c288adbb-a228-4d57-9fb4-855edaa7148cHow did the narrator's perception of art change after taking art classes at Harvard? Provide specific examples from the context to support your answer.$e7c2f260-df4f-4f53-9b3d-5f745b97e593Why did the narrator feel envious of their friend Robert Morris? How did this envy relate to their own situation in grad school?$b0660b20-1924-4343-a904-fb0a577b93c7In the context of the passage, why did the author decide to write their dissertation on applications of continuations instead of macros and embedded languages?$38bf7d3f-6e90-4c9b-b9fa-29ded9bb1f9bsHow did the author's plans to attend the Accademia di Belli Arti in Florence change after being accepted into RISD?$3e74f181-1b39-4541-8d58-3de04a50bbfdIn the context of the author's experience at the Accademia, explain the significance of the entrance exam for foreigners. How does it relate to the overall dynamics between Italian and foreign students at the institution?$9fd33504-6e2e-4801-8ef8-fc9f0e2e8ef3X  Analyze the author's perception of the painting department at the Accademia. How does the author describe the relationship between the faculty and the students? Discuss the role of conventions and traditional practices in the department's teaching approach.$888a8646-bdb2-4142-b28b-aa5129b28438In the context of the Accademia's painting department, describe the arrangement between the students and faculty and its impact on the learning experience.$613135e5-a42e-4a02-bc44-89c733f2ca1bCompare and contrast the process of painting still lives versus painting people, highlighting the differences in subject matter and techniques used.$178f0cf3-377c-4ffc-ae2a-f14f0c489580How does the process of painting still lives differ from painting people? Discuss the challenges and techniques involved in capturing the essence of a still life compared to a moving subject.$e8d973ac-c341-49e0-8293-de22697ee4c8Why did the author find painting still lives intriguing? Explain the role of conscious awareness in visual perception and how it influences the artist's approach to capturing details in a painting.$0512ef2f-ad6e-43bc-8fa0-7f2f90c84993How does the brain's low-level visual perception process contribute to our everyday lives? Provide examples to support your answer.$91250d92-bd16-4d0a-91b3-41d538cb6b7dIn what ways did the author's experience at the Accademia and Interleaf shape their understanding of painting and software development? Discuss the challenges they faced and the lessons they learned.$0aac7b22-ac6a-4d65-90df-e8629ae988c2How did the addition of a scripting language, inspired by Emacs, impact the software development at Interleaf? How did this decision reflect the company's approach to software creation?$932ecbe7-a3e8-4a86-81a7-ccf33d8b1cdcX  In what ways did the author's experience at Interleaf shape their understanding of the relationship between low-end and high-end software? How did their lack of knowledge in C and their unconventional work habits contribute to their experience at the company?$16f19fac-4971-49bb-be2b-62a2477900e9How did the author's experience at Interleaf influence their perspective on technology companies? Provide specific examples from the text to support your answer.$605a0cb9-7f04-4098-ab0a-164baca7f445Discuss the importance of being the "entry level" option in the business world, according to the author's observations. How does this concept relate to the idea of prestige? Use evidence from the text to support your response.$bfb898b8-f228-46fc-be76-22729981acebHow did the author's experience at Viaweb and Y Combinator influence their perspective on the importance of being the "entry level" option? Provide examples from the text to support your answer.$3ea5e159-c56f-4be1-9035-976eebe5306fX  Compare and contrast the author's experiences at the Accademia and the painting department at RISD. How did these experiences shape their understanding of art school and the expectations for painting students? Use specific details from the text to support your response.$9b395795-645a-4494-b1b9-6f66562b8182In the context of the passage, what is the significance of having a signature style in painting? How does it relate to the value and recognition of an artist's work?$ac730147-8875-4abe-a6c3-889e06354716How does the author's experience at RISD differ from the typical painting student's experience? Discuss the author's perspective on learning to paint and their decision to drop out of art school.$4be97945-fdb8-4f28-9c9f-f99cd5f71dccIn what ways did the author's experience at RISD differ from their high school experience in terms of their artistic abilities and style?$413e8e0c-727b-4d4c-a9e5-ce8e8a8f124avHow did the author's decision to move to New York City impact their career as an artist and their financial situation?$9b6c0aa0-42a3-4bbf-b1d0-7e3a454616e5How did the author's encounter with a famous fund manager inspire a change in their career aspirations? Discuss the thought process and decision-making behind this shift.$0fd4d6a0-d3bd-451b-884d-40f704846733X!  Explain the author's initial perception of the World Wide Web and their belief in its potential impact. How did this perception influence their decision to start a company focused on putting art galleries online? Discuss the challenges they faced and the ultimate outcome of their venture.$434bc002-8833-458d-bbb8-777f618fd0daHow did the author's initial perception of the web influence their decision to start a company? How did this decision ultimately lead to a change in their business idea?$439e353b-b6e1-4a53-b9ef-795df223ff50Describe the challenges the author faced when trying to sell their software to art galleries. How did the emergence of online stores impact their business strategy?$138d5de9-1be1-4dfc-b76d-df08f40a83ccHow did the idea of running the software on the server and controlling it through the browser revolutionize the concept of online stores?$e76d990c-4ec2-4702-a8d3-94160155ab4fzWhat challenges did the authors face in developing the web app for building online stores, and how did they overcome them?$26b942f9-4e4d-4167-9921-3fa798fbdf34zHow did the development of a web app for the store builder at Viaweb challenge traditional software development practices?$924b084e-b4ba-46a6-8c62-c62fa313f09bWhat was the significance of the seed funding received by Viaweb and how did it impact the company's progress and the founders' personal financial situations?$32978b9c-d3f0-40ac-9867-04929d40ef69cHow did the author's negative net worth impact their need for seed funding to launch their project?$fa560cbc-587c-40ad-a975-e6e1160178c6hIn what ways did the author's background in art contribute to the success of their online store builder?$ec0a1fd7-6b77-4b7a-9b79-66a931f756dbWhat were the three main parts of the software developed by the author and his team for their ecommerce business in 1996? How did each member contribute to the development of these parts?$8b30389f-7d81-4555-bbf3-ca60df20b430In the context of the document, why did the author mention that they were "almost fatally early" when they opened their online stores in January 1996? Discuss the challenges they faced and the market conditions at that time.$b79f69b0-6074-465c-b748-6f3b75d6268d{How did the team behind Viaweb differentiate themselves from their competitors in the ecommerce software market of the 90s?$cb5908c6-7a50-4cd2-8e2b-0926397abdb4kWhat were some of the challenges faced by the team while developing Viaweb, and how did they overcome them?$41859c44-ff4e-4a8f-bafe-06ed143cd9c5How did the founders of the software company initially attract users to their platform, and what did they learn from this experience?$28f896c7-1b19-4c6d-a1b1-1c9f73f13210What misconception did the author have about the importance of the absolute number of users versus the growth rate of a startup, and why is the growth rate considered the ultimate test of success?$14dbf101-28a8-4ece-a944-b21c08eafe05How did the author's perception of growth rate impact their decision-making process in running their startup? Provide examples from the text to support your answer.$41860f0f-5d35-46c5-b8cc-f016a45e6660Discuss the significance of the Yahoo acquisition for the author and their startup. How did it alleviate their concerns and change their financial situation?$c36e8cfe-447e-47a4-b53b-dbfa94f26973How did the author's perception of their Viaweb stock change after Yahoo bought the company? Explain the factors that influenced this change.$b4880bf0-78bf-4b71-bbcc-0bf8f25af56dDescribe the author's experience working at Yahoo after the acquisition of Viaweb. Discuss the factors that contributed to their decision to leave the company.$44801ed0-73d4-412a-8e8d-6b6994c42da8XHow did the author's perception of Yahoo change after they were acquired by the company?$b00fd5fa-9e4f-4521-be15-70dbb62ecc7djWhy did the author's boss at Yahoo have a long conversation with them when they announced their departure?$459ee2f7-fc07-4bfe-9c75-abf79b2e4f25How did the narrator's decision to quit their job and start a new startup reflect both ambition and uncertainty? Provide examples from the text to support your answer.$f5b74bd2-f925-4fa8-bb26-59658fd6c3b6Discuss the impact of the narrator's newfound wealth on their life and artistic pursuits. How did their financial status influence their choices and experiences? Use specific details from the text to support your response.$238a9ecc-cfbf-432a-939b-35fd1fb8545bHow did the protagonist's life change after the appearance of the doors? Discuss the impact of these doors on their daily routines and activities.$942fa1bc-5a94-4cf5-a3a7-5cf0c016b0bcExplain the protagonist's idea for a web app for making web apps. What motivated them to pursue this idea and what challenges did they face in implementing it?$af857535-6ba7-4315-bdfc-c1f51a72e6e4What were some of the services that could be run on the servers mentioned in the context information? How could these services be accessed?$19f79c7b-b00a-45db-b250-e984714692e0rWhy did the author decide to start a new company in Cambridge? What challenges did they face in recruiting a team?$19899368-a8f4-4998-b48c-737434d3d3a8What were the reasons behind the decision to change the name of the company from "application service provider" to "software as a service"? How did this name change reflect the evolving nature of the company?$ec4f864a-466c-45d1-9898-65bc303dc1b5How did the author's perspective on running a company change over time? What factors influenced their decision to shift towards building a subset of the vision as an open source project?$0b975938-1974-4420-b1e1-42e1f215b903yHow did the advent of the internet and the ability to publish essays online change the landscape for writers and readers?$290252ac-b068-4aff-b8cb-03ab68d39099What was the significance of the author's realization that anyone could publish anything on the web? How did this realization impact their own writing career?$f9bf0812-b238-4804-b88a-168dd163790aHow has the advent of online publishing changed the landscape for essay writing? Discuss the implications and opportunities it has created, as mentioned in the given context.$edac649b-57ef-4271-aad6-8bf69c1a7d5eAccording to the author, why is it encouraging to work on things that are not prestigious? Explain the relationship between working on unprestigious tasks and the potential for real discoveries, as well as the importance of having the right motives.$149e91a6-513b-4b1e-bbcd-c020cb7ab3d2In the context of the passage, what does the author suggest about the relationship between prestige and the right motives for pursuing certain types of work?$2ba660e5-b6d8-4a20-b150-7baa385af974{Based on the information provided, what motivated Jessica Livingston to compile a book of interviews with startup founders?$36c95041-22a0-4b8c-8d6c-22d559bb5d01How did Jessica Livingston's experience at the Boston investment bank influence her decision to compile a book of interviews with startup founders?$b63e38b5-89e1-443c-92a6-d786e3047cb7What were some of the suggestions made by the author regarding improvements that should be made in venture capital, based on his conversations with Jessica Livingston?$776f779d-9229-40d6-ab75-9340de726330How did the prospect of giving talks serve as a motivation for the author's essay writing process? How did this motivation lead to the idea of starting a startup?$eafcf74b-9d38-4ba5-8dd9-bdfebd59b571What factors influenced the author's decision to start their own investment firm? How did their lack of knowledge and experience in angel investing play a role in their decision-making process?$0bf668b8-5f71-44b3-872e-af147c64a2cdvHow did the founders of Y Combinator plan to support startups in their early stages, and what inspired their approach?$baa50756-d35f-4480-ae38-8c469caa762fWhy did the founders of Y Combinator choose to fund the organization with their own money instead of raising a fund, and what implications did this decision have for their returns?$636deca9-e11e-4a3f-b36a-1afe3ac6c694How did Julian's assistance in getting the company incorporated demonstrate the "magic" he brought to the startup? Explain the significance of having bylaws and stock in the context of starting a company.$e7831dd5-1a4c-4aa1-a845-b04563196f99Describe the unique approach of YC's batch model and how it was discovered by accident. Discuss the rationale behind funding a bunch of startups at once and the benefits it provided for both the investors and the founders.$a6a149ad-8db2-44e9-90bd-46fe9e6bce1a[How did the Summer Founders Program attract applicants and what was the unexpected outcome?$364cddad-53d6-4ca5-a2ba-2b33d679f11brWhat factors contributed to the success of the first batch of startups funded through the Summer Founders Program?$21a437b4-c778-4acd-9888-6c8bf949c43fnHow did the Summer Founders Program offered by YC solve one of the biggest problems faced by startup founders?$b1cc8e2b-a6fb-4ee1-bc40-9f75f6ee90f7{What advantages did YC notice as it grew in scale, particularly in terms of the startup community and customer acquisition?$574492a6-3aab-4116-96e8-f234439ce4a7mHow did the growth of YC contribute to the formation of a tight-knit community among its alumni and startups?$3ad85db2-1114-4de3-9a1c-3ce929ea5b1a_Why did the author consider Hacker News to be the biggest source of stress in their work at YC?$e3a0262c-4d79-4cb3-892e-0fa54b25104dHow did the author's role in managing Hacker News contribute to their stress levels while working at YC? How does this relate to the core of their work?$40c5501e-91ad-4969-b9be-0f1aed7ffe83In what ways did the author's work at YC differ from their previous experiences? How did the nature of their work at YC provide unique challenges and opportunities for learning?$8dc3df4a-2d2c-4615-9f2e-36e0159286c6How did the nature of work at Y Combinator differ from the author's previous experiences? What made it engaging for the author?$061ad010-0ad2-4b0d-b6ab-a403f96ee87bWhat advice did Robert Morris offer to the author regarding their involvement with Y Combinator? How did the author initially interpret this advice and how did their understanding change over time?$460b90b8-36a1-4fa9-86ca-000933dedbbapWhat was the significance of Rtm's advice to the author in relation to their involvement with Y Combinator (YC)?$b26bdcf7-1263-492d-9116-92f982eee9f6How did the author's personal circumstances, specifically their mother's health condition, influence their decision to hand over YC to someone else?$8985ff93-e410-488d-af68-a77c31efc321OHow did the founders of YC plan to ensure the long-term success of the company?$1035811c-4cd0-42c6-8946-32ad9bdf204cIWhat was the author's motivation for taking up painting after leaving YC?$756ef80d-8016-4928-a1e4-f3e35e596131mHow did the author's decision to focus on painting after leaving YC impact their productivity and engagement?$318f8ecc-9002-4ab3-a619-8fa34361cfa9What is the significance of Lisp as a programming language and how did John McCarthy discover its potential for computer programming?$9e5993cf-f6c8-4be8-a435-dacf797b8457How did Lisp originate and what was its original purpose? Provide a brief explanation of its core concept and its transformation into a programming language.$ebae519c-e205-48c7-8d5c-079d6a4a0c62X  Discuss the significance of McCarthy's axiomatic approach in the development of Lisp as a programming language. How did the advancement in computer technology enable the possibility of defining a complete programming language based on McCarthy's original Lisp?$d9c534b5-a4c7-4ae6-80bc-9ff02dd96476uHow did McCarthy test his interpreter for Lisp programs, and what limitation did he encounter in the testing process?$e685345d-9c35-4370-b528-186e35d249aaCan you explain the approach the author took to develop a new Lisp language called Bel, and what challenges did they face during the development process?$56f89691-464c-49c5-a09c-1de805eca0a7How did the author's intense focus on developing Bel impact their ability to write essays? Explain the challenges they faced and the consequences of their decision.$f631207e-fa90-46ea-a69a-4ad2bfc92b1dDescribe the author's experience working on Bel and how it affected their perception of life. Provide an example of a specific moment that stood out to them and explain its significance.$f3ac2262-e787-421d-946d-3b8487840465In the context of the author's experience with computers, what is the significance of skipping the step of time-sharing machines with interactive OSes? How did this impact their perception of microcomputers?$959a7d8f-9d48-4b83-894d-1a4b3f2f721dHow did the author's move to England in 2016 influence their writing process for the book "Bel"? Discuss the connection between the author's location and the content of their writing.$10e2892a-76e5-4510-a6b0-7daccc53e715In the context of the evolution of computers, what was the author's experience and how did it shape their perception of microcomputers?$0791918d-d836-4d0d-a449-1ad2e3ff04a3nHow did the author's living location in Florence contribute to their understanding and experience of the city?$0cbf1a5b-4d20-4b3f-8335-7d7a961e76a2In the context of the exponential growth in the power of commodity processors, explain how this affected high-end, special-purpose hardware and software companies. Provide examples to support your answer.$a37f47c8-e036-482e-afce-448572254e9bBased on the information provided, discuss the significance of launching privately before launching publicly for an online store builder. How does this relate to the need for an initial set of users and the appearance of the stores?$d4703fb3-de11-42ae-86ce-1d998ecc8253How does the author's experience with reading comments on their essay about Lisp reflect the challenges of expressing personal opinions online? Provide examples from the text to support your answer.$9babbdcd-195c-471b-bdc5-df23d76d22a2In what ways does the author highlight the impact of customs and traditions on various fields, such as publishing essays and venture capital? Use specific examples from the text to explain the author's perspective.$471f809e-f2fa-4d27-b3c0-75a023aa4d6dmHow did the choice of color for the Y Combinator logo reflect the mindset of venture capitalists at the time?$cd379762-83d6-4891-9cc0-0ff5dee92d0e}How did Y Combinator challenge the notion of a fixed number of startups in the market and what was their purpose in doing so?$4a6d6474-c61e-4379-bf35-01a8753f8772In the context of Y Combinator (YC), what is the purpose of the organization and how does it challenge the notion of "deal flow"?$b17cc06e-6167-43c7-82dc-7a910363de70How does the combination of running a forum and writing essays on Hacker News (HN) create a problematic situation for the author? Explain the consequences of not responding to misinterpretations on the forum.ucorpus}(hhhj  j  j7  j2  jU  jP  js  jn  j  j  j  j  j  j  j  j  j	  j  j'  j"  jE  j@  jc  j^  j  j|  j  j  j  j  j  j  j  j  j  j  j5  j0  jS  jN  jq  jl  j  j  j  j  j  j  j  j  j  j  j%  j   jC  j>  ja  j\  j  jz  j  j  j  j  j  j  j  j  j  j  j3  j.  jQ  jL  jo  jj  j  j  j  j  j  j  j  j  j  j   j#  j  jA  j<  j_  jZ  j}  jx  j  j  j  j  j  j  j  j  j  j  j1  j,  jO  jJ  jm  jh  j  j  j  u
relevant_docs}(j  ]haj  ]haj  ]haj  ]haj  ]j  aj  ]j  aj  ]j2  aj  ]j2  aj  ]jP  aj  ]jP  aj  ]jn  aj  ]jn  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j"  aj  ]j"  aj  ]j@  aj  ]j@  aj  ]j^  aj  ]j^  aj  ]j|  aj  ]j|  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j0  aj  ]j0  aj  ]jN  aj  ]jN  aj  ]jl  aj  ]jl  aj	  ]j  aj  ]j  aj
  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j   aj  ]j   aj!  ]j>  aj#  ]j>  aj%  ]j\  aj'  ]j\  aj)  ]jz  aj+  ]jz  aj-  ]j  aj/  ]j  aj1  ]j  aj3  ]j  aj5  ]j  aj7  ]j  aj9  ]j  aj;  ]j  aj=  ]j  aj?  ]j  ajA  ]j.  ajC  ]j.  ajE  ]jL  ajG  ]jL  ajI  ]jj  ajK  ]jj  ajM  ]j  ajO  ]j  ajQ  ]j  ajS  ]j  ajU  ]j  ajW  ]j  ajY  ]j  aj[  ]j  aj]  ]j   aj_  ]j   aja  ]j  ajc  ]j  aje  ]j<  ajg  ]j<  aji  ]jZ  ajk  ]jZ  ajm  ]jx  ajo  ]jx  ajq  ]j  ajs  ]j  aju  ]j  ajw  ]j  ajy  ]j  aj{  ]j  aj}  ]j  aj  ]j  aj  ]j  aj  ]j  aj  ]j,  aj  ]j,  aj  ]jJ  aj  ]jJ  aj  ]jh  aj  ]jh  aj  ]j  aj  ]j  aumodeh$uh.(j  j  j  h0}ubu.