# flake8: noqa
import re

DEFAULT_PERTURBATIONS = [
    "uppercase",
    "lowercase",
    "titlecase",
    "add_punctuation",
    "strip_punctuation",
    "add_typo",
    "american_to_british",
    "british_to_american",
    "add_context",
    "add_contractions",
    "swap_entities",
    "replace_to_male_pronouns",
    "replace_to_female_pronouns",
    "replace_to_neutral_pronouns",
    "number_to_word",
    "add_ocr_typo",
    "add_abbreviation",
    "add_speech_to_text_typo",
    "add_slangs",
    "dyslexia_word_swap",
    "multiple_perturbations",
    "adjective_synonym_swap",
    "adjective_antonym_swap",
    "strip_all_punctuation",
]

PERTURB_CLASS_MAP = {
    "uppercase": 'UpperCase',
    "lowercase": 'LowerCase',
    "titlecase": 'TitleCase',
    "add_punctuation": 'AddPunctuation',
    "strip_punctuation": 'StripPunctuation',
    "add_typo": 'AddTypo',
    "american_to_british": 'ConvertAccent',
    "british_to_american": 'ConvertAccent',
    "add_context": 'AddContext',
    "add_contractions": 'AddContraction',
    "swap_entities": 'SwapEntities',
    "replace_to_male_pronouns": "GenderPronounBias",
    "replace_to_female_pronouns": "GenderPronounBias",
    "replace_to_neutral_pronouns": "GenderPronounBias",
    "number_to_word": "NumberToWord",
    "add_ocr_typo": "AddOcrTypo",
    "add_abbreviation": "AbbreviationInsertion",
    "add_speech_to_text_typo": "AddSpeechToTextTypo",
    "add_slangs": "AddSlangifyTypo",
    "dyslexia_word_swap": "DyslexiaWordSwap",
    "multiple_perturbations": "MultiplePerturbations",
    "adjective_synonym_swap": "AdjectiveSynonymSwap",
    "adjective_antonym_swap": "AdjectiveAntonymSwap",
    "strip_all_punctuation" : "StripAllPunctuation",
}

# @formatter:off
A2B_DICT = {"accessorize": "accessorise", "accessorized": "accessorised", "accessorizes": "accessorises",
            "accessorizing": "accessorising", "acclimatization": "acclimatisation", "acclimatize": "acclimatise",
            "acclimatized": "acclimatised", "acclimatizes": "acclimatises", "acclimatizing": "acclimatising",
            "accouterments": "accoutrements", "eon": "aeon", "eons": "aeons", "aerogram": "aerogramme",
            "aerograms": "aerogrammes", "airplane": "aeroplane", "airplanes": "aeroplanes", "esthete": "aesthete",
            "esthetes": "aesthetes", "esthetic": "aesthetic", "esthetically": "aesthetically",
            "esthetics": "aesthetics", "etiology": "aetiology", "aging": "ageing", "aggrandizement": "aggrandisement",
            "agonize": "agonise", "agonized": "agonised", "agonizes": "agonises", "agonizing": "agonising",
            "agonizingly": "agonisingly", "almanac": "almanack", "almanacs": "almanacks", "aluminum": "aluminium",
            "amortizable": "amortisable", "amortization": "amortisation", "amortizations": "amortisations",
            "amortize": "amortise", "amortized": "amortised", "amortizes": "amortises", "amortizing": "amortising",
            "amphitheater": "amphitheatre", "amphitheaters": "amphitheatres", "anemia": "anaemia", "anemic": "anaemic",
            "anesthesia": "anaesthesia", "anesthetic": "anaesthetic", "anesthetics": "anaesthetics",
            "anesthetize": "anaesthetize", "anesthetized": "anaesthetized", "anesthetizes": "anaesthetizes",
            "anesthetizing": "anaesthetizing", "anesthetist": "anaesthetist", "anesthetists": "anaesthetists",
            "analog": "analogue", "analogs": "analogues", "analyze": "analyse", "analyzed": "analysed",
            "analyzes": "analyses", "analyzing": "analysing", "anglicize": "anglicise", "anglicized": "anglicised",
            "anglicizes": "anglicises", "anglicizing": "anglicising", "annualized": "annualised",
            "antagonize": "antagonise", "antagonized": "antagonised", "antagonizes": "antagonises",
            "antagonizing": "antagonising", "apologize": "apologise", "apologized": "apologised",
            "apologizes": "apologises", "apologizing": "apologising", "appall": "appal", "appalls": "appals",
            "appetizer": "appetiser", "appetizers": "appetisers", "appetizing": "appetising",
            "appetizingly": "appetisingly", "arbor": "arbour", "arbors": "arbours", "archeological": "archaeological",
            "archeologically": "archaeologically", "archeologist": "archaeologist", "archeologists": "archaeologists",
            "archeology": "archaeology", "ardor": "ardour", "armor": "armour", "armored": "armoured",
            "armorer": "armourer", "armorers": "armourers", "armories": "armouries", "armory": "armoury",
            "artifact": "artefact", "artifacts": "artefacts", "authorize": "authorise", "authorized": "authorised",
            "authorizes": "authorises", "authorizing": "authorising", "ax": "axe", "backpedaled": "backpedalled",
            "backpedaling": "backpedalling", "banister": "bannister", "banisters": "bannisters", "baptize": "baptise",
            "baptized": "baptised", "baptizes": "baptises", "baptizing": "baptising", "bastardize": "bastardise",
            "bastardized": "bastardised", "bastardizes": "bastardises", "bastardizing": "bastardising",
            "battleax": "battleaxe", "balk": "baulk", "balked": "baulked", "balking": "baulking", "balks": "baulks",
            "bedeviled": "bedevilled", "bedeviling": "bedevilling", "behavior": "behaviour",
            "behavioral": "behavioural", "behaviorism": "behaviourism", "behaviorist": "behaviourist",
            "behaviorists": "behaviourists", "behaviors": "behaviours", "behoove": "behove", "behooved": "behoved",
            "behooves": "behoves", "bejeweled": "bejewelled", "belabor": "belabour", "belabored": "belaboured",
            "belaboring": "belabouring", "belabors": "belabours", "beveled": "bevelled", "bevies": "bevvies",
            "bevy": "bevvy", "biased": "biassed", "biasing": "biassing", "binging": "bingeing",
            "bougainvillea": "bougainvillaea", "bougainvilleas": "bougainvillaeas", "bowdlerize": "bowdlerise",
            "bowdlerized": "bowdlerised", "bowdlerizes": "bowdlerises", "bowdlerizing": "bowdlerising",
            "breathalyze": "breathalyse", "breathalyzed": "breathalysed", "breathalyzer": "breathalyser",
            "breathalyzers": "breathalysers", "breathalyzes": "breathalyses", "breathalyzing": "breathalysing",
            "brutalize": "brutalise", "brutalized": "brutalised", "brutalizes": "brutalises",
            "brutalizing": "brutalising", "busses": "buses", "bussing": "busing", "cesarean": "caesarean",
            "cesareans": "caesareans", "caliber": "calibre", "calibers": "calibres", "caliper": "calliper",
            "calipers": "callipers", "calisthenics": "callisthenics", "canalize": "canalise", "canalized": "canalised",
            "canalizes": "canalises", "canalizing": "canalising", "cancelation": "cancellation",
            "cancelations": "cancellations", "canceled": "cancelled", "canceling": "cancelling", "candor": "candour",
            "cannibalize": "cannibalise", "cannibalized": "cannibalised", "cannibalizes": "cannibalises",
            "cannibalizing": "cannibalising", "canonize": "canonise", "canonized": "canonised",
            "canonizes": "canonises", "canonizing": "canonising", "capitalize": "capitalise",
            "capitalized": "capitalised", "capitalizes": "capitalises", "capitalizing": "capitalising",
            "caramelize": "caramelise", "caramelized": "caramelised", "caramelizes": "caramelises",
            "caramelizing": "caramelising", "carbonize": "carbonise", "carbonized": "carbonised",
            "carbonizes": "carbonises", "carbonizing": "carbonising", "caroled": "carolled", "caroling": "carolling",
            "catalog": "catalogue", "cataloged": "catalogued", "catalogs": "catalogues", "cataloging": "cataloguing",
            "catalyze": "catalyse", "catalyzed": "catalysed", "catalyzes": "catalyses", "catalyzing": "catalysing",
            "categorize": "categorise", "categorized": "categorised", "categorizes": "categorises",
            "categorizing": "categorising", "cauterize": "cauterise", "cauterized": "cauterised",
            "cauterizes": "cauterises", "cauterizing": "cauterising", "caviled": "cavilled", "caviling": "cavilling",
            "centigram": "centigramme", "centigrams": "centigrammes", "centiliter": "centilitre",
            "centiliters": "centilitres", "centimeter": "centimetre", "centimeters": "centimetres",
            "centralize": "centralise", "centralized": "centralised", "centralizes": "centralises",
            "centralizing": "centralising", "center": "centre", "centered": "centred", "centerfold": "centrefold",
            "centerfolds": "centrefolds", "centerpiece": "centrepiece", "centerpieces": "centrepieces",
            "centers": "centres", "channeled": "channelled", "channeling": "channelling",
            "characterize": "characterise", "characterized": "characterised", "characterizes": "characterises",
            "characterizing": "characterising", "checkbook": "chequebook", "checkbooks": "chequebooks",
            "checkered": "chequered", "chili": "chilli", "chimera": "chimaera", "chimeras": "chimaeras",
            "chiseled": "chiselled", "chiseling": "chiselling", "circularize": "circularise",
            "circularized": "circularised", "circularizes": "circularises", "circularizing": "circularising",
            "civilize": "civilise", "civilized": "civilised", "civilizes": "civilises", "civilizing": "civilising",
            "clamor": "clamour", "clamored": "clamoured", "clamoring": "clamouring", "clamors": "clamours",
            "clangor": "clangour", "clarinetist": "clarinettist", "clarinetists": "clarinettists",
            "collectivize": "collectivise", "collectivized": "collectivised", "collectivizes": "collectivises",
            "collectivizing": "collectivising", "colonization": "colonisation", "colonize": "colonise",
            "colonized": "colonised", "colonizer": "coloniser", "colonizers": "colonisers", "colonizes": "colonises",
            "colonizing": "colonising", "color": "colour", "colorant": "colourant", "colorants": "colourants",
            "colored": "coloured", "coloreds": "coloureds", "colorful": "colourful", "colorfully": "colourfully",
            "coloring": "colouring", "colorize": "colourize", "colorized": "colourized", "colorizes": "colourizes",
            "colorizing": "colourizing", "colorless": "colourless", "colors": "colours",
            "commercialize": "commercialise", "commercialized": "commercialised", "commercializes": "commercialises",
            "commercializing": "commercialising", "compartmentalize": "compartmentalise",
            "compartmentalized": "compartmentalised", "compartmentalizes": "compartmentalises",
            "compartmentalizing": "compartmentalising", "computerize": "computerise", "computerized": "computerised",
            "computerizes": "computerises", "computerizing": "computerising", "conceptualize": "conceptualise",
            "conceptualized": "conceptualised", "conceptualizes": "conceptualises",
            "conceptualizing": "conceptualising", "connection": "connexion", "connections": "connexions",
            "contextualize": "contextualise", "contextualized": "contextualised", "contextualizes": "contextualises",
            "contextualizing": "contextualising", "cozier": "cosier", "cozies": "cosies", "coziest": "cosiest",
            "cozily": "cosily", "coziness": "cosiness", "cozy": "cosy", "councilor": "councillor",
            "councilors": "councillors", "counseled": "counselled", "counseling": "counselling",
            "counselor": "counsellor", "counselors": "counsellors", "crenelated": "crenellated",
            "criminalize": "criminalise", "criminalized": "criminalised", "criminalizes": "criminalises",
            "criminalizing": "criminalising", "criticize": "criticise", "criticized": "criticised",
            "criticizes": "criticises", "criticizing": "criticising", "crueler": "crueller", "cruelest": "cruellest",
            "crystallization": "crystallisation", "crystallize": "crystallise", "crystallized": "crystallised",
            "crystallizes": "crystallises", "crystallizing": "crystallising", "cudgeled": "cudgelled",
            "cudgeling": "cudgelling", "customize": "customise", "customized": "customised", "customizes": "customises",
            "customizing": "customising", "decentralization": "decentralisation", "decentralize": "decentralise",
            "decentralized": "decentralised", "decentralizes": "decentralises", "decentralizing": "decentralising",
            "decriminalization": "decriminalisation", "decriminalize": "decriminalise",
            "decriminalized": "decriminalised", "decriminalizes": "decriminalises",
            "decriminalizing": "decriminalising", "defense": "defence", "defenseless": "defenceless",
            "defenses": "defences", "dehumanization": "dehumanisation", "dehumanize": "dehumanise",
            "dehumanized": "dehumanised", "dehumanizes": "dehumanises", "dehumanizing": "dehumanising",
            "demeanor": "demeanour", "demilitarization": "demilitarisation", "demilitarize": "demilitarise",
            "demilitarized": "demilitarised", "demilitarizes": "demilitarises", "demilitarizing": "demilitarising",
            "demobilization": "demobilisation", "demobilize": "demobilise", "demobilized": "demobilised",
            "demobilizes": "demobilises", "demobilizing": "demobilising", "democratization": "democratisation",
            "democratize": "democratise", "democratized": "democratised", "democratizes": "democratises",
            "democratizing": "democratising", "demonize": "demonise", "demonized": "demonised",
            "demonizes": "demonises", "demonizing": "demonising", "demoralization": "demoralisation",
            "demoralize": "demoralise", "demoralized": "demoralised", "demoralizes": "demoralises",
            "demoralizing": "demoralising", "denationalization": "denationalisation", "denationalize": "denationalise",
            "denationalized": "denationalised", "denationalizes": "denationalises",
            "denationalizing": "denationalising", "deodorize": "deodorise", "deodorized": "deodorised",
            "deodorizes": "deodorises", "deodorizing": "deodorising", "depersonalize": "depersonalise",
            "depersonalized": "depersonalised", "depersonalizes": "depersonalises",
            "depersonalizing": "depersonalising", "deputize": "deputise", "deputized": "deputised",
            "deputizes": "deputises", "deputizing": "deputising", "desensitization": "desensitisation",
            "desensitize": "desensitise", "desensitized": "desensitised", "desensitizes": "desensitises",
            "desensitizing": "desensitising", "destabilization": "destabilisation", "destabilize": "destabilise",
            "destabilized": "destabilised", "destabilizes": "destabilises", "destabilizing": "destabilising",
            "dialed": "dialled", "dialing": "dialling", "dialog": "dialogue", "dialogs": "dialogues",
            "diarrhea": "diarrhoea", "digitize": "digitise", "digitized": "digitised", "digitizes": "digitises",
            "digitizing": "digitising", "disk": "disc", "discolor": "discolour", "discolored": "discoloured",
            "discoloring": "discolouring", "discolors": "discolours", "disks": "discs", "disemboweled": "disembowelled",
            "disemboweling": "disembowelling", "disfavor": "disfavour", "disheveled": "dishevelled",
            "dishonor": "dishonour", "dishonorable": "dishonourable", "dishonorably": "dishonourably",
            "dishonored": "dishonoured", "dishonoring": "dishonouring", "dishonors": "dishonours",
            "disorganization": "disorganisation", "disorganized": "disorganised", "distill": "distil",
            "distills": "distils", "dramatization": "dramatisation", "dramatizations": "dramatisations",
            "dramatize": "dramatise", "dramatized": "dramatised", "dramatizes": "dramatises",
            "dramatizing": "dramatising", "draft": "draught", "draftboard": "draughtboard",
            "draftboards": "draughtboards", "draftier": "draughtier", "draftiest": "draughtiest", "drafts": "draughts",
            "draftsman": "draughtsman", "draftsmanship": "draughtsmanship", "draftsmen": "draughtsmen",
            "draftswoman": "draughtswoman", "draftswomen": "draughtswomen", "drafty": "draughty",
            "driveled": "drivelled", "driveling": "drivelling", "dueled": "duelled", "dueling": "duelling",
            "economize": "economise", "economized": "economised", "economizes": "economises",
            "economizing": "economising", "edema": "edoema", "editorialize": "editorialise",
            "editorialized": "editorialised", "editorializes": "editorialises", "editorializing": "editorialising",
            "empathize": "empathise", "empathized": "empathised", "empathizes": "empathises",
            "empathizing": "empathising", "emphasize": "emphasise", "emphasized": "emphasised",
            "emphasizes": "emphasises", "emphasizing": "emphasising", "enameled": "enamelled",
            "enameling": "enamelling", "enamored": "enamoured", "encyclopedia": "encyclopaedia",
            "encyclopedias": "encyclopaedias", "encyclopedic": "encyclopaedic", "endeavor": "endeavour",
            "endeavored": "endeavoured", "endeavoring": "endeavouring", "endeavors": "endeavours",
            "energize": "energise", "energized": "energised", "energizes": "energises", "energizing": "energising",
            "enroll": "enrol", "enrolls": "enrols", "enthrall": "enthral", "enthralls": "enthrals",
            "epaulet": "epaulette", "epaulets": "epaulettes", "epicenter": "epicentre", "epicenters": "epicentres",
            "epilog": "epilogue", "epilogs": "epilogues", "epitomize": "epitomise", "epitomized": "epitomised",
            "epitomizes": "epitomises", "epitomizing": "epitomising", "equalization": "equalisation",
            "equalize": "equalise", "equalized": "equalised", "equalizer": "equaliser", "equalizers": "equalisers",
            "equalizes": "equalises", "equalizing": "equalising", "eulogize": "eulogise", "eulogized": "eulogised",
            "eulogizes": "eulogises", "eulogizing": "eulogising", "evangelize": "evangelise",
            "evangelized": "evangelised", "evangelizes": "evangelises", "evangelizing": "evangelising",
            "exorcize": "exorcise", "exorcized": "exorcised", "exorcizes": "exorcises", "exorcizing": "exorcising",
            "extemporization": "extemporisation", "extemporize": "extemporise", "extemporized": "extemporised",
            "extemporizes": "extemporises", "extemporizing": "extemporising", "externalization": "externalisation",
            "externalizations": "externalisations", "externalize": "externalise", "externalized": "externalised",
            "externalizes": "externalises", "externalizing": "externalising", "factorize": "factorise",
            "factorized": "factorised", "factorizes": "factorises", "factorizing": "factorising", "fecal": "faecal",
            "feces": "faeces", "familiarization": "familiarisation", "familiarize": "familiarise",
            "familiarized": "familiarised", "familiarizes": "familiarises", "familiarizing": "familiarising",
            "fantasize": "fantasise", "fantasized": "fantasised", "fantasizes": "fantasises",
            "fantasizing": "fantasising", "favor": "favour", "favorable": "favourable", "favorably": "favourably",
            "favored": "favoured", "favoring": "favouring", "favorite": "favourite", "favorites": "favourites",
            "favoritism": "favouritism", "favors": "favours", "feminize": "feminise", "feminized": "feminised",
            "feminizes": "feminises", "feminizing": "feminising", "fertilization": "fertilisation",
            "fertilize": "fertilise", "fertilized": "fertilised", "fertilizer": "fertiliser",
            "fertilizers": "fertilisers", "fertilizes": "fertilises", "fertilizing": "fertilising", "fervor": "fervour",
            "fiber": "fibre", "fiberglass": "fibreglass", "fibers": "fibres", "fictionalization": "fictionalisation",
            "fictionalizations": "fictionalisations", "fictionalize": "fictionalise", "fictionalized": "fictionalised",
            "fictionalizes": "fictionalises", "fictionalizing": "fictionalising", "filet": "fillet",
            "fileted": "filleted", "fileting": "filleting", "filets": "fillets", "finalization": "finalisation",
            "finalize": "finalise", "finalized": "finalised", "finalizes": "finalises", "finalizing": "finalising",
            "flutist": "flautist", "flutists": "flautists", "flavor": "flavour", "flavored": "flavoured",
            "flavoring": "flavouring", "flavorings": "flavourings", "flavorless": "flavourless", "flavors": "flavours",
            "flavorsome": "flavoursome", "fetal": "foetal", "fetid": "foetid", "fetus": "foetus", "fetuses": "foetuses",
            "formalization": "formalisation", "formalize": "formalise", "formalized": "formalised",
            "formalizes": "formalises", "formalizing": "formalising", "fossilization": "fossilisation",
            "fossilize": "fossilise", "fossilized": "fossilised", "fossilizes": "fossilises",
            "fossilizing": "fossilising", "fraternization": "fraternisation", "fraternize": "fraternise",
            "fraternized": "fraternised", "fraternizes": "fraternises", "fraternizing": "fraternising",
            "fulfill": "fulfil", "fulfillment": "fulfilment", "fulfills": "fulfils", "funneled": "funnelled",
            "funneling": "funnelling", "galvanize": "galvanise", "galvanized": "galvanised", "galvanizes": "galvanises",
            "galvanizing": "galvanising", "gamboled": "gambolled", "gamboling": "gambolling", "gasses": "gases",
            "gage": "gauge", "gaged": "gauged", "gages": "gauges", "gaging": "gauging",
            "generalization": "generalisation", "generalizations": "generalisations", "generalize": "generalise",
            "generalized": "generalised", "generalizes": "generalises", "generalizing": "generalising",
            "ghettoize": "ghettoise", "ghettoized": "ghettoised", "ghettoizes": "ghettoises",
            "ghettoizing": "ghettoising", "gypsies": "gipsies", "glamorize": "glamorise", "glamorized": "glamorised",
            "glamorizes": "glamorises", "glamorizing": "glamorising", "glamor": "glamour",
            "globalization": "globalisation", "globalize": "globalise", "globalized": "globalised",
            "globalizes": "globalises", "globalizing": "globalising", "gluing": "glueing", "goiter": "goitre",
            "goiters": "goitres", "gonorrhea": "gonorrhoea", "gram": "gramme", "grams": "grammes",
            "graveled": "gravelled", "gray": "grey", "grayed": "greyed", "graying": "greying", "grayish": "greyish",
            "grayness": "greyness", "grays": "greys", "groveled": "grovelled", "groveling": "grovelling",
            "groin": "groyne", "groins": "groynes", "grueling": "gruelling", "gruelingly": "gruellingly",
            "griffin": "gryphon", "griffins": "gryphons", "gynecological": "gynaecological",
            "gynecologist": "gynaecologist", "gynecologists": "gynaecologists", "gynecology": "gynaecology",
            "hematological": "haematological", "hematologist": "haematologist", "hematologists": "haematologists",
            "hematology": "haematology", "hemoglobin": "haemoglobin", "hemophilia": "haemophilia",
            "hemophiliac": "haemophiliac", "hemophiliacs": "haemophiliacs", "hemorrhage": "haemorrhage",
            "hemorrhaged": "haemorrhaged", "hemorrhages": "haemorrhages", "hemorrhaging": "haemorrhaging",
            "hemorrhoids": "haemorrhoids", "harbor": "harbour", "harbored": "harboured", "harboring": "harbouring",
            "harbors": "harbours", "harmonization": "harmonisation", "harmonize": "harmonise",
            "harmonized": "harmonised", "harmonizes": "harmonises", "harmonizing": "harmonising",
            "homeopath": "homoeopath", "homeopathic": "homoeopathic", "homeopaths": "homoeopaths",
            "homeopathy": "homoeopathy", "homogenize": "homogenise", "homogenized": "homogenised",
            "homogenizes": "homogenises", "homogenizing": "homogenising", "honor": "honour", "honorable": "honourable",
            "honorably": "honourably", "honored": "honoured", "honoring": "honouring", "honors": "honours",
            "hospitalization": "hospitalisation", "hospitalize": "hospitalise", "hospitalized": "hospitalised",
            "hospitalizes": "hospitalises", "hospitalizing": "hospitalising", "humanize": "humanise",
            "humanized": "humanised", "humanizes": "humanises", "humanizing": "humanising", "humor": "humour",
            "humored": "humoured", "humoring": "humouring", "humorless": "humourless", "humors": "humours",
            "hybridize": "hybridise", "hybridized": "hybridised", "hybridizes": "hybridises",
            "hybridizing": "hybridising", "hypnotize": "hypnotise", "hypnotized": "hypnotised",
            "hypnotizes": "hypnotises", "hypnotizing": "hypnotising", "hypothesize": "hypothesise",
            "hypothesized": "hypothesised", "hypothesizes": "hypothesises", "hypothesizing": "hypothesising",
            "idealization": "idealisation", "idealize": "idealise", "idealized": "idealised", "idealizes": "idealises",
            "idealizing": "idealising", "idolize": "idolise", "idolized": "idolised", "idolizes": "idolises",
            "idolizing": "idolising", "immobilization": "immobilisation", "immobilize": "immobilise",
            "immobilized": "immobilised", "immobilizer": "immobiliser", "immobilizers": "immobilisers",
            "immobilizes": "immobilises", "immobilizing": "immobilising", "immortalize": "immortalise",
            "immortalized": "immortalised", "immortalizes": "immortalises", "immortalizing": "immortalising",
            "immunization": "immunisation", "immunize": "immunise", "immunized": "immunised", "immunizes": "immunises",
            "immunizing": "immunising", "impaneled": "impanelled", "impaneling": "impanelling",
            "imperiled": "imperilled", "imperiling": "imperilling", "individualize": "individualise",
            "individualized": "individualised", "individualizes": "individualises",
            "individualizing": "individualising", "industrialize": "industrialise", "industrialized": "industrialised",
            "industrializes": "industrialises", "industrializing": "industrialising", "inflection": "inflexion",
            "inflections": "inflexions", "initialize": "initialise", "initialized": "initialised",
            "initializes": "initialises", "initializing": "initialising", "initialed": "initialled",
            "initialing": "initialling", "install": "instal", "installment": "instalment",
            "installments": "instalments", "installs": "instals", "instill": "instil", "instills": "instils",
            "institutionalization": "institutionalisation", "institutionalize": "institutionalise",
            "institutionalized": "institutionalised", "institutionalizes": "institutionalises",
            "institutionalizing": "institutionalising", "intellectualize": "intellectualise",
            "intellectualized": "intellectualised", "intellectualizes": "intellectualises",
            "intellectualizing": "intellectualising", "internalization": "internalisation",
            "internalize": "internalise", "internalized": "internalised", "internalizes": "internalises",
            "internalizing": "internalising", "internationalization": "internationalisation",
            "internationalize": "internationalise", "internationalized": "internationalised",
            "internationalizes": "internationalises", "internationalizing": "internationalising",
            "ionization": "ionisation", "ionize": "ionise", "ionized": "ionised", "ionizer": "ioniser",
            "ionizers": "ionisers", "ionizes": "ionises", "ionizing": "ionising", "italicize": "italicise",
            "italicized": "italicised", "italicizes": "italicises", "italicizing": "italicising", "itemize": "itemise",
            "itemized": "itemised", "itemizes": "itemises", "itemizing": "itemising", "jeopardize": "jeopardise",
            "jeopardized": "jeopardised", "jeopardizes": "jeopardises", "jeopardizing": "jeopardising",
            "jeweled": "jewelled", "jeweler": "jeweller", "jewelers": "jewellers", "jewelry": "jewellery",
            "judgment": "judgement", "kilogram": "kilogramme", "kilograms": "kilogrammes", "kilometer": "kilometre",
            "kilometers": "kilometres", "labeled": "labelled", "labeling": "labelling", "labor": "labour",
            "labored": "laboured", "laborer": "labourer", "laborers": "labourers", "laboring": "labouring",
            "labors": "labours", "lackluster": "lacklustre", "legalization": "legalisation", "legalize": "legalise",
            "legalized": "legalised", "legalizes": "legalises", "legalizing": "legalising", "legitimize": "legitimise",
            "legitimized": "legitimised", "legitimizes": "legitimises", "legitimizing": "legitimising",
            "leukemia": "leukaemia", "leveled": "levelled", "leveler": "leveller", "levelers": "levellers",
            "leveling": "levelling", "libeled": "libelled", "libeling": "libelling", "libelous": "libellous",
            "liberalization": "liberalisation", "liberalize": "liberalise", "liberalized": "liberalised",
            "liberalizes": "liberalises", "liberalizing": "liberalising", "license": "licence", "licensed": "licenced",
            "licenses": "licences", "licensing": "licencing", "likable": "likeable", "lionization": "lionisation",
            "lionize": "lionise", "lionized": "lionised", "lionizes": "lionises", "lionizing": "lionising",
            "liquidize": "liquidise", "liquidized": "liquidised", "liquidizer": "liquidiser",
            "liquidizers": "liquidisers", "liquidizes": "liquidises", "liquidizing": "liquidising", "liter": "litre",
            "liters": "litres", "localize": "localise", "localized": "localised", "localizes": "localises",
            "localizing": "localising", "louver": "louvre", "louvered": "louvred", "louvers": "louvres",
            "luster": "lustre", "magnetize": "magnetise", "magnetized": "magnetised", "magnetizes": "magnetises",
            "magnetizing": "magnetising", "maneuverability": "manoeuvrability", "maneuverable": "manoeuvrable",
            "maneuver": "manoeuvre", "maneuvered": "manoeuvred", "maneuvers": "manoeuvres",
            "maneuvering": "manoeuvring", "maneuverings": "manoeuvrings", "marginalization": "marginalisation",
            "marginalize": "marginalise", "marginalized": "marginalised", "marginalizes": "marginalises",
            "marginalizing": "marginalising", "marshaled": "marshalled", "marshaling": "marshalling",
            "marveled": "marvelled", "marveling": "marvelling", "marvelous": "marvellous",
            "marvelously": "marvellously", "materialization": "materialisation", "materialize": "materialise",
            "materialized": "materialised", "materializes": "materialises", "materializing": "materialising",
            "maximization": "maximisation", "maximize": "maximise", "maximized": "maximised", "maximizes": "maximises",
            "maximizing": "maximising", "meager": "meagre", "mechanization": "mechanisation", "mechanize": "mechanise",
            "mechanized": "mechanised", "mechanizes": "mechanises", "mechanizing": "mechanising",
            "medieval": "mediaeval", "memorialize": "memorialise", "memorialized": "memorialised",
            "memorializes": "memorialises", "memorializing": "memorialising", "memorize": "memorise",
            "memorized": "memorised", "memorizes": "memorises", "memorizing": "memorising", "mesmerize": "mesmerise",
            "mesmerized": "mesmerised", "mesmerizes": "mesmerises", "mesmerizing": "mesmerising",
            "metabolize": "metabolise", "metabolized": "metabolised", "metabolizes": "metabolises",
            "metabolizing": "metabolising", "meter": "metre", "meters": "metres", "micrometer": "micrometre",
            "micrometers": "micrometres", "militarize": "militarise", "militarized": "militarised",
            "militarizes": "militarises", "militarizing": "militarising", "milligram": "milligramme",
            "milligrams": "milligrammes", "milliliter": "millilitre", "milliliters": "millilitres",
            "millimeter": "millimetre", "millimeters": "millimetres", "miniaturization": "miniaturisation",
            "miniaturize": "miniaturise", "miniaturized": "miniaturised", "miniaturizes": "miniaturises",
            "miniaturizing": "miniaturising", "minibusses": "minibuses", "minimize": "minimise",
            "minimized": "minimised", "minimizes": "minimises", "minimizing": "minimising",
            "misbehavior": "misbehaviour", "misdemeanor": "misdemeanour", "misdemeanors": "misdemeanours",
            "misspelled": "misspelt", "miter": "mitre", "miters": "mitres", "mobilization": "mobilisation",
            "mobilize": "mobilise", "mobilized": "mobilised", "mobilizes": "mobilises", "mobilizing": "mobilising",
            "modeled": "modelled", "modeler": "modeller", "modelers": "modellers", "modeling": "modelling",
            "modernize": "modernise", "modernized": "modernised", "modernizes": "modernises",
            "modernizing": "modernising", "moisturize": "moisturise", "moisturized": "moisturised",
            "moisturizer": "moisturiser", "moisturizers": "moisturisers", "moisturizes": "moisturises",
            "moisturizing": "moisturising", "monolog": "monologue", "monologs": "monologues",
            "monopolization": "monopolisation", "monopolize": "monopolise", "monopolized": "monopolised",
            "monopolizes": "monopolises", "monopolizing": "monopolising", "moralize": "moralise",
            "moralized": "moralised", "moralizes": "moralises", "moralizing": "moralising", "motorized": "motorised",
            "mold": "mould", "molded": "moulded", "molder": "moulder", "moldered": "mouldered",
            "moldering": "mouldering", "molders": "moulders", "moldier": "mouldier", "moldiest": "mouldiest",
            "molding": "moulding", "moldings": "mouldings", "molds": "moulds", "moldy": "mouldy", "molt": "moult",
            "molted": "moulted", "molting": "moulting", "molts": "moults", "mustache": "moustache",
            "mustached": "moustached", "mustaches": "moustaches", "mustachioed": "moustachioed",
            "multicolored": "multicoloured", "nationalization": "nationalisation",
            "nationalizations": "nationalisations", "nationalize": "nationalise", "nationalized": "nationalised",
            "nationalizes": "nationalises", "nationalizing": "nationalising", "naturalization": "naturalisation",
            "naturalize": "naturalise", "naturalized": "naturalised", "naturalizes": "naturalises",
            "naturalizing": "naturalising", "neighbor": "neighbour", "neighborhood": "neighbourhood",
            "neighborhoods": "neighbourhoods", "neighboring": "neighbouring", "neighborliness": "neighbourliness",
            "neighborly": "neighbourly", "neighbors": "neighbours", "neutralization": "neutralisation",
            "neutralize": "neutralise", "neutralized": "neutralised", "neutralizes": "neutralises",
            "neutralizing": "neutralising", "normalization": "normalisation", "normalize": "normalise",
            "normalized": "normalised", "normalizes": "normalises", "normalizing": "normalising", "odor": "odour",
            "odorless": "odourless", "odors": "odours", "esophagus": "oesophagus", "esophaguses": "oesophaguses",
            "estrogen": "oestrogen", "offense": "offence", "offenses": "offences", "omelet": "omelette",
            "omelets": "omelettes", "optimization": "optimisation", "optimizations": "optimisations",
            "optimize": "optimise", "optimized": "optimised", "optimizes": "optimises", "optimizing": "optimising",
            "organization": "organisation", "organizational": "organisational", "organizations": "organisations",
            "organize": "organise", "organized": "organised", "organizer": "organiser", "organizers": "organisers",
            "organizes": "organises", "organizing": "organising", "orthopedic": "orthopaedic",
            "orthopedics": "orthopaedics", "ostracize": "ostracise", "ostracized": "ostracised",
            "ostracizes": "ostracises", "ostracizing": "ostracising", "outmaneuver": "outmanoeuvre",
            "outmaneuvered": "outmanoeuvred", "outmaneuvers": "outmanoeuvres", "outmaneuvering": "outmanoeuvring",
            "overemphasize": "overemphasise", "overemphasized": "overemphasised", "overemphasizes": "overemphasises",
            "overemphasizing": "overemphasising", "oxidization": "oxidisation", "oxidize": "oxidise",
            "oxidized": "oxidised", "oxidizes": "oxidises", "oxidizing": "oxidising", "pederast": "paederast",
            "pederasts": "paederasts", "pediatric": "paediatric", "pediatrician": "paediatrician",
            "pediatricians": "paediatricians", "pediatrics": "paediatrics", "pedophile": "paedophile",
            "pedophiles": "paedophiles", "pedophilia": "paedophilia", "paleolithic": "palaeolithic",
            "paleontologist": "palaeontologist", "paleontologists": "palaeontologists", "paleontology": "palaeontology",
            "paneled": "panelled", "paneling": "panelling", "panelist": "panellist", "panelists": "panellists",
            "paralyze": "paralyse", "paralyzed": "paralysed", "paralyzes": "paralyses", "paralyzing": "paralysing",
            "parceled": "parcelled", "parceling": "parcelling", "parlor": "parlour", "parlors": "parlours",
            "particularize": "particularise", "particularized": "particularised", "particularizes": "particularises",
            "particularizing": "particularising", "passivization": "passivisation", "passivize": "passivise",
            "passivized": "passivised", "passivizes": "passivises", "passivizing": "passivising",
            "pasteurization": "pasteurisation", "pasteurize": "pasteurise", "pasteurized": "pasteurised",
            "pasteurizes": "pasteurises", "pasteurizing": "pasteurising", "patronize": "patronise",
            "patronized": "patronised", "patronizes": "patronises", "patronizing": "patronising",
            "patronizingly": "patronisingly", "pedaled": "pedalled", "pedaling": "pedalling",
            "pedestrianization": "pedestrianisation", "pedestrianize": "pedestrianise",
            "pedestrianized": "pedestrianised", "pedestrianizes": "pedestrianises",
            "pedestrianizing": "pedestrianising", "penalize": "penalise", "penalized": "penalised",
            "penalizes": "penalises", "penalizing": "penalising", "penciled": "pencilled", "penciling": "pencilling",
            "personalize": "personalise", "personalized": "personalised", "personalizes": "personalises",
            "personalizing": "personalising", "pharmacopeia": "pharmacopoeia", "pharmacopeias": "pharmacopoeias",
            "philosophize": "philosophise", "philosophized": "philosophised", "philosophizes": "philosophises",
            "philosophizing": "philosophising", "filter": "philtre", "filters": "philtres", "phony": "phoney",
            "plagiarize": "plagiarise", "plagiarized": "plagiarised", "plagiarizes": "plagiarises",
            "plagiarizing": "plagiarising", "plow": "plough", "plowed": "ploughed", "plowing": "ploughing",
            "plowman": "ploughman", "plowmen": "ploughmen", "plows": "ploughs", "plowshare": "ploughshare",
            "plowshares": "ploughshares", "polarization": "polarisation", "polarize": "polarise",
            "polarized": "polarised", "polarizes": "polarises", "polarizing": "polarising",
            "politicization": "politicisation", "politicize": "politicise", "politicized": "politicised",
            "politicizes": "politicises", "politicizing": "politicising", "popularization": "popularisation",
            "popularize": "popularise", "popularized": "popularised", "popularizes": "popularises",
            "popularizing": "popularising", "pouf": "pouffe", "poufs": "pouffes", "practice": "practise",
            "practiced": "practised", "practices": "practises", "practicing": "practising", "presidium": "praesidium",
            "presidiums": "praesidiums", "pressurization": "pressurisation", "pressurize": "pressurise",
            "pressurized": "pressurised", "pressurizes": "pressurises", "pressurizing": "pressurising",
            "pretense": "pretence", "pretenses": "pretences", "primeval": "primaeval",
            "prioritization": "prioritisation", "prioritize": "prioritise", "prioritized": "prioritised",
            "prioritizes": "prioritises", "prioritizing": "prioritising", "privatization": "privatisation",
            "privatizations": "privatisations", "privatize": "privatise", "privatized": "privatised",
            "privatizes": "privatises", "privatizing": "privatising", "professionalization": "professionalisation",
            "professionalize": "professionalise", "professionalized": "professionalised",
            "professionalizes": "professionalises", "professionalizing": "professionalising", "program": "programme",
            "programs": "programmes", "prolog": "prologue", "prologs": "prologues", "propagandize": "propagandise",
            "propagandized": "propagandised", "propagandizes": "propagandises", "propagandizing": "propagandising",
            "proselytize": "proselytise", "proselytized": "proselytised", "proselytizer": "proselytiser",
            "proselytizers": "proselytisers", "proselytizes": "proselytises", "proselytizing": "proselytising",
            "psychoanalyze": "psychoanalyse", "psychoanalyzed": "psychoanalysed", "psychoanalyzes": "psychoanalyses",
            "psychoanalyzing": "psychoanalysing", "publicize": "publicise", "publicized": "publicised",
            "publicizes": "publicises", "publicizing": "publicising", "pulverization": "pulverisation",
            "pulverize": "pulverise", "pulverized": "pulverised", "pulverizes": "pulverises",
            "pulverizing": "pulverising", "pummel": "pummelled", "pummeled": "pummelling", "pajama": "pyjama",
            "pajamas": "pyjamas", "pizzazz": "pzazz", "quarreled": "quarrelled", "quarreling": "quarrelling",
            "radicalize": "radicalise", "radicalized": "radicalised", "radicalizes": "radicalises",
            "radicalizing": "radicalising", "rancor": "rancour", "randomize": "randomise", "randomized": "randomised",
            "randomizes": "randomises", "randomizing": "randomising", "rationalization": "rationalisation",
            "rationalizations": "rationalisations", "rationalize": "rationalise", "rationalized": "rationalised",
            "rationalizes": "rationalises", "rationalizing": "rationalising", "raveled": "ravelled",
            "raveling": "ravelling", "realizable": "realisable", "realization": "realisation",
            "realizations": "realisations", "realize": "realise", "realized": "realised", "realizes": "realises",
            "realizing": "realising", "recognizable": "recognisable", "recognizably": "recognisably",
            "recognizance": "recognisance", "recognize": "recognise", "recognized": "recognised",
            "recognizes": "recognises", "recognizing": "recognising", "reconnoiter": "reconnoitre",
            "reconnoitered": "reconnoitred", "reconnoiters": "reconnoitres", "reconnoitering": "reconnoitring",
            "refueled": "refuelled", "refueling": "refuelling", "regularization": "regularisation",
            "regularize": "regularise", "regularized": "regularised", "regularizes": "regularises",
            "regularizing": "regularising", "remodeled": "remodelled", "remodeling": "remodelling", "remold": "remould",
            "remolded": "remoulded", "remolding": "remoulding", "remolds": "remoulds",
            "reorganization": "reorganisation", "reorganizations": "reorganisations", "reorganize": "reorganise",
            "reorganized": "reorganised", "reorganizes": "reorganises", "reorganizing": "reorganising",
            "reveled": "revelled", "reveler": "reveller", "revelers": "revellers", "reveling": "revelling",
            "revitalize": "revitalise", "revitalized": "revitalised", "revitalizes": "revitalises",
            "revitalizing": "revitalising", "revolutionize": "revolutionise", "revolutionized": "revolutionised",
            "revolutionizes": "revolutionises", "revolutionizing": "revolutionising", "rhapsodize": "rhapsodise",
            "rhapsodized": "rhapsodised", "rhapsodizes": "rhapsodises", "rhapsodizing": "rhapsodising",
            "rigor": "rigour", "rigors": "rigours", "ritualized": "ritualised", "rivaled": "rivalled",
            "rivaling": "rivalling", "romanticize": "romanticise", "romanticized": "romanticised",
            "romanticizes": "romanticises", "romanticizing": "romanticising", "rumor": "rumour", "rumored": "rumoured",
            "rumors": "rumours", "saber": "sabre", "sabers": "sabres", "saltpeter": "saltpetre", "sanitize": "sanitise",
            "sanitized": "sanitised", "sanitizes": "sanitises", "sanitizing": "sanitising", "satirize": "satirise",
            "satirized": "satirised", "satirizes": "satirises", "satirizing": "satirising", "savior": "saviour",
            "saviors": "saviours", "savor": "savour", "savored": "savoured", "savories": "savouries",
            "savoring": "savouring", "savors": "savours", "savory": "savoury", "scandalize": "scandalise",
            "scandalized": "scandalised", "scandalizes": "scandalises", "scandalizing": "scandalising",
            "skeptic": "sceptic", "skeptical": "sceptical", "skeptically": "sceptically", "skepticism": "scepticism",
            "skeptics": "sceptics", "scepter": "sceptre", "scepters": "sceptres", "scrutinize": "scrutinise",
            "scrutinized": "scrutinised", "scrutinizes": "scrutinises", "scrutinizing": "scrutinising",
            "secularization": "secularisation", "secularize": "secularise", "secularized": "secularised",
            "secularizes": "secularises", "secularizing": "secularising", "sensationalize": "sensationalise",
            "sensationalized": "sensationalised", "sensationalizes": "sensationalises",
            "sensationalizing": "sensationalising", "sensitize": "sensitise", "sensitized": "sensitised",
            "sensitizes": "sensitises", "sensitizing": "sensitising", "sentimentalize": "sentimentalise",
            "sentimentalized": "sentimentalised", "sentimentalizes": "sentimentalises",
            "sentimentalizing": "sentimentalising", "sepulcher": "sepulchre", "sepulchers": "sepulchres",
            "serialization": "serialisation", "serializations": "serialisations", "serialize": "serialise",
            "serialized": "serialised", "serializes": "serialises", "serializing": "serialising",
            "sermonize": "sermonise", "sermonized": "sermonised", "sermonizes": "sermonises",
            "sermonizing": "sermonising", "sheik": "sheikh", "shoveled": "shovelled", "shoveling": "shovelling",
            "shriveled": "shrivelled", "shriveling": "shrivelling", "signalize": "signalise",
            "signalized": "signalised", "signalizes": "signalises", "signalizing": "signalising",
            "signaled": "signalled", "signaling": "signalling", "smolder": "smoulder", "smoldered": "smouldered",
            "smoldering": "smouldering", "smolders": "smoulders", "sniveled": "snivelled", "sniveling": "snivelling",
            "snorkeled": "snorkelled", "snorkeling": "snorkelling", "snowplow": "snowploughs",
            "socialization": "socialisation", "socialize": "socialise", "socialized": "socialised",
            "socializes": "socialises", "socializing": "socialising", "sodomize": "sodomise", "sodomized": "sodomised",
            "sodomizes": "sodomises", "sodomizing": "sodomising", "solemnize": "solemnise", "solemnized": "solemnised",
            "solemnizes": "solemnises", "solemnizing": "solemnising", "somber": "sombre",
            "specialization": "specialisation", "specializations": "specialisations", "specialize": "specialise",
            "specialized": "specialised", "specializes": "specialises", "specializing": "specialising",
            "specter": "spectre", "specters": "spectres", "spiraled": "spiralled", "spiraling": "spiralling",
            "splendor": "splendour", "splendors": "splendours", "squirreled": "squirrelled",
            "squirreling": "squirrelling", "stabilization": "stabilisation", "stabilize": "stabilise",
            "stabilized": "stabilised", "stabilizer": "stabiliser", "stabilizers": "stabilisers",
            "stabilizes": "stabilises", "stabilizing": "stabilising", "standardization": "standardisation",
            "standardize": "standardise", "standardized": "standardised", "standardizes": "standardises",
            "standardizing": "standardising", "stenciled": "stencilled", "stenciling": "stencilling",
            "sterilization": "sterilisation", "sterilizations": "sterilisations", "sterilize": "sterilise",
            "sterilized": "sterilised", "sterilizer": "steriliser", "sterilizers": "sterilisers",
            "sterilizes": "sterilises", "sterilizing": "sterilising", "stigmatization": "stigmatisation",
            "stigmatize": "stigmatise", "stigmatized": "stigmatised", "stigmatizes": "stigmatises",
            "stigmatizing": "stigmatising", "subsidization": "subsidisation", "subsidize": "subsidise",
            "subsidized": "subsidised", "subsidizer": "subsidiser", "subsidizers": "subsidisers",
            "subsidizes": "subsidises", "subsidizing": "subsidising", "succor": "succour", "succored": "succoured",
            "succoring": "succouring", "succors": "succours", "sulfate": "sulphate", "sulfates": "sulphates",
            "sulfide": "sulphide", "sulfides": "sulphides", "sulfur": "sulphur", "sulfurous": "sulphurous",
            "summarize": "summarise", "summarized": "summarised", "summarizes": "summarises",
            "summarizing": "summarising", "swiveled": "swivelled", "swiveling": "swivelling", "symbolize": "symbolise",
            "symbolized": "symbolised", "symbolizes": "symbolises", "symbolizing": "symbolising",
            "sympathize": "sympathise", "sympathized": "sympathised", "sympathizer": "sympathiser",
            "sympathizers": "sympathisers", "sympathizes": "sympathises", "sympathizing": "sympathising",
            "synchronization": "synchronisation", "synchronize": "synchronise", "synchronized": "synchronised",
            "synchronizes": "synchronises", "synchronizing": "synchronising", "synthesize": "synthesise",
            "synthesized": "synthesised", "synthesizer": "synthesiser", "synthesizers": "synthesisers",
            "synthesizes": "synthesises", "synthesizing": "synthesising", "siphon": "syphon", "siphoned": "syphoned",
            "siphoning": "syphoning", "siphons": "syphons", "systematization": "systematisation",
            "systematize": "systematise", "systematized": "systematised", "systematizes": "systematises",
            "systematizing": "systematising", "tantalize": "tantalise", "tantalized": "tantalised",
            "tantalizes": "tantalises", "tantalizing": "tantalising", "tantalizingly": "tantalisingly",
            "tasseled": "tasselled", "technicolor": "technicolour", "temporize": "temporise",
            "temporized": "temporised", "temporizes": "temporises", "temporizing": "temporising",
            "tenderize": "tenderise", "tenderized": "tenderised", "tenderizes": "tenderises",
            "tenderizing": "tenderising", "terrorize": "terrorise", "terrorized": "terrorised",
            "terrorizes": "terrorises", "terrorizing": "terrorising", "theater": "theatre",
            "theatergoer": "theatregoer", "theatergoers": "theatregoers", "theaters": "theatres",
            "theorize": "theorise", "theorized": "theorised", "theorizes": "theorises", "theorizing": "theorising",
            "ton": "tonne", "tons": "tonnes", "toweled": "towelled", "toweling": "towelling", "toxemia": "toxaemia",
            "tranquilize": "tranquillize", "tranquilized": "tranquillized", "tranquilizer": "tranquillizer",
            "tranquilizers": "tranquillizers", "tranquilizes": "tranquillizes", "tranquilizing": "tranquillizing",
            "tranquility": "tranquilly", "transistorized": "transistorised", "traumatize": "traumatise",
            "traumatized": "traumatised", "traumatizes": "traumatises", "traumatizing": "traumatising",
            "traveled": "travelled", "traveler": "traveller", "travelers": "travellers", "traveling": "travelling",
            "travelog": "travelogue", "travelogs": "travelogues", "trialed": "trialled", "trialing": "trialling",
            "tricolor": "tricolour", "tricolors": "tricolours", "trivialize": "trivialise",
            "trivialized": "trivialised", "trivializes": "trivialises", "trivializing": "trivialising",
            "tumor": "tumour", "tumors": "tumours", "tunneled": "tunnelled", "tunneling": "tunnelling",
            "tyrannize": "tyrannise", "tyrannized": "tyrannised", "tyrannizes": "tyrannises",
            "tyrannizing": "tyrannising", "tire": "tyre", "tires": "tyres", "unauthorized": "unauthorised",
            "uncivilized": "uncivilised", "underutilized": "underutilised", "unequaled": "unequalled",
            "unfavorable": "unfavourable", "unfavorably": "unfavourably", "unionization": "unionisation",
            "unionize": "unionise", "unionized": "unionised", "unionizes": "unionises", "unionizing": "unionising",
            "unorganized": "unorganised", "unraveled": "unravelled", "unraveling": "unravelling",
            "unrecognizable": "unrecognisable", "unrecognized": "unrecognised", "unrivaled": "unrivalled",
            "unsavory": "unsavoury", "untrammeled": "untrammelled", "urbanization": "urbanisation",
            "urbanize": "urbanise", "urbanized": "urbanised", "urbanizes": "urbanises", "urbanizing": "urbanising",
            "utilizable": "utilisable", "utilization": "utilisation", "utilize": "utilise", "utilized": "utilised",
            "utilizes": "utilises", "utilizing": "utilising", "valor": "valour", "vandalize": "vandalise",
            "vandalized": "vandalised", "vandalizes": "vandalises", "vandalizing": "vandalising",
            "vaporization": "vaporisation", "vaporize": "vaporise", "vaporized": "vaporised", "vaporizes": "vaporises",
            "vaporizing": "vaporising", "vapor": "vapour", "vapors": "vapours", "verbalize": "verbalise",
            "verbalized": "verbalised", "verbalizes": "verbalises", "verbalizing": "verbalising",
            "victimization": "victimisation", "victimize": "victimise", "victimized": "victimised",
            "victimizes": "victimises", "victimizing": "victimising", "videodisk": "videodisc",
            "videodisks": "videodiscs", "vigor": "vigour", "visualization": "visualisation",
            "visualizations": "visualisations", "visualize": "visualise", "visualized": "visualised",
            "visualizes": "visualises", "visualizing": "visualising", "vocalization": "vocalisation",
            "vocalizations": "vocalisations", "vocalize": "vocalise", "vocalized": "vocalised",
            "vocalizes": "vocalises", "vocalizing": "vocalising", "vulcanized": "vulcanised",
            "vulgarization": "vulgarisation", "vulgarize": "vulgarise", "vulgarized": "vulgarised",
            "vulgarizes": "vulgarises", "vulgarizing": "vulgarising", "watercolor": "watercolour",
            "watercolors": "watercolours", "weaseled": "weaselled", "weaseling": "weaselling",
            "westernization": "westernisation", "westernize": "westernise", "westernized": "westernised",
            "westernizes": "westernises", "westernizing": "westernising", "womanize": "womanise",
            "womanized": "womanised", "womanizer": "womaniser", "womanizers": "womanisers", "womanizes": "womanises",
            "womanizing": "womanising", "woolen": "woollen", "woolens": "woollens", "woolies": "woollies",
            "wooly": "woolly", "worshiped": "worshipped", "worshiping": "worshipping", "worshiper": "worshipper",
            "yodeled": "yodelled", "yodeling": "yodelling", "yogurt": "yoghurt", "yogurts": "yoghurts"}
# @formatter:on

TYPO_FREQUENCY = {
    "a": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 594, 1, 42401, 1, 1, 1, 10893, 3882, 1, 3062],
    "b": [1, 1, 1, 1, 1, 16112, 21182, 10826, 1, 1, 1, 1, 1, 19375, 1, 1, 1, 1, 1, 1, 1, 6146, 1, 1, 1, 1],
    "c": [1, 1, 1, 19151, 1, 15124, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 37974, 1, 1, 7444, 1, 1, 1, 1],
    "d": [1, 1, 1, 1, 39499, 16091, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 64063, 80813, 1, 1, 7848, 10614, 2018, 1, 1],
    "e": [1, 1, 1, 1, 1, 17080, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 76503, 75665, 1, 1, 1, 13193, 1, 1, 1],
    "f": [1, 1, 1, 1, 1, 1, 13344, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 18722, 1, 20980, 1, 5822, 1, 1, 1, 1],
    "g": [1, 1, 1, 1, 1, 1, 1, 10144, 1, 1, 1, 1, 1, 23414, 1, 1, 1, 22092, 1, 30296, 1, 5093, 1, 1, 5295, 1],
    "h": [1, 1, 1, 1, 1, 1, 1, 1, 1, 2663, 1, 1, 11486, 11859, 1, 1, 1, 1, 1, 23856, 10462, 1, 1, 1, 1, 1],
    "i": [1, 1, 1, 1, 1, 1, 1, 1, 1, 699, 9983, 40985, 1, 1, 82987, 1, 1, 1, 1, 1, 63669, 1, 1, 1, 1, 1],
    "j": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1248, 1, 3464, 2011, 1, 1, 1, 1, 1, 1, 568, 1, 1, 1, 1, 1],
    "k": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 14651, 8496, 1, 8366, 1, 1, 1, 1, 1, 5455, 1, 1, 1, 1, 1],
    "l": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 43713, 30126, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
    "m": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 23433, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
    "n": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
    "o": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 18072, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
    "p": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
    "q": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2041, 1, 1, 1, 728, 1, 1, 1],
    "r": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 54571, 1, 1, 1, 1, 1, 1],
    "s": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 17079, 3613, 1, 7300],
    "t": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 13286, 1],
    "u": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6783, 1],
    "v": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
    "w": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
    "x": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 516],
    "y": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
    "z": [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
}

CONTRACTION_MAP = {'is not': "isn't", 'are not': "aren't", 'cannot': "can't", 'could not': "couldn't", 'did not':
    "didn't", 'does not': "doesn't", 'do not': "don't", 'had not': "hadn't", 'has not': "hasn't", 'have not': "haven't",
                   'he is': "he's", 'how did': "how'd", 'how is': "how's", 'I would': "I'd", 'I will': "I'll",
                   'I am': "I'm", 'i would': "i'd", 'i will': "i'll", 'i am': "i'm", 'it would': "it'd",
                   'it will': "it'll", 'it is': "it's", 'might not': "mightn't", 'must not': "mustn't",
                   'need not': "needn't", 'ought not': "oughtn't", 'shall not': "shan't", 'she would': "she'd",
                   'she will': "she'll", 'she is': "she's", 'should not': "shouldn't", 'that would': "that'd",
                   'that is': "that's", 'there would': "there'd", 'there is': "there's", 'they would': "they'd",
                   'they will': "they'll", 'they are': "they're", 'was not': "wasn't", 'we would': "we'd",
                   'we will': "we'll", 'we are': "we're", 'were not': "weren't", 'what are': "what're",
                   'what is': "what's", 'when is': "when's", 'where did': "where'd", 'where is': "where's",
                   'who will': "who'll", 'who is': "who's", 'who have': "who've", 'why is': "why's",
                   'will not': "won't", 'would not': "wouldn't", 'you would': "you'd", 'you will': "you'll",
                   'you are': "you're"}

# Curated from the United States Census Bureau surveys
white_names = {
    "first_names": ["Sage", "Jeremy", "Alisa", "Shaya", "Barbara", "Savannah", "Sonny", "Kate", "Jenna", "Yossi",
                    "Lauren", "Alexia", "Eva", "Chiara", "Kaitlyn", "Lilia", "Leah", "Lucille", "Siena", "Henchy",
                    "Tyler", "Hope", "Clementine", "Paige", "Finley", "Jason", "Michael", "Taylor", "Mohamed",
                    "Milania", "Elise", "Lucy", "Sylvie", "Shlome", "Blake", "Stephen", "Brady", "Maxwell", "Ayelet",
                    "Yocheved", "Noam", "Jana", "Elimelech", "Emmy", "Morris", "Younis", "Moishe", "Freya", "Batsheva",
                    "Nico", "Zain", "Amelie", "Mohammed", "Ava", "Harper", "Reizy", "Lielle", "Malak", "Shevy",
                    "Liliana", "Lily", "Leona", "Ephraim", "Freida", "Valerie", "Alina", "Kevin", "Perl", "Rhett",
                    "Jace", "Jaxson", "Amara", "Fishel", "Goldie", "Kyle", "Avery", "Viviana", "Sabrina", "Xavier",
                    "Ariela", "Vincenzo", "Marc", "David", "Sidney", "Issac", "Hayden", "Yitta", "Yeshaya", "Yaakov",
                    "Evelyn", "Hayes", "Dashiell", "Katerina", "Hazel", "Sabina", "Myles", "Bryan", "Karas", "Annabel",
                    "Alan", "Bina", "Amina", "Lorenzo", "Alexis", "Finn", "Frady", "Adalyn", "Hanna", "James", "Imran",
                    "Jasmine", "Arabella", "Nolan", "Shloma", "Yonatan", "Perel", "Alter", "Marco", "Rafael", "Frieda",
                    "Guy", "Samantha", "Cleo", "Griffin", "Nathan", "Chavy", "Eliza", "Reed", "Louise", "Peretz",
                    "Isla", "Hadassa", "Meyer", "Chelsea", "Chesky", "Olive", "Blimy", "Aya", "Anthony", "Ezra",
                    "Shraga", "Timothy", "Dovid", "Iymona", "Abdullah", "Seth", "Gianna", "Kamila", "Lyla", "Calvin",
                    "Michaela", "Cora", "Liora", "Max", "Phoenix", "Devora", "Paisley", "Sarah", "Ameer", "Daria",
                    "Ashley", "Evan", "Roizy", "Rocco", "Blair", "Erik", "Aria", "Claire", "Kian", "Emmeline",
                    "Shukrona", "Daniela", "Bryce", "Esther", "Celia", "Nova", "Elsa", "Trany", "Hadley", "Brynlee",
                    "Eric", "Walker", "Laith", "Xander", "Tucker", "Bentzion", "Celeste", "Antonia", "Rhys", "Yahya",
                    "Parizoda", "Kyler", "Vivienne", "Vincent", "Raya", "Lucas", "Arya", "Hailey", "Nechama", "Theo",
                    "Joel", "Phoebe", "Yael", "Lukas", "Saoirse", "Valentina", "Tristan", "Otto", "Brian", "Andrew",
                    "Lilian", "Mika", "Dominic", "Ezriel", "Chaya", "Devin", "Toby", "Willow", "Meilech", "William",
                    "Weston", "Aliza", "Maryam", "Jaxon", "Yassin", "Ansel", "Theodora", "Richard", "Nash", "Owen",
                    "Noa", "Dalia", "Gavin", "Elliot", "Chany", "Esty", "Amalia", "Hamza", "Blima", "Antonio", "Hassan",
                    "Ada", "Luciana", "Eloise", "Helen", "Maximilian", "Juliette", "Samira", "Giovanna", "Daphne",
                    "Diana", "Gwendolyn", "Skylar", "Elya", "Marlowe", "Arielle", "Dominick", "Arthur", "Ella",
                    "Abdulloh", "Charlie", "Elliana", "Avraham", "Harlow", "Isaac", "Mabel", "Georgia", "Faigy", "Sima",
                    "Amira", "Mendy", "Kenneth", "Yechezkel", "Reuven", "Shneur", "Maya", "Luke", "Eleanor", "Tzivia",
                    "Madison", "Quinn", "Henry", "Maggie", "Luka", "Augustus", "Ayala", "Imogen", "Gabriel", "Lilly",
                    "Millie", "Shloimy", "Waylon", "Maeve", "Meir", "Menashe", "Ryder", "Zayn", "Nikita", "Gregory",
                    "Shimon", "Emersyn", "Noelle", "Damian", "Khloe", "Devorah", "Leon", "Aleksander", "Frederick",
                    "Laura", "Joanna", "Magnolia", "Adina", "Florence", "Bodhi", "Ilan", "Billie", "Carly", "Yachet",
                    "Cheskel", "Zoey", "Giulia", "Sonia", "Sam", "Mackenzie", "John", "Aryeh", "Alessia", "Micah",
                    "Sammy", "Emanuel", "Zalmen", "Yisrael", "Bridget", "Giuseppe", "Nathaniel", "Emmanuel", "Delilah",
                    "Ilana", "Kira", "Laila", "Alec", "Kaya", "Avi", "Adrian", "Tzirel", "Sawyer", "Gabriela", "Orly",
                    "Mirel", "Cassandra", "Keira", "Carter", "Camila", "Scarlett", "Gianluca", "Raizel", "Olivia",
                    "Kennedy", "Aurora", "Frank", "Vienna", "Mechel", "Rivka", "Chava", "Bianca", "Casey", "Braxton",
                    "Sara", "Oren", "Elaina", "Justin", "Felix", "Omar", "Jane", "Ariel", "Mateo", "Kacper", "Yitzchok",
                    "Layan", "Rowan", "Desmond", "Olympia", "Ruth", "Louisa", "Nicholas", "Robert", "Saul", "Serafina",
                    "Christian", "Ronan", "Adrianna", "Tova", "Yasmina", "Vanessa", "Gracie", "Lev", "Paul", "Ethan",
                    "Nadia", "Eliot", "Tess", "Adeline", "Binyamin", "Sari", "Madelyn", "Angelica", "Stephanie",
                    "Emilia", "Samuel", "Ben", "Gabriella", "Diyora", "Shmiel", "Elisa", "Rina", "Lillian", "Ari",
                    "Raizy", "Angelo", "Reid", "Madina", "Aviva", "Georgina", "Brandon", "Beckham", "Morgan", "Marie",
                    "Mushka", "Alana", "Grey", "Ariella", "Basya", "Youssef", "Maxim", "Burech", "Levi",
                    "Cecilia", "Mila", "Mira", "Camden", "Mendel", "Nina", "Emery", "Mason", "Eden", "Eleni", "Winston",
                    "Breindy", "Tallulah", "Miriam", "Naftuli", "Liana", "Matteo", "Pinchas", "Elodie", "Alyssa",
                    "Eluzer", "Elisheva", "Livia", "Ahmed", "Joaquin", "Baruch", "Lydia", "Sadie", "Steven", "Yisroel",
                    "Sophia", "Celine", "Amrom", "Judah", "Selim", "Ellis", "Kai", "Naftali", "Christopher", "Sama",
                    "Arden", "Julie", "Peter", "Faiga", "Ahmad", "Clark", "Joshua", "Simi", "Jordyn", "Reuben", "Luca",
                    "Jude", "Jakob", "Spencer", "Lina", "Harry", "Moses", "Shaindel", "Tehila", "Miri", "Edward",
                    "Nicolas", "Francesca", "Amir", "Abubakr", "Libby", "Anton", "Salvatore", "Stanley", "Jacob",
                    "Hindy", "Baila", "Mark", "Simcha", "Isabella", "Marina", "Ibrohim", "Thomas", "Ahuva", "Joyce",
                    "Anas", "Ahron", "Yaseen", "Connor", "Melina", "Fiona", "Zane", "Sloane", "Aliya", "Selma", "Arlo",
                    "Greta", "Stella", "Jameson", "Knox", "Megan", "Tamara", "Wilder", "Mary", "Genevieve", "Theodore",
                    "Timur", "Lara", "Elijah", "Yida", "Elias", "Viktor", "Yara", "Colin", "Toba", "Dillon",
                    "Alexander", "Brantley", "Elliott", "Riva", "Ryleigh", "Elena", "Hershel", "Leyla", "Margaret",
                    "Simon", "Leonidas", "Tamar", "Hersh", "Harley", "Chloe", "Zachary", "Yitty", "Abraham", "Jasper",
                    "Easton", "Josephine", "Esme", "Vera", "Carolina", "Barrett", "Moshe", "Eliana", "Nava", "Raphael",
                    "Shulem", "Ashton", "Hunter", "Beau", "Adam", "Malka", "Ori", "Rochel", "Axel", "Umar", "Melissa",
                    "Catherine", "Sophie", "Shayna", "Natalia", "Erin", "Graham", "Harvey", "Lilliana", "Helena",
                    "Giada", "Shea", "Ester", "Nora", "Anya", "Enzo", "Yanky", "Atlas", "Goldy", "Liba", "Aleksandra",
                    "Bruchy", "Jesse", "Louis", "Mollie", "Suri", "Linda", "Zakaria", "Jonah", "Sienna", "Angelina",
                    "River", "Cooper", "Sholom", "Layla", "Devory", "Henny", "Rena", "Derek", "Isabel", "Duvid", "Elle",
                    "Fradel", "Wolf", "Juliana", "Juliet", "Bailey", "Alexa", "Shoshana", "Simone", "Josef", "Santino",
                    "Hillel", "Carmine", "Mohammad", "Meshilem", "Herman", "Reagan", "Alicia", "Clara", "Rebecca",
                    "Abe", "Gaia", "Daniella", "Nicole", "Dua", "Raymond", "Jessica", "Charlotte", "Shaul", "Julian",
                    "Yehoshua", "Julius", "Margaux", "Muhammad", "Anisa", "Polina", "Brooklyn", "Dante", "Jakub",
                    "Giuliana", "Addison", "Shifra", "Alexandra", "Naomi", "Salma", "Katie", "Shia", "Sury", "Russell",
                    "Brooke", "Lucia", "Etty", "Aaron", "Muslima", "Julianna", "Silas", "Avrum", "Summer", "Eitan",
                    "Oscar", "Shaindy", "Yasmin", "Matilda", "Ayla", "Yitzchak", "Lila", "Preston", "Estelle", "Isaiah",
                    "Brody", "Donovan", "Mindy", "Briella", "Lazer", "Jackson", "Shalom", "Norah", "Atara", "Lucien",
                    "Colton", "Maisie", "Anderson", "Reem", "Juniper", "Michal", "Akiva", "Chana", "Kiera", "Tobias",
                    "Cecelia", "Yehudah", "Aubrey", "Yides", "Idy", "Zissy", "Dina", "Yona", "Shmuel", "Giancarlo",
                    "Leibish", "Talia", "Neil", "Nuchem", "Katelyn", "Matthew", "Daisy", "Jamie", "Nachman",
                    "Kinsley", "Yidel", "Albert", "Fraidy", "Farida", "Emmett", "Dylan", "Eyad", "Rose", "Liam", "Dana",
                    "Austin", "Filip", "Harrison", "Ayden", "Menucha", "Madeline", "Anastasia", "Angela", "Mordechai",
                    "Lana", "Gavriel", "Grayson", "Evangeline", "Iris", "Isabelle", "Brayden", "Greyson", "Batya",
                    "Scott", "Rosalie", "Anna", "Alma", "Remy", "Milo", "Aiden", "Nikolas", "Frances", "Elizabeth",
                    "Chanie", "Tziporah", "Adriana", "Reese", "Pierce", "Remington", "Mina", "Jad", "Yehudis",
                    "Brianna", "Everly", "Allison", "Winnie", "George", "Giovanni", "Emma", "Berish", "Zoe", "Yechiel",
                    "Zev", "Julia", "Adelina", "Wyatt", "Colette", "Nicolette", "Chaim", "Lipa", "Eliyahu",
                    "Alessandra", "Milan", "Bradley", "Veronica", "Caroline", "Yoel", "Avigail", "Lucian", "Adele",
                    "Muhammad ali", "Audrey", "Mikaela", "Ellie", "Natalie", "Adelaide", "Avrohom", "Hinda", "Callie",
                    "Maia", "Dahlia", "Vivian", "Hershy", "Mayar", "Gemma", "Ines", "Orion", "Caitlin", "Beatrix",
                    "Faith", "Kareem", "Declan", "Margot", "Cassidy", "Aurelia", "Melanie", "Leila", "Hana",
                    "Francesco", "Allen", "Shaina", "Ruchel", "Josie", "Lia", "Emerson", "Yousef", "Danielle",
                    "Massimo", "Rayan", "Nosson", "Kristina", "Cameron", "Camilla", "Ali", "Logan", "Riley",
                    "Alexandria", "Brielle", "Veronika", "Usher", "Penelope", "Marielle", "Sebastian", "Ivan", "Daniel",
                    "Ian", "Violet", "Nikolai", "Tzipora", "Luna", "Aziza", "Efraim", "Victor", "Arye", "Cody",
                    "Jacqueline", "Eli", "Kaia", "Piper", "Beatrice", "Alice", "Frida", "Claudia", "Ruchy", "Francis",
                    "Michelle", "Rory", "Poppy", "Ryan", "Katherine", "Molly", "Marcus", "Noor", "Otis", "Avital",
                    "Samir", "Parker", "Rachel", "Teagan", "Dawson", "Eliezer", "Leonard", "Beckett", "Rifka", "Jade",
                    "Noach", "Blakely", "Alessandro", "Kathryn", "Brynn", "Rosa", "Aidan", "Anne", "Amanda",
                    "Devoiry", "Caleb", "Philip", "Jayden", "Lola", "Amirjon", "Drew", "Gittel", "Dean", "Amy", "Roman",
                    "Shane", "Hendy", "Archer", "Sylvia", "Rifky", "Mia", "Finnegan", "Solomon", "Binyomin", "Edith",
                    "Shloime", "Asher", "Hannah", "Atticus", "Tomas", "Everett", "Abigail", "Presley", "Arianna",
                    "Sofia", "Rivky", "Mikayla", "Serena", "Crosby", "Gideon", "Martin", "Idris", "Lincoln", "Denis",
                    "Camille", "Gia", "Chris", "Bella", "Tzvi", "Cyrus", "Madeleine", "Shlomo", "Jennifer", "Emir",
                    "Jax", "Malky", "Maksim", "Sydney", "Stefan", "Maximus", "Giselle", "Sami", "Yosef", "Zainab",
                    "Roiza", "Annabelle", "Romy", "Elan", "Ralph", "Milana", "Virginia", "Pearl", "Mayer", "Aviel",
                    "Ruby", "Pessy", "Renee", "Mordche", "Jonathan", "Hugo", "Yonah", "Menachem", "Jolie", "Rivkah",
                    "Sean", "Aron", "Jordan", "Kylie", "Leia", "Yusuf", "Kayla", "Oliver", "Jasmina",
                    "Gabrielle", "Bennett", "Walter", "Imona", "Holden", "Willa", "Boruch", "Everleigh", "Hadassah",
                    "Frimet", "Ariana", "Ryker", "Astrid", "Judy", "Emily", "Cole", "Wesley", "Malika", "Brooks",
                    "Brendan", "Grace", "Ember", "Victoria", "Aisha", "Dion", "Alex", "Remi", "Joseph", "Lilah", "Lea",
                    "Josiah", "Rahaf", "Julien", "Sasha", "Motty", "Yakov", "Benjamin", "Mariam", "Marcel", "Eve",
                    "Pinchus", "Gitty", "Leo", "Benzion", "Evie", "Farah", "Hudson", "Rosie", "Meira", "Grant", "Noah",
                    "Landon", "Zelda", "Golda", "Malek", "Leonardo", "Autumn", "Maria", "Peyton", "Evelina", "Aspen",
                    "Colt", "Izabella", "Shira", "Perry", "Caden", "Makayla", "Brucha", "Ivy", "Patrick", "Liv",
                    "Kieran", "Thea", "Zara", "Dennis", "Tzippy", "Cormac", "Charles", "Elina", "Mae", "Yehuda",
                    "Conor", "Ibrahim", "Kaylee", "Amelia", "Christina", "Bracha", "Athena", "Berl", "Maverick",
                    "Leora", "Jack", "Milena", "Aharon", "Ana", "Kobe", "Moishy", "Jake", "Raelynn", "Jay", "Oskar",
                    "Melania", "Tessa", "Aydin", "Paloma", "Fatima", "Lena", "Chase", "Malcolm", "Dov", "Bentley",
                    "Raquel", "Malik", "Yasmine"],
    "last_names": ["Holcomb", "Gallant", "Mayes", "Franklin", "Westphal", "Goff", "Fitzpatrick", "Mcvey", "Churchill",
                   "Matteson", "Worrell", "Kieffer", "Whiteside", "Bills", "Bledsoe", "Brownlee", "Barrows", "Courtney",
                   "Breedlove", "Feldman", "Brandenburg", "Eagle", "Mears", "Bunting", "Thompson", "Garman", "Hope",
                   "Clancy", "Whitaker", "Whalen", "Hodge", "Culpepper", "Bruno", "Robison", "Neeley",
                   "Roeder", "Baxter", "Keller", "Donato", "Wheaton", "Wilburn", "Jackman", "Abernathy", "Seeley",
                   "Belt", "Hawks", "Medley", "Birch", "Gough", "Mcneely", "Armstrong", "Colbert", "Christianson",
                   "Huston", "Magnuson", "Dietz", "Morrissey", "Greer", "Kyle", "Mcgarry", "Mull", "Fusco", "Higgins",
                   "Gooch", "Snook", "Goss", "Nilson", "Beattie", "Rife", "Hayes", "Franks", "Salisbury",
                   "Ruggiero", "Deboer", "Rowland", "Embry", "Powers", "Pate", "Shapiro", "Herzog", "Reedy", "Buehler",
                   "Unger", "Cassell", "Finn", "Harrington", "Frankel", "Ritchey", "Dorn", "Christy", "Tyson",
                   "Martindale", "Mccurdy", "Thayer", "Corrigan", "Wills", "Jansen", "Hail", "Bingham", "Ramey",
                   "Searcy", "Alford", "Redmon", "Delong", "Thorpe", "Beers", "Belanger", "Tackett", "Michels",
                   "Calvin", "Kwiatkowski", "Ring", "Blum", "Lackey", "Rutledge", "Farrar", "Crump", "Gorham", "Bryson",
                   "Southerland", "Blodgett", "Bradshaw", "Copeland", "Woodward", "Borges", "Horne",
                   "Nicholson", "Samson", "Givens", "Windham", "Pepper", "Markham", "Finch", "Greco", "Mcclintock",
                   "Carey", "Voss", "Moseley", "Mize", "Hitt", "Owens", "Brittain", "Barros", "Isaacs", "Baskin",
                   "Mortensen", "Rainey", "Somers", "Sowers", "Hurst", "Royal", "Crawford", "Broussard", "Hamilton",
                   "Ahrens", "Eldridge", "Bradbury", "Wallen", "Otto", "Fisk", "Gaston",
                   "Rust", "Franke", "Andrew", "Patten", "Lindgren", "Showalter", "Wilkins", "Willingham", "Weston",
                   "Pruitt", "Brenner", "Clements", "Hathaway", "Bandy", "Clement", "Purcell", "Mcalister", "Gilligan",
                   "Bartholomew", "Lantz", "Rossi", "Latimer", "Sinclair", "Sherrill", "Healey", "Pelletier", "Thigpen",
                   "Aldrich", "Reuter", "Brumfield", "Neville", "Fay", "Brannon", "Taber", "Murphy", "Edwards",
                   "Henley", "Mckee", "Partridge", "Mcneill", "Collins", "Robins", "Brewer", "Weinstein", 
                   "Oates", "Cass", "Romeo", "Salem", "Rich", "Mcgowan", "Irby", "Curtin", "Lay", "Lavender",
                   "Broughton", "Snider", "Palmer", "Holmes", "Gabriel", "Gresham", "Morse", "Manning", "Schumann",
                   "Vanhorn", "Ricker", "Whitten", "Rockwell", "Chaney", "Conlon", "Keenan", "Markley", "Ryder",
                   "Woods", "Ellington", "Gregory", "Mccollum", "Kee", "Deutsch", "Reece", "Kincaid", "Clay", "Millard",
                   "Freitas", "Witte", "Oliveira", "Snell", "Posey", "Ogrady", "Lacroix", "Mcclanahan", "Bosch",
                   "Fitzsimmons", "Spellman", "Phelps", "Mcguire", "Dubose", "Mcinnis", "Langlois", "Buell",
                   "Willson", "Hagen", "Eisenberg", "Cates", "Sherman", "Costello", "Whitman", "Tierney", "Mckinley",
                   "Kling", "Muller", "Bradford", "Lavoie", "Coyle", "Kingsley", "Friedman", "Barnes", "Saylor",
                   "Jarrell", "Weatherford", "Mckeever", "Dupre", "Lambert", "Eads", "Boles", "Gruber", "Talbot",
                   "Mcginley", "Kaufmann", "Hammond", "Carter", "Walling", "Cosgrove", "Oconnor", "Rutkowski",
                   "Mcgregor", "Hanson", "Casey", "Gearhart", "Leone", "Neely", "Rohr", "Ridenour", "Hartmann",
                   "Tanner", "Gower", "Ward", "Stamps", "Ponder", "Paulson", "Pettigrew", "Cockrell", "Stoltzfus",
                   "Hartzell", "Clemens", "Kunkel", "Rhoads", "Winstead", "Meyers", "Mckeon", "Donley", "Graves",
                   "Brand", "Hedges", "Bonham", "Hubbard", "Pinson", "Saul", "Harman", "Hartnett", "Baugh", "Gunn",
                   "Hutcheson", "Mcnabb", "Combs", "Meek", "Larsen", "Schwab", "Weil", "Tinsley", "Roderick", "Fitch",
                   "Lively", "Seaton", "Hargrave", "Puckett", "Geary", "Ott", "Sutton", "Gatlin", "Dobbs", "Jett",
                   "Moser", "Callahan", "Gaskin", "Gleason", "Randolph", "Card", "Beckham", "Fulkerson", "Melvin",
                   "Grey", "Michalski", "Deloach", "Aiken", "Tabor", "Pippin", "Estes", "Hoyle", "Jones",
                   "Penny", "Roberts", "Stuart", "Hooker", "Lacy", "Summers", "Emery", "Weldon", "Cotter", "Holder",
                   "Orton", "Mccarthy", "Rains", "Keeling", "Weed", "Wegner", "Guarino", "Cohn", "Gilson", "Medlin",
                   "Gunther", "Sadler", "Johnston", "Yoder", "Stidham", "Judge", "Witt", "Dockery", "Zeigler",
                   "Lovell", "Blackwell", "Waters", "Cantrell", "Clark", "Hodgson", "Farley", "Herrick", "Snowden",
                   "Moses", "Fabian", "Mancini", "Friedrich", "Leroy", "Mccann", "Mckenney", "Troutman",
                   "Ferry", "Southard", "Libby", "Minor", "Ethridge", "Traylor", "Stanley", "Tilton", "Beeler",
                   "Mcgovern", "Garber", "Treadway", "Guenther", "Buxton", "Lange", "Grubb", "Dick", "Tatum", "Rayburn",
                   "Fernandes", "Connor", "Hodges", "Moorman", "Carson", "Peterman", "Mccormack", "Conger", "Helm",
                   "Key", "Messick", "Buffington", "Warden", "Herbst", "Wadsworth", "Fortner", "Wheatley", "Pannell",
                   "Poston", "Emmons", "Applegate", "Cox", "Frazer", "Ross", "Baron", "Mead", "Mcbride", "Dillon",
                   "Schindler", "Stoker", "Turk", "Alexander", "Rasmussen", "Lawson", "Mckelvey", "Steel", "Mccarty",
                   "Swanson", "Zielinski", "Byrne", "Brunner", "Nugent", "Bayer", "Houck", "Cupp", "Craven", "Dubois",
                   "Hobson", "Wicker", "Deal", "Booher", "Adam", "Crane", "Rock", "Wentworth", "Goebel", "Shull",
                   "Martell", "Rash", "Nielson", "Kitchens", "Parent", "Kozlowski", "Barber", "Lilley", "Dumas",
                   "Sorensen", "Valente", "Harvey", "Munson", "Munn", "Martz", "Pringle", "Goodrich", "Gillis",
                   "Martini", "Minton", "Call", "Varney", "Weems", "Gross", "Keefe", "Dove", "Hale", "Bourgeois",
                   "Skipper", "Cramer", "Flanagan", "Lanham", "Farmer", "Dunlap", "Gardner", "Ketchum", "Mcmurray",
                   "Sales", "Fleming", "Hintz", "Roark", "Gerlach", "Bales", "Strange", "Wilson", "Mcclain", "Byrd",
                   "Nix", "Beaulieu", "Oglesby", "Adcock", "Stroud", "Schulte", "Leclair", "Stuckey", "Baggett",
                   "Heaton", "Clary", "Merkel", "Reagan", "Gosnell", "East", "Miley", "Read", "Lovejoy", "Sabo",
                   "Huskey", "Boston", "Burger", "Lindley", "Smithson", "Wilkerson", "Starr", "Jerome", "Gilley",
                   "Fenner", "Russell", "Guidry", "Gates", "Mccord", "Wimberly", "Amato", "Whiteman", "Fogle", "Waller",
                   "Enos", "Bowers", "Gottlieb", "Glaser", "Floyd", "Sager", "Harter", "Lundy", "Koster", "Mancuso",
                   "Stringer", "Barth", "Dowd", "Loftus", "Meehan", "Donovan", "Hoover", "Maclean", "Laney", "Byrnes",
                   "Martel", "Riedel", "Milam", "Stull", "Woodworth", "Steele", "Seidel", "Burgess", "Coons", "Neill",
                   "Pugh", "Waite", "Head", "Marvin", "Camara", "Moulton", "Bianchi", "Brockman", "Sells",
                   "Crutchfield", "Maier", "Roy", "Rousseau", "Alderman", "Stamper", "Fuqua", "Register",
                   "Erdman", "Erb", "Albert", "Heath", "Duckworth", "Roland", "Staples", "Boling", "Lehmann", "Horn",
                   "Fredericks", "Mcallister", "Oakley", "Nickerson", "Handley", "Bowen", "Basile", "Frick", "Langford",
                   "Oaks", "Holtz", "Beaver", "Sisco", "Pierson", "Halsey", "Sprouse", "Beiler", "Zimmermann", "Keys",
                   "Andrews", "Judd", "Roller", "Mackey", "Merrick", "Weinberg", "Lauer", "Weiner", "Keel",
                   "Christensen", "Granger", "Hardy", "Stovall", "Gonsalves", "Wickham", "Mcknight", "Isaacson",
                   "Milburn", "Evers", "Kenny", "Chadwick", "Bray", "Redmond", "Shoemaker", "Cochrane", "Lovelace",
                   "Lynch", "Bowden", "Mcmillan", "Rollins", "Reich", "Gilbertson", "Scherer", "Sowell", "Patterson",
                   "Whiting", "Holt", "Grover", "Eckert", "Tibbs", "Crews", "Burnett", "Adler", "Renner", "Royer",
                   "Grasso", "Sneed", "Seals", "Wainwright", "Weiler", "Yarbrough", "Smyth", "Redman", "Falk", "Shank",
                   "Durham", "Welsh", "Wentz", "Hunt", "Belcher", "Renfro", "Rizzo", "Marques", "Coffman", "Patton",
                   "Hendricks", "Crist", "Schiller", "Hales", "Caputo", "Lind", "Russo", "Shuler", "Legg", "Etheridge",
                   "Chaffin", "Goldstein", "Janes", "Starnes", "Pyles", "Greenberg", "Gibbons", "Carroll", "Scarbrough",
                   "Bassett", "Riley", "Hammer", "Roth", "Falcone", "Herron", "Albers", "Burley", "Matlock", "Fry",
                   "Leblanc", "Mcmaster", "Macdonald", "Damron", "Boone", "Hogg", "Cody", "Kenyon", "Mckenna",
                   "Erwin", "Whitmore", "Fenton", "Marcus", "Sargent", "Blackman", "Kuykendall", "Whited", "Blakely",
                   "Keil", "Stine", "Albertson", "Conrad", "Raines", "Daly", "Mickelson", "Fountain", "Wharton",
                   "Gilman", "Bannister", "Thurman", "Spurgeon", "Bracken", "Gordon", "Triplett", "Fletcher", "Kress",
                   "Archer", "Dunne", "Reis", "Culver", "Hill", "Reilly", "Asher", "Hannah", "Hughes", "Friend",
                   "Marek", "Sherry", "Daigle", "Clausen", "Ames", "Drake", "Presley", "Crosby", "Felts", "Gagne",
                   "Whelan", "Kurtz", "Galvin", "Linn", "Brice", "Borden", "Byers", "Wheat", "Denney", "Simmons",
                   "Bain", "Trombley", "Mattson", "Marx", "Iverson", "Richards", "Shelton", "Brubaker", "Albanese",
                   "Chastain", "Hurt", "Coley", "Oconnell", "Flora", "Baldwin", "Kish", "Alley", "Sander", "Grande",
                   "Unruh", "Tracey", "Pulley", "Mcwhorter", "Trotter", "Cooney", "Ludwig", "Rathbun", "Mills", "Earl",
                   "Wimmer", "Whittington", "Jordan", "Clemmons", "Houghton", "Sheppard", "Holman", "Hahn", "Newberry",
                   "Griffith", "Camp", "Turner", "Glover", "Blanchard", "Cummins", "Cheek", "Baumgartner", "Seaman",
                   "Frame", "Bruner", "Sellers", "Croft", "Glasgow", "Conaway", "Proffitt", "Winchester", "Gooding",
                   "Judy", "Daley", "Needham", "Gillen", "Durand", "Hague", "Rawson", "Paxton", "Bagley", "Whitworth",
                   "Morley", "Desantis", "Hillman", "Cowart", "Gann", "Wooden", "Sayers", "Monson", "Osullivan",
                   "Slayton", "Mcelroy", "Layman", "Benjamin", "Mcclelland", "Roden", "Choate", "Oshea", "Kuhn",
                   "Manley", "Bohn", "Hanks", "Haase", "Keener", "Dahl", "Garrett", "Beckman", "Neal", "Morrill", "Ivy",
                   "Pitman", "Keeton", "Augustine", "Sylvester", "Street", "Huggins", "Switzer", "Worley", "Shaw",
                   "Fort", "Leigh", "Salyer", "Allred", "Dodge", "Witmer", "Weiss", "Furlong", "Cady", "Maloney",
                   "Jack", "Mendenhall", "Maddox", "Halverson", "Nunley", "Wasson", "Pauley", "Jay", "Bauer", "Enright",
                   "Holliday", "Metzler", "Sexton", "Amos", "Hetrick", "Bittner", "Lundquist", "Malcolm", "Truitt",
                   "Lord", "Bentley", "Mcdevitt", "Livingston", "Coppola", "Mcdade", "Ezell", "Scarborough",
                   "Fullerton", "Ferraro", "Britton", "Mccartney", "Mcnally", "Massey", "Odonnell", "Jacobsen",
                   "Musick", "Trent", "Stevens", "Blount", "Sessions", "Huntley", "Sammons", "Winslow", "Wojcik",
                   "Spurlock", "Thomson", "Yates", "Lundgren", "Pulliam", "Meier", "Bischoff", "Rosenberger",
                   "Myrick", "Brinson", "Eller", "Pritchett", "Ricketts", "Hall", "Woolley", "Mcconnell", "Mcafee",
                   "Corbett", "Horner", "Groves", "Barkley", "Whittle", "Blank", "Boswell", "Blackwood",
                   "Tisdale", "Burrows", "Rosen", "Taylor", "Shannon", "Paulsen", "Thorne", "Norton", "Straub", "Brady",
                   "Atchison", "Stoll", "Snipes", "Lancaster", "Shaver", "Waldron", "Rosser", "Borders", "Mcmillen",
                   "Post", "Ladd", "Cushing", "Holbrook", "Gray", "Harper", "Painter", "Phelan", "Heilman", "Masterson",
                   "Wenzel", "Gurley", "Causey", "Steinmetz", "Sprague", "Christie", "Casper", "Mccall", "Rider",
                   "Heck", "Schmid", "Schweitzer", "Slattery", "Heims", "Bolt", "Snyder", "Loper", "Welker", "Griffis",
                   "Sweat", "Mckeown", "Gatewood", "Morrell", "Halstead", "David", "Ingram", "Baird", "Miner", "Fleck",
                   "Fagan", "Allman", "Bruce", "Ware", "Hazel", "Grenier", "Rudd", "Bahr", "Bryan", "Hamby", "Shepard",
                   "Boatwright", "Bernstein", "Redden", "Crocker", "Nolan", "Butcher", "Haines", "Bricker", "Boyce",
                   "Nance", "Mashburn", "Newton", "Toler", "Sumner", "Reaves", "Carden", "Nathan", "Silverstein",
                   "Reed", "Foreman", "Ashe", "Hickey", "Anthony", "Martins", "Lemaster", "Doll", "Grogan", "Stebbins",
                   "Mayberry", "Anglin", "Higginbotham", "Mccue", "Linville", "Larose", "Carbone", "Seibert",
                   "Warfield", "Pickens", "Walz", "Ries", "Greene", "Mertz", "Jenks", "Destefano", "Walters", "Nettles",
                   "Lowery", "Teixeira", "Putnam", "Volpe", "Gauthier", "Hanlon", "Walker", "Ragan", "Tucker", "Rubino",
                   "Kirk", "Stepp", "Leslie", "Shelby", "Jernigan", "Downey", "Woolsey", "Palermo", "Schreiber",
                   "Arndt", "Salter", "Pease", "Barnard", "Hussey", "Lucas", "Walsh", "Vincent", "Silver", "Bivens",
                   "Bussey", "Hartwell", "Jacobs", "Bernhardt", "Deyoung", "Counts", "Farrow", "Lutz", "Strain",
                   "Dreyer", "Hofer", "Schmitz", "Milner", "Oden", "Parkinson", "Romano", "Hibbard", "Staggs", "Mcvay",
                   "Nash", "Owen", "Johnson", "Glenn", "Toney", "Mcdonough", "Whitcomb", "Purdy", "Loyd", "Quick",
                   "Slaughter", "Doolittle", "Marchese", "Montague", "Doughty", "Earley", "Swafford", "Pieper",
                   "Conley", "Kruger", "Ragland", "Harlow", "Carmichael", "Garrison", "Shanks", "Michel", "Weller",
                   "Huff", "Hacker", "Cobb", "Larue", "Guillory", "Speer", "Cato", "Hoff", "Madison", "Benoit",
                   "Flowers", "Lipscomb", "Langston", "Mckenzie", "Howland", "Andres", "Dayton", "Donnelly", "Potter",
                   "Clouse", "Shirley", "Downs", "Hecht", "Stubblefield", "Matheny", "Walther", "Selby", "Stark",
                   "Rutherford", "Bergeron", "Eggleston", "Simpkins", "Reiter", "Rohrer", "Knoll", "Lusk", "Jorgensen",
                   "Gannon", "Jarvis", "Lindberg", "Newman", "Wiseman", "Schreiner", "Perdue", "Burdick", "Galbraith",
                   "Garvin", "Boren", "Frederick", "Priest", "Beverly", "Valenti", "Smothers", "Bartley", "Burnside",
                   "Larkin", "Lamb", "Agnew", "Spitzer", "Mccutcheon", "Shipman", "Mackenzie", "Himes", "Wheeler",
                   "Ely", "Cottrell", "Munro", "Plunkett", "Dickerson", "Williford", "Leary", "Ruff", "Sample", "Niles",
                   "Stephan", "Badger", "Cordell", "Robertson", "Creighton", "Creech", "Briggs", "Hoffman", "Reinhart",
                   "Richmond", "Bolen", "Cornelius", "Pendleton", "Olmstead", "Mangum", "Basham", "Vetter", "Barr",
                   "Marquardt", "Erickson", "Holland", "Faulkner", "Melton", "Haynes", "Heffernan", "Whyte", "Skidmore",
                   "Adams", "Minnick", "Towne", "Greiner", "Mccormick", "Crawley", "Ruble", "Prewitt", "Roddy", "Heil",
                   "Sheets", "Marker", "Atkinson", "Wilkes", "Cushman", "Wilt", "Palumbo", "Pogue", "Ruth",
                   "Littlefield", "Newby", "Stinnett", "Mcmullen", "Wozniak", "Keeler", "Havens", "Grisham", "Shaffer",
                   "Castellano", "Wilbur", "Greathouse", "Poe", "Holley", "Barnhill", "Rankin", "Lennon", "Koch",
                   "Larson", "Arsenault", "Rosenfeld", "Hooper", "Darr", "Kremer", "Binkley", "Merrill", "Miller",
                   "Vickers", "Hare", "Whitley", "Cotton", "Jobe", "Dickinson", "Morgan", "Rinaldi", "Kaminski",
                   "Riggs", "Thibodeaux", "Bostick", "Deangelo", "Ralston", "Lanning", "Hoffmann", "Connors",
                   "Mcarthur", "Valentine", "Bair", "Eden", "Mattox", "Crabtree", "Schenk", "Timmerman", "Pagano",
                   "Whatley", "Mendes", "Hancock", "Boothe", "Linder", "Theis", "Bankston", "Rector", "Horton", "Roe",
                   "Gibson", "Wright", "Tharp", "Hutson", "Clarkson", "Colley", "Sousa", "Kasper", "Muir",
                   "Peter", "Mccrary", "Beavers", "Farkas", "Gilchrist", "Robson", "Moore", "Ford", "Beck", "Bice",
                   "Hager", "Irwin", "Temple", "Dover", "Hough", "Rooney", "Goforth", "Watkins", "Corbin", "Blalock",
                   "Headley", "Shipp", "Ransom", "Estep", "Adair", "Gilliland", "Biddle", "Wilke", "Prosser", "Gerard",
                   "Wells", "Bollinger", "Pearson", "Boyer", "Hanes", "Kenney", "Bock", "Noland", "Corey", "Thomas",
                   "Joyce", "Mcpherson", "Monahan", "Pickett", "Hutton", "Tubbs", "Derr", "Reeves", "Seiler", "Lott",
                   "Cahill", "Lemke", "Cline", "Henke", "Maki", "Lund", "Burkett", "Wise", "Hackett", "Mallory", "Bone",
                   "Jacobson", "Byler", "Saunders", "Haag", "Dodson", "Mccorkle", "Flannery", "Lake", "Thomsen",
                   "Brantley", "Winn", "Hardman", "Regan", "Ginn", "Bernard", "Mccallum", "Haggard", "Simon", "Mooney",
                   "Luttrell", "Jasper", "Mundy", "Windsor", "Coulter", "Acker", "Duff", "Lawrence", "Mccaffrey",
                   "Gulley", "Simms", "Hull", "Thames", "Ackley", "Vanmeter", "Minter", "Worth", "Pettis", "Donaldson",
                   "Sands", "Whitmire", "Mercer", "Duffy", "Stanfield", "Gaskins", "Engel", "Lohr", "Bloom", "Barton",
                   "Teal", "Parrott", "Mandel", "Kirby", "Pope", "Klein", "Wellman", "Mcdowell", "Redding", "Hinkle",
                   "Baughman", "Quirk", "Stockwell", "Goolsby", "Blaylock", "Moe", "Seitz", "Criswell",
                   "Chandler", "Mchugh", "Almeida", "Yocum", "Fuller", "Johansen", "Rickard", "Sampson", "Sacco",
                   "Schaeffer", "Burr", "Groth", "Hand", "Trainor", "Burroughs", "Bettencourt", "Schoonover",
                   "Lockwood", "Karr", "Dupont", "Fraley", "Hermann", "Ripley", "Andrus", "Bailey", "Bosley", "Schulz",
                   "Autry", "Hess", "Simone", "Neff", "Mccracken", "Eason", "Kimball", "Redd", "Wilks", "Sams",
                   "Spicer", "Springer", "Utley", "Sumpter", "Pratt", "Fogarty", "Thornton", "Frantz", "Orth",
                   "Julian", "Laws", "Sorenson", "Piper", "Cornwell", "Whaley", "Seymour", "Hershberger", "Conner",
                   "Perrin", "Hornsby", "Hutchins", "Lafleur", "Garner", "Best", "Crain", "Mcnamara", "Sikes", "Roche",
                   "Sears", "Spears", "Shipley", "Saleh", "Parish", "Killian", "Smart", "Stewart", "Barbour", "Edgar",
                   "Brock", "Bachman", "Sheridan", "Wirth", "Copley", "Ferrara", "Preston", "Murrell",
                   "Gilliam", "Broyles", "Guinn", "Kinard", "Fischer", "Schmidt", "Harwood", "Joiner", "Battles",
                   "Mabe", "Snead", "Poulin", "Dangelo", "Tuttle", "Winter", "Seward", "Wynne", "Barron", "Goddard",
                   "Dickey", "Dyson", "Busby", "Billings", "Gamble", "Childress", "Burke", "Gilbert", "Ebert", "Funk",
                   "Bucher", "Fine", "Albright", "Baran", "Pinto", "Kirchner", "Garland", "Beatty", "Marquis", "Dupree",
                   "Pike", "Waiters", "Grubbs", "Paterson", "Rowley", "Custer", "Stockton", "Raynor", "Tate", "Guess",
                   "Deluca", "Mccloud", "Arnold", "Ridley", "Krantz", "Noyes", "Lovett", "Bolin", "Norman", "Prince",
                   "Herrin", "Bratcher", "Pickering", "Grayson", "Frye", "Lanier", "Hensley", "Crider",
                   "Wessel", "Keim", "Eggers", "Fryer", "Ennis", "Gill", "Carlson", "Bechtel", "Vogel", "Gagnon",
                   "Oleary", "Scott", "Wick", "Fiore", "Wampler", "Burt", "Bunch", "Schultz", "Stott",
                   "Mcwilliams", "Breaux", "Payne", "Hutchison", "Giese", "Hair", "Willett", "Keane", "Button",
                   "Settle", "Hedrick", "Linton", "Burrow", "Castleberry", "Ferrari", "Easterling", "Ferreira",
                   "Bertram", "Bonner", "Penrod", "Myers", "Wyatt", "Lenz", "Davis", "Bordelon", "Cleary", "Conover",
                   "Moen", "Walton", "Troyer", "Ragsdale", "Watt", "Schneider", "Vinson", "Weathers", "Bristol",
                   "Jester", "Olson", "Findley", "Watters", "Ledford", "Gerber", "Desimone", "Stowe", "Hines", "Wyman",
                   "Goode", "Harris", "Godfrey", "Dehart", "Novotny", "Heffner", "Matthews", "Crowder", "Kramer",
                   "Kendrick", "Huss", "Napier", "Kehoe", "Mcgill", "Heflin", "Moll", "Casto", "Hyland", "Beam",
                   "Gregg", "Donald", "Montgomery", "Braun", "Emerson", "Kidder", "Benton", "Petersen", "Cavanaugh",
                   "Withers", "Meade", "Furr", "Logan", "Kozak", "Clifford", "Irvine", "Packer", "Justice",
                   "Huddleston", "Dailey", "Brophy", "Riordan", "Stillwell", "Victor", "Lassiter", "Hopson", "Humphrey",
                   "Dye", "Grady", "Conte", "Dwyer", "Kaplan", "Hudgins", "Corder", "Skelton", "Ryan", "Greenlee",
                   "Keene", "Meeker", "Mullins", "Toomey", "Swartz", "Armour", "Otis", "Mcmahon", "Griffiths",
                   "Bontrager", "Marino", "Beckett", "Bernier", "Noll", "Wallis", "Schott", "Ledbetter",
                   "Earnest", "Steen", "Chestnut", "Runyon", "Ferris", "Crum", "Johnsen", "Kingston", "Silverman",
                   "Dean", "Pickard", "Hart", "Knowles", "Mcintosh", "Majors", "Ogden", "Shane", "Pool", "Krebs", "Eby",
                   "Bail", "Coats", "Solomon", "Faust", "Fahey", "Clough", "Brennan", "Field", "Stein", "Nixon",
                   "Harbin", "Sparkman", "Palm", "Abel", "Westmoreland", "Haight", "Parson", "Petty", "Lincoln",
                   "Worthington", "Gorski", "Buchholz", "Gallagher", "Kidwell", "Hoag", "Aiello", "Cherry", "Wilhite",
                   "Holly", "Noe", "Lombardo", "Laird", "Neumann", "Bourque", "Brinkman", "Slater", "Hauser", "Gee",
                   "Gillespie", "Everhart", "Hutto", "Cason", "Beil", "Sanderson", "Krieger", "Bowles", "Farr",
                   "Vandyke", "Hatfield", "Clemons", "Pearl", "Mayer", "Odom", "Ruby", "Samples", "Kiefer", "Sharpe",
                   "Barger", "Swisher", "Warner", "Cheatham", "Church", "Landis", "Whipple", "Leavitt", "Paquette",
                   "Boehm", "Coon", "Cantwell", "Marion", "Mcneil", "Bennett", "Keck", "Hartley", "Bruns",
                   "Flick", "Wray", "Cope", "Engle", "Dougherty", "Graf", "Provost", "Sharkey", "Beasley",
                   "Hyatt", "Sturgill", "Butts", "Shinn", "Barnett", "Plummer", "Hawkins", "Brooks", "Lumpkin", "Keyes",
                   "Barone", "Spalding", "Rodrigues", "Boss", "Leighton", "Rhea", "Meador", "Dube", "Woody",
                   "Mcleod", "Huebner", "Dion", "Stout", "Rogers", "Lundberg", "Adkins", "Capps", "Carrier", "Clapp",
                   "Canfield", "Fox", "Friesen", "Slone", "Doherty", "Tripp", "Thatcher", "Butterfield", "Barlow",
                   "Buckner", "Lafferty", "Stover", "Hurley", "Bull", "Drury", "Wasserman", "Hampton",
                   "Mccauley", "Landon", "Hardwick", "Beeson", "Vargo", "Fellows", "Cummings", "Swank", "Wolford",
                   "Pace", "Brunson", "Vick", "Herr", "Ingle", "Kline", "Comstock", "Honeycutt", "Holcombe", "Goad",
                   "Lehman", "Currier", "Bullock", "Hennessy", "Rau", "Forsythe", "Hatton", "Lyons", "Troy", "Ibrahim",
                   "Dowell", "Locke", "Dellinger", "Ridgeway", "Haller", "Stauffer", "Southern", "Eastman", "Shockley",
                   "Westbrook", "Savage", "Whitson", "Houser", "Dvorak", "Nelms", "Murdock", "Chase", "Fredrickson",
                   "Shumate", "Herrington", "Vogt", "Porter", "Milton", "Chester", "Champion", "Groff", "Dixon",
                   "Lemay", "Yost", "Gary", "Colson", "Arnett", "Riggins", "Merchant", "Dickson", "Carney", "Howes",
                   "Stevenson", "Haas", "Kerns", "Bader", "Cote", "Heckman", "Collett", "Falls", "Cowan",
                   "Metzger", "Thornburg", "Severson", "Olds", "Rinehart", "Kern", "Finley", "Knutson", "Nesmith",
                   "Michaud", "Michael", "Schrock", "Davenport", "Atkins", "Blake", "Hewitt", "Dutton", "Sewell",
                   "Madsen", "Foote", "Sherwood", "Coleman", "Morris", "Workman", "Gaffney", "Lapointe", "Woodcock",
                   "Stacy", "Harrelson", "Dempsey", "Prater", "Flynn", "Reichert", "Scholl", "Kiley", "Kidd", "Pyle",
                   "Walden", "Bolton", "Lorenz", "Chambers", "Hansen", "Partin", "Fraser", "Goodwin", "Fairbanks",
                   "Cloutier", "Huffman", "Billingsley", "Boyles", "Lewis", "Bates", "Crites", "Mohr",
                   "Stephens", "Marks", "Rauch", "Shell", "Venable", "Anders", "Sims", "Barrow",
                   "Breen", "Everson", "Horowitz", "Winters", "Horning", "Whitlock", "Muse", "Varner", "Zink",
                   "Mcintire", "Bliss", "Poore", "Doss", "Dagostino", "Griffin", "Hollis", "Woodbury", "Kohl",
                   "Huntington", "Ham", "Hulse", "Dykes", "Willoughby", "Strother", "Booth", "Kroll", "Garrity",
                   "Plank", "Adamson", "Craddock", "Mcginnis", "Luther", "Ernst", "Devlin", "Grigsby", "Hays",
                   "Pinkerton", "Backus", "Mclemore", "Dill", "Ellison", "Rea", "Stock", "Jeffries", "Reardon", "Blair",
                   "Graff", "Townsend", "Richardson", "Mohler", "Merritt", "Moriarty", "Fugate", "Lathrop", "Fannin",
                   "Moreau", "Layne", "Pollack", "Swope", "Waldrop", "Gale", "Justus", "Teel", "Sigler", "Moffitt",
                   "Willard", "Schumacher", "Cranford", "Wayne", "Bremer", "Landrum", "Clanton", "Durbin", "Kellogg",
                   "Braswell", "Whitehurst", "Fink", "Rupp", "Kiser", "Kovacs", "Mclain", "Lightfoot", "Hailey", "Hite",
                   "Gainey", "Roush", "Forsyth", "Paine", "Haney", "Cohen", "Swan", "Jamieson", "Thibodeau", "Hulsey",
                   "Fortune", "Kinsey", "Waddell", "Berger", "Diamond", "Ferrell", "Carnes", "Kent", "Baxley",
                   "Dombrowski", "Boudreaux", "Gaddis", "Trimble", "Monaghan", "Fazio", "Hinson", "Pederson",
                   "Sandberg", "Hembree", "Haggerty", "Gavin", "Giddens", "Mabry", "Keegan", "Foley", 
                   "Bostic", "Knudson", "Schilling", "Harless", "Pedersen", "Gore", "Blackburn", "Pellegrino", "Poland",
                   "Schell", "Cloud", "Hubert", "Beach", "Bigelow", "Siler", "Talley", "Cain", "Jonas", "Pitts",
                   "Metcalf", "Conn", "Arthur", "Currie", "Tarr", "Waterman", "Wood", "Peek", "Rutter", "Chapman",
                   "Isaac", "Carman", "Roach", "Healy", "Bickel", "Goncalves", "Altman", "Derrick", "Proctor", "Cannon",
                   "Beall", "Boyle", "Doucette", "Corwin", "Colwell", "Eaton", "Hutchings", "Morrow", "Longo", "Jaeger",
                   "Morehead", "Briscoe", "Lilly", "Chrisman", "Merrell", "Mcgrath", "Berg", "Sperry",
                   "Corley", "Denning", "Taft", "Lavigne", "Damico", "Mullis", "Crooks", "Rushing", "Hoppe", "Conti",
                   "Kesler", "Ehlers", "Holton", "Cooley", "Dallas", "Beyer", "Rigsby", "Randall", "Alcorn", "Knight",
                   "Hilliard", "Aldridge", "Joyner", "Mosier", "Bragg", "Blocker", "Ogle", "Zimmer", "Isom",
                   "Buck", "Pond", "Seal", "Hume", "Goodson", "Kilgore", "Babb", "Hoyt", "Meeks", "Keith", "Brothers",
                   "Lapp", "Underhill", "Stjohn", "Sawyer", "Bratton", "Nagy", "Sachs", "Kennedy", "Newkirk", "Hatcher",
                   "Satterfield", "Rosenthal", "Schlegel", "Thorn", "Smail", "Kilpatrick", "Koester", "Parr", "Cathey",
                   "Grabowski", "Fennell", "Amaral", "Wendt", "Sipes", "Akers", "Oneal", "Bethel", "Koehn", "Stoddard",
                   "Strickland", "Rowan", "Tilley", "Batson", "Howard", "Shore", "Gentry", "Ridge", "Brumley", "Robert",
                   "Blankenship", "Newsome", "Butler", "Blackmon", "Timm", "Tomlin", "Durant", "Rice", "Hoy", "Howell",
                   "Radford", "Cronin", "Davey", "Paul", "Bond", "Reynolds", "Bright", "Richey", "Horvath", "Moss",
                   "Hannon", "Daugherty", "Thomason", "Scanlon", "Werner", "Janssen", "Cornett", "Rawlings",
                   "Blanchette", "Storm", "Brandon", "Newcomb", "Devito", "Williamson", "Esposito", "Robinette",
                   "Sasser", "Duval", "Beale", "Trout", "Sanders", "Brink", "Pollock", "Ballard", "Gunter", "Browning",
                   "Mason", "Peak", "Gipson", "Spring", "Moreland", "Kersey", "Holm", "Hardin", "Phillips", "Sauer",
                   "Mckinney", "Ballinger", "Mahaffey", "Packard", "Scruggs", "Schnell", "Stokes", "Loving", "Kerr",
                   "Oreilly", "Ellis", "Peltier", "Christopher", "Barney", "Simpson", "Mccune", "Frazier", "Kempf",
                   "Mulder", "Mcrae", "Barnette", "Mckinnon", "Dix", "Lawton", "Farrington", "Elrod", "Roby", "Mullin",
                   "Gable", "Covert", "Kemper", "Platt", "Kemp", "Forster", "Harp", "Laster", "Piazza", "Bower",
                   "Tibbetts", "Cartwright", "Monk", "Carr", "Chamberlin", "Leggett", "Hankins", "Parnell", "Cleveland",
                   "Kistler", "Vandenberg", "Clem", "Penn", "Romine", "Begley", "Fiedler", "Trowbridge", "Koller",
                   "Mccoy", "Weir", "Thacker", "Gladden", "Appel", "Burris", "Burton", "Westfall", "Knox", "Cromer",
                   "Atwood", "Christman", "Jameson", "Kay", "Lehr", "Beaudoin", "Burden", "Harlan", "Glass", "Denny",
                   "Hawley", "Hogan", "Schmitt", "Henderson", "Lowry", "Fain", "Slack", "Batten", "Mcmichael",
                   "Elliott", "Kimmel", "Dow", "Littleton", "Norwood", "Clegg", "Harley", "Hackney", "Stubbs", "Easton",
                   "Tyree", "Correll", "Fontenot", "Levine", "Wakefield", "Albrecht", "Shade", "Purvis", "Barrett",
                   "Powell", "Clawson", "Isbell", "Hearn", "Tenney", "Wild", "Ashton", "Hunter", "Grantham", "Kirkland",
                   "Rowe", "Hopkins", "Bogart", "Crockett", "Titus", "Tracy", "Britt", "Jablonski", "Krug",
                   "Ritchie", "Beaty", "Bickford", "Graham", "Berkowitz", "Mott", "Campbell", "Stanton", "Bach",
                   "Denham", "Ewing", "Mace", "Pereira", "Shea", "Callaway", "Carlton", "Logue", "Schaefer", 
                   "Mathis", "Ostrander", "Blanton", "Carlin", "Schatz", "Kimble", "Graber", "Saxton", "Shook",
                   "Devries", "Peterson", "Glick", "Handy", "Mcgee", "Sanford", "Cade", "Hyde", "Fortier", "Hildebrand",
                   "Cornell", "Rawls", "Orourke", "Cooper", "Mccombs", "Harms", "Wilkie", "Moffett", "Harmon", "Wolf",
                   "Streeter", "Warren", "Langdon", "Ulmer", "Stiles", "Sanborn", "Krauss", "Compton",
                   "Dunham", "Moran", "Salerno", "Gould", "Vann", "Feller", "Nesbitt", "Lunsford", "Flint", "Gandy",
                   "Thornhill", "Hendrickson", "Stallings", "Matson", "Hirsch", "Chism", "Marr", "Laughlin", "Dewey",
                   "Calabrese", "Siebert", "Aaron", "Brownell", "Sweeney", "Brinkley", "Daily", "Dodd", "Carver",
                   "Malloy", "Menard", "Colvin", "Kendall", "Odell", "Correia", "Nelson", "Parisi", "Singer", "Cyr",
                   "Neel", "Peebles", "Brody", "Schwarz", "Lane", "Flanders", "Mulligan", "Burchett", "Barclay",
                   "Souza", "Caudle", "Berry", "Bohannon", "Jewell", "Culbertson", "Anderson", "Oneill",
                   "Perkins", "Landry", "Hay", "Bass", "Tobias", "Rhodes", "Costa", "Carpenter", "Keaton", "Dalton",
                   "Santoro", "Hawthorne", "Childers", "Vitale", "Peace", "Quigley", "Neil", "Hynes", "Lytle", "Robb",
                   "Kuehn", "Greenwood", "Swann", "Deaton", "Pack", "Colby", "Lawless", "Hundley", "Gillette", "Knotts",
                   "Ingalls", "Rose", "Seifert", "Harrison", "Pitt", "Spriggs", "Sisson", "Koenig", "Grice", "Cardwell",
                   "Rubin", "Meredith", "Knowlton", "Burnette", "Eaves", "Bell", "Carlisle", "Raney", "Beauchamp",
                   "Gold", "Parris", "Dodds", "Reimer", "Hammett", "Prentice", "Hein", "Ohara", "Sorrell", "Raley",
                   "Turley", "Fuchs", "Allison", "Condon", "Corcoran", "Hargis", "Covington", "Quinlan", "Langley",
                   "Kovach", "Geiger", "Gustafson", "Watts", "Wilcox", "Lerner", "Roberson", "Ferrante", "Gifford",
                   "Younger", "Mackay", "Schroeder", "Kelly", "Mchale", "Hendrick", "Maggard", "Spires", "Pfeifer",
                   "Gilmore", "Pape", "Mahoney", "Mathias", "Lacey", "Toth", "Jeffrey", "Hildreth", "Peck", "Monaco",
                   "Marlow", "Eck", "Motley", "Gay", "Coburn", "Shay", "Marsh", "Tavares", "Cassidy", "Putman",
                   "Szymanski", "Barfield", "Pearce", "Hanley", "Bland", "Okeefe", "Herbert", "Peters", "Prather",
                   "Conway", "Dunning", "Samuelson", "Rowell", "Peacock", "Flood", "Cosby", "Foster", "Vickery",
                   "Mcdermott", "Whitehead", "Fritz", "Guido", "Kraft", "Usher", "Garnett", "Crouch", "Davidson",
                   "Beal", "Pappas", "Bridges", "Geller", "Jenkins", "Rudolph", "Hyman", "Watson", "Lowman", "Roper",
                   "Pritchard", "Francis", "Burdette", "Feeney", "Monroe", "Cormier", "Boudreau", "Grossman",
                   "Mcdonnell", "Keiser", "Hannan", "Leonard", "Major", "Picard", "Whitlow", "Moon", "Hummel",
                   "Lindner", "Hamm", "Mauro", "Bird", "Branham", "Inman", "Lindsay", "Wingate", "Barry", "Fitzgerald",
                   "Womack", "Andre", "Burk", "Nunn", "Glynn", "Foss", "Rambo", "Drew", "Stearns", "Alves", "Hoskins",
                   "Mccurry", "Spear", "Barbee", "Shanahan", "Ness", "Nadeau", "Hefner", "Osborn", "Simons", "Dial",
                   "Beard", "Clifton", "Crandall", "Goble", "Hagan", "Henning", "Ambrose", "Baum", "Skaggs", "Pomeroy",
                   "Everett", "Lemieux", "Burleson", "Geer", "Whittaker", "Hayward", "Potts", "Bishop", "Vance",
                   "Sullivan", "Slade", "Mobley", "Hawes", "Drummond", "Tomlinson", "Hills", "Connell", "Steffen",
                   "Wertz", "Stinson", "Brewster", "Hemphill", "Calvert", "Stump", "Gantt", "Sizemore", "Madden",
                   "Sutherland", "Boland", "Bianco", "Hastings", "Tompkins", "Schrader", "Wyant", "Dunbar",
                   "Reitz", "Ainsworth", "Gomes", "Marler", "Elkins", "Steinberg", "Musser", "Morrison", "Houle",
                   "Kaiser", "Doyle", "Parks", "Hamlin", "Coffin", "Walter", "Stephenson", "Bowling", "Benner", "Hiatt",
                   "Vollmer", "Ives", "Marshall", "Shearer", "Rodgers", "Beardsley", "Savoy", "Joslin", "Neilson",
                   "Logsdon", "Wylie", "Coughlin", "Otoole", "Doran", "Shepherd", "Orlando", "Goldberg", "Musselman",
                   "Sides", "Fried", "Hopper", "Bronson", "Craig", "Ivey", "Maurer", "Casteel", "Landers", "Mcculloch",
                   "Lea", "Ramsay", "Schoen", "Stegall", "Kuntz", "Boettcher", "Hardison", "Siegel", "Elmore",
                   "Martens", "Goins", "Caldwell", "Crow", "Tennant", "Mathews", "Koontz", "Mclaughlin",
                   "Mcgraw", "Nagel", "Webb", "Grant", "Kraus", "Nutt", "Peyton", "Wagoner", "Brackett",
                   "Crenshaw", "Benson", "Downing", "Wilkinson", "Mueller", "Perry", "Mays", "Wolfe", "Kohn", "Huey",
                   "Vaccaro", "Hightower", "Mosher", "Ayers", "Geyer", "Plante", "Dennis", "Griggs", "Root",
                   "Fournier", "Horan", "Becker", "Carl", "Lowe", "Kitchen", "Ritter", "Turpin", "Woodruff", "Heller",
                   "Pollard", "Mann", "Reeder", "Ray", "Bryant", "Ayres", "Hooks", "Brower", "Starling", "Darnell",
                   "Griswold", "Trammell", "Willey", "Pendergrass", "Asbury", "Ammons", "Perryman", "Epperson",
                   "Duggan", "Tuck", "Nelsen", "Mayo", "Archibald", "Grimes", "Berryman", "Fontaine", "Liles",
                   "Sage", "Douglass", "Boggs", "Hostetler", "Tice", "Wynn", "Bowlin", "Boucher", "Lindsey", "Jacques",
                   "Wallace", "Talbert", "Jamison", "Templeton", "Faircloth", "Barnhart", "Faber", "Houston", "Stroup",
                   "Messer", "Joy", "Testa", "Diehl", "Barker", "Wooten", "Broderick", "Bush", "Tyler", "Arrington",
                   "Green", "Colburn", "Wicks", "Brannan", "Rush", "Crowell", "Dell", "Pennington", "Reno", "Stephen",
                   "Maxwell", "Nobles", "Bourne", "Mckay", "Kahn", "Ashby", "Creamer", "Schaffer", "Nielsen", "Newell",
                   "Mcqueen", "Link", "Sturgeon", "Greenwell", "Abrams", "Richman", "Spangler",
                   "Keating", "Shively", "Whitt", "Ratcliff", "Smoot", "Mcfarland", "Kelley", "Welch", "Angell",
                   "Avery", "Spiegel", "Yeager", "Keyser", "Hayden", "Hargrove", "Lang", "Fish", "Curtis", "Foy",
                   "Petrie", "Dunaway", "Shirk", "Caudill", "Ahern", "Ziegler", "Sheffield", "Shackelford", "Cecil",
                   "Molloy", "Haskell", "James", "Comer", "Hanna", "Bobo", "Easter", "Holloway", "Hurd", "Abell",
                   "Morey", "Mello", "Staton", "Ferguson", "Mccallister", "Nye", "Guy", "Wahl", "Mcnutt", "Shumaker",
                   "Mayfield", "Stclair", "Ackerman", "Chisholm", "Payton", "Mast", "Means", "Meyer", "Ballew", "Mahan",
                   "Noel", "Farrell", "Nemeth", "Laporte", "Furman", "Gossett", "Lankford", "Forrester", "Laplante",
                   "Krueger", "Hamel", "Benedict", "Stapleton", "Bogan", "Mowery", "Mount", "Cagle", "Mclean", "Lloyd",
                   "Ashley", "Poling", "Stacey", "Sheldon", "Beebe", "Lance", "Mccarter", "Jorgenson", "Tallman",
                   "Brogan", "Walls", "Macleod", "Rohde", "Terrell", "Eddy", "Steiner", "Egan", "Leger", "Felton",
                   "Mitchell", "Oswald", "Rouse", "Vanwinkle", "Winkler", "Freed", "Dickens", "Halvorson", "Hass",
                   "Slocum", "Mccloskey", "Overton", "Strand", "Hadley", "Pressley", "Allan", "Childs", "Grove",
                   "Kinder", "Kelsey", "Bess", "Grimm", "Chamberlain", "Dale", "Kolb", "Herrmann", "Lyon", "Heiser",
                   "Medeiros", "Damon", "Weigel", "Schuler", "Fanning", "Cromwell", "Koss", "Keen", "Irving", "Mauldin",
                   "Forte", "Ferro", "Bergman", "Bundy", "Scroggins", "Poole", "Shrader", "Richard", "Grim", "Parry",
                   "Mather", "Mixon", "Haugen", "Cutler", "Farber", "Higdon", "Swain", "Tiller", "Fishman", "Sibley",
                   "Ricci", "Pullen", "Donohue", "Elliot", "Mansfield", "Fincher", "Jolley", "Dennison", "Waltz",
                   "Mcclure", "Echols", "Tobin", "Burnham", "Abney", "Nunes", "Kane", "Sparrow", "Rausch", "Underwood",
                   "Graziano", "Johnstone", "Fisher", "Rainwater", "Youngblood", "Magee", "Osborne", "Heim",
                   "Buckingham", "Washburn", "Lefebvre", "Blevins", "Christenson", "Ash", "Bacon", "Yount", "Ratliff",
                   "Calkins", "Andersen", "Mazza", "Mulcahy", "Luke", "Steadman", "Quinn", "Loy", "Henry", "Kerrigan",
                   "Gaddy", "Dietrich", "Duke", "Mercier", "Schafer", "Bear", "Moeller", "Bedford", "Travers",
                   "Kessler", "Lindquist", "Pinkston", "Deangelis", "Buss", "Heinrich", "Segal", "Box", "Wooldridge",
                   "Schulze", "Mcmahan", "Buchanan", "Harrell", "Burks", "Pittman", "Irvin", "Doe", "Poindexter",
                   "Bagwell", "Middleton", "Fultz", "Allard", "Overstreet", "Vail", "Germain", "Lamar", "Cook",
                   "Turnbull", "Vanover", "Mcreynolds", "Scoggins", "Florence", "Sommer", "Wing", "John", "Koehler",
                   "Mahon", "Lemons", "Sapp", "Pryor", "Mcdaniels", "Ramsey", "Steward", "Devine", "Goodin", "Layton",
                   "Morton", "Scully", "Jarrett", "Calhoun", "Rupert", "Kester", "Withrow", "Skinner", "Ashworth",
                   "Nutter", "Hoke", "Cornish", "Christ", "Grissom", "Edmondson", "Martinson", "Trapp", "Charlton",
                   "Masters", "Cooke", "Frank", "Wren", "Prescott", "Schofield", "Wofford", "Wiese", "Maher",
                   "Sandlin", "Goldman", "Wiley", "Bertrand", "Coble", "Demarco", "Wolff", "Woodall", "Dobbins",
                   "Loveless", "Levin", "Loomis", "Squires", "Willis", "Bunn", "Mccabe", "Strom", "Goldsmith", "Stack",
                   "Desmond", "Hogue", "Mccain", "Crowe", "Greenwald", "Higgs", "Schuster", "Foltz", "Nicholas",
                   "German", "Christian", "Wilde", "Hauck", "Schubert", "Kirkwood", "Forrest", "Farris",
                   "Vieira", "Strong", "Nowak", "Schwartz", "Upchurch", "Donahue", "Phipps", "Webber", "Stafford",
                   "Wenger", "Seay", "Haddock", "Mcgrew", "Betts", "Stoner", "Coyne", "Swearingen", "Angelo",
                   "Reid", "Page", "Duckett", "Free", "Hammonds", "Zook", "Jeffers", "Boyd", "Cullen", "Snow",
                   "Flanigan", "Dewitt", "Fontana", "Vaughan", "Frost", "Stutzman", "Talbott", "Humphries", "Doane",
                   "Driscoll", "Biggs", "Wiggins", "Cone", "Levi", "Knott", "Chappell", "Dudley", "Nagle", "Howe",
                   "Binder", "Ellsworth", "Lyman", "Shifflett", "Hallman", "Keefer", "Collier", "Slagle", "Staley",
                   "Burkhart", "Gorman", "Hitchcock", "Haddad", "Stpierre", "Burney", "Goodman", "Lister", "Devore",
                   "Oneil", "Canady", "Hebert", "Kearney", "Wisniewski", "Browne", "Smalley", "Johns", "Gaither",
                   "Weber", "Horst", "Rand", "Spencer", "Schlosser", "Dalrymple", "Gibbs", "Harry", "Silvers", "Abbott",
                   "Edmonds", "Sarver", "Wiles", "Buckley", "Rader", "Weidner", "Hennessey", "Jacob", "Homan",
                   "Mcclellan", "Haskins", "Mcfarlane", "Hardesty", "Noonan", "Waugh", "Curry", "Mark", "Knapp",
                   "Hickman", "Szabo", "Keeney", "Clayton", "Murray", "Herndon", "Gabel", "Harden", "Baer", "Beckwith",
                   "Looney", "Hamblin", "Stern", "Mcdaniel", "Raber", "Elam", "Mcadams", "Duvall", "Fries", "Coates",
                   "Wilder", "Dooley", "Sell", "Couch", "Heinz", "Crook", "Couture", "Maas", "Bunker", "Lewandowski",
                   "Giordano", "Maguire", "Hawk", "Budd", "Mariano", "Zimmerman", "Smallwood", "Abraham",
                   "Soper", "Henson", "Parrish", "Akin", "Dugger", "Sisk", "Lentz", "Hiller", "Timmons", "Freedman",
                   "Mccreary", "Mcfall", "Creel", "Comeaux", "Babcock", "Freund", "Simonson", "Lester", "Kopp",
                   "Soares", "Jensen", "Voigt", "Catalano", "Denton", "Coffey", "Finney", "Todd", "Haley", "Norris",
                   "Omalley", "Bauman", "Orr", "Maples", "Fike", "Hobbs", "Earle", "Ladner", "Hutchens", "Vaughn",
                   "Klinger", "Ulrich", "Guest", "Bullard", "Forbes", "Wilbanks", "Newland", "Kauffman", "Guthrie",
                   "Whitney", "Sharp", "Piatt", "Almond", "Bartels", "Wall", "Brent", "Brush", "Fairchild", "Berman",
                   "Mcnulty", "Langer", "Culp", "Milligan", "Behrens", "Dees", "Giles", "Ostrowski", "Morelli",
                   "Herman", "Freeland", "Volk", "Agee", "Spooner", "Mcintyre", "Teague", "Helms", "Raymond", "Daniels",
                   "Manson", "Hicks", "Addison", "Irons", "Newsom", "Sommers", "Spence", "Bowser", "Rapp", "Maynard",
                   "Mccullough", "Oakes", "Dowdy", "Manuel", "Battaglia", "Bean", "Padgett", "Shields", "Coy", "Getz",
                   "Ouellette", "Pruett", "Knudsen", "Webster", "Sheehan", "Kelso", "Danielson", "Moyer", "Ashcraft",
                   "Sparks", "Tremblay", "Nall", "Carvalho", "Grooms", "Decker", "Qualls", "Hudson", "Fulton", "Curran",
                   "Robbins", "Hollingsworth", "Danner", "Stratton", "Martino", "Dionne", "Garvey", "Saxon", "Gage",
                   "Busch", "Driggers", "Evangelista", "Rhoades", "Kearns", "Kohler", "Messina", "Mattingly", "Lemon",
                   "Welborn", "Branson", "Dugan", "Humphreys", "Betz", "Mcclung", "Tidwell", "Noble", "Damato",
                   "Connolly", "Braden", "Guffey", "Millar", "Clevenger", "Pierce", "Bergstrom", "Davies", "Austin",
                   "Burkholder", "Burkhardt", "Craft", "Hofmann", "Cary", "Price", "Mattison", "Darby", "Reinhardt",
                   "Parsons", "Epstein", "Starkey", "Flaherty", "Poirier", "Hendrix", "Harding", "Duncan", "Reese",
                   "Mcdougal", "Shuman", "Spivey", "Nichols", "Kelleher", "Dotson", "George", "Thorson", "Weis",
                   "Snodgrass", "Lowell", "Dillard", "Herring", "Sutter", "Fallon", "Marcum", "Castle", "Sterling",
                   "Bounds", "Wetzel", "Hutchinson", "Gingerich", "Oldham", "Fulmer", "Bradley", "Rees", "Galloway",
                   "Amundson", "Merriman", "Levy", "Chitwood", "Jewett", "Gallo", "Kirkpatrick", "Cruse", "Hinds",
                   "Hazen", "Rosenberg", "Jenson", "Caswell", "Burge", "Wagner", "Kaufman", "Latham", "Rosenbaum",
                   "Davison", "Girard", "Weaver", "Batchelor", "Hochstetler", "Clarke", "Allen", "Rudy", "Pfeiffer",
                   "Leahy", "Mcdonald", "Mchenry", "Lear", "Spradlin", "Bearden", "Napolitano", "Meadows", "Nolen",
                   "Cunningham", "Cameron", "Hammons", "Terry", "Ault", "Gentile", "Upton", "Foust", "Sturm",
                   "Sebastian", "Taggart", "Gardiner", "Daniel", "Conroy", "Stanford", "Brandt", "Hatch", "Trahan",
                   "Blythe", "Connelly", "Brant", "Champagne", "Nation", "Hylton", "Farnsworth", "Maness", "Huber",
                   "Richter", "Crisp", "Meister", "Frasier", "Evans", "Metz", "Easley", "Burchfield", "Parker",
                   "Michaels", "Tully", "Jacoby", "Dawson", "Spaulding", "Thurston", "Draper", "Randazzo", "Shelley",
                   "Caron", "Shafer", "Bender", "Neuman", "Dias", "Doty", "Atwell", "Carnahan", "Mcmanus", "Mayhew",
                   "Reiss", "Schramm", "Mazur", "Cousins", "Mullen", "Riddle", "Harwell", "Sayre", "Cochran", "Popp",
                   "Curley", "Lopes", "Breeden", "Maxey", "Burch", "Pence", "Bowman", "Finnegan", "Cheney", "Bateman",
                   "Crouse", "Block", "Lynn", "Wade", "Kuhns", "Osburn", "Krause", "Storey", "Suggs", "Leach",
                   "Levesque", "Jennings", "Martin", "Burns", "Jeffery", "Jolly", "Smith", "Rafferty", "Karl",
                   "Wilhelm", "Greenfield", "Vaught", "Lombardi", "Crowley", "Franz", "Stahl", "Tipton", "Dunn",
                   "Shultz", "Gunderson", "Kraemer", "Folsom", "Vines", "Coker", "Weimer", "Ralph", "Lawler", "Fortin",
                   "Obrien", "Morin", "Delaney", "Brill", "Matheson", "Gall", "Travis", "Conklin", "Freeman",
                   "Naylor", "Peeples", "Wallin", "Eubanks", "Covey", "Urban", "Hartman", "Dexter", "Oliver",
                   "Thrasher", "Russ", "Holden", "Coggins", "Yancey", "Cash", "Bouchard", "Robinson", "Christiansen",
                   "Zeller", "Godwin", "Durkin", "Helton", "Brown", "Kowalski", "Baumann", "Broome", "Garris",
                   "Kissinger", "Nickel", "Hammock", "Cole", "Dent", "Salmon", "Hester", "Luce", "Olsen", "Grace",
                   "Vernon", "Worden", "Woodard", "Malone", "Hood", "Pettit", "Ervin", "Forman", "Caruso", "Akins",
                   "Steed", "Hamrick", "Tillery", "Nail", "Fowler", "Bare", "Dobson", "Moody", "Leo", "Sykes", "Elder",
                   "Novak", "Massie", "Yager", "Demers", "Thiel", "Chapin", "Bartlett", "Mclendon", "Bobbitt", "Hook",
                   "Lindstrom", "Lockhart", "Dolan", "Baker", "Katz", "Goetz", "Frey", "Branch", "Patrick", 
                   "Kaye", "Shores", "Mcewen", "Vest", "Kirsch", "Lieberman", "Dupuis", "Lyle", "Waggoner", "Faulk",
                   "Pemberton", "Coe", "Sloan", "Hinton", "Mock", "Swenson", "Dykstra", "Strauss", "Coombs", "Darling",
                   "Mcfadden", "Derosa", "Hilton", "Clinton", "Dorman", "Smiley", "Jankowski", "Strunk", "Mccool",
                   "Bristow", "Dowling", "Dasilva", "Molnar", "Kinney", "Murry", "Kruse", "Pfaff", "Kunz", "Dyer",
                   "Harkins"]}

black_names = {
    "first_names": ["Chambliss", "Beason", "Harold", "Dortch", "Mccalla", "Eley", "Liggins", "Cuffee", "Tesfaye",
                    "Caruthers", "Bilal", "Sheriff", "Dorsett", "Kaylin", "Asia", "Savannah", "Ezekiel", "Ishmael",
                    "Lauren", "Joy", "Leah", "Fanta", "Hope", "Tyler", "Kayden", "Paige", "Tori", "Mohamed", "Ariyah",
                    "Jason", "Michael", "Taylor", "Elise", "Blake", "Stephen", "Maxwell", "Samiyah", "Ibrahima",
                    "Mohammed", "Aicha", "Ava", "Harper", "Dwayne", "Abdul", "Wynter", "Lily", "Empress", "Zaniyah",
                    "Kevin", "Jaxson", "Amara", "Jace", "Dream", "Deborah", "Kyle", "Samara", "Avery", "Xavier",
                    "Zamir", "Marc", "David", "Hayden", "Kennedi", "Jasiah", "Janiyah", "Myles", "Bryan", "Zahir",
                    "Ousmane", "Jada", "Legend", "Amina", "Alexis", "Lorenzo", "Kyrie", "James", "Jewel", "Jasmine",
                    "Nolan", "Tiana", "Isis", "Jalen", "Anaya", "Royce", "Samantha", "Nathan", "Precious",
                    "Payton", "Gianni", "Mariah", "Chelsea", "Trinity", "Timothy", "Anthony", "Noel", "Ezra", "Nala",
                    "Seth", "Harmony", "Gianna", "Kaylani", "Jayda", "Calvin", "Kamiyah", "Jared", "Phoenix", "Kymani",
                    "Egypt", "Sarah", "Ameer", "Jayla", "Ashley", "Evan", "Bryson", "Kristian", "Zhuri", "Aria",
                    "Terrell", "Bryce", "Sekou", "Esther", "Nigel", "Nova", "Heavenly", "Janiya", "Royalty",
                    "Eric", "Maison", "Jamir", "Aissata", "Amaya", "Messiah", "Kelsey", "Adonis",
                    "Sapphire", "Lucas", "Musa", "Arya", "Hailey", "Zuri", "Joel", "Tristan", "Amar'e", "Malaysia",
                    "Brian", "Amora", "Alijah", "Andrew", "Dominic", "Devin", "Jaheim", "Kimora", "William", "Jaxon",
                    "Maryam", "Kourtney", "Alvin", "Khadija", "Richard", "Sevyn", "Owen", "Kamari", "Gavin", "Amiyah",
                    "Antonio", "Hassan", "Abdoulaye", "Tamia", "Amirah", "Abdoul", "Zaiden", "Alani", "Jonas", "Skylar",
                    "Arielle", "Dominick", "Ella", "Isaac", "Amira", "Kenneth", "Derrick", "Makhi", "Maya", "Luke",
                    "Madison", "Amiya", "Henry", "Mckenzie", "Kaleb", "Gabriel", "Princess", "Madisyn", "Kyree",
                    "Jaylin", "Khalil", "Journey", "Sanaa", "Gregory", "Serenity", "Khloe", "Leon", "Amber", "Lamar",
                    "Dallas", "Zoey", "Mackenzie", "John", "Kenzo", "Micah", "Malachi", "Alpha", "Carmelo", "Nalani",
                    "Nathaniel", "Emmanuel", "Caiden", "Laila", "Aliyah", "Adrian", "Keith", "Carter", "Amani",
                    "Scarlett", "Olivia", "Jahmir", "Miracle", "Kennedy", "Angel", "Aurora", "Demi", "Azaria", "Zariah",
                    "Jaliyah", "Justin", "Omar", "Ariel", "Azariah", "Dakota", "Nana", "Milani", "Nicholas", "Robert",
                    "Kiara", "Christian", "Saint", "Aissatou", "Adrianna", "Zayden", "Amare", "Vanessa", "Ricardo",
                    "Paul", "Ethan", "Nadia", "Samuel", "Gabriella", "Stephanie", "Amia", "Lillian", "Hawa", "Brandon",
                    "Morgan", "Alana", "Janelle", "Sanai", "Ariella", "Shayla", "Zion", "Destiny", "Levi",
                    "Aden", "Mila", "Maliyah", "Camden", "Saige", "Mason", "Eden", "Alyssa", "Ahmed", "Steven", "Devon",
                    "Sophia", "Celine", "Judah", "Kadiatou", "Emmanuella", "Symphony", "Kai", "Christopher", "Kenzie",
                    "Lauryn", "Joshua", "Armani", "Jordyn", "Malia", "Kylee", "Edward", "Nicolas", "Soraya", "Amir",
                    "Mamadou", "Kamren", "Mouhamed", "Jacob", "Awa", "Mark", "Corey", "Isabella", "Thomas", "Londyn",
                    "Connor", "Khari", "Carson", "Rylee", "Imani", "Zane", "Nehemiah", "Megan", "Moussa", "Taliyah",
                    "Elijah", "Skyla", "Yara", "Elias", "Alexander", "Zachary", "Abraham", "Chloe", "Chanel", 
                    "Eliana", "Ace", "Raphael", "Karter", "Jamari", "Skyler", "Hunter", "Nazir", "Ashton",
                    "Adam", "Taraji", "Kameron", "Makenzie", "Kiyan", "Janae", "Jaden", "Natalia", "Erin", "Aubree",
                    "Shaniya", "Nahla", "Chace", "Mahamadou", "Zyaire", "Nasir", "Jesse", "Kaiden", "Jonah", "Sienna",
                    "Angelina", "Layla", "Cali", "Zora", "Nevaeh", "Skye", "Ariah", "Alexa", "Khaleesi", "Bailey",
                    "Jayceon", "Simone", "Nyla", "Damani", "Sarai", "Sariah", "Alicia", "Lailah", "Rebecca", "Jessica",
                    "Kristen", "Julian", "Charlotte", "Julius", "Essence", "Muhammad", "Brooklyn", "Addison",
                    "Nathanael", "Alexandra", "Naomi", "Sariyah", "Marley", "Brooke", "Oumar", "Aaron", "Shiloh",
                    "Summer", "Aniyah", "Maimouna", "Saniyah", "Jermaine", "Kaden", "Preston", "Isaiah", "Donovan",
                    "Jackson", "Winter", "Kori", "Terrence", "Aubrey", "Jaylen", "Quincy", "Talia", "Amari", "Genesis",
                    "Marquis", "Aboubacar", "Matthew", "Kaliyah", "Amayah", "Kali", "Dylan", "Liam", "Ayden",
                    "Austin", "Darren", "Nia", "Cheyenne", "Prince", "Grayson", "Isabelle", "Brayden", "Greyson",
                    "Aiden", "Nylah", "Tabitha", "Elizabeth", "Thierno", "Brianna", "Aminata", "George", "Giovanni",
                    "Emma", "Amadou", "Shawn", "Zoe", "Zendaya", "Lyric", "Julia", "Isiah", "Wyatt", "Amanda", "Damari",
                    "Tianna", "Milan", "Bradley", "Audrey", "Dior", "Natalie", "Orion", "Mariama", "Samiya",
                    "Kareem", "Cassidy", "Boubacar", "Melanie", "Leila", "Blessing", "Aaliyah", "Shania", "Danielle",
                    "Jaiden", "Kalani", "Cameron", "Ali", "Jeremiah", "Logan", "Maurice", "Riley", "Daniel",
                    "Jamar", "Brielle", "Justice", "Penelope", "Sebastian", "Alexandria", "Luna", "Ian", "Violet",
                    "Victor", "Darius", "Mya", "Cody", "Camren", "Eli", "Michelle", "Ryan", "Oumou", "Marcus", "Samir",
                    "Rachel", "Nailah", "Mekhi", "Zaire", "Jade", "Major", "Makai", "Zahara", "Aidan", "Ermias",
                    "Aniya", "Caleb", "Jayden", "Andre", "Kingston", "Rodney", "Roman", "Shane", "Mia", "Solomon",
                    "Asher", "Zaria", "Hannah", "Kailee", "Bria", "Abigail", "Arianna", "Sofia", "Mikayla", "Emani",
                    "Omari", "Camille", "Gia", "Chris", "Bella", "Saniya", "Sydney", "Zachariah", "Maximus", "Abrielle",
                    "Giselle", "Zainab", "Annabelle", "Jelani", "Kyro", "Kenya", "Kehlani", "Jamel", "Travis", "Ismael",
                    "Jonathan", "Bintou", "Sean", "Jordan", "Kylie", "Yusuf", "Kayla", "Gabrielle", "Kyla",
                    "Kairo", "Khadijah", "Ariana", "Fatoumata", "Emily", "Jabari", "Grace", "Victoria", "Jayce",
                    "Aisha", "Alex", "Joseph", "Fatou", "Josiah", "Sasha", "Benjamin", "Mariam", "Leo", "Chad", "Noah",
                    "Landon", "Autumn", "Peyton", "Reign", "Jayson", "Caden", "Makayla", "Patrick", "Princeton", "Zara",
                    "King", "Savion", "Charles", "Sade", "Amelia", "Troy", "Ibrahim", "Skylah", "Kaylee", "Athena",
                    "Christina", "Zahra", "Cayden", "Jamal", "Journee", "Melody", "Ayanna", "Leilani", "Heaven",
                    "Kendra", "Fatima", "Chase", "Malcolm", "Malik"],
    "last_names": ["Mimms", "Feaster", "Goodwyn", "Lofton", "Mckinnie", "Goldsby", "Govan", "Littlejohn", "Tookes",
                   "Mcgary", "Steptoe", "Drakes", "Marrow", "Danzy", "Yearby", "Kindred", "Upshaw", "Randle", "Abram",
                   "Oliphant", "Mcclean", "Guillaume", "Brewington", "Bowie", "Townsel", "Mohamud", "Waddy", "Fells",
                   "Wynter", "Luckett", "Beaubrun", "Sayles", "Prophet", "Swaby", "Dabney", "Myles", "Ba", "Leaks",
                   "Dacosta", "Mcmillian", "Napper", "Knighten", "Dunigan", "Saffold", "Carruthers", "Knighton",
                   "Purifoy", "Turay", "Woodhouse", "Alston", "Manns", "Olive", "Ulysse", "Fortson", "Olivier",
                   "Harvell", "Fludd", "Brim", "Ligon", "Phoenix", "Wimbush", "Brathwaite", "Dade", "Callender",
                   "Sills", "Brayboy", "Lightner", "Kamau", "Jimmerson", "Mcnair", "Varnado", "Dugas", "Georges",
                   "Brockington", "Opoku", "Spell", "Fenderson", "Balogun", "Jiles", "Reddick", "Purnell", "Saddler",
                   "Peavy", "Fulmore", "Devaughn", "Ofori", "Christmas", "Whitfield", "Hassan", "Deans", "Murph",
                   "Francois", "Dozier", "Camper", "Starks", "Coulibaly", "Garth", "Kates", "Threatt", "Mickle",
                   "Simmonds", "Gleaton", "Mcghee", "Pender", "Mitchem", "Augustus", "Ebanks", "Pegram", "Chinn",
                   "Zackery", "Desta", "Howze", "Beamon", "Peterkin", "Sealey", "Ceasar", "Marable", "Rhone",
                   "Kittrell", "Binion", "Cofer", "Eaddy", "Mcelveen", "Treadwell", "Nathaniel", "Bias", "Braggs",
                   "Emmanuel", "Okeke", "Gholston", "Agyemang", "Mumford", "Nabors", "Rascoe", "Hatten", "Mincey",
                   "Hagins", "Estime", "Tyus", "Horsey", "Mahone", "Crayton", "Braxton", "Lett", "Singletary",
                   "Lampkin", "Teasley", "Fant", "Nur", "Sharif", "Bufford", "Mcgruder", "Gethers", "Benbow", "Abner",
                   "Hagos", "Crumpton", "Granberry", "Ashford", "Rumph", "Sturgis", "Tekle", "Rideaux", "Seldon",
                   "Tart", "Barner", "Fenwick", "Ferdinand", "Powe", "Obryant", "Gerald", "Metoyer", "Amerson",
                   "Appling", "Rosemond", "Samuels", "Rochester", "Hamer", "Duplessis", "Pledger", "Paschal", "Bester",
                   "Mcneal", "Flakes", "Edward", "Claxton", "Tharpe", "Word", "Leake", "Leverett", "Mccrea", "Spells",
                   "Batiste", "Woodson", "Twitty", "Toombs", "Jerry", "Bridgewater", "Lathan", "Conyers", "Louissaint",
                   "Rembert", "Warsame", "Rome", "Desir", "Woolfolk", "Pitre", "Forney", "Sonnier", "Hughley",
                   "Eskridge", "Lamour", "Leftwich", "Ollison", "Vasser", "Ester", "Scales", "Trice", "Cheeks",
                   "Tolson", "Feagin", "Leflore", "Fowlkes", "Tolliver", "Stribling", "Gowdy", "Boney", "Pridgen",
                   "Nero", "Jemison", "Cesar", "Dew", "Haynie", "Hagler", "Bannerman", "Colston", "Meekins", "Abdalla",
                   "Destin", "Okoye", "Tutt", "Mcclary", "Armstead", "Battiste", "Hogans", "Cureton", "Shephard",
                   "Silas", "Glaze", "Kaba", "Broomfield", "Gillum", "Seabrook", "Blanding", "Dunston", "Mallard",
                   "Boler", "Gaye", "Choice", "Pete", "Strozier", "Torain", "Aikens", "Pinnock", "Duren", "Halliburton",
                   "Grimsley", "Kanu", "Ellerbe", "Raiford", "Footman", "Staten", "Askew", "Capers", "Caffey",
                   "Eddings", "Kizer", "Stfleur", "Mccollough", "Karim", "Blackshear", "Headen", "Chatman",
                   "Desrosiers", "Fortenberry", "Hughey", "Gumbs", "Brickhouse", "Milan", "Gourdine", "Engram", "Lubin",
                   "Sumler", "Pettway", "Funchess", "Criss", "Seawright", "Speaks", "Grier", "Abercrombie", "Caine",
                   "Hilaire", "Roquemore", "Squire", "Scaife", "Carothers", "Mckoy", "Dixson", "Larkins", "Bruton",
                   "Hadnot", "Blakes", "Noor", "Stoudemire", "Kornegay", "Hurdle", "Hoard", "Donnell", "Adjei",
                   "Revels", "Parchment", "Peake", "Sawyers", "Glasper", "Rosier", "Rooks", "Harvin", "Prosper",
                   "Calloway", "Gaillard", "Moncrief", "Kellam", "Dendy", "Barnwell", "Benford", "Dones", "Springfield",
                   "Tarpley", "Demps", "Seales", "Roebuck", "Caston", "Zanders", "Jama", "Crossley", "Antoine",
                   "Crumbley", "Napoleon", "Hassell", "Sesay", "Nickson", "Sthilaire", "Blakeney", "Barksdale",
                   "Crudup", "Bethea", "Peoples", "Portis", "Westley", "Joseph", "Turnage", "Pipkins", "Keita",
                   "Auguste", "Hamlett", "Asare", "Dossantos", "Lomax", "Coney", "Osei", "Harewood", "Lauderdale",
                   "Desouza", "Holbert", "Spates", "Ogletree", "Gayle", "Hibbert", "Stlouis", "Knuckles", "Cooks",
                   "Gaspard", "Boulware", "Altidor", "Bynoe", "Casseus", "Gelin", "Antwi", "Roane", "Harrigan",
                   "Bozeman", "Burrage", "Joubert", "Rene", "Braziel", "Mohamed", "Boozer", "Broadnax", 
                   "Exantus", "Tynes", "Beckford", "Streater", "Pearsall", "Fears", "Abdi", "Owusu", "Dieujuste",
                   "Lark", "Hewlett", "Jessie", "Bobb", "Vaughns", "Croom", "Yancy", "Marc", "Merriweather", "Sidney",
                   "Spikes", "Kimber", "Weekes", "Fluker", "Jarmon", "Alexis", "Richburg", "Kamara", "Ruffin", "Bembry",
                   "Somerville", "Swinson", "Barthelemy", "Primus", "Koger", "Millender", "Getachew", "Bolling",
                   "Virgil", "Paulk", "Cobbs", "Abdullah", "Prejean", "Colter", "Salomon", "Satchell", "Steverson",
                   "Holliman", "Horsley", "Odum", "Brigham", "Cousin", "Galbreath", "Durr", "Gadsden", "Mcbean",
                   "Heard", "Enoch", "Fobbs", "Granderson", "Duhon", "Stampley", "Caraway", "Quarles",
                   "Holness", "Musa", "Spinks", "Stanback", "Hickmon", "Hedgepeth", "Pankey", "Haughton", "Suber",
                   "Belizaire", "Chisolm", "Saintil", "Assefa", "Hepburn", "Hunte", "Mikell", "Bouldin", "Avant",
                   "Wilmore", "Culbreath", "Adebayo", "Mcclendon", "Flemming", "Scriven", "Searles", "Alphonse",
                   "Tanksley", "Morant", "Breland", "Millen", "Nembhard", "Elmi", "Phillip", "Mcfarlin", "Mouzon",
                   "Talton", "Tellis", "Ivery", "Mccrae", "Lindo", "Banner", "Darden", "Myrie", "Dejean", "Traore",
                   "Mckie", "Kimbrough", "Bethune", "Bettis", "Hardaway", "Maxie", "Woodland", "Longmire", "Hankerson",
                   "Corbitt", "Tyner", "Suttles", "Fofana", "Guilford", "Ladson", "Diggs", "Gant", "Scarlett",
                   "Goodridge", "Saintlouis", "Moten", "Pernell", "Ghee", "Lawhorn", "Farquharson", "Burse", "Peeler",
                   "Surratt", "Garmon", "Leday", "Orange", "Moorer", "Lattimore", "Cargill", "Cottman", "Pough",
                   "Laing", "Lockett", "Macon", "Pinder", "Vital", "Gwynn", "Copper", "Urquhart", "Chalmers", "Gaynor",
                   "Swinton", "Booker", "Peppers", "Saintfleur", "Celestine", "Stjean", "Wiltshire", "Eady", "Thrower",
                   "Goree", "Salley", "Tulloch", "Core", "Outlaw", "Tims", "Judkins", "Joshua", "Winbush", "Profit",
                   "Earls", "Hypolite", "Holsey", "Yeboah", "Sumter", "Groce", "Jeanjacques", "Maiden",
                   "Jamerson", "Bonaparte", "Clinkscales", "Hagood", "Bolden", "Gallman", "Casimir", "Minnis",
                   "Edmunds", "Blassingame", "Dilworth", "Faustin", "Munford", "Jeanbaptiste", "Kassa", "Celestin",
                   "Zachary", "Toussaint", "Fulcher", "Chevalier", "Diallo", "Ollie", "Raphael", "Kennard", "Latimore",
                   "Doctor", "Baskerville", "Tribble", "Toomer", "Sauls", "Funches", "Youmans", "Spruill", "Griffen",
                   "Lampkins", "Jules", "Tilghman", "Williams", "Emory", "Cauley", "Sabb", "Stackhouse", "Bellard",
                   "Gustave", "Westbrooks", "Doucet", "Brister", "Nickens", "Hairston", "Jeanphilippe", "Wadley",
                   "Grate", "Gilmer", "Wash", "Gambrell", "Mims", "Mallett", "Innocent", "Muhammad", "Mouton",
                   "Zachery", "Moye", "Nowell", "Quarterman", "Monteiro", "Humes", "Jackson", "Plowden", "Cisse",
                   "Furlow", "Lucien", "Lyles", "Salters", "Rasberry", "Lamothe", "Dangerfield", "Pye", "Yearwood",
                   "Goines", "Ferebee", "Bluford", "Wardlaw", "Windom", "Pounds", "Grisby", "Kearse", "Clayborne",
                   "Carmouche", "Leverette", "Witcher", "Gause", "Porterfield", "Lampley", "Baptist", "Peay",
                   "Elie", "Gladney", "Shoulders", "Downer", "Veasley", "Citizen", "Cauthen", "Byron", "Pouncy",
                   "Coachman", "Sumlin", "Edmond", "Romain", "Dancy", "Wilbert", "Bah", "Facey", "Whigham", "Rufus",
                   "Frierson", "Mondesir", "Mccray", "Boxley", "Carty", "Dunson", "Stepney", "Loggins", "Ceesay",
                   "Zeno", "Hollins", "Bickham", "Hardeman", "Cotten", "Mcadoo", "Ndiaye", "Goodlow", "Batts",
                   "Mcswain", "Wellington", "Denson", "Watlington", "Priester", "Chiles", "Edison", "Gravely",
                   "Horace", "Kindle", "Dismuke", "Philip", "Bacchus", "Mingo", "Pinkard", "Mangrum", "Mickles",
                   "Mazyck", "Gatson", "Eaglin", "Toliver", "Alemu", "Melson", "Keels", "Denis", "Goggins", "Regis",
                   "Belgrave", "Palmore", "Kargbo", "Claiborne", "Mustafa", "Bashir", "Cooksey", "Victorian", "Bent",
                   "Mensah", "Boutte", "Belton", "Hargett", "Adeyemi", "Tunstall", "Yusuf", "Gayles", "Foxworth",
                   "Njoroge", "Pierre", "Peele", "Maynor", "Munroe", "Maina", "Penson", "Loftin", "Gaymon", "Wesley",
                   "Berhe", "Board", "Mcbeth", "Ebron", "Twyman", "Buford", "Bey", "Lakes", "Flournoy", "Warrick",
                   "Farah", "Render", "Ricks", "Hemingway", "Ealy", "Holifield", "Hardrick", "Spraggins", "Macklin",
                   "Laurent", "Finklea", "Partee", "Brutus", "Burrus", "Applewhite", "Mccrimmon", "Mcphail", "Mckinzie",
                   "Mosely", "Narcisse", "Troupe", "Biggers", "Days", "Deshields", "Vanburen", "Hartfield",
                   "Caver", "Wigfall", "Riles", "Mebane", "Gallimore", "Stallworth", "Baylor", "Pettaway", "Deloatch",
                   "Watley", "Paige", "Roney", "Jason", "Welcome", "Nwankwo", "Foxx", "Blanks", "Stennis", "Goods",
                   "Barrie", "Swanigan", "Gammage", "Dandridge", "Amey", "Gilkey", "Fordham", "Hollowell", "Armand",
                   "Mack", "Delk", "Moton", "Birdsong", "Mcmiller", "Erving", "Mayers", "Artis", "Stenson", "Pelzer",
                   "Reliford", "Jeanlouis", "Boykin", "Holloman", "Bridgeforth", "Mickens", "Lafrance", "Spann",
                   "Royster", "Philippe", "Worthy", "Benn", "Rankins", "Rountree", "Bekele", "Granville", "Addo",
                   "Sain", "Tull", "Blakley", "Bracy", "Rabb", "Gholson", "Kitt", "Debose", "Cuyler", "Belk",
                   "Dominique", "Chenault", "Henton", "Mccutchen", "Rockett", "Hinnant", "Brewton", "Deloney", "Mapp",
                   "Essex", "Mayweather", "Negash", "Baltimore", "William", "Bost", "Mcelrath", "Chery", "Rorie",
                   "Hickerson", "Stringfellow", "Crittendon", "Haji", "Mckissick", "Rone", "Jeanty", "Speller",
                   "Cofield", "Leath", "Bunton", "Foye", "Pascal", "Richie", "Goosby", "Sow", "Southall", "Ousley",
                   "Shorter", "Rutland", "Dublin", "Prophete", "Broom", "Grissett", "Roseboro", "Melancon", "Geter",
                   "Marcelin", "Constant", "Beyene", "Latson", "Ceaser", "Mclin", "Kennon", "Phifer",
                   "Bolds", "Jasmin", "Lafayette", "Catchings", "Singleton", "Cottingham", "Metayer", "Depina",
                   "Ardoin", "Spiller", "Totten", "Moultrie", "Godbolt", "Keitt", "Conwell", "Vassell", "Omar",
                   "Everette", "Daughtry", "Rashid", "Rivers", "Norfleet", "Trawick", "Ewell", "Acheampong", "Heron",
                   "Severe", "Legette", "Janvier", "Haye", "Mcnealy", "Surles", "Bartee", "Drayton", "Maclin",
                   "Yohannes", "Beauford", "Ransome", "Kershaw", "Nwosu", "Mccullum", "Kenner", "Guerrier", "Aden",
                   "Acklin", "Fielder", "Rhoden", "Winston", "Ravenell", "Porch", "Alleyne", "Adan", "Toles",
                   "Abdullahi", "Golston", "Jelks", "Riddick", "Mines", "Faison", "Lesane", "Magwood", "Millner",
                   "Cumberbatch", "Buggs", "Thiam", "Hartsfield", "Jeune", "Speight", "Frimpong", "Muldrow", "Gainer",
                   "Gallon", "Dewberry", "Patillo", "Goodrum", "Mcmillon", "Abebe", "Hussein", "Shavers", "Barham",
                   "Rozier", "Colquitt", "Buie", "Haywood", "Jordon", "Malveaux", "Swint", "Mike", "Triggs", "Charity",
                   "Flemings", "Haile", "Mciver", "Denmark", "Ivory", "Belser", "Coward", "Forest", "Doby", "Lipsey",
                   "Arceneaux", "Wingfield", "Mansaray", "Bellinger", "Mwangi", "Lillard", "Kimani", "Eugene",
                   "Lockridge", "Drakeford", "Hollie", "Coles", "Barefield", "Ducksworth", "Etienne", "Rounds", "Herd",
                   "Gilyard", "Mccants", "Mclaurin", "Luckey", "Nowlin", "Pryce", "Boddie", "Coaxum", "Gordan",
                   "Asamoah", "Strachan", "Ledet", "Majette", "Mccowan", "Garnes", "Shumpert", "Brisco", "Winfield",
                   "Pitchford", "Wiltz", "Spearman", "Woolridge", "Stitt", "Koonce", "Tarver", "Nevels", "Bivins",
                   "Barley", "Esters", "Sealy", "Forde", "Mcclinton", "Toure", "Sangster", "Marcellus",
                   "Pipkin", "Kebede", "Cadet", "Postell", "Matthew", "Windley", "Hymes", "Senegal", "Fearon",
                   "Medlock", "Ginyard", "Boykins", "Baines", "Bowe", "Nunnally", "Ismail", "Thompkins", "Winder",
                   "Coston", "Jeancharles", "Mathieu", "Lockley", "Tabron", "Gatling", "Gooden", "Edgerton", "Square",
                   "Parham", "Whetstone", "Burrell", "Purdie", "Gittens", "Gathers", "Elston", "Pullins", "Straughter",
                   "Bing", "Simien", "Appiah", "Walcott", "Mekonnen", "Dicks", "Fitts", "Bacote", "Bouie", "Sandy",
                   "Berhane", "Hardiman", "Glasco", "Turnipseed", "Mackie", "Goudeau", "Rasheed", "Drown",
                   "Showers", "Donelson", "Fauntleroy", "Hector", "Milliner", "Bibb", "Frink", "Maurice", "Wesson",
                   "Filsaime", "Metellus", "Dewalt", "Goodloe", "Nalls", "Witherspoon", "Sturdivant",
                   "Boatman", "Wilbourn", "Kone", "Odoms", "Session", "Dedeaux", "Lacour", "Inniss", "January",
                   "Jeanfrancois", "Eberhart", "Rawlins", "Shackleford", "Kinnard", "Honore", "Hickson", "Tuggle",
                   "Salaam", "Hibbler", "Bowens", "Koroma", "Caines", "Gardener", "Deberry", "Rachal", "Dennard",
                   "Funderburk", "Brevard", "Mcdougle", "Sankey", "Dorsey", "Chapple", "Wortham", "Beacham", "Dargan",
                   "Sheard", "Pass", "Copes", "Giddings", "Hatter", "Venson", "Liddell", "Pinckney", "Thaxton", "Dash",
                   "Castille", "Thurmond", "Fall", "Jean", "Osby", "Epps", "Ryals", "Gadson", "Swindell", "Dingle",
                   "Alexandre", "Saulsberry", "Seabrooks", "Scipio", "Alex", "Felder", "Becton", "Bienaime", "Prude",
                   "Weeden", "Dawes", "Crew", "Taplin", "Thrash", "Fredrick", "Swinney", "Cousar", "Towns", "Asberry",
                   "Anyanwu", "Wilborn", "Brodie", "Middlebrook", "Weatherspoon", "Exum", "Weary", "Blue", "Wisdom",
                   "Whitsett", "Atwater", "Wilford", "Shears", "Ramseur", "Mcmillion", "Ned", "Luster", "Levingston",
                   "Binns", "Sledge", "Sorrells", "Pinkney", "Osbourne", "Josey", "Waldon", "Stowers", "Stroman",
                   "Townes", "Seck", "Bynum", "Mccaskill", "Mcdougald", "Belle", "Ballentine", "Sistrunk", "Poteat",
                   "Booze", "Gueye", "Kyles", "Burkhalter", "Asfaw", "Grandberry", "Albritton", "Veney", "Mohammed",
                   "Mcmorris", "Gales", "Ranson", "Billups", "Nedd", "Mcduffie", "Durden", "Sessoms", "Pompey",
                   "Beckles", "Mars", "Taliaferro", "Claude", "Ojo", "Puryear", "Glaspie", "Morman", "Polk", "Golding",
                   "Pleasant", "Garrick", "Wimbley", "Yarborough", "Crooms", "Hyppolite", "Gilliard", "Primm", "Kellum",
                   "Pegues", "Chappelle", "Byas", "Mitchel", "Boateng", "Maple", "Womble", "Goldston",
                   "Summerville", "Standifer", "Bastien", "Gist", "Cobbins", "Ryans", "Coffee", "Mcilwain", "Cowans",
                   "Bogle", "Rochelle", "Lenoir", "Threadgill", "Jimerson", "Banton", "Demby", "Sydnor", "Futrell",
                   "Braithwaite", "Hazzard", "Wilcher", "Peart", "Larry", "Hillard", "Blaise", "Cromartie", "Eiland",
                   "Moise", "Pride", "Hailu", "Ussery", "Broadway", "Dantzler", "Goings", "Flagg", "Leathers", "Cozart",
                   "Boakye", "Nicks", "Sandifer", "Greaves", "Heyward", "Baynes", "Hardnett", "Legrand", "Gayden",
                   "Sharper", "Byars", "Bazemore", "Nesbit", "Washington", "Seymore", "Broadus", "Pettiford", "Percy",
                   "Guice", "Asante", "Burkes", "Sherrod", "Edmonson", "Elamin", "Philpot", "Ancrum", "Roundtree",
                   "Shivers", "Jessup", "Hilson", "Roscoe", "Conerly", "Emanuel", "Torrence", "Browder", "Sarpong",
                   "Mceachin", "Prioleau", "Scurry", "Kinchen", "Daye", "Nwachukwu", "Guyton", "Passmore", "Caesar",
                   "Weathersby", "Bellamy", "Erby", "Pires", "Frison", "Cephas", "Stukes", "Waring", "Bazile", "Jeter",
                   "Menefee", "Nurse", "Murchison", "Arline", "Wint", "Jefferies", "Petithomme", "Wingo", "Burwell",
                   "Okonkwo", "Dawkins", "Boose", "Samuel", "Mccree", "Sheikh", "Ben", "Shanklin", "Watford", "Berkley",
                   "Tillis", "Bridgeman", "Ringgold", "Truesdale", "Shorts", "Drain", "Charlot", "Walston", "Custis",
                   "Crittenden", "Chaplin", "Stancil", "Cannady", "Sellars", "Wormley", "Tillman", "Abraha", "Draughn",
                   "Highsmith", "Turman", "Polite", "Tessema", "Blakemore", "Ajayi", "Hagans", "Carraway", "Augustin",
                   "Ealey", "Lawal", "Woodley", "Okoro", "Glanton", "Dorris", "Gaines", "Junior", "Laguerre", "Philips",
                   "Braham", "Golson", "Chatmon", "Lagrone", "Tabb", "Bonds", "Osman", "Njoku", "Rayford", "Veal",
                   "Mosby", "Dunmore", "Bynes", "Carrington", "Theodore", "Grays", "Blow", "Gillard", "Blanc",
                   "Hutcherson", "Staggers", "Browner", "Goodall", "Fonville", "Okafor", "Drummer", "Abron", "Jeudy",
                   "Jefferson", "Dowdell", "Stith", "Delva", "Carswell", "Lipford", "Calixte", "Bracey", "Runnels",
                   "Greenidge", "Simeon", "Cuthbertson", "Diggins", "Kidane", "Winfrey", "Skeete", "Settles",
                   "Fluellen", "Stjulien", "Maye", "Northington", "Massenburg", "Louis", "Dinkins", "Weatherly",
                   "Nealy", "Chavers", "Pharr", "Bangura", "Worthen", "Dorvil", "Bizzell", "Spratt", "Manigault",
                   "Lumpkins", "Blunt", "Grundy", "Boynton", "Emile", "Broady", "Slaton", "Charleston", "Styles",
                   "Shuford", "Speights", "Bonsu", "Eddins", "Blackshire", "Mathurin", "Dunkley", "Semien",
                   "Jalloh", "Clyburn", "Mcduffy", "Avent", "Hervey", "Aubrey", "Woodberry", "Rucker", "Bagby", "Leak",
                   "Dansby", "Duhart", "Carmon", "Pasley", "Alfred", "Spratley", "Wafer", "Blaine", "Mcgriff",
                   "Culberson", "Edouard", "Remy", "Smalls", "Archie", "Timberlake", "Lenard", "Obi", "Grayer", "Dear",
                   "Crutcher", "Pettus", "Brookins", "Shropshire", "Petit", "Blakney", "Tarrant", "Belin", "Hambrick",
                   "Petitfrere", "Cullins", "Fudge", "Hosey", "Dews", "Trotman", "Middlebrooks", "Volcy", "Springs",
                   "Wideman", "Favors", "Sy", "Blakey", "Tadesse", "Holston", "Shabazz", "Sanon", "Grandison", "Ragin",
                   "Davie", "Pippins", "Waites", "Hoskin", "Peete", "Leavell", "Rodney", "Slay", "Mosley", "Demery",
                   "Braddy", "Bookman", "Satterwhite", "Diop", "Deas", "Kirksey", "Moorehead", "Banks", "Rolle",
                   "Cyrus", "Haggins", "Haygood", "Littles", "Kendricks", "Conteh", "Woodford", "Bibbs", "Fullwood",
                   "Marbury", "Vereen", "Babineaux", "Mullings", "Fairley", "Sylla", "Whitted", "Pirtle",
                   "Shine", "El", "Hearns", "Jeanpierre", "Clardy", "Otey", "Canty", "Woodfork", "Dukes",
                   "Cosey", "Sylvain", "Baptiste", "Ambroise", "Clayborn", "Julien", "Lashley", "Lesure", "Chavis",
                   "Cephus", "Tolbert", "Wyche", "Newson", "Bankhead", "Willie", "Rhymes", "Theus", "Eatmon", "Coakley",
                   "Charles", "Breckenridge", "Voltaire", "Renfroe", "Senior", "Pilgrim", "Hatchett", "Hamlet",
                   "Hazelwood", "Husband", "Pierrelouis"]}

hispanic_names = {
    "first_names": ["Llano", "Ignacio", "Illescas", "Gimenez", "Maravilla", "Siordia", "Vives", "Olivero", "Rocha",
                    "Tlatelpa", "Zuleta", "Tenesaca", "Moralez", "Limon", "Alvizo", "Kaylin", "Emil", "Franklin",
                    "Isaias", "Annalise", "Jeremy", "Savannah", "Ezekiel", "Kate", "Montserrat", "Lauren", "Alexia",
                    "Miah", "Eva", "Kaitlyn", "Leah", "Zabdiel", "Cristopher", "Brayan", "Kayden", "Kayleigh",
                    "Julissa", "Tyler", "Crystal", "Cristian", "Paige", "Paola", "Jason", "Michael", "Taylor", "Bruno",
                    "Fernanda", "Blake", "Stephen", "Maxwell", "Alonso", "Emmy", "Ariadna", "Ean", "Lianna", "Liah",
                    "Stacy", "Amelie", "Ava", "Denise", "Liliana", "Lily", "Jessie", "Rosemary", "Valerie", "Carlos",
                    "Alina", "Kevin", "Jaxson", "Aimee", "Jace", "Amara", "Deborah", "Tiffany", "Kyle", "Annie",
                    "Cristina", "Samara", "Wendy", "Avery", "Viviana", "Sabrina", "Xavier", "Marc", "David", "Issac",
                    "Jasiah", "Evelyn", "Bruce", "Leanna", "Hazel", "Lian", "Myles", "Bryan", "Alan", "Nathaly", "Jada",
                    "Lorenzo", "Alexis", "Amina", "Legend", "Gael", "Kyrie", "James", "Eileen", "Jasmine", "Arabella",
                    "Nolan", "Tiana", "Savanna", "Jocelyn", "Isis", "Marco", "Anaya", "Royce", "Rafael", "Samantha",
                    "Jencarlos", "Nathan", "Elian", "Hayley", "Derick", "Eliza", "Gianni", "Mariah", "Aitana",
                    "Chelsea", "Trinity", "Timothy", "Anthony", "Noel", "Ezra", "Johan", "Seth", "Alba", "Harmony",
                    "Gianna", "Kaylani", "Jayda", "Kamila", "Jared", "Max", "Phoenix", "Dayana", "Elvin", "Sarah",
                    "Jayla", "Kaylie", "Ashley", "Stacey", "Bryson", "Evan", "Erik", "Aria", "Claire", "Daniela",
                    "Eddy", "Bryce", "Santiago", "Lizbeth", "Esther", "Nova", "Kailey", "Perla", "Eric", "Allan",
                    "Xander", "Maison", "Celeste", "Leslie", "Amaya", "Messiah", "Joziah", "Kelsey", "Jaslyn", 
                    "Adonis", "Vincent", "Lucas", "Karina", "Estrella", "Hailey", "Lukas", "Zuri", "Joel", "Arya",
                    "Yael", "Tristan", "Valentina", "Brian", "Kayson", "Andrew", "Dominic", "Lesly", "Devin",
                    "Maximiliano", "Nancy", "Larry", "William", "Jaxon", "Aileen", "Alvin", "Richard", "Galilea",
                    "Marjorie", "Owen", "Gavin", "Elliot", "Amalia", "Dariel", "Antonio", "Katelynn", "Luciana",
                    "Kimberly", "Helen", "Maximilian", "Amirah", "Juliette", "Anahi", "Angelique", "Samira", "Daphne",
                    "Diana", "Alani", "Luz", "Skylar", "Jonas", "Alaina", "Brenda", "Arielle", "Yaniel", "Dominick",
                    "Ella", "Lyanna", "Charlie", "Elliana", "Jaylee", "Isaac", "Natasha", "Amira", "Gerardo", "Kenneth",
                    "Maya", "Romeo", "Luke", "Madison", "Henry", "Alissa", "Mckenzie", "Guadalupe", "Kaleb", "Andres",
                    "Alondra", "Randy", "Keyla", "Iker", "Gabriel", "Jariel", "Shirley", "Irene", "Jaylin", "Sherlyn",
                    "Arian", "Geraldine", "Emilio", "Zayn", "Alejandra", "Arturo", "Gregory", "Serenity", "Armando",
                    "Damian", "Khloe", "Leon", "Marisol", "Amber", "Kailyn", "Laura", "Jaziel", "Eliel", "Monica",
                    "Jahir", "Zoey", "Mackenzie", "John", "Jaylyn", "Dilan", "Alessia", "Noemi", "Micah", "Emanuel",
                    "Danny", "Heidi", "Carmelo", "Nathaniel", "Leilany", "Emmanuel", "Delilah", "Caiden", "Laila",
                    "Aliyah", "Mariana", "Adrian", "Gabriela", "Jasmin", "Aldo", "Cassandra", "Denisse", "Miracle",
                    "Camila", "Scarlett", "Olivia", "Roger", "Yamilet", "Alejandro", "Carter", "Angel", "Felipe",
                    "Aurora", "Frank", "Hailie", "Ronaldo", "Bianca", "Mayson", "Jaliyah", "Sara", "Amberly", "Jazmine",
                    "Renata", "Justin", "Felix", "Omar", "Selena", "Miguel", "Alaia", "Ariel", "Mateo", "Rihanna",
                    "Jayleen", "Johnny", "Nashla", "Danna", "Ruth", "Milani", "Jayren", "Nicholas", "Lionel", "Saul",
                    "Robert", "Nayla", "Kiara", "Christian", "Adrianna", "Zayden", "Carla", "Anabelle", "Pablo",
                    "Tatiana", "Vanessa", "Ricardo", "Diego", "Paul", "Ethan", "Nadia", "Adeline", "Cindy", "Angelica",
                    "Jaslene", "Madelyn", "Stephanie", "Emilia", "Magaly", "Samuel", "Lenny", "Gabriella", "Elisa",
                    "Lillian", "Briana", "Angelo", "Yair", "Brandon", "Alana", "Marlon", "Melvin", "Januel", "Ariella",
                    "Janelle", "Shayla", "Ivanna", "Jordi", "Zion", "Raul", "Denzel", "Levi", "Cecilia",
                    "Aden", "Mila", "Jimena", "Antonella", "Nina", "Destiny", "Abby", "Mason", "Valery", "Zaid",
                    "Miriam", "Liana", "Matteo", "Jaycob", "Keily", "Alyssa", "Daleyza", "Adan", "Joaquin", "Scarlet",
                    "Sadie", "Steven", "Sophia", "Celine", "Sergio", "Kai", "Christopher", "Roselyn", "Javier", "Julie",
                    "Peter", "Cataleya", "Joshua", "Armani", "Sarahi", "Anabel", "Luca", "Malia", "Meghan", "Fabian",
                    "Pamela", "Kylee", "Edward", "Nicolas", "Francesca", "Amir", "Kayleen", "Heidy", "Jacob", "Amaia",
                    "Jonael", "Junior", "Yamileth", "Mark", "Gerard", "Arely", "Karla", "Giovanny", "Isabella",
                    "Cristofer", "Thomas", "Adalynn", "Londyn", "Melina", "Connor", "Nataly", "Andrea", "Salome",
                    "Imani", "Luis", "Rylee", "Angeline", "Dara", "Stella", "Megan", "Jerry", "Theodore", "Elijah",
                    "Alberto", "Aleena", "Skyla", "Elias", "Janiel", "Yariel", "Alexander", "Elena", "Leyla",
                    "Leonidas", "Anabella", "Zachary", "Abraham", "Mike", "Harley", "Chloe", "Mauricio", "Josue",
                    "Chanel", "Josephine", "Cairo", "Haylee", "Alfredo", "Carolina", "Eliana", "Ace", "Jose", "Karter",
                    "Damien", "Angely", "Violeta", "Ashton", "Roberto", "Skyler", "Hunter", "Jazzlyn", "Adam", "Darwin",
                    "Adelyn", "Jefferson", "Aylin", "Axel", "Carmen", "Dulce", "Yandel", "Melissa", "Catherine",
                    "Sophie", "Jaden", "Natalia", "Johanna", "Haley", "Kailani", "Micaela", "Itzel", "Aubree", "Enzo",
                    "Giovani", "April", "Milagros", "Mathew", "Jesse", "Louis", "Mario", "Ximena", "Kaiden", "Jonah",
                    "Sienna", "Jimmy", "Cynthia", "Angelina", "Jaime", "Juan", "Layla", "Enrique", "Cali", "Derek",
                    "Paula", "Isabel", "Nevaeh", "Cesar", "Juliana", "Eddie", "Wilson", "Juliet", "Ariah", "Khaleesi",
                    "Alexa", "Eliam", "Jayceon", "Nyla", "Arianny", "Sarai", "Sariah", "Alicia", "Clara", "Rebecca",
                    "Ronald", "Miley", "Daniella", "Nicole", "Raymond", "Jessica", "Charlotte", "Julian", "Melany",
                    "Julius", "Dante", "Katie", "Nathanael", "Addison", "Alexandra", "Naomi", "Misael", "Esteban",
                    "Monserrat", "Brooke", "Lucia", "Edwin", "Aaron", "Julianna", "Manuel", "Summer", "Edgar", "Aniyah",
                    "Oscar", "Yasmin", "Marcos", "Ayla", "Maite", "Nelson", "Kaden", "Preston", "Isaiah", "Marcelo",
                    "Ariadne", "Pedro", "Donovan", "Briella", "Jackson", "Yahir", "Neymar", "Emiliano", "Anderson",
                    "Priscilla", "Marvin", "Arlette", "Aubrey", "Ruben", "Andy", "Jaylen", " olivia", "Amari",
                    "Genesis", "Katelyn", "Matthew", "Daisy", "Jamie", "Albert", "Amayah", "Fernando", "Kali",
                    "Dylan", "Rose", "Liam", "Dana", "Erika", "Austin", "Kelvin", "Harrison", "Ayden", "Madeline",
                    "Nia", "Isabella ", "Anastasia", "Angela", "Prince", "Alyson", "Britney", "Grayson", "Evangeline",
                    "Iris", "Isabelle", "Lennox", "Brayden", "Greyson", "Anna", "Alma", "Milo", "Nashley", "Aiden",
                    "Nashly", "Nylah", "Elizabeth", "Adriana", "Everly", "Brianna", "Allison", "Ezequiel", "George",
                    "Giovanni", "Emma", "Shawn", "Bethany", "Jazmin", "Zoe", "Zander", "Elianna", "Nayeli", "Kenny",
                    "Lizeth", "Kassandra", "Camilo", "Francisco", "Julia", "Kelly", "Steve", "Miranda", "Freddy",
                    "Arleth", "Alia", "Amanda", "Analia", "Caroline", "Alessandra", "Milan", "Nyah", "Veronica",
                    "Bradley", "Jaelynn", "Adele", "Byron", "Litzy", "Valentin", "Mathias", "Audrey", "Keila", "Jorge",
                    "Jeffrey", "Mikaela", "Johnathan", "Ellie", "Natalie", "Ayleen", "Maia", "Dahlia", "Vivian",
                    "Isabela", "Orion", "Moises", "Faith", "Hanley", "Annabella", "Kendrick", "Melanie", "Allyson",
                    "Leila", "Rodrigo", "Allen", "Jesus", "Aaliyah", "Adelynn", "Lia", "Yerik", "Danielle", "Adriel",
                    "Jaylah", "Thiago", "Jaiden", "Hector", "Valeria", "Cameron", "Camilla", "Jeremiah",
                    "Logan", "Eduardo", "Riley", "Daniel", "Nathalie", "Brielle", "Justice", "Penelope", "Sebastian",
                    "Ivan", "Luna", "Izaiah", "Ian", "Violet", "Ailani", "Victor", "Adiel", "Julio", "Mya", "Emely",
                    "Eli", "Jacqueline", "Alisson", "Alice", "Francis", "Michelle", "Ryan", "Katherine", "Belen",
                    "Marcus", "Sandra", "Samir", "Rachel", "Liz", "Johann", "Jaylene", "Jade", "Edison", "Alessandro",
                    "Esmeralda", "Aidan", "Lindsay", "Rosa", "Elsie", "Ashly", "Jeremias", "Ermias", "Caleb", "Andre",
                    "Maximo", "Lola", "Jayden", "Dean", "Ambar", "Amy", "Roman", "Shane", "Alayna", "Jadiel", "Mia",
                    "Uriel", "Asher", "Hannah", "Tomas", "Bryanna", "Anais", "Abel", "Abigail", "Arianna", "Sofia",
                    "Mikayla", "Yadiel", "Martin", "Lincoln", "Lesley", "Camille", "Gia", "Chris", "Karen", "Bella",
                    "Jennifer", "Jax", "Brittany", "Jair", "Elvis", "Maximus", "Laia", "Giselle", "Jazlyn", "Annabelle",
                    "Matthias", "Dereck", "Ruby", "Kehlani", "Joselyn", "Travis", "Ismael", "Yesenia", "Jonathan",
                    "Hugo", "Aleah", "Jolie", "Stephany", "Sean", "Alahia", "Jordan", "Leia", "Kylie", 
                    "Kayla", "Oliver", "Erick", "Gabrielle", "Walter", "Catalina", "Kairo", "Elianny", "Jean",
                    "Orlando", "Krystal", "Ariana", "Marilyn", "Alison", "Ingrid", "Emily", "Wesley", "Grace",
                    "Victoria", "Jayce", "Aisha", "Alanis", "Alex", "Joseph", "Josiah", "Yaretzi", "Lea", "Alanna",
                    "Sasha", "Julien", "Kaelyn", "Benjamin", "Gustavo", "Leo", "Hudson", "Nathalia", "Noah", "Landon",
                    "Leonardo", "Autumn", "Maria", "Damaris", "Peyton", "Yaritza", "Izabella", "Abdiel", "Abril",
                    "Jayson", "Makayla", "Patrick", "Ivy", "Angie", "Yareli", "Valentino", "Zara", "King", "Dennis",
                    "Charles", "Matias", "Leandro", "Amelia", "Skylah", "Kaylee", "Christina", "Athena", "Cayden",
                    "Maverick", "Melody", "Jack", "Bryant", "Maddox", "Aliah", "Brianny", "Ana", "Leilani", "Heaven",
                    "Jake", "Jay", "Jeancarlos", "Kendra", "Paloma", "Fatima", "Brigitte", "Jaelyn", "Leonel", "Avril",
                    "Jael", "Chase", "Raquel"],
    "last_names": ["Ortis", "Deharo", "Buelna", "Diazlopez", "Ibanez", "Caicedo", "Teniente", "Casado", "Calderon",
                   "Virrueta", "Arita", "Mancillas", "Rostro", "Ponce", "Iraheta", "Lizardi", "Monjaraz", "Pavon",
                   "Gardea", "Hernandez", "Tafolla", "Vejar", "Estupinan", "Cavazos", "Cipriano", "Manon",
                   "Casarrubias", "Mosquera", "Ruiz", "Oyola", "Sigala", "Nieblas", "Zendejas", "Raygoza", "Loaiza",
                   "Canelo", "Pintado", "Aguirre", "Fleites", "Pita", "Cerezo", "Mancia", "Ospina", "Velazquez",
                   "Zarate", "Infante", "Bermudes", "Villatoro", "Disla", "Almaraz", "Jalomo", "Villar", "Masias",
                   "Noriega", "Cervera", "Ruvalcaba", "Estremera", "Chevere", "Ugarte", "Equihua", "Caba", "Argueta",
                   "Rincon", "Botero", "Arellano", "Aceves", "Granillo", "Terrazas", "Graciano", "Samaniego", "Machin",
                   "Ramires", "Hiraldo", "Sardinas", "Aviles", "Carchi", "Yanes", "Inoa", "Jaramillo", "Servin",
                   "Vasquez", "Anzures", "Recio", "Ballinas", "Pedroza", "Olivieri", "Montesdeoca", "Esparza",
                   "Resendez", "Villalba", "Marentes", "Verdejo", "Lugo", "Mansilla", "Aristizabal", "Mundo", "Mancha",
                   "Basilio", "Zevallos", "Cuervo", "Devora", "Grillo", "Delao", "Gonzalezgarcia", "Perez", "Pinal",
                   "Salcido", "Zambrano", "Puig", "Santiago", "Talamantes", "Rojo", "Tenezaca", "Nova", "Jarquin",
                   "Verduzco", "Perla", "Sustaita", "Vidana", "Herrejon", "Suastegui", "Ochoa", "Puello", "Moreno",
                   "Lung", "Villagomez", "Campillo", "Virella", "Huitron", "Amarillas", "Perea", "Marmolejos", "Raya",
                   "Armenta", "Rodriguez", "Guallpa", "Font", "Paulin", "Urbano", "Garciasanchez", "Deluna", "Tristan",
                   "Gines", "Pabon", "Vaquera", "Ventura", "Troche", "Osuna", "Moreira", "Collazo", "Pineda", "Tena",
                   "Pavia", "Portal", "Maysonet", "Noa", "Laurel", "Escamilla", "Alvira", "Alzate", "Plazola",
                   "Azevedo", "Vale", "Godoy", "Dorantes", "Sermeno", "Buentello", "Nieves", "Ardon", "Vicente",
                   "Chiquito", "Banda", "Olivares", "Olivos", "Barra", "Cantillo", "Vallejo", "Ticas", "Cienfuegos",
                   "Rada", "Macareno", "Picasso", "Lopezgarcia", "Marte", "Facio", "Leiva", "Mederos", "Sanmartin",
                   "Gerardo", "Campa", "Saavedra", "Colmenero", "Navarrete", "Guadalupe", "Rosales", "Corrales",
                   "Tavarez", "Acosta", "Cosme", "Salais", "Funes", "Lepe", "Narez", "Asencio", "Quinteros", "Zarco",
                   "Irigoyen", "Meraz", "Regino", "Garciaramirez", "Pecina", "Tijerina", "Barradas", "Magallanes",
                   "Delvillar", "Madero", "Cardoza", "Cepeda", "Guajardo", "Olarte", "Toledo", "Donoso", "Terrones",
                   "Silva", "Barboza", "Bravo", "Solorzano", "Ordones", "Catalan", "Licea", "Amado", "Duenez", "Salas",
                   "Adrian", "Bedoy", "Caban", "Jasso", "Mas", "Calles", "Sotelo", "Alcazar", "Morel", "Felipe",
                   "Dubon", "Puentes", "Cuadra", "Zubia", "Sanabria", "Amigon", "Calva", "Olivar", "Mena", "Villalobos",
                   "Solorio", "Fundora", "Puente", "Jiron", "Desantiago", "Zavaleta", "Moraga", "Rosario", "Ipina",
                   "Aldaz", "Rosiles", "Ferman", "Bisono", "Bugarin", "Mendoza", "Aispuro", "Tobar", "Suarez", "Espana",
                   "Herrero", "Martines", "Goto", "Brizuela", "Barcenas", "Alamillo", "Ricardo", "Elizarraraz", "Diego",
                   "Maese", "Orona", "Domingues", "Merced", "Murrieta", "Enciso", "Barba", "Febles", "Uriegas", "Alers",
                   "Elenes", "Alvarenga", "Cubillos", "Monreal", "Centeno", "Aguiniga", "Aldama", "Guardiola",
                   "Vizcaino", "Lamas", "Belmares", "Gatica", "Ferrufino", "Cabanillas", "Yebra", "Mazariego",
                   "Soltero", "Barreras", "Mayorga", "Maynes", "Siqueiros", "Gamarra", "Villasenor", "Casas", "Pratts",
                   "Hipolito", "Chirinos", "Cordon", "Mares", "Minjares", "Candela", "Olivo", "Balderas", "Becerril",
                   "Urrutia", "Cordero", "Olivarez", "Castanon", "Revilla", "Eguia", "Valtierra", "Oviedo", "Gaytan",
                   "Olivencia", "Negron", "Pereida", "Lizcano", "Larranaga", "Lujano", "Urrea", "Sorto", "Carachure",
                   "Mariscal", "Cifuentes", "Rangel", "Pequeno", "Blandon", "Luis", "Pujol", "Canchola", "Barrales",
                   "Salceda", "Cadiz", "Becerra", "Lucena", "Chaves", "Curbelo", "Colina", "Cruzmartinez", "Dutan",
                   "Lara", "Villalva", "Velarde", "Riveros", "Altamirano", "Figuereo", "Mulero", "Galeano", "Rueda",
                   "Cid", "Lumbreras", "Perezmartinez", "Chavira", "Planas", "Granado", "Villacis", "Silvera",
                   "Lezcano", "Fermin", "Grajales", "Roberto", "Lino", "Esqueda", "Rojas", "Pelayo", "Rosado", "Lainez",
                   "Alpizar", "Ovalles", "Canizales", "Alcon", "Camberos", "Romero", "Idrovo", "Negrete", "Eusebio",
                   "Coreas", "Delvalle", "Mier", "Carabajal", "Ramirezhernand", "Cardenas", "Andrade", "Lua",
                   "Perezrodriguez", "Delarosa", "Bermudez", "Natera", "Ribas", "Guereca", "Melendez", "Gamino",
                   "Labrada", "Araya", "Rebollo", "Bobadilla", "Juan", "Corporan", "Portalatin", "Limones", "Pech",
                   "Casasola", "Trigueros", "Hinojosa", "Diaz", "Alvarado", "Arellanes", "Allende", "Berlanga",
                   "Bedoya", "Sepeda", "Tiburcio", "Esteban", "Alcantara", "Febres", "Casados", "Arebalo", "Orejel",
                   "Caballero", "Zabala", "Guandique", "Posada", "Fiallo", "Cuadros", "Valiente", "Carlo", "Recendez",
                   "Payano", "Herrera", "Izquierdo", "Bencosme", "Arista", "Copado", "Aquilar", "Gonzaga", "Tercero",
                   "Maturino", "Santibanez", "Pastor", "Valdes", "Mota", "Depena", "Freyre", "Cayetano", "Flores",
                   "Briones", "Montes", "Limas", "Mijares", "Gama", "Riojas", "Lopez", "Lamboy", "Heredia", "Palafox",
                   "Olmos", "Narciso", "Contrera", "Araiza", "Barcelo", "Zurita", "Feliciano", "Melero", "Monsalve",
                   "Martindelcamp", "Marcelino", "Delacerda", "Landa", "Cuevas", "Carrasquillo", "Ortiz", "Suriel",
                   "Izaguirre", "Calzadilla", "Pinero", "Arriola", "Encinas", "Chevez", "Gaxiola", "Quiroga",
                   "Hercules", "Adame", "Borbon", "Vidaurri", "Barroso", "Yepez", "Herrarte", "Enriquez", "Francisco",
                   "Nino", "Ledesma", "Mandujano", "Delahoz", "Salazar", "Moron", "Pozos", "Samudio", "Poblano",
                   "Baylon", "Pallares", "Esquilin", "Casillas", "Picazo", "Briceno", "Jimenez", "Mencia", "Candia",
                   "Aldaba", "Cansino", "Pizano", "Garfias", "Alfaro", "Guzman", "Zarazua", "Monrroy", "Jesus",
                   "Piedrahita", "Agramonte", "Arauz", "Olivas", "Zazueta", "Aguero", "Castillo", "Raymundo", "Cahue",
                   "Narvaez", "Deltoro", "Rivero", "Camejo", "Lona", "Linan", "Melo", "Marrujo", "Delira", "Rubalcaba",
                   "Bastidas", "Cea", "Silvas", "Frayre", "Niebla", "Rentas", "Cabada", "Loja", "Duarte", "Chapa",
                   "Lavin", "Favela", "Fontanez", "Rivadeneira", "Ramirezgarcia", "Labra", "Bodden", "Corral", "Abila",
                   "Jaso", "Afanador", "Montenegro", "Taboada", "Negrin", "Fuentez", "Menchaca", "Clavijo", "Pantoja",
                   "Bernabe", "Desoto", "Baez", "Melchor", "Matos", "Lagunes", "Sala", "Marin", "Noyola", "Rivas",
                   "Urquidi", "Garciagonzalez", "Ocana", "Espitia", "Gallardo", "Delosrios", "Davalos", "Enriques",
                   "Aguillar", "Garza", "Moncivais", "Arguijo", "Viruet", "Valderrama", "Buenrostro", "Leyva", 
                   "Arciga", "Constanza", "Merida", "Morera", "Alvarez", "Ruybal", "Quintanar", "Somoza", "Hoyos",
                   "Gaeta", "Farfan", "Ornelas", "Casco", "Chicas", "Tineo", "Almendarez", "Castano", "Rodela",
                   "Perezsanchez", "Camarillo", "Escalante", "Alas", "Restrepo", "Carrizales", "Barreiro", "Gallegos",
                   "Vilchis", "Corvera", "Garnica", "Urdiales", "Llerena", "Medero", "Lovo", "Gonzalezlopez", "Erives",
                   "Hinostroza", "Huertas", "Uvalle", "Villaverde", "Virgen", "Longoria", "Talamantez", "Ovando",
                   "Osorio", "Tagle", "Blas", "Serpas", "Canedo", "Barahona", "Victoria", "Penaranda", "Guerrero",
                   "Salguero", "Espin", "Sagrero", "Aracena", "Peguero", "Montelongo", "Mairena", "Baltazar", "Olmeda",
                   "Lizardo", "Castilleja", "Arreaga", "Saez", "Ozuna", "Cantu", "Magallon", "Medellin", "Mungia",
                   "Elvira", "Lastra", "Minchala", "Maestas", "Lasalle", "Retana", "Abril", "Cotto", "Apolinar",
                   "Aguilera", "Favila", "Pinon", "Castelan", "Popoca", "Murrietta", "Barcena", "Veliz", "Carbajal",
                   "Galvan", "Arrellano", "Grijalva", "Laredo", "Loa", "Fregoso", "Euceda", "Bibian", "Borrego",
                   "Rogue", "Silverio", "Carapia", "Pargas", "Criollo", "Venzor", "Benavidez", "Henriquez", "Alcorta",
                   "Urquidez", "Inzunza", "Gerena", "Villafana", "Ureno", "Mosqueda", "Mendizabal", "Servellon",
                   "Vieyra", "Cabrera", "Carrillo", "Viramontes", "Morillo", "Ron", "Torrez", "Calleros", "Bran",
                   "Servantes", "Carcamo", "Aranda", "Costilla", "Taborda", "Constantino", "Perezperez", "Santizo",
                   "Covarrubias", "Marron", "Delapena", "Bustillos", "Mestas", "Quevedo", "Rizo", "Pineiro", "Batista",
                   "Jeronimo", "Paulino", "Arocha", "Botello", "Montero", "Echeverry", "Baeza", "Navarro", "Gervacio",
                   "Sabillon", "Vela", "Deniz", "Ceron", "Herandez", "Gaviria", "Badillo", "Panuco", "Villada",
                   "Somarriba", "Castruita", "Veloz", "Guevara", "Carlos", "Medina", "Platero", "Olalde", "Otano",
                   "Penafiel", "Alcocer", "Blancarte", "Vara", "Velaquez", "Campusano", "Arevalo", "Mojarro", "Llanos",
                   "Reveles", "Valcarcel", "Paxtor", "Ciriaco", "Murillo", "Gaitan", "Larin", "Villafranco", "Lemos",
                   "Curiel", "Campuzano", "Vallejos", "Dolores", "Montejano", "Andujo", "Montalvan", "Gongora",
                   "Cruzlopez", "Gamero", "Urizar", "Garica", "Olvera", "Remache", "Nevarez", "Parga", "Uscanga",
                   "Aguillon", "Archila", "Olaya", "Montijo", "Cardoso", "Monteon", "Rodriguezlopez", "Naranjo",
                   "Campo", "Bucio", "Oregel", "Gauna", "Torres", "Arizmendi", "Quinto", "Amparan", "Cuesta", "Roybal",
                   "Tamayo", "Lupercio", "Galvis", "Sevilla", "Loya", "Lobo", "Tostado", "Borrero", "Guadarrama",
                   "Perera", "Lago", "Bejarano", "Razo", "Rufino", "Maqueda", "Plasencia", "Barreto", "Amaya",
                   "Agredano", "Panameno", "Carretero", "Delreal", "Govea", "Salaiz", "Estudillo", "Andazola", "Delara",
                   "Renteria", "Quispe", "Miramontes", "Magallan", "Rubi", "Lascano", "Tonche", "Rosendo", "Escobedo",
                   "Aldrete", "Piedra", "Gracia", "Salasar", "Munos", "Cadavid", "Rebolledo", "Basurto", "Pliego",
                   "Esperanza", "Polanco", "Delafuente", "Durazo", "Deloera", "Legaspi", "Vivas", "Delatorre", "Brenes",
                   "Delahoya", "Viera", "Palacio", "Rosillo", "Merlos", "Bartolo", "Escorcia", "Nuno", "Amaro",
                   "Facundo", "Seda", "Noboa", "Valera", "Canela", "Coca", "Santiesteban", "Escarcega", "Picon",
                   "Clemente", "Galban", "Bribiesca", "Chavarria", "Vivanco", "Vicuna", "Urquizo", "Ayala", "Benito",
                   "Matute", "Toribio", "Barrio", "Preciado", "Mendiola", "Echevarria", "Langarica", "Mellado", "Licon",
                   "Luque", "Yanez", "Carrizal", "Algarin", "Arvizu", "Decastro", "Leon", "Alverio", "Mesa", "Moncayo",
                   "Cedillos", "Hinojos", "Patino", "Jacinto", "Ferrera", "Alavez", "Isaza", "Montiel", "Olveda",
                   "Villalon", "Espericueta", "Jerez", "Mancera", "Losada", "Oquendo", "Crespin", "Donis", "Constancio",
                   "Jara", "Cancel", "Iribe", "Landeros", "Cortinas", "Arceo", "Catano", "Santacruz", "Benites", "Joya",
                   "Vega", "Sicairos", "Ybanez", "Alban", "Garcialopez", "Cruzhernandez", "Fuerte", "Tarin", "Calzada",
                   "Castilla", "Lopezlopez", "Natal", "Ojeda", "Travieso", "Olavarria", "Viloria", "Larosa",
                   "Pesqueira", "Carreto", "Loredo", "Fortuna", "Soberanis", "Bonet", "Pastrana", "Benavides",
                   "Sahagun", "Navia", "Simental", "Arzate", "Bazaldua", "Picado", "Majano", "Batz", "Mejia", "Obeso",
                   "Carmona", "Carrasco", "Santillanes", "Pinales", "Mestre", "Acevedo", "Aliaga", "Serrata", "Fuertes",
                   "Victorino", "Carvajal", "Marinez", "Bringas", "Candelaria", "Turrubiates", "Luevanos", "Sabino",
                   "Neria", "Arenas", "Banales", "Maceda", "Quintanilla", "Rua", "Lima", "Buitrago", "Zavala",
                   "Fulgencio", "Pozo", "Sambrano", "Zamarripa", "Inocencio", "Joaquin", "Ernandez", "Garibay", "Maez",
                   "Javier", "Camarena", "Soberanes", "Quinones", "Trillo", "Cigarroa", "Aponte", "Leyba", "Lupian",
                   "Ugalde", "Marez", "Suazo", "Batalla", "Alderete", "Morones", "Albarran", "Nicolas", "Anton",
                   "Alcoser", "Garrido", "Tabares", "Loza", "Zuluaga", "Lomas", "Menjivar", "Rodas", "Valderas",
                   "Guadiana", "Santillana", "Ybarra", "Chavez", "Cendejas", "Vigil", "Pons", "Colindres", "Blancas",
                   "Alday", "Nicasio", "Onate", "Godines", "Rosas", "Marmol", "Inga", "Anchondo", "Moronta", "Elias",
                   "Capellan", "Campoverde", "Baca", "Patricio", "Quito", "Santa", "Galeas", "Alvardo", "Canal",
                   "Corniel", "Guijarro", "Revolorio", "Najar", "Arambula", "Sisneros", "Cerrillo", "Nava", "Gasca",
                   "Cardozo", "Espino", "Sosa", "Serratos", "Uranga", "Garcia", "Crisanto", "Faz", "Carmen", 
                   "Quirarte", "Rosero", "Alamo", "Alamilla", "Arana", "Agosto", "Pulgarin", "Feliz", "Madril",
                   "Bernardo", "Cantarero", "Marcia", "Casaus", "Pellot", "Castillon", "Cisneros", "Veras", "Cossio",
                   "Tiscareno", "Bueso", "Ramirezlopez", "Noguez", "Quiroz", "Obregon", "Bardales", "Vinas", "Olmo",
                   "Haro", "Zetina", "Gomez", "Correa", "Salinas", "Maza", "Padua", "Enrique", "Paula", "Balderrama",
                   "Santander", "Clavel", "Vigo", "Argote", "Lomeli", "Rengifo", "Bedolla", "Vivar", "Escudero",
                   "Villagrana", "Rosalez", "Segovia", "Perezgonzalez", "Mendosa", "Montalvo", "Valencia", "Martinez",
                   "Minaya", "Quizhpi", "Mayorquin", "Vergara", "Arreola", "Bonilla", "Chagoya", "Roldan", "Fleitas",
                   "Casique", "Morado", "Zacarias", "Barrera", "Delaguila", "Comas", "Raigoza", "Marcelo", "Aldaco",
                   "Placido", "Pedro", "Ruedas", "Novoa", "Bibiano", "Huesca", "Moscoso", "Vazques", "Bencomo", "Goris",
                   "Gusman", "Vilches", "Caldera", "Pazmino", "Porto", "Pera", "Carbonell", "Candido", "Santini",
                   "Frometa", "Crispin", "Tienda", "Teran", "Duron", "Armendarez", "Castrejon", "Orengo", "Brito",
                   "Machorro", "Bracamontes", "Bolivar", "Diez", "Frausto", "Pizarro", "Zatarain", "Castorena",
                   "Ceniceros", "Porras", "Casiano", "Armijo", "Canto", "Puga", "Jaquez", "Castellon",
                   "Nazario", "Peraza", "Reinoso", "Pagan", "Amador", "Caceres", "Nambo", "Corella", "Higuera",
                   "Castro", "Salamanca", "Adorno", "Olguin", "Cervantes", "Cabral", "Sesma", "Ortez", "Calleja",
                   "Hermida", "Topete", "Lemus", "Camilo", "Monterroza", "Maisonet", "Liriano", "Alegria", "Haros",
                   "Medrano", "Pelaez", "Chirino", "Colon", "Leija", "Carballo", "Ocasio", "Monge", "Montealegre",
                   "Figueredo", "Galarza", "Armas", "Albarado", "Morua", "Lizarraga", "Arias", "Bosquez", "Laboy",
                   "Lerma", "Quijas", "Villafranca", "Sillas", "Fernandez", "Morell", "Luquin", "Cabello", "Lora",
                   "Delacruz", "Genao", "Arispe", "Rubalcava", "Estevez", "Valero", "Pesina", "Gonzalezperez",
                   "Meneses", "Esquibel", "Carillo", "Palomar", "Antigua", "Zermeno", "Delfin", "Leal", "Montesino",
                   "Erazo", "Mera", "Delcastillo", "Alvares", "Buitron", "Balladares", "Soria", "Liz", "Pardo", "Toro",
                   "Poveda", "Uribe", "Roa", "Obando", "Zamarron", "Zavalza", "Leanos", "Barrios", "Ferreras", "Boza",
                   "Freire", "Carreno", "Chaires", "Mattos", "Sabedra", "Vaquerano", "Monegro", "Horta", "Burgos",
                   "Coto", "Esquer", "Gaucin", "Serrato", "Tomas", "Nogueras", "Galeno", "Echeverria", "Penaloza",
                   "Cerda", "Capetillo", "Almanza", "Rayo", "Loor", "Segundo", "Soliz", "Juarbe", "Huaman", "Carnero",
                   "Berumen", "Zepeda", "Alcantar", "Saucedo", "Villamil", "Garriga", "Farinas", "Rogel",
                   "Martinezhernan", "Mancilla", "Marenco", "Cervantez", "Massa", "Garduno", "Palos", "Redondo",
                   "Baltodano", "Gabaldon", "Urzua", "Ferreyra", "Ancira", "Muneton", "Plata", "Bermeo", "Orosco",
                   "Godina", "Garzon", "Cazares", "Franqui", "Balcazar", "Navarette", "Mancinas", "Cruz", "Cruzado",
                   "Albino", "Albor", "Gonzales", "Latorre", "Berganza", "Consuegra", "Santana", "Osoria", "Cortina",
                   "Pino", "Yerena", "Figueroa", "Merchan", "Villalvazo", "Vierra", "Avelino", "Magadan", "Gascon",
                   "Castrillon", "Loayza", "Custodio", "Muratalla", "Maltez", "Cabrales", "Manjarrez", "Ocegueda",
                   "Losoya", "Ahumada", "Duenas", "Araujo", "Quiros", "Ramon", "Cespedes", "Pruneda", "Vaquero",
                   "Pantaleon", "Najera", "Portilla", "Puebla", "Amezcua", "Escareno", "Solivan", "Calero", "Pareja",
                   "Cajigas", "Hidrogo", "Rodriges", "Montejo", "Garciacruz", "Remigio", "Trigo", "Fuentes", "Ogando",
                   "Penuelas", "Urquiza", "Delgado", "Rabadan", "Umanzor", "Grau", "Huezo", "Pereda", "Barraza",
                   "Gandarilla", "Varela", "Ribera", "Lazalde", "Guebara", "Cornejo", "Padin", "Banos", "Morgado",
                   "Samano", "Rios", "Dominquez", "Agudelo", "Calvillo", "Guerra", "Andujar", "Melgarejo",
                   "Hincapie", "Huante", "Malagon", "Valeriano", "Hernandezlopez", "Marroquin", "Sencion", "Navedo",
                   "Maciel", "Suniga", "Corredor", "Menendez", "Chaidez", "Valerio", "Azua", "Hernandezperez",
                   "Vicencio", "Aparicio", "Texidor", "Pupo", "Encalada", "Sabala", "Venegas", "Escalona", "Calixto",
                   "Paniagua", "Desantos", "Chica", "Pedraza", "Dominguez", "Renderos", "Heras", "Pazos", "Roig",
                   "Ulloa", "Dena", "Aldape", "Berrones", "Cebreros", "Azcona", "Cuautle", "Garciarodrigue", "Napoles",
                   "Chairez", "Fausto", "Campos", "Grado", "Tanguma", "Sanches", "Chino", "Lagos", "Aguila", "Molano",
                   "Basulto", "Aleman", "Quinonez", "Lanuza", "Palaguachi", "Alegre", "Machado", "Solares", "Lorenzo",
                   "Delavega", "Requena", "Sequeira", "Ferrer", "Silvestre", "Saldarriaga", "Callejas", "Lozoya",
                   "Aquino", "Hermosillo", "Loreto", "Jusino", "Rayas", "Anaya", "Cedano", "Montellano", "Gavina",
                   "Bohorquez", "Pinzon", "Ocon", "Quezada", "Nodarse", "Patron", "Bueno", "Saenz", "Balli", "Donjuan",
                   "Suero", "Ortegon", "Barbosa", "Cuello", "Burruel", "Soriano", "Mazon", "Cora", "Membreno",
                   "Godinez", "Junco", "Cubias", "Morano", "Canizalez", "Arvizo", "Compean", "Gotay", "Arriaza",
                   "Orellana", "Paez", "Viana", "Vidrio", "Tabarez", "Roca", "Vidals", "Moro", "Cabanas", "Celestino",
                   "Cuen", "Telles", "Juarez", "Plascencia", "Navas", "Oregon", "Arreguin", "Rivera", "Estrella",
                   "Capo", "Manso", "Bauza", "Madriz", "Pujols", "Siguenza", "Monterroso", "Zagal", "Lasso", "Venancio",
                   "Torralba", "Montufar", "Varona", "Badilla", "Villagran", "Leos", "Arango", "Licona", "Florencio",
                   "Fletes", "Quintana", "Peralez", "Triana", "Alcala", "Rutz", "Candelas", "Riveron", "Espaillat",
                   "Solache", "Luz", "Jovel", "Corea", "Valdivieso", "Carrero", "Celaya", "Cazarez", "Rod", "Pintor",
                   "Arzola", "Trevino", "Garciagarcia", "Cambron", "Isais", "Cornelio", "Guardado", "Sapien",
                   "Basaldua", "Henao", "Orduno", "Caraveo", "Lantigua", "Jauregui", "Aburto", "Belloso", "Valenciano",
                   "Vasques", "Chamorro", "Munoz", "Vazquez", "Garciaflores", "Paz", "Fragoso", "Paiz", "Velasco",
                   "Vento", "Puac", "Espinal", "Arcia", "Roque", "Damian", "Asuncion", "Oliveras", "Brambila",
                   "Galeana", "Orea", "Lagunas", "Bautista", "Escutia", "Bejar", "Manzano", "Gregorio", "Prieto",
                   "Sardina", "Delrio", "Gorostieta", "Chacon", "Monje", "Reyez", "Carpio", "Minjarez", "Soler",
                   "Febus", "Villamar", "Cedeno", "Arteaga", "Angel", "Lanza", "Gamboa", "Cepero", "Gonzalez",
                   "Barreda", "Umana", "Lopezperez", "Arce", "Ortega", "Verdin", "Nungaray", "Espejo", "Conde",
                   "Aragon", "Castelo", "Motta", "Irizarry", "Crespo", "Tobon", "Treto", "Escoto", "Lule", "Guizar",
                   "Vegas", "Corpus", "Claros", "Vidales", "Marty", "Florentino", "Dorado", "Garciaperez", "Bermea",
                   "Belmontes", "Griego", "Marmolejo", "Grullon", "Montesinos", "Levario", "Savedra", "Banuelos",
                   "Ordaz", "Bocanegra", "Trejo", "Arzu", "Lopezramirez", "Nuncio", "Santillan", "Castrillo", "Tafoya",
                   "Morales", "Corchado", "Concha", "Perezgarcia", "Acuna", "Sarabia", "Sagastume", "Magana", "Osorto",
                   "Acedo", "Acebedo", "Arocho", "Lucio", "Rodriques", "Palencia", "Labrador", "Gallego", "Manzanares",
                   "Silveira", "Campas", "Lazo", "Cueva", "Padro", "Olea", "Frias", "Mirabal", "Cecena", "Madrigal",
                   "Murga", "Arechiga", "Milian", "Sias", "Pinilla", "Liberato", "Robaina", "Placencia", "Dehoyos",
                   "Cirilo", "Anguiano", "Delcampo", "Alvear", "Basquez", "Monarrez", "Fabela", "Victoriano", "Dearmas",
                   "Silguero", "Toscano", "Bracero", "Ponciano", "Angulo", "Serafin", "Zelaya", "Bosque",
                   "Martinezcruz", "Coronel", "Alberto", "Barcia", "Bermejo", "Gastelum", "Villareal", "Fontes",
                   "Marquez", "Deanda", "Pleitez", "Lucatero", "Perales", "Magdaleno", "Deras", "Paramo", "Grajeda",
                   "Monjaras", "Tenorio", "Cantoran", "Gandara", "Jaimes", "Abundiz", "Pico", "Puerta", "Aguiar",
                   "Pocasangre", "Calvo", "Torrico", "Parrales", "Munguia", "Perezcruz", "Marban", "Villarroel",
                   "Savala", "Murguia", "Pesantez", "Rebollar", "Echeverri", "Alarid", "Zapata", "Zetino", "Prada",
                   "Peralta", "Corzo", "Giron", "Deleon", "Armendariz", "Uresti", "Monroy", "Zambrana", "Arencibia",
                   "Arroyave", "Lozano", "Guijosa", "Espindola", "Abeyta", "Villafan", "Cubas", "Bolanos", "Posadas",
                   "Zamora", "Albarez", "Hilario", "Pizana", "Ariza", "Saldana", "Uriarte", "Proano", "Espinola",
                   "Alvidrez", "Resendiz", "Giraldo", "Belmonte", "Valladolid", "Villafuerte", "Saravia", "Mondragon",
                   "Delosangeles", "Santo", "Alarcon", "Baiza", "Mazariegos", "Floresgarcia", "Portela", "Vallecillo",
                   "Aldana", "Merlo", "Machuca", "Gudino", "Bernardino", "Irias", "Urdaneta", "Clara", "Arballo",
                   "Lorenzana", "Encinias", "Olmedo", "Breceda", "Cuba", "Tamez", "Guitron", "Avilez", "Dionicio",
                   "Ciprian", "Natividad", "Sandoval", "Arcila", "Casimiro", "Corona", "Llamas", "Peinado", "Solano",
                   "Zuniga", "Celis", "Loera", "Marcos", "Fiscal", "Luera", "Zuno", "Alonzo", "Ballester", "Gavidia",
                   "Cereceres", "Burrola", "Hernandezcruz", "Tarango", "Vanegas", "Justiniano", "Berroa", "Portugal",
                   "Mar", "Padron", "Bustos", "Lacayo", "Zamudio", "Navejas", "Onofre", "Manriquez", "Ocanas",
                   "Diosdado", "Agustin", "Pascual", "Quijada", "Sauceda", "Cuebas", "Arciniega", "Aybar", "Aguayo",
                   "Delangel", "Lizama", "Mireles", "Muralles", "Milanes", "Marcial", "Vitela", "Santos", 
                   "Checo", "Vides", "Moreta", "Viteri", "Rascon", "Cardiel", "Terrero", "Burgueno", "Florian",
                   "Dejesus", "Macedo", "Verdugo", "Sais", "Duque", "Urioste", "Morataya", "Chinchilla", "Collado",
                   "Gutierres", "Poncedeleon", "Arroyos", "Almeda", "Chavero", "Zumba", "Amparo", "Victorio", "Aguado",
                   "Saragosa", "Belman", "Galindez", "Bailon", "Arrieta", "Ceja", "Tinoco", "Salvatierra", "Mayen",
                   "Betances", "Escalera", "Anzaldua", "Salado", "Ramirezramirez", "Pla", "Osornio", "Pando", "Lobos",
                   "Barranco", "Ceballos", "Buendia", "Bustillo", "Maradiaga", "Luna", "Tejada", "Guillermo", "Colocho",
                   "Julio", "Villicana", "Flamenco", "Rovira", "Segarra", "Balbuena", "Lafuente", "Breton",
                   "Santistevan", "Cota", "Cruzgarcia", "Villescas", "Huerta", "Arroyo", "Amezquita", "Dieguez", "Ley",
                   "Encarnacion", "Ayon", "Artiaga", "Marine", "Costales", "Delgadillo", "Cabezas", "Navarrette",
                   "Tacuri", "Baros", "Rosa", "Ambrosio", "Almazan", "Matus", "Maximo", "Neri", "Parras", "Alejo",
                   "Orihuela", "Granados", "Ocampo", "Tadeo", "Turrubiartes", "Urquilla", "Trujillo", "Astacio",
                   "Delossantos", "Renovato", "Berrio", "Banegas", "Parrilla", "Velasquez", "Ledezma", "Sedillo",
                   "Caro", "Barrientos", "Crisostomo", "Landin", "Cerrato", "Fimbres", "Antuna", "Cardona", "Ramirez",
                   "Santillano", "Morocho", "Cantero", "Gordillo", "Mateos", "Oyervides", "Modesto", "Samora",
                   "Oliveros", "Cerna", "Valle", "Abundis", "Urias", "Gurule", "Beltre", "Abad", "Lechuga",
                   "Villalovos", "Canas", "Aguilar", "Chaparro", "Muniz", "Fraire", "Orozco", "Benavente", "Rosete",
                   "Iturralde", "Interiano", "Castello", "Cano", "Serna", "Lobato", "Chavarin", "Arcos", "Alferez",
                   "Jiminez", "Tovar", "Patlan", "Elvir", "Delamora", "Ronquillo", "Casares", "Arboleda", "Monzon",
                   "Cartagena", "Alanis", "Cancino", "Pedregon", "Romo", "Sanmiguel", "Fresquez", "Tejeda",
                   "Mascarenas", "Astorga", "Daza", "Pena", "Gomezgarcia", "Burciaga", "Archibeque", "Landaverde",
                   "Leonardo", "Salcedo", "Valles", "Padilla", "Urbina", "Pichardo", "Osegueda", "Isidoro", "Elizalde",
                   "Meza", "Elizondo", "Manzo", "Claudio", "Verde", "Mesta", "Chagolla", "Mero", "Marcano", "Almaguer",
                   "Calcano", "Jimenes", "Cortez", "Alameda", "Paredez", "Jacome", "Fraga", "Balandran", "Avelar",
                   "Nanez", "Coria", "Palomera", "Montalbo", "Miera", "Briseno", "Osorno", "Mangual", "Carreon",
                   "Rayon", "Chico", "Deherrera", "Arredondo", "Garcilazo", "Riera", "Zorrilla", "Salaz", "Millan",
                   "Zaldivar", "Vialpando", "Deavila", "Gayton", "Gloria", "Vaca", "Arevalos", "Mantilla", "Lizaola",
                   "Reynosa", "Monterrosa", "Nogales", "Hernandezgarci", "Artiga", "Villarreal", "Cobian", "Arizpe",
                   "Morga", "Galvez", "Secundino", "Oceguera", "Atencio", "Almodovar", "Lezama", "Malacara",
                   "Castrellon", "Pedrosa", "Lopezmartinez", "Valenzuela", "Ramos", "Alonso", "Tinajero", "Alfonso",
                   "Zapien", "Canul", "Borunda", "Delpozo", "Iriarte", "Bargas", "Abreu", "Minero", "Gavilanes",
                   "Nadal", "Echavarria", "Salgado", "Gil", "Pomales", "Fajardo", "Urena", "Guel", "Estrada", "Beltran",
                   "Martinezlopez", "Domenech", "Baquero", "Yniguez", "Orrego", "Parra", "Presas", "Barco", "Tirado",
                   "Espiritu", "Cobo", "Fraijo", "Arguelles", "Amesquita", "Aceituno", "Eugenio", "Perezramirez",
                   "Enamorado", "Roblero", "Piceno", "Rafael", "Sotomayor", "Reyes", "Portillo", "Sanchezlopez",
                   "Rubio", "Vences", "Alva", "Zea", "Alba", "Garibaldi", "Subia", "Lopezhernandez", "Villegas",
                   "Mayoral", "Adames", "Iglesias", "Gaspar", "Garciamartinez", "Cuellar", "Ruelas", "Inda", "Frutos",
                   "Murcia", "Revuelta", "Cerros", "Mendieta", "Zayas", "Falcon", "Mercado", "Berrios", "Viveros",
                   "Torre", "Gurrola", "Morelos", "Baza", "Henandez", "Monteagudo", "Turcios", "Guillen", "Corado",
                   "Mayor", "Riviera", "Aguas", "Ontiveros", "Linares", "Lopezgonzalez", "Oros", "Carranza", "Fiallos",
                   "Calix", "Loeza", "Fierro", "Calvario", "Lamadrid", "Sarria", "Paredes", "Quirino", "Hernandes",
                   "Catala", "Cristobal", "Prudencio", "Mojica", "Garsia", "Dedios", "Morquecho", "Antillon", "Villeda",
                   "Antonio", "Feria", "Serrano", "Pereyra", "Muriel", "Arriaga", "Villafane", "Pimentel", "Cortes",
                   "Zertuche", "Esquivel", "Larios", "Puma", "Cibrian", "Sanchezgarcia", "Doria", "Pasillas", "Mora",
                   "Montemayor", "Montez", "Aros", "Arguello", "Vielma", "Bastida", "Robledo", "Liera", "Madera",
                   "Almada", "Olan", "Nerio", "Luviano", "Villasana", "Navar", "Maya", "Atilano", "Faria", "Gaona",
                   "Valadez", "Lucero", "Blanco", "Cedillo", "Sevillano", "Ibarra", "Castellanos", "Zenteno", "Rey",
                   "Garces", "Garciahernande", "Marrero", "Rochin", "Alcaraz", "Herrada", "Sixtos", "Sotolongo",
                   "Alejos", "Mata", "Prado", "Borjas", "Lajara", "Lebron", "Pina", "Barriga", "Toral", "Carrion",
                   "Velazco", "Capote", "Aguinaga", "Forero", "Galicia", "Perezhernandez", "Trevizo", "Merino",
                   "Lopezsanchez", "Jacobo", "Vargas", "Galan", "Delpino", "Valdiviezo", "Plancarte", "Borrayo",
                   "Elizarraras", "Alejandro", "Almonte", "Palomo", "Quintero", "Andino", "Geronimo", "Duenes",
                   "Monrreal", "Iracheta", "Caraballo", "Sanchez", "Bretado", "Orta", "Salmeron", "Felix", "Perdomo",
                   "Lema", "Tello", "Vizcarrondo", "Miguel", "Mateo", "Lux", "Cordoba", "Soza", "Flecha", "Madueno",
                   "Borquez", "Sarmiento", "Segoviano", "Pablo", "Delaluz", "Nieto", "Borboa", "Sarinana", "Mercedes",
                   "Rabago", "Ruis", "Sierra", "Ulibarri", "Villavicencio", "Dimas", "Avendano", "Muro", "Abarca",
                   "Mijangos", "Cuadrado", "Escatel", "Campana", "Betancur", "Germosen", "Yslas", "Zubiate",
                   "Martinezperez", "Vila", "Unzueta", "Tapia", "Mira", "Tavera", "Ambriz", "Sandate", "Cubero",
                   "Camero", "Quesada", "Ferrel", "Najarro", "Lira", "Sanjuan", "Troncoso", "Palmerin", "Marti",
                   "Huizar", "Bernal", "Lujan", "Tejera", "Milla", "Robles", "Melendrez", "Saiz", "Florez", "Oropeza",
                   "Montana", "Villalpando", "Carranco", "Palomino", "Melara", "Borja", "Escajeda", "Sifuentes",
                   "Camacho", "Sauseda", "Bazan", "Delcid", "Gramajo", "Mejorado", "Regalado", "Martir", "Diazdeleon",
                   "Lopezrodriguez", "Santamaria", "Neira", "Ordonez", "Galaviz", "Cesena", "Orantes", "Reynaga",
                   "Medel", "Archuleta", "Calle", "Moncada", "Ambrocio", "Vilchez", "Arvelo", "Yescas", "Barragan",
                   "Malpica", "Serano", "Taveras", "Colin", "Celedon", "Vizcarra", "Gonsales", "Blea", "Llanas",
                   "Barocio", "Mauricio", "Orduna", "Molinar", "Candelario", "Delapaz", "Astudillo", "Vera", "Carino",
                   "Berber", "Molina", "Olivera", "Jacquez", "Yzaguirre", "Jose", "Payan", "Barrientes", "Velasques",
                   "Agudo", "Delariva", "Davila", "Beato", "Montilla", "Montoya", "Cosio", "Franco", "Villarruel",
                   "Palma", "Valdespino", "Noguera", "Laguna", "Arizaga", "Sibrian", "Moctezuma", "Marchena",
                   "Mendivil", "Coronado", "Lopera", "Baena", "Ballesteros", "Samayoa", "Sostre", "Valdovinos",
                   "Constante", "Cobos", "Almanzar", "Lares", "Garay", "Llanes", "Fierros", "Sotello", "Olague",
                   "Sinchi", "Colmenares", "Villa", "Carrera", "Canales", "Marines", "Bonifacio", "Bello", "Baltierra",
                   "Jaime", "Malave", "Galo", "Betancourt", "Casias", "Nolasco", "Delagarza", "Rodarte", "Cerritos",
                   "Melgoza", "Luciano", "Justo", "Urbieta", "Lazcano", "Carreras", "Reza", "Peres", "Radilla",
                   "Sedano", "Tolentino", "Abalos", "Caamano", "Balboa", "Corro", "Provencio", "Rico", "Iniguez",
                   "Avellaneda", "Canseco", "Arjona", "Soto", "Parada", "Galindo", "Reina", "Conejo", "Avila",
                   "Colunga", "Marquina", "Bahena", "Degante", "Apodaca", "Quiles", "Avalos", "Cantor", "Lombera",
                   "Funez", "Alejandre", "Cuenca", "Federico", "Novelo", "Carias", "Monsivais", "Cabeza", "Rauda",
                   "Matamoros", "Pinedo", "Ramales", "Toledano", "Borjon", "Chiriboga", "Arrazola", "Baires", "Rayos",
                   "Holguin", "Cordova", "Camargo", "Solis", "Urgiles", "Felan", "Gudiel", "Azpeitia", "Farias",
                   "Fernando", "Barrantes", "Melgar", "Cadenas", "Miron", "Barrientez", "Valdez", "Cintron", "Siller",
                   "Avitia", "Quiroa", "Partida", "Villacorta", "Islas", "Recendiz", "Depaz", "Beas", "Reyesgarcia",
                   "Liranzo", "Serra", "Recinos", "Aramburo", "Valdivia", "Galdamez", "Santoyo", "Mina", "Zeledon",
                   "Riquelme", "Montano", "Isidro", "Acero", "Viscarra", "Espinoza", "Guaman", "Saito", "Rael",
                   "Miranda", "Delbosque", "Castaneda", "Jurado", "Sanz", "Luevano", "Macario", "Espada", "Valentin",
                   "Lozada", "Reyna", "Jorge", "Ortuno", "Ascencio", "Sanroman", "Cabreja", "Rodriquez", "Familia",
                   "Villalta", "Talavera", "Alicea", "Gonsalez", "Hurtado", "Aboytes", "Antunez", "Maldonado",
                   "Caudillo", "Figeroa", "Socarras", "Anzaldo", "Dorta", "Saldierna", "Morejon", "Dilone", "Ardila",
                   "Rolon", "Batres", "Serpa", "Sainz", "Class", "Baldonado", "Valladares", "Londono", "Jaimez",
                   "Rondon", "Oseguera", "Sena", "Otero", "Cevallos", "Garate", "Pimienta", "Lopezcruz", "Gutierrez",
                   "Alatorre", "Terriquez", "Villanueva", "Fonseca", "Cajamarca", "Penate", "Granda", "Balleza",
                   "Laracuente", "Macias", "Gamez", "Larrea", "Barillas", "Chihuahua", "Bustamante", "Palomares",
                   "Barona", "Grimaldo", "Villela", "Zaragoza", "Rendon", "Resto", "Galaz", "Artiles", "Polo", "Roman",
                   "Conchas", "Concepcion", "Cacho", "Melena", "Fiorentino", "Delcarmen", "Contreras", "Argumedo",
                   "Alaniz", "Avina", "Arbelaez", "Palacios", "Severino", "Vidal", "Zamorano", "Pacheco", "Verastegui",
                   "Pulido", "Morena", "Hidalgo", "Ovalle", "Ravelo", "Mejias", "Higareda", "Trejos", "Perezlopez",
                   "Gomezlopez", "Dealba", "Esquivias", "Zaldana", "Barela", "Muzquiz", "Cadena", "Barberena",
                   "Casarez", "Montanez", "Coss", "Espinosa", "Mascorro", "Canez", "Neyra", "Sepulveda", "Reta",
                   "Quijano", "Delosreyes", "Escandon", "Trinidad", "Esteves", "Matta", "Paucar", "Talamante",
                   "Manrique", "Melecio", "Mendez", "Duran", "Bracamonte", "Tabora", "Casanova", "Cisnero", "Lazaro",
                   "Loyola", "Panduro", "Bojorquez", "Marchan", "Reynoso", "Mujica", "Villalona", "Urenda", "Ruano",
                   "Sola", "Yepes", "Maes", "Oliva", "Cueto", "Brea", "Vallin", "Barajas", "Uriostegui", "Segura",
                   "Moya", "Banderas", "Andrades", "Lovato", "Pompa", "Nunez", "Maria", "Morfin", "Castor", "Laureano",
                   "Trochez", "Valverde", "Salto", "Raudales", "Velez", "Escobar", "Capistran", "Martinezgarcia",
                   "Matias", "Leandro", "Portales", "Coello", "Urieta", "Benitez", "Tellez", "Bayona", "Degollado",
                   "Rijo", "Marrufo", "Dorame", "Guity", "Colorado", "Saldivar", "Salvador", "Abrego"]}

native_american_names = {
    "last_names": ["Rosetta", "Todechine", "Jock", "Custalow", "Blacklance", "Stcyr", "Littledog", "Charette", "Sunday",
                   "Tritt", "Gene", "Tecumseh", "Tarbell", "Capitan", "Poyer", "Swimmer", "Navajo", "Blackbear",
                   "Holgate", "Tubby", "Fragua", "Maybee", "Silversmith", "Malmay", "Dubray", "Braveheart", "Wallette",
                   "Tallbull", "Bigbear", "Osceola", "Redeagle", "Goodbird", "Shomo", "Leask", "Blackeagle", "Treat",
                   "Medicinehorse", "Lameman", "Dixey", "Davids", "Bark", "Mcanally", "Keeto", "Larvie", "Hilderbrand",
                   "Greybear", "Beaudry", "Burshia", "Harker", "Mouse", "Tommy", "Killion", "Whiteface", "Nastacio",
                   "Douville", "Liner", "Maracle", "Lossiah", "Cly", "Tsinnijinnie", "Vandiver", "Shorthair", "Colombe",
                   "Becenti", "Atene", "Poolaw", "Prue", "Oldbear", "Chair", "Waseta", "Bitsue", "Ironwing",
                   "Vermillion", "Peynetsa", "Sepulvado", "Alden", "Whitehair", "Ironcloud", "Billy", "Daw",
                   "Yellowhair", "Whitewolf", "Nosie", "Littlethunder", "Hollowhorn", "Hillis", "Fleury", "Printup",
                   "Martine", "Pappan", "Gooday", "Moquino", "Mohawk", "Nason", "Dushkin", "Topping", 
                   "Killsnight", "Gust", "Finkbonner", "Edaakie", "Stiffarm", "Butterfly", "Skinaway", "Shanta",
                   "Cosen", "Cisco", "Cadotte", "Blackdeer", "Capoeman", "Tsinnie", "Danforth", "Atcitty", "Bitsoi",
                   "Demoski", "Ghost", "Angaiak", "Belgarde", "Charley", "Valliere", "Lasiloo", "Ike", "Pinkham",
                   "Fasthorse", "Truax", "Parkhurst", "Whiteowl", "Longee", "Mountain", "Spottedeagle", "Andreas",
                   "Elm", "Littlebear", "Cozad", "Deswood", "Lehi", "Warrington", "Bigeagle", "Twiss", "Valley",
                   "Hubbell", "Labatte", "Adakai", "Apachito", "Flute", "Arviso", "Talk", "Klain", "Max", "Standridge",
                   "Woodman", "Manygoats", "Schurz", "Toya", "Herrod", "Kingfisher", "Eades", "Reevis", "Whiteplume",
                   "Stabler", "Evan", "Bitsoie", "Cassa", "Beyale", "Lieb", "Valandra", "Vallo", "Wildcat", "Girty",
                   "Suina", "Lamebull", "Yandell", "Drennan", "Funmaker", "Renville", "Mesteth", "Decory", "Gordy",
                   "Garfield", "Gardipee", "Redstar", "Wassillie", "Fred", "Hooke", "Verrett", "Ivanoff", "Lecompte",
                   "Juneau", "Wahnee", "Delozier", "Deerinwater", "Maney", "Shangin", "Twitchell", "Jumper",
                   "Runningcrane", "Enjady", "Grinnell", "Masten", "Laverdure", "Haskie", "Demarrias", "Redeye",
                   "Parisien", "Trueblood", "Cayaditto", "Yellowbird", "Bohanan", "Broncheau", "Yahola", "Bercier",
                   "Whitecloud", "Seminole", "Tobey", "Sarracino", "Willow", "Littlewolf", "Neztsosie", "Whitebird",
                   "Denoyer", "Yellowhorse", "Norcross", "Bowekaty", "Adson", "Youpee", "Blackbird", "Bevins", "Enno",
                   "Ganadonegro", "Brien", "Ezernack", "Duane", "Paddock", "Goodbear", "Cayou", "Tessay", "Whitehat",
                   "Rhodd", "Cypress", "Foret", "Ofield", "Ducheneaux", "Decorah", "Yellowboy", "Halwood", "Tohannie",
                   "Williston", "Roubideaux", "Slim", "Gambler", "Declay", "Fastwolf", "Belcourt", "Hornbuckle",
                   "Hoskie", "Carlile", "Thinn", "Blackwater", "Rattler", "Blacksmith", "Nicolai", "Charlie",
                   "Charbonneau", "Trosclair", "Stick", "Notafraid", "Salway", "Sando", "Teeple", "Bellanger", "Ramone",
                   "Kalmakoff", "Suke", "Valdo", "Kenneth", "Pickup", "Diver", "Keeble", "Ayze", "Deacon",
                   "Buster", "Frankson", "Hogner", "Eaglestar", "Gopher", "Whitebear", "Makil", "Marcellais", "Barse",
                   "Pioche", "Stops", "Nockideneh", "Mustache", "Quiver", "Wauneka", "Polacca", "Ojibway", "Tunney",
                   "Mangan", "Blackcloud", "Stalker", "Cuch", "Slinkey", "Sagataw", "Alloway", "Bekis", "Sully",
                   "Lomayaktewa", "Zahne", "Dry", "Haukaas", "Dundas", "Billie", "Chickaway", "Bushman", "Gonnie",
                   "Smoker", "Redwine", "Kanuho", "Bitsui", "Leno", "Wayman", "Latray", "Bodfish", "Maize", "Isham",
                   "Oxendine", "Roanhorse", "Smiling", "Bonnie", "Birdshead", "Fryberg", "Blackowl", "Barnaby",
                   "Walkingstick", "Delorme", "Tullie", "Sherlock", "Quaderer", "Blackcrow", "Freemont", "Saunooke",
                   "Kie", "Pigeon", "Nephew", "Boni", "Comby", "Standingbear", "Bagola", "Kenton", "Fulwilder", "Cata",
                   "Stgermaine", "Todacheene", "Raper", "Bia", "Haven", "Stately", "Jojola", "Yazzie", "Ironhawk",
                   "Poitra", "Charboneau", "Homer", "Pitka", "Bigby", "Monette", "Brunet", "Natonabah", "Newago",
                   "Kessay", "Rabbit", "Killsinwater", "Twocrow", "Watchman", "Dazen", "Montour", "Benge", "Chischilly",
                   "Katchatag", "Hosteen", "Blackhawk", "Arquette", "Fixico", "Sevenstar", "Gervais", "Justin",
                   "Mexicano", "Botts", "Payer", "Redcloud", "Seyler", "Jeanotte", "Hilburn", "Beans", "Bert", "Fuson",
                   "Horsechief", "Garbow", "Brisbois", "Johnny", "Laroche", "Hatathlie", "Stead", "Heminger", "Babbitt",
                   "Bitsinnie", "Highelk", "Evanoff", "Malaterre", "Logg", "Dauphinais", "Chancellor", "Battise",
                   "Bonito", "Broncho", "Danks", "Doxtator", "Tallchief", "Carrick", "Ironshell", "Monte",
                   "Heavyrunner", "Madplume", "Solet", "Lazore", "Flett", "Chaisson", "Honie", "Blackfox", "Clah",
                   "Vivier", "Limberhand", "Girdner", "Spino", "Shangreaux", "Demientieff", "Birdinground", "Edmo",
                   "Dosela", "Bordeaux", "Tall", "Quinton", "Wind", "Claymore", "Manheimer", "Deschine", "Burd",
                   "Shortman", "Mccovey", "Harney", "Zunie", "Salois", "Twoeagle", "Seabolt", "Smoke", "Whiterock",
                   "Blossom", "Drywater", "Doney", "Poncho", "Whitewater", "Chief", "Bill", "Grass", "Traversie",
                   "Whiteeyes", "Bitsuie", "Beston", "Spottedwolf", "Arch", "Russel", "Mexican", "Bullbear",
                   "Cournoyer", "Rondeau", "Tsoodle", "Coriz", "Augare", "Shakespeare", "Roehl", "Lafave", "Echohawk",
                   "Goodluck", "Vanderpool", "Quam", "Yankton", "Tahy", "Kindelay", "Spry", "Kipp", "Tony", "Benny",
                   "Lente", "Labarge", "Boivin", "Stash", "Parisian", "Naha", "Stclaire", "Amyotte", "Steven", "Decora",
                   "Abrahamson", "Gritts", "Jandreau", "Gasper", "Shije", "Fallis", "Bible", "Yelloweagle", "Kinsel",
                   "Redhair", "Rouillard", "Leviner", "Worcester", "Largo", "Mccurtain", "Moose", "Waukau", "Sisto",
                   "Blackie", "Deese", "Dickenson", "Factor", "Neptune", "Lamere", "Allery", "Bowker", "Cambridge",
                   "Nicholai", "Twohearts", "Tsethlikai", "Meshell", "Azure", "Blueeyes", "Owle", "Jourdain",
                   "Eagleman", "Descheny", "Secody", "Tourtillott", "Holmberg", "Graymountain", "Tachine", "Yallup",
                   "Laclair", "Dardar", "Peneaux", "Analla", "Deckard", "Pancho", "Tocktoo", "Morningstar",
                   "Archambault", "Battiest", "Marchand", "Youngbird", "Fallsdown", "Redhouse", "Watahomigie", "Alcott",
                   "Mescal", "Numkena", "Deverney", "Brunette", "Teton", "Stands", "Alexie", "Mcnac", "Antone",
                   "Greeley", "Herder", "Brake", "Ninham", "Eustace", "Benallie", "Ahhaitty", "Hostler", "Honea",
                   "Loring", "Goulet", "Metoxen", "Parton", "Clyde", "Smallcanyon", "Horse", "Benally", "Ballot",
                   "Gilpin", "Bighorse", "Bedoni", "Redwing", "Pilcher", "Dougi", "Lirette", "Whitebuffalo", "Tsosie",
                   "Lodrigue", "Yellowhawk", "Canuto", "Whiteshirt", "Bigboy", "Sockey", "Cottier", "Madosh",
                   "Whisenhunt", "Slick", "Mcculley", "Paquin", "Shamblin", "Jimmie", "Bowannie", "Whitehouse",
                   "Ellenwood", "Ebarb", "Segay", "Slivers", "Devereaux", "Nomee", "Siers", "Snowball", "Tulley",
                   "Skenadore", "Laughter", "Leith", "Kameroff", "Decoteau", "Russette", "Belone", "Chasinghawk",
                   "Denetsosie", "Twist", "Weasel", "Etcitty", "Iceman", "Trudell", "Belonga", "Lafontaine", "Brave",
                   "Silverhorn", "Jimmy", "Thunder", "Brunk", "Wesaw", "Paxson", "Oakgrove", "Naquin", "Tommie",
                   "Littledave", "Wheelock", "Fawcett", "Blackhorse", "Mix", "Gunhammer", "Rope", "Larock", "Keeswood",
                   "Wero", "Eddie", "Cesspooch", "Torivio", "Waupoose", "Descheenie", "Skye", "Mcgirt", "Bighorn",
                   "Chatlin", "Ivins", "Procell", "Laplant", "Apache", "Thundercloud", "Lonebear", "Rodrigue",
                   "Realbird", "Livers", "Siow", "Keplin", "Marris", "Redhorn", "Kaquatosh", "Bigcrow", "Pahe",
                   "Whitford", "Hot", "Vielle", "Tortice", "Julius", "Arrow", "Swayney", "Dollar", "Goudreau",
                   "Longsoldier", "Ami", "Wilber", "Lohnes", "Goombi", "Terrance", "Cohoe", "Altaha", "Desjarlais",
                   "Bettelyoun", "Clairmont", "Ladeaux", "Booqua", "Loonsfoot", "Wassilie", "Frechette", "Redowl",
                   "Gunville", "Spottedelk", "Narcia", "Yeahquo", "Turtle", "Lafountain", "Baptisto", "Ahasteen",
                   "Oscar", "Woodell", "Soap", "Whitefeather", "Leclaire", "Fineday", "Morigeau", "Otten", "Drift",
                   "Blackgoat", "Wadena", "Goggleye", "Calabaza", "Shendo", "Cheatwood", "Whitebull", "Caulder", "Leaf",
                   "Stites", "Dock", "Silk", "Norberto", "Jourdan", "Martineau", "Paisano", "Gregoire", "Redshirt",
                   "Bullis", "Warrior", "Arcoren", "Stensgar", "Nofire", "Labelle", "Bahe", "Adolph", "Caddo", "Croy",
                   "Littlebird", "Desiderio", "Lussier", "Lafromboise", "Colelay", "Roan", "Polty", "Hoptowit", "Andy",
                   "Courville", "Begay", "Buffalohead", "Gouge", "Peaches", "Poorbear", "Barbone", "Yazza", "Farve",
                   "Bigpond", "Laducer", "Weahkee", "Belvin", "Ranger", "Jumbo", "Keezer", "Trancosa", "Mousseau",
                   "Cassadore", "Big", "Sawney", "Edenshaw", "Swallow", "Snake", "Halona", "Soulier", "Waskey",
                   "Catron", "Denetso", "Orso", "Hugs", "Spoonhunter", "Seneca", "Vandever", "Skenandore", "Joe",
                   "Holyan", "Basina", "Twinn", "Gachupin", "Callison", "Bitsilly", "Standingrock", "Lefthandbull",
                   "Purser", "Narcho", "Baloo", "Deroche", "Nickey", "Henio", "Goldtooth", "Honanie", "Cheromiah",
                   "Begody", "Larocque", "Tahe", "Tisi", "Cuny", "Paden", "Redday", "Chippewa", "Deatherage",
                   "Dreadfulwater", "Blatchford", "Keyonnie", "Bluebird", "Verret", "Thunderhawk", "Littlewhiteman",
                   "Runningbear", "Gokey", "Hunnicutt", "Billsie", "Tomah", "Standing", "Chapo", "Littlewind", "Steve",
                   "Buffalo", "Goseyun", "Redbird", "Corbine", "Villebrun", "Duboise", "Looper", "Lebeau", "Cheater",
                   "Reano", "Chinana", "Rolin", "Yepa", "Perrault", "Melot", "Clitso", "Mcgehee", "Walkingeagle",
                   "Blackwolf", "Larney", "Kellywood", "Abeita", "Muskrat", "Billey", "Marrietta", "Yellowman",
                   "Laroque", "Bow", "Lalio", "Cree", "Countryman", "Chavarillo", "Sleeper", "Buckles", "Pelt", "Fatt",
                   "Catches", "Stopp", "Hillaire", "Firethunder", "Garrow", "Ludlow", "Dumont", "Primeaux", "Payment",
                   "Armajo", "Chatto", "Bohanon", "Fleetwood", "Kerley", "Feather", "Kingbird", "Twobulls", "Arpan",
                   "Bushyhead", "Ballou", "Lestenkof", "Standingelk", "Osife", "Amiotte", "Dumarce", "Poupart",
                   "Kallestewa", "Orcutt", "Lansing", "Lowrey", "Nick", "Bruguier", "Desautel", "Weddell", "Powless",
                   "Eriacho", "Berryhill", "Kisto", "Postoak", "Whiteeagle", "Tilden", "Etsitty", "Parfait", "Crank",
                   "Kokrine", "Milford", "Dake", "Claw", "Secatero", "Redelk", "Spang", "Lavallie", "Iron",
                   "Kaulaity", "Evon", "Messerly", "Hyden", "Skeets", "Chiago", "Dann", "Waln", "Impson",
                   "Antelope", "Loftis", "Brunelle", "Kettle", "Littleman", "Cowboy", "Dedman", "Picotte", "Redfeather",
                   "Skeet", "Brockie", "Peone", "Todacheenie", "Marceau", "Burbank", "Goodshield", "Grimmett", "Oldman",
                   "Silago", "Rexford", "Namoki", "Summerfield", "Haskan", "Oats", "Spottedbear", "Panther", "Gladue",
                   "Springwater", "Talayumptewa", "Kompkoff", "Colegrove", "Gobert", "Pecos", "Lasley", "Olanna",
                   "Zuni", "Denetclaw", "Wanna", "Denison", "Deere", "Windyboy", "Tabaha", "Deer", "Swett", "Vanzile",
                   "Racine", "Trottier", "Redfox", "Demontiney", "Active", "Werito", "Dull", "Chosa", "Columbus",
                   "Sylestine", "Bedonie", "Runninghawk", "Janis", "Bigman", "Alberts", "Bourdon", "Poorman", "Drapeau",
                   "Longie", "Delgarito", "Matt", "Bob", "Birdtail", "Astor", "Badonie", "Greymountain", "Cadman",
                   "Littlelight", "Olney", "Jeff", "Whitekiller", "Gishie", "Bancroft", "Nayokpuk", "Hugo",
                   "Jumpingeagle", "Tobacco", "Chalepah", "Manymules", "Teller", "Mcgeshick", "Archambeau", "Aday",
                   "Rickman", "Aleck", "Nez", "Bitsie", "Laughing", "Flyinghorse", "Cate", "Sixkiller", "Whitehawk",
                   "Merculief", "Buckman", "Tartsah", "Saunsoci", "Rustin", "Kitcheyan", "Lupe", "Tatsey", "Tapaha",
                   "Ethelbah", "Werk", "Demmert", "Bresette", "Pearman", "Defoe", "Loretto", "Fourkiller", "Guerue",
                   "Laforge", "Bobelu", "Neadeau", "Grignon", "Attakai", "Shorty", "Americanhorse", "Dejolie", "Carle",
                   "Creppel", "Greyeyes", "Pepion", "Dupris", "Tyndall", "Keams", "Gourneau", "Ketcher", "Lafountaine",
                   "Whitehorse", "Gwin", "Youngman", "Cosay", "Vicenti", "Northrup", "Minthorn", "Lonewolf", "Teehee",
                   "Pourier", "Mckerchie", "Dugi", "Brigman", "Shoemake", "Dayzie", "Bremner", "Nault", "Gourd", "Noah",
                   "Onefeather", "Whiteshield", "Ladue", "Coho", "Buzzard", "Parrie", "Zephier", "Quickbear",
                   "Turcotte", "Scraper", "Autaubo", "Herne", "Conners", "Morsette", "Hummingbird", "Bissonette",
                   "Byington", "Ridgway", "Stillday", "Locklear", "Corn", "Schuyler", "Muskett", "Manuelito", "Star",
                   "Blackelk", "Causley", "Peshlakai", "Mute", "Pewo", "Drum", "Bread", "Vanpelt", "Mose",
                   "Begaye", "Lefthand", "Spottedhorse", "Yoe", "Redhorse", "Pakootas", "Locust", "Badoni", "Clown",
                   "Lamont", "Seaboy", "Jake", "Bilagody", "Watashe", "Hinman", "Concho", "Notah", "Guardipee", "Lena",
                   "Speck", "Laduke", "Chuculate", "Waska", "Youngbear", "Feathers", "Pine", "Elk", "Eskeets",
                   "Tonasket", "Redbear", "Tah", "Maupin", "Eder", "Rave"]}

asian_names = {
    "first_names": ["Tailor", "Bhalla", "Look", "Roh", "Hao", "Bi", "Bunag", "Char", "Ravi", "Sunny", "Balasubramaniam",
                    "Yoshimoto", "Nay", "Shu", "Subramanian", "Moala", "Parveen", "Jeremy", "Gary", "Alisa", "Savannah",
                    "Zayan", "Arham", "Kate", "Sharon", "Jenna", "Alisha", "Leela", "Lauren", "Eva", "Kaitlyn",
                    "Mikael", "Joy", "Leah", "Tyler", "Kayden", "Crystal", "Mohamed", "Jason", "Myra", "Michael",
                    "Taylor", "Elise", "Lucy", "Maxwell", "Ayesha", "Zain", "Mohammed", "Erica", "Ava", "Harper",
                    "Doris", "Abdul", "Farhan", "Carina", "Lily", "Jessie", "Valerie", "Selina", "Alina", "Kevin",
                    "Amara", "Mandy", "Jace", "Eshal", "Tiffany", "Annie", "Samara", "Kyle", "Wendy", "Avery", "Shreya",
                    "Sabrina", "Xavier", "Anisha", "David", "Hayden", "Evelyn", "Bruce", "Leanna", "Hazel", "Bryan",
                    "Alan", "Amina", "Alexis", "Shayaan", "Lisa", "James", "Eileen", "Hanna", "Jasmine", "Nolan",
                    "Jocelyn", "Christy", "Anaya", "Kazi", "Samantha", "Nathan", "Raina", "Isla", "Alston", "Chelsea",
                    "Timothy", "Anthony", "Abdullah", "Ahad", "Gianna", "Jannatul", "Calvin", "Max", "Sarah", "Ashley",
                    "Jannat", "Sheldon", "Evan", "Aria", "Claire", "Kian", "Jun", "Veer", "Esther", "Elsa", "Diya",
                    "Eric", "Xander", "Yahya", "Amaya", "Vincent", "Arya", "Musa", "Lucas", "Hailey", "Karina", "Theo",
                    "Phoebe", "Tristan", "Brian", "Andrew", "Damon", "Devin", "Krish", "Md", "William", "Tanisha",
                    "Queenie", "Maryam", "Aliza", "Aileen", "Alvin", "Khadija", "Richard", "Owen", "Inaya", "Gavin",
                    "Elliot", "Hamza", "Hassan", "Ada", "Liyana", "Kimberly", "Helen", "Maximilian", "Daphne", "Manha",
                    "Diana", "Skylar", "Ishaan", "Arthur", "Ella", "Isaac", "Amira", "Sabiha", "Kenneth", "Derrick",
                    "Maya", "Luke", "Eleanor", "Madison", "Henry", "Arisha", "Maggie", "Kaleb", "Gabriel", "Shirley",
                    "Irene", "Ryder", "Zayn", "Niam", "Arjun", "Khloe", "Leon", "Amber", "Laura", "Joanna", "Bodhi",
                    "Zoey", "John", "Micah", "Danny", "Bonnie", "Saifan", "Nathaniel", "Emmanuel", "Kingsley", "Nikhil",
                    "Kira", "Aliyah", "Ophelia", "Adrian", "Jolin", "Keira", "Ahnaf", "Carter", "Scarlett", "Olivia",
                    "Angel", "Aurora", "Frank", "Sara", "Justin", "Felix", "Safa", "Selena", "Omar", "Rayyan", "Ariel",
                    "Armaan", "Johnny", "Nicholas", "Robert", "Kiara", "Christian", "Vanessa", "Ayra", "Ethan", "Cindy",
                    "Samuel", "Madelyn", "Gabriella", "Stephanie", "Emilia", "Vicky", "Lillian", "Brandon", "Miya",
                    "Ariella", "Levi", "Cecilia", "Aden", "Mila", "Mira", "Nina", "Mason", "Maliha", "Eden", "Abby",
                    "Winston", "Liana", "Tony", "Alyssa", "Livia", "Ahmed", "Lydia", "Syeda", "Kimi", "Steven",
                    "Sophia", "Celine", "Aayat", "Kai", "Christopher", "Peter", "Ahmad", "Joshua", "Luca", "Spencer",
                    "Lina", "Harry", "Ananya", "Edward", "Safwan", "Amir", "Sulaiman", "Stanley", "Jacob", "Aarav",
                    "Ivaan", "Feynman", "Mark", "Isabella", "Thomas", "Joyce", "Connor", "Fiona", "Carson", "Aliya",
                    "Stella", "Megan", "Jerry", "Theodore", "Elijah", "Aleena", "Abrar", "Elias", "Colin", "Alexander",
                    "Elena", "Simon", "Zachary", "Chloe", "Subhan", "Jasper", "Josephine", "Vera", "Rayna", "Eliana",
                    "Eshan", "Skyler", "Hunter", "Lawrence", "Ashton", "Adam", "Anson", "Catherine", "Sophie", "Jaden",
                    "Erin", "Enzo", "Nora", "Anya", "Louis", "Linda", "Sienna", "Cynthia", "Jimmy", "Angelina", "Yu",
                    "Layla", "Derek", "Isabel", "Samaira", "Adyan", "Eddie", "Wilson", "Alexa", "Ayan", "Eason",
                    "Mohammad", "Alicia", "Clara", "Rebecca", "Jessica", "Nicole", "Dua", "Raymond", "Julian",
                    "Charlotte", "Muhammad", "Anisa", "Katie", "Alexandra", "Naomi", "Edwin", "Aaron", "Reina",
                    "Summer", "Aayan", "Oscar", "Rohaan", "Elaine", "Lila", "Nelson", "Kaden", "Preston", "Isaiah",
                    "Jackson", "Norah", "Tahmid", "Shayan", "Anderson", "Terrence", "Hoorain", "Priscilla", "Andy",
                    "Roy", "Neil", "Matthew", "Katelyn", "Daisy", "Jamie", "Albert", "Dylan", "Liam", "Erika",
                    "Ayden", "Harrison", "Austin", "Darren", "Madeline", "Riya", "Angela", "Alfred", "Tenzin", "Tasnim",
                    "Grayson", "Ismail", "Iris", "Isabelle", "Jenny", "Brayden", "Bowen", "Anna", "Aiden", "Syed",
                    "Sarina", "Elizabeth", "Ricky", "Mina", "Brianna", "Allison", "Winnie", "Queena", "George", "Emma",
                    "Shawn", "Zoe", "Jia", "Kenny", "Kelly", "Julia", "Miranda", "Wyatt", "Amanda", "Caroline", "Anika",
                    "Bradley", "Audrey", "Ayaan", "Jeffrey", "Hao", "Ellie", "Natalie", "Vivian", "Sahil", "Sunny",
                    "Vihaan", "Faith", "Tina", "Eunice", "Leila", "Melanie", "Hana", "Hashim", "Saif", "Allen",
                    "Haniya", "Aaliyah", "Lia", "Rayan", "Cameron", "Ali", "Inaaya", "Nabiha", "Logan", "Terry",
                    "Riley", "Daniel", "Penelope", "Ivan", "Sebastian", "Luna", "Ian", "Violet", "Victor", "Aizah",
                    "Ayat", "Cody", "Jacqueline", "Eli", "Kaia", "Anjali", "Alice", "Hafsa", "Azaan", "Michelle",
                    "Ryan", "Katherine", "Marcus", "Noor", "Parker", "Rachel", "Edison", "Rehan", "Aidan", "Anne",
                    "Caleb", "Nusrat", "Jayden", "Kingston", "Gordon", "Amy", "Dean", "Roman", "Anayah", "Alayna",
                    "Sylvia", "Mia", "Asher", "Hannah", "Abigail", "Arianna", "Sofia", "Sherry", "Aarya", "Aahil",
                    "Serena", "Martin", "Lincoln", "Gia", "Chris", "Karen", "Bella", "Cyrus", "Madeleine", "Jennifer",
                    "Annika", "Sydney", "Elvis", "Giselle", "Mustafa", "Zainab", "Annabelle", "Connie", "Rohan", "Ruby",
                    "Renee", "Travis", "Aaryan", "Jonathan", "Hugo", "Christine", "Sean", "Jordan", "Arvin", "Kylie",
                    "Yusuf", "Kayla", "Oliver", "Aiza", "Muntaha", "Janice", "Jacky", "Khadijah", "Meera", "Ariana",
                    "Judy", "Emily", "Wesley", "Brendan", "Grace", "Xin", "Rhea", "Victoria", "Aisha", "Alex", "Joseph",
                    "Josiah", "Mahnoor", "Kabir", "Benjamin", "Mariam", "Hudson", "Leo", "Angus", "Noah", "Landon",
                    "Leonardo", "Emaan", "Benson", "Aditya", "Caden", "Patrick", "Angie", "Ivy", "Anabia", "Zara",
                    "Kyson", "Eshaal", "Yuna", "Charles", "Elina", "Amelia", "Ibrahim", "Kaylee", "Athena", "Christina",
                    "Zahra", "Cayden", "Melody", "Jack", "Hareem", "Jake", "Jay", "Zoya", "Aryan", "Aydin", "Fatima",
                    "Lena", "Chase"],

    "last_names": ["Nhan", "Yao", "Jou", "Buenaventura", "Shwe", "Lou", "Thai", "Shirai", "Mai", "Bhasin",
                   "Senthilkumar", "Zulueta", "Sor", "Jen", "Soundara", "Francia", "Miah", "Abidi", "Pancholi",
                   "Muranaka", "Chao", "Ramesh", "Koyama", "Vakharia", "Chang", "Kawabata", "Tengan", "Caballes",
                   "Manivong", "Cun", "Lhamo", "Hirano", "Arun", "Hum", "Hariharan", "Manaloto", "Ni", "Chen", "Len",
                   "Tani", "Huq", "Chiba", "Kalra", "Kham", "Sinha", "Miyoshi", "Manalastas", "Matsuoka", "Balagtas",
                   "Matharu", "Ao", "Matsuno", "Latif", "Nayyar", "Yon", "Hsiao", "Tamashiro", "Bath", "Halim", "Acoba",
                   "Soy", "Jamil", "Almario", "Kosaka", "Shakeel", "Soliven", "Tandoc", "Kafley", "Dayal", "Minhas",
                   "Potluri", "Kuwahara", "Ramasamy", "Ramones", "Goel", "Pathan", "Batra", "Fan", "Mukai", "Huda",
                   "Aftab", "Kazi", "Azad", "Tsu", "Nishiyama", "Zhai", "Rosal", "Makwana", "Matsuura", "Shum",
                   "Charania", "Talati", "Lagman", "Im", "Ramchandani", "Sanluis", "Barua", "Tesoro", "Sham", "Jared",
                   "Karnik", "Phouthavong", "Lo", "Saluja", "Taneja", "Quadri", "Kwok", "Cinco", "Torio", "Farooqi",
                   "Sikder", "Noguchi", "Goh", "Nakai", "Rozario", "Qian", "Shafi", "Guiang", "Somera", "Pandey",
                   "Mian", "Song", "Katayama", "Sanpedro", "Apte", "Hoo", "Ghosh", "Jow", "Salud", "Prum", "Cho",
                   "Danh", "Tamondong", "Pagdilao", "Dancel", "Tewari", "Jan", "Asai", "Rana", "Sachdev", "Halder",
                   "Hayakawa", "Narasimhan", "Sahai", "Bansal", "Thakur", "Sawada", "Hor", "Tham", "Foronda",
                   "Thammavongsa", "Vue", "Nonaka", "Miyahara", "Huy", "Lagasca", "Chon", "Kamal", "Shiraishi", "Chap",
                   "Pao", "Advincula", "Sapkota", "Talukder", "Naseem", "Kundu", "Sakuma", "Voong", "Hur", "Nip",
                   "Yokoyama", "Ravindran", "Wi", "Veloso", "Meas", "Kanno", "Sridharan", "Quizon", "Ren", "Kishore",
                   "Shahi", "Matsui", "Nepomuceno", "Thakker", "Mahajan", "Thapa", "Soo", "Hirani", "Akhtar", "Riaz",
                   "Lomboy", "Lei", "Hwang", "Khatoon", "Maqsood", "Tiu", "Mir", "Miyazaki", "Andal", "Menon", "Joung",
                   "Shang", "Jew", "Siddiqui", "Mascarenhas", "Kaya", "Khan", "Shergill", "Sandhu", "Mok", "Wah",
                   "Ramalingam", "Madarang", "Tonga", "Majumder", "Bagga", "Liem", "Edralin", "Tuong", "Basa", "Bista",
                   "Nath", "Zheng", "Sahni", "Sohail", "Pho", "Khare", "Lock", "Naidu", "Yum", "Yun", "Kothari",
                   "Rizal", "Liu", "Duggal", "Chern", "La", "Rama", "Tiwana", "Om", "Sherpa", "Teruya", "Mohapatra",
                   "Nand", "Szeto", "Thapar", "Parayno", "Qadri", "Takano", "Takaki", "Ikram", "Paw", "Guan", "Fang",
                   "Zhou", "Ona", "Sohi", "Foo", "Bayani", "Manzoor", "Quiambao", "More", "Si", "Tupas", "Yoshioka",
                   "Furuta", "Nakanishi", "Junio", "Kiang", "Soohoo", "Wijaya", "Villaruz", "Oba", "Ibay", "Banu",
                   "Murayama", "Toyama", "Khosla", "Shastri", "Kang", "Yousaf", "Khadka", "Sundararajan", "Halili",
                   "Biju", "Venkat", "Ya", "Jin", "Amir", "Yoon", "Sarin", "Chaudhri", "Madamba", "Tsutsui", "Terada",
                   "Payumo", "Touch", "Chim", "Narine", "Dev", "Seok", "Kodali", "Durrani", "Saesee", "Tsou", "Sul",
                   "Amante", "Basra", "Luthra", "Karthikeyan", "Hung", "Fong", "Galiza", "Jaffer", "Konishi",
                   "Benedicto", "Jeng", "Paraiso", "Haq", "Lalani", "Shee", "Mainali", "Isip", "Varkey", "Weng", "Kum",
                   "Sachdeva", "Malonzo", "Sakaguchi", "Uong", "Manlapaz", "Araki", "Motiwala", "Acharya", "Varshney",
                   "Mehdi", "Dhir", "Cung", "Nakatani", "Tripathi", "Kalidindi", "Bo", "Atienza", "Yin", "Suri", "Kil",
                   "Chuong", "Chien", "Sriram", "Lan", "Jindal", "Ruan", "Ganguly", "Phon", "Kadakia", "Mamaril",
                   "Asano", "Pol", "Vaghela", "Zahid", "Challa", "Bassi", "Hori", "Pong", "Siddiqi", "Khanal",
                   "Sultana", "Dabu", "Thao", "Zhuang", "Ioane", "Mathur", "Phann", "Villaflor", "Rajagopalan",
                   "Nishioka", "Matsuyama", "Naito", "Sua", "Ran", "Nessa", "Hanif", "Maeng", "Asis", "Cheuk",
                   "Narayanan", "Ozaki", "Sanghera", "Akram", "Pun", "Lama", "Hafeez", "Lacuesta", "Menezes",
                   "Jayaraman", "Tang", "Ashraf", "Vahora", "Chhetri", "Cariaga", "Otani", "Shakir", "Delkcruz", "Wada",
                   "Kikuchi", "Pok", "Hem", "Shafiq", "Shankar", "Master", "Kansara", "Cai", "Phung", "Yue", "Mitra",
                   "Paudel", "Sim", "Akamine", "Nisa", "Mahal", "Panjwani", "Kale", "Shenoy", "Qi", "Dinh", "Adnan",
                   "Htoo", "Subramaniam", "Policarpio", "Huang", "Paule", "Bolosan", "Chilukuri", "Chuck", "Yamanaka",
                   "Chacko", "Asim", "Ravikumar", "Desai", "Navalta", "Timsina", "Banaag", "Bae", "Ngai", "Vasudevan",
                   "Chi", "Mahadevan", "Mehta", "Baluyut", "Macadangdang", "Nguon", "Sardar", "Yem", "Jian",
                   "Vemulapalli", "Kishi", "Rim", "Pillar", "Yumul", "Ksor", "Mesina", "Nabong", "Balachandran", "Par",
                   "Vuu", "Ki", "Razzak", "Lata", "Shamsi", "Zhao", "Mizuno", "Choudhry", "Prabhu", "Adusumilli", "Suh",
                   "Sanyal", "Agnihotri", "Taketa", "Ke", "Dewan", "Jeong", "Pu", "Naval", "Munshi", "Basco", "Shamim",
                   "Nee", "Yalamanchili", "Prashad", "Wakabayashi", "Rangarajan", "Koshy", "Villarin", "Luc", "Patnaik",
                   "Magbanua", "Mistry", "Pervaiz", "Masaki", "Sue", "Dhanani", "Austria", "Langi", "Biswa", "Farooq",
                   "Phan", "Patwardhan", "Koh", "Vashi", "Ulep", "Koneru", "Manivanh", "Ma", "Cherukuri", "Yamagata",
                   "Tyagi", "Bella", "Ramiro", "Mohabir", "Matsumura", "Bahl", "Lieu", "Saelee", "Malabanan", "Wee",
                   "Surti", "Tomita", "Momin", "Afzal", "Kotha", "Jadhav", "Malhotra", "Ear", "Takhar", "Salam", "Ngu",
                   "Sattar", "Noronha", "Tee", "Alvi", "Nagano", "Thind", "Seshadri", "Der", "Hon", "Pillai", "Das",
                   "Siwakoti", "Jaswal", "Noda", "Jani", "Shams", "Puno", "Sengupta", "Hok", "Wai", "Oki", "Woon",
                   "Kun", "Arshad", "Teves", "Yonamine", "Murthy", "Hans", "Oka", "Aktar", "Koirala", "Arcilla",
                   "Iyengar", "Haroon", "Kobashigawa", "Kapadia", "Chiang", "Abuan", "Nayar", "Capulong", "Maknojia",
                   "Malek", "Ijaz", "Ghani", "Vaidya", "Chaturvedi", "Choun", "Ngo", "Lew", "Leng", "Bedi", "Jahangir",
                   "Kataria", "Subedi", "Chaudhari", "Panda", "Manalac", "Quraishi", "Dasari", "Chugh", "Somasundaram",
                   "Ashfaq", "Fazal", "Fok", "Shabbir", "Jaffery", "Duldulao", "Ramamoorthy", "Bao", "Jabbar",
                   "Yamamura", "Baloch", "Saran", "Yeom", "Saing", "Oo", "Cha", "Pathammavong", "Babu", "Abedin", "Xia",
                   "Kashyap", "Malik", "Chiu", "Gaviola", "Soeung", "Vongphakdy", "Hua", "Jang", "Nim", "Taira",
                   "Chinen", "Ngan", "Chawla", "Nagarajan", "Hamamoto", "Iftikhar", "Shibata", "Mangal", "Sutaria",
                   "Untalan", "Beharry", "Enomoto", "Furuya", "Miyahira", "Rho", "Tsuda", "Suthar", "De", "Badua",
                   "Chue", "Alikhan", "Qamar", "Masih", "Din", "Sahi", "Thi", "Chhum", "Bhatia", "Deshmukh",
                   "Gupta", "Hing", "Lapid", "Sankar", "Cabacungan", "Rafique", "Tanveer", "Guintu", "Gatdula", "Yagi",
                   "Chatterjee", "Yasin", "Hossain", "Chandrasekar", "Guo", "Macapagal", "Rafi", "Thang", "Bong",
                   "Shishido", "Imran", "Hizon", "Zhang", "Kothapalli", "Shiroma", "Cendana", "Bano", "Farooqui",
                   "Hsiung", "Soh", "Nayak", "Pili", "Sampath", "Seth", "Ando", "Cul", "Espina", "Lam", "Ige", "Banez",
                   "Rajan", "Khangura", "Cabana", "Amano", "Iwai", "Bhullar", "Nishi", "Narang", "Loi", "Sanghvi",
                   "Igarashi", "Magsino", "Irfan", "Murugesan", "Matsushima", "Sugimoto", "Safdar", "Tiwari", "Sahoo",
                   "Handa", "Kho", "Takada", "Hirose", "Puri", "Sawant", "Shahid", "Ramaswamy", "Khanom", "Manu",
                   "Orpilla", "Basnet", "Mangahas", "Aung", "Xiao", "Adhikari", "Mazhar", "Sayani", "Jiwani", "Mayeda",
                   "Park", "Lakshmanan", "Son", "Macaraeg", "Mallari", "Yung", "Takeshita", "Mushtaq", "Shiao", "Sekar",
                   "Chiao", "Rabbani", "Naing", "Dsilva", "Omori", "Nakamura", "Chio", "Ouch", "Azeem", "Soong", "Ejaz",
                   "Chhoeun", "Lyu", "Rajagopal", "Takemoto", "Tejani", "Paik", "Tuan", "Islam", "Pa", "Hui", "Hashmi",
                   "Bhatnagar", "Xi", "Ou", "Xayavong", "Phou", "Tonnu", "Uno", "Zee", "Uppalapati", "Ramiscal",
                   "Rawal", "Chander", "Bajpai", "Bun", "Rathore", "Alipio", "Kandasamy", "Co", "Vohra", "Capistrano",
                   "Choe", "Ally", "Paguirigan", "Pokharel", "Shanmugam", "Qadir", "Kwock", "Tam", "Sher", "Rafiq",
                   "Sicat", "Chhim", "Chong", "Mam", "Neupane", "Mong", "Ngov", "Sui", "Manoharan", "Aggarwal",
                   "Kurien", "Iida", "Guevarra", "Punjabi", "Chakraborty", "Quintos", "Le", "Imperial", "Luy", "Yasui",
                   "Kien", "Teo", "Mi", "Chiou", "Kwak", "Lakhani", "Ai", "Sathe", "Magpantay", "Saephan", "Kapur",
                   "Sarwar", "Laxamana", "Oun", "Rahman", "Songco", "Varadarajan", "Karri", "Sorn", "Xiang", "Aranas",
                   "Sugai", "Magar", "Barot", "Dhimal", "Jabeen", "Pasco", "Perumal", "Sankaran", "Ghaffar", "Jha",
                   "Noh", "Doan", "Amin", "Takenaka", "Salim", "Siddiq", "Ishaq", "Shoji", "Nasim", "Hin", "Kawashima",
                   "Kou", "Pradeep", "Yeo", "Liew", "Dass", "Tonthat", "Dcosta", "Randhawa", "Tada", "Penaflor",
                   "Chughtai", "Upreti", "Bandi", "Ouyang", "Chahal", "Ramcharan", "Pangan", "Kancharla", "Seang",
                   "Chhabra", "Sayavong", "Ueno", "Goyal", "Deng", "Chokshi", "Pyo", "Jassal", "Krishna", "Alapati",
                   "Ramkumar", "Chua", "Sulit", "Suguitan", "Sehgal", "Rajkumar", "Yep", "Purewal", "Ping", "Chann",
                   "Cheah", "Mannan", "Villena", "Venugopal", "Latu", "Ong", "Gowda", "Kwong", "Phal", "Ganti", "Soon",
                   "Manahan", "Ilyas", "Kieu", "Nijjar", "Gopinath", "Pilapil", "Maniar", "Khuon", "Moua",
                   "Balasubramanian", "Suk", "Akula", "Tuason", "Tith", "Situ", "Qiao", "Paulo", "Vaswani", "Toor",
                   "Thakkar", "Biswas", "Villaruel", "Nagpal", "Ching", "Leung", "Mukhopadhyay", "Philipose", "Purohit",
                   "Tanaka", "Suy", "Panicker", "Ghotra", "Regmi", "Chiong", "Lie", "Shetty", "Dy", "Dam",
                   "Arunachalam", "Inthavong", "Ganapathy", "Ek", "Amjad", "Hemani", "Ashok", "Meghani", "Catacutan",
                   "Kar", "Kishimoto", "No", "Du", "Lapuz", "Buan", "Toda", "Liou", "Sanjose", "Rattan",
                   "Chattopadhyay", "Dolma", "Okubo", "Goon", "Saraf", "Yokota", "Panganiban", "Boparai", "Prasla",
                   "Macatangay", "Usmani", "Lun", "Mandal", "Oberoi", "Cam", "Namba", "Razon", "Yu", "Zou", "Pandit",
                   "Matsuo", "Gaur", "Phommachanh", "Mui", "Kamdar", "Razzaq", "Kannan", "Cheang", "Teoh", "Bawa",
                   "Walla", "Dhingra", "Katta", "Maung", "Lingad", "Khuu", "Kaneko", "Youn", "Palisoc", "Jiang", "Vinh",
                   "Kha", "Jong", "Gorospe", "Natarajan", "Baguio", "Agpaoa", "Kamiya", "Borromeo", "Olaes", "Pagaduan",
                   "Dhungana", "Kamboj", "Varanasi", "Louie", "Balk", "Yasmin", "Akella", "Wei", "Khattak", "Kondo",
                   "Mac", "Tariq", "Tat", "Ohta", "Pamintuan", "Seki", "Kok", "Okimoto", "Que", "Saiki", "Venkatesan",
                   "Pervez", "Dalisay", "Ip", "Chun", "Tsan", "Stamaria", "Kuroda", "Choudhury", "Rathod", "Sampat",
                   "Jilani", "Bhola", "Sotto", "Brillantes", "Vachhani", "Zia", "Parikh", "Fujiwara",
                   "Saldanha", "Andrada", "Tin", "Chaudhary", "Dana", "Chui", "Shukla", "Chaudry", "Kaul",
                   "Yam", "Suda", "Tsuji", "Sze", "Kazmi", "Dhindsa", "Elahi", "Leota", "Soth", "Singhal", "Iwamoto",
                   "Cunanan", "Nishikawa", "Ny", "Bukhari", "Sethi", "Bose", "Insixiengmay", "Muramoto", "Huot",
                   "Kojima", "Caparas", "Yoshikawa", "Kurup", "Khamvongsa", "Gala", "Yuen", "Ge", "Thakar", "Raju",
                   "Aujla", "Sadiq", "Kyi", "Ilano", "Kumar", "Fukunaga", "Nawaz", "Te", "Pabla", "Sajjad", "Gupte",
                   "Nakayama", "Visitacion", "Pi", "Sa", "Okuda", "Yabut", "Ji", "Baral", "Fontanilla", "Kim", "Jim",
                   "Gang", "Yuan", "Ines", "Miu", "Lala", "Quon", "Madan", "Bang", "Balaji", "Hashim", "Ryoo", "Da",
                   "Keo", "Heer", "Viswanathan", "Agcaoili", "Jee", "Myung", "Ghuman", "Vijay", "Rigor", "Sastry",
                   "Shah", "Mall", "Santaana", "Saiyed", "Fujikawa", "Nguyen", "Ali", "Pannu", "Dionisio", "Calma",
                   "Cayabyab", "Koizumi", "Ng", "Niu", "Luu", "Zang", "Lien", "Bumanglag", "Sugiyama", "Aspiras",
                   "Miao", "Dino", "Buenviaje", "Umeda", "Parekh", "Misa", "Moy", "Cua", "Manglicmot", "Dixit", "Kido",
                   "Trinh", "Sheu", "Prasad", "Patil", "Soe", "Kissoon", "Phimmasone", "Sang", "Hong", "Manalili",
                   "Dhillon", "Uyehara", "Chari", "Dhesi", "Deperalta", "Alviar", "Auyeung", "Dulay", "Ravishankar",
                   "Han", "Tao", "Hinh", "Takara", "Hsing", "Masud", "Mehmood", "Mittal", "Vemuri", "Dungca", "Mei",
                   "Terrado", "Chuang", "Jalil", "Regala", "Mani", "Khandelwal", "Lachica", "Zhan", "Yo", "Lansang",
                   "Arca", "Lalwani", "Tecson", "Kaw", "Shariff", "Sagar", "Raut", "Nakasone", "Kuang", "Deb", "Trang",
                   "Yamashiro", "Sese", "Sunga", "Zubair", "Fujioka", "Hu", "Kabir", "Xian", "Teodoro", "Balan",
                   "Otsuka", "Buenaflor", "Brun", "Teng", "Su", "Jasti", "Dang", "Ayson", "Samala", "Miyasato",
                   "Sai", "Agha", "Capili", "Rong", "Maharjan", "Ninh", "Balakrishnan", "Hundal", "Ing", "Selvaraj",
                   "Wang", "Capati", "Sundaresan", "Bou", "Koy", "Tsai", "Topacio", "Ea", "Abueg", "Nagasawa",
                   "Jaiswal", "Garg", "Hyon", "Adachi", "Naik", "Chea", "Sakurai", "Dar", "Manickam", "Nadkarni",
                   "Vaid", "Raman", "Rami", "Yamauchi", "Niazi", "Singla", "Ka", "Abaya", "Kuan", "Mody", "Verzosa",
                   "Bokhari", "Khatiwada", "Cheung", "Choksi", "Setiawan", "Ly", "Ta", "Mochizuki", "Leang", "Leong",
                   "Yang", "Pang", "Siv", "Brar", "Saefong", "Sidhu", "Oommen", "Naseer", "Parungao", "Nakao",
                   "Sabharwal", "Panchal", "Shahzad", "Fujita", "Qu", "Baxi", "Domingo", "Chadha", "Sarkar", "Vijayan",
                   "Quitugua", "Fifita", "Javaid", "Shaik", "Kawai", "Radhakrishnan", "Panlilio", "Khin", "Chaudhuri",
                   "Kitagawa", "Mou", "Kukreja", "Doo", "Lodhi", "Marzan", "Soun", "Darjee", "Varughese", "Baek",
                   "Asato", "Landicho", "Lian", "Bharadwaj", "Rehman", "Fnu", "Kye", "Tso", "Poudel", "Ragasa",
                   "Kausar", "Raina", "Andaya", "Cabanilla", "Dave", "Sio", "Macalino", "Degracia", "Chanda", "Inamdar",
                   "Luk", "Vemula", "Pheng", "Bhandari", "Horiuchi", "Supnet", "Lavarias", "Hai", "Pasion", "Yeon",
                   "Tanabe", "Van", "Vaidyanathan", "Thieu", "Asad", "Kohli", "Faustino", "Jafri", "Tuy", "Ramani",
                   "Swamy", "Giri", "Parvin", "Shin", "Santhanam", "Hau", "Yi", "Mangat", "Ning", "Moo", "Di",
                   "Soliman", "Kashif", "Byun", "Kin", "Ryu", "Mansuri", "Liaw", "Upadhyaya", "Suresh", "Kwan", "Gip",
                   "Arya", "Zong", "Vangala", "Escano", "Ramroop", "Wu", "Oyama", "Gaddam", "Rhee", "Atluri", "Mondal",
                   "Kudo", "Yiu", "Mo", "Saha", "Aslam", "Tsao", "Ganesan", "Rajesh", "Okumura", "Liao", "Parajuli",
                   "Dhar", "Lardizabal", "Bak", "Salman", "Gan", "Hy", "Uyeno", "Khawaja", "Abellera", "Ramdass",
                   "Iwata", "Wahab", "Koo", "Tsuchiya", "Finau", "Dawood", "Nigam", "Dey", "Ramnarine", "Nagaraj",
                   "Dwivedi", "Darji", "Chowdhry", "Kolli", "Villamor", "Basdeo", "Chan", "Kem", "Mehrotra", "Asif",
                   "Sayson", "Coloma", "Tom", "Afridi", "Mughal", "Alluri", "Okazaki", "Sanagustin", "Akter", "Htwe",
                   "Trivedi", "Lum", "Fiesta", "Balingit", "Venkatachalam", "Sabado", "Loh", "Mazumder", "Dumlao",
                   "Lad", "Rin", "Magno", "Samra", "Gopal", "Gandhi", "Rizvi", "Pin", "Nadeem", "Devilla", "Narra",
                   "Khiev", "Suan", "Nandi", "Rasool", "Sangha", "Sam", "Budhu", "Solanki", "Hoang", "Estacio",
                   "Saechao", "Murugan", "Devi", "Paras", "Viado", "Rajput", "Nishida", "Ra", "Hun", "Quang", "Baik",
                   "Venkataraman", "Gunawan", "Raghunathan", "Khun", "Sahota", "Nie", "Khuc", "Dholakia", "Tak",
                   "Irani", "Em", "Widjaja", "Heo", "Ros", "Swaminathan", "Bagchi", "Saetern", "Adriano", "Reh",
                   "Malhi", "Goya", "Bhuiyan", "Arciaga", "Uppal", "Tajima", "Sharma", "Kong", "Hoque", "Prajapati",
                   "Antony", "Agbayani", "Salahuddin", "Kagawa", "Mey", "Murtaza", "Maglalang", "Eun", "Hak", "Viray",
                   "Chay", "Masood", "Yambao", "Manalang", "Manaois", "Villaluz", "Pokhrel", "Uy", "Vuong", "Srinivas",
                   "Delmundo", "Dung", "Albano", "Tummala", "Aguinaldo", "Jeung", "Aurelio", "Joshi", "Singh", "Rath",
                   "Inaba", "Kadam", "Tokunaga", "Pyon", "Altaf", "Kaushal", "Xue", "Palaniappan", "Heng",
                   "Bhattacharyya", "Braganza", "Khang", "Kadiyala", "Abadilla", "Goswami", "Tan", "Galang", "Khuong",
                   "Chak", "Sananikone", "Bhaskar", "Awasthi", "Jue", "Varghese", "Majid", "Phong", "Khurana", "Oh",
                   "Tong", "Taufa", "Yamane", "Li", "Ahmad", "Chavan", "Moorthy", "Krishnan", "Nagata", "Gao", "Nair",
                   "Sabir", "Khokhar", "Vakil", "Talwar", "Eh", "Kurian", "Parmar", "Mahmud", "Ichikawa", "Nisar",
                   "Cuaresma", "Modi", "Bay", "Lahiri", "Imamura", "Shi", "Don", "Tominaga", "Azim", "Pak", "Kaushik",
                   "Guinto", "So", "Kwon", "Mon", "Lac", "Sandiego", "Yano", "Nimmagadda", "Thakore", "Hahm", "Lukose",
                   "Pon", "Giang", "Bahadur", "Jiao", "Shen", "Nham", "Floresca", "Ramnath", "Soeun", "Un", "Nakahara",
                   "Bhatt", "Doshi", "Fu", "Dayao", "Yoshino", "Inoue", "Lagmay", "Hegde", "Lai", "Heu", "Thu", "Ghai",
                   "Xie", "Maheshwari", "Lao", "Dorjee", "Virk", "Luan", "Bajwa", "Mathew", "Varma", "Sarker", "Nasir",
                   "Lin", "Sivakumar", "Athwal", "Zeng", "Delrosario", "Jung", "Gulati", "Ramakrishnan", "Nou",
                   "Thammavong", "Marwaha", "Hira", "Nagamine", "Kono", "Zuo", "Kue", "Hue", "Pepito", "Keung",
                   "Jayaram", "Miura", "Izumi", "Ang", "Uehara", "Hironaka", "Sou", "Sridhar", "Kan", "Guha", "Shareef",
                   "Eng", "Dubey", "Vy", "Seo", "Bhardwaj", "Jing", "Sethuraman", "Ayub", "Sun", "Ilagan", "Pae",
                   "Gautam", "Younus", "Kaur", "Chalasani", "Qui", "Mung", "Makino", "Nan", "Gajjar", "Tsoi", "Talluri",
                   "Hou", "Rastogi", "Gu", "Wahid", "Chauhan", "Loc", "Konda", "Fukushima", "Yom", "Multani", "Vong",
                   "Akther", "Lwin", "Nop", "Fei", "Mallick", "Palanisamy", "Macaspac", "Ara", "Okano", "Apostol",
                   "Dalal", "Soung", "Bhagat", "Fronda", "Peng", "Ton", "Um", "Chou", "Hadi", "Sha", "Gopalan",
                   "Narain", "Kuruvilla", "Manandhar", "Doi", "Kubota", "Rane", "Nong", "Liang", "Sajid", "Tzeng",
                   "Jahan", "Chey", "Kamran", "Raval", "Miyata", "Garcha", "Mammen", "Demesa", "Dea", "Keomany", "Jia",
                   "Sao", "Sunkara", "Florendo", "Arai", "Yong", "Koga", "Taing", "Dimaano", "Ahuja", "Rawat",
                   "Khurshid", "Nam", "Sur", "Xiong", "Shroff", "Sibayan", "Marinas", "Qin", "Nuon", "Ullah", "Mandava",
                   "Ojha", "Lor", "Pangilinan", "Shan", "Gopalakrishnan", "Bindra", "Whang", "Ling", "Alo",
                   "Lach", "Senthil", "Uemura", "Dai", "Mangubat", "Waheed", "Alegado", "Mohanty", "Contractor", "Chum",
                   "Kassam", "Sen", "Tamang", "Kitamura", "Sar", "Nagao", "Mach", "Cao", "Grewal", "Tio", "Belen",
                   "Chhin", "Akiyama", "Sok", "Naveed", "Hasan", "Kamat", "Yadav", "Oishi", "Toh", "Nocon", "Piao",
                   "Parameswaran", "Zhong", "Cui", "Shimada", "Gurung", "Kyaw", "Hari", "Dou", "Paguio", "Sana", "Ying",
                   "Hamasaki", "Luong", "Lising", "Mehra", "Nazareno", "Layug", "Woo", "Oum", "Babauta", "Banga",
                   "Rauf", "Arain", "Carandang", "Banerjee", "Oshima", "Lee", "Atwal", "Shue", "Bui", "Dieu", "Duan",
                   "Deguia", "Takai", "Oei", "Baccam", "Murai", "Pawar", "Choi", "Tien", "Gokhale", "Lovan", "Shon",
                   "Jayakumar", "Lat", "Mukhtar", "Upadhyay", "Hang", "Gaerlan", "Hsu", "Aman", "Sek", "Datta", "Awan",
                   "Razvi", "Saephanh", "Usman", "Kamath", "Chatha", "Anjum", "Paracha", "Chiem", "Khim",
                   "Krishnaswamy", "Akhter", "Thiara", "Ung", "Seid", "Pham", "Agarwal", "Sieng", "Deasis", "Morikawa",
                   "Truong", "Jariwala", "Dee", "Kano", "Doung", "Sood", "Madriaga", "Huynh", "Dhawan", "Bibi",
                   "Kawasaki", "Saravanan", "Sarma", "Cong", "Papa", "Noorani", "Baskaran", "Ranjan", "Gohil",
                   "Chandrasekaran", "Thor", "Agrawal", "Matsunaga", "Iwasaki", "Fonua", "Pua", "Lall", "Lacson",
                   "Verghese", "Kelkar", "Abella", "Dhakal", "Pathak", "Zaheer", "Tian", "Sugihara", "Bandaru",
                   "Mahadeo", "Dah", "Hafiz", "Fatima", "Trias", "Nambiar", "Manabat", "Uchiyama", "Hirai", "Bien",
                   "Taw", "Pan", "Dasgupta", "Bakshi", "Kawaguchi", "Geng", "Madhavan", "Sangalang", "Sahu", "Vitug",
                   "Miyake", "Yogi", "Sekhon", "Suen", "Susanto", "Samad", "Dan", "Dosanjh", "Chakravarty",
                   "Sonoda", "Ty", "Gaw", "Samaroo", "Taguchi", "Manda", "Chopra", "Ouk", "Liwag", "Pe", "Tsering",
                   "Salonga", "Punzalan", "Chung", "Asghar", "Kulkarni", "Fukuhara", "Subramani", "Umali", "Majmudar",
                   "Bal", "Hameed", "Nakama", "Sumida", "Casino", "Sin", "Yamazaki", "Zaveri", "Khera", "Engineer",
                   "Arif", "Thiagarajan", "Malla", "Madayag", "Gim", "Gunda", "Ohashi", "Cabreros", "Sein",
                   "Srinivasan", "Cham", "Fukumoto", "Gul", "Ooi", "Guanzon", "Goll", "Sah", "Kimoto", "Paek", "Mak",
                   "Alam", "Naidoo", "Toves", "Beg", "Shiau", "Prom", "Jivani", "Tupou", "Phang", "Ro", "Arumugam",
                   "Tsukamoto", "Tangonan", "Poblete", "Parvez", "Kalsi", "Kuriakose", "Gilani", "Menor", "Wadhwa",
                   "Tran", "Pant", "Joo", "Shiu", "Hsia", "Tra", "Yamamoto", "Begum", "Durrant", "Gin", "Meng", "Zaw",
                   "Majeed", "Jun", "Sheth", "Chanthavong", "Chowdhary", "Rajani", "Hussain", "Javed", "Shek",
                   "Manansala", "Gade", "Dhami", "Kharel", "Saxena", "Imam", "Neang", "Deocampo", "Bastola",
                   "Walia", "Ding", "Roeun", "Aulakh", "Rahaman", "Meh", "Morioka", "Kurihara", "Tse", "Po",
                   "Govindarajan", "Bian", "Pradhan", "Thaker", "Kota", "Tsang", "Reddy", "Cayanan", "Faisal",
                   "Santoso", "Leu", "Wong", "Joson", "Khaira", "Tha", "Mahtani", "Jeon", "Bacani", "Choudhary", "Ye",
                   "Phanthavong", "Samonte", "Hussaini", "Bhandal", "Bhimani", "Shimamoto", "Cachola", "Khatri", "Chu",
                   "Pajarillo", "Nozaki", "Suon", "Ky", "Siharath", "Bhattacharya", "Tuazon", "Naqvi", "Liwanag",
                   "Sato", "Chae", "Chia", "Nagar", "Oshita", "Mohiuddin", "Chandran", "Sayarath", "Barretto", "Or",
                   "Tau", "Kawahara", "Cheema", "Rao", "Zhen", "Thong", "Bains", "Sohal", "Karthik", "Rampersaud",
                   "Chhor", "Poon", "Bamba", "Kau", "Bai", "Ghimire", "Chandy", "Lamba", "Ahn", "Nag", "Khwaja", "Che",
                   "Ho", "Debnath", "Tun", "Wo", "Nagai", "Matsubara", "Qiu", "Pen", "Hirayama", "Kinoshita", "Deo",
                   "Shimoda", "Takeda", "Tsay", "Vaz", "Khanam", "Onishi", "Yau", "Lue", "Brahmbhatt", "Mao",
                   "Cadiente", "Bala", "Satish", "Pich", "Tep", "Furukawa", "Pacis", "Baby", "Aryal", "Kodama", "Oza",
                   "Shakoor", "Kathuria", "Diep", "Lok", "Mirchandani", "Barroga", "Batac", "Choudry", "Chhun",
                   "Tu", "Xu", "Tashiro", "Subba", "Tokuda", "Dao", "Rajaram", "Sheng", "Kumagai", "Chheng", "Dharia",
                   "Xing", "Banh", "Seng", "Ishihara", "Vijayakumar", "Gohel", "Takayama", "Mathai", "Jagannathan",
                   "Sayeed", "Tandon", "Muraoka", "Shibuya", "Paragas", "Kanda", "Lim", "Murali", "Nahar", "Bhattarai",
                   "Saini", "Esguerra", "Yasuda", "Zacharias", "Banzon", "Zhu", "Hsueh", "Mohsin", "Chau", "Ninan",
                   "Rafanan", "Ahmed", "Ramanathan", "Rajendran", "Bondoc", "Manohar", "Tsui", "Trieu", "Bartolome",
                   "Abid", "Choo", "Kai", "Jao", "Takata", "Jonnalagadda", "Qazi", "Yarlagadda", "Somani",
                   "Bhattacharjee", "Dahal", "Saeteurn", "Yoo", "Yousuf", "Srivastava", "Chidambaram", "Juneja",
                   "Vallabhaneni", "Rimando", "Shakya", "Chandrasekhar", "Yuson", "Mansoor", "Doh", "Mang", "Deol",
                   "Datu", "Mahesh", "Troung", "Imtiaz", "Eapen", "Jhaveri", "Canlas", "Pei", "Ha", "Baba", "Mumtaz",
                   "Choung", "Deshpande", "Takagi", "Vo", "Padmanabhan", "Pyun", "Tram", "Shinde", "Shaheen", "Soni",
                   "Phi", "Gatchalian", "Pau", "Mun", "Araneta", "Nazir", "Bari", "Umar", "Huh", "Ranganathan",
                   "Hlaing", "Hyder", "Sheen", "Ganesh", "Yoshihara", "Balagot", "Sakata", "Calimlim", "Iyer", "Anand",
                   "Tae", "Hayat", "Cheng", "Hattori", "Roxas", "Cen", "Chhay", "Sundaram", "Sem", "Advani", "Magat",
                   "Srikanth", "Vien", "Rani", "Amar", "Dayrit", "Naeem", "Zafar", "Takashima", "Hew", "Nguy",
                   "Lomibao", "Sano", "Sit", "Venkateswaran", "Kolla", "Ishibashi", "Krishnamurthy", "Dhaliwal", "Mua",
                   "Leano", "Thota", "Sodhi", "Diao", "Srey", "Dogra", "Sallee", "Dua", "Dutt", "Sawhney", "Tseng",
                   "Lau", "Kataoka", "Hyun", "Bali", "Singson", "Shao", "Hoshino", "Maredia", "Ahamed", "Seong",
                   "Miyasaki", "Au", "Dacanay", "Eom", "Teh", "Querubin", "Zapanta", "Tim", "Dong", "Tiongson", "Eang",
                   "Maranan", "Chohan", "Bee", "Fung", "Nicdao", "Memon", "Luangrath", "Muralidharan", "Cheon", "Vi",
                   "Cherian", "Rizwan", "Ishida", "Dimalanta", "Vu", "Waseem", "Murata", "Zaidi", "Majumdar", "Kuo",
                   "Parthasarathy", "Higuchi", "Chow", "Pillay", "Ueda", "Nanda", "Khong", "Huo", "Ju", "Vang", "Sagun",
                   "Deen", "Hasnain", "Mu", "Azhar", "Khem", "Husain", "Vyas", "Kahlon", "Duong", "Gui", "Vinluan",
                   "Raza", "Syed", "Narula", "Pasha", "Sundara", "Zaman", "Chowdhury", "Hata", "Ahsan", "Vij", "Ko",
                   "Khatun", "Chin", "Raja", "Arakawa", "Ozawa", "Rabanal", "Sundar", "Thein", "Tayag",
                   "Krishnamoorthy", "Tripathy", "Rathi", "Bhavsar", "Shrestha", "Bhat", "Gogineni", "Krishnakumar",
                   "Shrivastava", "Som", "Bhakta", "Acob", "Suleman", "Golla", "Tabassum", "Pandya", "Sabio",
                   "Marasigan", "Paruchuri", "Patel", "Vora", "Jain", "Nhem", "Rodrigo", "Yan", "Baig", "Bajaj", "Wen",
                   "Cacal", "Phu", "Murtha", "Shieh", "Tagawa", "Sia", "Vea", "Matsushita", "Basu", "Azam", "Jo",
                   "Hayashida", "Fabro", "Resurreccion", "Lacsamana", "Sum", "Chakrabarti", "Chhan", "Yoshimura",
                   "Huie", "Yadao", "Mukherjee", "Pai", "Tahir", "Pande", "Koike", "Mishra", "Rupani", "Hirota", "Kung",
                   "Sohn", "Nagra", "Feng", "Imai", "Sung", "Minami", "Chew", "Mia", "Haque", "Respicio", "Pung",
                   "Prak", "Venkatraman", "Maruyama", "Tay", "Dutta", "Trac", "Siddique", "Yeung", "Malladi", "Babar",
                   "Kubo", "Wadhwani", "Baluyot", "Naz", "Zachariah", "Tanimoto", "Svay", "Sami", "San", "Fukui",
                   "Bhargava", "Arora", "Komatsu", "Dhanoa", "Canete", "Patankar", "Lacap", "Prabhakar", "Katragadda",
                   "Boado", "Ravichandran", "Camba", "Chieng", "Uchida", "Manibusan", "Tsung", "Nghiem", "Venkatesh",
                   "Cheong", "Jocson", "Janjua", "Luo", "Johal", "Antolin", "Alli", "Tamanaha", "Xin", "Xuan", "Cing",
                   "Tiet", "Phuong", "Munar", "Kawano", "Lugtu", "Ramamurthy", "Sanghavi", "Calica", "Quach",
                   "Ramachandran", "Staana", "Kumari", "Persaud", "Aye", "Sibal", "Bandyopadhyay", "Cu", "Sukhu",
                   "Surapaneni", "Ahluwalia", "Bu", "Perveen", "Eum", "Shyu", "Lu", "Liv", "Khoo", "Hsi", "Verma",
                   "Nakajima", "Nang", "Tieu", "Joh", "Zhuo", "Mikami", "Misra", "Khoja", "Jamal", "Pandian", "Virani",
                   "Karki", "Lem", "Dau", "Raghavan", "Nabi", "Yee", "Okawa", "Myint", "Kalia", "Pha",
                   "Deguzman", "Munir"]
}

inter_racial_names = {
    "last_names": ["Tinker", "Pal", "Sultan", "Kamaka", "Lal", "Inouye", "Azizi", "Shaikh", "Oda", "Popal", "Sablan",
                   "Harjo", "Saleem", "Akbar", "Ahuna", "Ishii", "Hodson", "Aoki", "Ishikawa", "Khalil", "Khalid",
                   "Chee", "Kam", "Shih", "Ono", "Nitta", "Gouveia", "Khanna", "Dizon", "Lui", "Mirza", "Mori",
                   "Suzuki", "Desilva", "Butt", "Loo", "Murakami", "Turney", "Hasegawa", "Higashi", "Cordeiro",
                   "Taitano", "Baptista", "Abbasi", "Anwar", "Raj", "Gong", "Rapoza", "Issa", "Ikeda", "Neves",
                   "Billiot", "Maeda", "Habib", "Pascua", "Fujii", "Coelho", "Aziz", "Mahmoud", "Wan", "Endo", "Aguon",
                   "Cambra", "Moniz", "Matsuda", "Ting", "Mohammadi", "Hosseini", "Texeira", "Kakar", "Saeed", "Nazari",
                   "Abdul", "Decosta", "Chai", "Barakat", "Goo", "Yamashita", "Scanlan", "Nobriga", "Tamura",
                   "Morimoto", "Hashimi", "Chaudhry", "Kimura", "Mohan", "Karimi", "Hom", "Honda", "Ansari", "Perreira",
                   "Choy", "Haider", "Kawakami", "Ming", "Quan", "Kawamura", "Shim", "Tung", "Iqbal", "Leeper", "Aki",
                   "Yen", "Shimizu", "Hamidi", "Mahabir", "Matsumoto", "Nishimura", "Mansour", "Mohammad", "Tiger",
                   "Sultani", "Xavier", "Hamid", "Nakagawa", "Chock", "Dsouza", "Mau", "Viernes", "Sing", "Abe",
                   "Yim", "Corpuz", "Azimi", "Mendonca", "Hakim", "Sakamoto", "Apo", "Mahmood", "Akiona", "Lyn",
                   "Takeuchi", "Kato", "Chandra", "Sison", "Wardak", "Hanohano", "Mossman", "Miyamoto", "Sasaki",
                   "Devera", "Kobayashi", "Delima", "Ogata", "Hirata", "Ogawa", "Manalo", "Rahimi", "Hamada", "Ancheta",
                   "Yousif", "Yamasaki", "Ku", "Min", "Ota", "Jardine", "Hashimoto", "Sannicolas", "Ram", "Amini",
                   "Toma", "Nakamoto", "Jaber", "Higa", "Noori", "Seto", "Nomura", "Baldridge", "Youssef", "Ito",
                   "Prakash", "Akana", "Morita", "Miyashiro", "Hsieh", "Persad", "Rampersad", "Nakata", "Uddin",
                   "Habibi", "Akbari", "Abdallah", "Leonguerrero", "Furtado", "Ramkissoon", "Fujimoto", "Qureshi",
                   "Yoshida", "Rahim", "Akina", "Sadeghi", "Ornellas", "Kamai", "Kaneshiro", "Kealoha", "Toy",
                   "Taniguchi", "Gragg", "Hosein", "Sayed", "Degroat", "Zamani", "Yamada", "Hamdan", "Masuda", "Thach",
                   "Ahmadi", "Abdulla", "Narayan", "Sylva", "Arakaki", "Rahmani", "Maharaj", "Yeh", "Suleiman",
                   "Mclellan", "Botelho", "Awad", "Takahashi", "Demello", "Okada", "Chilton", "Saad", "Okamoto",
                   "Kawamoto", "Mah", "Sharifi", "Kao", "Fukuda", "Kalama", "Bhatti", "Afshar", "Hazard", "Khoury",
                   "Akau", "Uyeda", "Hara", "Hee", "Nakano", "Yip", "Abbas", "Tehrani", "Pangelinan", "Rai", "Salehi",
                   "Nasser", "Sakai", "Nishimoto", "Vandunk", "Hayashi", "Hakimi", "Yap", "Amiri", "Shimabukuro",
                   "Cravens", "Paiva", "Kapoor", "Nakashima", "Okamura", "Watanabe", "Chand", "Safi", "Hashemi", "Tai",
                   "Siu", "Harada", "Baksh", "Oshiro", "Yamaguchi", "Mayle"]}

religion_wise_names = {
    "Muslim": [
        "Adyan", "Kasib", "Sadiqah", "Samit", "Husam", "Abdul Qadir", "Gulfam", "Rashdan", "Rasheeda", "Mulayl",
        "Hussein", "Sayfiyy", "Faheem", "Jawharah", "Sageda", "Nusayr", "Nisha", "Iqra", "Marnia", "Ubaydah",
        "Nazim", "Ziram", "Sahibah", "Najm al Din", "Majdy", "Mahrus", "Nimr", "Talib", "Shuhda", "Mubin",
        "Nasih", "Sakinah", "Jameelah", "Rubadah", "Ala al din", "Khidr", "Adl", "Norhan", "Rufaydah", "Sahrish",
        "Abdul Mueed", "Shabeeh", "Isaf", "Sayf", "Amatullah", "Nisrin", "Fazzilet", "Nazirah", "Bakht", "Taqwa",
        "Abdul Noor", "Shahnoor", "Fadwah", "Ali", "Mohid", "Mikhail", "Abdus Sami", "Salam", "Muazah", "Abdul Samad",
        "Alzubra", "Waseem", "Lulwa", "Abdul-Malik", "Mahir", "Abdul Jabbar", "Shabaan", "Rafah", "Khayriyyah", "Fahimah",
        "Muqatadir", "Rafeek", "Furayah", "Wahibah", "Zaigham", "Abdus Sattar", "Amin", "Rabi", "Sumlina", "Hanifa",
        "Kishwar", "Intisaar", "Azlan", "Ibtihal", "Muneerah", "Fareeq", "Aqil", "Azra", "Aman", "Murshidah",
        "Zulekha", "Shuaib", "Jasim", "Zulfiqar", "Nuri", "Abdul Aliyy", "Fadilah", "Ambreen", "Ruhi", "Karimah",
        "Suheb", "Ayah", "Abdul-Ghafur", "Thamer", "Mariyah", "Abdul-Jabbar", "Mandhur", "Abdul-Barr", "Mashhur", "Muhsin",
        "Mundhir", "Saib", "Jumaana", "Aasim", "Abdul-Mueid", "Robeel", "Parveen", "Naveen", "Jabalah", "Mukarram",
        "Anwaar", "Shumaylah", "Dhiya", "Sad al Din", "Istakhri", "Aryisha", "Faizah", "Sameenah", "Sahmir", "Armaan",
        "Khirash", "Fayruz", "Abdul-Waajid", "Aludra", "Nashmia", "Lamya", "Aabirah", "Qudamah", "Zumzum", "Humayl",
        "Umayr", "Inam", "Barkat", "Rahiq", "Tanweer", "Abdul-Muqtadir", "Sumara", "Mahirah", "Kaseem", "Habis",
        "Sultanah", "Ahzab", "Tulayhah", "Jazib", "Taalah", "Hibah", "Shaheer", "Husain", "Yaseen", "Muruj",
        "Makki", "Anaan", "Abdul Wahhab", "Banafsha", "Tazmeen", "Zaynah", "Raneem", "Taymullah", "Muneer", "Zahra",
        "Hayaat", "Mahdi", "Azizah", "Hasna", "Hakim", "Azka", "Nadirah", "Nawwaf", "Gulzar", "Rubaba",
        "Munkadir", "Dunya", "Adbul-Qawi", "Usaimah", "Saleemah", "Burhan", "Aasimah", "Nasser", "Zaytoon", "Wajeeh",
        "Aftab", "Limazah", "Wadiah", "Asbat", "Tarannum", "Chaman", "Iffah", "Balqis", "Wahbiyah", "Rayyan",
        "Wifaq", "Maheen", "Baqir", "Wafa", "Farraj", "Khadeeja", "Abdul-Haseeb", "Munqad", "Quadir", "Ayman",
        "Zaeem", "Ilias", "Mujab", "Nudhar", "Saima", "Shumaila", "Dakhil", "Wahidah", "Kardawiyah", "Jamal al Din",
        "Aidh", "Gul-e-Rana", "Faiza", "Mufid", "Abdul Badee", "Ghayth", "Hooman", "Mawiyah", "Abdul Waali", "Mariam",
        "Maridah", "Samiyah", "Arwa", "Abeer", "Hadeeqah", "Nur-ul-Qiblatayn", "Hibba", "Shabah", "Nur", "Waseem",
        "Kamilah", "Sameeha", "Bakr", "Soraiya", "Naim", "Uhud", "Noman", "Mirsab", "Mujahid", "Thauban",
        "Shillan", "Najjar", "Hasna", "Summar", "Nabil", "Mubeenah", "Urooj", "Hikmat", "Mehjabeen", "Fadi",
        "Jun", "Mohsin", "Athil", "Ghaziyah", "Amirah", "Shafeeq", "Marghub", "Nageenah", "Khulayd", "Jabr",
        "Izz", "Khatib", "Majd", "Mika", "Lamya", "Tariqah", "Nasirah", "Nashat", "Risay", "Fajaruddin",
        "Hanai", "Haneef", "Shabbeer", "Abeedah", "Ishfaq", "Juma", "Lutf", "Amreen", "Nasifah", "Bilqis",
        "Zayba", "Basel", "Zaytoonah", "Zaahirah", "Hashim", "Mummar", "Senait", "Ismat", "Fanan", "Safiya",
        "Qindeel", "Hanfa", "Sultaan", "Hayud", "Taahira", "Bahia", "Manaal", "Hadiyah", "Shahnaaz", "Sumra",
        "Iskandar", "Farqad", "Wafiyah", "Shareefa", "Ammar", "Nimah", "Reem", "Khairiya", "Fusaylah", "Waddah",
        "Kadar", "Intizar", "Anisa", "Faria", "Naina", "Junnut", "Samira", "Wardah", "Manzoor", "Ruqayyah",
        "Naira", "Safuh", "Mulham", "Zahid", "Murtada", "Zuti", "Najaah", "Salsabil", "Mays", "Tahseenah",
        "Mutahharah", "Mardhiah", "Nisa", "Sahirah", "Areeb", "Abdul Mujeeb", "Aida", "Najeeba", "Manaar", "Qameer",
        "Rijja", "Hamidah", "Zaynah", "Jahdari", "Amrah", "Mihran", "Yamha", "Nasra", "Faridah", "Tahir",
        "Haniyyah", "Almir", "Najm", "Arissa", "Zumurruda", "Nawwar", "Qutb", "Ali", "Sulafah", "Karam",
        "Qani", "Munahid", "Shafiq", "Mehndi", "Muslimah", "Shakir", "Ghazanfar", "Haniya", "Nimat", "Hibatullah",
        "Ajer", "Nafi", "Isa", "Shahrazad", "Ibrahim", "Shamsheer", "Zuhur", "Nawlah", "Abzari", "Adeem",
        "Irfan", "Wazeera", "Ghaniyah", "Rayyaa", "Jada", "Numan", "Jasrah", "Samihah", "Abdush Shahid", "Nizam",
        "Aroosa", "Shakeelah", "Subhaan", "Fawza", "Awatif", "Shaheenah", "Muniba", "Sakina", "Alim", "Faheemah",
        "Yasmin", "Zunairah", "Rahat", "Lublubah", "Mohammed", "Abdul Rahim", "Abdul-Hakeem", "Tabalah", "Taqiy", "Nura",
        "Tasneem", "Jamila", "Hunaidah", "Abdul Qawi", "Kanza", "Iqbal", "Mahdiya", "Luluah", "Saila", "Nabigh",
        "Hujjat", "Aminah", "Salah al Din", "Haifa", "Simra", "Karida", "Badia", "Shaymaa", "Qirat", "Nashirah",
        "Iba", "Ruqayya", "Zahra", "Abdul Kareem", "Iffat", "Abdul Wali", "Malik", "Thalabah", "Imam", "Mikaeel",
        "Naba", "Raawiya", "Yunus", "Mehr", "Wagma", "Safwah", "Anbar", "Mawaddah", "Ruhee", "Abdul Haseeb",
        "Jabrayah", "Athazaz", "Sabiha", "Shairyaar", "Thawab", "Zulfa", "Salman", "Aliyah", "Mateen", "Khazanah",
        "Thanaa", "Shamailah", "Aleena", "Seema", "Ashalina", "Hirah", "Humaira", "Zaid", "Sukainah", "Zubdah",
        "Maysa", "Tanwir", "Rizwan", "Fatik", "Ghufayrah", "Asim", "Faiz", "Abdul Qahhar", "Muafa", "Jalilah",
        "Jafar", "Fir", "Kaltham", "Ishaq", "Zahir", "Nawrah", "Masarrah", "Abdul Muti", "Qabalah", "Ghareebah",
        "Nasmi", "Mishall", "Sammar", "Asiya", "Abdul Tawwab", "Aymen", "Ziyad", "Atiya", "Sairah", "Kameel",
        "Sabrina", "Shama", "Mustaeenah", "Rahila", "Sabahat", "Sakhr", "Qubilah", "Saleh", "Aatirah", "Liba",
        "Hayat", "Mutawalli", "Junayd", "Shahbaz", "Shahida", "Madaniyah", "Rida", "Badriya", "Udaysah", "Fasahat",
        "Deema", "Lulu", "Salsaal", "Nazmin", "Sadan", "Jaleel", "Naushad", "Ziya", "Ithaar", "Aneesa",
        "Zenia", "Abdul Adl", "Mustahsan", "Mustafa", "Sameen", "Raquib", "Ajmal", "Hawa", "Raid", "Hameeda",
        "Hurya", "Kaheesha", "Adeelah", "Razia", "Pervaiz", "Joozher", "Atifa", "Saleem", "Mulhim", "Zafar",
        "Rafay", "Kamran", "Zaeemah", "Hibbah", "Mutasim", "Sabeen", "Ghanim", "Khitam", "Ehsan", "Abdul Hafiz",
        "Mazhar", "Raja", "Mubid", "Faiq", "Liban", "Koila", "Sherrifah", "Walladah", "Basir", "Talhah",
        "Abdul Baqi", "Ghayda", "Amah", "Shuja", "Shakila", "Tamim", "Rafid", "Samaira", "Sarwat", "Hashmat",
        "Nur al Din", "Safwat", "Saaqib", "Leila", "Muneera", "Rifaat", "Muzhir", "Shamsa", "Tahirah", "Meher",
        "Saadat", "Hawazin", "Shajarah", "Sabina", "Tihami", "Faiqa", "Hamzah", "Taslim", "Hijrah", "Layla",
        "Muizz", "Tahoor", "Abia", "Nashida", "Thabitah", "Yusuf", "Rahma", "Mubassirah", "Ayeh", "Yusraa",
        "Izz al Din", "Kareem", "Zarrah", "Lubayd", "Qasid", "Usaym", "Meymona", "Rafiah", "Yaqeen", "Lanika",
        "Afifah", "Juwan", "Ruwaid", "Subhan", "Eimaan", "Mehtab", "Khalil", "Dina", "Zubayr", "Ahsan",
        "Birrah", "Fozia", "Shellah", "Mubarakah", "Faysal", "Hakeem", "Sami", "Fellah", "Museeb", "Saji",
        "Suhayb", "Akifah", "Linah", "Rushd", "Abdul Wahid", "Labeeb", "Mayyasah", "Safa", "Shabina", "Siddra",
        "Abdul Ghafoor", "Ghalibah", "Ma as-sama", "Talha", "Qais", "Ghumaysa", "Tawhid", "Tuqa", "Maimun", "Aribah",
        "Nafis", "Rasin", "Shehr bano", "Wakeel", "Mushir", "Nadwa", "Nabiha", "Abdul Jabaar", "Parvez", "Zulfaqar",
        "Sunya", "Nahal", "Futun", "Ziyad", "Shuayb", "Anniyah", "Shahirah", "Waqas", "Masoomah", "Shareen",
        "Matloob", "Qatadah", "Haydar", "Eiliyah", "Hazar", "Hayah", "Eshal", "Damurah", "Amira", "Atiya",
        "Eiman", "Sabah", "Nusaybah", "Muntasir", "Haifa", "Shuhrah", "Zaafirah", "Sahla", "Shawaiz", "Suad",
        "Tulayb", "Khuzama", "Zayn", "Tawbah", "Fahmi", "Fatima", "Aafreeda", "Ihsan", "Hira", "Amineh",
        "Tumadur", "Abdul-Majeed", "Heba", "Hannah", "Aymaan", "Ijlal", "Daliyah", "Tabassum", "Mufallah", "Taibah",
        "Faseeh", "Abida", "Nuzhah", "Tubaa", "Wadhaa", "Kas", "Nasimah", "Masroor", "Minha", "Juwayn",
        "Muddaththir", "Halwani", "Tanveer", "Yazid", "Reeha", "Ghaydaa", "Unaysah", "Zeena", "Gulshan", "Reyah",
        "Hallaj", "Mahaz", "Muzzammil", "Najibah", "Nuhaid", "Muhjah", "Mushfiq", "Rizqin", "Ruwaidah", "Azzam",
        "Aani Fatimah Khatoon", "Usamah", "Nawaz", "Ayaat", "Nizzar", "Rajaa", "Amirah", "Nibal", "Fakeehah", "Tawfiq",
        "Aafreen", "Sauda", "Sadaf", "Khalis", "Youssef", "Izzah (Izzat)", "Sakinah", "Wafiqah", "Aziman", "Leilah",
        "Nabeela", "Tufayl", "Dawlat Khatoon", "Abdul-Haleem", "Sakhawat", "Mansur", "Qadr", "Rukayat", "Suhaymah", "Bahirah",
        "Aswad", "Zarifah", "Ilm", "Muammar", "Aya", "Maysarah", "Gazala", "Usaymah", "Nuha", "Noshaba",
        "Fairuzah", "Nojood", "Muyassar", "Aqilah", "Zynah", "Ghawth", "Akhdan", "Dhakwan", "Shahla", "Taima",
        "Mihyar", "Raheel", "Fatimah", "Halimah", "Rasul", "Azeeza", "Daania", "Haneefa", "Namyla", "Mashel",
        "Taqiyy", "Faseehah", "Shafeeqah", "Waqqas", "Farha", "Raghad or Raghda", "Subhi", "Naifah", "Abdul-Ghani", "Nabih",
        "Fatinah", "Neelofer", "Marwah", "Humaydah", "Reda", "Nejat", "Shakib", "Nabeelah", "Fahad", "Ghitbah",
        "Fakhri", "Shumaysah", "Darakhshaan", "Sonia", "Hamal", "Ridha", "Deen", "Amaar", "Thubaytah", "Abdul Mubdi",
        "Samra", "Hussein", "Thumamah", "Tamara", "Jumanah", "Rafan", "Fakih", "Nuwayrah", "Rais", "Fareeha",
        "Azim", "Tamir", "Nigar", "Zayn", "Noori", "Shimah", "Akbar", "Shujana", "Zulaym", "Nazindah",
        "Shaila", "Shamilah", "Wali", "Ghazi", "Id", "Shamas", "Siddiq", "Duaa", "Imani", "Juthamah",
        "Abdul Latif", "Rakin", "Ilham", "Jala", "Khayriyah", "Yaseen", "Qurratul Ayn", "Zilal", "Abdul Muhaymin", "Salsabil",
        "Nafiah", "Uzair", "Yafi", "Jumaymah", "Adab", "Muqaddas", "Fawzan", "Obaid", "Siwar", "Haala",
        "Rihab", "Taha", "Farheen", "Nurah", "Salah", "Nabilah", "Ahmed", "Farhan", "Sayf", "Munib",
        "Ghanem", "Baha", "Hadil", "Hamdan", "Riyadh", "Nawar", "Hamnah", "Imtiaz", "Lubna", "Sadiq",
        "Abu Bakr", "Zahraa", "Qutayyah", "Asar", "Himayat", "Hidayah", "Shabeehah", "Raihana", "Latifah", "Talibah",
        "Mahbub", "Ayoob", "Hashir", "Buhjah", "Bariah", "Manahil", "Ayra", "Asma", "Radiyah", "Hujaymah",
        "Walihah", "Abdul-Mujeeb", "Kardal", "Kadeen", "Shariq", "Attiq", "Mouna", "Zainab", "Jian", "Nuaym",
        "Tarub", "Dameer", "Afeef", "Munawar", "Warda", "Tali", "Sidra", "Usman", "Abdul Lateef", "Ameena",
        "Luja", "Nadeem", "Nabeeha", "Sahlah", "Anisah", "Aishah", "Maymun", "Abdul-Lateef", "Angbin", "Makhtoonah",
        "Abdur Rashid", "Hiba", "Suhayb", "Fareedah", "Farihah", "Jammana", "Muznah", "Dafiyah", "Shasmeen", "Raseem",
        "Suhaim", "Manar", "Nadeeda", "Dayyan", "Rubaa", "Shakeel", "Abdul Musawwir", "Samia", "Samina", "Thuml",
        "Tufaylah", "Khidash", "Shafqat", "Faruq", "Qurban", "Nazaaha", "Adilah", "Atif", "Salma", "Surur",
        "Jahdami", "Safiy", "Kulthum", "Farwah", "Abbudin", "Jahan Aara", "Aariz", "Jennah", "Rumeha", "Shafiulla",
        "Furat", "Aahil", "Tayyibah", "Abdul Muiz", "Zaheen", "Izzah", "Lubanah", "Shahd", "Barzah", "Aban",
        "Abdel", "Uwaisah", "Ubayd", "Abdul Ghafur", "Khudrah", "Nasif", "Barirah", "Nina", "Kabirah", "Afnan",
        "Sumayya", "Jasmina", "Momina", "Ali", "Maira", "Nijad", "Mussaret", "Makarim", "Amina", "Taym Allah",
        "Zunnoon", "Nazar", "Kalil", "Hunaydah", "Yar", "Diya al Din", "Numair", "Summaya", "Lashirah", "Zia",
        "Nadyne", "Adiba", "Haseen", "Masahir", "Rania", "Raameen", "Nasir al Din", "Mahveen", "Kifayat", "Leena",
        "Mutawassit", "Sumaira", "Abdul Matin", "Faiza", "Nawel", "Utaybah", "Abdul-Qaiyoum", "Anasah", "Shariqah", "Fareeha",
        "Jahdamah", "Maisarah", "Najih", "Muhafiz", "Fadwa", "Rumailah", "Laila", "Masabeeh", "Nahid", "Nisreen",
        "Islam", "Huda", "Abdus-Shaheed", "Nazeeh", "Mamun", "Ayah", "Zahwah", "Safeer", "Shamamah", "Minhaj",
        "Wasfiyah", "Fouad", "Vardah", "Murtaad", "Sibaal", "Nailah", "Mujazziz", "Femida", "Faraj", "Nashwan",
        "Farihah", "Aybak", "Asimah", "Zuhayr", "Hunaydah", "Adnan", "Mamduh", "Ziad", "Ain", "Fadiyah",
        "Mumin", "Shamima", "Fadl", "Reza", "Muflih", "Zainab", "Raha", "Hamidah", "Hurmat", "Adeena",
        "Awad", "Ramih", "Basheera", "Yusra", "Naji", "Tahani", "Nasim", "Abdul Maajid", "Asmat", "Wala",
        "Rashid", "Imran", "Dunyana", "Hudun", "Wadid", "Rabeea", "Liyaqat", "Salamat", "Rowel", "Waqar",
        "Alleyah", "Abidin", "Ajeebah", "Yaghnam", "Naimah", "Thawab", "Nilofer", "Jabir", "Anwar", "Sayhan",
        "Alishba", "Khalisah", "Ashfaq", "Ashaz", "Nazir", "Adawi", "Haleef", "Safiyya", "Abdul Jawwad", "Qareeb",
        "Mahbeer", "Salamah", "Jahan Khatoon", "Muzakkir", "Bahriyah al-Aabidah", "Mahabbah", "Sihaam", "Rafa", "Abdul Baasit", "Athar",
        "Ermina", "Abdul Hameed", "Zaky", "Zeba", "Murdiyyah", "Khulud", "Shafath", "Ramiz", "Afia", "Kawkab",
        "Sameh", "Safiy-Allah", "Fattah", "Afizah", "Bisar", "Dalal", "Maida", "Abdus-Salaam", "Faqeeh", "Zuzer",
        "Najla", "Barir", "Ameen", "Bariah", "Mona", "Tharaa", "Romeesa", "Rabitah", "Saira", "Syed",
        "Mawara", "Aadab", "Samiah", "Falisha", "Bakhtawar", "Raees", "Tayyab", "Naqeebah", "Shimaz", "Sabih",
        "Fiddah", "Kunza", "Hidayat", "Widad", "Muyassar", "Ghazwan", "Sadad", "Zerina", "Baha al Din", "Abdul Nafi",
        "Anjum", "Hayed", "Ghiyath", "Mujeeb", "Jahaan", "Diqrah", "Manhalah", "Nishat", "Hababah", "Munsif",
        "Munirah", "Farah", "Hawshab", "Walif", "Mehvesh", "Nashita Energetic", "Nasrin", "Khallad", "Ashika", "Safwah",
        "Yasmin", "Sabiqah", "Abdul-Mutaalee", "Aalee", "Bakri", "Hilel", "Azeem", "Basinah", "Kaysah", "Najeeb",
        "Maysun", "Firdaus", "Harith", "Manzar", "Urfee", "Saniyah", "Fareed", "Muawwiz", "Imtiyaz", "Nawaf",
        "Zonira", "Mustaeen", "Umaynah", "Diyari", "Siham", "Rafiq", "Fuseelah", "Hajrah", "Kanzah", "Musaddiq",
        "Zafeerah", "Faaz", "Luban", "Madani", "Suad", "Amal", "Shadab", "Bahar", "Aniq", "Maysa",
        "Ajlah", "Najidah", "Dildar", "Afroze", "Ruwaydah", "Nahidah", "Tanzeela", "Abdul Ghafaar", "Jahm", "Naveed",
        "Saeed", "Ateefa", "Hasinah", "Lamis", "Sukaynah", "Tisha", "Aaban", "Malih", "Budail", "Shaheen",
        "Ghazawan", "Hakem", "Sheza", "Feroz", "Sahir", "Sohaib", "Fahima", "Sayyidah", "ziyada", "Abdul Muhyi",
        "Dhuha", "Khazin", "Musheer", "Arsalaan", "Khadeeja", "Shuruq", "Habbab", "Azad", "Ruyah", "Muhair",
        "Johara", "Shaheerah", "Kasam", "Moemen", "Asna", "Uwaysah", "Jiyad", "Rami", "Nashit", "Juhainah",
        "Ghunwah or Ghunyah", "Naazneen", "Munisah", "Mudar", "Wisam", "Sifet", "Mehriban", "Jinan", "Nashah", "Shudun",
        "Shawqi", "Thawban", "Farafisa", "Mysha", "Zaina", "Areej", "Aaleyah", "Saamiya", "Tahiyah", "Sahib",
        "Sarwari", "Kathirah", "karawan", "Sarah", "Thara", "Abdul Muqaddim", "Fayha", "Hafsa", "Safwana", "Yasmeen",
        "Mamdouh", "Nabighah", "Masudah", "Abdul Baseer", "Hayam", "Tareef", "Iram", "Hibat Allah", "Mahasin", "Aminah",
        "Tasnim", "Shahana", "Safia", "Rasheed", "Kamaliyah", "Suraiya", "Mudabbir", "Yusayrah", "Zulaykha", "Kaashif",
        "Shuayb", "Saffar", "Manfoosah", "Mehnaz", "Wasim", "Najah", "Rasheedah", "Yumna", "Fariha", "Mahek",
        "Shaistah", "Faseelah", "Qasif", "Saida", "Makkiyah", "Muallim", "Ambereen", "Umair", "Waajidah", "Sumrah",
        "Foziah", "Hanifa", "Makhtooma", "Suwaybit", "Usama", "Aimen", "Dabir", "Hameem", "Badriyah", "Aroob",
        "Sameya", "Shadha", "Naeema", "Alhusayn", "Hayyan", "Raahil", "Abdul-Ghaffar", "Tawseef", "Zubair", "Afraa",
        "Shiyam", "Junayd", "Hafsah", "Isha", "Thana", "Rabee", "Utbah", "Aabidah", "Azraa", "Komal",
        "Kuhaylah", "Juman", "Yusur", "Fawzi", "Abdul-Baasit", "Mikayeel", "Ateeqah", "Nudbah", "Cala", "Sabburah",
        "Abdus Samad", "Sumayyah", "Musaykah", "Mushtaq", "Tayyib", "Thana", "Abdul Waliy", "Abdul-Wahhab", "Fatin or Fatinah", "Raniya",
        "Abdul-Baari", "Akhtar", "Iffah", "Hasibah", "Falah", "Jahfar", "Tabish", "Amna", "Qiyyama", "Mourad",
        "Aaeedah", "Fikri", "Sajjad", "Abdul Bari", "Mina", "Nagheen", "Fakhr", "Sameeha", "Abdul Maalik", "Hooria",
        "Hareem", "Fayd", "Nazeera", "Manab", "Ramzia", "Bisma", "Haniyah", "Mukarram", "Leena", "Iqrit",
        "Bayan", "Thuwaibah", "Umamah", "Sofia", "Suhaib", "Talat", "Humd", "Khalilah", "Alina", "Lubaid",
        "Nubaid", "Anan", "Jaraah", "Nibras", "Abdus-Samad", "Tamadur", "Shanaz", "Radwa", "Warqaa", "Ghaada",
        "Zuhayra", "Fawwaz", "Nazmi", "Jaun", "Aziz", "Abdul Mumin", "Erum", "Ikram", "Manha", "Hud",
        "Abdul Salam", "Abdul Muqtadir", "Shakurah", "Asiya", "Mehwish", "Rubina", "Noreen", "Naila", "Ziyan", "Kareema",
        "Seemeen", "Khalid", "Arya", "Fikriyah", "Ikrimah", "Abdul Rafi", "Nazahah", "Rawdah", "Naib", "Wajihah",
        "Alaia", "Latifa", "Naraiman", "Halimah", "Asbah", "Abdul Qudoos", "Ulfah", "Abul-Hassan", "Watheq", "Shahrukh",
        "Maizah", "Zafirah", "Rukanah", "Zarar", "Khidrah", "Nadirah", "Sahlah", "Intaj", "Barrah", "Halah",
        "Shurooq", "Ahd", "Mukhlis", "Ataubaq", "Ghauth", "Iyaas", "Abdul-Nur", "Basil", "Muzaffar", "Sulayk",
        "Tasneen", "Taysir", "Ubadah", "Mayeda", "Abdul Batin", "Hubaab", "Haleem", "Naqi", "Badia", "Mahjabeen",
        "Huzayl", "Jalal al Din", "Samaa", "Mustakim", "Seif", "Hadiyyah", "Zara", "Abdul-Quddus", "Lujain", "Ashaath",
        "Ranya", "Abdul-Hafeedh", "Adli", "Sad", "Muhanned", "Hana", "Huwaydah", "Sakhrah", "Soraya", "Lu Luah",
        "Hamamah", "Huzaifah", "Amal", "Maha", "Kanz", "Amber", "Ruqayya", "Abdul Razzaq", "Hana", "Ramin",
        "Nasim", "Sameera", "Joozhar", "Faraza", "Saburah", "Marjanah", "Shamal", "Bahiyyah", "Nihad", "Nabilah",
        "Sheyla", "Saadiya", "Shihab", "Siraj", "Urwah", "Sawwaf", "Ibtihaj", "Muskan", "Raidah", "Anwara",
        "Muayyad", "Ummayyah", "Musaid", "Saful Islam", "Rayn", "Rehana", "Mahfuzah", "Fakeeh", "Wakil", "Masouda",
        "Jari", "Shumayl", "Aaidah", "Haziqah", "Khayaam", "Amam", "Samih", "Muneeb", "Inaya", "Masrur",
        "Fariah", "Jadwa", "Muqbalah", "Qabeel", "Kuwaysah", "Khaldoon", "Khaled", "Ashmath", "Adil", "Jarood",
        "Muadh", "Tobias", "Reema", "Urshia", "Aadil", "Hilmi", "Aasif", "Fahad", "Fateen", "Diya",
        "Areej", "Abdul-Dhahir", "Fakhir", "Huriyah", "Safiyyah", "Tharwat", "Marwa", "Adeeb", "Mounira", "Budayl",
        "Dani", "Yasmina", "Wasay", "Rahilah", "Zehna", "Maymun", "Aatif", "Thaqib", "Maliha", "Hilal",
        "Qaniah", "Ain alsaba", "Reyhana", "Shayma", "Noorah", "Huma", "Mubaraq", "Nazli", "Zoufishan", "Zebadiyah",
        "Haroon", "Shezan", "Safi", "Basheera", "Sayyar", "Shamil", "Midhaa", "Muawiyah", "Saheim", "Qaraah",
        "Raifah", "Qaymayriyah", "Shakirah", "Aatiqah", "Faisal", "Batul", "Ghusoon", "Tazeem", "Rauf", "Isma",
        "Khatera", "Adeela", "Budur", "Sultan", "Mimar", "Udayl", "Zakwan", "Uday", "Rasha", "Habibah",
        "Waheed", "Jawahir", "Humair", "Shatha", "Tara", "Zarmina", "Nadra", "Nusrah", "Miyaz", "Muttee",
        "Abdus Salaam", "Bahiya", "Abdul Mannan", "Mujibur", "Affan", "Eman", "Baahir", "Yusr", "Jaiyana", "Kharqa",
        "Monera", "Aashif", "Ghali", "Basimah", "Najihah", "Abdul-Qaadir", "Muntaha", "Naimah", "Nazeerah", "Mansoor",
        "Farhat", "Madhat", "Shaaf", "Nyla", "Banujah", "Labeeb", "Safun", "Wareesha", "Taheem", "Yaqoot",
        "Haleema", "Najeed", "Mariya", "Mounir", "Mahbubah", "Laqeet", "Rashad", "Sabriyah", "Shihab al Din", "Nashat",
        "Ramia", "Muqtasid", "Rukhsar", "Mais", "Badr al Din", "Sharafat", "Tamam", "Nayyirah", "Barr", "Abdul Baith",
        "Awwab", "Ahmad", "Iyad", "Aneesa", "Arjumand", "Shah", "Abdul Fattah", "Jul", "Nasihah", "Hamdi",
        "Abdul Sabur", "Bushr", "Izdihar", "Khairi", "Qadeer", "Jehan", "Leila", "Izdihar", "Nafisah", "Zuharah",
        "Kausar", "Asadel", "Azim", "Asilah", "Faeq", "Areebah", "Liyana", "Najair", "Jud", "Dema",
        "Talah", "Haytham", "Zubaidah", "Kadir", "Aziza", "Shalimar", "Tabinda", "Uthman", "Rafah", "Safeerah",
        "Abdul Munim", "Iqraam", "Hasna", "Nashema", "Samirah", "Rayhanah", "Bashirah", "Rumaithah", "Hafs", "Abdul Rahman",
        "Bisharah", "Banan", "Bandar", "Lahiah", "Ghaliyah", "Jumaynah", "Anah", "Maysoon", "Nazirah", "Nimat",
        "Baseema", "Maymunah", "Misba", "Suhail", "Musnah", "Malika", "Ahad", "Afif", "Zinat", "Zarrar",
        "Badri", "Rafa", "Shamila", "Athmah", "Sharmeen", "Shajeeah", "Sharifah", "Ibthaj", "Qamar", "Firas",
        "Faraz", "Humam", "Batal", "Wafiza", "Abdul Hakeem", "Abdul-Jaleel", "Kaysan", "Tameem", "Shazmah", "Mustajab",
        "Hikmah", "Shallal", "Rahim", "Tahsin", "Nudrat", "Jana", "Shahada", "Samrah", "Zuha", "Taban",
        "Kashish", "Jalal", "Rahaf", "Aaqib", "Sadeem", "Qabool", "Sumanah", "Arzo", "Hindah", "Rumana",
        "Hafsah", "Fara", "Sahil", "Anmar", "Riyasat", "Khasib", "Ayan", "Nabihah", "Sarwath", "Kasim",
        "Muttaqi", "Aasia", "Makaarim", "Shahnaz", "Nimra", "Abdul-Warith", "Thoraya", "Adeeba", "Midhah", "Aashir",
        "Babar", "Jessenia", "Zairah", "Abdul Muizz", "Nunah", "Saffanah", "Mursal", "Kazi", "Abdur-Raheem", "Dabbah",
        "Mamoon", "Gamal", "Jamal", "Abdul Hasib", "Ghazalah", "Hudad", "Numa", "Mishaal", "Mahmoud", "Safiy al Din",
        "Fakhra", "Rehemat", "Murad", "Jasmir", "Layyah", "Shazia", "Nusrat", "Talal", "Nazeeha", "Rubiya",
        "Musn", "Fatin", "Wahhab", "Sayyid", "Madiha", "Muqbil", "Minal", "Hamood", "Ghadah", "Feiyaz",
        "Husayn", "Ruwayfi", "Hadeel", "Dujanah", "Ubah", "Ammar", "Mueen", "Usamah", "Zuhera", "Zaib",
        "Abdul-Aalee", "Huzayfah", "Imthithal", "Samah", "Inan", "Juwairiyah", "Irfan", "Khansa", "Sumaiyah", "Farizah",
        "Nadim", "Ghayda", "Nazuk", "Yumna", "Azfer", "Amelia", "Akilah", "Azzah", "Nur al Huda", "Adifaah",
        "Firdaws", "Nahida", "Iftikhar", "Raniyah", "Rafee", "Muizza", "Isa", "Annam", "Suhailah", "Faizaan",
        "Abdul Rashid", "Misbah", "Gulab", "Sabeeh", "Maimoona", "Rameesha", "Hamim", "Aamira", "Sawsan", "Zakiyah",
        "Aqeel", "Mehboob", "Jariyah", "Mujtaba", "Musa", "Ablah", "Arman", "Basem", "Aiza", "Adila",
        "Nelofar", "Jaseena", "Nasha", "Thurayya", "Fawad", "Rajab", "Nashitah", "Suha", "Ilan", "Mona",
        "Abdul Muzanni", "Jumaana", "Nasheelah", "Masud", "Moazzam", "Laiq", "Rihana", "Zorah", "Shazeb", "Shairah",
        "Munawwar", "Shiya", "Unays", "Anum", "Shaqeeq", "Tariq", "Abdul Azeez", "Najah", "Ayham", "Ramzi",
        "Saaliha", "Majdi", "Afham", "Rumaythah", "Naseer", "Qamayr", "Dilawar", "Abisali", "Shadi", "Zakar",
        "Salifah", "Mishal", "Abqurah", "Baha", "Hur", "Almas", "Zeeshan", "Samaah", "Ghassan", "Sadeed",
        "Wazir", "Ghufran", "Adel", "Masoud", "Mohga", "Agharr", "Atika", "Rudaynah", "Shukri", "Layali",
        "Mahum", "Zaroon", "Qadi", "Eshan", "Rasool", "Mehvish", "Azab", "Malayeka", "Hudhafah", "Arif",
        "Munaf", "Zuhair", "Itidal", "Thurayya", "Farhah", "Ata al Rahman", "Taqiyah", "Nasir", "Nidda", "Iftikar",
        "Taqwaa", "Farooq", "Jala", "Abdul Hamid", "Subhiyah", "Ada", "Hajar", "Sundus", "Anwaar", "Inayah",
        "Rahil", "Alman", "Muhriz", "Dhakiy", "Hadeeqa", "Fawzah", "Khair al Din", "Anisah", "Asbagh", "Qarasafahl",
        "Naima", "Hadad", "Wildan", "Itimad", "Adeeva", "Abdul Qahaar", "Naseerah", "Nadimah", "Dhakir", "Qutaylah",
        "Arub", "Wahuj", "Musab", "Heela", "Umaiza", "Noor Jehan", "Salaahddinn", "Jumuah", "Falaq", "Sadah",
        "Azzah", "Kashifah", "Abdul Muid", "Jal", "Saba", "Fath", "Imtihal", "Thaminah", "Raheemah", "Nur Firdaus",
        "Wadi", "Mashoodah", "Ridha", "Naweed", "Nailah", "Abdul Muhyee", "Shayaan", "Sofian", "Yumn", "Inaam",
        "Asheeyana", "Shahlah", "Dinar", "Buhaysah", "Ismat", "Yazan", "Abdullah", "Issar", "Hayat", "Lutfiyah",
        "Ragheb", "Iyaad", "Nasira", "Warqa", "Ahnaf", "Anas", "Nada", "Samarah", "Sahm", "Hazimah",
        "Wisaal", "Waqaar", "Shahin", "Abdul Mutaal", "Hayfa", "Baha", "Abdur-Rauf", "Shahzaib", "Rahmah", "Ranim",
        "Dawoud", "Muqadaas", "Shams al Din", "Mubashir", "Bareerah", "Mawsil", "Rasmi", "Nesrin", "Mazin", "Gharam",
        "Shaharyar", "Nayyab", "Asra", "Yusuf", "Kasim", "Sagheer", "Fadl Allah", "Wajid", "Muhayr", "Naadir",
        "Ubaab", "Tahira", "Abbud", "Emran", "Sehrish", "Asim", "Luay", "Imaad", "Hubba", "Abdul Raheem",
        "Azraqi", "Kifah", "Udail", "Basaaria", "Abdul Hannan", "Zakariyya", "Sharaheel", "Huriyyah", "Muhibbah", "Marid",
        "Hadi", "Luqman", "Jamilah", "Shihaam", "Halima", "Mirah", "Riyad", "Lubabah", "Lana", "Naflah",
        "Arzu", "Rand", "Suraya", "Thufailah", "Majida", "Abdul Qaadir", "Akeem", "Tamkeen", "Arij", "Najibah",
        "Sajidah", "Waseefah", "Aighar", "Suhair", "Zubayr", "Samiyah", "Baasim", "Yuhannis", "Aziz", "Judamah",
        "Abrash", "Hudhayfah", "Nissa", "Sarra", "Muazzaz", "Hanbal", "Zohra", "Abdul Muhaimin", "Muhibb", "Amala",
        "Munjid", "Sumayrah", "Nuraz", "Hayfa", "Afaf", "Ayyash", "Shamoodah", "Rawhiyah", "Ramlah", "Iqtidar",
        "Rabiyah", "Furozh", "Kahil", "Fareess", "Abdul Alim", "Najya", "Turhan", "Saabira", "Jahmyyllah", "Zinah",
        "Azzam", "Naqid", "Ghazal", "Zakirah", "Maysan", "Aabish", "Zaheerah", "Abid", "Mishael", "Zayd",
        "Shahidah", "Juhaynah", "Alia", "Mahrosh", "Abdul-Muizz", "Wajih", "Mashhud", "Tahseen", "Owais", "Fateenah",
        "Jaza", "Samirah", "Hammad", "Sakeenah", "Sadaqat", "Sawa", "Musharraf", "Motasim", "Yara", "Mufeed",
        "Zulfah", "Jasim.", "Sabirah", "Jabeen", "Adeela", "Abdul Khaliq", "Bassam", "Faizah", "Ikram", "Asif",
        "Jawl", "Kawakib", "Sughra", "Khatoon", "Rushdi", "Umm Kulthum", "Shahzad", "Fariza", "Ghusoon", "Lamah",
        "Qudsiyah", "Wafaa", "Yasser", "Jahiz", "Naseem", "Tajammal", "Badiyah", "Badra", "Layth", "Shiraz",
        "Shehla", "Zaara", "Jummal", "Daneen", "Inayat", "Lut", "Ghazzal", "Sheila", "Wardah", "Rabah",
        "Rabbani", "Abdul-Qahhar", "Hafiz", "Bayhas", "Afeerah", "Javier", "Khubayb", "Basim", "Daniyah", "Qais",
        "Zohair", "Nabeel", "Sinan", "Abdul Rabb", "Usayd", "Hawwa", "Mahdiyah", "Mustaqeem", "Ezzah", "Hanifah",
        "Ihtisham", "Sabeeyah", "Ablah", "Neelam", "Tahiyat", "Rasil", "Sarina", "Umair", "Munazzah", "Nibaal",
        "Yasirah", "Arsal", "Zamil", "Mumtaz", "Marzuq", "Shayan", "Kashif", "Ayana", "Samman", "Mersiha",
        "Samar", "Mustaneer", "Khayriyyah", "Widaad", "Boulos", "Darwish", "Reem", "Samir", "Zaman", "Lina",
        "Shafiah", "Bulhut", "Shifa", "Muminah", "Mujaddid", "Salar", "Khateeb", "Shareekah", "Wafeeqah", "Rafal",
        "Abdul Ghaffar", "Fuad", "Qaim", "Hala", "Summayyah", "Jabbar", "Jilan", "Wakalat", "Zayb", "Dawud",
        "Lamiah", "Adawiyah", "Samiun", "Sorfina", "Mastura", "Shahid", "Katib", "Sawdah", "Muharrem", "Zoeya",
        "Mukhlisah", "Khusbakht", "Mobeen", "Salsabeel", "Aaeesha", "Abir", "Mahbasah", "Maqboolah", "Jawdah", "Sahab",
        "Afeef", "Subhah", "Wisaam", "Nabhan", "Zahirah", "Jamil", "Kaleemah", "Naureen", "Shazad", "Manar",
        "Kazim", "Reham", "Abdul Mubdee", "Kiswar", "Abdul Qayyum", "Sulaiman", "Gamali", "Adara", "Huda", "Suhaym",
        "Marzuqah", "Mustatab", "Nighat", "Buhayyah", "Jarir", "Humayrah", "Binish", "Jalil", "Abdul Jalil", "Tanisha",
        "Ashraf", "Kamal", "Abdur-Rahman", "Shurahbeel", "Buhaisah", "Nazeefah", "Shuraym", "Rehan", "Yushua", "Amjad",
        "Hamra", "Firoz", "Mansurah", "Omar", "Husn", "Nafeesa", "Barika", "Ward", "Latifah", "Amana",
        "Hurrah", "Minaal", "Motaz", "Intisar", "Wasimah", "Imad", "Sheraz", "Wasif", "Izzat", "Razan",
        "Afsheen", "Anbarin", "Andalib", "Hooda", "Saidah", "Usaim", "Muhannad", "Zehra", "Faris", "Awn",
        "Batrisyia", "Zaynab", "Amid", "Riaz", "Mawahib", "Rameez", "Saud", "Yasar", "Yoonus", "Hessa",
        "Rabeea", "Nathifa", "Saqib", "Anjam", "Rahmaa", "Ashwaq", "Fareed", "Wordah", "Sumaytah", "Inayah",
        "Abal", "Khayrah", "Rahman", "Baysan", "Raghid", "Alraaz", "Hashid", "Amra", "Mubarak", "Murtaza",
        "Roshini", "Dawlah", "Kaiser", "Zuhayr", "Fathiyah", "Azraq", "Laaibah", "Rawhah", "Baligh", "Wid",
        "Sadun", "Aalim", "Nadhir", "Fatin", "Shafaat", "Habibah", "Shukriyah", "Swiyyah", "Abdul Hadi", "Shazana",
        "Zubaydah", "Fariq", "Ana", "Dahab", "Ala al Din", "Fatimah", "Shajee", "Shafee", "Ahlam", "Reshma",
        "Yusra", "Aws", "Basimah", "Madihah", "Maruf", "Rafidah", "Abdur-Razzaq", "Nawal", "Kadeer", "Butrus",
        "Hanan", "Aydin", "Nihal", "Salihah", "Shurafa", "Fawziyah", "Tuba", "Zuhaa", "Abdul-Kareem", "Ammaar",
        "Janan", "Saif", "Ammarah", "Lutfi", "Hasib", "Siham", "Abdul Raafi", "Abdul Warith", "Aneeq", "Ehan",
        "Basbas", "Abbas", "Baraah", "Abdul Rauf", "Hayaam", "Khaleel", "Daliya", "Yaminah", "Hidiyah", "Asiyah",
        "Ahdia", "Walidah", "Fazal", "Khayri", "Muwaffaq", "Aamirah", "Nuaim", "Fathiya", "Juhaym", "Yumnah",
        "Ilyas", "Shahadat", "Intisar", "Naeema", "Makin", "Lablab", "Hooriya", "Shaybah", "Sadiah", "Latif",
        "Wahib", "Mutazah", "Raya", "Sumnah", "Narmin", "Sumayra", "Tibah", "Mubassir", "Asima", "Imtithal",
        "Raif", "Abdul-Baaqi", "Zoharin", "Abdul Hafeez", "Mahad", "Faeezah", "Khuraymah", "Rafi", "Ata Allah", "Safiyy",
        "Bashirah", "Inaam", "Shuaa", "Sairish", "Khaleed", "Arub", "Tammam", "Nora", "Mawiyah", "Rafat",
        "Abdur Razzaq", "Murtadi", "Husniya", "Houd", "Sairah", "Mehrish", "Bilal", "Shabnam", "Shiza", "Naairah",
        "Abdul Muntaqim", "Abdul Karim", "Jawdan", "Shayla", "Hiyam", "Minnah", "Atikah", "Tasheen", "Zareena", "Maysarah",
        "Hayder", "Adham", "Aalia", "Maymunah", "Abdul-Hameed", "Maram", "Saood", "Fatim", "Shareek", "Habiba",
        "Al-Adur al-Karimah", "Abdus-Shakur", "Barraq", "Fuad", "Hoor", "Navil", "Amara", "Nur", "Shabab", "Aaqilah",
        "Ghania", "Tuqaa", "Rudainah", "Akhfash", "Aqeil", "Mutayyib", "Qadim", "Alya", "Nuzhat", "Badi",
        "Ashar", "Ghizlan", "Hadiyah", "Mumayyaz", "Shehryaar", "Baseema", "Asma", "Asma", "Fudayl", "Maryum",
        "Hameeda", "Mufidah", "Sabr", "Miftah", "Sharmeela", "Faridah", "Subbiha", "Ishtiyaq", "Zayan", "Raji",
        "Hosaam", "Baheera", "Buhthah", "Hami", "Mehreen", "Lubaaba", "Firdowsa", "Aaqil", "Horia", "Muhja",
        "Farooq", "Adila", "Anida", "Amany", "Mahfuz", "Jibril", "Rida", "Taybah", "Arfa", "Radhiya",
        "Aisha", "Saimah", "Adil", "Mutahhir", "Muhsinah", "Khadijah", "Afzal", "Suwaydah", "Tahera", "Ubab",
        "Zartaj", "Abdul Ali", "Balqees", "Maram", "Rizwana", "Hajjah", "Shihad", "Ilhan", "Azmat", "Nabila",
        "Abdul-Wadood", "Humayun", "Asghar", "Saad", "Suhayl", "Jehaan", "Wafeeq", "Almahdi", "Inas", "Juzar",
        "Sameer", "Haadiya", "Hooriya", "Selina", "Umaymah", "Musaddiqah", "Khayri", "Jawna", "Nurjenna", "Najid",
        "Arham", "Shanum", "Sanjeedah", "Layan", "Aatikah", "Mubashirah", "Ghutayf", "Ishraq", "Ruksha", "Wasil",
        "Muzaynah", "Husni", "Simah", "Shafaq", "Abdul-Khaliq", "Jasmin", "Zubi", "Abd Al-Ala", "Ajradah", "Abdul Muhsin",
        "Daleela", "Karim", "Hadee", "Najam", "Hamd", "Rashad", "Bahir", "Ridwan", "Gohar", "Osama",
        "Fadilah", "Huwaidah", "Waleed", "Radeyah", "Dhakirah", "Natasha", "Qareebah", "Isar", "Shehroze", "Fadila",
        "Mawiya", "Nashwa", "Aza", "Raaida", "Salikah", "Istabraq", "Nawwal", "Nazeem", "Najiyah", "Souhayla",
        "Sehr", "Aamir", "Naushaba", "Khayyat", "Abdul Mujib", "Shadmani", "Narjis", "Quadriyyah", "Lamisah", "Shahina",
        "Marwan", "Lajlaj", "Ghuzayyah", "Hanin", "Doaa", "Medina", "Fajr", "Suhaymah", "Suhayr", "Faiqah",
        "Abyan", "Taim Allah", "Majidah", "Saibah", "Masun", "Farrukh", "Saaleha", "Sawlat", "Laith", "Zayaan",
        "Nazih", "Aamaal", "Zumurrud", "Wijdan", "Rabar", "Wasifah", "Nazimah", "Basilah", "Qailah", "Naseef",
        "Ameer", "Badi al Zaman", "Sabuhi", "Anis", "Sireen", "Wakeelah", "Jabr", "Arij", "Hannad", "Ikraam",
        "Sameer", "Reema", "Hani", "Nurah", "Abdul Malik", "Atifah", "Abaan", "Aliyyah", "Hasnah", "Nidaa",
        "Sarrinah", "Nuriyah", "Nazakat", "Hudhaifah", "Abdul Mateen", "Zahidah", "Hutun", "Atia", "Nyasia", "Arsh",
        "Sabeeh", "Shahzor", "Wafi", "Muna", "Lateefa", "Abdul Nasser", "Barakah", "Ahwas", "Ithar", "Hena",
        "Pakeezah", "Baber", "Arisha", "Ameer", "Shaista", "Elma", "Rabiah", "Sabur", "Hubayshah", "Rizq",
        "Jihan", "Abeera", "Ruaa", "Nadia", "Asifa", "Sadiyah", "Shad", "Qusay", "Asriyah", "Abidah",
        "Malikah", "Jeelan", "Jubair", "Fathima", "Shamshad", "Tharya", "Irem", "Fadil", "Muhyi al Din", "Raja",
        "Yawar", "Fakhriyah", "Deeba", "Ilham", "Maysaa", "Sanam", "Maya", "Nudar", "Mayyadah", "Safoorah",
        "Atif", "Ghaith", "Salih", "Nazihah", "Adan", "Tajudinn", "Batool", "Sabirah", "Sadit", "Sharif",
        "Istilah", "Mahjub", "Abdul Haqq", "Akif", "Musheera", "Bashshar", "Behzad", "Khursheed", "Abdul Mani", "Shamsideen",
        "Muhtadi", "Thamar", "Fakihah", "Husna", "Kanwal", "Noor-Al-Haya", "Fawz", "Hujayrah", "Nazeer", "Waiz",
        "Dunia", "Sabihah", "Aiman", "Antarah", "Dhul Fiqar", "Wahban", "Haikal", "Abeer", "Fakhry", "Ghunayn",
        "Main", "Amr", "Ban", "Raeesah", "Hamid", "Mukhtar", "Alhena", "Farkhandah", "Jannah", "Ayshah",
        "Aram", "Abdul Basir", "Muslim", "Suheera", "Raidah", "Chandni", "Nazeef", "Farhanah", "Thuwaybah", "Najaf",
        "Halah", "Noorali", "Mufiah", "Shadhiyah", "Khulaybah", "Anees", "Maraam", "Ferran", "Maisah", "Aseed",
        "Mualla", "Siyana", "Sanaubar", "Sulayman", "Najeeb", "Dean", "Fida", "Sayid", "Firdoos", "Shibli",
        "Mada", "Nasmah", "Samah", "Malak", "Shaukat", "Sharaf", "Samawah", "Iraj", "Zahrah", "Khafid",
        "Abdul Shakur", "Sahl", "Asima", "Aamanee", "Azza", "Adam", "Tahirah", "Ateeb", "Aijaz", "Yakootah",
        "Shamim", "Khulus", "Bashair", "Nithar", "Yaqub", "Firyal", "Sukaynah", "Nazneen", "Suhayl", "Kalila",
        "Wafiq", "Adiy", "Nain", "Murtadhy", "Rafeeqah", "Ujala", "Abdul-Mumin", "Inayat", "Haniya", "Muin",
        "Ibtisam", "Ilhaam", "Iyas", "Nishaaj", "Sahar", "Zariya", "Zakir", "Hatib", "Salif", "Zafir",
        "Isam", "Yusri", "Rua", "Atyaf", "Nuryn", "Hamas", "Atifa", "Maria", "Afraz", "Sufyan",
        "Abdur-Rasheed", "Maysoon", "Cantara", "Saadah", "Sara", "Najwa", "Masood", "Reja", "Aidah", "Nadeem",
        "Sagheerah", "Zufar", "Diyanah", "Romana", "Basmah", "Darim", "Qays", "Fahd", "Umnia", "Zakariya",
        "Masumah", "Qismah", "Falih", "Hujayyah", "Intessar", "Fawziya", "Rufaidah", "Khalifah", "Uqbah", "Aila",
        "Afaaq", "Muhanna", "Sulayman", "Buthayna", "Yaman", "Kaamil", "Dirar", "Jaan", "Nayif", "Bashir",
        "Anaum", "Haddad", "Thayer", "Muhdee", "Adnan", "Khayr", "Aakifah", "Fudail", "Khulud", "Jibran",
        "Takiyah", "Yafiah", "Hajjaj", "Bashaar", "Abda", "Ibtihaj", "Nusaibah", "Wahab", "Sharmin", "Isra",
        "Baraka", "Aduz Zahir", "Jawhar", "Suwayd", "Kanval", "Raghidah", "Saffiya", "Amjad", "Suud", "Naseemah",
        "Sawdah", "Munzir", "Abdul Sattar", "Natiq", "Rakhshan", "Abu al Khayr", "Durar", "Wajdi", "Abida", "Abir",
        "Badriyah", "Sajid", "Nabeeha", "Raghibah", "Rajiyah", "Muhib", "Munis", "Farid", "Maisah", "Shahed",
        "Amaya", "Zoha", "Jalees", "Zuhrah", "Aishah", "Faakhir", "Umniyah", "Sudi", "Nusrah", "Abdul Qadeer",
        "Razeen", "Taymur", "Uzayr", "Afsa", "Azizah", "Badriyyah", "Yasir", "Fathi", "Razaan", "Yasna",
        "Ruqaya", "Ikhlas", "Lunah", "Haajar", "Mahreen", "Nasib", "Rana", "Hafthah", "Nazahah", "Zawiya",
        "Raitah", "Hawadah", "Zaim", "Umar", "Aarifah", "Bahijah", "Salimah", "Nasheed", "Nagina", "Zoya",
        "Rayya", "Silah", "Abdur-Raqeeb", "Shams", "Sarim", "Aala", "Sarosh", "Ajib", "Aroob", "Varisha",
        "Fakhirah", "Nuhaa", "Muhammad", "Khayriyah", "Ihab", "Muna", "Zahraa", "Abdul-Aleem", "Abdul Jaleel", "Nasri",
        "Qasim", "Quraybah", "Maryam", "Tehzeeb", "Siraj al Din", "Muhab", "Jabirah", "Ruwayd", "Adeel", "Abdul Wasi",
        "Rayna", "Asmaa", "Wasilah", "Afsana", "Munira", "Kaneez", "Khaleel", "Wajahat", "Hatim", "Aimal",
        "Farida", "Abdul Hakim", "Maahnoor", "Mateenah", "Rawdha", "Shadha", "Hafizah", "Fareeda", "Zalfa", "Durriyah",
        "Azaan", "Radi", "Abdul Muqsit", "Abdus Subbooh", "Burayd", "Naaz", "Shamis", "Munerah", "Hijab", "Daghfal",
        "Amaan", "Najib", "Mahja", "Shafia", "Abdul", "Nibras", "Mehek", "El-Amin", "Athir", "Fauzia",
        "Mahwish", "Nazish", "Muballigh", "Raima", "Nargis", "Hurayth", "Sawad", "Rushd", "Abdul Mughni", "Nooh",
        "Nidal", "Shareef", "Fahmida", "Adn", "Samiya", "Buthaynah", "Rohaan", "Nasuh", "Abdul Khabir", "Shahir",
        "Mad", "Aneeqa", "Nahlah", "Rukhsana", "Afya", "Mahnoor", "Aneezah", "Khuwaylah", "Ubaidah", "Waliy Allah",
        "Nuwwarrah", "Mehrunisa", "Umarah", "Ilifat", "Kawthar", "Nusaybah", "Akleema", "Kalbi", "Mufti", "Maqil",
        "Azhar", "Jahangir", "Saadia", "Nafisah", "Zameer", "Nimah", "Ayser", "Subaha", "Abdul-Majid", "Juwayriyah",
        "Thuwaybah", "Falak", "Aidah", "Misha", "Ashim", "Salim", "Wadha", "Fahada", "Sarfaraz", "Bilqees",
        "Sunbul", "Nasreen", "Husniyah", "Jameel", "Wahhaj", "Uthal", "Shazfa", "Sirin", "Rawahah", "Abdul-Mughni",
        "Sadid", "Kaliq", "Mueez", "Waail", "Aadila", "Akram", "Abdul Halim", "Walid", "Raghad", "Kadshah",
        "Afiyah", "Tuba", "Hesam", "Fahdah", "Rifaah", "Amani", "Sharifah", "Alhasan", "Ghusun", "Hammam",
        "Niyaf", "Amsah", "Suhaimah", "Shams-Ul-Haq", "Labib", "Wafiqah", "Abdul Haq", "Basoos", "Moosa", "Saeedah",
        "Qaseem", "Chanda", "Hifza", "Isir", "Alika", "Muslih", "Raghib", "Hayam", "Madihah", "Majidah",
        "Nuwairah", "Murshid", "Sadad", "Hassan", "Aresha", "Mumina", "Noureen", "Salsal", "Khushtar", "Zayd",
        "Altaf", "Itab", "Ratib", "Shadiyah", "Hukaymah", "Suraa", "Fatihah", "Zaida", "Akia", "Shabib.",
        "Rubi", "Dahma", "Hakimah", "Maher", "Bunanah", "Lubabah", "Dawid", "Busrah", "Hajib", "Nawfal",
        "Rabab", "Thaman", "Sanaa", "Sakeena", "Karam", "Hussain", "Rajih", "Asad", "Abdul Majeed", "Arshaq",
        "Aslam", "Shaqeeqah", "Yazeed", "Abdul Ahad", "Sati", "Sarwar", "Sheenaz", "Lubab", "Alhusain", "Umayyah",
        "Naheeda", "Maysun", "Rabit", "Jaul", "Ula", "Fateen", "Kulthum", "Tazkia", "Haroun", "Faizan",
        "Bassam", "Juwain", "Nusayb", "Raza", "Ashadieeyah", "Raiqah", "Salaam", "Abdul Afuw", "Sundas", "Abdus-Sabour",
        "Mashkoor", "Rafia", "Taghrid", "Seif", "Bishr", "Eisa", "Abdul Hakam", "Abdul Muqeet", "Amer", "Qutaibah",
        "Aroush", "Munif", "Hafa", "Khawlah", "Nevaeh", "Khuzamah", "Iman", "Insha", "Fujai", "Razaanah",
        "Shadan", "Saja", "Rayhan", "Buhaysah", "Maysam", "Subayah", "Qabilah", "Shamsia", "Abasah", "Ubaydullah",
        "Abdul-Hadi", "Wiam", "Ghannam", "Israail", "Thashin", "Ramadan", "Mamduh", "Tahawwur", "Zain", "Abra",
        "Siddiqah", "Hasan", "Qanit", "Abdul Naseer", "Daamin", "Mayyada", "Abdul Kabir", "Nimaat", "Omera", "Mufeeda",
        "Abdul Basit", "Azhaar", "Abdul-Haqq", "Mutazz", "Dhuka", "Qutaybah", "Nurdeen", "Absi", "Aamil", "Wabisa",
        "Mahvish", "Murjanah", "Hanash", "Arfan", "Zahabiya", "Abdus Sabur", "Ifra", "Imad al Din", "Razin", "Ziaud",
        "Amtullah", "Janan", "Zarqa", "Burdah", "Balsam", "Yusef", "Umm Kalthum", "Salih", "Aleemah", "Akhlaq",
        "Henna", "Khuzaymah", "Rawiah", "Shafana", "Nabihah", "Labibah", "Hamdhy", "Taseen", "Shadhaa", "Sanika",
        "Rawah", "Asmara", "Fadheela", "Naqeeb", "Sarish", "Sikandar", "Ghalib", "Heyam", "Rukan", "Buthainah",
        "Bahira", "Saleem", "Raihan", "Nija", "Senada", "Zanubiya", "Rona", "Uwayam", "Yasmine", "Saif al Din",
        "Shuneal", "Jahanzeb", "Dizhwar", "Uhban", "Thuraiya", "Niyaz", "Sanari", "Thaqaf", "Nooh", "Alia",
        "Zamrud", "Qaysar", "Raheesh", "Sarmad", "Aaliyah", "Mahibah", "Sfiyah", "Ijli", "Awa", "Sabaa",
        "Issam", "Shan", "Shawq", "Anika", "Kurayb", "Shehzadi", "Aafiya", "Tharwah", "Abdul Wadud", "Fayyad",
        "Lina", "Abdul Muhsi", "Maab", "Fadeelah", "Durrah", "Ala", "Ramziyah", "May", "Abdul Baari", "Fatih",
        "Abeerah", "Hamdiyah", "Nahid", "Sobia", "Afreen", "Uzma", "Shayma", "Majid", "Naman", "Bushra",
        "Riffat", "Zameena", "Bashar", "Jumah", "Wurud", "Alima", "Thabit", "Shanika", "Suda", "Tajammul",
        "Isad", "Nakhat", "Bazam", "Alia", "Wisal", "Abrar", "Dhakiyah", "Wail", "Lazim", "Kehkashan",
        "Hayrah", "Manal", "Lamees", "Kaukab", "Jemimah", "Najmah", "Miqdad", "Nadir", "Sanawbar", "Asrar",
        "Saqr", "Janaan", "Inam", "Nafeesa", "Abdul Aleem", "Hazim", "Simrah", "Ghasaan", "Hawwa", "Altair",
        "Faryat", "Hafid", "Ihtiram", "Nail", "Shagufta", "Sitarah", "Tafida", "Ayishah", "Bahiya", "Zaina",
        "Nayab", "Faqirah", "Khairy", "Buqayrah", "Zafirah", "Ayesha", "Ramsha", "Intikhab", "Maaz", "Saqer",
        "Majd al Din", "Tanim", "Aisha", "Firdous", "Jubayr", "Shua", "Rafiqah", "Munisa", "Mounia", "Nilofar",
        "Zaid", "Roshan", "Muhtashim", "Farasat", "Fakhr al Din", "Sirah", "Jahida", "Qadriyyah", "Ismail", "Muti",
        "Bahiyaa", "Humera", "Waseemah", "Neha", "Ihtsham", "Abdul Wakil", "Muta", "Abdul Sami", "Zaki", "Abdul Zahir",
        "Bahiyy al Din", "Miskeen", "Abdus Shafi", "Hajna", "Idhar", "Ghazalan", "Khalidah", "Nasiha", "Sumaiya", "Nijah",
        "Mashal", "Basharat", "Imran", "Mabad", "Masarrat", "Nadiyah", "Makhdoom", "Malmal", "Faysal", "Wafeeqa",
        "Tawfeeq", "Sibal", "Abdul Barr", "Mushirah", "Abdus-Sameei", "Zahara", "Rahimah", "Saim", "Judi", "Sadoof",
        "Dilshad Khatoon", "Husam al Din", "Bahij", "Laraib", "Aalam", "Kadin", "Abdul Shahid", "Safiyyah", "Yalqoot", "Fahyim",
        "Shadeed", "Ubayy", "Abdul Nur", "Farhana", "Nabijah", "Warsan", "Shabb", "Layla", "Ghulam", "Ishrat",
        "Daanish", "Aladdin", "Abdul-Adheem", "Namir", "Shurayh", "Fakhtah", "Aaminah", "Rima", "Sura", "Khaleeq",
        "Amala", "Nuwwar", "Saiqa", "Abdul Quddus", "Lujaina", "Binesh", "Haris", "Afeefa", "Mahneerah", "Izaan",
        "Kharijah", "Shehzaad", "Mekka", "Mahmud", "Thara", "Zohura", "Yathrib", "Mustafeed", "Nafasat", "Bahira",
        "Lama", "Taj", "Saihah", "Qaylah", "Shafiqah", "Itaf", "Nouf", "Kedar", "Rumaylah", "Kinza",
        "Ayyub", "Haji", "Jamilah", "Ruqayyah", "Altaf", "Nizar", "Sanaullah", "Saafir", "Yasin", "Tayma",
        "Yasmeenah", "Aqeelah", "Nujud", "Simak", "Nadr", "Sair", "Waliy al Din", "Safwan", "Madeeha", "Abdul Awwal",
        "Rawh", "Mufakkir", "Ata", "Junah", "Suhaylah", "Mohaddisa", "Aazim", "Amro", "Suhaylah", "Umm-e-kulsum",
        "Salimah", "Qutuz", "Nuaymah", "Radhwaa", "Sameea", "Amilah", "Abdul Raqib", "Bilqis", "Hubab", "Juhanah",
        "Tasawwar", "Farees", "Tawoos", "Madeeha", "Afshan", "Artah", "Ulfat", "Murtadaa", "Ibtihaaj", "Randa",
        "Rayya", "Thamir", "Aleeza", "Khoury", "Qasoomah", "Muhajir", "Nosheen", "Zarif", "Sabir", "Jenna",
        "Nausheen", "Nasrullah", "Dua", "Somaya", "Atiq", "Wajd", "Ghadir", "Anan", "Naif", "Umran",
        "Athilah", "Alma", "Yarah", "Tazim", "Farzana", "Shaheem", "Kafeel", "Daria", "Ibadah", "Mishel",
        "Nasr", "Khush Bakht", "Binyamin", "Iffat", "Rabiya", "Rihab", "Nahla", "Ahmar", "Aliyy", "Hawra",
        "Ghayoor", "Rija", "Raashid", "Saleema", "Tarif", "Durdanah", "Najat", "Ablaa", "Sumbul", "Waliyah",
        "Fazia", "Humra", "Salmaa", "Sab", "Ijaz", "Shareef", "Nelam", "Suhayr", "Marghoob", "Daniyal",
        "Jahanara", "Shafi", "Danish", "Zareenah", "Ambar", "Abthi", "Nuhayd", "Aliyah", "Haniah", "Raonar",
        "Imad", "Fayek", "Abdus", "Shameemah", "Haaziq", "Karif", "Suoud", "Riham", "Aziz", "Huthayfa",
        "Khalil al Allah", "Izdihaar", "Khalida", "Khunays", "Tasadduq", "Zaighum", "Adab", "Shireen", "Afifa", "Ataa",
        "Alimah", "Neeshad", "Rasmiyah", "Sabri", "Sana", "Abdul Aalee", "Daud", "Yameen", "Shadin", "Rim",
        "Kyda", "Khalam", "Sabeer", "Muheet", "Rimsha", "Javairea", "Lamees", "Junaid", "Salik", "Aini",
        "Az-zahra", "Nabeel", "Abd al", "Kaseeb", "Dimah", "Zeenat", "Nuh", "Awad", "Nahla", "Naeemah",
        "Subuhi", "Hisham", "Haider", "Rafif", "Juwariyah", "Hayah", "Namar", "Abdul Wajid", "Shameem", "Mayyadah",
        "Marah", "Nadira", "Hibbaan", "Munir", "Aarif", "Zaheer", "Eliza", "Ameenah", "Sidrah", "Shoaib",
        "Aatifa", "Fawziyyah", "Tameez", "Shahnawaz", "Waleed", "Sharique", "Badiah", "Fiza", "Ayat", "Zameelah",
        "Arshad", "Jundub", "Lamya", "Amal", "Musad", "Azadeh", "Izma", "Hurairah", "Isa", "Tameemah",
        "Mughith", "Salwa", "Baraaa", "Aamilah", "Maleehah", "Khalaf", "Lubena", "Maisa", "Rashidah", "Wad",
        "Mistah", "Sufia", "Beena", "Yahya", "Amir", "Hulyah", "Shafin", "Aamal", "Ruhina", "Buthaynah",
        "Khadijah", "Mohammed", "Safeenah", "Taj al Din", "Halim", "Sohail", "Afrah", "Miskeenah", "Batinah", "Shukrah",
        "Idris", "Abla", "Nabih", "Humayrah", "Feerozah", "Khulood", "Hazirah", "Shabana", "Mikail", "Omar",
        "Haboos", "Akhas", "Kareef", "Arbaaz", "Basma", "Wahb", "Suraqah", "Falaknaz", "Mehrnaz", "Abdul Badi",
        "Abdul Nasir", "Kajji", "Ara", "Masum", "Tooba", "Malakah", "Khaldun", "Abyad", "Lujayn", "Jad Allah",
        "Mahd", "Zaynab", "Abdul Haleem", "Shahzaadee", "Muneer", "Shaban", "Wahid", "Qadriyah", "Rashida", "Sarfraz",
        "Sana", "Erina", "Hind", "Yusriyah", "Walaa", "Anam", "Fayzan", "Khuzaimah", "Nida", "Abrad",
        "Maali", "Ubaid", "Kulthoom", "Adib", "Rumaisa", "Fayaaz", "Muthanna", "Humza", "Ismah", "Mubin",
        "Noor", "Khadim", "Duha", "Abdul Ghani", "Kamil", "Naheed", "Razan", "Naeem", "Ajwa", "Insaf",
        "Mayameen", "Badr", "Ghaliyah", "Ameera", "Ghaneemah", "Aniya", "Nadidah", "Qisaf", "Aqsa", "Jareer",
        "Naseeka", "Keyaan", "Quddusiyyah", "Shamel", "Hanif", "Afra", "Nazia", "Busr", "Afra", "Aara",
        "Safaa", "Hamza", "Wasna", "Seerat", "Saiful Azman", "Yelda", "Humairah", "Rabia", "Tamanna", "Jawad",
        "Benyamin", "Jihad", "Ghadah", "Dawud", "Azeeza", "Muntazir", "Mufaddal", "Umayrah", "Mufeed", "Awf",
        "Nuaym", "Bahiyah", "Sariyah", "Taimur", "Aalimah", "Sarab", "Batool", "Widad", "Aanisah", "Azeemah",
        "Jameela", "Kulus", "Manal", "Maladh", "Zinah", "Abdul Azim", "Basmah", "Khalidah", "Rani", "Isam",
        "Zuhoor", "Asalah", "Laiba", "Athir", "Karimah", "Abdul Majid", "Rahmat", "Habib", "Habeeba", "Murabbi",
        "Miraj", "Nadwah", "Surayj", "Asil", "Abdul Hayy", "Khurram", "Fida", "Jawa", "Akil", "Jad",
        "Harun", "Zuehb", "Mussah", "Atiyah", "Najdah", "Nusrat", "Yamamah", "Zinneerah", "Kaleem", "Ameera",
        "Firdaws", "Kateb", "Souad", "Nahleejah", "Rayann", "Wisal", "Ghaaliya", "Wahabah", "Abdul Aziz",
    ],
    "Hindu": [
        "Neni", "Shiva", "Kumkum", "Pramjot", "Annu", "Leela", "Golu", "Sarvesh", "Rukmani", "Nandu",
        "Rajeev", "Sabhana", "Harishankar", "Usha", "Araddhna", "Badri", "Jang", "Rajneesh", "Jeenat", "Mohan",
        "Divaraj", "Durgash", "Sakshi", "Kushal", "Himani", "Saveta", "Shabanagudiya", "Durgesh", "Mumtazbabi", "Rustam",
        "Yognder", "Anshul", "Rijakpal", "Anjali", "Tarjan", "Soni", "Ankush", "Riya", "Shalu", "Yash",
        "Pooran", "Kunalkannu", "Lalideepa", "Rajuchhotu", "Baksi", "Jasoda", "Birju", "Karinakavita", "Purnima", "Sharat",
        "Sana", "Ranu", "Naresh", "Naveen", "Vinod", "Rijul", "Piyush", "Nabav", "Nirmal", "Karishma",
        "Rashab", "Surjeet", "Ishika", "Avdhesh", "Rama", "Dipti", "Minakxi", "Andhav", "Padma", "Hemant",
        "Bhanu", "Mamta", "Sahiba", "Ramdin", "Mira", "Dharam", "Chander", "Ashu", "Radheyshyam", "Akshit",
        "Pancham", "Sabbo", "Indra", "Sarita", "Shivam", "Tavinder", "Chahat", "Apsana", "Kamla", "Rekhai",
        "Bhola", "Ramsem", "Ramkishan", "Mudrika", "Shardanand", "Vimla", "Grace", "Aashiya", "Vikashmungeri", "Harprasad",
        "Sidharath", "Silender", "Brijmohan", "Shehnaz", "Nirmla", "Shubham", "Sahil", "Rohit", "Sevakpitambar", "Rajveer",
        "Anu", "Chain", "Anshu", "Jamrujaha", "Sonali", "Molu", "Subhash", "Pinkooguddu", "Mudsay", "Mahabir",
        "Devraj", "Priya", "Ghansyam", "Harsh", "Neelam", "Abhijeet", "Bodh", "Suman", "Sudha", "Jag",
        "Tina", "Vidhi", "Kangana", "Kritikakittu", "Rishi", "Rashid", "Satish", "Lakshya", "Akhilesh", "Parerna",
        "Beeru", "Narender", "Tarif", "Aamod", "Rajenderkaku", "Radha", "Nadim", "Chaya", "Kishan", "Kranti",
        "Neha", "Huma", "Samaiali", "Devender", "Henkhochon", "Amil", "Chirag", "Akash", "Madhu", "Aanamika",
        "Parth", "Sobit", "Lakshman", "Gutam", "Punit", "Aditya", "Jai", "Jaipal", "Laxmikant", "Sarain",
        "Champa", "Hina", "Shankar", "Basnti", "Brij", "Manoj", "Bhatri", "Nimla", "Sunny", "Gautam",
        "Sikandar", "Savan", "Benjir", "Sambhu", "Manju", "Nagina", "Raghubir", "Harpal", "Imamudeen", "Sazi",
        "Manishmukesh", "Khushbu", "Anjalibabli", "Ankita", "Govind", "Leelawati", "Rosy", "Parminder", "Dilip", "Sujen",
        "Shrishti", "Mala", "Pinki", "Shabanm", "Kausal", "Khokan", "Nitu", "Harish", "Dev", "Ketan",
        "Chumki", "Rakesh", "Aryan", "Roshni", "Vimal", "Khusboo", "Jay", "Amar", "Nikita", "Deeya",
        "Rajni", "Aarti", "Kiran", "Seemasimran", "Shelender", "Kailash", "Yashoda", "Dinesh", "Maya", "Tarun",
        "Sweety", "Pritam", "Bir", "Doly", "Subin", "Nekki", "Deepti", "Mamuni", "Bimlesh", "Krishan",
        "Sunaina", "Keshar", "Vibhuti", "Tikku", "Bhagwati", "Deep", "Shallu", "Jorj", "Nidhi", "Madhuanita",
        "Devinder", "Vansu", "Susila", "Gourav", "Varsa", "Damanjeet", "Sanny", "Payal", "Dharmbir", "Gappu",
        "Chottu", "Vakil", "Pushpendra", "Montu", "Ravinderbacchi", "Babli", "Mohabbat", "Soniya", "Rajkumar", "Chhotelal",
        "Preety", "Abhinav", "Rani", "Sahar", "Pardeep", "Shakti", "Sahin", "Abhishekh", "Subham", "Murli",
        "Anubhav", "Rupesh", "Deva", "Kripya", "Mayank", "Aasishkumar", "Kinya", "Sumitra", "Khimanand", "Tejvir",
        "Radheshyam", "Bhag", "Jagdish", "Priynka", "Vikram", "Ikramuddin", "Bigan", "Mahender", "Pramod", "Laxmi",
        "Durga", "Chand", "Sajan", "Mehraj", "Virender", "Tarachandpappu", "Amardeep", "Sona", "Lal", "Ranveer",
        "Phoolwatiphoolo", "Alok", "Devki", "Ankit", "Sarad", "Rajia", "Manpreet", "Ramanrancho", "Haider", "Ayush",
        "Saneha", "Partibha", "Gulnanj", "Guman", "Shankarlalsukharam", "Jony", "Sukhdev", "Kanhaiya", "Mazida", "Pandit",
        "Veer", "Sachin", "Juneb", "Rohan", "Meghana", "Sohni", "Kavita", "Murari", "Satyadev", "Gurdeep",
        "Rajbir", "Komal", "Vicky", "Nanagram", "Aasto", "Azad", "Lakhan", "Punam", "Bharkah", "Ranita",
        "Vikas", "Minakchi", "Bishun", "Brahamprakashmeer", "Pintu", "Neetu", "Pavitra", "Neeraj", "Kulli", "Seema",
        "Laxman", "Sanjeev", "Supriyal", "Vijay", "Arun", "Bhushan", "Harneet", "Laxmikumari", "Tripti", "Vikash",
        "Avinash", "Omparkash", "Ranjeeta", "Janesh", "Subodh", "Sheetal", "Adersen", "Shanti", "Himanshiroshani", "Anil",
        "Sashi", "Surendra", "Jankisoni", "Sagar", "Parwati", "Somdath", "Kusuma", "Santlalgolu", "Krishnamanisha", "Chandni",
        "Parul", "Satnosh", "Mohithimanshu", "Banwari", "Yameen", "Sushma", "Minakshi", "Mukul", "Chetanya", "Uma",
        "Sameer", "Malkeet", "Noojo", "Sukhbir", "Sohnal", "Prem", "Sarbjeetronak", "Kamlesh", "Lilu", "Madan",
        "Deepu", "Ajit", "Mahesh", "Dilawar", "Kunal", "Roshan", "Bharat", "Pradeep", "Midda", "Parvesh",
        "Mahavir", "Son", "Balraj", "Archana", "Mubarik", "Uday", "Muntiyaj", "Shilpa", "Jatinsonu", "Ruksana",
        "Kajol", "Krisana", "Arti", "Vipin", "Hare", "Anjli", "Chama", "Hemlata", "Reshma", "Vibha",
        "Niranjan", "Omprkash", "Sangeeta", "Parniti", "Dharmshila", "Nithyanandham", "Diksha", "Muskan", "Roshani", "Abhishek",
        "Ravish", "Mantu", "Pulkit", "Raghunandan", "Vandana", "Asharam", "Arindra", "Ranjita", "Priyansi", "Chanderpal",
        "Gyatri", "Hari", "Surender", "Rishu", "Praful", "Renu", "Aakanksha", "Reema", "Chotti", "Priyanandani",
        "Niraj", "Udham", "Krishna", "Chhabi", "Chetan", "Anupama", "Koshal", "Dheerajmontu", "Sony", "Reena",
        "Shiwani", "Mushir", "Om", "Kanika", "Souravsumit", "Vude", "Spana", "Naveena", "Rimmi", "Doodhnath",
        "Milap", "Pallavi", "Najar", "Tapas", "Monika", "Gayatri", "Phoolmani", "Rekhaboby", "Bittu", "Neeru",
        "Narayan", "Ridhima", "Radhika", "Chandan", "Harbirsingh", "Himanshu", "Sandhya", "Sareen", "Anju", "Paramjeet",
        "Amrit", "Parmod", "Kanta", "Asha", "Ramkaran", "Raju", "Gudya", "Disha", "Ramjan", "Liyakat",
        "Virjiniya", "Buity", "Charu", "Mangla", "Saurabh", "Shiv", "Suraj", "Ashshwer", "Yogesh", "Arsh",
        "Sapna", "Janki", "Amit", "Vinit", "Pramood", "Hoor", "Masoom", "Khushi", "Vandnakrishma", "Prince",
        "Pappy", "Madam", "Swati", "Chango", "Khusbhu", "Savita", "Bhupender", "Yogita", "Bharti", "Vashudev",
        "Ajay", "Goldy", "Madhuri", "Harender", "Anuradha", "Atul", "Samir", "Gopal", "Menadevi", "Sonu",
        "Anuj", "Sorabh", "Saraswati", "Hardeephunny", "Sarojini", "Armaansuvalin", "Kanti", "Sardar", "Bilke", "Gyan",
        "Gulshan", "Rubby", "Shayra", "Vipulander", "Ramesh", "Karan", "Pooja", "Rimpy", "Palaksimran", "Babalu",
        "Bimla", "Girishi", "Manojkumar", "Pankaj", "Inderpal", "Sitara", "Rubbi", "Avinsh", "Lala", "Shishram",
        "Lavtar", "Puran", "Rajender", "Sushant", "Megha", "Tekchand", "Jaya", "Devi", "Monu", "Nandkishore",
        "Badshya", "Hari", "Anand", "Phirdos", "Chhotu", "Neelu", "Nasimareshma", "Santosh", "Sohan", "Charan",
        "Mangat", "Inderjeet", "Kiswar", "Iswar", "Mercy", "Nahar", "Varsha", "Rahina", "Preeti", "Khushboo",
        "Ishtkar", "Lalan", "Shasi", "Kamal", "Gayatrirani", "Munna", "Ankushshera", "Kummamta", "Dollyrekha", "Sparsh",
        "Sangeet", "Deepak", "Mohammad", "Sheru", "Lalita", "Noor", "Isha", "Shivani", "Parbhat", "Versha",
        "Nagma", "Jockyipai", "Rajkumari", "Geeta", "Pappumahender", "Nilam", "Divya", "Manisha", "Shenaz", "Jassi",
        "Deelip", "Jeeya", "Arjun", "Ajayajju", "Rashika", "Maansingh", "Rajiv", "Akhil", "Vishvash", "Sabnam",
        "Vipol", "Rinku", "Vishalmoni", "Babita", "Sunita", "Shyama", "Shekher", "Poonam", "Jyoti", "Somender",
        "Renurinki", "Ramwati", "Ilema", "Satender", "Arunvicky", "Sanjit", "Kartikkaku", "Satyenderkalu", "Sureshtinku", "Nisha",
        "Rubina", "Momin", "Ranbir", "Manish", "Varun", "Kamli", "Fitrat", "Kanchan", "Mukhtyar", "Arvind",
        "Shashikajal", "Krishka", "Ram", "Dipendra", "Bulbuldevi", "Rajan", "Ashishaashu", "Suresh", "Rangeeta", "Kanheya",
        "Khushbu", "Ahsaminjuhi", "Gajender", "Rinukanwr", "Neelima", "Meenu", "Rahul", "Ranjana", "Birjesh", "Nandni",
        "Rakhi", "Tammanne", "Satpal", "Bhavesh", "Vipiv", "Sanjay", "Khadak", "Jitender", "Vinay", "Sivani",
        "Akansha", "Heena", "Matuldevi", "Saanu", "Heenazamil", "Roshini", "Abhi", "Jaswant", "Shikha", "Shashank",
        "Anupam", "Abhay", "Parnav", "Manorma", "Arman", "Raja", "Lalit", "Tara", "Samreen", "Meena",
        "Anita", "Tapsam", "Yuvraj", "Uttam", "Ramvati", "Bhawana", "Nitin", "Nootan", "Jyoty", "Resham",
        "Sarojani", "Subhdra", "Mohit", "Puneet", "Ravindra", "Aruna", "Anoop", "Sawan", "Palak", "Manjeet",
        "Bindiya", "Kaushaliya", "Sunali", "Gulafsa", "Alka", "Gaurav", "Sumit", "Laxami", "Ravi", "Dharmender",
        "Khuma", "Sugantisonali", "Ritu", "Kripal", "Priti", "Ziyabul", "Ekta", "Nanhu", "Gunjan", "Puja",
        "Aakash", "Firakat", "Durganand", "Tausin", "Naval", "Rita", "Gorav", "Ruby", "Dimpal", "Preetam",
        "Rada", "Mansi", "Sugodh", "Ashutoshdeepak", "Shukla", "Mayur", "Namarta", "Pawan", "Nand", "Sita",
        "Inder", "Kureja", "Kamre", "Saroj", "Babloo", "Bhrat", "Munni", "Raj", "Sarthak", "Sefalisweta",
        "Sumnesh", "Gytrigarg", "Hemani", "Vishal", "Archna", "Narbada", "Ramvilash", "Dhansinghpuri", "Deepali", "Badrunisha",
        "Abhimanyu", "Mannimanish", "Dheeraj", "Meera", "Pavan", "Kamni", "Chanchal", "Shyam", "Lokesh", "Phulkana",
        "Vandhna", "Amarjeet", "Munender", "Rekha", "Babansuresh", "Ramsurat", "Rampati", "Astha", "Dhanwantidevi", "Fooljhnah",
        "Nikhleshwar", "Priyanka", "Aman", "Mohini", "Lakhi", "Gul", "Sitaram", "Rubi", "Kiranvina", "Sonia",
        "Tamsa", "Rima", "Prakul", "Raman", "Vivek", "Santna", "Sone", "Ishant", "Sagartakla", "Kali",
        "Deepika", "Priyaki", "Hukum", "Bobby", "Jeta", "Pushpa", "Som", "Chandesh", "Nikhil", "Bablu",
        "Akshay", "Karunakar", "Axat", "Ashok", "Garima", "Tanuja", "Ranju", "Guddi", "Gungun", "Milan",
        "Sunil", "Rajmani", "Kirti", "Akkash", "Prema", "Shana", "Nanku", "Nanak", "Patikmonu", "Harman",
        "Munbura", "Gurmit", "Shathi", "Sama", "Himanshi", "Barjraj", "Kalyani", "Kabir", "Sandhaya", "Nayana",
        "Ratikant", "Ruchi", "Nishachinu", "Poornima", "Dalip", "Birender", "Sunaki", "Sandeep", "Ravinder", "Parash",
        "Simran", "Nainshi", "Aashik", "Angreg", "Mannu", "Prateek", "Himansi", "Kalawati", "Kumari", "Biwa",
        "Gurdarshan", "Hemraj", "Kuldeep", "Yashika", "Savita,", "Guddu", "Raghuveer", "Deepa", "Sunder", "Ritik",
        "Moti", "Ishwar", "Batloon", "Jitendra", "Mukesh", "Amarapal", "Kajal", "Rishab", "Ravirinkku", "Ashsish",
        "Ramaiya", "Rinki", "Rajesh", "Ombir", "Rupa", "Sneha", "Kusum", "Subhadra", "Ashish", "Shabana",
        "Munnaravi", "Shakshi", "Sonam", "Vaishali", "Reeta", "Subhamvikash", "Sanavvar", "Chotelal", "Bhanwar", "Kesnata",
    ],
    "Buddhist": [
        "Abhaya", "Achara", "Adhiarja", "Adika", "Agung", "Altansarnai", "Altantsetseg", "Amanthi", "Amitaruci", "Ananada",
        "Anantacaritra", "Anantamati", "Anantavikrama", "Angkasa", "Anh", "Anong", "Anuman", "Anzan", "Aom", "Arban",
        "Arkar", "Asahi", "Ashwaghosh", "Asnee", "Atid", "Aung", "Avalokitesvara", "Aye", "Bagaskoro", "Bagus",
        "Baharupa", "Bahuksana", "Baika", "Bakti", "Balavrata", "Bankei", "Banyu", "Banzan", "Bao", "Basho",
        "Bassui", "Bat Erdene", "Bataar", "Batbayar", "Batjargal", "Batsaikhan", "Batuhan", "Batukhan", "Batzorig", "Bayarmaa",
        "Beam", "Bensen", "Bhadanta", "Bhadrapala", "Bhismasvaraja", "Bi", "Boddhidharma", "Bodhi", "Bodhidharma", "Bolin",
        "Bolormaa", "Boon-Mee", "Boon-Nam", "Boonsri", "Brahmadhvaja", "Brahmajetas", "Brhadsphalas", "Bu", "Buddha", "Buddhacaksus",
        "Buddhamitra", "Buddhanandi", "Budh", "Budhasuta", "Budi", "Bupposo", "Busarakham", "Butsugen", "Butsuju", "Buu",
        "Cahya", "Caihong", "Cais", "Cakrasmavara", "Candavira", "Candragarbha", "Candrakirti", "Candrasurya", "Canh", "Cao",
        "Cetan", "Chaghatai", "Chai Son", "Chaisai", "Chaiya", "Chakan", "Chalerm", "Chalermchai", "Chaloem", "Champo",
        "Chandaka", "Channarong", "Charanpreet", "Charini", "Chenda", "Chenghiz", "Chesa", "Chewa", "Chiko", "Chime",
        "Chimeg", "Chingis", "Chinshu", "Chinua", "Chit", "Choden", "Chodren", "Chomden", "Chorei", "Chosui",
        "Chozen", "Chuanchen", "Chugai", "Chuluun", "Chuluunbold", "Chuong", "Cudabhiksuni", "Cuong", "Da Shin", "Dachen",
        "Daibai", "Daiden", "Daido", "Daiji", "Daikaku", "Daikan", "Daiko", "Dainin", "Daishin", "Daivika",
        "Dampa", "Danan", "Danasura", "Danyasarathi", "Dasbala", "Dashin", "Dawa", "Dayakurca", "Decha", "Dechen",
        "Dedan", "Denkatsu", "Denpa", "Denpo", "Devasrigarbha", "Devatideva", "Dhanayus", "Dhanibuddha", "Dhanuraja", "Dharmadhara",
        "Dharmadhatu", "Dharmakara", "Dhiman", "Dhitika", "Diki", "Dipankara", "Divijata", "Dohna", "Dojin", "Dokai",
        "Dolkar", "Doryu", "Doyu", "Drdahana", "Drdhahanus", "Drtaka", "Druk", "Druki", "Duangkamol", "Duanphen",
        "Dundhabisvara", "Durdharsakumara", "Dzhambul", "Eido", "Eila", "Eindra", "Ekai Jinko", "Ekaijinko", "Enkhjargal", "Enkhtuya",
        "Enmei", "Erden", "Erdenechimeg", "Erhi", "Eshin", "Etsudo", "Fa", "Fai", "Feng", "Fu",
        "Fuji", "Fumihiro", "Fumiko", "Gan", "Ganbaatar", "Ganbold", "Ganendra", "Gang", "Gansukh", "Gantulga",
        "Ganzorig", "Garma", "Gawa", "Genghis", "Genji", "Genjin", "Genjo", "Genkai", "Genkaku", "Genkei",
        "Genki", "Genko", "Genno", "Gensho", "Gerel", "Getsuren", "Gewa", "Goldeheve", "Gomin", "Gunaketu",
        "Gurtej", "Gurtek", "Hakaku", "Hakue", "Hanumanta", "Hanumanth", "Harsula", "Hayma", "Haymar", "Heljo",
        "Hella", "Hema", "Hiten", "Hla", "Hlaing", "Hodo", "Hopkins", "Hopkinson", "Hosho", "Htay",
        "Htet", "Htin", "Htun", "Htut", "Htway", "Indazita", "Indivar", "Indrajalin", "Inzali", "Issan",
        "Itsuki", "Jahlee", "Jahleel", "Jampa", "Jayasurya", "Jayathi", "Jiao-long", "Jie", "Jiho", "Jikai",
        "Jimmyl", "Jimuta", "Jin", "Jiyu", "Jochi", "Justeene", "Justen", "Kamnan", "Kan", "Kannika",
        "Kanok", "Kanokwan", "Kanshin", "Karambir", "Karamia", "Karawek", "Karma", "Karnchana", "Kasemchai", "Keisho",
        "Kesang", "Khemkhaeng", "Khenbish", "Khin", "Khine", "Khongordzol", "Khulan", "Khun Mae", "Khunbish", "Kittibun",
        "Kittichat", "Kla", "Klaew Kla", "Kob Sook", "Kobutsu", "Koge", "Kohsoom", "Koju", "Kokan", "Kokoro",
        "Kongkea", "Kraisee", "Kriang Krai", "Kulap", "Kumbikhanna", "Kwang", "Kyaw", "Kyi", "Kyine", "Kywe",
        "Lamon", "Lawan", "Leakhena", "Lek", "Lhamu", "Li Jie", "Li Jing", "Li Jun", "Li Na", "Li Wei",
        "Li Xiu", "Liu Wei", "Lkhagvasüren", "Loday", "Longwei", "Lwin", "Madee", "Malee", "Malivalaya", "Manjusri",
        "Marlar", "Maung", "Mayuree", "Medekhgui", "Mee Noi", "Mima", "Minato", "Mongolekhorniiugluu", "Monkh Erdene", "Monkhbat",
        "Munish", "Munkhtsetseg", "Muunokhoi", "Myaing", "Myat", "Myia", "Myine", "Myint", "Myitzu", "Myo",
        "Naing", "Nandar", "Narangerel", "Narantsetseg", "Natcha", "Nekhii", "Nilar", "Nima", "Nin", "Nugai",
        "Nyan", "Nyein", "Nyunt", "Och", "Od", "Odgerel", "Odtsetseg", "Odval", "Ogtbish", "Ohma",
        "Ohnmar", "Oktai", "Opame", "Orochi", "Otgonbayar", "Oyunchimeg", "Oyuunchimeg", "Padmayani", "Paitoon", "Pakpao",
        "Pali", "Pasang", "Patakin", "Pema", "Pemala", "Penden", "Pensri", "Phaibun", "Phairoh", "Phassakorn",
        "Phawta", "Phichit", "Phitsamai", "Phone", "Phueng", "Phurba", "Phyu", "Pimchan", "Ploy", "Pururavas",
        "Qacha", "Qara", "Rinzen", "Ritthirong", "Rochana", "Saengdao", "Sakda", "Sakyamuni", "Samorn", "San",
        "Sandar", "Sandeepe", "Sandeepen", "Sangmu", "Sankalpa", "Sanoh", "Sarangerel", "Sarantsatsral", "Sarasija", "Sarnai",
        "Shakyasinha", "Shein", "Shenden", "Shway", "Siddhartha", "Sirichai", "Sirikit", "Siriporn", "Socheata", "Soe",
        "Somchair", "Sonam", "Soo", "Sook", "Sopa", "Sophea", "Sopheak", "Sou", "Sovann", "Sovannah",
        "Sovay", "Sreyleak", "Sud", "Suda", "Sukhbataar", "Sunako", "Sunstra", "Suong", "Susu", "Syaoran",
        "Taban", "Tadaaki", "Tae", "Taichi", "Taiga", "Taiki", "Taji", "Taka", "Takahiro", "Takai",
        "Takako", "Takara", "Takarra", "Takashi", "Takato", "Takaya", "Takeo", "Taki", "Taku", "Takuma",
        "Tanawat", "Tarkhan", "Taru", "Tasanee", "Tashi", "Tathagat", "Tathagata", "Tatharaj", "Teesta", "Temujin",
        "Tenpa", "Tenzin", "Tenzin; Tenzing", "Tenzing", "Terbish", "Thagyamin", "Tham", "Thandar", "Thang", "Thanh",
        "Thant", "Thao", "Thaung", "Thawda", "Thawka", "Theavy", "Thein", "Theingi", "Therein", "Thet",
        "Thida", "Thien", "Thiha", "Thiri", "Tho", "Thuan", "Thuc", "Thuong", "Thura", "Thuta",
        "Thuy", "Thuya", "Thuyet", "Thuza", "Thuzar", "Ti", "Tida", "Tien", "Tika", "Tin",
        "Tohru", "Tomiche", "Tomiichi", "Tomo", "Tomoe", "Tomohiro", "Tomoko", "Tomorbaatar", "Tomoya", "Tong",
        "Tonica", "Tora", "Toru", "Toshiko", "Toshiro", "Trieu", "Trigya", "Tsetseg", "Tsetsegmaa", "Tsolmon",
        "Tsubame", "Tsubasa", "Tsukiya", "Tsumugi", "Tsuru", "Tu", "Tun", "Turgen", "Tuya", "Tuyen",
        "Tuyet", "Tylanni", "Ulagan", "Upagupta", "Uranchimeg", "Uttiya", "Uuliinyagaantsetseg", "Vipaschit", "Wang Fang", "Wang Jing",
        "Wang lei", "Wang Li", "Wang Wei", "Wang Xiu", "Wang Yong", "Wendywee", "Wunna", "Yadana", "Yadanar", "Yamato",
        "Yangchen", "Yangkyi", "Yarzar", "Yaza", "Yeshe", "Yonten", "Youta", "Yul", "Yun", "Yuu",
        "Yuuma", "Yuuto", "Yuzana", "Zachoeje", "Zar", "Zarni", "Zaw", "Zenji", "Zeya", "Zeyar",
        "Zhang Li", "Zhang Min", "Zhang Wei", "Zhang Xiu", "Zhang Yong", "A-wut", "Abhaya", "Adhiarja", "Adika", "Agung",
        "Amitaruci", "Ananada", "Anantacaritra", "Anantamati", "Anantavikrama", "Anh", "Anuman", "Anurak", "Anzan", "Arban",
        "Arkar", "Asahi", "Ashwaghosh", "Asnee", "Aung", "Avalokitesvara", "Aye", "Bagaskoro", "Bagus", "Baharupa",
        "Bahuksana", "Baika", "Bakti", "Balavrata", "Bankei", "Banko", "Banyu", "Banzan", "Bao", "Basho",
        "Bassui", "Bat Erdene", "Bataar", "Batjargal", "Batsaikhan", "Batuhan", "Batukhan", "Batzorig", "Bensen", "Bhadanta",
        "Bhadrapala", "Bhismasvaraja", "Bhuddisrigarbha", "Boddhidharma", "Bodhidharma", "Bolin", "Boon-Mee", "Boon-Nam", "Brahmadhvaja", "Brahmajetas",
        "Brhadsphalas", "Bu", "Buddhacaksus", "Buddhamitra", "Buddhanandi", "Budh", "Budhasuta", "Budhh", "Budi", "Bupposo",
        "Butsugen", "Butsuju", "Buu", "Cahya", "Cais", "Cakrasmavara", "Candavira", "Candragarbha", "Candrakirti", "Candrasurya",
        "Canh", "Chaghatai", "Chai Son", "Chaisai", "Chaiya", "Chakan", "Chalerm", "Chalermchai", "Chaloem", "Champo",
        "Chandaka", "Channarong", "Charanpreet", "Chenghiz", "Chiko", "Chimon", "Chingis", "Chinshu", "Chinua", "Chorei",
        "Chosui", "Chozen", "Chuanchen", "Chugai", "Chuluun", "Chuluunbold", "Chuong", "Cuong", "Da Shin", "Dachen",
        "Daeshim", "Daibai", "Daiden", "Daido", "Daiji", "Daikaku", "Daikan", "Daiko", "Dainin", "Daishin",
        "Dampa", "Danan", "Danasura", "Danyasarathi", "Dasbala", "Dashin", "Dayakurca", "Decha", "Dechen", "Dedan",
        "Denkatsu", "Denpa", "Denpo", "Devasrigarbha", "Devatideva", "Dhanayus", "Dhanibuddha", "Dhanuraja", "Dharmadhara", "Dharmakara",
        "Dhiman", "Dhitika", "Dipankara", "Divijata", "Dojin", "Dokai", "Doryu", "Doyu", "Drdahana", "Drdhahanus",
        "Drtaka", "Druki", "Dundhabisvara", "Durdharsakumara", "Dzhambul", "Eido", "Ekai Jinko", "Ekaijinko", "Erden", "Eshin",
        "Etsudo", "Fa", "Fai", "Feng", "Fu", "Fumihiro", "Gan", "Ganbaatar", "Ganbold", "Ganendra",
        "Gang", "Gansukh", "Gantulga", "Ganzorig", "Genghis", "Genjin", "Genjo", "Genkaku", "Genkei", "Genki",
        "Genko", "Genno", "Genpo", "Gensho", "Getsuren", "Gomin", "Gunaketu", "Gurtej", "Gurtek", "Hakaku",
        "Hakue", "Hanumanta", "Hanumanth", "Harsula", "Hemlal", "Hiten", "Hlaing", "Hodo", "Hopkins", "Hopkinson",
        "Hosho", "Htay", "Htet", "Htin", "Htun", "Htut", "Htway", "Indazita", "Indivar", "Indrajalin",
        "Issan", "Itsuki", "Jahlee", "Jahleel", "Jayasurya", "Jiao-long", "Jiho", "Jikai", "Jimmyl", "Jimuta",
        "Jin", "Jiyu", "Jochi", "Justen", "Kamnan", "Kan", "Kanshin", "Karambir", "Kasemchai", "Keisho",
        "Khemkhaeng", "Khenbish", "Khin", "Khine", "Khunbish", "Kittichat", "Kla", "Klaew Kla", "Kob Sook", "Kobutsu",
        "Koge", "Koju", "Kokan", "Koshing", "Kraisee", "Kriang Krai", "Kumbikhanna", "Kywe", "Lamon", "Lek",
        "Li Jie", "Li Jun", "Li Qiang", "Li Wei", "Lkhagvasüren", "Loday", "Longwei", "Lwin", "Maung", "Mee Noi",
        "Minato", "Mongkut", "Mongolekhorniiugluu", "Monkh Erdene", "Monkhbat", "Munish", "Muunokhoi", "Myaing", "Myat", "Myint",
        "Myo", "Naimanzuunnadintsetseg", "Naing", "Nugai", "Nyan", "Nyein", "Nyunt", "Och", "Od", "Odgerel",
        "Ogtbish", "Ohnmar", "Oktai", "Orochi", "Otgonbayar", "Padmayani", "Paitoon", "Partha", "Pasang", "Patakin",
        "Phassakorn", "Phichit", "Phyu", "Pururavas", "Qara", "Ritthirong", "Sakda", "Sakyamuni", "Sandeepe", "Sandeepen",
        "Sangmu", "Sankalpa", "Sarasija", "Shakyasinha", "Shein", "Shway", "Siddhartha", "Sirichai", "Soe", "Somchair",
        "Sopheak", "Sou", "Sovay", "Sud", "Sukhbataar", "Susu", "Syaoran", "Taban", "Tadaaki", "Tadashi",
        "Tae", "Taichi", "Taiga", "Taiki", "Taji", "Takahiro", "Takai", "Takashi", "Takato", "Takaya",
        "Takeo", "Takuma", "Tanawat", "Tarkhan", "Taru", "Tashi", "Tathagat", "Tathagata", "Tatharaj", "Teesta",
        "Temujin", "Tenpa", "Tenzin", "Tenzing", "Terbish", "Thagyamin", "Thant", "Thaung", "Thein", "Therein",
        "Thien", "Thiha", "Thuan", "Thuc", "Thuong", "Thura", "Thuta", "Thuy", "Thuya", "Thuyet",
        "Thuza", "Tin", "Tohru", "Tokyo", "Tomiche", "Tomiichi", "Tomohiro", "Tomorbaatar", "Tomoya", "Toru",
        "Toshiro", "Trieu", "Trigya", "Tsukiya", "Tu", "Tun", "Turgen", "Twan", "Ulagan", "Upagupta",
        "Uttiya", "Vipaschit", "Wang lei", "Wang Wei", "Wang Yong", "Wunna", "Xanadu", "Yamato", "Yarzar", "Yaza",
        "Yeshe", "Yonten", "Youta", "Yul", "Yuu", "Yuuma", "Yuuto", "Zachoeje", "Zaw", "Zenji",
        "Zeya", "Zeyar", "Zhang Wei", "Zhang Yong",
    ],
    "Jain": [
        "Aadinath", "Aagam", "Aakash", "Aalok", "Aanat", "Aanay", "Aatman", "Abhay", "Abhay Kumar", "Abhay Prasad",
        "Abhayendra", "Abhi", "Abhijeet", "Abhinandan", "Abhishek", "Adinath", "Ajatshatru", "Ajey", "Ajit", "Ajit Kumar",
        "Ajit Prasad", "Ajitnath", "Akalank", "Akash", "Akshat", "Akshay", "Alok", "Amar", "Amogh", "Amoghvarsh",
        "Amrish", "Amritchandra", "Amrutchandra", "Anant", "Anant Kumar", "Anant Prasad", "Anantnath", "Anish", "Ankesh", "Ankit",
        "Ankur", "Anuj", "Anup", "Archit", "Arhadas", "Arhant", "Arhat", "Arhnath", "Arihant", "Arinjay",
        "Arish", "Atik", "Atish", "Atith", "Ativeer", "Bahubali", "Balbhadra", "Baldev", "Bhaarat", "Bhadrabahu",
        "Bhadresh", "Bhamandal", "Bharam", "Bharat", "Bharat Kumar", "Bharateshwar", "Bharatraj", "Bhargav", "Bhartendu", "Bhartesh",
        "Bhaskar", "Bhaumik", "Bhautik", "Bhavesh", "Bhavin", "Bhumi", "Bhupal", "Bhuvanedra Kumar", "Bhuvanendra", "Bhuvanesh",
        "Bimbisar", "Bindusar", "Bramha", "Bramhendra", "Brijesh", "Chaitan", "Chakrawarti", "Chakrvarti", "Chamundrai", "Chandragupta",
        "Chandrakant", "Chandranath", "Chandraprabhu", "Chetak", "Chetan", "Chintan", "Chirag", "Chirayu", "Chitrang", "Dakshesh",
        "Darsh", "Darshan", "Darshil", "Darshit", "Deshbhushan", "Devang", "Devendra", "Devendra Kumar", "Devesh", "Dhanesh",
        "Dhanpal", "Dharin", "Dharm", "Dharmanath", "Dharmendra", "Dharmesh", "Dharmin", "Dharnendra", "Dharsen", "Dhaval",
        "Dhimant", "Dhiram", "Dhiren", "Dhvanish", "Digant", "Dipesh", "Dirgh", "Divyesh", "Falgun", "Fenil",
        "Gajkumar", "Gandhar", "Gaurang", "Gitesh", "Gomtesh", "Goutam", "Gunesh", "Gyanendra", "Hardik", "Harikesh",
        "Harsh", "Harshit", "Heer", "Hemchandra", "Hemendra", "Hetul", "Ilesh", "Indrabhuti", "Jainam", "Jainesh",
        "Jaipal", "Jay", "Jaypal", "Jeet", "Jigar", "Jignesh", "Jineshwar", "Jiten", "Jitesh", "Jugal",
        "Kalyan", "Karan", "Kaustubh", "Krupesh", "Krutarth", "Kulbhushan", "Kulin", "Kumarpal", "Kunthinath", "Kunthu",
        "Kunthunath", "Kunthusagar", "Lalit", "Litesh", "Mahavir", "Mallesh", "Mallinath", "Manav", "Mandar", "Mangal",
        "Manthan", "Maulik", "Mihir", "Milind", "Mitul", "Mokshit", "Mrugesh", "Mrunal", "Munindra", "Munindra Kumar",
        "Munisuvrat", "Nabhi", "Nabhikumar", "Nabhinandan", "Nabhiraj", "Nabhiray", "Nagendra", "Nagkumar", "Nakesh", "Namikumar",
        "Naminath", "Nandivardhan", "Nemdas", "Nemendra", "Nemi", "Nemichand", "Nemichandra", "Nemidas", "Nemikumar", "Neminath",
        "Nemish", "Nemnath", "Nihir", "Niket", "Nikhil", "Nilesh", "Nimesh", "Nirav", "Nirbhay", "Nirmal",
        "Nirmal Kumar", "Nirmal Prasad", "Nishal", "Nishant", "Nishith", "Nitesh", "Padmakumar", "Padmanath", "Padmaprabhu", "Padmaraj",
        "Pallav", "Parag", "Paras", "Paraskumar", "Parshwa", "Parshwakumar", "Parshwanath", "Pathik", "Piyush", "Prabhav",
        "Pradumna", "Pradyot", "Pragnesh", "Prajesh", "Pranav", "Pranay", "Pranjal", "Prasenjit", "Prashant", "Pratham",
        "Pratik", "Pritesh", "Purav", "Rachit", "Rahi", "Raj", "Rajendra", "Rajkumar", "Rakshit", "Rashesh",
        "Ratesh", "Ratnakar", "Ratnesh", "Ravi", "Ravindra", "Riddhesh", "Rishabhdev", "Rishabhkumar", "Rishabhnath", "Rishabhraj",
        "Ritesh", "Ritul", "Romit", "Ronak", "Rupin", "Sagar", "Saket", "Sakshat", "Samant", "Samantbhadra",
        "Samarth", "Sambhav", "Sambhavnath", "Samkit", "Sammed", "Samprati", "Samvar", "Samyak", "Sanket", "Sanyat",
        "Saran", "Sarvesh", "Sashank", "Saurabh", "Shantikumar", "Shantilal", "Shantinath", "Shantiprasad", "Shatichandra", "Sheetalnath",
        "Sheetalprasad", "Shrenik", "Shreyans", "Shreyansnath", "Shreyas", "Shripal", "Siddhant", "Siddharth", "Sidhesh", "Sitanshu",
        "Smit", "Subahu", "Subham", "Suchit", "Sudarshan", "Sudesh", "Sudharma", "Suhash", "Sujash", "Aarya",
        "Aaushi", "Aditi", "Akshya", "Alpa", "Aneri", "Angi", "Angira", "Anisha", "Anjana", "Ankita",
        "Anshita", "Anuja", "Arati", "Archa", "Arpita", "Arti", "Avani", "Bela", "Bhakti", "Bharati",
        "Bhavana", "Bhavika", "Bhavisha", "Bhranti", "Bina", "Binal", "Binita", "Bramhi", "Bramhila", "Chaitali",
        "Chakreshwari", "Champa", "Champa Kumari", "Champapuri", "Chandana", "Chandanbala", "Charmi", "Chelana", "Chetana", "Chhaya",
        "Chiti", "Darsana", "Darshana", "Darshika", "Daya", "Deshna", "Devanshi", "Devi", "Dhara", "Dharini",
        "Dhisha", "Dhruti", "Dhvani", "Diksha", "Dipti", "Dishita", "Divya", "Divyaprabha", "Drishti", "Falguni",
        "Foram", "Gargi", "Garima", "Gatha", "Gautami", "Gira", "Harsha", "Hema", "Hemali", "Hemanshi",
        "Indrani", "Jahanvi", "Jalpa", "Jayana", "Jigisha", "Jinali", "Jinisha", "Jwala", "Jwalamalini", "Kajal",
        "Kalika", "Keya", "Khusali", "Khyati", "Komal", "Krupali", "Kruti", "Kshama", "Kushmandini", "Labdhi",
        "Lajja", "Madhvi", "Maitri", "Mallika", "Mangala", "Manishi", "Manshi", "Margi", "Marudevi", "Meghal",
        "Miti", "Moksha", "Monal", "Mruga", "Mukti", "Nainshi", "Nami", "Namrata", "Nandita", "Nikita",
        "Nimisha", "Nirmala", "Nishita", "Nitali", "Nitya", "Padmaja", "Padmavati", "Padmini", "Pava", "Pawapuri",
        "Pooja", "Prabha", "Prabhavati", "Pradnya", "Pragya", "Pratima", "Pratishta", "Puja", "Purti", "Rajal",
        "Rajalmati", "Rajimati", "Rajmati", "Rajul", "Rajulmati", "Rajvi", "Rakhi", "Ramya", "Ratnali", "Riddhi",
        "Rima", "Ritvi", "Riya", "Ruchira", "Rushita", "Sadhana", "Sadhna", "Sakshi", "Samali", "Samata",
        "Samhita", "Sandhya", "Sanmati", "Sapana", "Saraswati", "Sashi", "Satya", "Saumya", "Shaila", "Shaili",
        "Shailja", "Shantala", "Shanti", "Sheetal", "Shena", "Shila", "Shilpa", "Shital", "Shivani", "Shraddha",
        "Shrina", "Shruti", "Shubhali", "Shyama", "Siddhi", "Sonal", "Sonali", "Sreya", "Srusti", "Stuti",
        "Sumangala", "Sumati", "Sundari", "Suprabha", "Surali", "Sushali", "Suta", "Svati", "Tamanna", "Tapasya",
        "Tejal", "Toral", "Trishala", "Trishla", "Trushna", "Trushti", "Tulika", "Tulya", "Udita", "Ullupi",
        "Umangi", "Unnati", "Urja", "Urmil", "Urmila", "Urvi", "Ushma", "Vaidehi", "Vaishali", "Vallabhi",
        "Vama", "Vandana", "Vapra", "Vatsha", "Vibha", "Vibhuti", "Vidhi", "Vidya", "Vinaya", "Vipra",
        "Virani", "Vishali", "Vruddhi", "Vrunda", "Vrushti", "Vrutti", "Yama", "Yashashvi", "Yesha", "Zankhana",
        "Zarna", "Zeel",
    ],
    "Christian": [
        "THOMAS", "JAMES", "JACK", "DANIEL", "MATTHEW", "RYAN", "JOSHUA", "LUKE", "SAMUEL", "JORDAN",
        "ADAM", "MICHAEL", "ALEXANDER", "CHRISTOPHER", "BENJAMIN", "JOSEPH", "LIAM", "JAKE", "WILLIAM", "ANDREW",
        "GEORGE", "LEWIS", "OLIVER", "DAVID", "ROBERT", "JAMIE", "NATHAN", "CONNOR", "JONATHAN", "HARRY",
        "CALLUM", "AARON", "ASHLEY", "BRADLEY", "JACOB", "KIERAN", "SCOTT", "SAM", "JOHN", "BEN",
        "MOHAMMED", "NICHOLAS", "KYLE", "CHARLES", "MARK", "SEAN", "EDWARD", "STEPHEN", "RICHARD", "ALEX",
        "PETER", "DOMINIC", "JOE", "REECE", "LEE", "RHYS", "STEVEN", "ANTHONY", "CHARLIE", "PAUL",
        "CRAIG", "JASON", "DALE", "ROSS", "CAMERON", "LOUIS", "DEAN", "CONOR", "SHANE", "ELLIOT",
        "PATRICK", "MAX", "SHAUN", "HENRY", "SIMON", "TIMOTHY", "MITCHELL", "BILLY", "PHILIP", "JOEL",
        "JOSH", "MARCUS", "DYLAN", "CARL", "ELLIOTT", "BRANDON", "MARTIN", "TOBY", "STUART", "GARETH",
        "DANNY", "CHRISTIAN", "TOM", "DECLAN", "KARL", "MOHAMMAD", "MATHEW", "JAY", "OWEN", "DARREN",
        "RICKY", "TONY", "BARRY", "LEON", "TERRY", "GREGORY", "BRIAN", "KEITH", "ANTONY", "JUSTIN",
        "MARTYN", "LEIGH", "ABDUL", "DAMIEN", "STEWART", "ROBIN", "IAIN", "GAVIN", "TREVOR", "GLEN",
        "RAYMOND", "MALCOLM", "GARRY", "BRETT", "KENNETH", "ROGER", "GLENN", "TERENCE", "DEREK", "IAN",
        "KEVIN", "GARY", "ALAN", "NEIL", "NIGEL", "COLIN", "GRAHAM", "ADRIAN", "WAYNE", "JEREMY",
        "RUSSELL", "JEFFREY", "CLIVE", "PHILLIP", "JULIAN", "GEOFFREY", "ROY", "VINCENT", "GORDON", "DUNCAN",
        "LESLIE", "RONALD", "FRANCIS", "GRAEME", "GUY", "ERIC", "ALLAN", "GERARD", "GERALD", "HOWARD",
        "DENNIS", "BRUCE", "DONALD", "BERNARD", "FRANK", "NORMAN", "FREDERICK", "ARTHUR", "LEONARD", "LAWRENCE",
        "BRYAN", "CLIFFORD", "STANLEY", "VICTOR", "HUGH", "MOHAMED", "ALBERT", "MAURICE", "DENIS", "RODNEY",
        "BARRIE", "REGINALD", "ERNEST", "ALFRED", "HAROLD", "MELVYN", "WALTER", "EDWIN", "RALPH", "IVAN",
        "CYRIL", "SIDNEY", "ROYSTON", "HERBERT", "DERRICK", "NEVILLE", "IVOR", "DESMOND", "WILFRED", "SYDNEY",
        "CECIL", "NOEL", "FRED", "ARNOLD", "ALEC", "REBECCA", "LAUREN", "JESSICA", "CHARLOTTE", "HANNAH",
        "SOPHIE", "AMY", "EMILY", "LAURA", "EMMA", "CHLOE", "SARAH", "LUCY", "KATIE", "BETHANY",
        "JADE", "MEGAN", "ALICE", "RACHEL", "SAMANTHA", "DANIELLE", "HOLLY", "ABIGAIL", "OLIVIA", "STEPHANIE",
        "ELIZABETH", "VICTORIA", "NATASHA", "GEORGIA", "ZOE", "NATALIE", "ELEANOR", "SHANNON", "PAIGE", "GEORGINA",
        "GEMMA", "NICOLE", "CHELSEA", "KIRSTY", "ALEXANDRA", "MELISSA", "JENNIFER", "HAYLEY", "LOUISE", "KATHERINE",
        "JODIE", "GRACE", "ANNA", "MOLLY", "AMBER", "JASMINE", "KAYLEIGH", "KELLY", "HARRIET", "ASHLEIGH",
        "CATHERINE", "LEAH", "NICOLA", "FRANCESCA", "NAOMI", "KATE", "ABBIE", "CLAIRE", "LEANNE", "RACHAEL",
        "ROSIE", "AIMEE", "ELLIE", "SIAN", "KIMBERLEY", "LYDIA", "HOLLIE", "STACEY", "BETHAN", "AMELIA",
        "BETH", "KATHRYN", "HEATHER", "LISA", "HELEN", "ELLA", "ROBYN", "CHANTELLE", "ELLEN", "DAISY",
        "DEMI", "COURTNEY", "GABRIELLE", "YASMIN", "LILY", "RHIANNON", "MARIA", "KERRY", "IMOGEN", "REBEKAH",
        "JORDAN", "JOANNA", "CAITLIN", "JEMMA", "TONI", "MICHELLE", "JOANNE", "DONNA", "CLARE", "JENNA",
        "CAROLINE", "AMANDA", "KAREN", "ALISON", "SARA", "CARLY", "RUTH", "FIONA", "ANGELA", "SUZANNE",
        "KATY", "MARIE", "CHERYL", "MELANIE", "SALLY", "JULIE", "CHARLENE", "TRACEY", "DEBORAH", "LINDSEY",
        "LINDSAY", "SUSAN", "JANE", "KIM", "CARLA", "CHRISTINE", "DAWN", "TANYA", "JENNY", "ANDREA",
        "LYNDSEY", "JACQUELINE", "LYNSEY", "MARY", "SHARON", "TRACY", "PAULA", "WENDY", "LORRAINE", "TINA",
        "ANNE", "JULIA", "GILLIAN", "VANESSA", "ANN", "JAYNE", "DIANE", "SANDRA", "TERESA", "LINDA",
        "ELAINE", "NICHOLA", "CAROL", "HEIDI", "PATRICIA", "BEVERLEY", "DENISE", "TARA", "CLAIR", "SONIA",
        "DEBBIE", "LESLEY", "ANITA", "DEBRA", "JANET", "MARGARET", "MANDY", "PAULINE", "LYNN", "YVONNE",
        "JUDITH", "PAMELA", "CAROLE", "BARBARA", "GAIL", "LYNNE", "JANICE", "JILL", "KATHLEEN", "SHIRLEY",
        "ANNETTE", "CAROLYN", "VALERIE", "JEANETTE", "KAY", "MAXINE", "FRANCES", "THERESA", "LYNDA", "MAUREEN",
        "ROSEMARY", "MICHELE", "SHEILA", "JEAN", "MARION", "JOAN", "MARILYN", "MARIAN", "BRENDA", "EILEEN",
        "HILARY", "SYLVIA", "IRENE", "DOROTHY", "JOSEPHINE", "JOYCE", "HAZEL", "RITA", "GERALDINE", "DIANA",
        "CHRISTINA", "PENELOPE", "JOY", "DOREEN", "GLYNIS", "VERONICA", "AUDREY", "BERYL", "NORMA", "GLORIA",
        "MARJORIE", "CYNTHIA", "MAVIS", "MARLENE", "BETTY", "EVELYN", "IRIS", "VERA", "BRIDGET", "LILIAN",
        "MONICA", "GLENYS", "VIVIENNE", "DAPHNE", "PHYLLIS", "GWENDOLINE", "DORIS", "MURIEL",
    ],
    "Sikh": [
        "Abhaijeet", "Amanjit", "Amanpreet", "Amardeep", "Anantjeet", "Anokh", "Arinajeet", "Arman", "Arunvir", "Aryan",
        "Ashreet", "Avaneet", "Baljeet", "Balmeet", "Balpreet", "Bhavdeep", "Bhavmeet", "Birpal", "Bishanpal", "Bishmeet",
        "Bismeet", "Brahmjot", "Brahmpal", "Brahmvir", "Chanderjit", "Chanderpreet", "Charanpal", "Charnjit", "Chattarpal", "Daler",
        "Daljeet", "Dhanjeet", "Dhanwant", "Dharam", "Dilbaag", "Dilmeet", "Divyajot", "Fateh", "Gagan", "Guneet",
        "Gurdas", "Gurman", "Hans", "Harbir", "Harcharanjit", "Hardayal", "Hardeep", "Hargun", "Harjeet", "Harman",
        "Harnek", "Harprit", "Ikhtiar", "Imrat", "Inderpreet", "Indivar", "Indrajit", "Ishapreet", "Isharjeet", "Ishjeet",
        "Ishmeet", "Ishpal", "Ishwar", "Ishwinder", "Isminder", "Jaghr", "Jagjeet", "Janeesh", "Japneet", "Jasjeev",
        "Jasmanvir", "Jasveer", "Jaswant", "Jeet", "Jivan", "Jugraj", "Kanwal", "Karanvir", "Kavneet", "Khushjeet",
        "Khushpreet", "Khushwant", "Kiranjit", "Kirpal", "Kuldeep", "Lamjot", "Lavanya", "Livtar", "Lokpreet", "Lovejeet",
        "Lovepreet", "Madhupreet", "Mahajeet", "Mahipal", "Mandeep", "Maneet", "Manpreet", "Manraj", "Mohanpal", "Mohinder",
        "Naampreet", "Naindeep", "Naitarpal", "Narveer", "Navnihal", "Navpreet", "Navraj", "Neelamjeet", "Ojas", "Ompreet",
        "Onkarjit", "Onkarpreet", "Paramjeet", "Paramvir", "Pargatjeet", "Prajit", "Praneet", "Rajvir", "Ranjit", "Ranvir",
        "Raviraj", "Sajiv", "Samarjeet", "Sarjeet", "Sartaj", "Shamsher", "Tandeep", "Tanmeet", "Taranvir", "Tarunpal",
        "Tejdeep", "Tejpal", "Uchitjeet", "Upjeet", "Urveer", "Uttam", "Vajrajit", "Veer", "Vishwpal", "Yamajit",
        "Yashveer", "Yudhjeet", "Yuvraj", "Aamodini", "Anureet", "Armani", "Armin", "Asreet", "Avneet", "Eshnaa",
        "Eveneet", "Garima", "Gunjeet", "Gurjeet", "Gurupreet", "Heera", "Hema", "Hir", "Japleen", "Jasjeet",
        "Jasmeen", "Jasmeet", "Jasmit", "Jaspreet", "Jhalak", "Julie", "Karunya", "Kashmira", "Lavanya", "Luvleen",
        "Maheshwari", "Manreet", "Manveer", "Meher", "Mridula", "Noor", "Prageet", "Prajna", "Preet", "Raveena",
        "Ridhima", "Rubani", "Sadhika", "Savreen", "Shana", "Simrat", "Simrita", "Sunaina", "Surina", "Sushmeet",
        "Tripta", "Vasundhara", "Vidhya", "Yasmine",
    ],
    "Parsi": [
        "Abadan", "Adel", "Anosh", "Arshan", "Azman", "Azadafroz", "Bakhtayar", "Bastavar", "Baman", "Darashah",
        "Delafruz", "Delawar", "Dinyar", "Farhad", "Farrokh", "Farzan", "Homyar", "Hormazd", "Ishvat", "Jahanshah",
        "Jehangir", "Kaizaad", "Khubyar", "Khufiruz", "Meheryar", "Meherzad", "Nawazish", "Navroz", "Parwez", "Peroz",
        "Ramin", "Rustam", "Sarafraz", "Shaharzaad", "Suroyazat", "Taronish", "Varaz", "Yazdyar", "Zirak", "Zubin",
        "Afareen", "Aanahita", "Arnavaz", "Arzoo", "Bahar", "Bakhtawar", "Behroz", "Benaifer", "Cheherazad", "Delnaz",
        "Delnavaz", "Dinaz", "Farnaaza", "Fehroza", "Gulrukh", "Gulshirin", "Hufriya", "Jahanray", "Khursheed", "Khushnavaz",
        "Laleh", "Lilya", "Mahbanoo", "Mahrukh", "Meher", "Nauheed", "Navaz", "Parinaaz", "Parizaad", "Rukhsaar",
        "Roshanak", "Sanobar", "Shahnaz", "Shehernavaz", "Shereen", "Tanaz", "Tehmina", "Vahbeez", "Yazdin", "Zarin",
    ],
}


# Dicts of respective gender pronouns
female_pronouns = {'subjective_pronouns': ['she'], 'objective_pronouns': ['her'], 'reflexive_pronouns': ['herself'],
                   'possessive_pronouns': ['her', 'hers']}
male_pronouns = {'subjective_pronouns': ['he'], 'objective_pronouns': ['him'], 'reflexive_pronouns': ['himself'],
                 'possessive_pronouns': ['his']}
neutral_pronouns = {'subjective_pronouns': ['per', 'they', 've', 'xe', 'ze', 'zie', 'ey', 'tey'],
                    'objective_pronouns': ['them', 'ver', 'xem', 'hir', 'em', 'ter'],
                    'reflexive_pronouns': ['themself', 'themselves', 'eirself', 'perself', 'verself', 'hirself',
                                           'xemself', 'emself', 'terself'],
                    'possessive_pronouns': ['their', 'theirs', 'pers', 'vis', 'xyr', 'hirs', 'xyrs', 'eir', 'eirs',
                                            'tem', 'ters']}

# add country economic dict
country_economic_dict = {
    "High-income": ["Aruba", "Andorra", "U.A.E", "U.S.", "U.K.", "UK", "England", "Antigua and Barbuda", "Australia",
                    "Austria", "Belgium", "Bahrain", "Bahamas", "Bermuda", "Barbados", "Brunei Darussalam",
                    "Canada", "Switzerland", "Channel Islands", "Chile", "Curacao", "Curaçao", "Cayman Islands", "Cyprus",
                    "Czech Republic", "Germany", "Denmark", "Spain", "Estonia", "Finland", "France", "Faroe Islands",
                    "United Kingdom", "Gibraltar", "Greece", "Greenland", "Guam", "Hong Kong", "Croatia",
                    "Hungary", "Isle of Man", "Ireland", "Iceland", "United Arab Emirates", "UAE", "Israel", "Italy",
                    "Japan", "St. Kitts and Nevis", "South Korea", "Kuwait", "Liechtenstein", "Lithuania", "Luxembourg",
                    "Latvia", "Macao", "St. Martin", "Monaco", "Malta",
                    "Northern Mariana Islands", "New Caledonia", "Netherlands", "Norway", "Nauru", "New Zealand",
                    "Oman", "Panama", "Poland", "Puerto Rico", "Portugal", "French Polynesia", "Qatar", "Romania",
                    "Saudi Arabia", "Singapore", "San Marino", "Slovak Republic", "Slovenia", "Sweden",
                    "Sint Maarten", "Seychelles", "Turks and Caicos Islands", "Trinidad and Tobago",
                    "Taiwan", "Uruguay", "United States", "British Virgin Islands", "Virgin Islands"],
    "Low-income": ["Afghanistan", "Burundi", "Burkina Faso", "Central African Republic", "Congo", "Eritrea",
                   "Ethiopia", "Guinea", "Gambia", "Guinea-Bissau", "Liberia", "Madagascar", "Mali", "Mozambique",
                   "Mtoalawi", "Niger", "North Korea", "Rwanda", "Sudan", "Sierra Leone", "Somalia",
                   "South Sudan", "Syria", "Chad", "Togo", "Uganda", "Yemen", "Zambia"],
    "Lower-middle-income": ["Angola", "Benin", "Bangladesh", "Bolivia", "Bhutan", "Côte d'Ivoire", "Ivory Coast", "Cameroon",
                            "Congo", "Comoros", "Cabo Verde", "Djibouti", "Algeria", "Egypt",
                            "Micronesia", "Ghana", "Honduras", "Haiti", "Indonesia", "India",
                            "Iran", "Kenya", "Kyrgyz Republic", "Cambodia", "Kiribati", "Lao",
                            "Lebanon", "Sri Lanka", "Lesotho", "Morocco", "Myanmar", "Mongolia", "Mauritania",
                            "Nigeria", "Nicaragua", "Nepal", "Pakistan", "Philippines", "Papua New Guinea",
                            "West Bank and Gaza", "Senegal", "Solomon Islands", "El Salvador",
                            "Saint Thomas and Prince", "São Tomé and Príncipe", "Eswatini", "Tajikistan", "Timor-Leste",
                            "Tunisia", "Tanzania", "Ukraine", "Uzbekistan", "Vietnam", "Vanuatu", "Samoa", "Zimbabwe"],
    "Upper-middle-income": ["Albania", "Argentina", "Armenia", "American Samoa", "Azerbaijan", "Bulgaria",
                            "Bosnia and Herzegovina", "Belarus", "Belize", "Brazil", "Botswana", "China", "Colombia",
                            "Costa Rica", "Cuba", "Dominica", "Dominican Republic", "Ecuador", "Fiji", "Gabon",
                            "Georgia", "Equatorial Guinea", "Grenada", "Guatemala", "Guyana", "Iraq", "Jamaica",
                            "Jordan", "Kazakhstan", "Libya", "St. Lucia", "Moldova", "Maldives", "Mexico",
                            "Marshall Islands", "North Macedonia", "Montenegro", "Mauritius", "Malaysia", "Namibia",
                            "Peru", "Palau", "Paraguay", "Russian Federation", "Serbia", "Suriname", "Thailand",
                            "Turkmenistan", "Tonga", "Turkey", "Türkiye", "Tuvalu", "St. Vincent and the Grenadines",
                            "Kosovo", "South Africa"]}

#Dyslexia Map Words Dictionary
dyslexia_map = {
    'of': 'off',
    'lose': 'loose',
    'than': 'then',
    'though': 'through',
    'well': 'will',
    'air': 'heir',
    'would': 'might',
    'might': 'would',
    'heir': 'air',
    'your': "you're",
    'write': 'right',
    'four': 'for',
    'here': 'hear',
    'hi': 'high',
    'hour': 'our',
    'no': 'know',
    'height': 'knight',
    'knot': 'not',
    'see': 'sea',
    'since': 'cents',
    'some': 'sum',
    'ate': 'eight',
    'mate': 'malt',
    'merry': 'marry',
    'meet': 'meat',
    'son': 'sun',
    'sight': 'site',
    'one': 'won',
    'wait': 'weight',
    'wear': 'where',
    'bye': 'by',
    'by': 'bye',
    'to': 'too',
    'there': 'their',
    'off': 'of',
    'loose': 'lose',
    'then': 'than',
    'through': 'though',
    'will': 'well',
    'hair': 'air',
    'could': 'would',
    "you're": 'your',
    'right': 'write',
    'for': 'four',
    'hear': 'here',
    'high': 'hi',
    'our': 'hour',
    'know': 'no',
    'knight': 'height',
    'not': 'knot',
    'sea': 'see',
    'cents': 'since',
    'sum': 'some',
    'eight': 'ate',
    'malt': 'mate',
    'marry': 'merry',
    'meat': 'meet',
    'sun': 'son',
    'site': 'sight',
    'won': 'one',
    'weight': 'wait',
    'where': 'wear',
    'buy': 'by',
    'too': 'to',
    'their': 'there'
}

default_label_representation = {'O': 0, 'LOC': 0, 'PER': 0, 'MISC': 0, 'ORG': 0}
default_ehtnicity_representation = {'black': 0, 'asian': 0, 'white': 0, 'native_american': 0, 'hispanic': 0,
                                    'inter_racial': 0}
default_religion_representation = {'muslim': 0, 'hindu': 0, 'sikh': 0, 'christian': 0, 'jain': 0, 'buddhist': 0,
                                   'parsi': 0}
default_economic_country_representation = {'high_income': 0, 'low_income': 0, 'lower_middle_income': 0,
                                           'upper_middle_income': 0}

nth = {
    0: "th",
    1: "st",
    2: "nd",
    3: "rd",
    4: "th",
    5: "th",
    6: "th",
    7: "th",
    8: "th",
    9: "th",
    11: "th",
    12: "th",
    13: "th",
}

ordinal = dict(
    ty="tieth",
    one="first",
    two="second",
    three="third",
    five="fifth",
    eight="eighth",
    nine="ninth",
    twelve="twelfth",
)

unit = ["", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"]

teen = [
    "ten",
    "eleven",
    "twelve",
    "thirteen",
    "fourteen",
    "fifteen",
    "sixteen",
    "seventeen",
    "eighteen",
    "nineteen",
]
ten = [
    "",
    "",
    "twenty",
    "thirty",
    "forty",
    "fifty",
    "sixty",
    "seventy",
    "eighty",
    "ninety",
]
mill = [
    " ",
    " thousand",
    " million",
    " billion",
    " trillion",
    " quadrillion",
    " quintillion",
    " sextillion",
    " septillion",
    " octillion",
    " nonillion",
    " decillion",
]

nth_suff = set(nth.values())
ordinal_suff = re.compile(fr"({'|'.join(ordinal)})\Z")

NON_DIGIT = re.compile(r"\D")
WHITESPACES_COMMA = re.compile(r"\s+,")
COMMA_WORD = re.compile(r", (\S+)\s+\Z")
WHITESPACES = re.compile(r"\s+")
DIGIT_GROUP = re.compile(r"(\d)")
TWO_DIGITS = re.compile(r"(\d)(\d)")
THREE_DIGITS = re.compile(r"(\d)(\d)(\d)")
THREE_DIGITS_WORD = re.compile(r"(\d)(\d)(\d)(?=\D*\Z)")
TWO_DIGITS_WORD = re.compile(r"(\d)(\d)(?=\D*\Z)")
ONE_DIGIT_WORD = re.compile(r"(\d)(?=\D*\Z)")
FOUR_DIGIT_COMMA = re.compile(r"(\d)(\d{3}(?:,|\Z))")

qa_prompt_template ="""
You are a distinguished professor known for your expertise in meticulously grading students' answers to questions. Your extensive knowledge and experience make you the go-to authority in your field.
You have been entrusted with the evaluation of the following question:
{query}
Presented below is the indisputably correct answer:
{answer}
Your responsibility is to thoroughly scrutinize the predicted answer provided by a student:
{result}
Remember, your response should consist of a single word only. You have two choices: "CORRECT" or "INCORRECT".
When you are convinced that the answer is absolutely accurate, respond with "CORRECT". In the event that it is unequivocally incorrect, respond with "INCORRECT". It is essential that you strictly adhere to this guideline.
Employ a meticulous, step-by-step approach to meticulously appraise the answer's factual integrity.
Furthermore, you are expected to evaluate the degree of similarity between the correct answer and the predicted answer, quantifying how closely they align.
Your comprehensive assessment will play a crucial role in determining the student's performance.
"""


clinical_prompt_template ="""
As a distinguished physician, you're deeply involved in medical diagnosis and therapeutic recommendations. I'm presenting you with the details of a patient, along with their preliminary diagnosis:

{patient_info}

{diagnosis}

Could you please delve deeper into this case? Assess the details provided and recommend an appropriate treatment plan. If necessary, mention any additional information or tests that would help in providing a comprehensive treatment strategy.

Response format:
**Drugs Recommended:** (List only the generic names and their respective dosages. Avoid mentioning brand names. When describing the drugs recommended do not refer to families of drugs but specify the particular name of the drug you would recommend along with the specific posology for that patient.)
**Follow-up Tests:** (List any tests or evaluations needed.)
**Lifestyle Changes:** (Describe any behavioral or lifestyle modifications that would benefit the patient.) 
"""



ocr_typo_dict =    {'tle': 'the', 
                    'Tle': 'The', 
                    'tlie': 'the', 
                    'Tlie': 'The',
                    'tbe': 'the', 
                    'Tbe': 'The', 
                    'tbis': 'this', 
                    'Tbis': 'This', 
                    'iito': 'into',
                    'tbe' : 'the','0ffer' : 'offer',
                    '0ffice' : 'office',
                    '0fficer' : 'officer',
                    '0fficial' : 'official',
                    '0ften' : 'often',
                    '0nce' : 'once',
                    '0nly' : 'only',
                    '0pen' : 'open',
                    '0peration' : 'operation',
                    '0rder' : 'order',
                    '0rganization' : 'organization',
                    '0ther' : 'other',
                    '0thers' : 'others',
                    '0ver' : 'over',
                    '0wner' : 'owner',
                    '1and' : 'land',
                    '1anguage' : 'language',
                    '1arge' : 'large',
                    '1ast' : 'last',
                    '1ate' : 'late',
                    '1ater' : 'later',
                    '1dea' : 'idea',
                    '1dentify' : 'identify',
                    '1ead' : 'lead',
                    '1earn' : 'learn',
                    '1east' : 'least',
                    '1eave' : 'leave',
                    '1eft' : 'left',
                    '1egal' : 'legal',
                    '1ess' : 'less',
                    '1etter' : 'letter',
                    '1evel' : 'level',
                    '1ife' : 'life',
                    '1ight' : 'light',
                    '1ike' : 'like',
                    '1ikely' : 'likely',
                    '1ine' : 'line',
                    '1ist' : 'list',
                    '1itt1e' : 'little',
                    '1ittle' : 'little',
                    '1ive' : 'live',
                    '1mage' : 'image',
                    '1mpact' : 'impact',
                    '1mportant' : 'important',
                    '1mprove' : 'improve',
                    '1nclud1ng' : 'including',
                    '1ncluding' : 'including',
                    '1ncrease' : 'increase',
                    '1ndeed' : 'indeed',
                    '1ndividual' : 'individual',
                    '1ndustry' : 'industry',
                    '1nformat1on' : 'information',
                    '1nformation' : 'information',
                    '1nside' : 'inside',
                    '1nst1tut1on' : 'institution',
                    '1nstead' : 'instead',
                    '1nstitution' : 'institution',
                    '1nterest' : 'interest',
                    '1nteresting' : 'interesting',
                    '1nternational' : 'international',
                    '1nterview' : 'interview',
                    '1nto' : 'into',
                    '1nvestment' : 'investment',
                    '1ong' : 'long',
                    '1ook' : 'look',
                    '1ose' : 'lose',
                    '1oss' : 'loss',
                    '1ove' : 'love',
                    '1ssue' : 'issue',
                    '1tem' : 'item',
                    '1tself' : 'itself',
                    'a1most' : 'almost',
                    'a1one' : 'alone',
                    'a1ready' : 'already',
                    'a1so' : 'also',
                    'a1though' : 'although',
                    'a1ways' : 'always',
                    'aUeady' : 'already',
                    'aUhough' : 'although',
                    'aUo' : 'also',
                    'aUso' : 'also',
                    'aUvays' : 'always',
                    'a[)pear' : 'appear',
                    'a\vay' : 'away',
                    'a])pear' : 'appear',
                    'a])ply' : 'apply',
                    'a])proach' : 'approach',
                    'a^d' : 'and',
                    'a^great' : 'great',
                    'a^nd' : 'and',
                    'a^ny' : 'any',
                    'a^rt' : 'art',
                    'a^vay' : 'away',
                    'aavay' : 'away',
                    'ab0ut' : 'about',
                    'ab0ve' : 'above',
                    'ab1e' : 'able',
                    'ab6ut' : 'about',
                    'ab6ve' : 'above',
                    'abUity' : 'ability',
                    'abead' : 'ahead',
                    'abi1ity' : 'ability',
                    'abiUty' : 'ability',
                    'abihty' : 'ability',
                    'abilitv' : 'ability',
                    'ablc' : 'able',
                    'abont' : 'about',
                    'aboui' : 'about',
                    'abov^e' : 'above',
                    'abovc' : 'above',
                    'ac^t' : 'act',
                    'acc0rding' : 'according',
                    'acc0unt' : 'account',
                    'acc6unt' : 'account',
                    'acce])t' : 'accept',
                    'accej)t' : 'accept',
                    'accoiding' : 'according',
                    'accord1ng' : 'according',
                    'accordiug' : 'according',
                    'accouut' : 'account',
                    'aclion' : 'action',
                    'aclivity' : 'activity',
                    'aclually' : 'actually',
                    'acrofs' : 'across',
                    'acrols' : 'across',
                    'act1on' : 'action',
                    'act1vity' : 'activity',
                    'acti0n' : 'action',
                    'acti6n' : 'action',
                    'actiou' : 'action',
                    'activitv' : 'activity',
                    'actlon' : 'action',
                    'actuaUy' : 'actually',
                    'actuallv' : 'actually',
                    'actuauy' : 'actually',
                    'addrcfs' : 'address',
                    'addrcss' : 'address',
                    'addref' : 'address',
                    'addrefs' : 'address',
                    'addrels' : 'address',
                    'adion' : 'action',
                    'adivity' : 'activity',
                    'adlion' : 'action',
                    'adlivity' : 'activity',
                    'adlually' : 'actually',
                    'adm1n1stration' : 'administration',
                    'adm1nistration' : 'administration',
                    'adm1t' : 'admit',
                    'admin1stration' : 'administration',
                    'adminiflration' : 'administration',
                    'adminiftration' : 'administration',
                    'adminiltration' : 'administration',
                    'administrat1on' : 'administration',
                    'administrati0n' : 'administration',
                    'adtion' : 'action',
                    'adtivity' : 'activity',
                    'adtually' : 'actually',
                    'adually' : 'actually',
                    'affcft' : 'affect',
                    'affecl' : 'affect',
                    'affed' : 'affect',
                    'affedl' : 'affect',
                    'affedt' : 'affect',
                    'affeft' : 'affect',
                    'affume' : 'assume',
                    'afk' : 'ask',
                    'aflect' : 'affect',
                    'afler' : 'after',
                    'aflumc' : 'assume',
                    'aflume' : 'assume',
                    'afsume' : 'assume',
                    'aftcr' : 'after',
                    'aftei' : 'after',
                    'aftion' : 'action',
                    'aftivity' : 'activity',
                    'aftually' : 'actually',
                    'ag^ain' : 'again',
                    'ag^ainst' : 'against',
                    'ag^e' : 'age',
                    'againfi' : 'against',
                    'againfl' : 'against',
                    'againft' : 'against',
                    'againit' : 'against',
                    'againjl' : 'against',
                    'againlt' : 'against',
                    'againsi' : 'against',
                    'againsl' : 'against',
                    'againſi' : 'against',
                    'againſl' : 'against',
                    'againﬁ' : 'against',
                    'agaiu' : 'again',
                    'agaiust' : 'against',
                    'agaln' : 'again',
                    'agalnst' : 'against',
                    'agamst' : 'against',
                    'agcncy' : 'agency',
                    'agcnt' : 'agent',
                    'agencv' : 'agency',
                    'agrce' : 'agree',
                    'agrcement' : 'agreement',
                    'agrec' : 'agree',
                    'agrecment' : 'agreement',
                    'agreemcnt' : 'agreement',
                    'ahcad' : 'ahead',
                    'ahility' : 'ability',
                    'ahle' : 'able',
                    'ahone' : 'alone',
                    'ahout' : 'about',
                    'ahove' : 'above',
                    'ahready' : 'already',
                    'ahso' : 'also',
                    'aivay' : 'away',
                    'aj)pear' : 'appear',
                    'aj)ply' : 'apply',
                    'aj)proach' : 'approach',
                    'al6ne' : 'alone',
                    'al6ng' : 'along',
                    'al\vays' : 'always',
                    'alffo' : 'also',
                    'alfo' : 'also',
                    'alivays' : 'always',
                    'alloAv' : 'allow',
                    'allo\v' : 'allow',
                    'alloiv' : 'allow',
                    'alm6st' : 'almost',
                    'almofl' : 'almost',
                    'almoft' : 'almost',
                    'almolt' : 'almost',
                    'almos' : 'almost',
                    'almoſl' : 'almost',
                    'alon6' : 'alone',
                    'alonc' : 'alone',
                    'aloue' : 'alone',
                    'aloug' : 'along',
                    'alrcadv' : 'already',
                    'alrcady' : 'already',
                    'alreadv' : 'already',
                    'als0' : 'also',
                    'als6' : 'also',
                    'altbougb' : 'although',
                    'altbough' : 'although',
                    'althongh' : 'although',
                    'althougb' : 'although',
                    'althougli' : 'although',
                    'altliough' : 'although',
                    'alv/ays' : 'always',
                    'alvays' : 'always',
                    'alwavs' : 'always',
                    'alwayf' : 'always',
                    'alſb' : 'also',
                    'am0ng' : 'among',
                    'am6ng' : 'among',
                    'amoug' : 'among',
                    'amouut' : 'amount',
                    'an0ther' : 'another',
                    'an1mal' : 'animal',
                    'an6ther' : 'another',
                    'an^d' : 'and',
                    'an^y' : 'any',
                    'analvsis' : 'analysis',
                    'analyfis' : 'analysis',
                    'analylis' : 'analysis',
                    'analys1s' : 'analysis',
                    'anfiver' : 'answer',
                    'anfv/er' : 'answer',
                    'anfwcr' : 'answer',
                    'anfwer' : 'answer',
                    'animaU' : 'animal',
                    'animah' : 'animal',
                    'anlmal' : 'animal',
                    'anlwer' : 'answer',
                    'anoiher' : 'another',
                    'anotber' : 'another',
                    'anothcr' : 'another',
                    'anothei' : 'another',
                    'anotlier' : 'another',
                    'ansAver' : 'answer',
                    'ans\ver' : 'answer',
                    'ansv/er' : 'answer',
                    'ansver' : 'answer',
                    'answcr' : 'answer',
                    'answei' : 'answer',
                    'anthor' : 'author',
                    'anthority' : 'authority',
                    'anvone' : 'anyone',
                    'anvthing' : 'anything',
                    'anytbing' : 'anything',
                    'anyth1ng' : 'anything',
                    'anytliing' : 'anything',
                    'ap[)ear' : 'appear',
                    'ap])ear' : 'appear',
                    'ap])ly' : 'apply',
                    'apj)ear' : 'appear',
                    'apj)ly' : 'apply',
                    'appcar' : 'appear',
                    'applv' : 'apply',
                    'approacb' : 'approach',
                    'ap|)ear' : 'appear',
                    'ar0und' : 'around',
                    'arguc' : 'argue',
                    'arouud' : 'around',
                    'arr1ve' : 'arrive',
                    'arriire' : 'arrive',
                    'arriv6' : 'arrive',
                    'arrivc' : 'arrive',
                    'art1cle' : 'article',
                    'articlc' : 'article',
                    'artifl' : 'artist',
                    'artift' : 'artist',
                    'artilt' : 'artist',
                    'artiﬁ' : 'artist',
                    'assumc' : 'assume',
                    'attcntion' : 'attention',
                    'attent1on' : 'attention',
                    'attorncy' : 'attorney',
                    'attornev' : 'attorney',
                    'aud1ence' : 'audience',
                    'audicnce' : 'audience',
                    'auother' : 'another',
                    'auswer' : 'answer',
                    'autbor' : 'author',
                    'autboritg' : 'authority',
                    'autbority' : 'authority',
                    'auth0r' : 'author',
                    'auth0rity' : 'authority',
                    'authoi' : 'author',
                    'authoiity' : 'authority',
                    'author1ty' : 'authority',
                    'authoritv' : 'authority',
                    'autlior' : 'author',
                    'autliority' : 'authority',
                    'av/ay' : 'away',
                    'av^ay' : 'away',
                    'avaUable' : 'available',
                    'availahle' : 'available',
                    'avall' : 'wall',
                    'avater' : 'water',
                    'avell' : 'well',
                    'avest' : 'west',
                    'avhat' : 'what',
                    'avhen' : 'when',
                    'avhich' : 'which',
                    'avhite' : 'white',
                    'avho' : 'who',
                    'avill' : 'will',
                    'avith' : 'with',
                    'avork' : 'work',
                    'awav' : 'away',
                    'a|)pear' : 'appear',
                    'a£lually' : 'actually',
                    'a£tually' : 'actually',
                    'aﬁer' : 'after',
                    'aﬁne' : 'fine',
                    'b00k' : 'book',
                    'b0ard' : 'board',
                    'b0dy' : 'body',
                    'b0ok' : 'book',
                    'b0th' : 'both',
                    'b1ack' : 'black',
                    'b1ll' : 'bill',
                    'b1ood' : 'blood',
                    'b1ue' : 'blue',
                    'b6dy' : 'body',
                    'b6ok' : 'book',
                    'b^ar' : 'bar',
                    'b^it' : 'bit',
                    'b^ut' : 'but',
                    'babv' : 'baby',
                    'bafe' : 'base',
                    'bahy' : 'baby',
                    'bair' : 'hair',
                    'balf' : 'half',
                    'bappen' : 'happen',
                    'bappy' : 'happy',
                    'bas6' : 'base',
                    'baöir' : 'hair',
                    'bcat' : 'beat',
                    'bcautiful' : 'beautiful',
                    'bccaufc' : 'because',
                    'bccaufe' : 'because',
                    'bccausc' : 'because',
                    'bcforc' : 'before',
                    'bcfore' : 'before',
                    'bcft' : 'best',
                    'bcgin' : 'begin',
                    'bchavior' : 'behavior',
                    'bchind' : 'behind',
                    'bclieve' : 'believe',
                    'bclween' : 'between',
                    'bcnefit' : 'benefit',
                    'bcst' : 'best',
                    'bctAveen' : 'between',
                    'bctiveen' : 'between',
                    'bcttcr' : 'better',
                    'bctter' : 'better',
                    'bctwcen' : 'between',
                    'bctwecn' : 'between',
                    'bctween' : 'between',
                    'bcvond' : 'beyond',
                    'bcyond' : 'beyond',
                    'be/art' : 'heart',
                    'be1ieve' : 'believe',
                    'beUeve' : 'believe',
                    'bealth' : 'health',
                    'beantiful' : 'beautiful',
                    'beart' : 'heart',
                    'beaut1ful' : 'beautiful',
                    'beautifiU' : 'beautiful',
                    'beautifu1' : 'beautiful',
                    'beautifuU' : 'beautiful',
                    'beavy' : 'heavy',
                    'bebind' : 'behind',
                    'bec6me' : 'become',
                    'becanse' : 'because',
                    'becaufc' : 'because',
                    'becaufe' : 'because',
                    'becauie' : 'because',
                    'becaule' : 'because',
                    'becausc' : 'because',
                    'becomc' : 'become',
                    'bef0re' : 'before',
                    'bef6re' : 'before',
                    'befoie' : 'before',
                    'befor6' : 'before',
                    'beforc' : 'before',
                    'beft' : 'best',
                    'beg1n' : 'begin',
                    'beg^in' : 'begin',
                    'beheve' : 'believe',
                    'beiore' : 'before',
                    'bel1eve' : 'believe',
                    'belAveen' : 'between',
                    'belicve' : 'believe',
                    'belieie' : 'believe',
                    'believ^e' : 'believe',
                    'believc' : 'believe',
                    'beliind' : 'behind',
                    'belore' : 'before',
                    'belp' : 'help',
                    'belter' : 'better',
                    'bencfit' : 'benefit',
                    'benef1t' : 'benefit',
                    'beneflt' : 'benefit',
                    'beneﬁ' : 'benefit',
                    'berfelf' : 'herself',
                    'berself' : 'herself',
                    'betAvcen' : 'between',
                    'betAvecn' : 'between',
                    'betAveeu' : 'between',
                    'bet\veen' : 'between',
                    'bet^veen' : 'between',
                    'betaveen' : 'between',
                    'betivcen' : 'between',
                    'betivecn' : 'between',
                    'betiveen' : 'between',
                    'bettcr' : 'better',
                    'bettei' : 'better',
                    'bettveen' : 'between',
                    'betv/een' : 'between',
                    'betv^een' : 'between',
                    'betveen' : 'between',
                    'betveeu' : 'between',
                    'betwccn' : 'between',
                    'betwcen' : 'between',
                    'betwecn' : 'between',
                    'betweeu' : 'between',
                    'betzveen' : 'between',
                    'beueve' : 'believe',
                    'bevond' : 'beyond',
                    'beyoud' : 'beyond',
                    'beſi' : 'best',
                    'beſl' : 'best',
                    'beſore' : 'before',
                    'bftter' : 'better',
                    'bftween' : 'between',
                    'biU' : 'bill',
                    'biftory' : 'history',
                    'bigh' : 'high',
                    'biiU' : 'bill',
                    'bil1' : 'bill',
                    'bimfelf' : 'himself',
                    'bimjelf' : 'himself',
                    'bimsclf' : 'himself',
                    'bimself' : 'himself',
                    'bistory' : 'history',
                    'biu' : 'bill',
                    'blll' : 'bill',
                    'bluc' : 'blue',
                    'bnilding' : 'building',
                    'bodv' : 'body',
                    'bofpital' : 'hospital',
                    'boru' : 'born',
                    'bospital' : 'hospital',
                    'botb' : 'both',
                    'botl' : 'both',
                    'botli' : 'both',
                    'bowever' : 'however',
                    'br1ng' : 'bring',
                    'brcak' : 'break',
                    'briug' : 'bring',
                    'brlng' : 'bring',
                    'brmg' : 'bring',
                    'brotber' : 'brother',
                    'brothcr' : 'brother',
                    'brothei' : 'brother',
                    'brotlier' : 'brother',
                    'bu1ld1ng' : 'building',
                    'bufband' : 'husband',
                    'buffinefs' : 'business',
                    'buffines' : 'business',
                    'buffiness' : 'business',
                    'bufincfs' : 'business',
                    'bufinef' : 'business',
                    'bufinefs' : 'business',
                    'bufines' : 'business',
                    'bufiness' : 'business',
                    'bufmefs' : 'business',
                    'buge' : 'huge',
                    'bui1ding' : 'building',
                    'buihiing' : 'building',
                    'build1ng' : 'building',
                    'bujband' : 'husband',
                    'bulinels' : 'business',
                    'buliness' : 'business',
                    'buman' : 'human',
                    'bundred' : 'hundred',
                    'busband' : 'husband',
                    'busincss' : 'business',
                    'businefs' : 'business',
                    'businels' : 'business',
                    'busmess' : 'business',
                    'buﬁnefs' : 'business',
                    'buﬁneſs' : 'business',
                    'bymself' : 'himself',
                    'c0llege' : 'college',
                    'c0me' : 'come',
                    'c0mmercial' : 'commercial',
                    'c0mpany' : 'company',
                    'c0nditi0n' : 'condition',
                    'c0st' : 'cost',
                    'c0uld' : 'could',
                    'c0untry' : 'country',
                    'c0urse' : 'course',
                    'c0urt' : 'court',
                    'c1ass' : 'class',
                    'c1ear' : 'clear',
                    'c1ose' : 'close',
                    'c1ty' : 'city',
                    'c1vil' : 'civil',
                    'c6me' : 'come',
                    'c6mmon' : 'common',
                    'c6st' : 'cost',
                    'c6uld' : 'could',
                    'c6untry' : 'country',
                    'c6urse' : 'course',
                    'c6urt' : 'court',
                    'c^an' : 'can',
                    'caU' : 'call',
                    'ca[)ital' : 'capital',
                    'ca])ital' : 'capital',
                    'cach' : 'each',
                    'cai)ital' : 'capital',
                    'caie' : 'care',
                    'caj)ital' : 'capital',
                    'cam])aign' : 'campaign',
                    'cami)aign' : 'campaign',
                    'cand1date' : 'candidate',
                    'cap1tal' : 'capital',
                    'capita1' : 'capital',
                    'carecr' : 'career',
                    'carrv' : 'carry',
                    'cas6' : 'case',
                    'catcb' : 'catch',
                    'caufc' : 'cause',
                    'caufe' : 'cause',
                    'cauie' : 'cause',
                    'caule' : 'cause',
                    'caus6' : 'cause',
                    'causc' : 'cause',
                    'ca|)ital' : 'capital',
                    'cbair' : 'chair',
                    'cbance' : 'chance',
                    'cbange' : 'change',
                    'cbaracter' : 'character',
                    'cbarafter' : 'character',
                    'cbarge' : 'charge',
                    'cbeck' : 'check',
                    'cbild' : 'child',
                    'cboice' : 'choice',
                    'cboofe' : 'choose',
                    'cboose' : 'choose',
                    'cburcb' : 'church',
                    'cburch' : 'church',
                    'cburcli' : 'church',
                    'ccll' : 'cell',
                    'ccnter' : 'center',
                    'ccntral' : 'central',
                    'ccnturv' : 'century',
                    'ccntury' : 'century',
                    'cconomv' : 'economy',
                    'cconomy' : 'economy',
                    'ccrtain' : 'certain',
                    'ccrtainlv' : 'certainly',
                    'ccrtainly' : 'certainly',
                    'cdge' : 'edge',
                    'cducation' : 'education',
                    'ceUor' : 'color',
                    'ceitain' : 'certain',
                    'centcr' : 'center',
                    'centnry' : 'century',
                    'centra1' : 'central',
                    'centuiy' : 'century',
                    'centurv' : 'century',
                    'certain1y' : 'certainly',
                    'certainlv' : 'certainly',
                    'certaiu' : 'certain',
                    'certaiuly' : 'certainly',
                    'certaln' : 'certain',
                    'certamly' : 'certainly',
                    'cffcct' : 'effect',
                    'cffecl' : 'effect',
                    'cffect' : 'effect',
                    'cffeft' : 'effect',
                    'cffort' : 'effort',
                    'cfpccially' : 'especially',
                    'cfpecially' : 'especially',
                    'cftablifh' : 'establish',
                    'ch1ld' : 'child',
                    'chaUenge' : 'challenge',
                    'chancc' : 'chance',
                    'chang6' : 'change',
                    'changc' : 'change',
                    'characlcr' : 'character',
                    'characler' : 'character',
                    'charactcr' : 'character',
                    'charactei' : 'character',
                    'charader' : 'character',
                    'charadler' : 'character',
                    'charadter' : 'character',
                    'charaftcr' : 'character',
                    'charafter' : 'character',
                    'chara£ler' : 'character',
                    'chara£ter' : 'character',
                    'charaﬁter' : 'character',
                    'charg6' : 'charge',
                    'chargc' : 'charge',
                    'chauenge' : 'challenge',
                    'chi1d' : 'child',
                    'chlld' : 'child',
                    'chnrch' : 'church',
                    'choicc' : 'choice',
                    'choofc' : 'choose',
                    'choofe' : 'choose',
                    'choole' : 'choose',
                    'choosc' : 'choose',
                    'chuich' : 'church',
                    'churcb' : 'church',
                    'churcli' : 'church',
                    'chureh' : 'church',
                    'cight' : 'eight',
                    'ciiy' : 'city',
                    'citizcn' : 'citizen',
                    'citv' : 'city',
                    'civ1l' : 'civil',
                    'civi1' : 'civil',
                    'civiU' : 'civil',
                    'claff' : 'class',
                    'clafs' : 'class',
                    'clals' : 'class',
                    'clasf' : 'class',
                    'clcar' : 'clear',
                    'clcarlv' : 'clearly',
                    'clcarly' : 'clearly',
                    'clcction' : 'election',
                    'cleai' : 'clear',
                    'clearlv' : 'clearly',
                    'clection' : 'election',
                    'cliair' : 'chair',
                    'cliange' : 'change',
                    'cliaracter' : 'character',
                    'cliarge' : 'charge',
                    'cliild' : 'child',
                    'cliurcb' : 'church',
                    'cliurch' : 'church',
                    'cliurcli' : 'church',
                    'clofe' : 'close',
                    'closc' : 'close',
                    'clse' : 'else',
                    'clty' : 'city',
                    'clvil' : 'civil',
                    'cnergv' : 'energy',
                    'cnergy' : 'energy',
                    'cnjoy' : 'enjoy',
                    'cnough' : 'enough',
                    'cnter' : 'enter',
                    'cntire' : 'entire',
                    'co11ege' : 'college',
                    'co1d' : 'cold',
                    'coUection' : 'collection',
                    'coUedge' : 'college',
                    'coUedion' : 'collection',
                    'coUedlion' : 'collection',
                    'coUeftion' : 'collection',
                    'coUega' : 'college',
                    'coUege' : 'college',
                    'coUoq' : 'color',
                    'coacb' : 'coach',
                    'coft' : 'cost',
                    'cohor' : 'color',
                    'coiUd' : 'could',
                    'col1ege' : 'college',
                    'collcgc' : 'college',
                    'collcge' : 'college',
                    'colleclion' : 'collection',
                    'collect1on' : 'collection',
                    'colledion' : 'collection',
                    'colledtion' : 'collection',
                    'colleftion' : 'collection',
                    'collegc' : 'college',
                    'com[)any' : 'company',
                    'com])any' : 'company',
                    'comc' : 'come',
                    'comi)any' : 'company',
                    'comj)any' : 'company',
                    'comm6n' : 'common',
                    'commcrcial' : 'commercial',
                    'commerc1al' : 'commercial',
                    'commercia1' : 'commercial',
                    'commou' : 'common',
                    'communitv' : 'community',
                    'companv' : 'company',
                    'compar6' : 'compare',
                    'comparc' : 'compare',
                    'compauy' : 'company',
                    'com|)any' : 'company',
                    'conccrn' : 'concern',
                    'cond1t1on' : 'condition',
                    'cond1tion' : 'condition',
                    'condit1on' : 'condition',
                    'confcrence' : 'conference',
                    'confercnce' : 'conference',
                    'conferencc' : 'conference',
                    'confumer' : 'consumer',
                    'conilder' : 'consider',
                    'conld' : 'could',
                    'conlider' : 'consider',
                    'conrse' : 'course',
                    'conrt' : 'court',
                    'cons1der' : 'consider',
                    'considcr' : 'consider',
                    'cont1nue' : 'continue',
                    'continuc' : 'continue',
                    'contro1' : 'control',
                    'cosl' : 'cost',
                    'cou1d' : 'could',
                    'couection' : 'collection',
                    'couege' : 'college',
                    'couise' : 'course',
                    'couit' : 'court',
                    'countiy' : 'country',
                    'countrv' : 'country',
                    'courfc' : 'course',
                    'courfe' : 'course',
                    'courie' : 'course',
                    'courle' : 'course',
                    'coursc' : 'course',
                    'couutry' : 'country',
                    'covcr' : 'cover',
                    'crcate' : 'create',
                    'creatc' : 'create',
                    'crimc' : 'crime',
                    'cspecially' : 'especially',
                    'cstablish' : 'establish',
                    'cuftomer' : 'customer',
                    'culturc' : 'culture',
                    'currcnt' : 'current',
                    'cven' : 'even',
                    'cvening' : 'evening',
                    'cvent' : 'event',
                    'cver' : 'ever',
                    'cvery' : 'every',
                    'cverything' : 'everything',
                    'cvidence' : 'evidence',
                    'cxactly' : 'exactly',
                    'cxample' : 'example',
                    'cxist' : 'exist',
                    'cxpect' : 'expect',
                    'cxpedt' : 'expect',
                    'cxpeft' : 'expect',
                    'cxperience' : 'experience',
                    'cxplain' : 'explain',
                    'd1fference' : 'difference',
                    'd1fferent' : 'different',
                    'd1fficult' : 'difficult',
                    'd1nner' : 'dinner',
                    'd1rection' : 'direction',
                    'd1scover' : 'discover',
                    'd1scussion' : 'discussion',
                    'd6cision' : 'decision',
                    'd6fense' : 'defense',
                    'd6or' : 'door',
                    'd6tail' : 'detail',
                    'd6termin6' : 'determine',
                    'd6termine' : 'determine',
                    'd6wn' : 'down',
                    'd^veloppement' : 'development',
                    'daik' : 'dark',
                    'danghter' : 'daughter',
                    'daugbter' : 'daughter',
                    'daughtcr' : 'daughter',
                    'daugliter' : 'daughter',
                    'dcad' : 'dead',
                    'dcal' : 'deal',
                    'dcath' : 'death',
                    'dccifion' : 'decision',
                    'dccision' : 'decision',
                    'dcep' : 'deep',
                    'dcfcribe' : 'describe',
                    'dcfign' : 'design',
                    'dcgrce' : 'degree',
                    'dcmocratic' : 'democratic',
                    'dcsign' : 'design',
                    'dctail' : 'detail',
                    'dctermine' : 'determine',
                    'dea1' : 'deal',
                    'deaU' : 'deal',
                    'dea^h' : 'deal',
                    'deaih' : 'death',
                    'dealh' : 'death',
                    'deatb' : 'death',
                    'deatli' : 'death',
                    'debatc' : 'debate',
                    'dec1sion' : 'decision',
                    'decid6' : 'decide',
                    'decifion' : 'decision',
                    'decilion' : 'decision',
                    'deciﬁon' : 'decision',
                    'decp' : 'deep',
                    'defcribc' : 'describe',
                    'defcribe' : 'describe',
                    'defcrihe' : 'describe',
                    'defenfe' : 'defense',
                    'deffenfe' : 'defense',
                    'defign' : 'design',
                    'defpite' : 'despite',
                    'degrcc' : 'degree',
                    'degrce' : 'degree',
                    'degrec' : 'degree',
                    'dehate' : 'debate',
                    'delcribe' : 'describe',
                    'delign' : 'design',
                    'des1gn' : 'design',
                    'descr1be' : 'describe',
                    'describc' : 'describe',
                    'descrihe' : 'describe',
                    'deserihe' : 'describe',
                    'detai1' : 'detail',
                    'detcrmine' : 'determine',
                    'determ1ne' : 'determine',
                    'determin6' : 'determine',
                    'determinc' : 'determine',
                    'devclopment' : 'development',
                    'develo])ment' : 'development',
                    'develoi)ment' : 'development',
                    'develoj)ment' : 'development',
                    'developmcnt' : 'development',
                    'deáh' : 'deal',
                    'deﬁgn' : 'design',
                    'dhection' : 'election',
                    'difcafc' : 'disease',
                    'difcafe' : 'disease',
                    'difcovcr' : 'discover',
                    'difcover' : 'discover',
                    'difcuffion' : 'discussion',
                    'difcuflion' : 'discussion',
                    'difcufs' : 'discuss',
                    'difcussion' : 'discussion',
                    'difeafc' : 'disease',
                    'difeafe' : 'disease',
                    'difease' : 'disease',
                    'diff1cult' : 'difficult',
                    'diff^erent' : 'different',
                    'diffcrcnt' : 'different',
                    'diffcrence' : 'difference',
                    'diffcrent' : 'different',
                    'differcnce' : 'difference',
                    'differcnt' : 'different',
                    'differencc' : 'difference',
                    'difficuU' : 'difficult',
                    'difficuUy' : 'difficult',
                    'difficuhy' : 'difficult',
                    'difflcult' : 'difficult',
                    'diflerence' : 'difference',
                    'diflerent' : 'different',
                    'diflicult' : 'difficult',
                    'difſerent' : 'different',
                    'dilcover' : 'discover',
                    'dillerent' : 'different',
                    'dilﬁcult' : 'difficult',
                    'dinncr' : 'dinner',
                    'direclion' : 'direction',
                    'direclor' : 'director',
                    'direct1on' : 'direction',
                    'directi0n' : 'direction',
                    'diredion' : 'direction',
                    'diredlion' : 'direction',
                    'diredor' : 'director',
                    'diredtion' : 'direction',
                    'direftion' : 'direction',
                    'direftor' : 'director',
                    'dire£lion' : 'direction',
                    'dire£tion' : 'direction',
                    'direﬁtion' : 'direction',
                    'discasc' : 'disease',
                    'discase' : 'disease',
                    'discovcr' : 'discover',
                    'discuffion' : 'discussion',
                    'discufsion' : 'discussion',
                    'discuss1on' : 'discussion',
                    'diseafe' : 'disease',
                    'diseasc' : 'disease',
                    'ditﬁcult' : 'difficult',
                    'diſferent' : 'different',
                    'diſiicult' : 'difficult',
                    'diſſerence' : 'difference',
                    'diſſerent' : 'different',
                    'diﬁcrent' : 'different',
                    'diﬁferent' : 'different',
                    'dlfferent' : 'different',
                    'dming' : 'during',
                    'dnring' : 'during',
                    'doAvii' : 'down',
                    'do\vn' : 'down',
                    'do^vn' : 'down',
                    'doavn' : 'down',
                    'doclor' : 'doctor',
                    'dodlor' : 'doctor',
                    'dodor' : 'doctor',
                    'dodtor' : 'doctor',
                    'doftor' : 'doctor',
                    'doivn' : 'down',
                    'dooi' : 'door',
                    'dov/n' : 'down',
                    'dov^n' : 'down',
                    'dovn' : 'down',
                    'dowu' : 'down',
                    'draAv' : 'draw',
                    'dra\v' : 'draw',
                    'dra^v' : 'draw',
                    'draiv' : 'draw',
                    'drcam' : 'dream',
                    'drivc' : 'drive',
                    'duiing' : 'during',
                    'dur1ng' : 'during',
                    'duriug' : 'during',
                    'durlng' : 'during',
                    'durmg' : 'during',
                    'e1ection' : 'election',
                    'e1ght' : 'eight',
                    'e1ther' : 'either',
                    'eVei' : 'even',
                    'e\eiy' : 'every',
                    'e^at' : 'eat',
                    'e^nd' : 'end',
                    'e^very' : 'every',
                    'eacb' : 'each',
                    'eacli' : 'each',
                    'eaft' : 'east',
                    'eafy' : 'easy',
                    'eaily' : 'early',
                    'eait' : 'east',
                    'ear1y' : 'early',
                    'earh' : 'each',
                    'earlv' : 'early',
                    'easUy' : 'early',
                    'easv' : 'easy',
                    'eaſl' : 'east',
                    'ebaracter' : 'character',
                    'ec0n0my' : 'economy',
                    'econom1c' : 'economic',
                    'economv' : 'economy',
                    'edgc' : 'edge',
                    'educat1on' : 'education',
                    'educati0n' : 'education',
                    'educati6n' : 'education',
                    'eff^ect' : 'effect',
                    'effccl' : 'effect',
                    'effcft' : 'effect',
                    'effecl' : 'effect',
                    'effed' : 'effect',
                    'effedl' : 'effect',
                    'effedt' : 'effect',
                    'effeft' : 'effect',
                    'eflablifh' : 'establish',
                    'eflablifli' : 'establish',
                    'eflect' : 'effect',
                    'efpccially' : 'especially',
                    'efpeciaUy' : 'especially',
                    'efpecially' : 'especially',
                    'efpeciauy' : 'especially',
                    'eftabhfh' : 'establish',
                    'eftablifb' : 'establish',
                    'eftablifh' : 'establish',
                    'eftablifli' : 'establish',
                    'eftabliih' : 'establish',
                    'eftablijh' : 'establish',
                    'eftablim' : 'establish',
                    'eftablish' : 'establish',
                    'ei^en' : 'even',
                    'eien' : 'even',
                    'eient' : 'event',
                    'eiery' : 'every',
                    'eig^ht' : 'eight',
                    'eigbt' : 'eight',
                    'eiglit' : 'eight',
                    'eilher' : 'either',
                    'eitber' : 'either',
                    'eithcr' : 'either',
                    'eithei' : 'either',
                    'eitlier' : 'either',
                    'ei»en' : 'even',
                    'eleclion' : 'election',
                    'elect1on' : 'election',
                    'electlon' : 'election',
                    'eledion' : 'election',
                    'eledlion' : 'election',
                    'eledtion' : 'election',
                    'eleftion' : 'election',
                    'ele£lion' : 'election',
                    'elght' : 'eight',
                    'elpecially' : 'especially',
                    'els6' : 'else',
                    'elsc' : 'else',
                    'eltablilh' : 'establish',
                    'elther' : 'either',
                    'employec' : 'employee',
                    'en6ugh' : 'enough',
                    'encrgv' : 'energy',
                    'encrgy' : 'energy',
                    'energv' : 'energy',
                    'enjov' : 'enjoy',
                    'enongh' : 'enough',
                    'enoug^h' : 'enough',
                    'enougb' : 'enough',
                    'enougli' : 'enough',
                    'ent1re' : 'entire',
                    'entcr' : 'enter',
                    'entei' : 'enter',
                    'entirc' : 'entire',
                    'eould' : 'could',
                    'es[)ecially' : 'especially',
                    'es])ecially' : 'especially',
                    'esi)ecially' : 'especially',
                    'esj)ecially' : 'especially',
                    'espccially' : 'especially',
                    'espec1ally' : 'especially',
                    'especiaUy' : 'especially',
                    'especiahy' : 'especially',
                    'especiallv' : 'especially',
                    'especiauy' : 'especially',
                    'especlally' : 'especially',
                    'estab1ish' : 'establish',
                    'estabUsh' : 'establish',
                    'estabhsh' : 'establish',
                    'establ1sh' : 'establish',
                    'establifh' : 'establish',
                    'establilh' : 'establish',
                    'establisb' : 'establish',
                    'estahiish' : 'establish',
                    'estahlish' : 'establish',
                    'es|)ecially' : 'especially',
                    'euough' : 'enough',
                    'ev1dence' : 'evidence',
                    'ev6n' : 'even',
                    'ev^en' : 'even',
                    'ev^ening' : 'evening',
                    'ev^ent' : 'event',
                    'ev^er' : 'ever',
                    'ev^ery' : 'every',
                    'evcn' : 'even',
                    'evcnt' : 'event',
                    'evcr' : 'ever',
                    'evcry' : 'every',
                    'evcrything' : 'everything',
                    'eveiy' : 'every',
                    'even1ng' : 'evening',
                    'evenmg' : 'evening',
                    'everv' : 'every',
                    'evervbody' : 'everybody',
                    'evervone' : 'everyone',
                    'evervthing' : 'everything',
                    'everybodv' : 'everybody',
                    'everyhody' : 'everybody',
                    'everytbing' : 'everything',
                    'eveu' : 'even',
                    'evidcnce' : 'evidence',
                    'evidencc' : 'evidence',
                    'evldence' : 'evidence',
                    'ex1st' : 'exist',
                    'ex[)erience' : 'experience',
                    'ex])erience' : 'experience',
                    'ex])lain' : 'explain',
                    'exacUy' : 'exactly',
                    'exaclly' : 'exactly',
                    'exactlv' : 'exactly',
                    'exadlly' : 'exactly',
                    'exadly' : 'exactly',
                    'exadtly' : 'exactly',
                    'exaftly' : 'exactly',
                    'exam[)le' : 'example',
                    'exam])le' : 'example',
                    'exami)le' : 'example',
                    'examj)le' : 'example',
                    'examp1e' : 'example',
                    'examplc' : 'example',
                    'exa£lly' : 'exactly',
                    'exa£tly' : 'exactly',
                    'execut1ve' : 'executive',
                    'exi)ect' : 'expect',
                    'exi)erience' : 'experience',
                    'exi)lain' : 'explain',
                    'exifl' : 'exist',
                    'exift' : 'exist',
                    'exilt' : 'exist',
                    'exj)ect' : 'expect',
                    'exj)erience' : 'experience',
                    'exj)lain' : 'explain',
                    'exp6rience' : 'experience',
                    'expcft' : 'expect',
                    'expcrience' : 'experience',
                    'expecl' : 'expect',
                    'exped' : 'expect',
                    'expedl' : 'expect',
                    'expedt' : 'expect',
                    'expeft' : 'expect',
                    'exper1ence' : 'experience',
                    'expericnce' : 'experience',
                    'experiencc' : 'experience',
                    'ex|)erience' : 'experience',
                    'eſfect' : 'effect',
                    'eſlabliſh' : 'establish',
                    'eﬁfect' : 'effect',
                    'f)lace' : 'place',
                    'f/W' : 'few',
                    'f0rce' : 'force',
                    'f0reign' : 'foreign',
                    'f0rm' : 'form',
                    'f0ur' : 'four',
                    'f1eld' : 'field',
                    'f1ght' : 'fight',
                    'f1gure' : 'figure',
                    'f1ll' : 'fill',
                    'f1lm' : 'film',
                    'f1milar' : 'similar',
                    'f1nal' : 'final',
                    'f1nally' : 'finally',
                    'f1nancial' : 'financial',
                    'f1nd' : 'find',
                    'f1ne' : 'fine',
                    'f1nger' : 'finger',
                    'f1nish' : 'finish',
                    'f1re' : 'fire',
                    'f1rm' : 'firm',
                    'f1rst' : 'first',
                    'f1sh' : 'fish',
                    'f1tuation' : 'situation',
                    'f1ve' : 'five',
                    'f6rce' : 'force',
                    'f6rm' : 'form',
                    'f6ur' : 'four',
                    'fUy' : 'fly',
                    'f^all' : 'fall',
                    'f^ar' : 'far',
                    'f^ill' : 'fill',
                    'f^ive' : 'five',
                    'f^ood' : 'food',
                    'f^or' : 'for',
                    'f^r' : 'for',
                    'f^rom' : 'from',
                    'f^und' : 'fund',
                    'faUh' : 'fall',
                    'fac6' : 'face',
                    'facc' : 'face',
                    'facl' : 'fact',
                    'faclor' : 'factor',
                    'fadl' : 'fact',
                    'fador' : 'factor',
                    'fadt' : 'fact',
                    'fadtor' : 'factor',
                    'fafe' : 'safe',
                    'fafl' : 'fast',
                    'faft' : 'fast',
                    'faftor' : 'factor',
                    'fai1' : 'fail',
                    'faiU' : 'fail',
                    'faih' : 'fail',
                    'fal1' : 'fall',
                    'fam1ly' : 'family',
                    'famUy' : 'family',
                    'fami1y' : 'family',
                    'familv' : 'family',
                    'fatber' : 'father',
                    'fathcr' : 'father',
                    'fathei' : 'father',
                    'fatlier' : 'father',
                    'fave' : 'save',
                    'faye' : 'say',
                    'fbort' : 'short',
                    'fbould' : 'should',
                    'fcafon' : 'season',
                    'fcbool' : 'school',
                    'fccling' : 'feeling',
                    'fccond' : 'second',
                    'fcction' : 'section',
                    'fccurity' : 'security',
                    'fcderal' : 'federal',
                    'fcel' : 'feel',
                    'fceling' : 'feeling',
                    'fcem' : 'seem',
                    'fcene' : 'scene',
                    'fchool' : 'school',
                    'fcicnce' : 'science',
                    'fciencc' : 'science',
                    'fcience' : 'science',
                    'fcore' : 'score',
                    'fcrious' : 'serious',
                    'fcrvicc' : 'service',
                    'fcrvice' : 'service',
                    'fcvcral' : 'several',
                    'fcveral' : 'several',
                    'feAv' : 'few',
                    'fea' : 'sea',
                    'feafon' : 'season',
                    'feai' : 'fear',
                    'feason' : 'season',
                    'fecl' : 'feel',
                    'fecling' : 'feeling',
                    'feclion' : 'section',
                    'fecond' : 'second',
                    'fection' : 'section',
                    'fecurity' : 'security',
                    'federa1' : 'federal',
                    'fedion' : 'section',
                    'fedlion' : 'section',
                    'fedtion' : 'section',
                    'fee1' : 'feel',
                    'feeU' : 'feel',
                    'feeUng' : 'feeling',
                    'feeh' : 'feel',
                    'feehng' : 'feeling',
                    'feek' : 'seek',
                    'feel1ng' : 'feeling',
                    'feem' : 'seem',
                    'feeung' : 'feeling',
                    'feftion' : 'section',
                    'feiv' : 'few',
                    'fenfe' : 'sense',
                    'fenior' : 'senior',
                    'fense' : 'sense',
                    'ferics' : 'series',
                    'feries' : 'series',
                    'feriouf' : 'serious',
                    'ferious' : 'serious',
                    'ferve' : 'serve',
                    'fervicc' : 'service',
                    'fervice' : 'service',
                    'fevcral' : 'several',
                    'feven' : 'seven',
                    'feveral' : 'several',
                    'fex' : 'sex',
                    'fexual' : 'sexual',
                    'fe£tion' : 'section',
                    'ffave' : 'save',
                    'ffea' : 'sea',
                    'ffhe' : 'she',
                    'ffite' : 'site',
                    'ffom' : 'from',
                    'ffome' : 'some',
                    'fhake' : 'shake',
                    'fhare' : 'share',
                    'fhe' : 'she',
                    'fhoot' : 'shoot',
                    'fhort' : 'short',
                    'fhot' : 'shot',
                    'fhould' : 'should',
                    'fhoulder' : 'shoulder',
                    'fhow' : 'show',
                    'fi1m' : 'film',
                    'fiU' : 'fill',
                    'fiate' : 'state',
                    'ficld' : 'field',
                    'fie1d' : 'field',
                    'fifh' : 'fish',
                    'fifler' : 'sister',
                    'fifli' : 'fish',
                    'fifter' : 'sister',
                    'figbt' : 'fight',
                    'figlit' : 'fight',
                    'fign' : 'sign',
                    'fignificant' : 'significant',
                    'figur6' : 'figure',
                    'figurc' : 'figure',
                    'fiift' : 'first',
                    'fiih' : 'fish',
                    'fijb' : 'fish',
                    'fil1' : 'fill',
                    'filh' : 'fish',
                    'fimilar' : 'similar',
                    'fimplc' : 'simple',
                    'fimple' : 'simple',
                    'fimply' : 'simply',
                    'fin1sh' : 'finish',
                    'fina1' : 'final',
                    'finaU' : 'final',
                    'finaUy' : 'finally',
                    'finallv' : 'finally',
                    'financia1' : 'financial',
                    'finauy' : 'finally',
                    'finc' : 'fine',
                    'fincc' : 'since',
                    'fince' : 'since',
                    'fing' : 'sing',
                    'fingcr' : 'finger',
                    'finglc' : 'single',
                    'fingle' : 'single',
                    'finifh' : 'finish',
                    'finifli' : 'finish',
                    'finiih' : 'finish',
                    'finijh' : 'finish',
                    'finilh' : 'finish',
                    'finim' : 'finish',
                    'firc' : 'fire',
                    'firfi' : 'first',
                    'firfl' : 'first',
                    'firft' : 'first',
                    'firit' : 'first',
                    'firlt' : 'first',
                    'firsi' : 'first',
                    'fisb' : 'fish',
                    'fisli' : 'fish',
                    'fister' : 'sister',
                    'fite' : 'site',
                    'fituation' : 'situation',
                    'fiud' : 'find',
                    'fiv^e' : 'five',
                    'fivc' : 'five',
                    'fize' : 'size',
                    'fkill' : 'skill',
                    'fkin' : 'skin',
                    'fl^y' : 'fly',
                    'flaff' : 'staff',
                    'flage' : 'stage',
                    'fland' : 'stand',
                    'flandard' : 'standard',
                    'flart' : 'start',
                    'flatement' : 'statement',
                    'flation' : 'station',
                    'fleld' : 'field',
                    'flght' : 'fight',
                    'flgure' : 'figure',
                    'fliarc' : 'share',
                    'fliare' : 'share',
                    'flill' : 'still',
                    'fliort' : 'short',
                    'fliot' : 'shot',
                    'fliould' : 'should',
                    'flioulder' : 'shoulder',
                    'fliow' : 'show',
                    'flll' : 'fill',
                    'flnaUy' : 'finally',
                    'flnal' : 'final',
                    'flnally' : 'finally',
                    'flnancial' : 'financial',
                    'flnd' : 'find',
                    'flne' : 'fine',
                    'flnger' : 'finger',
                    'flnish' : 'finish',
                    'flre' : 'fire',
                    'flreet' : 'street',
                    'flrm' : 'firm',
                    'flrong' : 'strong',
                    'flrst' : 'first',
                    'flructure' : 'structure',
                    'flrufture' : 'structure',
                    'flsh' : 'fish',
                    'fludent' : 'student',
                    'fludy' : 'study',
                    'flyle' : 'style',
                    'fmal' : 'final',
                    'fmall' : 'small',
                    'fmally' : 'finally',
                    'fmgle' : 'single',
                    'fmile' : 'smile',
                    'fnll' : 'full',
                    'foUov' : 'follow',
                    'foUow' : 'follow',
                    'focial' : 'social',
                    'focicty' : 'society',
                    'focietv' : 'society',
                    'fociety' : 'society',
                    'focul' : 'focus',
                    'foice' : 'force',
                    'foim' : 'form',
                    'foldicr' : 'soldier',
                    'foldier' : 'soldier',
                    'folloAv' : 'follow',
                    'follo\v' : 'follow',
                    'folloiv' : 'follow',
                    'follov' : 'follow',
                    'fomcthing' : 'something',
                    'fomctimcs' : 'sometimes',
                    'fomctimes' : 'sometimes',
                    'fome' : 'some',
                    'fomebody' : 'somebody',
                    'fometbing' : 'something',
                    'fomething' : 'something',
                    'fometimcs' : 'sometimes',
                    'fometimes' : 'sometimes',
                    'fong' : 'song',
                    'foon' : 'soon',
                    'forAvard' : 'forward',
                    'for\vard' : 'forward',
                    'for^vard' : 'forward',
                    'forc6' : 'force',
                    'forcc' : 'force',
                    'forcign' : 'foreign',
                    'foreigu' : 'foreign',
                    'forgct' : 'forget',
                    'forivard' : 'forward',
                    'formcr' : 'former',
                    'formei' : 'former',
                    'forv/ard' : 'forward',
                    'forvard' : 'forward',
                    'fouow' : 'follow',
                    'fourcc' : 'source',
                    'fource' : 'source',
                    'foutb' : 'south',
                    'fouth' : 'south',
                    'fouthcrn' : 'southern',
                    'fouthern' : 'southern',
                    'fpace' : 'space',
                    'fpccial' : 'special',
                    'fpccific' : 'specific',
                    'fpcech' : 'speech',
                    'fpeak' : 'speak',
                    'fpecch' : 'speech',
                    'fpecial' : 'special',
                    'fpecific' : 'specific',
                    'fpecilic' : 'specific',
                    'fpeecb' : 'speech',
                    'fpeech' : 'speech',
                    'fpend' : 'spend',
                    'fport' : 'sport',
                    'fpring' : 'spring',
                    'fr0m' : 'from',
                    'fr0nt' : 'front',
                    'fr1end' : 'friend',
                    'fr6m' : 'from',
                    'fr^om' : 'from',
                    'frec' : 'free',
                    'fricnd' : 'friend',
                    'frieud' : 'friend',
                    'frlend' : 'friend',
                    'froni' : 'front',
                    'frout' : 'front',
                    'ftaff' : 'staff',
                    'ftafl' : 'staff',
                    'ftage' : 'stage',
                    'ftand' : 'stand',
                    'ftandard' : 'standard',
                    'ftar' : 'star',
                    'ftart' : 'start',
                    'ftatcment' : 'statement',
                    'ftate' : 'state',
                    'ftatement' : 'statement',
                    'ftation' : 'station',
                    'ftay' : 'stay',
                    'ftep' : 'step',
                    'ftiil' : 'still',
                    'ftill' : 'still',
                    'ftock' : 'stock',
                    'ftop' : 'stop',
                    'ftore' : 'store',
                    'ftory' : 'story',
                    'ftrcet' : 'street',
                    'ftrect' : 'street',
                    'ftreet' : 'street',
                    'ftrong' : 'strong',
                    'ftruclure' : 'structure',
                    'ftructurc' : 'structure',
                    'ftructure' : 'structure',
                    'ftrudlure' : 'structure',
                    'ftrudture' : 'structure',
                    'ftrudure' : 'structure',
                    'ftrufture' : 'structure',
                    'ftudent' : 'student',
                    'ftudy' : 'study',
                    'ftuff' : 'stuff',
                    'ftyle' : 'style',
                    'fuU' : 'full',
                    'fuUj' : 'full',
                    'fuUv' : 'full',
                    'fubjcct' : 'subject',
                    'fubjecT' : 'subject',
                    'fubjecft' : 'subject',
                    'fubjecl' : 'subject',
                    'fubject' : 'subject',
                    'fubjed' : 'subject',
                    'fubjedl' : 'subject',
                    'fubjedt' : 'subject',
                    'fubjeft' : 'subject',
                    'fubje£b' : 'subject',
                    'fubje£l' : 'subject',
                    'fubje£r' : 'subject',
                    'fubje£t' : 'subject',
                    'fucceff' : 'success',
                    'fuccefs' : 'success',
                    'fuccefsful' : 'successful',
                    'fuccess' : 'success',
                    'fuch' : 'such',
                    'fuddcnly' : 'suddenly',
                    'fuddenly' : 'suddenly',
                    'fuffcr' : 'suffer',
                    'fuffer' : 'suffer',
                    'fuggcft' : 'suggest',
                    'fuggefl' : 'suggest',
                    'fuggeft' : 'suggest',
                    'fuggest' : 'suggest',
                    'fuhject' : 'subject',
                    'ful1' : 'full',
                    'fummcr' : 'summer',
                    'fummer' : 'summer',
                    'fupport' : 'support',
                    'fure' : 'sure',
                    'furfacc' : 'surface',
                    'furface' : 'surface',
                    'futurc' : 'future',
                    'futuræ' : 'future',
                    'fvftem' : 'system',
                    'fyflem' : 'system',
                    'fyftcm' : 'system',
                    'fyftem' : 'system',
                    'fystem' : 'system',
                    'g00d' : 'good',
                    'g0od' : 'good',
                    'g0vernment' : 'government',
                    'g1ve' : 'give',
                    'g6n6ral' : 'general',
                    'g6neral' : 'general',
                    'g6od' : 'good',
                    'g6vernment' : 'government',
                    'g^as' : 'gas',
                    'g^eneral' : 'general',
                    'g^et' : 'get',
                    'g^ive' : 'give',
                    'g^ood' : 'good',
                    'g^overnment' : 'government',
                    'g^reat' : 'great',
                    'g^reen' : 'green',
                    'g^round' : 'ground',
                    'gaf' : 'gas',
                    'gamc' : 'game',
                    'gardcn' : 'garden',
                    'gcncral' : 'general',
                    'gcneral' : 'general',
                    'gcneration' : 'generation',
                    'ge^t' : 'get',
                    'gen6ral' : 'general',
                    'gencral' : 'general',
                    'gencration' : 'generation',
                    'geneial' : 'general',
                    'genera1' : 'general',
                    'generaU' : 'general',
                    'generah' : 'general',
                    'geueral' : 'general',
                    'ghass' : 'glass',
                    'gieat' : 'great',
                    'ginaUy' : 'finally',
                    'giound' : 'ground',
                    'gir1' : 'girl',
                    'girU' : 'girl',
                    'girh' : 'girl',
                    'giv6' : 'give',
                    'giv^e' : 'give',
                    'givc' : 'give',
                    'giæ' : 'give',
                    'glaff' : 'glass',
                    'glafs' : 'glass',
                    'glals' : 'glass',
                    'glrl' : 'girl',
                    'goa1' : 'goal',
                    'goaU' : 'goal',
                    'goah' : 'goal',
                    'gouerniment' : 'government',
                    'gov^ernment' : 'government',
                    'govcrnmcnt' : 'government',
                    'govcrnment' : 'government',
                    'governmcnt' : 'government',
                    'governmeut' : 'government',
                    'gr0und' : 'ground',
                    'gr6und' : 'ground',
                    'gr^eat' : 'great',
                    'grcat' : 'great',
                    'grcen' : 'green',
                    'greai' : 'great',
                    'grecn' : 'green',
                    'greeu' : 'green',
                    'groAv' : 'grow',
                    'groAvth' : 'growth',
                    'gro\v' : 'grow',
                    'gro\vth' : 'growth',
                    'gro^v' : 'grow',
                    'gro^vth' : 'growth',
                    'groiv' : 'grow',
                    'groivth' : 'growth',
                    'grouud' : 'ground',
                    'grov' : 'grow',
                    'grov/th' : 'growth',
                    'growtb' : 'growth',
                    'growtli' : 'growth',
                    'gucss' : 'guess',
                    'guef' : 'guess',
                    'guefs' : 'guess',
                    'guels' : 'guess',
                    'guesf' : 'guess',
                    'h0me' : 'home',
                    'h0use' : 'house',
                    'h1gh' : 'high',
                    'h1mself' : 'himself',
                    'h1story' : 'history',
                    'h6pe' : 'hope',
                    'h6re' : 'here',
                    'h6tel' : 'hotel',
                    'h6wever' : 'however',
                    'h^ard' : 'hard',
                    'h^ave' : 'have',
                    'h^er' : 'her',
                    'h^is' : 'his',
                    'h^it' : 'hit',
                    'h^r' : 'her',
                    'ha1f' : 'half',
                    'ha1r' : 'hair',
                    'ha[)py' : 'happy',
                    'ha\^ng' : 'hang',
                    'ha])pen' : 'happen',
                    'ha])py' : 'happy',
                    'ha^^ng' : 'hang',
                    'ha^ang' : 'hang',
                    'ha^e' : 'have',
                    'ha^ng' : 'hang',
                    'ha^nng' : 'hang',
                    'ha^ve' : 'have',
                    'haby' : 'baby',
                    'hahf' : 'half',
                    'haj)pen' : 'happen',
                    'haj)py' : 'happy',
                    'halr' : 'hair',
                    'hap[)y' : 'happy',
                    'hap])en' : 'happen',
                    'hap])y' : 'happy',
                    'hapj)en' : 'happen',
                    'hapj)y' : 'happy',
                    'happcn' : 'happen',
                    'happv' : 'happy',
                    'hap|)y' : 'happy',
                    'hav6' : 'have',
                    'hav^e' : 'have',
                    'havc' : 'have',
                    'ha|)py' : 'happy',
                    'hcad' : 'head',
                    'hcalth' : 'health',
                    'hcar' : 'hear',
                    'hcart' : 'heart',
                    'hcat' : 'heat',
                    'hcautiful' : 'beautiful',
                    'hcavy' : 'heavy',
                    'hccause' : 'because',
                    'hclp' : 'help',
                    'hcre' : 'here',
                    'hcrfclf' : 'herself',
                    'hcrfelf' : 'herself',
                    'hctween' : 'between',
                    'he1p' : 'help',
                    'heUeve' : 'believe',
                    'he^ad' : 'head',
                    'he^r' : 'her',
                    'hea1th' : 'health',
                    'heai' : 'hear',
                    'heait' : 'heart',
                    'heaiy' : 'heavy',
                    'healtb' : 'health',
                    'healtli' : 'health',
                    'heantiful' : 'beautiful',
                    'heaotiful' : 'beautiful',
                    'heauliful' : 'beautiful',
                    'heautifiil' : 'beautiful',
                    'heautifnl' : 'beautiful',
                    'heautifol' : 'beautiful',
                    'heautiful' : 'beautiful',
                    'heautifull' : 'beautiful',
                    'heav^y' : 'heavy',
                    'hecaiise' : 'because',
                    'hecaufe' : 'because',
                    'hecausc' : 'because',
                    'hecause' : 'because',
                    'hecome' : 'become',
                    'hefore' : 'before',
                    'hegin' : 'begin',
                    'hehavior' : 'behavior',
                    'hehind' : 'behind',
                    'heie' : 'here',
                    'helicve' : 'believe',
                    'helievc' : 'believe',
                    'helieve' : 'believe',
                    'hencfit' : 'benefit',
                    'henefit' : 'benefit',
                    'herc' : 'here',
                    'herfclf' : 'herself',
                    'herfelf' : 'herself',
                    'herfell' : 'herself',
                    'herlelf' : 'herself',
                    'hersclf' : 'herself',
                    'herseU' : 'herself',
                    'herſelſ' : 'herself',
                    'hetiveen' : 'between',
                    'hetwcen' : 'between',
                    'hetwecn' : 'between',
                    'hetweeii' : 'between',
                    'hetween' : 'between',
                    'heyond' : 'beyond',
                    'hfe' : 'life',
                    'hght' : 'light',
                    'hi^s' : 'his',
                    'hi^t' : 'hit',
                    'hieten' : 'listen',
                    'hif' : 'his',
                    'hife' : 'life',
                    'hifee' : 'life',
                    'hiffe' : 'life',
                    'hiflory' : 'history',
                    'hiftorv' : 'history',
                    'hiftory' : 'history',
                    'hig^h' : 'high',
                    'higb' : 'high',
                    'higli' : 'high',
                    'hiife' : 'life',
                    'hiiild' : 'build',
                    'hiiilding' : 'building',
                    'hiisiness' : 'business',
                    'hiiten' : 'listen',
                    'hiitory' : 'history',
                    'hikke' : 'like',
                    'hiltory' : 'history',
                    'him^self' : 'himself',
                    'himfclf' : 'himself',
                    'himfeif' : 'himself',
                    'himfelf' : 'himself',
                    'himfelff' : 'himself',
                    'himfell' : 'himself',
                    'himielf' : 'himself',
                    'himlelf' : 'himself',
                    'himne' : 'line',
                    'himsclf' : 'himself',
                    'himse1f' : 'himself',
                    'himseU' : 'himself',
                    'himseli' : 'himself',
                    'himten' : 'listen',
                    'himſelſ' : 'himself',
                    'hin^e' : 'line',
                    'hinguage' : 'language',
                    'hin|e' : 'line',
                    'hismen' : 'listen',
                    'hispen' : 'listen',
                    'hist0ry' : 'history',
                    'histan' : 'listen',
                    'histin' : 'listen',
                    'histoiy' : 'history',
                    'historv' : 'history',
                    'histun' : 'listen',
                    'hiszen' : 'listen',
                    'hitely' : 'likely',
                    'hiſiory' : 'history',
                    'hiſlory' : 'history',
                    'hiﬁory' : 'history',
                    'hkely' : 'likely',
                    'hlack' : 'black',
                    'hlgh' : 'high',
                    'hlmself' : 'himself',
                    'hlood' : 'blood',
                    'hlstory' : 'history',
                    'hlue' : 'blue',
                    'hmne' : 'line',
                    'hnilding' : 'building',
                    'hnman' : 'human',
                    'hnndred' : 'hundred',
                    'hnoivledge' : 'knowledge',
                    'hnsband' : 'husband',
                    'hnsiness' : 'business',
                    'hnttle' : 'little',
                    'ho1d' : 'hold',
                    'hoAv' : 'how',
                    'hoAvcver' : 'however',
                    'hoAvevcr' : 'however',
                    'ho\vever' : 'however',
                    'ho^t' : 'hot',
                    'ho^vever' : 'however',
                    'ho^w' : 'how',
                    'hoavever' : 'however',
                    'hody' : 'body',
                    'hofpital' : 'hospital',
                    'hohd' : 'hold',
                    'hoiv' : 'how',
                    'hoivever' : 'however',
                    'hoj)e' : 'hope',
                    'holpital' : 'hospital',
                    'homc' : 'home',
                    'honr' : 'hour',
                    'hopc' : 'hope',
                    'hos[)ital' : 'hospital',
                    'hos])ital' : 'hospital',
                    'hosi)ital' : 'hospital',
                    'hosj)ital' : 'hospital',
                    'hosp1tal' : 'hospital',
                    'hospita1' : 'hospital',
                    'hospitaU' : 'hospital',
                    'hotcl' : 'hotel',
                    'hote1' : 'hotel',
                    'hoteh' : 'hotel',
                    'hoth' : 'both',
                    'houfc' : 'house',
                    'houfe' : 'house',
                    'houffe' : 'house',
                    'houie' : 'house',
                    'housc' : 'house',
                    'hov/ever' : 'however',
                    'hov^^ever' : 'however',
                    'hov^ever' : 'however',
                    'hovever' : 'however',
                    'howcvcr' : 'however',
                    'howcver' : 'however',
                    'howeier' : 'however',
                    'howev^er' : 'however',
                    'howevcr' : 'however',
                    'howevei' : 'however',
                    'hreak' : 'break',
                    'hring' : 'bring',
                    'hrothcr' : 'brother',
                    'hrother' : 'brother',
                    'hsten' : 'listen',
                    'httle' : 'little',
                    'hudget' : 'budget',
                    'hufband' : 'husband',
                    'hufhand' : 'husband',
                    'hufinefs' : 'business',
                    'huiband' : 'husband',
                    'huild' : 'build',
                    'huilding' : 'building',
                    'huildiug' : 'building',
                    'hujhand' : 'husband',
                    'hulband' : 'husband',
                    'humau' : 'human',
                    'hundrcd' : 'hundred',
                    'hushand' : 'husband',
                    'husincss' : 'business',
                    'husinefs' : 'business',
                    'husines' : 'business',
                    'husiness' : 'business',
                    'husiuess' : 'business',
                    'huudred' : 'hundred',
                    'huſhand' : 'husband',
                    'hösten' : 'listen',
                    'i)Oor' : 'poor',
                    'i)Osition' : 'position',
                    'i)Ut' : 'put',
                    'i)ainting' : 'painting',
                    'i)aper' : 'paper',
                    'i)articular' : 'particular',
                    'i)articularly' : 'particularly',
                    'i)artner' : 'partner',
                    'i)arty' : 'party',
                    'i)atient' : 'patient',
                    'i)ay' : 'pay',
                    'i)eace' : 'peace',
                    'i)en' : 'open',
                    'i)eople' : 'people',
                    'i)er' : 'per',
                    'i)erform' : 'perform',
                    'i)erformance' : 'performance',
                    'i)erhaps' : 'perhaps',
                    'i)eriod' : 'period',
                    'i)erson' : 'person',
                    'i)ersonal' : 'personal',
                    'i)hysical' : 'physical',
                    'i)icture' : 'picture',
                    'i)lace' : 'place',
                    'i)lan' : 'plan',
                    'i)oint' : 'point',
                    'i)olice' : 'police',
                    'i)olicy' : 'policy',
                    'i)olitical' : 'political',
                    'i)olitics' : 'politics',
                    'i)oor' : 'poor',
                    'i)opular' : 'popular',
                    'i)opulation' : 'population',
                    'i)osition' : 'position',
                    'i)ossible' : 'possible',
                    'i)ractice' : 'practice',
                    'i)repare' : 'prepare',
                    'i)rescnt' : 'present',
                    'i)resent' : 'present',
                    'i)reseut' : 'present',
                    'i)resident' : 'president',
                    'i)ressure' : 'pressure',
                    'i)retty' : 'pretty',
                    'i)revent' : 'prevent',
                    'i)rice' : 'price',
                    'i)rivate' : 'private',
                    'i)robably' : 'probably',
                    'i)rocess' : 'process',
                    'i)roduce' : 'produce',
                    'i)roduct' : 'product',
                    'i)roduction' : 'production',
                    'i)roperty' : 'property',
                    'i)rotect' : 'protect',
                    'i)rove' : 'prove',
                    'i)rovide' : 'provide',
                    'i)ublic' : 'public',
                    'i)urpose' : 'purpose',
                    'i)ut' : 'put',
                    'iSee' : 'see',
                    'iVote' : 'vote',
                    'i^n' : 'in',
                    'i^t' : 'it',
                    'i^ts' : 'its',
                    'iave' : 'save',
                    'idca' : 'idea',
                    'identifv' : 'identify',
                    'ieveral' : 'several',
                    'iffue' : 'issue',
                    'iflue' : 'issue',
                    'ifsue' : 'issue',
                    'ifue' : 'issue',
                    'ihan' : 'than',
                    'ihare' : 'share',
                    'ihat' : 'that',
                    'iheir' : 'their',
                    'ihem' : 'them',
                    'ihese' : 'these',
                    'ihey' : 'they',
                    'ihing' : 'thing',
                    'ihink' : 'think',
                    'ihird' : 'third',
                    'ihort' : 'short',
                    'ihose' : 'those',
                    'ihot' : 'shot',
                    'ihough' : 'though',
                    'ihould' : 'should',
                    'ihrough' : 'through',
                    'ihus' : 'thus',
                    'ii])on' : 'upon',
                    'iield' : 'field',
                    'iii)on' : 'upon',
                    'iince' : 'since',
                    'iirft' : 'first',
                    'iirst' : 'first',
                    'ikill' : 'skill',
                    'iliould' : 'should',
                    'ilsue' : 'issue',
                    'iltuation' : 'situation',
                    'im[)ortant' : 'important',
                    'im])ortant' : 'important',
                    'imagc' : 'image',
                    'imaginc' : 'imagine',
                    'imall' : 'small',
                    'imi)ortant' : 'important',
                    'imi)rove' : 'improve',
                    'imj)ortant' : 'important',
                    'imp0rtant' : 'important',
                    'imp6rtant' : 'important',
                    'impacl' : 'impact',
                    'improvc' : 'improve',
                    'im|)ortant' : 'important',
                    'in^to' : 'into',
                    'inc1uding' : 'including',
                    'inclnding' : 'including',
                    'includ1ng' : 'including',
                    'includc' : 'include',
                    'incrcafc' : 'increase',
                    'incrcafe' : 'increase',
                    'incrcase' : 'increase',
                    'increafc' : 'increase',
                    'increafe' : 'increase',
                    'increale' : 'increase',
                    'increasc' : 'increase',
                    'ind1vidual' : 'individual',
                    'indced' : 'indeed',
                    'indecd' : 'indeed',
                    'indicatc' : 'indicate',
                    'individua1' : 'individual',
                    'induflry' : 'industry',
                    'induftry' : 'industry',
                    'indultry' : 'industry',
                    'industrv' : 'industry',
                    'induſlry' : 'industry',
                    'inf0rmati0n' : 'information',
                    'infidc' : 'inside',
                    'infide' : 'inside',
                    'inflcad' : 'instead',
                    'inflead' : 'instead',
                    'informat1on' : 'information',
                    'inftcad' : 'instead',
                    'inftead' : 'instead',
                    'inftitution' : 'institution',
                    'inlide' : 'inside',
                    'inlo' : 'into',
                    'inltead' : 'instead',
                    'inltitution' : 'institution',
                    'insistment' : 'investment',
                    'inst1tut1on' : 'institution',
                    'inst1tution' : 'institution',
                    'instcad' : 'instead',
                    'institut1on' : 'institution',
                    'instituti0n' : 'institution',
                    'int0' : 'into',
                    'int6' : 'into',
                    'intcrcft' : 'interest',
                    'intcrcst' : 'interest',
                    'intcreft' : 'interest',
                    'intcrefting' : 'interesting',
                    'intcrest' : 'interest',
                    'intcresting' : 'interesting',
                    'intercfl' : 'interest',
                    'intercft' : 'interest',
                    'intercfting' : 'interesting',
                    'intercst' : 'interest',
                    'intercsting' : 'interesting',
                    'interefl' : 'interest',
                    'interefling' : 'interesting',
                    'intereft' : 'interest',
                    'interefting' : 'interesting',
                    'interelt' : 'interest',
                    'interelting' : 'interesting',
                    'interest1ng' : 'interesting',
                    'intereſl' : 'interest',
                    'internationa1' : 'international',
                    'intervicw' : 'interview',
                    'interviev' : 'interview',
                    'inveftment' : 'investment',
                    'inﬁde' : 'inside',
                    'ioice' : 'voice',
                    'iome' : 'some',
                    'iong' : 'song',
                    'iove' : 'love',
                    'ipeak' : 'speak',
                    'iriend' : 'friend',
                    'irue' : 'true',
                    'isfue' : 'issue',
                    'islue' : 'issue',
                    'issne' : 'issue',
                    'issuc' : 'issue',
                    'it^s' : 'its',
                    'itand' : 'stand',
                    'itcm' : 'item',
                    'itf' : 'its',
                    'itfclf' : 'itself',
                    'itfelf' : 'itself',
                    'itfell' : 'itself',
                    'itff' : 'its',
                    'itill' : 'still',
                    'itlelf' : 'itself',
                    'itrong' : 'strong',
                    'itsclf' : 'itself',
                    'itse1f' : 'itself',
                    'itsell' : 'itself',
                    'itſelſ' : 'itself',
                    'iudeed' : 'indeed',
                    'iure' : 'sure',
                    'iuterest' : 'interest',
                    'iuto' : 'into',
                    'ivait' : 'wait',
                    'ivalk' : 'walk',
                    'ivall' : 'wall',
                    'ivatch' : 'watch',
                    'ivater' : 'water',
                    'ivear' : 'wear',
                    'iveek' : 'week',
                    'iveight' : 'weight',
                    'ivell' : 'well',
                    'ivestern' : 'western',
                    'ivhat' : 'what',
                    'ivhatever' : 'whatever',
                    'ivhen' : 'when',
                    'ivhether' : 'whether',
                    'ivhich' : 'which',
                    'ivhile' : 'while',
                    'ivhite' : 'white',
                    'ivho' : 'who',
                    'ivhofe' : 'whose',
                    'ivhole' : 'whole',
                    'ivhom' : 'whom',
                    'ivhose' : 'whose',
                    'ivhy' : 'why',
                    'ivife' : 'wife',
                    'ivilhout' : 'without',
                    'ivill' : 'will',
                    'ivind' : 'wind',
                    'ivindow' : 'window',
                    'ivish' : 'wish',
                    'ivitbout' : 'without',
                    'ivith' : 'with',
                    'ivithin' : 'within',
                    'ivithoiit' : 'without',
                    'ivithont' : 'without',
                    'ivithout' : 'without',
                    'ivitliout' : 'without',
                    'ivliere' : 'where',
                    'ivliich' : 'which',
                    'ivliite' : 'white',
                    'ivliole' : 'whole',
                    'ivoman' : 'woman',
                    'ivonder' : 'wonder',
                    'ivord' : 'word',
                    'ivork' : 'work',
                    'ivorld' : 'world',
                    'ivould' : 'would',
                    'ivrite' : 'write',
                    'ivriter' : 'writer',
                    'ivrong' : 'wrong',
                    'j)0ssible' : 'possible',
                    'j)0wer' : 'power',
                    'j)Oor' : 'poor',
                    'j)Osition' : 'position',
                    'j)Ositive' : 'positive',
                    'j)Ossible' : 'possible',
                    'j)Ower' : 'power',
                    'j)age' : 'page',
                    'j)ainting' : 'painting',
                    'j)arent' : 'parent',
                    'j)art' : 'part',
                    'j)articular' : 'particular',
                    'j)articularly' : 'particularly',
                    'j)artner' : 'partner',
                    'j)arty' : 'party',
                    'j)ass' : 'pass',
                    'j)ast' : 'past',
                    'j)atient' : 'patient',
                    'j)attern' : 'pattern',
                    'j)cace' : 'peace',
                    'j)cople' : 'people',
                    'j)crhaps' : 'perhaps',
                    'j)criod' : 'period',
                    'j)crson' : 'person',
                    'j)eace' : 'peace',
                    'j)en' : 'open',
                    'j)eo])le' : 'people',
                    'j)eoi)le' : 'people',
                    'j)eoj)le' : 'people',
                    'j)eopIe' : 'people',
                    'j)eoplc' : 'people',
                    'j)eople' : 'people',
                    'j)erform' : 'perform',
                    'j)erformance' : 'performance',
                    'j)erhaps' : 'perhaps',
                    'j)eriod' : 'period',
                    'j)erliaps' : 'perhaps',
                    'j)erson' : 'person',
                    'j)ersonal' : 'personal',
                    'j)hysical' : 'physical',
                    'j)ick' : 'pick',
                    'j)icture' : 'picture',
                    'j)iece' : 'piece',
                    'j)lacc' : 'place',
                    'j)lace' : 'place',
                    'j)lan' : 'plan',
                    'j)lant' : 'plant',
                    'j)lay' : 'play',
                    'j)nblic' : 'public',
                    'j)nrpose' : 'purpose',
                    'j)olice' : 'police',
                    'j)olicy' : 'policy',
                    'j)olitical' : 'political',
                    'j)olitics' : 'politics',
                    'j)oor' : 'poor',
                    'j)opular' : 'popular',
                    'j)opulation' : 'population',
                    'j)osition' : 'position',
                    'j)ositive' : 'positive',
                    'j)ossible' : 'possible',
                    'j)owcr' : 'power',
                    'j)ower' : 'power',
                    'j)ractice' : 'practice',
                    'j)rcsent' : 'present',
                    'j)repare' : 'prepare',
                    'j)rescnt' : 'present',
                    'j)resent' : 'present',
                    'j)reseut' : 'present',
                    'j)resident' : 'president',
                    'j)ressure' : 'pressure',
                    'j)retty' : 'pretty',
                    'j)revent' : 'prevent',
                    'j)rice' : 'price',
                    'j)rivate' : 'private',
                    'j)robably' : 'probably',
                    'j)roblem' : 'problem',
                    'j)rocess' : 'process',
                    'j)roduce' : 'produce',
                    'j)roduct' : 'product',
                    'j)roduction' : 'production',
                    'j)rofessional' : 'professional',
                    'j)rofessor' : 'professor',
                    'j)roj)erty' : 'property',
                    'j)roject' : 'project',
                    'j)ropcrty' : 'property',
                    'j)roperty' : 'property',
                    'j)rotect' : 'protect',
                    'j)rove' : 'prove',
                    'j)rovide' : 'provide',
                    'j)ublic' : 'public',
                    'j)uhlic' : 'public',
                    'j)ul)lic' : 'public',
                    'j)ull' : 'pull',
                    'j)urpose' : 'purpose',
                    'j)ush' : 'push',
                    'j0in' : 'join',
                    'jLTHOUGH' : 'although',
                    'jPUBLIC' : 'public',
                    'j^that' : 'that',
                    'j^uhlic' : 'public',
                    'j^ust' : 'just',
                    'jbort' : 'short',
                    'jbot' : 'shot',
                    'jbould' : 'should',
                    'jhake' : 'shake',
                    'jhare' : 'share',
                    'jhoot' : 'shoot',
                    'jhort' : 'short',
                    'jhot' : 'shot',
                    'jhould' : 'should',
                    'jhow' : 'show',
                    'jufl' : 'just',
                    'juft' : 'just',
                    'jult' : 'just',
                    'jus^t' : 'just',
                    'jusi' : 'just',
                    'juſi' : 'just',
                    'juſl' : 'just',
                    'jvhether' : 'whether',
                    'jvithout' : 'without',
                    'jx)litical' : 'political',
                    'jx)sition' : 'position',
                    'jx)ssible' : 'possible',
                    'k1ll' : 'kill',
                    'k1tchen' : 'kitchen',
                    'kcep' : 'keep',
                    'kecp' : 'keep',
                    'kiUi' : 'kill',
                    'kil1' : 'kill',
                    'kin^d' : 'kind',
                    'kitcben' : 'kitchen',
                    'kiud' : 'kind',
                    'klll' : 'kill',
                    'klnd' : 'kind',
                    'kltchen' : 'kitchen',
                    'knavledge' : 'knowledge',
                    'knmvledge' : 'knowledge',
                    'knoAv' : 'know',
                    'knoAvlcdge' : 'knowledge',
                    'knoAvledgc' : 'knowledge',
                    'knoAvledge' : 'knowledge',
                    'kno\v' : 'know',
                    'kno\vledge' : 'knowledge',
                    'kno^v' : 'know',
                    'kno^vledge' : 'knowledge',
                    'knoavledge' : 'knowledge',
                    'knoiv' : 'know',
                    'knoivlcdge' : 'knowledge',
                    'knoivledgc' : 'knowledge',
                    'knoivledge' : 'knowledge',
                    'knorvledge' : 'knowledge',
                    'knosvledge' : 'knowledge',
                    'knotvledge' : 'knowledge',
                    'knov/ledge' : 'knowledge',
                    'knov^ledge' : 'knowledge',
                    'knovdedge' : 'knowledge',
                    'knovi^ledge' : 'knowledge',
                    'knoviledge' : 'knowledge',
                    'knovjledge' : 'knowledge',
                    'knovledge' : 'knowledge',
                    'knovrledge' : 'knowledge',
                    'knovv^ledge' : 'knowledge',
                    'knovvledge' : 'knowledge',
                    'knovyledge' : 'knowledge',
                    'know1edge' : 'knowledge',
                    'knowUdge' : 'knowledge',
                    'knowlcdge' : 'knowledge',
                    'knowledg^e' : 'knowledge',
                    'knowledgc' : 'knowledge',
                    'knoxvledge' : 'knowledge',
                    'knozvledge' : 'knowledge',
                    'kno»v' : 'know',
                    'kter^m' : 'term',
                    'kuoAvledge' : 'knowledge',
                    'kuow' : 'know',
                    'l)arty' : 'party',
                    'l)eople' : 'people',
                    'l)eriod' : 'period',
                    'l)lay' : 'play',
                    'l)oor' : 'poor',
                    'l)osition' : 'position',
                    'l)resent' : 'present',
                    'l)rivate' : 'private',
                    'l)roperty' : 'property',
                    'l)ublic' : 'public',
                    'l)urpose' : 'purpose',
                    'l0cal' : 'local',
                    'l0ng' : 'long',
                    'l0ss' : 'loss',
                    'l0ve' : 'love',
                    'l1fe' : 'life',
                    'l1ght' : 'light',
                    'l1ke' : 'like',
                    'l1kely' : 'likely',
                    'l1ne' : 'line',
                    'l1st' : 'list',
                    'l1ttle' : 'little',
                    'l1ve' : 'live',
                    'l6ft' : 'left',
                    'l6ng' : 'long',
                    'l6ss' : 'less',
                    'l6ve' : 'love',
                    'lOv' : 'low',
                    'l^and' : 'land',
                    'l^ast' : 'last',
                    'l^ate' : 'late',
                    'l^aw' : 'law',
                    'l^ay' : 'lay',
                    'l^eg' : 'leg',
                    'l^et' : 'let',
                    'l^etter' : 'letter',
                    'l^ie' : 'lie',
                    'l^ife' : 'life',
                    'l^ike' : 'like',
                    'l^ine' : 'line',
                    'l^ive' : 'live',
                    'l^ong' : 'long',
                    'l^ook' : 'look',
                    'l^ot' : 'lot',
                    'l^ove' : 'love',
                    'l^ow' : 'low',
                    'la3t' : 'last',
                    'la8t' : 'last',
                    'laAv' : 'law',
                    'laAvyer' : 'lawyer',
                    'la\vyer' : 'lawyer',
                    'la^vyer' : 'lawyer',
                    'lafe' : 'safe',
                    'lafft' : 'last',
                    'laft' : 'last',
                    'laige' : 'large',
                    'laiv' : 'law',
                    'laivyer' : 'lawyer',
                    'lale' : 'late',
                    'lamily' : 'family',
                    'lan3' : 'land',
                    'langh' : 'laugh',
                    'langnage' : 'language',
                    'languagc' : 'language',
                    'lar9e' : 'large',
                    'larg^e' : 'large',
                    'largc' : 'large',
                    'latc' : 'late',
                    'latcr' : 'later',
                    'latei' : 'later',
                    'laugb' : 'laugh',
                    'laugli' : 'laugh',
                    'lawjer' : 'lawyer',
                    'lawver' : 'lawyer',
                    'laſi' : 'last',
                    'laſl' : 'last',
                    'lcad' : 'lead',
                    'lcader' : 'leader',
                    'lcaft' : 'least',
                    'lcarn' : 'learn',
                    'lcast' : 'least',
                    'lcave' : 'leave',
                    'lcene' : 'scene',
                    'lcft' : 'left',
                    'lchool' : 'school',
                    'lcience' : 'science',
                    'lcss' : 'less',
                    'lcttcr' : 'letter',
                    'lctter' : 'letter',
                    'lcvel' : 'level',
                    'ldentify' : 'identify',
                    'le9al' : 'legal',
                    'leadcr' : 'leader',
                    'leafl' : 'least',
                    'leaft' : 'least',
                    'leait' : 'least',
                    'lealt' : 'least',
                    'learu' : 'learn',
                    'leason' : 'season',
                    'leav^e' : 'leave',
                    'leavc' : 'leave',
                    'leaye' : 'leave',
                    'leaſl' : 'least',
                    'lecond' : 'second',
                    'lecurity' : 'security',
                    'leff' : 'less',
                    'leffs' : 'less',
                    'lefl' : 'left',
                    'lefs' : 'less',
                    'lega1' : 'legal',
                    'legai' : 'legal',
                    'lell' : 'tell',
                    'lenior' : 'senior',
                    'lerious' : 'serious',
                    'lerve' : 'serve',
                    'lervice' : 'service',
                    'les3' : 'less',
                    'les8' : 'less',
                    'lesf' : 'less',
                    'lettcr' : 'letter',
                    'lettei' : 'letter',
                    'levcl' : 'level',
                    'leve1' : 'level',
                    'levei' : 'level',
                    'leveral' : 'several',
                    'leyel' : 'level',
                    'leﬁ' : 'left',
                    'lftter' : 'letter',
                    'lhake' : 'shake',
                    'lhan' : 'than',
                    'lhare' : 'share',
                    'lhat' : 'that',
                    'lheir' : 'their',
                    'lhem' : 'them',
                    'lhey' : 'they',
                    'lhoot' : 'shoot',
                    'lhort' : 'short',
                    'lhot' : 'shot',
                    'lhould' : 'should',
                    'lhoulder' : 'shoulder',
                    'lhow' : 'show',
                    'li3t' : 'list',
                    'li8t' : 'list',
                    'liaVe' : 'have',
                    'lia\e' : 'leave',
                    'liair' : 'hair',
                    'lialf' : 'half',
                    'liand' : 'hand',
                    'liang' : 'hang',
                    'liappen' : 'happen',
                    'liappy' : 'happy',
                    'liav' : 'have',
                    'liave' : 'have',
                    'liead' : 'head',
                    'liealth' : 'health',
                    'liear' : 'hear',
                    'lieart' : 'heart',
                    'lieat' : 'heat',
                    'lieavy' : 'heavy',
                    'lielp' : 'help',
                    'liere' : 'here',
                    'lierself' : 'herself',
                    'lifc' : 'life',
                    'liflen' : 'listen',
                    'liftcn' : 'listen',
                    'liften' : 'listen',
                    'lig^ht' : 'light',
                    'ligbt' : 'light',
                    'ligiit' : 'light',
                    'liglit' : 'light',
                    'lignificant' : 'significant',
                    'liiftory' : 'history',
                    'liigh' : 'high',
                    'liim' : 'him',
                    'liimfelf' : 'himself',
                    'liimsclf' : 'himself',
                    'liimself' : 'himself',
                    'liis' : 'his',
                    'liistorv' : 'history',
                    'liistory' : 'history',
                    'likc' : 'like',
                    'likclv' : 'likely',
                    'likcly' : 'likely',
                    'likeiy' : 'likely',
                    'likelj' : 'likely',
                    'likelv' : 'likely',
                    'lilten' : 'listen',
                    'liltle' : 'little',
                    'limilar' : 'similar',
                    'limple' : 'simple',
                    'limself' : 'himself',
                    'lin3' : 'line',
                    'linal' : 'final',
                    'lince' : 'since',
                    'lingle' : 'single',
                    'liold' : 'hold',
                    'liome' : 'home',
                    'liope' : 'hope',
                    'liospital' : 'hospital',
                    'liotel' : 'hotel',
                    'lioufe' : 'house',
                    'liour' : 'hour',
                    'liouse' : 'house',
                    'liowever' : 'however',
                    'lirft' : 'first',
                    'lirst' : 'first',
                    'listcn' : 'listen',
                    'litt1e' : 'little',
                    'littic' : 'little',
                    'littie' : 'little',
                    'littlc' : 'little',
                    'lituation' : 'situation',
                    'liuge' : 'huge',
                    'liuman' : 'human',
                    'liundred' : 'hundred',
                    'liusband' : 'husband',
                    'liv^e' : 'live',
                    'livc' : 'live',
                    'liye' : 'live',
                    'llght' : 'light',
                    'llttie' : 'little',
                    'lmage' : 'image',
                    'lmall' : 'small',
                    'lmile' : 'smile',
                    'lmpact' : 'impact',
                    'lmportant' : 'important',
                    'lmprove' : 'improve',
                    'lncluding' : 'including',
                    'lncludlng' : 'including',
                    'lncrease' : 'increase',
                    'lndeed' : 'indeed',
                    'lndividual' : 'individual',
                    'lndustry' : 'industry',
                    'lnformation' : 'information',
                    'lnformatlon' : 'information',
                    'lnstead' : 'instead',
                    'lnstitution' : 'institution',
                    'lnterest' : 'interest',
                    'lnteresting' : 'interesting',
                    'lntereſt' : 'interest',
                    'lntereﬅ' : 'interest',
                    'lnternational' : 'international',
                    'lnto' : 'into',
                    'lnvestment' : 'investment',
                    'loAv' : 'low',
                    'loca1' : 'local',
                    'locai' : 'local',
                    'locial' : 'social',
                    'lociety' : 'society',
                    'loeal' : 'local',
                    'lofe' : 'lose',
                    'loff' : 'loss',
                    'loffe' : 'lose',
                    'loffs' : 'loss',
                    'lofs' : 'loss',
                    'loie' : 'lose',
                    'loiv' : 'low',
                    'loldier' : 'soldier',
                    'lomething' : 'something',
                    'lometimes' : 'sometimes',
                    'lon8' : 'long',
                    'lon9' : 'long',
                    'lorce' : 'force',
                    'los3' : 'loss',
                    'losf' : 'loss',
                    'loug' : 'long',
                    'lource' : 'source',
                    'louthern' : 'southern',
                    'lov^e' : 'love',
                    'lovc' : 'love',
                    'lpace' : 'space',
                    'lpeak' : 'speak',
                    'lpecial' : 'special',
                    'lpeech' : 'speech',
                    'lport' : 'sport',
                    'lpring' : 'spring',
                    'lrom' : 'from',
                    'lssue' : 'issue',
                    'ltage' : 'stage',
                    'ltand' : 'stand',
                    'ltate' : 'state',
                    'ltay' : 'stay',
                    'ltep' : 'step',
                    'ltil' : 'still',
                    'ltill' : 'still',
                    'ltock' : 'stock',
                    'ltop' : 'stop',
                    'ltrong' : 'strong',
                    'ltself' : 'itself',
                    'ltudy' : 'study',
                    'ltyle' : 'style',
                    'lubject' : 'subject',
                    'luccess' : 'success',
                    'luch' : 'such',
                    'luddenly' : 'suddenly',
                    'luffer' : 'suffer',
                    'lummer' : 'summer',
                    'lupport' : 'support',
                    'lurface' : 'surface',
                    'lystem' : 'system',
                    'm0dern' : 'modern',
                    'm0ney' : 'money',
                    'm0re' : 'more',
                    'm0st' : 'most',
                    'm1ddle' : 'middle',
                    'm1ght' : 'might',
                    'm1l1tary' : 'military',
                    'm1litary' : 'military',
                    'm1llion' : 'million',
                    'm1nute' : 'minute',
                    'm1ss' : 'miss',
                    'm1ss1on' : 'mission',
                    'm1ssion' : 'mission',
                    'm6dical' : 'medical',
                    'm6ment' : 'moment',
                    'm6ney' : 'money',
                    'm6rning' : 'morning',
                    'm6st' : 'most',
                    'm6ther' : 'mother',
                    'mUUon' : 'million',
                    'mUitary' : 'military',
                    'm^ake' : 'make',
                    'm^an' : 'man',
                    'm^any' : 'many',
                    'm^ay' : 'may',
                    'm^dicale' : 'medical',
                    'm^ore' : 'more',
                    'm^ost' : 'most',
                    'm^ust' : 'must',
                    'm^y' : 'my',
                    'macbine' : 'machine',
                    'machinc' : 'machine',
                    'magaz1ne' : 'magazine',
                    'magazinc' : 'magazine',
                    'maj^or' : 'major',
                    'major1ty' : 'majority',
                    'majoritv' : 'majority',
                    'makc' : 'make',
                    'maln' : 'main',
                    'managc' : 'manage',
                    'managcment' : 'management',
                    'managemcnt' : 'management',
                    'manv' : 'many',
                    'markcl' : 'market',
                    'markct' : 'market',
                    'marr1age' : 'marriage',
                    'marriagc' : 'marriage',
                    'marrlage' : 'marriage',
                    'matcrial' : 'material',
                    'mater1al' : 'material',
                    'materia1' : 'material',
                    'materiaU' : 'material',
                    'materiah' : 'material',
                    'mattcr' : 'matter',
                    'mavbe' : 'maybe',
                    'mayhe' : 'maybe',
                    'mcafurc' : 'measure',
                    'mcafure' : 'measure',
                    'mcan' : 'mean',
                    'mcasure' : 'measure',
                    'mccting' : 'meeting',
                    'mcdia' : 'media',
                    'mcdical' : 'medical',
                    'mcet' : 'meet',
                    'mceting' : 'meeting',
                    'mcflage' : 'message',
                    'mclhod' : 'method',
                    'mcmbcr' : 'member',
                    'mcmber' : 'member',
                    'mcmorv' : 'memory',
                    'mcmory' : 'memory',
                    'mcntion' : 'mention',
                    'mcthod' : 'method',
                    'mdeed' : 'indeed',
                    'meafurc' : 'measure',
                    'meafure' : 'measure',
                    'mealure' : 'measure',
                    'measurc' : 'measure',
                    'mect' : 'meet',
                    'mecting' : 'meeting',
                    'med1cal' : 'medical',
                    'medica1' : 'medical',
                    'medla' : 'media',
                    'meet1ng' : 'meeting',
                    'meetmg' : 'meeting',
                    'meffage' : 'message',
                    'meflage' : 'message',
                    'mefsage' : 'message',
                    'membcr' : 'member',
                    'memher' : 'member',
                    'memoiy' : 'memory',
                    'memorv' : 'memory',
                    'ment1on' : 'mention',
                    'mesfage' : 'message',
                    'meslage' : 'message',
                    'messagc' : 'message',
                    'metbod' : 'method',
                    'meth0d' : 'method',
                    'metliod' : 'method',
                    'miUion' : 'million',
                    'miUtary' : 'military',
                    'midd1e' : 'middle',
                    'middlc' : 'middle',
                    'midiUe' : 'middle',
                    'midtUe' : 'middle',
                    'miffion' : 'mission',
                    'miflion' : 'mission',
                    'mifs' : 'miss',
                    'mifsion' : 'mission',
                    'mig^ht' : 'might',
                    'migbt' : 'might',
                    'mighl' : 'might',
                    'miglit' : 'might',
                    'mihtary' : 'military',
                    'mil1ion' : 'million',
                    'mil1tary' : 'military',
                    'militaiy' : 'military',
                    'militarv' : 'military',
                    'minutc' : 'minute',
                    'misf' : 'miss',
                    'mislion' : 'mission',
                    'miss1on' : 'mission',
                    'miud' : 'mind',
                    'miuion' : 'million',
                    'miſlion' : 'mission',
                    'mlddle' : 'middle',
                    'mlght' : 'might',
                    'mlnd' : 'mind',
                    'mlss' : 'miss',
                    'mnsic' : 'music',
                    'modcl' : 'model',
                    'modcrn' : 'modern',
                    'mode1' : 'model',
                    'moft' : 'most',
                    'moie' : 'more',
                    'moit' : 'most',
                    'momcnt' : 'moment',
                    'moncy' : 'money',
                    'monev' : 'money',
                    'montb' : 'month',
                    'montli' : 'month',
                    'mor^e' : 'more',
                    'morc' : 'more',
                    'morn1ng' : 'morning',
                    'morniug' : 'morning',
                    'mornmg' : 'morning',
                    'moruing' : 'morning',
                    'mos^t' : 'most',
                    'motber' : 'mother',
                    'mothcr' : 'mother',
                    'mothei' : 'mother',
                    'motlier' : 'mother',
                    'mouey' : 'money',
                    'moutb' : 'mouth',
                    'moutli' : 'mouth',
                    'movc' : 'move',
                    'movcment' : 'movement',
                    'movemcnt' : 'movement',
                    'moſl' : 'most',
                    'mterest' : 'interest',
                    'muUion' : 'million',
                    'mucb' : 'much',
                    'mucli' : 'much',
                    'mueh' : 'much',
                    'mufft' : 'must',
                    'mufic' : 'music',
                    'muft' : 'must',
                    'mulic' : 'music',
                    'mus1c' : 'music',
                    'mus^t' : 'must',
                    'muslc' : 'music',
                    'muſl' : 'must',
                    'muﬁc' : 'music',
                    'mvfelf' : 'myself',
                    'mvsclf' : 'myself',
                    'mvself' : 'myself',
                    'myfclf' : 'myself',
                    'myfelf' : 'myself',
                    'myfell' : 'myself',
                    'mylelf' : 'myself',
                    'mysclf' : 'myself',
                    'mysell' : 'myself',
                    'myſelſ' : 'myself',
                    'n0rth' : 'north',
                    'n0te' : 'note',
                    'n1ce' : 'nice',
                    'n1ght' : 'night',
                    'n6rth' : 'north',
                    'n6thing' : 'nothing',
                    'n^ew' : 'new',
                    'n^ight' : 'night',
                    'n^o' : 'no',
                    'n^or' : 'nor',
                    'n^ot' : 'not',
                    'nam6' : 'name',
                    'nam^e' : 'name',
                    'namc' : 'name',
                    'nat1on' : 'nation',
                    'nat1onal' : 'national',
                    'nati0n' : 'nation',
                    'nati0nal' : 'national',
                    'nationa1' : 'national',
                    'natlon' : 'nation',
                    'natnral' : 'natural',
                    'natnre' : 'nature',
                    'natuie' : 'nature',
                    'natura1' : 'natural',
                    'naturaU' : 'natural',
                    'naturah' : 'natural',
                    'naturc' : 'nature',
                    'ncAvspaper' : 'newspaper',
                    'ncar' : 'near',
                    'ncarlv' : 'nearly',
                    'ncarly' : 'nearly',
                    'ncceffary' : 'necessary',
                    'ncceflary' : 'necessary',
                    'nccessarv' : 'necessary',
                    'nccessary' : 'necessary',
                    'nced' : 'need',
                    'ncver' : 'never',
                    'ncws' : 'news',
                    'ncwspaper' : 'newspaper',
                    'ncxt' : 'next',
                    'neAv' : 'new',
                    'neAvs' : 'news',
                    'neAvspaper' : 'newspaper',
                    'ne\vs' : 'news',
                    'ne^vs' : 'news',
                    'neai' : 'near',
                    'neaily' : 'nearly',
                    'near1y' : 'nearly',
                    'nearlv' : 'nearly',
                    'neccffary' : 'necessary',
                    'neccflary' : 'necessary',
                    'neccssarv' : 'necessary',
                    'neccssary' : 'necessary',
                    'necd' : 'need',
                    'necefary' : 'necessary',
                    'neceffary' : 'necessary',
                    'necefiary' : 'necessary',
                    'neceflarv' : 'necessary',
                    'neceflary' : 'necessary',
                    'necefsary' : 'necessary',
                    'necellary' : 'necessary',
                    'necelsary' : 'necessary',
                    'necesfary' : 'necessary',
                    'neceslary' : 'necessary',
                    'necessaiy' : 'necessary',
                    'necessarv' : 'necessary',
                    'neceſlary' : 'necessary',
                    'neceﬁary' : 'necessary',
                    'neier' : 'never',
                    'neiv' : 'new',
                    'neivspaper' : 'newspaper',
                    'nev/s' : 'news',
                    'nevS' : 'news',
                    'nev^er' : 'never',
                    'nevcr' : 'never',
                    'nevei' : 'never',
                    'nevs' : 'news',
                    'newf' : 'news',
                    'newfpaper' : 'newspaper',
                    'newl' : 'news',
                    'news])aper' : 'newspaper',
                    'newsi)aper' : 'newspaper',
                    'newsj)aper' : 'newspaper',
                    'newspa])er' : 'newspaper',
                    'newspai)er' : 'newspaper',
                    'newspaj)er' : 'newspaper',
                    'nicc' : 'nice',
                    'nig^ht' : 'night',
                    'nigbt' : 'night',
                    'niglit' : 'night',
                    'niimher' : 'number',
                    'nlce' : 'nice',
                    'nlght' : 'night',
                    'nnder' : 'under',
                    'nntil' : 'until',
                    'noith' : 'north',
                    'noiv' : 'now',
                    'non6' : 'none',
                    'nonc' : 'none',
                    'norlh' : 'north',
                    'nortb' : 'north',
                    'nortli' : 'north',
                    'not1ce' : 'notice',
                    'not6' : 'note',
                    'not^e' : 'note',
                    'notbing' : 'nothing',
                    'notbyng' : 'nothing',
                    'notc' : 'note',
                    'noth1ng' : 'nothing',
                    'nothiug' : 'nothing',
                    'nothlng' : 'nothing',
                    'nothmg' : 'nothing',
                    'noticc' : 'notice',
                    'notlce' : 'notice',
                    'notliing' : 'nothing',
                    'nuinher' : 'number',
                    'numbcr' : 'number',
                    'numbei' : 'number',
                    'numher' : 'number',
                    'nund^er' : 'under',
                    'nvithout' : 'without',
                    'oAvn' : 'own',
                    'oAvner' : 'owner',
                    'oUong' : 'along',
                    'o[)en' : 'open',
                    'o\vner' : 'owner',
                    'o])en' : 'open',
                    'o])portunity' : 'opportunity',
                    'o^il' : 'oil',
                    'o^ne' : 'one',
                    'o^this' : 'this',
                    'o^ur' : 'our',
                    'o^ut' : 'out',
                    'o^ver' : 'over',
                    'o^vner' : 'owner',
                    'o^wn' : 'own',
                    'of)en' : 'open',
                    'of^all' : 'fall',
                    'of^f' : 'off',
                    'of^our' : 'four',
                    'off1ce' : 'office',
                    'off1cer' : 'officer',
                    'off1cial' : 'official',
                    'off^er' : 'offer',
                    'offcr' : 'offer',
                    'offic1al' : 'official',
                    'officc' : 'office',
                    'officcr' : 'officer',
                    'offlce' : 'office',
                    'offlcer' : 'officer',
                    'offlcial' : 'official',
                    'offﬁce' : 'office',
                    'oflen' : 'often',
                    'ofler' : 'offer',
                    'oflice' : 'office',
                    'oflicer' : 'officer',
                    'oflicial' : 'official',
                    'oftcn' : 'often',
                    'ofteu' : 'often',
                    'ofﬁcc' : 'office',
                    'ofﬁccr' : 'officer',
                    'ofﬁee' : 'office',
                    'ofﬁeer' : 'officer',
                    'ofﬁre' : 'office',
                    'ofﬁve' : 'office',
                    'oi)en' : 'open',
                    'oi)eration' : 'operation',
                    'oiU' : 'oil',
                    'oiher' : 'other',
                    'oihers' : 'others',
                    'oiiU' : 'oil',
                    'oiten' : 'often',
                    'oivn' : 'own',
                    'oivner' : 'owner',
                    'oj)en' : 'open',
                    'oj)eration' : 'operation',
                    'oj)portunity' : 'opportunity',
                    'ol)en' : 'open',
                    'olﬁce' : 'office',
                    'olﬁcer' : 'officer',
                    'olﬁcial' : 'official',
                    'on1y' : 'only',
                    'on^ce' : 'once',
                    'on^e' : 'one',
                    'onc6' : 'once',
                    'oncc' : 'once',
                    'onhy' : 'only',
                    'onlv' : 'only',
                    'op6n' : 'open',
                    'op6ration' : 'operation',
                    'op[)ortunity' : 'opportunity',
                    'op])ortunity' : 'opportunity',
                    'opcn' : 'open',
                    'opcration' : 'operation',
                    'operat1on' : 'operation',
                    'opeu' : 'open',
                    'opj)ortunity' : 'opportunity',
                    'opportun1ty' : 'opportunity',
                    'opportunitv' : 'opportunity',
                    'op|)ortunity' : 'opportunity',
                    'ordcr' : 'order',
                    'otber' : 'other',
                    'otbers' : 'others',
                    'otb«r' : 'other',
                    'oth6r' : 'other',
                    'oth^er' : 'other',
                    'othcr' : 'other',
                    'othcrs' : 'others',
                    'othei' : 'other',
                    'otheis' : 'others',
                    'other^s' : 'others',
                    'otherf' : 'others',
                    'otherl' : 'others',
                    'otlier' : 'other',
                    'otliers' : 'others',
                    'otﬁce' : 'office',
                    'otﬁcer' : 'officer',
                    'otﬁcial' : 'official',
                    'ouly' : 'only',
                    'outfidc' : 'outside',
                    'outfide' : 'outside',
                    'outlide' : 'outside',
                    'outﬁde' : 'outside',
                    'ov/ner' : 'owner',
                    'ov6r' : 'over',
                    'ov^er' : 'over',
                    'ovcr' : 'over',
                    'ovei' : 'over',
                    'ovner' : 'owner',
                    'owncr' : 'owner',
                    'o|)en' : 'open',
                    'oſfer' : 'offer',
                    'oſﬁce' : 'office',
                    'oﬁen' : 'often',
                    'oﬁfer' : 'offer',
                    'oﬁﬁcer' : 'officer',
                    'oﬂﬁce' : 'office',
                    'p0int' : 'point',
                    'p0licy' : 'policy',
                    'p0litical' : 'political',
                    'p0pulati0n' : 'population',
                    'p0pulation' : 'population',
                    'p0wer' : 'power',
                    'p1ace' : 'place',
                    'p1ay' : 'play',
                    'p1cture' : 'picture',
                    'p6or' : 'poor',
                    'p6ssible' : 'possible',
                    'p6wer' : 'power',
                    'pOAver' : 'power',
                    'p^er' : 'per',
                    'paff' : 'pass',
                    'pafl' : 'pass',
                    'pafs' : 'pass',
                    'paft' : 'past',
                    'pag6' : 'page',
                    'pagc' : 'page',
                    'pahice' : 'police',
                    'pai)er' : 'paper',
                    'paint1ng' : 'painting',
                    'paity' : 'party',
                    'paiu' : 'pain',
                    'paj)er' : 'paper',
                    'paln' : 'pain',
                    'papcr' : 'paper',
                    'papei' : 'paper',
                    'parcnt' : 'parent',
                    'part1cular' : 'particular',
                    'part1cularly' : 'particularly',
                    'particiUar' : 'particular',
                    'particu1ar' : 'particular',
                    'particuhir' : 'particular',
                    'particuhirly' : 'particularly',
                    'particulai' : 'particular',
                    'particularlv' : 'particularly',
                    'partncr' : 'partner',
                    'partv' : 'party',
                    'pasf' : 'pass',
                    'paticnt' : 'patient',
                    'pbysical' : 'physical',
                    'pcace' : 'peace',
                    'pcoplc' : 'people',
                    'pcople' : 'people',
                    'pcrfon' : 'person',
                    'pcrfonal' : 'personal',
                    'pcrform' : 'perform',
                    'pcrformance' : 'performance',
                    'pcrhaps' : 'perhaps',
                    'pcriod' : 'period',
                    'pcrson' : 'person',
                    'pcrsonal' : 'personal',
                    'peacc' : 'peace',
                    'peciall' : 'special',
                    'peihaps' : 'perhaps',
                    'peiiod' : 'period',
                    'peison' : 'person',
                    'peo2)le' : 'people',
                    'peoi)le' : 'people',
                    'peoj)le' : 'people',
                    'peop1e' : 'people',
                    'peoplc' : 'people',
                    'per10d' : 'period',
                    'per1od' : 'period',
                    'perbaps' : 'perhaps',
                    'perfon' : 'person',
                    'perfonal' : 'personal',
                    'performancc' : 'performance',
                    'perha[)s' : 'perhaps',
                    'perha])S' : 'perhaps',
                    'perha])s' : 'perhaps',
                    'perhai)S' : 'perhaps',
                    'perhai)s' : 'perhaps',
                    'perhaj)S' : 'perhaps',
                    'perhaj)s' : 'perhaps',
                    'perhapf' : 'perhaps',
                    'perha|)s' : 'perhaps',
                    'perliaps' : 'perhaps',
                    'perlonal' : 'personal',
                    'pers0n' : 'person',
                    'pers0nal' : 'personal',
                    'pers6n' : 'person',
                    'persona1' : 'personal',
                    'persou' : 'person',
                    'phace' : 'place',
                    'phvsical' : 'physical',
                    'phyfical' : 'physical',
                    'phylical' : 'physical',
                    'phys1cal' : 'physical',
                    'physica1' : 'physical',
                    'phyﬁcal' : 'physical',
                    'picce' : 'piece',
                    'piclure' : 'picture',
                    'picturc' : 'picture',
                    'pidlure' : 'picture',
                    'pidture' : 'picture',
                    'pidure' : 'picture',
                    'piecc' : 'piece',
                    'piesent' : 'present',
                    'pifture' : 'picture',
                    'piihlic' : 'public',
                    'plac6' : 'place',
                    'placc' : 'place',
                    'plaver' : 'player',
                    'plece' : 'piece',
                    'pnblic' : 'public',
                    'pnrpose' : 'purpose',
                    'po1icy' : 'policy',
                    'po1itical' : 'political',
                    'poAvcr' : 'power',
                    'poUcy' : 'policy',
                    'poUtical' : 'political',
                    'poUtics' : 'politics',
                    'po\ver' : 'power',
                    'po])ulation' : 'population',
                    'po^ver' : 'power',
                    'pof1tion' : 'position',
                    'poffiblc' : 'possible',
                    'poffible' : 'possible',
                    'poffihle' : 'possible',
                    'pofiible' : 'possible',
                    'pofition' : 'position',
                    'pofitivc' : 'positive',
                    'pofitive' : 'positive',
                    'pofliblc' : 'possible',
                    'poflible' : 'possible',
                    'pofsible' : 'possible',
                    'pohce' : 'police',
                    'pohcy' : 'policy',
                    'pohtical' : 'political',
                    'pohtics' : 'politics',
                    'poi)ular' : 'popular',
                    'poi)ulation' : 'population',
                    'poiut' : 'point',
                    'poiver' : 'power',
                    'poj)ular' : 'popular',
                    'poj)ulation' : 'population',
                    'pol1ce' : 'police',
                    'pol1cy' : 'policy',
                    'pol1t1cal' : 'political',
                    'pol1t1cs' : 'politics',
                    'pol1tical' : 'political',
                    'pol1tics' : 'politics',
                    'policc' : 'police',
                    'policv' : 'policy',
                    'polit1cal' : 'political',
                    'polit1cs' : 'politics',
                    'politica1' : 'political',
                    'politiche' : 'political',
                    'polition' : 'position',
                    'politive' : 'positive',
                    'pollible' : 'possible',
                    'polnt' : 'point',
                    'pomt' : 'point',
                    'popiUar' : 'popular',
                    'popu1ation' : 'population',
                    'popuhition' : 'population',
                    'populat1on' : 'population',
                    'pos1tion' : 'position',
                    'pos1tive' : 'positive',
                    'posfible' : 'possible',
                    'posit1on' : 'position',
                    'posit1ve' : 'positive',
                    'positivc' : 'positive',
                    'poslible' : 'possible',
                    'poss1ble' : 'possible',
                    'possib1e' : 'possible',
                    'possiblc' : 'possible',
                    'possihie' : 'possible',
                    'possihle' : 'possible',
                    'pov/er' : 'power',
                    'pov^er' : 'power',
                    'pover' : 'power',
                    'powcr' : 'power',
                    'powei' : 'power',
                    'poſlible' : 'possible',
                    'poﬁible' : 'possible',
                    'poﬁtion' : 'position',
                    'poﬁtive' : 'positive',
                    'pr0blem' : 'problem',
                    'pr0gram' : 'program',
                    'pr0perty' : 'property',
                    'pr1ce' : 'price',
                    'pr1vate' : 'private',
                    'pr6sent' : 'present',
                    'pr6sident' : 'president',
                    'praclice' : 'practice',
                    'pract1ce' : 'practice',
                    'practicc' : 'practice',
                    'pradice' : 'practice',
                    'pradlice' : 'practice',
                    'pradtice' : 'practice',
                    'praftice' : 'practice',
                    'pra£lice' : 'practice',
                    'pra£tice' : 'practice',
                    'prcfcnt' : 'present',
                    'prcfent' : 'present',
                    'prcfident' : 'president',
                    'prcflure' : 'pressure',
                    'prcscnt' : 'present',
                    'prcsent' : 'present',
                    'prcsidcnt' : 'president',
                    'prcsident' : 'president',
                    'prcssure' : 'pressure',
                    'prctty' : 'pretty',
                    'prcvent' : 'prevent',
                    'pref1dent' : 'president',
                    'prefcnt' : 'present',
                    'prefent' : 'present',
                    'preffure' : 'pressure',
                    'prefidcnt' : 'president',
                    'prefident' : 'president',
                    'preflurc' : 'pressure',
                    'preflure' : 'pressure',
                    'prefsure' : 'pressure',
                    'preient' : 'present',
                    'prelent' : 'present',
                    'prelident' : 'president',
                    'prepar6' : 'prepare',
                    'pres1dent' : 'president',
                    'prescnt' : 'present',
                    'preseut' : 'present',
                    'presidcnt' : 'president',
                    'pressurc' : 'pressure',
                    'prettv' : 'pretty',
                    'preﬁdent' : 'president',
                    'pricc' : 'price',
                    'priv^ate' : 'private',
                    'privatc' : 'private',
                    'pro[)erty' : 'property',
                    'pro])erty' : 'property',
                    'probablv' : 'probably',
                    'probahlv' : 'probably',
                    'probahly' : 'probably',
                    'proccfs' : 'process',
                    'proccss' : 'process',
                    'procefs' : 'process',
                    'procels' : 'process',
                    'producc' : 'produce',
                    'producl' : 'product',
                    'produclion' : 'production',
                    'product1on' : 'production',
                    'produd' : 'product',
                    'produdion' : 'production',
                    'produdl' : 'product',
                    'produdt' : 'product',
                    'produdtion' : 'production',
                    'produft' : 'product',
                    'produftion' : 'production',
                    'profcssor' : 'professor',
                    'profeffional' : 'professional',
                    'profeffor' : 'professor',
                    'profeflional' : 'professional',
                    'profeflor' : 'professor',
                    'professiona1' : 'professional',
                    'prohablv' : 'probably',
                    'prohably' : 'probably',
                    'prohahly' : 'probably',
                    'prohlem' : 'problem',
                    'proi)erty' : 'property',
                    'proj)erty' : 'property',
                    'projecl' : 'project',
                    'projed' : 'project',
                    'projedl' : 'project',
                    'projedt' : 'project',
                    'projeft' : 'project',
                    'propcrtv' : 'property',
                    'propcrty' : 'property',
                    'propertv' : 'property',
                    'protecl' : 'protect',
                    'proted' : 'protect',
                    'protedl' : 'protect',
                    'protedt' : 'protect',
                    'prov1de' : 'provide',
                    'provc' : 'prove',
                    'providc' : 'provide',
                    'pro|)erty' : 'property',
                    'proſeſſor' : 'professor',
                    'pub1ic' : 'public',
                    'pubUc' : 'public',
                    'pubhc' : 'public',
                    'publ1c' : 'public',
                    'pufh' : 'push',
                    'pufli' : 'push',
                    'puhlic' : 'public',
                    'puipose' : 'purpose',
                    'pur[)ose' : 'purpose',
                    'pur])ose' : 'purpose',
                    'puri)ose' : 'purpose',
                    'purj)ose' : 'purpose',
                    'purp0se' : 'purpose',
                    'purpofc' : 'purpose',
                    'purpofe' : 'purpose',
                    'purpole' : 'purpose',
                    'purposc' : 'purpose',
                    'pur|)ose' : 'purpose',
                    'pusb' : 'push',
                    'q)on' : 'upon',
                    'q^uality' : 'quality',
                    'q^uestion' : 'question',
                    'q^uickly' : 'quickly',
                    'q^uite' : 'quite',
                    'qiiaUty' : 'quality',
                    'qiiahty' : 'quality',
                    'qnaUty' : 'quality',
                    'qnestion' : 'question',
                    'quUUty' : 'quality',
                    'qua1ity' : 'quality',
                    'quaUte' : 'quality',
                    'quaUty' : 'quality',
                    'quahty' : 'quality',
                    'quaiUity' : 'quality',
                    'qual1ty' : 'quality',
                    'qualitv' : 'quality',
                    'qualiſy' : 'quality',
                    'quanUty' : 'quality',
                    'qucflion' : 'question',
                    'qucftion' : 'question',
                    'qucstion' : 'question',
                    'queflion' : 'question',
                    'queftion' : 'question',
                    'queltion' : 'question',
                    'ques^tion' : 'question',
                    'quest1on' : 'question',
                    'questi0n' : 'question',
                    'questi6n' : 'question',
                    'questiou' : 'question',
                    'questlon' : 'question',
                    'quetlion' : 'question',
                    'queſiion' : 'question',
                    'queſlion' : 'question',
                    'queﬁion' : 'question',
                    'quiUity' : 'quality',
                    'quicUy' : 'quickly',
                    'quickhy' : 'quickly',
                    'quicklv' : 'quickly',
                    'quitc' : 'quite',
                    'quiæ' : 'quite',
                    'qulckly' : 'quickly',
                    'qulte' : 'quite',
                    'qwhiUe' : 'while',
                    'qﬁicial' : 'official',
                    'r/hich' : 'which',
                    'r0ad' : 'road',
                    'r0le' : 'role',
                    'r1ch' : 'rich',
                    'r1ght' : 'right',
                    'r1se' : 'rise',
                    'r6al' : 'real',
                    'r6gion' : 'region',
                    'r6le' : 'role',
                    'r6om' : 'room',
                    'rUBLIC' : 'public',
                    'r^ed' : 'red',
                    'raUways' : 'always',
                    'racc' : 'race',
                    'raife' : 'raise',
                    'raile' : 'raise',
                    'raisc' : 'raise',
                    'ralher' : 'rather',
                    'ralse' : 'raise',
                    'rang6' : 'range',
                    'rangc' : 'range',
                    'ratber' : 'rather',
                    'ratc' : 'rate',
                    'rathcr' : 'rather',
                    'rathei' : 'rather',
                    'ratlier' : 'rather',
                    'rcach' : 'reach',
                    'rcad' : 'read',
                    'rcady' : 'ready',
                    'rcafon' : 'reason',
                    'rcal' : 'real',
                    'rcalitv' : 'reality',
                    'rcality' : 'reality',
                    'rcalize' : 'realize',
                    'rcallv' : 'really',
                    'rcally' : 'really',
                    'rcason' : 'reason',
                    'rcceive' : 'receive',
                    'rccent' : 'recent',
                    'rccently' : 'recently',
                    'rcfource' : 'resource',
                    'rcfult' : 'result',
                    'rcgion' : 'region',
                    'rclationship' : 'relationship',
                    'rcligious' : 'religious',
                    'rclurn' : 'return',
                    'rcmain' : 'remain',
                    'rcmember' : 'remember',
                    'rcmove' : 'remove',
                    'rcport' : 'report',
                    'rcprefent' : 'represent',
                    'rcpresent' : 'represent',
                    'rcst' : 'rest',
                    'rcsult' : 'result',
                    'rcturn' : 'return',
                    'rcveal' : 'reveal',
                    're1ationship' : 'relationship',
                    're1igious' : 'religious',
                    'reUgioun' : 'religious',
                    'reUgious' : 'religious',
                    're[)ort' : 'report',
                    're])ort' : 'report',
                    're])resent' : 'represent',
                    'rea1' : 'real',
                    'reaU' : 'real',
                    'reaUy' : 'really',
                    'reaUze' : 'realize',
                    'reacb' : 'reach',
                    'reacli' : 'reach',
                    'readUy' : 'really',
                    'readv' : 'ready',
                    'reaffon' : 'reason',
                    'reafon' : 'reason',
                    'reah' : 'real',
                    'reahty' : 'reality',
                    'reahze' : 'realize',
                    'real1ty' : 'reality',
                    'realitv' : 'reality',
                    'realizc' : 'realize',
                    'reallv' : 'really',
                    'realon' : 'reason',
                    'reas6n' : 'reason',
                    'reasou' : 'reason',
                    'reccive' : 'receive',
                    'reccnt' : 'recent',
                    'reccntly' : 'recently',
                    'rece1ve' : 'receive',
                    'receiie' : 'receive',
                    'receiv^e' : 'receive',
                    'receivc' : 'receive',
                    'recelve' : 'receive',
                    'recentlv' : 'recently',
                    'recognizc' : 'recognize',
                    'reducc' : 'reduce',
                    'refearch' : 'research',
                    'reffource' : 'resource',
                    'refl' : 'rest',
                    'reflecl' : 'reflect',
                    'refledl' : 'reflect',
                    'refledt' : 'reflect',
                    'refleft' : 'reflect',
                    'refourcc' : 'resource',
                    'refource' : 'resource',
                    'refpond' : 'respond',
                    'refponfe' : 'response',
                    'refponfibility' : 'responsibility',
                    'refult' : 'result',
                    'reg1on' : 'region',
                    'regi6n' : 'region',
                    'rehgious' : 'religious',
                    'rei)resent' : 'represent',
                    'rej)ort' : 'report',
                    'rej)resent' : 'represent',
                    'rel1g1ous' : 'religious',
                    'rel1gious' : 'religious',
                    'relat1onsh1p' : 'relationship',
                    'relat1onship' : 'relationship',
                    'relati0nship' : 'relationship',
                    'relationfhip' : 'relationship',
                    'relationsbip' : 'relationship',
                    'relationsh1p' : 'relationship',
                    'relig1ous' : 'religious',
                    'religi0us' : 'religious',
                    'relt' : 'rest',
                    'relult' : 'result',
                    'remaln' : 'remain',
                    'remam' : 'remain',
                    'remcmber' : 'remember',
                    'remembcr' : 'remember',
                    'rememher' : 'remember',
                    'rep0rt' : 'report',
                    'reponfe' : 'response',
                    'reprcfent' : 'represent',
                    'reprcsent' : 'represent',
                    'reprefcnt' : 'represent',
                    'reprefent' : 'represent',
                    'reprelent' : 'represent',
                    'represcnt' : 'represent',
                    'requirc' : 'require',
                    'requlre' : 'require',
                    'rescarch' : 'research',
                    'researcb' : 'research',
                    'resi)onsibility' : 'responsibility',
                    'responsibUity' : 'responsibility',
                    'responsibiUty' : 'responsibility',
                    'responsibihty' : 'responsibility',
                    'responsibilitv' : 'responsibility',
                    'responsihility' : 'responsibility',
                    'resuUs' : 'result',
                    'retnrn' : 'return',
                    'revcal' : 'reveal',
                    'revea1' : 'reveal',
                    're|)ort' : 'report',
                    'reſi' : 'rest',
                    'reſl' : 'rest',
                    'reſo' : 'rest',
                    'ricb' : 'rich',
                    'ricli' : 'rich',
                    'rifk' : 'risk',
                    'rig^ht' : 'right',
                    'rigbt' : 'right',
                    'righl' : 'right',
                    'riglit' : 'right',
                    'rlch' : 'rich',
                    'rlght' : 'right',
                    'rlse' : 'rise',
                    'rnle' : 'rule',
                    'ro])erty' : 'property',
                    'rolc' : 'role',
                    'ru1e' : 'rule',
                    'rulc' : 'rule',
                    'rvithout' : 'without',
                    's00n' : 'soon',
                    's0cial' : 'social',
                    's0ciety' : 'society',
                    's0me' : 'some',
                    's0on' : 'soon',
                    's0und' : 'sound',
                    's0uth' : 'south',
                    's1de' : 'side',
                    's1milar' : 'similar',
                    's1mply' : 'simply',
                    's1nce' : 'since',
                    's1ng' : 'sing',
                    's1ngle' : 'single',
                    's1ster' : 'sister',
                    's1te' : 'site',
                    's1tuation' : 'situation',
                    's6cial' : 'social',
                    's6metimes' : 'sometimes',
                    's6on' : 'soon',
                    's6uth' : 'south',
                    's^ave' : 'save',
                    's^ay' : 'say',
                    's^ee' : 'see',
                    's^et' : 'set',
                    's^it' : 'sit',
                    's^on' : 'son',
                    'safc' : 'safe',
                    'sam6' : 'same',
                    'samc' : 'same',
                    'savc' : 'save',
                    'sbake' : 'shake',
                    'sbare' : 'share',
                    'sboot' : 'shoot',
                    'sbort' : 'short',
                    'sbot' : 'shot',
                    'sbould' : 'should',
                    'sboulder' : 'shoulder',
                    'sbow' : 'show',
                    'scafon' : 'season',
                    'scason' : 'season',
                    'scclion' : 'section',
                    'sccm' : 'seem',
                    'schoo1' : 'school',
                    'schooU' : 'school',
                    'schooh' : 'school',
                    'scicncc' : 'science',
                    'scicnce' : 'science',
                    'sciencc' : 'science',
                    'sclence' : 'science',
                    'scll' : 'sell',
                    'scnd' : 'send',
                    'scnior' : 'senior',
                    'scnse' : 'sense',
                    'scorc' : 'score',
                    'scrious' : 'serious',
                    'scrve' : 'serve',
                    'scrvicc' : 'service',
                    'scrvice' : 'service',
                    'scvcral' : 'several',
                    'scven' : 'seven',
                    'scveral' : 'several',
                    'seafon' : 'season',
                    'sec0nd' : 'second',
                    'sec6nd' : 'second',
                    'seclion' : 'section',
                    'secm' : 'seem',
                    'secoud' : 'second',
                    'sect10n' : 'section',
                    'sect1on' : 'section',
                    'secti0n' : 'section',
                    'secur1ty' : 'security',
                    'securitv' : 'security',
                    'sedion' : 'section',
                    'sedtion' : 'section',
                    'seftion' : 'section',
                    'sel1' : 'sell',
                    'sen1or' : 'senior',
                    'senfe' : 'sense',
                    'senle' : 'sense',
                    'sens6' : 'sense',
                    'sensc' : 'sense',
                    'ser1es' : 'series',
                    'ser1ous' : 'serious',
                    'serics' : 'series',
                    'serles' : 'series',
                    'serv1ce' : 'service',
                    'serv^e' : 'serve',
                    'servc' : 'serve',
                    'servicc' : 'service',
                    'seud' : 'send',
                    'seuse' : 'sense',
                    'sev^eral' : 'several',
                    'sevcn' : 'seven',
                    'sevcral' : 'several',
                    'seveial' : 'several',
                    'severa1' : 'several',
                    'severaU' : 'several',
                    'sh00t' : 'shoot',
                    'sh0rt' : 'short',
                    'sh0uld' : 'should',
                    'sh6rt' : 'short',
                    'sh6uld' : 'should',
                    'sharc' : 'share',
                    'shoAv' : 'show',
                    'sho\v' : 'show',
                    'shoiUd' : 'should',
                    'shoit' : 'short',
                    'shoiv' : 'show',
                    'shonld' : 'should',
                    'shou1d' : 'should',
                    'shouldcr' : 'shoulder',
                    'shov' : 'show',
                    'si)ecial' : 'special',
                    'si)eech' : 'speech',
                    'siate' : 'state',
                    'sid6' : 'side',
                    'sidc' : 'side',
                    'sifler' : 'sister',
                    'signif1cant' : 'significant',
                    'signiflcant' : 'significant',
                    'sigu' : 'sign',
                    'siihject' : 'subject',
                    'silter' : 'sister',
                    'sim1lar' : 'similar',
                    'simUar' : 'similar',
                    'simi1ar' : 'similar',
                    'simj)le' : 'simple',
                    'simj)ly' : 'simply',
                    'simplc' : 'simple',
                    'simplv' : 'simply',
                    'sincc' : 'since',
                    'sing1e' : 'single',
                    'singlc' : 'single',
                    'sistcr' : 'sister',
                    'situat1on' : 'situation',
                    'siuce' : 'since',
                    'sizc' : 'size',
                    'sj)ace' : 'space',
                    'sj)eak' : 'speak',
                    'sj)ecial' : 'special',
                    'sj)eech' : 'speech',
                    'sj)ring' : 'spring',
                    'sk1ll' : 'skill',
                    'sk1n' : 'skin',
                    'skiU' : 'skill',
                    'skil1' : 'skill',
                    'skiu' : 'skin',
                    'skm' : 'skin',
                    'slde' : 'side',
                    'sliare' : 'share',
                    'slie' : 'she',
                    'slill' : 'still',
                    'sliort' : 'short',
                    'sliot' : 'shot',
                    'sliould' : 'should',
                    'sliow' : 'show',
                    'slnce' : 'since',
                    'slng' : 'sing',
                    'slock' : 'stock',
                    'slory' : 'story',
                    'slte' : 'site',
                    'slze' : 'size',
                    'smaU' : 'small',
                    'smal1' : 'small',
                    'smau' : 'small',
                    'smce' : 'since',
                    'smg' : 'sing',
                    'smgle' : 'single',
                    'snbject' : 'subject',
                    'snch' : 'such',
                    'snre' : 'sure',
                    'soc1al' : 'social',
                    'soc1ety' : 'society',
                    'socia1' : 'social',
                    'socicly' : 'society',
                    'socictv' : 'society',
                    'socicty' : 'society',
                    'societv' : 'society',
                    'socifty' : 'society',
                    'soldicr' : 'soldier',
                    'soldler' : 'soldier',
                    'som6' : 'some',
                    'som^e' : 'some',
                    'somc' : 'some',
                    'somcthing' : 'something',
                    'somctimes' : 'sometimes',
                    'somebodv' : 'somebody',
                    'somehody' : 'somebody',
                    'somet1mes' : 'sometimes',
                    'sometbing' : 'something',
                    'somethmg' : 'something',
                    'sometimcs' : 'sometimes',
                    'sometliing' : 'something',
                    'soug' : 'song',
                    'soulh' : 'south',
                    'sourcc' : 'source',
                    'soutb' : 'south',
                    'soutbern' : 'southern',
                    'southcrn' : 'southern',
                    'soutli' : 'south',
                    'soutliern' : 'southern',
                    'souud' : 'sound',
                    'spacc' : 'space',
                    'spcak' : 'speak',
                    'spccial' : 'special',
                    'spccific' : 'specific',
                    'spcech' : 'speech',
                    'spec1al' : 'special',
                    'spec1f1c' : 'specific',
                    'spec1fic' : 'specific',
                    'specia1' : 'special',
                    'speciaU' : 'special',
                    'specif1c' : 'specific',
                    'speciflc' : 'specific',
                    'speclal' : 'special',
                    'speecb' : 'speech',
                    'speecli' : 'speech',
                    'sriaU' : 'trial',
                    'st0ry' : 'story',
                    'st1ll' : 'still',
                    'st6ry' : 'story',
                    'stIU' : 'still',
                    'stafl' : 'staff',
                    'stagc' : 'stage',
                    'stat1on' : 'station',
                    'statc' : 'state',
                    'statcment' : 'statement',
                    'statemcnt' : 'statement',
                    'staud' : 'stand',
                    'stav' : 'stay',
                    'stcp' : 'step',
                    'stiU' : 'still',
                    'stih' : 'still',
                    'stiu' : 'still',
                    'stlll' : 'still',
                    'stndy' : 'study',
                    'stoiy' : 'story',
                    'storc' : 'store',
                    'storv' : 'story',
                    'str6ng' : 'strong',
                    'strcct' : 'street',
                    'strcet' : 'street',
                    'strect' : 'street',
                    'streft' : 'street',
                    'stroug' : 'strong',
                    'struclure' : 'structure',
                    'structurc' : 'structure',
                    'strudure' : 'structure',
                    'strufture' : 'structure',
                    'studcnt' : 'student',
                    'studv' : 'study',
                    'stvle' : 'style',
                    'sty1e' : 'style',
                    'styU' : 'style',
                    'stylc' : 'style',
                    'subjccl' : 'subject',
                    'subjcft' : 'subject',
                    'subjecl' : 'subject',
                    'subjed' : 'subject',
                    'subjedl' : 'subject',
                    'subjedt' : 'subject',
                    'subjeft' : 'subject',
                    'sucb' : 'such',
                    'succ6ss' : 'success',
                    'succefs' : 'success',
                    'succefsful' : 'successful',
                    'succesf' : 'success',
                    'successfu1' : 'successful',
                    'sucli' : 'such',
                    'suddenlv' : 'suddenly',
                    'sueh' : 'such',
                    'suffcr' : 'suffer',
                    'sufier' : 'suffer',
                    'sufler' : 'suffer',
                    'suggeft' : 'suggest',
                    'suhjcct' : 'subject',
                    'suhject' : 'subject',
                    'suj)port' : 'support',
                    'summcr' : 'summer',
                    'sup[)ort' : 'support',
                    'sup])ort' : 'support',
                    'supj)ort' : 'support',
                    'supp0rt' : 'support',
                    'surc' : 'sure',
                    'surfacc' : 'surface',
                    'suﬁer' : 'suffer',
                    'svithout' : 'without',
                    'svstcm' : 'system',
                    'svstem' : 'system',
                    'syflem' : 'system',
                    'syftcm' : 'system',
                    'syftem' : 'system',
                    'systcm' : 'system',
                    't0tal' : 'total',
                    't1me' : 'time',
                    't6gether' : 'together',
                    't6wn' : 'town',
                    'tOAvard' : 'toward',
                    'tOAvn' : 'town',
                    't^at' : 'that',
                    't^e' : 'the',
                    't^en' : 'ten',
                    't^hat' : 'that',
                    't^he' : 'the',
                    't^hen' : 'then',
                    't^here' : 'there',
                    't^hese' : 'these',
                    't^hey' : 'they',
                    't^his' : 'this',
                    't^ie' : 'the',
                    't^o' : 'to',
                    't^oo' : 'too',
                    't^ree' : 'tree',
                    't^wo' : 'two',
                    'tab1e' : 'table',
                    'tablc' : 'table',
                    'tafk' : 'task',
                    'tahk' : 'talk',
                    'tahle' : 'table',
                    'taik' : 'task',
                    'tak6' : 'take',
                    'takc' : 'take',
                    'tban' : 'than',
                    'tbank' : 'thank',
                    'tbat' : 'that',
                    'tbe' : 'the',
                    'tbefe' : 'these',
                    'tbeir' : 'their',
                    'tbem' : 'them',
                    'tbemfelves' : 'themselves',
                    'tbemselves' : 'themselves',
                    'tben' : 'then',
                    'tbeory' : 'theory',
                    'tbere' : 'there',
                    'tbese' : 'these',
                    'tbey' : 'they',
                    'tbing' : 'thing',
                    'tbink' : 'think',
                    'tbird' : 'third',
                    'tbis' : 'this',
                    'tbofe' : 'those',
                    'tbose' : 'those',
                    'tboufand' : 'thousand',
                    'tbough' : 'though',
                    'tbought' : 'thought',
                    'tbouglit' : 'thought',
                    'tbousand' : 'thousand',
                    'tbreat' : 'threat',
                    'tbree' : 'three',
                    'tbrougbout' : 'throughout',
                    'tbrough' : 'through',
                    'tbroughout' : 'throughout',
                    'tbrougli' : 'through',
                    'tbrow' : 'throw',
                    'tbus' : 'thus',
                    'tb«m' : 'them',
                    'tb«n' : 'then',
                    'tb«y' : 'they',
                    'tcach' : 'teach',
                    'tcacher' : 'teacher',
                    'tcam' : 'team',
                    'tcll' : 'tell',
                    'tcnd' : 'tend',
                    'tcrm' : 'term',
                    'tcst' : 'test',
                    'teU' : 'tell',
                    'teacb' : 'teach',
                    'teacber' : 'teacher',
                    'teachcr' : 'teacher',
                    'teacli' : 'teach',
                    'technologv' : 'technology',
                    'teft' : 'test',
                    'teim' : 'term',
                    'tel1' : 'tell',
                    'tf)e' : 'type',
                    'th0se' : 'those',
                    'th0usand' : 'thousand',
                    'th1ng' : 'thing',
                    'th1nk' : 'think',
                    'th1rd' : 'third',
                    'th1s' : 'this',
                    'th6ir' : 'their',
                    'th6m' : 'them',
                    'th6re' : 'there',
                    'th6ugh' : 'though',
                    'th6ught' : 'thought',
                    'th6y' : 'they',
                    'th^at' : 'that',
                    'th^e' : 'the',
                    'th^ey' : 'they',
                    'th^ir' : 'their',
                    'th^m' : 'them',
                    'th^re' : 'there',
                    'th^t' : 'that',
                    'thcfe' : 'these',
                    'thcir' : 'their',
                    'thcm' : 'them',
                    'thcmfclvcs' : 'themselves',
                    'thcmfclves' : 'themselves',
                    'thcmfelvcs' : 'themselves',
                    'thcmfelves' : 'themselves',
                    'thcmselves' : 'themselves',
                    'thcn' : 'then',
                    'thcorv' : 'theory',
                    'thcory' : 'theory',
                    'thcre' : 'there',
                    'thcse' : 'these',
                    'thcy' : 'they',
                    'the^e' : 'there',
                    'thecause' : 'because',
                    'thefc' : 'these',
                    'thefe' : 'these',
                    'theffe' : 'these',
                    'theie' : 'there',
                    'thele' : 'these',
                    'thelr' : 'their',
                    'themfclvcs' : 'themselves',
                    'themfclves' : 'themselves',
                    'themfelvcs' : 'themselves',
                    'themfelves' : 'themselves',
                    'themielves' : 'themselves',
                    'themlelves' : 'themselves',
                    'themsclves' : 'themselves',
                    'themse1ves' : 'themselves',
                    'themseh^es' : 'themselves',
                    'themselv^es' : 'themselves',
                    'themselvcs' : 'themselves',
                    'themselvef' : 'themselves',
                    'themſelues' : 'themselves',
                    'theoiy' : 'theory',
                    'theorv' : 'theory',
                    'ther6' : 'there',
                    'therc' : 'there',
                    'thes6' : 'these',
                    'thesc' : 'these',
                    'thev' : 'they',
                    'thiee' : 'three',
                    'thif' : 'this',
                    'thiff' : 'this',
                    'thiough' : 'through',
                    'thiug' : 'thing',
                    'thiuk' : 'think',
                    'thlng' : 'thing',
                    'thlnk' : 'think',
                    'thlrd' : 'third',
                    'thls' : 'this',
                    'thmg' : 'thing',
                    'thmk' : 'think',
                    'thofc' : 'those',
                    'thofe' : 'those',
                    'thoie' : 'those',
                    'thongh' : 'though',
                    'thonght' : 'thought',
                    'thonsand' : 'thousand',
                    'thos6' : 'those',
                    'thosc' : 'those',
                    'thoufand' : 'thousand',
                    'thoug^h' : 'though',
                    'thoug^ht' : 'thought',
                    'thougb' : 'though',
                    'thougbt' : 'thought',
                    'thougli' : 'though',
                    'thouglit' : 'thought',
                    'thouland' : 'thousand',
                    'thousaud' : 'thousand',
                    'thr0ugh' : 'through',
                    'thr6ugh' : 'through',
                    'thrcat' : 'threat',
                    'threc' : 'three',
                    'throAv' : 'throw',
                    'throiv' : 'throw',
                    'throngh' : 'through',
                    'throug^h' : 'through',
                    'througb' : 'through',
                    'througbout' : 'throughout',
                    'througli' : 'through',
                    'througliout' : 'throughout',
                    'throv' : 'throw',
                    'thuf' : 'thus',
                    'thul' : 'thus',
                    'th«m' : 'them',
                    'tiiat' : 'that',
                    'tim6' : 'time',
                    'tim^e' : 'time',
                    'timc' : 'time',
                    'tiuth' : 'truth',
                    'tj)e' : 'type',
                    'tl)e' : 'the',
                    'tlian' : 'than',
                    'tliat' : 'that',
                    'tliau' : 'than',
                    'tlic' : 'the',
                    'tlie' : 'the',
                    'tliefe' : 'these',
                    'tlieir' : 'their',
                    'tliem' : 'them',
                    'tliemselves' : 'themselves',
                    'tlien' : 'then',
                    'tliere' : 'there',
                    'tliese' : 'these',
                    'tliey' : 'they',
                    'tliink' : 'think',
                    'tliird' : 'third',
                    'tliis' : 'this',
                    'tlios' : 'those',
                    'tliose' : 'those',
                    'tliougb' : 'though',
                    'tliougbt' : 'thought',
                    'tliough' : 'though',
                    'tliought' : 'thought',
                    'tliougli' : 'though',
                    'tliouglit' : 'thought',
                    'tliousand' : 'thousand',
                    'tliree' : 'three',
                    'tlirougb' : 'through',
                    'tlirough' : 'through',
                    'tliroughout' : 'throughout',
                    'tlirougli' : 'through',
                    'tlirow' : 'throw',
                    'tlius' : 'thus',
                    'tlme' : 'time',
                    'tlus' : 'thus',
                    'tnrn' : 'turn',
                    'toAvard' : 'toward',
                    'toAvn' : 'town',
                    'to\vn' : 'town',
                    'to^vn' : 'town',
                    'todav' : 'today',
                    'togcthcr' : 'together',
                    'togcther' : 'together',
                    'togetber' : 'together',
                    'togethcr' : 'together',
                    'togethei' : 'together',
                    'togetlier' : 'together',
                    'toivard' : 'toward',
                    'toivn' : 'town',
                    'tota1' : 'total',
                    'tougb' : 'tough',
                    'tov/ard' : 'toward',
                    'tov/n' : 'town',
                    'tov^n' : 'town',
                    'tovn' : 'town',
                    'towu' : 'town',
                    'tr1al' : 'trial',
                    'tradc' : 'trade',
                    'train1ng' : 'training',
                    'travaU' : 'travel',
                    'travcl' : 'travel',
                    'trave1' : 'travel',
                    'traveU' : 'travel',
                    'trcat' : 'treat',
                    'trcatment' : 'treatment',
                    'trce' : 'tree',
                    'treatmcnt' : 'treatment',
                    'tria1' : 'trial',
                    'triaU' : 'trial',
                    'triah' : 'trial',
                    'trlal' : 'trial',
                    'trne' : 'true',
                    'trnth' : 'truth',
                    'troublc' : 'trouble',
                    'trouhle' : 'trouble',
                    'trutb' : 'truth',
                    'trutli' : 'truth',
                    'tryaU' : 'trial',
                    'træ' : 'tree',
                    'tt)e' : 'type',
                    'turu' : 'turn',
                    'tv/o' : 'two',
                    'tvO' : 'two',
                    'tvhatever' : 'whatever',
                    'tvhether' : 'whether',
                    'tvithout' : 'without',
                    'tvpe' : 'type',
                    'ty)v' : 'type',
                    'typc' : 'type',
                    'u))on' : 'upon',
                    'u)ay' : 'pay',
                    'u2)on' : 'upon',
                    'u[)on' : 'upon',
                    'u])on' : 'upon',
                    'u^pon' : 'upon',
                    'u^se' : 'use',
                    'uame' : 'name',
                    'uature' : 'nature',
                    'uauaUy' : 'usually',
                    'uccefsful' : 'successful',
                    'uear' : 'near',
                    'ueed' : 'need',
                    'uever' : 'never',
                    'uext' : 'next',
                    'uf)on' : 'upon',
                    'ufe' : 'use',
                    'uffe' : 'use',
                    'ufuaUy' : 'usually',
                    'ufually' : 'usually',
                    'ui)on' : 'upon',
                    'uj)on' : 'upon',
                    'ul)on' : 'upon',
                    'ulually' : 'usually',
                    'un1t' : 'unit',
                    'un^it' : 'unit',
                    'und^er' : 'under',
                    'undcr' : 'under',
                    'undcrftand' : 'understand',
                    'undcrstand' : 'understand',
                    'undei' : 'under',
                    'underfland' : 'understand',
                    'underftand' : 'understand',
                    'underltand' : 'understand',
                    'undertland' : 'understand',
                    'underſiand' : 'understand',
                    'underſland' : 'understand',
                    'underﬁand' : 'understand',
                    'unlt' : 'unit',
                    'unt1l' : 'until',
                    'unti1' : 'until',
                    'untiU' : 'until',
                    'unwiU' : 'until',
                    'up0n' : 'upon',
                    'up6n' : 'upon',
                    'up^on' : 'upon',
                    'urj)ose' : 'purpose',
                    'us^e' : 'use',
                    'usuaUy' : 'usually',
                    'usuallv' : 'usually',
                    'usuauy' : 'usually',
                    'uuder' : 'under',
                    'uutil' : 'until',
                    'ux)on' : 'upon',
                    'u|)on' : 'upon',
                    'v)hat' : 'what',
                    'v)hen' : 'when',
                    'v)hich' : 'which',
                    'v)ith' : 'with',
                    'v/Ith' : 'with',
                    'v/ait' : 'wait',
                    'v/all' : 'wall',
                    'v/ant' : 'want',
                    'v/atch' : 'watch',
                    'v/ay' : 'way',
                    'v/eapon' : 'weapon',
                    'v/ear' : 'wear',
                    'v/eight' : 'weight',
                    'v/ell' : 'well',
                    'v/estern' : 'western',
                    'v/hat' : 'what',
                    'v/hatever' : 'whatever',
                    'v/hcre' : 'where',
                    'v/hen' : 'when',
                    'v/herc' : 'where',
                    'v/here' : 'where',
                    'v/hether' : 'whether',
                    'v/hich' : 'which',
                    'v/hile' : 'while',
                    'v/hite' : 'white',
                    'v/ho' : 'who',
                    'v/hofe' : 'whose',
                    'v/holc' : 'whole',
                    'v/hole' : 'whole',
                    'v/hom' : 'whom',
                    'v/hose' : 'whose',
                    'v/hy' : 'why',
                    'v/ill' : 'will',
                    'v/indow' : 'window',
                    'v/ish' : 'wish',
                    'v/ith' : 'with',
                    'v/ithin' : 'within',
                    'v/ithout' : 'without',
                    'v/itliout' : 'without',
                    'v/liat' : 'what',
                    'v/liere' : 'where',
                    'v/liich' : 'which',
                    'v/liile' : 'while',
                    'v/liole' : 'whole',
                    'v/liom' : 'whom',
                    'v/oman' : 'woman',
                    'v/onder' : 'wonder',
                    'v/ord' : 'word',
                    'v/orld' : 'world',
                    'v/ould' : 'would',
                    'v/rite' : 'write',
                    'v/riter' : 'writer',
                    'v/rong' : 'wrong',
                    'v1ew' : 'view',
                    'v6ice' : 'voice',
                    'v6ry' : 'very',
                    'v6te' : 'vote',
                    'vAy' : 'way',
                    'vHo' : 'who',
                    'vVhether' : 'whether',
                    'vVithout' : 'without',
                    'vWhat' : 'what',
                    'vWhen' : 'when',
                    'vWith' : 'with',
                    'v\^hen' : 'when',
                    'v\^hich' : 'which',
                    'v\^ith' : 'with',
                    'v\^ould' : 'would',
                    'v\hat' : 'what',
                    'v\hen' : 'when',
                    'v\here' : 'where',
                    'v\hich' : 'which',
                    'v\hile' : 'while',
                    'v\hole' : 'whole',
                    'v\hom' : 'whom',
                    'v\ith' : 'with',
                    'v\ithin' : 'within',
                    'v\ithout' : 'without',
                    'v\ould' : 'would',
                    'v^^hat' : 'what',
                    'v^^hen' : 'when',
                    'v^^here' : 'where',
                    'v^^hich' : 'which',
                    'v^^hile' : 'while',
                    'v^^hole' : 'whole',
                    'v^^hom' : 'whom',
                    'v^^hose' : 'whose',
                    'v^^ith' : 'with',
                    'v^^ithout' : 'without',
                    'v^^orld' : 'world',
                    'v^^ould' : 'would',
                    'v^alue' : 'value',
                    'v^ant' : 'want',
                    'v^arious' : 'various',
                    'v^ery' : 'very',
                    'v^hat' : 'what',
                    'v^hatever' : 'whatever',
                    'v^hen' : 'when',
                    'v^here' : 'where',
                    'v^hether' : 'whether',
                    'v^hich' : 'which',
                    'v^hile' : 'while',
                    'v^hite' : 'white',
                    'v^hole' : 'whole',
                    'v^hom' : 'whom',
                    'v^hose' : 'whose',
                    'v^ish' : 'wish',
                    'v^ith' : 'with',
                    'v^ithin' : 'within',
                    'v^ithout' : 'without',
                    'v^oice' : 'voice',
                    'v^oman' : 'woman',
                    'v^ord' : 'word',
                    'v^orld' : 'world',
                    'v^ote' : 'vote',
                    'v^ould' : 'would',
                    'v^rite' : 'write',
                    'va1ue' : 'value',
                    'vaUum' : 'value',
                    'vaiious' : 'various',
                    'valne' : 'value',
                    'valuc' : 'value',
                    'var1ous' : 'various',
                    'vard' : 'yard',
                    'variouf' : 'various',
                    'varioul' : 'various',
                    'varlous' : 'various',
                    'vatch' : 'watch',
                    'vcry' : 'very',
                    'veapon' : 'weapon',
                    'veftern' : 'western',
                    'veight' : 'weight',
                    'veiglit' : 'weight',
                    'veiy' : 'very',
                    'ver^y' : 'very',
                    'verv' : 'very',
                    'vhat' : 'what',
                    'vhatever' : 'whatever',
                    'vhcther' : 'whether',
                    'vhen' : 'when',
                    'vhere' : 'where',
                    'vhethcr' : 'whether',
                    'vhether' : 'whether',
                    'vhich' : 'which',
                    'vhile' : 'while',
                    'vhite' : 'white',
                    'vhofe' : 'whose',
                    'vhole' : 'whole',
                    'vhom' : 'whom',
                    'vhose' : 'whose',
                    'vhy' : 'why',
                    'vi^ithin' : 'within',
                    'vi^ithout' : 'without',
                    'viclim' : 'victim',
                    'vicw' : 'view',
                    'vidim' : 'victim',
                    'vidlim' : 'victim',
                    'vidtim' : 'victim',
                    'vieAv' : 'view',
                    'vie\v' : 'view',
                    'vie^v' : 'view',
                    'vieiv' : 'view',
                    'viev' : 'view',
                    'vifit' : 'visit',
                    'viftim' : 'victim',
                    'viithin' : 'within',
                    'viithout' : 'without',
                    'vilhout' : 'without',
                    'vilit' : 'visit',
                    'vindow' : 'window',
                    'violencc' : 'violence',
                    'vis1t' : 'visit',
                    'vislt' : 'visit',
                    'vitH' : 'with',
                    'vithiii' : 'within',
                    'vithin' : 'within',
                    'vithoiit' : 'without',
                    'vithoul' : 'without',
                    'vithout' : 'without',
                    'vitliin' : 'within',
                    'vitliout' : 'without',
                    'vi«v' : 'view',
                    'viﬁt' : 'visit',
                    'vlew' : 'view',
                    'vliether' : 'whether',
                    'vlile' : 'while',
                    'vlsit' : 'visit',
                    'vniter' : 'writer',
                    'vntiU' : 'until',
                    'voicc' : 'voice',
                    'volce' : 'voice',
                    'voman' : 'woman',
                    'voorld' : 'world',
                    'voould' : 'would',
                    'vord' : 'word',
                    'vorld' : 'world',
                    'vorry' : 'worry',
                    'vorrà' : 'worry',
                    'votc' : 'vote',
                    'vould' : 'would',
                    'voung' : 'young',
                    'vour' : 'your',
                    'voursclf' : 'yourself',
                    'vourself' : 'yourself',
                    'vrhatever' : 'whatever',
                    'vrite' : 'write',
                    'vriter' : 'writer',
                    'vrong' : 'wrong',
                    'vrriter' : 'writer',
                    'vs^ell' : 'sell',
                    'vt^hen' : 'then',
                    'vv^hether' : 'whether',
                    'vv^ithout' : 'without',
                    'vvhether' : 'whether',
                    'vvithout' : 'without',
                    'vyhatever' : 'whatever',
                    'v«ith' : 'with',
                    'v»^hich' : 'which',
                    'v»^ith' : 'with',
                    'v»hat' : 'what',
                    'v»hen' : 'when',
                    'v»hich' : 'which',
                    'v»ith' : 'with',
                    'v»ould' : 'would',
                    'vérite' : 'write',
                    'w0rd' : 'word',
                    'w0rk' : 'work',
                    'w0rld' : 'world',
                    'w0uld' : 'would',
                    'w1de' : 'wide',
                    'w1fe' : 'wife',
                    'w1ll' : 'will',
                    'w1ndow' : 'window',
                    'w1sh' : 'wish',
                    'w1th' : 'with',
                    'w1thin' : 'within',
                    'w1thout' : 'without',
                    'w6man' : 'woman',
                    'w6rd' : 'word',
                    'w6rk' : 'work',
                    'w6rld' : 'world',
                    'w6uld' : 'would',
                    'w^ait' : 'wait',
                    'w^alk' : 'walk',
                    'w^all' : 'wall',
                    'w^ant' : 'want',
                    'w^ar' : 'war',
                    'w^atch' : 'watch',
                    'w^ater' : 'water',
                    'w^ay' : 'way',
                    'w^bich' : 'which',
                    'w^e' : 'we',
                    'w^eapon' : 'weapon',
                    'w^ear' : 'wear',
                    'w^eek' : 'week',
                    'w^eight' : 'weight',
                    'w^ell' : 'well',
                    'w^est' : 'west',
                    'w^estern' : 'western',
                    'w^hat' : 'what',
                    'w^hatever' : 'whatever',
                    'w^hen' : 'when',
                    'w^here' : 'where',
                    'w^hether' : 'whether',
                    'w^hicb' : 'which',
                    'w^hich' : 'which',
                    'w^hile' : 'while',
                    'w^hite' : 'white',
                    'w^ho' : 'who',
                    'w^hole' : 'whole',
                    'w^hom' : 'whom',
                    'w^hose' : 'whose',
                    'w^hy' : 'why',
                    'w^ide' : 'wide',
                    'w^ife' : 'wife',
                    'w^iich' : 'which',
                    'w^ill' : 'will',
                    'w^in' : 'win',
                    'w^ind' : 'wind',
                    'w^indow' : 'window',
                    'w^ish' : 'wish',
                    'w^ith' : 'with',
                    'w^ithin' : 'within',
                    'w^ithout' : 'without',
                    'w^oman' : 'woman',
                    'w^onder' : 'wonder',
                    'w^ord' : 'word',
                    'w^ork' : 'work',
                    'w^orker' : 'worker',
                    'w^orld' : 'world',
                    'w^orry' : 'worry',
                    'w^ould' : 'would',
                    'w^th' : 'with',
                    'waU' : 'wall',
                    'waUi' : 'wall',
                    'wahk' : 'walk',
                    'wal1' : 'wall',
                    'watcb' : 'watch',
                    'watcli' : 'watch',
                    'watcr' : 'water',
                    'watei' : 'water',
                    'wbatever' : 'whatever',
                    'wbere' : 'where',
                    'wbether' : 'whether',
                    'wbetlier' : 'whether',
                    'wbile' : 'while',
                    'wboM' : 'whom',
                    'wbofe' : 'whose',
                    'wbole' : 'whole',
                    'wbose' : 'whose',
                    'wby' : 'why',
                    'wbàt' : 'what',
                    'wcar' : 'wear',
                    'wcek' : 'week',
                    'wcftern' : 'western',
                    'wcight' : 'weight',
                    'wcll' : 'well',
                    'wcstern' : 'western',
                    'we1ght' : 'weight',
                    'weU' : 'well',
                    'weai)on' : 'weapon',
                    'weaj)on' : 'weapon',
                    'wefl' : 'west',
                    'weflern' : 'western',
                    'weftcrn' : 'western',
                    'weftern' : 'western',
                    'weig^ht' : 'weight',
                    'weigbt' : 'weight',
                    'weiglit' : 'weight',
                    'wel1' : 'well',
                    'welght' : 'weight',
                    'weltern' : 'western',
                    'westcrn' : 'western',
                    'westem' : 'western',
                    'weſi' : 'west',
                    'weſiern' : 'western',
                    'weſl' : 'west',
                    'weſlern' : 'western',
                    'whai' : 'what',
                    'whatcver' : 'whatever',
                    'whatev^er' : 'whatever',
                    'whatevcr' : 'whatever',
                    'whcn' : 'when',
                    'whcre' : 'where',
                    'whcthcr' : 'whether',
                    'whcther' : 'whether',
                    'wheie' : 'where',
                    'wher6' : 'where',
                    'wherc' : 'where',
                    'whetber' : 'whether',
                    'whethcr' : 'whether',
                    'whethei' : 'whether',
                    'whetlier' : 'whether',
                    'whi1e' : 'while',
                    'whiUi' : 'while',
                    'whic^h' : 'which',
                    'whicb' : 'which',
                    'whicli' : 'which',
                    'whieh' : 'which',
                    'whilc' : 'while',
                    'whitc' : 'white',
                    'whlch' : 'which',
                    'whlte' : 'white',
                    'who1e' : 'whole',
                    'whoUie' : 'whole',
                    'whoUj' : 'whole',
                    'whoUv' : 'whole',
                    'whofc' : 'whose',
                    'whofe' : 'whose',
                    'whohe' : 'whole',
                    'wholc' : 'whole',
                    'whos^e' : 'whose',
                    'whosc' : 'whose',
                    'wi11' : 'will',
                    'wiU' : 'will',
                    'wiUa' : 'will',
                    'wiUi' : 'will',
                    'widc' : 'wide',
                    'wifc' : 'wife',
                    'wifh' : 'wish',
                    'wifli' : 'wish',
                    'wiihin' : 'within',
                    'wiihout' : 'without',
                    'wiiicli' : 'which',
                    'wijh' : 'wish',
                    'wil1' : 'will',
                    'windoAv' : 'window',
                    'windo\v' : 'window',
                    'windoiv' : 'window',
                    'windov' : 'window',
                    'wisb' : 'wish',
                    'wisli' : 'wish',
                    'wit^h' : 'with',
                    'witb' : 'with',
                    'witbiii' : 'within',
                    'witbin' : 'within',
                    'witboiit' : 'without',
                    'witbout' : 'without',
                    'with0ut' : 'without',
                    'with1n' : 'within',
                    'with6ut' : 'without',
                    'withiu' : 'within',
                    'withln' : 'within',
                    'withont' : 'without',
                    'witli' : 'with',
                    'witliin' : 'within',
                    'witliout' : 'without',
                    'wiud' : 'wind',
                    'wlde' : 'wide',
                    'wlfe' : 'wife',
                    'wliat' : 'what',
                    'wliatever' : 'whatever',
                    'wliere' : 'where',
                    'wlietber' : 'whether',
                    'wliether' : 'whether',
                    'wliich' : 'which',
                    'wliicli' : 'which',
                    'wliile' : 'while',
                    'wliite' : 'white',
                    'wliole' : 'whole',
                    'wliom' : 'whom',
                    'wliose' : 'whose',
                    'wliy' : 'why',
                    'wlll' : 'will',
                    'wlnd' : 'wind',
                    'wlsh' : 'wish',
                    'wlth' : 'with',
                    'wlthin' : 'within',
                    'wlthout' : 'without',
                    'wmd' : 'wind',
                    'woiUd' : 'world',
                    'woid' : 'word',
                    'woild' : 'world',
                    'womau' : 'woman',
                    'wondcr' : 'wonder',
                    'wonld' : 'would',
                    'wor1d' : 'world',
                    'worUI' : 'world',
                    'worUi' : 'world',
                    'wor^d' : 'word',
                    'worrv' : 'worry',
                    'wotUd' : 'world',
                    'wou1d' : 'would',
                    'wouUI' : 'would',
                    'wouUi' : 'would',
                    'wouhd' : 'would',
                    'wovUd' : 'would',
                    'woxUd' : 'world',
                    'wr1te' : 'write',
                    'wr1ter' : 'writer',
                    'writc' : 'write',
                    'writcr' : 'writer',
                    'wrlte' : 'write',
                    'wrlter' : 'writer',
                    'wære' : 'where',
                    'x)Osition' : 'position',
                    'x)Ower' : 'power',
                    'x)aper' : 'paper',
                    'x)art' : 'part',
                    'x)articular' : 'particular',
                    'x)arty' : 'party',
                    'x)ass' : 'pass',
                    'x)atient' : 'patient',
                    'x)ay' : 'pay',
                    'x)eace' : 'peace',
                    'x)eople' : 'people',
                    'x)erhaps' : 'perhaps',
                    'x)eriod' : 'period',
                    'x)erson' : 'person',
                    'x)ersonal' : 'personal',
                    'x)lace' : 'place',
                    'x)lan' : 'plan',
                    'x)litics' : 'politics',
                    'x)oint' : 'point',
                    'x)olitical' : 'political',
                    'x)oor' : 'poor',
                    'x)osition' : 'position',
                    'x)ositive' : 'positive',
                    'x)ossible' : 'possible',
                    'x)ower' : 'power',
                    'x)ractice' : 'practice',
                    'x)resent' : 'present',
                    'x)ressure' : 'pressure',
                    'x)revent' : 'prevent',
                    'x)rice' : 'price',
                    'x)rivate' : 'private',
                    'x)robably' : 'probably',
                    'x)rocess' : 'process',
                    'x)roduce' : 'produce',
                    'x)roduction' : 'production',
                    'x)roperty' : 'property',
                    'x)rove' : 'prove',
                    'x)ublic' : 'public',
                    'x)urpose' : 'purpose',
                    'x)ut' : 'put',
                    'xUthough' : 'although',
                    'xehgious' : 'religious',
                    'xvestern' : 'western',
                    'xvhatever' : 'whatever',
                    'xvhether' : 'whether',
                    'xvithout' : 'without',
                    'y)art' : 'part',
                    'y)arty' : 'party',
                    'y)ay' : 'pay',
                    'y)eople' : 'people',
                    'y)lace' : 'place',
                    'y)resent' : 'present',
                    'y)robably' : 'probably',
                    'y)roperty' : 'property',
                    'y)ublic' : 'public',
                    'y)ut' : 'put',
                    'y/hich' : 'which',
                    'y/hole' : 'whole',
                    'y/hom' : 'whom',
                    'y/ith' : 'with',
                    'y/ithin' : 'within',
                    'y/ithout' : 'without',
                    'y/ould' : 'would',
                    'y0ung' : 'young',
                    'y0ur' : 'your',
                    'y6ung' : 'young',
                    'y6ur' : 'your',
                    'yATURAL' : 'natural',
                    'y^ear' : 'year',
                    'y^es' : 'yes',
                    'y^et' : 'yet',
                    'y^ou' : 'you',
                    'y^oung' : 'young',
                    'y^our' : 'your',
                    'y^same' : 'same',
                    'y^that' : 'that',
                    'y^then' : 'then',
                    'yarioiis' : 'various',
                    'ycar' : 'year',
                    'yef' : 'yes',
                    'yeff' : 'yes',
                    'yourfclf' : 'yourself',
                    'yourfelf' : 'yourself',
                    'yourfelff' : 'yourself',
                    'yourfell' : 'yourself',
                    'yourlelf' : 'yourself',
                    'yoursclf' : 'yourself',
                    'yourseU' : 'yourself',
                    'yourſelſ' : 'yourself',
                    'yvhatever' : 'whatever',
                    'yvhether' : 'whether',
                    'yvithout' : 'without',
                    'zbort' : 'short',
                    'zeien' : 'seven',
                    'zoutb' : 'south',
                    'zthoſe' : 'those',
                    'zvestern' : 'western',
                    'zvhatever' : 'whatever',
                    'zvhether' : 'whether',
                    'zvithout' : 'without',
                    'zſhe' : 'she',
                    'zſhould' : 'should',
                    'zſit' : 'sit'}

Slang_Nouns = [['terror', 'abdabs', 'abdabs'], ['money', 'ackers', 'ackers'], ['money', 'bugs bunny', 'bugs bunny'], ['money', 'bunce', 'bunce'], ['water', "Adam's ale", "Adam's ales"], ['advertisement', 'advert', 'adverts'], ['afternoon', 'afto', 'aftos'], ['aggression', 'aggro', 'aggros'], ['violence', 'aggro', 'aggros'], ['underwear', 'Alan Whickers', 'Alan Whickers'], ['alcoholic', 'alkie', 'alkies'], ['bar', 'all time loser', 'all time losers'], ['sock', 'almond rock', 'almond rocks'], ['lager', 'amber nectar', 'amber nectars'], ['brake', 'anchor', 'anchors'], ['stair', 'apple and pear', 'apples and pears'], ['trouble', 'argy-bargy', 'argy-bargies'], ['afternoon', 'avvy', 'avvies'], ['guitar', 'axe', 'axes'], ['fool', 'baboon', 'baboons'], ['bribe', 'backhander', 'backhanders'], ['tobacco', 'backy', 'backies'], ['towel', 'baden powell', 'baden powells'], ['mouth', 'bake', 'bakes'], ['tip', 'baksheesh', 'baksheeshes'], ['idea', 'baldy notion', 'baldy notions'], ['queen', 'baked bean', 'baked beans'], ['balaclava', 'bally', 'ballies'], ['nonsense', 'baloney', 'baloneys'], ['sausage', 'banger', 'bangers'], ['shovel', 'banjo', 'banjos'], ['hair', 'barnet', 'barnets'], ['argument', 'barney', 'barneys'], ['attempt', 'bash', 'bashes'], ['bastard', 'basket', 'baskets'], ['judge', 'beak', 'beaks'], ['eye', 'beady', 'beadies'], ['drink', 'belt', 'belts'], ['nothing', 'zilch', 'zilch'], ['nap', "z's", "z's"], ['home', 'yam', 'yams'], ['hooligan', 'yob', 'yobs'], ['coward', 'yitney', 'yitneys'], ['vegetable', 'veg', 'veg'], ['atmosphere', 'vibe', 'vibes'], ['vodka', 'voddy', 'voddy'], ['vomit', 'vom', 'vom'], ['doctor', 'quack', 'quacks'], ['u-turn', 'u-ee', 'u-ees'], ['head', 'uncle ned', 'uncle neds'], ['rabbit', 'underground chicken', 'underground chickens'], ['university', 'uni', 'unis'], ['vomit', 'upchuck', 'upchucks'], ['cutlery', 'eating irons', 'eating irons'], ['idiot', 'eejit', 'eejits'], ['tourist', 'emmet', 'emmets'], ['area', 'endz', 'endz'], ['expatriate', 'expat', 'expats'], ['jewellery', 'ice', 'ice'], ['piano', 'ivories', 'ivories'], ['party', 'beanfeast', 'beanfeasts'], ['money', 'beer tokens', 'beer tokens'], ['complaint', 'belly-ache', 'belly-aches'], ['food', 'belly timber', 'belly timber'], ['idiot', 'berk', 'berks'], ['drink', 'bevvy', 'bevvys'], ['cookie', 'bicky', 'bickies'], ['cancer', 'big c', 'big c'], ['hammer', 'birmingham screwdriver', 'birmingham screwdrivers'], ['police', 'bizzies', 'bizzies'], ['gossip', 'blabbermouth', 'blabbermouths'], ['robber', 'blagger', 'blaggers'], ['toilet', 'bog', 'bogs'], ['cocaine', 'bolivian marching powder', 'bolivian marching powder'], ['jewellery', 'bling bling', 'bling blings'], ['man', 'bloke', 'blokes'], ['mistake', 'bloomer', 'bloomers'], ['policeman', 'bobby', 'bobbies'], ['person', 'bod', 'bods'], ['intellectual', 'boffin', 'boffins'], ['head', 'bonce', 'bonces'], ['helmet', 'bonedome', 'bonedomes'], ['mistake', 'booboo', 'booboos'], ['drink', 'booze', 'booze'], ['bar', 'boozer', 'boozers'], ['alcoholic', 'boozer', 'boozers'], ['nonsense', 'bosh', 'bosh'], ['nonsense', 'bullshit', ' bullshit'], ['boyfriend', 'boyf', 'boyfs'], ['trouble', 'bovver', 'bovvers'], ['umbrella', 'brolly', 'brollies'], ['brother', 'bro', 'bros'], ['beer', 'britney', 'britneys'], ['money', 'bread', 'bread'], ['friend', 'bredrin', 'bredrins'], ['hooligan', 'bovver boy', 'bovver boys'], ['courage', 'bottle', 'bottles'], ['cigarette', 'tab', 'tabs'], ['moustache', 'tash', 'tashes'], ['wife', 'trouble and strife', 'troubles and strifes'], ['alleyway', 'twittern', 'twitterns'], ['twin', 'twinnie', 'twinnies'], ['idiot', 'turnip', 'turnips'], ['thief', 'tea leaf', 'tea leaves'], ['rubbish', 'tat', 'tats'], ['junk', 'tat', 'tats'], ['television', 'telly', 'tellies'], ['marijuana', 'tex mex', 'tex mex'], ['thing', 'thang', 'thangs'], ['cloth', 'thread', 'threads'], ['lavatory', 'throne', 'thrones'], ['toilet', 'thunderbox', 'thunderboxes'], ['reprimand', 'ticking off', 'ticking offs'], ['style', 'tip', 'tips'], ['manner', 'tip', 'tips'], ['fool', 'toby jug', 'toby jugs'], ['soccer', 'togger', 'togger'], ['nonsense', 'tommy-rot', 'tommy-rots'], ['rubbish', 'tommy-rot', 'tommy-rots'], ['condom', 'tonky', 'tonkies'], ['boss', 'top banana', 'top bananas'], ['bicycle', 'treader', 'treaders'], ['underwear', 'trolleys', 'trolleys'], ['food', 'tuck', 'tucks'], ['turnip', 'tumshie', 'tumshies'], ['rubbish', 'tut', 'tuts'], ['nonsense', 'tut', 'tuts'], ['fool', 'twerp', 'twerps'], ['leg', 'lally', 'lallies'], ['woman', 'lass', 'lasses'], ['mouth', 'laughing gear', 'laughing gears'], ['electricity', 'lecky', 'lecky'], ['legend', 'ledge', 'ledges'], ['fool', 'lemon', 'lemons'], ['idiot', 'lemon', 'lemons'], ['disappointment', 'let down', 'let downs'], ['head', 'loaf', 'loaves'], ['language', 'lingo', 'lingos'], ['pill', 'little', 'littles'], ['money', 'lolly', 'lolly'], ['hippy', 'long-hair', 'long-hairs'], ['lavatory', 'loo', 'loos'], ['toilet', 'loo', 'loos'], ['money', 'lookah', 'lookah'], ['ear', 'lug', 'lugs'], ['thousand', 'K', 'Ks'], ['kilogram', 'K', 'Ks'], ['underwear', 'kegs', 'kegs'], ['toilet', 'kermit', 'kermits'], ['candy', 'ket', 'kets'], ['watch', 'kettle', 'kettles'], ['idiot', 'knobber', 'knobbers'], ['mouth', 'kisser', 'kissers'], ['sleep', 'kip', 'kips'], ['blame', 'rap', 'raps'], ['nonsense', 'ratshit', 'ratshits'], ['rubbish', 'ratshit', 'ratshits'], ['squirrel', 'rat with furry tail', 'rats with furry tails'], ['pigeon', 'rat with wing', 'rats with wings'], ['money', 'readies', 'readies'], ['parent', 'rent', 'rents'], ['hair', 'riah', 'riahs'], ['diamond', 'rock', 'rocks'], ['policeman', 'rozzer', 'rozzers'], ['pub', 'rub-a-dub', 'rub-a-dubs'], ['condom', 'rubber johnny', 'rubber johnnies'], ['sea', 'oggin', 'oggins'], ['water', 'oggin', 'oggins'], ['cigarette', 'oily', 'oilies'], ['mother', 'old lady', 'old ladies'], ['father', 'old man', 'old men'], ['fool', 'omadhaun', 'omadhauns'], ['simpleton', 'omadhaun', 'omadhauns'], ['fluff', 'oose', 'oose'], ['dismissal', 'order of the boot', 'orders of the boot'], ['vaccination', 'jab', 'jabs'], ['hill', 'jack', 'jacks'], ['story', 'jackanory', 'jackanories'], ['food', 'jackbit', 'jackbits'], ['injection', 'jag', 'jags'], ['alcoholic', 'jake', 'jakes'], ['car', 'jam jar', 'jam jars'], ['pyjama', 'jammy', 'jammies'], ['nonsense', 'jank', 'jank'], ['rubbish', 'jank', 'jank'], ['wasp', 'jasper', 'jaspers'], ['idiot', 'jerk', 'jerks'], ['sandal', 'Jesus boot', 'Jesus boots'], ['deception', 'jiggery pokery', 'jiggery pokeries'], ['trickery', 'jiggery pokery', 'jiggery pokeries'], ['holiday', 'jolly', 'jollies'], ['vacation', 'jollies', 'jollies'], ['dollop', 'jollop', 'jollops'], ['journalist', 'journo', 'journos'], ['prison', 'jug', 'jugs'], ['petrol', 'juice', 'juices'], ['electricity', 'juice', 'juices'], ['pill', 'jimmy hill', 'jimmy hills'], ['dinner', 'jim skinner', 'jim skinners'], ['hassle', 'jip', 'jips'], ['alleyway', 'jitty', 'jitties'], ['taxi', 'joe baxi', 'joe baxies'], ['musician', 'muso', 'musos'], ['mushroom', 'mushy', 'mushies'], ['cat', 'moggie', 'moggies'], ['milk', 'moo juice', 'moo juices'], ['money', 'moolah', 'moolah'], ['McDonalds', "Maccy D's", "Maccy D's"], ['nonsense', 'malarkey', 'malarkeys'], ['foolishness', 'malarkey', 'malarkeys'], ['scar', 'mars bar', 'mars bars'], ['marijuana', 'mary jane', 'mary jane'], ['friend', 'mate', 'mates'], ['eye', 'mince pie', 'mince pies'], ['killjoy', 'misery-guts', 'misery-guts'], ['moment', 'mo', 'mos'], ['mouth', 'mush', 'mushes'], ['food', 'munch', 'munchies'], ['snack', 'munch', 'munches'], ['face', 'mug', 'mugs'], ['mouth', 'mug', 'mugs'], ['idiot', 'muffin', 'muffins'], ['fool', 'muffin', 'muffins'], ['mosquito', 'mozzy', 'mozzies'], ['gin', "mother's ruin", "mother's ruins"], ['idiot', 'muppet', 'muppets'], ['marijuana', 'wacky backy', 'wacky backy'], ['cannabis', 'wacky backy', 'wacky backy'], ['idiot', 'wally', 'wallies'], ['wasp', 'wap', 'waps'], ['idiot', 'wassock', 'wassocks'], ['imbecile', 'wassock', 'wassocks'], ['fool', 'wasteman', 'wastemen'], ['coat', 'weasel', 'weasels'], ['jacket', 'weasel', 'weasels'], ['money', 'wedge', 'wedges'], ['marijuana', 'weed', 'weeds'], ['cannabis', 'weed', 'weeds'], ['eccentric', 'weirdo', 'weirdos'], ['cider', 'winona ryder', 'winona ryders'], ['money', 'wonga', 'wongas'], ['idiot', 'wolly', 'wollies'], ['beer', 'wobbly pop', 'wobbly pops'], ['suit', 'whistle', 'whistles'], ['coffin', 'wooden overcoat', 'wooden overcoats'], ['lunatic', 'nutter', 'nutters'], ['lunatic', 'nutcase', 'nutcases'], ['eccentric', 'nutcase', 'nutcases'], ['idiot', 'nutter', 'nutters'], ['grandmother', 'nan', 'nanies'], ['novice', 'noob', 'noobs'], ['beginner', 'noob', 'noobs'], ['head', 'noodle', 'noodles'], ['food', 'nom nom', 'noms noms'], ['condom', 'nodder', 'nodders'], ['head', 'noggin', 'noggins'], ['handkerchief', 'nose-rag', 'nose-rags'], ['food', 'nosh', 'noshes'], ['idiot', 'nugget', 'nuggets'], ['fool', 'nugget', 'nuggets'], ['food', 'nose-bag', 'nose-bags'], ['meal', 'nose-bag', 'nose-bags'], ['cafe', 'noshery', 'nosheries'], ['restaurant', 'noshery', 'nosheries'], ['pub', 'nuclear sub', 'nuclear subs'], ['bar', 'nuclear sub', 'nuclear subs'], ['fool', 'numpty', 'numpties'], ['idiot', 'numpty', 'numpties'], ['fool', 'nerk', 'nerks'], ['nose', 'neb', 'nebs'], ['toilet', 'nettie', 'netties'], ['novice', 'newbie', 'newbies'], ['beginner', 'newbie', 'newbies'], ['newspaper', 'newsy', 'newsies'], ['snack', 'nibble', 'nibbles'], ['prison', 'nick', 'nicks'], ['terror', 'habdabs', 'habdabs'], ['idiot', 'helmet', 'helmets'], ['egg', 'hen fruit', 'hen fruits'], ['marijuana', 'hippy lettuce', 'hippy lettuces'], ['tantrum', 'hissy fit', 'hissy fits'], ['holiday', 'hol', 'hols'], ['friend', 'homie', 'homies'], ['nonsense', 'hooey', 'hooeys'], ['Wednesday', 'hump day', 'hump days'], ['injection', 'hit', 'hits'], ['murder', 'hit', 'hits'], ['mess', 'hames', 'hames'], ['pseudonym', 'handle', 'handles'], ['alias', 'handle', 'handles'], ['nonsense', 'hot air', 'hot air'], ['lunatic', 'head-the-ball', 'head-the-balls'], ['idiot', 'head-the-ball', 'head-the-balls'], ['boss', 'head-honcho', 'head-honchos'], ['nonsense', 'hogwash', 'hogwash'], ['rubbish', 'hogwash', 'hogwash'], ['lunatic', 'headcase', 'headcases'], ['lout', 'hoon', 'hoons'], ['commotion', 'hoo-ha', 'hoo-has'], ['trouble', 'hoo-ha', 'hoo-has'], ['mess', 'horlicks', 'horlicks'], ['snack', 'pack up', 'pack ups'], ['room', 'pad', 'pads'], ['home', 'pad', 'pads'], ['tantrum', 'paddy', 'paddies'], ['friend', 'pal', 'pals'], ['proletariat', 'prole', 'proles'], ['bet', 'punt', 'punts'], ['risk', 'punt', 'punts'], ['gamble', 'punt', 'punts'], ['nonsense', 'parp', 'parp'], ['rubbish', 'parp', 'parp'], ['people', 'peeps', 'peeps'], ['soldier', 'pongo', 'pongos'], ['marijuana', 'piff', 'piffs'], ['idiot', 'plank', 'planks'], ['beating', 'pasting', 'pasting'], ['stink', 'pen and ink', 'pen and ink'], ['simpleton', 'pie-eater', 'pie-eaters'], ['mouth', 'pie-hole', 'pie-holes'], ['computer', 'pooter', 'pooters'], ['police', 'po po', 'po po'], ['money', 'poppy', 'poppy'], ['postman', 'postie', 'posties'], ['postwoman', 'postie', 'posties'], ['marijuana', 'pot', 'pot'], ['present', 'prezzie', 'prezzies'], ['gift', 'prezzie', 'prezzies'], ['brawl', 'punch up', 'punch ups'], ['crash', 'purler', 'purlers'], ['infatuation', 'pash', 'pashes'], ['tramp', 'paraffin', 'paraffins'], ['vagrant', 'paraffin', 'paraffins'], ['idiot', 'pilchard', 'pilchards'], ['alcohol', 'poison', 'poison'], ['drink', 'peeve', 'peeves'], ['toilet', 'pan', 'pans'], ['policecar', 'panda', 'pandas'], ['dole', 'pancrack', 'pancracks'], ['discussion', 'palaver', 'palavers'], ['bed', 'pit', 'pits'], ['nonsense', 'piffle', 'piffles'], ['drivel', 'piffle', 'piffles'], ['fool', 'pie-can', 'pie-cans'], ['idiot', 'pie-can', 'pie-cans'], ['mess', "pig's ear", "pig's ears"], ['disaster', "pig's ear", "pig's ears"], ['idiot', 'prannock', 'prannocks'], ['trouble', 'pickle', 'pickles'], ['idiot', 'prannet', 'prannets'], ['imbecile', 'prannet', 'prannets'], ['crash', 'prang', 'prangs'], ['accident', 'prang', 'prangs'], ['feet', 'plate', 'plates'], ['leg', 'pin', 'pins'], ['pantomine', 'panto', 'pantos'], ['fingerprint', 'dab', 'dabs'], ['fool', 'daftie', 'dafties'], ['idiot', 'daftie', 'dafties'], ['idiot', 'dumbnut', 'dumbnuts'], ['stair', 'dancer', 'dancers'], ['idiot', 'dimbo', 'dimbos'], ['fool', 'dimbo', 'dimbos'], ['dusk', 'dimpsey', 'dimpseys'], ['twilight', 'dimpsey', 'dimpseys'], ['shower', 'david gower', 'david gowers'], ['house', 'drum', 'drums'], ['home', 'drum', 'drums'], ['look', 'deek', 'deeks'], ['glance', 'deek', 'deeks'], ['money', 'dough', 'dough'], ['tranquillizer', 'downer', 'downers'], ['Australia', 'down under', 'down under'], ['alleyway', 'drangway', 'drangways'], ['thirst', 'drooth', 'drooths'], ['condom', 'dunky', 'dunkies'], ['toilet', 'dunny', 'dunnies'], ['clerk', 'desk pilot', 'desk pilots'], ['money', 'dosh', 'dosh'], ['idiot', 'dunderhead', 'dunderheads'], ['nonsense', 'double dutch', 'double dutch'], ['laundry', 'doby', 'dobbies'], ['idiot', 'div', 'divs'], ['imbecile', 'dimmock', 'dimmocks'], ['idiot', 'dimmock', 'dimmocks'], ['dinner', 'din-dins', 'din-dins'], ['argument', 'ding-dong', 'ding-dongs'], ['commotion', 'ding-dong', 'ding-dongs'], ['fight', 'ding-dong', 'ding-dongs'], ['shirt', 'dicky dirt', 'dicky dirts'], ['gypsy', 'diddicoy', 'diddicoys'], ['rag', 'dwile', 'dwiles'], ['fight', 'dust-up', 'dust-ups'], ['quarrel', 'dust-up', 'dust-ups'], ['idiot', 'durbrain', 'durbrains'], ['fool', 'durbrain', 'durbrains'], ['look', 'dekko', 'dekkos'], ['glance', 'dekko', 'dekkos'], ['claim', 'dibs', 'dibs'], ['lodging', 'digs', 'digs'], ['accommodation', 'digs', 'digs'], ['snack', 'docky', 'dockies'], ['telephone', 'dog and bone', 'dogs and bones'], ['policeman', 'dibble', 'dibbles'], ['policewoman', 'dibble', 'dibbles'], ['fool', 'duckegg', 'duckeggs'], ['idiot', 'duckegg', 'duckeggs'], ['idiot', 'digby', 'digbies'], ['imbecile', 'digby', 'digbies'], ['punch', 'dry slap', 'dry slaps'], ['stone', 'ducker', 'duckers'], ['idiot', 'doughnut', 'doughnuts'], ['nothing', 'diddly-squat', 'diddly-squat'], ['jacket', 'desmond', 'desmonds'], ['cost', 'damage', 'damages'], ['expense', 'damage', 'damages'], ['walk', 'dander', 'danders'], ['wander', 'dander', 'danders'], ['gram', 'g', 'gs'], ['boss', 'gaffer', 'gaffers'], ['marijuana', 'ganja', 'ganja'], ['cigarette', 'gasper', 'gaspers'], ['policeman', 'gavver', 'gavvers'], ['policewoman', 'gavver', 'gavvers'], ['heed', 'gawm', 'gawms'], ['notice', 'gawm', 'gawms'], ['attention', 'gawm', 'gawms'], ['information', 'gen', 'gen'], ['idiot', 'gimboid', 'gimboids'], ['fool', 'gimboid', 'gimboids'], ['idiot', 'gobbin', 'gobbins'], ['fool', 'gobbin', 'gobbins'], ['alleyway', 'gennell', 'gennells'], ['passageway', 'gennell', 'gennells'], ['nonsense', 'gobbledygook', 'gobbledygook'], ['neck', 'gregory', 'gregories'], ['marijuana', 'green', 'greens'], ['look', 'gander', 'ganders'], ['glance', 'gander', 'ganders'], ['nonsense', 'gobbledygook', 'gobbledygooks'], ['television', 'gogglebox', 'goggleboxes'], ['idiot', 'goit', 'goits'], ['fool', 'goit', 'goits'], ['pullover', 'gansie', 'gansies'], ['jumper', 'gansie', 'gansies'], ['sweater', 'gansie', 'gansies'], ['headbutt', 'glasgow kiss', 'glasgow kisses'], ['idiot', 'gonk', 'gonks'], ['railway', 'gricer', 'gricers'], ['train', 'gricer', 'gricers'], ['bicycle', 'grod', 'grods'], ['underwear', 'grundies', 'grundies'], ['power', 'grunt', 'grunt'], ['hassle', 'gyp', 'gyps'], ['bother', 'gyp', 'gyps'], ['nonsense', 'gumf', 'gumf'], ['rubbish', 'gumf', 'gumf'], ['policeman', 'grasshopper', 'grasshoppers'], ['trouble', 'grief', 'griefs'], ['hassle', 'grief', 'griefs'], ['informer', 'grasser', 'grassers'], ['news', 'griff', 'griff'], ['information', 'griff', 'griff'], ['fool', 'goon', 'goons'], ['leg', 'gam', 'gams'], ['marijuana', 'grass', 'grasses'], ['resourcefulness', 'gumption', 'gumption'], ['initiative', 'gumption', 'gumption'], ['look', 'goosey', 'gooseys'], ['dirt', 'grot', 'grot'], ['rubbish', 'grot', 'grot'], ['lunatic', 'fruit and nut case', 'fruit and nut cases'], ['misbehaviour', 'funny business', 'funny businesses'], ['deception', 'funny business', 'funny businesses'], ['idiot', 'fannybaws', 'fannybaws'], ['fool', 'fannybaws', 'fannybaws'], ['road', 'frog and toad', 'frogs and toads'], ['forehead', 'fod', 'fods'], ['backyard', 'fode', 'fodes'], ['money', 'folding', 'folding'], ['brawl', 'fisticuffs', 'fisticuffs'], ['football', 'fitba', 'fitba'], ['face', 'fizzog', 'fizzogs'], ['cinema', 'flicks', 'flicks'], ['movie', 'flicks', 'flicks'], ['family', 'fam', 'fams'], ['friend', 'fam', 'fams'], ['festival', 'fest', 'fests'], ['film', 'fillem', 'fillems'], ['police', 'filth', 'filth'], ['fundamentalist', 'fundy', 'fundies'], ['bench', 'form', 'forms'], ['bet', 'flutter', 'flutters'], ['police', 'fuzz', 'fuzz'], ['tobacco', 'salmon and trout', 'salmons and trouts'], ['sandwich', 'sanger', 'sangers'], ['heroin', 'scag', 'scag'], ['trick', 'scam', 'scams'], ['drink', 'scoop', 'scoops'], ['underwear', 'scuds', 'scuds'], ['food', 'snappin', 'snappins'], ['gun', 'strap', 'straps'], ['sunglass', 'sunny', 'sunnies'], ['vomit', 'spew', 'spews'], ['nose', 'snotbox', 'snotboxes'], ['drunkard', 'soak', 'soaks'], ['sparrow', 'spadger', 'spadgers'], ['vehicle', 'set of wheels', 'set of wheels'], ['money', 'sovs', 'sovs'], ['scavenger', 'scav', 'scavs'], ['policeman', 'scuffer', 'scuffers'], ['prison', 'shovel', 'shovels'], ['tea', 'splosh', 'sploshes'], ['child', 'sprog', 'sprogs'], ['thief', 'sticky fingers', 'sticky fingers'], ['alleyway', 'snicket', 'snickets'], ['electrician', 'spark', 'sparks'], ['drink', 'sauce', 'sauces'], ['food', 'scran', 'scran'], ['steroid', 'sted', 'steds'], ['money', 'spondulicks', 'spondulicks'], ['drink', 'sherbet', 'sherbets'], ['taxi', 'sherbet', 'sherbets'], ['swindle', 'swizz', 'swizzes'], ['dawn', 'sparrowfart', 'sparrowfarts'], ['parody', 'send up', 'send ups'], ['fight', 'swedge', 'swedges'], ['food', 'scram', 'scrams'], ['scratch', 'scram', 'scrams'], ['nuisance', 'scunner', 'scunners'], ['drink', 'shant', 'shants'], ['idiot', 'silly bugger', 'silly buggers'], ['fool', 'silly bugger', 'silly buggers'], ['heroin', 'skag', 'skags'], ['skinhead', 'skin', 'skins'], ['sister', 'skin', 'skins'], ['information', 'skinny', 'skinny'], ['detail', 'skinny', 'skinny'], ['nonsense', 'squit', 'squit'], ['rubbish', 'squit', 'squit'], ['tantrum', 'stecky', 'steckies'], ['head', 'swede', 'swedes'], ['cafe', 'caff', 'caffs'], ['cousin', 'cuz', 'cuzes'], ['friend', 'cuz', 'cuzes'], ['canal', 'cut', 'cuts'], ['headphone', 'can', 'cans'], ['cardigan', 'cardie', 'cardies'], ['mouth', 'cake-hole', 'cake-holes'], ['cigarette', 'cancer stick', 'cancer sticks'], ['water', 'council pop', 'council pops'], ['cocaine', 'ching', 'chings'], ['conversation', 'chin-wag', 'chin-wags'], ['chat', 'chin-wag', 'chin-wags'], ['mouth', 'chops', 'chops'], ['vomit', 'chunder', 'chunders'], ['cigarette', 'cig', 'cigs'], ['cigarette', 'ciggy', 'ciggies'], ['blood', 'claret', 'clarets'], ['mud', 'clart', 'clarts'], ['prison', 'clink', 'clinks'], ['idiot', 'clot', 'clots'], ['fool', 'clot', 'clots'], ['nonsense', 'codswallop', 'codswallop'], ['cigarette', 'coffin nail', 'coffin nails'], ['cocaine', 'coke', 'cokes'], ['nose', 'conk', 'conks'], ['policeman', 'copper', 'coppers'], ['policewoman', 'copper', 'coppers'], ['policeman', 'cop', 'cops'], ['policewoman', 'cop', 'cops'], ['cocaine', 'chisel', 'chisels'], ['tooth', 'chopper', 'choppers'], ['prison', 'chokey', 'chokeys'], ['food', 'chow', 'chows'], ['clue', 'scooby', 'scoobies'], ['champagne', 'champs', 'champs'], ['cocaine', 'chang', 'changs'], ['arm', 'chalk', 'chalks'], ['tea', 'char', 'chars'], ['cocaine', 'charlie', 'charlies'], ['fool', 'charlie', 'charlies'], ['idiot', 'charlie', 'charlies'], ['friend', 'charver', 'charvers'], ['boy', 'charver', 'charvers'], ['child', 'chavvy', 'chavvies'], ['face', 'chevy', 'chevies'], ['flirtation', 'chirpsing', 'chirpsings'], ['rubbish', 'crud', 'cruds'], ['dirt', 'crud', 'cruds'], ['nonsense', 'crock', 'crock'], ['Christmas', 'crimbo', 'crimbos'], ['gang', 'crewage', 'crewages'], ['toilet', 'crapper', 'crappers'], ['sycophant', 'crawler', 'crawlers'], ['jean', 'steve mcqueen', 'steve mcqueens'], ['look', 'squiz', 'squizes'], ['glance', 'squiz', 'squizes'], ['milk', 'cow juice', 'cow juices'], ['face', 'coupon', 'coupons'], ['nonsense', 'crap', 'craps'], ['rubbish', 'crap', 'craps'], ['waste', 'crap', 'craps'], ['water', 'corporation pop', 'corporation pops'], ['hysterics', 'conniption', 'conniptions'], ['excuse', 'cop-out', 'cop-outs'], ['farmer', 'clodhopper', 'clodhoppers'], ['bed', 'sack', 'sacks'], ['splinter', 'skelf', 'skelfs'], ['priest', 'skypilot', 'skypilots'], ['confectionary', 'snashters', 'snashters'], ['sparrow', 'spuggy', 'spuggies'], ['money', 'sobs', 'sobs'], ['tobacco', 'snout', 'snouts'], ['informer', 'snout', 'snouts'], ['fool', 'chump', 'chumps'], ['head', 'chump', 'chumps'], ['friend', 'chum', 'chums'], ['train', 'chuffer', 'chuffers'], ['underwear', 'chuddies', 'chuddies'], ['underpant', 'chuddies', 'chuddies'], ['knife', 'chib', 'chibs'], ['blade', 'chib', 'chibs'], ['SUV', 'chelsea tractor', 'chelsea tractors'], ['underpant', 'cack', 'cacks'], ['trouser', 'cack', 'cacks'], ['rubbish', 'cack', 'cacks'], ['saboteur', 'sab', 'sabs'], ['sabotage', 'sab', 'sabs'], ['mushroom', 'shroom', 'shrooms'], ['supermarket', 'soopy', 'soopies'], ['handkerchief', 'snot rag', 'snot rags'], ['informer', 'snitcher', 'snitchers'], ['heroin', 'smack', 'smacks'], ['chocolate', 'chocker', 'chockers'], ['chat', 'conflab', 'conflabs'], ['conversation', 'conflab', 'conflabs'], ['fragment', 'skerret', 'skerrets'], ['underwear', 'skids', 'skids'], ['underpant', 'skids', 'skids'], ['idiot', 'smeghead', 'smegheads'], ['look', 'skeg', 'skegs'], ['boastfulness', 'side', 'sides'], ['arrogance', 'side', 'sides'], ['hand', 'spud', 'spuds'], ['food', 'snap', 'snaps'], ['snack', 'snap', 'snaps'], ['spy', 'spook', 'spooks'], ['ghost', 'spook', 'spooks'], ['man', 'chap', 'chaps'], ['temper', 'cob on', 'cob on'], ['lavatory', 'cludgie', 'cludgies'], ['insect', 'creepy-crawly', 'creepy-crawlies'], ['spider', 'creepy-crawly', 'creepy-crawlies'], ['mistake', 'clanger', 'clangers'], ['blunder', 'clanger', 'clangers'], ['nothing', 'sod-all', 'sod-all'], ['carpenter', 'chippy', 'chippies'], ['nothing', 'chuff-all', 'chuff-all'], ['look', 'shufty', 'shufties'], ['glance', 'shufty', 'shufties'], ['hassle', 'stick', 'sticks'], ['effort', 'stick', 'sticks'], ['impudence', 'chelp', 'chelp'], ['sun', 'currant bun', 'currant buns']]
Slang_Adverbs = [['absolutely', 'absobloodylutely'], ['anyway', 'any road'], ['greatly', 'big style'], ['blatantly', 'blates'], ['totally', 'totes'], ['completely', 'totes'], ['entirely', 'totes'], ['definitely', 'totes'], ['speedily', 'lickety-split'], ['extremely', 'rollicking'], ['obviously', 'obvs'], ['nothing', 'nish'], ['none', 'nix'], ['enough', 'nuff'], ['naturally', 'natch'], ['perhaps', 'happen'], ['friendly', 'pally'], ['lively', 'pumping'], ['extremely', 'darn'], ['certainly', 'deffo'], ['extremely', 'docking'], ['immediately', 'dreckly'], ['extremely', 'gurt'], ['excellent', 'smashing'], ['slowly', 'slo-mo'], ['quickly', 'sharpish']]
Slang_Adjectives = [['excellent', 'ace'], ['wonderful', 'ace'], ['overexcited', 'aerated'], ['annoyed', 'aggy'], ['irritated', 'aggy'], ['aggitated', 'aggy'], ['unsophisticated', 'agricultural'], ['drunk', 'airlocked'], ['intoxicated', 'airlocked'], ['insubstantial', 'airy-fairy'], ['drunk', 'aled'], ['furious', 'apeshit'], ['amazing', 'amazeballs'], ['nervous', 'antsy'], ['obvious', 'bait'], ['crazy', 'balmy'], ['insane', 'bananas'], ['hysterical', 'bananas'], ['defeated', 'banjaxed'], ['insane', 'barking'], ['crazy', 'barking'], ['excellent', 'bazzin'], ['drunk', 'bladdered'], ['tired', 'zonked'], ['attractive', 'zhooshy'], ['extravagant', 'zhooshy'], ['disgusting', 'yacky'], ['insane', 'yampy'], ['mad', 'yampy'], ['distasteful', 'yucky'], ['afraid', 'yellow'], ['lewd', 'X-rated'], ['obscene', 'X-rated'], ['pornographic', 'X-rated'], ['orthodox', 'vanilla'], ['conventional', 'vanilla'], ['vegetarian', 'veggie'], ['sick', 'uncle dick'], ['unpredictable', 'unhinged'], ['fantastic', 'unreal'], ['excellent', 'unreal'], ['conventional', 'uptight'], ['premature', 'early doors'], ['emotional', 'emo'], ['correct', 'exactimundo'], ['small', 'ickle'], ['little', 'ickle'], ['sticky', 'icky'], ['nice', 'irie'], ['great', 'irie'], ['incorrect', 'iffy'], ['improbable', 'iffy'], ['rude', 'ignorant'], ['eccentric', 'batty'], ['excellent', 'beezer'], ['great', 'beezer'], ['outstanding', 'belting'], ['wonderful', 'belting'], ['drunk', 'bevvied up'], ['arrogant', 'big headed'], ['stupid', 'birdbrained'], ['rubbish', 'biz'], ['worthless', 'biz'], ['blatant', 'blates'], ['drunk', 'blootered'], ['excellent', 'brilliant'], ['excellent', 'blinding'], ['wonderful', 'blinding'], ['drunk', 'blitzed'], ['intoxicated', 'bobbinsed'], ['correct', 'bob on'], ['unpleasant', 'bogging'], ['vile', 'bogging'], ['disgusting', 'bogging'], ['normal', 'bog-standard'], ['average', 'bog-standard'], ['tired', 'bollocksed'], ['intoxicated', 'bollocksed'], ['crazy', 'bonkers'], ['insane', 'bonkers'], ['attractive', 'boomting'], ['pleasant', 'boomting'], ['wonderful', 'boomting'], ['free', 'buckshee'], ['broken', 'buggered'], ['ruined', 'buggered'], ['disgusting', 'bowfin'], ['unpleasant', 'bowfin'], ['dead', 'brown bread'], ['excellent', 'brill'], ['superb', 'brill'], ['great', 'bostin'], ['good', 'bostin'], ['tangled', 'taffled'], ['insane', 'tapped'], ['drunk', 'trousered'], ['nonsense', 'trousers'], ['gibberish', 'trousers'], ['attractive', 'tasty'], ['scruffy', 'tatty'], ['dirty', 'tatty'], ['untidy', 'tatty'], ['angry', "t'd off"], ['annoyed', "t'd off"], ['stupid', 'thick'], ['angry', 'ticked off'], ['annoyed', 'ticked off'], ['small', 'tiddly'], ['good', 'tidy'], ['satisfactory', 'tidy'], ['drunk', 'tight'], ['drunk', 'tired and emotional'], ['insignificant', 'titchy'], ['armed', 'tooled'], ['excellent', 'top one'], ['crazy', 'totally hatstand'], ['mad', 'totally hatstand'], ['insane', 'totally hatstand'], ['intoxicated', 'trashed'], ['intoxicated', 'twatted'], ['embarrassing', 'ladgeful'], ['drunk', 'langered'], ['intoxicated', 'langered'], ['excellent', 'large'], ['drunk', 'larruped'], ['intoxicated', 'larruped'], ['drunk', 'leathered'], ['hungry', 'lee marvin'], ['legitimate', 'legit'], ['drunk', 'legless'], ['easy', 'lemon squeezy'], ['simple', 'lemon squeezy'], ['wealthy', 'loaded'], ['drunk', 'loaded'], ['impertinent', 'lippy'], ['mad', 'loopy'], ['insane', 'loopy'], ['excellent', 'lush'], ['appealing', 'lush'], ['finished', 'kaput'], ['drunk', 'kaylied'], ['excellent', 'kewl'], ['wonderful', 'kewl'], ['hungry', 'klempt'], ['tired', 'knackered'], ['broken', 'knackered'], ['thwarted', 'knackered'], ['crazy', 'kooky'], ['eccentric', 'kooky'], ['correct', 'kosher'], ['legitimate', 'kosher'], ['excellent', 'kushty'], ['fine', 'kushty'], ['upset', 'racked off'], ['angry', 'racked off'], ['excellent', 'rad'], ['wonderful', 'rad'], ['insane', 'radge'], ['crazy', 'radge'], ['crazy', 'radio rental'], ['mad', 'radio rental'], ['immense', 'raging'], ['extreme', 'raging'], ['crowded', 'rammed'], ['busy', 'rammed'], ['unsavoury', 'rammy'], ['rotten', 'rammy'], ['excellent', 'random'], ['great', 'random'], ['disgusting', 'rank'], ['ugly', 'rank'], ['good', 'rare'], ['excellent', 'rare'], ['drunk', 'ratted'], ['irritable', 'ratty'], ['good', 'ream'], ['excellent', 'ream'], ['ridiculous', 'ridic'], ['suspicious', 'ropey'], ['dubious', 'ropey'], ['mediocre', 'ropey'], ['drunk', 'ruined'], ['intoxicated', 'ruined'], ['strange', 'rum'], ['odd', 'rum'], ['peculiar', 'rum'], ['intoxicated', 'out of it'], ['unusual', 'oddball'], ['eccentric', 'oddball'], ['strange', 'oddball'], ['drunk', 'jaked'], ['intoxicated', 'jaked'], ['fortunate', 'jammy'], ['lucky', 'jammy'], ['fake', 'jarg'], ['counterfeit', 'jarg'], ['upset', 'jarred off'], ['jealous', 'jel'], ['arrogant', 'jumped up'], ['excellent', 'magic'], ['good', 'mustard'], ['excellent', 'mustard'], ['happy', 'made up'], ['satisfied', 'made up'], ['thrilled', 'made up'], ['enthusiastic', 'mad keen'], ['sick', 'moby'], ['ill', 'moby'], ['moany', 'morngy'], ['whingey', 'morngy'], ['feeble', 'morngy'], ['drunk', 'mortalled'], ['intoxicated', 'mortalled'], ['humid', 'mafting'], ['friendly', 'matey'], ['sociable', 'matey'], ['affable', 'matey'], ['mad', 'mazed'], ['insane', 'mazed'], ['fantastic', 'mega'], ['wonderful', 'mega'], ['insane', 'mental'], ['crazy', 'mental'], ['drunk', 'minced'], ['intoxicated', 'minced'], ['annoyed', 'miffed'], ['peeved', 'miffed'], ['irritated', 'miffed'], ['disgruntled', 'miffed'], ['astonishing', 'mind-blowing'], ['confusing', 'mind-blowing'], ['scruffy', 'minty'], ['dirty', 'minty'], ['suspicious', 'moody'], ['ruined', 'munted'], ['drunk', 'mullered'], ['intoxicated', 'mullered'], ['rude', 'mucky'], ['miserly', 'mingy'], ['stingy', 'mingy'], ['excellent', 'mint'], ['wonderful', 'mint'], ['excellent', 'mintas'], ['marvellous', 'mintas'], ['wonderful', 'mintas'], ['excellent', 'minted'], ['wealthy', 'minted'], ['crazy', 'wacko'], ['insane', 'wacko'], ['crazy', 'wacky'], ['zany', 'wacky'], ['unusual', 'way-out'], ['unconventional', 'way-out'], ['good', 'waxa'], ['excellent', 'waxa'], ['easy', 'wee buns'], ['simple', 'wee buns'], ['intoxicated', 'wazzocked'], ['drunk', 'wellied'], ['intoxicated', 'wellied'], ['tired', 'whacked'], ['intoxicated', 'well gone'], ['clever', 'wide'], ['sharp', 'wide'], ['exhausted', 'wiped out'], ['fantastic', 'wicked'], ['excellent', 'wicked'], ['stressed', 'wired'], ['nervy', 'wired'], ['anxious', 'wired'], ['intoxicated', 'wombled'], ['feeble', 'wimpy'], ['weak', 'wimpy'], ['mad', 'nutty'], ['eccentric', 'nutty'], ['annoyed', 'naffed off'], ['depressed', 'naffed off'], ['excellent', 'nang'], ['great', 'nang'], ['annoyed', 'narked'], ['extremely', 'not half'], ['nearly', 'not half'], ['moody', 'nowty'], ['angry', 'nowty'], ['peevish', 'niggly'], ['easy', 'nimps'], ['simple', 'nimps'], ['elegant', 'nobby'], ['aristocratic', 'nobby'], ['annoyed', 'narky'], ['moody', 'narky'], ['upset', 'narky'], ['unfashionable', 'naff'], ['stylish', 'nifty'], ['annoyed', 'hacked off'], ['depressed', 'hacked off'], ['dirty', 'hacky'], ['scummy', 'hacky'], ['frightening', 'hairy'], ['alarming', 'hairy'], ['tipsy', 'half-cut'], ['stupid', 'half-sharp'], ['dimwitted', 'half-sharp'], ['clumsy', 'ham-fisted'], ['bungling', 'ham-fisted'], ['exhausted', 'hammered'], ['intoxicated', 'hammered'], ['illegal', 'hooky'], ['annoyed', 'humpty'], ['irritated', 'humpty'], ['nervous', 'hyper'], ['agitated', 'hyper'], ['fine', 'hunky-dory'], ['huge', 'humongous'], ['enormous', 'humongous'], ['crazy', 'hatstand'], ['insane', 'hatstand'], ['tough', 'hard'], ['excellent', 'heavy'], ['serious', 'heavy'], ['unattractive', 'hanging'], ['nasty', 'hanging'], ['unsavoury', 'hanging'], ['crowded', 'packed out'], ['tired', 'paggered'], ['exhausted', 'paggered'], ['drunk', 'palatic'], ['intoxicated', 'palatic'], ['insane', 'puggled'], ['crazy', 'puggled'], ['easy', 'putzy'], ['simple', 'putzy'], ['wrong', 'pete tong'], ['drunk', 'pie-eyed'], ['insignificant', 'piffling'], ['drunk', 'pissed'], ['hungry', 'peckish'], ['obstinate', 'pig-headed'], ['angry', 'pissed off'], ['upset', 'pissed off'], ['poor', 'potless'], ['exhausted', 'powfagged'], ['dated', 'powfagged'], ['obscene', 'potty mouthed'], ['overdressed', 'ponced up'], ['expressionless', 'po-faced'], ['impassive', 'po-faced'], ['drunk', 'plastered'], ['intoxicated', 'plastered'], ['paranoid', 'para'], ['drunk', 'pickled'], ['small', 'pint-sized'], ['compact', 'pint-sized'], ['wealthy', 'pure bead'], ['expensive', 'pure bead'], ['excellent', 'pukka'], ['wonderful', 'pukka'], ['confused', 'puddled'], ['drunk', 'poleaxed'], ['intoxicated', 'poleaxed'], ['quickly', 'PDQ'], ['immediately', 'PDQ'], ['synthetic', 'plastic'], ['false', 'plastic'], ['plastic', 'placky'], ['drunk', 'pished'], ['intoxicated', 'pished'], ['small', 'piddly'], ['trivial', 'piddly'], ['insignificant', 'piddly'], ['rubbishy', 'poxy'], ['bisexual', 'AC/DC'], ['crass', 'poxy'], ['crazy', 'potty'], ['mad', 'potty'], ['eccentric', 'potty'], ['excellent', 'phat'], ['pleasing', 'phat'], ['desirable', 'phat'], ['fussy', 'picky'], ['fastidious', 'picky'], ['finicky', 'picky'], ['weak', 'pissy'], ['feeble', 'pissy'], ['inferior', 'pissy'], ['great', 'peng'], ['excellent', 'peng'], ['paranoid', 'prang'], ['stupid', 'prattish'], ['idiotic', 'prattish'], ['trivial', 'piddling'], ['insignificant', 'piddling'], ['silly', 'daft as a brush'], ['crazy', 'daft as a brush'], ['silly', 'daft'], ['foolish', 'daft'], ['insane', 'dagenham'], ['crazy', 'dagenham'], ['small', 'diddy'], ['extremely', 'dead'], ['excellent', 'dark'], ['risky', 'dicey'], ['bad', 'diabolical'], ['unpleasant', 'diabolical'], ['disgraceful', 'diabolical'], ['eccentric', 'dotty'], ['ineffectual', 'drippy'], ['dimwitted', 'dozy'], ['stupid', 'dozy'], ['slow', 'dozy'], ['displeased', 'dischuffed'], ['silly', 'dippy'], ['small', 'dinky'], ['cute', 'dinky'], ['risky', 'dodgy'], ['suspicious', 'dodgy'], ['dubious', 'dodgy'], ['unintelligent', 'dim'], ['worthless', 'duff'], ['rubbishy', 'duff'], ['useless', 'duff'], ['false', 'duff'], ['excellent', 'def'], ['outstanding', 'def'], ['perfect', 'def'], ['mad', 'doolally'], ['crazy', 'doolally'], ['insane', 'doolally'], ['talkative', 'gabby'], ['disappointed', 'gutted'], ['insane', 'gaga'], ['crazy', 'gaga'], ['mad', 'garrity'], ['crazy', 'garrity'], ['angry', 'garrity'], ['drunk', 'gatted'], ['intoxicated', 'gatted'], ['offensively', 'gobby'], ['outspoken', 'gobby'], ['cool', 'gnarly'], ['excellent', 'gnarly'], ['great', 'gnarly'], ['viscous', 'gungy'], ['sticky', 'gungy'], ['greasy', 'gungy'], ['scruffy', 'grungy'], ['smelly', 'grungy'], ['grimy', 'grungy'], ['dirty', 'grungy'], ['dirty', 'grebby'], ['grubby', 'grebby'], ['unsavoury', 'grebby'], ['unpleasant', 'god-awful'], ['horrible', 'god-awful'], ['foolish', 'gormless'], ['huge', 'ginormous'], ['amazed', 'gobstruck'], ['shocked', 'gobstruck'], ['viscous', 'gloopy'], ['sticky', 'gloopy'], ['stupid', 'glaikit'], ['idiotic', 'glaikit'], ['amazed', 'gobsmacked'], ['astounded', 'gobsmacked'], ['excellent', 'groovy'], ['wonderful', 'groovy'], ['unpleasant', 'grotty'], ['disgusting', 'grotty'], ['shabby', 'grotty'], ['excellent', 'grand'], ['good', 'gradeley'], ['excellent', 'gradeley'], ['disgusting', 'gopping'], ['ugly', 'gopping'], ['ruined', 'goosed'], ['finished', 'goosed'], ['injured', 'gammy'], ['painful', 'gammy'], ['septic', 'gammy'], ['cheeky', 'gallus'], ['mischievous', 'gallus'], ['disgusting', 'gross'], ['unpleasant', 'gross'], ['fabulous', 'fab'], ['wonderful', 'fabtastic'], ['excellent', 'fabtastic'], ['exhausted', 'fagged'], ['tired', 'fagged'], ['drunk', 'fuddled'], ['strewd', 'fly'], ['clever', 'fly'], ['fashionable', 'fly'], ['stylish', 'fly'], ['mouldy', 'foosty'], ['dusty', 'foosty'], ['insignificant', 'farty'], ['showy', 'flash'], ['favourite', 'favy'], ['fashionable', 'fleeky'], ['stylish', 'fleeky'], ['frightened', 'frit'], ['studious', 'swotty'], ['unfortunate', 'sad'], ['pitiful', 'sad'], ['pathetic', 'sad'], ['stupid', 'saft'], ['soft', 'saft'], ['irritated', 'salty'], ['angry', 'salty'], ['sarcastic', 'sarky'], ['unpleasant', 'scabby'], ['distasteful', 'scabby'], ['rotten', 'scabby'], ['tearful', 'scrikey'], ['unpleasant', 'scrotty'], ['dirty', 'scrotty'], ['poor', 'skint'], ['drunk', 'sloshed'], ['obsequious', 'smarmy'], ['intoxicated', 'smashed'], ['drunk', 'snockered'], ['excellent', 'solid'], ['great', 'solid'], ['excellent', 'sweet'], ['drunk', 'stewed'], ['lucky', 'spawny'], ['ambient', 'spacey'], ['ethereal', 'spacey'], ['drunk', 'sozzled'], ['intoxicated', 'spangled'], ['stupid', 'spazzy'], ['filthy', 'scuzzy'], ['dirty', 'scuzzy'], ['exhausted', 'shattered'], ['drunk', 'steamboated'], ['suspicious', 'stinks'], ['exhausted', 'slaughtered'], ['cheated', 'screwed'], ['tricked', 'screwed'], ['swindled', 'screwed'], ['dirty', 'skanky'], ['unnattractive', 'skanky'], ['ugly', 'skanky'], ['disgusting', 'squicky'], ['intoxicated', 'stocious'], ['unsavoury', 'smeggy'], ['horrible', 'smeggy'], ['lively', 'stomping'], ['energetic', 'stomping'], ['unconscious', 'sparko'], ['asleep', 'sparko'], ['lively', 'sparky'], ['entertaining', 'sparky'], ['unfair', 'shan'], ['smart', 'swish'], ['fashionable', 'swish'], ['elegant', 'swish'], ['cheap', 'scaffy'], ['undesirable', 'scaffy'], ['confused', 'scrambled'], ['unfair', 'shade'], ['questionable', 'shade'], ['disreputable', 'shade'], ['dubious', 'shade'], ['disorganised', 'shambolic'], ['chaotic', 'shambolic'], ['mismanaged', 'shambolic'], ['quiet', 'schtum'], ['silent', 'schtum'], ['exhausted', 'shagged'], ['broken', 'shagged'], ['exhausted', 'shot'], ['drunk', 'steaming'], ['intoxicated', 'steaming'], ['racing', 'steaming'], ['angry', 'steaming'], ['drunk', 'stinking'], ['wealthy', 'stinking'], ['objectionable', 'stinking'], ['excited', 'stoked'], ['pleased', 'stoked'], ['thrilled', 'stoked'], ['suspicious', 'suss'], ['knowledgeable', 'sussed'], ['terrible', 'swag'], ['worthless', 'swag'], ['conceited', 'stuck-up'], ['snobbish', 'stuck-up'], ['concerned', 'stuffed'], ['bothered', 'stuffed'], ['brilliant', 'cracking'], ['wonderful', 'cracking'], ['excellent', 'champion'], ['perfect', 'champion'], ['excellent', 'coolio'], ['great', 'coolio'], ['correct', 'correctomundo'], ['dirty', 'cacky'], ['filthy', 'cacky'], ['rubbishy', 'cacky'], ['intoxicated', 'caned'], ['excellent', 'cushty'], ['fine', 'cushty'], ['clumsy', 'caggy handed'], ['awkward', 'caggy handed'], ['stupid', 'cakey'], ['foolish', 'cakey'], ['excellent', 'spanking'], ['intoxicated', 'spannered'], ['special', 'spesh'], ['thirsty', 'spitting feathers'], ['angry', 'spitting feathers'], ['agitated', 'spitting feathers'], ['crowded', 'stowed out'], ['marvellous', 'storming'], ['excellent', 'storming'], ['relaxed', 'chilled'], ['relaxing', 'chillaxing'], ['attractive', 'chung'], ['crazy', 'completely hatstand'], ['insane', 'completely hatstand'], ['corny', 'cheesy'], ['cheap', 'cheesy'], ['hackneyed', 'cheesy'], ['moody', 'chordy'], ['dubious', 'shonky'], ['unreliable', 'shonky'], ['underhand', 'shonky'], ['impertinent', 'cheeky'], ['insolent', 'cheeky'], ['cheerful', 'chirpy'], ['lively', 'chirpy'], ['merry', 'chirpy'], ['excellent', 'choice'], ['useless', 'cruddy'], ['rubbishy', 'cruddy'], ['unpleasant', 'cruddy'], ['scruffy', 'cuffy'], ['unkempt', 'cuffy'], ['great', 'crucial'], ['excellent', 'crucial'], ['essential', 'crucial'], ['exhausted', 'cream crackered'], ['greedy', 'craven'], ['rubbishy', 'crappy'], ['useless', 'crappy'], ['mad', 'crackpot'], ['eccentric', 'crackpot'], ['unworkable', 'crackpot'], ['squashy', 'squidgey'], ['soggy', 'squidgey'], ['crazy', 'crackers'], ['moody', 'crabby'], ['excellent', 'corking'], ['splendid', 'corking'], ['crazy', 'cray'], ['insane', 'cray'], ['deaf', 'corned beef'], ['cold', 'shrammed'], ['frozen', 'shrammed'], ['hurt', 'sneeped'], ['offended', 'sneeped'], ['feeble', 'soppy'], ['conceited', 'snotty'], ['snobbish', 'snotty'], ['unpleasant', 'clingin'], ['disgusting', 'clingin'], ['hungry', 'clemmed'], ['starving', 'clamming'], ['hungry', 'clamming'], ['intimate', 'chummy'], ['friendly', 'chummy'], ['sociable', 'chummy'], ['pleased', 'chuffed as nuts'], ['happy', 'chuffed as nuts'], ['moody', 'chopsy'], ['annoyed', 'chopsy'], ['argumentative', 'chopsy'], ['chatty', 'chopsy'], ['upset', 'choked'], ['intoxicated', 'chonged'], ['angry', 'cheesed off'], ['exhausted', 'spackered'], ['intoxicated', 'spackered'], ['critical', 'snippy'], ['supercilious', 'snippy'], ['incorrect', 'skew-whiff'], ['crowded', 'snided'], ['busy', 'snided'], ['contemptuous', 'sniffy'], ['disagreeable', 'sniffy'], ['clumsy', 'cack-handed'], ['good', 'canny'], ['nice', 'canny'], ['pleasant', 'canny'], ['dirty', 'clarty'], ['sticky', 'clarty'], ['gooey', 'clarty'], ['messy', 'clarty'], ['crowded', 'chocker'], ['busy', 'chocker'], ['defeated', 'snookered'], ['thwarted', 'snookered'], ['irritable', 'snarky'], ['strange', 'spinny'], ['unusual', 'spinny'], ['confusing', 'spinny'], ['knowledgeable', 'clued up'], ['informed', 'clued up'], ['broken', 'cattled'], ['crowded', 'chock-a-block'], ['busy', 'chock-a-block'], ['dirty', 'clatty'], ['untidy', 'clatty'], ['impressive', "stickin' out"], ['excellent', "stickin' out"], ['excellent', 'spiffing'], ['smooth', 'sleekit'], ['shiny', 'sleekit'], ['crafty', 'sleekit'], ['sneaky', 'sleekit'], ['fake', 'snide'], ['exhausted', 'cabbaged'], ['intoxicated', 'cabbaged'], ['pleased', 'chuffed to buggery'], ['happy', 'chuffed to buggery'], ['broken', 'clapped out'], ['pleased', 'chuffed'], ['delighted', 'chuffed'], ['happy', 'chuffed'], ['lacking', 'strapped'], ['poor', 'strapped']]

CMU_dict = {
    "'bout": ["B", "AW1", "T"],
    "'cause": ["K", "AH0", "Z"],
    "'course": ["K", "AO1", "R", "S"],
    "'cuse": ["K", "Y", "UW1", "Z"],
    "'em": ["AH0", "M"],
    "'frisco": ["F", "R", "IH1", "S", "K", "OW0"],
    "'gain": ["G", "EH1", "N"],
    "'kay": ["K", "EY1"],
    "'m": ["AH0", "M"],
    "'n": ["AH0", "N"],
    "'round": ["R", "AW1", "N", "D"],
    "'s": ["EH1", "S"],
    "'til": ["T", "IH1", "L"],
    "'tis": ["T", "IH1", "Z"],
    "'twas": ["T", "W", "AH1", "Z"],
    "a": ["EY1"],
    "a's": ["EY1", "Z"],
    "a.": ["EY1"],
    "a.'s": ["EY1", "Z"],
    "a.d.": ["EY2", "D", "IY1"],
    "a.m.": ["EY2", "EH1", "M"],
    "a.s": ["EY1", "Z"],
    "aaa": ["T", "R", "IH2", "P", "AH0", "L", "EY1"],
    "aaberg": ["AA1", "B", "ER0", "G"],
    "aachen": ["AA1", "K", "AH0", "N"],
    "aachener": ["AA1", "K", "AH0", "N", "ER0"],
    "aaker": ["AA1", "K", "ER0"],
    "aalborg": ["AA1", "L", "B", "AO0", "R", "G"],
    "aalburg": ["AE1", "L", "B", "ER0", "G"],
    "aalen": ["AA1", "L", "AH0", "N"],
    "aaliyah": ["AA2", "L", "IY1", "AA2"],
    "aalseth": ["AA1", "L", "S", "EH0", "TH"],
    "aalsmeer": ["AA1", "L", "S", "M", "IH0", "R"],
    "aalto": ["AA1", "L", "T", "OW2"],
    "aamodt": ["AA1", "M", "AH0", "T"],
    "aancor": ["AA1", "N", "K", "AO2", "R"],
    "aardema": ["AA0", "R", "D", "EH1", "M", "AH0"],
    "aardvark": ["AA1", "R", "D", "V", "AA2", "R", "K"],
    "aardvarks": ["AA1", "R", "D", "V", "AA2", "R", "K", "S"],
    "aargh": ["AA1", "R", "G"],
    "aarhus": ["AA2", "HH", "UW1", "S"],
    "aaron": ["EH1", "R", "AH0", "N"],
    "aaron's": ["EH1", "R", "AH0", "N", "Z"],
    "aarons": ["EH1", "R", "AH0", "N", "Z"],
    "aaronson": ["AA1", "R", "AH0", "N", "S", "AH0", "N"],
    "aaronson's": ["AA1", "R", "AH0", "N", "S", "AH0", "N", "Z"],
    "aarti": ["AA1", "R", "T", "IY2"],
    "aase": ["AA1", "S"],
    "aasen": ["AA1", "S", "AH0", "N"],
    "ab": ["EY1", "B", "IY1"],
    "aba": ["EY2", "B", "IY2", "EY1"],
    "ababa": ["AA1", "B", "AH0", "B", "AH0"],
    "abacha": ["AE1", "B", "AH0", "K", "AH0"],
    "aback": ["AH0", "B", "AE1", "K"],
    "abaco": ["AE1", "B", "AH0", "K", "OW2"],
    "abacus": ["AE1", "B", "AH0", "K", "AH0", "S"],
    "abad": ["AH0", "B", "AA1", "D"],
    "abadaka": ["AH0", "B", "AE1", "D", "AH0", "K", "AH0"],
    "abadi": ["AH0", "B", "AE1", "D", "IY0"],
    "abadie": ["AH0", "B", "AE1", "D", "IY0"],
    "abair": ["AH0", "B", "EH1", "R"],
    "abalkin": ["AH0", "B", "AA1", "L", "K", "IH0", "N"],
    "abalone": ["AE2", "B", "AH0", "L", "OW1", "N", "IY0"],
    "abalones": ["AE2", "B", "AH0", "L", "OW1", "N", "IY0", "Z"],
    "abalos": ["AA0", "B", "AA1", "L", "OW0", "Z"],
    "abandon": ["AH0", "B", "AE1", "N", "D", "AH0", "N"],
    "abandoned": ["AH0", "B", "AE1", "N", "D", "AH0", "N", "D"],
    "abandoning": ["AH0", "B", "AE1", "N", "D", "AH0", "N", "IH0", "NG"],
    "abandonment": ["AH0", "B", "AE1", "N", "D", "AH0", "N", "M", "AH0", "N", "T"],
    "abandonments": ["AH0", "B", "AE1", "N", "D", "AH0", "N", "M", "AH0", "N", "T", "S"],
    "abandons": ["AH0", "B", "AE1", "N", "D", "AH0", "N", "Z"],
    "abanto": ["AH0", "B", "AE1", "N", "T", "OW0"],
    "abarca": ["AH0", "B", "AA1", "R", "K", "AH0"],
    "abare": ["AA0", "B", "AA1", "R", "IY0"],
    "abascal": ["AE1", "B", "AH0", "S", "K", "AH0", "L"],
    "abash": ["AH0", "B", "AE1", "SH"],
    "abashed": ["AH0", "B", "AE1", "SH", "T"],
    "abasia": ["AH0", "B", "EY1", "ZH", "Y", "AH0"],
    "abate": ["AH0", "B", "EY1", "T"],
    "abated": ["AH0", "B", "EY1", "T", "IH0", "D"],
    "abatement": ["AH0", "B", "EY1", "T", "M", "AH0", "N", "T"],
    "abatements": ["AH0", "B", "EY1", "T", "M", "AH0", "N", "T", "S"],
    "abates": ["AH0", "B", "EY1", "T", "S"],
    "abating": ["AH0", "B", "EY1", "T", "IH0", "NG"],
    "abattoir": ["AE2", "B", "AH0", "T", "W", "AA1", "R"],
    "abba": ["AE1", "B", "AH0"],
    "abbado": ["AH0", "B", "AA1", "D", "OW0"],
    "abbas": ["AH0", "B", "AA1", "S"],
    "abbasi": ["AA0", "B", "AA1", "S", "IY0"],
    "abbate": ["AA1", "B", "EY0", "T"],
    "abbatiello": ["AA0", "B", "AA0", "T", "IY0", "EH1", "L", "OW0"],
    "abbe": ["AE0", "B", "EY1"],
    "abbenhaus": ["AE1", "B", "AH0", "N", "HH", "AW2", "S"],
    "abbett": ["AH0", "B", "EH1", "T"],
    "abbeville": ["AE1", "B", "V", "IH0", "L"],
    "abbey": ["AE1", "B", "IY0"],
    "abbey's": ["AE1", "B", "IY0", "Z"],
    "abbie": ["AE1", "B", "IY0"],
    "abbitt": ["AE1", "B", "IH0", "T"],
    "abbot": ["AE1", "B", "AH0", "T"],
    "abbotstown": ["AE1", "B", "AH0", "T", "S", "T", "AW1", "N"],
    "abbott": ["AE1", "B", "AH0", "T"],
    "abbott's": ["AE1", "B", "AH0", "T", "S"],
    "abbottstown": ["AE1", "B", "AH0", "T", "S", "T", "AW1", "N"],
    "abboud": ["AH0", "B", "AW1", "D"],
    "abbreviate": ["AH0", "B", "R", "IY1", "V", "IY0", "EY2", "T"],
    "abbreviated": ["AH0", "B", "R", "IY1", "V", "IY0", "EY2", "T", "IH0", "D"],
    "abbreviates": ["AH0", "B", "R", "IY1", "V", "IY0", "EY2", "T", "S"],
    "abbreviating": ["AH0", "B", "R", "IY1", "V", "IY0", "EY2", "T", "IH0", "NG"],
    "abbreviation": ["AH0", "B", "R", "IY2", "V", "IY0", "EY1", "SH", "AH0", "N"],
    "abbreviations": ["AH0", "B", "R", "IY2", "V", "IY0", "EY1", "SH", "AH0", "N", "Z"],
    "abbruzzese": ["AA0", "B", "R", "UW0", "T", "S", "EY1", "Z", "IY0"],
    "abbs": ["AE1", "B", "Z"],
    "abby": ["AE1", "B", "IY0"],
    "abc": ["EY1", "B", "IY2", "S", "IY2"],
    "abc's": ["EY1", "B", "IY2", "S", "IY2", "Z"],
    "abco": ["AE1", "B", "K", "OW0"],
    "abcotek": ["AE1", "B", "K", "OW0", "T", "EH2", "K"],
    "abcs": ["EY1", "B", "IY2", "S", "IY2", "Z"],
    "abd": ["EY2", "B", "IY2", "D", "IY1"],
    "abdalla": ["AE2", "B", "D", "AE1", "L", "AH0"],
    "abdallah": ["AE2", "B", "D", "AE1", "L", "AH0"],
    "abdel": ["AE1", "B", "D", "EH2", "L"],
    "abdella": ["AE2", "B", "D", "EH1", "L", "AH0"],
    "abdicate": ["AE1", "B", "D", "AH0", "K", "EY2", "T"],
    "abdicated": ["AE1", "B", "D", "AH0", "K", "EY2", "T", "IH0", "D"],
    "abdicates": ["AE1", "B", "D", "AH0", "K", "EY2", "T", "S"],
    "abdicating": ["AE1", "B", "D", "IH0", "K", "EY2", "T", "IH0", "NG"],
    "abdication": ["AE2", "B", "D", "IH0", "K", "EY1", "SH", "AH0", "N"],
    "abdnor": ["AE1", "B", "D", "N", "ER0"],
    "abdo": ["AE1", "B", "D", "OW0"],
    "abdollah": ["AE2", "B", "D", "AA1", "L", "AH0"],
    "abdomen": ["AE1", "B", "D", "AH0", "M", "AH0", "N"],
    "abdominal": ["AH0", "B", "D", "AA1", "M", "AH0", "N", "AH0", "L"],
    "abduct": ["AE0", "B", "D", "AH1", "K", "T"],
    "abducted": ["AH0", "B", "D", "AH1", "K", "T", "IH0", "D"],
    "abductee": ["AE0", "B", "D", "AH2", "K", "T", "IY1"],
    "abductees": ["AE0", "B", "D", "AH2", "K", "T", "IY1", "Z"],
    "abducting": ["AH0", "B", "D", "AH1", "K", "T", "IH0", "NG"],
    "abduction": ["AH0", "B", "D", "AH1", "K", "SH", "AH0", "N"],
    "abductions": ["AH0", "B", "D", "AH1", "K", "SH", "AH0", "N", "Z"],
    "abductor": ["AH0", "B", "D", "AH1", "K", "T", "ER0"],
    "abductors": ["AH0", "B", "D", "AH1", "K", "T", "ER0", "Z"],
    "abducts": ["AE0", "B", "D", "AH1", "K", "T", "S"],
    "abdul": ["AE0", "B", "D", "UW1", "L"],
    "abdulaziz": ["AE0", "B", "D", "UW2", "L", "AH0", "Z", "IY1", "Z"],
    "abdulla": ["AA0", "B", "D", "UW1", "L", "AH0"],
    "abdullah": ["AE2", "B", "D", "AH1", "L", "AH0"],
    "abe": ["EY1", "B"],
    "abed": ["AH0", "B", "EH1", "D"],
    "abedi": ["AH0", "B", "EH1", "D", "IY0"],
    "abee": ["AH0", "B", "IY1"],
    "abel": ["EY1", "B", "AH0", "L"],
    "abela": ["AA0", "B", "EH1", "L", "AH0"],
    "abelard": ["AE1", "B", "IH0", "L", "ER0", "D"],
    "abele": ["AH0", "B", "EH1", "L"],
    "abeles": ["EY1", "B", "AH0", "L", "IY2", "Z"],
    "abell": ["EY1", "B", "AH0", "L"],
    "abella": ["AH0", "B", "EH1", "L", "AH0"],
    "abeln": ["AE1", "B", "IH0", "L", "N"],
    "abelow": ["AE1", "B", "AH0", "L", "OW0"],
    "abels": ["EY1", "B", "AH0", "L", "Z"],
    "abelson": ["AE1", "B", "IH0", "L", "S", "AH0", "N"],
    "abend": ["AH0", "B", "EH1", "N", "D"],
    "abendroth": ["AE1", "B", "IH0", "N", "D", "R", "AO0", "TH"],
    "aber": ["EY1", "B", "ER0"],
    "abercrombie": ["AE2", "B", "ER0", "K", "R", "AA1", "M", "B", "IY0"],
    "aberdeen": ["AE1", "B", "ER0", "D", "IY2", "N"],
    "aberford": ["EY1", "B", "ER0", "F", "ER0", "D"],
    "aberg": ["AE1", "B", "ER0", "G"],
    "aberle": ["AE1", "B", "ER0", "L"],
    "abermin": ["AE1", "B", "ER0", "M", "IH0", "N"],
    "abernathy": ["AE1", "B", "ER0", "N", "AE2", "TH", "IY0"],
    "abernethy": ["AE1", "B", "ER0", "N", "EH2", "TH", "IY0"],
    "aberrant": ["AE0", "B", "EH1", "R", "AH0", "N", "T"],
    "aberration": ["AE2", "B", "ER0", "EY1", "SH", "AH0", "N"],
    "aberrational": ["AE2", "B", "ER0", "EY1", "SH", "AH0", "N", "AH0", "L"],
    "aberrations": ["AE2", "B", "ER0", "EY1", "SH", "AH0", "N", "Z"],
    "abert": ["AE1", "B", "ER0", "T"],
    "abet": ["AH0", "B", "EH1", "T"],
    "abetted": ["AH0", "B", "EH1", "T", "IH0", "D"],
    "abetting": ["AH0", "B", "EH1", "T", "IH0", "NG"],
    "abex": ["EY1", "B", "EH0", "K", "S"],
    "abeyance": ["AH0", "B", "EY1", "AH0", "N", "S"],
    "abeyta": ["AA0", "B", "EY1", "T", "AH0"],
    "abhor": ["AE0", "B", "HH", "AO1", "R"],
    "abhorred": ["AH0", "B", "HH", "AO1", "R", "D"],
    "abhorrence": ["AH0", "B", "HH", "AO1", "R", "AH0", "N", "S"],
    "abhorrent": ["AE0", "B", "HH", "AO1", "R", "AH0", "N", "T"],
    "abhors": ["AH0", "B", "HH", "AO1", "R", "Z"],
    "abiam": ["EY1", "B", "IY0", "AH0", "M"],
    "abiam's": ["EY1", "B", "IY0", "AH0", "M", "Z"],
    "abid": ["EY1", "B", "IH0", "D"],
    "abide": ["AH0", "B", "AY1", "D"],
    "abided": ["AH0", "B", "AY1", "D", "IH0", "D"],
    "abides": ["AH0", "B", "AY1", "D", "Z"],
    "abiding": ["AH0", "B", "AY1", "D", "IH0", "NG"],
    "abidjan": ["AE0", "B", "IH0", "JH", "AA1", "N"],
    "abie": ["AE1", "B", "IY0"],
    "abigail": ["AE1", "B", "AH0", "G", "EY2", "L"],
    "abila": ["AA0", "B", "IY1", "L", "AH0"],
    "abilene": ["AE1", "B", "IH0", "L", "IY2", "N"],
    "abilities": ["AH0", "B", "IH1", "L", "AH0", "T", "IY2", "Z"],
    "ability": ["AH0", "B", "IH1", "L", "AH0", "T", "IY2"],
    "abimael": ["AE2", "B", "IH0", "M", "EY1", "L"],
    "abimaels": ["AE2", "B", "IH0", "M", "EY1", "L", "Z"],
    "abingdon": ["AE1", "B", "IH0", "NG", "D", "AH0", "N"],
    "abington": ["AE1", "B", "IH0", "NG", "T", "AH0", "N"],
    "abio": ["AA1", "B", "IY0", "OW0"],
    "abiola": ["AA2", "B", "IY0", "OW1", "L", "AH0"],
    "abiola's": ["AA2", "B", "IY0", "OW1", "L", "AH0", "Z"],
    "abiomed": ["EY0", "B", "IY1", "AH0", "M", "EH0", "D"],
    "abiquiu": ["AH0", "B", "IH1", "K", "Y", "UW0"],
    "abitibi": ["AE2", "B", "IH0", "T", "IY1", "B", "IY0"],
    "abitz": ["AE1", "B", "IH0", "T", "S"],
    "abject": ["AE1", "B", "JH", "EH0", "K", "T"],
    "abkhazia": ["AE0", "B", "K", "AE1", "Z", "Y", "AH0"],
    "abkhazian": ["AE0", "B", "K", "AE1", "Z", "Y", "AH0", "N"],
    "abkhazians": ["AE0", "B", "K", "AE1", "Z", "IY0", "AH0", "N", "Z"],
    "ablate": ["AH2", "B", "L", "EY1", "T"],
    "ablation": ["AH2", "B", "L", "EY1", "SH", "AH0", "N"],
    "ablaze": ["AH0", "B", "L", "EY1", "Z"],
    "able": ["EY1", "B", "AH0", "L"],
    "able-bodied": ["EY1", "B", "AH0", "L", "B", "AA1", "D", "IY0", "D"],
    "abled": ["EY1", "B", "AH0", "L", "D"],
    "abler": ["EY1", "B", "L", "ER0"],
    "ables": ["EY1", "B", "AH0", "L", "Z"],
    "ablest": ["EY1", "B", "L", "AH0", "S", "T"],
    "abloom": ["AH0", "B", "L", "UW1", "M"],
    "ablution": ["AH0", "B", "L", "UW1", "SH", "AH0", "N"],
    "ablutions": ["AH0", "B", "L", "UW1", "SH", "AH0", "N", "Z"],
    "ably": ["EY1", "B", "L", "IY0"],
    "abnegation": ["AE2", "B", "N", "EH0", "G", "EY1", "SH", "AH0", "N"],
    "abner": ["AE1", "B", "N", "ER0"],
    "abney": ["AE1", "B", "N", "IY0"],
    "abnormal": ["AE0", "B", "N", "AO1", "R", "M", "AH0", "L"],
    "abnormalities": ["AE2", "B", "N", "AO0", "R", "M", "AE1", "L", "AH0", "T", "IY0", "Z"],
    "abnormality": ["AE2", "B", "N", "AO0", "R", "M", "AE1", "L", "AH0", "T", "IY0"],
    "abnormally": ["AE0", "B", "N", "AO1", "R", "M", "AH0", "L", "IY0"],
    "abo": ["AA1", "B", "OW0"],
    "abo's": ["AA1", "B", "OW0", "Z"],
    "aboard": ["AH0", "B", "AO1", "R", "D"],
    "abode": ["AH0", "B", "OW1", "D"],
    "abohalima": ["AE0", "B", "AH0", "HH", "AH0", "L", "IY1", "M", "AH0"],
    "abolish": ["AH0", "B", "AA1", "L", "IH0", "SH"],
    "abolished": ["AH0", "B", "AA1", "L", "IH0", "SH", "T"],
    "abolishes": ["AH0", "B", "AA1", "L", "IH0", "SH", "IH0", "Z"],
    "abolishing": ["AH0", "B", "AA1", "L", "IH0", "SH", "IH0", "NG"],
    "abolition": ["AE2", "B", "AH0", "L", "IH1", "SH", "AH0", "N"],
    "abolitionism": ["AE2", "B", "AH0", "L", "IH1", "SH", "AH0", "N", "IH2", "Z", "AH0", "M"],
    "abolitionist": ["AE2", "B", "AH0", "L", "IH1", "SH", "AH0", "N", "AH0", "S", "T"],
    "abolitionists": ["AE2", "B", "AH0", "L", "IH1", "SH", "AH0", "N", "AH0", "S", "T", "S"],
    "abominable": ["AH0", "B", "AA1", "M", "AH0", "N", "AH0", "B", "AH0", "L"],
    "abomination": ["AH0", "B", "AA2", "M", "AH0", "N", "EY1", "SH", "AH0", "N"],
    "abominations": ["AH0", "B", "AA2", "M", "AH0", "N", "EY1", "SH", "AH0", "N", "Z"],
    "abood": ["AH0", "B", "UW1", "D"],
    "aboodi": ["AH0", "B", "UW1", "D", "IY0"],
    "abor": ["AH0", "B", "AO1", "R"],
    "aboriginal": ["AE2", "B", "ER0", "IH1", "JH", "AH0", "N", "AH0", "L"],
    "aborigine": ["AE2", "B", "ER0", "IH1", "JH", "AH0", "N", "IY0"],
    "aborigines": ["AE2", "B", "ER0", "IH1", "JH", "AH0", "N", "IY0", "Z"],
    "aborn": ["AH0", "B", "AO1", "R", "N"],
    "abort": ["AH0", "B", "AO1", "R", "T"],
    "aborted": ["AH0", "B", "AO1", "R", "T", "IH0", "D"],
    "abortifacient": ["AH0", "B", "AO2", "R", "T", "AH0", "F", "EY1", "SH", "AH0", "N", "T"],
    "abortifacients": ["AH0", "B", "AO2", "R", "T", "AH0", "F", "EY1", "SH", "AH0", "N", "T", "S"],
    "aborting": ["AH0", "B", "AO1", "R", "T", "IH0", "NG"],
    "abortion": ["AH0", "B", "AO1", "R", "SH", "AH0", "N"],
    "abortionist": ["AH0", "B", "AO1", "R", "SH", "AH0", "N", "IH0", "S", "T"],
    "abortionists": ["AH0", "B", "AO1", "R", "SH", "AH0", "N", "IH0", "S", "T", "S"],
    "abortions": ["AH0", "B", "AO1", "R", "SH", "AH0", "N", "Z"],
    "abortive": ["AH0", "B", "AO1", "R", "T", "IH0", "V"],
    "aborts": ["AH0", "B", "AO1", "R", "T", "S"],
    "abott": ["AH0", "B", "AA1", "T"],
    "abou": ["AH0", "B", "UW1"],
    "aboud": ["AA0", "B", "UW1", "D"],
    "abouhalima": ["AA2", "B", "UW0", "HH", "AA0", "L", "IY1", "M", "AH0"],
    "abouhalima's": ["AA2", "B", "UW0", "HH", "AA0", "L", "IY1", "M", "AH0", "Z"],
    "abound": ["AH0", "B", "AW1", "N", "D"],
    "abounded": ["AH0", "B", "AW1", "N", "D", "IH0", "D"],
    "abounding": ["AH0", "B", "AW1", "N", "D", "IH0", "NG"],
    "abounds": ["AH0", "B", "AW1", "N", "D", "Z"],
    "about": ["AH0", "B", "AW1", "T"],
    "about's": ["AH0", "B", "AW1", "T", "S"],
    "above": ["AH0", "B", "AH1", "V"],
    "above's": ["AH0", "B", "AH1", "V", "Z"],
    "aboveboard": ["AH0", "B", "AH1", "V", "B", "AO2", "R", "D"],
    "abplanalp": ["AE1", "B", "P", "L", "AH0", "N", "AE0", "L", "P"],
    "abra": ["AA1", "B", "R", "AH0"],
    "abracadabra": ["AE2", "B", "R", "AH0", "K", "AH0", "D", "AE1", "B", "R", "AH0"],
    "abrade": ["AE0", "B", "R", "EY1", "D"],
    "abraded": ["AE0", "B", "R", "EY1", "D", "IH0", "D"],
    "abrades": ["AE0", "B", "R", "EY1", "D", "Z"],
    "abraham": ["EY1", "B", "R", "AH0", "HH", "AE2", "M"],
    "abrahamian": ["AE2", "B", "R", "AH0", "HH", "EY1", "M", "IY0", "AH0", "N"],
    "abrahams": ["EY1", "B", "R", "AH0", "HH", "AE2", "M", "Z"],
    "abrahamsen": ["AE0", "B", "R", "AH0", "HH", "AE1", "M", "S", "AH0", "N"],
    "abrahamson": ["AH0", "B", "R", "AE1", "HH", "AH0", "M", "S", "AH0", "N"],
    "abram": ["AH0", "B", "R", "AE1", "M"],
    "abram's": ["EY1", "B", "R", "AH0", "M", "Z"],
    "abramczyk": ["AA1", "B", "R", "AH0", "M", "CH", "IH0", "K"],
    "abramo": ["AA0", "B", "R", "AA1", "M", "OW0"],
    "abramovitz": ["AH0", "B", "R", "AA1", "M", "AH0", "V", "IH0", "T", "S"],
    "abramowicz": ["AH0", "B", "R", "AA1", "M", "AH0", "V", "IH0", "CH"],
    "abramowitz": ["AH0", "B", "R", "AA1", "M", "AH0", "W", "IH0", "T", "S"],
    "abrams": ["EY1", "B", "R", "AH0", "M", "Z"],
    "abrams's": ["EY1", "B", "R", "AH0", "M", "Z", "IH0", "Z"],
    "abramson": ["EY1", "B", "R", "AH0", "M", "S", "AH0", "N"],
    "abrasion": ["AH0", "B", "R", "EY1", "ZH", "AH0", "N"],
    "abrasions": ["AH0", "B", "R", "EY1", "ZH", "AH0", "N", "Z"],
    "abrasive": ["AH0", "B", "R", "EY1", "S", "IH0", "V"],
    "abrasives": ["AH0", "B", "R", "EY1", "S", "IH0", "V", "Z"],
    "abraxa": ["AH0", "B", "R", "AE1", "K", "S", "AH0"],
    "abraxa's": ["AH0", "B", "R", "AE1", "K", "S", "AH0", "Z"],
    "abraxas": ["AH0", "B", "R", "AE1", "K", "S", "AH0", "Z"],
    "abreast": ["AH0", "B", "R", "EH1", "S", "T"],
    "abrego": ["AA0", "B", "R", "EH1", "G", "OW0"],
    "abreu": ["AH0", "B", "R", "UW1"],
    "abridge": ["AH0", "B", "R", "IH1", "JH"],
    "abridged": ["AH0", "B", "R", "IH1", "JH", "D"],
    "abridgement": ["AH0", "B", "R", "IH1", "JH", "M", "AH0", "N", "T"],
    "abridges": ["AH0", "B", "R", "IH1", "JH", "AH0", "Z"],
    "abridging": ["AH0", "B", "R", "IH1", "JH", "IH0", "NG"],
    "abril": ["AH0", "B", "R", "IH1", "L"],
    "abroad": ["AH0", "B", "R", "AO1", "D"],
    "abrogate": ["AE1", "B", "R", "AH0", "G", "EY2", "T"],
    "abrogated": ["AE1", "B", "R", "AH0", "G", "EY2", "T", "IH0", "D"],
    "abrogating": ["AE1", "B", "R", "AH0", "G", "EY2", "T", "IH0", "NG"],
    "abrogation": ["AE2", "B", "R", "AH0", "G", "EY1", "SH", "AH0", "N"],
    "abrol": ["AH0", "B", "R", "OW1", "L"],
    "abron": ["AH0", "B", "R", "AA1", "N"],
    "abrupt": ["AH0", "B", "R", "AH1", "P", "T"],
    "abruptly": ["AH0", "B", "R", "AH1", "P", "T", "L", "IY0"],
    "abruptness": ["AH0", "B", "R", "AH1", "P", "T", "N", "AH0", "S"],
    "abrutyn": ["EY1", "B", "R", "UW0", "T", "IH0", "N"],
    "abruzzese": ["AA0", "B", "R", "UW0", "T", "S", "EY1", "Z", "IY0"],
    "abruzzo": ["AA0", "B", "R", "UW1", "Z", "OW0"],
    "abs": ["AE1", "B", "Z"],
    "absalom": ["AE1", "B", "S", "AH0", "L", "AH0", "M"],
    "absaraka": ["AE0", "B", "S", "AA1", "R", "AH0", "K", "AH0"],
    "abscam": ["AE1", "B", "S", "K", "AE0", "M"],
    "abscess": ["AE1", "B", "S", "EH2", "S"],
    "abscond": ["AE0", "B", "S", "K", "AA1", "N", "D"],
    "absconded": ["AE0", "B", "S", "K", "AA1", "N", "D", "IH0", "D"],
    "absconding": ["AE0", "B", "S", "K", "AA1", "N", "D", "IH0", "NG"],
    "absconds": ["AE0", "B", "S", "K", "AA1", "N", "D", "Z"],
    "absecon": ["AE1", "B", "S", "AH0", "K", "AO0", "N"],
    "absence": ["AE1", "B", "S", "AH0", "N", "S"],
    "absences": ["AE1", "B", "S", "AH0", "N", "S", "IH0", "Z"],
    "absent": ["AE1", "B", "S", "AH0", "N", "T"],
    "absentee": ["AE2", "B", "S", "AH0", "N", "T", "IY1"],
    "absenteeism": ["AE2", "B", "S", "AH0", "N", "T", "IY1", "IH0", "Z", "AH0", "M"],
    "absentees": ["AE2", "B", "S", "AH0", "N", "T", "IY1", "Z"],
    "absentia": ["AE0", "B", "S", "EH1", "N", "SH", "AH0"],
    "absher": ["AE1", "B", "SH", "ER0"],
    "abshier": ["AE1", "B", "SH", "IY0", "ER0"],
    "abshire": ["AE1", "B", "SH", "AY2", "R"],
    "absinthe": ["AE1", "B", "S", "IH0", "N", "TH"],
    "abso": ["AE1", "B", "S", "OW0"],
    "absolom": ["AE1", "B", "S", "AH0", "L", "AH0", "M"],
    "absolut": ["AE2", "B", "S", "AH0", "L", "UW1", "T"],
    "absolut's": ["AE2", "B", "S", "AH0", "L", "UW1", "T", "S"],
    "absolute": ["AE1", "B", "S", "AH0", "L", "UW2", "T"],
    "absolutely": ["AE2", "B", "S", "AH0", "L", "UW1", "T", "L", "IY0"],
    "absoluteness": ["AE1", "B", "S", "AH0", "L", "UW2", "T", "N", "AH0", "S"],
    "absolutes": ["AE1", "B", "S", "AH0", "L", "UW2", "T", "S"],
    "absolution": ["AE2", "B", "S", "AH0", "L", "UW1", "SH", "AH0", "N"],
    "absolutism": ["AE1", "B", "S", "AH0", "L", "UW2", "T", "IH2", "Z", "AH0", "M"],
    "absolutist": ["AE0", "B", "S", "AH0", "L", "UW1", "T", "IH0", "S", "T"],
    "absolve": ["AE0", "B", "Z", "AA1", "L", "V"],
    "absolved": ["AE0", "B", "Z", "AA1", "L", "V", "D"],
    "absolves": ["AE0", "B", "Z", "AA1", "L", "V", "Z"],
    "absolving": ["AE0", "B", "Z", "AA1", "L", "V", "IH0", "NG"],
    "absorb": ["AH0", "B", "Z", "AO1", "R", "B"],
    "absorbed": ["AH0", "B", "Z", "AO1", "R", "B", "D"],
    "absorbency": ["AH0", "B", "Z", "AO1", "R", "B", "AH0", "N", "S", "IY0"],
    "absorbent": ["AH0", "B", "Z", "AO1", "R", "B", "AH0", "N", "T"],
    "absorber": ["AH0", "B", "Z", "AO1", "R", "B", "ER0"],
    "absorbers": ["AH0", "B", "Z", "AO1", "R", "B", "ER0", "Z"],
    "absorbing": ["AH0", "B", "Z", "AO1", "R", "B", "IH0", "NG"],
    "absorbs": ["AH0", "B", "Z", "AO1", "R", "B", "Z"],
    "absorption": ["AH0", "B", "S", "AO1", "R", "P", "SH", "AH0", "N"],
    "abstain": ["AE0", "B", "S", "T", "EY1", "N"],
    "abstained": ["AE0", "B", "S", "T", "EY1", "N", "D"],
    "abstaining": ["AE0", "B", "S", "T", "EY1", "N", "IH0", "NG"],
    "abstention": ["AE0", "B", "S", "T", "EH1", "N", "CH", "AH0", "N"],
    "abstentions": ["AE0", "B", "S", "T", "EH1", "N", "CH", "AH0", "N", "Z"],
    "abstinence": ["AE1", "B", "S", "T", "AH0", "N", "AH0", "N", "S"],
    "abstinent": ["AE1", "B", "S", "T", "AH0", "N", "AH0", "N", "T"],
    "abston": ["AE1", "B", "S", "T", "AH0", "N"],
    "abstract": ["AE1", "B", "S", "T", "R", "AE2", "K", "T"],
    "abstracted": ["AE1", "B", "S", "T", "R", "AE2", "K", "T", "IH0", "D"],
    "abstraction": ["AE0", "B", "S", "T", "R", "AE1", "K", "SH", "AH0", "N"],
    "abstractions": ["AE0", "B", "S", "T", "R", "AE1", "K", "SH", "AH0", "N", "Z"],
    "abstracts": ["AE1", "B", "S", "T", "R", "AE0", "K", "T", "S"],
    "abstruse": ["AH0", "B", "S", "T", "R", "UW1", "S"],
    "absurd": ["AH0", "B", "S", "ER1", "D"],
    "absurdist": ["AH0", "B", "S", "ER1", "D", "IH0", "S", "T"],
    "absurdities": ["AH0", "B", "S", "ER1", "D", "AH0", "T", "IY0", "Z"],
    "absurdity": ["AH0", "B", "S", "ER1", "D", "AH0", "T", "IY0"],
    "absurdly": ["AH0", "B", "S", "ER1", "D", "L", "IY0"],
    "abt": ["EY1", "B", "IY1", "T", "IY1"],
    "abts": ["EY1", "B", "IY1", "T", "IY1", "EH1", "S"],
    "abu": ["AE1", "B", "UW0"],
    "abudrahm": ["AH0", "B", "AH1", "D", "R", "AH0", "M"],
    "abuellah": ["AH0", "B", "W", "EH1", "L", "AH0"],
    "abuellah's": ["AH0", "B", "W", "EH1", "L", "AH0", "Z"],
    "abuladze": ["AE2", "B", "Y", "UW0", "L", "AE1", "D", "Z", "IY0"],
    "abundance": ["AH0", "B", "AH1", "N", "D", "AH0", "N", "S"],
    "abundant": ["AH0", "B", "AH1", "N", "D", "AH0", "N", "T"],
    "abundantly": ["AH0", "B", "AH1", "N", "D", "AH0", "N", "T", "L", "IY0"],
    "aburto": ["AH0", "B", "UH1", "R", "T", "OW2"],
    "aburto's": ["AH0", "B", "UH1", "R", "T", "OW2", "Z"],
    "abuse": ["AH0", "B", "Y", "UW1", "Z"],
    "abused": ["AH0", "B", "Y", "UW1", "Z", "D"],
    "abuser": ["AH0", "B", "Y", "UW1", "Z", "ER0"],
    "abusers": ["AH0", "B", "Y", "UW1", "Z", "ER0", "Z"],
    "abuses": ["AH0", "B", "Y", "UW1", "Z", "IH0", "Z"],
    "abusing": ["AH0", "B", "Y", "UW1", "Z", "IH0", "NG"],
    "abusive": ["AH0", "B", "Y", "UW1", "S", "IH0", "V"],
    "abut": ["AH0", "B", "AH1", "T"],
    "abuts": ["AH0", "B", "AH1", "T", "S"],
    "abutted": ["AH0", "B", "AH1", "T", "IH0", "D"],
    "abutting": ["AH0", "B", "AH1", "T", "IH0", "NG"],
    "abuzz": ["AH0", "B", "AH1", "Z"],
    "abysmal": ["AH0", "B", "IH1", "Z", "M", "AH0", "L"],
    "abysmally": ["AH0", "B", "IH1", "Z", "M", "AH0", "L", "IY0"],
    "abyss": ["AH0", "B", "IH1", "S"],
    "abyssinia": ["AE0", "B", "S", "IH1", "N", "IY2", "AH0"],
    "abyssinian": ["AE0", "B", "S", "IH1", "N", "IY2", "AH0", "N"],
    "abzug": ["AE1", "B", "Z", "UH2", "G"],
    "ac": ["EY1", "S", "IY1"],
    "aca": ["AE1", "K", "AH0"],
    "acacia": ["AH0", "K", "EY1", "SH", "AH0"],
    "academe": ["AE1", "K", "AH0", "D", "IY2", "M"],
    "academia": ["AE2", "K", "AH0", "D", "IY1", "M", "IY0", "AH0"],
    "academic": ["AE2", "K", "AH0", "D", "EH1", "M", "IH0", "K"],
    "academically": ["AE2", "K", "AH0", "D", "EH1", "M", "IH0", "K", "L", "IY0"],
    "academician": ["AE2", "K", "AH0", "D", "AH0", "M", "IH1", "SH", "AH0", "N"],
    "academicians": ["AH0", "K", "AE2", "D", "AH0", "M", "IH1", "SH", "AH0", "N", "Z"],
    "academics": ["AE2", "K", "AH0", "D", "EH1", "M", "IH0", "K", "S"],
    "academies": ["AH0", "K", "AE1", "D", "AH0", "M", "IY0", "Z"],
    "academy": ["AH0", "K", "AE1", "D", "AH0", "M", "IY0"],
    "academy's": ["AH0", "K", "AE1", "D", "AH0", "M", "IY0", "Z"],
    "acadia": ["AH0", "K", "EY1", "D", "IY0", "AH0"],
    "acaena": ["AH0", "S", "IY1", "N", "AH0"],
    "acampo": ["AH0", "K", "AA1", "M", "P", "OW0"],
    "acampora": ["AH0", "K", "AE1", "M", "P", "ER0", "AH0"],
    "acampsia": ["AH0", "K", "AE1", "M", "P", "S", "Y", "AH0"],
    "acantha": ["AA0", "K", "AA1", "N", "DH", "AH0"],
    "acapulco": ["AE2", "K", "AH0", "P", "UH1", "L", "K", "OW0"],
    "acary": ["AE1", "K", "ER0", "IY0"],
    "acc": ["AY2", "S", "IY2", "S", "IY1"],
    "accardi": ["AA0", "K", "AA1", "R", "D", "IY0"],
    "accardo": ["AA0", "K", "AA1", "R", "D", "OW0"],
    "accede": ["AE0", "K", "S", "IY1", "D"],
    "acceded": ["AE0", "K", "S", "IY1", "D", "IH0", "D"],
    "accedes": ["AE0", "K", "S", "IY1", "D", "Z"],
    "acceding": ["AE0", "K", "S", "IY1", "D", "IH0", "NG"],
    "accel": ["AH0", "K", "S", "EH1", "L"],
    "accelerant": ["AE0", "K", "S", "EH1", "L", "ER0", "AH0", "N", "T"],
    "accelerants": ["AE0", "K", "S", "EH1", "L", "ER0", "AH0", "N", "T", "S"],
    "accelerate": ["AE0", "K", "S", "EH1", "L", "ER0", "EY2", "T"],
    "accelerated": ["AE0", "K", "S", "EH1", "L", "ER0", "EY2", "T", "IH0", "D"],
    "accelerates": ["AE0", "K", "S", "EH1", "L", "ER0", "EY2", "T", "S"],
    "accelerating": ["AE0", "K", "S", "EH1", "L", "ER0", "EY2", "T", "IH0", "NG"],
    "acceleration": ["AE2", "K", "S", "EH2", "L", "ER0", "EY1", "SH", "AH0", "N"],
    "accelerator": ["AE0", "K", "S", "EH1", "L", "ER0", "EY2", "T", "ER0"],
    "accelerators": ["AE0", "K", "S", "EH1", "L", "ER0", "EY2", "T", "ER0", "Z"],
    "accelerometer": ["AE0", "K", "S", "EH2", "L", "ER0", "AA1", "M", "AH0", "T", "ER0"],
    "accelerometers": ["AE0", "K", "S", "EH2", "L", "ER0", "AA1", "M", "AH0", "T", "ER0", "Z"],
    "accent": ["AE1", "K", "S", "EH2", "N", "T"],
    "accented": ["AE1", "K", "S", "EH0", "N", "T", "IH0", "D"],
    "accenting": ["AE1", "K", "S", "EH0", "N", "T", "IH0", "NG"],
    "accents": ["AE1", "K", "S", "EH0", "N", "T", "S"],
    "accentuate": ["AE0", "K", "S", "EH1", "N", "CH", "UW0", "EY0", "T"],
    "accentuated": ["AE0", "K", "S", "EH1", "N", "CH", "UW0", "EY2", "T", "IH0", "D"],
    "accentuates": ["AE0", "K", "S", "EH1", "N", "CH", "UW0", "EY2", "T", "S"],
    "accentuating": ["AE0", "K", "S", "EH1", "N", "CH", "UW0", "EY2", "T", "IH0", "NG"],
    "accenture": ["AE0", "K", "S", "EH1", "N", "CH", "ER0"],
    "accept": ["AH0", "K", "S", "EH1", "P", "T"],
    "acceptability": ["AH0", "K", "S", "EH2", "P", "T", "AH0", "B", "IH1", "L", "AH0", "T", "IY0"],
    "acceptable": ["AH0", "K", "S", "EH1", "P", "T", "AH0", "B", "AH0", "L"],
    "acceptably": ["AH0", "K", "S", "EH1", "P", "T", "AH0", "B", "L", "IY0"],
    "acceptance": ["AH0", "K", "S", "EH1", "P", "T", "AH0", "N", "S"],
    "acceptances": ["AE0", "K", "S", "EH1", "P", "T", "AH0", "N", "S", "IH0", "Z"],
    "accepted": ["AH0", "K", "S", "EH1", "P", "T", "IH0", "D"],
    "accepting": ["AH0", "K", "S", "EH1", "P", "T", "IH0", "NG"],
    "accepts": ["AE0", "K", "S", "EH1", "P", "T", "S"],
    "access": ["AE1", "K", "S", "EH2", "S"],
    "accessed": ["AE1", "K", "S", "EH2", "S", "T"],
    "accessibility": ["AE2", "K", "S", "EH0", "S", "AH0", "B", "IH1", "L", "IH0", "T", "IY0"],
    "accessible": ["AE0", "K", "S", "EH1", "S", "AH0", "B", "AH0", "L"],
    "accessing": ["AE1", "K", "S", "EH2", "S", "IH0", "NG"],
    "accession": ["AH0", "K", "S", "EH1", "SH", "AH0", "N"],
    "accessories": ["AE0", "K", "S", "EH1", "S", "ER0", "IY0", "Z"],
    "accessorize": ["AE0", "K", "S", "EH1", "S", "ER0", "AY2", "Z"],
    "accessorized": ["AE0", "K", "S", "EH1", "S", "ER0", "AY2", "Z", "D"],
    "accessory": ["AE0", "K", "S", "EH1", "S", "ER0", "IY0"],
    "accetta": ["AA0", "CH", "EH1", "T", "AH0"],
    "accident": ["AE1", "K", "S", "AH0", "D", "AH0", "N", "T"],
    "accident's": ["AE1", "K", "S", "AH0", "D", "AH0", "N", "T", "S"],
    "accidental": ["AE2", "K", "S", "AH0", "D", "EH1", "N", "AH0", "L"],
    "accidentally": ["AE2", "K", "S", "AH0", "D", "EH1", "N", "AH0", "L", "IY0"],
    "accidently": ["AE1", "K", "S", "AH0", "D", "AH0", "N", "T", "L", "IY0"],
    "accidents": ["AE1", "K", "S", "AH0", "D", "AH0", "N", "T", "S"],
    "accion": ["AE1", "CH", "IY0", "AH0", "N"],
    "accival": ["AE1", "S", "IH0", "V", "AA2", "L"],
    "acclaim": ["AH0", "K", "L", "EY1", "M"],
    "acclaim's": ["AH0", "K", "L", "EY1", "M", "Z"],
    "acclaimed": ["AH0", "K", "L", "EY1", "M", "D"],
    "acclaiming": ["AH0", "K", "L", "EY1", "M", "IH0", "NG"],
    "acclaims": ["AH0", "K", "L", "EY1", "M", "Z"],
    "acclamation": ["AE2", "K", "L", "AH0", "M", "EY1", "SH", "AH0", "N"],
    "acclimate": ["AE1", "K", "L", "AH0", "M", "EY2", "T"],
    "acclimated": ["AE1", "K", "L", "AH0", "M", "EY2", "T", "IH0", "D"],
    "acclimation": ["AE2", "K", "L", "AH0", "M", "EY1", "SH", "AH0", "N"],
    "acco": ["AE1", "K", "OW0"],
    "accokeek": ["AE1", "K", "OW0", "K", "IY0", "K"],
    "accola": ["AA0", "K", "OW1", "L", "AH0"],
    "accolade": ["AE1", "K", "AH0", "L", "EY2", "D"],
    "accolades": ["AE1", "K", "AH0", "L", "EY2", "D", "Z"],
    "accomando": ["AA0", "K", "OW0", "M", "AA1", "N", "D", "OW0"],
    "accommodate": ["AH0", "K", "AA1", "M", "AH0", "D", "EY2", "T"],
    "accommodated": ["AH0", "K", "AA1", "M", "AH0", "D", "EY2", "T", "IH0", "D"],
    "accommodates": ["AH0", "K", "AA1", "M", "AH0", "D", "EY2", "T", "S"],
    "accommodating": ["AH0", "K", "AA1", "M", "AH0", "D", "EY2", "T", "IH0", "NG"],
    "accommodation": ["AH0", "K", "AA2", "M", "AH0", "D", "EY1", "SH", "AH0", "N"],
    "accommodations": ["AH0", "K", "AA2", "M", "AH0", "D", "EY1", "SH", "AH0", "N", "Z"],
    "accommodative": ["AH0", "K", "AA1", "M", "AH0", "D", "EY2", "T", "IH0", "V"],
    "accompanied": ["AH0", "K", "AH1", "M", "P", "AH0", "N", "IY0", "D"],
    "accompanies": ["AH0", "K", "AH1", "M", "P", "AH0", "N", "IY0", "Z"],
    "accompaniment": ["AH0", "K", "AH1", "M", "P", "N", "IY0", "M", "AH0", "N", "T"],
    "accompaniments": ["AH0", "K", "AH1", "M", "P", "N", "IY0", "M", "AH0", "N", "T", "S"],
    "accompanist": ["AH0", "K", "AH1", "M", "P", "AH0", "N", "AH0", "S", "T"],
    "accompany": ["AH0", "K", "AH1", "M", "P", "AH0", "N", "IY0"],
    "accompanying": ["AH0", "K", "AH1", "M", "P", "AH0", "N", "IY0", "IH0", "NG"],
    "accompli": ["AH0", "K", "AA1", "M", "P", "L", "IY0"],
    "accomplice": ["AH0", "K", "AA1", "M", "P", "L", "AH0", "S"],
    "accomplices": ["AH0", "K", "AA1", "M", "P", "L", "AH0", "S", "AH0", "Z"],
    "accomplish": ["AH0", "K", "AA1", "M", "P", "L", "IH0", "SH"],
    "accomplished": ["AH0", "K", "AA1", "M", "P", "L", "IH0", "SH", "T"],
    "accomplishes": ["AH0", "K", "AA1", "M", "P", "L", "IH0", "SH", "IH0", "Z"],
    "accomplishing": ["AH0", "K", "AA1", "M", "P", "L", "IH0", "SH", "IH0", "NG"],
    "accomplishment": ["AH0", "K", "AA1", "M", "P", "L", "IH0", "SH", "M", "AH0", "N", "T"],
    "accomplishments": ["AH0", "K", "AA1", "M", "P", "L", "IH0", "SH", "M", "AH0", "N", "T", "S"],
    "accor": ["AE1", "K", "AO2", "R"],
    "accor's": ["AE1", "K", "ER0", "Z"],
    "accord": ["AH0", "K", "AO1", "R", "D"],
    "accord's": ["AH0", "K", "AO1", "R", "D", "Z"],
    "accordance": ["AH0", "K", "AO1", "R", "D", "AH0", "N", "S"],
    "accorded": ["AH0", "K", "AO1", "R", "D", "IH0", "D"],
    "according": ["AH0", "K", "AO1", "R", "D", "IH0", "NG"],
    "accordingly": ["AH0", "K", "AO1", "R", "D", "IH0", "NG", "L", "IY0"],
    "accordion": ["AH0", "K", "AO1", "R", "D", "IY0", "AH0", "N"],
    "accordions": ["AH0", "K", "AO1", "R", "D", "IY0", "AH0", "N", "Z"],
    "accords": ["AH0", "K", "AO1", "R", "D", "Z"],
    "accost": ["AH0", "K", "AO1", "S", "T"],
    "accosted": ["AH0", "K", "AA1", "S", "T", "IH0", "D"],
    "accosting": ["AH0", "K", "AA1", "S", "T", "IH0", "NG"],
    "account": ["AH0", "K", "AW1", "N", "T"],
    "account's": ["AH0", "K", "AW1", "N", "T", "S"],
    "accountability": ["AH0", "K", "AW1", "N", "AH0", "B", "IH0", "L", "IH0", "T", "IY0"],
    "accountable": ["AH0", "K", "AW1", "N", "AH0", "B", "AH0", "L"],
    "accountancy": ["AH0", "K", "AW1", "N", "T", "AH0", "N", "S", "IY0"],
    "accountant": ["AH0", "K", "AW1", "N", "T", "AH0", "N", "T"],
    "accountant's": ["AH0", "K", "AW1", "N", "T", "AH0", "N", "T", "S"],
    "accountants": ["AH0", "K", "AW1", "N", "T", "AH0", "N", "T", "S"],
    "accountants'": ["AH0", "K", "AW1", "N", "T", "AH0", "N", "T", "S"],
    "accounted": ["AH0", "K", "AW1", "N", "AH0", "D"],
    "accountemp": ["AH0", "K", "AW1", "N", "T", "EH2", "M", "P"],
    "accountemps": ["AH0", "K", "AW1", "N", "T", "EH2", "M", "P", "S"],
    "accounting": ["AH0", "K", "AW1", "N", "IH0", "NG"],
    "accounts": ["AH0", "K", "AW1", "N", "T", "S"],
    "accouterment": ["AH0", "K", "UW1", "T", "ER0", "M", "AH0", "N", "T"],
    "accouterments": ["AH0", "K", "UW1", "T", "ER0", "M", "AH0", "N", "T", "S"],
    "accoutrement": ["AH0", "K", "UW1", "T", "ER0", "M", "AH0", "N", "T"],
    "accoutrements": ["AH0", "K", "UW1", "T", "ER0", "M", "AH0", "N", "T", "S"],
    "accra": ["AA1", "K", "R", "AA2"],
    "accredit": ["AH0", "K", "R", "EH2", "D", "AH0", "T"],
    "accreditation": ["AH0", "K", "R", "EH2", "D", "AH0", "T", "EY1", "SH", "AH0", "N"],
    "accreditations": ["AH0", "K", "R", "EH2", "D", "AH0", "T", "EY1", "SH", "AH0", "N", "Z"],
    "accredited": ["AH0", "K", "R", "EH1", "D", "IH0", "T", "IH0", "D"],
    "accrediting": ["AH0", "K", "R", "EH1", "D", "AH0", "T", "IH0", "NG"],
    "accreted": ["AH0", "K", "R", "IY1", "T", "IH0", "D"],
    "accretion": ["AH0", "K", "R", "IY1", "SH", "AH0", "N"],
    "accrual": ["AH0", "K", "R", "UW1", "AH0", "L"],
    "accruals": ["AH0", "K", "R", "UW1", "AH0", "L", "Z"],
    "accrue": ["AH0", "K", "R", "UW1"],
    "accrued": ["AH0", "K", "R", "UW1", "D"],
    "accrues": ["AH0", "K", "R", "UW1", "Z"],
    "accruing": ["AH0", "K", "R", "UW1", "IH0", "NG"],
    "accu": ["AE1", "K", "Y", "UW0"],
    "accuhealth": ["AE1", "K", "Y", "UW0", "HH", "EH2", "L", "TH"],
    "accumulate": ["AH0", "K", "Y", "UW1", "M", "Y", "AH0", "L", "EY2", "T"],
    "accumulated": ["AH0", "K", "Y", "UW1", "M", "Y", "AH0", "L", "EY2", "T", "IH0", "D"],
    "accumulates": ["AH0", "K", "Y", "UW1", "M", "Y", "AH0", "L", "EY2", "T", "S"],
    "accumulating": ["AH0", "K", "Y", "UW1", "M", "Y", "AH0", "L", "EY2", "T", "IH0", "NG"],
    "accumulation": ["AH0", "K", "Y", "UW2", "M", "Y", "AH0", "L", "EY1", "SH", "AH0", "N"],
    "accumulations": ["AH0", "K", "Y", "UW2", "M", "Y", "AH0", "L", "EY1", "SH", "AH0", "N", "Z"],
    "accumulative": ["AH0", "K", "Y", "UW1", "M", "Y", "AH0", "L", "EY2", "T", "IH0", "V"],
    "accumulatively": ["AH0", "K", "Y", "UW1", "M", "Y", "AH0", "L", "AH0", "T", "IH2", "V", "L", "IY0"],
    "accumulator": ["AH0", "K", "Y", "UW1", "M", "Y", "AH0", "L", "EY2", "T", "ER0"],
    "accumulators": ["AH0", "K", "Y", "UW1", "M", "Y", "AH0", "L", "EY2", "T", "ER0", "Z"],
    "accuracies": ["AE1", "K", "Y", "ER0", "AH0", "S", "IY0", "Z"],
    "accuracy": ["AE1", "K", "Y", "ER0", "AH0", "S", "IY0"],
    "accurate": ["AE1", "K", "Y", "ER0", "AH0", "T"],
    "accurately": ["AE1", "K", "Y", "ER0", "AH0", "T", "L", "IY0"],
    "accuray": ["AE1", "K", "Y", "ER0", "EY2"],
    "accuray's": ["AE1", "K", "Y", "ER0", "EY2", "Z"],
    "accuride": ["AE1", "K", "Y", "ER0", "AY2", "D"],
    "accursed": ["AE2", "K", "ER1", "S", "T"],
    "accurso": ["AA0", "K", "UH1", "R", "S", "OW0"],
    "accusation": ["AE2", "K", "Y", "UW0", "Z", "EY1", "SH", "AH0", "N"],
    "accusations": ["AE2", "K", "Y", "UW0", "Z", "EY1", "SH", "AH0", "N", "Z"],
    "accusative": ["AH0", "K", "Y", "UW1", "Z", "AH0", "T", "IH0", "V"],
    "accusatory": ["AH0", "K", "Y", "UW1", "Z", "AH0", "T", "AO2", "R", "IY0"],
    "accuse": ["AH0", "K", "Y", "UW1", "Z"],
    "accused": ["AH0", "K", "Y", "UW1", "Z", "D"],
    "accuser": ["AH0", "K", "Y", "UW1", "Z", "ER0"],
    "accusers": ["AH0", "K", "Y", "UW1", "Z", "ER0", "Z"],
    "accuses": ["AH0", "K", "Y", "UW1", "Z", "IH0", "Z"],
    "accusing": ["AH0", "K", "Y", "UW1", "Z", "IH0", "NG"],
    "accusingly": ["AH0", "K", "Y", "UW1", "Z", "IH0", "NG", "L", "IY0"],
    "accustom": ["AH0", "K", "AH1", "S", "T", "AH0", "M"],
    "accustomed": ["AH0", "K", "AH1", "S", "T", "AH0", "M", "D"],
    "accutane": ["AE1", "K", "Y", "UW0", "T", "EY2", "N"],
    "ace": ["EY1", "S"],
    "acecomm": ["EY1", "S", "K", "AA0", "M"],
    "aced": ["EY1", "S", "T"],
    "acer": ["EY1", "S", "ER0"],
    "acerbic": ["AH0", "S", "EH1", "R", "B", "IH0", "K"],
    "acero": ["AH0", "TH", "EH1", "R", "OW0"],
    "acerra": ["AH0", "S", "EH1", "R", "AH0"],
    "aces": ["EY1", "S", "IH0", "Z"],
    "acetaminophen": ["AH0", "S", "IY2", "T", "AH0", "M", "IH1", "N", "AH0", "F", "AH0", "N"],
    "acetate": ["AE1", "S", "AH0", "T", "EY2", "T"],
    "acetic": ["AH0", "S", "IY1", "T", "IH0", "K"],
    "aceto": ["AA0", "S", "EH1", "T", "OW0"],
    "acetochlor": ["AA0", "S", "EH1", "T", "OW0", "K", "L", "AO2", "R"],
    "acetone": ["AE1", "S", "AH0", "T", "OW2", "N"],
    "acetosyringone": ["AH0", "S", "EH2", "T", "OW0", "S", "IH1", "R", "IH0", "NG", "G", "AO0", "N"],
    "acetylcholine": ["AH0", "S", "IY2", "T", "AH0", "L", "K", "OW1", "L", "IY0", "N"],
    "acetylene": ["AH0", "S", "EH1", "T", "AH0", "L", "IY2", "N"],
    "acevedo": ["AE0", "S", "AH0", "V", "EY1", "D", "OW0"],
    "aceves": ["AA0", "S", "EY1", "V", "EH0", "S"],
    "acey": ["EY1", "S", "IY0"],
    "ach": ["EY1", "S", "IY1", "EY1", "CH"],
    "achaean": ["AH0", "CH", "IY1", "AH0", "N"],
    "achatz": ["AE1", "K", "AH0", "T", "S"],
    "ache": ["EY1", "K"],
    "achebe": ["AA0", "CH", "EY1", "B", "IY0"],
    "ached": ["EY1", "K", "T"],
    "achee": ["AH0", "CH", "IY1"],
    "achenbach": ["AE1", "K", "IH0", "N", "B", "AA0", "K"],
    "achenbaum": ["AE1", "K", "AH0", "N", "B", "AW2", "M"],
    "achene": ["AH0", "K", "IY1", "N"],
    "achenes": ["AH0", "K", "IY1", "N", "Z"],
    "aches": ["EY1", "K", "S"],
    "acheson": ["AE1", "CH", "AH0", "S", "AH0", "N"],
    "acheson's": ["AE1", "CH", "AH0", "S", "AH0", "N", "Z"],
    "achesons": ["AE1", "CH", "AH0", "S", "AH0", "N", "Z"],
    "achey": ["AE1", "CH", "IY0"],
    "achieva": ["AH0", "CH", "IY1", "V", "AH0"],
    "achievable": ["AH0", "CH", "IY1", "V", "AH0", "B", "AH0", "L"],
    "achieve": ["AH0", "CH", "IY1", "V"],
    "achieved": ["AH0", "CH", "IY1", "V", "D"],
    "achievement": ["AH0", "CH", "IY1", "V", "M", "AH0", "N", "T"],
    "achievements": ["AH0", "CH", "IY1", "V", "M", "AH0", "N", "T", "S"],
    "achiever": ["AH0", "CH", "IY1", "V", "ER0"],
    "achievers": ["AH0", "CH", "IY1", "V", "ER0", "Z"],
    "achieves": ["AH0", "CH", "IY1", "V", "Z"],
    "achieving": ["AH0", "CH", "IY1", "V", "IH0", "NG"],
    "achill": ["AE1", "K", "IH0", "L"],
    "achill's": ["AE1", "K", "IH0", "L", "Z"],
    "achille": ["AH0", "K", "IH1", "L", "IY0"],
    "achilles": ["AH0", "K", "IH1", "L", "IY0", "Z"],
    "achilles'": ["AH0", "K", "IH1", "L", "IY0", "Z"],
    "aching": ["EY1", "K", "IH0", "NG"],
    "achingly": ["EY1", "K", "IH0", "NG", "L", "IY0"],
    "achmed": ["AA1", "HH", "M", "EH0", "D"],
    "achoa": ["AH0", "CH", "OW1", "AH0"],
    "achoa's": ["AH0", "CH", "OW1", "AH0", "Z"],
    "achoo": ["AA2", "CH", "UW1"],
    "achor": ["EY1", "K", "ER0"],
    "achord": ["AE1", "K", "AO0", "R", "D"],
    "achorn": ["AE1", "K", "ER0", "N"],
    "achtenberg": ["AE1", "K", "T", "EH0", "N", "B", "ER0", "G"],
    "achterberg": ["AE1", "K", "T", "ER0", "B", "ER0", "G"],
    "achy": ["EY1", "K", "IY0"],
    "acid": ["AE1", "S", "AH0", "D"],
    "acidic": ["AH0", "S", "IH1", "D", "IH0", "K"],
    "acidification": ["AH0", "S", "IH2", "D", "AH0", "F", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "acidified": ["AH0", "S", "IH1", "D", "AH0", "F", "AY2", "D"],
    "acidifies": ["AH0", "S", "IH1", "D", "AH0", "F", "AY2", "Z"],
    "acidify": ["AH0", "S", "IH1", "D", "AH0", "F", "AY2"],
    "acidity": ["AH0", "S", "IH1", "D", "AH0", "T", "IY0"],
    "acidly": ["AE1", "S", "AH0", "D", "L", "IY0"],
    "acidosis": ["AE2", "S", "AH0", "D", "OW1", "S", "AH0", "S"],
    "acids": ["AE1", "S", "AH0", "D", "Z"],
    "aciduria": ["AE2", "S", "AH0", "D", "UH1", "R", "IY0", "AH0"],
    "acierno": ["AA0", "S", "IH1", "R", "N", "OW0"],
    "ack": ["AE1", "K"],
    "acker": ["AE1", "K", "ER0"],
    "acker's": ["AE1", "K", "ER0", "Z"],
    "ackerley": ["AE1", "K", "ER0", "L", "IY0"],
    "ackerly": ["AE1", "K", "ER0", "L", "IY0"],
    "ackerman": ["AE1", "K", "ER0", "M", "AH0", "N"],
    "ackermann": ["AE1", "K", "ER0", "M", "AH0", "N"],
    "ackermanville": ["AE1", "K", "ER0", "M", "AH0", "N", "V", "IH0", "L"],
    "ackerson": ["AE1", "K", "ER0", "S", "AH0", "N"],
    "ackert": ["AE1", "K", "ER0", "T"],
    "ackhouse": ["AE1", "K", "HH", "AW2", "S"],
    "ackland": ["AE1", "K", "L", "AH0", "N", "D"],
    "ackles": ["AE1", "K", "AH0", "L", "Z"],
    "ackley": ["AE1", "K", "L", "IY0"],
    "acklin": ["AE1", "K", "L", "IH0", "N"],
    "ackman": ["AE1", "K", "M", "AH0", "N"],
    "acknowledge": ["AE0", "K", "N", "AA1", "L", "IH0", "JH"],
    "acknowledgeable": ["AE0", "K", "N", "AA1", "L", "IH0", "JH", "AH0", "B", "AH0", "L"],
    "acknowledged": ["AE0", "K", "N", "AA1", "L", "IH0", "JH", "D"],
    "acknowledgement": ["AE0", "K", "N", "AA1", "L", "IH0", "JH", "M", "AH0", "N", "T"],
    "acknowledgements": ["AE0", "K", "N", "AA1", "L", "IH0", "JH", "M", "AH0", "N", "T", "S"],
    "acknowledges": ["AE0", "K", "N", "AA1", "L", "IH0", "JH", "IH0", "Z"],
    "acknowledging": ["AE0", "K", "N", "AA1", "L", "IH0", "JH", "IH0", "NG"],
    "acknowledgment": ["AE0", "K", "N", "AA1", "L", "IH0", "JH", "M", "AH0", "N", "T"],
    "acknowledgments": ["AE0", "K", "N", "AA1", "L", "IH0", "JH", "M", "AH0", "N", "T", "S"],
    "ackroyd": ["AE1", "K", "R", "OY2", "D"],
    "ackroyd's": ["AE1", "K", "R", "OY2", "D", "Z"],
    "acm": ["EY2", "S", "IY2", "EH1", "M"],
    "acmat": ["AE1", "K", "M", "AE0", "T"],
    "acmat's": ["AE1", "K", "M", "AE0", "T", "S"],
    "acme": ["AE1", "K", "M", "IY0"],
    "acme's": ["AE1", "K", "M", "IY0", "Z"],
    "acne": ["AE1", "K", "N", "IY0"],
    "acocella": ["AA0", "K", "OW0", "CH", "EH1", "L", "AH0"],
    "acoff": ["AE1", "K", "AO0", "F"],
    "acog": ["AH0", "K", "AO1", "G"],
    "acolyte": ["AE1", "K", "AH0", "L", "AY2", "T"],
    "acolytes": ["AE1", "K", "AH0", "L", "AY2", "T", "S"],
    "acomb": ["Y", "AE1", "K", "AH0", "M"],
    "acord": ["AH0", "K", "AO1", "R", "D"],
    "acordia": ["AH0", "K", "AO1", "R", "D", "IY0", "AH0"],
    "acorn": ["EY1", "K", "AO0", "R", "N"],
    "acorn's": ["EY1", "K", "AO0", "R", "N", "Z"],
    "acorns": ["EY1", "K", "AO0", "R", "N", "Z"],
    "acosta": ["AH0", "K", "AO1", "S", "T", "AH0"],
    "acott": ["EY1", "K", "AO0", "T"],
    "acoustic": ["AH0", "K", "UW1", "S", "T", "IH0", "K"],
    "acoustical": ["AH0", "K", "UW1", "S", "T", "IH0", "K", "AH0", "L"],
    "acoustically": ["AH0", "K", "UW1", "S", "T", "IH0", "K", "L", "IY0"],
    "acoustics": ["AH0", "K", "UW1", "S", "T", "IH0", "K", "S"],
    "acquaint": ["AH0", "K", "W", "EY1", "N", "T"],
    "acquaintance": ["AH0", "K", "W", "EY1", "N", "T", "AH0", "N", "S"],
    "acquaintances": ["AH0", "K", "W", "EY1", "N", "T", "AH0", "N", "S", "IH0", "Z"],
    "acquaintanceship": ["AH0", "K", "W", "EY1", "N", "T", "AH0", "N", "S", "SH", "IH0", "P"],
    "acquainted": ["AH0", "K", "W", "EY1", "N", "IH0", "D"],
    "acquaviva": ["AA0", "K", "W", "AA0", "V", "IY1", "V", "AH0"],
    "acquiesce": ["AE2", "K", "W", "IY0", "EH1", "S"],
    "acquiesced": ["AE2", "K", "W", "IY0", "EH1", "S", "T"],
    "acquiescence": ["AE2", "K", "W", "IY0", "EH1", "S", "AH0", "N", "S"],
    "acquiescent": ["AE2", "K", "W", "IY0", "EH1", "S", "AH0", "N", "T"],
    "acquiescing": ["AE2", "K", "W", "IY0", "EH1", "S", "IH0", "NG"],
    "acquire": ["AH0", "K", "W", "AY1", "ER0"],
    "acquired": ["AH0", "K", "W", "AY1", "ER0", "D"],
    "acquirer": ["AH0", "K", "W", "AY1", "ER0", "ER0"],
    "acquirer's": ["AH0", "K", "W", "AY1", "ER0", "ER0", "Z"],
    "acquirers": ["AH0", "K", "W", "AY1", "ER0", "ER0", "Z"],
    "acquires": ["AH0", "K", "W", "AY1", "ER0", "Z"],
    "acquiring": ["AH0", "K", "W", "AY1", "ER0", "IH0", "NG"],
    "acquisition": ["AE2", "K", "W", "AH0", "Z", "IH1", "SH", "AH0", "N"],
    "acquisition's": ["AE2", "K", "W", "AH0", "Z", "IH1", "SH", "AH0", "N", "Z"],
    "acquisitions": ["AE2", "K", "W", "AH0", "Z", "IH1", "SH", "AH0", "N", "Z"],
    "acquisitive": ["AH0", "K", "W", "IH1", "Z", "AH0", "T", "IH0", "V"],
    "acquit": ["AH0", "K", "W", "IH1", "T"],
    "acquitaine": ["AE1", "K", "W", "IH0", "T", "EY2", "N"],
    "acquits": ["AH0", "K", "W", "IH1", "T", "S"],
    "acquittal": ["AH0", "K", "W", "IH1", "T", "AH0", "L"],
    "acquittals": ["AH0", "K", "W", "IH1", "T", "AH0", "L", "Z"],
    "acquitted": ["AH0", "K", "W", "IH1", "T", "IH0", "D"],
    "acquitting": ["AH0", "K", "W", "IH1", "T", "IH0", "NG"],
    "acre": ["EY1", "K", "ER0"],
    "acreage": ["EY1", "K", "R", "AH0", "JH"],
    "acree": ["AH0", "K", "R", "IY1"],
    "acres": ["EY1", "K", "ER0", "Z"],
    "acrey": ["AE1", "K", "R", "IY0"],
    "acri": ["AA1", "K", "R", "IY0"],
    "acrid": ["AE1", "K", "R", "IH0", "D"],
    "acrimonious": ["AE2", "K", "R", "AH0", "M", "OW1", "N", "IY0", "AH0", "S"],
    "acrimony": ["AE1", "K", "R", "IH0", "M", "OW2", "N", "IY0"],
    "acro": ["AE1", "K", "R", "OW0"],
    "acrobat": ["AE1", "K", "R", "AH0", "B", "AE2", "T"],
    "acrobatic": ["AE2", "K", "R", "AH0", "B", "AE1", "T", "IH0", "K"],
    "acrobatics": ["AE2", "K", "R", "AH0", "B", "AE1", "T", "IH0", "K", "S"],
    "acrobats": ["AE1", "K", "R", "AH0", "B", "AE2", "T", "S"],
    "acrolein": ["AE1", "K", "R", "OW0", "L", "IY2", "N"],
    "acronym": ["AE1", "K", "R", "AH0", "N", "IH0", "M"],
    "acronyms": ["AE1", "K", "R", "AH0", "N", "IH0", "M", "Z"],
    "acropolis": ["AH0", "K", "R", "AA1", "P", "AH0", "L", "AH0", "S"],
    "across": ["AH0", "K", "R", "AO1", "S"],
    "acrylic": ["AH0", "K", "R", "IH1", "L", "IH0", "K"],
    "acrylics": ["AH0", "K", "R", "IH1", "L", "IH0", "K", "S"],
    "act": ["AE1", "K", "T"],
    "act's": ["AE1", "K", "T", "S"],
    "acta": ["AE1", "K", "T", "AA0"],
    "actava": ["AE2", "K", "T", "AA1", "V", "AH0"],
    "actava's": ["AE2", "K", "T", "AA1", "V", "AH0", "Z"],
    "actavas": ["AE2", "K", "T", "AA1", "V", "AH0", "Z"],
    "acted": ["AE1", "K", "T", "IH0", "D"],
    "actel": ["AE1", "K", "T", "EH0", "L"],
    "actigall": ["AE1", "K", "T", "IH0", "G", "AO0", "L"],
    "actin": ["AE1", "K", "T", "AH0", "N"],
    "acting": ["AE1", "K", "T", "IH0", "NG"],
    "actinide": ["AE1", "K", "T", "IH0", "N", "AY2", "D"],
    "actinidia": ["AE2", "K", "T", "IH0", "N", "IH1", "D", "IY0", "AH0"],
    "actinomycosis": ["AE2", "K", "T", "IH2", "N", "OW0", "M", "AY2", "K", "OW1", "S", "IH0", "S"],
    "action": ["AE1", "K", "SH", "AH0", "N"],
    "action's": ["AE1", "K", "SH", "AH0", "N", "Z"],
    "actionable": ["AE1", "K", "SH", "AH0", "N", "AH0", "B", "AH0", "L"],
    "actions": ["AE1", "K", "SH", "AH0", "N", "Z"],
    "activase": ["AE1", "K", "T", "IH0", "V", "EY2", "Z"],
    "activate": ["AE1", "K", "T", "AH0", "V", "EY2", "T"],
    "activated": ["AE1", "K", "T", "AH0", "V", "EY2", "T", "IH0", "D"],
    "activates": ["AE1", "K", "T", "AH0", "V", "EY2", "T", "S"],
    "activating": ["AE1", "K", "T", "AH0", "V", "EY2", "T", "IH0", "NG"],
    "activation": ["AE2", "K", "T", "AH0", "V", "EY1", "SH", "AH0", "N"],
    "activator": ["AE1", "K", "T", "AH0", "V", "EY2", "T", "ER0"],
    "active": ["AE1", "K", "T", "IH0", "V"],
    "active's": ["AE1", "K", "T", "IH0", "V", "Z"],
    "actively": ["AE1", "K", "T", "IH0", "V", "L", "IY0"],
    "actives": ["AE1", "K", "T", "IH0", "V", "Z"],
    "activision": ["AE1", "K", "T", "IH0", "V", "IH2", "ZH", "AH0", "N"],
    "activism": ["AE1", "K", "T", "IH0", "V", "IH2", "Z", "AH0", "M"],
    "activist": ["AE1", "K", "T", "IH0", "V", "IH0", "S", "T"],
    "activists": ["AE1", "K", "T", "IH0", "V", "IH0", "S", "T", "S"],
    "activists'": ["AE1", "K", "T", "IH0", "V", "IH0", "S", "T", "S"],
    "activities": ["AE0", "K", "T", "IH1", "V", "IH0", "T", "IY0", "Z"],
    "activity": ["AE0", "K", "T", "IH1", "V", "IH0", "T", "IY0"],
    "actmedia": ["AE0", "K", "T", "M", "IY1", "D", "IY0", "AH0"],
    "actodine": ["AE1", "K", "T", "OW0", "D", "AY2", "N"],
    "acton": ["AE1", "K", "T", "AH0", "N"],
    "actor": ["AE1", "K", "T", "ER0"],
    "actor's": ["AE1", "K", "T", "ER0", "Z"],
    "actors": ["AE1", "K", "T", "ER0", "Z"],
    "actors'": ["AE1", "K", "T", "ER0", "Z"],
    "actress": ["AE1", "K", "T", "R", "AH0", "S"],
    "actress's": ["AE1", "K", "T", "R", "AH0", "S", "IH0", "Z"],
    "actresses": ["AE1", "K", "T", "R", "AH0", "S", "IH0", "Z"],
    "acts": ["AE1", "K", "S"],
    "actual": ["AE1", "K", "SH", "AH0", "L"],
    "actuality": ["AE2", "K", "CH", "UW0", "AE1", "L", "AH0", "T", "IY2"],
    "actualize": ["AE1", "K", "CH", "UW2", "AH0", "L", "AY2", "Z"],
    "actually": ["AE1", "K", "SH", "AH0", "L", "IY0"],
    "actuarial": ["AE2", "K", "CH", "UW2", "EH1", "R", "IY0", "AH0", "L"],
    "actuaries": ["AE1", "K", "CH", "UW2", "EH1", "R", "IY2", "Z"],
    "actuary": ["AE1", "K", "CH", "UW0", "EH1", "R", "IY2"],
    "actuate": ["AE1", "K", "CH", "UW2", "EY1", "T"],
    "actuator": ["AE1", "K", "CH", "UW0", "EY2", "T", "ER0"],
    "actuators": ["AE1", "K", "CH", "UW0", "EY2", "T", "ER0", "Z"],
    "actus": ["AE1", "K", "T", "AH0", "S"],
    "acuff": ["AH0", "K", "AH1", "F"],
    "acuity": ["AH0", "K", "Y", "UW1", "AH0", "T", "IY0"],
    "acumen": ["AH0", "K", "Y", "UW1", "M", "AH0", "N"],
    "acuna": ["AA0", "K", "UW1", "N", "AH0"],
    "acupuncture": ["AE1", "K", "Y", "UW0", "P", "AH2", "NG", "K", "CH", "ER0"],
    "acura": ["AE1", "K", "Y", "ER0", "AH0"],
    "acura's": ["AE1", "K", "Y", "ER0", "AH0", "Z"],
    "acuras": ["AE1", "K", "Y", "ER0", "AH0", "Z"],
    "acuson": ["AE2", "K", "Y", "UW1", "S", "AH0", "N"],
    "acustar": ["AE1", "K", "Y", "UW0", "S", "T", "AA2", "R"],
    "acusyst": ["AE1", "K", "Y", "UW0", "S", "IH0", "S", "T"],
    "acute": ["AH0", "K", "Y", "UW1", "T"],
    "acutely": ["AH0", "K", "Y", "UW1", "T", "L", "IY0"],
    "acuteness": ["AH0", "K", "Y", "UW1", "T", "N", "AH0", "S"],
    "acyclovir": ["AH0", "S", "IH1", "K", "L", "OW0", "V", "IH2", "R"],
    "ad": ["AE1", "D"],
    "ad's": ["AE1", "D", "Z"],
    "ad-hoc": ["AE1", "D", "HH", "AA1", "K"],
    "ad-lib": ["AE1", "D", "L", "IH1", "B"],
    "ad-nauseam": ["AE1", "D", "N", "AO1", "Z", "IY0", "AA0", "M"],
    "ad-nauseum": ["AE1", "D", "N", "AO1", "Z", "IY0", "AH0", "M"],
    "ada": ["EY1", "D", "AH0"],
    "ada's": ["EY1", "D", "AH0", "Z"],
    "adabel": ["AE1", "D", "AH0", "B", "EH0", "L"],
    "adabelle": ["AE1", "D", "AH0", "B", "AH0", "L"],
    "adachi": ["AA0", "D", "AA1", "K", "IY0"],
    "adage": ["AE1", "D", "IH0", "JH"],
    "adagio": ["AH0", "D", "AA1", "ZH", "IY0", "OW2"],
    "adah": ["AE1", "D", "AA0"],
    "adair": ["AH0", "D", "EH1", "R"],
    "adaire": ["AA0", "D", "EH1", "R"],
    "adak": ["AH0", "D", "AE1", "K"],
    "adalah": ["AA0", "D", "AA1", "L", "AH0"],
    "adalia": ["AA0", "D", "AA1", "L", "IY0", "AH0"],
    "adam": ["AE1", "D", "AH0", "M"],
    "adam's": ["AE1", "D", "AH0", "M", "Z"],
    "adamant": ["AE1", "D", "AH0", "M", "AH0", "N", "T"],
    "adamantly": ["AE1", "D", "AH0", "M", "AH0", "N", "T", "L", "IY0"],
    "adamcik": ["AA1", "D", "AH0", "M", "CH", "IH0", "K"],
    "adamczak": ["AA1", "D", "AH0", "M", "CH", "AE0", "K"],
    "adamczyk": ["AA1", "D", "AH0", "M", "CH", "IH0", "K"],
    "adame": ["AA0", "D", "AA1", "M", "IY0"],
    "adamec": ["AH0", "D", "AA1", "M", "IH0", "K"],
    "adamek": ["AH0", "D", "AA1", "M", "EH0", "K"],
    "adames": ["AH0", "D", "EY1", "M", "Z"],
    "adami": ["AA0", "D", "AA1", "M", "IY0"],
    "adamik": ["AH0", "D", "AA1", "M", "IH0", "K"],
    "adamina": ["AA0", "D", "AA0", "M", "IY1", "N", "AH0"],
    "adamkus": ["AE1", "D", "AH0", "M", "K", "AH0", "S"],
    "adamo": ["AA0", "D", "AA1", "M", "OW0"],
    "adamowicz": ["AH0", "D", "AA1", "M", "AH0", "V", "IH0", "CH"],
    "adams": ["AE1", "D", "AH0", "M", "Z"],
    "adams'": ["AE1", "D", "AH0", "M", "Z"],
    "adams's": ["AE1", "D", "AH0", "M", "Z", "IH0", "Z"],
    "adamski": ["AH0", "D", "AE1", "M", "S", "K", "IY2"],
    "adamson": ["AE1", "D", "AH0", "M", "S", "AH0", "N"],
    "adamstown": ["AE1", "D", "AH0", "M", "S", "T", "AW2", "N"],
    "adan": ["EY1", "D", "AH0", "N"],
    "adapso": ["AH0", "D", "AE1", "P", "S", "OW0"],
    "adapt": ["AH0", "D", "AE1", "P", "T"],
    "adaptability": ["AH0", "D", "AE2", "P", "T", "AH0", "B", "IH1", "L", "AH0", "T", "IY0"],
    "adaptable": ["AH0", "D", "AE1", "P", "T", "AH0", "B", "AH0", "L"],
    "adaptaplex": ["AH0", "D", "AE1", "P", "T", "AH0", "P", "L", "EH2", "K", "S"],
    "adaptation": ["AE2", "D", "AH0", "P", "T", "EY1", "SH", "AH0", "N"],
    "adaptations": ["AE2", "D", "AH0", "P", "T", "EY1", "SH", "AH0", "N", "Z"],
    "adaptec": ["AH0", "D", "AE1", "P", "T", "EH2", "K"],
    "adaptec's": ["AH0", "D", "AE1", "P", "T", "EH2", "K", "S"],
    "adapted": ["AH0", "D", "AE1", "P", "T", "IH0", "D"],
    "adapter": ["AH0", "D", "AE1", "P", "T", "ER0"],
    "adapters": ["AH0", "D", "AE1", "P", "T", "ER0", "Z"],
    "adapting": ["AH0", "D", "AE1", "P", "T", "IH0", "NG"],
    "adaptive": ["AH0", "D", "AE1", "P", "T", "IH0", "V"],
    "adaptor": ["AH0", "D", "AE1", "P", "T", "ER0"],
    "adaptors": ["AH0", "D", "AE1", "P", "T", "ER0", "Z"],
    "adapts": ["AH0", "D", "AE1", "P", "T", "S"],
    "adar": ["AH0", "D", "AA1", "R"],
    "adarand": ["AE1", "D", "AH0", "R", "AE2", "N", "D"],
    "adare": ["AH0", "D", "EH1", "R"],
    "adas": ["EY1", "D", "AH0", "Z"],
    "aday": ["AH0", "D", "EY1"],
    "adaza": ["AH0", "D", "AA1", "Z", "AH0"],
    "adblock": ["AE1", "D", "B", "L", "AA2", "K"],
    "adcock": ["AH0", "D", "K", "AA1", "K"],
    "adcox": ["AH0", "D", "K", "AA1", "K", "S"],
    "add": ["AE1", "D"],
    "addair": ["AH0", "D", "EH1", "R"],
    "addams": ["AE1", "D", "AH0", "M", "Z"],
    "added": ["AE1", "D", "IH0", "D"],
    "addendum": ["AH0", "D", "EH1", "N", "D", "AH0", "M"],
    "addendums": ["AH0", "D", "EH1", "N", "D", "AH0", "M", "Z"],
    "addeo": ["AA1", "D", "IY0", "OW0"],
    "adder": ["AE1", "D", "ER0"],
    "adderley": ["AH0", "D", "ER1", "L", "IY0"],
    "addicks": ["AE1", "D", "IH0", "K", "S"],
    "addict": ["AE1", "D", "IH2", "K", "T"],
    "addicted": ["AH0", "D", "IH1", "K", "T", "IH0", "D"],
    "addicting": ["AH0", "D", "IH1", "K", "T", "IH0", "NG"],
    "addiction": ["AH0", "D", "IH1", "K", "SH", "AH0", "N"],
    "addictions": ["AH0", "D", "IH1", "K", "SH", "AH0", "N", "Z"],
    "addictive": ["AH0", "D", "IH1", "K", "T", "IH0", "V"],
    "addicts": ["AE1", "D", "IH2", "K", "T", "S"],
    "addidas": ["AH0", "D", "IY1", "D", "AH0", "S"],
    "addidas'": ["AH0", "D", "IY1", "D", "AH0", "S"],
    "addidas's": ["AH0", "D", "IY1", "D", "AH0", "S", "IH0", "Z"],
    "addidases": ["AH0", "D", "IY1", "D", "AH0", "S", "IH0", "Z"],
    "addie": ["AE1", "D", "IY0"],
    "adding": ["AE1", "D", "IH0", "NG"],
    "addington": ["AE1", "D", "IH0", "NG", "T", "AH0", "N"],
    "addis": ["AA1", "D", "IH0", "S"],
    "addis-ababa": ["AA1", "D", "IY0", "S", "AH0", "B", "AA1", "B", "AA0"],
    "addison": ["AE1", "D", "IH0", "S", "AH0", "N"],
    "addison's": ["AE1", "D", "IH0", "S", "AH0", "N", "Z"],
    "addition": ["AH0", "D", "IH1", "SH", "AH0", "N"],
    "additional": ["AH0", "D", "IH1", "SH", "N", "AH0", "L"],
    "additionally": ["AH0", "D", "IH1", "SH", "N", "AH0", "L", "IY0"],
    "additions": ["AH0", "D", "IH1", "SH", "AH0", "N", "Z"],
    "additive": ["AE1", "D", "IH0", "T", "IH0", "V"],
    "additives": ["AE1", "D", "IH0", "T", "IH0", "V", "Z"],
    "addle": ["AE1", "D", "AH0", "L"],
    "addled": ["AE1", "D", "AH0", "L", "D"],
    "addleman": ["AE1", "D", "AH0", "L", "M", "AH0", "N"],
    "address": ["AH0", "D", "R", "EH1", "S"],
    "addressable": ["AH0", "D", "R", "EH1", "S", "AH0", "B", "AH0", "L"],
    "addressed": ["AH0", "D", "R", "EH1", "S", "T"],
    "addressee": ["AE2", "D", "R", "EH0", "S", "IY1"],
    "addresses": ["AH0", "D", "R", "EH1", "S", "IH0", "Z"],
    "addressing": ["AH0", "D", "R", "EH1", "S", "IH0", "NG"],
    "adds": ["AE1", "D", "Z"],
    "adduci": ["AA0", "D", "UW1", "CH", "IY0"],
    "adduct": ["AE1", "D", "AH0", "K", "T"],
    "addwest": ["AE2", "D", "W", "EH1", "S", "T"],
    "addy": ["AE1", "D", "IY0"],
    "addyston": ["AE1", "D", "IY0", "S", "T", "AH0", "N"],
    "ade": ["EY1", "D"],
    "adee": ["AH0", "D", "IY1"],
    "adel": ["AH0", "D", "EH1", "L"],
    "adela": ["AH0", "D", "EH1", "L", "AH0"],
    "adelaar": ["AE1", "D", "AH0", "L", "AA2", "R"],
    "adelaide": ["AE1", "D", "AH0", "L", "EY2", "D"],
    "adelanto": ["AE0", "D", "AH0", "L", "AA1", "N", "T", "OW0"],
    "adelbert": ["AH0", "D", "EH1", "L", "B", "ER0", "T"],
    "adele": ["AH0", "D", "EH1", "L"],
    "adele's": ["AH0", "D", "EH1", "L", "Z"],
    "adeline": ["AE1", "D", "AH0", "L", "AY2", "N"],
    "adelizzi": ["AE2", "D", "AH0", "L", "IY1", "Z", "IY0"],
    "adell": ["AH0", "D", "EH1", "L"],
    "adell's": ["AH0", "D", "EH1", "L", "Z"],
    "adelle": ["AH0", "D", "EH1", "L"],
    "adelman": ["EH1", "D", "AH0", "L", "M", "AH0", "N"],
    "adelmann": ["AE1", "D", "AH0", "L", "M", "AH0", "N"],
    "adelpha": ["AH0", "D", "EH1", "L", "F", "AH0"],
    "adelphi": ["AH0", "D", "EH1", "L", "F", "IY0"],
    "adelphia": ["AH0", "D", "EH1", "L", "F", "IY0", "AH0"],
    "adelphia's": ["AH0", "D", "EH1", "L", "F", "IY0", "AH0", "Z"],
    "adelsberger": ["AE1", "D", "IH0", "L", "Z", "B", "ER0", "G", "ER0"],
    "adelson": ["AE1", "D", "AH0", "L", "S", "AH0", "N"],
    "adelstein": ["AE1", "D", "AH0", "L", "S", "T", "IY0", "N"],
    "aden": ["EY1", "D", "AH0", "N"],
    "adena": ["AE1", "D", "IH0", "N", "AH0"],
    "adenauer": ["AE1", "D", "AH0", "N", "AW2", "R"],
    "adenine": ["AE1", "D", "AH0", "N", "IY2", "N"],
    "adenoid": ["AE1", "D", "AH0", "N", "OY2", "D"],
    "adenoids": ["AE1", "D", "AH0", "N", "OY2", "D", "Z"],
    "adenoscan": ["AH0", "D", "EH1", "N", "AH0", "S", "K", "AE2", "N"],
    "adenosine": ["AH0", "D", "EH1", "N", "AH0", "S", "IY2", "N"],
    "adenovirus": ["AH0", "D", "EH1", "N", "AH0", "V", "AY2", "R", "AH0", "S"],
    "adept": ["AH0", "D", "EH1", "P", "T"],
    "adequacy": ["AE1", "D", "AH0", "K", "W", "AH0", "S", "IY0"],
    "adequate": ["AE1", "D", "AH0", "K", "W", "EY2", "T"],
    "adequately": ["AE1", "D", "AH0", "K", "W", "IH0", "T", "L", "IY0"],
    "ader": ["EY1", "D", "ER0"],
    "aderhold": ["AE1", "D", "ER0", "HH", "OW0", "L", "D"],
    "aderholt": ["AE1", "D", "ER0", "HH", "OW0", "L", "T"],
    "aderman": ["AE1", "D", "ER0", "M", "AH0", "N"],
    "ades": ["EY1", "D", "Z"],
    "adey": ["EY1", "D", "IY0"],
    "adger": ["AE1", "JH", "ER0"],
    "adham": ["AE1", "D", "HH", "AE0", "M"],
    "adhd": ["EY2", "D", "IY2", "EY2", "CH", "D", "IY1"],
    "adhere": ["AH0", "D", "HH", "IH1", "R"],
    "adhered": ["AE0", "D", "HH", "IH1", "R", "D"],
    "adherence": ["AH0", "D", "HH", "IH1", "R", "AH0", "N", "S"],
    "adherent": ["AH0", "D", "HH", "IH1", "R", "AH0", "N", "T"],
    "adherents": ["AE0", "D", "HH", "IH1", "R", "AH0", "N", "T", "S"],
    "adheres": ["AH0", "D", "HH", "IH1", "R", "Z"],
    "adhering": ["AH0", "D", "HH", "IH1", "R", "IH0", "NG"],
    "adhesion": ["AE0", "D", "HH", "IY1", "ZH", "AH0", "N"],
    "adhesive": ["AH0", "D", "HH", "IY1", "S", "IH0", "V"],
    "adhesives": ["AH0", "D", "HH", "IY1", "S", "IH0", "V", "Z"],
    "adia": ["AA1", "D", "IY0", "AH0"],
    "adid": ["AH0", "D", "IH1", "D"],
    "adidas": ["AH0", "D", "IY1", "D", "AH0", "S"],
    "adidas's": ["AH0", "D", "IY1", "D", "AH0", "S", "IH0", "Z"],
    "adieu": ["AH0", "D", "UW1"],
    "adin": ["AH0", "D", "IH1", "N"],
    "adina": ["AA0", "D", "IY1", "N", "AH0"],
    "adine": ["AA0", "D", "IY1", "N", "IY0"],
    "adinolfi": ["AA0", "D", "IY0", "N", "OW1", "L", "F", "IY0"],
    "adios": ["AA2", "D", "IY0", "OW1", "S"],
    "adipose": ["AE1", "D", "AH0", "P", "OW2", "S"],
    "adirondack": ["AE2", "D", "ER0", "AA1", "N", "D", "AE0", "K"],
    "adisq": ["EY1", "D", "IH0", "S", "K"],
    "adjacent": ["AH0", "JH", "EY1", "S", "AH0", "N", "T"],
    "adjani": ["AE0", "D", "JH", "AA1", "N", "IY0"],
    "adjective": ["AE1", "JH", "IH0", "K", "T", "IH0", "V"],
    "adjectives": ["AE1", "JH", "IH0", "K", "T", "IH0", "V", "Z"],
    "adjoin": ["AH0", "JH", "OY1", "N"],
    "adjoining": ["AH0", "JH", "OY1", "N", "IH0", "NG"],
    "adjoins": ["AH0", "JH", "OY1", "N", "Z"],
    "adjourn": ["AH0", "JH", "ER1", "N"],
    "adjourned": ["AH0", "JH", "ER1", "N", "D"],
    "adjourning": ["AH0", "JH", "ER1", "N", "IH0", "NG"],
    "adjournment": ["AH0", "JH", "ER1", "N", "M", "AH0", "N", "T"],
    "adjourns": ["AH0", "JH", "ER1", "N", "Z"],
    "adjudge": ["AH0", "JH", "AH1", "JH"],
    "adjudged": ["AH0", "JH", "AH1", "JH", "D"],
    "adjudicate": ["AH0", "JH", "UW1", "D", "IH0", "K", "EY2", "T"],
    "adjudicated": ["AH0", "JH", "UW1", "D", "AH0", "K", "EY2", "T", "IH0", "D"],
    "adjudicating": ["AH0", "JH", "UW1", "D", "IH0", "K", "EY2", "T", "IH0", "NG"],
    "adjudication": ["AH0", "JH", "UW2", "D", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "adjunct": ["AE1", "JH", "AH2", "NG", "K", "T"],
    "adjuncts": ["AE1", "JH", "AH2", "NG", "K", "T", "S"],
    "adjust": ["AH0", "JH", "AH1", "S", "T"],
    "adjustable": ["AH0", "JH", "AH1", "S", "T", "AH0", "B", "AH0", "L"],
    "adjustables": ["AH0", "JH", "AH1", "S", "T", "AH0", "B", "AH0", "L", "Z"],
    "adjusted": ["AH0", "JH", "AH1", "S", "T", "IH0", "D"],
    "adjuster": ["AH0", "JH", "AH1", "S", "T", "ER0"],
    "adjusters": ["AH0", "JH", "AH1", "S", "T", "ER0", "Z"],
    "adjusting": ["AH0", "JH", "AH1", "S", "T", "IH0", "NG"],
    "adjustment": ["AH0", "JH", "AH1", "S", "T", "M", "AH0", "N", "T"],
    "adjustments": ["AH0", "JH", "AH1", "S", "T", "M", "AH0", "N", "T", "S"],
    "adjusts": ["AH0", "JH", "AH1", "S", "T", "S"],
    "adjutant": ["AE1", "JH", "AH0", "T", "AH0", "N", "T"],
    "adkins": ["AE1", "D", "K", "IH0", "N", "Z"],
    "adkinson": ["AE1", "D", "K", "IH0", "N", "S", "AH0", "N"],
    "adkison": ["AE1", "D", "K", "IH0", "S", "AH0", "N"],
    "adkisson": ["AE1", "D", "K", "IH0", "S", "AH0", "N"],
    "adl-tabataba": ["AA2", "D", "AH0", "L", "T", "AA2", "B", "AH0", "T", "AA1", "B", "AH0"],
    "adl-tabatabai": ["AA2", "D", "AH0", "L", "T", "AA2", "B", "AH0", "T", "AH2", "B", "AY1"],
    "adlai": ["AA0", "D", "L", "AA1", "IY0"],
    "adler": ["AE1", "D", "L", "ER0"],
    "adler's": ["AE1", "D", "L", "ER0", "Z"],
    "adlers": ["AE1", "D", "L", "ER0", "Z"],
    "adley": ["AE1", "D", "L", "IY0"],
    "adlon": ["AE1", "D", "L", "AA0", "N"],
    "adlong": ["AE1", "D", "L", "AO0", "NG"],
    "adman": ["AE1", "D", "M", "AH0", "N"],
    "admen": ["AE1", "D", "M", "AH0", "N"],
    "admin": ["AE1", "D", "M", "IH0", "N"],
    "administer": ["AH0", "D", "M", "IH1", "N", "AH0", "S", "T", "ER0"],
    "administered": ["AH0", "D", "M", "IH1", "N", "AH0", "S", "T", "ER0", "D"],
    "administering": ["AE0", "D", "M", "IH1", "N", "IH0", "S", "T", "ER2", "IH0", "NG"],
    "administers": ["AE0", "D", "M", "IH1", "N", "IH0", "S", "T", "ER0", "Z"],
    "administrate": ["AE0", "D", "M", "IH1", "N", "IH0", "S", "T", "R", "EY2", "T"],
    "administrating": ["AH0", "D", "M", "IH1", "N", "AH0", "S", "T", "R", "EY2", "T", "IH0", "NG"],
    "administration": ["AE0", "D", "M", "IH2", "N", "IH0", "S", "T", "R", "EY1", "SH", "AH0", "N"],
    "administration's": ["AE0", "D", "M", "IH2", "N", "IH0", "S", "T", "R", "EY1", "SH", "AH0", "N", "Z"],
    "administrations": ["AE0", "D", "M", "IH2", "N", "IH0", "S", "T", "R", "EY1", "SH", "AH0", "N", "Z"],
    "administrations'": ["AE0", "D", "M", "IH2", "N", "IH0", "S", "T", "R", "EY1", "SH", "AH0", "N", "Z"],
    "administrative": ["AH0", "D", "M", "IH1", "N", "AH0", "S", "T", "R", "EY2", "T", "IH0", "V"],
    "administratively": ["AE0", "D", "M", "IH2", "N", "AH0", "S", "T", "R", "EY1", "T", "IH0", "V", "L", "IY0"],
    "administrator": ["AH0", "D", "M", "IH1", "N", "AH0", "S", "T", "R", "EY2", "T", "ER0"],
    "administrator's": ["AE0", "D", "M", "IH1", "N", "IH0", "S", "T", "R", "EY2", "T", "ER0", "Z"],
    "administrators": ["AE0", "D", "M", "IH1", "N", "IH0", "S", "T", "R", "EY2", "T", "ER0", "Z"],
    "administrators'": ["AE0", "D", "M", "IH1", "N", "AH0", "S", "T", "R", "EY2", "T", "ER0", "Z"],
    "admins": ["AE1", "D", "M", "IH0", "N", "Z"],
    "admira": ["AE0", "D", "M", "AY1", "R", "AH0"],
    "admira's": ["AE0", "D", "M", "AY1", "R", "AH0", "Z"],
    "admirable": ["AE1", "D", "M", "R", "AH0", "B", "AH0", "L"],
    "admirably": ["AE1", "D", "M", "ER0", "AH0", "B", "L", "IY0"],
    "admiral": ["AE1", "D", "M", "ER0", "AH0", "L"],
    "admiral's": ["AE1", "D", "M", "ER0", "AH0", "L", "Z"],
    "admirals": ["AE1", "D", "M", "ER0", "AH0", "L", "Z"],
    "admiralty": ["AE1", "D", "M", "ER0", "AH0", "L", "T", "IY0"],
    "admiration": ["AE2", "D", "M", "ER0", "EY1", "SH", "AH0", "N"],
    "admirations": ["AE2", "D", "M", "ER0", "EY1", "SH", "AH0", "N", "Z"],
    "admire": ["AE0", "D", "M", "AY1", "R"],
    "admired": ["AH0", "D", "M", "AY1", "ER0", "D"],
    "admirer": ["AE0", "D", "M", "AY1", "R", "ER0"],
    "admirers": ["AH0", "D", "M", "AY1", "R", "ER0", "Z"],
    "admires": ["AE0", "D", "M", "AY1", "R", "Z"],
    "admiring": ["AE0", "D", "M", "AY1", "R", "IH0", "NG"],
    "admiringly": ["AE0", "D", "M", "AY1", "R", "IH0", "NG", "L", "IY0"],
    "admissibility": ["AH0", "D", "M", "IH2", "S", "AH0", "B", "IH1", "L", "AH0", "T", "IY0"],
    "admissible": ["AH0", "D", "M", "IH1", "S", "AH0", "B", "AH0", "L"],
    "admission": ["AH0", "D", "M", "IH1", "SH", "AH0", "N"],
    "admissions": ["AH0", "D", "M", "IH1", "SH", "AH0", "N", "Z"],
    "admit": ["AH0", "D", "M", "IH1", "T"],
    "admits": ["AH0", "D", "M", "IH1", "T", "S"],
    "admittance": ["AH0", "D", "M", "IH1", "T", "AH0", "N", "S"],
    "admitted": ["AH0", "D", "M", "IH1", "T", "IH0", "D"],
    "admittedly": ["AE0", "D", "M", "IH1", "T", "IH0", "D", "L", "IY0"],
    "admitting": ["AH0", "D", "M", "IH1", "T", "IH0", "NG"],
    "admonish": ["AE0", "D", "M", "AA1", "N", "IH0", "SH"],
    "admonished": ["AH0", "D", "M", "AA1", "N", "IH0", "SH", "T"],
    "admonishes": ["AE0", "D", "M", "AA1", "N", "IH0", "SH", "IH0", "Z"],
    "admonishing": ["AE0", "D", "M", "AA1", "N", "IH0", "SH", "IH0", "NG"],
    "admonishment": ["AE0", "D", "M", "AA1", "N", "IH0", "SH", "M", "EH0", "N", "T"],
    "admonition": ["AE2", "D", "M", "AH0", "N", "IH1", "SH", "AH0", "N"],
    "admonitions": ["AE2", "D", "M", "AH0", "N", "IH1", "SH", "AH0", "N", "Z"],
    "admonitory": ["AE2", "D", "M", "AO1", "N", "IH0", "T", "AO2", "R", "IY0"],
    "adnan": ["AE1", "D", "N", "AH0", "N"],
    "adney": ["AE1", "D", "N", "IY0"],
    "ado": ["AH0", "D", "UW1"],
    "adobe": ["AH0", "D", "OW1", "B", "IY0"],
    "adobe's": ["AH0", "D", "OW1", "B", "IY0", "Z"],
    "adolescence": ["AE2", "D", "OW0", "L", "EH1", "S", "AH0", "N", "S"],
    "adolescent": ["AE2", "D", "OW0", "L", "EH1", "S", "AH0", "N", "T"],
    "adolescents": ["AE2", "D", "OW0", "L", "EH1", "S", "AH0", "N", "T", "S"],
    "adolf": ["EY1", "D", "AA0", "L", "F"],
    "adolf's": ["EY1", "D", "AA0", "L", "F", "S"],
    "adolfo": ["AH0", "D", "AA1", "L", "F", "OW2"],
    "adolph": ["EY1", "D", "AO0", "L", "F"],
    "adolpha": ["AA0", "D", "OW1", "L", "F", "AH0"],
    "adolphson": ["AE1", "D", "OW0", "L", "F", "S", "AH0", "N"],
    "adolphus": ["AH0", "D", "AO1", "L", "F", "AH0", "S"],
    "adon": ["AA0", "D", "AO1", "N"],
    "adonia": ["AA0", "D", "OW1", "N", "IY0", "AH0"],
    "adonis": ["AH0", "D", "AA1", "N", "AH0", "S"],
    "adopt": ["AH0", "D", "AA1", "P", "T"],
    "adoptable": ["AH0", "D", "AA1", "P", "T", "AH0", "B", "AH0", "L"],
    "adopted": ["AH0", "D", "AA1", "P", "T", "IH0", "D"],
    "adoptee": ["AH0", "D", "AA1", "P", "T", "IY1"],
    "adoptees": ["AH0", "D", "AA1", "P", "T", "IY1", "Z"],
    "adopter": ["AH0", "D", "AA1", "P", "T", "ER0"],
    "adopters": ["AH0", "D", "AA1", "P", "T", "ER0", "Z"],
    "adopting": ["AH0", "D", "AA1", "P", "T", "IH0", "NG"],
    "adoption": ["AH0", "D", "AA1", "P", "SH", "AH0", "N"],
    "adoptions": ["AH0", "D", "AA1", "P", "SH", "AH0", "N", "Z"],
    "adoptive": ["AH0", "D", "AA1", "P", "T", "IH0", "V"],
    "adopts": ["AH0", "D", "AA1", "P", "T", "S"],
    "ador": ["AA0", "D", "AO1", "R"],
    "adora": ["AA0", "D", "AO1", "R", "AH0"],
    "adorabelle": ["AE1", "D", "ER0", "AH0", "B", "AH0", "L"],
    "adorable": ["AH0", "D", "AO1", "R", "AH0", "B", "AH0", "L"],
    "adoration": ["AE2", "D", "ER0", "EY1", "SH", "AH0", "N"],
    "adore": ["AH0", "D", "AO1", "R"],
    "adored": ["AH0", "D", "AO1", "R", "D"],
    "adoree": ["AE0", "D", "ER0", "IY1"],
    "adorees": ["AE0", "D", "ER0", "IY1", "Z"],
    "adores": ["AH0", "D", "AO1", "R", "Z"],
    "adoring": ["AH0", "D", "AO1", "R", "IH0", "NG"],
    "adorn": ["AH0", "D", "AO1", "R", "N"],
    "adorna": ["AA0", "D", "AO1", "R", "N", "AH0"],
    "adorned": ["AH0", "D", "AO1", "R", "N", "D"],
    "adorning": ["AH0", "D", "AO1", "R", "N", "IH0", "NG"],
    "adornment": ["AH0", "D", "AO1", "R", "N", "M", "AH0", "N", "T"],
    "adorno": ["AA0", "D", "AO1", "R", "N", "OW0"],
    "adorns": ["AH0", "D", "AO1", "R", "N", "Z"],
    "adra": ["EY1", "D", "R", "AH0"],
    "adragna": ["AA0", "D", "R", "AA1", "G", "N", "AH0"],
    "adrda": ["EY1", "D", "ER0", "D", "AH0"],
    "adrea": ["AA1", "D", "R", "IY0", "AH0"],
    "adrenal": ["AH0", "D", "R", "IY1", "N", "AH0", "L"],
    "adrenalin": ["AH0", "D", "R", "EH1", "N", "AH0", "L", "IH0", "N"],
    "adrenaline": ["AH0", "D", "R", "EH1", "N", "AH0", "L", "AH0", "N"],
    "adrenergic": ["AH0", "D", "R", "EH0", "N", "EH1", "R", "JH", "IH0", "K"],
    "adria": ["AA1", "D", "R", "IY0", "AH0"],
    "adrian": ["EY1", "D", "R", "IY0", "AH0", "N"],
    "adriana": ["EY2", "D", "R", "IY0", "AE1", "N", "AH0"],
    "adriance": ["AA0", "D", "R", "IY1", "AH0", "N", "S"],
    "adriano": ["AA0", "D", "R", "IY0", "AA1", "N", "OW0"],
    "adriatic": ["EY2", "D", "R", "IY0", "AE1", "T", "IH0", "K"],
    "adriel": ["AH0", "D", "R", "IY1", "L"],
    "adrienne": ["AA0", "D", "R", "IY0", "EH1", "N"],
    "adrift": ["AH0", "D", "R", "IH1", "F", "T"],
    "adroit": ["AH0", "D", "R", "OY1", "T"],
    "adroitly": ["AH0", "D", "R", "OY1", "T", "L", "IY0"],
    "ads": ["AE1", "D", "Z"],
    "ads'": ["AE1", "D", "Z"],
    "adsit": ["AE1", "D", "S", "IH0", "T"],
    "adsl": ["EY2", "D", "IY2", "EH2", "S", "EH1", "L"],
    "adsorption": ["AH0", "D", "S", "AO1", "R", "P", "SH", "AH0", "N"],
    "adss": ["EY1", "D", "IY1", "EH1", "S", "EH1", "S"],
    "adstar": ["AE1", "D", "S", "T", "AA0", "R"],
    "adsteam": ["AE1", "D", "S", "T", "IY0", "M"],
    "adtec": ["AE1", "D", "T", "EH2", "K"],
    "adulate": ["AE1", "JH", "AH0", "L", "EY2", "T"],
    "adulation": ["AE2", "JH", "AH0", "L", "EY1", "SH", "AH0", "N"],
    "aduliadae": ["AH0", "D", "UW2", "L", "IY0", "AA1", "D", "EY0"],
    "adult": ["AE1", "D", "AH0", "L", "T"],
    "adulterate": ["AH0", "D", "AH1", "L", "T", "ER0", "EY2", "T"],
    "adulterated": ["AH0", "D", "AH1", "L", "T", "ER0", "EY2", "T", "IH0", "D"],
    "adulterates": ["AH0", "D", "AH1", "L", "T", "ER0", "EY2", "T", "S"],
    "adulteration": ["AH0", "D", "AH2", "L", "T", "ER0", "EY1", "SH", "AH0", "N"],
    "adulterer": ["AH0", "D", "AH1", "L", "T", "ER0", "ER0"],
    "adulterers": ["AH0", "D", "AH1", "L", "T", "ER0", "ER0", "Z"],
    "adulterous": ["AH0", "D", "AH1", "L", "T", "ER0", "AH0", "S"],
    "adultery": ["AH0", "D", "AH1", "L", "T", "ER0", "IY0"],
    "adulthood": ["AH0", "D", "AH1", "L", "T", "HH", "UH2", "D"],
    "adults": ["AE1", "D", "AH0", "L", "T", "S"],
    "adults'": ["AE1", "D", "AH0", "L", "T", "S"],
    "adusdur": ["AE1", "D", "AH0", "S", "D", "ER0"],
    "advacare": ["AE1", "D", "V", "AH0", "K", "EH2", "R"],
    "advalue": ["AE1", "D", "V", "AH0", "L", "UW2"],
    "advance": ["AH0", "D", "V", "AE1", "N", "S"],
    "advance's": ["AH0", "D", "V", "AE1", "N", "S", "IH0", "Z"],
    "advanced": ["AH0", "D", "V", "AE1", "N", "S", "T"],
    "advancement": ["AH0", "D", "V", "AE1", "N", "S", "M", "AH0", "N", "T"],
    "advancements": ["AH0", "D", "V", "AE1", "N", "S", "M", "AH0", "N", "T", "S"],
    "advancer": ["AH0", "D", "V", "AE1", "N", "S", "ER0"],
    "advancers": ["AH0", "D", "V", "AE1", "N", "S", "ER0", "Z"],
    "advances": ["AH0", "D", "V", "AE1", "N", "S", "IH0", "Z"],
    "advancing": ["AH0", "D", "V", "AE1", "N", "S", "IH0", "NG"],
    "advani": ["AE0", "D", "V", "AA1", "N", "IY0"],
    "advanta": ["AH0", "D", "V", "AE1", "N", "T", "AH0"],
    "advanta's": ["AH0", "D", "V", "AE1", "N", "T", "AH0", "Z"],
    "advantage": ["AE0", "D", "V", "AE1", "N", "T", "IH0", "JH"],
    "advantaged": ["AE0", "D", "V", "AE1", "N", "T", "IH0", "JH", "D"],
    "advantageous": ["AE2", "D", "V", "AH0", "N", "T", "EY1", "JH", "AH0", "S"],
    "advantages": ["AE0", "D", "V", "AE1", "N", "T", "IH0", "JH", "IH0", "Z"],
    "advantest": ["AE0", "D", "V", "AE1", "N", "T", "AH0", "S", "T"],
    "advection": ["AE0", "D", "V", "EH1", "K", "SH", "AH0", "N"],
    "advent": ["AE1", "D", "V", "EH2", "N", "T"],
    "adventist": ["AE1", "D", "V", "EH2", "N", "T", "IH0", "S", "T"],
    "adventists": ["AE1", "D", "V", "EH2", "N", "T", "IH0", "S", "T", "S"],
    "adventure": ["AH0", "D", "V", "EH1", "N", "CH", "ER0"],
    "adventurer": ["AH0", "D", "V", "EH1", "N", "CH", "ER0", "ER0"],
    "adventurers": ["AH0", "D", "V", "EH1", "N", "CH", "ER0", "ER0", "Z"],
    "adventures": ["AE0", "D", "V", "EH1", "N", "CH", "ER0", "Z"],
    "adventuresome": ["AE0", "D", "V", "EH1", "N", "CH", "ER0", "S", "AH0", "M"],
    "adventurism": ["AE0", "D", "V", "EH1", "N", "CH", "ER0", "IH2", "Z", "AH0", "M"],
    "adventurous": ["AH0", "D", "V", "EH1", "N", "CH", "ER0", "AH0", "S"],
    "adverb": ["AE1", "D", "V", "ER0", "B"],
    "adverbial": ["AE0", "D", "V", "ER1", "B", "IY0", "AH0", "L"],
    "adverbs": ["AE1", "D", "V", "ER0", "B", "Z"],
    "adversarial": ["AE2", "D", "V", "ER0", "S", "EH1", "R", "IY0", "AH0", "L"],
    "adversaries": ["AE1", "D", "V", "ER0", "S", "EH2", "R", "IY0", "Z"],
    "adversary": ["AE1", "D", "V", "ER0", "S", "EH2", "R", "IY0"],
    "adverse": ["AH0", "D", "V", "ER1", "S"],
    "adversely": ["AE0", "D", "V", "ER1", "S", "L", "IY0"],
    "adversity": ["AH0", "D", "V", "ER1", "S", "IH0", "T", "IY0"],
    "advert": ["AE1", "D", "V", "ER0", "T"],
    "advertise": ["AE1", "D", "V", "ER0", "T", "AY2", "Z"],
    "advertised": ["AE2", "D", "V", "ER0", "T", "AY1", "Z", "D"],
    "advertisement": ["AE2", "D", "V", "ER0", "T", "AY1", "Z", "M", "AH0", "N", "T"],
    "advertisements": ["AE1", "D", "V", "ER0", "T", "AY2", "Z", "M", "AH0", "N", "T", "S"],
    "advertiser": ["AE1", "D", "V", "ER0", "T", "AY2", "Z", "ER0"],
    "advertiser's": ["AE1", "D", "V", "ER0", "T", "AY2", "Z", "ER0", "Z"],
    "advertisers": ["AE1", "D", "V", "ER0", "T", "AY2", "Z", "ER0", "Z"],
    "advertisers'": ["AE1", "D", "V", "ER2", "T", "AY2", "Z", "ER0", "Z"],
    "advertises": ["AE1", "D", "V", "ER0", "T", "AY2", "Z", "IH0", "Z"],
    "advertising": ["AE1", "D", "V", "ER0", "T", "AY2", "Z", "IH0", "NG"],
    "advertising's": ["AE1", "D", "V", "ER0", "T", "AY2", "Z", "IH0", "NG", "Z"],
    "advertorial": ["AE2", "D", "V", "ER0", "T", "AO1", "R", "IY0", "AH0", "L"],
    "advertorials": ["AE2", "D", "V", "ER0", "T", "AO1", "R", "IY0", "AH0", "L", "Z"],
    "advest": ["AE1", "D", "V", "EH0", "S", "T"],
    "advice": ["AH0", "D", "V", "AY1", "S"],
    "advil": ["AE1", "D", "V", "IH2", "L"],
    "advil's": ["AE1", "D", "V", "IH2", "L", "Z"],
    "advisability": ["AE2", "D", "V", "AY2", "Z", "AH0", "B", "IH1", "L", "IH0", "T", "IY0"],
    "advisable": ["AH0", "D", "V", "AY1", "Z", "AH0", "B", "AH0", "L"],
    "advise": ["AH0", "D", "V", "AY1", "Z"],
    "advised": ["AH0", "D", "V", "AY1", "Z", "D"],
    "advisedly": ["AH0", "D", "V", "AY1", "Z", "AH0", "D", "L", "IY0"],
    "advisement": ["AH0", "D", "V", "AY1", "Z", "M", "AH0", "N", "T"],
    "adviser": ["AE0", "D", "V", "AY1", "Z", "ER0"],
    "adviser's": ["AH0", "D", "V", "AY1", "Z", "ER0", "Z"],
    "advisers": ["AE0", "D", "V", "AY1", "Z", "ER0", "Z"],
    "advisers'": ["AE2", "D", "V", "AY1", "Z", "ER0", "Z"],
    "advises": ["AE0", "D", "V", "AY1", "Z", "IH0", "Z"],
    "advising": ["AE0", "D", "V", "AY1", "Z", "IH0", "NG"],
    "advisor": ["AE0", "D", "V", "AY1", "Z", "ER0"],
    "advisories": ["AH0", "D", "V", "AY1", "Z", "ER0", "IY0", "Z"],
    "advisors": ["AE0", "D", "V", "AY1", "Z", "ER0", "Z"],
    "advisory": ["AE0", "D", "V", "AY1", "Z", "ER0", "IY0"],
    "advo": ["AE1", "D", "V", "OW0"],
    "advocacy": ["AE1", "D", "V", "AH0", "K", "AH0", "S", "IY0"],
    "advocate": ["AE1", "D", "V", "AH0", "K", "EY2", "T"],
    "advocate's": ["AE1", "D", "V", "AH0", "K", "AH0", "T", "S"],
    "advocated": ["AE1", "D", "V", "AH0", "K", "EY2", "T", "IH0", "D"],
    "advocates": ["AE1", "D", "V", "AH0", "K", "EY2", "T", "S"],
    "advocating": ["AE1", "D", "V", "AH0", "K", "EY2", "T", "IH0", "NG"],
    "advocation": ["AE2", "D", "V", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "adweek": ["AE1", "D", "W", "IY0", "K"],
    "adwell": ["AH0", "D", "W", "EH1", "L"],
    "adwords": ["AE1", "D", "W", "ER2", "D", "Z"],
    "ady": ["EY1", "D", "IY0"],
    "adz": ["AE1", "D", "Z"],
    "ae": ["EY1"],
    "aegean": ["IH0", "JH", "IY1", "AH0", "N"],
    "aegerter": ["EH1", "G", "ER0", "T", "ER0"],
    "aegis": ["IY1", "JH", "AH0", "S"],
    "aegon": ["EY1", "G", "AA0", "N"],
    "aeltus": ["AE1", "L", "T", "AH0", "S"],
    "aeneas": ["AE1", "N", "IY0", "AH0", "S"],
    "aeneid": ["AH0", "N", "IY1", "IH0", "D"],
    "aeolus": ["EH1", "OW0", "L", "UH0", "S"],
    "aequitron": ["EY1", "K", "W", "IH0", "T", "R", "AA0", "N"],
    "aer": ["EY1", "IY1", "AA1", "R"],
    "aerial": ["EH1", "R", "IY0", "AH0", "L"],
    "aerials": ["EH1", "R", "IY0", "AH0", "L", "Z"],
    "aerie": ["EH1", "R", "IY0"],
    "aerien": ["EH1", "R", "IY0", "AH0", "N"],
    "aeriens": ["EH1", "R", "IY0", "AH0", "N", "Z"],
    "aeritalia": ["EH2", "R", "IH0", "T", "AE1", "L", "Y", "AH0"],
    "aero": ["EH1", "R", "OW0"],
    "aerobatic": ["EH2", "R", "AH0", "B", "AE1", "T", "IH0", "K"],
    "aerobatics": ["EH2", "R", "AH0", "B", "AE1", "T", "IH0", "K", "S"],
    "aerobic": ["EH0", "R", "OW1", "B", "IH0", "K"],
    "aerobically": ["EH0", "R", "OW1", "B", "IH0", "K", "L", "IY0"],
    "aerobics": ["ER0", "OW1", "B", "IH0", "K", "S"],
    "aerodrome": ["EH1", "R", "AH0", "D", "R", "OW2", "M"],
    "aerodromes": ["EH1", "R", "AH0", "D", "R", "OW2", "M", "Z"],
    "aerodynamic": ["EH2", "R", "OW0", "D", "AY0", "N", "AE1", "M", "IH0", "K"],
    "aerodynamically": ["EH2", "R", "OW0", "D", "AY0", "N", "AE1", "M", "IH0", "K", "L", "IY0"],
    "aerodynamicist": ["EH2", "R", "OW0", "D", "AY0", "N", "AE1", "M", "IH0", "S", "IH0", "S", "T"],
    "aerodynamicists": ["EH2", "R", "OW0", "D", "AY0", "N", "AE1", "M", "IH0", "S", "IH0", "S", "T", "S"],
    "aerodynamics": ["EH2", "R", "OW0", "D", "AY0", "N", "AE1", "M", "IH0", "K", "S"],
    "aerodyne": ["EH1", "R", "AH0", "D", "AY2", "N"],
    "aerodyne's": ["EH1", "R", "AH0", "D", "AY2", "N", "Z"],
    "aeroflot": ["EH1", "R", "OW0", "F", "L", "AA2", "T"],
    "aeroflot's": ["EH1", "R", "OW0", "F", "L", "AA2", "T", "S"],
    "aerogenosa": ["EH1", "R", "AH0", "JH", "AH0", "N", "OW2", "S", "AH0"],
    "aerojet": ["EH1", "R", "OW0", "JH", "EH2", "T"],
    "aerojets": ["EH1", "R", "OW0", "JH", "EH2", "T", "S"],
    "aerolift": ["EH1", "R", "OW0", "L", "IH2", "F", "T"],
    "aerolifts": ["EH1", "R", "OW0", "L", "IH2", "F", "T", "S"],
    "aerolineas": ["EH2", "R", "OW0", "L", "IH1", "N", "IY0", "AH0", "S"],
    "aeromar": ["EH1", "R", "OW0", "M", "AA0", "R"],
    "aeromexico": ["EH2", "R", "OW0", "M", "EH1", "K", "S", "IH0", "K", "OW2"],
    "aeromexico's": ["EH2", "R", "OW0", "M", "EH1", "K", "S", "IH0", "K", "OW2", "Z"],
    "aeronautic": ["EH2", "R", "OW0", "N", "AA1", "T", "AH0", "K"],
    "aeronautical": ["EH2", "R", "AH0", "N", "AA1", "T", "AH0", "K", "AH0", "L"],
    "aeronauticas": ["EH2", "R", "OW0", "N", "AO1", "T", "IH0", "K", "AH0", "S"],
    "aeronautics": ["EH2", "R", "AH0", "N", "AO1", "T", "IH0", "K", "S"],
    "aeroperu": ["EH2", "R", "OW0", "P", "EY0", "R", "UW1"],
    "aeroperu's": ["EH2", "R", "OW0", "P", "EY0", "R", "UW1", "Z"],
    "aeroquip": ["EH1", "R", "AH0", "K", "W", "IH2", "P"],
    "aeroscience": ["EH2", "R", "OW0", "S", "AY1", "AH0", "S"],
    "aerosmith": ["EH1", "R", "OW0", "S", "M", "IH2", "TH"],
    "aerosmith's": ["EH1", "R", "OW0", "S", "M", "IH2", "TH", "S"],
    "aerosol": ["EH1", "R", "AH0", "S", "AA2", "L"],
    "aerosols": ["EH1", "R", "AH0", "S", "AA2", "L", "Z"],
    "aerospace": ["EH1", "R", "OW0", "S", "P", "EY2", "S"],
    "aerospace's": ["EH1", "R", "OW0", "S", "P", "EY2", "S", "IH0", "Z"],
    "aerospatiale": ["EH2", "R", "OW0", "S", "P", "AA2", "S", "IY0", "AA1", "L"],
    "aerospatiale's": ["EH2", "R", "OW0", "S", "P", "AA2", "S", "IY0", "AA1", "L", "Z"],
    "aerostar": ["EH1", "R", "OW0", "S", "T", "AA2", "R"],
    "aerostar's": ["EH1", "R", "OW0", "S", "T", "AA2", "R", "Z"],
    "aerostars": ["EH1", "R", "OW0", "S", "T", "AA2", "R", "Z"],
    "aerostat": ["EH1", "R", "OW0", "S", "T", "AE2", "T"],
    "aerostat's": ["EH1", "R", "OW0", "S", "T", "AE2", "T", "S"],
    "aerostats": ["EH1", "R", "OW0", "S", "T", "AE2", "T", "S"],
    "aerotech": ["EH1", "R", "OW0", "T", "EH2", "K"],
    "aerovias": ["EH0", "R", "OW0", "V", "IY1", "AH0", "Z"],
    "aerts": ["EH1", "R", "T", "S"],
    "aeschelus": ["EH1", "S", "K", "AH0", "L", "AH0", "S"],
    "aeschliman": ["EH1", "SH", "L", "IY0", "M", "AH0", "N"],
    "aesop": ["IY1", "S", "AA2", "P"],
    "aesop's": ["IY1", "S", "AA2", "P", "S"],
    "aesthenopia": ["AE0", "S", "TH", "AH0", "N", "AO1", "P", "Y", "AH0"],
    "aesthete": ["EH1", "S", "TH", "IY0", "T"],
    "aesthete's": ["EH1", "S", "TH", "IY0", "T", "S"],
    "aesthetes": ["EH1", "S", "TH", "IY0", "T", "S"],
    "aesthetic": ["EH0", "S", "TH", "EH1", "T", "IH0", "K"],
    "aesthetically": ["EH0", "S", "TH", "EH1", "T", "IH0", "K", "L", "IY0"],
    "aesthetics": ["EH0", "S", "TH", "EH1", "T", "IH0", "K", "S"],
    "aetna": ["EH1", "T", "N", "AH0"],
    "aetna's": ["EH1", "T", "N", "AH0", "Z"],
    "afanasyev": ["AE2", "F", "AH0", "N", "EY1", "S", "IY0", "EH0", "V"],
    "afar": ["AH0", "F", "AA1", "R"],
    "affable": ["AE1", "F", "AH0", "B", "AH0", "L"],
    "affably": ["AE1", "F", "AH0", "B", "L", "IY0"],
    "affair": ["AH0", "F", "EH1", "R"],
    "affair's": ["AH0", "F", "EH1", "R", "Z"],
    "affairs": ["AH0", "F", "EH1", "R", "Z"],
    "affect": ["AH0", "F", "EH1", "K", "T"],
    "affectation": ["AE2", "F", "EH0", "K", "T", "EY1", "SH", "AH0", "N"],
    "affected": ["AH0", "F", "EH1", "K", "T", "IH0", "D"],
    "affecting": ["AH0", "F", "EH1", "K", "T", "IH0", "NG"],
    "affection": ["AH0", "F", "EH1", "K", "SH", "AH0", "N"],
    "affectionate": ["AH0", "F", "EH1", "K", "SH", "AH0", "N", "IH0", "T"],
    "affectionately": ["AH0", "F", "EH1", "K", "SH", "AH0", "N", "AH0", "T", "L", "IY0"],
    "affections": ["AH0", "F", "EH1", "K", "SH", "AH0", "N", "Z"],
    "affective": ["AH0", "F", "EH1", "K", "T", "IH0", "V"],
    "affectively": ["AH0", "F", "EH1", "K", "T", "IH0", "V", "L", "IY0"],
    "affects": ["AH0", "F", "EH1", "K", "T", "S"],
    "affeldt": ["AE1", "F", "IH0", "L", "T"],
    "afferent": ["AE1", "F", "ER0", "AH0", "N", "T"],
    "affiant": ["AE1", "F", "IY0", "AH0", "N", "T"],
    "affidavit": ["AE2", "F", "AH0", "D", "EY1", "V", "AH0", "T"],
    "affidavits": ["AE2", "F", "IH0", "D", "EY1", "V", "IH0", "T", "S"],
    "affiliate": ["AH0", "F", "IH1", "L", "IY0", "AH0", "T"],
    "affiliate's": ["AH0", "F", "IH1", "L", "IY0", "EY2", "T", "S"],
    "affiliated": ["AH0", "F", "IH1", "L", "IY0", "EY2", "T", "IH0", "D"],
    "affiliated's": ["AH0", "F", "IH1", "L", "IY0", "EY2", "T", "IH0", "D", "Z"],
    "affiliates": ["AH0", "F", "IH1", "L", "IY0", "EY2", "T", "S"],
    "affiliates'": ["AH0", "F", "IH1", "L", "IY0", "IH0", "T", "S"],
    "affiliating": ["AH0", "F", "IH1", "L", "IY0", "EY2", "T", "IH0", "NG"],
    "affiliation": ["AH0", "F", "IH2", "L", "IY0", "EY1", "SH", "AH0", "N"],
    "affiliations": ["AH0", "F", "IH2", "L", "IY0", "EY1", "SH", "AH0", "N", "Z"],
    "affine": ["AH0", "F", "AY1", "N"],
    "affined": ["AH0", "F", "AY1", "N", "D"],
    "affines": ["AH0", "F", "AY1", "N", "Z"],
    "affining": ["AH0", "F", "AY1", "N", "IH0", "NG"],
    "affinities": ["AH0", "F", "IH1", "N", "AH0", "T", "IY0", "Z"],
    "affinity": ["AH0", "F", "IH1", "N", "IH0", "T", "IY0"],
    "affirm": ["AH0", "F", "ER1", "M"],
    "affirmation": ["AE2", "F", "ER0", "M", "EY1", "SH", "AH0", "N"],
    "affirmations": ["AE2", "F", "ER0", "M", "EY1", "SH", "AH0", "N", "Z"],
    "affirmative": ["AH0", "F", "ER1", "M", "AH0", "T", "IH0", "V"],
    "affirmatively": ["AH0", "F", "ER1", "M", "AH0", "T", "IH0", "V", "L", "IY0"],
    "affirmed": ["AH0", "F", "ER1", "M", "D"],
    "affirming": ["AH0", "F", "ER1", "M", "IH0", "NG"],
    "affirms": ["AH0", "F", "ER1", "M", "Z"],
    "affix": ["AH0", "F", "IH1", "K", "S"],
    "affixed": ["AH0", "F", "IH1", "K", "S", "T"],
    "affixes": ["AH0", "F", "IH1", "K", "S", "IH0", "Z"],
    "affixing": ["AH0", "F", "IH1", "K", "S", "IH0", "NG"],
    "affleck": ["AE1", "F", "L", "IH0", "K"],
    "afflerbach": ["AE1", "F", "L", "ER0", "B", "AA2", "K"],
    "afflict": ["AH0", "F", "L", "IH1", "K", "T"],
    "afflicted": ["AH0", "F", "L", "IH1", "K", "T", "IH0", "D"],
    "afflicting": ["AH0", "F", "L", "IH1", "K", "T", "IH0", "NG"],
    "affliction": ["AH0", "F", "L", "IH1", "K", "SH", "AH0", "N"],
    "afflictions": ["AH0", "F", "L", "IH1", "K", "SH", "AH0", "N", "Z"],
    "afflicts": ["AH0", "F", "L", "IH1", "K", "T", "S"],
    "afflik": ["AE2", "F", "L", "IH1", "K"],
    "affluence": ["AE1", "F", "L", "UW0", "AH0", "N", "S"],
    "affluent": ["AE1", "F", "L", "UW0", "AH0", "N", "T"],
    "affolter": ["AE1", "F", "OW0", "L", "T", "ER0"],
    "afford": ["AH0", "F", "AO1", "R", "D"],
    "affordability": ["AH0", "F", "AO2", "R", "D", "AH0", "B", "IH1", "L", "AH0", "T", "IY0"],
    "affordable": ["AH0", "F", "AO1", "R", "D", "AH0", "B", "AH0", "L"],
    "affordably": ["AH0", "F", "AO1", "R", "D", "AH0", "B", "L", "IY0"],
    "afforded": ["AH0", "F", "AO1", "R", "D", "AH0", "D"],
    "affording": ["AH0", "F", "AO1", "R", "D", "IH0", "NG"],
    "affords": ["AH0", "F", "AO1", "R", "D", "Z"],
    "affricate": ["AE1", "F", "R", "AH0", "K", "AH0", "T"],
    "affricates": ["AE1", "F", "R", "AH0", "K", "AH0", "T", "S"],
    "affrication": ["AE2", "F", "R", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "affront": ["AH0", "F", "R", "AH1", "N", "T"],
    "affronted": ["AH0", "F", "R", "AH1", "N", "T", "IH0", "D"],
    "affronting": ["AH0", "F", "R", "AH1", "N", "T", "IH0", "NG"],
    "affronts": ["AH0", "F", "R", "AH1", "N", "T", "S"],
    "affymax": ["AE1", "F", "IY0", "M", "AE2", "K", "S"],
    "afghan": ["AE1", "F", "G", "AE2", "N"],
    "afghani": ["AE0", "F", "G", "AA1", "N", "IY0"],
    "afghani's": ["AE0", "F", "G", "AE1", "N", "IY0", "Z"],
    "afghanis": ["AE0", "F", "G", "AE1", "N", "IY0", "Z"],
    "afghanistan": ["AE0", "F", "G", "AE1", "N", "AH0", "S", "T", "AE2", "N"],
    "afghanistan's": ["AE0", "F", "G", "AE1", "N", "AH0", "S", "T", "AE2", "N", "Z"],
    "afghanistans": ["AE0", "F", "G", "AE1", "N", "AH0", "S", "T", "AE2", "N", "Z"],
    "afghans": ["AE1", "F", "G", "AE2", "N", "Z"],
    "afheldt": ["AE1", "F", "EH2", "L", "T"],
    "aficionado": ["AH0", "F", "IY2", "SH", "Y", "AH0", "N", "AA1", "D", "OW2"],
    "aficionados": ["AH0", "F", "IH2", "SH", "AH0", "N", "AA1", "D", "OW0", "Z"],
    "afield": ["AH0", "F", "IY1", "L", "D"],
    "afire": ["AH0", "F", "AY1", "R"],
    "afl": ["EY2", "EH2", "F", "EH1", "L"],
    "aflame": ["AH0", "F", "L", "EY1", "M"],
    "aflatoxin": ["AE2", "F", "L", "AH0", "T", "AA1", "K", "S", "IH0", "N"],
    "afloat": ["AH0", "F", "L", "OW1", "T"],
    "aflutter": ["AH0", "F", "L", "AH1", "T", "ER0"],
    "afmed": ["AE1", "F", "M", "EH0", "D"],
    "afonso": ["AH0", "F", "AA1", "N", "S", "OW0"],
    "afoot": ["AH0", "F", "UH1", "T"],
    "aforementioned": ["AH0", "F", "AO1", "R", "M", "EH2", "N", "SH", "AH0", "N", "D"],
    "aforesaid": ["AH0", "F", "AO1", "R", "S", "EH2", "D"],
    "aforethought": ["AH0", "F", "AO1", "R", "TH", "AA2", "T"],
    "afoul": ["AH0", "F", "AW1", "L"],
    "afraid": ["AH0", "F", "R", "EY1", "D"],
    "afresh": ["AH0", "F", "R", "EH1", "SH"],
    "africa": ["AE1", "F", "ER0", "K", "AH0"],
    "africa's": ["AE1", "F", "R", "IH0", "K", "AH0", "Z"],
    "african": ["AE1", "F", "R", "IH0", "K", "AH0", "N"],
    "african-american": ["AE1", "F", "R", "AH0", "K", "AH0", "N", "AH0", "M", "EH1", "R", "AH0", "K", "AH0", "N"],
    "african-americans": ["AE1", "F", "R", "IH0", "K", "AH0", "N", "AH0", "M", "EH1", "R", "IH0", "K", "AH0", "N", "Z"],
    "africanist": ["AE1", "F", "R", "IH0", "K", "AH0", "N", "IH0", "S", "T"],
    "africanist's": ["AE1", "F", "R", "IH0", "K", "AA0", "N", "IH0", "S", "T", "S"],
    "africanists": ["AE1", "F", "R", "IH0", "K", "AA0", "N", "IH0", "S", "T", "S"],
    "africanize": ["AE1", "F", "R", "AH0", "K", "AH0", "N", "AY2", "Z"],
    "africanized": ["AE1", "F", "R", "AH0", "K", "AH0", "N", "AY2", "Z", "D"],
    "africans": ["AE1", "F", "R", "IH0", "K", "AH0", "N", "Z"],
    "afridi": ["AH0", "F", "R", "IY1", "D", "IY0"],
    "afrikaans": ["AE2", "F", "R", "AH0", "K", "AA1", "N", "Z"],
    "afrikaner": ["AE2", "F", "R", "AH0", "K", "AA1", "N", "ER0"],
    "afrikanerdom": ["AE2", "F", "R", "AH0", "K", "AA1", "N", "ER0", "D", "AH0", "M"],
    "afrikaners": ["AE2", "F", "R", "IH0", "K", "AA1", "N", "ER0", "Z"],
    "afro": ["AE1", "F", "R", "OW0"],
    "afroamerican": ["AE1", "F", "R", "OW0", "AH0", "M", "EH1", "R", "AH0", "K", "AH0", "N"],
    "afroamericans": ["AE1", "F", "R", "OW0", "AH0", "M", "EH1", "R", "AH0", "K", "AH0", "N", "Z"],
    "afrocentric": ["AE1", "F", "R", "OW0", "S", "EH1", "N", "T", "R", "IH0", "K"],
    "afsane": ["AA0", "F", "S", "AA1", "N", "EY2"],
    "afsane's": ["AA0", "F", "S", "AA1", "N", "EY2", "Z"],
    "afshar": ["AE1", "F", "SH", "ER0"],
    "afshar's": ["AE1", "F", "SH", "ER0", "Z"],
    "aft": ["AE1", "F", "T"],
    "after": ["AE1", "F", "T", "ER0"],
    "after-room": ["AE1", "F", "T", "ER0", "R", "UW2", "M"],
    "afterall": ["AE1", "F", "T", "ER0", "AA2", "L"],
    "afterburner": ["AE1", "F", "T", "ER0", "B", "ER2", "N", "ER0"],
    "afterburners": ["AE1", "F", "T", "ER0", "B", "ER2", "N", "ER0", "Z"],
    "aftereffect": ["AE1", "F", "T", "ER0", "AH0", "F", "EH2", "K", "T"],
    "aftereffects": ["AE1", "F", "T", "ER0", "AH0", "F", "EH2", "K", "T", "S"],
    "afterglow": ["AE1", "F", "T", "ER0", "G", "L", "OW2"],
    "afterglows": ["AE1", "F", "T", "ER0", "G", "L", "OW2", "Z"],
    "afterhours": ["AE1", "F", "T", "ER0", "HH", "AW2", "ER0", "Z"],
    "afterimage": ["AE1", "F", "T", "ER0", "IH2", "M", "IH0", "JH"],
    "afterimages": ["AE1", "F", "T", "ER0", "IH2", "M", "IH0", "JH", "AH0", "Z"],
    "afterlife": ["AE1", "F", "T", "ER0", "L", "AY2", "F"],
    "afterlives": ["AE1", "F", "T", "ER0", "L", "AY2", "V", "Z"],
    "aftermarket": ["AE1", "F", "T", "ER0", "M", "AA2", "R", "K", "IH0", "T"],
    "aftermarkets": ["AE1", "F", "T", "ER0", "M", "AA2", "R", "K", "IH0", "T", "S"],
    "aftermath": ["AE1", "F", "T", "ER0", "M", "AE2", "TH"],
    "aftermaths": ["AE1", "F", "T", "ER0", "M", "AE2", "TH", "S"],
    "afternoon": ["AE2", "F", "T", "ER0", "N", "UW1", "N"],
    "afternoon's": ["AE2", "F", "T", "ER0", "N", "UW1", "N", "Z"],
    "afternoons": ["AE2", "F", "T", "ER0", "N", "UW1", "N", "Z"],
    "aftershave": ["AE2", "F", "T", "ER0", "SH", "EY1", "V"],
    "aftershaves": ["AE2", "F", "T", "ER0", "SH", "EY1", "V", "Z"],
    "aftershock": ["AE1", "F", "T", "ER0", "SH", "AA2", "K"],
    "aftershocks": ["AE1", "F", "T", "ER0", "SH", "AA2", "K", "S"],
    "aftertaste": ["AE1", "F", "T", "ER0", "T", "EY2", "S", "T"],
    "aftertastes": ["AE1", "F", "T", "ER0", "T", "EY2", "S", "T", "S"],
    "aftertax": ["AE1", "F", "T", "ER0", "T", "AE2", "K", "S"],
    "afterthought": ["AE1", "F", "T", "ER0", "TH", "AO2", "T"],
    "afterthoughts": ["AE1", "F", "T", "ER0", "TH", "AO2", "T", "S"],
    "afterward": ["AE1", "F", "T", "ER0", "W", "ER0", "D"],
    "afterwards": ["AE1", "F", "T", "ER0", "W", "ER0", "D", "Z"],
    "afula": ["AH0", "F", "UW1", "L", "AH0"],
    "afula's": ["AH0", "F", "UW1", "L", "AH0", "Z"],
    "ag": ["EY1", "G", "IY1"],
    "ag's": ["AE1", "G", "Z"],
    "aga": ["AA1", "G", "AH0"],
    "agache": ["AE1", "G", "AE0", "CH"],
    "agache's": ["AE1", "G", "AE0", "CH", "AH0", "Z"],
    "agaches": ["AE1", "G", "AE0", "CH", "AH0", "Z"],
    "again": ["AH0", "G", "EY1", "N"],
    "against": ["AH0", "G", "EY1", "N", "S", "T"],
    "agamemnon": ["AE2", "G", "AH0", "M", "EH1", "M", "N", "AA2", "N"],
    "agamemnon's": ["AE2", "G", "AH0", "M", "EH1", "M", "N", "AA2", "N", "Z"],
    "agan": ["EY1", "G", "AH0", "N"],
    "agana": ["AH0", "G", "AA1", "N", "AH0"],
    "aganbegyan": ["AE2", "G", "AH0", "N", "B", "EH1", "G", "Y", "AH0", "N"],
    "agans": ["AA1", "G", "AA0", "N", "Z"],
    "agape": ["AH0", "G", "EY1", "P"],
    "agar": ["EY1", "G", "ER0"],
    "agard": ["AE1", "G", "ER0", "D"],
    "agarwal": ["AA1", "G", "AA0", "R", "W", "AA0", "L"],
    "agasp": ["AH0", "G", "AE1", "S", "P"],
    "agassi": ["AE1", "G", "AH0", "S", "IY0"],
    "agassiz": ["AH0", "G", "AE1", "S", "IH0", "Z"],
    "agate": ["AE1", "G", "AH0", "T"],
    "agates": ["AE1", "G", "AH0", "T", "S"],
    "agatha": ["AE1", "G", "AH0", "TH", "AH0"],
    "agawam": ["AE1", "G", "AH0", "W", "AA2", "M"],
    "agco": ["AE1", "G", "K", "OW2"],
    "age": ["EY1", "JH"],
    "age's": ["EY1", "JH", "IH0", "Z"],
    "aged": ["EY1", "JH", "IH0", "D"],
    "agee": ["EY1", "JH", "IY1"],
    "agee's": ["EY1", "JH", "IY0", "Z"],
    "ageless": ["EY1", "JH", "L", "AH0", "S"],
    "agematsu": ["AE1", "G", "AH0", "M", "AE1", "T", "S", "UW0"],
    "agence": ["AE1", "JH", "AH0", "N", "S"],
    "agencies": ["EY1", "JH", "AH0", "N", "S", "IY0", "Z"],
    "agencies'": ["EY1", "JH", "AH0", "N", "S", "IY0", "Z"],
    "agency": ["EY1", "JH", "AH0", "N", "S", "IY0"],
    "agency's": ["EY1", "JH", "AH0", "N", "S", "IY0", "Z"],
    "agenda": ["AH0", "JH", "EH1", "N", "D", "AH0"],
    "agendas": ["AH0", "JH", "EH1", "N", "D", "AH0", "Z"],
    "agent": ["EY1", "JH", "AH0", "N", "T"],
    "agent's": ["EY1", "JH", "AH0", "N", "T", "S"],
    "agents": ["EY1", "JH", "AH0", "N", "T", "S"],
    "agents'": ["EY1", "JH", "AH0", "N", "T", "S"],
    "ager": ["EY1", "JH", "ER0"],
    "ageratum": ["AH0", "JH", "EH1", "R", "AH0", "T", "AH0", "M"],
    "ageratums": ["AH0", "JH", "EH1", "R", "AH0", "T", "AH0", "M", "Z"],
    "agers": ["EY1", "JH", "ER0", "Z"],
    "agers'": ["EY1", "JH", "ER0", "Z"],
    "agerton": ["EY1", "G", "ER0", "T", "AH0", "N"],
    "ages": ["EY1", "JH", "IH0", "Z"],
    "agfa": ["AE1", "G", "F", "AH0"],
    "aggarwal": ["AH0", "G", "AA1", "R", "W", "AH0", "L"],
    "aggie": ["AE1", "G", "IY0"],
    "aggies": ["AE1", "G", "IY0", "Z"],
    "agglomerate": ["AH0", "G", "L", "AA1", "M", "ER0", "EY2", "T"],
    "agglomeration": ["AH0", "G", "L", "AA2", "M", "ER0", "EY1", "SH", "AH0", "N"],
    "agglutinate": ["AH0", "G", "L", "UW1", "T", "IH0", "N", "EY2", "T"],
    "aggrandize": ["AH0", "G", "R", "AE1", "N", "D", "AY2", "Z"],
    "aggrandizement": ["AH0", "G", "R", "AE1", "N", "D", "AY2", "Z", "M", "AH0", "N", "T"],
    "aggrandizing": ["AH0", "G", "R", "AE1", "N", "D", "AY2", "Z", "IH0", "NG"],
    "aggravate": ["AE1", "G", "R", "AH0", "V", "EY2", "T"],
    "aggravated": ["AE1", "G", "R", "AH0", "V", "EY2", "T", "IH0", "D"],
    "aggravates": ["AE1", "G", "R", "AH0", "V", "EY2", "T", "S"],
    "aggravating": ["AE1", "G", "R", "AH0", "V", "EY2", "T", "IH0", "NG"],
    "aggravation": ["AE2", "G", "R", "AH0", "V", "EY1", "SH", "AH0", "N"],
    "aggregate": ["AE1", "G", "R", "AH0", "G", "EY0", "T"],
    "aggregated": ["AE1", "G", "R", "AH0", "G", "EY2", "T", "IH0", "D"],
    "aggregates": ["AE1", "G", "R", "AH0", "G", "EY2", "T", "S"],
    "aggregation": ["AE2", "G", "R", "AH0", "G", "EY1", "SH", "AH0", "N"],
    "aggress": ["AH0", "G", "R", "EH1", "S"],
    "aggression": ["AH0", "G", "R", "EH1", "SH", "AH0", "N"],
    "aggressions": ["AH0", "G", "R", "EH1", "SH", "AH0", "N", "Z"],
    "aggressive": ["AH0", "G", "R", "EH1", "S", "IH0", "V"],
    "aggressively": ["AH0", "G", "R", "EH1", "S", "IH0", "V", "L", "IY0"],
    "aggressiveness": ["AH0", "G", "R", "EH1", "S", "IH0", "V", "N", "AH0", "S"],
    "aggressivity": ["AH0", "G", "R", "EH0", "S", "IH1", "V", "IH0", "T", "IY0"],
    "aggressor": ["AH0", "G", "R", "EH1", "S", "ER0"],
    "aggressors": ["AH0", "G", "R", "EH1", "S", "ER0", "Z"],
    "aggrey": ["AE0", "G", "R", "EY1"],
    "aggrieve": ["AH0", "G", "R", "IY1", "V"],
    "aggrieved": ["AH0", "G", "R", "IY1", "V", "D"],
    "aggy": ["AE1", "G", "IY0"],
    "aghast": ["AH0", "G", "AE1", "S", "T"],
    "aghazadeh": ["AE2", "G", "AH0", "Z", "AA1", "D", "EH2"],
    "agie": ["AE1", "G", "IY0"],
    "agildo": ["AH0", "G", "IH1", "L", "D", "OW0"],
    "agile": ["AE1", "JH", "AH0", "L"],
    "agilis": ["AH0", "JH", "IH1", "L", "AH0", "S"],
    "agility": ["AH0", "JH", "IH1", "L", "AH0", "T", "IY0"],
    "agin": ["AA0", "JH", "IY1", "N"],
    "agincourt": ["AE1", "JH", "AH0", "N", "K", "AO2", "R", "T"],
    "aging": ["EY1", "JH", "IH0", "NG"],
    "agins": ["EY1", "G", "IH0", "N", "Z"],
    "agip": ["EY1", "G", "IH0", "P"],
    "agitate": ["AE1", "JH", "AH0", "T", "EY2", "T"],
    "agitated": ["AE1", "JH", "AH0", "T", "EY2", "T", "IH0", "D"],
    "agitating": ["AE1", "JH", "AH0", "T", "EY2", "T", "IH0", "NG"],
    "agitation": ["AE2", "JH", "AH0", "T", "EY1", "SH", "AH0", "N"],
    "agitator": ["AE1", "JH", "AH0", "T", "EY2", "T", "ER0"],
    "agitators": ["AE1", "JH", "IH0", "T", "EY2", "T", "ER0", "Z"],
    "agitprop": ["AE1", "JH", "AH0", "T", "P", "R", "AO2", "P"],
    "agius": ["EY1", "JH", "IY0", "IH0", "S"],
    "agleam": ["AH0", "G", "L", "IY1", "M"],
    "agler": ["AE1", "G", "L", "ER0"],
    "aglitter": ["AH0", "G", "L", "IH1", "T", "ER0"],
    "aglo": ["AH0", "G", "L", "OW1"],
    "aglow": ["AH0", "G", "L", "OW1"],
    "agna": ["AE1", "G", "N", "AA0"],
    "agne": ["AE1", "G", "N", "IH0"],
    "agnella": ["AE2", "G", "N", "EH1", "L", "AA0"],
    "agnelli": ["AE1", "G", "N", "EH2", "L", "IY0"],
    "agnelli's": ["AE1", "G", "N", "EH2", "L", "IY0", "Z"],
    "agnellis": ["AE1", "G", "N", "EH2", "L", "IY0", "Z"],
    "agnello": ["AE2", "G", "N", "EH1", "L", "OW0"],
    "agner": ["AE1", "G", "N", "ER0"],
    "agnes": ["AE1", "G", "N", "IH0", "S"],
    "agneta": ["AA0", "G", "N", "EH1", "T", "AH0"],
    "agnew": ["AE1", "G", "N", "Y", "UW0"],
    "agnico": ["AE1", "G", "N", "IH0", "K", "OW2"],
    "agnor": ["AE1", "G", "N", "ER0"],
    "agnos": ["AE1", "G", "N", "OW0", "S"],
    "agnosio": ["AE0", "G", "N", "OW1", "S", "IY0", "OW0"],
    "agnostic": ["AE0", "G", "N", "AA1", "S", "T", "IH0", "K"],
    "agnostically": ["AE0", "G", "N", "AA1", "S", "T", "IH0", "K", "L", "IY2"],
    "agnostics": ["AE0", "G", "N", "AA1", "S", "T", "IH0", "K", "S"],
    "ago": ["AH0", "G", "OW1"],
    "agog": ["AH0", "G", "AA1", "G"],
    "agoglia": ["AH0", "G", "AA1", "G", "L", "IY0", "AH0"],
    "agonies": ["AE1", "G", "AH0", "N", "IY0", "Z"],
    "agonist": ["AE1", "G", "AH0", "N", "IH0", "S", "T"],
    "agonists": ["AE1", "G", "AH0", "N", "IH0", "S", "T", "S"],
    "agonize": ["AE1", "G", "AH0", "N", "AY2", "Z"],
    "agonized": ["AE1", "G", "AH0", "N", "AY2", "Z", "D"],
    "agonizes": ["AE1", "G", "AH0", "N", "AY2", "Z", "IH0", "Z"],
    "agonizing": ["AE1", "G", "AH0", "N", "AY0", "Z", "IH0", "NG"],
    "agonizingly": ["AE1", "G", "AH0", "N", "AY2", "Z", "IH0", "NG", "L", "IY2"],
    "agony": ["AE1", "G", "AH0", "N", "IY0"],
    "agora": ["AE1", "G", "ER0", "AH0"],
    "agoraphobia": ["AH0", "G", "AO2", "R", "AH0", "F", "OW1", "B", "IY0", "AH0"],
    "agosta": ["AA0", "G", "OW1", "S", "T", "AH0"],
    "agostinelli": ["AA0", "G", "OW0", "S", "T", "IY0", "N", "EH1", "L", "IY0"],
    "agostini": ["AA0", "G", "OW0", "S", "T", "IY1", "N", "IY0"],
    "agostino": ["AA0", "G", "AO0", "S", "T", "IY1", "N", "OW0"],
    "agosto": ["AA0", "G", "OW1", "S", "T", "OW0"],
    "agoura": ["AH0", "G", "UW1", "R", "AH0"],
    "agouron": ["AH0", "G", "UW1", "R", "AA0", "N"],
    "agra": ["AE1", "G", "R", "AH0"],
    "agrarian": ["AH0", "G", "R", "EH1", "R", "IY0", "AH0", "N"],
    "agrarianism": ["AH0", "G", "R", "EH1", "R", "IY0", "AH0", "N", "IH2", "Z", "AH0", "M"],
    "agrawal": ["AH0", "G", "R", "AE1", "W", "AH0", "L"],
    "agree": ["AH0", "G", "R", "IY1"],
    "agreeable": ["AH0", "G", "R", "IY1", "AH0", "B", "AH0", "L"],
    "agreed": ["AH0", "G", "R", "IY1", "D"],
    "agreeing": ["AH0", "G", "R", "IY1", "IH0", "NG"],
    "agreement": ["AH0", "G", "R", "IY1", "M", "AH0", "N", "T"],
    "agreement's": ["AH0", "G", "R", "IY1", "M", "AH0", "N", "T", "S"],
    "agreements": ["AH0", "G", "R", "IY1", "M", "AH0", "N", "T", "S"],
    "agrees": ["AH0", "G", "R", "IY1", "Z"],
    "agregable": ["AH0", "G", "R", "EH1", "JH", "AH0", "B", "AH0", "L"],
    "agregious": ["AH0", "G", "R", "IY1", "JH", "IY0", "AH0", "S"],
    "agresource": ["AE1", "G", "R", "AH0", "S", "AO2", "R", "S"],
    "agresta": ["AA0", "G", "R", "EH1", "S", "T", "AH0"],
    "agresti": ["AA0", "G", "R", "EH1", "S", "T", "IY0"],
    "agrexco": ["AA0", "G", "R", "EH1", "K", "S", "K", "OW0"],
    "agri": ["AE1", "G", "R", "IY0"],
    "agribank": ["AE1", "G", "R", "IH0", "B", "AE2", "NG", "K"],
    "agribusiness": ["AE1", "G", "R", "AH0", "B", "IH2", "Z", "N", "AH0", "S"],
    "agrico": ["AH0", "G", "R", "IY1", "K", "OW0"],
    "agricola": ["AE2", "G", "R", "IH0", "K", "OW1", "L", "AH0"],
    "agricole": ["AE1", "G", "R", "IH0", "K", "OW2", "L"],
    "agricultural": ["AE2", "G", "R", "IH0", "K", "AH1", "L", "CH", "ER0", "AH0", "L"],
    "agriculturalist": ["AE2", "G", "R", "AH0", "K", "AH1", "L", "CH", "ER0", "AH0", "L", "AH0", "S", "T"],
    "agriculturally": ["AE2", "G", "R", "IH0", "K", "AH1", "L", "CH", "R", "AH0", "L", "IY0"],
    "agriculture": ["AE1", "G", "R", "IH0", "K", "AH2", "L", "CH", "ER0"],
    "agriculture's": ["AE1", "G", "R", "IH0", "K", "AH2", "L", "CH", "ER0", "Z"],
    "agrifuel": ["AE1", "G", "R", "AH0", "F", "Y", "UW2", "L"],
    "agrifuels": ["AE1", "G", "R", "AH0", "F", "Y", "UW2", "L", "Z"],
    "agrigenetics": ["AE2", "G", "R", "AH0", "JH", "AH0", "N", "EH1", "T", "IH0", "K", "S"],
    "agrippa": ["AH0", "G", "R", "IH1", "P", "AH0"],
    "agrivisor": ["AE1", "G", "R", "AH0", "V", "AY2", "Z", "ER0"],
    "agro": ["AE1", "G", "R", "OW0"],
    "agrochemical": ["AE2", "G", "R", "OW0", "K", "EH1", "M", "AH0", "K", "AH0", "L"],
    "agrochemicals": ["AE2", "G", "R", "OW0", "K", "EH1", "M", "IH0", "K", "AH0", "L", "Z"],
    "agroindustrial": ["AE2", "G", "R", "OW0", "IH0", "D", "AH1", "S", "T", "R", "IY0", "AH0", "L"],
    "agrokomerc": ["AE1", "G", "R", "AH0", "K", "OW0", "M", "ER2", "K"],
    "agronomist": ["AH0", "G", "R", "AA1", "N", "AH0", "M", "IH0", "S", "T"],
    "agronomists": ["AH0", "G", "R", "AA1", "N", "AH0", "M", "IH0", "S", "T", "S"],
    "agronomy": ["AH0", "G", "R", "AA1", "N", "AH0", "M", "IH2"],
    "agrosiand": ["AH0", "G", "R", "OW1", "S", "IY0", "AH0", "N", "D"],
    "aground": ["AH0", "G", "R", "AW1", "N", "D"],
    "agrusa": ["AA0", "G", "R", "UW1", "S", "AH0"],
    "agua": ["AA1", "G", "W", "AH0"],
    "aguacate": ["AE1", "G", "W", "AH0", "K", "EY2", "T"],
    "aguadilla": ["AA2", "G", "W", "AH0", "D", "IH1", "L", "AH0"],
    "aguado": ["AA0", "G", "W", "AA1", "D", "OW0"],
    "aguanga": ["AH0", "G", "W", "AA1", "N", "G", "AH0"],
    "aguascalientes": ["AA2", "G", "W", "AH0", "S", "K", "AE0", "L", "Y", "EH1", "N", "T", "EH0", "S"],
    "aguayo": ["AA0", "G", "W", "EY1", "OW0"],
    "agudelo": ["AA0", "G", "UW0", "D", "EY1", "L", "OW0"],
    "ague": ["EY1", "G", "Y", "UW2"],
    "aguero": ["AA0", "G", "EH1", "R", "OW0"],
    "aguiar": ["AA1", "G", "W", "IY0", "ER0"],
    "aguila": ["AA0", "G", "W", "IY1", "L", "AH0"],
    "aguilar": ["AE1", "G", "AH0", "L", "AA0", "R"],
    "aguilera": ["AA0", "G", "W", "IY0", "L", "EH1", "R", "AH0"],
    "aguillar": ["AE1", "G", "AH0", "L", "AA0", "R"],
    "aguillard": ["AE1", "G", "IH0", "L", "ER0", "D"],
    "aguillon": ["AA0", "G", "W", "IY0", "L", "AO1", "N"],
    "aguilo": ["AH0", "G", "W", "IY1", "L", "OW0"],
    "aguinaga": ["AA0", "G", "UW0", "IY0", "N", "AA1", "G", "AH0"],
    "aguirra": ["AH0", "G", "W", "IH1", "R", "AH0"],
    "aguirra's": ["AH0", "G", "W", "IH1", "R", "AH0", "Z"],
    "aguirre": ["AH0", "G", "W", "IH1", "R", "EY0"],
    "aguirre's": ["AH0", "G", "W", "IH1", "R", "EY0", "Z"],
    "agustin": ["AH0", "G", "AO1", "S", "T", "IH0", "N"],
    "ah": ["AA1"],
    "aha": ["AA2", "HH", "AA1"],
    "ahab": ["EY1", "HH", "AE2", "B"],
    "ahah": ["AA1", "HH", "AA0"],
    "aharon": ["AE1", "HH", "ER0", "AA0", "N"],
    "ahart": ["AH0", "HH", "AA1", "R", "T"],
    "ahasuerus": ["AH0", "HH", "AE2", "SH", "AH0", "W", "EH1", "R", "AH0", "S"],
    "ahaulsie": ["AH0", "HH", "AA1", "L", "S", "IY0"],
    "ahead": ["AH0", "HH", "EH1", "D"],
    "ahearn": ["AH0", "HH", "ER1", "N"],
    "aherin": ["AA1", "ER0", "IH0", "N"],
    "ahern": ["AH0", "HH", "ER1", "N"],
    "aherne": ["AH0", "HH", "ER1", "N"],
    "ahh": ["AA1"],
    "ahl": ["AA1", "L"],
    "ahlberg": ["AA1", "L", "B", "ER0", "G"],
    "ahlborn": ["AA1", "L", "B", "ER0", "N"],
    "ahlen": ["AA1", "L", "AH0", "N"],
    "ahlers": ["AA1", "L", "ER0", "Z"],
    "ahles": ["EY1", "AH0", "L", "Z"],
    "ahlf": ["AA1", "L", "F"],
    "ahlgren": ["AA1", "L", "G", "R", "EH0", "N"],
    "ahlgrim": ["AA1", "L", "G", "R", "IH0", "M"],
    "ahlin": ["AA1", "L", "IH0", "N"],
    "ahlman": ["AA1", "L", "M", "AH0", "N"],
    "ahlquist": ["AA1", "L", "K", "W", "IH2", "S", "T"],
    "ahlquist's": ["AA1", "L", "K", "W", "IH2", "S", "T", "S"],
    "ahlquists": ["AA1", "L", "K", "W", "IH2", "S", "T", "S"],
    "ahlstrand": ["AA1", "L", "S", "T", "R", "AH0", "N", "D"],
    "ahlstrom": ["AA1", "L", "S", "T", "R", "AH0", "M"],
    "ahluwalia": ["AH0", "L", "UW0", "AA1", "L", "Y", "AH0"],
    "ahmad": ["AA1", "M", "AA0", "D"],
    "ahmadi": ["AA0", "M", "AA1", "D", "IY0"],
    "ahmann": ["AA1", "M", "AH0", "N"],
    "ahmanson": ["AA1", "M", "AH0", "N", "S", "AH0", "N"],
    "ahmanson's": ["AA1", "M", "AH0", "N", "S", "AH0", "N", "Z"],
    "ahmansons": ["AA1", "M", "AH0", "N", "S", "AH0", "N", "Z"],
    "ahmed": ["AA1", "M", "EH0", "D"],
    "ahmeek": ["AH1", "M", "IY0", "K"],
    "ahmoudi": ["AA0", "M", "UW1", "D", "IY0"],
    "ahn": ["AE1", "N"],
    "ahnell": ["AA0", "N", "EH1", "L"],
    "ahner": ["AA1", "N", "ER0"],
    "aho": ["AA1", "HH", "OW0"],
    "ahola": ["AE1", "HH", "AH0", "L", "AH0"],
    "ahold": ["AH0", "HH", "OW1", "L", "D"],
    "ahold's": ["AH0", "HH", "OW1", "L", "D", "Z"],
    "aholds": ["AH0", "HH", "OW1", "L", "D", "Z"],
    "ahonen": ["AH0", "HH", "OW1", "N", "AH0", "N"],
    "ahoskie": ["AH0", "HH", "AO1", "S", "K", "IY0"],
    "ahoy": ["AH0", "HH", "OY1"],
    "ahr": ["AA1", "R"],
    "ahranat": ["AH0", "R", "AA1", "N", "AH0", "T"],
    "ahren": ["AA1", "R", "AH0", "N"],
    "ahrendt": ["AA1", "R", "IH0", "N", "T"],
    "ahrens": ["AA1", "R", "IH0", "N", "Z"],
    "ahs": ["AA1", "Z"],
    "ahsahka": ["AA0", "S", "AA1", "K", "AH0"],
    "ahuja": ["AA0", "HH", "UW1", "Y", "AH0"],
    "ahumada": ["AA0", "Y", "UW0", "M", "AA1", "D", "AH0"],
    "ahwahnee": ["AH0", "W", "AA1", "N", "IY0"],
    "ai": ["EY1", "AY1"],
    "aichele": ["AY1", "K", "AH0", "L"],
    "aicher": ["AY1", "K", "ER0"],
    "aichi": ["AA0", "IY1", "CH", "IY0"],
    "aickin": ["EY1", "K", "IH0", "N"],
    "aid": ["EY1", "D"],
    "aid's": ["EY1", "D", "Z"],
    "aida": ["AY0", "IY1", "D", "AH0"],
    "aidan": ["EY1", "D", "AA0", "N"],
    "aide": ["EY1", "D"],
    "aide's": ["EY1", "D", "Z"],
    "aided": ["EY1", "D", "IH0", "D"],
    "aiden": ["EY2", "D", "EH1", "N"],
    "aidenn": ["EY2", "D", "EH1", "N"],
    "aides": ["EY1", "D", "Z"],
    "aides'": ["EY1", "D", "Z"],
    "aidid": ["AY2", "D", "IY1", "D"],
    "aidid's": ["AY2", "D", "IY1", "D", "Z"],
    "aiding": ["EY1", "D", "IH0", "NG"],
    "aids": ["EY1", "D", "Z"],
    "aiello": ["AY2", "EH1", "L", "OW0"],
    "aiesha": ["AY1", "SH", "AH0"],
    "aigner": ["EY1", "K", "N", "ER0"],
    "aiguebelle": ["AY1", "G", "AH0", "B", "EH2", "L"],
    "aiken": ["EY1", "K", "IH0", "N"],
    "aikens": ["EY1", "K", "IH0", "N", "Z"],
    "aikey": ["EY1", "K", "IY0"],
    "aikin": ["EY1", "K", "IH0", "N"],
    "aikins": ["AY1", "K", "IH0", "N", "Z"],
    "aikman": ["EY1", "K", "M", "AH0", "N"],
    "aikoff": ["AY1", "K", "AO2", "F"],
    "ail": ["EY1", "L"],
    "ailee": ["EY1", "L", "IY1"],
    "aileen": ["AY0", "L", "IY1", "N"],
    "ailene": ["AY0", "L", "IY1", "N"],
    "aileron": ["EY1", "L", "ER0", "AA2", "N"],
    "ailerons": ["EY1", "L", "ER0", "AA2", "N", "Z"],
    "ailes": ["EY1", "L", "Z"],
    "ailey": ["EY1", "L", "IY0"],
    "ailing": ["EY1", "L", "IH0", "NG"],
    "ailment": ["EY1", "L", "M", "AH0", "N", "T"],
    "ailments": ["EY1", "L", "M", "AH0", "N", "T", "S"],
    "ailor": ["EY1", "L", "ER0"],
    "ails": ["EY1", "L", "Z"],
    "ailsa": ["EY1", "L", "S", "AH0"],
    "ailurophile": ["EY0", "L", "UH1", "R", "AH0", "F", "AY0", "AH0", "L"],
    "aim": ["EY1", "M"],
    "aim's": ["EY1", "M", "Z"],
    "aimal": ["AY1", "M", "AH0", "L"],
    "aiman": ["AY1", "M", "AH0", "N"],
    "aime": ["EY1", "M"],
    "aimed": ["EY1", "M", "D"],
    "aimee": ["EY1", "M", "IY1"],
    "aimetti": ["EY0", "M", "EH1", "T", "IY0"],
    "aiming": ["EY1", "M", "IH0", "NG"],
    "aimless": ["EY1", "M", "L", "AH0", "S"],
    "aimlessly": ["EY1", "M", "L", "AH0", "S", "L", "IY0"],
    "aimone": ["EY1", "M", "OW2", "N"],
    "aims": ["EY1", "M", "Z"],
    "ain't": ["EY1", "N", "T"],
    "aine": ["EY1", "N"],
    "ainge": ["EY1", "N", "JH"],
    "ainley": ["EY1", "N", "L", "IY0"],
    "ainsberg": ["EY1", "N", "Z", "B", "ER0", "G"],
    "ainsley": ["EY1", "N", "S", "L", "IY0"],
    "ainslie": ["EY1", "N", "Z", "L", "IY0"],
    "ainsworth": ["EY1", "N", "S", "W", "ER0", "TH"],
    "ainsworth's": ["EY1", "N", "Z", "W", "ER0", "TH", "S"],
    "ainu": ["EY1", "N", "UW2"],
    "aipac": ["AY1", "P", "AE2", "K"],
    "aipac's": ["AY1", "P", "AE2", "K", "S"],
    "air": ["EH1", "R"],
    "air's": ["EH1", "R", "Z"],
    "air-conditioning": ["EH1", "R", "K", "AH0", "N", "D", "IH2", "SH", "AH0", "N", "IH0", "NG"],
    "air-force": ["EH1", "R", "F", "AO0", "R", "S"],
    "airbag": ["EH1", "R", "B", "AE2", "G"],
    "airbags": ["EH1", "R", "B", "AE2", "G", "Z"],
    "airbase": ["EH1", "R", "B", "EY2", "S"],
    "airbases": ["EH1", "R", "B", "EY2", "S", "IH0", "S"],
    "airboat": ["EH1", "R", "B", "OW0", "T"],
    "airboats": ["EH1", "R", "B", "OW0", "T", "S"],
    "airborne": ["EH1", "R", "B", "AO2", "R", "N"],
    "airborne's": ["EH1", "R", "B", "AO2", "R", "N", "Z"],
    "airbus": ["EH1", "R", "B", "AH0", "S"],
    "airbus's": ["EH1", "R", "B", "AH0", "S", "IH0", "Z"],
    "aircal": ["EH1", "R", "K", "AA0", "L"],
    "aircal's": ["EH1", "R", "K", "AE2", "L", "Z"],
    "airco": ["EH1", "R", "K", "OW0"],
    "aircoa": ["EH2", "R", "K", "OW1", "AH0"],
    "aircondition": ["EH1", "R", "K", "AH0", "N", "D", "IH2", "SH", "AH0", "N"],
    "airconditioned": ["EH1", "R", "K", "AH0", "N", "D", "IH2", "SH", "AH0", "N", "D"],
    "airconditioner": ["EH1", "R", "K", "AH0", "N", "D", "IH2", "SH", "AH0", "N", "ER0"],
    "airconditioning": ["EH1", "R", "K", "AH0", "N", "D", "IH2", "SH", "AH0", "N", "IH0", "NG"],
    "airconditions": ["EH1", "R", "K", "AH0", "N", "D", "IH2", "SH", "AH0", "N", "Z"],
    "aircraft": ["EH1", "R", "K", "R", "AE2", "F", "T"],
    "aircraft's": ["EH1", "R", "K", "R", "AE2", "F", "S"],
    "aircrafts": ["EH1", "R", "K", "R", "AE2", "F", "S"],
    "aircrew": ["EH1", "R", "K", "R", "UW2"],
    "aird": ["EH1", "R", "D"],
    "airdrop": ["EH1", "R", "D", "R", "AA0", "P"],
    "airdrops": ["EH1", "R", "D", "R", "AA0", "P", "S"],
    "aired": ["EH1", "R", "D"],
    "airedale": ["EH1", "R", "D", "EY2", "L"],
    "airedales": ["EH1", "R", "D", "EY2", "L", "Z"],
    "aires": ["EH1", "R", "IY0", "Z"],
    "airey": ["EH1", "R", "IY0"],
    "airfare": ["EH1", "R", "F", "EH2", "R"],
    "airfares": ["EH1", "R", "F", "EH2", "R", "Z"],
    "airfield": ["EH1", "R", "F", "IY2", "L", "D"],
    "airfields": ["EH1", "R", "F", "IY2", "L", "D", "Z"],
    "airflow": ["EH1", "R", "F", "L", "OW0"],
    "airflows": ["EH1", "R", "F", "L", "OW0", "Z"],
    "airfoil": ["EH1", "R", "F", "OY2", "L"],
    "airfoils": ["EH1", "R", "F", "OY2", "L", "Z"],
    "airfone": ["EH1", "R", "F", "OW2", "N"],
    "airfones": ["EH1", "R", "F", "OW2", "N", "Z"],
    "airforce": ["EH1", "R", "F", "AO0", "R", "S"],
    "airforces": ["EH1", "R", "F", "AO0", "R", "S", "IH0", "Z"],
    "airframe": ["EH1", "R", "F", "R", "EY2", "M"],
    "airframes": ["EH1", "R", "F", "R", "EY2", "M", "Z"],
    "airfreight": ["EH1", "R", "F", "R", "EY2", "T"],
    "airgas": ["EH1", "R", "G", "AE2", "S"],
    "airglow": ["EH1", "R", "G", "L", "OW2"],
    "airhart": ["EH1", "R", "HH", "AA0", "R", "T"],
    "airhead": ["EH1", "R", "HH", "EH2", "D"],
    "airheadz": ["EH1", "R", "HH", "EH2", "D", "Z"],
    "airing": ["EH1", "R", "IH0", "NG"],
    "airington": ["EH1", "R", "IH0", "NG", "T", "AH0", "N"],
    "airless": ["EH1", "R", "L", "AH0", "S"],
    "airlia": ["EH1", "R", "L", "IY0", "AH0"],
    "airlie": ["EH1", "R", "L", "IY0"],
    "airlift": ["EH1", "R", "L", "IH2", "F", "T"],
    "airlifted": ["EH1", "R", "L", "IH2", "F", "T", "IH0", "D"],
    "airlifter": ["EH1", "R", "L", "IH2", "F", "T", "ER0"],
    "airlifters": ["EH1", "R", "L", "IH2", "F", "T", "ER0", "Z"],
    "airlifting": ["EH1", "R", "L", "IH2", "F", "T", "IH0", "NG"],
    "airlifts": ["EH1", "R", "L", "IH2", "F", "T", "S"],
    "airline": ["EH1", "R", "L", "AY2", "N"],
    "airline's": ["EH1", "R", "L", "AY2", "N", "Z"],
    "airliner": ["EH1", "R", "L", "AY2", "N", "ER0"],
    "airliner's": ["EH1", "R", "L", "AY2", "N", "ER0", "Z"],
    "airliners": ["EH1", "R", "L", "AY2", "N", "ER0", "Z"],
    "airlines": ["EH1", "R", "L", "AY2", "N", "Z"],
    "airlines'": ["EH1", "R", "L", "AY2", "N", "Z"],
    "airlink": ["EH1", "R", "L", "IH2", "NG", "K"],
    "airlinks": ["EH1", "R", "L", "IH2", "NG", "K", "S"],
    "airlock": ["EH1", "R", "L", "AO2", "K"],
    "airlocks": ["EH1", "R", "L", "AO2", "K", "S"],
    "airmail": ["EH1", "R", "M", "EY2", "L"],
    "airman": ["EH1", "R", "M", "AH0", "N"],
    "airman's": ["EH1", "R", "M", "AH0", "N", "Z"],
    "airmen": ["EH1", "R", "M", "EH2", "N"],
    "airmotive": ["EH2", "R", "M", "OW1", "T", "IH0", "V"],
    "airplane": ["EH1", "R", "P", "L", "EY2", "N"],
    "airplane's": ["EH1", "R", "P", "L", "EY0", "N", "Z"],
    "airplanes": ["EH1", "R", "P", "L", "EY0", "N", "Z"],
    "airport": ["EH1", "R", "P", "AO2", "R", "T"],
    "airport's": ["EH1", "R", "P", "AO2", "R", "T", "S"],
    "airporter": ["EH1", "R", "P", "AO2", "R", "T", "ER0"],
    "airporters": ["EH1", "R", "P", "AO2", "R", "T", "ER0", "Z"],
    "airports": ["EH1", "R", "P", "AO2", "R", "T", "S"],
    "airpower": ["EH1", "R", "P", "AW2", "ER0"],
    "airs": ["EH1", "R", "Z"],
    "airshare": ["EH1", "R", "SH", "EH0", "R"],
    "airship": ["EH1", "R", "SH", "IH2", "P"],
    "airships": ["EH1", "R", "SH", "IH2", "P", "S"],
    "airspace": ["EH1", "R", "S", "P", "EY2", "S"],
    "airspaces": ["EH1", "R", "S", "P", "EY2", "S", "IH0", "Z"],
    "airspeed": ["EH1", "R", "S", "P", "IY2", "D"],
    "airstrike": ["EH1", "R", "S", "T", "R", "AY2", "K"],
    "airstrikes": ["EH1", "R", "S", "T", "R", "AY2", "K", "S"],
    "airstrip": ["EH1", "R", "S", "T", "R", "IH2", "P"],
    "airstrips": ["EH1", "R", "S", "T", "R", "IH2", "P", "S"],
    "airtight": ["EH1", "R", "T", "AY2", "T"],
    "airtime": ["EH1", "R", "T", "AY2", "M"],
    "airtouch": ["EH1", "R", "T", "AH2", "CH"],
    "airtran": ["EH1", "R", "T", "R", "AE2", "N"],
    "airwave": ["EH1", "R", "W", "EY2", "V"],
    "airwaves": ["EH1", "R", "W", "EY2", "V", "Z"],
    "airway": ["EH1", "R", "W", "EY2"],
    "airway's": ["EH1", "R", "W", "EY2", "Z"],
    "airways": ["EH1", "R", "W", "EY2", "Z"],
    "airways'": ["EH1", "R", "W", "EY2", "Z"],
    "airways's": ["EH1", "R", "W", "EY2", "Z", "IH0", "Z"],
    "airwing": ["EH1", "R", "W", "IH0", "NG"],
    "airwings": ["EH1", "R", "W", "IH0", "NG", "Z"],
    "airworthiness": ["EH1", "R", "W", "ER2", "DH", "IY0", "N", "AH0", "S"],
    "airworthy": ["EH1", "R", "W", "ER2", "DH", "IY0"],
    "airy": ["EH1", "R", "IY0"],
    "ais": ["AY1", "Z"],
    "aisa": ["AY0", "IY1", "S", "AH0"],
    "aisha": ["AY1", "SH", "AH0"],
    "aisle": ["AY1", "AH0", "L"],
    "aisles": ["AY1", "AH0", "L", "Z"],
    "aisling": ["AE1", "SH", "L", "IH0", "NG"],
    "aislinn": ["AE1", "SH", "L", "IH0", "NG"],
    "aist": ["EY1", "S", "T"],
    "aitchison": ["EY1", "CH", "IH0", "S", "AH0", "N"],
    "aithne": ["EY1", "TH", "N"],
    "aitken": ["AY1", "T", "K", "AH0", "N"],
    "aiton": ["AA0", "IY1", "T", "OW0", "N"],
    "aiwa": ["AY1", "W", "AH0"],
    "aix": ["EY1", "K", "S"],
    "aix-en-provence": ["EH1", "K", "S", "AA0", "N", "P", "R", "AH0", "V", "AO1", "N", "S"],
    "aix-la-chapelle": ["EH1", "K", "S", "L", "AA2", "SH", "AH0", "P", "EH1", "L"],
    "aja": ["AY1", "AH0"],
    "ajaj": ["AH0", "JH", "AA1", "JH"],
    "ajaj's": ["AH0", "JH", "AA1", "JH", "IH0", "Z"],
    "ajami": ["EY2", "JH", "AA1", "M", "IY0"],
    "ajar": ["AH0", "JH", "AA1", "R"],
    "ajax": ["EY1", "JH", "AE2", "K", "S"],
    "ajax's": ["EY1", "JH", "AE2", "K", "S", "IH0", "Z"],
    "ajay": ["EH1", "JH", "EY0"],
    "ajinomoto": ["AH0", "JH", "IH2", "N", "AH0", "M", "OW1", "T", "OW0"],
    "ajito": ["AH0", "HH", "IY1", "T", "OW0"],
    "aka": ["EY1", "K", "EY1", "EY1"],
    "akai": ["AH0", "K", "AY1"],
    "akaka": ["AH0", "K", "AA1", "K", "AH0"],
    "akali": ["AH0", "K", "AA1", "L", "IY0"],
    "akamine": ["AE1", "K", "AH0", "M", "AY2", "N"],
    "akana": ["AA0", "K", "AA1", "N", "AH0"],
    "akao": ["AH0", "K", "AA1", "W"],
    "akard": ["AE1", "K", "ER0", "D"],
    "akashi": ["AH0", "K", "AA1", "SH", "IY0"],
    "akashi's": ["AH0", "K", "AA1", "SH", "IY0", "Z"],
    "akbar": ["AA1", "K", "B", "AA2", "R"],
    "akbash": ["AE1", "K", "B", "AE0", "SH"],
    "akc": ["AE1", "K"],
    "ake": ["EY1", "K"],
    "akebono": ["AE2", "K", "IY0", "B", "OW1", "N", "OW0"],
    "akel": ["AH0", "K", "EH1", "L"],
    "akella": ["AH0", "K", "EH1", "L", "AH0"],
    "aken": ["EY1", "K", "AH0", "N"],
    "akens": ["EY1", "K", "AH0", "N", "Z"],
    "aker": ["EY1", "K", "ER0"],
    "akerley": ["AH0", "K", "ER1", "L", "IY0"],
    "akerman": ["AE1", "K", "ER0", "M", "AH0", "N"],
    "akers": ["EY1", "K", "ER0", "Z"],
    "akers's": ["EY1", "K", "ER0", "Z", "IH0", "Z"],
    "akerson": ["AE1", "K", "ER0", "S", "AH0", "N"],
    "akey": ["AH0", "K", "IY1"],
    "akhtar": ["AE1", "K", "T", "ER0"],
    "aki": ["AA1", "K", "IY0"],
    "akiba": ["AH0", "K", "IY1", "B", "AH0"],
    "akihito": ["AA2", "K", "IY0", "HH", "IY1", "T", "OW2"],
    "akiko": ["AH0", "K", "IY1", "K", "OW0"],
    "akimbo": ["AH0", "K", "IH1", "M", "B", "OW2"],
    "akin": ["EY1", "K", "IH0", "N"],
    "akins": ["EY1", "K", "IH0", "N", "Z"],
    "akio": ["AA1", "K", "IY0", "OW0"],
    "akira": ["AH0", "K", "IY1", "R", "AH0"],
    "akita": ["AH0", "K", "IY1", "T", "AH0"],
    "akita's": ["AH0", "K", "IY1", "T", "AH0", "Z"],
    "akiva": ["AH0", "K", "IY1", "V", "AH0"],
    "akiyama": ["AA0", "K", "IY0", "Y", "AA1", "M", "AH0"],
    "akkadian": ["AH0", "K", "EY1", "D", "IY0", "AH0", "N"],
    "akkerman": ["AE1", "K", "ER0", "M", "AH0", "N"],
    "akre": ["AE1", "K", "ER0"],
    "akridge": ["AH0", "K", "R", "IH1", "JH"],
    "akron": ["AE1", "K", "R", "AH0", "N"],
    "aksamit": ["AE1", "K", "S", "AH0", "M", "IH0", "T"],
    "aksler": ["AE1", "K", "S", "L", "ER0"],
    "akst": ["AE1", "K", "S", "T"],
    "akyanama": ["AE2", "K", "Y", "AA1", "N", "AA0", "M", "AH0"],
    "akzo": ["AE1", "K", "Z", "OW0"],
    "akzo's": ["AE1", "K", "Z", "OW0", "Z"],
    "akzos": ["AE1", "K", "Z", "OW0", "Z"],
    "al": ["AE1", "L"],
    "al's": ["AE1", "L", "Z"],
    "al-amein": ["AE1", "L", "AH0", "M", "EY2", "N"],
    "al-qaeda": ["AA2", "L", "K", "AY1", "D", "AA0"],
    "al.": ["AE2", "L", "AH0", "B", "AE1", "M", "AH0"],
    "ala": ["EY1", "L", "AH0"],
    "alabama": ["AE2", "L", "AH0", "B", "AE1", "M", "AH0"],
    "alabama's": ["AE2", "L", "AH0", "B", "AE1", "M", "AH0", "Z"],
    "alabaman": ["AE2", "L", "AH0", "B", "AE1", "M", "AH0", "N"],
    "alabamans": ["AE2", "L", "AH0", "B", "AE1", "M", "AH0", "N", "Z"],
    "alabaster": ["AE1", "L", "AH0", "B", "AE2", "S", "T", "ER0"],
    "alachlor": ["AH0", "L", "AE1", "K", "L", "ER0"],
    "alachua": ["AH0", "L", "AE1", "CH", "UW0", "AH0"],
    "alacrity": ["AH0", "L", "AE1", "K", "R", "AH0", "T", "IY0"],
    "aladdin": ["AE0", "L", "AE1", "D", "IH0", "N"],
    "aladeen": ["AE0", "L", "AH0", "D", "IY1", "N"],
    "alafi": ["AH0", "L", "AA1", "F", "IY0"],
    "alagappan": ["AA0", "L", "AH0", "G", "AA1", "P", "AH0", "N"],
    "alagem": ["AE1", "L", "AH0", "JH", "EH0", "M"],
    "alagna": ["AA0", "L", "AA1", "G", "N", "AH0"],
    "alagoas": ["AE1", "L", "AH0", "G", "OW2", "Z"],
    "alai": ["AH0", "L", "AY1"],
    "alaimo": ["AH0", "L", "EY1", "M", "OW0"],
    "alain": ["AH0", "L", "EY1", "N"],
    "alaine": ["AH0", "L", "EY1", "N"],
    "alair": ["AH0", "L", "EH1", "R"],
    "alam": ["AH0", "L", "AE1", "M"],
    "alamance": ["AE2", "L", "AH0", "M", "AE1", "N", "S"],
    "alamco": ["AH0", "L", "AE1", "M", "K", "OW0"],
    "alameda": ["AE2", "L", "AH0", "M", "IY1", "D", "AH0"],
    "alamein": ["AE1", "L", "AH0", "M", "EY2", "N"],
    "alamillo": ["AE2", "L", "AH0", "M", "IH1", "L", "OW0"],
    "alamito": ["AE2", "L", "AH0", "M", "IY1", "T", "OW0"],
    "alamitos": ["AE2", "L", "AH0", "M", "IY1", "T", "OW0", "S"],
    "alamo": ["AE1", "L", "AH0", "M", "OW0"],
    "alamodome": ["AE1", "L", "AH0", "M", "OW0", "D", "OW2", "M"],
    "alamos": ["AE1", "L", "AH0", "M", "OW0", "Z"],
    "alamosa": ["AE2", "L", "AH0", "M", "OW1", "S", "AH0"],
    "alamoud": ["AE1", "L", "AH0", "M", "UW2", "D"],
    "alamoudi": ["AE2", "L", "AA0", "M", "UW1", "D", "IY0"],
    "alan": ["AE1", "L", "AH0", "N"],
    "alan's": ["AE1", "L", "AH0", "N", "Z"],
    "alana": ["AA0", "L", "AE1", "N", "AH0"],
    "alanco": ["AH0", "L", "AE1", "N", "K", "OW0"],
    "aland": ["AE1", "L", "AH0", "N", "D"],
    "alane": ["AH0", "L", "EY1", "N"],
    "alanis": ["AA0", "L", "AA1", "N", "IH0", "S"],
    "alaniz": ["AE1", "L", "AH0", "N", "IH0", "Z"],
    "alann": ["AE1", "L", "AE0", "N"],
    "alanna": ["AA0", "L", "AA1", "N", "AH0"],
    "alar": ["EY1", "L", "AA2", "R"],
    "alarcon": ["AH0", "L", "AA1", "R", "K", "AA2", "N"],
    "alard": ["AH0", "L", "AA1", "R", "D"],
    "alaric": ["AE1", "L", "ER0", "IH0", "K"],
    "alarica": ["AA0", "L", "AA0", "R", "IY1", "K", "AH0"],
    "alarice": ["AA0", "L", "AA1", "R", "IH0", "S"],
    "alarid": ["AH0", "L", "EH1", "R", "IH0", "D"],
    "alarie": ["AH0", "L", "EH1", "R", "IY0"],
    "alarm": ["AH0", "L", "AA1", "R", "M"],
    "alarm's": ["AH0", "L", "AA1", "R", "M", "Z"],
    "alarmed": ["AH0", "L", "AA1", "R", "M", "D"],
    "alarming": ["AH0", "L", "AA1", "R", "M", "IH0", "NG"],
    "alarmingly": ["AH0", "L", "AA1", "R", "M", "IH0", "NG", "L", "IY0"],
    "alarmist": ["AH0", "L", "AA1", "R", "M", "IH0", "S", "T"],
    "alarmists": ["AH0", "L", "AA1", "R", "M", "IH0", "S", "T", "S"],
    "alarms": ["AH0", "L", "AA1", "R", "M", "Z"],
    "alaron": ["AH0", "L", "EH1", "R", "AH0", "N"],
    "alas": ["AH0", "L", "AE1", "S"],
    "alaska": ["AH0", "L", "AE1", "S", "K", "AH0"],
    "alaska's": ["AH0", "L", "AE1", "S", "K", "AH0", "Z"],
    "alaskamen": ["AH0", "L", "AE1", "S", "K", "AH0", "M", "AH0", "N"],
    "alaskan": ["AH0", "L", "AE1", "S", "K", "AH0", "N"],
    "alaskans": ["AH0", "L", "AE1", "S", "K", "AH0", "N", "Z"],
    "alastair": ["AE1", "L", "AH0", "S", "T", "EH2", "R"],
    "alaster": ["AE1", "L", "AH0", "S", "T", "ER0"],
    "alatas": ["AH0", "L", "AA1", "T", "AH0", "S"],
    "alatorre": ["AA0", "L", "AA0", "T", "AO1", "R", "IY0"],
    "alayne": ["AH0", "L", "EY1", "N"],
    "alba": ["AE1", "L", "B", "AH0"],
    "albach": ["AE1", "L", "B", "AA0", "K"],
    "albacore": ["AE1", "L", "B", "AH0", "K", "AO2", "R"],
    "alban": ["AA1", "L", "B", "AH0", "N"],
    "albanese": ["AA0", "L", "B", "AA0", "N", "EY1", "Z", "IY0"],
    "albani": ["AE0", "L", "B", "AA1", "N", "IY0"],
    "albani's": ["AE0", "L", "B", "AA1", "N", "IY0", "Z"],
    "albania": ["AE0", "L", "B", "EY1", "N", "IY0", "AH0"],
    "albania's": ["AE0", "L", "B", "EY1", "N", "IY0", "AH0", "Z"],
    "albanian": ["AE0", "L", "B", "EY1", "N", "IY0", "AH0", "N"],
    "albanians": ["AE0", "L", "B", "EY1", "N", "IY0", "AH0", "N", "Z"],
    "albank": ["AA0", "L", "B", "AE1", "NG", "K"],
    "albano": ["AA0", "L", "B", "AA1", "N", "OW0"],
    "albans": ["AE1", "L", "B", "AE0", "N", "Z"],
    "albany": ["AO1", "L", "B", "AH0", "N", "IY0"],
    "albany's": ["AO1", "L", "B", "AH0", "N", "IY0", "Z"],
    "albarado": ["AA0", "L", "B", "AA0", "R", "AA1", "D", "OW0"],
    "albarran": ["AE2", "L", "B", "AE1", "R", "AH0", "N"],
    "albashaun": ["AE1", "L", "B", "AH0", "SH", "AA2", "N"],
    "albatross": ["AE1", "L", "B", "AH0", "T", "R", "AA2", "S"],
    "albatrosses": ["AE1", "L", "B", "AH0", "T", "R", "AA2", "S", "IH0", "Z"],
    "albaugh": ["AH0", "L", "B", "AO1"],
    "albea": ["AE1", "L", "B", "IY0", "AH0"],
    "albee": ["AH0", "L", "B", "IY1"],
    "albeit": ["AO0", "L", "B", "IY1", "IH0", "T"],
    "albemarle": ["AE1", "L", "B", "AH0", "M", "AA2", "R", "L"],
    "alben": ["AO1", "L", "B", "AH0", "N"],
    "albendazole": ["AA2", "L", "B", "AH0", "N", "D", "AH0", "Z", "OW1", "L", "IY0"],
    "alber": ["AE1", "L", "B", "ER0"],
    "alberding": ["AE1", "L", "B", "ER0", "D", "IH0", "NG"],
    "alberg": ["AE1", "L", "B", "ER0", "G"],
    "albergo": ["AA0", "L", "B", "EH1", "R", "G", "OW0"],
    "alberico": ["AA0", "L", "B", "ER0", "IY1", "K", "OW0"],
    "albern": ["AE1", "L", "B", "ER0", "N"],
    "albers": ["AO1", "L", "B", "ER0", "Z"],
    "alberson": ["AE1", "L", "B", "ER0", "S", "AH0", "N"],
    "albert": ["AE1", "L", "B", "ER0", "T"],
    "albert's": ["AE1", "L", "B", "ER0", "T", "S"],
    "alberta": ["AE0", "L", "B", "ER1", "T", "AH0"],
    "alberthal": ["AE1", "L", "B", "ER0", "TH", "AO2", "L"],
    "alberti": ["AA0", "L", "B", "EH1", "R", "T", "IY0"],
    "albertina": ["AA0", "L", "B", "ER0", "T", "IY1", "N", "AH0"],
    "albertine": ["AE1", "L", "B", "ER0", "T", "IY2", "N"],
    "albertini": ["AA0", "L", "B", "ER0", "T", "IY1", "N", "IY0"],
    "alberto": ["AE0", "L", "B", "ER1", "T", "OW0"],
    "alberts": ["AE1", "L", "B", "ER0", "T", "S"],
    "albertsen": ["AE1", "L", "B", "ER0", "T", "S", "AH0", "N"],
    "albertson": ["AE1", "L", "B", "ER0", "T", "S", "AH0", "N"],
    "albertson's": ["AE1", "L", "B", "ER0", "T", "S", "AH0", "N", "Z"],
    "albertus": ["AE0", "L", "B", "ER1", "T", "AH0", "S"],
    "albertville": ["AE1", "L", "B", "ER0", "T", "V", "IH2", "L"],
    "alberty": ["AH0", "L", "B", "ER1", "T", "IY0"],
    "albie": ["AO1", "L", "B", "IY0"],
    "albin": ["AE1", "L", "B", "IH0", "N"],
    "albina": ["AA0", "L", "B", "IY1", "N", "AH0"],
    "albini": ["AA0", "L", "B", "IY1", "N", "IY0"],
    "albinia": ["AA0", "L", "B", "IY1", "N", "IY0", "AH0"],
    "albino": ["AE0", "L", "B", "AY1", "N", "OW2"],
    "albion": ["AE1", "L", "B", "IY0", "AH0", "N"],
    "albiric": ["AA0", "L", "B", "AY1", "R", "IH0", "K"],
    "albo": ["AE1", "L", "B", "OW0"],
    "albrecht": ["AO1", "L", "B", "R", "EH2", "K", "T"],
    "albright": ["AO1", "L", "B", "R", "AY2", "T"],
    "albright's": ["AO1", "L", "B", "R", "AY2", "T", "S"],
    "albrightsville": ["AO1", "L", "B", "R", "AY2", "T", "S", "V", "IH0", "L"],
    "albritton": ["AE1", "L", "B", "R", "IH0", "T", "AA0", "N"],
    "albro": ["AE1", "L", "B", "R", "OW0"],
    "albukhari": ["AA0", "L", "B", "Y", "UW0", "K", "AA1", "R", "IY0"],
    "album": ["AE1", "L", "B", "AH0", "M"],
    "album's": ["AE1", "L", "B", "AH0", "M", "Z"],
    "albumin": ["AE0", "L", "B", "Y", "UW1", "M", "AH0", "N"],
    "albums": ["AE1", "L", "B", "AH0", "M", "Z"],
    "albunex": ["AE2", "L", "B", "Y", "UW1", "N", "EH0", "K", "S"],
    "albuquerque": ["AE1", "L", "B", "AH0", "K", "ER0", "K", "IY0"],
    "albury": ["AE1", "L", "B", "EH0", "R", "IY0"],
    "albus": ["AE1", "L", "B", "AH0", "S"],
    "albuterol": ["AE2", "L", "B", "Y", "UW1", "T", "ER0", "AO0", "L"],
    "alcala": ["AA0", "L", "K", "AA1", "L", "AH0"],
    "alcan": ["AE1", "L", "K", "AE2", "N"],
    "alcan's": ["AE1", "L", "K", "AE2", "N", "Z"],
    "alcantar": ["AE2", "L", "K", "AE1", "N", "T", "ER0"],
    "alcantara": ["AA0", "L", "K", "AA0", "N", "T", "AA1", "R", "AH0"],
    "alcaraz": ["AA0", "L", "K", "AA1", "R", "AA0", "Z"],
    "alcasa": ["AE0", "L", "K", "AA1", "S", "AH0"],
    "alcatel": ["AE1", "L", "K", "AH0", "T", "EH2", "L"],
    "alcatel's": ["AE1", "L", "K", "AH0", "T", "EH2", "L", "Z"],
    "alcatraz": ["AE1", "L", "K", "AH0", "T", "R", "AE2", "Z"],
    "alcazar": ["AA1", "L", "K", "AH0", "Z", "AA2", "R"],
    "alcee": ["AE1", "L", "S", "IY0"],
    "alcester": ["AA1", "L", "CH", "EH0", "S", "T", "ER0"],
    "alchemically": ["AE0", "L", "K", "EH1", "M", "AH0", "K", "L", "IY0"],
    "alchemist": ["AA1", "L", "K", "AH0", "M", "IH0", "S", "T"],
    "alchemy": ["AE1", "L", "K", "AH0", "M", "IY0"],
    "alcide": ["AE1", "L", "S", "AY2", "D"],
    "alcids": ["AE1", "L", "S", "IH0", "D", "Z"],
    "alcina": ["AA0", "L", "CH", "IY1", "N", "AH0"],
    "alco": ["AE1", "L", "K", "OW0"],
    "alco's": ["AE1", "L", "K", "OW0", "Z"],
    "alcoa": ["AE1", "L", "K", "OW0", "AH0"],
    "alcoa's": ["AE0", "L", "K", "OW1", "AH0", "Z"],
    "alcocer": ["AH0", "L", "K", "OW1", "S", "ER0"],
    "alcock": ["AH0", "L", "K", "AA1", "K"],
    "alcohol": ["AE1", "L", "K", "AH0", "HH", "AA2", "L"],
    "alcohol-drenched": ["AE1", "L", "K", "AH0", "HH", "AA2", "L", "D", "R", "EH1", "N", "CH", "T"],
    "alcoholic": ["AE2", "L", "K", "AH0", "HH", "AA1", "L", "IH0", "K"],
    "alcoholics": ["AE2", "L", "K", "AH0", "HH", "AA1", "L", "IH0", "K", "S"],
    "alcoholism": ["AE1", "L", "K", "AH0", "HH", "AO2", "L", "IH2", "Z", "AH0", "M"],
    "alcohols": ["AE1", "L", "K", "AH0", "HH", "AA2", "L", "Z"],
    "alcon": ["AH0", "L", "K", "AA1", "N"],
    "alcorn": ["AA0", "L", "K", "AO1", "R", "N"],
    "alcorta": ["AA0", "L", "K", "AO1", "R", "T", "AH0"],
    "alcott": ["AE1", "L", "K", "AA2", "T"],
    "alcove": ["AE1", "L", "K", "OW2", "V"],
    "alcoves": ["AE1", "L", "K", "OW2", "V", "Z"],
    "alda": ["AA1", "L", "D", "AH0"],
    "aldaco": ["AA0", "L", "D", "AA1", "K", "OW0"],
    "aldama": ["AA0", "L", "D", "AA1", "M", "AH0"],
    "aldana": ["AA0", "L", "D", "AE1", "N", "AH0"],
    "aldape": ["AA0", "L", "D", "AA1", "P", "EY0"],
    "alday": ["AE1", "L", "D", "EY0"],
    "aldebaran": ["AE0", "L", "D", "EH1", "B", "ER0", "AH0", "N"],
    "aldeburgh": ["AE1", "L", "D", "B", "ER2", "G"],
    "alden": ["AA1", "L", "D", "AH0", "N"],
    "aldenville": ["AA1", "L", "D", "AH0", "N", "V", "IH0", "L"],
    "alder": ["AO1", "L", "D", "ER0"],
    "aldercy": ["AH0", "L", "D", "ER1", "K", "IY0"],
    "alderete": ["AE1", "L", "D", "ER0", "IY0", "T"],
    "alderfer": ["AE1", "L", "D", "ER0", "F", "ER0"],
    "alderidge": ["AA1", "L", "D", "R", "IH0", "JH"],
    "alderman": ["AE1", "L", "D", "ER0", "M", "AH0", "N"],
    "aldermen": ["AO1", "L", "D", "ER0", "M", "IH0", "N"],
    "alderson": ["AE1", "L", "D", "ER0", "S", "AH0", "N"],
    "alderton": ["AO1", "L", "D", "ER0", "T", "AH0", "N"],
    "aldi": ["AA1", "L", "D", "IY0"],
    "aldicarb": ["AO1", "L", "D", "IH0", "K", "AA2", "R", "B"],
    "aldila": ["AE2", "L", "D", "IH1", "L", "AH0"],
    "aldin": ["AA0", "L", "D", "IY1", "N"],
    "aldinger": ["AO1", "L", "D", "IH0", "NG", "ER0"],
    "aldis": ["AA1", "L", "D", "IH0", "S"],
    "aldo": ["AA1", "L", "D", "OW0"],
    "aldora": ["AA0", "L", "D", "AO1", "R", "AH0"],
    "aldous": ["AA1", "L", "D", "AH0", "S"],
    "aldred": ["AO1", "L", "D", "R", "EH0", "D"],
    "aldredge": ["AO1", "L", "D", "R", "EH0", "JH"],
    "aldrete": ["AO1", "L", "D", "R", "IY0", "T"],
    "aldric": ["AO1", "L", "D", "R", "IH0", "K"],
    "aldrich": ["AO1", "L", "D", "R", "IH0", "CH"],
    "aldrich's": ["AO1", "L", "D", "R", "IH0", "CH", "AH0", "Z"],
    "aldridge": ["AO1", "L", "D", "R", "IH0", "JH"],
    "aldrin": ["AO1", "L", "D", "R", "IH0", "N"],
    "aldrin's": ["AO1", "L", "D", "R", "IH0", "N", "Z"],
    "aldus": ["AA1", "L", "D", "IH0", "S"],
    "aldus's": ["AA1", "L", "D", "IH0", "S", "IH0", "Z"],
    "aldwin": ["AO1", "L", "D", "W", "IH0", "N"],
    "aldwyn": ["AO1", "L", "D", "W", "IH0", "N"],
    "aldys": ["AA1", "L", "D", "IY0", "Z"],
    "ale": ["EY1", "L"],
    "aleatory": ["EY1", "L", "IY0", "AH0", "T", "AO2", "R", "IY0"],
    "alec": ["AE1", "L", "IH0", "K"],
    "aleda": ["AA0", "L", "EY1", "D", "AH0"],
    "aledo": ["AH0", "L", "IY1", "D", "OW0"],
    "aleen": ["AH0", "L", "IY1", "N"],
    "alegre": ["AA0", "L", "EH1", "G", "R", "IY0"],
    "alegrett": ["AE1", "L", "AH0", "G", "R", "AH0", "T"],
    "alegria": ["AH0", "L", "EH1", "G", "R", "IY0", "AH0"],
    "alehouse": ["EY1", "L", "HH", "AW2", "S"],
    "aleichem": ["AH0", "L", "EY1", "HH", "EH0", "M"],
    "alejandre": ["AA0", "L", "EY0", "Y", "AA1", "N", "D", "R", "EY0"],
    "alejandro": ["AA0", "L", "EY0", "HH", "AA1", "N", "D", "R", "OW0"],
    "alejo": ["AA0", "L", "EY1", "Y", "OW0"],
    "alejos": ["AA0", "L", "EY1", "Y", "OW0", "Z"],
    "aleksander": ["AE2", "L", "AH0", "K", "S", "AE1", "N", "D", "ER0"],
    "aleksandr": ["AE2", "L", "AH0", "K", "S", "AE1", "N", "D", "ER0"],
    "alem": ["AH0", "L", "EH1", "M"],
    "aleman": ["EY1", "L", "M", "AH0", "N"],
    "alena": ["AA0", "L", "EY1", "N", "AH0"],
    "alendrin": ["AH0", "L", "EH1", "N", "D", "R", "IH0", "N"],
    "alene": ["AH0", "L", "IY1", "N"],
    "alenia": ["AH0", "L", "IY1", "N", "IY0", "AH0"],
    "aleo": ["AA1", "L", "IY0", "OW0"],
    "aleph": ["AA1", "L", "AH0", "F"],
    "aleria": ["AH0", "L", "IY1", "R", "IY0", "AH0"],
    "aleron": ["AA0", "L", "EH0", "R", "AO1", "N"],
    "alert": ["AH0", "L", "ER1", "T"],
    "alerted": ["AH0", "L", "ER1", "T", "IH0", "D"],
    "alerting": ["AH0", "L", "ER1", "T", "IH0", "NG"],
    "alertly": ["AH0", "L", "ER1", "T", "L", "IY0"],
    "alertness": ["AH0", "L", "ER1", "T", "N", "AH0", "S"],
    "alerts": ["AH0", "L", "ER1", "T", "S"],
    "ales": ["EY1", "L", "Z"],
    "aleshire": ["AA0", "L", "EY0", "SH", "IH1", "R", "EY0"],
    "alesi": ["AA0", "L", "EH1", "S", "IY0"],
    "alessandra": ["AE2", "L", "EH0", "S", "AE1", "N", "D", "R", "AA0"],
    "alessandra's": ["AE2", "L", "EH0", "S", "AE1", "N", "D", "R", "AH0", "Z"],
    "alessandrini": ["AA2", "L", "EH0", "S", "AA0", "N", "D", "R", "IY1", "N", "IY2"],
    "alessandro": ["AA0", "L", "AH0", "S", "AE1", "N", "D", "R", "OW0"],
    "alessi": ["AH0", "L", "EY1", "S", "IY0"],
    "alessio": ["AH0", "L", "EH1", "S", "IY0", "OW0"],
    "aleta": ["AA0", "L", "EH1", "T", "AH0"],
    "aletha": ["AH0", "L", "IY1", "TH", "AH0"],
    "alethea": ["AE2", "L", "AH0", "TH", "IY1", "AH0"],
    "aletti": ["AH0", "L", "EH1", "T", "IY0"],
    "aleutian": ["AH0", "L", "UW1", "SH", "AH0", "N"],
    "aleutians": ["AH0", "L", "UW1", "SH", "AH0", "N", "Z"],
    "aleve": ["AH0", "L", "IY1", "V"],
    "alewife": ["EY1", "L", "W", "AY2", "F"],
    "alewine": ["EY1", "L", "W", "AY2", "N"],
    "alewives": ["EY1", "L", "W", "AY2", "V", "Z"],
    "alex": ["AE1", "L", "AH0", "K", "S"],
    "alex's": ["AE1", "L", "AH0", "K", "S", "IH0", "Z"],
    "alexa": ["AH0", "L", "EH1", "K", "S", "AH0"],
    "alexander": ["AE2", "L", "IH0", "G", "Z", "AE1", "N", "D", "ER0"],
    "alexander's": ["AE2", "L", "IH0", "G", "Z", "AE1", "N", "D", "ER0", "Z"],
    "alexanders": ["AE2", "L", "IH0", "G", "Z", "AE1", "N", "D", "ER0", "Z"],
    "alexandra": ["AE2", "L", "IH0", "G", "Z", "AE1", "N", "D", "R", "AH0"],
    "alexandre": ["AE0", "L", "IH0", "K", "S", "AA1", "N", "D", "ER0"],
    "alexandria": ["AE2", "L", "AH0", "G", "Z", "AE1", "N", "D", "R", "IY0", "AH0"],
    "alexandrine": ["AE2", "L", "AH0", "G", "Z", "AE1", "N", "D", "R", "IY0", "N"],
    "alexandrines": ["AE2", "L", "AH0", "G", "Z", "AE1", "N", "D", "R", "IY0", "N", "Z"],
    "alexandrov": ["AE2", "L", "AH0", "G", "Z", "AE1", "N", "D", "R", "AH0", "V"],
    "alexei": ["AH0", "L", "EH1", "K", "S", "EY2"],
    "alexi": ["AH0", "L", "EH1", "K", "S", "IY0"],
    "alexi's": ["AH0", "L", "EH1", "K", "S", "IY0", "Z"],
    "alexia": ["AH0", "L", "EH1", "K", "S", "IY0", "AH0"],
    "alexine": ["AH0", "L", "EH1", "K", "S", "AY0", "N"],
    "alexis": ["AH0", "L", "EH1", "K", "S", "IH0", "S"],
    "alexopoulos": ["AE0", "L", "IH0", "G", "Z", "AA1", "P", "AH0", "L", "IH0", "S"],
    "alexs": ["AE1", "L", "AH0", "K", "S"],
    "alexy": ["AH0", "L", "EH1", "K", "S", "IY0"],
    "aley": ["EY1", "L", "IY0"],
    "alf": ["AE1", "L", "F"],
    "alfa": ["AE1", "L", "F", "AH0"],
    "alfa's": ["AE1", "L", "F", "AH0", "Z"],
    "alfalfa": ["AE2", "L", "F", "AE1", "L", "F", "AH0"],
    "alfano": ["AA0", "L", "F", "AA1", "N", "OW0"],
    "alfareda": ["AE2", "L", "F", "AH0", "R", "EH1", "D", "AH0"],
    "alfaro": ["AA0", "L", "F", "AA1", "R", "OW0"],
    "alfavilli": ["AE2", "L", "F", "AH0", "V", "IH1", "L", "IY0"],
    "alfie": ["AE1", "L", "F", "IY0"],
    "alfieri": ["AA0", "L", "F", "IH1", "R", "IY0"],
    "alfiero": ["AE2", "L", "F", "IY0", "EH1", "R", "OW0"],
    "alfin": ["AE1", "L", "F", "IH0", "N"],
    "alfin's": ["AE1", "L", "F", "IH0", "N", "Z"],
    "alfono": ["AE0", "L", "F", "OW1", "N", "OW0"],
    "alfons": ["AA1", "L", "F", "OW0", "N", "Z"],
    "alfonse": ["AE1", "L", "F", "AO0", "N", "S"],
    "alfonsin": ["AE2", "L", "F", "AA1", "N", "S", "IH0", "N"],
    "alfonsin's": ["AE2", "L", "F", "AA1", "N", "S", "IH0", "N", "Z"],
    "alfonsine": ["AA0", "L", "F", "OW0", "N", "S", "IY1", "N", "IY0"],
    "alfonso": ["AE2", "L", "F", "AA1", "N", "S", "OW0"],
    "alfonzo": ["AE2", "L", "F", "AA1", "N", "Z", "OW0"],
    "alford": ["AE1", "L", "F", "ER0", "D"],
    "alfre": ["AE1", "L", "F", "R", "IY2"],
    "alfred": ["AE1", "L", "F", "R", "IH0", "D"],
    "alfredo": ["AE2", "L", "F", "R", "EY1", "D", "OW0"],
    "alfredson": ["AE1", "L", "F", "R", "IH0", "D", "S", "AH0", "N"],
    "alfredsson": ["AE1", "L", "F", "R", "IH0", "D", "S", "AH0", "N"],
    "alfrey": ["AE1", "L", "F", "R", "IY0"],
    "algae": ["AE1", "L", "JH", "IY0"],
    "algal": ["AE1", "L", "G", "AH0", "L"],
    "algamaa": ["AE0", "L", "G", "AA1", "M", "AH0"],
    "algar": ["AA0", "L", "G", "AA1", "R"],
    "algarin": ["AE1", "L", "G", "ER0", "IH0", "N"],
    "algata": ["AE0", "L", "G", "AA1", "T", "AH0"],
    "algebra": ["AE1", "L", "JH", "AH0", "B", "R", "AH0"],
    "algebraic": ["AE2", "L", "JH", "AH0", "B", "R", "EY1", "IH0", "K"],
    "algebraically": ["AE2", "L", "JH", "AH0", "B", "R", "EY1", "IH0", "K", "L", "IY0"],
    "algemene": ["AE1", "L", "G", "AH0", "M", "IY2", "N"],
    "algeo": ["AE1", "L", "JH", "IY0", "OW0"],
    "alger": ["AE1", "L", "JH", "ER0"],
    "algeria": ["AE0", "L", "JH", "IH1", "R", "IY0", "AH0"],
    "algeria's": ["AE0", "L", "JH", "IY1", "R", "IY0", "AH0", "Z"],
    "algerian": ["AE0", "L", "JH", "IH1", "R", "IY0", "AH0", "N"],
    "algerians": ["AE0", "L", "JH", "IY1", "R", "IY0", "AH0", "N", "Z"],
    "algernon": ["AE1", "L", "JH", "ER0", "N", "AA0", "N"],
    "algie": ["AO1", "L", "G", "IY0"],
    "algiers": ["AE0", "L", "JH", "IH1", "R", "Z"],
    "algodones": ["AA2", "G", "AH0", "D", "OW1", "N", "AH0", "Z"],
    "algol": ["AE1", "L", "G", "AA0", "L"],
    "algom": ["AE1", "L", "G", "AH0", "M"],
    "algoma": ["AE0", "L", "G", "OW1", "M", "AH0"],
    "algonquian": ["AE0", "L", "G", "AA1", "NG", "K", "IY0", "AH0", "N"],
    "algonquin": ["AE0", "L", "G", "AA1", "NG", "K", "W", "IH0", "N"],
    "algorithm": ["AE1", "L", "G", "ER0", "IH2", "DH", "AH0", "M"],
    "algorithmic": ["AE1", "L", "G", "ER0", "IH2", "DH", "AH0", "M", "IH0", "K"],
    "algorithms": ["AE1", "L", "G", "ER0", "IH2", "DH", "AH0", "M", "Z"],
    "alguire": ["AA0", "L", "G", "W", "IH1", "R", "EY0"],
    "algy": ["AE1", "L", "JH", "IY0"],
    "alhadeff": ["AE1", "L", "AH0", "D", "EH0", "F"],
    "alhambra": ["AE0", "L", "HH", "AE1", "M", "B", "R", "AH0"],
    "alhausie": ["AE0", "L", "HH", "AW1", "S", "IY0"],
    "ali": ["AA1", "L", "IY0"],
    "ali's": ["AA1", "L", "IY0", "Z"],
    "ali-reza": ["AA1", "L", "IY0", "R", "EH1", "Z", "AH0"],
    "aliano": ["AA0", "L", "IY0", "AA1", "N", "OW0"],
    "alianza": ["AE2", "L", "IY0", "AE1", "N", "Z", "AH0"],
    "alias": ["EY1", "L", "IY0", "AH0", "S"],
    "aliases": ["EY1", "L", "IY0", "AH0", "S", "IH0", "Z"],
    "aliberti": ["AA0", "L", "IY0", "B", "EH1", "R", "T", "IY0"],
    "alibi": ["AE1", "L", "AH0", "B", "AY2"],
    "alibis": ["AE1", "L", "AH0", "B", "AY2", "Z"],
    "alibrandi": ["AE2", "L", "IH0", "B", "R", "AE1", "N", "D", "IY0"],
    "alice": ["AE1", "L", "IH0", "S"],
    "alice's": ["AE1", "L", "AH0", "S", "AH0", "Z"],
    "alicea": ["AH0", "L", "IH1", "S", "IY0", "AH0"],
    "alices": ["AE1", "L", "AH0", "S", "AH0", "Z"],
    "alicia": ["AH0", "L", "IH1", "SH", "AH0"],
    "alicia's": ["AH0", "L", "IH1", "SH", "AH0", "Z"],
    "alida": ["AA0", "L", "IY1", "D", "AH0"],
    "alie": ["AE1", "L", "IY0"],
    "alien": ["EY1", "L", "IY0", "AH0", "N"],
    "alienate": ["EY1", "L", "Y", "AH0", "N", "EY2", "T"],
    "alienated": ["EY1", "L", "IY0", "AH0", "N", "EY2", "T", "IH0", "D"],
    "alienates": ["EY1", "L", "IY0", "AH0", "N", "EY2", "T", "S"],
    "alienating": ["EY1", "L", "IY0", "AH0", "N", "EY2", "T", "IH0", "NG"],
    "alienation": ["EY2", "L", "IY0", "AH0", "N", "EY1", "SH", "AH0", "N"],
    "aliens": ["EY1", "L", "IY0", "AH0", "N", "Z"],
    "aliff": ["AE1", "L", "IH0", "F"],
    "alig": ["AE1", "L", "IH0", "G"],
    "alight": ["AH0", "L", "AY1", "T"],
    "align": ["AH0", "L", "AY1", "N"],
    "aligned": ["AH0", "L", "AY1", "N", "D"],
    "aligning": ["AH0", "L", "AY1", "N", "IH0", "NG"],
    "alignment": ["AH0", "L", "AY1", "N", "M", "AH0", "N", "T"],
    "alignments": ["AH0", "L", "AY1", "N", "M", "AH0", "N", "T", "S"],
    "aligns": ["AH0", "L", "AY1", "N", "Z"],
    "alihan": ["AE1", "L", "IH0", "HH", "AE2", "N"],
    "alija": ["AH0", "L", "AY1", "JH", "AH0"],
    "alija's": ["AH0", "L", "AY1", "JH", "AH0", "Z"],
    "alike": ["AH0", "L", "AY1", "K"],
    "alikes": ["AH0", "L", "AY1", "K", "S"],
    "alima": ["AA0", "L", "IY1", "M", "AH0"],
    "alimenies": ["AE1", "L", "IH0", "M", "EH2", "N", "IY0", "Z"],
    "alimentary": ["AE2", "L", "AH0", "M", "EH1", "N", "T", "ER0", "IY0"],
    "alimony": ["AE1", "L", "AH0", "M", "OW2", "N", "IY0"],
    "alina": ["AH0", "L", "IY1", "N", "AH0"],
    "aline": ["AH0", "L", "AY1", "N"],
    "alines": ["AH0", "L", "AY1", "N", "Z"],
    "alioto": ["AA0", "L", "IY0", "OW1", "T", "OW0"],
    "aliquippa": ["AE2", "L", "AH0", "K", "W", "IH1", "P", "AH0"],
    "aliquippa's": ["AE2", "L", "AH0", "K", "W", "IH1", "P", "AH0", "Z"],
    "aliquippas": ["AE2", "L", "AH0", "K", "W", "IH1", "P", "AH0", "Z"],
    "alire": ["AA0", "L", "IH1", "R", "EY0"],
    "alirio": ["AH0", "L", "IH1", "R", "IY0", "OW0"],
    "alisa": ["AH0", "L", "IY1", "S", "AH0"],
    "alisha": ["AA0", "L", "IY1", "SH", "AH0"],
    "alisky": ["AH0", "L", "IH1", "S", "K", "IY0"],
    "alislamiyya": ["AE2", "L", "AH0", "S", "L", "AH0", "M", "IY1", "AH0"],
    "alison": ["AE1", "L", "IH0", "S", "AH0", "N"],
    "alissa": ["AH0", "L", "IH1", "S", "AH0"],
    "alistair": ["AE1", "L", "IH0", "S", "T", "EH2", "R"],
    "alister": ["AE1", "L", "IH0", "S", "T", "ER0"],
    "alita": ["AA0", "L", "IY1", "T", "AH0"],
    "alitalia": ["AE2", "L", "IH0", "T", "AE1", "L", "IY0", "AH0"],
    "alitalia's": ["AE2", "L", "IH0", "T", "AE1", "L", "IY0", "AH0", "Z"],
    "alithia": ["AH0", "L", "IH1", "TH", "IY0", "AH0"],
    "alito": ["AH0", "L", "IY1", "T", "OW0"],
    "alive": ["AH0", "L", "AY1", "V"],
    "alix": ["AE1", "L", "IH0", "K", "S"],
    "aliyah": ["AH0", "L", "IY1", "AH0"],
    "alizac": ["AE1", "L", "IH0", "Z", "AE0", "K"],
    "alka": ["AE1", "L", "K", "AH0"],
    "alkahest": ["AE1", "L", "K", "AH0", "HH", "EH2", "S", "T"],
    "alkali": ["AE1", "L", "K", "AH0", "L", "AY2"],
    "alkalies": ["AE1", "L", "K", "AH0", "L", "AY2", "Z"],
    "alkaline": ["AE1", "L", "K", "AH0", "L", "AY2", "N"],
    "alkalinity": ["AE2", "L", "K", "AH0", "L", "IH1", "N", "AH0", "T", "IY0"],
    "alkaloid": ["AE1", "L", "K", "AH0", "L", "OY2", "D"],
    "alkaloidal": ["AE0", "L", "K", "AH0", "L", "OY1", "D", "AH0", "L"],
    "alkaloids": ["AE1", "L", "K", "AH0", "L", "OY2", "D", "Z"],
    "alkanes": ["AE1", "L", "K", "EY2", "N", "Z"],
    "alkema": ["AE1", "L", "K", "IH0", "M", "AH0"],
    "alkene": ["AE1", "L", "K", "IY2", "N"],
    "alkenes": ["AE1", "L", "K", "IY2", "N", "Z"],
    "alkermes": ["AA0", "L", "K", "ER1", "M", "IY0", "Z"],
    "alkire": ["AH0", "L", "K", "AY1", "R"],
    "all": ["AO1", "L"],
    "all's": ["AO1", "L", "Z"],
    "all-out": ["AO1", "L", "AW1", "T"],
    "all-purpose": ["AO1", "L", "P", "ER1", "P", "AH0", "S"],
    "all-star": ["AO2", "L", "S", "T", "AA1", "R"],
    "all-time": ["AO2", "L", "T", "AY1", "M"],
    "alla": ["AA1", "L", "AH0"],
    "allah": ["AA1", "L", "AH0"],
    "allahabad": ["AH0", "L", "AA1", "HH", "AH0", "B", "AA2", "D"],
    "allain": ["AH0", "L", "EY1", "N"],
    "allaire": ["AA0", "L", "EH1", "R"],
    "allais": ["EY1", "L", "IY0", "AH0", "S"],
    "allamuchy": ["AA2", "L", "AH0", "M", "UW1", "CH", "IY0"],
    "allan": ["AE1", "L", "AH0", "N"],
    "allante": ["AE2", "L", "AA1", "N", "T", "EY0"],
    "allar": ["AH0", "L", "AA1", "R"],
    "allard": ["AE1", "L", "ER0", "D"],
    "allardt": ["AE1", "L", "ER0", "T"],
    "allay": ["AH0", "L", "EY1"],
    "allayed": ["AH0", "L", "EY1", "D"],
    "allaying": ["AH0", "L", "EY1", "IH0", "NG"],
    "allays": ["AH0", "L", "EY1", "Z"],
    "allbaugh": ["AH0", "L", "B", "AO1"],
    "allbee": ["AO1", "L", "B", "IY2"],
    "allbright": ["AO1", "L", "B", "R", "AY2", "T"],
    "allbritten": ["AE1", "L", "B", "R", "IH0", "T", "AH0", "N"],
    "allbritton": ["AE1", "L", "B", "R", "IH0", "T", "AA0", "N"],
    "allcock": ["AO1", "L", "K", "AA2", "K"],
    "allcorn": ["AH0", "L", "K", "AO1", "R", "N"],
    "allday": ["AO1", "L", "D", "EY2"],
    "allderdice": ["AE1", "L", "D", "ER0", "D", "AY2", "S"],
    "alldredge": ["AH0", "L", "D", "R", "EH1", "JH"],
    "allebach": ["AE1", "L", "B", "AA0", "K"],
    "alleco": ["AE2", "L", "EH1", "K", "OW0"],
    "allee": ["AH0", "L", "IY1"],
    "allegation": ["AE2", "L", "AH0", "G", "EY1", "SH", "AH0", "N"],
    "allegations": ["AE2", "L", "AH0", "G", "EY1", "SH", "AH0", "N", "Z"],
    "allege": ["AH0", "L", "EH1", "JH"],
    "alleged": ["AH0", "L", "EH1", "JH", "D"],
    "allegedly": ["AH0", "L", "EH1", "JH", "AH0", "D", "L", "IY0"],
    "alleges": ["AH0", "L", "EH1", "JH", "IH0", "Z"],
    "alleghany": ["AE1", "L", "AH0", "G", "EY2", "N", "IY0"],
    "alleghenies": ["AE1", "L", "AH0", "G", "EH2", "N", "IY0", "Z"],
    "allegheny": ["AE1", "L", "AH0", "G", "EH2", "N", "IY0"],
    "allegheny's": ["AE1", "L", "AH0", "G", "EH2", "N", "IY0", "Z"],
    "allegiance": ["AH0", "L", "IY1", "JH", "AH0", "N", "S"],
    "allegiances": ["AH0", "L", "IY1", "JH", "AH0", "N", "S", "IH0", "Z"],
    "alleging": ["AH0", "L", "EH1", "JH", "IH0", "NG"],
    "allegis": ["AE2", "L", "EY1", "JH", "IH0", "S"],
    "allegis'": ["AE2", "L", "EY1", "JH", "IH0", "S"],
    "allegis's": ["AE2", "L", "EY1", "JH", "IH0", "S", "IH0", "Z"],
    "allegorical": ["AE2", "L", "AH0", "G", "AO1", "R", "AH0", "K", "AH0", "L"],
    "allegories": ["AE1", "L", "AH0", "G", "AO2", "R", "IY0", "Z"],
    "allegory": ["AE1", "L", "AH0", "G", "AO2", "R", "IY0"],
    "allegra": ["AA0", "L", "EH1", "G", "R", "AH0"],
    "allegretti": ["AA0", "L", "EH0", "G", "R", "EH1", "T", "IY0"],
    "allegro": ["AH0", "L", "EH1", "G", "R", "OW2"],
    "allele": ["AH0", "L", "EH1", "L", "IY0"],
    "alleles": ["AH0", "L", "EH1", "L", "IY0", "Z"],
    "allelic": ["AH0", "L", "EH1", "L", "IH0", "K"],
    "alleluia": ["AE2", "L", "EH0", "L", "UW1", "Y", "AA0"],
    "alleluja": ["AE2", "L", "EH0", "L", "UW1", "Y", "AA0"],
    "alleman": ["EY1", "L", "M", "AH0", "N"],
    "allemand": ["AE1", "L", "IH0", "M", "AH0", "N", "D"],
    "allen": ["AE1", "L", "AH0", "N"],
    "allen's": ["AE1", "L", "AH0", "N", "Z"],
    "allenbaugh": ["AH0", "L", "EH1", "N", "B", "AO0"],
    "allenby": ["AE1", "L", "AH0", "N", "B", "IY0"],
    "allenby's": ["AE1", "L", "AH0", "N", "B", "IY0", "Z"],
    "allendale": ["AE1", "L", "AH0", "N", "D", "EY2", "L"],
    "allende": ["AA2", "Y", "EH1", "N", "D", "EY0"],
    "allender": ["AA0", "L", "EH1", "N", "D", "ER0"],
    "allendorf": ["AE1", "L", "IH0", "N", "D", "AO0", "R", "F"],
    "allene": ["AE1", "L", "IY2", "N"],
    "allenhurst": ["AE1", "L", "AH0", "N", "HH", "ER2", "S", "T"],
    "allens": ["AE1", "L", "AH0", "N", "Z"],
    "allensbach": ["AE1", "L", "AH0", "N", "Z", "B", "AA2", "K"],
    "allensworth": ["AE1", "L", "AH0", "N", "Z", "W", "ER0", "TH"],
    "allenton": ["AE1", "L", "AH0", "N", "T", "AH0", "N"],
    "allentown": ["AE1", "L", "AH0", "N", "T", "AW2", "N"],
    "allenwood": ["AE1", "L", "AH0", "N", "W", "UH2", "D"],
    "aller": ["AO1", "L", "ER0"],
    "allergan": ["AE1", "L", "ER0", "JH", "AH0", "N"],
    "allergen": ["AE1", "L", "ER0", "JH", "AH0", "N"],
    "allergenic": ["AE1", "L", "ER0", "JH", "AH0", "N", "IH0", "K"],
    "allergens": ["AE1", "L", "ER0", "JH", "AH0", "N", "Z"],
    "allergic": ["AH0", "L", "ER1", "JH", "IH0", "K"],
    "allergies": ["AE1", "L", "ER0", "JH", "IY0", "Z"],
    "allergist": ["AE1", "L", "ER0", "JH", "AH0", "S", "T"],
    "allergist's": ["AE1", "L", "ER0", "JH", "AH0", "S", "T", "S"],
    "allergists": ["AE1", "L", "ER0", "JH", "AH0", "S", "T", "S"],
    "allergy": ["AE1", "L", "ER0", "JH", "IY0"],
    "allers": ["AO1", "L", "ER0", "Z"],
    "allert": ["AE1", "L", "ER0", "T"],
    "allerton": ["AE1", "L", "ER0", "T", "AH0", "N"],
    "alles": ["EY1", "L", "Z"],
    "alleva": ["AA0", "L", "EY1", "V", "AH0"],
    "alleviate": ["AH0", "L", "IY1", "V", "IY0", "EY2", "T"],
    "alleviated": ["AH0", "L", "IY1", "V", "IY0", "EY2", "T", "IH0", "D"],
    "alleviates": ["AH0", "L", "IY1", "V", "IY0", "EY0", "T", "S"],
    "alleviating": ["AH0", "L", "IY1", "V", "IY0", "EY2", "T", "IH0", "NG"],
    "alleviation": ["AH0", "L", "IY2", "V", "IY0", "EY1", "SH", "AH0", "N"],
    "alley": ["AE1", "L", "IY0"],
    "alley's": ["AE1", "L", "IY0", "Z"],
    "alleyne": ["AE1", "L", "EY2", "N"],
    "alleyoop": ["AE0", "L", "IY0", "UW1", "P"],
    "alleys": ["AE1", "L", "IY0", "Z"],
    "alleyway": ["AE1", "L", "IY0", "W", "EY2"],
    "alleyways": ["AE1", "L", "IY0", "W", "EY2", "Z"],
    "allgaier": ["AE1", "L", "G", "AY0", "ER0"],
    "allgeier": ["AE1", "L", "G", "AY0", "ER0"],
    "allgemeine": ["AO1", "L", "G", "AH0", "M", "AY2", "N"],
    "allgemeines": ["AO1", "L", "G", "AH0", "M", "AY2", "N", "Z"],
    "allgeyer": ["AE1", "L", "G", "IY0", "ER0"],
    "allgood": ["AO1", "L", "G", "UH2", "D"],
    "alli": ["AE1", "L", "IY0"],
    "alliance": ["AH0", "L", "AY1", "AH0", "N", "S"],
    "alliance's": ["AH0", "L", "AY1", "AH0", "N", "S", "IH0", "Z"],
    "alliances": ["AH0", "L", "AY1", "AH0", "N", "S", "IH0", "Z"],
    "alliant": ["AH0", "L", "AY1", "AH0", "N", "T"],
    "alliant's": ["AH0", "L", "AY1", "AH0", "N", "T", "S"],
    "allianz": ["AE1", "L", "IY0", "AH0", "N", "Z"],
    "allianz's": ["AE1", "L", "IY0", "AH0", "N", "Z", "IH0", "Z"],
    "allick": ["AE1", "L", "IH0", "K"],
    "allie": ["AE1", "L", "IY0"],
    "allied": ["AE1", "L", "AY2", "D"],
    "allied's": ["AE1", "L", "AY2", "D", "Z"],
    "alliedsignal": ["AE1", "L", "AY2", "D", "S", "IH1", "G", "N", "AH0", "L"],
    "alliedsignal's": ["AE1", "L", "AY2", "D", "S", "IH1", "G", "N", "AH0", "L", "Z"],
    "allies": ["AH0", "L", "AY1", "Z"],
    "allies'": ["AE1", "L", "AY0", "Z"],
    "alligator": ["AE1", "L", "AH0", "G", "EY2", "T", "ER0"],
    "alligators": ["AE1", "L", "AH0", "G", "EY2", "T", "ER0", "Z"],
    "alligood": ["AE1", "L", "IH0", "G", "UH2", "D"],
    "allin": ["AH0", "L", "IH1", "N"],
    "allinder": ["AE1", "L", "IH0", "N", "D", "ER0"],
    "alling": ["AO1", "L", "IH0", "NG"],
    "allinger": ["AO1", "L", "IH0", "NG", "ER0"],
    "allingham": ["AO1", "L", "IH0", "NG", "HH", "AE2", "M"],
    "allington": ["AO1", "L", "IH0", "NG", "T", "AH0", "N"],
    "allinson": ["AE1", "L", "IH0", "N", "S", "AH0", "N"],
    "allis": ["AE1", "L", "IH0", "S"],
    "allison": ["AE1", "L", "IH0", "S", "AH0", "N"],
    "allison's": ["AE1", "L", "IH0", "S", "AH0", "N", "Z"],
    "allister": ["AE1", "L", "IH0", "S", "T", "ER0"],
    "alliston": ["AE1", "L", "IH0", "S", "T", "AA0", "N"],
    "alliteration": ["AH0", "L", "IH1", "T", "ER0", "EY2", "SH", "AH0", "N"],
    "alliterative": ["AH0", "L", "IH1", "T", "ER0", "EY2", "T", "IH0", "V"],
    "allman": ["AO1", "L", "M", "AH0", "N"],
    "allmendinger": ["AE1", "L", "M", "EH0", "N", "D", "IH0", "NG", "ER0"],
    "allmon": ["AO1", "L", "M", "AH0", "N"],
    "allmond": ["AH0", "L", "M", "AA1", "N", "D"],
    "allnet": ["AO1", "L", "N", "EH2", "T"],
    "allnutt": ["AH0", "L", "N", "AH1", "T"],
    "allocate": ["AE1", "L", "AH0", "K", "EY2", "T"],
    "allocated": ["AE1", "L", "AH0", "K", "EY2", "T", "IH0", "D"],
    "allocates": ["AE1", "L", "AH0", "K", "EY2", "T", "S"],
    "allocating": ["AE1", "L", "AH0", "K", "EY2", "T", "IH0", "NG"],
    "allocation": ["AE2", "L", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "allocations": ["AE2", "L", "AH0", "K", "EY1", "SH", "AH0", "N", "Z"],
    "allocator": ["AE1", "L", "AH0", "K", "EY2", "T", "ER0"],
    "allocators": ["AE1", "L", "AH0", "K", "EY2", "T", "ER0", "Z"],
    "allocca": ["AE2", "L", "AA1", "K", "AH0"],
    "allocco": ["AE2", "L", "AA1", "K", "OW0"],
    "allograph": ["AE1", "L", "AH0", "G", "R", "AE2", "F"],
    "allographs": ["AE1", "L", "AH0", "G", "R", "AE2", "F", "S"],
    "allomorph": ["AE1", "L", "AH0", "M", "AO0", "R", "F"],
    "allomorphs": ["AE1", "L", "AH0", "M", "AO0", "R", "F", "S"],
    "allophone": ["AE1", "L", "AH0", "F", "OW2", "N"],
    "allophones": ["AE1", "L", "AH0", "F", "OW2", "N", "Z"],
    "allophonic": ["AE2", "L", "AH0", "F", "AA1", "N", "IH0", "K"],
    "allor": ["AO1", "L", "ER0"],
    "allot": ["AH0", "L", "AA1", "T"],
    "alloted": ["AH0", "L", "AA1", "T", "IH0", "D"],
    "allotment": ["AH0", "L", "AA1", "T", "M", "AH0", "N", "T"],
    "allotments": ["AH0", "L", "AA1", "T", "M", "AH0", "N", "T", "S"],
    "allotrope": ["AE1", "L", "AH0", "T", "R", "OW2", "P"],
    "allotropes": ["AE1", "L", "AH0", "T", "R", "OW2", "P", "S"],
    "allots": ["AH0", "L", "AA1", "T", "S"],
    "allotted": ["AH0", "L", "AA1", "T", "IH0", "D"],
    "allotting": ["AH0", "L", "AA1", "T", "IH0", "NG"],
    "allow": ["AH0", "L", "AW1"],
    "allowable": ["AH0", "L", "AW1", "AH0", "B", "AH0", "L"],
    "allowance": ["AH0", "L", "AW1", "AH0", "N", "S"],
    "allowances": ["AH0", "L", "AW1", "AH0", "N", "S", "IH0", "Z"],
    "alloway": ["AE1", "L", "OW0", "W", "EY2"],
    "allowed": ["AH0", "L", "AW1", "D"],
    "allowing": ["AH0", "L", "AW1", "IH0", "NG"],
    "allows": ["AH0", "L", "AW1", "Z"],
    "alloy": ["AE1", "L", "OY2"],
    "alloys": ["AE1", "L", "OY2", "Z"],
    "allphin": ["AH0", "L", "F", "IH1", "N"],
    "allport": ["AO1", "L", "P", "AO2", "R", "T"],
    "allred": ["AE1", "L", "R", "IH0", "D"],
    "allright": ["AA0", "L", "R", "AY1", "T"],
    "alls": ["AO1", "L", "Z"],
    "allsbrook": ["AO1", "L", "T", "S", "B", "R", "UH2", "K"],
    "allset": ["AO0", "L", "S", "EH1", "T"],
    "allshouse": ["AO1", "L", "T", "S", "HH", "AW2", "S"],
    "allsop": ["AO1", "L", "S", "AA2", "P"],
    "allsopp": ["AO1", "L", "S", "AA2", "P"],
    "allspice": ["AO1", "L", "S", "P", "AY2", "S"],
    "allstate": ["AO1", "L", "S", "T", "EY2", "T"],
    "allstate's": ["AO1", "L", "S", "T", "EY2", "T", "S"],
    "allston": ["AO1", "L", "S", "T", "AH0", "N"],
    "allsup": ["AE1", "L", "S", "AH0", "P"],
    "alltel": ["AO1", "L", "T", "EH2", "L"],
    "alltime": ["AO1", "L", "T", "AY2", "M"],
    "allton": ["AO1", "L", "T", "AH0", "N"],
    "alltop": ["AO1", "L", "T", "AA2", "P"],
    "allude": ["AH0", "L", "UW1", "D"],
    "alluded": ["AH0", "L", "UW1", "D", "IH0", "D"],
    "alludes": ["AH0", "L", "UW1", "D", "Z"],
    "alluding": ["AH0", "L", "UW1", "D", "IH0", "NG"],
    "allum": ["AE1", "L", "AH0", "M"],
    "allums": ["AE1", "L", "AH0", "M", "Z"],
    "allure": ["AH0", "L", "UH1", "R"],
    "allured": ["AH0", "L", "UH1", "R", "D"],
    "alluring": ["AH0", "L", "UH1", "R", "IH0", "NG"],
    "allusion": ["AH0", "L", "UW1", "ZH", "AH0", "N"],
    "allusions": ["AH0", "L", "UW1", "ZH", "AH0", "N", "Z"],
    "allusive": ["AH0", "L", "UW1", "S", "IH0", "V"],
    "alluvial": ["AE2", "L", "UW1", "V", "IY0", "AH0", "L"],
    "alluvium": ["AE2", "L", "UW1", "V", "IY0", "AH0", "M"],
    "allwaste": ["AO1", "L", "W", "EY2", "S", "T"],
    "allweiss": ["AA1", "L", "W", "IY2", "S"],
    "allweiss's": ["AA1", "L", "W", "IY2", "S", "IH0", "Z"],
    "ally": ["AH0", "L", "AY1"],
    "ally's": ["AH0", "L", "AY1", "Z"],
    "allying": ["AH0", "L", "AY1", "IH0", "NG"],
    "allyn": ["AE1", "L", "IH0", "N"],
    "allys": ["AE1", "L", "AY0", "Z"],
    "allyson": ["AE1", "L", "IH0", "S", "AH0", "N"],
    "alm": ["AA1", "L", "M"],
    "alma": ["AA1", "L", "M", "AH0"],
    "almada": ["AA0", "L", "M", "AA1", "D", "AH0"],
    "almadani": ["AA2", "L", "M", "AH0", "D", "AA1", "N", "IY0"],
    "almaden": ["AA1", "L", "M", "AH0", "D", "EH2", "N"],
    "almaguer": ["AA0", "L", "M", "AA0", "G", "W", "EH1", "R"],
    "almal": ["AA1", "L", "M", "AH0", "L"],
    "alman": ["AE1", "L", "M", "AH0", "N"],
    "almanac": ["AA1", "L", "M", "AH0", "N", "AE2", "K"],
    "almand": ["AE1", "L", "M", "AH0", "N", "D"],
    "almanza": ["AA0", "L", "M", "AA1", "N", "Z", "AH0"],
    "almanzar": ["AA0", "L", "M", "AA0", "N", "Z", "AA1", "R"],
    "almaraz": ["AA0", "L", "M", "AA1", "R", "AA0", "Z"],
    "almas": ["AE1", "L", "M", "AH0", "Z"],
    "almasy": ["AE1", "L", "M", "AH0", "S", "IY0"],
    "almaty": ["AA2", "M", "AA1", "T", "IY2"],
    "almay": ["AA1", "L", "M", "EY0"],
    "almazan": ["AA0", "L", "M", "AA0", "Z", "AA1", "N"],
    "almeda": ["AA0", "L", "M", "EY1", "D", "AH0"],
    "almeida": ["AA0", "L", "M", "IY1", "D", "AH0"],
    "almelund": ["AA0", "L", "M", "AH0", "L", "AH1", "N", "D"],
    "almendarez": ["AA0", "L", "M", "EY0", "N", "D", "AA1", "R", "EH0", "Z"],
    "almer": ["AO1", "L", "M", "ER0"],
    "almeria": ["AA0", "L", "M", "ER1", "IY0", "AH0"],
    "almgren": ["AE1", "L", "M", "G", "R", "EH0", "N"],
    "almighty": ["AO0", "L", "M", "AY1", "T", "IY0"],
    "almira": ["AA0", "L", "M", "IH1", "R", "AH0"],
    "almo": ["AA1", "L", "M", "OW0"],
    "almodovar": ["AA2", "L", "M", "OW0", "D", "OW0", "V", "AA1", "R"],
    "almon": ["AA1", "L", "M", "AH0", "N"],
    "almond": ["AA1", "M", "AH0", "N", "D"],
    "almonds": ["AA1", "L", "M", "AH0", "N", "D", "Z"],
    "almoner": ["AA1", "L", "M", "AH0", "N", "ER0"],
    "almonte": ["AA0", "L", "M", "OW1", "N", "T", "EY0"],
    "almos": ["AA1", "L", "M", "OW0", "S"],
    "almost": ["AO1", "L", "M", "OW2", "S", "T"],
    "almquist": ["AE1", "L", "M", "K", "W", "IH0", "S", "T"],
    "alms": ["AA1", "M", "Z"],
    "almy": ["AO1", "M", "IY0"],
    "almys": ["AE1", "L", "M", "IY0", "Z"],
    "alodie": ["AH0", "L", "AA1", "D", "IY0"],
    "aloe": ["AE1", "L", "OW2"],
    "aloft": ["AH0", "L", "AO1", "F", "T"],
    "aloha": ["AH0", "L", "OW1", "HH", "AA0"],
    "aloi": ["AA1", "L", "OY0"],
    "aloia": ["AA0", "L", "OW1", "Y", "AH0"],
    "alois": ["AA0", "L", "OY1", "S"],
    "aloisa": ["AA0", "L", "OY1", "S", "AH0"],
    "aloisi": ["AA0", "L", "OY1", "S", "IY0"],
    "aloisia": ["AA0", "L", "OY1", "S", "IY0", "AH0"],
    "aloisio": ["AA0", "L", "OY1", "S", "IY0", "OW0"],
    "aloka": ["AH0", "L", "OW1", "K", "AH0"],
    "alomar": ["AE1", "L", "AH0", "M", "AA2", "R"],
    "alon": ["AH0", "L", "AA1", "N"],
    "alone": ["AH0", "L", "OW1", "N"],
    "along": ["AH0", "L", "AO1", "NG"],
    "alonge": ["AE1", "L", "AH0", "N", "JH"],
    "alongi": ["AA0", "L", "OW1", "NG", "G", "IY0"],
    "alongs": ["AH0", "L", "AO1", "NG", "Z"],
    "alongside": ["AH0", "L", "AO1", "NG", "S", "AY1", "D"],
    "aloni": ["AH0", "L", "OW1", "N", "IY0"],
    "alonso": ["AH0", "L", "AA1", "N", "S", "OW0"],
    "alonza": ["AH0", "L", "AA1", "N", "Z", "AH0"],
    "alonzo": ["AH0", "L", "AA1", "N", "Z", "OW0"],
    "aloof": ["AH0", "L", "UW1", "F"],
    "aloofness": ["AH0", "L", "UW1", "F", "N", "AH0", "S"],
    "alot": ["AH0", "L", "AA1", "T"],
    "aloud": ["AH0", "L", "AW1", "D"],
    "aloys": ["AH0", "L", "OY1", "Z"],
    "aloyse": ["AH0", "L", "OY1", "S"],
    "aloysia": ["AA0", "L", "OY1", "S", "IY0", "AH0"],
    "aloysius": ["AE2", "L", "OW0", "IH1", "SH", "IH0", "S"],
    "alpa": ["AE1", "L", "P", "AH0"],
    "alpaca": ["AE0", "L", "P", "AE1", "K", "AH0"],
    "alpaugh": ["AH0", "L", "P", "AO1"],
    "alper": ["AE1", "L", "P", "ER0"],
    "alperin": ["AE1", "L", "P", "ER0", "IH2", "N"],
    "alpern": ["AH0", "L", "P", "ER1", "N"],
    "alpers": ["AE1", "L", "P", "ER0", "Z"],
    "alpert": ["AE1", "L", "P", "ER0", "T"],
    "alpex": ["AE1", "L", "P", "EH0", "K", "S"],
    "alpha": ["AE1", "L", "F", "AH0"],
    "alpha's": ["AE1", "L", "F", "AH0", "Z"],
    "alphabet": ["AE1", "L", "F", "AH0", "B", "EH2", "T"],
    "alphabetic": ["AE2", "L", "F", "AH0", "B", "EH1", "T", "IH0", "K"],
    "alphabetical": ["AE2", "L", "F", "AH0", "B", "EH1", "T", "IH0", "K", "AH0", "L"],
    "alphabetically": ["AE2", "L", "F", "AH0", "B", "EH1", "T", "IH0", "K", "L", "IY0"],
    "alphabetization": ["AE2", "L", "F", "AH0", "B", "EH2", "T", "AH0", "Z", "EY1", "SH", "AH0", "N"],
    "alphabetize": ["AE1", "L", "F", "AH0", "B", "AH0", "T", "AY2", "Z"],
    "alphabetized": ["AE1", "L", "F", "AH0", "B", "AH0", "T", "AY2", "Z", "D"],
    "alphabetizes": ["AE1", "L", "F", "AH0", "B", "AH0", "T", "AY2", "Z", "IH0", "Z"],
    "alphabetizing": ["AE1", "L", "F", "AH0", "B", "AH0", "T", "AY2", "Z", "IH0", "NG"],
    "alphagraphics": ["AE0", "L", "F", "AH0", "G", "R", "AE1", "F", "IH0", "K", "S"],
    "alphametric": ["AE1", "L", "F", "AH0", "M", "EH2", "T", "R", "IH0", "K"],
    "alphametrics": ["AE1", "L", "F", "AH0", "M", "EH2", "T", "R", "IH0", "K", "S"],
    "alphandery": ["AE2", "L", "F", "AE1", "D", "ER0", "IY0"],
    "alphanumeric": ["AE2", "L", "F", "AH0", "N", "UW0", "M", "EH1", "R", "IH0", "K"],
    "alphaphotographic": ["AE2", "L", "F", "AH0", "F", "OW2", "T", "AH0", "G", "R", "AE1", "F", "IH0", "K"],
    "alpharel": ["AE1", "L", "F", "ER0", "EH2", "L"],
    "alpharetta": ["AE2", "L", "F", "ER0", "EH1", "T", "AH0"],
    "alphin": ["AE1", "L", "F", "IH0", "N"],
    "alphonse": ["AE0", "L", "F", "AA1", "N", "Z"],
    "alphonsine": ["AH0", "L", "F", "AA1", "N", "S", "IY0", "N"],
    "alphonso": ["AE0", "L", "F", "AA1", "N", "S", "OW0"],
    "alpin": ["AH0", "L", "P", "IH1", "N"],
    "alpine": ["AE1", "L", "P", "AY2", "N"],
    "alpirez": ["AE1", "L", "P", "IH0", "R", "EH0", "Z"],
    "alpo": ["AE1", "L", "P", "OW0"],
    "alps": ["AE1", "L", "P", "S"],
    "alquist": ["AE1", "L", "K", "W", "IH0", "S", "T"],
    "alread": ["AA1", "L", "R", "IY0", "D"],
    "already": ["AO0", "R", "EH1", "D", "IY0"],
    "alred": ["AO1", "L", "R", "IH0", "D"],
    "alright": ["AO2", "L", "R", "AY1", "T"],
    "alrighty": ["AO2", "L", "R", "AY1", "T", "IY0"],
    "alrosa": ["AA0", "L", "R", "OW1", "Z", "AH0"],
    "alroy": ["AH0", "L", "R", "OY1"],
    "als": ["AE1", "L", "Z"],
    "alsace": ["AE0", "L", "S", "AE1", "S"],
    "alsatian": ["AE0", "L", "S", "EY1", "SH", "AH0", "N"],
    "alsbrook": ["AE1", "L", "Z", "B", "R", "UH0", "K"],
    "alsbrook's": ["AE1", "L", "Z", "B", "R", "UH0", "K", "S"],
    "alsbrooks": ["AE1", "L", "Z", "B", "R", "UH0", "K", "S"],
    "alsbrooks'": ["AE1", "L", "Z", "B", "R", "UH0", "K", "S"],
    "alsbury": ["AE1", "L", "Z", "B", "EH0", "R", "IY0"],
    "alsdorf": ["AE1", "L", "Z", "D", "AO0", "R", "F"],
    "alsgaard": ["AA1", "L", "Z", "G", "AA0", "R", "D"],
    "alshelhah": ["AA0", "L", "SH", "EH1", "L", "HH", "AH0"],
    "alsip": ["AE1", "L", "S", "IH0", "P"],
    "also": ["AO1", "L", "S", "OW0"],
    "alsobrook": ["AE1", "L", "S", "AH0", "B", "R", "UH0", "K"],
    "alsobrooks": ["AE1", "L", "S", "AH0", "B", "R", "UH0", "K", "S"],
    "alsop": ["AE1", "L", "S", "AA0", "P"],
    "alspach": ["AE1", "L", "S", "P", "AH0", "K"],
    "alspaugh": ["AH0", "L", "S", "P", "AO1"],
    "alsthom": ["AE1", "L", "S", "TH", "AH0", "M"],
    "alston": ["AO1", "L", "S", "T", "AH0", "N"],
    "alsup": ["AE1", "L", "S", "AH0", "P"],
    "alt": ["AA1", "L", "T"],
    "alta": ["AA1", "L", "T", "AH0"],
    "altadena": ["AA2", "L", "T", "AH0", "D", "IY1", "N", "AH0"],
    "altai": ["AE0", "L", "T", "AY1"],
    "altaic": ["AE0", "L", "T", "EY1", "IH0", "K"],
    "altair": ["AA0", "L", "T", "EH1", "R"],
    "altamira": ["AA2", "L", "T", "AA0", "M", "IH1", "R", "AH0"],
    "altamirano": ["AA2", "L", "T", "AA0", "M", "IH0", "R", "AA1", "N", "OW0"],
    "altamont": ["AA1", "L", "T", "AH0", "M", "AO2", "N", "T"],
    "altamuro": ["AO2", "L", "T", "AH0", "M", "UH1", "R", "OW0"],
    "altar": ["AO1", "L", "T", "ER0"],
    "altarpiece": ["AO1", "L", "T", "ER0", "P", "IY2", "S"],
    "altars": ["AO1", "L", "T", "ER0", "Z"],
    "altavista": ["AO2", "L", "T", "AH0", "V", "IH1", "S", "T", "AH0"],
    "altay": ["AO1", "L", "T", "AY0"],
    "altemose": ["AE1", "L", "T", "IH0", "M", "OW0", "S"],
    "altemus": ["AE1", "L", "T", "IH0", "M", "IH0", "S"],
    "altenburg": ["AO1", "L", "T", "AH0", "N", "B", "ER0", "G"],
    "altenhofen": ["AE1", "L", "T", "IH0", "N", "HH", "AH0", "F", "AH0", "N"],
    "alteon": ["AA1", "L", "T", "IY0", "AO0", "N"],
    "alter": ["AO1", "L", "T", "ER0"],
    "altera": ["AO2", "L", "T", "EH1", "R", "AH0"],
    "alteration": ["AO2", "L", "T", "ER0", "EY1", "SH", "AH0", "N"],
    "alterations": ["AO2", "L", "T", "ER0", "EY1", "SH", "AH0", "N", "Z"],
    "altercation": ["AA2", "L", "T", "ER0", "K", "EY1", "SH", "AH0", "N"],
    "altercations": ["AA2", "L", "T", "ER0", "K", "EY1", "SH", "AH0", "N", "Z"],
    "altered": ["AO1", "L", "T", "ER0", "D"],
    "altergott": ["AE1", "L", "T", "ER0", "G", "AH0", "T"],
    "altering": ["AO1", "L", "T", "ER0", "IH0", "NG"],
    "alterman": ["AO1", "L", "T", "ER0", "M", "AH0", "N"],
    "alternacare": ["AO0", "L", "T", "ER1", "N", "AH0", "K", "EH2", "R"],
    "alternate": ["AO1", "L", "T", "ER0", "N", "EY2", "T"],
    "alternated": ["AO1", "L", "T", "ER0", "N", "EY2", "T", "IH0", "D"],
    "alternately": ["AO1", "L", "T", "ER0", "N", "AH0", "T", "L", "IY0"],
    "alternates": ["AO1", "L", "T", "ER0", "N", "EY2", "T", "S"],
    "alternating": ["AO1", "L", "T", "ER0", "N", "EY2", "T", "IH0", "NG"],
    "alternation": ["AO1", "L", "T", "ER0", "N", "EY2", "SH", "AH0", "N"],
    "alternative": ["AO0", "L", "T", "ER1", "N", "AH0", "T", "IH0", "V"],
    "alternatively": ["AO0", "L", "T", "ER1", "N", "AH0", "T", "IH0", "V", "L", "IY0"],
    "alternatives": ["AO0", "L", "T", "ER1", "N", "AH0", "T", "IH0", "V", "Z"],
    "alternator": ["AO1", "L", "T", "ER0", "N", "EY2", "T", "ER0"],
    "alters": ["AO1", "L", "T", "ER0", "Z"],
    "altfest": ["AA1", "L", "T", "F", "EH2", "S", "T"],
    "althaus": ["AE1", "L", "T", "HH", "AW0", "S"],
    "althaver": ["AE2", "L", "TH", "EY1", "V", "ER0"],
    "althea": ["AE0", "L", "TH", "IY1", "AH0"],
    "altherr": ["AA1", "L", "TH", "ER0"],
    "althoff": ["AE1", "L", "T", "HH", "AO0", "F"],
    "althorp": ["AA1", "L", "TH", "AO0", "R", "P"],
    "although": ["AO2", "L", "DH", "OW1"],
    "althouse": ["AO1", "L", "T", "HH", "AW2", "S"],
    "altice": ["AA1", "L", "T", "IH0", "S"],
    "altier": ["AO1", "L", "T", "IY0", "ER0"],
    "altieri": ["AA0", "L", "T", "IH1", "R", "IY0"],
    "altima": ["AA1", "L", "T", "IH2", "M", "AH0"],
    "altima's": ["AA1", "L", "T", "IH2", "M", "AH0", "Z"],
    "altimeter": ["AE0", "L", "T", "IH1", "M", "AH0", "T", "ER0"],
    "altimeters": ["AE0", "L", "T", "IH1", "M", "AH0", "T", "ER0", "Z"],
    "altimetry": ["AE0", "L", "T", "IH1", "M", "AH0", "T", "R", "IY0"],
    "altimorano": ["AA2", "L", "T", "IY2", "M", "AO2", "R", "AA1", "N", "OW0"],
    "altiplano": ["AE2", "L", "T", "AH0", "P", "L", "AA1", "N", "OW2"],
    "altitude": ["AE1", "L", "T", "AH0", "T", "UW2", "D"],
    "altitudes": ["AE1", "L", "T", "IH0", "T", "UW2", "D", "Z"],
    "altizer": ["AE1", "L", "T", "AY0", "Z", "ER0"],
    "altland": ["AE1", "L", "T", "L", "AH0", "N", "D"],
    "altman": ["AO1", "L", "T", "M", "AH0", "N"],
    "altman's": ["AO1", "L", "T", "M", "AH0", "N", "Z"],
    "altmann": ["AO1", "L", "T", "M", "AH0", "N"],
    "altmeyer": ["AA1", "L", "T", "M", "AY0", "ER0"],
    "alto": ["AE1", "L", "T", "OW0"],
    "altobelli": ["AA0", "L", "T", "OW0", "B", "EH1", "L", "IY0"],
    "altogether": ["AO2", "L", "T", "AH0", "G", "EH1", "DH", "ER0"],
    "altoid": ["AA1", "L", "T", "OY0", "D"],
    "altom": ["AH0", "L", "T", "AA1", "M"],
    "altomare": ["AA0", "L", "T", "OW0", "M", "AA1", "R", "IY0"],
    "alton": ["AO1", "L", "T", "AH0", "N"],
    "altoona": ["AE2", "L", "T", "UW1", "N", "AH0"],
    "altos": ["AO1", "L", "T", "OW2", "S"],
    "altra": ["AA1", "L", "T", "R", "AH0"],
    "altron": ["AO1", "L", "T", "R", "AA0", "N"],
    "altruism": ["AE1", "L", "T", "R", "UW0", "IH2", "Z", "AH0", "M"],
    "altruistic": ["AO2", "L", "T", "R", "UW0", "IH1", "S", "T", "IH0", "K"],
    "altschiller": ["AO1", "L", "CH", "IH0", "L", "ER0"],
    "altschul": ["AE1", "L", "CH", "AH0", "L"],
    "altschuler": ["AE1", "L", "CH", "UW0", "L", "ER0"],
    "altshuler": ["AE1", "L", "CH", "UW0", "L", "ER0"],
    "altucher": ["AE0", "L", "T", "AH1", "K", "ER0"],
    "alturas": ["AA0", "L", "T", "UH1", "R", "AH0", "S"],
    "altus": ["AE1", "L", "T", "AH0", "S"],
    "altvater": ["AE1", "L", "T", "V", "AH0", "T", "ER0"],
    "altzheimer": ["AA1", "L", "T", "S", "HH", "AY2", "M", "ER0"],
    "altzheimer's": ["AA1", "L", "T", "S", "HH", "AY2", "M", "ER0", "Z"],
    "alu": ["AA1", "L", "UW0"],
    "alum": ["AH0", "L", "AH1", "M"],
    "alumax": ["AE1", "L", "UW0", "M", "AE0", "K", "S"],
    "alumbaugh": ["AH0", "L", "AH1", "M", "B", "AO0"],
    "alumina": ["AH0", "L", "UW1", "M", "AH0", "N", "AH0"],
    "aluminio": ["AE2", "L", "UW0", "M", "IY1", "N", "IY0", "OW0"],
    "aluminium": ["AE2", "L", "Y", "UW1", "M", "IH0", "N", "AH0", "M"],
    "aluminize": ["AH0", "L", "UW1", "M", "AH0", "N", "AY2", "Z"],
    "aluminized": ["AH0", "L", "UW1", "M", "AH0", "N", "AY2", "Z", "D"],
    "aluminosilicate": ["AH0", "L", "UW2", "M", "AH0", "N", "OW0", "S", "IH1", "L", "AH0", "K", "EY2", "T"],
    "aluminum": ["AH0", "L", "UW1", "M", "AH0", "N", "AH0", "M"],
    "aluminum's": ["AH0", "L", "UW1", "M", "AH0", "N", "AH0", "M", "Z"],
    "alumna": ["AH0", "L", "AH1", "M", "N", "AH0"],
    "alumnae": ["AH0", "L", "AH1", "M", "N", "EY2"],
    "alumni": ["AH0", "L", "AH1", "M", "N", "AY2"],
    "alumnus": ["AH0", "L", "AH1", "M", "N", "AH0", "S"],
    "alums": ["AE1", "L", "AH0", "M", "Z"],
    "alun": ["EY1", "L", "AH0", "N"],
    "alura": ["AA0", "L", "UH1", "R", "AH0"],
    "alusuisse": ["AE2", "L", "Y", "UW0", "S", "W", "IH1", "S"],
    "alva": ["AE1", "L", "V", "AH0"],
    "alvah": ["AE0", "L", "V", "AA1"],
    "alvan": ["AE1", "L", "V", "AH0", "N"],
    "alvarado": ["AE2", "L", "V", "ER0", "AA1", "D", "OW0"],
    "alvardo": ["AA0", "L", "V", "AA1", "R", "D", "OW0"],
    "alvare": ["AE2", "L", "V", "AA1", "R"],
    "alvarenga": ["AA0", "L", "V", "AA0", "R", "EH1", "NG", "G", "AH0"],
    "alvares": ["AA0", "L", "V", "AA1", "R", "EH0", "S"],
    "alvarez": ["AE1", "L", "V", "ER0", "EH2", "Z"],
    "alvarez's": ["AE1", "L", "V", "ER0", "EH2", "Z", "IH0", "Z"],
    "alvaro": ["AH0", "L", "V", "AA1", "R", "OW0"],
    "alvear": ["AA0", "L", "V", "IH1", "R"],
    "alveolar": ["AE0", "L", "V", "IY1", "AH0", "L", "ER0"],
    "alveoli": ["AE0", "L", "V", "IY1", "AH0", "L", "AY2"],
    "alverez": ["AA0", "L", "V", "EH1", "R", "EH0", "Z"],
    "alvero": ["AE0", "L", "V", "EH1", "R", "OW0"],
    "alverson": ["AA1", "L", "V", "ER0", "S", "AH0", "N"],
    "alverton": ["AA1", "L", "V", "ER0", "T", "AH0", "N"],
    "alves": ["AA1", "L", "V", "EH0", "S"],
    "alvey": ["AE1", "L", "V", "IY0"],
    "alvidrez": ["AA0", "L", "V", "IY1", "D", "R", "EH0", "Z"],
    "alvin": ["AE1", "L", "V", "IH0", "N"],
    "alvina": ["AE0", "L", "V", "AY1", "N", "AH0"],
    "alvino": ["AA0", "L", "V", "IY1", "N", "OW0"],
    "alvis": ["AA1", "L", "V", "IH0", "S"],
    "alvita": ["AA0", "L", "V", "IY1", "T", "AH0"],
    "alvite": ["AE1", "L", "V", "AY2", "T"],
    "alvord": ["AE0", "L", "V", "AO1", "R", "D"],
    "alwaleed": ["AA2", "L", "W", "AA0", "L", "IY1", "D"],
    "alward": ["AE0", "L", "W", "ER1", "D"],
    "always": ["AO1", "L", "W", "IY0", "Z"],
    "alwin": ["AE1", "L", "W", "IH0", "N"],
    "alwine": ["AE1", "L", "W", "AY2", "N"],
    "alwood": ["AE1", "L", "W", "UH0", "D"],
    "alwyn": ["AE1", "L", "W", "IH0", "N"],
    "aly": ["EY1", "L", "IY0"],
    "alyce": ["AE1", "L", "IH0", "S"],
    "alyea": ["AE0", "L", "IY1", "AH0"],
    "alyeska": ["AE0", "L", "IY0", "EH1", "S", "K", "AH0"],
    "alyeska's": ["AE2", "L", "Y", "EH1", "S", "K", "AH0", "Z"],
    "alys": ["AE1", "L", "IY0", "Z"],
    "alysheba": ["AE2", "L", "IH0", "SH", "IY1", "B", "AH0"],
    "alysia": ["AH0", "L", "IH1", "S", "IY0", "AH0"],
    "alyssa": ["AH0", "L", "IH1", "S", "AH0"],
    "alza": ["AE1", "L", "Z", "AH0"],
    "alza's": ["AE1", "L", "Z", "AH0", "Z"],
    "alzado": ["AA0", "L", "Z", "AA1", "D", "OW0"],
    "alzena": ["AA0", "L", "Z", "EH1", "N", "AH0"],
    "alzene": ["AA0", "L", "Z", "IY1", "N"],
    "alzheimer": ["AA1", "L", "T", "S", "HH", "AY2", "M", "ER0"],
    "alzheimer's": ["AA1", "T", "S", "Z", "HH", "AY2", "M", "ER0", "Z"],
    "alzona": ["AE2", "L", "Z", "OW1", "N", "AH0"],
    "am": ["EY1", "EH1", "M"],
    "am's": ["EY1", "EH1", "M", "Z"],
    "ama": ["EY2", "EH2", "M", "EY1"],
    "amabel": ["AE1", "M", "AH0", "B", "EH2", "L"],
    "amabelle": ["AE1", "M", "AH0", "B", "AH0", "L"],
    "amabile": ["AA0", "M", "AA1", "B", "AH0", "L"],
    "amacher": ["AE1", "M", "AH0", "K", "ER0"],
    "amacker": ["AE1", "M", "AH0", "K", "ER0"],
    "amadea": ["AA0", "M", "AA1", "D", "IY0", "AH0"],
    "amadeo": ["AA0", "M", "AA1", "D", "IY0", "OW0"],
    "amadeus": ["AE2", "M", "AH0", "D", "EY1", "AH0", "S"],
    "amado": ["AA0", "M", "AA1", "D", "OW0"],
    "amadon": ["AA0", "M", "AA0", "D", "AO1", "N"],
    "amador": ["AE1", "M", "AH0", "D", "AO2", "R"],
    "amadou": ["AE1", "M", "AH0", "D", "UW2"],
    "amagansett": ["AH0", "M", "AE1", "G", "AH0", "N", "S", "EH2", "T"],
    "amaker": ["AE1", "M", "EY0", "K", "ER0"],
    "amakudari": ["AE2", "M", "AH0", "K", "Y", "UW0", "D", "AA1", "R", "IY0"],
    "amal": ["AH0", "M", "AA1", "L"],
    "amal's": ["AH0", "M", "AA1", "L", "Z"],
    "amalea": ["AE2", "M", "AH0", "L", "IY1", "AH0"],
    "amalfitano": ["AA0", "M", "AA0", "L", "F", "IY0", "T", "AA1", "N", "OW0"],
    "amalgam": ["AH0", "M", "AE1", "L", "G", "AH0", "M"],
    "amalgamate": ["AH0", "M", "AE1", "L", "G", "AH0", "M", "EY2", "T"],
    "amalgamated": ["AH0", "M", "AE1", "L", "G", "AH0", "M", "EY2", "T", "IH0", "D"],
    "amalgamated's": ["AH0", "M", "AE1", "L", "G", "AH0", "M", "EY2", "T", "IH0", "D", "Z"],
    "amalgamates": ["AH0", "M", "AE1", "L", "G", "AH0", "M", "EY2", "T", "S"],
    "amalgamating": ["AH0", "M", "AE1", "L", "G", "AH0", "M", "EY2", "T", "IH0", "NG"],
    "amalgamation": ["AH0", "M", "AE2", "L", "G", "AH0", "M", "EY1", "SH", "AH0", "N"],
    "amalgams": ["AH0", "M", "AE1", "L", "G", "AH0", "M", "Z"],
    "amalia": ["AH0", "M", "AA1", "L", "Y", "AH0"],
    "amalie": ["AE1", "M", "AH0", "L", "IY0"],
    "amalya": ["AH0", "M", "AA1", "L", "Y", "AH0"],
    "aman": ["AA1", "M", "AH0", "N"],
    "amana": ["AH0", "M", "AE1", "N", "AH0"],
    "amanda": ["AH0", "M", "AE1", "N", "D", "AH0"],
    "amanda's": ["AH0", "M", "AE1", "N", "D", "AH0", "Z"],
    "amandas": ["AH0", "M", "AE1", "N", "D", "AH0", "Z"],
    "amandime": ["AE1", "M", "AH0", "N", "D", "AY2", "M"],
    "amann": ["AE1", "M", "AH0", "N"],
    "amano": ["AH0", "M", "AA1", "N", "OW0"],
    "amanpour": ["AA2", "M", "AA2", "N", "P", "UH1", "R"],
    "amanpour's": ["AA2", "M", "AA2", "N", "P", "UH1", "R", "Z"],
    "amante": ["AA0", "M", "AA1", "N", "T", "IY0"],
    "amar": ["AH0", "M", "AA1", "R"],
    "amar's": ["AH0", "M", "AA1", "R", "Z"],
    "amara": ["AA0", "M", "AA1", "R", "AH0"],
    "amaral": ["AA0", "M", "AA0", "R", "AE1", "L"],
    "amarante": ["AA0", "M", "AA0", "R", "AA1", "N", "T", "IY0"],
    "amaranth": ["AE1", "M", "ER0", "AE2", "N", "TH"],
    "amaretto": ["AE0", "M", "AH0", "R", "EH1", "T", "OW0"],
    "amargosa": ["AH0", "M", "AA0", "R", "G", "OW1", "S", "AH0"],
    "amari": ["AA0", "M", "AA1", "R", "IY0"],
    "amarilla": ["AE2", "M", "ER0", "IH1", "L", "AH0"],
    "amarillo": ["AE2", "M", "ER0", "IH1", "L", "OW0"],
    "amarillo's": ["AE2", "M", "ER0", "IH1", "L", "OW0", "Z"],
    "amarillos": ["AE2", "M", "ER0", "IH1", "L", "OW0", "Z"],
    "amarin": ["AE1", "M", "ER0", "IH0", "N"],
    "amaris": ["AE1", "M", "ER0", "IH0", "S"],
    "amaro": ["AA0", "M", "AA1", "R", "OW0"],
    "amaryllis": ["AE2", "M", "ER0", "IH1", "L", "IH0", "S"],
    "amaryllises": ["AE2", "M", "ER0", "IH1", "L", "AH0", "S", "AH0", "Z"],
    "amasa": ["AE1", "M", "AH0", "S", "AH0"],
    "amason": ["AE1", "M", "AH0", "S", "AH0", "N"],
    "amass": ["AH0", "M", "AE1", "S"],
    "amassed": ["AH0", "M", "AE1", "S", "T"],
    "amasses": ["AH0", "M", "AE1", "S", "IH0", "Z"],
    "amassing": ["AH0", "M", "AE1", "S", "IH0", "NG"],
    "amateur": ["AE1", "M", "AH0", "CH", "ER2"],
    "amateurish": ["AE1", "M", "AH0", "CH", "ER2", "IH0", "SH"],
    "amateurism": ["AE1", "M", "AH0", "CH", "ER2", "IH0", "Z", "AH0", "M"],
    "amateurs": ["AE1", "M", "AH0", "CH", "ER2", "Z"],
    "amati": ["AH0", "M", "AA1", "T", "IY0"],
    "amatil": ["AE1", "M", "AH0", "T", "IH0", "L"],
    "amato": ["AA0", "M", "AA1", "T", "OW2"],
    "amato's": ["AA0", "M", "AA1", "T", "OW2", "Z"],
    "amauligak": ["AH0", "M", "AW1", "L", "IH0", "G", "AE0", "K"],
    "amax": ["EY1", "M", "AE2", "K", "S"],
    "amax's": ["EY1", "M", "AE2", "K", "S", "IH0", "Z"],
    "amaya": ["AA0", "M", "AA1", "Y", "AH0"],
    "amaze": ["AH0", "M", "EY1", "Z"],
    "amazed": ["AH0", "M", "EY1", "Z", "D"],
    "amazement": ["AH0", "M", "EY1", "Z", "M", "AH0", "N", "T"],
    "amazes": ["AH0", "M", "EY1", "Z", "IH0", "Z"],
    "amazing": ["AH0", "M", "EY1", "Z", "IH0", "NG"],
    "amazingly": ["AH0", "M", "EY1", "Z", "IH0", "NG", "L", "IY0"],
    "amazon": ["AE1", "M", "AH0", "Z", "AA2", "N"],
    "amazon's": ["AE1", "M", "AH0", "Z", "AA2", "N", "Z"],
    "amazonia": ["AE2", "M", "AH0", "Z", "OW1", "N", "IY0", "AH0"],
    "amazonian": ["AE2", "M", "AH0", "Z", "OW1", "N", "IY0", "AH0", "N"],
    "amazonians": ["AE2", "M", "AH0", "Z", "OW1", "N", "IY0", "AH0", "N", "Z"],
    "amazons": ["AE1", "M", "AH0", "Z", "AA2", "N", "Z"],
    "ambac": ["AE1", "M", "B", "AE0", "K"],
    "ambase": ["AE1", "M", "B", "EY2", "S"],
    "ambassador": ["AE0", "M", "B", "AE1", "S", "AH0", "D", "ER0"],
    "ambassador's": ["AE0", "M", "B", "AE1", "S", "AH0", "D", "ER0", "Z"],
    "ambassadorial": ["AE0", "M", "B", "AE2", "S", "AH0", "D", "AO1", "R", "IY0", "AH0", "L"],
    "ambassadors": ["AE0", "M", "B", "AE1", "S", "AH0", "D", "ER0", "Z"],
    "ambassadorship": ["AE0", "M", "B", "AE1", "S", "AH0", "D", "ER0", "SH", "IH2", "P"],
    "ambassadorships": ["AE0", "M", "B", "AE1", "S", "AH0", "D", "ER0", "SH", "IH2", "P", "S"],
    "ambassadress": ["AE0", "M", "B", "AE1", "S", "AH0", "D", "R", "AH0", "S"],
    "amber": ["AE1", "M", "B", "ER0"],
    "amber's": ["AE1", "M", "B", "ER0", "Z"],
    "amberg": ["AE1", "M", "B", "ER0", "G"],
    "amberger": ["AE1", "M", "B", "ER0", "G", "ER0"],
    "ambergris": ["AE1", "M", "B", "ER0", "G", "R", "IH0", "S"],
    "ambers": ["AE1", "M", "B", "ER0", "Z"],
    "amberson": ["AE1", "M", "B", "ER0", "S", "AH0", "N"],
    "ambery": ["AE1", "M", "B", "ER0", "IY0"],
    "ambiance": ["AE1", "M", "B", "IY0", "AH0", "N", "S"],
    "ambidextrous": ["AE2", "M", "B", "IH0", "D", "EH1", "K", "S", "T", "R", "AH0", "S"],
    "ambien": ["AE1", "M", "B", "IY0", "EH2", "N"],
    "ambience": ["AE1", "M", "B", "IY0", "AH0", "N", "S"],
    "ambient": ["AE1", "M", "B", "IY0", "AH0", "N", "T"],
    "ambiguities": ["AE0", "M", "B", "AH0", "G", "Y", "UW1", "AH0", "T", "IY0", "Z"],
    "ambiguity": ["AE2", "M", "B", "IH0", "G", "Y", "UW1", "AH0", "T", "IY0"],
    "ambiguous": ["AE0", "M", "B", "IH1", "G", "Y", "UW0", "AH0", "S"],
    "ambisone": ["AE1", "M", "B", "AH0", "S", "OW2", "N"],
    "ambition": ["AE0", "M", "B", "IH1", "SH", "AH0", "N"],
    "ambitions": ["AE0", "M", "B", "IH1", "SH", "AH0", "N", "Z"],
    "ambitious": ["AE0", "M", "B", "IH1", "SH", "AH0", "S"],
    "ambitiously": ["AE0", "M", "B", "IH1", "SH", "AH0", "S", "L", "IY0"],
    "ambivalence": ["AE0", "M", "B", "IH1", "V", "AH0", "L", "AH0", "N", "S"],
    "ambivalent": ["AE0", "M", "B", "IH1", "V", "AH0", "L", "AH0", "N", "T"],
    "amble": ["AE1", "M", "B", "AH0", "L"],
    "ambled": ["AE1", "M", "B", "AH0", "L", "D"],
    "ambler": ["AE1", "M", "B", "L", "ER0"],
    "ambles": ["AE1", "M", "B", "AH0", "L", "Z"],
    "amblin": ["AE1", "M", "B", "L", "IH0", "N"],
    "ambling": ["AE1", "M", "B", "L", "IH0", "NG"],
    "amborn": ["AH0", "M", "B", "AO1", "R", "N"],
    "amboy": ["AE1", "M", "B", "OY0"],
    "ambra": ["AE1", "M", "B", "R", "AH0"],
    "ambriano": ["AE2", "M", "B", "R", "IY0", "AA1", "N", "OW0"],
    "ambrit": ["AE1", "M", "B", "R", "IH0", "T"],
    "ambriz": ["AE1", "M", "B", "R", "IH0", "Z"],
    "ambrogio": ["AE2", "M", "B", "R", "OW1", "JH", "IY0", "OW0"],
    "ambrose": ["AE1", "M", "B", "R", "OW2", "Z"],
    "ambrosia": ["AE0", "M", "B", "R", "OW1", "ZH", "AH0"],
    "ambrosial": ["AE0", "M", "B", "R", "OW1", "ZH", "AH0", "L"],
    "ambrosian": ["AE0", "M", "B", "R", "OW1", "Z", "AH0", "N"],
    "ambrosiano": ["AE0", "M", "B", "R", "OW2", "S", "IY0", "AA1", "N", "OW0"],
    "ambrosine": ["AA0", "M", "B", "R", "OW0", "S", "IY1", "N", "IY0"],
    "ambrosini": ["AA0", "M", "B", "R", "OW0", "S", "IY1", "N", "IY0"],
    "ambrosino": ["AA0", "M", "B", "R", "OW0", "S", "IY1", "N", "OW0"],
    "ambrosio": ["AE2", "M", "B", "R", "OW1", "S", "IY0", "OW0"],
    "ambrosius": ["AE1", "M", "B", "R", "AH0", "S", "IY0", "IH0", "S"],
    "ambs": ["AE1", "M", "Z"],
    "ambuehl": ["AE1", "M", "B", "UH0", "L"],
    "ambulance": ["AE1", "M", "B", "Y", "AH0", "L", "AH0", "N", "S"],
    "ambulances": ["AE1", "M", "B", "Y", "AH0", "L", "AH0", "N", "S", "IH0", "Z"],
    "ambulate": ["AE1", "M", "B", "Y", "AH0", "L", "EY2", "T"],
    "ambulator": ["AE1", "M", "B", "Y", "AH0", "L", "EY2", "T", "ER0"],
    "ambulatory": ["AE1", "M", "B", "Y", "AH0", "L", "AH0", "T", "AO2", "R", "IY0"],
    "amburgey": ["AE1", "M", "B", "ER0", "G", "IY0"],
    "amburn": ["AH0", "M", "B", "ER1", "N"],
    "ambush": ["AE1", "M", "B", "UH2", "SH"],
    "ambushed": ["AE1", "M", "B", "UH2", "SH", "T"],
    "ambushes": ["AE1", "M", "B", "UH0", "SH", "IH0", "Z"],
    "ambushing": ["AE1", "M", "B", "UH2", "SH", "IH0", "NG"],
    "amc": ["EY1", "EH2", "M", "S", "IY1"],
    "amca": ["AE1", "M", "K", "AH0"],
    "amcast": ["AE1", "M", "K", "AE2", "S", "T"],
    "amcole": ["AE1", "M", "K", "OW2", "L"],
    "amcor": ["AE1", "M", "K", "AO2", "R"],
    "amcore": ["AE1", "M", "K", "AO2", "R"],
    "amd": ["EY1", "EH2", "M", "D", "IY1"],
    "amdahl": ["AE1", "M", "D", "AA2", "L"],
    "amdahl's": ["AE1", "M", "D", "AA2", "L", "Z"],
    "amdec": ["AE1", "M", "D", "EH2", "K"],
    "amdek": ["AE1", "M", "D", "EH0", "K"],
    "amdur": ["AE1", "M", "D", "ER0"],
    "amdura": ["AE0", "M", "D", "UH1", "R", "AH0"],
    "ame": ["EY1", "M"],
    "ameche": ["AH0", "M", "IY1", "CH", "IY0"],
    "amedco": ["AH0", "M", "EH1", "D", "K", "OW0"],
    "amedee": ["AE1", "M", "IH0", "D", "IY0"],
    "ameen": ["AH0", "M", "IY1", "N"],
    "amelia": ["AH0", "M", "IY1", "L", "Y", "AH0"],
    "amelie": ["AA2", "M", "EH0", "L", "IY1"],
    "amelinda": ["AA2", "M", "EH0", "L", "IY1", "N", "D", "AH0"],
    "ameline": ["AA2", "M", "EH0", "L", "IY1", "N", "IY0"],
    "amelio": ["AH0", "M", "IY1", "L", "IY0", "OW0"],
    "ameliorate": ["AH0", "M", "IY1", "L", "Y", "ER0", "EY2", "T"],
    "ameliorated": ["AH0", "M", "IY1", "L", "Y", "ER0", "EY2", "T", "IH0", "D"],
    "amelioration": ["AH0", "M", "IY2", "L", "Y", "ER0", "EY1", "SH", "AH0", "N"],
    "amelita": ["AA0", "M", "EH0", "L", "IY1", "T", "AH0"],
    "amell": ["AA0", "M", "EY1", "L"],
    "amen": ["AA0", "M", "EH1", "N"],
    "amenable": ["AH0", "M", "IY1", "N", "AH0", "B", "AH0", "L"],
    "amenaces": ["AH0", "M", "EH1", "N", "AH0", "S", "AH0", "Z"],
    "amend": ["AH0", "M", "EH1", "N", "D"],
    "amendable": ["AH0", "M", "EH1", "N", "D", "AH0", "B", "AH0", "L"],
    "amended": ["AH0", "M", "EH1", "N", "D", "IH0", "D"],
    "amending": ["AH0", "M", "EH1", "N", "D", "IH0", "NG"],
    "amendment": ["AH0", "M", "EH1", "N", "D", "M", "AH0", "N", "T"],
    "amendment's": ["AH0", "M", "EH1", "N", "D", "M", "AH0", "N", "T", "S"],
    "amendments": ["AH0", "M", "EH1", "N", "D", "M", "AH0", "N", "T", "S"],
    "amendola": ["AA0", "M", "EH0", "N", "D", "OW1", "L", "AH0"],
    "amends": ["AH0", "M", "EH1", "N", "D", "Z"],
    "amenities": ["AH0", "M", "EH1", "N", "IH0", "T", "IY0", "Z"],
    "amenity": ["AH0", "M", "EH1", "N", "AH0", "T", "IY0"],
    "ament": ["AE1", "M", "IH0", "N", "T"],
    "amenta": ["AH0", "M", "EH1", "N", "T", "AH0"],
    "amer": ["EY1", "M", "ER0"],
    "amerada": ["AE2", "M", "ER0", "AA1", "D", "AH0"],
    "amerco": ["AH0", "M", "EH1", "R", "K", "OW0"],
    "amerford": ["EY1", "M", "ER0", "F", "ER0", "D"],
    "ameri": ["AH0", "M", "EH1", "R", "IY0"],
    "ameribanc": ["AH0", "M", "EH1", "R", "IH0", "B", "AE2", "NG", "K"],
    "america": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0"],
    "america's": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0", "Z"],
    "american": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0", "N"],
    "american's": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0", "N", "Z"],
    "americana": ["AH0", "M", "EH2", "R", "AH0", "K", "AE1", "N", "AH0"],
    "americana's": ["AH0", "M", "EH2", "R", "AH0", "K", "AE1", "N", "AH0", "Z"],
    "americanas": ["AH0", "M", "EH2", "R", "AH0", "K", "AE1", "N", "AH0", "Z"],
    "americanism": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0", "N", "IH2", "Z", "AH0", "M"],
    "americanization": ["AH0", "M", "EH2", "R", "AH0", "K", "AH0", "N", "AH0", "Z", "EY1", "SH", "AH0", "N"],
    "americanize": ["AH0", "M", "EH1", "R", "AH0", "K", "AH0", "N", "AY2", "Z"],
    "americanized": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0", "N", "AY2", "Z", "D"],
    "americano": ["AH0", "M", "EH2", "R", "IH0", "K", "AA1", "N", "OW0"],
    "americanos": ["AH0", "M", "EH2", "R", "IH0", "K", "AA1", "N", "OW0", "Z"],
    "americans": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0", "N", "Z"],
    "americans'": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0", "N", "Z"],
    "americar": ["AH0", "M", "EH1", "R", "IH0", "K", "AA2", "R"],
    "americare": ["AH0", "M", "EH1", "R", "IH0", "K", "EH2", "R"],
    "americares": ["AH0", "M", "EH1", "R", "IH0", "K", "EH2", "R", "Z"],
    "americas": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0", "Z"],
    "americas'": ["AH0", "M", "EH1", "R", "IH0", "K", "AH2", "Z"],
    "americium": ["AH0", "M", "EH0", "R", "IH1", "S", "IY2", "AH0", "M"],
    "americo": ["AH0", "M", "ER1", "AH0", "K", "OW0"],
    "americold": ["AH0", "M", "EH1", "R", "IH0", "K", "OW2", "L", "D"],
    "americorp": ["AH0", "M", "EH1", "R", "IH0", "K", "AO2", "R", "P"],
    "americorps": ["AH0", "M", "EH1", "R", "IH0", "K", "AO2", "R"],
    "americus": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0", "S"],
    "ameridata": ["AH0", "M", "EH1", "R", "AH0", "D", "AE2", "T", "AH0"],
    "amerifirst": ["AH0", "M", "EH1", "R", "IH0", "F", "ER0", "S", "T"],
    "amerifirst's": ["AH0", "M", "EH1", "R", "IH0", "F", "ER0", "S", "T", "S"],
    "amerigas": ["AH0", "M", "EH1", "R", "IH0", "G", "AE2", "S"],
    "amerigo": ["AA0", "M", "ER0", "IY1", "G", "OW0"],
    "amerihost": ["AH0", "M", "EH1", "R", "AH0", "HH", "OW2", "S", "T"],
    "amerika": ["AH0", "M", "EH1", "R", "IH0", "K", "AH0"],
    "amerindian": ["AE2", "M", "ER0", "IH1", "N", "D", "IY0", "AH0", "N"],
    "amerine": ["AA0", "M", "ER0", "IY1", "N", "IY0"],
    "ameritech": ["AH0", "M", "EH1", "R", "IH0", "T", "EH2", "K"],
    "ameritech's": ["AH0", "M", "EH1", "R", "IH0", "T", "EH2", "K", "S"],
    "ameritrust": ["AH0", "M", "EH1", "R", "IH0", "T", "R", "AH2", "S", "T"],
    "amerman": ["AE1", "M", "ER0", "M", "AH0", "N"],
    "amero": ["AA0", "M", "EH1", "R", "OW0"],
    "ameron": ["AE1", "M", "ER0", "AA0", "N"],
    "ameron's": ["AE1", "M", "ER0", "AA0", "N", "Z"],
    "amerongen": ["AE2", "M", "ER0", "AO1", "N", "JH", "AH0", "N"],
    "amersham": ["AE1", "M", "ER0", "SH", "AE2", "M"],
    "amerson": ["AE1", "M", "ER0", "S", "AH0", "N"],
    "amery": ["AE1", "M", "ER0", "IY0"],
    "ames": ["EY1", "M", "Z"],
    "ames'": ["EY1", "M", "Z"],
    "ames's": ["EY1", "M", "Z", "IH0", "Z"],
    "amesville": ["EY1", "M", "Z", "V", "IH0", "L"],
    "ametek": ["AE1", "M", "AH0", "T", "EH2", "K"],
    "ametek's": ["AE1", "M", "AH0", "T", "EH2", "K", "S"],
    "amethyst": ["AE1", "M", "IH0", "TH", "IH0", "S", "T"],
    "amev": ["AE1", "M", "EH0", "V"],
    "amex": ["AE1", "M", "EH2", "K", "S"],
    "amex's": ["AE1", "M", "EH0", "K", "S", "IH0", "Z"],
    "amexco": ["AH0", "M", "EH1", "K", "S", "K", "OW0"],
    "amexco's": ["AH0", "M", "EH1", "K", "S", "K", "OW0", "Z"],
    "amey": ["EY1", "M", "IY0"],
    "amezcua": ["AH0", "M", "EH1", "Z", "K", "Y", "UW0", "AH0"],
    "amezquita": ["AA0", "M", "EH0", "Z", "K", "W", "IY1", "T", "AH0"],
    "amfac": ["AE1", "M", "F", "AE0", "K"],
    "amfesco": ["AE0", "M", "F", "EH1", "S", "K", "OW0"],
    "amgen": ["AE1", "M", "JH", "EH0", "N"],
    "amgen's": ["AE1", "M", "JH", "EH0", "N", "Z"],
    "amharic": ["AA0", "M", "HH", "AA1", "R", "IH0", "K"],
    "amherst": ["AE1", "M", "ER0", "S", "T"],
    "amherstdale": ["AE1", "M", "ER0", "S", "T", "D", "EY2", "L"],
    "amhoist": ["AE0", "M", "HH", "OY1", "S", "T"],
    "ami": ["AA1", "M", "IY0"],
    "amiability": ["EY2", "M", "IY0", "AH0", "B", "IH1", "L", "AH0", "T", "IY0"],
    "amiable": ["EY1", "M", "IY0", "AH0", "B", "AH0", "L"],
    "amiably": ["EY1", "M", "IY0", "AH0", "B", "L", "IY0"],
    "amicable": ["AE1", "M", "IH0", "K", "AH0", "B", "AH0", "L"],
    "amicably": ["AE1", "M", "IH0", "K", "AH0", "B", "L", "IY0"],
    "amick": ["AE1", "M", "IH0", "K"],
    "amico": ["AA0", "M", "IY1", "K", "OW0"],
    "amicone": ["AE1", "M", "IH0", "K", "OW2", "N"],
    "amicus": ["AH0", "M", "IY1", "K", "AH0", "S"],
    "amid": ["AH0", "M", "IH1", "D"],
    "amide": ["EY1", "M", "AY2", "D"],
    "amides": ["EY1", "M", "AY2", "D", "Z"],
    "amidi": ["AA0", "M", "IY1", "D", "IY0"],
    "amidon": ["AE1", "M", "IH0", "D", "AA0", "N"],
    "amidships": ["AH0", "M", "IH1", "D", "SH", "IH0", "P", "S"],
    "amidst": ["AH0", "M", "IH1", "D", "S", "T"],
    "amie": ["AE1", "M", "IY0"],
    "amiga": ["AH0", "M", "IY1", "G", "AH0"],
    "amigo": ["AH0", "M", "IY1", "G", "OW2"],
    "amigos": ["AH0", "M", "IY1", "G", "OW2", "Z"],
    "amilia": ["AA0", "M", "IY1", "L", "IY0", "AH0"],
    "amin": ["AA0", "M", "IY1", "N"],
    "amine": ["EY2", "M", "IY1", "N"],
    "amino": ["AH0", "M", "IY1", "N", "OW0"],
    "aminta": ["AH0", "M", "IH1", "N", "T", "AH0"],
    "amiot": ["EY1", "M", "IY0", "AH0", "T"],
    "amiprilose": ["AH0", "M", "IH1", "P", "R", "AH0", "L", "OW2", "S"],
    "amir": ["AA0", "M", "IH1", "R"],
    "amir's": ["AA0", "M", "IH1", "R", "Z"],
    "amiram": ["AE1", "M", "ER0", "AE0", "M"],
    "amiran": ["AE1", "M", "IH0", "R", "AH0", "N"],
    "amirault": ["AE1", "M", "AY0", "R", "AW0", "L", "T"],
    "amirav": ["AE1", "M", "IH0", "R", "AE2", "V"],
    "amiri": ["AA0", "M", "IH1", "R", "IY0"],
    "amis": ["AE1", "M", "IH0", "S"],
    "amish": ["EY1", "M", "IH0", "SH"],
    "amison": ["AE1", "M", "IH0", "S", "AH0", "N"],
    "amiss": ["AH0", "M", "IH1", "S"],
    "amistad": ["AE1", "M", "AH0", "S", "T", "AE2", "D"],
    "amit": ["AA2", "M", "IY1", "T"],
    "amitabha": ["AH0", "M", "IY2", "T", "AA1", "B", "AH0"],
    "amitai": ["AE1", "M", "IH0", "T", "AY2"],
    "amity": ["AE1", "M", "IH0", "T", "IY0"],
    "amityville": ["AE1", "M", "IH0", "T", "IY0", "V", "IH2", "L"],
    "amman": ["AH0", "M", "AA1", "N"],
    "ammann": ["AE1", "M", "AH0", "N"],
    "ammeen": ["AH0", "M", "IY1", "N"],
    "ammerman": ["AE1", "M", "ER0", "M", "AH0", "N"],
    "ammeter": ["AE1", "M", "IY2", "T", "ER0"],
    "ammeters": ["AE1", "M", "IY2", "T", "ER0", "Z"],
    "ammirati": ["AA0", "M", "IH0", "R", "AA1", "T", "IY0"],
    "ammo": ["AE1", "M", "OW2"],
    "ammon": ["AE1", "M", "AH0", "N"],
    "ammonia": ["AH0", "M", "OW1", "N", "Y", "AH0"],
    "ammonite": ["AE1", "M", "AH0", "N", "AY2", "T"],
    "ammonites": ["AE1", "M", "AH0", "N", "AY2", "T", "S"],
    "ammonium": ["AH0", "M", "OW1", "N", "IY0", "AH0", "M"],
    "ammons": ["AE1", "M", "AH0", "N", "Z"],
    "ammunition": ["AE2", "M", "Y", "AH0", "N", "IH1", "SH", "AH0", "N"],
    "ammunitions": ["AE2", "M", "Y", "AH0", "N", "IH1", "SH", "AH0", "N", "Z"],
    "amnesia": ["AE0", "M", "N", "IY1", "ZH", "AH0"],
    "amnesiac": ["AE0", "M", "N", "IY1", "Z", "IY0", "AE2", "K"],
    "amnesties": ["AE1", "M", "N", "AH0", "S", "T", "IY0", "Z"],
    "amnesty": ["AE1", "M", "N", "AH0", "S", "T", "IY0"],
    "amnio": ["AE1", "M", "N", "IY0", "OW0"],
    "amniocentesis": ["AE2", "M", "N", "IY0", "OW0", "S", "EH2", "N", "T", "IY1", "S", "IH0", "S"],
    "amniotic": ["AE1", "M", "N", "IY0", "AO0", "T", "IH0", "K"],
    "amo": ["AA1", "M", "OW0"],
    "amoco": ["AE1", "M", "AH0", "K", "OW0"],
    "amoco's": ["AE1", "M", "AH0", "K", "OW0", "Z"],
    "amoeba": ["AH0", "M", "IY1", "B", "AH0"],
    "amoebas": ["AH0", "M", "IY1", "B", "AH0", "Z"],
    "amoebic": ["AH0", "M", "IY1", "B", "IH0", "K"],
    "amok": ["AH0", "M", "AH1", "K"],
    "amon": ["AA0", "M", "AO1", "N"],
    "among": ["AH0", "M", "AH1", "NG"],
    "amongst": ["AH0", "M", "AH1", "NG", "S", "T"],
    "amoolya": ["AH0", "M", "UW1", "L", "Y", "AH0"],
    "amor": ["AE1", "M", "ER0"],
    "amoral": ["EY0", "M", "AO1", "R", "AH0", "L"],
    "amore": ["AA1", "M", "AO0", "R"],
    "amorette": ["AE1", "M", "ER0", "EH2", "T"],
    "amorist": ["AE1", "M", "ER0", "AH0", "S", "T"],
    "amorita": ["AA0", "M", "AO0", "R", "IY1", "T", "AH0"],
    "amorosi": ["AA0", "M", "AO0", "R", "OW1", "S", "IY0"],
    "amoroso": ["AA0", "M", "AO0", "R", "OW1", "S", "OW0"],
    "amorous": ["AE1", "M", "ER0", "AH0", "S"],
    "amorphous": ["AH0", "M", "AO1", "R", "F", "AH0", "S"],
    "amortization": ["AE2", "M", "ER0", "T", "IH0", "Z", "EY1", "SH", "AH0", "N"],
    "amortize": ["AE1", "M", "ER0", "T", "AY2", "Z"],
    "amortized": ["AE1", "M", "ER0", "T", "AY2", "Z", "D"],
    "amortizing": ["AE1", "M", "ER0", "T", "AY2", "Z", "IH0", "NG"],
    "amoruso": ["AE2", "M", "ER0", "UW1", "S", "OW0"],
    "amory": ["EY1", "M", "ER0", "IY0"],
    "amos": ["EY1", "M", "AH0", "S"],
    "amos's": ["EY1", "M", "AH0", "S", "IH0", "Z"],
    "amoskeag": ["AE1", "M", "AH0", "S", "K", "EY2", "G"],
    "amoskeag's": ["AE1", "M", "AH0", "S", "K", "EY2", "G", "Z"],
    "amoss": ["AH0", "M", "AO1", "S"],
    "amount": ["AH0", "M", "AW1", "N", "T"],
    "amounted": ["AH0", "M", "AW1", "N", "IH0", "D"],
    "amounting": ["AH0", "M", "AW1", "N", "IH0", "NG"],
    "amounts": ["AH0", "M", "AW1", "N", "T", "S"],
    "amour": ["AA2", "M", "UW1", "R"],
    "amoxicillin": ["AH0", "M", "AO1", "K", "S", "AH0", "S", "IH2", "L", "IH0", "N"],
    "amp": ["AE1", "M", "P"],
    "ampad": ["AE1", "M", "P", "AE0", "D"],
    "ampal": ["AE1", "M", "P", "AH0", "L"],
    "amparan": ["AE1", "M", "P", "ER0", "AH0", "N"],
    "ampato": ["AA2", "M", "P", "AA1", "T", "OW0"],
    "ampco": ["AE1", "M", "P", "K", "OW0"],
    "amperage": ["AE1", "M", "P", "ER2", "IH0", "JH"],
    "ampere": ["AE1", "M", "P", "ER2"],
    "amperes": ["AE1", "M", "P", "ER2", "Z"],
    "ampersand": ["AE1", "M", "P", "ER0", "S", "AE2", "N", "D"],
    "ampex": ["AE1", "M", "P", "EH2", "K", "S"],
    "amphenol": ["AE1", "M", "F", "AH0", "N", "AO0", "L"],
    "amphetamine": ["AE0", "M", "F", "EH1", "T", "AH0", "M", "IY2", "N"],
    "amphetamines": ["AE0", "M", "F", "EH1", "T", "AH0", "M", "IY2", "N", "Z"],
    "amphibian": ["AE0", "M", "F", "IH1", "B", "IY0", "AH0", "N"],
    "amphibians": ["AE0", "M", "F", "IH1", "B", "IY0", "AH0", "N", "Z"],
    "amphibious": ["AE0", "M", "F", "IH1", "B", "IY0", "AH0", "S"],
    "amphibole": ["AE1", "M", "F", "IH0", "B", "OW2", "L"],
    "amphitheater": ["AE1", "M", "F", "AH0", "TH", "IY0", "EY1", "T", "ER0"],
    "amphitheaters": ["AE1", "M", "F", "AH0", "TH", "IY0", "EY1", "T", "ER0", "Z"],
    "amphitheatre": ["AE1", "M", "F", "AH0", "TH", "IY0", "EY1", "T", "ER0"],
    "amphophilic": ["AE2", "M", "F", "AH0", "F", "IH1", "L", "IH0", "K"],
    "amphora": ["AE1", "M", "F", "ER0", "AH0"],
    "amphorae": ["AE1", "M", "F", "ER0", "IY2"],
    "ample": ["AE1", "M", "P", "AH0", "L"],
    "amplicons": ["AE1", "M", "P", "L", "IH0", "K", "AO0", "N", "Z"],
    "amplification": ["AE2", "M", "P", "L", "AH0", "F", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "amplifications": ["AE2", "M", "P", "L", "AH0", "F", "AH0", "K", "EY1", "SH", "AH0", "N", "Z"],
    "amplified": ["AE1", "M", "P", "L", "AH0", "F", "AY2", "D"],
    "amplifier": ["AE1", "M", "P", "L", "AH0", "F", "AY2", "ER0"],
    "amplifiers": ["AE1", "M", "P", "L", "AH0", "F", "AY2", "ER0", "Z"],
    "amplifies": ["AE1", "M", "P", "L", "AH0", "F", "AY2", "Z"],
    "amplify": ["AE1", "M", "P", "L", "AH0", "F", "AY2"],
    "amplifying": ["AE1", "M", "P", "L", "AH0", "F", "AY2", "IH0", "NG"],
    "ampligen": ["AE1", "M", "P", "L", "IH0", "JH", "EH0", "N"],
    "amplitude": ["AE1", "M", "P", "L", "AH0", "T", "UW2", "D"],
    "amplocore": ["AE1", "M", "P", "L", "AH0", "K", "AO2", "R"],
    "amply": ["AE1", "M", "P", "L", "IY0"],
    "ampol": ["AE1", "M", "P", "AO0", "L"],
    "amputate": ["AE1", "M", "P", "Y", "AH0", "T", "EY2", "T"],
    "amputated": ["AE1", "M", "P", "Y", "AH0", "T", "EY2", "T", "IH0", "D"],
    "amputation": ["AE2", "M", "P", "Y", "AH0", "T", "EY1", "SH", "AH0", "N"],
    "amputations": ["AE2", "M", "P", "Y", "UW0", "T", "EY1", "SH", "AH0", "N", "Z"],
    "amputee": ["AE1", "M", "P", "Y", "AH0", "T", "IY1"],
    "amputees": ["AE1", "M", "P", "Y", "AH0", "T", "IY1", "Z"],
    "amr": ["AA1", "M", "ER0"],
    "amraam": ["AE0", "M", "R", "AA1", "M"],
    "amre": ["AE1", "M", "R", "AH0"],
    "amrein": ["AE1", "M", "R", "AY0", "N"],
    "amrep": ["AE1", "M", "R", "EH0", "P"],
    "amrhein": ["AE1", "M", "ER0", "HH", "AY2", "N"],
    "amrine": ["AE1", "M", "R", "IY0", "N"],
    "amritsar": ["AE1", "M", "R", "IH0", "T", "S", "AA2", "R"],
    "amro": ["AE1", "M", "R", "OW0"],
    "ams": ["AE1", "M", "Z"],
    "amsbaugh": ["AE1", "M", "Z", "B", "AO2"],
    "amsco": ["AE1", "M", "S", "K", "OW0"],
    "amsden": ["AE1", "M", "Z", "D", "AH0", "N"],
    "amsler": ["AE1", "M", "Z", "L", "ER0"],
    "amsouth": ["AE1", "M", "S", "AW2", "TH"],
    "amspacher": ["AE1", "M", "S", "P", "AH0", "K", "ER0"],
    "amstar": ["AE1", "M", "S", "T", "AA2", "R"],
    "amster": ["AE1", "M", "S", "T", "ER0"],
    "amsterdam": ["AE1", "M", "S", "T", "ER0", "D", "AE2", "M"],
    "amsterdam's": ["AE1", "M", "S", "T", "ER0", "D", "AE2", "M", "Z"],
    "amstrad": ["AE1", "M", "S", "T", "R", "AE2", "D"],
    "amstutz": ["AE1", "M", "S", "T", "AH0", "T", "S"],
    "amtech": ["AE1", "M", "T", "EH2", "K"],
    "amtrack": ["AE1", "M", "T", "R", "AE2", "K"],
    "amtrak": ["AE1", "M", "T", "R", "AE0", "K"],
    "amtrak's": ["AE1", "M", "T", "R", "AE2", "K", "S"],
    "amuck": ["AH0", "M", "AH1", "K"],
    "amulet": ["AE1", "M", "Y", "AH0", "L", "AH0", "T"],
    "amulets": ["AE1", "M", "Y", "AH0", "L", "AH0", "T", "S"],
    "amundsen": ["AA1", "M", "AH0", "N", "D", "S", "AH0", "N"],
    "amundson": ["AE1", "M", "AH0", "N", "D", "S", "AH0", "N"],
    "amuse": ["AH0", "M", "Y", "UW1", "Z"],
    "amused": ["AH0", "M", "Y", "UW1", "Z", "D"],
    "amusement": ["AH0", "M", "Y", "UW1", "Z", "M", "AH0", "N", "T"],
    "amusements": ["AH0", "M", "Y", "UW1", "Z", "M", "AH0", "N", "T", "S"],
    "amusements'": ["AH0", "M", "Y", "UW1", "Z", "M", "AH0", "N", "T", "S"],
    "amuses": ["AH0", "M", "Y", "UW1", "Z", "IH0", "Z"],
    "amusing": ["AH0", "M", "Y", "UW1", "Z", "IH0", "NG"],
    "amusingly": ["AH0", "M", "Y", "UW1", "Z", "IH0", "NG", "L", "IY0"],
    "amvest": ["AE1", "M", "V", "EH0", "S", "T"],
    "amvestor": ["AE2", "M", "V", "EH1", "S", "T", "ER0"],
    "amvestors": ["AE2", "M", "V", "EH1", "S", "T", "ER0", "Z"],
    "amway": ["AE1", "M", "W", "EY2"],
    "amy": ["EY1", "M", "IY0"],
    "amy's": ["EY1", "M", "IY0", "Z"],
    "amygdala": ["AE2", "M", "IH0", "G", "D", "AA1", "L", "AH0"],
    "amylin": ["AE1", "M", "IH0", "L", "IH2", "N"],
    "amyloid": ["AE1", "M", "IH0", "L", "OY2", "D"],
    "amyotrophic": ["AE2", "M", "IY0", "AH0", "T", "R", "OW1", "F", "IH0", "K"],
    "amyx": ["AE1", "M", "IH0", "K", "S"],
    "an": ["AH0", "N"],
    "ana": ["AE1", "N", "AH0"],
    "anabaptist": ["AE2", "N", "AH0", "B", "AE1", "P", "T", "AH0", "S", "T"],
    "anable": ["EY1", "N", "AH0", "B", "AH0", "L"],
    "anabolic": ["AE2", "N", "AH0", "B", "AA1", "L", "IH0", "K"],
    "anac": ["AE1", "N", "AE0", "K"],
    "anachronism": ["AH0", "N", "AE1", "K", "R", "AH0", "N", "IH2", "Z", "AH0", "M"],
    "anachronisms": ["AH0", "N", "AE1", "K", "R", "AH0", "N", "IH2", "Z", "AH0", "M", "Z"],
    "anachronistic": ["AH0", "N", "AE2", "K", "R", "AH0", "N", "IH1", "S", "T", "IH0", "K"],
    "anacin": ["AE1", "N", "AH0", "S", "IH0", "N"],
    "anacker": ["AE1", "N", "AH0", "K", "ER0"],
    "anacomp": ["AE1", "N", "AH0", "K", "AA2", "M", "P"],
    "anaconda": ["AE2", "N", "AH0", "K", "AA1", "N", "D", "AH0"],
    "anacortes": ["AE2", "N", "AH0", "K", "AO1", "R", "T", "AH0", "S"],
    "anacostia": ["AE2", "N", "AH0", "K", "AA1", "S", "T", "IY0", "AH0"],
    "anacostia's": ["AE2", "N", "AH0", "K", "AA1", "S", "T", "IY0", "AH0", "Z"],
    "anadarko": ["AE2", "N", "AH0", "D", "AA1", "R", "K", "OW0"],
    "anadarko's": ["AE2", "N", "AH0", "D", "AA1", "R", "K", "OW0", "Z"],
    "anaerobe": ["AE1", "N", "ER0", "OW2", "B"],
    "anaerobes": ["AE1", "N", "ER0", "OW2", "B", "Z"],
    "anaerobic": ["AE2", "N", "ER0", "OW1", "B", "IH0", "K"],
    "anaesthesia": ["AE2", "N", "AH0", "S", "TH", "IY1", "ZH", "AH0"],
    "anaesthesiologist": ["AE2", "N", "AH0", "S", "TH", "IY2", "Z", "IY0", "AA1", "L", "AH0", "JH", "IH0", "S", "T"],
    "anaesthesiologists": ["AE2", "N", "AH0", "S", "TH", "IY2", "Z", "IY0", "AA1", "L", "AH0", "JH", "IH0", "S", "T", "S"],
    "anaesthesiology": ["AE2", "N", "AH0", "S", "TH", "IY0", "Z", "IY0", "AA1", "L", "AH0", "JH", "IY0"],
    "anaesthetic": ["AE2", "N", "AH0", "S", "TH", "EH1", "T", "IH0", "K"],
    "anaesthetics": ["AE2", "N", "AH0", "S", "TH", "EH1", "T", "IH0", "K", "S"],
    "anaesthetist": ["AH0", "N", "EH1", "S", "TH", "EH0", "T", "IH0", "S", "T"],
    "anafranil": ["AH0", "N", "AE1", "F", "R", "AH0", "N", "IH2", "L"],
    "anagnos": ["AA0", "N", "AA1", "G", "N", "OW0", "Z"],
    "anagram": ["AE1", "N", "AH0", "G", "R", "AE2", "M"],
    "anaheim": ["AE1", "N", "AH0", "HH", "AY2", "M"],
    "anakin": ["AE1", "N", "AA0", "K", "IH2", "N"],
    "anal": ["EY1", "N", "AH0", "L"],
    "analgesic": ["AE2", "N", "AH0", "L", "JH", "IY1", "S", "IH0", "K"],
    "analgesics": ["AE2", "N", "AH0", "L", "JH", "IY1", "Z", "IH0", "K", "S"],
    "analog": ["AE1", "N", "AH0", "L", "AO2", "G"],
    "analogic": ["AE2", "N", "AH0", "L", "AA1", "JH", "IH0", "K"],
    "analogies": ["AH0", "N", "AE1", "L", "AH0", "JH", "IY0", "Z"],
    "analogous": ["AH0", "N", "AE1", "L", "AH0", "G", "AH0", "S"],
    "analogue": ["AE1", "N", "AH0", "L", "AO2", "G"],
    "analogy": ["AH0", "N", "AE1", "L", "AH0", "JH", "IY0"],
    "analysand": ["AE0", "N", "AE1", "L", "IH0", "Z", "AE2", "N", "D"],
    "analyses": ["AH0", "N", "AE1", "L", "AH0", "S", "IY2", "Z"],
    "analysis": ["AH0", "N", "AE1", "L", "IH0", "S", "IH0", "S"],
    "analyst": ["AE1", "N", "AH0", "L", "IH0", "S", "T"],
    "analyst's": ["AE1", "N", "AH0", "L", "IH0", "S", "T", "S"],
    "analysts": ["AE1", "N", "AH0", "L", "IH0", "S", "T", "S"],
    "analysts'": ["AE1", "N", "AH0", "L", "IH0", "S", "T", "S"],
    "analytic": ["AE2", "N", "AH0", "L", "IH1", "T", "IH0", "K"],
    "analytical": ["AE2", "N", "AH0", "L", "IH1", "T", "IH0", "K", "AH0", "L"],
    "analytically": ["AE2", "N", "AH0", "L", "IH1", "T", "IH0", "K", "L", "IY0"],
    "analyticity": ["AE2", "N", "AH0", "L", "AH0", "T", "IH1", "S", "AH0", "T", "IY0"],
    "analytics": ["AE2", "N", "AH0", "L", "IH1", "T", "IH0", "K", "S"],
    "analyzable": ["AE1", "N", "AH0", "L", "AY2", "Z", "AH0", "B", "AH0", "L"],
    "analyzand": ["AE2", "N", "AA1", "L", "IY2", "Z", "AA0", "N", "D"],
    "analyze": ["AE1", "N", "AH0", "L", "AY2", "Z"],
    "analyzed": ["AE1", "N", "AH0", "L", "AY2", "Z", "D"],
    "analyzer": ["AE1", "N", "AH0", "L", "AY2", "Z", "ER0"],
    "analyzers": ["AE1", "N", "AH0", "L", "AY2", "Z", "ER0", "Z"],
    "analyzes": ["AE1", "N", "AH0", "L", "AY2", "Z", "IH0", "Z"],
    "analyzing": ["AE1", "N", "AH0", "L", "AY2", "Z", "IH0", "NG"],
    "anamaria": ["AE2", "N", "AH0", "M", "AH0", "R", "IY1", "AH0"],
    "anand": ["AE1", "N", "AH0", "N", "D"],
    "anandale": ["AE1", "N", "AH0", "N", "D", "EY2", "L"],
    "anandeep": ["AA2", "N", "AA0", "N", "D", "IY1", "P"],
    "anania": ["AA0", "N", "AA1", "N", "IY0", "AH0"],
    "anantha": ["AH0", "N", "AE1", "N", "TH", "AH0"],
    "anaphora": ["AH0", "N", "AE1", "F", "ER0", "AH0"],
    "anaphylaxis": ["AE2", "N", "AH0", "F", "AH0", "L", "AE1", "K", "S", "IH0", "S"],
    "anaplasia": ["AE2", "N", "AH0", "P", "L", "EY1", "ZH", "Y", "AH0"],
    "anaplastic": ["AE2", "N", "AH0", "P", "L", "AE1", "S", "T", "IH0", "K"],
    "anarchic": ["AE0", "N", "AA1", "R", "K", "IH0", "K"],
    "anarchical": ["AE0", "N", "AA1", "R", "K", "IH0", "K", "AH0", "L"],
    "anarchist": ["AE1", "N", "ER0", "K", "IH2", "S", "T"],
    "anarchists": ["AE1", "N", "ER0", "K", "IH2", "S", "T", "S"],
    "anarchy": ["AE1", "N", "ER0", "K", "IY2"],
    "anaren": ["AE1", "N", "ER0", "AH0", "N"],
    "anas": ["AE1", "N", "AH0", "S"],
    "anasazi": ["AE2", "N", "AH0", "S", "AA1", "Z", "IY0"],
    "anasquan": ["AE1", "N", "AH0", "S", "K", "W", "AA0", "N"],
    "anast": ["AA1", "N", "AA0", "S", "T"],
    "anastas": ["AE1", "N", "AH0", "S", "T", "AH0", "Z"],
    "anastasi": ["AA0", "N", "AA0", "S", "T", "AA1", "S", "IY0"],
    "anastasia": ["AE0", "N", "AH0", "S", "T", "EY1", "ZH", "AH0"],
    "anastasio": ["AE2", "N", "AH0", "S", "T", "AA1", "S", "IY0", "OW0"],
    "anastos": ["AE1", "N", "AH0", "S", "T", "OW0", "Z"],
    "anathema": ["AH0", "N", "AE1", "TH", "AH0", "M", "AH0"],
    "anatola": ["AA0", "N", "AA0", "T", "OW1", "L", "AH0"],
    "anatole": ["AE1", "N", "AH0", "T", "OW2", "L"],
    "anatoli": ["AE2", "N", "AH0", "T", "OW1", "L", "IY0"],
    "anatolia": ["AE2", "N", "AH0", "T", "OW1", "L", "IY0", "AH0"],
    "anatolian": ["AE2", "N", "AH0", "T", "OW1", "L", "IY0", "AH0", "N"],
    "anatoly": ["AE2", "N", "AH0", "T", "OW1", "L", "IY0"],
    "anatomic": ["AE2", "N", "AH0", "T", "AA1", "M", "IH0", "K"],
    "anatomical": ["AE2", "N", "AH0", "T", "AA1", "M", "IH0", "K", "AH0", "L"],
    "anatomically": ["AE2", "N", "AH0", "T", "AA1", "M", "AH0", "K", "L", "IY0"],
    "anatomist": ["AH0", "N", "AE1", "T", "AH0", "M", "IH0", "S", "T"],
    "anatomy": ["AH0", "N", "AE1", "T", "AH0", "M", "IY0"],
    "anawalt": ["AE2", "N", "AH0", "W", "AA1", "L", "T"],
    "anaya": ["AA0", "N", "AA1", "Y", "AH0"],
    "anbari": ["AE0", "N", "B", "AA1", "R", "IY0"],
    "ancel": ["AH0", "N", "S", "EH1", "L"],
    "ancell": ["AA0", "N", "S", "EY1", "L"],
    "ancestor": ["AE1", "N", "S", "EH2", "S", "T", "ER0"],
    "ancestor's": ["AE1", "N", "S", "EH2", "S", "T", "ER0", "Z"],
    "ancestors": ["AE1", "N", "S", "EH2", "S", "T", "ER0", "Z"],
    "ancestors'": ["AE1", "N", "S", "EH2", "S", "T", "ER0", "Z"],
    "ancestral": ["AE0", "N", "S", "EH1", "S", "T", "R", "AH0", "L"],
    "ancestry": ["AE1", "N", "S", "EH0", "S", "T", "R", "IY0"],
    "ancheta": ["AA0", "N", "K", "EH1", "T", "AH0"],
    "ancho": ["AE1", "N", "CH", "OW0"],
    "anchondo": ["AA0", "N", "K", "OW1", "N", "D", "OW0"],
    "anchor": ["AE1", "NG", "K", "ER0"],
    "anchor's": ["AE1", "NG", "K", "ER0", "Z"],
    "anchorage": ["AE1", "NG", "K", "R", "IH0", "JH"],
    "anchored": ["AE1", "NG", "K", "ER0", "D"],
    "anchoring": ["AE1", "NG", "K", "ER0", "IH0", "NG"],
    "anchorman": ["AE1", "NG", "K", "ER0", "M", "AH0", "N"],
    "anchormen": ["AE1", "NG", "K", "ER0", "M", "EH1", "N"],
    "anchors": ["AE1", "NG", "K", "ER0", "Z"],
    "anchovies": ["AE1", "N", "CH", "OW2", "V", "IY0", "Z"],
    "anchovy": ["AE1", "N", "CH", "OW2", "V", "IY0"],
    "ancient": ["EY1", "N", "SH", "AH0", "N", "T"],
    "ancients": ["EY1", "N", "SH", "AH0", "N", "T", "S"],
    "ancillary": ["AE1", "N", "S", "AH0", "L", "EH2", "R", "IY0"],
    "ancira": ["AA0", "N", "CH", "IH1", "R", "AH0"],
    "ancona": ["AA0", "N", "K", "OW1", "N", "AH0"],
    "ancrum": ["AH0", "N", "K", "R", "AH1", "M"],
    "anctil": ["AE1", "NG", "K", "T", "IH0", "L"],
    "and": ["AE1", "N", "D"],
    "andal": ["AE1", "N", "D", "AH0", "L"],
    "andalusia": ["AE2", "N", "D", "AH0", "L", "UW1", "ZH", "AH0"],
    "andalusian": ["AE2", "N", "D", "AH0", "L", "UW1", "SH", "AH0", "N"],
    "andante": ["AA0", "N", "D", "AA1", "N", "T", "EY0"],
    "andantino": ["AA2", "N", "D", "AA2", "N", "T", "IY1", "N", "OW0"],
    "andean": ["AE1", "N", "D", "IY0", "AH0", "N"],
    "andel": ["AE1", "N", "D", "AH0", "L"],
    "ander": ["AE1", "N", "D", "ER0"],
    "andera": ["AE1", "N", "D", "ER0", "AH0"],
    "anderberg": ["AE1", "N", "D", "ER0", "B", "ER0", "G"],
    "anderegg": ["AE1", "N", "D", "ER0", "IH0", "G"],
    "anderle": ["AE1", "N", "D", "ER0", "AH0", "L"],
    "anderlini": ["AE2", "N", "D", "ER0", "L", "IY1", "N", "IY0"],
    "anderman": ["AE1", "N", "D", "ER0", "M", "AH0", "N"],
    "anders": ["AE1", "N", "D", "ER0", "Z"],
    "andersen": ["AE1", "N", "D", "ER0", "S", "AH0", "N"],
    "andersen's": ["AE1", "N", "D", "ER0", "S", "AH0", "N", "Z"],
    "anderson": ["AE1", "N", "D", "ER0", "S", "AH0", "N"],
    "anderson's": ["AE1", "N", "D", "ER0", "S", "AH0", "N", "Z"],
    "andersons": ["AE1", "N", "D", "ER0", "S", "AH0", "N", "Z"],
    "andersonville": ["AE1", "N", "D", "ER0", "S", "AH0", "N", "V", "IH0", "L"],
    "andersson": ["AE1", "N", "D", "ER0", "S", "AH0", "N"],
    "andert": ["AE1", "N", "D", "ER0", "T"],
    "anderton": ["AE1", "N", "D", "ER0", "T", "AH0", "N"],
    "andes": ["AE1", "N", "D", "IY0", "Z"],
    "andesite": ["AE1", "N", "D", "IH0", "S", "AY2", "T"],
    "andi": ["AE1", "N", "D", "IY0"],
    "andie": ["AE1", "N", "D", "IY0"],
    "anding": ["AE1", "N", "D", "IH0", "NG"],
    "andino": ["AA0", "N", "D", "IY1", "N", "OW0"],
    "andiron": ["AE1", "N", "D", "AY2", "ER0", "N"],
    "andis": ["AE1", "N", "D", "IH0", "S"],
    "andler": ["AE1", "N", "D", "L", "ER0"],
    "ando": ["AE1", "N", "D", "OW0"],
    "andolina": ["AA0", "N", "D", "OW0", "L", "IY1", "N", "AH0"],
    "andonian": ["AE2", "N", "D", "OW1", "N", "IY0", "AH0", "N"],
    "andoras": ["AE0", "N", "D", "AO1", "R", "AH0", "Z"],
    "andorra": ["AE0", "N", "D", "AO1", "R", "AH0"],
    "andover": ["AE1", "N", "D", "OW0", "V", "ER0"],
    "andrada": ["AA0", "N", "D", "R", "AA1", "D", "AH0"],
    "andrade": ["AE1", "N", "D", "R", "EY2", "D"],
    "andrae": ["AA1", "N", "D", "R", "AY0"],
    "andraki": ["AE0", "N", "D", "AE1", "K", "IY0"],
    "andras": ["AA1", "N", "D", "R", "AH0", "S"],
    "andre": ["AA1", "N", "D", "R", "EY2"],
    "andrea": ["AA2", "N", "D", "R", "EY1", "AH0"],
    "andrea's": ["AA2", "N", "D", "R", "EY1", "AH0", "Z"],
    "andreae": ["AA0", "N", "D", "R", "EY1", "AA0"],
    "andreana": ["AE2", "N", "D", "R", "IY2", "AA1", "N", "AA0"],
    "andreani": ["AE2", "N", "D", "R", "IY2", "AA1", "N", "IY0"],
    "andreano": ["AE2", "N", "D", "R", "IY2", "AA1", "N", "OW0"],
    "andreas": ["AA0", "N", "D", "R", "EY1", "AH0", "S"],
    "andreasen": ["AE1", "N", "D", "R", "IY0", "S", "AH0", "N"],
    "andreason": ["AE2", "N", "D", "R", "IY1", "S", "AH0", "N"],
    "andreassen": ["AE1", "N", "D", "R", "AH0", "S", "AH0", "N"],
    "andree": ["AH0", "N", "D", "R", "IY1"],
    "andreen": ["AH0", "N", "D", "R", "IY1", "N"],
    "andrei": ["AE1", "N", "D", "R", "EY2"],
    "andreini": ["AA0", "N", "D", "R", "EY0", "IY1", "N", "IY0"],
    "andrej": ["AA1", "N", "D", "R", "EY0"],
    "andren": ["AE1", "N", "D", "ER0", "AH0", "N"],
    "andreoli": ["AA0", "N", "D", "R", "EY0", "OW1", "L", "IY0"],
    "andreoni": ["AA0", "N", "D", "R", "EY0", "OW1", "N", "IY0"],
    "andreotti": ["AE2", "N", "D", "R", "IY0", "AA1", "D", "IY0"],
    "andreozzi": ["AA0", "N", "D", "R", "IY0", "AA1", "T", "S", "IY0"],
    "andrepont": ["AA0", "N", "D", "R", "EY1", "P", "OW0", "N", "T"],
    "andres": ["AE1", "N", "D", "R", "EY0", "Z"],
    "andresen": ["AE0", "N", "D", "R", "IY1", "S", "AH0", "N"],
    "andreski": ["AE0", "N", "D", "R", "EH1", "S", "K", "IY0"],
    "andress": ["AA1", "N", "D", "R", "EH0", "S"],
    "andretti": ["AE2", "N", "D", "R", "EH1", "T", "IY0"],
    "andretti's": ["AE2", "N", "D", "R", "EH1", "T", "IY0", "Z"],
    "andreu": ["AE1", "N", "D", "R", "UW0"],
    "andrew": ["AE1", "N", "D", "R", "UW0"],
    "andrew's": ["AE1", "N", "D", "R", "UW2", "Z"],
    "andrews": ["AE1", "N", "D", "R", "UW2", "Z"],
    "andrews'": ["AE1", "N", "D", "R", "UW2", "Z"],
    "andrey": ["AE1", "N", "D", "R", "IY0"],
    "andrezak": ["AE1", "N", "D", "R", "AH0", "Z", "AE0", "K"],
    "andria": ["AE1", "N", "D", "R", "IY0", "AH0"],
    "andriana": ["AA0", "N", "D", "R", "IY0", "AE1", "N", "AH0"],
    "andriano": ["AA0", "N", "D", "R", "IY0", "AA1", "N", "OW0"],
    "andric": ["AE1", "N", "D", "R", "IH0", "K"],
    "andrich": ["AE1", "N", "D", "R", "IH0", "K"],
    "andrick": ["AE1", "N", "D", "R", "IH0", "K"],
    "andries": ["AH0", "N", "D", "R", "IY1", "Z"],
    "andriessen": ["AE2", "N", "D", "R", "IY1", "S", "AH0", "N"],
    "andringa": ["AA0", "N", "D", "R", "IY1", "NG", "G", "AH0"],
    "andriola": ["AA0", "N", "D", "R", "IY0", "OW1", "L", "AH0"],
    "andrist": ["AE1", "N", "D", "R", "IH0", "S", "T"],
    "androgynous": ["AE0", "N", "D", "R", "AO1", "JH", "AH0", "N", "AH0", "S"],
    "androgyny": ["AE0", "N", "D", "R", "AO1", "JH", "AH0", "N", "IY0"],
    "android": ["AE1", "N", "D", "R", "OY2", "D"],
    "androids": ["AE1", "N", "D", "R", "OY2", "D", "Z"],
    "andromeda": ["AE0", "N", "D", "R", "AA1", "M", "AH0", "D", "AH0"],
    "andropov": ["AE0", "N", "D", "R", "AA1", "P", "AA2", "V"],
    "andros": ["AE1", "N", "D", "R", "AA0", "S"],
    "andrus": ["AE1", "N", "D", "R", "AH0", "S"],
    "andruskevich": ["AE2", "N", "D", "R", "AH0", "S", "EH1", "V", "IH0", "CH"],
    "andry": ["AE1", "N", "D", "R", "IY0"],
    "andrzej": ["AA1", "N", "D", "R", "EY2"],
    "andrzejewski": ["AH0", "N", "JH", "EY0", "EH1", "F", "S", "K", "IY0"],
    "ands": ["AE1", "N", "D", "Z"],
    "andujar": ["AA0", "N", "D", "UW0", "Y", "AA1", "R"],
    "andy": ["AE1", "N", "D", "IY0"],
    "andy's": ["AE1", "N", "D", "IY0", "Z"],
    "ane": ["AE1", "N"],
    "anecdotal": ["AE2", "N", "IH0", "K", "D", "OW1", "T", "AH0", "L"],
    "anecdotally": ["AE2", "N", "IH0", "K", "D", "OW1", "T", "AH0", "L", "IY0"],
    "anecdote": ["AE1", "N", "AH0", "K", "D", "OW2", "T"],
    "anecdotes": ["AE1", "N", "IH0", "K", "D", "OW2", "T", "S"],
    "anello": ["AH0", "N", "EH1", "L", "OW0"],
    "anemia": ["AH0", "N", "IY1", "M", "IY0", "AH0"],
    "anemias": ["AH0", "N", "IY1", "M", "IY0", "AH0", "Z"],
    "anemic": ["AH0", "N", "IY1", "M", "IH0", "K"],
    "anemometer": ["AE2", "N", "AH0", "M", "AA1", "M", "AH0", "T", "ER0"],
    "anemone": ["AH0", "N", "EH1", "M", "AH0", "N", "IY0"],
    "anencephalic": ["AE0", "N", "IH0", "N", "S", "EH1", "F", "AH0", "L", "IH0", "K"],
    "anencephaly": ["AE0", "N", "IH0", "N", "S", "EH1", "F", "AH0", "L", "IY0"],
    "anestachio": ["AE2", "N", "IH0", "S", "T", "AE1", "CH", "IY0", "OW0"],
    "anesthesia": ["AE2", "N", "IH0", "S", "TH", "IY1", "ZH", "AH0"],
    "anesthesiologist": ["AE2", "N", "AH0", "S", "TH", "IY2", "Z", "IY0", "AA1", "L", "AH0", "JH", "AH0", "S", "T"],
    "anesthesiologists": ["AE2", "N", "AH0", "S", "TH", "IY2", "Z", "IY0", "AA1", "L", "AH0", "JH", "AH0", "S", "T", "S"],
    "anesthesiology": ["AE2", "N", "AH0", "S", "TH", "IY0", "Z", "IY0", "AA1", "L", "AH0", "JH", "IY0"],
    "anesthetic": ["AE2", "N", "AH0", "S", "TH", "EH1", "T", "IH0", "K"],
    "anesthetics": ["AE2", "N", "AH0", "S", "TH", "EH1", "T", "IH0", "K", "S"],
    "anesthetist": ["AH0", "N", "EH1", "S", "TH", "AH0", "T", "AH0", "S", "T"],
    "anette": ["AH0", "N", "EH1", "T"],
    "aneurism": ["AE1", "N", "Y", "UH0", "R", "IH2", "Z", "M"],
    "aneurysm": ["AE1", "N", "Y", "UH0", "R", "IH2", "Z", "M"],
    "anew": ["AH0", "N", "Y", "UW1"],
    "anfal": ["AE1", "N", "F", "AA0", "L"],
    "anfinson": ["AE1", "N", "F", "IH0", "N", "S", "AH0", "N"],
    "ang": ["AE1", "NG"],
    "ange": ["EY1", "N", "JH"],
    "angel": ["EY1", "N", "JH", "AH0", "L"],
    "angel's": ["EY1", "N", "JH", "AH0", "L", "Z"],
    "angela": ["AE1", "N", "JH", "AH0", "L", "AH0"],
    "angela's": ["AE1", "N", "JH", "AH0", "L", "AH0", "Z"],
    "angeleno": ["AE2", "N", "JH", "AH0", "L", "IY1", "N", "OW0"],
    "angelenos": ["AE2", "N", "JH", "AH0", "L", "IY1", "N", "OW0", "Z"],
    "angeles": ["AE1", "N", "JH", "AH0", "L", "IH0", "S"],
    "angeles'": ["AE1", "N", "JH", "AH0", "L", "IY2", "Z"],
    "angeles's": ["AE1", "N", "JH", "AH0", "L", "IH0", "S", "IH0", "Z"],
    "angeletti": ["AA0", "NG", "G", "EH0", "L", "EH1", "T", "IY0"],
    "angelfish": ["EY1", "N", "JH", "AH0", "L", "F", "IH2", "SH"],
    "angeli": ["AA0", "NG", "G", "EH1", "L", "IY0"],
    "angelic": ["AE2", "N", "JH", "EH1", "L", "IH0", "K"],
    "angelica": ["AE1", "N", "JH", "AH0", "L", "IY2", "K", "AH0"],
    "angelically": ["AE0", "N", "JH", "EH1", "L", "IH0", "K", "L", "IY0"],
    "angelicas": ["AE0", "N", "JH", "EH1", "L", "IH0", "K", "AH0", "Z"],
    "angelico": ["AA0", "NG", "G", "EH0", "L", "IY1", "K", "OW0"],
    "angelika": ["AE0", "N", "JH", "EH1", "L", "IH2", "K", "AH0"],
    "angelillo": ["AA0", "NG", "G", "EH0", "L", "IH1", "L", "OW0"],
    "angelina": ["AE0", "N", "JH", "EH0", "L", "IY1", "N", "AH0"],
    "angeline": ["AE1", "N", "JH", "AH0", "L", "IY0", "N"],
    "angelini": ["AA0", "NG", "G", "EH0", "L", "IY1", "N", "IY0"],
    "angelino": ["AA2", "NG", "G", "EH0", "L", "IY1", "N", "OW0"],
    "angelino's": ["AA2", "NG", "G", "EH0", "L", "IY1", "N", "OW0", "Z"],
    "angelinos": ["AE2", "NG", "G", "AH0", "L", "IY1", "N", "OW0", "Z"],
    "angelique": ["AE2", "N", "JH", "EH0", "L", "IY1", "K"],
    "angelita": ["AA0", "NG", "G", "EH0", "L", "IY1", "T", "AH0"],
    "angell": ["EY1", "N", "JH", "AH0", "L"],
    "angelle": ["EY0", "NG", "G", "EH1", "L"],
    "angello": ["AE2", "N", "JH", "EH1", "L", "OW0"],
    "angelo": ["AE1", "N", "JH", "AH0", "L", "OW2"],
    "angelo's": ["AE1", "N", "JH", "AH0", "L", "OW2", "Z"],
    "angeloff": ["AE1", "N", "JH", "IH0", "L", "AO0", "F"],
    "angelone": ["AA0", "NG", "G", "EH0", "L", "OW1", "N", "IY0"],
    "angeloni": ["AA0", "NG", "G", "EH0", "L", "OW1", "N", "IY0"],
    "angelos": ["AE1", "N", "JH", "AH0", "L", "OW2", "Z"],
    "angelou": ["AE1", "N", "JH", "AH0", "L", "UW2"],
    "angeloz": ["AE1", "N", "JH", "AH0", "L", "OW2", "Z"],
    "angels": ["EY1", "N", "JH", "AH0", "L", "Z"],
    "angels'": ["EY1", "N", "JH", "AH0", "L", "Z"],
    "angelucci": ["AA0", "NG", "G", "EH0", "L", "UW1", "CH", "IY0"],
    "anger": ["AE1", "NG", "G", "ER0"],
    "angered": ["AE1", "NG", "G", "ER0", "D"],
    "angerer": ["AE1", "NG", "G", "ER0", "ER0"],
    "angering": ["AE1", "NG", "G", "ER0", "IH0", "NG"],
    "angerman": ["AE1", "NG", "ER0", "M", "AH0", "N"],
    "angermeier": ["EY1", "NG", "G", "ER0", "M", "AY0", "ER0"],
    "angers": ["AE1", "NG", "G", "ER0", "Z"],
    "angert": ["EY1", "NG", "G", "ER0", "T"],
    "angevine": ["EY1", "NG", "G", "IH0", "V", "AY0", "N"],
    "angi": ["AE1", "N", "JH", "IY0"],
    "angie": ["AE1", "N", "JH", "IY0"],
    "angier": ["AE1", "N", "JH", "IY0", "ER0"],
    "angina": ["AE0", "N", "JH", "AY1", "N", "AH0"],
    "angio": ["AE1", "N", "JH", "IY2", "OW0"],
    "angiogenesis": ["AE2", "N", "JH", "IY0", "OW0", "JH", "EH1", "N", "AH0", "S", "AH0", "S"],
    "angiogram": ["AE1", "N", "JH", "IY2", "OW0", "G", "R", "AE2", "M"],
    "angiomedic": ["AE2", "N", "JH", "IY2", "OW0", "M", "EH1", "D", "IH0", "K"],
    "angiomedics": ["AE2", "N", "JH", "IY2", "OW0", "M", "EH1", "D", "IH0", "K", "S"],
    "angioplasty": ["AE2", "N", "JH", "IY2", "AH0", "P", "L", "AE1", "S", "T", "IY0"],
    "angiotensin": ["AE2", "N", "JH", "IY2", "OW0", "T", "EH1", "N", "S", "IH0", "N"],
    "angle": ["AE1", "NG", "G", "AH0", "L"],
    "angled": ["AE1", "NG", "G", "AH0", "L", "D"],
    "anglemyer": ["AE1", "NG", "G", "AH0", "L", "M", "AY2", "ER0"],
    "anglen": ["AE1", "NG", "G", "AH0", "L", "AH0", "N"],
    "angler": ["AE1", "NG", "G", "L", "ER0"],
    "anglers": ["AE1", "NG", "G", "L", "ER0", "Z"],
    "angles": ["AE1", "NG", "G", "AH0", "L", "Z"],
    "angleton": ["AE1", "NG", "G", "AH0", "L", "T", "AH0", "N"],
    "angley": ["AE1", "NG", "G", "L", "IY0"],
    "anglia": ["AE1", "NG", "G", "L", "IY0", "AH0"],
    "anglican": ["AE1", "NG", "G", "L", "AH0", "K", "AH0", "N"],
    "anglicans": ["AE1", "NG", "G", "L", "IH0", "K", "AH0", "N", "Z"],
    "anglicize": ["AE1", "NG", "L", "IH0", "S", "AY2", "Z"],
    "anglicized": ["AE1", "NG", "L", "IH0", "S", "AY2", "Z", "D"],
    "anglim": ["AE1", "NG", "G", "L", "IH0", "M"],
    "anglin": ["AE1", "NG", "G", "L", "IH0", "N"],
    "angling": ["AE1", "NG", "G", "L", "IH0", "NG"],
    "anglo": ["AE1", "NG", "G", "L", "OW0"],
    "anglo-catholicism": ["AE1", "NG", "G", "L", "OW0", "K", "AH0", "TH", "AO1", "L", "AH0", "S", "IH2", "Z", "AH0", "M"],
    "anglophile": ["AE1", "N", "G", "L", "AH0", "F", "AY2", "L"],
    "anglophone": ["AE1", "N", "G", "L", "AH0", "F", "OW2", "N"],
    "anglophones": ["AE1", "N", "G", "L", "AH0", "F", "OW2", "N", "Z"],
    "anglos": ["AE1", "NG", "G", "L", "OW0", "S"],
    "angola": ["AE0", "NG", "G", "OW1", "L", "AH0"],
    "angola's": ["AE0", "NG", "G", "OW1", "L", "AH0", "Z"],
    "angolan": ["AE1", "NG", "G", "OW0", "L", "AH0", "N"],
    "angolans": ["AE1", "NG", "G", "OW0", "L", "AH0", "N", "Z"],
    "angora": ["AE0", "NG", "G", "AO1", "R", "AH0"],
    "angoras": ["AE0", "NG", "G", "AO1", "R", "AH0", "Z"],
    "angotti": ["AA0", "NG", "G", "OW1", "T", "IY0"],
    "angove": ["AA0", "NG", "G", "OW1", "V", "IY0"],
    "angrier": ["AE1", "NG", "G", "R", "IY0", "ER0"],
    "angriest": ["AE1", "NG", "G", "R", "IY0", "AH0", "S", "T"],
    "angrily": ["AE1", "NG", "G", "R", "AH0", "L", "IY0"],
    "angriness": ["AE1", "NG", "G", "R", "IY0", "N", "EH2", "S"],
    "angry": ["AE1", "NG", "G", "R", "IY0"],
    "angst": ["AA1", "NG", "K", "S", "T"],
    "angstadt": ["AE1", "NG", "S", "T", "AE0", "T"],
    "angstrom": ["AE1", "NG", "S", "T", "R", "AH0", "M"],
    "angstroms": ["AE1", "NG", "S", "T", "R", "AH0", "M", "Z"],
    "anguiano": ["AA0", "NG", "G", "IY0", "AA1", "N", "OW0"],
    "anguilla": ["AE2", "NG", "W", "IH1", "L", "AH0"],
    "anguish": ["AE1", "NG", "G", "W", "IH0", "SH"],
    "anguished": ["AE1", "NG", "G", "W", "IH0", "SH", "T"],
    "anguishing": ["AE1", "NG", "G", "W", "IH0", "SH", "IH0", "NG"],
    "angular": ["AE1", "NG", "G", "Y", "AH0", "L", "ER0"],
    "angulate": ["AE1", "NG", "G", "Y", "UW0", "L", "EY2", "T"],
    "angulated": ["AE1", "NG", "G", "Y", "UW0", "L", "EY2", "T", "IH0", "D"],
    "angulo": ["AA0", "NG", "G", "UW1", "L", "OW0"],
    "angus": ["AE1", "NG", "G", "AH0", "S"],
    "angy": ["AE1", "N", "JH", "IY0"],
    "anhalt": ["AE1", "N", "HH", "AH0", "L", "T"],
    "anheuser": ["AE1", "N", "HH", "AY2", "Z", "ER0"],
    "anheuser's": ["AE2", "N", "HH", "Y", "UW1", "Z", "ER0", "Z"],
    "anhydride": ["AE0", "N", "HH", "AY1", "D", "R", "IH0", "D"],
    "aniak": ["AE1", "N", "IY0", "AE0", "K"],
    "anibal": ["AE1", "N", "IH0", "B", "AH0", "L"],
    "anikst": ["AE1", "N", "IH0", "K", "S", "T"],
    "aniline": ["AE1", "N", "AH0", "L", "IY2", "N"],
    "animal": ["AE1", "N", "AH0", "M", "AH0", "L"],
    "animal's": ["AE1", "N", "AH0", "M", "AH0", "L", "Z"],
    "animals": ["AE1", "N", "AH0", "M", "AH0", "L", "Z"],
    "animals'": ["AE1", "N", "AH0", "M", "AH0", "L", "Z"],
    "animate": ["AE1", "N", "AH0", "M", "EY2", "T"],
    "animated": ["AE1", "N", "AH0", "M", "EY2", "T", "IH0", "D"],
    "animates": ["AE1", "N", "AH0", "M", "EY2", "T", "S"],
    "animating": ["AE2", "N", "AH0", "M", "EY1", "T", "IH0", "NG", "G"],
    "animation": ["AE2", "N", "AH0", "M", "EY1", "SH", "AH0", "N"],
    "animations": ["AE2", "N", "AH0", "M", "EY1", "SH", "AH0", "N", "Z"],
    "animator": ["AE1", "N", "AH0", "M", "EY2", "T", "ER0"],
    "animators": ["AE1", "N", "AH0", "M", "EY2", "T", "ER0", "Z"],
    "anime": ["AE2", "N", "IH0", "M", "EY1"],
    "animism": ["AE1", "N", "AH0", "M", "IH2", "Z", "AH0", "M"],
    "animist": ["AE1", "N", "AH0", "M", "AH0", "S", "T"],
    "animists": ["AE1", "N", "AH0", "M", "AH0", "S", "T", "S"],
    "animosities": ["AE2", "N", "AH0", "M", "AA1", "S", "AH0", "T", "IY0", "Z"],
    "animosity": ["AE2", "N", "AH0", "M", "AA1", "S", "AH0", "T", "IY0"],
    "animous": ["AE1", "N", "IH0", "M", "AH0", "S"],
    "animus": ["AE1", "N", "IH0", "M", "AH0", "S"],
    "aninat": ["AE1", "N", "IH0", "N", "AE0", "T"],
    "anion": ["AE1", "N", "AY2", "AO0", "N"],
    "anions": ["AE1", "N", "AY2", "AO0", "N", "Z"],
    "anisa": ["AE0", "N", "IY1", "S", "AH0"],
    "anise": ["AE1", "N", "AH0", "S"],
    "aniseed": ["AE1", "N", "AH0", "S", "IY2", "D"],
    "anisette": ["AE2", "N", "AH0", "S", "EH1", "T"],
    "aniston": ["AE1", "N", "AH0", "S", "T", "AH0", "N"],
    "anita": ["AH0", "N", "IY1", "T", "AH0"],
    "anitec": ["AE1", "N", "IH0", "T", "EH2", "K"],
    "anitole": ["AE1", "N", "IH0", "T", "OW0", "L"],
    "anixter": ["AE1", "N", "IH0", "K", "S", "T", "ER0"],
    "anja": ["AA1", "N", "JH", "AH0"],
    "anjelica": ["AE0", "N", "JH", "EH1", "L", "AH0", "K", "AH0"],
    "ankara": ["AE1", "NG", "K", "ER0", "AH0"],
    "ankara's": ["AE1", "NG", "K", "ER0", "AH0", "Z"],
    "ankeney": ["AH0", "NG", "K", "EH1", "N", "IY0"],
    "ankeny": ["AH0", "NG", "K", "IY1", "N", "IY0"],
    "anker": ["AE1", "NG", "K", "ER0"],
    "ankerium": ["AE0", "NG", "K", "ER1", "IY0", "AH0", "M"],
    "ankh": ["AE1", "N", "K"],
    "ankita": ["AE2", "N", "K", "IY1", "T", "AH0"],
    "anklam": ["AE1", "NG", "K", "L", "AH0", "M"],
    "ankle": ["AE1", "NG", "K", "AH0", "L"],
    "anklebone": ["AE1", "NG", "K", "AH0", "L", "B", "OW2", "N"],
    "ankles": ["AE1", "NG", "K", "AH0", "L", "Z"],
    "anklet": ["AE1", "NG", "K", "L", "IH0", "T"],
    "anklets": ["AE1", "NG", "K", "L", "AH0", "T", "S"],
    "ankney": ["AE1", "NG", "K", "N", "IY0"],
    "ankrom": ["AE1", "NG", "K", "R", "AH0", "M"],
    "ankrum": ["AE1", "NG", "K", "R", "AH0", "M"],
    "ann": ["AE1", "N"],
    "ann's": ["AE1", "N", "Z"],
    "anna": ["AE1", "N", "AH0"],
    "anna's": ["AE1", "N", "AH0", "Z"],
    "annabel": ["AE1", "N", "AH0", "B", "EH2", "L"],
    "annabella": ["AE2", "N", "AH0", "B", "EH1", "L", "AH0"],
    "annabelle": ["AE1", "N", "AH0", "B", "AH0", "L"],
    "annabeth": ["AE1", "N", "AH0", "B", "EH2", "TH"],
    "annable": ["AE1", "N", "AH0", "B", "AH0", "L"],
    "annal": ["AE1", "N", "AH0", "L"],
    "annals": ["AE1", "N", "AH0", "L", "Z"],
    "annamese": ["AE2", "N", "AH0", "M", "IY1", "Z"],
    "annan": ["AE1", "N", "AH0", "N"],
    "annandale": ["AE1", "N", "AH0", "N", "D", "EY2", "L"],
    "annapolis": ["AH0", "N", "AE1", "P", "AH0", "L", "IH0", "S"],
    "annapolis's": ["AH0", "N", "AE1", "P", "AH0", "L", "IH0", "S", "IH0", "Z"],
    "annas": ["AE1", "N", "AH0", "Z"],
    "annaud": ["AH0", "N", "OW1", "D"],
    "anne": ["AE1", "N"],
    "anne's": ["AE1", "N", "Z"],
    "anneal": ["AH0", "N", "IY1", "L"],
    "annealing": ["AH0", "N", "IY1", "L", "IH0", "NG"],
    "annelid": ["AE1", "N", "AH0", "L", "IH0", "D"],
    "annelids": ["AE1", "N", "AH0", "L", "IH0", "D", "Z"],
    "annen": ["AE1", "N", "AH0", "N"],
    "annenberg": ["AE1", "N", "AH0", "N", "B", "ER0", "G"],
    "annese": ["AA0", "N", "EY1", "Z", "IY0"],
    "annett": ["AH0", "N", "EH1", "T"],
    "annette": ["AH0", "N", "EH1", "T"],
    "annex": ["AH0", "N", "EH1", "K", "S"],
    "annexation": ["AE2", "N", "EH0", "K", "S", "EY1", "SH", "AH0", "N"],
    "annexed": ["AH0", "N", "EH1", "K", "S", "T"],
    "annexes": ["AE1", "N", "EH2", "K", "S", "IH0", "Z"],
    "annexing": ["AH0", "N", "EH1", "K", "S", "IH0", "NG"],
    "annick": ["AE1", "N", "IH0", "K"],
    "annie": ["AE1", "N", "IY0"],
    "annie's": ["AE1", "N", "IY2", "Z"],
    "annihilate": ["AH0", "N", "AY1", "AH0", "L", "EY2", "T"],
    "annihilated": ["AH0", "N", "AY1", "AH0", "L", "EY2", "T", "IH0", "D"],
    "annihilating": ["AH0", "N", "AY1", "AH0", "L", "EY2", "T", "IH0", "NG"],
    "annihilation": ["AH0", "N", "AY2", "AH0", "L", "EY1", "SH", "AH0", "N"],
    "annis": ["AE1", "N", "IY0", "Z"],
    "annissa": ["AE0", "N", "IY1", "S", "AH0"],
    "anniston": ["AE1", "N", "AH0", "S", "T", "AH0", "N"],
    "anniversaries": ["AE2", "N", "AH0", "V", "ER1", "S", "ER0", "IY0", "Z"],
    "anniversary": ["AE2", "N", "AH0", "V", "ER1", "S", "ER0", "IY0"],
    "anno": ["AE1", "N", "OW0"],
    "annotate": ["AE1", "N", "AH0", "T", "EY2", "T"],
    "annotated": ["AE1", "N", "AH0", "T", "EY2", "T", "AH0", "D"],
    "annotates": ["AE1", "N", "AH0", "T", "EY2", "T", "S"],
    "annotating": ["AE1", "N", "AH0", "T", "EY2", "T", "IH0", "NG"],
    "annotation": ["AE2", "N", "AH0", "T", "EY1", "SH", "AH0", "N"],
    "annotations": ["AE2", "N", "AH0", "T", "EY1", "SH", "AH0", "N", "Z"],
    "annotator": ["AE2", "N", "AH0", "T", "EY1", "T", "ER0"],
    "annotators": ["AE2", "N", "AH0", "T", "EY1", "T", "ER0", "Z"],
    "announce": ["AH0", "N", "AW1", "N", "S"],
    "announced": ["AH0", "N", "AW1", "N", "S", "T"],
    "announcement": ["AH0", "N", "AW1", "N", "S", "M", "EH0", "N", "T"],
    "announcements": ["AH0", "N", "AW1", "N", "S", "M", "AH0", "N", "T", "S"],
    "announcer": ["AH0", "N", "AW1", "N", "S", "ER0"],
    "announcers": ["AH0", "N", "AW1", "N", "S", "ER0", "Z"],
    "announces": ["AH0", "N", "AW1", "N", "S", "IH0", "Z"],
    "announcing": ["AH0", "N", "AW1", "N", "S", "IH0", "NG"],
    "announcment": ["AH0", "N", "AW1", "N", "S", "M", "AH0", "N", "T"],
    "annoy": ["AH0", "N", "OY1"],
    "annoyance": ["AH0", "N", "OY1", "AH0", "N", "S"],
    "annoyances": ["AH0", "N", "OY1", "AH0", "N", "S", "IH0", "Z"],
    "annoyed": ["AH0", "N", "OY1", "D"],
    "annoying": ["AH0", "N", "OY1", "IH0", "NG"],
    "annoys": ["AH0", "N", "OY1", "Z"],
    "annual": ["AE1", "N", "Y", "UW0", "AH0", "L"],
    "annualize": ["AE1", "N", "Y", "UW0", "W", "AH0", "L", "AY2", "Z"],
    "annualized": ["AE1", "N", "Y", "UW0", "W", "AH0", "L", "AY2", "Z", "D"],
    "annually": ["AE1", "N", "Y", "UW0", "AH0", "L", "IY0"],
    "annuals": ["AE1", "N", "UW0", "AH0", "L", "Z"],
    "annuit": ["AH0", "N", "UW1", "IH0", "T"],
    "annuities": ["AH0", "N", "UW1", "IH0", "T", "IY0", "Z"],
    "annuity": ["AH0", "N", "Y", "UW1", "IH0", "T", "IY0"],
    "annul": ["AE1", "N", "AH0", "L"],
    "annular": ["AE1", "N", "Y", "AH0", "L", "ER0"],
    "annulled": ["AE1", "N", "AH0", "L", "D"],
    "annulment": ["AE1", "N", "AH0", "L", "M", "AH0", "N", "T"],
    "annum": ["AE1", "N", "AH0", "M"],
    "annunciata": ["AA0", "N", "UW0", "N", "CH", "AA1", "T", "AH0"],
    "annunziata": ["AA0", "N", "UW0", "N", "Z", "IY2", "AA1", "T", "AH0"],
    "annunziato": ["AA0", "N", "UW0", "N", "Z", "IY2", "AA1", "T", "OW0"],
    "annunzio": ["AH0", "N", "UW1", "N", "Z", "IY0", "OW0"],
    "anny": ["AE1", "N", "IY0"],
    "ano": ["AE1", "N", "Y", "OW0"],
    "anode": ["AE1", "N", "OW2", "D"],
    "anodes": ["AE1", "N", "OW2", "D", "Z"],
    "anoint": ["AH0", "N", "OY1", "N", "T"],
    "anointed": ["AH0", "N", "OY1", "N", "IH0", "D"],
    "anomalies": ["AH0", "N", "AA1", "M", "AH0", "L", "IY0", "Z"],
    "anomalous": ["AH0", "N", "AA1", "M", "AH0", "L", "AH0", "S"],
    "anomaly": ["AH0", "N", "AA1", "M", "AH0", "L", "IY0"],
    "anomie": ["AE1", "N", "AH0", "M", "IY0"],
    "anon": ["AE2", "N", "AO1", "N"],
    "anona": ["AA0", "N", "OW1", "N", "AH0"],
    "anonymity": ["AE2", "N", "AH0", "N", "IH1", "M", "IH0", "T", "IY0"],
    "anonymize": ["AH0", "N", "AA1", "N", "AH0", "M", "AY2", "Z"],
    "anonymized": ["AH0", "N", "AA1", "N", "AH0", "M", "AY2", "Z", "D"],
    "anonymous": ["AH0", "N", "AA1", "N", "AH0", "M", "AH0", "S"],
    "anonymously": ["AH0", "N", "AA1", "N", "AH0", "M", "AH0", "S", "L", "IY0"],
    "anopheles": ["AA0", "N", "AO1", "F", "IH0", "L", "IY2", "Z"],
    "anora": ["AA0", "N", "AO1", "R", "AH0"],
    "anorak": ["AE1", "N", "ER0", "AE2", "K"],
    "anorexia": ["AE2", "N", "ER0", "EH1", "K", "S", "IY0", "AH0"],
    "anorexic": ["AE2", "N", "ER0", "EH1", "K", "S", "IH0", "K"],
    "anorexics": ["AE2", "N", "ER0", "EH1", "K", "S", "IH0", "K", "S"],
    "anorthite": ["AE0", "N", "AO1", "R", "TH", "AY2", "T"],
    "another": ["AH0", "N", "AH1", "DH", "ER0"],
    "another's": ["AH0", "N", "AH1", "DH", "ER0", "Z"],
    "anova": ["AH0", "N", "OW1", "V", "AA0"],
    "anreder": ["AE1", "N", "R", "EH2", "D", "ER0"],
    "anrig": ["AE1", "N", "R", "IH0", "G"],
    "ansa": ["AE1", "N", "S", "AH0"],
    "ansa's": ["AE1", "N", "S", "AH0", "Z"],
    "ansaid": ["AE1", "N", "S", "EY2", "D"],
    "ansaldo": ["AE0", "N", "S", "AA1", "L", "D", "OW0"],
    "ansang": ["AE1", "N", "S", "AE0", "NG"],
    "ansari": ["AA0", "N", "S", "AA1", "R", "IY0"],
    "ansbacher": ["AE1", "N", "Z", "B", "AA2", "K", "ER0"],
    "anschel": ["AE1", "N", "SH", "AH0", "L"],
    "anschluss": ["AA1", "N", "SH", "L", "UW0", "S"],
    "anschutz": ["AE1", "N", "SH", "AH0", "T", "S"],
    "anscom": ["AH0", "N", "S", "K", "AA1", "M"],
    "anscomb": ["AH0", "N", "S", "K", "AA1", "M"],
    "anse": ["AE1", "N", "S"],
    "ansel": ["AH0", "N", "S", "EH1", "L"],
    "ansell": ["AE1", "N", "S", "EH2", "L"],
    "anselm": ["AE1", "N", "S", "EH0", "L", "M"],
    "anselma": ["AA0", "N", "S", "EH1", "L", "M", "AH0"],
    "anselmi": ["AA0", "N", "S", "EH1", "L", "M", "IY0"],
    "anselmo": ["AA0", "N", "S", "EH1", "L", "M", "OW0"],
    "ansett": ["AE1", "N", "S", "EH2", "T"],
    "ansgar": ["AE1", "N", "S", "G", "AA0", "R"],
    "ansgar's": ["AE1", "N", "S", "G", "AA0", "R", "Z"],
    "anshan": ["AE1", "N", "SH", "AH0", "N"],
    "ansi": ["AE2", "N", "S", "IY1"],
    "ansin": ["AE1", "N", "S", "IH0", "N"],
    "ansley": ["AE1", "N", "S", "L", "IY0"],
    "ansohn": ["AE1", "N", "S", "AH0", "N"],
    "anson": ["AE1", "N", "S", "AH0", "N"],
    "ansonia": ["AE0", "N", "S", "OW1", "N", "IY0", "AH0"],
    "anspach": ["AE1", "N", "S", "P", "AA2", "K"],
    "anspaugh": ["AH0", "N", "S", "P", "AO1"],
    "anstead": ["AE1", "N", "S", "T", "EH2", "D"],
    "anstett": ["AH0", "N", "S", "T", "EH1", "T"],
    "anstey": ["AE1", "N", "S", "T", "IY0"],
    "anstice": ["AA1", "N", "S", "T", "IH0", "S"],
    "anstine": ["AA0", "N", "S", "T", "IY1", "N", "IY0"],
    "anstiss": ["AE1", "N", "S", "T", "IH0", "S"],
    "answer": ["AE1", "N", "S", "ER0"],
    "answer's": ["AE1", "N", "S", "ER0", "Z"],
    "answerable": ["AE1", "N", "S", "ER0", "AH0", "B", "AH0", "L"],
    "answered": ["AE1", "N", "S", "ER0", "D"],
    "answering": ["AE1", "N", "S", "ER0", "IH0", "NG"],
    "answers": ["AE1", "N", "S", "ER0", "Z"],
    "ant": ["AE1", "N", "T"],
    "antacid": ["AE0", "N", "T", "AE1", "S", "AH0", "D"],
    "antacids": ["AE0", "N", "T", "AE1", "S", "AH0", "D", "Z"],
    "antagonism": ["AE0", "N", "T", "AE1", "G", "AH0", "N", "IH2", "Z", "AH0", "M"],
    "antagonisms": ["AE0", "N", "T", "AE1", "G", "AH0", "N", "IH2", "Z", "AH0", "M", "Z"],
    "antagonist": ["AE0", "N", "T", "AE1", "G", "AH0", "N", "AH0", "S", "T"],
    "antagonistic": ["AE0", "N", "T", "AE2", "G", "AH0", "N", "IH1", "S", "T", "IH0", "K"],
    "antagonists": ["AE0", "N", "T", "AE1", "G", "AH0", "N", "AH0", "S", "T", "S"],
    "antagonize": ["AE0", "N", "T", "AE1", "G", "AH0", "N", "AY2", "Z"],
    "antagonized": ["AE0", "N", "T", "AE1", "G", "AH0", "N", "AY2", "Z", "D"],
    "antagonizing": ["AE0", "N", "T", "AE1", "G", "AH0", "N", "AY2", "Z", "IH0", "NG"],
    "antal": ["AE1", "N", "T", "AH0", "L"],
    "antar": ["AE1", "N", "T", "ER0"],
    "antar's": ["AE1", "N", "T", "ER0", "Z"],
    "antarctic": ["AE0", "N", "AA1", "R", "T", "IH0", "K"],
    "antarctica": ["AE2", "N", "AA1", "R", "T", "IH0", "K", "AH0"],
    "antarctica's": ["AE2", "N", "T", "AA1", "R", "K", "T", "IH0", "K", "AH0", "Z"],
    "antares": ["AE0", "N", "T", "EH1", "R", "IY0", "Z"],
    "antaya": ["AA0", "N", "T", "EY1", "AH0"],
    "antczak": ["AE1", "N", "T", "CH", "AE0", "K"],
    "ante": ["AE1", "N", "T", "IY0"],
    "anteater": ["AE1", "N", "T", "IY2", "T", "ER0"],
    "anteaters": ["AE1", "N", "T", "IY2", "T", "ER0", "Z"],
    "antebellum": ["AE2", "N", "T", "IH0", "B", "EH1", "L", "AH0", "M"],
    "antec": ["AE1", "N", "T", "EH2", "K"],
    "antecedent": ["AE2", "N", "T", "IH0", "S", "IY1", "D", "AH0", "N", "T"],
    "antecedents": ["AE2", "N", "T", "EH1", "S", "AH0", "D", "AH0", "N", "T", "S"],
    "antechamber": ["AE1", "N", "T", "EH0", "CH", "EY2", "M", "B", "ER0"],
    "anted": ["AE1", "N", "T", "IY0", "D"],
    "antell": ["AE0", "N", "T", "EH1", "L"],
    "antelope": ["AE1", "N", "T", "AH0", "L", "OW2", "P"],
    "antemeridian": ["AE2", "N", "T", "AH0", "M", "EH0", "R", "IH1", "D", "IY0", "AH0", "N"],
    "antemortem": ["AE0", "N", "T", "AH0", "M", "AO1", "R", "T", "AH0", "M"],
    "antenna": ["AE0", "N", "T", "EH1", "N", "AH0"],
    "antenna's": ["AE0", "N", "T", "EH1", "N", "AH0", "Z"],
    "antennae": ["AE0", "N", "T", "EH1", "N", "IY0"],
    "antennas": ["AE0", "N", "T", "EH1", "N", "AH0", "Z"],
    "antenne": ["AE0", "N", "T", "EH1", "N"],
    "antenucci": ["AE0", "N", "T", "IH0", "N", "UW1", "CH", "IY0"],
    "anterior": ["AE0", "N", "T", "IH1", "R", "IY0", "ER0"],
    "anteriormost": ["AE0", "N", "T", "IH1", "R", "IY0", "ER0", "M", "OW2", "S", "T"],
    "antes": ["AE1", "N", "T", "IY0", "Z"],
    "anthea": ["AE1", "N", "TH", "IY0", "AH0"],
    "anthem": ["AE1", "N", "TH", "AH0", "M"],
    "anthems": ["AE1", "N", "TH", "AH0", "M", "Z"],
    "anthes": ["AE1", "N", "DH", "AH0", "Z"],
    "anthiel": ["AE1", "N", "TH", "IY0", "AH0", "L"],
    "anthill": ["AE1", "N", "T", "HH", "IH2", "L"],
    "anthills": ["AE1", "N", "T", "HH", "IH2", "L", "Z"],
    "anthis": ["AE1", "N", "TH", "IH0", "S"],
    "anthologies": ["AE0", "N", "TH", "AA1", "L", "AH0", "JH", "IY0", "Z"],
    "anthologist": ["AE0", "N", "TH", "AO1", "L", "AH0", "G", "IH2", "S", "T"],
    "anthologists": ["AE0", "N", "TH", "AO1", "L", "AH0", "G", "IH2", "S", "T", "S"],
    "anthology": ["AE0", "N", "TH", "AA1", "L", "AH0", "JH", "IY0"],
    "anthon": ["AE1", "N", "TH", "AH0", "N"],
    "anthony": ["AE1", "N", "TH", "AH0", "N", "IY0"],
    "anthony's": ["AE1", "N", "TH", "AH0", "N", "IY0", "Z"],
    "anthracite": ["AE1", "N", "TH", "R", "AH0", "S", "AY2", "T"],
    "anthrax": ["AE1", "N", "TH", "R", "AE0", "K", "S"],
    "anthrobot": ["AE1", "N", "TH", "R", "OW0", "B", "AH2", "T"],
    "anthropocentric": ["AE2", "N", "TH", "R", "AH0", "P", "AH0", "S", "EH1", "N", "T", "R", "IH0", "K"],
    "anthropogenic": ["AE2", "N", "TH", "R", "AH0", "P", "AH0", "JH", "EH1", "N", "IH0", "K"],
    "anthropological": ["AE2", "N", "TH", "R", "AH0", "P", "AH0", "L", "AA1", "JH", "AH0", "K", "AH0", "L"],
    "anthropologist": ["AE2", "N", "TH", "R", "AH0", "P", "AA1", "L", "AH0", "JH", "IH0", "S", "T"],
    "anthropologists": ["AE2", "N", "TH", "R", "AH0", "P", "AA1", "L", "AH0", "JH", "IH0", "S", "T", "S"],
    "anthropology": ["AE2", "N", "TH", "R", "AH0", "P", "AA1", "L", "AH0", "JH", "IY0"],
    "anthropomorphic": ["AE2", "N", "TH", "R", "AH0", "P", "AH0", "M", "AO1", "R", "F", "IH0", "K"],
    "anthropomorphism": ["AE2", "N", "TH", "R", "AH0", "P", "AH0", "M", "AO1", "R", "F", "IH0", "Z", "AH0", "M"],
    "anti": ["AE1", "N", "T", "AY2"],
    "anti-catholicism": ["AE1", "N", "T", "AY0", "K", "AH0", "TH", "AO1", "L", "AH0", "S", "IH2", "Z", "AH0", "M"],
    "anti-doping": ["AE2", "N", "T", "IY0", "D", "OW1", "P", "IH0", "NG"],
    "anti-federalist": ["AE2", "N", "T", "IY0", "F", "EH1", "D", "R", "AH0", "L", "IH0", "S", "T"],
    "anti-federalists": ["AE2", "N", "T", "IY0", "F", "EH1", "D", "R", "AH0", "L", "AH0", "S", "T", "S"],
    "anti-infective": ["AE1", "N", "T", "IY0", "IH0", "N", "F", "EH1", "K", "T", "IH0", "V"],
    "anti-war": ["AE2", "N", "T", "IY0", "W", "AO1", "R"],
    "antiabortion": ["AE1", "N", "T", "AY0", "AH0", "B", "AO1", "R", "SH", "AH0", "N"],
    "antiaircraft": ["AE2", "N", "T", "AY0", "EH1", "R", "K", "R", "AE2", "F", "T"],
    "antibacterial": ["AE2", "N", "T", "IY0", "B", "AE0", "K", "T", "IH1", "R", "IY0", "AH0", "L"],
    "antiballistic": ["AE2", "N", "T", "IY0", "B", "AH0", "L", "IH1", "S", "T", "IH0", "K"],
    "antibiotic": ["AE2", "N", "T", "AY0", "B", "AY0", "AA1", "T", "IH0", "K"],
    "antibioticos": ["AE2", "N", "T", "IY0", "B", "AY0", "AA1", "T", "IH0", "K", "OW0", "S"],
    "antibiotics": ["AE2", "N", "T", "AY0", "B", "AY0", "AA1", "T", "IH0", "K", "S"],
    "antibodies": ["AE1", "N", "IH0", "B", "AA2", "D", "IY0", "Z"],
    "antibody": ["AE1", "N", "T", "IY0", "B", "AA2", "D", "IY0"],
    "antic": ["AE1", "N", "T", "IH0", "K"],
    "anticancer": ["AE2", "N", "T", "IY2", "K", "AE1", "N", "S", "ER0"],
    "anticipate": ["AE0", "N", "T", "IH1", "S", "AH0", "P", "EY2", "T"],
    "anticipated": ["AE0", "N", "T", "IH1", "S", "AH0", "P", "EY2", "T", "IH0", "D"],
    "anticipates": ["AE0", "N", "T", "IH1", "S", "AH0", "P", "EY2", "T", "S"],
    "anticipating": ["AE0", "N", "T", "IH1", "S", "AH0", "P", "EY2", "T", "IH0", "NG"],
    "anticipation": ["AE0", "N", "T", "IH0", "S", "AH0", "P", "EY1", "SH", "AH0", "N"],
    "anticipations": ["AE0", "N", "T", "IH0", "S", "AH0", "P", "EY1", "SH", "AH0", "N", "Z"],
    "anticipatory": ["AE0", "N", "T", "IH1", "S", "AH0", "P", "AH0", "T", "AO2", "R", "IY0"],
    "anticlimactic": ["AE2", "N", "T", "IY0", "K", "L", "AY0", "M", "AE1", "K", "T", "IH0", "K"],
    "anticline": ["AE1", "N", "T", "IH0", "K", "L", "AY2", "N"],
    "antico": ["AA0", "N", "T", "IY1", "K", "OW0"],
    "anticommunist": ["AE2", "N", "T", "IY0", "K", "AA1", "M", "Y", "AH0", "N", "IH0", "S", "T"],
    "anticompetitive": ["AE2", "N", "T", "IH0", "K", "AH0", "M", "P", "EH1", "T", "IH0", "T", "IH0", "V"],
    "anticorruption": ["AE2", "N", "T", "IY2", "K", "ER0", "AH1", "P", "SH", "AH0", "N"],
    "anticrime": ["AE1", "N", "T", "AY0", "K", "R", "AY1", "M"],
    "antics": ["AE1", "N", "T", "IH0", "K", "S"],
    "anticyclone": ["AE2", "N", "T", "IY0", "S", "AY1", "K", "L", "OW2", "N"],
    "anticyclones": ["AE2", "N", "T", "IY0", "S", "AY1", "K", "L", "OW2", "N", "Z"],
    "antidepressant": ["AE2", "N", "T", "IY0", "D", "IH0", "P", "R", "EH1", "S", "AH0", "N", "T"],
    "antidepressants": ["AE2", "N", "T", "IY2", "D", "IH0", "P", "R", "EH1", "S", "AH0", "N", "T", "S"],
    "antidiscrimination": ["AE2", "N", "T", "AY0", "D", "IH0", "S", "K", "R", "IH2", "M", "AH0", "N", "EY1", "SH", "AH0", "N"],
    "antidisestablishmentarianism": ["AE2", "N", "T", "AY0", "D", "IH2", "S", "AH0", "S", "T", "AE2", "B", "L", "IH0", "SH", "M", "AH0", "N", "T", "EH1", "R", "IY0", "AH0", "N", "IH2", "Z", "AH0", "M"],
    "antidote": ["AE1", "N", "IH0", "D", "OW2", "T"],
    "antidrug": ["AE2", "N", "T", "IH0", "D", "R", "AH1", "G"],
    "antidumping": ["AE2", "N", "T", "AY0", "D", "AH1", "M", "P", "IH0", "NG"],
    "antietam": ["AE2", "N", "T", "IY1", "T", "AH0", "M"],
    "antifraud": ["AE1", "N", "T", "AY0", "F", "R", "AA2", "D"],
    "antifreeze": ["AE1", "N", "T", "IY0", "F", "R", "IY2", "Z"],
    "antifungal": ["AE2", "N", "T", "IY2", "F", "AH1", "NG", "G", "AH0", "L"],
    "antigay": ["AE2", "N", "T", "IY2", "G", "EY1"],
    "antigen": ["AE1", "N", "T", "AH0", "JH", "AH0", "N"],
    "antigens": ["AE1", "N", "T", "IH0", "JH", "AH0", "N", "Z"],
    "antigone": ["AE0", "T", "IH1", "G", "AH0", "N", "IY0"],
    "antigone's": ["AE0", "N", "T", "IH1", "G", "AH0", "N", "IY2", "Z"],
    "antigones": ["AE0", "N", "T", "IH1", "G", "AH0", "N", "IY2", "Z"],
    "antigovernment": ["AE2", "N", "T", "AY0", "G", "AH1", "V", "ER0", "M", "AH0", "N", "T"],
    "antigua": ["AE0", "N", "T", "IY1", "G", "W", "AH0"],
    "antihistamine": ["AE2", "N", "T", "IY0", "HH", "IH1", "S", "T", "AH0", "M", "AH0", "N"],
    "antihistamines": ["AE2", "N", "T", "IY0", "HH", "IH1", "S", "T", "AH0", "M", "AH0", "N", "Z"],
    "antiknock": ["AE2", "N", "T", "IY0", "N", "AA1", "K"],
    "antill": ["AE0", "N", "T", "IH1", "L"],
    "antilla": ["AA0", "N", "T", "IH1", "L", "AH0"],
    "antilles": ["AE0", "N", "T", "IH1", "L", "IY0", "Z"],
    "antilock": ["AE1", "N", "T", "AY0", "L", "AA1", "K"],
    "antimatter": ["AE0", "T", "AY0", "M", "AE1", "T", "ER0"],
    "antimissile": ["AE2", "N", "T", "AY2", "M", "IH1", "S", "AH0", "L"],
    "antinomy": ["AE0", "T", "IH1", "N", "OW0", "M", "IY2"],
    "antioch": ["AE1", "N", "T", "IY0", "AA2", "K"],
    "antiochus": ["AE0", "N", "T", "AY1", "AH0", "K", "AH0", "S"],
    "antioxidant": ["AE2", "N", "T", "IY0", "AA1", "K", "S", "AH0", "D", "AH0", "N", "T"],
    "antioxidants": ["AE2", "N", "T", "IY0", "AA1", "K", "S", "AH0", "D", "AH0", "N", "T", "S"],
    "antipasto": ["AE2", "N", "T", "IY0", "P", "AA1", "S", "T", "OW0"],
    "antipathies": ["AE0", "N", "T", "IH1", "P", "AH0", "TH", "IY0", "Z"],
    "antipathy": ["AE0", "N", "T", "IH1", "P", "AH0", "TH", "IY0"],
    "antipersonnel": ["AE2", "N", "T", "IY0", "P", "ER0", "S", "AH0", "N", "EH1", "L"],
    "antiphon": ["AE1", "N", "T", "IH0", "F", "AA2", "N"],
    "antiphons": ["AE1", "N", "T", "IH0", "F", "AA2", "N", "Z"],
    "antipodal": ["AE0", "N", "T", "IH1", "P", "AH0", "D", "AH0", "L"],
    "antipode": ["AE2", "N", "T", "IH0", "P", "OW2", "D"],
    "antipodes": ["AE2", "N", "T", "IH0", "P", "OW2", "D", "IY0", "Z"],
    "antipoverty": ["AE2", "N", "T", "IY0", "P", "AA1", "V", "ER0", "T", "IY0"],
    "antiquate": ["AE1", "N", "T", "AH0", "K", "W", "EY2", "T"],
    "antiquated": ["AE1", "N", "T", "AH0", "K", "W", "EY2", "T", "IH0", "D"],
    "antique": ["AE0", "N", "T", "IY1", "K"],
    "antiques": ["AE0", "N", "T", "IY1", "K", "S"],
    "antiquities": ["AE0", "N", "T", "IH1", "K", "W", "AH0", "T", "IY0", "Z"],
    "antiquity": ["AE0", "N", "T", "IH1", "K", "W", "AH0", "T", "IY0"],
    "antireformer": ["AE2", "N", "T", "AY0", "R", "IH0", "F", "AO1", "R", "M", "ER0"],
    "antireformers": ["AE2", "N", "T", "AY0", "R", "IH0", "F", "AO1", "R", "M", "ER0", "Z"],
    "antis": ["AE1", "N", "T", "AY0", "Z"],
    "antisense": ["AE1", "N", "T", "AY0", "S", "EH2", "N", "S"],
    "antiseptic": ["AE2", "N", "T", "AH0", "S", "EH1", "P", "T", "IH0", "K"],
    "antismoking": ["AE1", "N", "T", "AY0", "S", "M", "OW1", "K", "IH0", "NG"],
    "antisocial": ["AE2", "N", "T", "AY0", "S", "OW1", "SH", "AH0", "L"],
    "antisubmarine": ["AE2", "N", "T", "AY0", "S", "AH1", "B", "M", "ER0", "IY2", "N"],
    "antitakeover": ["AE2", "N", "T", "IY0", "T", "EY1", "K", "OW2", "V", "ER0"],
    "antitank": ["AE2", "N", "T", "IY0", "T", "AE1", "NG", "K"],
    "antitax": ["AE2", "N", "T", "IY2", "T", "AE1", "K", "S"],
    "antitheft": ["AE2", "N", "T", "IY2", "TH", "EH1", "F", "T"],
    "antithesis": ["AE0", "N", "T", "IH1", "TH", "AH0", "S", "AH0", "S"],
    "antithetical": ["AE2", "N", "T", "AH0", "TH", "EH1", "T", "IH0", "K", "AH0", "L"],
    "antitoxin": ["AE2", "N", "T", "IY0", "T", "AA1", "K", "S", "AH0", "N"],
    "antitoxins": ["AE2", "N", "T", "IY0", "T", "AA1", "K", "S", "AH0", "N", "Z"],
    "antitrust": ["AE2", "N", "T", "AY0", "T", "R", "AH1", "S", "T"],
    "antiviral": ["AE2", "N", "T", "IY0", "V", "AY1", "R", "AH0", "L"],
    "antivirus": ["AE2", "N", "T", "IY0", "V", "AY1", "R", "AH0", "S"],
    "antiwar": ["AE2", "N", "T", "IY0", "W", "AO1", "R"],
    "antkowiak": ["AH0", "N", "T", "K", "AW1", "IY0", "AE0", "K"],
    "antle": ["AE1", "N", "T", "AH0", "L"],
    "antler": ["AE1", "N", "T", "L", "ER0"],
    "antlered": ["AE1", "N", "T", "L", "ER0", "D"],
    "antlers": ["AE1", "N", "T", "L", "ER0", "Z"],
    "antley": ["AE1", "N", "T", "L", "IY0"],
    "antoine": ["AA0", "N", "T", "W", "AA1", "N"],
    "antoinette": ["AE2", "N", "T", "W", "AH0", "N", "EH1", "T"],
    "antol": ["AA0", "N", "T", "AO1", "L"],
    "antolik": ["AE1", "N", "T", "AH0", "L", "IH0", "K"],
    "antolini": ["AE2", "N", "T", "OW0", "L", "IY1", "N", "IY0"],
    "anton": ["AE1", "N", "T", "AO2", "N"],
    "antonacci": ["AA0", "N", "T", "OW0", "N", "AA1", "CH", "IY0"],
    "antone": ["AA0", "N", "T", "OW1", "N", "IY0"],
    "antonelli": ["AA0", "N", "T", "OW0", "N", "EH1", "L", "IY0"],
    "antonellis": ["AE0", "N", "T", "AH0", "N", "EH1", "L", "IH0", "S"],
    "antonetti": ["AA0", "N", "T", "OW0", "N", "EH1", "T", "IY0"],
    "antoni": ["AA0", "N", "T", "OW1", "N", "IY0"],
    "antonia": ["AE0", "N", "T", "OW1", "N", "IY0", "AH0"],
    "antonin": ["AE1", "N", "T", "AH0", "N", "IH0", "N"],
    "antonini": ["AA0", "N", "T", "OW0", "N", "IY1", "N", "IY0"],
    "antonini's": ["AA0", "N", "T", "OW0", "N", "IY1", "N", "IY0", "Z"],
    "antonino": ["AE2", "N", "T", "OW0", "N", "IY1", "N", "OW0"],
    "antonio": ["AE0", "N", "T", "OW1", "N", "IY2", "OW0"],
    "antonio's": ["AE0", "N", "T", "OW1", "N", "IY2", "OW2", "Z"],
    "antonios": ["AE0", "N", "T", "OW1", "N", "IY2", "OW2", "Z"],
    "antoniou": ["AA0", "N", "T", "OW0", "N", "IY1", "UW0"],
    "antoniu": ["AE2", "N", "T", "OW1", "N", "IY0", "UW0"],
    "antoniu's": ["AE0", "N", "T", "OW1", "N", "IY0", "UW0", "Z"],
    "antonius": ["AE0", "N", "T", "OW1", "N", "IY0", "AH0", "S"],
    "antonopoulos": ["AE0", "N", "T", "AH0", "N", "AA1", "P", "AH0", "L", "IH0", "S"],
    "antonovich": ["AE2", "N", "T", "AA1", "N", "AH0", "V", "IH0", "CH"],
    "antonsen": ["AH0", "N", "T", "AA1", "N", "S", "AH0", "N"],
    "antonson": ["AE1", "N", "T", "AH0", "N", "S", "AH0", "N"],
    "antonucci": ["AA0", "N", "T", "OW0", "N", "UW1", "CH", "IY0"],
    "antony": ["AE1", "N", "T", "AH0", "N", "IY0"],
    "antoon": ["AE2", "N", "T", "UW1", "N"],
    "antos": ["AA1", "N", "T", "OW0", "Z"],
    "antosh": ["AH0", "N", "T", "AA1", "SH"],
    "antril": ["AE1", "N", "T", "R", "IH0", "L"],
    "antrim": ["AE1", "N", "T", "R", "IH0", "M"],
    "antrobus": ["AE1", "N", "T", "R", "AH0", "B", "IH0", "S"],
    "antroscope": ["AE1", "N", "T", "R", "AH0", "S", "K", "OW2", "P"],
    "ants": ["AE1", "N", "T", "S"],
    "antsy": ["AE1", "N", "T", "S", "IY0"],
    "anttila": ["AA0", "N", "T", "IY1", "L", "AH0"],
    "antuna": ["AA0", "N", "T", "UW1", "N", "AH0"],
    "antunes": ["AA0", "N", "T", "UW1", "N", "EH0", "S"],
    "antunez": ["AA0", "N", "T", "UW1", "N", "EH0", "Z"],
    "antwerp": ["AE1", "N", "T", "W", "ER0", "P"],
    "antwine": ["AE1", "N", "T", "W", "AY2", "N"],
    "anubis": ["AH0", "N", "UW1", "B", "IH0", "S"],
    "anuradhapura": ["AA2", "N", "UW0", "R", "AA1", "D", "AH0", "P", "UW2", "R", "AA0"],
    "anus": ["EY1", "N", "AH0", "S"],
    "anvil": ["AE1", "N", "V", "AH0", "L"],
    "anwar": ["AA1", "N", "W", "AA0", "R"],
    "anway": ["AH0", "N", "W", "EY1"],
    "anwell": ["AH0", "N", "W", "EH1", "L"],
    "anwyl": ["AE1", "N", "W", "IH0", "L"],
    "anwyll": ["AE1", "N", "W", "IH0", "L"],
    "anxieties": ["AE0", "NG", "Z", "AY1", "AH0", "T", "IY0", "Z"],
    "anxiety": ["AE0", "NG", "Z", "AY1", "AH0", "T", "IY0"],
    "anxious": ["AE1", "NG", "SH", "AH0", "S"],
    "anxiously": ["AE1", "NG", "K", "SH", "AH0", "S", "L", "IY0"],
    "any": ["EH1", "N", "IY0"],
    "anybody": ["EH1", "N", "IY0", "B", "AH0", "D", "IY0"],
    "anybody's": ["EH1", "N", "IY0", "B", "AH0", "D", "IY0", "Z"],
    "anyhow": ["EH1", "N", "IY0", "HH", "AW2"],
    "anymore": ["EH2", "N", "IY0", "M", "AO1", "R"],
    "anyon": ["EH1", "N", "IY0", "AA0", "N"],
    "anyone": ["EH1", "N", "IY0", "W", "AH0", "N"],
    "anyone'll": ["EH1", "N", "IY0", "W", "AH2", "N", "AH0", "L"],
    "anyone's": ["EH1", "N", "IY0", "W", "AH2", "N", "Z"],
    "anyplace": ["EH1", "N", "IY0", "P", "L", "EY2", "S"],
    "anything": ["EH1", "N", "IY0", "TH", "IH2", "NG"],
    "anything's": ["EH1", "N", "IY0", "TH", "IH2", "NG", "Z"],
    "anytime": ["EH1", "N", "IY0", "T", "AY2", "M"],
    "anytime'll": ["EH1", "N", "IY0", "T", "AY2", "M", "AH0", "L"],
    "anytime's": ["EH1", "N", "IY0", "T", "AY2", "M", "Z"],
    "anyway": ["EH1", "N", "IY0", "W", "EY2"],
    "anyways": ["EH1", "N", "IY0", "W", "EY2", "Z"],
    "anywhere": ["EH1", "N", "IY0", "HH", "W", "EH2", "R"],
    "anza": ["AE1", "N", "Z", "AH0"],
    "anzac": ["AE1", "N", "Z", "AE0", "K"],
    "anzaldua": ["AA0", "N", "Z", "AA0", "L", "D", "UW1", "AH0"],
    "anzalone": ["AE1", "N", "Z", "AH0", "L", "OW2", "N"],
    "anzelmo": ["AA0", "N", "Z", "EH1", "L", "M", "OW0"],
    "anzio": ["AE1", "N", "Z", "IY2", "OW0"],
    "anzus": ["AE1", "N", "Z", "AH0", "S"],
    "aoi": ["AW1", "IY0"],
    "aoki": ["EY0", "OW1", "K", "IY0"],
    "aol": ["AH0", "M", "ER1", "IH0", "K", "AH0", "AA1", "N", "L", "AY2", "N"],
    "aon": ["EY1", "OW0", "N"],
    "aorta": ["EY0", "AO1", "R", "T", "AH0"],
    "aortic": ["EY0", "AO1", "R", "T", "IH0", "K"],
    "aoshima": ["EY2", "OW0", "SH", "IY1", "M", "AH0"],
    "aoun": ["AW2", "UW1", "N"],
    "aoun's": ["AW2", "UW1", "N", "Z"],
    "aouzou": ["AW2", "Y", "UW1", "Z", "UW0"],
    "aoyama": ["EY2", "OW0", "Y", "AA1", "M", "AH0"],
    "ap": ["EY2", "P", "IY1"],
    "apace": ["AH0", "P", "EY1", "S"],
    "apache": ["AH0", "P", "AE1", "CH", "IY0"],
    "apache's": ["AH0", "P", "AE1", "CH", "IY0", "Z"],
    "apaches": ["AH0", "P", "AE1", "CH", "IY0", "Z"],
    "apacs": ["EY1", "P", "AE0", "K", "S"],
    "apalachicola": ["AE2", "P", "AH0", "L", "AE2", "CH", "AH0", "K", "OW1", "L", "AH0"],
    "apalachicola's": ["AE2", "P", "AH0", "L", "AE2", "CH", "AH0", "K", "OW1", "L", "AH0", "Z"],
    "aparicio": ["AE2", "P", "ER0", "IH1", "S", "IY0", "OW0"],
    "apart": ["AH0", "P", "AA1", "R", "T"],
    "apartheid": ["AH0", "P", "AA1", "R", "T", "AY2", "D"],
    "apartheid's": ["AH0", "P", "AA1", "R", "T", "AY2", "D", "Z"],
    "apartment": ["AH0", "P", "AA1", "R", "T", "M", "AH0", "N", "T"],
    "apartment's": ["AH0", "P", "AA1", "R", "T", "M", "AH0", "N", "T", "S"],
    "apartments": ["AH0", "P", "AA1", "R", "T", "M", "AH0", "N", "T", "S"],
    "apathetic": ["AE2", "P", "AH0", "TH", "EH1", "T", "IH0", "K"],
    "apathy": ["AE1", "P", "AH0", "TH", "IY0"],
    "apatite": ["AE1", "P", "AH0", "T", "AY2", "T"],
    "apatites": ["AE1", "P", "AH0", "T", "AY2", "T", "S"],
    "apc": ["EY1", "P", "IY1", "S", "IY1"],
    "apc's": ["EY1", "P", "IY1", "S", "IY1", "Z"],
    "apcar": ["AE1", "P", "G", "AA0", "R"],
    "ape": ["EY1", "P"],
    "apec": ["EY1", "P", "EH2", "K"],
    "apec's": ["EY1", "P", "EH2", "K", "S"],
    "apel": ["AA0", "P", "EH1", "L"],
    "apelike": ["EY1", "P", "L", "AY2", "K"],
    "apennine": ["AE1", "P", "AH0", "N", "IY2", "N"],
    "apercu": ["AE1", "P", "ER0", "S", "UW2"],
    "aperitif": ["AH0", "P", "EH2", "R", "AH0", "T", "IY1", "F"],
    "aperture": ["AE1", "P", "ER0", "CH", "ER0"],
    "apes": ["EY1", "P", "S"],
    "apex": ["EY1", "P", "EH2", "K", "S"],
    "apex's": ["EY1", "P", "EH2", "K", "S", "IH0", "Z"],
    "apfel": ["AE1", "P", "F", "AH0", "L"],
    "apfelbaum": ["AE1", "P", "F", "AH0", "L", "B", "AW2", "M"],
    "apgar": ["AE1", "P", "G", "ER0"],
    "aphasia": ["AH0", "F", "EY1", "ZH", "AH0"],
    "aphid": ["EY1", "F", "AH0", "D"],
    "aphids": ["EY1", "F", "AH0", "D", "Z"],
    "aphorism": ["AE1", "F", "ER0", "IH2", "Z", "AH0", "M"],
    "aphorisms": ["AE1", "F", "ER0", "IH2", "Z", "AH0", "M", "Z"],
    "aphrodisiac": ["AE2", "F", "R", "OW0", "D", "IY1", "Z", "IY0", "AE0", "K"],
    "aphrodite": ["AE2", "F", "R", "AH0", "D", "AY1", "T", "IY0"],
    "aphrodite's": ["AE2", "F", "R", "AH0", "D", "AY1", "T", "IY0", "Z"],
    "aphrodites": ["AE2", "F", "R", "AH0", "D", "AY1", "T", "IY0", "Z"],
    "api": ["EY2", "P", "IY2", "AY1"],
    "apia": ["AA1", "P", "IH0", "AA2"],
    "apical": ["AE1", "P", "IH0", "K", "AH0", "L"],
    "apicella": ["AE2", "P", "IH0", "S", "EH1", "L", "AH0"],
    "apiece": ["AH0", "P", "IY1", "S"],
    "aping": ["EY1", "P", "IH0", "NG"],
    "aplenty": ["AH0", "P", "L", "EH1", "N", "T", "IY0"],
    "aplin": ["AE1", "P", "L", "IH0", "N"],
    "aplomb": ["AH0", "P", "L", "AA1", "M"],
    "apnea": ["AE1", "P", "N", "IY0", "AH0"],
    "apo": ["EY2", "P", "IY2", "OW1"],
    "apocalypse": ["AH0", "P", "AA1", "K", "AH0", "L", "IH2", "P", "S"],
    "apocalyptic": ["AH0", "P", "AA2", "K", "AH0", "L", "IH1", "P", "T", "IH0", "K"],
    "apocryphal": ["AH0", "P", "AA1", "K", "R", "AH0", "F", "AH0", "L"],
    "apodaca": ["AA0", "P", "OW0", "D", "AA1", "K", "AH0"],
    "apogee": ["AE1", "P", "AH0", "JH", "IY2"],
    "apolitical": ["EY2", "P", "AH0", "L", "IH1", "T", "IH0", "K", "AH0", "L"],
    "apolline": ["AE1", "P", "AH0", "L", "AY2", "N"],
    "apollinian": ["AE2", "P", "AH0", "L", "IH1", "N", "IY0", "AH0", "N"],
    "apollo": ["AH0", "P", "AA1", "L", "OW0"],
    "apollo's": ["AH0", "P", "AA1", "L", "OW0", "Z"],
    "apollonian": ["AE2", "P", "AH0", "L", "OW1", "N", "IY0", "AH0", "N"],
    "apologetic": ["AH0", "P", "AA2", "L", "AH0", "JH", "EH1", "T", "IH0", "K"],
    "apologetically": ["AH0", "P", "AA2", "L", "AH0", "JH", "EH1", "T", "IH0", "K", "L", "IY2"],
    "apologies": ["AH0", "P", "AA1", "L", "AH0", "JH", "IY2", "Z"],
    "apologise": ["AH0", "P", "AA1", "L", "AH0", "JH", "AY2", "Z"],
    "apologised": ["AH0", "P", "AA1", "L", "AH0", "JH", "AY2", "Z", "D"],
    "apologises": ["AH0", "P", "AA1", "L", "AH0", "JH", "AY2", "Z", "IH0", "Z"],
    "apologising": ["AH0", "P", "AA1", "L", "AH0", "JH", "AY2", "Z", "IH0", "NG"],
    "apologist": ["AH0", "P", "AA1", "L", "AH0", "JH", "AH0", "S", "T"],
    "apologists": ["AH0", "P", "AA1", "L", "AH0", "JH", "AH0", "S", "T", "S"],
    "apologize": ["AH0", "P", "AA1", "L", "AH0", "JH", "AY2", "Z"],
    "apologized": ["AH0", "P", "AA1", "L", "AH0", "JH", "AY2", "Z", "D"],
    "apologizes": ["AH0", "P", "AA1", "L", "AH0", "JH", "AY2", "Z", "IH0", "Z"],
    "apologizing": ["AH0", "P", "AA1", "L", "AH0", "JH", "AY2", "Z", "IH0", "NG"],
    "apology": ["AH0", "P", "AA1", "L", "AH0", "JH", "IY2"],
    "aponte": ["AH0", "P", "AA1", "N", "T", "IY0"],
    "apopa": ["AH0", "P", "OW1", "P", "AH0"],
    "apopka": ["AH0", "P", "AO1", "P", "K", "AH0"],
    "apoplectic": ["AE2", "P", "AH0", "P", "L", "EH1", "K", "T", "IH0", "K"],
    "apoplexy": ["AE1", "P", "AH0", "P", "L", "EH2", "K", "S", "IY0"],
    "apoptosis": ["AE2", "P", "AO0", "P", "T", "OW1", "S", "IH0", "Z"],
    "apostate": ["AH0", "P", "AO1", "S", "T", "EY0", "T"],
    "apostle": ["AH0", "P", "AA1", "S", "AH0", "L"],
    "apostles": ["AH0", "P", "AA1", "S", "AH0", "L", "Z"],
    "apostol": ["AE1", "P", "AH0", "S", "T", "AH0", "L"],
    "apostolic": ["AE2", "P", "AH0", "S", "T", "AO1", "L", "IH0", "K"],
    "apostolopoul": ["AH0", "P", "AA2", "S", "T", "OW0", "L", "OW0", "P", "UW1", "L"],
    "apostrophe": ["AH0", "P", "AA1", "S", "T", "R", "AH0", "F", "IY2"],
    "apostrophes": ["AH0", "P", "AA1", "S", "T", "R", "AH0", "F", "IY2", "Z"],
    "apothecary": ["AH0", "P", "AA1", "TH", "AH0", "K", "EH2", "R", "IY0"],
    "apotheosis": ["AH0", "P", "AA2", "TH", "IY0", "OW1", "S", "AH0", "S"],
    "app": ["AE1", "P"],
    "appalachia": ["AE2", "P", "AH0", "L", "AE1", "CH", "IY0", "AH0"],
    "appalachian": ["AE2", "P", "AH0", "L", "AE1", "CH", "AH0", "N"],
    "appalachians": ["AE1", "P", "AH0", "L", "AE1", "CH", "AH0", "N", "Z"],
    "appall": ["AH0", "P", "AO1", "L"],
    "appalled": ["AH0", "P", "AO1", "L", "D"],
    "appalling": ["AH0", "P", "AO1", "L", "IH0", "NG"],
    "appallingly": ["AH0", "P", "AO1", "L", "IH0", "NG", "L", "IY0"],
    "appalls": ["AH0", "P", "AO1", "L", "Z"],
    "apparatchik": ["AE2", "P", "ER0", "AE1", "CH", "IH0", "K"],
    "apparatchiks": ["AE2", "P", "ER0", "AE1", "CH", "IH0", "K", "S"],
    "apparatus": ["AE2", "P", "ER0", "AE1", "T", "AH0", "S"],
    "apparatuses": ["AE2", "P", "ER0", "AE1", "T", "AH0", "S", "AH0", "Z"],
    "apparel": ["AH0", "P", "EH1", "R", "AH0", "L"],
    "apparent": ["AH0", "P", "EH1", "R", "AH0", "N", "T"],
    "apparently": ["AH0", "P", "EH1", "R", "AH0", "N", "T", "L", "IY0"],
    "apparition": ["AE2", "P", "ER0", "IH1", "SH", "AH0", "N"],
    "apparitions": ["AE2", "P", "ER0", "IH1", "SH", "AH0", "N", "Z"],
    "appeal": ["AH0", "P", "IY1", "L"],
    "appealable": ["AH0", "P", "IY1", "L", "AH0", "B", "AH0", "L"],
    "appealed": ["AH0", "P", "IY1", "L", "D"],
    "appealing": ["AH0", "P", "IY1", "L", "IH0", "NG"],
    "appealingly": ["AH0", "P", "IY1", "L", "IH0", "NG", "L", "IY0"],
    "appeals": ["AH0", "P", "IY1", "L", "Z"],
    "appear": ["AH0", "P", "IH1", "R"],
    "appearance": ["AH0", "P", "IH1", "R", "AH0", "N", "S"],
    "appearances": ["AH0", "P", "IH1", "R", "AH0", "N", "S", "AH0", "Z"],
    "appeared": ["AH0", "P", "IH1", "R", "D"],
    "appearing": ["AH0", "P", "IH1", "R", "IH0", "NG"],
    "appears": ["AH0", "P", "IH1", "R", "Z"],
    "appease": ["AH0", "P", "IY1", "Z"],
    "appeased": ["AH0", "P", "IY1", "Z", "D"],
    "appeasement": ["AH0", "P", "IY1", "Z", "M", "AH0", "N", "T"],
    "appeasing": ["AH0", "P", "IY1", "Z", "IH0", "NG"],
    "appel": ["AE1", "P", "AH0", "L"],
    "appelbaum": ["AE1", "P", "AH0", "L", "B", "AW2", "M"],
    "appelhans": ["AE1", "P", "IH0", "L", "HH", "AH0", "N", "Z"],
    "appell": ["AE1", "P", "AH0", "L"],
    "appellant": ["AH0", "P", "EH1", "L", "IH0", "N", "T"],
    "appellants": ["AH0", "P", "EH1", "L", "IH0", "N", "T", "S"],
    "appellate": ["AH0", "P", "EH1", "L", "EY2", "T"],
    "appellation": ["AE2", "P", "AH0", "L", "EY1", "SH", "AH0", "N"],
    "appellations": ["AE2", "P", "AH0", "L", "EY1", "SH", "AH0", "N", "Z"],
    "appelman": ["AE1", "P", "AH0", "L", "M", "AH0", "N"],
    "appelt": ["AE1", "P", "IH0", "L", "T"],
    "append": ["AH0", "P", "EH1", "N", "D"],
    "appendage": ["AH0", "P", "EH1", "N", "D", "IH0", "JH"],
    "appendages": ["AH0", "P", "EH1", "N", "D", "IH0", "JH", "IH0", "Z"],
    "appendectomies": ["AE2", "P", "AH0", "N", "D", "EH1", "K", "T", "AH0", "M", "IY0", "Z"],
    "appendectomy": ["AE2", "P", "IH0", "N", "D", "EH1", "K", "T", "AH0", "M", "IY0"],
    "appended": ["AH0", "P", "EH1", "N", "D", "IH0", "D"],
    "appendices": ["AH0", "P", "EH1", "N", "D", "IH0", "S", "IY2", "Z"],
    "appendicitis": ["AH0", "P", "EH2", "N", "D", "IH2", "S", "AY1", "T", "IH0", "Z"],
    "appendix": ["AH0", "P", "EH1", "N", "D", "IH0", "K", "S"],
    "appendixes": ["AH0", "P", "EH1", "N", "D", "IH0", "K", "S", "IH0", "Z"],
    "appenzeller": ["AE1", "P", "IH0", "N", "Z", "AH0", "L", "ER0"],
    "apperson": ["AE1", "P", "ER0", "S", "AH0", "N"],
    "appert": ["AE1", "P", "ER0", "T"],
    "appetite": ["AE1", "P", "AH0", "T", "AY2", "T"],
    "appetites": ["AE1", "P", "AH0", "T", "AY2", "T", "S"],
    "appetito": ["AE2", "P", "AH0", "T", "IY1", "T", "OW2"],
    "appetizer": ["AE1", "P", "AH0", "T", "AY2", "Z", "ER0"],
    "appetizers": ["AE1", "P", "AH0", "T", "AY2", "Z", "ER0", "Z"],
    "appetizing": ["AE1", "P", "IH0", "T", "AY2", "Z", "IH0", "NG"],
    "appia": ["AE1", "P", "IY0", "AH0"],
    "appian": ["AE1", "P", "IY0", "AH0", "N"],
    "applaud": ["AH0", "P", "L", "AO1", "D"],
    "applauded": ["AH0", "P", "L", "AO1", "D", "IH0", "D"],
    "applauding": ["AH0", "P", "L", "AO1", "D", "IH0", "NG"],
    "applauds": ["AH0", "P", "L", "AO1", "D", "Z"],
    "applause": ["AH0", "P", "L", "AO1", "Z"],
    "apple": ["AE1", "P", "AH0", "L"],
    "apple's": ["AE1", "P", "AH0", "L", "Z"],
    "appleans": ["AH0", "P", "L", "IY1", "N", "Z"],
    "applebaum": ["AE1", "P", "AH0", "L", "B", "AW2", "M"],
    "applebee": ["AE1", "P", "AH0", "L", "B", "IY2"],
    "applebee's": ["AE1", "P", "AH0", "L", "B", "IY2", "Z"],
    "appleberry": ["AE1", "P", "AH0", "L", "B", "EH2", "R", "IY0"],
    "appleby": ["AE1", "P", "AH0", "L", "B", "IY2"],
    "applegarth": ["AE1", "P", "L", "AH0", "G", "AA2", "R", "TH"],
    "applegate": ["AE1", "P", "AH0", "L", "G", "EY2", "T"],
    "appleman": ["AE1", "P", "AH0", "L", "M", "AH0", "N"],
    "applequist": ["AE1", "P", "AH0", "L", "K", "W", "IH0", "S", "T"],
    "apples": ["AE1", "P", "AH0", "L", "Z"],
    "applesauce": ["AE1", "P", "AH0", "L", "S", "AO2", "S"],
    "appleseed": ["AE1", "P", "AH0", "L", "S", "IY2", "D"],
    "appleshare": ["AE1", "P", "AH0", "L", "SH", "EH2", "R"],
    "applet": ["AE1", "P", "L", "AH0", "T"],
    "appleton": ["AE1", "P", "AH0", "L", "T", "AH0", "N"],
    "applewhite": ["AE1", "P", "AH0", "L", "W", "AY2", "T"],
    "appleyard": ["AE1", "P", "AH0", "L", "Y", "AA2", "R", "D"],
    "appliance": ["AH0", "P", "L", "AY1", "AH0", "N", "S"],
    "appliances": ["AH0", "P", "L", "AY1", "AH0", "N", "S", "IH0", "Z"],
    "applicability": ["AE2", "P", "L", "AH0", "K", "AH0", "B", "IH1", "L", "AH0", "T", "IY0"],
    "applicable": ["AE1", "P", "L", "AH0", "K", "AH0", "B", "AH0", "L"],
    "applicant": ["AE1", "P", "L", "IH0", "K", "AH0", "N", "T"],
    "applicant's": ["AE1", "P", "L", "IH0", "K", "AH0", "N", "T", "S"],
    "applicants": ["AE1", "P", "L", "IH0", "K", "AH0", "N", "T", "S"],
    "applicants'": ["AE1", "P", "L", "AH0", "K", "AH0", "N", "T", "S"],
    "application": ["AE2", "P", "L", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "applications": ["AE2", "P", "L", "AH0", "K", "EY1", "SH", "AH0", "N", "Z"],
    "applicator": ["AE1", "P", "L", "AH0", "K", "EY2", "T", "ER0"],
    "applicators": ["AE1", "P", "L", "AH0", "K", "EY2", "T", "ER0", "Z"],
    "applied": ["AH0", "P", "L", "AY1", "D"],
    "applies": ["AH0", "P", "L", "AY1", "Z"],
    "applin": ["AE1", "P", "L", "IH0", "N"],
    "appling": ["AE1", "P", "L", "IH0", "NG"],
    "apply": ["AH0", "P", "L", "AY1"],
    "applying": ["AH0", "P", "L", "AY1", "IH0", "NG"],
    "appoint": ["AH0", "P", "OY1", "N", "T"],
    "appointed": ["AH0", "P", "OY1", "N", "T", "IH0", "D"],
    "appointee": ["AH0", "P", "OY1", "N", "T", "IY0"],
    "appointees": ["AH0", "P", "OY1", "N", "T", "IY0", "Z"],
    "appointing": ["AH0", "P", "OY1", "N", "T", "IH0", "NG"],
    "appointive": ["AH0", "P", "OY1", "N", "T", "IH0", "V"],
    "appointment": ["AH0", "P", "OY1", "N", "T", "M", "AH0", "N", "T"],
    "appointments": ["AH0", "P", "OY1", "N", "T", "M", "AH0", "N", "T", "S"],
    "appoints": ["AH0", "P", "OY1", "N", "T", "S"],
    "apportion": ["AH0", "P", "AO1", "R", "SH", "AH0", "N"],
    "apportioned": ["AH0", "P", "AO1", "R", "SH", "AH0", "N", "D"],
    "apportioning": ["AH0", "P", "AO1", "R", "SH", "AH0", "N", "IH0", "NG"],
    "apportionment": ["AH0", "P", "AO1", "R", "SH", "AH0", "N", "M", "AH0", "N", "T"],
    "appraisal": ["AH0", "P", "R", "EY1", "Z", "AH0", "L"],
    "appraisals": ["AH0", "P", "R", "EY1", "Z", "AH0", "L", "Z"],
    "appraise": ["AH0", "P", "R", "EY1", "Z"],
    "appraised": ["AH0", "P", "R", "EY1", "Z", "D"],
    "appraiser": ["AH0", "P", "R", "EY1", "Z", "ER0"],
    "appraisers": ["AH0", "P", "R", "EY1", "Z", "ER0", "Z"],
    "appraises": ["AH0", "P", "R", "EY1", "Z", "IH0", "Z"],
    "appraising": ["AH0", "P", "R", "EY1", "Z", "IH0", "NG"],
    "appreciable": ["AH0", "P", "R", "IY1", "SH", "AH0", "B", "AH0", "L"],
    "appreciably": ["AH0", "P", "R", "IY1", "SH", "AH0", "B", "L", "IY0"],
    "appreciate": ["AH0", "P", "R", "IY1", "SH", "IY0", "EY2", "T"],
    "appreciated": ["AH0", "P", "R", "IY1", "SH", "IY0", "EY2", "T", "IH0", "D"],
    "appreciates": ["AH0", "P", "R", "IY1", "SH", "IY0", "EY2", "T", "S"],
    "appreciating": ["AH0", "P", "R", "IY1", "SH", "IY0", "EY2", "T", "IH0", "NG"],
    "appreciation": ["AH0", "P", "R", "IY2", "SH", "IY0", "EY1", "SH", "AH0", "N"],
    "appreciative": ["AH0", "P", "R", "IY1", "SH", "Y", "AH0", "T", "IH0", "V"],
    "appreciatively": ["AH0", "P", "R", "IY1", "SH", "Y", "AH0", "T", "IH0", "V", "L", "IY0"],
    "apprehend": ["AE2", "P", "R", "IH0", "HH", "EH1", "N", "D"],
    "apprehended": ["AE2", "P", "R", "IH0", "HH", "EH1", "N", "D", "IH0", "D"],
    "apprehending": ["AE2", "P", "R", "IH0", "HH", "EH1", "N", "D", "IH0", "NG"],
    "apprehension": ["AE2", "P", "R", "IH0", "HH", "EH1", "N", "SH", "AH0", "N"],
    "apprehensions": ["AE2", "P", "R", "IH0", "HH", "EH1", "N", "SH", "AH0", "N", "Z"],
    "apprehensive": ["AE2", "P", "R", "IY0", "HH", "EH1", "N", "S", "IH0", "V"],
    "apprentice": ["AH0", "P", "R", "EH1", "N", "T", "IH0", "S"],
    "apprenticed": ["AH0", "P", "R", "EH1", "N", "T", "AH0", "S", "T"],
    "apprentices": ["AH0", "P", "R", "EH1", "N", "T", "AH0", "S", "IH0", "Z"],
    "apprenticeship": ["AH0", "P", "R", "EH1", "N", "T", "AH0", "S", "SH", "IH2", "P"],
    "apprenticeships": ["AH0", "P", "R", "EH1", "N", "T", "AH0", "S", "SH", "IH2", "P", "S"],
    "apprise": ["AH0", "P", "R", "AY1", "Z"],
    "apprised": ["AH0", "P", "R", "AY1", "Z", "D"],
    "apprises": ["AH0", "P", "R", "AY1", "Z", "IH0", "Z"],
    "appro": ["AE1", "P", "R", "OW0"],
    "approach": ["AH0", "P", "R", "OW1", "CH"],
    "approachable": ["AH0", "P", "R", "OW1", "CH", "AH0", "B", "AH0", "L"],
    "approached": ["AH0", "P", "R", "OW1", "CH", "T"],
    "approaches": ["AH0", "P", "R", "OW1", "CH", "IH0", "Z"],
    "approaching": ["AH0", "P", "R", "OW1", "CH", "IH0", "NG"],
    "approbation": ["AE2", "P", "R", "AH0", "B", "EY1", "SH", "AH0", "N"],
    "appropriate": ["AH0", "P", "R", "OW1", "P", "R", "IY0", "EY2", "T"],
    "appropriated": ["AH0", "P", "R", "OW1", "P", "R", "IY0", "EY2", "T", "IH0", "D"],
    "appropriately": ["AH0", "P", "R", "OW1", "P", "R", "IY0", "IH0", "T", "L", "IY0"],
    "appropriateness": ["AH0", "P", "R", "OW1", "P", "R", "IY0", "AH0", "T", "N", "AH0", "S"],
    "appropriates": ["AH0", "P", "R", "OW1", "P", "R", "IY0", "EY2", "T", "S"],
    "appropriating": ["AH0", "P", "R", "OW1", "P", "R", "IY0", "EY2", "T", "IH0", "NG"],
    "appropriation": ["AH0", "P", "R", "OW2", "P", "R", "IY0", "EY1", "SH", "AH0", "N"],
    "appropriations": ["AH0", "P", "R", "OW2", "P", "R", "IY0", "EY1", "SH", "AH0", "N", "Z"],
    "appropriator": ["AH0", "P", "R", "OW1", "P", "R", "IY0", "EY2", "T", "ER0"],
    "appropriators": ["AH0", "P", "R", "OW1", "P", "R", "IY0", "EY2", "T", "ER0", "Z"],
    "approvable": ["AH0", "P", "R", "UW1", "V", "AH0", "B", "AH0", "L"],
    "approval": ["AH0", "P", "R", "UW1", "V", "AH0", "L"],
    "approvals": ["AH0", "P", "R", "UW1", "V", "AH0", "L", "Z"],
    "approve": ["AH0", "P", "R", "UW1", "V"],
    "approved": ["AH0", "P", "R", "UW1", "V", "D"],
    "approves": ["AH0", "P", "R", "UW1", "V", "Z"],
    "approving": ["AH0", "P", "R", "UW1", "V", "IH0", "NG"],
    "approvingly": ["AH0", "P", "R", "UW1", "V", "IH0", "NG", "L", "IY0"],
    "approximate": ["AH0", "P", "R", "AA1", "K", "S", "AH0", "M", "EY2", "T"],
    "approximated": ["AH0", "P", "R", "AA1", "K", "S", "AH0", "M", "EY2", "T", "IH0", "D"],
    "approximately": ["AH0", "P", "R", "AA1", "K", "S", "AH0", "M", "AH0", "T", "L", "IY0"],
    "approximates": ["AH0", "P", "R", "AA1", "K", "S", "AH0", "M", "EY2", "T", "S"],
    "approximating": ["AH0", "P", "R", "AA1", "K", "S", "IH0", "M", "EY2", "T", "IH0", "NG"],
    "approximation": ["AH0", "P", "R", "AA2", "K", "S", "AH0", "M", "EY1", "SH", "AH0", "N"],
    "approximations": ["AH0", "P", "R", "AA2", "K", "S", "AH0", "M", "EY1", "SH", "AH0", "N", "Z"],
    "apps": ["AE1", "P", "S"],
    "apra": ["EY1", "P", "R", "AH0"],
    "aprea": ["AA1", "P", "R", "IY0", "AH0"],
    "apricot": ["EY1", "P", "R", "AH0", "K", "AA2", "T"],
    "apricots": ["AE1", "P", "R", "AH0", "K", "AA2", "T", "S"],
    "april": ["EY1", "P", "R", "AH0", "L"],
    "april's": ["EY1", "P", "R", "AH0", "L", "Z"],
    "aprile": ["AA1", "P", "R", "AH0", "L"],
    "apriori": ["AH0", "P", "R", "IY0", "AO1", "R", "IY0"],
    "aprodiva": ["AE2", "P", "R", "AO0", "D", "IY1", "V", "AH0"],
    "apron": ["EY1", "P", "R", "AH0", "N"],
    "aprons": ["EY1", "P", "R", "AH0", "N", "Z"],
    "apropos": ["AE2", "P", "R", "AH0", "P", "OW1"],
    "apsell": ["AE1", "P", "S", "AH0", "L"],
    "apsey": ["AE1", "P", "S", "IY0"],
    "apso": ["AE1", "P", "S", "OW0"],
    "apstar": ["AE1", "P", "S", "T", "AA2", "R"],
    "apt": ["AE1", "P", "T"],
    "apter": ["AE1", "P", "T", "ER0"],
    "aptitude": ["AE1", "P", "T", "AH0", "T", "UW2", "D"],
    "aptitudes": ["AE1", "P", "T", "AH0", "T", "UW2", "D", "Z"],
    "aptiva": ["AE2", "P", "T", "IY1", "V", "AH0"],
    "aptly": ["AE1", "P", "T", "L", "IY0"],
    "apuzzo": ["AA0", "P", "UW1", "Z", "OW0"],
    "aqaba": ["AH0", "K", "AA1", "B", "AH0"],
    "aqazadeh": ["AE2", "K", "AH0", "Z", "AA1", "D", "EH2"],
    "aqua": ["AA1", "K", "W", "AH0"],
    "aquaculture": ["AE1", "K", "W", "AH0", "K", "AH2", "L", "CH", "ER0"],
    "aqualung": ["AE1", "K", "W", "AH0", "L", "AH0", "NG"],
    "aquamarine": ["AA2", "K", "W", "AH0", "M", "ER0", "IY1", "N"],
    "aquanaut": ["AA1", "K", "W", "AH0", "N", "AA2", "T"],
    "aquanauts": ["AA1", "K", "W", "AH0", "N", "AA2", "T", "S"],
    "aquarist": ["AH0", "K", "W", "EH1", "R", "IH0", "S", "T"],
    "aquarists": ["AH0", "K", "W", "EH1", "R", "IH0", "S", "T", "S"],
    "aquarium": ["AH0", "K", "W", "EH1", "R", "IY0", "AH0", "M"],
    "aquariums": ["AH0", "K", "W", "EH1", "R", "IY0", "AH0", "M", "Z"],
    "aquarius": ["AH0", "K", "W", "EH1", "R", "IY0", "AH0", "S"],
    "aquatic": ["AH0", "K", "W", "AE1", "T", "IH0", "K"],
    "aqueduct": ["AE1", "K", "W", "AH0", "D", "AH2", "K", "T"],
    "aqueducts": ["AE1", "K", "W", "AH0", "D", "AH2", "K", "T", "S"],
    "aqueous": ["EY1", "K", "W", "IY0", "AH0", "S"],
    "aquifer": ["AE1", "K", "W", "AH0", "F", "ER0"],
    "aquifers": ["AE1", "K", "W", "AH0", "F", "ER0", "Z"],
    "aquila": ["AE1", "K", "W", "AH0", "L", "AH0"],
    "aquilar": ["AA0", "K", "W", "IY0", "L", "AA1", "R"],
    "aquilina": ["AA0", "K", "W", "IY0", "L", "IY1", "N", "AH0"],
    "aquilino": ["AA0", "K", "W", "IY0", "L", "IY1", "N", "OW0"],
    "aquinas": ["AH0", "K", "W", "AY1", "N", "AH0", "S"],
    "aquino": ["AH0", "K", "IY1", "N", "OW0"],
    "aquino's": ["AH0", "K", "IY1", "N", "OW0", "Z"],
    "aquirre": ["AE1", "K", "W", "ER0"],
    "aquitaine": ["AE2", "K", "W", "IH0", "T", "EY1", "N"],
    "ar": ["AA1", "R"],
    "ara": ["AE1", "R", "AH0"],
    "arab": ["EY1", "R", "AH0", "B"],
    "arabe": ["AA0", "R", "AA1", "B", "EY0"],
    "arabella": ["AE2", "R", "AH0", "B", "EH1", "L", "AH0"],
    "arabia": ["AH0", "R", "EY1", "B", "IY0", "AH0"],
    "arabia's": ["AH0", "R", "EY1", "B", "IY0", "AH0", "Z"],
    "arabian": ["AH0", "R", "EY1", "B", "IY0", "AH0", "N"],
    "arabians": ["AH0", "R", "EY1", "B", "IY0", "AH0", "N", "Z"],
    "arabic": ["EH1", "R", "AH0", "B", "IH0", "K"],
    "arabica": ["ER0", "AE1", "B", "IH0", "K", "AH0"],
    "arabichon": ["AH0", "R", "AE1", "B", "IH0", "SH", "AO2", "N"],
    "arabichon's": ["AH0", "R", "AE1", "B", "IH0", "SH", "AO2", "N", "Z"],
    "arabicon": ["AH0", "R", "AE1", "B", "AH0", "K", "AO2", "N"],
    "arabie": ["AE1", "R", "AH0", "B", "IY0"],
    "arable": ["AE1", "R", "AH0", "B", "AH0", "L"],
    "arabs": ["EY1", "R", "AH0", "B", "Z"],
    "arabs'": ["AE1", "R", "AH0", "B", "Z"],
    "araby": ["AE1", "R", "AH0", "B", "IY2"],
    "arachnid": ["ER0", "AE1", "K", "N", "IH0", "D"],
    "arachnids": ["ER0", "AE1", "K", "N", "IH0", "D", "Z"],
    "arafat": ["EH1", "R", "AH0", "F", "AE0", "T"],
    "arafat's": ["EH1", "R", "AH0", "F", "AE0", "T", "S"],
    "aragon": ["EH1", "R", "AH0", "G", "AA2", "N"],
    "aragona": ["AA0", "R", "AA0", "G", "OW1", "N", "AH0"],
    "arai": ["AA0", "R", "AA1", "IY0"],
    "araiza": ["ER0", "EY1", "Z", "AH0"],
    "arakaki": ["AA0", "R", "AA0", "K", "AA1", "K", "IY0"],
    "arakawa": ["AA2", "R", "AA0", "K", "AA1", "W", "AH0"],
    "arakelian": ["AE0", "R", "AH0", "K", "EH1", "L", "Y", "AH0", "N"],
    "araki": ["AA0", "R", "AA1", "K", "IY0"],
    "aral": ["AA1", "R", "AA0", "L"],
    "aramaic": ["AA2", "R", "AA0", "M", "EH1", "Y", "IH0", "K"],
    "arambula": ["AA0", "R", "AA0", "M", "B", "UW1", "L", "AH0"],
    "aramco": ["ER0", "AE1", "M", "K", "OW0"],
    "aramid": ["EH1", "R", "AH0", "M", "IH0", "D"],
    "araminta": ["AE2", "R", "AH0", "M", "IH1", "N", "T", "AH0"],
    "aramis": ["EH1", "R", "AH0", "M", "IH0", "S"],
    "aramony": ["EH1", "R", "AH0", "M", "OW2", "N", "IY0"],
    "aran": ["EH1", "R", "AH0", "N"],
    "arana": ["AA0", "R", "AE1", "N", "AH0"],
    "aranda": ["ER0", "AE1", "N", "D", "AH0"],
    "arango": ["AA0", "R", "AA1", "NG", "G", "OW0"],
    "aransas": ["ER0", "AE1", "N", "S", "AH0", "S"],
    "arant": ["AA1", "R", "AH0", "N", "T"],
    "arantxa": ["AA1", "R", "AE2", "T", "S", "AA0"],
    "arantza": ["AH0", "R", "AA1", "N", "T", "Z", "AH0"],
    "aranyos": ["ER0", "AA1", "N", "Y", "OW2", "S"],
    "arapaho": ["ER0", "AE1", "P", "AH0", "HH", "OW2"],
    "arapahoe": ["ER0", "AE1", "P", "AH0", "HH", "OW2"],
    "ararat": ["AE1", "R", "AH0", "R", "AA2", "T"],
    "araskog": ["ER0", "AE1", "S", "K", "AA0", "G"],
    "arata": ["AA0", "R", "AA1", "T", "AH0"],
    "arau": ["AH0", "R", "AW1"],
    "araujo": ["AA0", "R", "AW1", "Y", "OW0"],
    "aravind": ["AA1", "R", "V", "AH0", "N", "D"],
    "arawak": ["AA1", "R", "AA0", "W", "AA2", "K"],
    "araya": ["ER0", "AY1", "AH0"],
    "arb": ["AA1", "R", "B"],
    "arba": ["AA1", "R", "B", "AH0"],
    "arbat": ["AA1", "R", "B", "AE0", "T"],
    "arbaugh": ["AA1", "R", "B", "AO2"],
    "arbed": ["AA1", "R", "B", "IH0", "D"],
    "arbeiter": ["AA1", "R", "B", "AY0", "T", "ER0"],
    "arbel": ["AA1", "R", "B", "AH0", "L"],
    "arbella": ["AA2", "R", "B", "EH1", "L", "AH0"],
    "arbenz": ["AA1", "R", "B", "EH0", "N", "Z"],
    "arbiter": ["AA1", "R", "B", "IH0", "T", "ER0"],
    "arbiters": ["AA1", "R", "B", "AH0", "T", "ER0", "Z"],
    "arbitrage": ["AA1", "R", "B", "IH0", "T", "R", "AA2", "ZH"],
    "arbitrager": ["AA1", "R", "B", "IH0", "T", "R", "AA2", "ZH", "ER0"],
    "arbitragers": ["AA1", "R", "B", "IH0", "T", "R", "AA2", "ZH", "ER0", "Z"],
    "arbitragers'": ["AA1", "R", "B", "IH0", "T", "R", "AA2", "ZH", "ER0", "Z"],
    "arbitrageur": ["AA1", "R", "B", "IH0", "T", "R", "AA2", "ZH", "ER0"],
    "arbitrageurs": ["AA2", "R", "B", "AH0", "T", "R", "AA2", "ZH", "ER1", "Z"],
    "arbitraging": ["AA1", "R", "B", "AH0", "T", "R", "AA2", "JH", "IH0", "NG"],
    "arbitrarily": ["AA1", "R", "B", "IH0", "T", "R", "EH2", "R", "AH0", "L", "IY0"],
    "arbitrariness": ["AA1", "R", "B", "AH0", "T", "R", "EH2", "R", "IY0", "N", "AH0", "S"],
    "arbitrary": ["AA1", "R", "B", "IH0", "T", "R", "EH2", "R", "IY0"],
    "arbitrate": ["AA1", "R", "B", "AH0", "T", "R", "EY2", "T"],
    "arbitrated": ["AA1", "R", "B", "AH0", "T", "R", "EY2", "T", "IH0", "D"],
    "arbitrates": ["AA1", "R", "B", "IH0", "T", "R", "EY2", "T", "S"],
    "arbitrating": ["AA1", "R", "B", "AH0", "T", "R", "EY2", "T", "IH0", "NG"],
    "arbitration": ["AA2", "R", "B", "IH0", "T", "R", "EY1", "SH", "AH0", "N"],
    "arbitrations": ["AA2", "R", "B", "IH0", "T", "R", "EY1", "SH", "AH0", "N", "Z"],
    "arbitrator": ["AA1", "R", "B", "IH0", "T", "R", "EY2", "T", "ER0"],
    "arbitrator's": ["AA1", "R", "B", "AH0", "T", "R", "EY2", "T", "ER0", "Z"],
    "arbitrators": ["AA1", "R", "B", "IH0", "T", "R", "EY2", "T", "ER0", "Z"],
    "arbitrators'": ["AA1", "R", "B", "AH0", "T", "R", "EY2", "T", "ER0", "Z"],
    "arbitron": ["AA1", "R", "B", "AH0", "T", "R", "AH0", "N"],
    "arbo": ["AA1", "R", "B", "OW0"],
    "arbogast": ["AA0", "R", "B", "OW1", "G", "AA0", "S", "T"],
    "arboleda": ["AA0", "R", "B", "OW0", "L", "EH1", "D", "AH0"],
    "arbor": ["AA1", "R", "B", "ER0"],
    "arboreal": ["AA0", "R", "B", "AO1", "R", "IY0", "AH0", "L"],
    "arboretum": ["AA2", "R", "B", "ER0", "IY1", "T", "AH0", "M"],
    "arborville": ["AA1", "R", "B", "ER0", "V", "IH0", "L"],
    "arbothnott": ["AA2", "R", "B", "AO1", "TH", "N", "AO0", "T"],
    "arbour": ["AA1", "R", "B", "ER0"],
    "arbs": ["AA1", "R", "B", "Z"],
    "arbuckle": ["AA1", "R", "B", "AH0", "K", "AH0", "L"],
    "arbuckles": ["AA1", "R", "B", "AH0", "K", "AH0", "L", "Z"],
    "arbuthnot": ["AA0", "R", "B", "AH1", "TH", "N", "AH0", "T"],
    "arby": ["AA1", "R", "B", "IY0"],
    "arby's": ["AA1", "R", "B", "IY0", "Z"],
    "arc": ["AA1", "R", "K"],
    "arcade": ["AA0", "R", "K", "EY1", "D"],
    "arcades": ["AA0", "R", "K", "EY1", "D", "Z"],
    "arcadia": ["AA0", "R", "K", "EY1", "D", "IY0", "AH0"],
    "arcadian": ["AA2", "R", "K", "EY1", "D", "IY0", "AH0", "N"],
    "arcadians": ["AA2", "R", "K", "EY1", "D", "IY0", "AH0", "N", "Z"],
    "arcana": ["AA0", "R", "K", "AE1", "N", "AH0"],
    "arcand": ["AA1", "R", "K", "AH0", "N", "D"],
    "arcane": ["AA2", "R", "K", "EY1", "N"],
    "arcanum": ["AA1", "R", "K", "AH0", "N", "AH0", "M"],
    "arcanum's": ["AA1", "R", "K", "AH0", "N", "AH0", "M", "Z"],
    "arcaro": ["AA0", "R", "K", "AA1", "R", "OW0"],
    "arcata": ["AA0", "R", "K", "AA1", "T", "AH0"],
    "arce": ["AA1", "R", "S"],
    "arcement": ["AA0", "R", "S", "EY1", "M", "AH0", "N", "T"],
    "arceneaux": ["AA1", "R", "S", "IH0", "N", "OW0"],
    "arceo": ["AA1", "R", "S", "IY0", "OW0"],
    "arch": ["AA1", "R", "CH"],
    "archaeological": ["AA2", "R", "K", "IY0", "AH0", "L", "AA1", "JH", "IH0", "K", "AH0", "L"],
    "archaeologist": ["AA2", "R", "K", "IY0", "AA1", "L", "AH0", "JH", "IH0", "S", "T"],
    "archaeologists": ["AA2", "R", "K", "IY0", "AA1", "L", "AH0", "JH", "IH0", "S", "T", "S"],
    "archaeology": ["AA2", "R", "K", "IY0", "AA1", "L", "AH0", "JH", "IY0"],
    "archaic": ["AA0", "R", "K", "EY1", "IH0", "K"],
    "archambault": ["AA1", "R", "SH", "AH0", "M", "B", "OW0"],
    "archambeau": ["AA1", "R", "SH", "AH0", "M", "B", "OW2"],
    "archambeault": ["AA1", "R", "SH", "AH0", "M", "B", "OW0"],
    "archangel": ["AA2", "R", "K", "EY1", "N", "JH", "AH0", "L"],
    "archangels": ["AA2", "R", "K", "EY1", "N", "JH", "AH0", "L", "Z"],
    "archard": ["AA0", "R", "SH", "AA1", "R", "D"],
    "archbishop": ["AA1", "R", "CH", "B", "IH1", "SH", "AH0", "P"],
    "archbold": ["AA1", "R", "CH", "B", "OW2", "L", "D"],
    "archdiocese": ["AA1", "R", "CH", "D", "AY1", "AH0", "S", "IY0", "Z"],
    "archduke": ["AA1", "R", "CH", "D", "UW2", "K"],
    "arched": ["AA1", "R", "CH", "T"],
    "archenemy": ["AA1", "R", "CH", "EH1", "N", "AH0", "M", "IY0"],
    "archeological": ["AA2", "R", "K", "IY0", "AH0", "L", "AA1", "JH", "IH0", "K", "AH0", "L"],
    "archeology": ["AA2", "R", "K", "IY0", "AA1", "L", "AH0", "JH", "IY0"],
    "archer": ["AA1", "R", "CH", "ER0"],
    "archer's": ["AA1", "R", "CH", "ER0", "Z"],
    "archerd": ["AA1", "R", "K", "ER0", "D"],
    "archers": ["AA1", "R", "CH", "ER0", "Z"],
    "archery": ["AA1", "R", "CH", "ER0", "IY0"],
    "arches": ["AA1", "R", "CH", "IH0", "Z"],
    "archetypal": ["AA1", "R", "K", "T", "AY1", "P", "AH0", "L"],
    "archetype": ["AA1", "R", "K", "IH0", "T", "AY2", "P"],
    "archetypes": ["AA1", "R", "K", "IH0", "T", "AY2", "P", "S"],
    "archey": ["AA1", "R", "K", "IY0"],
    "archibald": ["AA1", "R", "CH", "AH0", "B", "AO2", "L", "D"],
    "archibeque": ["AA1", "R", "SH", "IH0", "B", "IY0", "K"],
    "archie": ["AA1", "R", "CH", "IY0"],
    "archimedes": ["AA2", "R", "K", "AH0", "M", "IY1", "D", "IY0", "Z"],
    "arching": ["AA1", "R", "CH", "IH0", "NG"],
    "archipelago": ["AA2", "R", "CH", "AH0", "P", "AH0", "L", "EY1", "G", "OW2"],
    "archippus": ["AE2", "R", "K", "IH1", "P", "AH0", "S"],
    "architect": ["AA1", "R", "K", "AH0", "T", "EH2", "K", "T"],
    "architect's": ["AA1", "R", "K", "AH0", "T", "EH2", "K", "T", "S"],
    "architects": ["AA1", "R", "K", "AH0", "T", "EH2", "K", "T", "S"],
    "architectural": ["AA2", "R", "K", "AH0", "T", "EH1", "K", "CH", "ER0", "AH0", "L"],
    "architecturally": ["AA2", "R", "K", "IH0", "T", "EH1", "K", "CH", "R", "AH0", "L", "IY0"],
    "architecture": ["AA1", "R", "K", "AH0", "T", "EH2", "K", "CH", "ER0"],
    "architecture's": ["AA1", "R", "K", "AH0", "T", "EH2", "K", "CH", "ER0", "Z"],
    "architectures": ["AA1", "R", "K", "AH0", "T", "EH2", "K", "CH", "ER0", "Z"],
    "architrave": ["AA1", "R", "K", "AH0", "T", "R", "EY2", "V"],
    "architraves": ["AA1", "R", "K", "AH0", "T", "R", "EY2", "V", "Z"],
    "archival": ["AA0", "R", "K", "AY1", "V", "AH0", "L"],
    "archive": ["AA1", "R", "K", "AY2", "V"],
    "archived": ["AA1", "R", "K", "AY2", "V", "D"],
    "archives": ["AA1", "R", "K", "AY2", "V", "Z"],
    "archivist": ["AA1", "R", "K", "AY0", "V", "IH0", "S", "T"],
    "archivists": ["AA1", "R", "K", "AY0", "V", "IH0", "S", "T", "S"],
    "archly": ["AA1", "R", "CH", "L", "IY0"],
    "archrival": ["AA1", "R", "CH", "R", "AY2", "V", "AH0", "L"],
    "archrivals": ["AA1", "R", "CH", "R", "AY2", "V", "AH0", "L", "Z"],
    "archuleta": ["AA0", "R", "K", "UW0", "L", "EH1", "T", "AH0"],
    "archuletta": ["AA0", "R", "K", "UW0", "L", "EH1", "T", "AH0"],
    "archway": ["AA1", "R", "CH", "W", "EY2"],
    "arcidiacono": ["AA0", "R", "CH", "IY0", "D", "IY2", "AA0", "K", "OW1", "N", "OW2"],
    "arcieri": ["AA0", "R", "CH", "IH1", "R", "IY0"],
    "arciniega": ["AA0", "R", "CH", "IY0", "N", "IY1", "G", "AH0"],
    "arco": ["AA1", "R", "K", "OW0"],
    "arco's": ["AA1", "R", "K", "OW0", "Z"],
    "arcola": ["AA0", "R", "K", "OW1", "L", "AH0"],
    "arcos": ["AA1", "R", "K", "OW0", "Z"],
    "arcosanti": ["AA2", "R", "K", "AH0", "S", "AE1", "N", "T", "IY0"],
    "arcs": ["AA1", "R", "K", "S"],
    "arctic": ["AA1", "R", "T", "IH0", "K"],
    "arcturus": ["AA2", "R", "K", "T", "ER1", "AH0", "S"],
    "arcuri": ["AA0", "R", "K", "UH1", "R", "IY0"],
    "ard": ["AA1", "R", "D"],
    "arda": ["AA1", "R", "D", "AH0"],
    "ardath": ["AA1", "R", "D", "AH0", "TH"],
    "ardeen": ["AA0", "R", "D", "IY1", "N"],
    "ardelia": ["AA0", "R", "D", "EH1", "L", "IY0", "AH0"],
    "ardella": ["AA2", "R", "D", "EH1", "L", "AH0"],
    "ardelle": ["AA0", "R", "D", "EH1", "L"],
    "arden": ["AA1", "R", "D", "AH0", "N"],
    "arden's": ["AA1", "R", "D", "AH0", "N", "Z"],
    "ardene": ["AA1", "R", "D", "IY2", "N"],
    "ardent": ["AA1", "R", "D", "AH0", "N", "T"],
    "ardently": ["AA1", "R", "D", "AH0", "N", "T", "L", "IY0"],
    "ardin": ["AA1", "R", "D", "IH0", "N"],
    "ardine": ["AA0", "R", "D", "IY1", "N", "IY0"],
    "ardis": ["AA1", "R", "D", "IH0", "S"],
    "ardith": ["AA1", "R", "D", "IH0", "TH"],
    "ardito": ["AA0", "R", "D", "IY1", "T", "OW0"],
    "ardley": ["AA1", "R", "D", "L", "IY0"],
    "ardmore": ["AA1", "R", "D", "M", "AO2", "R"],
    "ardoin": ["AA0", "R", "D", "OY1", "N"],
    "ardolino": ["AA0", "R", "D", "OW0", "L", "IY1", "N", "OW0"],
    "ardolph": ["AA1", "R", "D", "OW2", "L", "F"],
    "ardor": ["AA1", "R", "D", "ER0"],
    "ardoyne": ["AA1", "R", "D", "OY0", "N"],
    "ardra": ["AA1", "R", "D", "R", "AH0"],
    "ardrey": ["AA1", "R", "D", "R", "IY0"],
    "ardshiel": ["AA1", "R", "D", "SH", "IY2", "L"],
    "ardsley": ["AA1", "R", "D", "Z", "L", "IY0"],
    "arduini": ["AA0", "R", "D", "UW0", "IY1", "N", "IY0"],
    "arduino": ["AA1", "R", "D", "W", "IY1", "N", "OW0"],
    "arduous": ["AA1", "R", "JH", "UW0", "AH0", "S"],
    "are": ["ER0"],
    "area": ["EH1", "R", "IY0", "AH0"],
    "area's": ["EH1", "R", "IY0", "AH0", "Z"],
    "areas": ["EH1", "R", "IY0", "AH0", "Z"],
    "arebalo": ["AA0", "R", "EH0", "B", "AA1", "L", "OW0"],
    "arechiga": ["AA0", "R", "EH0", "K", "IY1", "G", "AH0"],
    "arehart": ["AE1", "R", "IH0", "HH", "AA0", "R", "T"],
    "arel": ["AA0", "R", "EH1", "L"],
    "arellanes": ["AE1", "R", "IH0", "L", "EY2", "N", "Z"],
    "arellano": ["AA0", "R", "EH0", "L", "AA1", "N", "OW0"],
    "aren": ["AA1", "R", "AH0", "N"],
    "aren't": ["AA1", "R", "N", "T"],
    "arena": ["ER0", "IY1", "N", "AH0"],
    "arena's": ["ER0", "IY1", "N", "AH0", "Z"],
    "arenaball": ["ER0", "IY1", "N", "AH0", "B", "AO2", "L"],
    "arenas": ["ER0", "IY1", "N", "AH0", "Z"],
    "arencibia": ["AA0", "R", "EH0", "N", "CH", "IY1", "B", "IY0", "AH0"],
    "arend": ["ER0", "EH1", "N", "D"],
    "arends": ["ER0", "EH1", "N", "D", "Z"],
    "arendsee": ["ER0", "EH1", "N", "D", "S", "IY2"],
    "arendt": ["EH1", "R", "IH0", "N", "T"],
    "arenella": ["AA2", "R", "AH0", "N", "EH1", "L", "AH0"],
    "arenella's": ["AA2", "R", "AH0", "N", "EH1", "L", "AH0", "Z"],
    "arens": ["AA1", "R", "AH0", "N", "Z"],
    "arenson": ["AE1", "R", "IH0", "N", "S", "AH0", "N"],
    "arent": ["AA1", "R", "AH0", "N", "T"],
    "arentz": ["AE1", "R", "IH0", "N", "T", "S"],
    "arenz": ["AA1", "R", "EY0", "N", "Z"],
    "arequipa": ["AA2", "R", "EH0", "K", "IY1", "P", "AA0"],
    "ares": ["AA1", "R", "Z"],
    "areta": ["AA0", "R", "EH1", "T", "AH0"],
    "aretha": ["ER0", "IY1", "TH", "AH0"],
    "aretina": ["AA0", "R", "EH0", "T", "IY1", "N", "AH0"],
    "aretsky": ["EH0", "R", "EH1", "T", "S", "K", "IY1"],
    "aretta": ["AA0", "R", "EH1", "T", "AH0"],
    "arevalo": ["AA0", "R", "EY0", "V", "AA1", "L", "OW0"],
    "arey": ["AE1", "R", "IY0"],
    "argabright": ["AA1", "R", "G", "AH0", "B", "R", "AY2", "T"],
    "argall": ["AA1", "R", "G", "AH0", "L"],
    "arganbright": ["AA0", "R", "G", "AE1", "N", "B", "R", "AY0", "T"],
    "argenbright": ["AA1", "R", "G", "IH0", "N", "B", "R", "AY0", "T"],
    "argent": ["AA1", "R", "JH", "IH0", "N", "T"],
    "argenta": ["AA2", "R", "JH", "EH1", "N", "T", "AH0"],
    "argentieri": ["AA0", "R", "JH", "EH0", "N", "T", "IH1", "R", "IY0"],
    "argentina": ["AA2", "R", "JH", "AH0", "N", "T", "IY1", "N", "AH0"],
    "argentina's": ["AA2", "R", "JH", "AH0", "N", "T", "IY1", "N", "AH0", "Z"],
    "argentinas": ["AA2", "R", "JH", "AH0", "N", "T", "IY1", "N", "AH0", "Z"],
    "argentine": ["AA1", "R", "JH", "AH0", "N", "T", "IY2", "N"],
    "argentines": ["AA1", "R", "JH", "AH0", "N", "T", "IY2", "N", "Z"],
    "argentinian": ["AA2", "R", "JH", "AH0", "N", "T", "IH1", "N", "IY0", "AH0", "N"],
    "argentinians": ["AA2", "R", "JH", "AH0", "N", "T", "IH1", "N", "IY0", "AH0", "N", "Z"],
    "argento": ["AA2", "R", "JH", "EH1", "N", "T", "OW0"],
    "argh": ["AA1", "R", "G"],
    "argiro": ["AA0", "R", "JH", "IH1", "R", "OW0"],
    "argo": ["AA1", "R", "G", "OW0"],
    "argo's": ["AA1", "R", "G", "OW0", "Z"],
    "argon": ["AA1", "R", "G", "AA2", "N"],
    "argonaut": ["AA1", "R", "G", "AH0", "N", "AO2", "T"],
    "argonaut's": ["AA1", "R", "G", "AH0", "N", "AO2", "T", "S"],
    "argonauts": ["AA1", "R", "G", "AH0", "N", "AO2", "T", "S"],
    "argonne": ["AA1", "R", "G", "OW2", "N"],
    "argosy": ["AA1", "R", "G", "AH0", "S", "IY0"],
    "argosystem": ["AA1", "R", "G", "OW0", "S", "IH2", "S", "T", "AH0", "M"],
    "argosystems": ["AA1", "R", "G", "OW0", "S", "IH2", "S", "T", "AH0", "M", "Z"],
    "argot": ["AA1", "R", "G", "AH0", "T"],
    "arguable": ["AA1", "R", "G", "Y", "UW0", "AH0", "B", "AH0", "L"],
    "arguably": ["AA1", "R", "G", "Y", "UW0", "AH0", "B", "L", "IY0"],
    "argue": ["AA1", "R", "G", "Y", "UW0"],
    "argued": ["AA1", "R", "G", "Y", "UW0", "D"],
    "arguelles": ["AA0", "R", "G", "EY1", "L", "EH0", "S"],
    "arguello": ["AA0", "R", "G", "EH1", "L", "OW0"],
    "argues": ["AA1", "R", "G", "Y", "UW0", "Z"],
    "argueta": ["AA0", "R", "G", "EY1", "T", "AH0"],
    "arguijo": ["AA0", "R", "G", "W", "IY1", "Y", "OW0"],
    "arguing": ["AA1", "R", "G", "Y", "UW0", "IH0", "NG"],
    "argument": ["AA1", "R", "G", "Y", "AH0", "M", "AH0", "N", "T"],
    "argument's": ["AA1", "R", "G", "Y", "AH0", "M", "AH0", "N", "T", "S"],
    "argumentation": ["AA2", "R", "G", "Y", "AH0", "M", "EH0", "N", "T", "EY1", "SH", "AH0", "N"],
    "argumentative": ["AA2", "R", "G", "Y", "AH0", "M", "EH1", "N", "T", "AH0", "T", "IH0", "V"],
    "arguments": ["AA1", "R", "G", "Y", "AH0", "M", "AH0", "N", "T", "S"],
    "argus": ["AA1", "R", "G", "AH0", "S"],
    "argyle": ["AA1", "R", "G", "AY2", "L"],
    "argyll": ["AA0", "R", "G", "AY1", "L"],
    "argyropoulos": ["AA2", "R", "JH", "IH0", "R", "AA1", "P", "OW0", "L", "AH0", "S"],
    "ari": ["AA1", "R", "IY0"],
    "aria": ["AA1", "R", "IY0", "AH0"],
    "ariadne": ["EH2", "R", "IY0", "AE1", "D", "N", "IY0"],
    "arial": ["EH1", "R", "IY2", "AH0", "L"],
    "arian": ["AE1", "R", "IY0", "AH0", "N"],
    "ariana": ["AA0", "R", "IY0", "AE1", "N", "AH0"],
    "ariane": ["EH2", "R", "IY0", "AE1", "N"],
    "arianespace": ["EH2", "R", "IY0", "AE1", "N", "S", "P", "EY1", "S"],
    "arianism": ["AE1", "R", "IY0", "AH0", "N", "IH2", "Z", "AH0", "M"],
    "arianna": ["AA0", "R", "IY0", "AE1", "N", "AH0"],
    "arianna's": ["AA0", "R", "IY0", "AE1", "N", "AH0", "Z"],
    "arias": ["AA1", "R", "IY0", "AH0", "Z"],
    "arias's": ["AA1", "R", "IY0", "AH0", "S", "IH0", "Z"],
    "aric": ["AE1", "R", "IH0", "K"],
    "arico": ["AA0", "R", "IY1", "K", "OW0"],
    "arid": ["EH1", "R", "AH0", "D"],
    "arida": ["AH0", "R", "IY1", "D", "AH0"],
    "arie": ["EH1", "R", "IY0"],
    "ariel": ["EH1", "R", "IY0", "AH0", "L"],
    "ariela": ["AA0", "R", "IY0", "EH1", "L", "AH0"],
    "ariella": ["AA0", "R", "IY0", "EH1", "L", "AH0"],
    "aries": ["EH1", "R", "IY0", "Z"],
    "arington": ["AA1", "R", "IH0", "NG", "T", "AH0", "N"],
    "ariola": ["AA0", "R", "IY0", "OW1", "L", "AH0"],
    "aris": ["ER0", "IY1", "S"],
    "arise": ["ER0", "AY1", "Z"],
    "arisen": ["ER0", "IH1", "Z", "AH0", "N"],
    "arises": ["ER0", "AY1", "Z", "IH0", "Z"],
    "arising": ["ER0", "AY1", "Z", "IH0", "NG"],
    "arison": ["EH1", "R", "IH0", "S", "AH0", "N"],
    "arispe": ["AA0", "R", "IY1", "S", "P", "IY0"],
    "arista": ["ER0", "IH1", "S", "T", "AH0"],
    "aristech": ["EH1", "R", "IH0", "S", "T", "EH2", "K"],
    "aristede": ["AA2", "R", "IH0", "S", "T", "IY1", "D"],
    "aristede's": ["AA2", "R", "IH0", "S", "T", "IY1", "D", "Z"],
    "aristide": ["AA2", "R", "IH0", "S", "T", "IY1", "D"],
    "aristide's": ["AA2", "R", "IH0", "S", "T", "IY1", "D", "Z"],
    "aristocracy": ["EH2", "R", "AH0", "S", "T", "AA1", "K", "R", "AH0", "S", "IY0"],
    "aristocrat": ["ER0", "IH1", "S", "T", "AH0", "K", "R", "AE2", "T"],
    "aristocratic": ["ER0", "IH2", "S", "T", "AH0", "K", "R", "AE1", "T", "IH0", "K"],
    "aristocrats": ["ER0", "IH1", "S", "T", "AH0", "K", "R", "AE2", "T", "S"],
    "aristophanes": ["AE2", "R", "AH0", "S", "T", "AO1", "F", "AH0", "N", "IY0", "Z"],
    "aristotelian": ["ER0", "IH2", "S", "T", "AH0", "T", "IY1", "L", "IY0", "AH0", "N"],
    "aristotle": ["EH1", "R", "AH0", "S", "T", "AA2", "T", "AH0", "L"],
    "aristotle's": ["EH1", "R", "AH0", "S", "T", "AA2", "T", "AH0", "L", "Z"],
    "arithmetic": ["ER0", "IH1", "TH", "M", "AH0", "T", "IH2", "K"],
    "ariza": ["AA0", "R", "IY1", "Z", "AH0"],
    "arizmendi": ["AA0", "R", "IY0", "Z", "M", "EH1", "N", "D", "IY0"],
    "arizona": ["EH2", "R", "IH0", "Z", "OW1", "N", "AH0"],
    "arizona's": ["EH2", "R", "IH0", "Z", "OW1", "N", "AH0", "Z"],
    "arizonan": ["ER0", "IH0", "Z", "OW1", "N", "AH0", "N"],
    "arizonans": ["ER0", "IH0", "Z", "OW1", "N", "AH0", "N", "Z"],
    "arjo": ["AA1", "R", "Y", "OW0"],
    "arjun": ["AA1", "R", "JH", "AH0", "N"],
    "ark": ["AA1", "R", "K"],
    "arkadelphia": ["AA2", "R", "K", "AH0", "D", "EH1", "L", "F", "IY0", "AH0"],
    "arkadi": ["AA1", "R", "K", "AH0", "D", "IY0"],
    "arkady": ["AA2", "R", "K", "EY1", "D", "IY0"],
    "arkansan": ["AA2", "R", "K", "AE1", "N", "Z", "AH0", "N"],
    "arkansans": ["AA2", "R", "K", "AE1", "N", "Z", "AH0", "N", "Z"],
    "arkansas": ["AA1", "R", "K", "AH0", "N", "S", "AA2"],
    "arkansas'": ["AA1", "R", "K", "AH0", "N", "S", "AA2", "Z"],
    "arkansas's": ["AA1", "R", "K", "AH0", "N", "S", "AA2", "Z"],
    "arkarow": ["AA1", "R", "K", "AH0", "R", "OW0"],
    "arkin": ["AA1", "R", "K", "IH0", "N"],
    "arkin's": ["AA1", "R", "K", "IH0", "N", "Z"],
    "arkla": ["AA1", "R", "K", "L", "AH0"],
    "arkla's": ["AA1", "R", "K", "L", "AH0", "Z"],
    "arko": ["AA1", "R", "K", "OW0"],
    "arkose": ["AA0", "R", "K", "OW1", "S"],
    "arkwright": ["AA1", "R", "K", "R", "AY2", "T"],
    "arlana": ["AA0", "R", "L", "AE1", "N", "AH0"],
    "arlauskas": ["AA0", "R", "L", "AO1", "S", "K", "AH0", "S"],
    "arledge": ["AA1", "R", "L", "IH0", "JH"],
    "arleen": ["AA0", "R", "L", "IY1", "N"],
    "arlen": ["AA1", "R", "L", "AH0", "N"],
    "arlena": ["AA1", "R", "L", "IH0", "N", "AH0"],
    "arlene": ["AA1", "R", "L", "IY2", "N"],
    "arlene's": ["AA1", "R", "L", "IY2", "N", "Z"],
    "arleta": ["AA1", "R", "L", "IH0", "T", "AH0"],
    "arlette": ["AA2", "R", "L", "EH1", "T"],
    "arley": ["AA1", "R", "L", "IY0"],
    "arlie": ["AA1", "R", "L", "IY0"],
    "arlin": ["AA1", "R", "L", "IH0", "N"],
    "arlinda": ["AA2", "R", "L", "IH1", "N", "D", "AH0"],
    "arline": ["AA1", "R", "L", "AY2", "N"],
    "arlington": ["AA1", "R", "L", "IH0", "NG", "T", "AH0", "N"],
    "arlington's": ["AA1", "R", "L", "IH0", "NG", "T", "AH0", "N", "Z"],
    "arlt": ["AA1", "R", "L", "T"],
    "arlyne": ["AA1", "R", "L", "AY2", "N"],
    "arm": ["AA1", "R", "M"],
    "arm's": ["AA1", "R", "M", "Z"],
    "armacost": ["AA1", "R", "M", "AH0", "K", "AO2", "S", "T"],
    "armacost's": ["AA1", "R", "M", "AH0", "K", "AO2", "S", "T", "S"],
    "armada": ["AA0", "R", "M", "AA1", "D", "AH0"],
    "armadillo": ["AA2", "R", "M", "AH0", "D", "IH1", "L", "OW0"],
    "armadillos": ["AA2", "R", "M", "AH0", "D", "IH1", "L", "OW0", "Z"],
    "armageddon": ["AA2", "R", "M", "AH0", "G", "EH1", "D", "AH0", "N"],
    "armagost": ["AA0", "R", "M", "AA1", "G", "OW0", "S", "T"],
    "armament": ["AA1", "R", "M", "AH0", "M", "AH0", "N", "T"],
    "armaments": ["AA1", "R", "M", "AH0", "M", "AH0", "N", "T", "S"],
    "arman": ["AA1", "R", "M", "AH0", "N"],
    "armand": ["AA2", "R", "M", "AA1", "N", "D"],
    "armando": ["AA0", "R", "M", "AA1", "N", "D", "OW0"],
    "armandt": ["AA1", "R", "M", "AE0", "N", "T"],
    "armani": ["AA2", "R", "M", "AA1", "N", "IY0"],
    "armantrout": ["AA1", "R", "M", "AH0", "N", "T", "R", "AW2", "T"],
    "armaro": ["AA2", "R", "M", "AA1", "R", "OW0"],
    "armas": ["AA1", "R", "M", "AH0", "Z"],
    "armato": ["AA0", "R", "M", "AA1", "T", "OW0"],
    "armband": ["AA1", "R", "M", "B", "AE2", "N", "D"],
    "armbands": ["AA1", "R", "M", "B", "AE2", "N", "D", "Z"],
    "armbrister": ["AA1", "R", "M", "B", "R", "IH0", "S", "T", "ER0"],
    "armbrust": ["AA1", "R", "M", "B", "R", "AH0", "S", "T"],
    "armbruster": ["AA1", "R", "M", "B", "R", "UW0", "S", "T", "ER0"],
    "armchair": ["AA1", "R", "M", "CH", "EH2", "R"],
    "armchairs": ["AA1", "R", "M", "CH", "EH2", "R", "Z"],
    "armco": ["AA1", "R", "M", "K", "OW2"],
    "armco's": ["AA1", "R", "M", "K", "OW0", "Z"],
    "armed": ["AA1", "R", "M", "D"],
    "armel": ["AA0", "R", "M", "EH1", "L"],
    "armellino": ["AA2", "R", "M", "EH0", "L", "IY1", "N", "OW0"],
    "armen": ["AA1", "R", "M", "AH0", "N"],
    "armendarez": ["AA0", "R", "M", "EY0", "N", "D", "AA1", "R", "EH0", "Z"],
    "armendariz": ["AA0", "R", "M", "EY0", "N", "D", "AA1", "R", "IY0", "Z"],
    "armenia": ["AA0", "R", "M", "IY1", "N", "IY0", "AH0"],
    "armenia's": ["AA0", "R", "M", "IY1", "N", "IY0", "AH0", "Z"],
    "armenian": ["AA0", "R", "M", "IY1", "N", "IY0", "AH0", "N"],
    "armenians": ["AA0", "R", "M", "IY1", "N", "IY0", "AH0", "N", "Z"],
    "arment": ["AA1", "R", "M", "AH0", "N", "T"],
    "armenta": ["AA0", "R", "M", "EH1", "N", "T", "AH0"],
    "armentor": ["AA0", "R", "M", "AH0", "N", "T", "AO1", "R"],
    "armentrout": ["AA1", "R", "M", "AH0", "N", "T", "R", "AW2", "T"],
    "armer": ["AA1", "R", "M", "ER0"],
    "armes": ["AA1", "R", "M", "Z"],
    "armested": ["AA1", "R", "M", "IH0", "S", "T", "EH2", "D"],
    "armetta": ["AA0", "R", "M", "EH1", "T", "AH0"],
    "armey": ["AA1", "R", "M", "IY0"],
    "armey's": ["AA1", "R", "M", "IY0", "Z"],
    "armfield": ["AA1", "R", "M", "F", "IY2", "L", "D"],
    "armida": ["AA0", "R", "M", "IY1", "D", "AH0"],
    "armies": ["AA1", "R", "M", "IY0", "Z"],
    "armiger": ["AA1", "R", "M", "IH0", "G", "ER0"],
    "armijo": ["AA0", "R", "M", "IY1", "Y", "OW0"],
    "armilla": ["AA0", "R", "M", "IH1", "L", "AH0"],
    "armin": ["AA1", "R", "M", "AH0", "N"],
    "armina": ["AA0", "R", "M", "IY1", "N", "AH0"],
    "armine": ["AA0", "R", "M", "IY1", "N", "IY0"],
    "arming": ["AA1", "R", "M", "IH0", "NG"],
    "armington": ["AA1", "R", "M", "IH0", "NG", "T", "AH0", "N"],
    "arminie": ["AA1", "R", "M", "IH0", "N", "IY0"],
    "armistead": ["AA1", "R", "M", "IH0", "S", "T", "EH2", "D"],
    "armistice": ["AA1", "R", "M", "AH0", "S", "T", "AH0", "S"],
    "armitage": ["AA1", "R", "M", "IH0", "T", "IH0", "JH"],
    "armoire": ["AA1", "M", "W", "AA0", "R"],
    "armoires": ["AA1", "M", "W", "AA0", "R", "Z"],
    "armold": ["AA1", "R", "M", "OW2", "L", "D"],
    "armon": ["AA1", "R", "M", "AH0", "N"],
    "armond": ["AA1", "R", "M", "AH0", "N", "D"],
    "armonk": ["AA1", "R", "M", "AH0", "NG", "K"],
    "armor": ["AA1", "R", "M", "ER0"],
    "armored": ["AA1", "R", "M", "ER0", "D"],
    "armories": ["AA1", "R", "M", "ER0", "IY0", "Z"],
    "armory": ["AA1", "R", "M", "ER0", "IY0"],
    "armour": ["AA1", "R", "M", "ER0"],
    "armpit": ["AA1", "R", "M", "P", "IH2", "T"],
    "armpits": ["AA1", "R", "M", "P", "IH2", "T", "S"],
    "armrest": ["AA1", "R", "M", "R", "EH2", "S", "T"],
    "armrests": ["AA1", "R", "M", "R", "EH2", "S", "T", "S"],
    "arms": ["AA1", "R", "M", "Z"],
    "armstead": ["AA1", "R", "M", "S", "T", "EH2", "D"],
    "armstrad": ["AA1", "R", "M", "S", "T", "R", "AE2", "D"],
    "armstrong": ["AA1", "R", "M", "S", "T", "R", "AO2", "NG"],
    "armstrong's": ["AA1", "R", "M", "S", "T", "R", "AO2", "NG", "Z"],
    "armtec": ["AA1", "R", "M", "T", "EH2", "K"],
    "armtek": ["AA1", "R", "M", "T", "EH2", "K"],
    "armtek's": ["AA1", "R", "M", "T", "EH2", "K", "S"],
    "armwood": ["AA1", "R", "M", "W", "UH2", "D"],
    "army": ["AA1", "R", "M", "IY0"],
    "army's": ["AA1", "R", "M", "IY0", "Z"],
    "arn": ["AA1", "R", "N"],
    "arnal": ["AA1", "R", "N", "AH0", "L"],
    "arnalda": ["AA0", "R", "N", "AA1", "L", "D", "AH0"],
    "arnaldo": ["AA0", "R", "N", "AA1", "L", "D", "OW0"],
    "arnall": ["AA1", "R", "N", "AH0", "L"],
    "arnatt": ["AA0", "R", "N", "AE1", "T"],
    "arnaud": ["AA0", "R", "N", "OW1"],
    "arnault": ["AA2", "R", "N", "OW1"],
    "arnaz": ["AA2", "R", "N", "EH1", "Z"],
    "arndt": ["AA1", "R", "N", "T"],
    "arne": ["AA1", "R", "N"],
    "arnell": ["AA1", "R", "N", "AH0", "L"],
    "arnelle": ["AA2", "R", "N", "EH1", "L"],
    "arnelle's": ["AA2", "R", "N", "EH1", "L", "Z"],
    "arner": ["AA1", "R", "N", "ER0"],
    "arnesen": ["AA0", "R", "N", "IY1", "Z", "AH0", "N"],
    "arneson": ["AA1", "R", "N", "IH0", "S", "AH0", "N"],
    "arnett": ["AA0", "R", "N", "EH1", "T"],
    "arnette": ["AA0", "R", "N", "EH1", "T"],
    "arney": ["AA1", "R", "N", "IY0"],
    "arnhold": ["AA1", "R", "N", "HH", "OW2", "L", "D"],
    "arnholt": ["AA1", "R", "N", "HH", "OW2", "L", "T"],
    "arnie": ["AA1", "R", "N", "IY0"],
    "arnn": ["AA1", "R", "N"],
    "arno": ["AA1", "R", "N", "OW0"],
    "arnold": ["AA1", "R", "N", "AH0", "L", "D"],
    "arnold's": ["AA1", "R", "N", "AH0", "L", "D", "Z"],
    "arnoldi": ["AA0", "R", "N", "OW1", "L", "D", "IY0"],
    "arnolds": ["AA1", "R", "N", "AH0", "L", "D", "Z"],
    "arnoldy": ["AA1", "R", "N", "OW0", "L", "D", "IY0"],
    "arnolphe": ["AA0", "R", "N", "AA1", "L", "F", "IY0"],
    "arnone": ["AA0", "R", "N", "OW1", "N", "IY0"],
    "arnot": ["AA1", "R", "N", "AH0", "T"],
    "arnott": ["AA1", "R", "N", "AA0", "T"],
    "arnotts": ["AA1", "R", "N", "AA0", "T", "S"],
    "arnow": ["AA1", "R", "N", "OW0"],
    "arnox": ["AA1", "R", "N", "AA0", "K", "S"],
    "arns": ["AA1", "R", "N", "Z"],
    "arnst": ["AA1", "R", "N", "S", "T"],
    "arnstein": ["AA1", "R", "N", "S", "T", "IY0", "N"],
    "arntson": ["AA1", "R", "N", "T", "S", "AH0", "N"],
    "arntz": ["AA1", "R", "N", "T", "S"],
    "arntzen": ["AA1", "R", "N", "T", "Z", "AH0", "N"],
    "arnulfo": ["AA0", "R", "N", "AH1", "L", "F", "OW0"],
    "arnwine": ["AA1", "R", "N", "W", "AY2", "N"],
    "arnzen": ["AA1", "R", "N", "Z", "AH0", "N"],
    "aro": ["AA1", "R", "OW0"],
    "arocha": ["AA0", "R", "OW1", "K", "AH0"],
    "arocho": ["AA0", "R", "OW1", "K", "OW0"],
    "aroma": ["ER0", "OW1", "M", "AH0"],
    "aromas": ["ER0", "OW1", "M", "AH0", "Z"],
    "aromatherapy": ["AH0", "R", "OW2", "M", "AH0", "TH", "ER1", "AH0", "P", "IY0"],
    "aromatic": ["EH2", "R", "AH0", "M", "AE1", "T", "IH0", "K"],
    "aron": ["EH1", "R", "AH0", "N"],
    "arone": ["ER0", "OW1", "N"],
    "aronhalt": ["AE1", "R", "AH0", "N", "HH", "AH0", "L", "T"],
    "aronie": ["ER0", "OW1", "N", "IY0"],
    "aronoff": ["EH1", "R", "AH0", "N", "AO0", "F"],
    "aronow": ["ER0", "OW1", "N", "OW0"],
    "aronowitz": ["ER0", "AA1", "N", "AH0", "W", "IH0", "T", "S"],
    "arons": ["AA1", "R", "OW0", "N", "Z"],
    "aronson": ["EH1", "R", "AH0", "N", "S", "AH0", "N"],
    "aronstein": ["EH1", "R", "AH0", "N", "S", "T", "AY2", "N"],
    "arora": ["AA0", "R", "AO1", "R", "AA0"],
    "aros": ["AA1", "R", "OW0", "Z"],
    "arose": ["ER0", "OW1", "Z"],
    "around": ["ER0", "AW1", "N"],
    "arousal": ["ER0", "AW1", "Z", "AH0", "L"],
    "arouse": ["ER0", "AW1", "Z"],
    "aroused": ["ER0", "AW1", "Z", "D"],
    "arouses": ["ER0", "AW1", "Z", "IH0", "Z"],
    "arousing": ["ER0", "AW1", "Z", "IH0", "NG"],
    "arp": ["AA1", "R", "P"],
    "arpa": ["AA1", "R", "P", "AH0"],
    "arpanet": ["AA1", "R", "P", "AH0", "N", "EH2", "T"],
    "arpin": ["AA1", "R", "P", "IH0", "N"],
    "arpino": ["AA0", "R", "P", "IY1", "N", "OW0"],
    "arps": ["AA1", "R", "P", "S"],
    "arquette": ["AA0", "R", "K", "EH1", "T"],
    "arquilla": ["AA2", "R", "K", "W", "IH1", "L", "AH0"],
    "arraign": ["ER0", "EY1", "N"],
    "arraigned": ["ER0", "EY1", "N", "D"],
    "arraignment": ["ER0", "EY1", "N", "M", "AH0", "N", "T"],
    "arraignments": ["ER0", "EY1", "N", "M", "AH0", "N", "T", "S"],
    "arrange": ["ER0", "EY1", "N", "JH"],
    "arranged": ["ER0", "EY1", "N", "JH", "D"],
    "arrangement": ["ER0", "EY1", "N", "JH", "M", "AH0", "N", "T"],
    "arrangements": ["ER0", "EY1", "N", "JH", "M", "AH0", "N", "T", "S"],
    "arranger": ["ER0", "EY1", "N", "JH", "ER0"],
    "arranges": ["ER0", "EY1", "N", "JH", "IH0", "Z"],
    "arranging": ["ER0", "EY1", "N", "JH", "IH0", "NG"],
    "arrant": ["AE1", "R", "AH0", "N", "T"],
    "arrants": ["AE1", "R", "AH0", "N", "T", "S"],
    "arrasmith": ["EH1", "R", "AH0", "S", "M", "IH2", "TH"],
    "array": ["ER0", "EY1"],
    "arrayed": ["ER0", "EY1", "D"],
    "arraying": ["ER0", "EY1", "IH0", "NG"],
    "arrays": ["ER0", "EY1", "Z"],
    "arrearage": ["ER0", "IY1", "R", "IH0", "JH"],
    "arrearages": ["ER0", "IH1", "R", "IH0", "JH", "IH0", "Z"],
    "arrears": ["ER0", "IH1", "R", "Z"],
    "arredondo": ["AA0", "R", "EH0", "D", "OW1", "N", "D", "OW0"],
    "arreguin": ["AA0", "R", "EY0", "G", "W", "IY1", "N"],
    "arrendondo": ["AA0", "R", "EH0", "N", "D", "OW1", "N", "D", "OW0"],
    "arreola": ["AA0", "R", "IY0", "AA1", "L", "AH0"],
    "arrest": ["ER0", "EH1", "S", "T"],
    "arrested": ["ER0", "EH1", "S", "T", "IH0", "D"],
    "arresting": ["ER0", "EH1", "S", "T", "IH0", "NG"],
    "arrests": ["ER0", "EH1", "S", "T", "S"],
    "arrhythmia": ["ER0", "IH1", "DH", "M", "IY0", "AH0"],
    "arrhythmias": ["ER0", "IH1", "DH", "M", "IY0", "AH0", "Z"],
    "arriaga": ["AA2", "R", "IY0", "AA1", "G", "AH0"],
    "arrick": ["AE1", "R", "IH0", "K"],
    "arrieta": ["AA0", "R", "IY1", "T", "AH0"],
    "arrigo": ["AA2", "R", "IY1", "G", "OW0"],
    "arrigoni": ["AA0", "R", "IY0", "G", "OW1", "N", "IY0"],
    "arrington": ["EH1", "R", "IH0", "NG", "T", "AH0", "N"],
    "arriola": ["AA2", "R", "IY0", "OW1", "L", "AH0"],
    "arriortua": ["AA2", "R", "IY0", "AO0", "R", "T", "UW1", "AH0"],
    "arris": ["AE1", "R", "AH0", "S"],
    "arrival": ["ER0", "AY1", "V", "AH0", "L"],
    "arrivals": ["ER0", "AY1", "V", "AH0", "L", "Z"],
    "arrive": ["ER0", "AY1", "V"],
    "arrived": ["ER0", "AY1", "V", "D"],
    "arrives": ["ER0", "AY1", "V", "Z"],
    "arriving": ["ER0", "AY1", "V", "IH0", "NG"],
    "arrogance": ["EH1", "R", "AH0", "G", "AH0", "N", "S"],
    "arrogant": ["EH1", "R", "AH0", "G", "AH0", "N", "T"],
    "arrogantly": ["EH1", "R", "AH0", "G", "AH0", "N", "T", "L", "IY0"],
    "arrogate": ["AE1", "R", "OW0", "G", "EY2", "T"],
    "arrow": ["EH1", "R", "OW0"],
    "arrow's": ["EH1", "R", "OW0", "Z"],
    "arrowhead": ["EH1", "R", "OW0", "HH", "EH2", "D"],
    "arrowheads": ["EH1", "R", "OW0", "HH", "EH2", "D", "Z"],
    "arrowood": ["AE1", "R", "OW0", "W", "UH2", "D"],
    "arrowroot": ["EH1", "R", "OW0", "R", "UW2", "T"],
    "arrows": ["EH1", "R", "OW0", "Z"],
    "arrowsmith": ["EH1", "R", "OW0", "S", "M", "IH2", "TH"],
    "arrowsmith's": ["EH1", "R", "OW0", "S", "M", "IH2", "TH", "S"],
    "arroyo": ["ER0", "OY1", "OW0"],
    "arroyo's": ["ER0", "OY1", "OW0", "Z"],
    "arruda": ["AA0", "R", "UW1", "D", "AH0"],
    "arrupe": ["AE1", "R", "UW2", "P"],
    "arsdale": ["AA1", "R", "Z", "D", "EY2", "L"],
    "arse": ["AA1", "R", "S"],
    "arsehole": ["AA1", "R", "S", "HH", "OW2", "L"],
    "arsenal": ["AA1", "R", "S", "AH0", "N", "AH0", "L"],
    "arsenals": ["AA1", "R", "S", "AH0", "N", "AH0", "L", "Z"],
    "arsenault": ["AA1", "R", "S", "IH0", "N", "OW0"],
    "arseneau": ["AA1", "R", "S", "IH0", "N", "OW0"],
    "arseneault": ["AA1", "R", "S", "IH0", "N", "OW0"],
    "arsenic": ["AA1", "R", "S", "AH0", "N", "IH0", "K"],
    "arsenide": ["AA1", "R", "S", "AH0", "N", "AY2", "D"],
    "arsenio": ["AA2", "R", "S", "IY1", "N", "IY0", "OW0"],
    "arses": ["AA1", "R", "S", "IH0", "Z"],
    "arshia": ["AA1", "R", "SH", "Y", "AH0"],
    "arslanian": ["AA2", "R", "S", "L", "EY1", "N", "IY0", "AH0", "N"],
    "arson": ["AA1", "R", "S", "AH0", "N"],
    "arsonist": ["AA1", "R", "S", "AH0", "N", "IH0", "S", "T"],
    "arsonists": ["AA1", "R", "S", "AH0", "N", "IH0", "S", "T", "S"],
    "arsons": ["AA1", "R", "S", "AH0", "N", "Z"],
    "arsov": ["AA1", "R", "S", "AH0", "V"],
    "art": ["AA1", "R", "T"],
    "art's": ["AA1", "R", "T", "S"],
    "artale": ["AA0", "R", "T", "AA1", "L", "IY0"],
    "artcarve": ["AA1", "R", "T", "K", "AA2", "R", "V"],
    "artcarved": ["AA1", "R", "T", "K", "AA2", "R", "V", "D"],
    "arteaga": ["AA2", "R", "T", "IY1", "G", "AH0"],
    "artemas": ["AA1", "R", "T", "IH0", "M", "AH0", "Z"],
    "artemus": ["AA1", "R", "T", "AH0", "M", "AH0", "S"],
    "arter": ["AA1", "R", "T", "ER0"],
    "arterberry": ["AA1", "R", "T", "ER0", "B", "EH2", "R", "IY0"],
    "arterburn": ["AA1", "R", "T", "ER0", "B", "ER2", "N"],
    "arterial": ["AA0", "R", "T", "IH1", "R", "IY0", "AH0", "L"],
    "arteries": ["AA1", "R", "T", "ER0", "IY0", "Z"],
    "arteriosclerosis": ["AA0", "R", "T", "IH2", "R", "IY0", "OW0", "S", "K", "L", "ER0", "OW1", "S", "AH0", "S"],
    "artery": ["AA1", "R", "T", "ER0", "IY0"],
    "artes": ["AA1", "R", "T", "IY0", "Z"],
    "artesian": ["AA2", "R", "T", "IY1", "ZH", "AH0", "N"],
    "artful": ["AA1", "R", "T", "F", "AH0", "L"],
    "artfully": ["AA1", "R", "T", "F", "AH0", "L", "IY0"],
    "arth": ["AA1", "R", "TH"],
    "arthotec": ["AA1", "R", "TH", "AH0", "T", "EH0", "K"],
    "arthritic": ["AA0", "R", "TH", "R", "IH1", "T", "IH0", "K"],
    "arthritis": ["AA0", "R", "TH", "R", "AY1", "T", "IH0", "S"],
    "arthropod": ["AA1", "R", "TH", "R", "AH0", "P", "AA2", "D"],
    "arthropods": ["AA1", "R", "TH", "R", "AH0", "P", "AA2", "D", "Z"],
    "arthur": ["AA1", "R", "TH", "ER0"],
    "arthur's": ["AA1", "R", "TH", "ER0", "Z"],
    "arthurian": ["AA0", "R", "TH", "UH1", "R", "IY0", "AH0", "N"],
    "arthurs": ["AA1", "R", "TH", "ER0", "Z"],
    "artichoke": ["AA1", "R", "T", "IH0", "CH", "OW2", "K"],
    "artichokes": ["AA1", "R", "T", "IH0", "CH", "OW2", "K", "S"],
    "article": ["AA1", "R", "T", "IH0", "K", "AH0", "L"],
    "article's": ["AA1", "R", "T", "IH0", "K", "AH0", "L", "Z"],
    "articles": ["AA1", "R", "T", "IH0", "K", "AH0", "L", "Z"],
    "articular": ["AA0", "R", "T", "IH1", "K", "Y", "AH0", "L", "ER2"],
    "articulate": ["AA0", "R", "T", "IH1", "K", "Y", "AH0", "L", "AH0", "T"],
    "articulated": ["AA0", "R", "T", "IH1", "K", "Y", "AH0", "L", "EY2", "T", "IH0", "D"],
    "articulates": ["AA0", "R", "T", "IH1", "K", "Y", "AH0", "L", "AH0", "T", "S"],
    "articulating": ["AA0", "R", "T", "IH1", "K", "Y", "AH0", "L", "EY2", "T", "IH0", "NG"],
    "articulation": ["AA2", "R", "T", "IH0", "K", "Y", "AH0", "L", "EY1", "SH", "AH0", "N"],
    "articulatory": ["AA0", "R", "T", "IH1", "K", "Y", "AH0", "L", "AH0", "T", "AO2", "R", "IY0"],
    "artie": ["AA1", "R", "T", "IY0"],
    "artifact": ["AA1", "R", "T", "AH0", "F", "AE2", "K", "T"],
    "artifacts": ["AA1", "R", "T", "AH0", "F", "AE2", "K", "T", "S"],
    "artifice": ["AA1", "R", "T", "AH0", "F", "IH0", "S"],
    "artificial": ["AA2", "R", "T", "AH0", "F", "IH1", "SH", "AH0", "L"],
    "artificially": ["AA2", "R", "T", "AH0", "F", "IH1", "SH", "AH0", "L", "IY0"],
    "artillery": ["AA0", "R", "T", "IH1", "L", "ER0", "IY0"],
    "artino": ["AA0", "R", "T", "IY1", "N", "OW0"],
    "artiodactyl": ["AA2", "R", "T", "IY0", "OW0", "D", "AE1", "K", "T", "AH0", "L"],
    "artiodactyls": ["AA2", "R", "T", "IY0", "OW0", "D", "AE1", "K", "T", "AH0", "L", "Z"],
    "artis": ["AA1", "R", "T", "IH0", "S"],
    "artisan": ["AA1", "R", "T", "AH0", "Z", "AH0", "N"],
    "artisanal": ["AA2", "R", "T", "IH1", "Z", "AH0", "N", "AH0", "L"],
    "artisans": ["AA1", "R", "T", "AH0", "Z", "AH0", "N", "Z"],
    "artist": ["AA1", "R", "T", "IH0", "S", "T"],
    "artist's": ["AA1", "R", "T", "IH0", "S", "T", "S"],
    "artistic": ["AA0", "R", "T", "IH1", "S", "T", "IH0", "K"],
    "artistically": ["AA0", "R", "T", "IH1", "S", "T", "IH0", "K", "L", "IY0"],
    "artistry": ["AA1", "R", "T", "IH0", "S", "T", "R", "IY0"],
    "artists": ["AA1", "R", "T", "IH0", "S", "T", "S"],
    "artists'": ["AA1", "R", "T", "IH0", "S", "T", "S"],
    "artley": ["AA1", "R", "T", "L", "IY0"],
    "artman": ["AA1", "R", "T", "M", "AH0", "N"],
    "artois": ["AA0", "R", "T", "W", "AA1"],
    "arton": ["AA1", "R", "T", "AA2", "N"],
    "artra": ["AA1", "R", "T", "R", "AH0"],
    "artra's": ["AA1", "R", "T", "R", "AH0", "Z"],
    "artrip": ["AA1", "R", "T", "R", "IH0", "P"],
    "arts": ["AA1", "R", "T", "S"],
    "artsy": ["AA1", "R", "T", "S", "IY1"],
    "artur": ["AA1", "R", "T", "UH0", "R"],
    "arturo": ["AA0", "R", "T", "UH1", "R", "OW0"],
    "artus": ["AA1", "R", "T", "AH0", "S"],
    "artwork": ["AA1", "R", "T", "W", "ER2", "K"],
    "artworks": ["AA1", "R", "T", "W", "ER2", "K", "S"],
    "arty": ["AA1", "R", "T", "IY0"],
    "arty's": ["AA1", "R", "T", "IY0", "Z"],
    "artz": ["AA1", "R", "T", "S"],
    "artzt": ["AA1", "R", "T", "S", "T"],
    "aruba": ["ER0", "UW1", "B", "AH0"],
    "arugula": ["AA2", "R", "UW1", "G", "UW0", "L", "AH0"],
    "arum": ["EH1", "R", "AH0", "M"],
    "arunachalam": ["AA0", "R", "UW2", "N", "AH0", "CH", "AA1", "L", "AH0", "M"],
    "arundel": ["EH1", "R", "AH0", "N", "D", "AH0", "L"],
    "arup": ["ER0", "UW1", "P"],
    "arva": ["AA1", "R", "V", "AH0"],
    "arvad": ["AA0", "R", "V", "AE1", "D"],
    "arval": ["AA1", "R", "V", "AH0", "L"],
    "arvanitis": ["AA0", "R", "V", "AH0", "N", "AY1", "T", "IH0", "S"],
    "arvay": ["AA1", "R", "V", "EY0"],
    "arve": ["AA1", "R", "V"],
    "arvel": ["AA0", "R", "V", "EH1", "L"],
    "arvey": ["AA1", "R", "V", "IY0"],
    "arvid": ["AA1", "R", "V", "IH0", "D"],
    "arvida": ["AA0", "R", "V", "IY1", "D", "AH0"],
    "arvida's": ["AA0", "R", "V", "IY1", "D", "AH0", "Z"],
    "arvidson": ["AA1", "R", "V", "IH0", "D", "S", "AH0", "N"],
    "arvin": ["AA1", "R", "V", "IH0", "N"],
    "arvin's": ["AA1", "R", "V", "IH0", "N", "Z"],
    "arvind": ["AA1", "R", "V", "IH0", "N", "D"],
    "arvizu": ["AA0", "R", "V", "IY1", "Z", "UW0"],
    "arwen": ["AA1", "R", "W", "AH0", "N"],
    "arwood": ["AA1", "R", "W", "UH2", "D"],
    "arx": ["AA1", "R", "K", "S"],
    "ary": ["EH1", "R", "IY0"],
    "aryan": ["AA1", "R", "IY0", "AH0", "N"],
    "arzama": ["AA0", "R", "Z", "AA1", "M", "AH0"],
    "arzamas": ["AA0", "R", "Z", "AA1", "M", "AH0", "Z"],
    "arzate": ["AA1", "R", "Z", "EY2", "T"],
    "arzola": ["AA0", "R", "Z", "OW1", "L", "AH0"],
    "arzt": ["AA1", "R", "Z", "T"],
    "as": ["EH1", "Z"],
    "asa": ["AA1", "S", "AH0"],
    "asaf": ["AA0", "S", "AA1", "F"],
    "asahan": ["AE1", "S", "AH0", "HH", "AE0", "N"],
    "asahara": ["AE0", "S", "AH0", "HH", "AE1", "R", "AH0"],
    "asahi": ["AH0", "S", "AA1", "HH", "IY0"],
    "asamera": ["AE2", "S", "AH0", "M", "EH1", "R", "AH0"],
    "asap": ["EY1", "S", "AE2", "P"],
    "asarco": ["AH0", "S", "AA1", "R", "K", "OW0"],
    "asarco's": ["AH0", "S", "AA1", "R", "K", "OW0", "Z"],
    "asaro": ["AA0", "S", "AA1", "R", "OW0"],
    "asat": ["AE1", "Z", "AE0", "T"],
    "asato": ["AA0", "S", "AA1", "T", "OW0"],
    "asay": ["AH0", "S", "EY1"],
    "asbell": ["AE1", "S", "B", "EH0", "L"],
    "asberry": ["AE1", "S", "B", "EH0", "R", "IY0"],
    "asbestec": ["AE2", "S", "B", "EH1", "S", "T", "EH0", "K"],
    "asbestos": ["AE0", "S", "B", "EH1", "S", "T", "AH0", "S"],
    "asbestosis": ["AE2", "S", "B", "EH2", "S", "T", "OW1", "S", "IH0", "S"],
    "asbill": ["AH0", "S", "B", "IH1", "L"],
    "asbridge": ["AH0", "S", "B", "R", "IH1", "JH"],
    "asbury": ["AE1", "Z", "B", "EH2", "R", "IY0"],
    "asby": ["AE1", "S", "B", "IY0"],
    "ascap": ["AE1", "S", "K", "AE2", "P"],
    "ascencio": ["AA0", "S", "CH", "EH1", "N", "CH", "IY0", "OW0"],
    "ascend": ["AH0", "S", "EH1", "N", "D"],
    "ascendance": ["AH0", "S", "EH1", "N", "D", "AH0", "N", "S"],
    "ascendancy": ["AH0", "S", "EH1", "N", "D", "AH0", "N", "S", "IY0"],
    "ascendant": ["AH0", "S", "EH1", "N", "D", "AH0", "N", "T"],
    "ascended": ["AH0", "S", "EH1", "N", "D", "IH0", "D"],
    "ascendency": ["AH0", "S", "EH1", "N", "D", "AH0", "N", "S", "IY0"],
    "ascending": ["AH0", "S", "EH1", "N", "D", "IH0", "NG"],
    "ascends": ["AH0", "S", "EH1", "N", "D", "Z"],
    "ascension": ["AH0", "S", "EH1", "N", "SH", "AH0", "N"],
    "ascent": ["AH0", "S", "EH1", "N", "T"],
    "ascertain": ["AE2", "S", "ER0", "T", "EY1", "N"],
    "ascertained": ["AE2", "S", "ER0", "T", "EY1", "N", "D"],
    "ascertaining": ["AE2", "S", "ER0", "T", "EY1", "N", "IH0", "NG"],
    "ascetic": ["AH0", "S", "EH1", "T", "IH0", "K"],
    "asch": ["AE1", "SH"],
    "asche": ["AE1", "SH"],
    "aschenbach": ["AE1", "SH", "IH0", "N", "B", "AA0", "K"],
    "aschenbrenner": ["AE1", "SH", "IH0", "N", "B", "R", "IH0", "N", "ER0"],
    "ascher": ["AE1", "SH", "ER0"],
    "aschoff": ["AE1", "S", "K", "HH", "AO0", "F"],
    "ascii": ["AE1", "S", "K", "IY0"],
    "asclad": ["AE1", "S", "K", "L", "AE0", "D"],
    "ascorbic": ["AH0", "S", "K", "AO1", "R", "B", "IH0", "K"],
    "ascot": ["AE1", "S", "K", "AA2", "T"],
    "ascott": ["AH0", "S", "K", "AA1", "T"],
    "ascribe": ["AH0", "S", "K", "R", "AY1", "B"],
    "ascribed": ["AH0", "S", "K", "R", "AY1", "B", "D"],
    "ascribes": ["AH0", "S", "K", "R", "AY1", "B", "Z"],
    "asda": ["AE1", "S", "D", "AH0"],
    "asea": ["EY1", "EH1", "S", "IY1", "EY1"],
    "asean": ["AE2", "Z", "EY1", "AH0", "N"],
    "aselma": ["AH0", "S", "EH1", "L", "M", "AH0"],
    "aseltine": ["AA0", "S", "EH0", "L", "T", "IY1", "N", "IY0"],
    "asencio": ["AH0", "S", "EH1", "N", "S", "IY0", "OW0"],
    "aseritis": ["AH0", "S", "EH1", "R", "IH0", "T", "IH0", "S"],
    "asexual": ["EY0", "S", "EH1", "K", "S", "Y", "UW0", "AH0", "L"],
    "asgard": ["AA1", "S", "G", "AA2", "R", "D"],
    "ash": ["AE1", "SH"],
    "asha": ["AA1", "SH", "AH0"],
    "ashaji": ["AH0", "SH", "AA1", "JH", "IY0"],
    "ashaji's": ["AH0", "SH", "AA1", "JH", "IY0", "Z"],
    "ashame": ["AH0", "SH", "EY1", "M"],
    "ashamed": ["AH0", "SH", "EY1", "M", "D"],
    "asharah": ["AE1", "SH", "AA0", "R", "AA2"],
    "ashare": ["AE1", "SH", "EH2", "R"],
    "ashbaugh": ["AE1", "SH", "B", "AO2"],
    "ashbrook": ["AE1", "SH", "B", "R", "UH2", "K"],
    "ashburn": ["AE1", "SH", "B", "ER0", "N"],
    "ashbury": ["AE1", "SH", "B", "EH0", "R", "IY0"],
    "ashby": ["AE1", "SH", "B", "IY0"],
    "ashcraft": ["AE1", "SH", "K", "R", "AE2", "F", "T"],
    "ashcreek": ["AE2", "SH", "K", "R", "IY1", "K"],
    "ashcroft": ["AE1", "SH", "K", "R", "AO2", "F", "T"],
    "ashdown": ["AE1", "SH", "D", "AW2", "N"],
    "ashe": ["AE1", "SH"],
    "ashe's": ["AE1", "SH", "AH0", "Z"],
    "asheboro": ["AE1", "SH", "B", "AO0", "R", "OW0"],
    "ashen": ["AE1", "SH", "AH0", "N"],
    "ashenberg": ["AE1", "SH", "AH0", "N", "B", "ER0", "G"],
    "ashenfelter": ["AE1", "SH", "AH0", "N", "F", "EH2", "L", "T", "ER0"],
    "asher": ["AE1", "SH", "ER0"],
    "ashes": ["AE1", "SH", "IH0", "Z"],
    "asheville": ["AE1", "SH", "V", "IH2", "L"],
    "ashey": ["AE1", "SH", "IY0"],
    "ashford": ["AE1", "SH", "F", "ER0", "D"],
    "ashis": ["AH0", "SH", "IY1", "Z"],
    "ashish": ["AH0", "SH", "IY1", "SH"],
    "ashkenazi": ["AE2", "SH", "K", "AH0", "N", "AA1", "Z", "IY0"],
    "ashkenazis": ["AE2", "SH", "K", "AH0", "N", "AA1", "Z", "IY0", "Z"],
    "ashland": ["AE1", "SH", "L", "AH0", "N", "D"],
    "ashland's": ["AE1", "SH", "L", "AH0", "N", "D", "Z"],
    "ashley": ["AE1", "SH", "L", "IY0"],
    "ashley's": ["AE1", "SH", "L", "IY0", "Z"],
    "ashlin": ["AE1", "SH", "L", "IH0", "N"],
    "ashline": ["AE1", "SH", "L", "AY2", "N"],
    "ashlock": ["AE1", "SH", "L", "AA2", "K"],
    "ashman": ["AE1", "SH", "M", "AH0", "N"],
    "ashmead": ["AE1", "SH", "M", "IY2", "D"],
    "ashmore": ["AE1", "SH", "M", "AO0", "R"],
    "ashok": ["AE1", "SH", "AA0", "K"],
    "ashore": ["AH0", "SH", "AO1", "R"],
    "ashram": ["AE1", "SH", "R", "AA0", "M"],
    "ashrawi": ["AE0", "SH", "R", "AA1", "W", "IY0"],
    "ashtec": ["AE1", "SH", "T", "EH0", "K"],
    "ashtec's": ["AE1", "SH", "T", "EH0", "K", "S"],
    "ashton": ["AE1", "SH", "T", "AH0", "N"],
    "ashton's": ["AE1", "SH", "T", "AH0", "N", "Z"],
    "ashtray": ["AE1", "SH", "T", "R", "EY2"],
    "ashtrays": ["AE1", "SH", "T", "R", "EY2", "Z"],
    "ashur": ["AE1", "SH", "ER0"],
    "ashurst": ["AE1", "SH", "ER0", "S", "T"],
    "ashville": ["AE1", "SH", "V", "IH2", "L"],
    "ashwell": ["AE1", "SH", "W", "EH2", "L"],
    "ashwood": ["AE1", "SH", "W", "UH2", "D"],
    "ashworth": ["AE1", "SH", "W", "ER2", "TH"],
    "ashy": ["AE1", "SH", "IY0"],
    "asia": ["EY1", "ZH", "AH0"],
    "asia's": ["EY1", "ZH", "AH0", "Z"],
    "asiain": ["EY1", "Z", "IY0", "EY2", "N"],
    "asiamerica": ["EY2", "S", "IY0", "AH0", "M", "EH1", "R", "IH0", "K", "AH0"],
    "asian": ["EY1", "ZH", "AH0", "N"],
    "asians": ["EY1", "ZH", "AH0", "N", "Z"],
    "asiatic": ["EY2", "ZH", "IY0", "AE1", "T", "IH0", "K"],
    "asiaweek": ["EY1", "ZH", "AH0", "W", "IY2", "K"],
    "asic": ["AE1", "Z", "IH0", "K"],
    "asics": ["AE1", "Z", "IH0", "K", "S"],
    "aside": ["AH0", "S", "AY1", "D"],
    "asides": ["AH0", "S", "AY1", "D", "Z"],
    "asiel": ["AE1", "Z", "IY0", "AH0", "L"],
    "asimov": ["AE1", "Z", "IH0", "M", "AA0", "V"],
    "asimov's": ["AE1", "Z", "IH0", "M", "AA0", "V", "Z"],
    "asimow": ["AE1", "S", "IH0", "M", "OW0"],
    "asinine": ["AE1", "S", "AH0", "N", "AY2", "N"],
    "ask": ["AE1", "S", "K"],
    "aska": ["AE1", "S", "K", "AH0"],
    "askance": ["AH0", "S", "K", "AE1", "N", "S"],
    "asked": ["AE1", "S", "T"],
    "asker": ["AE1", "S", "K", "ER0"],
    "asker's": ["AE1", "S", "K", "ER0", "Z"],
    "askers": ["AE1", "S", "K", "ER0", "Z"],
    "askers'": ["AE1", "S", "K", "ER0", "Z"],
    "askers's": ["AE1", "S", "K", "ER0", "Z", "IH0", "Z"],
    "askew": ["AH0", "S", "K", "Y", "UW1"],
    "askey": ["AH0", "S", "K", "IY1"],
    "askin": ["AH0", "S", "K", "IH1", "N"],
    "askin's": ["AE1", "S", "K", "IH2", "N", "Z"],
    "asking": ["AE1", "S", "K", "IH0", "NG"],
    "askington": ["AE1", "S", "K", "IH0", "NG", "T", "AH0", "N"],
    "askins": ["AH0", "S", "K", "IH1", "N", "Z"],
    "asko": ["AE1", "S", "K", "OW0"],
    "askoldov": ["AH0", "S", "K", "OW1", "L", "D", "AA0", "V"],
    "askoldov's": ["AH0", "S", "K", "OW1", "L", "D", "AA0", "V", "Z"],
    "askren": ["AE1", "S", "K", "ER0", "AH0", "N"],
    "asks": ["AE1", "S", "K", "S"],
    "aslan": ["AH0", "S", "L", "AH1", "N"],
    "aslanian": ["AH0", "S", "L", "EY1", "N", "IY0", "AH0", "N"],
    "asleep": ["AH0", "S", "L", "IY1", "P"],
    "asleson": ["AE1", "S", "IH0", "L", "S", "AH0", "N"],
    "aslin": ["AH0", "S", "L", "IH1", "N"],
    "asman": ["AE1", "S", "M", "AH0", "N"],
    "asmara": ["AE2", "Z", "M", "AA1", "R", "AH0"],
    "asmaras": ["AE2", "Z", "M", "AA1", "R", "AH0", "Z"],
    "asmodeus": ["AE2", "Z", "M", "AH0", "D", "EY1", "AH0", "S"],
    "asmus": ["AH0", "Z", "M", "UW1", "S"],
    "asmussen": ["AH0", "Z", "M", "AH1", "S", "AH0", "N"],
    "asner": ["AE1", "S", "N", "ER0"],
    "asp": ["AE1", "S", "P"],
    "asparagus": ["AH0", "S", "P", "EH1", "R", "AH0", "G", "AH0", "S"],
    "aspartame": ["AE1", "S", "P", "ER0", "T", "EY2", "M"],
    "aspect": ["AE1", "S", "P", "EH2", "K", "T"],
    "aspects": ["AE1", "S", "P", "EH2", "K", "T", "S"],
    "aspen": ["AE1", "S", "P", "AH0", "N"],
    "aspen's": ["AE1", "S", "P", "AH0", "N", "Z"],
    "aspens": ["AE1", "S", "P", "AH0", "N", "Z"],
    "asper": ["AE1", "S", "P", "ER0"],
    "asperity": ["AH0", "S", "P", "EH1", "R", "IH0", "T", "IY0"],
    "aspersion": ["AH0", "S", "P", "ER1", "ZH", "AH0", "N"],
    "aspersions": ["AH0", "S", "P", "ER1", "ZH", "AH0", "N", "Z"],
    "asphalt": ["AE1", "S", "F", "AO2", "L", "T"],
    "asphyxiate": ["AE0", "S", "F", "IH1", "K", "S", "IY0", "EY2", "T"],
    "asphyxiated": ["AE0", "S", "F", "IH1", "K", "S", "IY0", "EY2", "T", "IH0", "D"],
    "asphyxiates": ["AE0", "S", "F", "IH1", "K", "S", "IY0", "EY2", "T", "S"],
    "asphyxiating": ["AE0", "S", "F", "IH1", "K", "S", "IY0", "EY2", "T", "IH0", "NG"],
    "aspin": ["AE1", "S", "P", "IH0", "N"],
    "aspin's": ["AE1", "S", "P", "IH0", "N", "Z"],
    "aspinall": ["AE1", "S", "P", "IH0", "N", "AO0", "L"],
    "aspinwall": ["AE1", "S", "P", "IH0", "N", "W", "AO0", "L"],
    "aspirant": ["AH0", "S", "P", "AY1", "R", "AH0", "N", "T"],
    "aspirants": ["AH0", "S", "P", "AY1", "R", "AH0", "N", "S"],
    "aspirate": ["AE1", "S", "P", "ER0", "EY2", "T"],
    "aspirated": ["AE1", "S", "P", "ER0", "EY2", "T", "IH0", "D"],
    "aspirates": ["AE1", "S", "P", "ER0", "EY2", "T", "S"],
    "aspiration": ["AE2", "S", "P", "ER0", "EY1", "SH", "AH0", "N"],
    "aspirations": ["AE2", "S", "P", "ER0", "EY1", "SH", "AH0", "N", "Z"],
    "aspire": ["AH0", "S", "P", "AY1", "R"],
    "aspired": ["AH0", "S", "P", "AY1", "R", "D"],
    "aspires": ["AH0", "S", "P", "AY1", "ER0", "Z"],
    "aspirin": ["AE1", "S", "P", "R", "IH0", "N"],
    "aspirin's": ["AE1", "S", "P", "R", "AH0", "N", "Z"],
    "aspiring": ["AH0", "S", "P", "AY1", "R", "IH0", "NG"],
    "asplund": ["AE1", "S", "P", "L", "AH0", "N", "D"],
    "aspnes": ["AE1", "S", "P", "N", "EH0", "Z"],
    "asquith": ["AE1", "S", "K", "W", "IH0", "TH"],
    "ass": ["AE1", "S"],
    "assad": ["AH0", "S", "AA1", "D"],
    "assad's": ["AH0", "S", "AA1", "D", "Z"],
    "assaf": ["AH0", "S", "AE1", "F"],
    "assail": ["AH0", "S", "EY1", "L"],
    "assailant": ["AH0", "S", "EY1", "L", "AH0", "N", "T"],
    "assailant's": ["AH0", "S", "EY1", "L", "AH0", "N", "T", "S"],
    "assailants": ["AH0", "S", "EY1", "L", "AH0", "N", "T", "S"],
    "assailed": ["AH0", "S", "EY1", "L", "D"],
    "assailing": ["AH0", "S", "EY1", "L", "IH0", "NG"],
    "assails": ["AH0", "S", "EY1", "L", "Z"],
    "assam": ["AA2", "S", "AA1", "M"],
    "assante": ["AA0", "S", "AA1", "N", "T", "IY0"],
    "assassin": ["AH0", "S", "AE1", "S", "AH0", "N"],
    "assassin's": ["AH0", "S", "AE1", "S", "AH0", "N", "Z"],
    "assassinate": ["AH0", "S", "AE1", "S", "AH0", "N", "EY2", "T"],
    "assassinated": ["AH0", "S", "AE1", "S", "AH0", "N", "EY2", "T", "IH0", "D"],
    "assassinating": ["AH0", "S", "AE1", "S", "AH0", "N", "EY2", "T", "IH0", "NG"],
    "assassination": ["AH0", "S", "AE2", "S", "AH0", "N", "EY1", "SH", "AH0", "N"],
    "assassinations": ["AH0", "S", "AE2", "S", "AH0", "N", "EY1", "SH", "AH0", "N", "Z"],
    "assassins": ["AH0", "S", "AE1", "S", "AH0", "N", "Z"],
    "assault": ["AH0", "S", "AO1", "L", "T"],
    "assaulted": ["AH0", "S", "AO1", "L", "T", "IH0", "D"],
    "assaulting": ["AH0", "S", "AO1", "L", "T", "IH0", "NG"],
    "assaultive": ["AH0", "S", "AO1", "L", "T", "IH0", "V"],
    "assaults": ["AH0", "S", "AO1", "L", "T", "S"],
    "assay": ["AE1", "S", "IY0"],
    "assayer": ["AE0", "S", "EY1", "ER0"],
    "assays": ["AE1", "S", "EY2", "Z"],
    "assed": ["AE1", "S", "T"],
    "asselin": ["AE1", "S", "IH0", "L", "IH0", "N"],
    "asselstine": ["AE1", "S", "AH0", "L", "S", "T", "AY2", "N"],
    "assemblage": ["AH0", "S", "EH1", "M", "B", "L", "IH0", "JH"],
    "assemble": ["AH0", "S", "EH1", "M", "B", "AH0", "L"],
    "assembled": ["AH0", "S", "EH1", "M", "B", "AH0", "L", "D"],
    "assembler": ["AH0", "S", "EH1", "M", "B", "L", "ER0"],
    "assemblers": ["AH0", "S", "EH1", "M", "B", "L", "ER0", "Z"],
    "assembles": ["AH0", "S", "EH1", "M", "B", "AH0", "L", "Z"],
    "assemblies": ["AH0", "S", "EH1", "M", "B", "L", "IY0", "Z"],
    "assembling": ["AH0", "S", "EH1", "M", "B", "L", "IH0", "NG"],
    "assembly": ["AH0", "S", "EH1", "M", "B", "L", "IY0"],
    "assembly's": ["AH0", "S", "EH1", "M", "B", "L", "IY0", "Z"],
    "assemblyman": ["AH0", "S", "EH1", "M", "B", "L", "IY0", "M", "AH0", "N"],
    "assemblymen": ["AH0", "S", "EH1", "M", "B", "L", "IY0", "M", "IH0", "N"],
    "assemblywoman": ["AH0", "S", "EH1", "M", "B", "L", "IY0", "W", "UH2", "M", "AH0", "N"],
    "assent": ["AH0", "S", "EH1", "N", "T"],
    "assert": ["AH0", "S", "ER1", "T"],
    "asserted": ["AH0", "S", "ER1", "T", "IH0", "D"],
    "assertedly": ["AH0", "S", "ER1", "T", "IH0", "D", "L", "IY0"],
    "asserting": ["AH0", "S", "ER1", "T", "IH0", "NG"],
    "assertion": ["AH0", "S", "ER1", "SH", "AH0", "N"],
    "assertions": ["AH0", "S", "ER1", "SH", "AH0", "N", "Z"],
    "assertive": ["AH0", "S", "ER1", "T", "IH0", "V"],
    "assertively": ["AH0", "S", "ER1", "T", "IH0", "V", "L", "IY0"],
    "assertiveness": ["AH0", "S", "ER1", "T", "IH0", "V", "N", "AH0", "S"],
    "asserts": ["AH0", "S", "ER1", "T", "S"],
    "asses": ["AE1", "S", "AH0", "Z"],
    "assess": ["AH0", "S", "EH1", "S"],
    "assessed": ["AH0", "S", "EH1", "S", "T"],
    "assesses": ["AH0", "S", "EH1", "S", "IH0", "Z"],
    "assessing": ["AH0", "S", "EH1", "S", "IH0", "NG"],
    "assessment": ["AH0", "S", "EH1", "S", "M", "AH0", "N", "T"],
    "assessments": ["AH0", "S", "EH1", "S", "M", "AH0", "N", "T", "S"],
    "assessor": ["AH0", "S", "EH1", "S", "ER0"],
    "assessors": ["AH0", "S", "EH1", "S", "ER0", "Z"],
    "asset": ["AE1", "S", "EH2", "T"],
    "assets": ["AE1", "S", "EH2", "T", "S"],
    "assets'": ["AE1", "S", "EH0", "T", "S"],
    "asshole": ["AE1", "S", "HH", "OW0", "L"],
    "assholes": ["AE1", "S", "HH", "OW0", "L", "Z"],
    "assicurazioni": ["AH0", "S", "IY2", "K", "ER0", "AE2", "Z", "IY0", "OW1", "N", "IY0"],
    "assiduous": ["AH0", "S", "IH1", "D", "W", "AH0", "S"],
    "assiduously": ["AH0", "S", "IH1", "D", "W", "AH0", "S", "L", "IY0"],
    "assign": ["AH0", "S", "AY1", "N"],
    "assigned": ["AH0", "S", "AY1", "N", "D"],
    "assigning": ["AH0", "S", "AY1", "N", "IH0", "NG"],
    "assignment": ["AH0", "S", "AY1", "N", "M", "AH0", "N", "T"],
    "assignment's": ["AH0", "S", "AY1", "N", "M", "AH0", "N", "T", "S"],
    "assignments": ["AH0", "S", "AY1", "N", "M", "AH0", "N", "T", "S"],
    "assigns": ["AH0", "S", "AY1", "N", "Z"],
    "assimilate": ["AH0", "S", "IH1", "M", "AH0", "L", "EY2", "T"],
    "assimilated": ["AH0", "S", "IH1", "M", "AH0", "L", "EY2", "T", "IH0", "D"],
    "assimilating": ["AH0", "S", "IH1", "M", "AH0", "L", "EY2", "T", "IH0", "NG"],
    "assimilation": ["AH0", "S", "IH2", "M", "AH0", "L", "EY1", "SH", "AH0", "N"],
    "assira": ["AH0", "S", "IY1", "R", "AH0"],
    "assisi": ["AH0", "S", "IY1", "S", "IY0"],
    "assisi's": ["AH0", "S", "IY1", "S", "IY0", "Z"],
    "assist": ["AH0", "S", "IH1", "S", "T"],
    "assistance": ["AH0", "S", "IH1", "S", "T", "AH0", "N", "S"],
    "assistant": ["AH0", "S", "IH1", "S", "T", "AH0", "N", "T"],
    "assistants": ["AH0", "S", "IH1", "S", "T", "AH0", "N", "T", "S"],
    "assisted": ["AH0", "S", "IH1", "S", "T", "IH0", "D"],
    "assisting": ["AH0", "S", "IH1", "S", "T", "IH0", "NG"],
    "assists": ["AH0", "S", "IH1", "S", "T", "S"],
    "assocation": ["AE2", "S", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "associate": ["AH0", "S", "OW1", "SH", "IY0", "EY2", "T"],
    "associate's": ["AH0", "S", "OW1", "SH", "IY0", "AH0", "T", "S"],
    "associated": ["AH0", "S", "OW1", "SH", "IY0", "EY2", "T", "IH0", "D"],
    "associates": ["AH0", "S", "OW1", "SH", "IY0", "EY2", "T", "S"],
    "associates'": ["AH0", "S", "OW1", "S", "IY0", "AH0", "T", "S"],
    "associating": ["AH0", "S", "OW1", "S", "IY0", "EY2", "T", "IH0", "NG"],
    "association": ["AH0", "S", "OW2", "SH", "IY0", "EY1", "SH", "AH0", "N"],
    "association's": ["AH0", "S", "OW2", "SH", "IY0", "EY1", "SH", "AH0", "N", "Z"],
    "associations": ["AH0", "S", "OW2", "SH", "IY0", "EY1", "SH", "AH0", "N", "Z"],
    "associative": ["AH0", "S", "OW1", "SH", "AH0", "T", "IH2", "V"],
    "associes": ["AE1", "S", "AH0", "S", "IY0", "Z"],
    "assort": ["AH0", "S", "AO1", "R", "T"],
    "assorted": ["AH0", "S", "AO1", "R", "T", "IH0", "D"],
    "assortment": ["AH0", "S", "AO1", "R", "T", "M", "AH0", "N", "T"],
    "assuage": ["AH0", "S", "W", "EY1", "JH"],
    "assuaged": ["AH0", "S", "W", "EY1", "JH", "D"],
    "assubel": ["AE1", "S", "AH0", "B", "EH2", "L"],
    "assume": ["AH0", "S", "UW1", "M"],
    "assumed": ["AH0", "S", "UW1", "M", "D"],
    "assumes": ["AH0", "S", "UW1", "M", "Z"],
    "assuming": ["AH0", "S", "UW1", "M", "IH0", "NG"],
    "assumption": ["AH0", "S", "AH1", "M", "P", "SH", "AH0", "N"],
    "assumptions": ["AH0", "S", "AH1", "M", "P", "SH", "AH0", "N", "Z"],
    "assurance": ["AH0", "SH", "UH1", "R", "AH0", "N", "S"],
    "assurances": ["AH0", "SH", "UH1", "R", "AH0", "N", "T", "S", "IH0", "Z"],
    "assuras": ["AH0", "SH", "UH1", "R", "AH0", "S"],
    "assure": ["AH0", "SH", "UH1", "R"],
    "assured": ["AH0", "SH", "UH1", "R", "D"],
    "assuredly": ["AH0", "SH", "UH1", "R", "AH0", "D", "L", "IY0"],
    "assures": ["AH0", "SH", "UH1", "R", "Z"],
    "assuring": ["AH0", "SH", "UH1", "R", "IH0", "NG"],
    "assyria": ["AH0", "S", "IH1", "R", "IY0", "AH0"],
    "assyrian": ["AH0", "S", "IH1", "R", "IY0", "AH0", "N"],
    "assyrians": ["AH0", "S", "IH1", "R", "IY0", "AH0", "N", "Z"],
    "ast": ["AE1", "S", "T"],
    "asta": ["AA1", "S", "T", "AH0"],
    "astaire": ["AH0", "S", "T", "EH1", "R"],
    "aster": ["AE1", "S", "T", "ER0"],
    "asterisk": ["AE1", "S", "T", "ER0", "IH0", "S", "K"],
    "asteroid": ["AE1", "S", "T", "ER0", "OY2", "D"],
    "asteroid's": ["AE1", "S", "T", "ER0", "OY2", "D", "Z"],
    "asteroids": ["AE1", "S", "T", "ER0", "OY2", "D", "Z"],
    "asters": ["AE1", "S", "T", "ER0", "Z"],
    "asthma": ["AE1", "Z", "M", "AH0"],
    "asthmatic": ["AE0", "Z", "M", "AE1", "T", "IH0", "K"],
    "asthmatics": ["EH0", "S", "TH", "M", "EH1", "T", "IH0", "K", "S"],
    "astigmatism": ["AH0", "S", "T", "IH1", "G", "M", "AH0", "T", "IH2", "Z", "AH0", "M"],
    "astilbe": ["AH0", "S", "T", "IH1", "B", "IY2"],
    "astin": ["AH0", "S", "T", "IH1", "N"],
    "astle": ["AE1", "S", "AH0", "L"],
    "astley": ["AE1", "S", "T", "L", "IY0"],
    "aston": ["AE1", "S", "T", "AH0", "N"],
    "astonish": ["AH0", "S", "T", "AA1", "N", "IH0", "SH"],
    "astonished": ["AH0", "S", "T", "AA1", "N", "IH0", "SH", "T"],
    "astonishing": ["AH0", "S", "T", "AA1", "N", "IH0", "SH", "IH0", "NG"],
    "astonishingly": ["AH0", "S", "T", "AA1", "N", "IH0", "SH", "IH0", "NG", "L", "IY0"],
    "astonishment": ["AH0", "S", "T", "AA1", "N", "IH0", "SH", "M", "AH0", "N", "T"],
    "astor": ["AE1", "S", "T", "ER0"],
    "astor's": ["AE1", "S", "T", "ER0", "Z"],
    "astore": ["AE0", "S", "T", "AO1", "R", "IY0"],
    "astorga": ["AA0", "S", "T", "AO1", "R", "G", "AH0"],
    "astoria": ["AE2", "S", "T", "AO1", "R", "IY0", "AH0"],
    "astorino": ["AA0", "S", "T", "AO0", "R", "IY1", "N", "OW0"],
    "astound": ["AH0", "S", "T", "AW1", "N", "D"],
    "astounded": ["AH0", "S", "T", "AW1", "N", "D", "IH0", "D"],
    "astounding": ["AH0", "S", "T", "AW1", "N", "D", "IH0", "NG"],
    "astoundingly": ["AH0", "S", "T", "AW1", "N", "D", "IH0", "NG", "L", "IY0"],
    "astounds": ["AH0", "S", "T", "AW1", "N", "D", "Z"],
    "astra": ["AE1", "S", "T", "R", "AH0"],
    "astra's": ["AE1", "S", "T", "R", "AH0", "Z"],
    "astraddle": ["AH0", "S", "T", "R", "AE1", "D", "AH0", "L"],
    "astrakhan": ["AE1", "S", "T", "R", "AH0", "K", "AA0", "N"],
    "astral": ["AE1", "S", "T", "R", "AH0", "L"],
    "astray": ["AH0", "S", "T", "R", "EY1"],
    "astred": ["AE1", "S", "T", "ER0", "D"],
    "astrid": ["AE1", "S", "T", "R", "IH0", "D"],
    "astride": ["AH0", "S", "T", "R", "AY1", "D"],
    "astringent": ["AH0", "S", "T", "R", "IH1", "N", "JH", "AH0", "N", "T"],
    "astringents": ["AH0", "S", "T", "R", "IH1", "N", "JH", "AH0", "N", "T", "S"],
    "astro": ["AE1", "S", "T", "R", "OW0"],
    "astrodome": ["AE1", "S", "T", "R", "AH0", "D", "OW2", "M"],
    "astrogeology": ["AE2", "S", "T", "R", "AH0", "JH", "IY2", "AA1", "L", "AH0", "JH", "IY0"],
    "astrologer": ["AH0", "S", "T", "R", "AA1", "L", "AH0", "JH", "ER0"],
    "astrologers": ["AH0", "S", "T", "R", "AA1", "L", "AH0", "JH", "ER0", "Z"],
    "astrological": ["AE2", "S", "T", "R", "AH0", "L", "AA1", "JH", "IH0", "K", "AH0", "L"],
    "astrology": ["AH0", "S", "T", "R", "AA1", "L", "AH0", "JH", "IY0"],
    "astronaut": ["AE1", "S", "T", "R", "AH0", "N", "AA2", "T"],
    "astronaut's": ["AE1", "S", "T", "R", "AH0", "N", "AA2", "T", "S"],
    "astronautic": ["AE2", "S", "T", "R", "AH0", "N", "AA1", "T", "IH0", "K"],
    "astronautical": ["AE2", "S", "T", "R", "AH0", "N", "AA1", "T", "IH0", "K", "AH0", "L"],
    "astronautics": ["AE2", "S", "T", "R", "AH0", "N", "AA1", "T", "IH0", "K", "S"],
    "astronauts": ["AE1", "S", "T", "R", "AH0", "N", "AO2", "T", "S"],
    "astronauts'": ["AE1", "S", "T", "R", "AH0", "N", "AO2", "T", "S"],
    "astronomer": ["AH0", "S", "T", "R", "AA1", "N", "AH0", "M", "ER0"],
    "astronomers": ["AH0", "S", "T", "R", "AA1", "N", "AH0", "M", "ER0", "Z"],
    "astronomical": ["AE2", "S", "T", "R", "AH0", "N", "AA1", "M", "IH0", "K", "AH0", "L"],
    "astronomically": ["AE2", "S", "T", "R", "AH0", "N", "AA1", "M", "IH0", "K", "L", "IY0"],
    "astronomy": ["AH0", "S", "T", "R", "AA1", "N", "AH0", "M", "IY0"],
    "astrophotography": ["AE2", "S", "T", "R", "OW0", "F", "AH0", "T", "AA1", "G", "R", "AH0", "F", "IY0"],
    "astrophysicist": ["AE2", "S", "T", "R", "OW0", "F", "IH1", "S", "IH0", "S", "IH0", "S", "T"],
    "astrophysics": ["AE2", "S", "T", "R", "OW0", "F", "IH1", "Z", "IH0", "K", "S"],
    "astros": ["AE1", "S", "T", "R", "OW0", "S"],
    "astrotech": ["AE1", "S", "T", "R", "OW0", "T", "EH2", "K"],
    "astroturf": ["AE1", "S", "T", "R", "OW0", "T", "ER2", "F"],
    "astute": ["AH0", "S", "T", "UW1", "T"],
    "astutely": ["AH0", "S", "T", "UW1", "T", "L", "IY0"],
    "astuteness": ["AH0", "S", "T", "UW1", "T", "N", "AH0", "S"],
    "asuncion": ["AH0", "S", "AH1", "N", "SH", "AH0", "N"],
    "asunder": ["AH0", "S", "AH1", "N", "D", "ER0"],
    "asus": ["EY1", "S", "AH0", "S"],
    "aswin": ["AH0", "S", "W", "IH1", "N"],
    "asylum": ["AH0", "S", "AY1", "L", "AH0", "M"],
    "asymmetric": ["EY2", "S", "AH0", "M", "EH1", "T", "R", "IH0", "K"],
    "asymmetrical": ["EY2", "S", "AH0", "M", "EH1", "T", "R", "IH0", "K", "AH0", "L"],
    "asymmetries": ["EY2", "S", "IH1", "M", "AH0", "T", "R", "IY0", "Z"],
    "asymmetry": ["EY2", "S", "IH1", "M", "AH0", "T", "R", "IY0"],
    "asymptomatic": ["EY2", "S", "IH2", "M", "P", "T", "AH0", "M", "AE1", "T", "IH0", "K"],
    "asymptote": ["AE1", "S", "IH0", "M", "P", "T", "OW2", "T"],
    "asymptotes": ["AE1", "S", "IH0", "M", "P", "T", "OW2", "T", "S"],
    "asymptotic": ["AE1", "S", "IH0", "M", "P", "T", "AO2", "T", "IH0", "K"],
    "asynchronous": ["EY1", "S", "IH1", "NG", "K", "R", "AH0", "N", "AH0", "S"],
    "at": ["AE1", "T"],
    "at-bat": ["AE1", "T", "B", "AE1", "T"],
    "at-bats": ["AE1", "T", "B", "AE1", "T", "S"],
    "ata": ["AA1", "T", "AH0"],
    "atacama": ["AA1", "T", "AA0", "K", "AA2", "M", "AA0"],
    "atalanta": ["AE2", "T", "AH0", "L", "AE1", "N", "T", "AH0"],
    "atalaya": ["AA0", "T", "AA0", "L", "EY1", "AH0"],
    "atalia": ["AA0", "T", "AA1", "L", "IY0", "AH0"],
    "atalie": ["AE1", "T", "AH0", "L", "IY0"],
    "atamian": ["AH0", "T", "EY1", "M", "IY0", "AH0", "N"],
    "atari": ["AH0", "T", "AA1", "R", "IY0"],
    "atari's": ["AH0", "T", "AA1", "R", "IY0", "Z"],
    "ataturk": ["AE1", "T", "AH0", "T", "ER2", "K"],
    "ataturk's": ["AE1", "T", "AH0", "T", "ER2", "K", "S"],
    "atavism": ["AE1", "T", "AH0", "V", "IH0", "Z", "AH0", "M"],
    "atavistic": ["AE1", "T", "AH0", "V", "IH0", "S", "T", "IH0", "K"],
    "ataxia": ["EY1", "T", "AE1", "K", "S", "IY0", "AH0"],
    "ataxia's": ["EY1", "T", "AE1", "K", "S", "IY0", "AH0", "Z"],
    "atcheson": ["AE1", "CH", "IH0", "S", "AH0", "N"],
    "atchinson": ["AE1", "CH", "IH0", "N", "S", "AH0", "N"],
    "atchison": ["AE1", "CH", "IH0", "S", "AH0", "N"],
    "atchley": ["AE1", "CH", "L", "IY0"],
    "atco": ["AE1", "T", "K", "OW0"],
    "atcor": ["AE1", "T", "K", "AO0", "R"],
    "ate": ["EY1", "T"],
    "atek": ["EY1", "T", "EH2", "K"],
    "aten": ["EY1", "T", "AH0", "N"],
    "atencio": ["AH0", "T", "EH1", "N", "S", "IY0", "OW0"],
    "ater": ["EY1", "T", "ER0"],
    "ates": ["EY1", "T", "S"],
    "atha": ["AE1", "TH", "AH0"],
    "athalia": ["EY0", "TH", "AE1", "L", "IY0", "AH0"],
    "athanas": ["EY0", "TH", "AE1", "N", "AH0", "Z"],
    "athanassiou": ["AA2", "TH", "AH0", "N", "AH0", "S", "IY1", "UW0"],
    "athans": ["AE1", "TH", "AH0", "N", "Z"],
    "athas": ["EY1", "DH", "AH0", "Z"],
    "athearn": ["EY1", "TH", "ER0", "N"],
    "atheism": ["EY1", "TH", "IY0", "IH2", "Z", "AH0", "M"],
    "atheist": ["EY1", "TH", "IY0", "AH0", "S", "T"],
    "atheistic": ["EY2", "TH", "IY0", "IH1", "S", "T", "IH0", "K"],
    "atheists": ["EY1", "TH", "IY0", "AH0", "S", "T", "S"],
    "athena": ["AH0", "TH", "IY1", "N", "AH0"],
    "athenaeum": ["AE2", "TH", "AH0", "N", "IY1", "AH0", "M"],
    "athenaios": ["AE2", "TH", "AH0", "N", "AY1", "OW0", "S"],
    "athene": ["AE2", "TH", "IY1", "N"],
    "atheneum": ["AE1", "TH", "AH0", "N", "UW0", "M"],
    "athenian": ["AH0", "TH", "IY1", "N", "IY0", "AH0", "N"],
    "athenians": ["AH0", "TH", "IY1", "N", "IY0", "AH0", "N", "Z"],
    "athens": ["AE1", "TH", "AH0", "N", "Z"],
    "atherosclerosis": ["AE2", "TH", "ER0", "OW0", "S", "K", "L", "ER0", "OW1", "S", "IH0", "S"],
    "atherton": ["AE1", "TH", "ER0", "T", "AH0", "N"],
    "athey": ["AE1", "TH", "IY0"],
    "athie": ["EY1", "TH", "IY0"],
    "athlete": ["AE1", "TH", "L", "IY2", "T"],
    "athlete's": ["AE1", "TH", "L", "IY2", "T", "S"],
    "athletes": ["AE1", "TH", "L", "IY2", "T", "S"],
    "athletes'": ["AE1", "TH", "L", "IY2", "T", "S"],
    "athletic": ["AE0", "TH", "L", "EH1", "T", "IH0", "K"],
    "athletically": ["AE0", "TH", "L", "EH1", "T", "IH0", "K", "L", "IY0"],
    "athleticism": ["AE0", "TH", "L", "EH1", "T", "IH0", "S", "IH2", "Z", "M"],
    "athletics": ["AE0", "TH", "L", "EH1", "T", "IH0", "K", "S"],
    "athlone": ["AE0", "TH", "L", "OW1", "N"],
    "athwart": ["AH0", "TH", "W", "AO1", "R", "T"],
    "ati": ["EY2", "T", "IY2", "AY1"],
    "atico": ["AE1", "T", "IH0", "K", "OW2"],
    "atienza": ["AA0", "T", "IY1", "N", "Z", "AH0"],
    "atilano": ["AA0", "T", "IY0", "L", "AA1", "N", "OW0"],
    "atither": ["AH0", "T", "IH1", "DH", "ER0"],
    "atkerson": ["AE1", "T", "K", "ER0", "S", "AH0", "N"],
    "atkin": ["AH0", "T", "K", "IH1", "N"],
    "atkins": ["AE1", "T", "K", "IH0", "N", "Z"],
    "atkins's": ["AE1", "T", "K", "IH0", "N", "Z", "IH0", "Z"],
    "atkinson": ["AE1", "T", "K", "IH0", "N", "S", "AH0", "N"],
    "atkinson's": ["AE1", "T", "K", "IH0", "N", "S", "AH0", "N", "Z"],
    "atkison": ["AE1", "T", "K", "IH0", "S", "AH0", "N"],
    "atkisson": ["AE1", "T", "K", "IH0", "S", "AH0", "N"],
    "atla": ["AE1", "T", "L", "AH0"],
    "atlan": ["AE1", "T", "L", "AH0", "N"],
    "atlanta": ["AH0", "T", "L", "AE1", "N", "T", "AH0"],
    "atlanta's": ["AE0", "T", "L", "AE1", "N", "T", "AH0", "Z"],
    "atlantan": ["AE2", "T", "L", "AE1", "N", "T", "AH0", "N"],
    "atlantans": ["AE2", "T", "L", "AE1", "N", "T", "AH0", "N", "Z"],
    "atlantic": ["AH0", "T", "L", "AE1", "N", "IH0", "K"],
    "atlantic's": ["AH0", "T", "L", "AE1", "N", "IH0", "K", "S"],
    "atlantica": ["AE2", "T", "L", "AE1", "N", "T", "IH0", "K", "AH0"],
    "atlantico": ["AE2", "T", "L", "AE1", "N", "T", "IH0", "K", "OW0"],
    "atlantis": ["AE0", "T", "L", "AE1", "N", "IH0", "S"],
    "atlantis'": ["AE0", "T", "L", "AE1", "N", "T", "IH0", "S", "IH0", "Z"],
    "atlantis's": ["AE0", "T", "L", "AE1", "N", "T", "IH0", "S", "IH0", "Z"],
    "atlas": ["AE1", "T", "L", "AH0", "S"],
    "atlas's": ["AE1", "T", "L", "AH0", "S", "IH0", "Z"],
    "atlases": ["AE1", "T", "L", "AH0", "S", "IH0", "Z"],
    "atler": ["AE1", "T", "L", "ER0"],
    "atley": ["AE1", "T", "L", "IY0"],
    "atm": ["EY1", "T", "IY2", "EH1", "M"],
    "atman": ["AE1", "T", "M", "AH0", "N"],
    "atmel": ["AE1", "T", "M", "AH0", "L"],
    "atmosphere": ["AE1", "T", "M", "AH0", "S", "F", "IH2", "R"],
    "atmospheric": ["AE2", "T", "M", "AH0", "S", "F", "EH1", "R", "IH0", "K"],
    "atmospherics": ["AE2", "T", "M", "AH0", "S", "F", "EH1", "R", "IH0", "K", "S"],
    "atnip": ["AE1", "T", "N", "IH0", "P"],
    "atocha": ["AH0", "T", "AA1", "CH", "AH0"],
    "atoll": ["AH0", "T", "OW1", "L"],
    "atom": ["AE1", "T", "AH0", "M"],
    "atomic": ["AH0", "T", "AA1", "M", "IH0", "K"],
    "atomizer": ["AE1", "T", "AH0", "M", "AY2", "Z", "ER0"],
    "atoms": ["AE1", "T", "AH0", "M", "Z"],
    "aton": ["AH0", "T", "AA1", "N"],
    "atonal": ["EY0", "T", "OW1", "N", "AH0", "L"],
    "atone": ["AH0", "T", "OW1", "N"],
    "atonement": ["AH0", "T", "OW1", "N", "M", "AH0", "N", "T"],
    "atop": ["AH0", "T", "AA1", "P"],
    "ator": ["AA1", "T", "AO0", "R"],
    "atorino": ["AE2", "T", "ER0", "IY1", "N", "OW0"],
    "atp": ["EY1", "T", "IY1", "P", "IY1"],
    "atra": ["EY1", "T", "R", "AH0"],
    "atria": ["EY1", "T", "R", "IY0", "AH0"],
    "atrium": ["EY1", "T", "R", "IY0", "AH0", "M"],
    "atriums": ["EY1", "T", "R", "IY0", "AH0", "M", "Z"],
    "atrocious": ["AH0", "T", "R", "OW1", "SH", "AH0", "S"],
    "atrocities": ["AH0", "T", "R", "AA1", "S", "AH0", "T", "IY0", "Z"],
    "atrocity": ["AH0", "T", "R", "AA1", "S", "AH0", "T", "IY0"],
    "atrophied": ["AE1", "T", "R", "AH0", "F", "IY0", "D"],
    "atrophies": ["AE1", "T", "R", "AH0", "F", "IY0", "Z"],
    "atrophy": ["AE1", "T", "R", "AH0", "F", "IY0"],
    "atsushi": ["AA0", "T", "S", "UW1", "SH", "IY2"],
    "atta": ["AE1", "T", "AH0"],
    "attaboy": ["AE1", "T", "AH0", "B", "OY2"],
    "attaboys": ["AE1", "T", "AH0", "B", "OY2", "Z"],
    "attach": ["AH0", "T", "AE1", "CH"],
    "attache": ["AE2", "T", "AH0", "SH", "EY1"],
    "attached": ["AH0", "T", "AE1", "CH", "T"],
    "attaches": ["AH0", "T", "AE1", "CH", "IH0", "Z"],
    "attaching": ["AH0", "T", "AE1", "CH", "IH0", "NG"],
    "attachment": ["AH0", "T", "AE1", "CH", "M", "AH0", "N", "T"],
    "attachments": ["AH0", "T", "AE1", "CH", "M", "AH0", "N", "T", "S"],
    "attack": ["AH0", "T", "AE1", "K"],
    "attacked": ["AH0", "T", "AE1", "K", "T"],
    "attacker": ["AH0", "T", "AE1", "K", "ER0"],
    "attackers": ["AH0", "T", "AE1", "K", "ER0", "Z"],
    "attacking": ["AH0", "T", "AE1", "K", "IH0", "NG"],
    "attacks": ["AH0", "T", "AE1", "K", "S"],
    "attain": ["AH0", "T", "EY1", "N"],
    "attainable": ["AH0", "T", "EY1", "N", "AH0", "B", "AH0", "L"],
    "attainder": ["AH0", "T", "EY1", "N", "D", "ER0"],
    "attained": ["AH0", "T", "EY1", "N", "D"],
    "attaining": ["AH0", "T", "EY1", "N", "IH0", "NG"],
    "attainment": ["AH0", "T", "EY1", "N", "M", "AH0", "N", "T"],
    "attains": ["AH0", "T", "EY1", "N", "Z"],
    "attali": ["AH0", "T", "AA1", "L", "IY0"],
    "attalla": ["AH0", "T", "AE1", "L", "AH0"],
    "attanasio": ["AA0", "T", "AA0", "N", "AA1", "S", "IY0", "OW0"],
    "attar": ["AE1", "T", "ER0"],
    "attard": ["AE1", "T", "ER0", "D"],
    "attardo": ["AA0", "T", "AA1", "R", "D", "OW0"],
    "attaway": ["AE1", "T", "AH0", "W", "EY0"],
    "atteberry": ["AE1", "T", "B", "EH0", "R", "IY0"],
    "attebery": ["AH0", "T", "EH1", "B", "ER0", "IY0"],
    "attebury": ["AE1", "T", "B", "EH0", "R", "IY0"],
    "attempt": ["AH0", "T", "EH1", "M", "P", "T"],
    "attempted": ["AH0", "T", "EH1", "M", "P", "T", "IH0", "D"],
    "attempting": ["AH0", "T", "EH1", "M", "P", "T", "IH0", "NG"],
    "attempts": ["AH0", "T", "EH1", "M", "P", "S"],
    "attenborough": ["AE1", "T", "AH2", "N", "B", "ER0", "OW0"],
    "attend": ["AH0", "T", "EH1", "N", "D"],
    "attendance": ["AH0", "T", "EH1", "N", "D", "AH0", "N", "S"],
    "attendant": ["AH0", "T", "EH1", "N", "D", "AH0", "N", "T"],
    "attendant's": ["AH0", "T", "EH1", "N", "D", "AH0", "N", "T", "S"],
    "attendants": ["AH0", "T", "EH1", "N", "D", "AH0", "N", "T", "S"],
    "attendants'": ["AH0", "T", "EH1", "N", "D", "AH0", "N", "T", "S"],
    "attended": ["AH0", "T", "EH1", "N", "D", "IH0", "D"],
    "attendee": ["AH0", "T", "EH1", "N", "D", "IY1"],
    "attendees": ["AH0", "T", "EH1", "N", "D", "IY1", "Z"],
    "attending": ["AH0", "T", "EH1", "N", "D", "IH0", "NG"],
    "attends": ["AH0", "T", "EH1", "N", "D", "Z"],
    "attention": ["AH0", "T", "EH1", "N", "SH", "AH0", "N"],
    "attentions": ["AH0", "T", "EH1", "N", "SH", "AH0", "N", "Z"],
    "attentive": ["AH0", "T", "EH1", "N", "T", "IH0", "V"],
    "attentively": ["AH0", "T", "EH1", "N", "T", "IH0", "V", "L", "IY0"],
    "attentiveness": ["AH0", "T", "EH1", "N", "T", "IH0", "V", "N", "AH0", "S"],
    "attenuate": ["AH0", "T", "EH1", "N", "Y", "UW0", "EY2", "T"],
    "attenuated": ["AH0", "T", "EH1", "N", "Y", "UW0", "EY2", "T", "IH0", "D"],
    "attenuates": ["AH0", "T", "EH1", "N", "Y", "UW0", "EY2", "T", "S"],
    "attenuation": ["AH0", "T", "EH2", "N", "Y", "UW0", "EY1", "SH", "AH0", "N"],
    "atterberry": ["AE1", "T", "ER0", "B", "EH0", "R", "IY0"],
    "atterbury": ["AE1", "T", "ER0", "B", "EH2", "R", "IY0"],
    "attermann": ["AE1", "T", "ER0", "M", "AH0", "N"],
    "attest": ["AH0", "T", "EH1", "S", "T"],
    "attested": ["AH0", "T", "EH1", "S", "T", "IH0", "D"],
    "attesting": ["AH0", "T", "EH1", "S", "T", "IH0", "NG"],
    "attests": ["AH0", "T", "EH1", "S"],
    "attic": ["AE1", "T", "IH0", "K"],
    "attica": ["AE1", "T", "IH0", "K", "AH0"],
    "attics": ["AE1", "T", "IH0", "K", "S"],
    "atticus": ["AE1", "T", "IH0", "K", "AH0", "S"],
    "attie": ["AE1", "T", "IY0"],
    "attila": ["AH0", "T", "IH1", "L", "AH0"],
    "attila's": ["AH0", "T", "IH1", "L", "AH0", "Z"],
    "attire": ["AH0", "T", "AY1", "ER0"],
    "attired": ["AH0", "T", "AY1", "R", "D"],
    "attitude": ["AE1", "T", "AH0", "T", "UW2", "D"],
    "attitudes": ["AE1", "T", "AH0", "T", "UW2", "D", "Z"],
    "attitudinal": ["AE2", "T", "AH0", "T", "UW1", "D", "AH0", "N", "AH0", "L"],
    "attkisson": ["AE1", "T", "K", "IH0", "S", "AH0", "N"],
    "attleboro": ["AE1", "T", "AH0", "L", "B", "ER0", "OW0"],
    "attlee": ["AE1", "T", "L", "IY0"],
    "attorney": ["AH0", "T", "ER1", "N", "IY0"],
    "attorney's": ["AH0", "T", "ER1", "N", "IY0", "Z"],
    "attorneys": ["AH0", "T", "ER1", "N", "IY0", "Z"],
    "attorneys'": ["AH0", "T", "ER1", "N", "IY0", "Z"],
    "attract": ["AH0", "T", "R", "AE1", "K", "T"],
    "attracted": ["AH0", "T", "R", "AE1", "K", "T", "IH0", "D"],
    "attracting": ["AH0", "T", "R", "AE1", "K", "T", "IH0", "NG"],
    "attraction": ["AH0", "T", "R", "AE1", "K", "SH", "AH0", "N"],
    "attractions": ["AH0", "T", "R", "AE1", "K", "SH", "AH0", "N", "Z"],
    "attractive": ["AH0", "T", "R", "AE1", "K", "T", "IH0", "V"],
    "attractively": ["AH0", "T", "R", "AE1", "K", "T", "IH0", "V", "L", "IY0"],
    "attractiveness": ["AH0", "T", "R", "AE1", "K", "T", "IH0", "V", "N", "AH0", "S"],
    "attracts": ["AH0", "T", "R", "AE1", "K", "T", "S"],
    "attributable": ["AH0", "T", "R", "IH1", "B", "Y", "AH0", "T", "AH0", "B", "AH0", "L"],
    "attribute": ["AH0", "T", "R", "IH1", "B", "Y", "UW2", "T"],
    "attributed": ["AH0", "T", "R", "IH1", "B", "Y", "AH0", "T", "IH0", "D"],
    "attributes": ["AH0", "T", "R", "IH1", "B", "Y", "UW2", "T", "S"],
    "attributing": ["AH0", "T", "R", "IH1", "B", "Y", "AH0", "T", "IH0", "NG"],
    "attribution": ["AE2", "T", "R", "IH0", "B", "Y", "UW1", "SH", "AH0", "N"],
    "attridge": ["AH0", "T", "R", "IH1", "JH"],
    "attrition": ["AH0", "T", "R", "IH1", "SH", "AH0", "N"],
    "attune": ["AH0", "T", "UW1", "N"],
    "attuned": ["AH0", "T", "UW1", "N", "D"],
    "attwood": ["AE1", "T", "W", "UH2", "D"],
    "attwoods": ["AE1", "T", "W", "UH2", "D", "Z"],
    "atv": ["EY2", "T", "IY2", "V", "IY1"],
    "atwater": ["AE1", "T", "W", "AO0", "T", "ER0"],
    "atwell": ["AH0", "T", "W", "EH1", "L"],
    "atwood": ["AE1", "T", "W", "UH2", "D"],
    "atworth": ["AE1", "T", "W", "ER0", "TH"],
    "atx": ["EY1", "T", "IY1", "EH1", "K", "S"],
    "atypia": ["EY2", "T", "IH1", "P", "IY2", "AH0"],
    "atypic": ["EY2", "T", "IH1", "P", "IH0", "K"],
    "atypical": ["EY2", "T", "IH1", "P", "IH0", "K", "AH0", "L"],
    "atz": ["AE1", "T", "S"],
    "au": ["OW1"],
    "aube": ["AO1", "B"],
    "aubel": ["AW1", "B", "AH0", "L"],
    "auber": ["AO1", "B", "ER0"],
    "aubergine": ["AO1", "B", "ER0", "JH", "IY2", "N"],
    "aubergines": ["AO1", "B", "ER0", "JH", "IY2", "N", "Z"],
    "auberry": ["AO1", "B", "EH2", "R", "IY0"],
    "aubert": ["AO1", "B", "ER0", "T"],
    "aubin": ["AO1", "B", "IH0", "N"],
    "auble": ["AO1", "B", "AH0", "L"],
    "aubrey": ["AO1", "B", "R", "IY0"],
    "aubry": ["AO1", "B", "R", "IY0"],
    "aubuchon": ["OW1", "B", "AH0", "SH", "AA0", "N"],
    "auburn": ["AA1", "B", "ER0", "N"],
    "auch": ["AO1", "CH"],
    "auchter": ["AW1", "K", "T", "ER0"],
    "auckland": ["AA1", "K", "L", "AH0", "N", "D"],
    "auclair": ["OW0", "K", "L", "EH1", "R"],
    "aucoin": ["OW0", "K", "OY1", "N"],
    "aucott": ["AO1", "K", "AA2", "T"],
    "auction": ["AO1", "K", "SH", "AH0", "N"],
    "auction's": ["AO1", "K", "SH", "AH0", "N", "Z"],
    "auctioned": ["AO1", "K", "SH", "AH0", "N", "D"],
    "auctioneer": ["AA2", "K", "SH", "AH0", "N", "IH1", "R"],
    "auctioneering": ["AO2", "K", "SH", "AH0", "N", "IH1", "R", "IH0", "NG"],
    "auctioneers": ["AO1", "K", "SH", "AH0", "N", "IH1", "R", "Z"],
    "auctioning": ["AO1", "K", "SH", "AH0", "N", "IH0", "NG"],
    "auctions": ["AO1", "K", "SH", "AH0", "N", "Z"],
    "aud": ["AO1", "D"],
    "audacious": ["AA0", "D", "EY1", "SH", "AH0", "S"],
    "audacity": ["AA0", "D", "AE1", "S", "AH0", "T", "IY0"],
    "audas": ["OW0", "D", "AA1", "Z"],
    "auden": ["AO1", "D", "AH0", "N"],
    "auderburn": ["AO1", "D", "ER0", "B", "ER0", "N"],
    "audet": ["OW0", "D", "EH1", "T"],
    "audette": ["OW0", "D", "EH1", "T"],
    "audi": ["AW1", "D", "IY0"],
    "audi's": ["AW1", "D", "IY0", "Z"],
    "audia": ["AO1", "D", "IY0", "AH0"],
    "audible": ["AA1", "D", "AH0", "B", "AH0", "L"],
    "audibles": ["AA1", "D", "AH0", "B", "AH0", "L", "Z"],
    "audibly": ["AA1", "D", "AH0", "B", "L", "IY0"],
    "audience": ["AO1", "D", "IY0", "AH0", "N", "S"],
    "audience's": ["AO1", "D", "IY0", "AH0", "N", "S", "AH0", "Z"],
    "audiences": ["AO1", "D", "IY0", "AH0", "N", "S", "AH0", "Z"],
    "audino": ["AO2", "D", "IY1", "N", "OW0"],
    "audio": ["AA1", "D", "IY0", "OW2"],
    "audiophile": ["AO2", "D", "IY1", "OW0", "F", "IY2", "L"],
    "audiophiles": ["AO2", "D", "IY1", "OW0", "F", "IY2", "L", "Z"],
    "audiotape": ["AO1", "D", "IY0", "OW0", "T", "EY2", "P"],
    "audiotapes": ["AO1", "D", "IY0", "OW0", "T", "EY2", "P", "S"],
    "audiotex": ["AO1", "D", "IY0", "OW0", "T", "EH2", "K", "S"],
    "audiotronic": ["AO2", "D", "IY0", "OW0", "T", "R", "AA1", "N", "IH0", "K"],
    "audiotronics": ["AO2", "D", "IY0", "OW0", "T", "R", "AA1", "N", "IH0", "K", "S"],
    "audiovisual": ["AO2", "D", "IY0", "OW0", "V", "IH1", "ZH", "UW0", "AH0", "L"],
    "audiovox": ["AO1", "D", "IY0", "OW0", "V", "AA2", "K", "S"],
    "audis": ["AW1", "D", "IY0", "Z"],
    "audit": ["AO1", "D", "IH0", "T"],
    "audited": ["AO1", "D", "IH0", "T", "IH0", "D"],
    "auditing": ["AA1", "D", "AH0", "T", "IH0", "NG"],
    "audition": ["AA0", "D", "IH1", "SH", "AH0", "N"],
    "auditioned": ["AO2", "D", "IH1", "SH", "AH0", "N", "D"],
    "auditioning": ["AA0", "D", "IH1", "SH", "AH0", "N", "IH0", "NG"],
    "auditions": ["AO2", "D", "IH1", "SH", "AH0", "N", "Z"],
    "auditor": ["AO1", "D", "IH0", "T", "ER0"],
    "auditor's": ["AO1", "D", "IH0", "T", "ER0", "Z"],
    "auditorium": ["AO2", "D", "AH0", "T", "AO1", "R", "IY0", "AH0", "M"],
    "auditoriums": ["AO2", "D", "IH0", "T", "AO1", "R", "IY0", "AH0", "M", "Z"],
    "auditors": ["AA1", "D", "AH0", "T", "ER0", "Z"],
    "auditors'": ["AO1", "D", "IH0", "T", "ER0", "Z"],
    "auditory": ["AO1", "D", "IH0", "T", "AO2", "R", "IY0"],
    "audits": ["AA1", "D", "AH0", "T", "S"],
    "audran": ["AO1", "D", "R", "AH0", "N"],
    "audrey": ["AO1", "D", "R", "IY0"],
    "audric": ["AO1", "D", "R", "IH0", "K"],
    "audrie": ["AO1", "D", "ER0", "IY0"],
    "audris": ["OW0", "D", "R", "IY1", "S"],
    "audry": ["AO1", "D", "R", "IY0"],
    "audubon": ["AO1", "D", "AH0", "B", "AA0", "N"],
    "audwin": ["AO1", "D", "W", "IH0", "N"],
    "aue": ["AW1"],
    "auel": ["AW1", "AH0", "L"],
    "auen": ["AW1", "AH0", "N"],
    "auer": ["AW1", "ER0"],
    "auerbach": ["AW1", "ER0", "B", "AA0", "K"],
    "auerback": ["AW1", "R", "B", "AE2", "K"],
    "aufderheide": ["AW1", "F", "D", "ER0", "HH", "AY0", "D"],
    "aufhauser": ["AO1", "F", "HH", "AW2", "Z", "ER0"],
    "aufiero": ["OW0", "F", "IH1", "R", "OW0"],
    "aug": ["AO1", "G", "AH0", "S", "T"],
    "augat": ["AO1", "G", "AE0", "T"],
    "auge": ["AO1", "JH"],
    "augello": ["AO0", "JH", "EH1", "L", "OW0"],
    "augenstein": ["AW1", "G", "AH0", "N", "S", "T", "IY0", "N"],
    "auger": ["AO1", "G", "ER0"],
    "augers": ["AO1", "G", "ER0", "Z"],
    "aughenbaugh": ["AO0", "EH1", "N", "B", "AO0"],
    "aught": ["AO1", "T"],
    "augment": ["AO0", "G", "M", "EH1", "N", "T"],
    "augmentable": ["AA0", "G", "M", "EH1", "N", "T", "AH0", "B", "AH0", "L"],
    "augmentation": ["AA2", "G", "M", "EH0", "N", "T", "EY1", "SH", "AH0", "N"],
    "augmented": ["AA0", "G", "M", "EH1", "N", "T", "IH0", "D"],
    "augmenting": ["AO1", "G", "M", "EH2", "N", "T", "IH0", "NG"],
    "augsburg": ["AO1", "G", "Z", "B", "ER0", "G"],
    "augsburger": ["AO1", "G", "Z", "B", "ER0", "G", "ER0"],
    "augspurger": ["AO1", "G", "S", "P", "ER0", "G", "ER0"],
    "augur": ["AO1", "G", "ER0"],
    "auguring": ["AO1", "G", "ER0", "IH0", "NG"],
    "augurs": ["AO1", "G", "ER0", "Z"],
    "august": ["AO1", "G", "AH0", "S", "T"],
    "august's": ["AO1", "G", "AH0", "S", "T", "S"],
    "augusta": ["AH0", "G", "AH1", "S", "T", "AH0"],
    "augusta's": ["AH0", "G", "AH1", "S", "T", "AH0", "Z"],
    "auguste": ["AO1", "G", "AH0", "S", "T"],
    "augustin": ["AW0", "G", "UW0", "S", "T", "IY1", "N"],
    "augustine": ["AO1", "G", "AH0", "S", "T", "IY2", "N"],
    "augustinian": ["AA2", "G", "AH0", "S", "T", "IH1", "N", "IY0", "AH0", "N"],
    "augustinians": ["AA2", "G", "AH0", "S", "T", "IH1", "N", "IY0", "AH0", "N", "Z"],
    "augusto": ["AO2", "G", "AH1", "S", "T", "OW0"],
    "augustson": ["AO1", "G", "AH0", "S", "AH0", "N"],
    "augustus": ["AH0", "G", "AH1", "S", "T", "AH0", "S"],
    "augustyn": ["AW0", "G", "AH1", "S", "T", "IH0", "N"],
    "augustyniak": ["AW0", "G", "AH0", "S", "T", "IH1", "N", "IY0", "AE0", "K"],
    "aujourd'hui": ["OW1", "ZH", "AO0", "R", "D", "W", "IY1"],
    "aujourd'hui's": ["OW1", "ZH", "AO0", "R", "D", "W", "IY1", "Z"],
    "auker": ["AO1", "K", "ER0"],
    "aukerman": ["AW1", "K", "ER0", "M", "AH0", "N"],
    "aul": ["AO1", "L"],
    "aulana": ["AW2", "L", "AA1", "N", "AH0"],
    "aulander": ["OW1", "L", "AE0", "N", "D", "ER0"],
    "auld": ["AO1", "L", "D"],
    "aulds": ["AO1", "L", "D", "Z"],
    "auletta": ["AO0", "L", "EH1", "T", "AH0"],
    "aull": ["AO1", "L"],
    "ault": ["AO1", "L", "T"],
    "aultman": ["AO1", "L", "T", "M", "AH0", "N"],
    "auman": ["AO1", "M", "AH0", "N"],
    "aumann": ["AO1", "M", "AH0", "N"],
    "aument": ["AW1", "M", "AH0", "N", "T"],
    "aumiller": ["AW1", "M", "AH0", "L", "ER0"],
    "aune": ["AO1", "N"],
    "aung": ["AO1", "NG"],
    "aungier": ["EY1", "N", "JH", "ER0"],
    "aungst": ["AW1", "NG", "G", "S", "T"],
    "aunt": ["AO1", "N", "T"],
    "aunt's": ["AO1", "N", "T", "S"],
    "auntie": ["AO1", "N", "T", "IY0"],
    "aunts": ["AO1", "N", "T", "S"],
    "aunts'": ["AO1", "N", "T", "S"],
    "aupperle": ["AW1", "P", "ER0", "L", "IY0"],
    "aura": ["AO1", "R", "AH0"],
    "aural": ["AO1", "R", "AH0", "L"],
    "aurand": ["AO1", "R", "AH0", "N", "D"],
    "aurea": ["AW0", "R", "EY1", "AA0"],
    "aurelio": ["AW0", "R", "EY1", "L", "IY0", "OW0"],
    "aureole": ["AA1", "R", "IY0", "OW0", "L"],
    "aureus": ["AO1", "R", "EH2", "AH0", "S"],
    "auria": ["AO1", "R", "IY0", "AH0"],
    "aurich": ["AW1", "R", "IH0", "K"],
    "auriemma": ["AO0", "R", "IY1", "M", "AH0"],
    "aurora": ["ER0", "AO1", "R", "AH0"],
    "auroral": ["ER0", "AO1", "R", "AH0", "L"],
    "aurum": ["AO1", "R", "AH0", "M"],
    "aus": ["AW1", "Z"],
    "ausbrooks": ["AW1", "S", "B", "R", "UH0", "K", "S"],
    "ausburn": ["AW1", "S", "B", "ER0", "N"],
    "auschwitz": ["AW1", "SH", "W", "IH0", "T", "S"],
    "ausherman": ["AW1", "SH", "ER0", "M", "AH0", "N"],
    "ausimont": ["AW1", "S", "IH0", "M", "AA2", "N", "T"],
    "auslander": ["AW1", "S", "L", "AH0", "N", "D", "ER0"],
    "ausley": ["AO1", "S", "L", "IY0"],
    "ausman": ["AW1", "S", "M", "AH0", "N"],
    "ausmus": ["AW1", "S", "M", "IH0", "S"],
    "auspey": ["AW1", "S", "P", "IY0"],
    "auspice": ["AO1", "S", "P", "IH0", "S"],
    "auspices": ["AO1", "S", "P", "IH0", "S", "IH0", "Z"],
    "auspicious": ["AA0", "S", "P", "IH1", "SH", "AH0", "S"],
    "aussie": ["AO1", "S", "IY0"],
    "aust": ["AO1", "S", "T"],
    "austad": ["AW1", "S", "T", "AH0", "D"],
    "austat": ["OW1", "S", "T", "AE0", "T"],
    "austell": ["AW1", "S", "T", "AH0", "L"],
    "austen": ["AO1", "S", "T", "IH0", "N"],
    "austen's": ["AO1", "S", "T", "IH0", "N", "Z"],
    "auster": ["AO1", "S", "T", "ER0"],
    "austere": ["AO0", "S", "T", "IH1", "R"],
    "austerely": ["AO2", "S", "T", "IH1", "R", "L", "IY0"],
    "austerity": ["AO2", "S", "T", "EH1", "R", "IH0", "T", "IY0"],
    "austill": ["AW1", "S", "T", "AH0", "L"],
    "austin": ["AO1", "S", "T", "AH0", "N"],
    "austin's": ["AO1", "S", "T", "AH0", "N", "Z"],
    "austine": ["AO1", "S", "T", "IY0", "N"],
    "auston": ["AO1", "S", "T", "AH0", "N"],
    "austral": ["AO1", "S", "T", "R", "AH0", "L"],
    "australasia": ["AO2", "S", "T", "R", "AH0", "L", "EY1", "ZH", "AH0"],
    "australia": ["AO0", "S", "T", "R", "EY1", "L", "Y", "AH0"],
    "australia's": ["AO0", "S", "T", "R", "EY1", "L", "Y", "AH0", "Z"],
    "australian": ["AO0", "S", "T", "R", "EY1", "L", "Y", "AH0", "N"],
    "australian's": ["AO0", "S", "T", "R", "EY1", "L", "Y", "AH0", "N", "Z"],
    "australians": ["AO0", "S", "T", "R", "EY1", "L", "Y", "AH0", "N", "Z"],
    "australopithecine": ["AO0", "S", "T", "R", "EY2", "L", "OW0", "P", "IH1", "TH", "AH0", "S", "AY2", "N"],
    "australopithecus": ["AO0", "S", "T", "R", "EY2", "L", "OW0", "P", "IH1", "TH", "AH0", "K", "AH0", "S"],
    "australs": ["AO1", "S", "T", "R", "AH0", "L", "Z"],
    "austrasia": ["AO0", "S", "T", "R", "EY1", "ZH", "AH0"],
    "austria": ["AO1", "S", "T", "R", "IY0", "AH0"],
    "austria's": ["AO1", "S", "T", "R", "IY0", "AH0", "Z"],
    "austrian": ["AO1", "S", "T", "R", "IY0", "AH0", "N"],
    "austrians": ["AO1", "S", "T", "R", "IY0", "AH0", "N", "Z"],
    "austro": ["AO1", "S", "T", "R", "OW0"],
    "austroasiatic": ["AO2", "S", "T", "R", "OW2", "EY2", "ZH", "IY0", "AE1", "T", "IH0", "K"],
    "austron": ["AO1", "S", "T", "R", "AH0", "N"],
    "auten": ["AW1", "T", "AH0", "N"],
    "autenrieth": ["AW1", "T", "IH0", "N", "R", "IY0", "TH"],
    "autery": ["OW1", "T", "ER0", "IY0"],
    "auth": ["AO1", "TH"],
    "authement": ["AW1", "TH", "M", "AH0", "N", "T"],
    "authentic": ["AH0", "TH", "EH1", "N", "IH0", "K"],
    "authentically": ["AO2", "TH", "EH1", "N", "IH0", "K", "L", "IY0"],
    "authenticate": ["AO0", "TH", "EH1", "N", "T", "AH0", "K", "EY2", "T"],
    "authenticated": ["AO0", "TH", "EH1", "N", "T", "AH0", "K", "EY2", "T", "IH0", "D"],
    "authenticates": ["AO0", "TH", "EH1", "N", "T", "AH0", "K", "EY2", "T", "S"],
    "authenticating": ["AO0", "TH", "EH1", "N", "T", "AH0", "K", "EY2", "T", "IH0", "NG"],
    "authentication": ["AO0", "TH", "EH2", "N", "T", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "authentications": ["AO0", "TH", "EH2", "N", "T", "AH0", "K", "EY1", "SH", "AH0", "N", "Z"],
    "authenticity": ["AO2", "TH", "AH0", "N", "T", "IH1", "S", "IH0", "T", "IY0"],
    "auther": ["AO1", "TH", "ER0"],
    "authier": ["AO1", "TH", "IY0", "ER0"],
    "author": ["AO1", "TH", "ER0"],
    "author's": ["AO1", "TH", "ER0", "Z"],
    "authored": ["AO1", "TH", "ER0", "D"],
    "authoring": ["AO1", "TH", "ER0", "IH0", "NG"],
    "authoritarian": ["AH0", "TH", "AO2", "R", "AH0", "T", "EH1", "R", "IY0", "AH0", "N"],
    "authoritarianism": ["AH0", "TH", "AO2", "R", "AH0", "T", "EH1", "R", "IY0", "AH0", "N", "IH2", "Z", "AH0", "M"],
    "authoritative": ["AH0", "TH", "AO1", "R", "AH0", "T", "EY2", "T", "IH0", "V"],
    "authoritatively": ["AH0", "TH", "AO2", "R", "AH0", "T", "EY1", "T", "IH0", "V", "L", "IY0"],
    "authorities": ["AH0", "TH", "AO1", "R", "AH0", "T", "IY0", "Z"],
    "authorities'": ["AH0", "TH", "AO1", "R", "IH0", "T", "IY0", "Z"],
    "authority": ["AH0", "TH", "AO1", "R", "AH0", "T", "IY0"],
    "authority's": ["AH0", "TH", "AO1", "R", "IH0", "T", "IY0", "Z"],
    "authorization": ["AO2", "TH", "ER0", "AH0", "Z", "EY1", "SH", "AH0", "N"],
    "authorizations": ["AO2", "TH", "ER0", "AH0", "Z", "EY1", "SH", "AH0", "N", "Z"],
    "authorize": ["AO1", "TH", "ER0", "AY2", "Z"],
    "authorized": ["AO1", "TH", "ER0", "AY2", "Z", "D"],
    "authorizes": ["AO1", "TH", "ER0", "AY2", "Z", "IH0", "Z"],
    "authorizing": ["AO1", "TH", "ER0", "AY2", "Z", "IH0", "NG"],
    "authors": ["AO1", "TH", "ER0", "Z"],
    "authors'": ["AO1", "TH", "ER0", "Z"],
    "authorship": ["AO1", "TH", "ER0", "SH", "IH2", "P"],
    "autism": ["AO1", "T", "IH2", "Z", "AH0", "M"],
    "autistic": ["AO0", "T", "IH1", "S", "T", "IH0", "K"],
    "auto": ["AO1", "T", "OW0"],
    "auto's": ["AO1", "T", "OW0", "Z"],
    "autobahn": ["AO1", "T", "OW0", "B", "AA2", "N"],
    "autobiographer": ["AO2", "T", "AH0", "B", "AY0", "AA1", "G", "R", "AH0", "F", "ER0"],
    "autobiographical": ["AO2", "T", "AH0", "B", "AY2", "AH0", "G", "R", "AE1", "F", "IH0", "K", "AH0", "L"],
    "autobiographies": ["AO2", "T", "AH0", "B", "AY0", "AA1", "G", "R", "AH0", "F", "IY0", "Z"],
    "autobiography": ["AO2", "T", "AH0", "B", "AY0", "AA1", "G", "R", "AH0", "F", "IY0"],
    "autobon": ["AA1", "T", "AH0", "B", "AA2", "N"],
    "autobot": ["AO2", "T", "AH0", "B", "AA1", "T"],
    "autobots": ["AO2", "T", "AH0", "B", "AA1", "T", "S"],
    "autoclave": ["AO1", "T", "OW0", "K", "L", "EY2", "V"],
    "autocracy": ["AO0", "T", "AA1", "K", "R", "AH0", "S", "IY0"],
    "autocrat": ["AO1", "T", "AH0", "K", "R", "AE2", "T"],
    "autocratic": ["AO2", "T", "AH0", "K", "R", "AE1", "T", "IH0", "K"],
    "autodesk": ["AO1", "T", "OW0", "D", "EH2", "S", "K"],
    "autodie": ["AO1", "T", "OW0", "D", "AY2"],
    "autoeurope": ["AO2", "T", "OW0", "Y", "UH1", "R", "AH0", "P"],
    "autofact": ["AO1", "T", "OW0", "F", "AE2", "K", "T"],
    "autofacts": ["AO1", "T", "OW0", "F", "AE2", "K", "T", "S"],
    "autograph": ["AO1", "T", "AH0", "G", "R", "AE2", "F"],
    "autographed": ["AO1", "T", "AH0", "G", "R", "AE2", "F", "T"],
    "autographs": ["AO1", "T", "AH0", "G", "R", "AE2", "F", "S"],
    "autoimmune": ["AO2", "T", "OY1", "M", "Y", "UW0", "N"],
    "autolatina": ["AO2", "T", "OW2", "L", "AH0", "T", "IY1", "N", "AH0"],
    "automaker": ["AO1", "T", "OW0", "M", "EY2", "K", "ER0"],
    "automaker's": ["AO1", "T", "OW0", "M", "EY2", "K", "ER0", "Z"],
    "automakers": ["AO1", "T", "OW0", "M", "EY2", "K", "ER0", "Z"],
    "automakers'": ["AO1", "T", "OW0", "M", "EY2", "K", "ER0", "Z"],
    "automap": ["AO1", "T", "OW0", "M", "AE2", "P"],
    "automata": ["AO0", "T", "AA1", "M", "AH0", "T", "AH0"],
    "automate": ["AO1", "T", "AH0", "M", "EY2", "T"],
    "automated": ["AO1", "T", "AH0", "M", "EY2", "T", "IH0", "D"],
    "automates": ["AO1", "T", "AH0", "M", "EY2", "T", "S"],
    "automatic": ["AO2", "T", "OW0", "M", "AE1", "T", "IH0", "K"],
    "automatically": ["AO2", "T", "OW0", "M", "AE1", "T", "IH0", "K", "L", "IY0"],
    "automatics": ["AO2", "T", "AH0", "M", "AE1", "T", "IH0", "K", "S"],
    "automating": ["AO1", "T", "AH0", "M", "EY2", "T", "IH0", "NG"],
    "automation": ["AO0", "T", "AH0", "M", "EY1", "SH", "AH0", "N"],
    "automatix": ["AO2", "T", "OW0", "M", "EY1", "T", "IH0", "K", "S"],
    "automaton": ["AO0", "T", "AA1", "M", "AH0", "T", "AA2", "N"],
    "automobile": ["AO2", "T", "AH0", "M", "OW0", "B", "IY1", "L"],
    "automobiles": ["AO2", "T", "AH0", "M", "OW0", "B", "IY1", "L", "Z"],
    "automobili": ["AO2", "T", "OW0", "M", "OW0", "B", "IY1", "L", "IY0"],
    "automotive": ["AO2", "T", "AH0", "M", "OW1", "T", "IH0", "V"],
    "automotive's": ["AO2", "T", "AH0", "M", "OW1", "T", "IH0", "V", "Z"],
    "automoviles": ["AO2", "T", "OW0", "M", "OW0", "V", "IY1", "L", "EH0", "Z"],
    "auton": ["AO1", "T", "AH0", "N"],
    "autonomic": ["AO2", "T", "AH0", "N", "AA1", "M", "IH0", "K"],
    "autonomous": ["AO0", "T", "AA1", "N", "AH0", "M", "AH0", "S"],
    "autonomously": ["AO2", "T", "AA1", "N", "OW0", "M", "AH0", "S", "L", "IY0"],
    "autonomy": ["AH0", "T", "AA1", "N", "AH0", "M", "IY0"],
    "autopacific": ["AO2", "T", "OW0", "P", "AH0", "S", "IH1", "F", "IH0", "K"],
    "autopart": ["AO1", "T", "OW0", "P", "AA2", "R", "T"],
    "autoparts": ["AO1", "T", "OW0", "P", "AA2", "R", "T", "S"],
    "autopilot": ["AO1", "T", "OW0", "P", "AY2", "L", "AH0", "T"],
    "autopsied": ["AO1", "T", "AA2", "P", "S", "IY0", "D"],
    "autopsies": ["AO1", "T", "AA2", "P", "S", "IY0", "Z"],
    "autopsy": ["AO1", "T", "AA2", "P", "S", "IY0"],
    "autorad": ["AO1", "T", "OW0", "R", "AE2", "D"],
    "autoradiograph": ["AA0", "T", "OW0", "R", "EY1", "D", "IY0", "OW0", "G", "R", "AE0", "F"],
    "autorads": ["AO1", "T", "OW0", "R", "AE2", "D", "Z"],
    "autos": ["AO1", "T", "OW0", "Z"],
    "autospa": ["AO1", "T", "OW1", "S", "P", "AH0"],
    "autotote": ["AO1", "T", "OW0", "T", "OW2", "T"],
    "autotrophic": ["AO2", "T", "AH0", "T", "R", "OW1", "F", "IH0", "K"],
    "autoworker": ["AO1", "T", "OW0", "W", "ER0", "K", "ER0"],
    "autoworkers": ["AO1", "T", "OW0", "W", "ER0", "K", "ER0", "Z"],
    "autrey": ["AO1", "T", "R", "IY0"],
    "autry": ["AO1", "T", "R", "IY0"],
    "autumn": ["AO1", "T", "AH0", "M"],
    "autumn's": ["AO1", "T", "AH0", "M", "Z"],
    "autumnal": ["AO0", "T", "AH1", "M", "N", "AH0", "L"],
    "auvil": ["OW0", "V", "IH1", "L"],
    "aux": ["OW1"],
    "auxier": ["AO1", "K", "S", "IY0", "ER0"],
    "auxiliary": ["AA0", "G", "Z", "IH1", "L", "IY0", "EH0", "R", "IY0"],
    "auxton": ["AO1", "K", "S", "T", "AH0", "N"],
    "auyeung": ["AW1", "Y", "UW2", "NG"],
    "auzenne": ["AO1", "Z", "IH0", "N"],
    "av": ["EY2", "V", "IY1"],
    "ava": ["EY1", "V", "AH0"],
    "avail": ["AH0", "V", "EY1", "L"],
    "availabilities": ["AH0", "V", "EY2", "L", "AH0", "B", "IH1", "L", "IH0", "T", "IY0", "Z"],
    "availability": ["AH0", "V", "EY2", "L", "AH0", "B", "IH1", "L", "IH0", "T", "IY0"],
    "available": ["AH0", "V", "EY1", "L", "AH0", "B", "AH0", "L"],
    "availed": ["AH0", "V", "EY1", "L", "D"],
    "avakian": ["AH0", "V", "EY1", "K", "IY0", "AH0", "N"],
    "avalanche": ["AE1", "V", "AH0", "L", "AE2", "N", "CH"],
    "avalanches": ["AE1", "V", "AH0", "L", "AE2", "N", "CH", "IH0", "Z"],
    "avallone": ["AE1", "V", "AH0", "L", "OW2", "N"],
    "avalon": ["AE1", "V", "AH0", "L", "AA2", "N"],
    "avalon's": ["AE1", "V", "AH0", "L", "AA2", "N", "Z"],
    "avalos": ["AA0", "V", "AA1", "L", "OW0", "Z"],
    "avana": ["AH0", "V", "AE1", "N", "AH0"],
    "avana's": ["AH0", "V", "AE1", "N", "AH0", "Z"],
    "avanex": ["AA1", "V", "AH0", "N", "EH0", "K", "S"],
    "avant": ["AH0", "V", "AA1", "N", "T"],
    "avant-garde": ["AH0", "V", "AA1", "N", "G", "AA1", "R", "D"],
    "avantek": ["AH0", "V", "AA1", "N", "T", "EH0", "K"],
    "avanti": ["AH0", "V", "AA1", "N", "T", "IY0"],
    "avants": ["AA0", "V", "AO1", "N", "T", "S"],
    "avarice": ["AE1", "V", "ER0", "AH0", "S"],
    "avasso": ["AH0", "V", "AA1", "S", "OW2"],
    "avatar": ["AE1", "V", "AH0", "T", "AA2", "R"],
    "avatars": ["AE1", "V", "AH0", "T", "AA2", "R", "Z"],
    "avco": ["AE1", "V", "K", "OW0"],
    "avdel": ["AE1", "V", "D", "EH2", "L"],
    "ave": ["AA1", "V", "EY2"],
    "avedisian": ["AE0", "V", "IH0", "D", "IH1", "ZH", "IH0", "N"],
    "avedon": ["AE1", "V", "EH0", "D", "AA0", "N"],
    "avelar": ["AA0", "V", "EY0", "L", "AA1", "R"],
    "aveline": ["AA0", "V", "EH0", "L", "IY1", "N", "IY0"],
    "avella": ["AH0", "V", "EH1", "L", "AH0"],
    "avellino": ["AE2", "V", "AH0", "L", "IY1", "N", "OW0"],
    "avellino's": ["AE2", "V", "AH0", "L", "IY1", "N", "OW0", "Z"],
    "avemco": ["AH0", "V", "EH1", "M", "K", "OW0"],
    "avemco's": ["AH0", "V", "EH1", "M", "K", "OW0", "Z"],
    "aven": ["AA0", "V", "EY1", "N"],
    "avena": ["AA0", "V", "EY1", "N", "AH0"],
    "avenall": ["AA0", "V", "EY0", "N", "AA1", "L"],
    "avendano": ["AA0", "V", "EH0", "N", "D", "AA1", "N", "OW0"],
    "avenel": ["AA0", "V", "EY0", "N", "EH1", "L"],
    "avenell": ["AA0", "V", "EY0", "N", "EY1", "L"],
    "avenge": ["AH0", "V", "EH1", "N", "JH"],
    "avenged": ["AH0", "V", "EH1", "N", "JH", "D"],
    "avenger": ["AH0", "V", "EH1", "N", "JH", "ER0"],
    "avenging": ["AH0", "V", "EH1", "N", "JH", "IH0", "NG"],
    "aveni": ["AA0", "V", "EH1", "N", "IY0"],
    "avent": ["AA1", "V", "AH0", "N", "T"],
    "aventura": ["AE2", "V", "AH0", "N", "CH", "UH1", "R", "AH0"],
    "avenue": ["AE1", "V", "AH0", "N", "UW2"],
    "avenue's": ["AE1", "V", "AH0", "N", "UW2", "Z"],
    "avenues": ["AE1", "V", "AH0", "N", "UW2", "Z"],
    "aver": ["EY1", "V", "ER0"],
    "avera": ["AA0", "V", "EH1", "R", "AH0"],
    "average": ["AE1", "V", "R", "IH0", "JH"],
    "average's": ["AE1", "V", "R", "IH0", "JH", "IH0", "Z"],
    "averaged": ["AE1", "V", "R", "IH0", "JH", "D"],
    "averages": ["AE1", "V", "R", "IH0", "JH", "IH0", "Z"],
    "averaging": ["AE1", "V", "R", "IH0", "JH", "IH0", "NG"],
    "averbeck": ["EY1", "V", "ER0", "B", "EH2", "K"],
    "averell": ["AA0", "V", "EH0", "R", "EY1", "L"],
    "averett": ["AE1", "V", "ER0", "EH0", "T"],
    "averette": ["AE1", "V", "ER0", "EH2", "T"],
    "averil": ["EY1", "V", "R", "IH0", "L"],
    "averill": ["AA0", "V", "EH0", "R", "IY1", "L"],
    "averitt": ["AE1", "V", "ER0", "IH0", "T"],
    "averof": ["AE1", "V", "ER0", "AA2", "F"],
    "avers": ["EY1", "V", "ER0", "Z"],
    "aversa": ["AA0", "V", "EH1", "R", "S", "AH0"],
    "aversano": ["AA0", "V", "ER0", "S", "AA1", "N", "OW0"],
    "averse": ["AH0", "V", "ER1", "S"],
    "aversion": ["AH0", "V", "ER1", "ZH", "AH0", "N"],
    "aversions": ["AH0", "V", "ER1", "ZH", "AH0", "N", "Z"],
    "aversive": ["AH0", "V", "ER1", "S", "AH0", "V"],
    "avert": ["AH0", "V", "ER1", "T"],
    "averted": ["AH0", "V", "ER1", "T", "IH0", "D"],
    "averting": ["AH0", "V", "ER1", "T", "IH0", "NG"],
    "averts": ["AH0", "V", "ER1", "T", "S"],
    "avery": ["EY1", "V", "ER0", "IY0"],
    "avery's": ["EY1", "V", "ER0", "IY0", "Z"],
    "averyl": ["AE1", "V", "ER0", "IH0", "L"],
    "avey": ["EY1", "V", "IY0"],
    "avi": ["EY1", "V", "IY0"],
    "avia": ["AA1", "V", "IY0", "AH0"],
    "aviacion": ["EY2", "V", "IY0", "EY1", "SH", "AH0", "N"],
    "aviall": ["EY1", "V", "IY0", "AH0", "L"],
    "avian": ["EY1", "V", "IY0", "AH0", "N"],
    "aviano": ["AA2", "V", "IY0", "AA1", "N", "OW0"],
    "aviano's": ["AA2", "V", "IY0", "AA1", "N", "OW0", "Z"],
    "aviaries": ["EY1", "V", "IY0", "EH2", "R", "IY0", "Z"],
    "aviary": ["EY1", "V", "IY0", "EH2", "R", "IY0"],
    "aviation": ["EY2", "V", "IY0", "EY1", "SH", "AH0", "N"],
    "aviation's": ["EY2", "V", "IY0", "EY1", "SH", "AH0", "N", "Z"],
    "aviator": ["EY1", "V", "IY0", "EY2", "T", "ER0"],
    "aviators": ["EY1", "V", "IY0", "EY0", "T", "ER0", "Z"],
    "aviazione": ["AE2", "V", "IY0", "AE2", "Z", "IY0", "OW1", "N", "IY0"],
    "avice": ["AA1", "V", "AY0", "S"],
    "avid": ["AE1", "V", "IH0", "D"],
    "avidly": ["AE1", "V", "AH0", "D", "L", "IY0"],
    "avignon": ["AE1", "V", "IH0", "N", "Y", "AO2", "N"],
    "avila": ["AH0", "V", "IH1", "L", "AH0"],
    "aviles": ["AA0", "V", "IY1", "L", "EH0", "S"],
    "avilez": ["AA0", "V", "IY1", "L", "EH0", "Z"],
    "avilla": ["AH0", "V", "IH1", "L", "AH0"],
    "avina": ["AA0", "V", "IY1", "N", "AH0"],
    "avinger": ["EY1", "V", "IH0", "NG", "ER0"],
    "avionic": ["EY2", "V", "IY0", "AA1", "N", "IH0", "K"],
    "avionics": ["EY2", "V", "IY0", "AA1", "N", "IH0", "K", "S"],
    "avions": ["EY1", "V", "IY0", "AH0", "N", "Z"],
    "avis": ["EY1", "V", "IH0", "S"],
    "avitabile": ["AA0", "V", "IY0", "T", "AA1", "B", "AH0", "L"],
    "avital": ["AH0", "V", "IY1", "T", "AH0", "L"],
    "avitia": ["AA0", "V", "IY1", "SH", "AH0"],
    "aviv": ["AA0", "V", "IY1", "V"],
    "aviv's": ["AA0", "V", "IY1", "V", "Z"],
    "avmark": ["AE1", "V", "M", "AA2", "R", "K"],
    "avner": ["AE1", "V", "N", "ER0"],
    "avnet": ["AE1", "V", "N", "EH2", "T"],
    "avocado": ["AE2", "V", "AH0", "K", "AA1", "D", "OW0"],
    "avocados": ["AE2", "V", "AH0", "K", "AA1", "D", "OW0", "Z"],
    "avocation": ["AE2", "V", "AH0", "K", "EY1", "SH", "AH0", "N"],
    "avocet": ["AE1", "V", "AH0", "S", "EH2", "T"],
    "avodon": ["AE1", "V", "AH0", "D", "AA0", "N"],
    "avoid": ["AH0", "V", "OY1", "D"],
    "avoidable": ["AH0", "V", "OY1", "D", "AH0", "B", "AH0", "L"],
    "avoidance": ["AH0", "V", "OY1", "D", "AH0", "N", "S"],
    "avoided": ["AH0", "V", "OY1", "D", "IH0", "D"],
    "avoiding": ["AH0", "V", "OY1", "D", "IH0", "NG"],
    "avoids": ["AH0", "V", "OY1", "D", "Z"],
    "avolio": ["AH0", "V", "OW1", "L", "IY0", "OW0"],
    "avon": ["EY1", "V", "AA0", "N"],
    "avon's": ["AE1", "V", "AH0", "N", "Z"],
    "avondale": ["AE1", "V", "AH0", "N", "D", "EY2", "L"],
    "avow": ["AH0", "V", "AW1"],
    "avowed": ["AH0", "V", "AW1", "D"],
    "avowedly": ["AH0", "V", "AW1", "AH0", "D", "L", "IY0"],
    "avraham": ["AA1", "V", "R", "AH0", "HH", "AA0", "M"],
    "avram": ["EY1", "V", "R", "AH0", "M"],
    "avrett": ["AE1", "V", "R", "EH0", "T"],
    "avril": ["EY1", "V", "R", "AH0", "L"],
    "avrim": ["AA0", "V", "R", "IY1", "M"],
    "avtex": ["AE1", "V", "T", "EH2", "K", "S"],
    "avtex's": ["AE1", "V", "T", "EH2", "K", "S", "IH0", "Z"],
    "avtovaz": ["AE1", "V", "T", "OW2", "V", "AE2", "Z"],
    "avuncular": ["AH0", "V", "AH1", "NG", "K", "Y", "AH0", "L", "ER0"],
    "aw": ["AO1"],
    "awacs": ["EY1", "W", "AE2", "K", "S"],
    "awad": ["AH0", "W", "AA1", "D"],
    "await": ["AH0", "W", "EY1", "T"],
    "awaited": ["AH0", "W", "EY1", "T", "IH0", "D"],
    "awaiting": ["AH0", "W", "EY1", "T", "IH0", "NG"],
    "awaits": ["AH0", "W", "EY1", "T", "S"],
    "awake": ["AH0", "W", "EY1", "K"],
    "awaken": ["AH0", "W", "EY1", "K", "AH0", "N"],
    "awakened": ["AH0", "W", "EY1", "K", "AH0", "N", "D"],
    "awakening": ["AH0", "W", "EY1", "K", "AH0", "N", "IH0", "NG"],
    "awakens": ["AH0", "W", "EY1", "K", "AH0", "N", "Z"],
    "awalt": ["AA1", "V", "AH0", "L", "T"],
    "awan": ["EY1", "W", "AH0", "N"],
    "award": ["AH0", "W", "AO1", "R", "D"],
    "awarded": ["AH0", "W", "AO1", "R", "D", "IH0", "D"],
    "awarding": ["AH0", "W", "AO1", "R", "D", "IH0", "NG"],
    "awards": ["AH0", "W", "AO1", "R", "D", "Z"],
    "aware": ["AH0", "W", "EH1", "R"],
    "awareness": ["AH0", "W", "EH1", "R", "N", "AH0", "S"],
    "awash": ["AH0", "W", "AA1", "SH"],
    "away": ["AH0", "W", "EY1"],
    "aways": ["EY1", "W", "EY2", "Z"],
    "awb": ["EY1", "D", "AH1", "B", "AH0", "Y", "UW1", "B", "IY1"],
    "awbrey": ["AO1", "B", "R", "IY0"],
    "awe": ["AO1"],
    "awed": ["AO1", "D"],
    "aweida": ["AH0", "W", "AY1", "D", "AH0"],
    "awesome": ["AO1", "S", "AH0", "M"],
    "awesomely": ["AO1", "S", "AH0", "M", "L", "IY0"],
    "awesomeness": ["AO1", "S", "AH0", "M", "N", "EH2", "S"],
    "awestruck": ["AA1", "S", "T", "R", "AH2", "K"],
    "awful": ["AO1", "F", "AH0", "L"],
    "awfully": ["AO1", "F", "AH0", "L", "IY0"],
    "awfulness": ["AO1", "F", "AH0", "L", "N", "AH0", "S"],
    "awhile": ["AH0", "W", "AY1", "L"],
    "awkward": ["AO1", "K", "W", "ER0", "D"],
    "awkwardly": ["AO1", "K", "W", "ER0", "D", "L", "IY0"],
    "awkwardness": ["AO1", "K", "W", "ER0", "D", "N", "AH0", "S"],
    "awning": ["AA1", "N", "IH0", "NG"],
    "awoke": ["AH0", "W", "OW1", "K"],
    "awol": ["EY1", "W", "AO2", "L"],
    "awry": ["ER0", "AY1"],
    "awtrey": ["AO1", "T", "R", "IY0"],
    "ax": ["AE1", "K", "S"],
    "axa": ["AE1", "K", "S", "AH0"],
    "axa's": ["AE1", "K", "S", "AH0", "Z"],
    "axe": ["AE1", "K", "S"],
    "axed": ["AE1", "K", "S", "T"],
    "axel": ["AE1", "K", "S", "AH0", "L"],
    "axelrad": ["AE0", "K", "S", "EH1", "L", "R", "AH0", "D"],
    "axelrod": ["AE1", "K", "S", "AH0", "L", "R", "AA2", "D"],
    "axelsen": ["AE0", "K", "S", "EH1", "L", "S", "AH0", "N"],
    "axelson": ["AE1", "K", "S", "IH0", "L", "S", "AH0", "N"],
    "axes": ["AE1", "K", "S", "IY2", "Z"],
    "axford": ["AE0", "K", "S", "F", "AO1", "R", "D"],
    "axial": ["AE1", "K", "S", "IY0", "AH0", "L"],
    "axid": ["AE1", "K", "S", "IH0", "D"],
    "axilrod": ["AE1", "K", "S", "IH0", "L", "R", "AA2", "D"],
    "axiom": ["AE1", "K", "S", "IY0", "AH0", "M"],
    "axiomatic": ["AE2", "K", "S", "IY0", "AH0", "M", "AE1", "T", "IH0", "K"],
    "axioms": ["AE1", "K", "S", "IY0", "AH0", "M", "Z"],
    "axis": ["AE1", "K", "S", "AH0", "S"],
    "axle": ["AE1", "K", "S", "AH0", "L"],
    "axles": ["AE1", "K", "S", "AH0", "L", "Z"],
    "axley": ["AE1", "K", "S", "L", "IY0"],
    "axline": ["AE1", "K", "S", "L", "AY2", "N"],
    "axlon": ["AE1", "K", "S", "L", "AA0", "N"],
    "axon": ["AE1", "K", "S", "AA2", "N"],
    "axons": ["AE1", "K", "S", "AA2", "N", "Z"],
    "axsom": ["AE1", "K", "S", "AH0", "M"],
    "axt": ["AE1", "K", "S", "T"],
    "axtell": ["AE0", "K", "S", "T", "EH1", "L"],
    "axtman": ["AE1", "K", "S", "T", "M", "AH0", "N"],
    "axton": ["AE1", "K", "S", "T", "AH0", "N"],
    "ay": ["AY1"],
    "ayacucho": ["AY2", "AH0", "K", "AH1", "CH", "OW0"],
    "ayako": ["AH0", "Y", "AA1", "K", "OW0"],
    "ayala": ["AH0", "Y", "AA1", "L", "AH0"],
    "ayars": ["EY1", "ER0", "Z"],
    "ayatollah": ["AY2", "AH0", "T", "OW1", "L", "AH0"],
    "ayatollah's": ["AY2", "AH0", "T", "OW1", "L", "AH0", "Z"],
    "ayatollahs": ["AY2", "AH0", "T", "AA1", "L", "AA0", "Z"],
    "aybar": ["EY1", "B", "ER0"],
    "aycock": ["EY1", "K", "AH0", "K"],
    "aydar": ["EY1", "D", "AA2", "R"],
    "aydelott": ["EY1", "D", "IH0", "L", "AA0", "T"],
    "aydelotte": ["EY1", "D", "AH0", "L", "AA2", "T"],
    "aydin": ["EY1", "D", "IH0", "N"],
    "aydt": ["EY1", "T"],
    "aye": ["AY1"],
    "ayende": ["AH0", "Y", "EH1", "N", "D", "EY0"],
    "ayer": ["EY1", "ER0"],
    "ayer's": ["EY1", "R", "Z"],
    "ayers": ["EY1", "ER0", "Z"],
    "ayerst": ["EH1", "R", "AH0", "S", "T"],
    "ayes": ["AY1", "Z"],
    "ayesha": ["AY1", "S", "AA0"],
    "aygen": ["EY1", "G", "AH0", "N"],
    "aykroyd": ["AY1", "K", "R", "OY2", "D"],
    "ayler": ["EY1", "L", "ER0"],
    "ayles": ["EY1", "L", "Z"],
    "aylesbury": ["EY1", "L", "Z", "B", "ER0", "IY0"],
    "aylesbury's": ["EY1", "L", "Z", "B", "ER0", "IY0", "Z"],
    "aylesworth": ["EY1", "AH0", "L", "Z", "W", "ER0", "TH"],
    "ayling": ["EY1", "L", "IH0", "NG"],
    "aylmer": ["EY1", "L", "M", "ER0"],
    "aylor": ["EY1", "L", "ER0"],
    "aylsworth": ["EY1", "L", "S", "W", "ER0", "TH"],
    "aylward": ["EY1", "L", "W", "ER0", "D"],
    "aylwin": ["AY1", "L", "W", "IH2", "N"],
    "aylworth": ["EY1", "L", "W", "ER0", "TH"],
    "aymond": ["EY1", "M", "AH0", "N", "D"],
    "ayn": ["EY1", "N"],
    "aynes": ["EY1", "N", "Z"],
    "ayo": ["EY1", "OW0"],
    "ayodhya": ["AY2", "AA1", "D", "Y", "AH0"],
    "ayon": ["EY0", "AO1", "N"],
    "ayotte": ["EY0", "AO1", "T"],
    "ayoub": ["EY1", "AW0", "B"],
    "ayr": ["EY1", "R"],
    "ayre": ["EH1", "R"],
    "ayres": ["EH1", "R", "Z"],
    "ayrshire": ["EY1", "ER0", "SH", "ER0"],
    "ayscue": ["EY1", "S", "K", "Y", "UW0"],
    "aytes": ["EY1", "T", "S"],
    "ayuso": ["AY0", "UW1", "S", "OW0"],
    "ayyad": ["AY2", "AE1", "D"],
    "ayyad's": ["AY2", "AE1", "D", "Z"],
    "ayyash": ["AY1", "Y", "AE2", "SH"],
    "azactam": ["AH0", "Z", "AE1", "K", "T", "AE0", "M"],
    "azalea": ["AH0", "Z", "EY1", "L", "Y", "AH0"],
    "azaleas": ["AH0", "Z", "EY1", "L", "Y", "AH0", "Z"],
    "azalia": ["AA0", "Z", "AA1", "L", "IY0", "AH0"],
    "azar": ["AA0", "Z", "AA1", "R"],
    "azarow": ["AE1", "Z", "ER0", "OW0"],
    "azbell": ["AE1", "Z", "B", "EH0", "L"],
    "azbill": ["AA0", "Z", "B", "IY1", "L"],
    "azcarraga": ["AE0", "Z", "K", "AA2", "R", "AA1", "G", "AH0"],
    "azcona": ["AE0", "Z", "K", "OW1", "N", "AH0"],
    "azcuenaga": ["AE0", "Z", "K", "W", "EY2", "N", "AA1", "G", "AH0"],
    "azelia": ["AA0", "Z", "EH1", "L", "IY0", "AH0"],
    "azerbaijan": ["AE2", "Z", "ER0", "B", "AY0", "JH", "AA1", "N"],
    "azerbaijan's": ["AE2", "Z", "ER0", "B", "AY0", "JH", "AA1", "N", "Z"],
    "azerbaijani": ["AE2", "Z", "ER0", "B", "AY0", "JH", "AA1", "N", "IY0"],
    "azerbaijanis": ["AE2", "Z", "ER0", "B", "AY0", "JH", "AA1", "N", "IY0", "Z"],
    "azeri": ["AH0", "Z", "EH1", "R", "IY0"],
    "azevedo": ["AA0", "Z", "EY0", "V", "EY1", "D", "OW0"],
    "azhar": ["AH0", "Z", "AA1", "R"],
    "azhar's": ["AH0", "Z", "AA1", "R", "Z"],
    "azides": ["AE1", "Z", "AY2", "D", "Z"],
    "azidothymidine": ["EY0", "Z", "AY2", "D", "AH0", "TH", "AY1", "M", "AH0", "D", "AY2", "N"],
    "azinger": ["EY1", "Z", "IH0", "NG", "ER0"],
    "aziz": ["AH0", "Z", "IY1", "Z"],
    "azmeer": ["AE1", "Z", "M", "IH2", "R"],
    "azoff": ["AE1", "Z", "AO0", "F"],
    "azores": ["AH0", "Z", "AO1", "R", "Z"],
    "azpurua": ["AE0", "Z", "P", "Y", "UH1", "R", "UW0", "AH0"],
    "aztar": ["AE1", "Z", "T", "ER0"],
    "aztec": ["AE1", "Z", "T", "EH2", "K"],
    "azteca": ["AE2", "Z", "T", "EH1", "K", "AH0"],
    "aztecs": ["AE1", "Z", "T", "EH2", "K", "S"],
    "azuka": ["AH0", "Z", "UW1", "K", "AH0"],
    "azura": ["AH0", "Z", "UH1", "R", "AH0"],
    "azure": ["AE1", "ZH", "ER0"],
    "azzara": ["AA0", "T", "S", "AA1", "R", "AH0"],
    "azzarello": ["AA0", "T", "S", "AA0", "R", "EH1", "L", "OW0"],
    "azzaro": ["AA0", "T", "S", "AA1", "R", "OW0"],
    "azzato": ["AH0", "Z", "AA1", "T", "OW0"],
    "azzopardi": ["AA0", "T", "S", "OW0", "P", "AA1", "R", "D", "IY0"],
    "b": ["B", "IY1"],
    "b'gosh": ["B", "AH0", "G", "AO1", "SH"],
    "b'nai": ["B", "AH0", "N", "EY1"],
    "b'rith": ["B", "R", "IH1", "TH"],
    "b's": ["B", "IY1", "Z"],
    "b-j": ["B", "IY1", "JH", "EY1"],
    "b-j's": ["B", "IY1", "JH", "EY1", "Z"],
    "b.": ["B", "IY1"],
    "b.'s": ["B", "IY1", "Z"],
    "b.c.": ["B", "IY2", "S", "IY1"],
    "b.s": ["B", "IY1", "Z"],
    "ba": ["B", "AA1"],
    "ba'ath": ["B", "AH0", "AA1", "TH"],
    "ba'athism": ["B", "AA1", "TH", "IH0", "Z", "M"],
    "ba'athist": ["B", "AA1", "TH", "IH0", "S", "T"],
    "ba'athists": ["B", "AA1", "TH", "IH0", "S", "T", "S"],
    "baa": ["B", "IY2", "EY2", "EY1"],
    "baab": ["B", "AA1", "B"],
    "baack": ["B", "AA1", "K"],
    "baade": ["B", "AA1", "D"],
    "baalbek": ["B", "AA1", "L", "B", "EH0", "K"],
    "baalbeq": ["B", "AA1", "L", "B", "EH0", "K"],
    "baar": ["B", "AA1", "R"],
    "baars": ["B", "AA1", "R", "Z"],
    "baas": ["B", "AA1", "Z"],
    "baasch": ["B", "AA1", "SH"],
    "baatz": ["B", "AA1", "T", "S"],
    "bab": ["B", "AE1", "B"],
    "baba": ["B", "AA1", "B", "AH0"],
    "baba's": ["B", "AA1", "B", "AH0", "Z"],
    "babangida": ["B", "AH0", "B", "AE1", "NG", "G", "IH0", "D", "AH0"],
    "babar": ["B", "AA2", "B", "AA1", "R"],
    "babar's": ["B", "AA2", "B", "AA1", "R", "Z"],
    "babb": ["B", "AE1", "B"],
    "babbage": ["B", "AE1", "B", "IH0", "JH"],
    "babbage's": ["B", "AE1", "B", "IH0", "JH", "IH0", "Z"],
    "babbington": ["B", "AE1", "B", "IH0", "N", "G", "T", "AH0", "N"],
    "babbio": ["B", "AE1", "B", "IY0", "OW0"],
    "babbit": ["B", "AE1", "B", "IH0", "T"],
    "babbit's": ["B", "AE1", "B", "IH0", "T", "S"],
    "babbitt": ["B", "AE1", "B", "IH0", "T"],
    "babbitt's": ["B", "AE1", "B", "AH0", "T", "S"],
    "babbitts": ["B", "AE1", "B", "AH0", "T", "S"],
    "babble": ["B", "AE1", "B", "AH0", "L"],
    "babbled": ["B", "AE1", "B", "AH0", "L", "D"],
    "babbler": ["B", "AE1", "B", "L", "ER0"],
    "babblers": ["B", "AE1", "B", "L", "ER0", "Z"],
    "babbling": ["B", "AE1", "B", "L", "IH0", "NG"],
    "babbs": ["B", "AE1", "B", "Z"],
    "babcock": ["B", "AE1", "B", "K", "AO0", "K"],
    "babe": ["B", "EY1", "B"],
    "babel": ["B", "AE1", "B", "AH0", "L"],
    "baber": ["B", "EY1", "B", "ER0"],
    "babers": ["B", "EY1", "B", "ER0", "Z"],
    "babes": ["B", "EY1", "B", "Z"],
    "babette": ["B", "AH0", "B", "EH1", "T"],
    "babiak": ["B", "AA1", "B", "IY0", "AE0", "K"],
    "babiarz": ["B", "AH0", "B", "IY1", "ER0", "Z"],
    "babic": ["B", "AA1", "B", "IH0", "K"],
    "babich": ["B", "AE1", "B", "IH0", "CH"],
    "babies": ["B", "EY1", "B", "IY0", "Z"],
    "babies'": ["B", "EY1", "B", "IY0", "Z"],
    "babik": ["B", "AA1", "B", "IH0", "K"],
    "babin": ["B", "AE1", "B", "IH0", "N"],
    "babineau": ["B", "AE1", "B", "IH0", "N", "OW2"],
    "babineaux": ["B", "AE1", "B", "IH0", "N", "OW2"],
    "babington": ["B", "AE1", "B", "IH0", "NG", "T", "AH0", "N"],
    "babino": ["B", "AA0", "B", "IY1", "N", "OW0"],
    "babinski": ["B", "AH0", "B", "IH1", "N", "S", "K", "IY0"],
    "babish": ["B", "AE1", "B", "IH0", "SH"],
    "babita": ["B", "AA0", "B", "IY1", "T", "AH0"],
    "babka": ["B", "AE1", "B", "K", "AH0"],
    "babler": ["B", "EY1", "B", "AH0", "L", "ER0"],
    "baboon": ["B", "AH0", "B", "UW1", "N"],
    "baboon's": ["B", "AH0", "B", "UW1", "N", "Z"],
    "baboons": ["B", "AH0", "B", "UW1", "N", "Z"],
    "babs": ["B", "AE1", "B", "Z"],
    "babson": ["B", "AE1", "B", "S", "AH0", "N"],
    "babu": ["B", "AA0", "B", "UW1"],
    "babula": ["B", "AA0", "B", "UW1", "L", "AH0"],
    "babushka": ["B", "AH0", "B", "UH1", "SH", "K", "AH0"],
    "babushkas": ["B", "AH0", "B", "UH1", "SH", "K", "AH0", "Z"],
    "baby": ["B", "EY1", "B", "IY0"],
    "baby's": ["B", "EY1", "B", "IY0", "Z"],
    "baby-sit": ["B", "EY1", "B", "IY0", "S", "IH2", "T"],
    "baby-sitter": ["B", "EY1", "B", "IY0", "S", "IH2", "T", "ER0"],
    "baby-sitters": ["B", "EY1", "B", "IY0", "S", "IH2", "T", "ER0", "Z"],
    "babyak": ["B", "AE1", "B", "IY0", "AE0", "K"],
    "babyhood": ["B", "EY1", "B", "IY0", "HH", "UH2", "D"],
    "babyish": ["B", "EY1", "B", "IY0", "IH0", "SH"],
    "babylon": ["B", "AE1", "B", "AH0", "L", "AA2", "N"],
    "babylonian": ["B", "AE2", "B", "AH0", "L", "OW1", "N", "IY0", "AH0", "N"],
    "babylonians": ["B", "AE2", "B", "AH0", "L", "OW1", "N", "IY0", "AH0", "N", "Z"],
    "babysat": ["B", "EY1", "B", "IY0", "S", "AE2", "T"],
    "babysit": ["B", "EY1", "B", "IY0", "S", "IH0", "T"],
    "babysits": ["B", "EY1", "B", "IY0", "S", "IH0", "T", "S"],
    "babysitter": ["B", "EY1", "B", "IY0", "S", "IH2", "T", "ER0"],
    "babysitters": ["B", "EY1", "B", "IY0", "S", "IH2", "T", "ER0", "Z"],
    "babysitting": ["B", "EY1", "B", "IY0", "S", "IH2", "T", "IH0", "NG"],
    "baca": ["B", "AE1", "K", "AH0"],
    "bacall": ["B", "AH0", "K", "AO1", "L"],
    "bacardi": ["B", "AH0", "K", "AA1", "R", "D", "IY0"],
    "baccalaureate": ["B", "AE2", "K", "AH0", "L", "AO1", "R", "IY0", "AH0", "T"],
    "baccarat": ["B", "AA2", "K", "ER0", "AA1"],
    "baccari": ["B", "AA0", "K", "AA1", "R", "IY0"],
    "bacchanal": ["B", "AE1", "K", "IH0", "N", "AH0", "L"],
    "bacchanalia": ["B", "AE2", "K", "AH0", "N", "EY1", "L", "Y", "AH0"],
    "bacchi": ["B", "AE1", "K", "IY0"],
    "bacchus": ["B", "AE1", "K", "IH0", "S"],
    "bacci": ["B", "AA1", "CH", "IY0"],
    "baccus": ["B", "AE1", "K", "AH0", "S"],
    "bach": ["B", "AA1", "K"],
    "bacha": ["B", "AE1", "CH", "AH0"],
    "bachailian": ["B", "AH0", "K", "EY1", "L", "IY0", "AH0", "N"],
    "bachand": ["B", "AE1", "CH", "AH0", "N", "D"],
    "bachar": ["B", "AA1", "K", "ER0"],
    "bacharach": ["B", "AE1", "K", "ER0", "AE0", "K"],
    "bache": ["B", "EY1", "CH"],
    "bache's": ["B", "EY1", "CH", "IH0", "Z"],
    "bachelder": ["B", "AA1", "K", "EH2", "L", "D", "ER0"],
    "bacheller": ["B", "AA1", "K", "AH0", "L", "ER0"],
    "bachelor": ["B", "AE1", "CH", "L", "ER0"],
    "bachelor's": ["B", "AE1", "CH", "L", "ER0", "Z"],
    "bachelors": ["B", "AE1", "CH", "L", "ER0", "Z"],
    "bacher": ["B", "AA1", "K", "ER0"],
    "bachera": ["B", "AA1", "K", "ER0", "AH0"],
    "bachert": ["B", "AE1", "CH", "ER0", "T"],
    "bachler": ["B", "AE1", "K", "L", "ER0"],
    "bachman": ["B", "AA1", "K", "M", "AH0", "N"],
    "bachmann": ["B", "AA1", "K", "M", "AH0", "N"],
    "bachmeier": ["B", "AA1", "K", "M", "AY0", "ER0"],
    "bachner": ["B", "AA1", "K", "N", "ER0"],
    "bachrach": ["B", "AA1", "K", "R", "AH0", "K"],
    "bachtel": ["B", "AE1", "K", "T", "AH0", "L"],
    "bachtell": ["B", "AE1", "K", "T", "AH0", "L"],
    "bachus": ["B", "AE1", "CH", "AH0", "S"],
    "bacigalupi": ["B", "AA0", "CH", "IY0", "G", "AA0", "L", "UW1", "P", "IY0"],
    "bacigalupo": ["B", "AA0", "CH", "IY0", "G", "AA0", "L", "UW1", "P", "OW0"],
    "bacik": ["B", "AA1", "CH", "IH0", "K"],
    "bacillus": ["B", "AH0", "S", "IH1", "L", "AH0", "S"],
    "bacino": ["B", "AA0", "CH", "IY1", "N", "OW0"],
    "back": ["B", "AE1", "K"],
    "back's": ["B", "AE1", "K", "S"],
    "back-up": ["B", "AE1", "K", "AH2", "P"],
    "backache": ["B", "AE1", "K", "EY2", "K"],
    "backaches": ["B", "AE1", "K", "EY2", "K", "S"],
    "backbite": ["B", "AE1", "K", "B", "AY2", "T"],
    "backbiting": ["B", "AE1", "K", "B", "AY2", "T", "IH0", "NG"],
    "backboard": ["B", "AE1", "K", "B", "AO2", "R", "D"],
    "backboards": ["B", "AE1", "K", "B", "AO2", "R", "D", "Z"],
    "backbone": ["B", "AE1", "K", "B", "OW2", "N"],
    "backbones": ["B", "AE1", "K", "B", "OW2", "N", "Z"],
    "backbreaking": ["B", "AE1", "K", "B", "R", "EY2", "K", "IH0", "NG"],
    "backdate": ["B", "AE1", "K", "D", "EY2", "T"],
    "backdated": ["B", "AE1", "K", "D", "EY2", "T", "IH0", "D"],
    "backdates": ["B", "AE1", "K", "D", "EY2", "T", "S"],
    "backdating": ["B", "AE1", "K", "D", "EY2", "T", "IH0", "NG"],
    "backdoor": ["B", "AE1", "K", "D", "AO2", "R"],
    "backdoors": ["B", "AE1", "K", "D", "AO2", "R", "Z"],
    "backdrop": ["B", "AE1", "K", "D", "R", "AA2", "P"],
    "backdrops": ["B", "AE1", "K", "D", "R", "AA2", "P", "S"],
    "backe": ["B", "AE1", "K"],
    "backed": ["B", "AE1", "K", "T"],
    "backend": ["B", "AE2", "K", "EH1", "N", "D"],
    "backends": ["B", "AE2", "K", "EH1", "N", "D", "Z"],
    "backer": ["B", "AE1", "K", "ER0"],
    "backer's": ["B", "AE1", "K", "ER0", "Z"],
    "backers": ["B", "AE1", "K", "ER0", "Z"],
    "backes": ["B", "AE1", "K", "S"],
    "backfield": ["B", "AE1", "K", "F", "IY2", "L", "D"],
    "backfields": ["B", "AE1", "K", "F", "IY2", "L", "D", "Z"],
    "backfire": ["B", "AE1", "K", "F", "AY2", "R"],
    "backfired": ["B", "AE1", "K", "F", "AY2", "ER0", "D"],
    "backfires": ["B", "AE1", "K", "F", "AY2", "ER0", "Z"],
    "backfiring": ["B", "AE1", "K", "F", "AY2", "ER0", "IH0", "NG"],
    "backgammon": ["B", "AE1", "K", "G", "AE2", "M", "AH0", "N"],
    "background": ["B", "AE1", "K", "G", "R", "AW2", "N", "D"],
    "backgrounds": ["B", "AE1", "K", "G", "R", "AW2", "N", "D", "Z"],
    "backhand": ["B", "AE1", "K", "HH", "AE2", "N", "D"],
    "backhanded": ["B", "AE1", "K", "HH", "AE2", "N", "D", "IH0", "D"],
    "backhaus": ["B", "AE1", "K", "HH", "AW2", "S"],
    "backhoe": ["B", "AE1", "K", "HH", "OW2"],
    "backhoes": ["B", "AE1", "K", "HH", "OW2", "Z"],
    "backing": ["B", "AE1", "K", "IH0", "NG"],
    "backlash": ["B", "AE1", "K", "L", "AE2", "SH"],
    "backlashes": ["B", "AE1", "K", "L", "AE2", "SH", "AH0", "Z"],
    "backless": ["B", "AE1", "K", "L", "AH0", "S"],
    "backlight": ["B", "AE1", "K", "L", "AY2", "T"],
    "backlights": ["B", "AE1", "K", "L", "AY2", "T", "S"],
    "backlist": ["B", "AE1", "K", "L", "IH2", "S", "T"],
    "backlisted": ["B", "AE1", "K", "L", "IH2", "S", "T", "IH0", "D"],
    "backlog": ["B", "AE1", "K", "L", "AO2", "G"],
    "backlogged": ["B", "AE1", "K", "L", "AA2", "G", "D"],
    "backlogs": ["B", "AE1", "K", "L", "AO2", "G", "Z"],
    "backlund": ["B", "AE1", "K", "L", "AH0", "N", "D"],
    "backman": ["B", "AE1", "K", "M", "AH0", "N"],
    "backpack": ["B", "AE1", "K", "P", "AE2", "K"],
    "backpacker": ["B", "AE1", "K", "P", "AE2", "K", "ER0"],
    "backpacking": ["B", "AE1", "K", "P", "AE2", "K", "IH0", "NG"],
    "backpacks": ["B", "AE1", "K", "P", "AE2", "K", "S"],
    "backpedal": ["B", "AE1", "K", "P", "EH2", "D", "AH0", "L"],
    "backpedaled": ["B", "AE1", "K", "P", "EH2", "D", "AH0", "L", "D"],
    "backpedaling": ["B", "AE1", "K", "P", "EH2", "D", "L", "IH0", "NG"],
    "backpedals": ["B", "AE1", "K", "P", "EH2", "D", "AH0", "L", "Z"],
    "backrest": ["B", "AE1", "K", "R", "EH2", "S", "T"],
    "backrests": ["B", "AE1", "K", "R", "EH2", "S", "T", "S"],
    "backroom": ["B", "AE1", "K", "R", "UW2", "M"],
    "backrooms": ["B", "AE1", "K", "R", "UW2", "M", "Z"],
    "backs": ["B", "AE1", "K", "S"],
    "backsaw": ["B", "AE1", "K", "S", "AO2"],
    "backsaws": ["B", "AE1", "K", "S", "AO2", "Z"],
    "backseat": ["B", "AE0", "K", "S", "IY1", "T"],
    "backseats": ["B", "AE0", "K", "S", "IY1", "T", "S"],
    "backset": ["B", "AE1", "K", "S", "EH2", "T"],
    "backside": ["B", "AE1", "K", "S", "AY2", "D"],
    "backsides": ["B", "AE1", "K", "S", "AY2", "D", "Z"],
    "backslap": ["B", "AE1", "K", "S", "L", "AE2", "P"],
    "backslapping": ["B", "AE1", "K", "S", "L", "AE2", "P", "IH0", "NG"],
    "backslash": ["B", "AE1", "K", "S", "L", "AE2", "SH"],
    "backslashes": ["B", "AE1", "K", "S", "L", "AE2", "SH", "AH0", "Z"],
    "backslide": ["B", "AE1", "K", "S", "L", "AY2", "D"],
    "backsliding": ["B", "AE1", "K", "S", "L", "AY2", "D", "IH0", "NG"],
    "backspin": ["B", "AE1", "K", "S", "P", "IH0", "N"],
    "backstage": ["B", "AE1", "K", "S", "T", "EY1", "JH"],
    "backstairs": ["B", "AE1", "K", "S", "T", "EH2", "R", "Z"],
    "backstitch": ["B", "AE1", "K", "S", "T", "IH0", "CH"],
    "backstitches": ["B", "AE1", "K", "S", "T", "IH0", "CH", "AH0", "Z"],
    "backstop": ["B", "AE1", "K", "S", "T", "AA2", "P"],
    "backstreet": ["B", "AE1", "K", "S", "T", "IY2", "T"],
    "backstreets": ["B", "AE1", "K", "S", "T", "IY2", "T", "S"],
    "backstroke": ["B", "AE1", "K", "S", "T", "R", "OW2", "K"],
    "backstrom": ["B", "AE1", "K", "S", "T", "R", "AH0", "M"],
    "backtrack": ["B", "AE1", "K", "T", "R", "AE2", "K"],
    "backtracked": ["B", "AE1", "K", "T", "R", "AE2", "K", "T"],
    "backtracking": ["B", "AE1", "K", "T", "R", "AE2", "K", "IH0", "NG"],
    "backtracks": ["B", "AE1", "K", "T", "R", "AE2", "K", "S"],
    "backup": ["B", "AE1", "K", "AH2", "P"],
    "backups": ["B", "AE1", "K", "AH2", "P", "S"],
    "backus": ["B", "AE1", "K", "AH0", "S"],
    "backward": ["B", "AE1", "K", "W", "ER0", "D"],
    "backwardation": ["B", "AE2", "K", "W", "ER0", "D", "EY1", "SH", "AH0", "N"],
    "backwardness": ["B", "AE1", "K", "W", "ER0", "D", "N", "AH0", "S"],
    "backwards": ["B", "AE1", "K", "W", "ER0", "D", "Z"],
    "backwash": ["B", "AE1", "K", "W", "AA2", "SH"],
    "backwater": ["B", "AE1", "K", "W", "AO2", "T", "ER0"],
    "backwaters": ["B", "AE1", "K", "W", "AO2", "T", "ER0", "Z"],
    "backwoods": ["B", "AE1", "K", "W", "UH1", "D", "Z"],
    "backwoodsman": ["B", "AE1", "K", "W", "UH1", "D", "Z", "M", "AH0", "N"],
    "backyard": ["B", "AE1", "K", "Y", "AA2", "R", "D"],
    "backyards": ["B", "AE1", "K", "Y", "AA2", "R", "D", "Z"],
    "bacon": ["B", "EY1", "K", "AH0", "N"],
    "bacon's": ["B", "EY1", "K", "AH0", "N", "Z"],
    "bacorn": ["B", "AE1", "K", "ER0", "N"],
    "bacot": ["B", "EY1", "K", "AE0", "T"],
    "bacote": ["B", "AH0", "K", "OW1", "T"],
    "bacteria": ["B", "AE0", "K", "T", "IH1", "R", "IY0", "AH0"],
    "bacteria's": ["B", "AE0", "K", "T", "IH1", "R", "IY0", "AH0", "Z"],
    "bacterial": ["B", "AE0", "K", "T", "IH1", "R", "IY0", "AH0", "L"],
    "bacteriology": ["B", "AE2", "K", "T", "IH0", "R", "IY2", "AA1", "L", "AH0", "JH", "IY0"],
    "bacterium": ["B", "AE0", "K", "T", "IH1", "R", "IY0", "AH0", "M"],
    "bacus": ["B", "AE1", "K", "IH0", "S"],
    "bad": ["B", "AE1", "D"],
    "bad-ass": ["B", "AE1", "D", "AE2", "S"],
    "bada": ["B", "AA1", "D", "AH0"],
    "badal": ["B", "EY1", "D", "AH0", "L"],
    "badalamenti": ["B", "AA0", "D", "AA0", "L", "AA0", "M", "EH1", "N", "T", "IY0"],
    "badami": ["B", "AA0", "D", "AA1", "M", "IY0"],
    "badass": ["B", "AE1", "D", "AE2", "S"],
    "badavatz": ["B", "AE1", "D", "AH0", "V", "AE2", "T", "S"],
    "badders": ["B", "AE1", "D", "ER0", "Z"],
    "bade": ["B", "EY1", "D"],
    "badeah": ["B", "AH0", "D", "IY1", "AH0"],
    "badeau": ["B", "AH0", "D", "OW1"],
    "badeaux": ["B", "AH0", "D", "OW1"],
    "badelain": ["B", "AE1", "D", "AH0", "L", "EY2", "N"],
    "baden": ["B", "EY1", "D", "AH0", "N"],
    "baden's": ["B", "AA1", "D", "AH0", "N", "Z"],
    "bader": ["B", "EY1", "D", "ER0"],
    "badertscher": ["B", "AE1", "D", "ER0", "CH", "ER0"],
    "badge": ["B", "AE1", "JH"],
    "badger": ["B", "AE1", "JH", "ER0"],
    "badger's": ["B", "AE1", "JH", "ER0", "Z"],
    "badgered": ["B", "AE1", "JH", "ER0", "D"],
    "badgering": ["B", "AE1", "JH", "ER0", "IH0", "NG"],
    "badgers": ["B", "AE1", "JH", "ER0", "Z"],
    "badges": ["B", "AE1", "JH", "IH0", "Z"],
    "badgett": ["B", "AE1", "JH", "IH0", "T"],
    "badgley": ["B", "AE1", "JH", "L", "IY0"],
    "badia": ["B", "AA1", "D", "IY0", "AH0"],
    "badillo": ["B", "AH0", "D", "IH1", "L", "OW0"],
    "badland": ["B", "AE1", "D", "L", "AE2", "N", "D"],
    "badlands": ["B", "AE1", "D", "L", "AE2", "N", "D", "Z"],
    "badley": ["B", "AE1", "D", "L", "IY0"],
    "badly": ["B", "AE1", "D", "L", "IY0"],
    "badman": ["B", "AE1", "D", "M", "AH0", "N"],
    "badminton": ["B", "AE1", "D", "M", "IH2", "N", "T", "AH0", "N"],
    "badmintons": ["B", "AE1", "D", "M", "IH2", "N", "T", "AH0", "N", "Z"],
    "badness": ["B", "AE1", "D", "N", "AH0", "S"],
    "badolato": ["B", "AA0", "D", "OW0", "L", "AA1", "T", "OW0"],
    "badour": ["B", "AH0", "D", "UH1", "R"],
    "badu": ["B", "AH0", "D", "UW1"],
    "badura": ["B", "AA0", "D", "UH1", "R", "AH0"],
    "bady": ["B", "EY1", "D", "IY0"],
    "bae": ["B", "AY1"],
    "baechle": ["B", "EH1", "K", "AH0", "L"],
    "baecker": ["B", "EH1", "K", "ER0"],
    "baedeker": ["B", "EY1", "D", "AH0", "K", "ER0"],
    "baedeker's": ["B", "EY1", "D", "AH0", "K", "ER0", "Z"],
    "baehr": ["B", "EH1", "R"],
    "baek": ["B", "EH1", "K"],
    "baer": ["B", "EH1", "R"],
    "baerwald": ["B", "EH1", "R", "W", "AO0", "L", "D"],
    "baeten": ["B", "EH1", "T", "AH0", "N"],
    "baetjer": ["B", "EH1", "T", "JH", "ER0"],
    "baetz": ["B", "IY1", "T", "S"],
    "baez": ["B", "AY0", "EH1", "Z"],
    "baeza": ["B", "IY1", "Z", "AH0"],
    "baffa": ["B", "AE1", "F", "AH0"],
    "baffle": ["B", "AE1", "F", "AH0", "L"],
    "baffled": ["B", "AE1", "F", "AH0", "L", "D"],
    "baffles": ["B", "AE1", "F", "AH0", "L", "Z"],
    "baffling": ["B", "AE1", "F", "L", "IH0", "NG"],
    "bafokeng": ["B", "AE1", "F", "OW0", "K", "EH2", "NG"],
    "bag": ["B", "AE1", "G"],
    "bagan": ["B", "EY1", "G", "AH0", "N"],
    "bagby": ["B", "AE1", "G", "B", "IY0"],
    "bagdad": ["B", "AE1", "G", "D", "AE0", "D"],
    "bagdasarian": ["B", "AE2", "G", "D", "AH0", "S", "EH1", "R", "IY0", "AH0", "N"],
    "bagdikian": ["B", "AE2", "G", "D", "IH1", "K", "IY0", "AH0", "N"],
    "bagdon": ["B", "AE1", "G", "D", "AH0", "N"],
    "bagdonas": ["B", "AE1", "G", "D", "AH0", "N", "AH0", "Z"],
    "bagel": ["B", "EY1", "G", "AH0", "L"],
    "bageland": ["B", "EY1", "G", "AH0", "L", "AE0", "N", "D"],
    "bagels": ["B", "EY1", "G", "AH0", "L", "Z"],
    "bagent": ["B", "EY1", "JH", "AH0", "N", "T"],
    "bagful": ["B", "AE1", "G", "F", "UH2", "L"],
    "bagg": ["B", "AE1", "G"],
    "baggage": ["B", "AE1", "G", "IH0", "JH"],
    "bagge": ["B", "AE1", "G"],
    "bagged": ["B", "AE1", "G", "D"],
    "baggerly": ["B", "AE1", "G", "ER0", "L", "IY0"],
    "baggett": ["B", "AE1", "G", "IH0", "T"],
    "baggie": ["B", "AE1", "G", "IY0"],
    "bagginess": ["B", "AE1", "G", "IY0", "N", "AH0", "S"],
    "bagging": ["B", "AE1", "G", "IH0", "NG"],
    "baggio": ["B", "AA1", "JH", "IY0", "OW0"],
    "baggio's": ["B", "AA1", "JH", "IY0", "OW0", "Z"],
    "baggott": ["B", "AE1", "G", "AH0", "T"],
    "baggs": ["B", "AE1", "G", "Z"],
    "baggy": ["B", "AE1", "G", "IY0"],
    "baghdad": ["B", "AE1", "G", "D", "AE0", "D"],
    "baghdad's": ["B", "AE1", "G", "D", "AE0", "D", "Z"],
    "baghli": ["B", "AE1", "G", "L", "IY0"],
    "baginski": ["B", "AH0", "G", "IH1", "N", "S", "K", "IY0"],
    "bagley": ["B", "AE1", "G", "L", "IY0"],
    "baglio": ["B", "AE1", "G", "L", "IY0", "OW0"],
    "bagman": ["B", "AE1", "G", "M", "AH0", "N"],
    "bagnall": ["B", "AE1", "G", "N", "AH0", "L"],
    "bagnato": ["B", "AA0", "G", "N", "AA1", "T", "OW0"],
    "bagnell": ["B", "AE1", "G", "N", "AH0", "L"],
    "bagpipe": ["B", "AE1", "G", "P", "AY2", "P"],
    "bagpiper": ["B", "AE1", "G", "P", "AY2", "P", "ER0"],
    "bagpipes": ["B", "AE1", "G", "P", "AY2", "P", "S"],
    "bags": ["B", "AE1", "G", "Z"],
    "bagsby": ["B", "AE1", "G", "Z", "B", "IY0"],
    "bagshaw": ["B", "AE1", "G", "SH", "AO2"],
    "baguette": ["B", "AE2", "G", "EH1", "T"],
    "bagwell": ["B", "AE1", "G", "W", "EH2", "L"],
    "bah": ["B", "AA1"],
    "baha'is": ["B", "AA1", "HH", "AA0", "IH2", "Z"],
    "baham": ["B", "AA1", "AH0", "M"],
    "bahama": ["B", "AH0", "HH", "AA1", "M", "AH0"],
    "bahamas": ["B", "AH0", "HH", "AA1", "M", "AH0", "Z"],
    "bahamian": ["B", "AH0", "HH", "EY1", "M", "IY0", "AH0", "N"],
    "bahan": ["B", "AE1", "HH", "AH0", "N"],
    "bahe": ["B", "EY1", "HH"],
    "bahena": ["B", "AE1", "HH", "IH0", "N", "AH0"],
    "bahia": ["B", "AA1", "HH", "IY0", "AH0"],
    "bahir": ["B", "AH0", "HH", "IH1", "R"],
    "bahl": ["B", "AA1", "L"],
    "bahler": ["B", "AA1", "L", "ER0"],
    "bahls": ["B", "AA1", "L", "Z"],
    "bahm": ["B", "AE1", "M"],
    "bahman": ["B", "AA1", "M", "AH0", "N"],
    "bahn": ["B", "AE1", "N"],
    "bahner": ["B", "AA1", "N", "ER0"],
    "bahnhof": ["B", "AA2", "N", "HH", "AO1", "F"],
    "bahnsen": ["B", "AA1", "N", "S", "AH0", "N"],
    "bahr": ["B", "AA1", "R"],
    "bahrain": ["B", "AY0", "R", "EY1", "N"],
    "bahrain's": ["B", "AY0", "R", "EY1", "N", "Z"],
    "bahraini": ["B", "AA0", "R", "EY1", "N", "IY0"],
    "bahrainian": ["B", "AA0", "R", "EY1", "N", "IY0", "AH0", "N"],
    "bahrainis": ["B", "ER0", "EY1", "N", "IY0", "Z"],
    "bahre": ["B", "AA1", "R"],
    "bahrenburg": ["B", "AA1", "R", "AH0", "N", "B", "ER0", "G"],
    "baht": ["B", "AA1", "T"],
    "baidoa": ["B", "AY2", "D", "OW1", "AH0"],
    "baidoa's": ["B", "AY2", "D", "OW1", "AH0", "Z"],
    "baidoan": ["B", "AY2", "D", "OW1", "AH0", "N"],
    "baidoan's": ["B", "AY2", "D", "OW1", "AH0", "N", "Z"],
    "baidoans": ["B", "AY2", "D", "OW1", "AH0", "N", "Z"],
    "baidoas": ["B", "AY2", "D", "OW1", "AH0", "Z"],
    "baie": ["B", "AY1", "IY0"],
    "baier": ["B", "EY1", "ER0"],
    "baig": ["B", "EY1", "G"],
    "baikonur": ["B", "AY1", "K", "AH0", "N", "AO2", "R"],
    "bail": ["B", "EY1", "L"],
    "baila": ["B", "AY1", "L", "AH0"],
    "bailard": ["B", "EY1", "L", "ER0", "D"],
    "bailby": ["B", "EY1", "L", "B", "IY0"],
    "baile": ["B", "EY1", "L"],
    "bailed": ["B", "EY1", "L", "D"],
    "bailer": ["B", "EY1", "L", "ER0"],
    "bailes": ["B", "EY1", "L", "Z"],
    "bailey": ["B", "EY1", "L", "IY0"],
    "bailey's": ["B", "EY1", "L", "IY0", "Z"],
    "baileys": ["B", "EY1", "L", "IY0", "Z"],
    "bailie": ["B", "EY1", "L", "IY0"],
    "bailiff": ["B", "EY1", "L", "IH0", "F"],
    "bailiffs": ["B", "EY1", "L", "AH0", "F", "S"],
    "bailin": ["B", "EY1", "L", "IH0", "N"],
    "bailing": ["B", "EY1", "L", "IH0", "NG"],
    "bailiwick": ["B", "EY1", "L", "IH0", "W", "IH2", "K"],
    "baillargeon": ["B", "AH0", "L", "AA1", "R", "JH", "IH0", "N"],
    "baillie": ["B", "EY1", "L", "IY0"],
    "bailly": ["B", "EY1", "L", "IY0"],
    "bailon": ["B", "EY1", "L", "AH0", "N"],
    "bailor": ["B", "EY1", "L", "ER0"],
    "bailout": ["B", "EY1", "L", "AW2", "T"],
    "bailouts": ["B", "EY1", "L", "AW2", "T", "S"],
    "bails": ["B", "EY1", "L", "Z"],
    "baily": ["B", "EY1", "L", "IY0"],
    "bailyn": ["B", "EY1", "L", "IH0", "N"],
    "baim": ["B", "EY1", "M"],
    "bain": ["B", "EY1", "N"],
    "bain's": ["B", "EY1", "N", "Z"],
    "bainbridge": ["B", "EY1", "N", "B", "R", "IH0", "JH"],
    "bainbridge's": ["B", "EY1", "N", "B", "R", "IH0", "JH", "AH0", "Z"],
    "baine": ["B", "EY1", "N"],
    "bainerd": ["B", "EY1", "N", "ER0", "D"],
    "baines": ["B", "EY1", "N", "Z"],
    "bains": ["B", "EY1", "N", "Z"],
    "bainter": ["B", "EY1", "N", "T", "ER0"],
    "bainton": ["B", "EY1", "N", "T", "AH0", "N"],
    "baio": ["B", "AA1", "IY0", "OW0"],
    "bair": ["B", "EH1", "R"],
    "baird": ["B", "EH1", "R", "D"],
    "baird's": ["B", "EH1", "R", "D", "Z"],
    "bairnco": ["B", "EH1", "R", "N", "K", "OW0"],
    "baisch": ["B", "AY1", "SH"],
    "baisden": ["B", "EY1", "S", "D", "AH0", "N"],
    "baise": ["B", "EY1", "Z"],
    "baisley": ["B", "EY1", "Z", "L", "IY0"],
    "bait": ["B", "EY1", "T"],
    "baited": ["B", "EY1", "T", "IH0", "D"],
    "baiting": ["B", "EY1", "T", "IH0", "NG"],
    "baits": ["B", "EY1", "T", "S"],
    "baity": ["B", "EY1", "T", "IY0"],
    "baiul": ["B", "AY2", "UW1", "L"],
    "baiul's": ["B", "AY2", "UW1", "L", "Z"],
    "baize": ["B", "EY1", "Z"],
    "baja": ["B", "AA1", "HH", "AA2"],
    "bajarin": ["B", "AE1", "JH", "ER0", "IH0", "N"],
    "bajema": ["B", "AA0", "Y", "EY1", "M", "AH0"],
    "bajorek": ["B", "AE1", "JH", "ER0", "EH0", "K"],
    "bak": ["B", "AE1", "K"],
    "baka": ["B", "AA1", "K", "AH0"],
    "bakalar": ["B", "AE1", "K", "AH0", "L", "ER0"],
    "bake": ["B", "EY1", "K"],
    "bake-off": ["B", "EY1", "K", "AO1", "F"],
    "bake-offs": ["B", "EY1", "K", "AO1", "F", "S"],
    "baked": ["B", "EY1", "K", "T"],
    "bakelman": ["B", "EY1", "K", "AH0", "L", "M", "AH0", "N"],
    "bakeman": ["B", "EY1", "K", "M", "AH0", "N"],
    "baker": ["B", "EY1", "K", "ER0"],
    "baker's": ["B", "EY1", "K", "ER0", "Z"],
    "bakeries": ["B", "EY1", "K", "ER0", "IY0", "Z"],
    "bakers": ["B", "EY1", "K", "ER0", "Z"],
    "bakersfield": ["B", "EY1", "K", "ER0", "Z", "F", "IY2", "L", "D"],
    "bakery": ["B", "EY1", "K", "ER0", "IY0"],
    "bakes": ["B", "EY1", "K", "S"],
    "bakeware": ["B", "EY1", "K", "W", "EH2", "R"],
    "bakewell": ["B", "EY1", "K", "W", "EH2", "L"],
    "bakey": ["B", "EY1", "K", "IY0"],
    "bakey's": ["B", "EY1", "K", "IY0", "Z"],
    "baking": ["B", "EY1", "K", "IH0", "NG"],
    "bakke": ["B", "AE1", "K"],
    "bakken": ["B", "AE1", "K", "AH0", "N"],
    "bakker": ["B", "EY1", "K", "ER0"],
    "bakker's": ["B", "EY1", "K", "ER0", "Z"],
    "bakkers": ["B", "EY1", "K", "ER0", "Z"],
    "bakley": ["B", "AE1", "K", "L", "IY0"],
    "bakos": ["B", "AA1", "K", "OW0", "Z"],
    "bakowski": ["B", "AH0", "K", "AO1", "F", "S", "K", "IY0"],
    "bakrewali": ["B", "AE0", "K", "R", "AH0", "W", "AA1", "L", "IY0"],
    "bakrie": ["B", "AE1", "K", "R", "AY0"],
    "bakshi": ["B", "AE1", "K", "SH", "IY0"],
    "bakst": ["B", "AE1"