# Team Pal コンセプト

## ビジョン
Team Pal は、人間や外部システムから遠隔で受け取った指示を、適切な実行環境を持つエージェントに仲介し、結果を確実に返却するためのオーケストレーション基盤である。`codex-cli` のような実行エージェントを含む多様なコンポーネントを一元管理し、指示の受付から結果の返却までを透過的に扱うことで、利用者が運用の複雑さを意識せずに成果を得られることを目指す。

この基盤は「サービス」という概念を中心に据え、指示を受け付けるチャネルと実行結果を返却するチャネルを統一的に扱う。サービスはチャネル固有のアダプターを生成しつつ、指示と結果を紐付けるセッション管理、監査ログやリトライなどのクロスカッティングな関心事を集約して提供する。利用者は単一の入口に指示を預けるだけで、必要な実行フローが背後で整然と連携する世界観を手にする。

## ユーザーの困りごとと期待値
1. **マルチチャネル運用の煩雑さ**  
   Slack やメール、API などチャネルごとに手動で指示を配信し、結果を収集しているため、担当者が常に状況を追跡し続けなければならない。Team Pal は単一のオーケストレーション基盤を提供することで、チャネル横断のオペレーションを自動化し、担当者の負荷を軽減することを期待されている。
2. **エージェント実行の属人化**  
   `codex-cli` のような実行エージェントを呼び出す手順が個別に管理されており、設定や認証情報が人に紐づいてしまっている。Team Pal は標準化されたインターフェースでエージェントを呼び出し、環境設定を一元管理することで、属人性を排し信頼できる実行パイプラインを提供する必要がある。
3. **結果の追跡とフィードバックの遅延**  
   実行結果がどこで止まっているのか、失敗しているのかが可視化されず、利用者がフィードバックを得るまでに時間を要している。Team Pal は各指示のライフサイクルを追跡し、状況に応じた通知とエラー情報の提示を通じて迅速なフィードバックを実現することが求められる。

## 基本原則
- **レイヤードなオーケストレーション**: 起動、指示受付、エージェント実行、結果返却という明確なレイヤー構造を定義し、それぞれの責務を独立させながらも堅牢な契約を維持する。
- **プラグ可能なエージェント**: 実行エージェントは共通の実行インターフェースを満たすコンポーネントとして扱い、新しいエージェント種別を上位レイヤーの変更なしに追加できるようにする。
- **統一された指示モデル**: API や Slack ポーリングなど多様なチャネルから受信した指示を共通フォーマットに正規化し、下流の処理を一貫した方法で進められるようにする。
- **可観測性とフィードバック**: すべての指示に対して状態・出力・エラーを追跡し、利用者が結果を信頼し迅速に問題分析できる仕組みを提供する。

## レイヤー概要
| レイヤー | 主な役割 | 代表的な構成要素 | クロスカッティング関心事 |
| --- | --- | --- | --- |
| プラットフォーム起動 | 共通設定や依存関係、インフラリソースを初期化し、後続レイヤーが動作するための基盤を整える。 | 設定ローダー、シークレットマネージャー、監査ログ初期化 | 観測基盤、リトライポリシーの初期設定 |
| 指示受付 | REST API、Slack ポーリング、定期ジョブなど外部チャネルを監視し、受信した指示を統一フォーマットへ変換するアダプター群。 | Slack アダプター、Webhook リスナー、キューワーカー | 入力バリデーション、レート制御 |
| エージェント実行 | 指示に応じて適切なエージェント（例: `codex-cli`）へ処理をディスパッチし、ライフサイクル管理やログ収集、リソース・セキュリティ制御を行う。 | エージェントディスパッチャー、実行セッション、出力パーサー | 認可・認証、リソース隔離 |
| 結果返却 | 実行結果やステータス、メタデータを整形し、指示元チャネルまたは指定されたシンクへ返却する。 | Slack 返信アダプター、ステータス通知サービス、履歴ストア | エラーサマリ、遅延通知のスケジューリング |

## サービス概念
- **統一エントリーポイント**: 指示受付先と結果返却先は多くの場合同一チャネルであり、同じセッション／コンテキストを共有する。レイヤー間の仲介役として「オーケストレーションサービス」を設け、単一のファサードから指示待ちと結果返却の両機能を提供する。
- **サービス内部の責務分割**: オーケストレーションサービス自体はチャネル固有のアダプター（受付／返却）を生成・注入するファクトリーの役割に留める。実際の受付処理は指示受付レイヤーのアダプターが、返却処理は結果返却レイヤーのアダプターが担い、サービスは両者のライフサイクルと状態遷移（指示の受領→実行→返却）を調整する。
- **サービス導入の利点**: クライアントはサービスから提供されるコンテキストオブジェクト（例: `InstructionSession`）を通じて入力と出力を対に管理できる。マルチチャネル対応や結果の遅延返却などの高度な要件にも対応しやすくなり、テスト面ではサービスをモックすることで受付・返却レイヤーを個別に検証しつつ、統合テストではサービス経由でシナリオ全体を再現できる。

## 初期ターゲットシナリオ
1. **チャネル**  
   Slack ワークスペースを主要なユーザー接点とし、Bot ユーザーを介して指示を受け取り、必要に応じてチャンネルやダイレクトメッセージへ結果を返却する。ユーザーが投稿するコマンドや自然文は、サービスがセッション単位で管理する。
2. **実行エージェント**  
   `codex-cli` を Phase 1 の準エージェントと位置付け、自然言語の指示をコードタスクや自動化スクリプトとして実行する。Slack 側から付与されたメタデータ（ユーザー、チャネル、スレッド情報など）はエージェント側へ必要最小限だけ橋渡しする。
3. **オーケストレーションの流れ**  
   Slack のメッセージイベントを指示受付レイヤーのアダプターが受信し、共通フォーマットへ正規化した上でエージェント実行レイヤーにディスパッチする。`codex-cli` が処理を完了すると、結果返却レイヤーが整形・要約を行い、元の Slack スレッドへ通知する。サービスはこの一連のフローに対し、セッション識別子やトレーシング情報を付与し、リトライ／タイムアウトの制御を司る。

## マルチプロジェクト & Python モードの採用 (Phase 3 構想)
- **前提**  
  Phase 3 ではマルチプロジェクトモードを Team Pal の操作形態として導入する。ルートディレクトリ直下に複数のサブディレクトリが存在し、それぞれが GitHub リポジトリに相当する「プロジェクト」を表す。ルートディレクトリ配下の各サブディレクトリがプロジェクトとして認識され、エージェントによる作業対象となる。

- **ユーザー体験**  
  CLI／Slack からプロジェクトを指定してもらい、選択されたプロジェクト内で codex タスクを実行する。利用者がまだプロジェクトを選択していない場合は、ルートディレクトリ内のプロジェクト一覧を提示し、選択を促すメッセージを返す。

- **サブコマンド**  
  - プロジェクト一覧を表示するサブコマンド（`$project_list` / `$pl`）を提供し、ルートディレクトリ内の候補を即座に把握できるようにする。
  - プロジェクトを選択するサブコマンド（`$project_select <name>` / `$ps`）を実装し、選択状態をセッションに紐付ける。
  - プロジェクト未設定時は、自動的に一覧を返し、選択を促すフローをマルチプロジェクトモードの標準挙動とする。

- **狙い**  
  マルチレポジトリ環境での運用負荷を下げつつ、プロジェクトごとの履歴やコンテキストを維持する。フェーズ移行後も既存フェーズのチャネル機能を維持し、プロジェクト選択を加えた上で codex 実行が行われるようにする。マルチプロジェクトモードが有効な場合、選択されたプロジェクトのディレクトリに移動した状態でコーディングエージェントを実行する。加えて Python モード（デフォルト ON）を導入し、`.venv` 等の仮想環境が存在する場合は自動的にアクティベートしてからエージェントを実行することで、環境差異による不整合を防ぐ。

## レイヤー構造レビュー
- **境界の明確さ**: 各レイヤーは入力・出力インターフェースを明示的に定義し、契約を API 仕様やイベントスキーマとして文書化する必要がある。特に指示受付レイヤーとエージェント実行レイヤーの間では、指示の共通データモデル（例: コマンド、パラメータ、追跡 ID）を標準化しておくことで拡張時の影響範囲を限定できる。
- **責務の独立性**: プラットフォーム起動レイヤーは環境ブートストラップと設定の提供に徹し、ビジネスロジックを持たないようにする。逆に結果返却レイヤーは送達チャネルごとのフォーマット変換や再送制御を引き受け、エージェント実行レイヤーからは結果の原型とメタ情報のみを受け取る形を守ると、責務の混在を防げる。
- **クロスカッティング関心事**: 監査ログ、リトライ、エラーハンドリング、メトリクス収集などは各レイヤーで一貫した基盤サービスに委譲する設計が望ましい。例えば観測基盤をプラットフォーム起動レイヤーで初期化し、利用トレースをミドルウェアとして注入することで重複実装を避ける。
- **拡張性とテスト戦略**: 各レイヤーを抽象化するインターフェースを設けることでモック／フェイクが容易になり、TDD やフェーズごとの検証が進めやすくなる。特にエージェント実行レイヤーはエージェントアダプターのプラグイン構造を採用し、ユニットテストと統合テストを切り分けられるようにする。
- **将来的な分散運用への布石**: スケーラビリティを意識し、レイヤー間通信を非同期メッセージングでも置き換えられるようにしておく。初期段階では同一プロセス内で完結しても、キューやイベントバスを活用した分散構成へ移行しやすいようにプロトコルを抽象化しておくと良い。

## 目指す成果
- 遠隔エージェントとの協働を統一的かつ拡張可能なフレームワークとして提供する。
- 指示ルーティングやライフサイクル管理を自動化し、手動での調整コストを削減する。
- ロードマップで定義された新規エージェントや連携機能を無理なく追加できる拡張性を確保する。
