'''
exceptions.py: exceptions defined by Zowie

Authors
-------

Michael Hucka <mhucka@caltech.edu> -- Caltech Library

Copyright
---------

Copyright (c) 2020 by Michael Hucka and the California Institute of Technology.
This code is open-source software released under a 3-clause BSD license.
Please see the file "LICENSE" for more information.
'''


# Base class.
# .............................................................................
# The base class makes it possible to use a single test to distinguish between
# exceptions generated by Zowie and exceptions generated by something else.

class ZowieException(Exception):
    '''Base class for Zowie exceptions.'''
    pass


# Exception classes.
# .............................................................................

class CannotProceed(ZowieException):
    '''A recognizable condition caused an early exit from the program.'''
    pass

class UserCancelled(ZowieException):
    '''The user elected to cancel/quit the program.'''
    pass

class NetworkFailure(ZowieException):
    '''Unrecoverable problem involving network operations.'''
    pass

class ServiceFailure(ZowieException):
    '''Unrecoverable problem involving a remote service.'''
    pass

class AuthenticationFailure(ZowieException):
    '''Problem obtaining or using authentication credentials.'''
    pass

class InternalError(ZowieException):
    '''Unrecoverable problem involving Zowie itself.'''
    pass

class NotFound(ZowieException):
    '''Item could not be found.'''
    pass

class FileError(ZowieException):
    '''Problem reading or writing a file or its attributes.'''
    pass
