# coding: utf-8

"""
    STACKIT Server Backup Management API

    API endpoints for Server Backup Operations on STACKIT Servers.

    The version of the OpenAPI document: 1.0
    Contact: support@stackit.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing_extensions import Self

from stackit.serverbackup.models.backup_volume_backups_inner import (
    BackupVolumeBackupsInner,
)


class Backup(BaseModel):
    """
    Backup
    """

    created_at: StrictStr = Field(alias="createdAt")
    expire_at: StrictStr = Field(alias="expireAt")
    id: StrictStr
    last_restored_at: Optional[StrictStr] = Field(default=None, alias="lastRestoredAt")
    name: StrictStr
    size: Optional[StrictInt] = None
    status: StrictStr
    volume_backups: Optional[List[BackupVolumeBackupsInner]] = Field(default=None, alias="volumeBackups")
    __properties: ClassVar[List[str]] = [
        "createdAt",
        "expireAt",
        "id",
        "lastRestoredAt",
        "name",
        "size",
        "status",
        "volumeBackups",
    ]

    @field_validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(
            [
                "creating",
                "available",
                "deleting",
                "error",
                "restoring",
                "error_deleting",
                "backing up",
                "inconsistent",
                "error-creating",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('creating', 'available', 'deleting', 'error', 'restoring', 'error_deleting', 'backing up', 'inconsistent', 'error-creating')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Backup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in volume_backups (list)
        _items = []
        if self.volume_backups:
            for _item in self.volume_backups:
                if _item:
                    _items.append(_item.to_dict())
            _dict["volumeBackups"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Backup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "createdAt": obj.get("createdAt"),
                "expireAt": obj.get("expireAt"),
                "id": obj.get("id"),
                "lastRestoredAt": obj.get("lastRestoredAt"),
                "name": obj.get("name"),
                "size": obj.get("size"),
                "status": obj.get("status"),
                "volumeBackups": (
                    [BackupVolumeBackupsInner.from_dict(_item) for _item in obj["volumeBackups"]]
                    if obj.get("volumeBackups") is not None
                    else None
                ),
            }
        )
        return _obj
