# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'HelmReleaseSettingsArgs',
    'HelmReleaseSettingsArgsDict',
    'KubeClientSettingsArgs',
    'KubeClientSettingsArgsDict',
]

MYPY = False

if not MYPY:
    class HelmReleaseSettingsArgsDict(TypedDict):
        """
        Options to configure the Helm Release resource.
        """
        driver: NotRequired[pulumi.Input[builtins.str]]
        """
        The backend storage driver for Helm. Values are: configmap, secret, memory, sql.
        """
        plugins_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path to the helm plugins directory.
        """
        registry_config_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path to the registry config file.
        """
        repository_cache: NotRequired[pulumi.Input[builtins.str]]
        """
        The path to the directory containing cached repository indexes.
        """
        repository_config_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path to the file containing repository names and URLs.
        """
elif False:
    HelmReleaseSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HelmReleaseSettingsArgs:
    def __init__(__self__, *,
                 driver: Optional[pulumi.Input[builtins.str]] = None,
                 plugins_path: Optional[pulumi.Input[builtins.str]] = None,
                 registry_config_path: Optional[pulumi.Input[builtins.str]] = None,
                 repository_cache: Optional[pulumi.Input[builtins.str]] = None,
                 repository_config_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        Options to configure the Helm Release resource.
        :param pulumi.Input[builtins.str] driver: The backend storage driver for Helm. Values are: configmap, secret, memory, sql.
        :param pulumi.Input[builtins.str] plugins_path: The path to the helm plugins directory.
        :param pulumi.Input[builtins.str] registry_config_path: The path to the registry config file.
        :param pulumi.Input[builtins.str] repository_cache: The path to the directory containing cached repository indexes.
        :param pulumi.Input[builtins.str] repository_config_path: The path to the file containing repository names and URLs.
        """
        if driver is None:
            driver = _utilities.get_env('PULUMI_K8S_HELM_DRIVER')
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if plugins_path is None:
            plugins_path = _utilities.get_env('PULUMI_K8S_HELM_PLUGINS_PATH')
        if plugins_path is not None:
            pulumi.set(__self__, "plugins_path", plugins_path)
        if registry_config_path is None:
            registry_config_path = _utilities.get_env('PULUMI_K8S_HELM_REGISTRY_CONFIG_PATH')
        if registry_config_path is not None:
            pulumi.set(__self__, "registry_config_path", registry_config_path)
        if repository_cache is None:
            repository_cache = _utilities.get_env('PULUMI_K8S_HELM_REPOSITORY_CACHE')
        if repository_cache is not None:
            pulumi.set(__self__, "repository_cache", repository_cache)
        if repository_config_path is None:
            repository_config_path = _utilities.get_env('PULUMI_K8S_HELM_REPOSITORY_CONFIG_PATH')
        if repository_config_path is not None:
            pulumi.set(__self__, "repository_config_path", repository_config_path)

    @property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backend storage driver for Helm. Values are: configmap, secret, memory, sql.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter(name="pluginsPath")
    def plugins_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to the helm plugins directory.
        """
        return pulumi.get(self, "plugins_path")

    @plugins_path.setter
    def plugins_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plugins_path", value)

    @property
    @pulumi.getter(name="registryConfigPath")
    def registry_config_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to the registry config file.
        """
        return pulumi.get(self, "registry_config_path")

    @registry_config_path.setter
    def registry_config_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_config_path", value)

    @property
    @pulumi.getter(name="repositoryCache")
    def repository_cache(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to the directory containing cached repository indexes.
        """
        return pulumi.get(self, "repository_cache")

    @repository_cache.setter
    def repository_cache(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_cache", value)

    @property
    @pulumi.getter(name="repositoryConfigPath")
    def repository_config_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to the file containing repository names and URLs.
        """
        return pulumi.get(self, "repository_config_path")

    @repository_config_path.setter
    def repository_config_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_config_path", value)


if not MYPY:
    class KubeClientSettingsArgsDict(TypedDict):
        """
        Options for tuning the Kubernetes client used by a Provider.
        """
        burst: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum burst for throttle. Default value is 120.
        """
        qps: NotRequired[pulumi.Input[builtins.float]]
        """
        Maximum queries per second (QPS) to the API server from this client. Default value is 50.
        """
        timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum time in seconds to wait before cancelling a HTTP request to the Kubernetes server. Default value is 32.
        """
elif False:
    KubeClientSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KubeClientSettingsArgs:
    def __init__(__self__, *,
                 burst: Optional[pulumi.Input[builtins.int]] = None,
                 qps: Optional[pulumi.Input[builtins.float]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        Options for tuning the Kubernetes client used by a Provider.
        :param pulumi.Input[builtins.int] burst: Maximum burst for throttle. Default value is 120.
        :param pulumi.Input[builtins.float] qps: Maximum queries per second (QPS) to the API server from this client. Default value is 50.
        :param pulumi.Input[builtins.int] timeout: Maximum time in seconds to wait before cancelling a HTTP request to the Kubernetes server. Default value is 32.
        """
        if burst is None:
            burst = _utilities.get_env_int('PULUMI_K8S_CLIENT_BURST')
        if burst is not None:
            pulumi.set(__self__, "burst", burst)
        if qps is None:
            qps = _utilities.get_env_float('PULUMI_K8S_CLIENT_QPS')
        if qps is not None:
            pulumi.set(__self__, "qps", qps)
        if timeout is None:
            timeout = _utilities.get_env_int('PULUMI_K8S_CLIENT_TIMEOUT')
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def burst(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum burst for throttle. Default value is 120.
        """
        return pulumi.get(self, "burst")

    @burst.setter
    def burst(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "burst", value)

    @property
    @pulumi.getter
    def qps(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Maximum queries per second (QPS) to the API server from this client. Default value is 50.
        """
        return pulumi.get(self, "qps")

    @qps.setter
    def qps(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "qps", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum time in seconds to wait before cancelling a HTTP request to the Kubernetes server. Default value is 32.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)


