# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'ControllerRevisionArgs',
    'ControllerRevisionArgsDict',
    'DaemonSetConditionArgs',
    'DaemonSetConditionArgsDict',
    'DaemonSetSpecPatchArgs',
    'DaemonSetSpecPatchArgsDict',
    'DaemonSetSpecArgs',
    'DaemonSetSpecArgsDict',
    'DaemonSetStatusArgs',
    'DaemonSetStatusArgsDict',
    'DaemonSetUpdateStrategyPatchArgs',
    'DaemonSetUpdateStrategyPatchArgsDict',
    'DaemonSetUpdateStrategyArgs',
    'DaemonSetUpdateStrategyArgsDict',
    'DaemonSetArgs',
    'DaemonSetArgsDict',
    'DeploymentConditionArgs',
    'DeploymentConditionArgsDict',
    'DeploymentSpecPatchArgs',
    'DeploymentSpecPatchArgsDict',
    'DeploymentSpecArgs',
    'DeploymentSpecArgsDict',
    'DeploymentStatusArgs',
    'DeploymentStatusArgsDict',
    'DeploymentStrategyPatchArgs',
    'DeploymentStrategyPatchArgsDict',
    'DeploymentStrategyArgs',
    'DeploymentStrategyArgsDict',
    'DeploymentArgs',
    'DeploymentArgsDict',
    'ReplicaSetConditionArgs',
    'ReplicaSetConditionArgsDict',
    'ReplicaSetSpecPatchArgs',
    'ReplicaSetSpecPatchArgsDict',
    'ReplicaSetSpecArgs',
    'ReplicaSetSpecArgsDict',
    'ReplicaSetStatusArgs',
    'ReplicaSetStatusArgsDict',
    'ReplicaSetArgs',
    'ReplicaSetArgsDict',
    'RollingUpdateDaemonSetPatchArgs',
    'RollingUpdateDaemonSetPatchArgsDict',
    'RollingUpdateDaemonSetArgs',
    'RollingUpdateDaemonSetArgsDict',
    'RollingUpdateDeploymentPatchArgs',
    'RollingUpdateDeploymentPatchArgsDict',
    'RollingUpdateDeploymentArgs',
    'RollingUpdateDeploymentArgsDict',
    'RollingUpdateStatefulSetStrategyPatchArgs',
    'RollingUpdateStatefulSetStrategyPatchArgsDict',
    'RollingUpdateStatefulSetStrategyArgs',
    'RollingUpdateStatefulSetStrategyArgsDict',
    'StatefulSetConditionArgs',
    'StatefulSetConditionArgsDict',
    'StatefulSetOrdinalsPatchArgs',
    'StatefulSetOrdinalsPatchArgsDict',
    'StatefulSetOrdinalsArgs',
    'StatefulSetOrdinalsArgsDict',
    'StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgs',
    'StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgsDict',
    'StatefulSetPersistentVolumeClaimRetentionPolicyArgs',
    'StatefulSetPersistentVolumeClaimRetentionPolicyArgsDict',
    'StatefulSetSpecPatchArgs',
    'StatefulSetSpecPatchArgsDict',
    'StatefulSetSpecArgs',
    'StatefulSetSpecArgsDict',
    'StatefulSetStatusArgs',
    'StatefulSetStatusArgsDict',
    'StatefulSetUpdateStrategyPatchArgs',
    'StatefulSetUpdateStrategyPatchArgsDict',
    'StatefulSetUpdateStrategyArgs',
    'StatefulSetUpdateStrategyArgsDict',
    'StatefulSetArgs',
    'StatefulSetArgsDict',
]

MYPY = False

if not MYPY:
    class ControllerRevisionArgsDict(TypedDict):
        """
        ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
        """
        revision: pulumi.Input[builtins.int]
        """
        Revision indicates the revision of the state represented by Data.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        data: NotRequired[Any]
        """
        Data is the serialized representation of the state.
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
elif False:
    ControllerRevisionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ControllerRevisionArgs:
    def __init__(__self__, *,
                 revision: pulumi.Input[builtins.int],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 data: Optional[Any] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
        :param pulumi.Input[builtins.int] revision: Revision indicates the revision of the state represented by Data.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param Any data: Data is the serialized representation of the state.
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        pulumi.set(__self__, "revision", revision)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if data is not None:
            pulumi.set(__self__, "data", data)
        if kind is not None:
            pulumi.set(__self__, "kind", 'ControllerRevision')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def revision(self) -> pulumi.Input[builtins.int]:
        """
        Revision indicates the revision of the state represented by Data.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[Any]:
        """
        Data is the serialized representation of the state.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[Any]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class DaemonSetConditionArgsDict(TypedDict):
        """
        DaemonSetCondition describes the state of a DaemonSet at a certain point.
        """
        status: pulumi.Input[builtins.str]
        """
        Status of the condition, one of True, False, Unknown.
        """
        type: pulumi.Input[builtins.str]
        """
        Type of DaemonSet condition.
        """
        last_transition_time: NotRequired[pulumi.Input[builtins.str]]
        """
        Last time the condition transitioned from one status to another.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        A human readable message indicating details about the transition.
        """
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        The reason for the condition's last transition.
        """
elif False:
    DaemonSetConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DaemonSetConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 last_transition_time: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        DaemonSetCondition describes the state of a DaemonSet at a certain point.
        :param pulumi.Input[builtins.str] status: Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[builtins.str] type: Type of DaemonSet condition.
        :param pulumi.Input[builtins.str] last_transition_time: Last time the condition transitioned from one status to another.
        :param pulumi.Input[builtins.str] message: A human readable message indicating details about the transition.
        :param pulumi.Input[builtins.str] reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of DaemonSet condition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)


if not MYPY:
    class DaemonSetSpecPatchArgsDict(TypedDict):
        """
        DaemonSetSpec is the specification of a daemon set.
        """
        min_ready_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        """
        revision_history_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        selector: NotRequired[pulumi.Input['_meta.v1.LabelSelectorPatchArgsDict']]
        """
        A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        template: NotRequired[pulumi.Input['_core.v1.PodTemplateSpecPatchArgsDict']]
        """
        An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        update_strategy: NotRequired[pulumi.Input['DaemonSetUpdateStrategyPatchArgsDict']]
        """
        An update strategy to replace existing DaemonSet pods with new pods.
        """
elif False:
    DaemonSetSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DaemonSetSpecPatchArgs:
    def __init__(__self__, *,
                 min_ready_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 revision_history_limit: Optional[pulumi.Input[builtins.int]] = None,
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']] = None,
                 template: Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']] = None,
                 update_strategy: Optional[pulumi.Input['DaemonSetUpdateStrategyPatchArgs']] = None):
        """
        DaemonSetSpec is the specification of a daemon set.
        :param pulumi.Input[builtins.int] min_ready_seconds: The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        :param pulumi.Input[builtins.int] revision_history_limit: The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param pulumi.Input['_meta.v1.LabelSelectorPatchArgs'] selector: A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param pulumi.Input['_core.v1.PodTemplateSpecPatchArgs'] template: An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param pulumi.Input['DaemonSetUpdateStrategyPatchArgs'] update_strategy: An update strategy to replace existing DaemonSet pods with new pods.
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        """
        return pulumi.get(self, "min_ready_seconds")

    @min_ready_seconds.setter
    def min_ready_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_ready_seconds", value)

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @revision_history_limit.setter
    def revision_history_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "revision_history_limit", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]:
        """
        A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']]:
        """
        An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[pulumi.Input['DaemonSetUpdateStrategyPatchArgs']]:
        """
        An update strategy to replace existing DaemonSet pods with new pods.
        """
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input['DaemonSetUpdateStrategyPatchArgs']]):
        pulumi.set(self, "update_strategy", value)


if not MYPY:
    class DaemonSetSpecArgsDict(TypedDict):
        """
        DaemonSetSpec is the specification of a daemon set.
        """
        selector: pulumi.Input['_meta.v1.LabelSelectorArgsDict']
        """
        A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        template: pulumi.Input['_core.v1.PodTemplateSpecArgsDict']
        """
        An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        min_ready_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        """
        revision_history_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        update_strategy: NotRequired[pulumi.Input['DaemonSetUpdateStrategyArgsDict']]
        """
        An update strategy to replace existing DaemonSet pods with new pods.
        """
elif False:
    DaemonSetSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DaemonSetSpecArgs:
    def __init__(__self__, *,
                 selector: pulumi.Input['_meta.v1.LabelSelectorArgs'],
                 template: pulumi.Input['_core.v1.PodTemplateSpecArgs'],
                 min_ready_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 revision_history_limit: Optional[pulumi.Input[builtins.int]] = None,
                 update_strategy: Optional[pulumi.Input['DaemonSetUpdateStrategyArgs']] = None):
        """
        DaemonSetSpec is the specification of a daemon set.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param pulumi.Input['_core.v1.PodTemplateSpecArgs'] template: An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param pulumi.Input[builtins.int] min_ready_seconds: The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        :param pulumi.Input[builtins.int] revision_history_limit: The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param pulumi.Input['DaemonSetUpdateStrategyArgs'] update_strategy: An update strategy to replace existing DaemonSet pods with new pods.
        """
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Input['_meta.v1.LabelSelectorArgs']:
        """
        A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: pulumi.Input['_meta.v1.LabelSelectorArgs']):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['_core.v1.PodTemplateSpecArgs']:
        """
        An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['_core.v1.PodTemplateSpecArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        """
        return pulumi.get(self, "min_ready_seconds")

    @min_ready_seconds.setter
    def min_ready_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_ready_seconds", value)

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @revision_history_limit.setter
    def revision_history_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "revision_history_limit", value)

    @property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[pulumi.Input['DaemonSetUpdateStrategyArgs']]:
        """
        An update strategy to replace existing DaemonSet pods with new pods.
        """
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input['DaemonSetUpdateStrategyArgs']]):
        pulumi.set(self, "update_strategy", value)


if not MYPY:
    class DaemonSetStatusArgsDict(TypedDict):
        """
        DaemonSetStatus represents the current status of a daemon set.
        """
        current_number_scheduled: pulumi.Input[builtins.int]
        """
        The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        desired_number_scheduled: pulumi.Input[builtins.int]
        """
        The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        number_misscheduled: pulumi.Input[builtins.int]
        """
        The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        number_ready: pulumi.Input[builtins.int]
        """
        numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.
        """
        collision_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['DaemonSetConditionArgsDict']]]]
        """
        Represents the latest available observations of a DaemonSet's current state.
        """
        number_available: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        number_unavailable: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        observed_generation: NotRequired[pulumi.Input[builtins.int]]
        """
        The most recent generation observed by the daemon set controller.
        """
        updated_number_scheduled: NotRequired[pulumi.Input[builtins.int]]
        """
        The total number of nodes that are running updated daemon pod
        """
elif False:
    DaemonSetStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DaemonSetStatusArgs:
    def __init__(__self__, *,
                 current_number_scheduled: pulumi.Input[builtins.int],
                 desired_number_scheduled: pulumi.Input[builtins.int],
                 number_misscheduled: pulumi.Input[builtins.int],
                 number_ready: pulumi.Input[builtins.int],
                 collision_count: Optional[pulumi.Input[builtins.int]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['DaemonSetConditionArgs']]]] = None,
                 number_available: Optional[pulumi.Input[builtins.int]] = None,
                 number_unavailable: Optional[pulumi.Input[builtins.int]] = None,
                 observed_generation: Optional[pulumi.Input[builtins.int]] = None,
                 updated_number_scheduled: Optional[pulumi.Input[builtins.int]] = None):
        """
        DaemonSetStatus represents the current status of a daemon set.
        :param pulumi.Input[builtins.int] current_number_scheduled: The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param pulumi.Input[builtins.int] desired_number_scheduled: The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param pulumi.Input[builtins.int] number_misscheduled: The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param pulumi.Input[builtins.int] number_ready: numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.
        :param pulumi.Input[builtins.int] collision_count: Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param pulumi.Input[Sequence[pulumi.Input['DaemonSetConditionArgs']]] conditions: Represents the latest available observations of a DaemonSet's current state.
        :param pulumi.Input[builtins.int] number_available: The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param pulumi.Input[builtins.int] number_unavailable: The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param pulumi.Input[builtins.int] observed_generation: The most recent generation observed by the daemon set controller.
        :param pulumi.Input[builtins.int] updated_number_scheduled: The total number of nodes that are running updated daemon pod
        """
        pulumi.set(__self__, "current_number_scheduled", current_number_scheduled)
        pulumi.set(__self__, "desired_number_scheduled", desired_number_scheduled)
        pulumi.set(__self__, "number_misscheduled", number_misscheduled)
        pulumi.set(__self__, "number_ready", number_ready)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if number_available is not None:
            pulumi.set(__self__, "number_available", number_available)
        if number_unavailable is not None:
            pulumi.set(__self__, "number_unavailable", number_unavailable)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if updated_number_scheduled is not None:
            pulumi.set(__self__, "updated_number_scheduled", updated_number_scheduled)

    @property
    @pulumi.getter(name="currentNumberScheduled")
    def current_number_scheduled(self) -> pulumi.Input[builtins.int]:
        """
        The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "current_number_scheduled")

    @current_number_scheduled.setter
    def current_number_scheduled(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "current_number_scheduled", value)

    @property
    @pulumi.getter(name="desiredNumberScheduled")
    def desired_number_scheduled(self) -> pulumi.Input[builtins.int]:
        """
        The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "desired_number_scheduled")

    @desired_number_scheduled.setter
    def desired_number_scheduled(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "desired_number_scheduled", value)

    @property
    @pulumi.getter(name="numberMisscheduled")
    def number_misscheduled(self) -> pulumi.Input[builtins.int]:
        """
        The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "number_misscheduled")

    @number_misscheduled.setter
    def number_misscheduled(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "number_misscheduled", value)

    @property
    @pulumi.getter(name="numberReady")
    def number_ready(self) -> pulumi.Input[builtins.int]:
        """
        numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.
        """
        return pulumi.get(self, "number_ready")

    @number_ready.setter
    def number_ready(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "number_ready", value)

    @property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @collision_count.setter
    def collision_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "collision_count", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DaemonSetConditionArgs']]]]:
        """
        Represents the latest available observations of a DaemonSet's current state.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DaemonSetConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="numberAvailable")
    def number_available(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_available")

    @number_available.setter
    def number_available(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_available", value)

    @property
    @pulumi.getter(name="numberUnavailable")
    def number_unavailable(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_unavailable")

    @number_unavailable.setter
    def number_unavailable(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_unavailable", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The most recent generation observed by the daemon set controller.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter(name="updatedNumberScheduled")
    def updated_number_scheduled(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The total number of nodes that are running updated daemon pod
        """
        return pulumi.get(self, "updated_number_scheduled")

    @updated_number_scheduled.setter
    def updated_number_scheduled(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "updated_number_scheduled", value)


if not MYPY:
    class DaemonSetUpdateStrategyPatchArgsDict(TypedDict):
        """
        DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
        """
        rolling_update: NotRequired[pulumi.Input['RollingUpdateDaemonSetPatchArgsDict']]
        """
        Rolling update config params. Present only if type = "RollingUpdate".
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
elif False:
    DaemonSetUpdateStrategyPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DaemonSetUpdateStrategyPatchArgs:
    def __init__(__self__, *,
                 rolling_update: Optional[pulumi.Input['RollingUpdateDaemonSetPatchArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
        :param pulumi.Input['RollingUpdateDaemonSetPatchArgs'] rolling_update: Rolling update config params. Present only if type = "RollingUpdate".
        :param pulumi.Input[builtins.str] type: Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional[pulumi.Input['RollingUpdateDaemonSetPatchArgs']]:
        """
        Rolling update config params. Present only if type = "RollingUpdate".
        """
        return pulumi.get(self, "rolling_update")

    @rolling_update.setter
    def rolling_update(self, value: Optional[pulumi.Input['RollingUpdateDaemonSetPatchArgs']]):
        pulumi.set(self, "rolling_update", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class DaemonSetUpdateStrategyArgsDict(TypedDict):
        """
        DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
        """
        rolling_update: NotRequired[pulumi.Input['RollingUpdateDaemonSetArgsDict']]
        """
        Rolling update config params. Present only if type = "RollingUpdate".
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
elif False:
    DaemonSetUpdateStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DaemonSetUpdateStrategyArgs:
    def __init__(__self__, *,
                 rolling_update: Optional[pulumi.Input['RollingUpdateDaemonSetArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
        :param pulumi.Input['RollingUpdateDaemonSetArgs'] rolling_update: Rolling update config params. Present only if type = "RollingUpdate".
        :param pulumi.Input[builtins.str] type: Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional[pulumi.Input['RollingUpdateDaemonSetArgs']]:
        """
        Rolling update config params. Present only if type = "RollingUpdate".
        """
        return pulumi.get(self, "rolling_update")

    @rolling_update.setter
    def rolling_update(self, value: Optional[pulumi.Input['RollingUpdateDaemonSetArgs']]):
        pulumi.set(self, "rolling_update", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class DaemonSetArgsDict(TypedDict):
        """
        DaemonSet represents the configuration of a daemon set.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        spec: NotRequired[pulumi.Input['DaemonSetSpecArgsDict']]
        """
        The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        status: NotRequired[pulumi.Input['DaemonSetStatusArgsDict']]
        """
        The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
elif False:
    DaemonSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DaemonSetArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['DaemonSetSpecArgs']] = None,
                 status: Optional[pulumi.Input['DaemonSetStatusArgs']] = None):
        """
        DaemonSet represents the configuration of a daemon set.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['DaemonSetSpecArgs'] spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['DaemonSetStatusArgs'] status: The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'DaemonSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['DaemonSetSpecArgs']]:
        """
        The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['DaemonSetSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['DaemonSetStatusArgs']]:
        """
        The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['DaemonSetStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class DeploymentConditionArgsDict(TypedDict):
        """
        DeploymentCondition describes the state of a deployment at a certain point.
        """
        status: pulumi.Input[builtins.str]
        """
        Status of the condition, one of True, False, Unknown.
        """
        type: pulumi.Input[builtins.str]
        """
        Type of deployment condition.
        """
        last_transition_time: NotRequired[pulumi.Input[builtins.str]]
        """
        Last time the condition transitioned from one status to another.
        """
        last_update_time: NotRequired[pulumi.Input[builtins.str]]
        """
        The last time this condition was updated.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        A human readable message indicating details about the transition.
        """
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        The reason for the condition's last transition.
        """
elif False:
    DeploymentConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 last_transition_time: Optional[pulumi.Input[builtins.str]] = None,
                 last_update_time: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        DeploymentCondition describes the state of a deployment at a certain point.
        :param pulumi.Input[builtins.str] status: Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[builtins.str] type: Type of deployment condition.
        :param pulumi.Input[builtins.str] last_transition_time: Last time the condition transitioned from one status to another.
        :param pulumi.Input[builtins.str] last_update_time: The last time this condition was updated.
        :param pulumi.Input[builtins.str] message: A human readable message indicating details about the transition.
        :param pulumi.Input[builtins.str] reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of deployment condition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last time this condition was updated.
        """
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_update_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)


if not MYPY:
    class DeploymentSpecPatchArgsDict(TypedDict):
        """
        DeploymentSpec is the specification of the desired behavior of the Deployment.
        """
        min_ready_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        paused: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates that the deployment is paused.
        """
        progress_deadline_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        """
        replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        """
        revision_history_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        selector: NotRequired[pulumi.Input['_meta.v1.LabelSelectorPatchArgsDict']]
        """
        Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        """
        strategy: NotRequired[pulumi.Input['DeploymentStrategyPatchArgsDict']]
        """
        The deployment strategy to use to replace existing pods with new ones.
        """
        template: NotRequired[pulumi.Input['_core.v1.PodTemplateSpecPatchArgsDict']]
        """
        Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        """
elif False:
    DeploymentSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSpecPatchArgs:
    def __init__(__self__, *,
                 min_ready_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 paused: Optional[pulumi.Input[builtins.bool]] = None,
                 progress_deadline_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 replicas: Optional[pulumi.Input[builtins.int]] = None,
                 revision_history_limit: Optional[pulumi.Input[builtins.int]] = None,
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']] = None,
                 strategy: Optional[pulumi.Input['DeploymentStrategyPatchArgs']] = None,
                 template: Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']] = None):
        """
        DeploymentSpec is the specification of the desired behavior of the Deployment.
        :param pulumi.Input[builtins.int] min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param pulumi.Input[builtins.bool] paused: Indicates that the deployment is paused.
        :param pulumi.Input[builtins.int] progress_deadline_seconds: The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        :param pulumi.Input[builtins.int] replicas: Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        :param pulumi.Input[builtins.int] revision_history_limit: The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param pulumi.Input['_meta.v1.LabelSelectorPatchArgs'] selector: Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        :param pulumi.Input['DeploymentStrategyPatchArgs'] strategy: The deployment strategy to use to replace existing pods with new ones.
        :param pulumi.Input['_core.v1.PodTemplateSpecPatchArgs'] template: Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if progress_deadline_seconds is not None:
            pulumi.set(__self__, "progress_deadline_seconds", progress_deadline_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @min_ready_seconds.setter
    def min_ready_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_ready_seconds", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates that the deployment is paused.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter(name="progressDeadlineSeconds")
    def progress_deadline_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        """
        return pulumi.get(self, "progress_deadline_seconds")

    @progress_deadline_seconds.setter
    def progress_deadline_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "progress_deadline_seconds", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @revision_history_limit.setter
    def revision_history_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "revision_history_limit", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]:
        """
        Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input['DeploymentStrategyPatchArgs']]:
        """
        The deployment strategy to use to replace existing pods with new ones.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input['DeploymentStrategyPatchArgs']]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']]:
        """
        Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']]):
        pulumi.set(self, "template", value)


if not MYPY:
    class DeploymentSpecArgsDict(TypedDict):
        """
        DeploymentSpec is the specification of the desired behavior of the Deployment.
        """
        selector: pulumi.Input['_meta.v1.LabelSelectorArgsDict']
        """
        Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        """
        template: pulumi.Input['_core.v1.PodTemplateSpecArgsDict']
        """
        Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        """
        min_ready_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        paused: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates that the deployment is paused.
        """
        progress_deadline_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        """
        replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        """
        revision_history_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        strategy: NotRequired[pulumi.Input['DeploymentStrategyArgsDict']]
        """
        The deployment strategy to use to replace existing pods with new ones.
        """
elif False:
    DeploymentSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSpecArgs:
    def __init__(__self__, *,
                 selector: pulumi.Input['_meta.v1.LabelSelectorArgs'],
                 template: pulumi.Input['_core.v1.PodTemplateSpecArgs'],
                 min_ready_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 paused: Optional[pulumi.Input[builtins.bool]] = None,
                 progress_deadline_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 replicas: Optional[pulumi.Input[builtins.int]] = None,
                 revision_history_limit: Optional[pulumi.Input[builtins.int]] = None,
                 strategy: Optional[pulumi.Input['DeploymentStrategyArgs']] = None):
        """
        DeploymentSpec is the specification of the desired behavior of the Deployment.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        :param pulumi.Input['_core.v1.PodTemplateSpecArgs'] template: Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        :param pulumi.Input[builtins.int] min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param pulumi.Input[builtins.bool] paused: Indicates that the deployment is paused.
        :param pulumi.Input[builtins.int] progress_deadline_seconds: The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        :param pulumi.Input[builtins.int] replicas: Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        :param pulumi.Input[builtins.int] revision_history_limit: The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param pulumi.Input['DeploymentStrategyArgs'] strategy: The deployment strategy to use to replace existing pods with new ones.
        """
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if progress_deadline_seconds is not None:
            pulumi.set(__self__, "progress_deadline_seconds", progress_deadline_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Input['_meta.v1.LabelSelectorArgs']:
        """
        Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: pulumi.Input['_meta.v1.LabelSelectorArgs']):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['_core.v1.PodTemplateSpecArgs']:
        """
        Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['_core.v1.PodTemplateSpecArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @min_ready_seconds.setter
    def min_ready_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_ready_seconds", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates that the deployment is paused.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter(name="progressDeadlineSeconds")
    def progress_deadline_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        """
        return pulumi.get(self, "progress_deadline_seconds")

    @progress_deadline_seconds.setter
    def progress_deadline_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "progress_deadline_seconds", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @revision_history_limit.setter
    def revision_history_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "revision_history_limit", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input['DeploymentStrategyArgs']]:
        """
        The deployment strategy to use to replace existing pods with new ones.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input['DeploymentStrategyArgs']]):
        pulumi.set(self, "strategy", value)


if not MYPY:
    class DeploymentStatusArgsDict(TypedDict):
        """
        DeploymentStatus is the most recently observed status of the Deployment.
        """
        available_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.
        """
        collision_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeploymentConditionArgsDict']]]]
        """
        Represents the latest available observations of a deployment's current state.
        """
        observed_generation: NotRequired[pulumi.Input[builtins.int]]
        """
        The generation observed by the deployment controller.
        """
        ready_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Total number of non-terminating pods targeted by this Deployment with a Ready Condition.
        """
        replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Total number of non-terminating pods targeted by this deployment (their labels match the selector).
        """
        terminating_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.

        This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        unavailable_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        """
        updated_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Total number of non-terminating pods targeted by this deployment that have the desired template spec.
        """
elif False:
    DeploymentStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentStatusArgs:
    def __init__(__self__, *,
                 available_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 collision_count: Optional[pulumi.Input[builtins.int]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentConditionArgs']]]] = None,
                 observed_generation: Optional[pulumi.Input[builtins.int]] = None,
                 ready_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 replicas: Optional[pulumi.Input[builtins.int]] = None,
                 terminating_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 unavailable_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 updated_replicas: Optional[pulumi.Input[builtins.int]] = None):
        """
        DeploymentStatus is the most recently observed status of the Deployment.
        :param pulumi.Input[builtins.int] available_replicas: Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.
        :param pulumi.Input[builtins.int] collision_count: Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentConditionArgs']]] conditions: Represents the latest available observations of a deployment's current state.
        :param pulumi.Input[builtins.int] observed_generation: The generation observed by the deployment controller.
        :param pulumi.Input[builtins.int] ready_replicas: Total number of non-terminating pods targeted by this Deployment with a Ready Condition.
        :param pulumi.Input[builtins.int] replicas: Total number of non-terminating pods targeted by this deployment (their labels match the selector).
        :param pulumi.Input[builtins.int] terminating_replicas: Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.
               
               This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        :param pulumi.Input[builtins.int] unavailable_replicas: Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        :param pulumi.Input[builtins.int] updated_replicas: Total number of non-terminating pods targeted by this deployment that have the desired template spec.
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if terminating_replicas is not None:
            pulumi.set(__self__, "terminating_replicas", terminating_replicas)
        if unavailable_replicas is not None:
            pulumi.set(__self__, "unavailable_replicas", unavailable_replicas)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.
        """
        return pulumi.get(self, "available_replicas")

    @available_replicas.setter
    def available_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "available_replicas", value)

    @property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        """
        return pulumi.get(self, "collision_count")

    @collision_count.setter
    def collision_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "collision_count", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentConditionArgs']]]]:
        """
        Represents the latest available observations of a deployment's current state.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The generation observed by the deployment controller.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of non-terminating pods targeted by this Deployment with a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @ready_replicas.setter
    def ready_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ready_replicas", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of non-terminating pods targeted by this deployment (their labels match the selector).
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="terminatingReplicas")
    def terminating_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.

        This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        return pulumi.get(self, "terminating_replicas")

    @terminating_replicas.setter
    def terminating_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "terminating_replicas", value)

    @property
    @pulumi.getter(name="unavailableReplicas")
    def unavailable_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        """
        return pulumi.get(self, "unavailable_replicas")

    @unavailable_replicas.setter
    def unavailable_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "unavailable_replicas", value)

    @property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of non-terminating pods targeted by this deployment that have the desired template spec.
        """
        return pulumi.get(self, "updated_replicas")

    @updated_replicas.setter
    def updated_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "updated_replicas", value)


if not MYPY:
    class DeploymentStrategyPatchArgsDict(TypedDict):
        """
        DeploymentStrategy describes how to replace existing pods with new ones.
        """
        rolling_update: NotRequired[pulumi.Input['RollingUpdateDeploymentPatchArgsDict']]
        """
        Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
elif False:
    DeploymentStrategyPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentStrategyPatchArgs:
    def __init__(__self__, *,
                 rolling_update: Optional[pulumi.Input['RollingUpdateDeploymentPatchArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        DeploymentStrategy describes how to replace existing pods with new ones.
        :param pulumi.Input['RollingUpdateDeploymentPatchArgs'] rolling_update: Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param pulumi.Input[builtins.str] type: Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional[pulumi.Input['RollingUpdateDeploymentPatchArgs']]:
        """
        Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        """
        return pulumi.get(self, "rolling_update")

    @rolling_update.setter
    def rolling_update(self, value: Optional[pulumi.Input['RollingUpdateDeploymentPatchArgs']]):
        pulumi.set(self, "rolling_update", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class DeploymentStrategyArgsDict(TypedDict):
        """
        DeploymentStrategy describes how to replace existing pods with new ones.
        """
        rolling_update: NotRequired[pulumi.Input['RollingUpdateDeploymentArgsDict']]
        """
        Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
elif False:
    DeploymentStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentStrategyArgs:
    def __init__(__self__, *,
                 rolling_update: Optional[pulumi.Input['RollingUpdateDeploymentArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        DeploymentStrategy describes how to replace existing pods with new ones.
        :param pulumi.Input['RollingUpdateDeploymentArgs'] rolling_update: Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param pulumi.Input[builtins.str] type: Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional[pulumi.Input['RollingUpdateDeploymentArgs']]:
        """
        Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        """
        return pulumi.get(self, "rolling_update")

    @rolling_update.setter
    def rolling_update(self, value: Optional[pulumi.Input['RollingUpdateDeploymentArgs']]):
        pulumi.set(self, "rolling_update", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class DeploymentArgsDict(TypedDict):
        """
        Deployment enables declarative updates for Pods and ReplicaSets.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The Deployment has begun to be updated by the Deployment controller. If the current
           generation of the Deployment is > 1, then this means that the current generation must
           be different from the generation reported by the last outputs.
        2. There exists a ReplicaSet whose revision is equal to the current revision of the
           Deployment.
        3. The Deployment's '.status.conditions' has a status of type 'Available' whose 'status'
           member is set to 'True'.
        4. If the Deployment has generation > 1, then '.status.conditions' has a status of type
           'Progressing', whose 'status' member is set to 'True', and whose 'reason' is
           'NewReplicaSetAvailable'. For generation <= 1, this status field does not exist,
           because it doesn't do a rollout (i.e., it simply creates the Deployment and
           corresponding ReplicaSet), and therefore there is no rollout to mark as 'Progressing'.

        If the Deployment has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        spec: NotRequired[pulumi.Input['DeploymentSpecArgsDict']]
        """
        Specification of the desired behavior of the Deployment.
        """
        status: NotRequired[pulumi.Input['DeploymentStatusArgsDict']]
        """
        Most recently observed status of the Deployment.
        """
elif False:
    DeploymentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['DeploymentSpecArgs']] = None,
                 status: Optional[pulumi.Input['DeploymentStatusArgs']] = None):
        """
        Deployment enables declarative updates for Pods and ReplicaSets.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The Deployment has begun to be updated by the Deployment controller. If the current
           generation of the Deployment is > 1, then this means that the current generation must
           be different from the generation reported by the last outputs.
        2. There exists a ReplicaSet whose revision is equal to the current revision of the
           Deployment.
        3. The Deployment's '.status.conditions' has a status of type 'Available' whose 'status'
           member is set to 'True'.
        4. If the Deployment has generation > 1, then '.status.conditions' has a status of type
           'Progressing', whose 'status' member is set to 'True', and whose 'reason' is
           'NewReplicaSetAvailable'. For generation <= 1, this status field does not exist,
           because it doesn't do a rollout (i.e., it simply creates the Deployment and
           corresponding ReplicaSet), and therefore there is no rollout to mark as 'Progressing'.

        If the Deployment has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['DeploymentSpecArgs'] spec: Specification of the desired behavior of the Deployment.
        :param pulumi.Input['DeploymentStatusArgs'] status: Most recently observed status of the Deployment.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Deployment')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['DeploymentSpecArgs']]:
        """
        Specification of the desired behavior of the Deployment.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['DeploymentSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['DeploymentStatusArgs']]:
        """
        Most recently observed status of the Deployment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['DeploymentStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ReplicaSetConditionArgsDict(TypedDict):
        """
        ReplicaSetCondition describes the state of a replica set at a certain point.
        """
        status: pulumi.Input[builtins.str]
        """
        Status of the condition, one of True, False, Unknown.
        """
        type: pulumi.Input[builtins.str]
        """
        Type of replica set condition.
        """
        last_transition_time: NotRequired[pulumi.Input[builtins.str]]
        """
        The last time the condition transitioned from one status to another.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        A human readable message indicating details about the transition.
        """
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        The reason for the condition's last transition.
        """
elif False:
    ReplicaSetConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicaSetConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 last_transition_time: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        ReplicaSetCondition describes the state of a replica set at a certain point.
        :param pulumi.Input[builtins.str] status: Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[builtins.str] type: Type of replica set condition.
        :param pulumi.Input[builtins.str] last_transition_time: The last time the condition transitioned from one status to another.
        :param pulumi.Input[builtins.str] message: A human readable message indicating details about the transition.
        :param pulumi.Input[builtins.str] reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of replica set condition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)


if not MYPY:
    class ReplicaSetSpecPatchArgsDict(TypedDict):
        """
        ReplicaSetSpec is the specification of a ReplicaSet.
        """
        min_ready_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        selector: NotRequired[pulumi.Input['_meta.v1.LabelSelectorPatchArgsDict']]
        """
        Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        template: NotRequired[pulumi.Input['_core.v1.PodTemplateSpecPatchArgsDict']]
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
elif False:
    ReplicaSetSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicaSetSpecPatchArgs:
    def __init__(__self__, *,
                 min_ready_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 replicas: Optional[pulumi.Input[builtins.int]] = None,
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']] = None,
                 template: Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']] = None):
        """
        ReplicaSetSpec is the specification of a ReplicaSet.
        :param pulumi.Input[builtins.int] min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param pulumi.Input[builtins.int] replicas: Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        :param pulumi.Input['_meta.v1.LabelSelectorPatchArgs'] selector: Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param pulumi.Input['_core.v1.PodTemplateSpecPatchArgs'] template: Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @min_ready_seconds.setter
    def min_ready_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_ready_seconds", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]:
        """
        Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']]:
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']]):
        pulumi.set(self, "template", value)


if not MYPY:
    class ReplicaSetSpecArgsDict(TypedDict):
        """
        ReplicaSetSpec is the specification of a ReplicaSet.
        """
        selector: pulumi.Input['_meta.v1.LabelSelectorArgsDict']
        """
        Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        min_ready_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        template: NotRequired[pulumi.Input['_core.v1.PodTemplateSpecArgsDict']]
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
elif False:
    ReplicaSetSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicaSetSpecArgs:
    def __init__(__self__, *,
                 selector: pulumi.Input['_meta.v1.LabelSelectorArgs'],
                 min_ready_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 replicas: Optional[pulumi.Input[builtins.int]] = None,
                 template: Optional[pulumi.Input['_core.v1.PodTemplateSpecArgs']] = None):
        """
        ReplicaSetSpec is the specification of a ReplicaSet.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param pulumi.Input[builtins.int] min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param pulumi.Input[builtins.int] replicas: Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        :param pulumi.Input['_core.v1.PodTemplateSpecArgs'] template: Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
        pulumi.set(__self__, "selector", selector)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Input['_meta.v1.LabelSelectorArgs']:
        """
        Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: pulumi.Input['_meta.v1.LabelSelectorArgs']):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @min_ready_seconds.setter
    def min_ready_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_ready_seconds", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['_core.v1.PodTemplateSpecArgs']]:
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['_core.v1.PodTemplateSpecArgs']]):
        pulumi.set(self, "template", value)


if not MYPY:
    class ReplicaSetStatusArgsDict(TypedDict):
        """
        ReplicaSetStatus represents the current status of a ReplicaSet.
        """
        replicas: pulumi.Input[builtins.int]
        """
        Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        available_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicaSetConditionArgsDict']]]]
        """
        Represents the latest available observations of a replica set's current state.
        """
        fully_labeled_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.
        """
        observed_generation: NotRequired[pulumi.Input[builtins.int]]
        """
        ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        """
        ready_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.
        """
        terminating_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.

        This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
elif False:
    ReplicaSetStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicaSetStatusArgs:
    def __init__(__self__, *,
                 replicas: pulumi.Input[builtins.int],
                 available_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaSetConditionArgs']]]] = None,
                 fully_labeled_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 observed_generation: Optional[pulumi.Input[builtins.int]] = None,
                 ready_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 terminating_replicas: Optional[pulumi.Input[builtins.int]] = None):
        """
        ReplicaSetStatus represents the current status of a ReplicaSet.
        :param pulumi.Input[builtins.int] replicas: Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        :param pulumi.Input[builtins.int] available_replicas: The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicaSetConditionArgs']]] conditions: Represents the latest available observations of a replica set's current state.
        :param pulumi.Input[builtins.int] fully_labeled_replicas: The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.
        :param pulumi.Input[builtins.int] observed_generation: ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        :param pulumi.Input[builtins.int] ready_replicas: The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.
        :param pulumi.Input[builtins.int] terminating_replicas: The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.
               
               This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        pulumi.set(__self__, "replicas", replicas)
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if fully_labeled_replicas is not None:
            pulumi.set(__self__, "fully_labeled_replicas", fully_labeled_replicas)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if terminating_replicas is not None:
            pulumi.set(__self__, "terminating_replicas", terminating_replicas)

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Input[builtins.int]:
        """
        Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.
        """
        return pulumi.get(self, "available_replicas")

    @available_replicas.setter
    def available_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "available_replicas", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaSetConditionArgs']]]]:
        """
        Represents the latest available observations of a replica set's current state.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaSetConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="fullyLabeledReplicas")
    def fully_labeled_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.
        """
        return pulumi.get(self, "fully_labeled_replicas")

    @fully_labeled_replicas.setter
    def fully_labeled_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "fully_labeled_replicas", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @ready_replicas.setter
    def ready_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ready_replicas", value)

    @property
    @pulumi.getter(name="terminatingReplicas")
    def terminating_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.

        This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        return pulumi.get(self, "terminating_replicas")

    @terminating_replicas.setter
    def terminating_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "terminating_replicas", value)


if not MYPY:
    class ReplicaSetArgsDict(TypedDict):
        """
        ReplicaSet ensures that a specified number of pod replicas are running at any given time.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        spec: NotRequired[pulumi.Input['ReplicaSetSpecArgsDict']]
        """
        Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        status: NotRequired[pulumi.Input['ReplicaSetStatusArgsDict']]
        """
        Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
elif False:
    ReplicaSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicaSetArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['ReplicaSetSpecArgs']] = None,
                 status: Optional[pulumi.Input['ReplicaSetStatusArgs']] = None):
        """
        ReplicaSet ensures that a specified number of pod replicas are running at any given time.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['ReplicaSetSpecArgs'] spec: Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['ReplicaSetStatusArgs'] status: Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ReplicaSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['ReplicaSetSpecArgs']]:
        """
        Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['ReplicaSetSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ReplicaSetStatusArgs']]:
        """
        Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ReplicaSetStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class RollingUpdateDaemonSetPatchArgsDict(TypedDict):
        """
        Spec to control the desired behavior of daemon set rolling update.
        """
        max_surge: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        """
        max_unavailable: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
elif False:
    RollingUpdateDaemonSetPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RollingUpdateDaemonSetPatchArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None,
                 max_unavailable: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None):
        """
        Spec to control the desired behavior of daemon set rolling update.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_surge: The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_unavailable: The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_surge", value)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_unavailable", value)


if not MYPY:
    class RollingUpdateDaemonSetArgsDict(TypedDict):
        """
        Spec to control the desired behavior of daemon set rolling update.
        """
        max_surge: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        """
        max_unavailable: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
elif False:
    RollingUpdateDaemonSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RollingUpdateDaemonSetArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None,
                 max_unavailable: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None):
        """
        Spec to control the desired behavior of daemon set rolling update.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_surge: The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_unavailable: The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_surge", value)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_unavailable", value)


if not MYPY:
    class RollingUpdateDeploymentPatchArgsDict(TypedDict):
        """
        Spec to control the desired behavior of rolling update.
        """
        max_surge: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        """
        max_unavailable: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
elif False:
    RollingUpdateDeploymentPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RollingUpdateDeploymentPatchArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None,
                 max_unavailable: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None):
        """
        Spec to control the desired behavior of rolling update.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_surge", value)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_unavailable", value)


if not MYPY:
    class RollingUpdateDeploymentArgsDict(TypedDict):
        """
        Spec to control the desired behavior of rolling update.
        """
        max_surge: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        """
        max_unavailable: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
elif False:
    RollingUpdateDeploymentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RollingUpdateDeploymentArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None,
                 max_unavailable: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None):
        """
        Spec to control the desired behavior of rolling update.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_surge", value)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_unavailable", value)


if not MYPY:
    class RollingUpdateStatefulSetStrategyPatchArgsDict(TypedDict):
        """
        RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
        """
        max_unavailable: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        """
        partition: NotRequired[pulumi.Input[builtins.int]]
        """
        Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
elif False:
    RollingUpdateStatefulSetStrategyPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RollingUpdateStatefulSetStrategyPatchArgs:
    def __init__(__self__, *,
                 max_unavailable: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None,
                 partition: Optional[pulumi.Input[builtins.int]] = None):
        """
        RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        :param pulumi.Input[builtins.int] partition: Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_unavailable", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "partition", value)


if not MYPY:
    class RollingUpdateStatefulSetStrategyArgsDict(TypedDict):
        """
        RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
        """
        max_unavailable: NotRequired[pulumi.Input[Union[builtins.int, builtins.str]]]
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        """
        partition: NotRequired[pulumi.Input[builtins.int]]
        """
        Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
elif False:
    RollingUpdateStatefulSetStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RollingUpdateStatefulSetStrategyArgs:
    def __init__(__self__, *,
                 max_unavailable: Optional[pulumi.Input[Union[builtins.int, builtins.str]]] = None,
                 partition: Optional[pulumi.Input[builtins.int]] = None):
        """
        RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
        :param pulumi.Input[Union[builtins.int, builtins.str]] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        :param pulumi.Input[builtins.int] partition: Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[Union[builtins.int, builtins.str]]]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[Union[builtins.int, builtins.str]]]):
        pulumi.set(self, "max_unavailable", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "partition", value)


if not MYPY:
    class StatefulSetConditionArgsDict(TypedDict):
        """
        StatefulSetCondition describes the state of a statefulset at a certain point.
        """
        status: pulumi.Input[builtins.str]
        """
        Status of the condition, one of True, False, Unknown.
        """
        type: pulumi.Input[builtins.str]
        """
        Type of statefulset condition.
        """
        last_transition_time: NotRequired[pulumi.Input[builtins.str]]
        """
        Last time the condition transitioned from one status to another.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        A human readable message indicating details about the transition.
        """
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        The reason for the condition's last transition.
        """
elif False:
    StatefulSetConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 last_transition_time: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        StatefulSetCondition describes the state of a statefulset at a certain point.
        :param pulumi.Input[builtins.str] status: Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[builtins.str] type: Type of statefulset condition.
        :param pulumi.Input[builtins.str] last_transition_time: Last time the condition transitioned from one status to another.
        :param pulumi.Input[builtins.str] message: A human readable message indicating details about the transition.
        :param pulumi.Input[builtins.str] reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of statefulset condition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)


if not MYPY:
    class StatefulSetOrdinalsPatchArgsDict(TypedDict):
        """
        StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.
        """
        start: NotRequired[pulumi.Input[builtins.int]]
        """
        start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
          [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
        If unset, defaults to 0. Replica indices will be in the range:
          [0, .spec.replicas).
        """
elif False:
    StatefulSetOrdinalsPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetOrdinalsPatchArgs:
    def __init__(__self__, *,
                 start: Optional[pulumi.Input[builtins.int]] = None):
        """
        StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.
        :param pulumi.Input[builtins.int] start: start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
                 [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
               If unset, defaults to 0. Replica indices will be in the range:
                 [0, .spec.replicas).
        """
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
          [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
        If unset, defaults to 0. Replica indices will be in the range:
          [0, .spec.replicas).
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start", value)


if not MYPY:
    class StatefulSetOrdinalsArgsDict(TypedDict):
        """
        StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.
        """
        start: NotRequired[pulumi.Input[builtins.int]]
        """
        start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
          [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
        If unset, defaults to 0. Replica indices will be in the range:
          [0, .spec.replicas).
        """
elif False:
    StatefulSetOrdinalsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetOrdinalsArgs:
    def __init__(__self__, *,
                 start: Optional[pulumi.Input[builtins.int]] = None):
        """
        StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.
        :param pulumi.Input[builtins.int] start: start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
                 [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
               If unset, defaults to 0. Replica indices will be in the range:
                 [0, .spec.replicas).
        """
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
          [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
        If unset, defaults to 0. Replica indices will be in the range:
          [0, .spec.replicas).
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start", value)


if not MYPY:
    class StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgsDict(TypedDict):
        """
        StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.
        """
        when_deleted: NotRequired[pulumi.Input[builtins.str]]
        """
        WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        """
        when_scaled: NotRequired[pulumi.Input[builtins.str]]
        """
        WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
elif False:
    StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgs:
    def __init__(__self__, *,
                 when_deleted: Optional[pulumi.Input[builtins.str]] = None,
                 when_scaled: Optional[pulumi.Input[builtins.str]] = None):
        """
        StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.
        :param pulumi.Input[builtins.str] when_deleted: WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        :param pulumi.Input[builtins.str] when_scaled: WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
        if when_deleted is not None:
            pulumi.set(__self__, "when_deleted", when_deleted)
        if when_scaled is not None:
            pulumi.set(__self__, "when_scaled", when_scaled)

    @property
    @pulumi.getter(name="whenDeleted")
    def when_deleted(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        """
        return pulumi.get(self, "when_deleted")

    @when_deleted.setter
    def when_deleted(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "when_deleted", value)

    @property
    @pulumi.getter(name="whenScaled")
    def when_scaled(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
        return pulumi.get(self, "when_scaled")

    @when_scaled.setter
    def when_scaled(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "when_scaled", value)


if not MYPY:
    class StatefulSetPersistentVolumeClaimRetentionPolicyArgsDict(TypedDict):
        """
        StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.
        """
        when_deleted: NotRequired[pulumi.Input[builtins.str]]
        """
        WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        """
        when_scaled: NotRequired[pulumi.Input[builtins.str]]
        """
        WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
elif False:
    StatefulSetPersistentVolumeClaimRetentionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetPersistentVolumeClaimRetentionPolicyArgs:
    def __init__(__self__, *,
                 when_deleted: Optional[pulumi.Input[builtins.str]] = None,
                 when_scaled: Optional[pulumi.Input[builtins.str]] = None):
        """
        StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.
        :param pulumi.Input[builtins.str] when_deleted: WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        :param pulumi.Input[builtins.str] when_scaled: WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
        if when_deleted is not None:
            pulumi.set(__self__, "when_deleted", when_deleted)
        if when_scaled is not None:
            pulumi.set(__self__, "when_scaled", when_scaled)

    @property
    @pulumi.getter(name="whenDeleted")
    def when_deleted(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        """
        return pulumi.get(self, "when_deleted")

    @when_deleted.setter
    def when_deleted(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "when_deleted", value)

    @property
    @pulumi.getter(name="whenScaled")
    def when_scaled(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
        return pulumi.get(self, "when_scaled")

    @when_scaled.setter
    def when_scaled(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "when_scaled", value)


if not MYPY:
    class StatefulSetSpecPatchArgsDict(TypedDict):
        """
        A StatefulSetSpec is the specification of a StatefulSet.
        """
        min_ready_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        ordinals: NotRequired[pulumi.Input['StatefulSetOrdinalsPatchArgsDict']]
        """
        ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        """
        persistent_volume_claim_retention_policy: NotRequired[pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgsDict']]
        """
        persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        """
        pod_management_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        """
        replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        """
        revision_history_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        """
        selector: NotRequired[pulumi.Input['_meta.v1.LabelSelectorPatchArgsDict']]
        """
        selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        service_name: NotRequired[pulumi.Input[builtins.str]]
        """
        serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        """
        template: NotRequired[pulumi.Input['_core.v1.PodTemplateSpecPatchArgsDict']]
        """
        template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        """
        update_strategy: NotRequired[pulumi.Input['StatefulSetUpdateStrategyPatchArgsDict']]
        """
        updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        """
        volume_claim_templates: NotRequired[pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimPatchArgsDict']]]]
        """
        volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
elif False:
    StatefulSetSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetSpecPatchArgs:
    def __init__(__self__, *,
                 min_ready_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 ordinals: Optional[pulumi.Input['StatefulSetOrdinalsPatchArgs']] = None,
                 persistent_volume_claim_retention_policy: Optional[pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgs']] = None,
                 pod_management_policy: Optional[pulumi.Input[builtins.str]] = None,
                 replicas: Optional[pulumi.Input[builtins.int]] = None,
                 revision_history_limit: Optional[pulumi.Input[builtins.int]] = None,
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 template: Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']] = None,
                 update_strategy: Optional[pulumi.Input['StatefulSetUpdateStrategyPatchArgs']] = None,
                 volume_claim_templates: Optional[pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimPatchArgs']]]] = None):
        """
        A StatefulSetSpec is the specification of a StatefulSet.
        :param pulumi.Input[builtins.int] min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param pulumi.Input['StatefulSetOrdinalsPatchArgs'] ordinals: ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        :param pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgs'] persistent_volume_claim_retention_policy: persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        :param pulumi.Input[builtins.str] pod_management_policy: podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        :param pulumi.Input[builtins.int] replicas: replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        :param pulumi.Input[builtins.int] revision_history_limit: revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        :param pulumi.Input['_meta.v1.LabelSelectorPatchArgs'] selector: selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param pulumi.Input[builtins.str] service_name: serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        :param pulumi.Input['_core.v1.PodTemplateSpecPatchArgs'] template: template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        :param pulumi.Input['StatefulSetUpdateStrategyPatchArgs'] update_strategy: updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        :param pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimPatchArgs']]] volume_claim_templates: volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if ordinals is not None:
            pulumi.set(__self__, "ordinals", ordinals)
        if persistent_volume_claim_retention_policy is not None:
            pulumi.set(__self__, "persistent_volume_claim_retention_policy", persistent_volume_claim_retention_policy)
        if pod_management_policy is not None:
            pulumi.set(__self__, "pod_management_policy", pod_management_policy)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)
        if volume_claim_templates is not None:
            pulumi.set(__self__, "volume_claim_templates", volume_claim_templates)

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @min_ready_seconds.setter
    def min_ready_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_ready_seconds", value)

    @property
    @pulumi.getter
    def ordinals(self) -> Optional[pulumi.Input['StatefulSetOrdinalsPatchArgs']]:
        """
        ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        """
        return pulumi.get(self, "ordinals")

    @ordinals.setter
    def ordinals(self, value: Optional[pulumi.Input['StatefulSetOrdinalsPatchArgs']]):
        pulumi.set(self, "ordinals", value)

    @property
    @pulumi.getter(name="persistentVolumeClaimRetentionPolicy")
    def persistent_volume_claim_retention_policy(self) -> Optional[pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgs']]:
        """
        persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        """
        return pulumi.get(self, "persistent_volume_claim_retention_policy")

    @persistent_volume_claim_retention_policy.setter
    def persistent_volume_claim_retention_policy(self, value: Optional[pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgs']]):
        pulumi.set(self, "persistent_volume_claim_retention_policy", value)

    @property
    @pulumi.getter(name="podManagementPolicy")
    def pod_management_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        """
        return pulumi.get(self, "pod_management_policy")

    @pod_management_policy.setter
    def pod_management_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pod_management_policy", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @revision_history_limit.setter
    def revision_history_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "revision_history_limit", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]:
        """
        selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']]:
        """
        template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['_core.v1.PodTemplateSpecPatchArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[pulumi.Input['StatefulSetUpdateStrategyPatchArgs']]:
        """
        updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        """
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input['StatefulSetUpdateStrategyPatchArgs']]):
        pulumi.set(self, "update_strategy", value)

    @property
    @pulumi.getter(name="volumeClaimTemplates")
    def volume_claim_templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimPatchArgs']]]]:
        """
        volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        return pulumi.get(self, "volume_claim_templates")

    @volume_claim_templates.setter
    def volume_claim_templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimPatchArgs']]]]):
        pulumi.set(self, "volume_claim_templates", value)


if not MYPY:
    class StatefulSetSpecArgsDict(TypedDict):
        """
        A StatefulSetSpec is the specification of a StatefulSet.
        """
        selector: pulumi.Input['_meta.v1.LabelSelectorArgsDict']
        """
        selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        template: pulumi.Input['_core.v1.PodTemplateSpecArgsDict']
        """
        template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        """
        min_ready_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        ordinals: NotRequired[pulumi.Input['StatefulSetOrdinalsArgsDict']]
        """
        ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        """
        persistent_volume_claim_retention_policy: NotRequired[pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyArgsDict']]
        """
        persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        """
        pod_management_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        """
        replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        """
        revision_history_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        """
        service_name: NotRequired[pulumi.Input[builtins.str]]
        """
        serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        """
        update_strategy: NotRequired[pulumi.Input['StatefulSetUpdateStrategyArgsDict']]
        """
        updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        """
        volume_claim_templates: NotRequired[pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimArgsDict']]]]
        """
        volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
elif False:
    StatefulSetSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetSpecArgs:
    def __init__(__self__, *,
                 selector: pulumi.Input['_meta.v1.LabelSelectorArgs'],
                 template: pulumi.Input['_core.v1.PodTemplateSpecArgs'],
                 min_ready_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 ordinals: Optional[pulumi.Input['StatefulSetOrdinalsArgs']] = None,
                 persistent_volume_claim_retention_policy: Optional[pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyArgs']] = None,
                 pod_management_policy: Optional[pulumi.Input[builtins.str]] = None,
                 replicas: Optional[pulumi.Input[builtins.int]] = None,
                 revision_history_limit: Optional[pulumi.Input[builtins.int]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 update_strategy: Optional[pulumi.Input['StatefulSetUpdateStrategyArgs']] = None,
                 volume_claim_templates: Optional[pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimArgs']]]] = None):
        """
        A StatefulSetSpec is the specification of a StatefulSet.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param pulumi.Input['_core.v1.PodTemplateSpecArgs'] template: template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        :param pulumi.Input[builtins.int] min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param pulumi.Input['StatefulSetOrdinalsArgs'] ordinals: ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        :param pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyArgs'] persistent_volume_claim_retention_policy: persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        :param pulumi.Input[builtins.str] pod_management_policy: podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        :param pulumi.Input[builtins.int] replicas: replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        :param pulumi.Input[builtins.int] revision_history_limit: revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        :param pulumi.Input[builtins.str] service_name: serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        :param pulumi.Input['StatefulSetUpdateStrategyArgs'] update_strategy: updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        :param pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimArgs']]] volume_claim_templates: volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if ordinals is not None:
            pulumi.set(__self__, "ordinals", ordinals)
        if persistent_volume_claim_retention_policy is not None:
            pulumi.set(__self__, "persistent_volume_claim_retention_policy", persistent_volume_claim_retention_policy)
        if pod_management_policy is not None:
            pulumi.set(__self__, "pod_management_policy", pod_management_policy)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)
        if volume_claim_templates is not None:
            pulumi.set(__self__, "volume_claim_templates", volume_claim_templates)

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Input['_meta.v1.LabelSelectorArgs']:
        """
        selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: pulumi.Input['_meta.v1.LabelSelectorArgs']):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['_core.v1.PodTemplateSpecArgs']:
        """
        template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['_core.v1.PodTemplateSpecArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @min_ready_seconds.setter
    def min_ready_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_ready_seconds", value)

    @property
    @pulumi.getter
    def ordinals(self) -> Optional[pulumi.Input['StatefulSetOrdinalsArgs']]:
        """
        ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        """
        return pulumi.get(self, "ordinals")

    @ordinals.setter
    def ordinals(self, value: Optional[pulumi.Input['StatefulSetOrdinalsArgs']]):
        pulumi.set(self, "ordinals", value)

    @property
    @pulumi.getter(name="persistentVolumeClaimRetentionPolicy")
    def persistent_volume_claim_retention_policy(self) -> Optional[pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyArgs']]:
        """
        persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        """
        return pulumi.get(self, "persistent_volume_claim_retention_policy")

    @persistent_volume_claim_retention_policy.setter
    def persistent_volume_claim_retention_policy(self, value: Optional[pulumi.Input['StatefulSetPersistentVolumeClaimRetentionPolicyArgs']]):
        pulumi.set(self, "persistent_volume_claim_retention_policy", value)

    @property
    @pulumi.getter(name="podManagementPolicy")
    def pod_management_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        """
        return pulumi.get(self, "pod_management_policy")

    @pod_management_policy.setter
    def pod_management_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pod_management_policy", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @revision_history_limit.setter
    def revision_history_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "revision_history_limit", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[pulumi.Input['StatefulSetUpdateStrategyArgs']]:
        """
        updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        """
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input['StatefulSetUpdateStrategyArgs']]):
        pulumi.set(self, "update_strategy", value)

    @property
    @pulumi.getter(name="volumeClaimTemplates")
    def volume_claim_templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimArgs']]]]:
        """
        volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        return pulumi.get(self, "volume_claim_templates")

    @volume_claim_templates.setter
    def volume_claim_templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_core.v1.PersistentVolumeClaimArgs']]]]):
        pulumi.set(self, "volume_claim_templates", value)


if not MYPY:
    class StatefulSetStatusArgsDict(TypedDict):
        """
        StatefulSetStatus represents the current state of a StatefulSet.
        """
        replicas: pulumi.Input[builtins.int]
        """
        replicas is the number of Pods created by the StatefulSet controller.
        """
        available_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.
        """
        collision_count: NotRequired[pulumi.Input[builtins.int]]
        """
        collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['StatefulSetConditionArgsDict']]]]
        """
        Represents the latest available observations of a statefulset's current state.
        """
        current_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
        """
        current_revision: NotRequired[pulumi.Input[builtins.str]]
        """
        currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
        """
        observed_generation: NotRequired[pulumi.Input[builtins.int]]
        """
        observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
        """
        ready_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.
        """
        update_revision: NotRequired[pulumi.Input[builtins.str]]
        """
        updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
        """
        updated_replicas: NotRequired[pulumi.Input[builtins.int]]
        """
        updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
        """
elif False:
    StatefulSetStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetStatusArgs:
    def __init__(__self__, *,
                 replicas: pulumi.Input[builtins.int],
                 available_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 collision_count: Optional[pulumi.Input[builtins.int]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['StatefulSetConditionArgs']]]] = None,
                 current_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 current_revision: Optional[pulumi.Input[builtins.str]] = None,
                 observed_generation: Optional[pulumi.Input[builtins.int]] = None,
                 ready_replicas: Optional[pulumi.Input[builtins.int]] = None,
                 update_revision: Optional[pulumi.Input[builtins.str]] = None,
                 updated_replicas: Optional[pulumi.Input[builtins.int]] = None):
        """
        StatefulSetStatus represents the current state of a StatefulSet.
        :param pulumi.Input[builtins.int] replicas: replicas is the number of Pods created by the StatefulSet controller.
        :param pulumi.Input[builtins.int] available_replicas: Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.
        :param pulumi.Input[builtins.int] collision_count: collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param pulumi.Input[Sequence[pulumi.Input['StatefulSetConditionArgs']]] conditions: Represents the latest available observations of a statefulset's current state.
        :param pulumi.Input[builtins.int] current_replicas: currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
        :param pulumi.Input[builtins.str] current_revision: currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
        :param pulumi.Input[builtins.int] observed_generation: observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
        :param pulumi.Input[builtins.int] ready_replicas: readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.
        :param pulumi.Input[builtins.str] update_revision: updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
        :param pulumi.Input[builtins.int] updated_replicas: updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
        """
        pulumi.set(__self__, "replicas", replicas)
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_replicas is not None:
            pulumi.set(__self__, "current_replicas", current_replicas)
        if current_revision is not None:
            pulumi.set(__self__, "current_revision", current_revision)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if update_revision is not None:
            pulumi.set(__self__, "update_revision", update_revision)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Input[builtins.int]:
        """
        replicas is the number of Pods created by the StatefulSet controller.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.
        """
        return pulumi.get(self, "available_replicas")

    @available_replicas.setter
    def available_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "available_replicas", value)

    @property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @collision_count.setter
    def collision_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "collision_count", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StatefulSetConditionArgs']]]]:
        """
        Represents the latest available observations of a statefulset's current state.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StatefulSetConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="currentReplicas")
    def current_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
        """
        return pulumi.get(self, "current_replicas")

    @current_replicas.setter
    def current_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "current_replicas", value)

    @property
    @pulumi.getter(name="currentRevision")
    def current_revision(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
        """
        return pulumi.get(self, "current_revision")

    @current_revision.setter
    def current_revision(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "current_revision", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @ready_replicas.setter
    def ready_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ready_replicas", value)

    @property
    @pulumi.getter(name="updateRevision")
    def update_revision(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
        """
        return pulumi.get(self, "update_revision")

    @update_revision.setter
    def update_revision(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_revision", value)

    @property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
        """
        return pulumi.get(self, "updated_replicas")

    @updated_replicas.setter
    def updated_replicas(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "updated_replicas", value)


if not MYPY:
    class StatefulSetUpdateStrategyPatchArgsDict(TypedDict):
        """
        StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
        """
        rolling_update: NotRequired[pulumi.Input['RollingUpdateStatefulSetStrategyPatchArgsDict']]
        """
        RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
elif False:
    StatefulSetUpdateStrategyPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetUpdateStrategyPatchArgs:
    def __init__(__self__, *,
                 rolling_update: Optional[pulumi.Input['RollingUpdateStatefulSetStrategyPatchArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
        :param pulumi.Input['RollingUpdateStatefulSetStrategyPatchArgs'] rolling_update: RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        :param pulumi.Input[builtins.str] type: Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional[pulumi.Input['RollingUpdateStatefulSetStrategyPatchArgs']]:
        """
        RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        """
        return pulumi.get(self, "rolling_update")

    @rolling_update.setter
    def rolling_update(self, value: Optional[pulumi.Input['RollingUpdateStatefulSetStrategyPatchArgs']]):
        pulumi.set(self, "rolling_update", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class StatefulSetUpdateStrategyArgsDict(TypedDict):
        """
        StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
        """
        rolling_update: NotRequired[pulumi.Input['RollingUpdateStatefulSetStrategyArgsDict']]
        """
        RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
elif False:
    StatefulSetUpdateStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetUpdateStrategyArgs:
    def __init__(__self__, *,
                 rolling_update: Optional[pulumi.Input['RollingUpdateStatefulSetStrategyArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
        :param pulumi.Input['RollingUpdateStatefulSetStrategyArgs'] rolling_update: RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        :param pulumi.Input[builtins.str] type: Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional[pulumi.Input['RollingUpdateStatefulSetStrategyArgs']]:
        """
        RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        """
        return pulumi.get(self, "rolling_update")

    @rolling_update.setter
    def rolling_update(self, value: Optional[pulumi.Input['RollingUpdateStatefulSetStrategyArgs']]):
        pulumi.set(self, "rolling_update", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class StatefulSetArgsDict(TypedDict):
        """
        StatefulSet represents a set of pods with consistent identities. Identities are defined as:
          - Network: A single stable DNS and hostname.
          - Storage: As many VolumeClaims as requested.

        The StatefulSet guarantees that a given network identity will always map to the same storage identity.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The value of 'spec.replicas' matches '.status.replicas', '.status.currentReplicas',
           and '.status.readyReplicas'.
        2. The value of '.status.updateRevision' matches '.status.currentRevision'.

        If the StatefulSet has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        spec: NotRequired[pulumi.Input['StatefulSetSpecArgsDict']]
        """
        Spec defines the desired identities of pods in this set.
        """
        status: NotRequired[pulumi.Input['StatefulSetStatusArgsDict']]
        """
        Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.
        """
elif False:
    StatefulSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatefulSetArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['StatefulSetSpecArgs']] = None,
                 status: Optional[pulumi.Input['StatefulSetStatusArgs']] = None):
        """
        StatefulSet represents a set of pods with consistent identities. Identities are defined as:
          - Network: A single stable DNS and hostname.
          - Storage: As many VolumeClaims as requested.

        The StatefulSet guarantees that a given network identity will always map to the same storage identity.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The value of 'spec.replicas' matches '.status.replicas', '.status.currentReplicas',
           and '.status.readyReplicas'.
        2. The value of '.status.updateRevision' matches '.status.currentRevision'.

        If the StatefulSet has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['StatefulSetSpecArgs'] spec: Spec defines the desired identities of pods in this set.
        :param pulumi.Input['StatefulSetStatusArgs'] status: Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'StatefulSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['StatefulSetSpecArgs']]:
        """
        Spec defines the desired identities of pods in this set.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['StatefulSetSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['StatefulSetStatusArgs']]:
        """
        Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['StatefulSetStatusArgs']]):
        pulumi.set(self, "status", value)


