# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'CronJob',
    'CronJobSpec',
    'CronJobSpecPatch',
    'CronJobStatus',
    'CronJobStatusPatch',
    'Job',
    'JobCondition',
    'JobConditionPatch',
    'JobSpec',
    'JobSpecPatch',
    'JobStatus',
    'JobStatusPatch',
    'JobTemplateSpec',
    'JobTemplateSpecPatch',
    'PodFailurePolicy',
    'PodFailurePolicyOnExitCodesRequirement',
    'PodFailurePolicyOnExitCodesRequirementPatch',
    'PodFailurePolicyOnPodConditionsPattern',
    'PodFailurePolicyOnPodConditionsPatternPatch',
    'PodFailurePolicyPatch',
    'PodFailurePolicyRule',
    'PodFailurePolicyRulePatch',
    'SuccessPolicy',
    'SuccessPolicyPatch',
    'SuccessPolicyRule',
    'SuccessPolicyRulePatch',
    'UncountedTerminatedPods',
    'UncountedTerminatedPodsPatch',
]

@pulumi.output_type
class CronJob(dict):
    """
    CronJob represents the configuration of a single cron job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CronJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CronJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CronJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.CronJobSpec'] = None,
                 status: Optional['outputs.CronJobStatus'] = None):
        """
        CronJob represents the configuration of a single cron job.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'CronJobSpecArgs' spec: Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'CronJobStatusArgs' status: Current status of a cron job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'batch/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'CronJob')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.CronJobSpec']:
        """
        Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.CronJobStatus']:
        """
        Current status of a cron job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CronJobSpec(dict):
    """
    CronJobSpec describes how the job execution will look like and when it will actually run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobTemplate":
            suggest = "job_template"
        elif key == "concurrencyPolicy":
            suggest = "concurrency_policy"
        elif key == "failedJobsHistoryLimit":
            suggest = "failed_jobs_history_limit"
        elif key == "startingDeadlineSeconds":
            suggest = "starting_deadline_seconds"
        elif key == "successfulJobsHistoryLimit":
            suggest = "successful_jobs_history_limit"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CronJobSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CronJobSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CronJobSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_template: 'outputs.JobTemplateSpec',
                 schedule: builtins.str,
                 concurrency_policy: Optional[builtins.str] = None,
                 failed_jobs_history_limit: Optional[builtins.int] = None,
                 starting_deadline_seconds: Optional[builtins.int] = None,
                 successful_jobs_history_limit: Optional[builtins.int] = None,
                 suspend: Optional[builtins.bool] = None,
                 time_zone: Optional[builtins.str] = None):
        """
        CronJobSpec describes how the job execution will look like and when it will actually run.
        :param 'JobTemplateSpecArgs' job_template: Specifies the job that will be created when executing a CronJob.
        :param builtins.str schedule: The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
        :param builtins.str concurrency_policy: Specifies how to treat concurrent executions of a Job. Valid values are:
               
               - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
        :param builtins.int failed_jobs_history_limit: The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
        :param builtins.int starting_deadline_seconds: Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
        :param builtins.int successful_jobs_history_limit: The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
        :param builtins.bool suspend: This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
        :param builtins.str time_zone: The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
        """
        pulumi.set(__self__, "job_template", job_template)
        pulumi.set(__self__, "schedule", schedule)
        if concurrency_policy is not None:
            pulumi.set(__self__, "concurrency_policy", concurrency_policy)
        if failed_jobs_history_limit is not None:
            pulumi.set(__self__, "failed_jobs_history_limit", failed_jobs_history_limit)
        if starting_deadline_seconds is not None:
            pulumi.set(__self__, "starting_deadline_seconds", starting_deadline_seconds)
        if successful_jobs_history_limit is not None:
            pulumi.set(__self__, "successful_jobs_history_limit", successful_jobs_history_limit)
        if suspend is not None:
            pulumi.set(__self__, "suspend", suspend)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="jobTemplate")
    def job_template(self) -> 'outputs.JobTemplateSpec':
        """
        Specifies the job that will be created when executing a CronJob.
        """
        return pulumi.get(self, "job_template")

    @property
    @pulumi.getter
    def schedule(self) -> builtins.str:
        """
        The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="concurrencyPolicy")
    def concurrency_policy(self) -> Optional[builtins.str]:
        """
        Specifies how to treat concurrent executions of a Job. Valid values are:

        - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
        """
        return pulumi.get(self, "concurrency_policy")

    @property
    @pulumi.getter(name="failedJobsHistoryLimit")
    def failed_jobs_history_limit(self) -> Optional[builtins.int]:
        """
        The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
        """
        return pulumi.get(self, "failed_jobs_history_limit")

    @property
    @pulumi.getter(name="startingDeadlineSeconds")
    def starting_deadline_seconds(self) -> Optional[builtins.int]:
        """
        Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
        """
        return pulumi.get(self, "starting_deadline_seconds")

    @property
    @pulumi.getter(name="successfulJobsHistoryLimit")
    def successful_jobs_history_limit(self) -> Optional[builtins.int]:
        """
        The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
        """
        return pulumi.get(self, "successful_jobs_history_limit")

    @property
    @pulumi.getter
    def suspend(self) -> Optional[builtins.bool]:
        """
        This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
        """
        return pulumi.get(self, "suspend")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[builtins.str]:
        """
        The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class CronJobSpecPatch(dict):
    """
    CronJobSpec describes how the job execution will look like and when it will actually run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrencyPolicy":
            suggest = "concurrency_policy"
        elif key == "failedJobsHistoryLimit":
            suggest = "failed_jobs_history_limit"
        elif key == "jobTemplate":
            suggest = "job_template"
        elif key == "startingDeadlineSeconds":
            suggest = "starting_deadline_seconds"
        elif key == "successfulJobsHistoryLimit":
            suggest = "successful_jobs_history_limit"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CronJobSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CronJobSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CronJobSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrency_policy: Optional[builtins.str] = None,
                 failed_jobs_history_limit: Optional[builtins.int] = None,
                 job_template: Optional['outputs.JobTemplateSpecPatch'] = None,
                 schedule: Optional[builtins.str] = None,
                 starting_deadline_seconds: Optional[builtins.int] = None,
                 successful_jobs_history_limit: Optional[builtins.int] = None,
                 suspend: Optional[builtins.bool] = None,
                 time_zone: Optional[builtins.str] = None):
        """
        CronJobSpec describes how the job execution will look like and when it will actually run.
        :param builtins.str concurrency_policy: Specifies how to treat concurrent executions of a Job. Valid values are:
               
               - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
        :param builtins.int failed_jobs_history_limit: The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
        :param 'JobTemplateSpecPatchArgs' job_template: Specifies the job that will be created when executing a CronJob.
        :param builtins.str schedule: The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
        :param builtins.int starting_deadline_seconds: Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
        :param builtins.int successful_jobs_history_limit: The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
        :param builtins.bool suspend: This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
        :param builtins.str time_zone: The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
        """
        if concurrency_policy is not None:
            pulumi.set(__self__, "concurrency_policy", concurrency_policy)
        if failed_jobs_history_limit is not None:
            pulumi.set(__self__, "failed_jobs_history_limit", failed_jobs_history_limit)
        if job_template is not None:
            pulumi.set(__self__, "job_template", job_template)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if starting_deadline_seconds is not None:
            pulumi.set(__self__, "starting_deadline_seconds", starting_deadline_seconds)
        if successful_jobs_history_limit is not None:
            pulumi.set(__self__, "successful_jobs_history_limit", successful_jobs_history_limit)
        if suspend is not None:
            pulumi.set(__self__, "suspend", suspend)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="concurrencyPolicy")
    def concurrency_policy(self) -> Optional[builtins.str]:
        """
        Specifies how to treat concurrent executions of a Job. Valid values are:

        - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
        """
        return pulumi.get(self, "concurrency_policy")

    @property
    @pulumi.getter(name="failedJobsHistoryLimit")
    def failed_jobs_history_limit(self) -> Optional[builtins.int]:
        """
        The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.
        """
        return pulumi.get(self, "failed_jobs_history_limit")

    @property
    @pulumi.getter(name="jobTemplate")
    def job_template(self) -> Optional['outputs.JobTemplateSpecPatch']:
        """
        Specifies the job that will be created when executing a CronJob.
        """
        return pulumi.get(self, "job_template")

    @property
    @pulumi.getter
    def schedule(self) -> Optional[builtins.str]:
        """
        The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startingDeadlineSeconds")
    def starting_deadline_seconds(self) -> Optional[builtins.int]:
        """
        Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.
        """
        return pulumi.get(self, "starting_deadline_seconds")

    @property
    @pulumi.getter(name="successfulJobsHistoryLimit")
    def successful_jobs_history_limit(self) -> Optional[builtins.int]:
        """
        The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.
        """
        return pulumi.get(self, "successful_jobs_history_limit")

    @property
    @pulumi.getter
    def suspend(self) -> Optional[builtins.bool]:
        """
        This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.
        """
        return pulumi.get(self, "suspend")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[builtins.str]:
        """
        The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class CronJobStatus(dict):
    """
    CronJobStatus represents the current state of a cron job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastScheduleTime":
            suggest = "last_schedule_time"
        elif key == "lastSuccessfulTime":
            suggest = "last_successful_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CronJobStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CronJobStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CronJobStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: Optional[Sequence['_core.v1.outputs.ObjectReference']] = None,
                 last_schedule_time: Optional[builtins.str] = None,
                 last_successful_time: Optional[builtins.str] = None):
        """
        CronJobStatus represents the current state of a cron job.
        :param Sequence['_core.v1.ObjectReferenceArgs'] active: A list of pointers to currently running jobs.
        :param builtins.str last_schedule_time: Information when was the last time the job was successfully scheduled.
        :param builtins.str last_successful_time: Information when was the last time the job successfully completed.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if last_schedule_time is not None:
            pulumi.set(__self__, "last_schedule_time", last_schedule_time)
        if last_successful_time is not None:
            pulumi.set(__self__, "last_successful_time", last_successful_time)

    @property
    @pulumi.getter
    def active(self) -> Optional[Sequence['_core.v1.outputs.ObjectReference']]:
        """
        A list of pointers to currently running jobs.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="lastScheduleTime")
    def last_schedule_time(self) -> Optional[builtins.str]:
        """
        Information when was the last time the job was successfully scheduled.
        """
        return pulumi.get(self, "last_schedule_time")

    @property
    @pulumi.getter(name="lastSuccessfulTime")
    def last_successful_time(self) -> Optional[builtins.str]:
        """
        Information when was the last time the job successfully completed.
        """
        return pulumi.get(self, "last_successful_time")


@pulumi.output_type
class CronJobStatusPatch(dict):
    """
    CronJobStatus represents the current state of a cron job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastScheduleTime":
            suggest = "last_schedule_time"
        elif key == "lastSuccessfulTime":
            suggest = "last_successful_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CronJobStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CronJobStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CronJobStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: Optional[Sequence['_core.v1.outputs.ObjectReferencePatch']] = None,
                 last_schedule_time: Optional[builtins.str] = None,
                 last_successful_time: Optional[builtins.str] = None):
        """
        CronJobStatus represents the current state of a cron job.
        :param Sequence['_core.v1.ObjectReferencePatchArgs'] active: A list of pointers to currently running jobs.
        :param builtins.str last_schedule_time: Information when was the last time the job was successfully scheduled.
        :param builtins.str last_successful_time: Information when was the last time the job successfully completed.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if last_schedule_time is not None:
            pulumi.set(__self__, "last_schedule_time", last_schedule_time)
        if last_successful_time is not None:
            pulumi.set(__self__, "last_successful_time", last_successful_time)

    @property
    @pulumi.getter
    def active(self) -> Optional[Sequence['_core.v1.outputs.ObjectReferencePatch']]:
        """
        A list of pointers to currently running jobs.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="lastScheduleTime")
    def last_schedule_time(self) -> Optional[builtins.str]:
        """
        Information when was the last time the job was successfully scheduled.
        """
        return pulumi.get(self, "last_schedule_time")

    @property
    @pulumi.getter(name="lastSuccessfulTime")
    def last_successful_time(self) -> Optional[builtins.str]:
        """
        Information when was the last time the job successfully completed.
        """
        return pulumi.get(self, "last_successful_time")


@pulumi.output_type
class Job(dict):
    """
    Job represents the configuration of a single job.

    This resource waits until its status is ready before registering success
    for create/update, and populating output properties from the current state of the resource.
    The following conditions are used to determine whether the resource creation has
    succeeded or failed:

    1. The Job's '.status.startTime' is set, which indicates that the Job has started running.
    2. The Job's '.status.conditions' has a status of type 'Complete', and a 'status' set
       to 'True'.
    3. The Job's '.status.conditions' do not have a status of type 'Failed', with a
    	'status' set to 'True'. If this condition is set, we should fail the Job immediately.

    If the Job has not reached a Ready state after 10 minutes, it will
    time out and mark the resource update as Failed. You can override the default timeout value
    by setting the 'customTimeouts' option on the resource.

    By default, if a resource failed to become ready in a previous update, 
    Pulumi will continue to wait for readiness on the next update. If you would prefer
    to schedule a replacement for an unready resource on the next update, you can add the
    "pulumi.com/replaceUnready": "true" annotation to the resource definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Job. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Job.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Job.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.JobSpec'] = None,
                 status: Optional['outputs.JobStatus'] = None):
        """
        Job represents the configuration of a single job.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The Job's '.status.startTime' is set, which indicates that the Job has started running.
        2. The Job's '.status.conditions' has a status of type 'Complete', and a 'status' set
           to 'True'.
        3. The Job's '.status.conditions' do not have a status of type 'Failed', with a
        	'status' set to 'True'. If this condition is set, we should fail the Job immediately.

        If the Job has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.

        By default, if a resource failed to become ready in a previous update, 
        Pulumi will continue to wait for readiness on the next update. If you would prefer
        to schedule a replacement for an unready resource on the next update, you can add the
        "pulumi.com/replaceUnready": "true" annotation to the resource definition.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'JobSpecArgs' spec: Specification of the desired behavior of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'JobStatusArgs' status: Current status of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'batch/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Job')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.JobSpec']:
        """
        Specification of the desired behavior of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.JobStatus']:
        """
        Current status of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class JobCondition(dict):
    """
    JobCondition describes current state of a job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastProbeTime":
            suggest = "last_probe_time"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: builtins.str,
                 type: builtins.str,
                 last_probe_time: Optional[builtins.str] = None,
                 last_transition_time: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 reason: Optional[builtins.str] = None):
        """
        JobCondition describes current state of a job.
        :param builtins.str status: Status of the condition, one of True, False, Unknown.
        :param builtins.str type: Type of job condition, Complete or Failed.
        :param builtins.str last_probe_time: Last time the condition was checked.
        :param builtins.str last_transition_time: Last time the condition transit from one status to another.
        :param builtins.str message: Human readable message indicating details about last transition.
        :param builtins.str reason: (brief) reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_probe_time is not None:
            pulumi.set(__self__, "last_probe_time", last_probe_time)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of job condition, Complete or Failed.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="lastProbeTime")
    def last_probe_time(self) -> Optional[builtins.str]:
        """
        Last time the condition was checked.
        """
        return pulumi.get(self, "last_probe_time")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[builtins.str]:
        """
        Last time the condition transit from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Human readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[builtins.str]:
        """
        (brief) reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class JobConditionPatch(dict):
    """
    JobCondition describes current state of a job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastProbeTime":
            suggest = "last_probe_time"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_probe_time: Optional[builtins.str] = None,
                 last_transition_time: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 reason: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        JobCondition describes current state of a job.
        :param builtins.str last_probe_time: Last time the condition was checked.
        :param builtins.str last_transition_time: Last time the condition transit from one status to another.
        :param builtins.str message: Human readable message indicating details about last transition.
        :param builtins.str reason: (brief) reason for the condition's last transition.
        :param builtins.str status: Status of the condition, one of True, False, Unknown.
        :param builtins.str type: Type of job condition, Complete or Failed.
        """
        if last_probe_time is not None:
            pulumi.set(__self__, "last_probe_time", last_probe_time)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastProbeTime")
    def last_probe_time(self) -> Optional[builtins.str]:
        """
        Last time the condition was checked.
        """
        return pulumi.get(self, "last_probe_time")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[builtins.str]:
        """
        Last time the condition transit from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Human readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[builtins.str]:
        """
        (brief) reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Type of job condition, Complete or Failed.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobSpec(dict):
    """
    JobSpec describes how the job execution will look like.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDeadlineSeconds":
            suggest = "active_deadline_seconds"
        elif key == "backoffLimit":
            suggest = "backoff_limit"
        elif key == "backoffLimitPerIndex":
            suggest = "backoff_limit_per_index"
        elif key == "completionMode":
            suggest = "completion_mode"
        elif key == "managedBy":
            suggest = "managed_by"
        elif key == "manualSelector":
            suggest = "manual_selector"
        elif key == "maxFailedIndexes":
            suggest = "max_failed_indexes"
        elif key == "podFailurePolicy":
            suggest = "pod_failure_policy"
        elif key == "podReplacementPolicy":
            suggest = "pod_replacement_policy"
        elif key == "successPolicy":
            suggest = "success_policy"
        elif key == "ttlSecondsAfterFinished":
            suggest = "ttl_seconds_after_finished"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template: '_core.v1.outputs.PodTemplateSpec',
                 active_deadline_seconds: Optional[builtins.int] = None,
                 backoff_limit: Optional[builtins.int] = None,
                 backoff_limit_per_index: Optional[builtins.int] = None,
                 completion_mode: Optional[builtins.str] = None,
                 completions: Optional[builtins.int] = None,
                 managed_by: Optional[builtins.str] = None,
                 manual_selector: Optional[builtins.bool] = None,
                 max_failed_indexes: Optional[builtins.int] = None,
                 parallelism: Optional[builtins.int] = None,
                 pod_failure_policy: Optional['outputs.PodFailurePolicy'] = None,
                 pod_replacement_policy: Optional[builtins.str] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 success_policy: Optional['outputs.SuccessPolicy'] = None,
                 suspend: Optional[builtins.bool] = None,
                 ttl_seconds_after_finished: Optional[builtins.int] = None):
        """
        JobSpec describes how the job execution will look like.
        :param '_core.v1.PodTemplateSpecArgs' template: Describes the pod that will be created when executing a job. The only allowed template.spec.restartPolicy values are "Never" or "OnFailure". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param builtins.int active_deadline_seconds: Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.
        :param builtins.int backoff_limit: Specifies the number of retries before marking this job failed. Defaults to 6
        :param builtins.int backoff_limit_per_index: Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable.
        :param builtins.str completion_mode: completionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.
               
               `NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.
               
               `Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.
               
               More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.
        :param builtins.int completions: Specifies the desired number of successfully finished pods the job should be run with.  Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param builtins.str managed_by: ManagedBy field indicates the controller that manages a Job. The k8s Job controller reconciles jobs which don't have this field at all or the field value is the reserved string `kubernetes.io/job-controller`, but skips reconciling Jobs with a custom value for this field. The value must be a valid domain-prefixed path (e.g. acme.io/foo) - all characters before the first "/" must be a valid subdomain as defined by RFC 1123. All characters trailing the first "/" must be valid HTTP Path characters as defined by RFC 3986. The value cannot exceed 63 characters. This field is immutable.
               
               This field is beta-level. The job controller accepts setting the field when the feature gate JobManagedBy is enabled (enabled by default).
        :param builtins.bool manual_selector: manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
        :param builtins.int max_failed_indexes: Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the `Complete` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5.
        :param builtins.int parallelism: Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param 'PodFailurePolicyArgs' pod_failure_policy: Specifies the policy of handling failed pods. In particular, it allows to specify the set of actions and conditions which need to be satisfied to take the associated action. If empty, the default behaviour applies - the counter of failed pods, represented by the jobs's .status.failed field, is incremented and it is checked against the backoffLimit. This field cannot be used in combination with restartPolicy=OnFailure.
        :param builtins.str pod_replacement_policy: podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods
                 when they are terminating (has a metadata.deletionTimestamp) or failed.
               - Failed means to wait until a previously created Pod is fully terminated (has phase
                 Failed or Succeeded) before creating a replacement Pod.
               
               When using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle. This is on by default.
        :param '_meta.v1.LabelSelectorArgs' selector: A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param 'SuccessPolicyArgs' success_policy: successPolicy specifies the policy when the Job can be declared as succeeded. If empty, the default behavior applies - the Job is declared as succeeded only when the number of succeeded pods equals to the completions. When the field is specified, it must be immutable and works only for the Indexed Jobs. Once the Job meets the SuccessPolicy, the lingering pods are terminated.
        :param builtins.bool suspend: suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.
        :param builtins.int ttl_seconds_after_finished: ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.
        """
        pulumi.set(__self__, "template", template)
        if active_deadline_seconds is not None:
            pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        if backoff_limit is not None:
            pulumi.set(__self__, "backoff_limit", backoff_limit)
        if backoff_limit_per_index is not None:
            pulumi.set(__self__, "backoff_limit_per_index", backoff_limit_per_index)
        if completion_mode is not None:
            pulumi.set(__self__, "completion_mode", completion_mode)
        if completions is not None:
            pulumi.set(__self__, "completions", completions)
        if managed_by is not None:
            pulumi.set(__self__, "managed_by", managed_by)
        if manual_selector is not None:
            pulumi.set(__self__, "manual_selector", manual_selector)
        if max_failed_indexes is not None:
            pulumi.set(__self__, "max_failed_indexes", max_failed_indexes)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if pod_failure_policy is not None:
            pulumi.set(__self__, "pod_failure_policy", pod_failure_policy)
        if pod_replacement_policy is not None:
            pulumi.set(__self__, "pod_replacement_policy", pod_replacement_policy)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if success_policy is not None:
            pulumi.set(__self__, "success_policy", success_policy)
        if suspend is not None:
            pulumi.set(__self__, "suspend", suspend)
        if ttl_seconds_after_finished is not None:
            pulumi.set(__self__, "ttl_seconds_after_finished", ttl_seconds_after_finished)

    @property
    @pulumi.getter
    def template(self) -> '_core.v1.outputs.PodTemplateSpec':
        """
        Describes the pod that will be created when executing a job. The only allowed template.spec.restartPolicy values are "Never" or "OnFailure". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> Optional[builtins.int]:
        """
        Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.
        """
        return pulumi.get(self, "active_deadline_seconds")

    @property
    @pulumi.getter(name="backoffLimit")
    def backoff_limit(self) -> Optional[builtins.int]:
        """
        Specifies the number of retries before marking this job failed. Defaults to 6
        """
        return pulumi.get(self, "backoff_limit")

    @property
    @pulumi.getter(name="backoffLimitPerIndex")
    def backoff_limit_per_index(self) -> Optional[builtins.int]:
        """
        Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable.
        """
        return pulumi.get(self, "backoff_limit_per_index")

    @property
    @pulumi.getter(name="completionMode")
    def completion_mode(self) -> Optional[builtins.str]:
        """
        completionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.

        `NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.

        `Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.

        More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.
        """
        return pulumi.get(self, "completion_mode")

    @property
    @pulumi.getter
    def completions(self) -> Optional[builtins.int]:
        """
        Specifies the desired number of successfully finished pods the job should be run with.  Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "completions")

    @property
    @pulumi.getter(name="managedBy")
    def managed_by(self) -> Optional[builtins.str]:
        """
        ManagedBy field indicates the controller that manages a Job. The k8s Job controller reconciles jobs which don't have this field at all or the field value is the reserved string `kubernetes.io/job-controller`, but skips reconciling Jobs with a custom value for this field. The value must be a valid domain-prefixed path (e.g. acme.io/foo) - all characters before the first "/" must be a valid subdomain as defined by RFC 1123. All characters trailing the first "/" must be valid HTTP Path characters as defined by RFC 3986. The value cannot exceed 63 characters. This field is immutable.

        This field is beta-level. The job controller accepts setting the field when the feature gate JobManagedBy is enabled (enabled by default).
        """
        return pulumi.get(self, "managed_by")

    @property
    @pulumi.getter(name="manualSelector")
    def manual_selector(self) -> Optional[builtins.bool]:
        """
        manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
        """
        return pulumi.get(self, "manual_selector")

    @property
    @pulumi.getter(name="maxFailedIndexes")
    def max_failed_indexes(self) -> Optional[builtins.int]:
        """
        Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the `Complete` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5.
        """
        return pulumi.get(self, "max_failed_indexes")

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[builtins.int]:
        """
        Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter(name="podFailurePolicy")
    def pod_failure_policy(self) -> Optional['outputs.PodFailurePolicy']:
        """
        Specifies the policy of handling failed pods. In particular, it allows to specify the set of actions and conditions which need to be satisfied to take the associated action. If empty, the default behaviour applies - the counter of failed pods, represented by the jobs's .status.failed field, is incremented and it is checked against the backoffLimit. This field cannot be used in combination with restartPolicy=OnFailure.
        """
        return pulumi.get(self, "pod_failure_policy")

    @property
    @pulumi.getter(name="podReplacementPolicy")
    def pod_replacement_policy(self) -> Optional[builtins.str]:
        """
        podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods
          when they are terminating (has a metadata.deletionTimestamp) or failed.
        - Failed means to wait until a previously created Pod is fully terminated (has phase
          Failed or Succeeded) before creating a replacement Pod.

        When using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle. This is on by default.
        """
        return pulumi.get(self, "pod_replacement_policy")

    @property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="successPolicy")
    def success_policy(self) -> Optional['outputs.SuccessPolicy']:
        """
        successPolicy specifies the policy when the Job can be declared as succeeded. If empty, the default behavior applies - the Job is declared as succeeded only when the number of succeeded pods equals to the completions. When the field is specified, it must be immutable and works only for the Indexed Jobs. Once the Job meets the SuccessPolicy, the lingering pods are terminated.
        """
        return pulumi.get(self, "success_policy")

    @property
    @pulumi.getter
    def suspend(self) -> Optional[builtins.bool]:
        """
        suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.
        """
        return pulumi.get(self, "suspend")

    @property
    @pulumi.getter(name="ttlSecondsAfterFinished")
    def ttl_seconds_after_finished(self) -> Optional[builtins.int]:
        """
        ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.
        """
        return pulumi.get(self, "ttl_seconds_after_finished")


@pulumi.output_type
class JobSpecPatch(dict):
    """
    JobSpec describes how the job execution will look like.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDeadlineSeconds":
            suggest = "active_deadline_seconds"
        elif key == "backoffLimit":
            suggest = "backoff_limit"
        elif key == "backoffLimitPerIndex":
            suggest = "backoff_limit_per_index"
        elif key == "completionMode":
            suggest = "completion_mode"
        elif key == "managedBy":
            suggest = "managed_by"
        elif key == "manualSelector":
            suggest = "manual_selector"
        elif key == "maxFailedIndexes":
            suggest = "max_failed_indexes"
        elif key == "podFailurePolicy":
            suggest = "pod_failure_policy"
        elif key == "podReplacementPolicy":
            suggest = "pod_replacement_policy"
        elif key == "successPolicy":
            suggest = "success_policy"
        elif key == "ttlSecondsAfterFinished":
            suggest = "ttl_seconds_after_finished"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_deadline_seconds: Optional[builtins.int] = None,
                 backoff_limit: Optional[builtins.int] = None,
                 backoff_limit_per_index: Optional[builtins.int] = None,
                 completion_mode: Optional[builtins.str] = None,
                 completions: Optional[builtins.int] = None,
                 managed_by: Optional[builtins.str] = None,
                 manual_selector: Optional[builtins.bool] = None,
                 max_failed_indexes: Optional[builtins.int] = None,
                 parallelism: Optional[builtins.int] = None,
                 pod_failure_policy: Optional['outputs.PodFailurePolicyPatch'] = None,
                 pod_replacement_policy: Optional[builtins.str] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 success_policy: Optional['outputs.SuccessPolicyPatch'] = None,
                 suspend: Optional[builtins.bool] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpecPatch'] = None,
                 ttl_seconds_after_finished: Optional[builtins.int] = None):
        """
        JobSpec describes how the job execution will look like.
        :param builtins.int active_deadline_seconds: Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.
        :param builtins.int backoff_limit: Specifies the number of retries before marking this job failed. Defaults to 6
        :param builtins.int backoff_limit_per_index: Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable.
        :param builtins.str completion_mode: completionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.
               
               `NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.
               
               `Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.
               
               More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.
        :param builtins.int completions: Specifies the desired number of successfully finished pods the job should be run with.  Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param builtins.str managed_by: ManagedBy field indicates the controller that manages a Job. The k8s Job controller reconciles jobs which don't have this field at all or the field value is the reserved string `kubernetes.io/job-controller`, but skips reconciling Jobs with a custom value for this field. The value must be a valid domain-prefixed path (e.g. acme.io/foo) - all characters before the first "/" must be a valid subdomain as defined by RFC 1123. All characters trailing the first "/" must be valid HTTP Path characters as defined by RFC 3986. The value cannot exceed 63 characters. This field is immutable.
               
               This field is beta-level. The job controller accepts setting the field when the feature gate JobManagedBy is enabled (enabled by default).
        :param builtins.bool manual_selector: manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
        :param builtins.int max_failed_indexes: Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the `Complete` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5.
        :param builtins.int parallelism: Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param 'PodFailurePolicyPatchArgs' pod_failure_policy: Specifies the policy of handling failed pods. In particular, it allows to specify the set of actions and conditions which need to be satisfied to take the associated action. If empty, the default behaviour applies - the counter of failed pods, represented by the jobs's .status.failed field, is incremented and it is checked against the backoffLimit. This field cannot be used in combination with restartPolicy=OnFailure.
        :param builtins.str pod_replacement_policy: podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods
                 when they are terminating (has a metadata.deletionTimestamp) or failed.
               - Failed means to wait until a previously created Pod is fully terminated (has phase
                 Failed or Succeeded) before creating a replacement Pod.
               
               When using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle. This is on by default.
        :param '_meta.v1.LabelSelectorPatchArgs' selector: A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param 'SuccessPolicyPatchArgs' success_policy: successPolicy specifies the policy when the Job can be declared as succeeded. If empty, the default behavior applies - the Job is declared as succeeded only when the number of succeeded pods equals to the completions. When the field is specified, it must be immutable and works only for the Indexed Jobs. Once the Job meets the SuccessPolicy, the lingering pods are terminated.
        :param builtins.bool suspend: suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.
        :param '_core.v1.PodTemplateSpecPatchArgs' template: Describes the pod that will be created when executing a job. The only allowed template.spec.restartPolicy values are "Never" or "OnFailure". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param builtins.int ttl_seconds_after_finished: ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.
        """
        if active_deadline_seconds is not None:
            pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        if backoff_limit is not None:
            pulumi.set(__self__, "backoff_limit", backoff_limit)
        if backoff_limit_per_index is not None:
            pulumi.set(__self__, "backoff_limit_per_index", backoff_limit_per_index)
        if completion_mode is not None:
            pulumi.set(__self__, "completion_mode", completion_mode)
        if completions is not None:
            pulumi.set(__self__, "completions", completions)
        if managed_by is not None:
            pulumi.set(__self__, "managed_by", managed_by)
        if manual_selector is not None:
            pulumi.set(__self__, "manual_selector", manual_selector)
        if max_failed_indexes is not None:
            pulumi.set(__self__, "max_failed_indexes", max_failed_indexes)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if pod_failure_policy is not None:
            pulumi.set(__self__, "pod_failure_policy", pod_failure_policy)
        if pod_replacement_policy is not None:
            pulumi.set(__self__, "pod_replacement_policy", pod_replacement_policy)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if success_policy is not None:
            pulumi.set(__self__, "success_policy", success_policy)
        if suspend is not None:
            pulumi.set(__self__, "suspend", suspend)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if ttl_seconds_after_finished is not None:
            pulumi.set(__self__, "ttl_seconds_after_finished", ttl_seconds_after_finished)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> Optional[builtins.int]:
        """
        Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.
        """
        return pulumi.get(self, "active_deadline_seconds")

    @property
    @pulumi.getter(name="backoffLimit")
    def backoff_limit(self) -> Optional[builtins.int]:
        """
        Specifies the number of retries before marking this job failed. Defaults to 6
        """
        return pulumi.get(self, "backoff_limit")

    @property
    @pulumi.getter(name="backoffLimitPerIndex")
    def backoff_limit_per_index(self) -> Optional[builtins.int]:
        """
        Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable.
        """
        return pulumi.get(self, "backoff_limit_per_index")

    @property
    @pulumi.getter(name="completionMode")
    def completion_mode(self) -> Optional[builtins.str]:
        """
        completionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.

        `NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.

        `Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.

        More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.
        """
        return pulumi.get(self, "completion_mode")

    @property
    @pulumi.getter
    def completions(self) -> Optional[builtins.int]:
        """
        Specifies the desired number of successfully finished pods the job should be run with.  Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "completions")

    @property
    @pulumi.getter(name="managedBy")
    def managed_by(self) -> Optional[builtins.str]:
        """
        ManagedBy field indicates the controller that manages a Job. The k8s Job controller reconciles jobs which don't have this field at all or the field value is the reserved string `kubernetes.io/job-controller`, but skips reconciling Jobs with a custom value for this field. The value must be a valid domain-prefixed path (e.g. acme.io/foo) - all characters before the first "/" must be a valid subdomain as defined by RFC 1123. All characters trailing the first "/" must be valid HTTP Path characters as defined by RFC 3986. The value cannot exceed 63 characters. This field is immutable.

        This field is beta-level. The job controller accepts setting the field when the feature gate JobManagedBy is enabled (enabled by default).
        """
        return pulumi.get(self, "managed_by")

    @property
    @pulumi.getter(name="manualSelector")
    def manual_selector(self) -> Optional[builtins.bool]:
        """
        manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
        """
        return pulumi.get(self, "manual_selector")

    @property
    @pulumi.getter(name="maxFailedIndexes")
    def max_failed_indexes(self) -> Optional[builtins.int]:
        """
        Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the `Complete` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5.
        """
        return pulumi.get(self, "max_failed_indexes")

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[builtins.int]:
        """
        Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter(name="podFailurePolicy")
    def pod_failure_policy(self) -> Optional['outputs.PodFailurePolicyPatch']:
        """
        Specifies the policy of handling failed pods. In particular, it allows to specify the set of actions and conditions which need to be satisfied to take the associated action. If empty, the default behaviour applies - the counter of failed pods, represented by the jobs's .status.failed field, is incremented and it is checked against the backoffLimit. This field cannot be used in combination with restartPolicy=OnFailure.
        """
        return pulumi.get(self, "pod_failure_policy")

    @property
    @pulumi.getter(name="podReplacementPolicy")
    def pod_replacement_policy(self) -> Optional[builtins.str]:
        """
        podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods
          when they are terminating (has a metadata.deletionTimestamp) or failed.
        - Failed means to wait until a previously created Pod is fully terminated (has phase
          Failed or Succeeded) before creating a replacement Pod.

        When using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle. This is on by default.
        """
        return pulumi.get(self, "pod_replacement_policy")

    @property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="successPolicy")
    def success_policy(self) -> Optional['outputs.SuccessPolicyPatch']:
        """
        successPolicy specifies the policy when the Job can be declared as succeeded. If empty, the default behavior applies - the Job is declared as succeeded only when the number of succeeded pods equals to the completions. When the field is specified, it must be immutable and works only for the Indexed Jobs. Once the Job meets the SuccessPolicy, the lingering pods are terminated.
        """
        return pulumi.get(self, "success_policy")

    @property
    @pulumi.getter
    def suspend(self) -> Optional[builtins.bool]:
        """
        suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.
        """
        return pulumi.get(self, "suspend")

    @property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpecPatch']:
        """
        Describes the pod that will be created when executing a job. The only allowed template.spec.restartPolicy values are "Never" or "OnFailure". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="ttlSecondsAfterFinished")
    def ttl_seconds_after_finished(self) -> Optional[builtins.int]:
        """
        ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.
        """
        return pulumi.get(self, "ttl_seconds_after_finished")


@pulumi.output_type
class JobStatus(dict):
    """
    JobStatus represents the current state of a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completedIndexes":
            suggest = "completed_indexes"
        elif key == "completionTime":
            suggest = "completion_time"
        elif key == "failedIndexes":
            suggest = "failed_indexes"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "uncountedTerminatedPods":
            suggest = "uncounted_terminated_pods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: Optional[builtins.int] = None,
                 completed_indexes: Optional[builtins.str] = None,
                 completion_time: Optional[builtins.str] = None,
                 conditions: Optional[Sequence['outputs.JobCondition']] = None,
                 failed: Optional[builtins.int] = None,
                 failed_indexes: Optional[builtins.str] = None,
                 ready: Optional[builtins.int] = None,
                 start_time: Optional[builtins.str] = None,
                 succeeded: Optional[builtins.int] = None,
                 terminating: Optional[builtins.int] = None,
                 uncounted_terminated_pods: Optional['outputs.UncountedTerminatedPods'] = None):
        """
        JobStatus represents the current state of a Job.
        :param builtins.int active: The number of pending and running pods which are not terminating (without a deletionTimestamp). The value is zero for finished jobs.
        :param builtins.str completed_indexes: completedIndexes holds the completed indexes when .spec.completionMode = "Indexed" in a text format. The indexes are represented as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7".
        :param builtins.str completion_time: Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is set when the job finishes successfully, and only then. The value cannot be updated or removed. The value indicates the same or later point in time as the startTime field.
        :param Sequence['JobConditionArgs'] conditions: The latest available observations of an object's current state. When a Job fails, one of the conditions will have type "Failed" and status true. When a Job is suspended, one of the conditions will have type "Suspended" and status true; when the Job is resumed, the status of this condition will become false. When a Job is completed, one of the conditions will have type "Complete" and status true.
               
               A job is considered finished when it is in a terminal condition, either "Complete" or "Failed". A Job cannot have both the "Complete" and "Failed" conditions. Additionally, it cannot be in the "Complete" and "FailureTarget" conditions. The "Complete", "Failed" and "FailureTarget" conditions cannot be disabled.
               
               More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param builtins.int failed: The number of pods which reached phase Failed. The value increases monotonically.
        :param builtins.str failed_indexes: FailedIndexes holds the failed indexes when spec.backoffLimitPerIndex is set. The indexes are represented in the text format analogous as for the `completedIndexes` field, ie. they are kept as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the failed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". The set of failed indexes cannot overlap with the set of completed indexes.
        :param builtins.int ready: The number of active pods which have a Ready condition and are not terminating (without a deletionTimestamp).
        :param builtins.str start_time: Represents time when the job controller started processing a job. When a Job is created in the suspended state, this field is not set until the first time it is resumed. This field is reset every time a Job is resumed from suspension. It is represented in RFC3339 form and is in UTC.
               
               Once set, the field can only be removed when the job is suspended. The field cannot be modified while the job is unsuspended or finished.
        :param builtins.int succeeded: The number of pods which reached phase Succeeded. The value increases monotonically for a given spec. However, it may decrease in reaction to scale down of elastic indexed jobs.
        :param builtins.int terminating: The number of pods which are terminating (in phase Pending or Running and have a deletionTimestamp).
               
               This field is beta-level. The job controller populates the field when the feature gate JobPodReplacementPolicy is enabled (enabled by default).
        :param 'UncountedTerminatedPodsArgs' uncounted_terminated_pods: uncountedTerminatedPods holds the UIDs of Pods that have terminated but the job controller hasn't yet accounted for in the status counters.
               
               The job controller creates pods with a finalizer. When a pod terminates (succeeded or failed), the controller does three steps to account for it in the job status:
               
               1. Add the pod UID to the arrays in this field. 2. Remove the pod finalizer. 3. Remove the pod UID from the arrays while increasing the corresponding
                   counter.
               
               Old jobs might not be tracked using this field, in which case the field remains null. The structure is empty for finished jobs.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if completed_indexes is not None:
            pulumi.set(__self__, "completed_indexes", completed_indexes)
        if completion_time is not None:
            pulumi.set(__self__, "completion_time", completion_time)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if failed is not None:
            pulumi.set(__self__, "failed", failed)
        if failed_indexes is not None:
            pulumi.set(__self__, "failed_indexes", failed_indexes)
        if ready is not None:
            pulumi.set(__self__, "ready", ready)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if succeeded is not None:
            pulumi.set(__self__, "succeeded", succeeded)
        if terminating is not None:
            pulumi.set(__self__, "terminating", terminating)
        if uncounted_terminated_pods is not None:
            pulumi.set(__self__, "uncounted_terminated_pods", uncounted_terminated_pods)

    @property
    @pulumi.getter
    def active(self) -> Optional[builtins.int]:
        """
        The number of pending and running pods which are not terminating (without a deletionTimestamp). The value is zero for finished jobs.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="completedIndexes")
    def completed_indexes(self) -> Optional[builtins.str]:
        """
        completedIndexes holds the completed indexes when .spec.completionMode = "Indexed" in a text format. The indexes are represented as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7".
        """
        return pulumi.get(self, "completed_indexes")

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> Optional[builtins.str]:
        """
        Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is set when the job finishes successfully, and only then. The value cannot be updated or removed. The value indicates the same or later point in time as the startTime field.
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.JobCondition']]:
        """
        The latest available observations of an object's current state. When a Job fails, one of the conditions will have type "Failed" and status true. When a Job is suspended, one of the conditions will have type "Suspended" and status true; when the Job is resumed, the status of this condition will become false. When a Job is completed, one of the conditions will have type "Complete" and status true.

        A job is considered finished when it is in a terminal condition, either "Complete" or "Failed". A Job cannot have both the "Complete" and "Failed" conditions. Additionally, it cannot be in the "Complete" and "FailureTarget" conditions. The "Complete", "Failed" and "FailureTarget" conditions cannot be disabled.

        More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def failed(self) -> Optional[builtins.int]:
        """
        The number of pods which reached phase Failed. The value increases monotonically.
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter(name="failedIndexes")
    def failed_indexes(self) -> Optional[builtins.str]:
        """
        FailedIndexes holds the failed indexes when spec.backoffLimitPerIndex is set. The indexes are represented in the text format analogous as for the `completedIndexes` field, ie. they are kept as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the failed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". The set of failed indexes cannot overlap with the set of completed indexes.
        """
        return pulumi.get(self, "failed_indexes")

    @property
    @pulumi.getter
    def ready(self) -> Optional[builtins.int]:
        """
        The number of active pods which have a Ready condition and are not terminating (without a deletionTimestamp).
        """
        return pulumi.get(self, "ready")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        Represents time when the job controller started processing a job. When a Job is created in the suspended state, this field is not set until the first time it is resumed. This field is reset every time a Job is resumed from suspension. It is represented in RFC3339 form and is in UTC.

        Once set, the field can only be removed when the job is suspended. The field cannot be modified while the job is unsuspended or finished.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def succeeded(self) -> Optional[builtins.int]:
        """
        The number of pods which reached phase Succeeded. The value increases monotonically for a given spec. However, it may decrease in reaction to scale down of elastic indexed jobs.
        """
        return pulumi.get(self, "succeeded")

    @property
    @pulumi.getter
    def terminating(self) -> Optional[builtins.int]:
        """
        The number of pods which are terminating (in phase Pending or Running and have a deletionTimestamp).

        This field is beta-level. The job controller populates the field when the feature gate JobPodReplacementPolicy is enabled (enabled by default).
        """
        return pulumi.get(self, "terminating")

    @property
    @pulumi.getter(name="uncountedTerminatedPods")
    def uncounted_terminated_pods(self) -> Optional['outputs.UncountedTerminatedPods']:
        """
        uncountedTerminatedPods holds the UIDs of Pods that have terminated but the job controller hasn't yet accounted for in the status counters.

        The job controller creates pods with a finalizer. When a pod terminates (succeeded or failed), the controller does three steps to account for it in the job status:

        1. Add the pod UID to the arrays in this field. 2. Remove the pod finalizer. 3. Remove the pod UID from the arrays while increasing the corresponding
            counter.

        Old jobs might not be tracked using this field, in which case the field remains null. The structure is empty for finished jobs.
        """
        return pulumi.get(self, "uncounted_terminated_pods")


@pulumi.output_type
class JobStatusPatch(dict):
    """
    JobStatus represents the current state of a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completedIndexes":
            suggest = "completed_indexes"
        elif key == "completionTime":
            suggest = "completion_time"
        elif key == "failedIndexes":
            suggest = "failed_indexes"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "uncountedTerminatedPods":
            suggest = "uncounted_terminated_pods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: Optional[builtins.int] = None,
                 completed_indexes: Optional[builtins.str] = None,
                 completion_time: Optional[builtins.str] = None,
                 conditions: Optional[Sequence['outputs.JobConditionPatch']] = None,
                 failed: Optional[builtins.int] = None,
                 failed_indexes: Optional[builtins.str] = None,
                 ready: Optional[builtins.int] = None,
                 start_time: Optional[builtins.str] = None,
                 succeeded: Optional[builtins.int] = None,
                 terminating: Optional[builtins.int] = None,
                 uncounted_terminated_pods: Optional['outputs.UncountedTerminatedPodsPatch'] = None):
        """
        JobStatus represents the current state of a Job.
        :param builtins.int active: The number of pending and running pods which are not terminating (without a deletionTimestamp). The value is zero for finished jobs.
        :param builtins.str completed_indexes: completedIndexes holds the completed indexes when .spec.completionMode = "Indexed" in a text format. The indexes are represented as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7".
        :param builtins.str completion_time: Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is set when the job finishes successfully, and only then. The value cannot be updated or removed. The value indicates the same or later point in time as the startTime field.
        :param Sequence['JobConditionPatchArgs'] conditions: The latest available observations of an object's current state. When a Job fails, one of the conditions will have type "Failed" and status true. When a Job is suspended, one of the conditions will have type "Suspended" and status true; when the Job is resumed, the status of this condition will become false. When a Job is completed, one of the conditions will have type "Complete" and status true.
               
               A job is considered finished when it is in a terminal condition, either "Complete" or "Failed". A Job cannot have both the "Complete" and "Failed" conditions. Additionally, it cannot be in the "Complete" and "FailureTarget" conditions. The "Complete", "Failed" and "FailureTarget" conditions cannot be disabled.
               
               More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param builtins.int failed: The number of pods which reached phase Failed. The value increases monotonically.
        :param builtins.str failed_indexes: FailedIndexes holds the failed indexes when spec.backoffLimitPerIndex is set. The indexes are represented in the text format analogous as for the `completedIndexes` field, ie. they are kept as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the failed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". The set of failed indexes cannot overlap with the set of completed indexes.
        :param builtins.int ready: The number of active pods which have a Ready condition and are not terminating (without a deletionTimestamp).
        :param builtins.str start_time: Represents time when the job controller started processing a job. When a Job is created in the suspended state, this field is not set until the first time it is resumed. This field is reset every time a Job is resumed from suspension. It is represented in RFC3339 form and is in UTC.
               
               Once set, the field can only be removed when the job is suspended. The field cannot be modified while the job is unsuspended or finished.
        :param builtins.int succeeded: The number of pods which reached phase Succeeded. The value increases monotonically for a given spec. However, it may decrease in reaction to scale down of elastic indexed jobs.
        :param builtins.int terminating: The number of pods which are terminating (in phase Pending or Running and have a deletionTimestamp).
               
               This field is beta-level. The job controller populates the field when the feature gate JobPodReplacementPolicy is enabled (enabled by default).
        :param 'UncountedTerminatedPodsPatchArgs' uncounted_terminated_pods: uncountedTerminatedPods holds the UIDs of Pods that have terminated but the job controller hasn't yet accounted for in the status counters.
               
               The job controller creates pods with a finalizer. When a pod terminates (succeeded or failed), the controller does three steps to account for it in the job status:
               
               1. Add the pod UID to the arrays in this field. 2. Remove the pod finalizer. 3. Remove the pod UID from the arrays while increasing the corresponding
                   counter.
               
               Old jobs might not be tracked using this field, in which case the field remains null. The structure is empty for finished jobs.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if completed_indexes is not None:
            pulumi.set(__self__, "completed_indexes", completed_indexes)
        if completion_time is not None:
            pulumi.set(__self__, "completion_time", completion_time)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if failed is not None:
            pulumi.set(__self__, "failed", failed)
        if failed_indexes is not None:
            pulumi.set(__self__, "failed_indexes", failed_indexes)
        if ready is not None:
            pulumi.set(__self__, "ready", ready)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if succeeded is not None:
            pulumi.set(__self__, "succeeded", succeeded)
        if terminating is not None:
            pulumi.set(__self__, "terminating", terminating)
        if uncounted_terminated_pods is not None:
            pulumi.set(__self__, "uncounted_terminated_pods", uncounted_terminated_pods)

    @property
    @pulumi.getter
    def active(self) -> Optional[builtins.int]:
        """
        The number of pending and running pods which are not terminating (without a deletionTimestamp). The value is zero for finished jobs.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="completedIndexes")
    def completed_indexes(self) -> Optional[builtins.str]:
        """
        completedIndexes holds the completed indexes when .spec.completionMode = "Indexed" in a text format. The indexes are represented as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7".
        """
        return pulumi.get(self, "completed_indexes")

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> Optional[builtins.str]:
        """
        Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is set when the job finishes successfully, and only then. The value cannot be updated or removed. The value indicates the same or later point in time as the startTime field.
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.JobConditionPatch']]:
        """
        The latest available observations of an object's current state. When a Job fails, one of the conditions will have type "Failed" and status true. When a Job is suspended, one of the conditions will have type "Suspended" and status true; when the Job is resumed, the status of this condition will become false. When a Job is completed, one of the conditions will have type "Complete" and status true.

        A job is considered finished when it is in a terminal condition, either "Complete" or "Failed". A Job cannot have both the "Complete" and "Failed" conditions. Additionally, it cannot be in the "Complete" and "FailureTarget" conditions. The "Complete", "Failed" and "FailureTarget" conditions cannot be disabled.

        More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def failed(self) -> Optional[builtins.int]:
        """
        The number of pods which reached phase Failed. The value increases monotonically.
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter(name="failedIndexes")
    def failed_indexes(self) -> Optional[builtins.str]:
        """
        FailedIndexes holds the failed indexes when spec.backoffLimitPerIndex is set. The indexes are represented in the text format analogous as for the `completedIndexes` field, ie. they are kept as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the failed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". The set of failed indexes cannot overlap with the set of completed indexes.
        """
        return pulumi.get(self, "failed_indexes")

    @property
    @pulumi.getter
    def ready(self) -> Optional[builtins.int]:
        """
        The number of active pods which have a Ready condition and are not terminating (without a deletionTimestamp).
        """
        return pulumi.get(self, "ready")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.str]:
        """
        Represents time when the job controller started processing a job. When a Job is created in the suspended state, this field is not set until the first time it is resumed. This field is reset every time a Job is resumed from suspension. It is represented in RFC3339 form and is in UTC.

        Once set, the field can only be removed when the job is suspended. The field cannot be modified while the job is unsuspended or finished.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def succeeded(self) -> Optional[builtins.int]:
        """
        The number of pods which reached phase Succeeded. The value increases monotonically for a given spec. However, it may decrease in reaction to scale down of elastic indexed jobs.
        """
        return pulumi.get(self, "succeeded")

    @property
    @pulumi.getter
    def terminating(self) -> Optional[builtins.int]:
        """
        The number of pods which are terminating (in phase Pending or Running and have a deletionTimestamp).

        This field is beta-level. The job controller populates the field when the feature gate JobPodReplacementPolicy is enabled (enabled by default).
        """
        return pulumi.get(self, "terminating")

    @property
    @pulumi.getter(name="uncountedTerminatedPods")
    def uncounted_terminated_pods(self) -> Optional['outputs.UncountedTerminatedPodsPatch']:
        """
        uncountedTerminatedPods holds the UIDs of Pods that have terminated but the job controller hasn't yet accounted for in the status counters.

        The job controller creates pods with a finalizer. When a pod terminates (succeeded or failed), the controller does three steps to account for it in the job status:

        1. Add the pod UID to the arrays in this field. 2. Remove the pod finalizer. 3. Remove the pod UID from the arrays while increasing the corresponding
            counter.

        Old jobs might not be tracked using this field, in which case the field remains null. The structure is empty for finished jobs.
        """
        return pulumi.get(self, "uncounted_terminated_pods")


@pulumi.output_type
class JobTemplateSpec(dict):
    """
    JobTemplateSpec describes the data a Job should have when created from a template
    """
    def __init__(__self__, *,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.JobSpec'] = None):
        """
        JobTemplateSpec describes the data a Job should have when created from a template
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'JobSpecArgs' spec: Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.JobSpec']:
        """
        Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class JobTemplateSpecPatch(dict):
    """
    JobTemplateSpec describes the data a Job should have when created from a template
    """
    def __init__(__self__, *,
                 metadata: Optional['_meta.v1.outputs.ObjectMetaPatch'] = None,
                 spec: Optional['outputs.JobSpecPatch'] = None):
        """
        JobTemplateSpec describes the data a Job should have when created from a template
        :param '_meta.v1.ObjectMetaPatchArgs' metadata: Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'JobSpecPatchArgs' spec: Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMetaPatch']:
        """
        Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.JobSpecPatch']:
        """
        Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class PodFailurePolicy(dict):
    """
    PodFailurePolicy describes how failed pods influence the backoffLimit.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.PodFailurePolicyRule']):
        """
        PodFailurePolicy describes how failed pods influence the backoffLimit.
        :param Sequence['PodFailurePolicyRuleArgs'] rules: A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.PodFailurePolicyRule']:
        """
        A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class PodFailurePolicyOnExitCodesRequirement(dict):
    """
    PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodFailurePolicyOnExitCodesRequirement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodFailurePolicyOnExitCodesRequirement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodFailurePolicyOnExitCodesRequirement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: builtins.str,
                 values: Sequence[builtins.int],
                 container_name: Optional[builtins.str] = None):
        """
        PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check.
        :param builtins.str operator: Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:
               
               - In: the requirement is satisfied if at least one container exit code
                 (might be multiple if there are multiple containers not restricted
                 by the 'containerName' field) is in the set of specified values.
               - NotIn: the requirement is satisfied if at least one container exit code
                 (might be multiple if there are multiple containers not restricted
                 by the 'containerName' field) is not in the set of specified values.
               Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
        :param Sequence[builtins.int] values: Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
        :param builtins.str container_name: Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def operator(self) -> builtins.str:
        """
        Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:

        - In: the requirement is satisfied if at least one container exit code
          (might be multiple if there are multiple containers not restricted
          by the 'containerName' field) is in the set of specified values.
        - NotIn: the requirement is satisfied if at least one container exit code
          (might be multiple if there are multiple containers not restricted
          by the 'containerName' field) is not in the set of specified values.
        Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.int]:
        """
        Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
        """
        return pulumi.get(self, "container_name")


@pulumi.output_type
class PodFailurePolicyOnExitCodesRequirementPatch(dict):
    """
    PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodFailurePolicyOnExitCodesRequirementPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodFailurePolicyOnExitCodesRequirementPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodFailurePolicyOnExitCodesRequirementPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[builtins.str] = None,
                 operator: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.int]] = None):
        """
        PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check.
        :param builtins.str container_name: Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
        :param builtins.str operator: Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:
               
               - In: the requirement is satisfied if at least one container exit code
                 (might be multiple if there are multiple containers not restricted
                 by the 'containerName' field) is in the set of specified values.
               - NotIn: the requirement is satisfied if at least one container exit code
                 (might be multiple if there are multiple containers not restricted
                 by the 'containerName' field) is not in the set of specified values.
               Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
        :param Sequence[builtins.int] values: Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def operator(self) -> Optional[builtins.str]:
        """
        Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:

        - In: the requirement is satisfied if at least one container exit code
          (might be multiple if there are multiple containers not restricted
          by the 'containerName' field) is in the set of specified values.
        - NotIn: the requirement is satisfied if at least one container exit code
          (might be multiple if there are multiple containers not restricted
          by the 'containerName' field) is not in the set of specified values.
        Additional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.int]]:
        """
        Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PodFailurePolicyOnPodConditionsPattern(dict):
    """
    PodFailurePolicyOnPodConditionsPattern describes a pattern for matching an actual pod condition type.
    """
    def __init__(__self__, *,
                 status: builtins.str,
                 type: builtins.str):
        """
        PodFailurePolicyOnPodConditionsPattern describes a pattern for matching an actual pod condition type.
        :param builtins.str status: Specifies the required Pod condition status. To match a pod condition it is required that the specified status equals the pod condition status. Defaults to True.
        :param builtins.str type: Specifies the required Pod condition type. To match a pod condition it is required that specified type equals the pod condition type.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Specifies the required Pod condition status. To match a pod condition it is required that the specified status equals the pod condition status. Defaults to True.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the required Pod condition type. To match a pod condition it is required that specified type equals the pod condition type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PodFailurePolicyOnPodConditionsPatternPatch(dict):
    """
    PodFailurePolicyOnPodConditionsPattern describes a pattern for matching an actual pod condition type.
    """
    def __init__(__self__, *,
                 status: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        PodFailurePolicyOnPodConditionsPattern describes a pattern for matching an actual pod condition type.
        :param builtins.str status: Specifies the required Pod condition status. To match a pod condition it is required that the specified status equals the pod condition status. Defaults to True.
        :param builtins.str type: Specifies the required Pod condition type. To match a pod condition it is required that specified type equals the pod condition type.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Specifies the required Pod condition status. To match a pod condition it is required that the specified status equals the pod condition status. Defaults to True.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Specifies the required Pod condition type. To match a pod condition it is required that specified type equals the pod condition type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PodFailurePolicyPatch(dict):
    """
    PodFailurePolicy describes how failed pods influence the backoffLimit.
    """
    def __init__(__self__, *,
                 rules: Optional[Sequence['outputs.PodFailurePolicyRulePatch']] = None):
        """
        PodFailurePolicy describes how failed pods influence the backoffLimit.
        :param Sequence['PodFailurePolicyRulePatchArgs'] rules: A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.PodFailurePolicyRulePatch']]:
        """
        A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class PodFailurePolicyRule(dict):
    """
    PodFailurePolicyRule describes how a pod failure is handled when the requirements are met. One of onExitCodes and onPodConditions, but not both, can be used in each rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onExitCodes":
            suggest = "on_exit_codes"
        elif key == "onPodConditions":
            suggest = "on_pod_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodFailurePolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodFailurePolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodFailurePolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: builtins.str,
                 on_exit_codes: Optional['outputs.PodFailurePolicyOnExitCodesRequirement'] = None,
                 on_pod_conditions: Optional[Sequence['outputs.PodFailurePolicyOnPodConditionsPattern']] = None):
        """
        PodFailurePolicyRule describes how a pod failure is handled when the requirements are met. One of onExitCodes and onPodConditions, but not both, can be used in each rule.
        :param builtins.str action: Specifies the action taken on a pod failure when the requirements are satisfied. Possible values are:
               
               - FailJob: indicates that the pod's job is marked as Failed and all
                 running pods are terminated.
               - FailIndex: indicates that the pod's index is marked as Failed and will
                 not be restarted.
               - Ignore: indicates that the counter towards the .backoffLimit is not
                 incremented and a replacement pod is created.
               - Count: indicates that the pod is handled in the default way - the
                 counter towards the .backoffLimit is incremented.
               Additional values are considered to be added in the future. Clients should react to an unknown action by skipping the rule.
        :param 'PodFailurePolicyOnExitCodesRequirementArgs' on_exit_codes: Represents the requirement on the container exit codes.
        :param Sequence['PodFailurePolicyOnPodConditionsPatternArgs'] on_pod_conditions: Represents the requirement on the pod conditions. The requirement is represented as a list of pod condition patterns. The requirement is satisfied if at least one pattern matches an actual pod condition. At most 20 elements are allowed.
        """
        pulumi.set(__self__, "action", action)
        if on_exit_codes is not None:
            pulumi.set(__self__, "on_exit_codes", on_exit_codes)
        if on_pod_conditions is not None:
            pulumi.set(__self__, "on_pod_conditions", on_pod_conditions)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Specifies the action taken on a pod failure when the requirements are satisfied. Possible values are:

        - FailJob: indicates that the pod's job is marked as Failed and all
          running pods are terminated.
        - FailIndex: indicates that the pod's index is marked as Failed and will
          not be restarted.
        - Ignore: indicates that the counter towards the .backoffLimit is not
          incremented and a replacement pod is created.
        - Count: indicates that the pod is handled in the default way - the
          counter towards the .backoffLimit is incremented.
        Additional values are considered to be added in the future. Clients should react to an unknown action by skipping the rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="onExitCodes")
    def on_exit_codes(self) -> Optional['outputs.PodFailurePolicyOnExitCodesRequirement']:
        """
        Represents the requirement on the container exit codes.
        """
        return pulumi.get(self, "on_exit_codes")

    @property
    @pulumi.getter(name="onPodConditions")
    def on_pod_conditions(self) -> Optional[Sequence['outputs.PodFailurePolicyOnPodConditionsPattern']]:
        """
        Represents the requirement on the pod conditions. The requirement is represented as a list of pod condition patterns. The requirement is satisfied if at least one pattern matches an actual pod condition. At most 20 elements are allowed.
        """
        return pulumi.get(self, "on_pod_conditions")


@pulumi.output_type
class PodFailurePolicyRulePatch(dict):
    """
    PodFailurePolicyRule describes how a pod failure is handled when the requirements are met. One of onExitCodes and onPodConditions, but not both, can be used in each rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onExitCodes":
            suggest = "on_exit_codes"
        elif key == "onPodConditions":
            suggest = "on_pod_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodFailurePolicyRulePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodFailurePolicyRulePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodFailurePolicyRulePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[builtins.str] = None,
                 on_exit_codes: Optional['outputs.PodFailurePolicyOnExitCodesRequirementPatch'] = None,
                 on_pod_conditions: Optional[Sequence['outputs.PodFailurePolicyOnPodConditionsPatternPatch']] = None):
        """
        PodFailurePolicyRule describes how a pod failure is handled when the requirements are met. One of onExitCodes and onPodConditions, but not both, can be used in each rule.
        :param builtins.str action: Specifies the action taken on a pod failure when the requirements are satisfied. Possible values are:
               
               - FailJob: indicates that the pod's job is marked as Failed and all
                 running pods are terminated.
               - FailIndex: indicates that the pod's index is marked as Failed and will
                 not be restarted.
               - Ignore: indicates that the counter towards the .backoffLimit is not
                 incremented and a replacement pod is created.
               - Count: indicates that the pod is handled in the default way - the
                 counter towards the .backoffLimit is incremented.
               Additional values are considered to be added in the future. Clients should react to an unknown action by skipping the rule.
        :param 'PodFailurePolicyOnExitCodesRequirementPatchArgs' on_exit_codes: Represents the requirement on the container exit codes.
        :param Sequence['PodFailurePolicyOnPodConditionsPatternPatchArgs'] on_pod_conditions: Represents the requirement on the pod conditions. The requirement is represented as a list of pod condition patterns. The requirement is satisfied if at least one pattern matches an actual pod condition. At most 20 elements are allowed.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if on_exit_codes is not None:
            pulumi.set(__self__, "on_exit_codes", on_exit_codes)
        if on_pod_conditions is not None:
            pulumi.set(__self__, "on_pod_conditions", on_pod_conditions)

    @property
    @pulumi.getter
    def action(self) -> Optional[builtins.str]:
        """
        Specifies the action taken on a pod failure when the requirements are satisfied. Possible values are:

        - FailJob: indicates that the pod's job is marked as Failed and all
          running pods are terminated.
        - FailIndex: indicates that the pod's index is marked as Failed and will
          not be restarted.
        - Ignore: indicates that the counter towards the .backoffLimit is not
          incremented and a replacement pod is created.
        - Count: indicates that the pod is handled in the default way - the
          counter towards the .backoffLimit is incremented.
        Additional values are considered to be added in the future. Clients should react to an unknown action by skipping the rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="onExitCodes")
    def on_exit_codes(self) -> Optional['outputs.PodFailurePolicyOnExitCodesRequirementPatch']:
        """
        Represents the requirement on the container exit codes.
        """
        return pulumi.get(self, "on_exit_codes")

    @property
    @pulumi.getter(name="onPodConditions")
    def on_pod_conditions(self) -> Optional[Sequence['outputs.PodFailurePolicyOnPodConditionsPatternPatch']]:
        """
        Represents the requirement on the pod conditions. The requirement is represented as a list of pod condition patterns. The requirement is satisfied if at least one pattern matches an actual pod condition. At most 20 elements are allowed.
        """
        return pulumi.get(self, "on_pod_conditions")


@pulumi.output_type
class SuccessPolicy(dict):
    """
    SuccessPolicy describes when a Job can be declared as succeeded based on the success of some indexes.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.SuccessPolicyRule']):
        """
        SuccessPolicy describes when a Job can be declared as succeeded based on the success of some indexes.
        :param Sequence['SuccessPolicyRuleArgs'] rules: rules represents the list of alternative rules for the declaring the Jobs as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met, the "SucceededCriteriaMet" condition is added, and the lingering pods are removed. The terminal state for such a Job has the "Complete" condition. Additionally, these rules are evaluated in order; Once the Job meets one of the rules, other rules are ignored. At most 20 elements are allowed.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.SuccessPolicyRule']:
        """
        rules represents the list of alternative rules for the declaring the Jobs as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met, the "SucceededCriteriaMet" condition is added, and the lingering pods are removed. The terminal state for such a Job has the "Complete" condition. Additionally, these rules are evaluated in order; Once the Job meets one of the rules, other rules are ignored. At most 20 elements are allowed.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class SuccessPolicyPatch(dict):
    """
    SuccessPolicy describes when a Job can be declared as succeeded based on the success of some indexes.
    """
    def __init__(__self__, *,
                 rules: Optional[Sequence['outputs.SuccessPolicyRulePatch']] = None):
        """
        SuccessPolicy describes when a Job can be declared as succeeded based on the success of some indexes.
        :param Sequence['SuccessPolicyRulePatchArgs'] rules: rules represents the list of alternative rules for the declaring the Jobs as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met, the "SucceededCriteriaMet" condition is added, and the lingering pods are removed. The terminal state for such a Job has the "Complete" condition. Additionally, these rules are evaluated in order; Once the Job meets one of the rules, other rules are ignored. At most 20 elements are allowed.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.SuccessPolicyRulePatch']]:
        """
        rules represents the list of alternative rules for the declaring the Jobs as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met, the "SucceededCriteriaMet" condition is added, and the lingering pods are removed. The terminal state for such a Job has the "Complete" condition. Additionally, these rules are evaluated in order; Once the Job meets one of the rules, other rules are ignored. At most 20 elements are allowed.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class SuccessPolicyRule(dict):
    """
    SuccessPolicyRule describes rule for declaring a Job as succeeded. Each rule must have at least one of the "succeededIndexes" or "succeededCount" specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "succeededCount":
            suggest = "succeeded_count"
        elif key == "succeededIndexes":
            suggest = "succeeded_indexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SuccessPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SuccessPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SuccessPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 succeeded_count: Optional[builtins.int] = None,
                 succeeded_indexes: Optional[builtins.str] = None):
        """
        SuccessPolicyRule describes rule for declaring a Job as succeeded. Each rule must have at least one of the "succeededIndexes" or "succeededCount" specified.
        :param builtins.int succeeded_count: succeededCount specifies the minimal required size of the actual set of the succeeded indexes for the Job. When succeededCount is used along with succeededIndexes, the check is constrained only to the set of indexes specified by succeededIndexes. For example, given that succeededIndexes is "1-4", succeededCount is "3", and completed indexes are "1", "3", and "5", the Job isn't declared as succeeded because only "1" and "3" indexes are considered in that rules. When this field is null, this doesn't default to any value and is never evaluated at any time. When specified it needs to be a positive integer.
        :param builtins.str succeeded_indexes: succeededIndexes specifies the set of indexes which need to be contained in the actual set of the succeeded indexes for the Job. The list of indexes must be within 0 to ".spec.completions-1" and must not contain duplicates. At least one element is required. The indexes are represented as intervals separated by commas. The intervals can be a decimal integer or a pair of decimal integers separated by a hyphen. The number are listed in represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". When this field is null, this field doesn't default to any value and is never evaluated at any time.
        """
        if succeeded_count is not None:
            pulumi.set(__self__, "succeeded_count", succeeded_count)
        if succeeded_indexes is not None:
            pulumi.set(__self__, "succeeded_indexes", succeeded_indexes)

    @property
    @pulumi.getter(name="succeededCount")
    def succeeded_count(self) -> Optional[builtins.int]:
        """
        succeededCount specifies the minimal required size of the actual set of the succeeded indexes for the Job. When succeededCount is used along with succeededIndexes, the check is constrained only to the set of indexes specified by succeededIndexes. For example, given that succeededIndexes is "1-4", succeededCount is "3", and completed indexes are "1", "3", and "5", the Job isn't declared as succeeded because only "1" and "3" indexes are considered in that rules. When this field is null, this doesn't default to any value and is never evaluated at any time. When specified it needs to be a positive integer.
        """
        return pulumi.get(self, "succeeded_count")

    @property
    @pulumi.getter(name="succeededIndexes")
    def succeeded_indexes(self) -> Optional[builtins.str]:
        """
        succeededIndexes specifies the set of indexes which need to be contained in the actual set of the succeeded indexes for the Job. The list of indexes must be within 0 to ".spec.completions-1" and must not contain duplicates. At least one element is required. The indexes are represented as intervals separated by commas. The intervals can be a decimal integer or a pair of decimal integers separated by a hyphen. The number are listed in represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". When this field is null, this field doesn't default to any value and is never evaluated at any time.
        """
        return pulumi.get(self, "succeeded_indexes")


@pulumi.output_type
class SuccessPolicyRulePatch(dict):
    """
    SuccessPolicyRule describes rule for declaring a Job as succeeded. Each rule must have at least one of the "succeededIndexes" or "succeededCount" specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "succeededCount":
            suggest = "succeeded_count"
        elif key == "succeededIndexes":
            suggest = "succeeded_indexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SuccessPolicyRulePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SuccessPolicyRulePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SuccessPolicyRulePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 succeeded_count: Optional[builtins.int] = None,
                 succeeded_indexes: Optional[builtins.str] = None):
        """
        SuccessPolicyRule describes rule for declaring a Job as succeeded. Each rule must have at least one of the "succeededIndexes" or "succeededCount" specified.
        :param builtins.int succeeded_count: succeededCount specifies the minimal required size of the actual set of the succeeded indexes for the Job. When succeededCount is used along with succeededIndexes, the check is constrained only to the set of indexes specified by succeededIndexes. For example, given that succeededIndexes is "1-4", succeededCount is "3", and completed indexes are "1", "3", and "5", the Job isn't declared as succeeded because only "1" and "3" indexes are considered in that rules. When this field is null, this doesn't default to any value and is never evaluated at any time. When specified it needs to be a positive integer.
        :param builtins.str succeeded_indexes: succeededIndexes specifies the set of indexes which need to be contained in the actual set of the succeeded indexes for the Job. The list of indexes must be within 0 to ".spec.completions-1" and must not contain duplicates. At least one element is required. The indexes are represented as intervals separated by commas. The intervals can be a decimal integer or a pair of decimal integers separated by a hyphen. The number are listed in represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". When this field is null, this field doesn't default to any value and is never evaluated at any time.
        """
        if succeeded_count is not None:
            pulumi.set(__self__, "succeeded_count", succeeded_count)
        if succeeded_indexes is not None:
            pulumi.set(__self__, "succeeded_indexes", succeeded_indexes)

    @property
    @pulumi.getter(name="succeededCount")
    def succeeded_count(self) -> Optional[builtins.int]:
        """
        succeededCount specifies the minimal required size of the actual set of the succeeded indexes for the Job. When succeededCount is used along with succeededIndexes, the check is constrained only to the set of indexes specified by succeededIndexes. For example, given that succeededIndexes is "1-4", succeededCount is "3", and completed indexes are "1", "3", and "5", the Job isn't declared as succeeded because only "1" and "3" indexes are considered in that rules. When this field is null, this doesn't default to any value and is never evaluated at any time. When specified it needs to be a positive integer.
        """
        return pulumi.get(self, "succeeded_count")

    @property
    @pulumi.getter(name="succeededIndexes")
    def succeeded_indexes(self) -> Optional[builtins.str]:
        """
        succeededIndexes specifies the set of indexes which need to be contained in the actual set of the succeeded indexes for the Job. The list of indexes must be within 0 to ".spec.completions-1" and must not contain duplicates. At least one element is required. The indexes are represented as intervals separated by commas. The intervals can be a decimal integer or a pair of decimal integers separated by a hyphen. The number are listed in represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as "1,3-5,7". When this field is null, this field doesn't default to any value and is never evaluated at any time.
        """
        return pulumi.get(self, "succeeded_indexes")


@pulumi.output_type
class UncountedTerminatedPods(dict):
    """
    UncountedTerminatedPods holds UIDs of Pods that have terminated but haven't been accounted in Job status counters.
    """
    def __init__(__self__, *,
                 failed: Optional[Sequence[builtins.str]] = None,
                 succeeded: Optional[Sequence[builtins.str]] = None):
        """
        UncountedTerminatedPods holds UIDs of Pods that have terminated but haven't been accounted in Job status counters.
        :param Sequence[builtins.str] failed: failed holds UIDs of failed Pods.
        :param Sequence[builtins.str] succeeded: succeeded holds UIDs of succeeded Pods.
        """
        if failed is not None:
            pulumi.set(__self__, "failed", failed)
        if succeeded is not None:
            pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter
    def failed(self) -> Optional[Sequence[builtins.str]]:
        """
        failed holds UIDs of failed Pods.
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter
    def succeeded(self) -> Optional[Sequence[builtins.str]]:
        """
        succeeded holds UIDs of succeeded Pods.
        """
        return pulumi.get(self, "succeeded")


@pulumi.output_type
class UncountedTerminatedPodsPatch(dict):
    """
    UncountedTerminatedPods holds UIDs of Pods that have terminated but haven't been accounted in Job status counters.
    """
    def __init__(__self__, *,
                 failed: Optional[Sequence[builtins.str]] = None,
                 succeeded: Optional[Sequence[builtins.str]] = None):
        """
        UncountedTerminatedPods holds UIDs of Pods that have terminated but haven't been accounted in Job status counters.
        :param Sequence[builtins.str] failed: failed holds UIDs of failed Pods.
        :param Sequence[builtins.str] succeeded: succeeded holds UIDs of succeeded Pods.
        """
        if failed is not None:
            pulumi.set(__self__, "failed", failed)
        if succeeded is not None:
            pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter
    def failed(self) -> Optional[Sequence[builtins.str]]:
        """
        failed holds UIDs of failed Pods.
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter
    def succeeded(self) -> Optional[Sequence[builtins.str]]:
        """
        succeeded holds UIDs of succeeded Pods.
        """
        return pulumi.get(self, "succeeded")


