# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from ... import meta as _meta

__all__ = [
    'CertificateSigningRequestConditionArgs',
    'CertificateSigningRequestConditionArgsDict',
    'CertificateSigningRequestSpecPatchArgs',
    'CertificateSigningRequestSpecPatchArgsDict',
    'CertificateSigningRequestSpecArgs',
    'CertificateSigningRequestSpecArgsDict',
    'CertificateSigningRequestStatusArgs',
    'CertificateSigningRequestStatusArgsDict',
    'CertificateSigningRequestArgs',
    'CertificateSigningRequestArgsDict',
    'ClusterTrustBundleSpecPatchArgs',
    'ClusterTrustBundleSpecPatchArgsDict',
    'ClusterTrustBundleSpecArgs',
    'ClusterTrustBundleSpecArgsDict',
    'ClusterTrustBundleArgs',
    'ClusterTrustBundleArgsDict',
]

MYPY = False

if not MYPY:
    class CertificateSigningRequestConditionArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        request approval state, currently Approved or Denied.
        """
        last_transition_time: NotRequired[pulumi.Input[builtins.str]]
        """
        lastTransitionTime is the time the condition last transitioned from one status to another. If unset, when a new condition type is added or an existing condition's status is changed, the server defaults this to the current time.
        """
        last_update_time: NotRequired[pulumi.Input[builtins.str]]
        """
        timestamp for the last update to this condition
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        human readable message with details about the request state
        """
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        brief reason for the request state
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        Status of the condition, one of True, False, Unknown. Approved, Denied, and Failed conditions may not be "False" or "Unknown". Defaults to "True". If unset, should be treated as "True".
        """
elif False:
    CertificateSigningRequestConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateSigningRequestConditionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 last_transition_time: Optional[pulumi.Input[builtins.str]] = None,
                 last_update_time: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: request approval state, currently Approved or Denied.
        :param pulumi.Input[builtins.str] last_transition_time: lastTransitionTime is the time the condition last transitioned from one status to another. If unset, when a new condition type is added or an existing condition's status is changed, the server defaults this to the current time.
        :param pulumi.Input[builtins.str] last_update_time: timestamp for the last update to this condition
        :param pulumi.Input[builtins.str] message: human readable message with details about the request state
        :param pulumi.Input[builtins.str] reason: brief reason for the request state
        :param pulumi.Input[builtins.str] status: Status of the condition, one of True, False, Unknown. Approved, Denied, and Failed conditions may not be "False" or "Unknown". Defaults to "True". If unset, should be treated as "True".
        """
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        request approval state, currently Approved or Denied.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        lastTransitionTime is the time the condition last transitioned from one status to another. If unset, when a new condition type is added or an existing condition's status is changed, the server defaults this to the current time.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        timestamp for the last update to this condition
        """
        return pulumi.get(self, "last_update_time")

    @last_update_time.setter
    def last_update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_update_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        human readable message with details about the request state
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        brief reason for the request state
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the condition, one of True, False, Unknown. Approved, Denied, and Failed conditions may not be "False" or "Unknown". Defaults to "True". If unset, should be treated as "True".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class CertificateSigningRequestSpecPatchArgsDict(TypedDict):
        """
        This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
        """
        extra: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]
        """
        Extra information about the requesting user. See user.Info interface for details.
        """
        groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Group information about the requesting user. See user.Info interface for details.
        """
        request: NotRequired[pulumi.Input[builtins.str]]
        """
        Base64-encoded PKCS#10 CSR data
        """
        signer_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
         1. If it's a kubelet client certificate, it is assigned
            "kubernetes.io/kube-apiserver-client-kubelet".
         2. If it's a kubelet serving certificate, it is assigned
            "kubernetes.io/kubelet-serving".
         3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
        Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        """
        uid: NotRequired[pulumi.Input[builtins.str]]
        """
        UID information about the requesting user. See user.Info interface for details.
        """
        usages: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
             https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        Information about the requesting user. See user.Info interface for details.
        """
elif False:
    CertificateSigningRequestSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateSigningRequestSpecPatchArgs:
    def __init__(__self__, *,
                 extra: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 request: Optional[pulumi.Input[builtins.str]] = None,
                 signer_name: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 usages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] extra: Extra information about the requesting user. See user.Info interface for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: Group information about the requesting user. See user.Info interface for details.
        :param pulumi.Input[builtins.str] request: Base64-encoded PKCS#10 CSR data
        :param pulumi.Input[builtins.str] signer_name: Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
                1. If it's a kubelet client certificate, it is assigned
                   "kubernetes.io/kube-apiserver-client-kubelet".
                2. If it's a kubelet serving certificate, it is assigned
                   "kubernetes.io/kubelet-serving".
                3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
               Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        :param pulumi.Input[builtins.str] uid: UID information about the requesting user. See user.Info interface for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] usages: allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
                    https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        :param pulumi.Input[builtins.str] username: Information about the requesting user. See user.Info interface for details.
        """
        if extra is not None:
            pulumi.set(__self__, "extra", extra)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def extra(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        Extra information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "extra")

    @extra.setter
    def extra(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "extra", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Group information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded PKCS#10 CSR data
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
         1. If it's a kubelet client certificate, it is assigned
            "kubernetes.io/kube-apiserver-client-kubelet".
         2. If it's a kubelet serving certificate, it is assigned
            "kubernetes.io/kubelet-serving".
         3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
        Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        """
        return pulumi.get(self, "signer_name")

    @signer_name.setter
    def signer_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signer_name", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UID information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
             https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        """
        return pulumi.get(self, "usages")

    @usages.setter
    def usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "usages", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class CertificateSigningRequestSpecArgsDict(TypedDict):
        """
        This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
        """
        request: pulumi.Input[builtins.str]
        """
        Base64-encoded PKCS#10 CSR data
        """
        extra: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]
        """
        Extra information about the requesting user. See user.Info interface for details.
        """
        groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Group information about the requesting user. See user.Info interface for details.
        """
        signer_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
         1. If it's a kubelet client certificate, it is assigned
            "kubernetes.io/kube-apiserver-client-kubelet".
         2. If it's a kubelet serving certificate, it is assigned
            "kubernetes.io/kubelet-serving".
         3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
        Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        """
        uid: NotRequired[pulumi.Input[builtins.str]]
        """
        UID information about the requesting user. See user.Info interface for details.
        """
        usages: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
             https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        Information about the requesting user. See user.Info interface for details.
        """
elif False:
    CertificateSigningRequestSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateSigningRequestSpecArgs:
    def __init__(__self__, *,
                 request: pulumi.Input[builtins.str],
                 extra: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 signer_name: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 usages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
        :param pulumi.Input[builtins.str] request: Base64-encoded PKCS#10 CSR data
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] extra: Extra information about the requesting user. See user.Info interface for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: Group information about the requesting user. See user.Info interface for details.
        :param pulumi.Input[builtins.str] signer_name: Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
                1. If it's a kubelet client certificate, it is assigned
                   "kubernetes.io/kube-apiserver-client-kubelet".
                2. If it's a kubelet serving certificate, it is assigned
                   "kubernetes.io/kubelet-serving".
                3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
               Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        :param pulumi.Input[builtins.str] uid: UID information about the requesting user. See user.Info interface for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] usages: allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
                    https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        :param pulumi.Input[builtins.str] username: Information about the requesting user. See user.Info interface for details.
        """
        pulumi.set(__self__, "request", request)
        if extra is not None:
            pulumi.set(__self__, "extra", extra)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def request(self) -> pulumi.Input[builtins.str]:
        """
        Base64-encoded PKCS#10 CSR data
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter
    def extra(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        Extra information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "extra")

    @extra.setter
    def extra(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "extra", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Group information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
         1. If it's a kubelet client certificate, it is assigned
            "kubernetes.io/kube-apiserver-client-kubelet".
         2. If it's a kubelet serving certificate, it is assigned
            "kubernetes.io/kubelet-serving".
         3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
        Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        """
        return pulumi.get(self, "signer_name")

    @signer_name.setter
    def signer_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signer_name", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UID information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def usages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
             https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        """
        return pulumi.get(self, "usages")

    @usages.setter
    def usages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "usages", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class CertificateSigningRequestStatusArgsDict(TypedDict):
        certificate: NotRequired[pulumi.Input[builtins.str]]
        """
        If request was approved, the controller will place the issued certificate here.
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['CertificateSigningRequestConditionArgsDict']]]]
        """
        Conditions applied to the request, such as approval or denial.
        """
elif False:
    CertificateSigningRequestStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateSigningRequestStatusArgs:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSigningRequestConditionArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] certificate: If request was approved, the controller will place the issued certificate here.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateSigningRequestConditionArgs']]] conditions: Conditions applied to the request, such as approval or denial.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If request was approved, the controller will place the issued certificate here.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSigningRequestConditionArgs']]]]:
        """
        Conditions applied to the request, such as approval or denial.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSigningRequestConditionArgs']]]]):
        pulumi.set(self, "conditions", value)


if not MYPY:
    class CertificateSigningRequestArgsDict(TypedDict):
        """
        Describes a certificate signing request
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        spec: NotRequired[pulumi.Input['CertificateSigningRequestSpecArgsDict']]
        """
        The certificate request itself and any additional information.
        """
        status: NotRequired[pulumi.Input['CertificateSigningRequestStatusArgsDict']]
        """
        Derived information about the request.
        """
elif False:
    CertificateSigningRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateSigningRequestArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['CertificateSigningRequestSpecArgs']] = None,
                 status: Optional[pulumi.Input['CertificateSigningRequestStatusArgs']] = None):
        """
        Describes a certificate signing request
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['CertificateSigningRequestSpecArgs'] spec: The certificate request itself and any additional information.
        :param pulumi.Input['CertificateSigningRequestStatusArgs'] status: Derived information about the request.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'certificates.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'CertificateSigningRequest')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['CertificateSigningRequestSpecArgs']]:
        """
        The certificate request itself and any additional information.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['CertificateSigningRequestSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['CertificateSigningRequestStatusArgs']]:
        """
        Derived information about the request.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['CertificateSigningRequestStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ClusterTrustBundleSpecPatchArgsDict(TypedDict):
        """
        ClusterTrustBundleSpec contains the signer and trust anchors.
        """
        signer_name: NotRequired[pulumi.Input[builtins.str]]
        """
        signerName indicates the associated signer, if any.

        In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.

        If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.

        If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.

        List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        """
        trust_bundle: NotRequired[pulumi.Input[builtins.str]]
        """
        trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.

        The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.

        Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        """
elif False:
    ClusterTrustBundleSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterTrustBundleSpecPatchArgs:
    def __init__(__self__, *,
                 signer_name: Optional[pulumi.Input[builtins.str]] = None,
                 trust_bundle: Optional[pulumi.Input[builtins.str]] = None):
        """
        ClusterTrustBundleSpec contains the signer and trust anchors.
        :param pulumi.Input[builtins.str] signer_name: signerName indicates the associated signer, if any.
               
               In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.
               
               If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.
               
               If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.
               
               List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        :param pulumi.Input[builtins.str] trust_bundle: trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.
               
               The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.
               
               Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        """
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)
        if trust_bundle is not None:
            pulumi.set(__self__, "trust_bundle", trust_bundle)

    @property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        signerName indicates the associated signer, if any.

        In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.

        If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.

        If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.

        List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        """
        return pulumi.get(self, "signer_name")

    @signer_name.setter
    def signer_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signer_name", value)

    @property
    @pulumi.getter(name="trustBundle")
    def trust_bundle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.

        The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.

        Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        """
        return pulumi.get(self, "trust_bundle")

    @trust_bundle.setter
    def trust_bundle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trust_bundle", value)


if not MYPY:
    class ClusterTrustBundleSpecArgsDict(TypedDict):
        """
        ClusterTrustBundleSpec contains the signer and trust anchors.
        """
        trust_bundle: pulumi.Input[builtins.str]
        """
        trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.

        The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.

        Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        """
        signer_name: NotRequired[pulumi.Input[builtins.str]]
        """
        signerName indicates the associated signer, if any.

        In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.

        If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.

        If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.

        List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        """
elif False:
    ClusterTrustBundleSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterTrustBundleSpecArgs:
    def __init__(__self__, *,
                 trust_bundle: pulumi.Input[builtins.str],
                 signer_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        ClusterTrustBundleSpec contains the signer and trust anchors.
        :param pulumi.Input[builtins.str] trust_bundle: trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.
               
               The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.
               
               Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        :param pulumi.Input[builtins.str] signer_name: signerName indicates the associated signer, if any.
               
               In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.
               
               If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.
               
               If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.
               
               List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        """
        pulumi.set(__self__, "trust_bundle", trust_bundle)
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)

    @property
    @pulumi.getter(name="trustBundle")
    def trust_bundle(self) -> pulumi.Input[builtins.str]:
        """
        trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.

        The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.

        Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        """
        return pulumi.get(self, "trust_bundle")

    @trust_bundle.setter
    def trust_bundle(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "trust_bundle", value)

    @property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        signerName indicates the associated signer, if any.

        In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.

        If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.

        If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.

        List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        """
        return pulumi.get(self, "signer_name")

    @signer_name.setter
    def signer_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signer_name", value)


if not MYPY:
    class ClusterTrustBundleArgsDict(TypedDict):
        """
        ClusterTrustBundle is a cluster-scoped container for X.509 trust anchors (root certificates).

        ClusterTrustBundle objects are considered to be readable by any authenticated user in the cluster, because they can be mounted by pods using the `clusterTrustBundle` projection.  All service accounts have read access to ClusterTrustBundles by default.  Users who only have namespace-level access to a cluster can read ClusterTrustBundles by impersonating a serviceaccount that they have access to.

        It can be optionally associated with a particular assigner, in which case it contains one valid set of trust anchors for that signer. Signers may have multiple associated ClusterTrustBundles; each is an independent set of trust anchors for that signer. Admission control is used to enforce that only users with permissions on the signer can create or modify the corresponding bundle.
        """
        spec: pulumi.Input['ClusterTrustBundleSpecArgsDict']
        """
        spec contains the signer (if any) and trust anchors.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        metadata contains the object metadata.
        """
elif False:
    ClusterTrustBundleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterTrustBundleArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ClusterTrustBundleSpecArgs'],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ClusterTrustBundle is a cluster-scoped container for X.509 trust anchors (root certificates).

        ClusterTrustBundle objects are considered to be readable by any authenticated user in the cluster, because they can be mounted by pods using the `clusterTrustBundle` projection.  All service accounts have read access to ClusterTrustBundles by default.  Users who only have namespace-level access to a cluster can read ClusterTrustBundles by impersonating a serviceaccount that they have access to.

        It can be optionally associated with a particular assigner, in which case it contains one valid set of trust anchors for that signer. Signers may have multiple associated ClusterTrustBundles; each is an independent set of trust anchors for that signer. Admission control is used to enforce that only users with permissions on the signer can create or modify the corresponding bundle.
        :param pulumi.Input['ClusterTrustBundleSpecArgs'] spec: spec contains the signer (if any) and trust anchors.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: metadata contains the object metadata.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'certificates.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ClusterTrustBundle')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ClusterTrustBundleSpecArgs']:
        """
        spec contains the signer (if any) and trust anchors.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ClusterTrustBundleSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        metadata contains the object metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


