# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'CertificateSigningRequest',
    'CertificateSigningRequestCondition',
    'CertificateSigningRequestConditionPatch',
    'CertificateSigningRequestSpec',
    'CertificateSigningRequestSpecPatch',
    'CertificateSigningRequestStatus',
    'CertificateSigningRequestStatusPatch',
    'ClusterTrustBundle',
    'ClusterTrustBundleSpec',
    'ClusterTrustBundleSpecPatch',
]

@pulumi.output_type
class CertificateSigningRequest(dict):
    """
    Describes a certificate signing request
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSigningRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSigningRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSigningRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.CertificateSigningRequestSpec'] = None,
                 status: Optional['outputs.CertificateSigningRequestStatus'] = None):
        """
        Describes a certificate signing request
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param 'CertificateSigningRequestSpecArgs' spec: The certificate request itself and any additional information.
        :param 'CertificateSigningRequestStatusArgs' status: Derived information about the request.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'certificates.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'CertificateSigningRequest')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.CertificateSigningRequestSpec']:
        """
        The certificate request itself and any additional information.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.CertificateSigningRequestStatus']:
        """
        Derived information about the request.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CertificateSigningRequestCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "lastUpdateTime":
            suggest = "last_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSigningRequestCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSigningRequestCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSigningRequestCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 last_transition_time: Optional[builtins.str] = None,
                 last_update_time: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 reason: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None):
        """
        :param builtins.str type: request approval state, currently Approved or Denied.
        :param builtins.str last_transition_time: lastTransitionTime is the time the condition last transitioned from one status to another. If unset, when a new condition type is added or an existing condition's status is changed, the server defaults this to the current time.
        :param builtins.str last_update_time: timestamp for the last update to this condition
        :param builtins.str message: human readable message with details about the request state
        :param builtins.str reason: brief reason for the request state
        :param builtins.str status: Status of the condition, one of True, False, Unknown. Approved, Denied, and Failed conditions may not be "False" or "Unknown". Defaults to "True". If unset, should be treated as "True".
        """
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        request approval state, currently Approved or Denied.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[builtins.str]:
        """
        lastTransitionTime is the time the condition last transitioned from one status to another. If unset, when a new condition type is added or an existing condition's status is changed, the server defaults this to the current time.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[builtins.str]:
        """
        timestamp for the last update to this condition
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        human readable message with details about the request state
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[builtins.str]:
        """
        brief reason for the request state
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of the condition, one of True, False, Unknown. Approved, Denied, and Failed conditions may not be "False" or "Unknown". Defaults to "True". If unset, should be treated as "True".
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CertificateSigningRequestConditionPatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "lastUpdateTime":
            suggest = "last_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSigningRequestConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSigningRequestConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSigningRequestConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[builtins.str] = None,
                 last_update_time: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 reason: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str last_transition_time: lastTransitionTime is the time the condition last transitioned from one status to another. If unset, when a new condition type is added or an existing condition's status is changed, the server defaults this to the current time.
        :param builtins.str last_update_time: timestamp for the last update to this condition
        :param builtins.str message: human readable message with details about the request state
        :param builtins.str reason: brief reason for the request state
        :param builtins.str status: Status of the condition, one of True, False, Unknown. Approved, Denied, and Failed conditions may not be "False" or "Unknown". Defaults to "True". If unset, should be treated as "True".
        :param builtins.str type: request approval state, currently Approved or Denied.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[builtins.str]:
        """
        lastTransitionTime is the time the condition last transitioned from one status to another. If unset, when a new condition type is added or an existing condition's status is changed, the server defaults this to the current time.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[builtins.str]:
        """
        timestamp for the last update to this condition
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        human readable message with details about the request state
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[builtins.str]:
        """
        brief reason for the request state
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of the condition, one of True, False, Unknown. Approved, Denied, and Failed conditions may not be "False" or "Unknown". Defaults to "True". If unset, should be treated as "True".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        request approval state, currently Approved or Denied.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CertificateSigningRequestSpec(dict):
    """
    This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signerName":
            suggest = "signer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSigningRequestSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSigningRequestSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSigningRequestSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request: builtins.str,
                 extra: Optional[Mapping[str, Sequence[builtins.str]]] = None,
                 groups: Optional[Sequence[builtins.str]] = None,
                 signer_name: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None,
                 usages: Optional[Sequence[builtins.str]] = None,
                 username: Optional[builtins.str] = None):
        """
        This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
        :param builtins.str request: Base64-encoded PKCS#10 CSR data
        :param Mapping[str, Sequence[builtins.str]] extra: Extra information about the requesting user. See user.Info interface for details.
        :param Sequence[builtins.str] groups: Group information about the requesting user. See user.Info interface for details.
        :param builtins.str signer_name: Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
                1. If it's a kubelet client certificate, it is assigned
                   "kubernetes.io/kube-apiserver-client-kubelet".
                2. If it's a kubelet serving certificate, it is assigned
                   "kubernetes.io/kubelet-serving".
                3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
               Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        :param builtins.str uid: UID information about the requesting user. See user.Info interface for details.
        :param Sequence[builtins.str] usages: allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
                    https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        :param builtins.str username: Information about the requesting user. See user.Info interface for details.
        """
        pulumi.set(__self__, "request", request)
        if extra is not None:
            pulumi.set(__self__, "extra", extra)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def request(self) -> builtins.str:
        """
        Base64-encoded PKCS#10 CSR data
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def extra(self) -> Optional[Mapping[str, Sequence[builtins.str]]]:
        """
        Extra information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "extra")

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[builtins.str]]:
        """
        Group information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[builtins.str]:
        """
        Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
         1. If it's a kubelet client certificate, it is assigned
            "kubernetes.io/kube-apiserver-client-kubelet".
         2. If it's a kubelet serving certificate, it is assigned
            "kubernetes.io/kubelet-serving".
         3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
        Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        """
        return pulumi.get(self, "signer_name")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        UID information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def usages(self) -> Optional[Sequence[builtins.str]]:
        """
        allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
             https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        """
        return pulumi.get(self, "usages")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class CertificateSigningRequestSpecPatch(dict):
    """
    This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signerName":
            suggest = "signer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSigningRequestSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSigningRequestSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSigningRequestSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extra: Optional[Mapping[str, Sequence[builtins.str]]] = None,
                 groups: Optional[Sequence[builtins.str]] = None,
                 request: Optional[builtins.str] = None,
                 signer_name: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None,
                 usages: Optional[Sequence[builtins.str]] = None,
                 username: Optional[builtins.str] = None):
        """
        This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
        :param Mapping[str, Sequence[builtins.str]] extra: Extra information about the requesting user. See user.Info interface for details.
        :param Sequence[builtins.str] groups: Group information about the requesting user. See user.Info interface for details.
        :param builtins.str request: Base64-encoded PKCS#10 CSR data
        :param builtins.str signer_name: Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
                1. If it's a kubelet client certificate, it is assigned
                   "kubernetes.io/kube-apiserver-client-kubelet".
                2. If it's a kubelet serving certificate, it is assigned
                   "kubernetes.io/kubelet-serving".
                3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
               Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        :param builtins.str uid: UID information about the requesting user. See user.Info interface for details.
        :param Sequence[builtins.str] usages: allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
                    https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        :param builtins.str username: Information about the requesting user. See user.Info interface for details.
        """
        if extra is not None:
            pulumi.set(__self__, "extra", extra)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def extra(self) -> Optional[Mapping[str, Sequence[builtins.str]]]:
        """
        Extra information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "extra")

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[builtins.str]]:
        """
        Group information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def request(self) -> Optional[builtins.str]:
        """
        Base64-encoded PKCS#10 CSR data
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[builtins.str]:
        """
        Requested signer for the request. It is a qualified name in the form: `scope-hostname.io/name`. If empty, it will be defaulted:
         1. If it's a kubelet client certificate, it is assigned
            "kubernetes.io/kube-apiserver-client-kubelet".
         2. If it's a kubelet serving certificate, it is assigned
            "kubernetes.io/kubelet-serving".
         3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
        Distribution of trust for signers happens out of band. You can select on this field using `spec.signerName`.
        """
        return pulumi.get(self, "signer_name")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        UID information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def usages(self) -> Optional[Sequence[builtins.str]]:
        """
        allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
             https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        """
        return pulumi.get(self, "usages")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Information about the requesting user. See user.Info interface for details.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class CertificateSigningRequestStatus(dict):
    def __init__(__self__, *,
                 certificate: Optional[builtins.str] = None,
                 conditions: Optional[Sequence['outputs.CertificateSigningRequestCondition']] = None):
        """
        :param builtins.str certificate: If request was approved, the controller will place the issued certificate here.
        :param Sequence['CertificateSigningRequestConditionArgs'] conditions: Conditions applied to the request, such as approval or denial.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        If request was approved, the controller will place the issued certificate here.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.CertificateSigningRequestCondition']]:
        """
        Conditions applied to the request, such as approval or denial.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class CertificateSigningRequestStatusPatch(dict):
    def __init__(__self__, *,
                 certificate: Optional[builtins.str] = None,
                 conditions: Optional[Sequence['outputs.CertificateSigningRequestConditionPatch']] = None):
        """
        :param builtins.str certificate: If request was approved, the controller will place the issued certificate here.
        :param Sequence['CertificateSigningRequestConditionPatchArgs'] conditions: Conditions applied to the request, such as approval or denial.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        If request was approved, the controller will place the issued certificate here.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.CertificateSigningRequestConditionPatch']]:
        """
        Conditions applied to the request, such as approval or denial.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class ClusterTrustBundle(dict):
    """
    ClusterTrustBundle is a cluster-scoped container for X.509 trust anchors (root certificates).

    ClusterTrustBundle objects are considered to be readable by any authenticated user in the cluster, because they can be mounted by pods using the `clusterTrustBundle` projection.  All service accounts have read access to ClusterTrustBundles by default.  Users who only have namespace-level access to a cluster can read ClusterTrustBundles by impersonating a serviceaccount that they have access to.

    It can be optionally associated with a particular assigner, in which case it contains one valid set of trust anchors for that signer. Signers may have multiple associated ClusterTrustBundles; each is an independent set of trust anchors for that signer. Admission control is used to enforce that only users with permissions on the signer can create or modify the corresponding bundle.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTrustBundle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTrustBundle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTrustBundle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ClusterTrustBundleSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ClusterTrustBundle is a cluster-scoped container for X.509 trust anchors (root certificates).

        ClusterTrustBundle objects are considered to be readable by any authenticated user in the cluster, because they can be mounted by pods using the `clusterTrustBundle` projection.  All service accounts have read access to ClusterTrustBundles by default.  Users who only have namespace-level access to a cluster can read ClusterTrustBundles by impersonating a serviceaccount that they have access to.

        It can be optionally associated with a particular assigner, in which case it contains one valid set of trust anchors for that signer. Signers may have multiple associated ClusterTrustBundles; each is an independent set of trust anchors for that signer. Admission control is used to enforce that only users with permissions on the signer can create or modify the corresponding bundle.
        :param 'ClusterTrustBundleSpecArgs' spec: spec contains the signer (if any) and trust anchors.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: metadata contains the object metadata.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'certificates.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ClusterTrustBundle')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ClusterTrustBundleSpec':
        """
        spec contains the signer (if any) and trust anchors.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        metadata contains the object metadata.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ClusterTrustBundleSpec(dict):
    """
    ClusterTrustBundleSpec contains the signer and trust anchors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustBundle":
            suggest = "trust_bundle"
        elif key == "signerName":
            suggest = "signer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTrustBundleSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTrustBundleSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTrustBundleSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trust_bundle: builtins.str,
                 signer_name: Optional[builtins.str] = None):
        """
        ClusterTrustBundleSpec contains the signer and trust anchors.
        :param builtins.str trust_bundle: trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.
               
               The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.
               
               Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        :param builtins.str signer_name: signerName indicates the associated signer, if any.
               
               In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.
               
               If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.
               
               If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.
               
               List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        """
        pulumi.set(__self__, "trust_bundle", trust_bundle)
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)

    @property
    @pulumi.getter(name="trustBundle")
    def trust_bundle(self) -> builtins.str:
        """
        trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.

        The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.

        Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        """
        return pulumi.get(self, "trust_bundle")

    @property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[builtins.str]:
        """
        signerName indicates the associated signer, if any.

        In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.

        If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.

        If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.

        List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        """
        return pulumi.get(self, "signer_name")


@pulumi.output_type
class ClusterTrustBundleSpecPatch(dict):
    """
    ClusterTrustBundleSpec contains the signer and trust anchors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signerName":
            suggest = "signer_name"
        elif key == "trustBundle":
            suggest = "trust_bundle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTrustBundleSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTrustBundleSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTrustBundleSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signer_name: Optional[builtins.str] = None,
                 trust_bundle: Optional[builtins.str] = None):
        """
        ClusterTrustBundleSpec contains the signer and trust anchors.
        :param builtins.str signer_name: signerName indicates the associated signer, if any.
               
               In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.
               
               If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.
               
               If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.
               
               List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        :param builtins.str trust_bundle: trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.
               
               The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.
               
               Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        """
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)
        if trust_bundle is not None:
            pulumi.set(__self__, "trust_bundle", trust_bundle)

    @property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[builtins.str]:
        """
        signerName indicates the associated signer, if any.

        In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.

        If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.

        If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.

        List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.
        """
        return pulumi.get(self, "signer_name")

    @property
    @pulumi.getter(name="trustBundle")
    def trust_bundle(self) -> Optional[builtins.str]:
        """
        trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.

        The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.

        Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.
        """
        return pulumi.get(self, "trust_bundle")


