# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'Lease',
    'LeaseSpec',
    'LeaseSpecPatch',
]

@pulumi.output_type
class Lease(dict):
    """
    Lease defines a lease concept.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Lease. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Lease.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Lease.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.LeaseSpec'] = None):
        """
        Lease defines a lease concept.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'LeaseSpecArgs' spec: spec contains the specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'coordination.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Lease')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.LeaseSpec']:
        """
        spec contains the specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class LeaseSpec(dict):
    """
    LeaseSpec is a specification of a Lease.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acquireTime":
            suggest = "acquire_time"
        elif key == "holderIdentity":
            suggest = "holder_identity"
        elif key == "leaseDurationSeconds":
            suggest = "lease_duration_seconds"
        elif key == "leaseTransitions":
            suggest = "lease_transitions"
        elif key == "preferredHolder":
            suggest = "preferred_holder"
        elif key == "renewTime":
            suggest = "renew_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LeaseSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LeaseSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LeaseSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acquire_time: Optional[builtins.str] = None,
                 holder_identity: Optional[builtins.str] = None,
                 lease_duration_seconds: Optional[builtins.int] = None,
                 lease_transitions: Optional[builtins.int] = None,
                 preferred_holder: Optional[builtins.str] = None,
                 renew_time: Optional[builtins.str] = None,
                 strategy: Optional[builtins.str] = None):
        """
        LeaseSpec is a specification of a Lease.
        :param builtins.str acquire_time: acquireTime is a time when the current lease was acquired.
        :param builtins.str holder_identity: holderIdentity contains the identity of the holder of a current lease. If Coordinated Leader Election is used, the holder identity must be equal to the elected LeaseCandidate.metadata.name field.
        :param builtins.int lease_duration_seconds: leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it. This is measured against the time of last observed renewTime.
        :param builtins.int lease_transitions: leaseTransitions is the number of transitions of a lease between holders.
        :param builtins.str preferred_holder: PreferredHolder signals to a lease holder that the lease has a more optimal holder and should be given up. This field can only be set if Strategy is also set.
        :param builtins.str renew_time: renewTime is a time when the current holder of a lease has last updated the lease.
        :param builtins.str strategy: Strategy indicates the strategy for picking the leader for coordinated leader election. If the field is not specified, there is no active coordination for this lease. (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.
        """
        if acquire_time is not None:
            pulumi.set(__self__, "acquire_time", acquire_time)
        if holder_identity is not None:
            pulumi.set(__self__, "holder_identity", holder_identity)
        if lease_duration_seconds is not None:
            pulumi.set(__self__, "lease_duration_seconds", lease_duration_seconds)
        if lease_transitions is not None:
            pulumi.set(__self__, "lease_transitions", lease_transitions)
        if preferred_holder is not None:
            pulumi.set(__self__, "preferred_holder", preferred_holder)
        if renew_time is not None:
            pulumi.set(__self__, "renew_time", renew_time)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="acquireTime")
    def acquire_time(self) -> Optional[builtins.str]:
        """
        acquireTime is a time when the current lease was acquired.
        """
        return pulumi.get(self, "acquire_time")

    @property
    @pulumi.getter(name="holderIdentity")
    def holder_identity(self) -> Optional[builtins.str]:
        """
        holderIdentity contains the identity of the holder of a current lease. If Coordinated Leader Election is used, the holder identity must be equal to the elected LeaseCandidate.metadata.name field.
        """
        return pulumi.get(self, "holder_identity")

    @property
    @pulumi.getter(name="leaseDurationSeconds")
    def lease_duration_seconds(self) -> Optional[builtins.int]:
        """
        leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it. This is measured against the time of last observed renewTime.
        """
        return pulumi.get(self, "lease_duration_seconds")

    @property
    @pulumi.getter(name="leaseTransitions")
    def lease_transitions(self) -> Optional[builtins.int]:
        """
        leaseTransitions is the number of transitions of a lease between holders.
        """
        return pulumi.get(self, "lease_transitions")

    @property
    @pulumi.getter(name="preferredHolder")
    def preferred_holder(self) -> Optional[builtins.str]:
        """
        PreferredHolder signals to a lease holder that the lease has a more optimal holder and should be given up. This field can only be set if Strategy is also set.
        """
        return pulumi.get(self, "preferred_holder")

    @property
    @pulumi.getter(name="renewTime")
    def renew_time(self) -> Optional[builtins.str]:
        """
        renewTime is a time when the current holder of a lease has last updated the lease.
        """
        return pulumi.get(self, "renew_time")

    @property
    @pulumi.getter
    def strategy(self) -> Optional[builtins.str]:
        """
        Strategy indicates the strategy for picking the leader for coordinated leader election. If the field is not specified, there is no active coordination for this lease. (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class LeaseSpecPatch(dict):
    """
    LeaseSpec is a specification of a Lease.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acquireTime":
            suggest = "acquire_time"
        elif key == "holderIdentity":
            suggest = "holder_identity"
        elif key == "leaseDurationSeconds":
            suggest = "lease_duration_seconds"
        elif key == "leaseTransitions":
            suggest = "lease_transitions"
        elif key == "preferredHolder":
            suggest = "preferred_holder"
        elif key == "renewTime":
            suggest = "renew_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LeaseSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LeaseSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LeaseSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acquire_time: Optional[builtins.str] = None,
                 holder_identity: Optional[builtins.str] = None,
                 lease_duration_seconds: Optional[builtins.int] = None,
                 lease_transitions: Optional[builtins.int] = None,
                 preferred_holder: Optional[builtins.str] = None,
                 renew_time: Optional[builtins.str] = None,
                 strategy: Optional[builtins.str] = None):
        """
        LeaseSpec is a specification of a Lease.
        :param builtins.str acquire_time: acquireTime is a time when the current lease was acquired.
        :param builtins.str holder_identity: holderIdentity contains the identity of the holder of a current lease. If Coordinated Leader Election is used, the holder identity must be equal to the elected LeaseCandidate.metadata.name field.
        :param builtins.int lease_duration_seconds: leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it. This is measured against the time of last observed renewTime.
        :param builtins.int lease_transitions: leaseTransitions is the number of transitions of a lease between holders.
        :param builtins.str preferred_holder: PreferredHolder signals to a lease holder that the lease has a more optimal holder and should be given up. This field can only be set if Strategy is also set.
        :param builtins.str renew_time: renewTime is a time when the current holder of a lease has last updated the lease.
        :param builtins.str strategy: Strategy indicates the strategy for picking the leader for coordinated leader election. If the field is not specified, there is no active coordination for this lease. (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.
        """
        if acquire_time is not None:
            pulumi.set(__self__, "acquire_time", acquire_time)
        if holder_identity is not None:
            pulumi.set(__self__, "holder_identity", holder_identity)
        if lease_duration_seconds is not None:
            pulumi.set(__self__, "lease_duration_seconds", lease_duration_seconds)
        if lease_transitions is not None:
            pulumi.set(__self__, "lease_transitions", lease_transitions)
        if preferred_holder is not None:
            pulumi.set(__self__, "preferred_holder", preferred_holder)
        if renew_time is not None:
            pulumi.set(__self__, "renew_time", renew_time)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="acquireTime")
    def acquire_time(self) -> Optional[builtins.str]:
        """
        acquireTime is a time when the current lease was acquired.
        """
        return pulumi.get(self, "acquire_time")

    @property
    @pulumi.getter(name="holderIdentity")
    def holder_identity(self) -> Optional[builtins.str]:
        """
        holderIdentity contains the identity of the holder of a current lease. If Coordinated Leader Election is used, the holder identity must be equal to the elected LeaseCandidate.metadata.name field.
        """
        return pulumi.get(self, "holder_identity")

    @property
    @pulumi.getter(name="leaseDurationSeconds")
    def lease_duration_seconds(self) -> Optional[builtins.int]:
        """
        leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it. This is measured against the time of last observed renewTime.
        """
        return pulumi.get(self, "lease_duration_seconds")

    @property
    @pulumi.getter(name="leaseTransitions")
    def lease_transitions(self) -> Optional[builtins.int]:
        """
        leaseTransitions is the number of transitions of a lease between holders.
        """
        return pulumi.get(self, "lease_transitions")

    @property
    @pulumi.getter(name="preferredHolder")
    def preferred_holder(self) -> Optional[builtins.str]:
        """
        PreferredHolder signals to a lease holder that the lease has a more optimal holder and should be given up. This field can only be set if Strategy is also set.
        """
        return pulumi.get(self, "preferred_holder")

    @property
    @pulumi.getter(name="renewTime")
    def renew_time(self) -> Optional[builtins.str]:
        """
        renewTime is a time when the current holder of a lease has last updated the lease.
        """
        return pulumi.get(self, "renew_time")

    @property
    @pulumi.getter
    def strategy(self) -> Optional[builtins.str]:
        """
        Strategy indicates the strategy for picking the leader for coordinated leader election. If the field is not specified, there is no active coordination for this lease. (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.
        """
        return pulumi.get(self, "strategy")


