# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta
from ._inputs import *

__all__ = ['EventInitArgs', 'Event']

@pulumi.input_type
class EventInitArgs:
    def __init__(__self__, *,
                 involved_object: pulumi.Input['ObjectReferenceArgs'],
                 metadata: pulumi.Input['_meta.v1.ObjectMetaArgs'],
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 count: Optional[pulumi.Input[builtins.int]] = None,
                 event_time: Optional[pulumi.Input[builtins.str]] = None,
                 first_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 last_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 related: Optional[pulumi.Input['ObjectReferenceArgs']] = None,
                 reporting_component: Optional[pulumi.Input[builtins.str]] = None,
                 reporting_instance: Optional[pulumi.Input[builtins.str]] = None,
                 series: Optional[pulumi.Input['EventSeriesArgs']] = None,
                 source: Optional[pulumi.Input['EventSourceArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Event resource.
        :param pulumi.Input['ObjectReferenceArgs'] involved_object: The object that this event is about.
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[builtins.str] action: What action was taken/failed regarding to the Regarding object.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.int] count: The number of times this event has occurred.
        :param pulumi.Input[builtins.str] event_time: Time when this Event was first observed.
        :param pulumi.Input[builtins.str] first_timestamp: The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[builtins.str] last_timestamp: The time at which the most recent occurrence of this event was recorded.
        :param pulumi.Input[builtins.str] message: A human-readable description of the status of this operation.
        :param pulumi.Input[builtins.str] reason: This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        :param pulumi.Input['ObjectReferenceArgs'] related: Optional secondary object for more complex actions.
        :param pulumi.Input[builtins.str] reporting_component: Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        :param pulumi.Input[builtins.str] reporting_instance: ID of the controller instance, e.g. `kubelet-xyzf`.
        :param pulumi.Input['EventSeriesArgs'] series: Data about the Event series this event represents or nil if it's a singleton Event.
        :param pulumi.Input['EventSourceArgs'] source: The component reporting this event. Should be a short machine understandable string.
        :param pulumi.Input[builtins.str] type: Type of this event (Normal, Warning), new types could be added in the future
        """
        pulumi.set(__self__, "involved_object", involved_object)
        pulumi.set(__self__, "metadata", metadata)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if count is not None:
            pulumi.set(__self__, "count", count)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if first_timestamp is not None:
            pulumi.set(__self__, "first_timestamp", first_timestamp)
        if kind is not None:
            pulumi.set(__self__, "kind", 'Event')
        if last_timestamp is not None:
            pulumi.set(__self__, "last_timestamp", last_timestamp)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if related is not None:
            pulumi.set(__self__, "related", related)
        if reporting_component is not None:
            pulumi.set(__self__, "reporting_component", reporting_component)
        if reporting_instance is not None:
            pulumi.set(__self__, "reporting_instance", reporting_instance)
        if series is not None:
            pulumi.set(__self__, "series", series)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="involvedObject")
    def involved_object(self) -> pulumi.Input['ObjectReferenceArgs']:
        """
        The object that this event is about.
        """
        return pulumi.get(self, "involved_object")

    @involved_object.setter
    def involved_object(self, value: pulumi.Input['ObjectReferenceArgs']):
        pulumi.set(self, "involved_object", value)

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Input['_meta.v1.ObjectMetaArgs']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input['_meta.v1.ObjectMetaArgs']):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        What action was taken/failed regarding to the Regarding object.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of times this event has occurred.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when this Event was first observed.
        """
        return pulumi.get(self, "event_time")

    @event_time.setter
    def event_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_time", value)

    @property
    @pulumi.getter(name="firstTimestamp")
    def first_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        """
        return pulumi.get(self, "first_timestamp")

    @first_timestamp.setter
    def first_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "first_timestamp", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="lastTimestamp")
    def last_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the most recent occurrence of this event was recorded.
        """
        return pulumi.get(self, "last_timestamp")

    @last_timestamp.setter
    def last_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_timestamp", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the status of this operation.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def related(self) -> Optional[pulumi.Input['ObjectReferenceArgs']]:
        """
        Optional secondary object for more complex actions.
        """
        return pulumi.get(self, "related")

    @related.setter
    def related(self, value: Optional[pulumi.Input['ObjectReferenceArgs']]):
        pulumi.set(self, "related", value)

    @property
    @pulumi.getter(name="reportingComponent")
    def reporting_component(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        """
        return pulumi.get(self, "reporting_component")

    @reporting_component.setter
    def reporting_component(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reporting_component", value)

    @property
    @pulumi.getter(name="reportingInstance")
    def reporting_instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the controller instance, e.g. `kubelet-xyzf`.
        """
        return pulumi.get(self, "reporting_instance")

    @reporting_instance.setter
    def reporting_instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reporting_instance", value)

    @property
    @pulumi.getter
    def series(self) -> Optional[pulumi.Input['EventSeriesArgs']]:
        """
        Data about the Event series this event represents or nil if it's a singleton Event.
        """
        return pulumi.get(self, "series")

    @series.setter
    def series(self, value: Optional[pulumi.Input['EventSeriesArgs']]):
        pulumi.set(self, "series", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['EventSourceArgs']]:
        """
        The component reporting this event. Should be a short machine understandable string.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['EventSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of this event (Normal, Warning), new types could be added in the future
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("kubernetes:core/v1:Event")
class Event(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 count: Optional[pulumi.Input[builtins.int]] = None,
                 event_time: Optional[pulumi.Input[builtins.str]] = None,
                 first_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 involved_object: Optional[pulumi.Input[Union['ObjectReferenceArgs', 'ObjectReferenceArgsDict']]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 last_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['_meta.v1.ObjectMetaArgs', '_meta.v1.ObjectMetaArgsDict']]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 related: Optional[pulumi.Input[Union['ObjectReferenceArgs', 'ObjectReferenceArgsDict']]] = None,
                 reporting_component: Optional[pulumi.Input[builtins.str]] = None,
                 reporting_instance: Optional[pulumi.Input[builtins.str]] = None,
                 series: Optional[pulumi.Input[Union['EventSeriesArgs', 'EventSeriesArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['EventSourceArgs', 'EventSourceArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: What action was taken/failed regarding to the Regarding object.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.int] count: The number of times this event has occurred.
        :param pulumi.Input[builtins.str] event_time: Time when this Event was first observed.
        :param pulumi.Input[builtins.str] first_timestamp: The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        :param pulumi.Input[Union['ObjectReferenceArgs', 'ObjectReferenceArgsDict']] involved_object: The object that this event is about.
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[builtins.str] last_timestamp: The time at which the most recent occurrence of this event was recorded.
        :param pulumi.Input[builtins.str] message: A human-readable description of the status of this operation.
        :param pulumi.Input[Union['_meta.v1.ObjectMetaArgs', '_meta.v1.ObjectMetaArgsDict']] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[builtins.str] reason: This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        :param pulumi.Input[Union['ObjectReferenceArgs', 'ObjectReferenceArgsDict']] related: Optional secondary object for more complex actions.
        :param pulumi.Input[builtins.str] reporting_component: Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        :param pulumi.Input[builtins.str] reporting_instance: ID of the controller instance, e.g. `kubelet-xyzf`.
        :param pulumi.Input[Union['EventSeriesArgs', 'EventSeriesArgsDict']] series: Data about the Event series this event represents or nil if it's a singleton Event.
        :param pulumi.Input[Union['EventSourceArgs', 'EventSourceArgsDict']] source: The component reporting this event. Should be a short machine understandable string.
        :param pulumi.Input[builtins.str] type: Type of this event (Normal, Warning), new types could be added in the future
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.

        :param str resource_name: The name of the resource.
        :param EventInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 count: Optional[pulumi.Input[builtins.int]] = None,
                 event_time: Optional[pulumi.Input[builtins.str]] = None,
                 first_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 involved_object: Optional[pulumi.Input[Union['ObjectReferenceArgs', 'ObjectReferenceArgsDict']]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 last_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['_meta.v1.ObjectMetaArgs', '_meta.v1.ObjectMetaArgsDict']]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 related: Optional[pulumi.Input[Union['ObjectReferenceArgs', 'ObjectReferenceArgsDict']]] = None,
                 reporting_component: Optional[pulumi.Input[builtins.str]] = None,
                 reporting_instance: Optional[pulumi.Input[builtins.str]] = None,
                 series: Optional[pulumi.Input[Union['EventSeriesArgs', 'EventSeriesArgsDict']]] = None,
                 source: Optional[pulumi.Input[Union['EventSourceArgs', 'EventSourceArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventInitArgs.__new__(EventInitArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["api_version"] = 'v1'
            __props__.__dict__["count"] = count
            __props__.__dict__["event_time"] = event_time
            __props__.__dict__["first_timestamp"] = first_timestamp
            if involved_object is None and not opts.urn:
                raise TypeError("Missing required property 'involved_object'")
            __props__.__dict__["involved_object"] = involved_object
            __props__.__dict__["kind"] = 'Event'
            __props__.__dict__["last_timestamp"] = last_timestamp
            __props__.__dict__["message"] = message
            if metadata is None and not opts.urn:
                raise TypeError("Missing required property 'metadata'")
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["reason"] = reason
            __props__.__dict__["related"] = related
            __props__.__dict__["reporting_component"] = reporting_component
            __props__.__dict__["reporting_instance"] = reporting_instance
            __props__.__dict__["series"] = series
            __props__.__dict__["source"] = source
            __props__.__dict__["type"] = type
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="kubernetes:events.k8s.io/v1:Event"), pulumi.Alias(type_="kubernetes:events.k8s.io/v1beta1:Event")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Event, __self__).__init__(
            'kubernetes:core/v1:Event',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Event':
        """
        Get an existing Event resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EventInitArgs.__new__(EventInitArgs)

        __props__.__dict__["action"] = None
        __props__.__dict__["api_version"] = None
        __props__.__dict__["count"] = None
        __props__.__dict__["event_time"] = None
        __props__.__dict__["first_timestamp"] = None
        __props__.__dict__["involved_object"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["last_timestamp"] = None
        __props__.__dict__["message"] = None
        __props__.__dict__["metadata"] = None
        __props__.__dict__["reason"] = None
        __props__.__dict__["related"] = None
        __props__.__dict__["reporting_component"] = None
        __props__.__dict__["reporting_instance"] = None
        __props__.__dict__["series"] = None
        __props__.__dict__["source"] = None
        __props__.__dict__["type"] = None
        return Event(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        What action was taken/failed regarding to the Regarding object.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def count(self) -> pulumi.Output[builtins.int]:
        """
        The number of times this event has occurred.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> pulumi.Output[builtins.str]:
        """
        Time when this Event was first observed.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="firstTimestamp")
    def first_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        """
        return pulumi.get(self, "first_timestamp")

    @property
    @pulumi.getter(name="involvedObject")
    def involved_object(self) -> pulumi.Output['outputs.ObjectReference']:
        """
        The object that this event is about.
        """
        return pulumi.get(self, "involved_object")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastTimestamp")
    def last_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the most recent occurrence of this event was recorded.
        """
        return pulumi.get(self, "last_timestamp")

    @property
    @pulumi.getter
    def message(self) -> pulumi.Output[builtins.str]:
        """
        A human-readable description of the status of this operation.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Output[builtins.str]:
        """
        This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def related(self) -> pulumi.Output['outputs.ObjectReference']:
        """
        Optional secondary object for more complex actions.
        """
        return pulumi.get(self, "related")

    @property
    @pulumi.getter(name="reportingComponent")
    def reporting_component(self) -> pulumi.Output[builtins.str]:
        """
        Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        """
        return pulumi.get(self, "reporting_component")

    @property
    @pulumi.getter(name="reportingInstance")
    def reporting_instance(self) -> pulumi.Output[builtins.str]:
        """
        ID of the controller instance, e.g. `kubelet-xyzf`.
        """
        return pulumi.get(self, "reporting_instance")

    @property
    @pulumi.getter
    def series(self) -> pulumi.Output['outputs.EventSeries']:
        """
        Data about the Event series this event represents or nil if it's a singleton Event.
        """
        return pulumi.get(self, "series")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.EventSource']:
        """
        The component reporting this event. Should be a short machine understandable string.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of this event (Normal, Warning), new types could be added in the future
        """
        return pulumi.get(self, "type")

