# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities

__all__ = [
    'ConditionArgs',
    'ConditionArgsDict',
    'LabelSelectorPatchArgs',
    'LabelSelectorPatchArgsDict',
    'LabelSelectorRequirementPatchArgs',
    'LabelSelectorRequirementPatchArgsDict',
    'LabelSelectorRequirementArgs',
    'LabelSelectorRequirementArgsDict',
    'LabelSelectorArgs',
    'LabelSelectorArgsDict',
    'ListMetaPatchArgs',
    'ListMetaPatchArgsDict',
    'ListMetaArgs',
    'ListMetaArgsDict',
    'ManagedFieldsEntryPatchArgs',
    'ManagedFieldsEntryPatchArgsDict',
    'ManagedFieldsEntryArgs',
    'ManagedFieldsEntryArgsDict',
    'ObjectMetaPatchArgs',
    'ObjectMetaPatchArgsDict',
    'ObjectMetaArgs',
    'ObjectMetaArgsDict',
    'OwnerReferencePatchArgs',
    'OwnerReferencePatchArgsDict',
    'OwnerReferenceArgs',
    'OwnerReferenceArgsDict',
    'StatusCausePatchArgs',
    'StatusCausePatchArgsDict',
    'StatusCauseArgs',
    'StatusCauseArgsDict',
    'StatusDetailsPatchArgs',
    'StatusDetailsPatchArgsDict',
    'StatusDetailsArgs',
    'StatusDetailsArgsDict',
]

MYPY = False

if not MYPY:
    class ConditionArgsDict(TypedDict):
        """
        Condition contains details for one aspect of the current state of this API Resource.
        """
        last_transition_time: pulumi.Input[builtins.str]
        """
        lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.
        """
        message: pulumi.Input[builtins.str]
        """
        message is a human readable message indicating details about the transition. This may be an empty string.
        """
        reason: pulumi.Input[builtins.str]
        """
        reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty.
        """
        status: pulumi.Input[builtins.str]
        """
        status of the condition, one of True, False, Unknown.
        """
        type: pulumi.Input[builtins.str]
        """
        type of condition in CamelCase or in foo.example.com/CamelCase.
        """
        observed_generation: NotRequired[pulumi.Input[builtins.int]]
        """
        observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance.
        """
elif False:
    ConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConditionArgs:
    def __init__(__self__, *,
                 last_transition_time: pulumi.Input[builtins.str],
                 message: pulumi.Input[builtins.str],
                 reason: pulumi.Input[builtins.str],
                 status: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 observed_generation: Optional[pulumi.Input[builtins.int]] = None):
        """
        Condition contains details for one aspect of the current state of this API Resource.
        :param pulumi.Input[builtins.str] last_transition_time: lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.
        :param pulumi.Input[builtins.str] message: message is a human readable message indicating details about the transition. This may be an empty string.
        :param pulumi.Input[builtins.str] reason: reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty.
        :param pulumi.Input[builtins.str] status: status of the condition, one of True, False, Unknown.
        :param pulumi.Input[builtins.str] type: type of condition in CamelCase or in foo.example.com/CamelCase.
        :param pulumi.Input[builtins.int] observed_generation: observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance.
        """
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> pulumi.Input[builtins.str]:
        """
        lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> pulumi.Input[builtins.str]:
        """
        message is a human readable message indicating details about the transition. This may be an empty string.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Input[builtins.str]:
        """
        reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[builtins.str]:
        """
        status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        type of condition in CamelCase or in foo.example.com/CamelCase.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "observed_generation", value)


if not MYPY:
    class LabelSelectorPatchArgsDict(TypedDict):
        """
        A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.
        """
        match_expressions: NotRequired[pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementPatchArgsDict']]]]
        """
        matchExpressions is a list of label selector requirements. The requirements are ANDed.
        """
        match_labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
        """
elif False:
    LabelSelectorPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LabelSelectorPatchArgs:
    def __init__(__self__, *,
                 match_expressions: Optional[pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementPatchArgs']]]] = None,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.
        :param pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementPatchArgs']]] match_expressions: matchExpressions is a list of label selector requirements. The requirements are ANDed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] match_labels: matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
        """
        if match_expressions is not None:
            pulumi.set(__self__, "match_expressions", match_expressions)
        if match_labels is not None:
            pulumi.set(__self__, "match_labels", match_labels)

    @property
    @pulumi.getter(name="matchExpressions")
    def match_expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementPatchArgs']]]]:
        """
        matchExpressions is a list of label selector requirements. The requirements are ANDed.
        """
        return pulumi.get(self, "match_expressions")

    @match_expressions.setter
    def match_expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementPatchArgs']]]]):
        pulumi.set(self, "match_expressions", value)

    @property
    @pulumi.getter(name="matchLabels")
    def match_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
        """
        return pulumi.get(self, "match_labels")

    @match_labels.setter
    def match_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "match_labels", value)


if not MYPY:
    class LabelSelectorRequirementPatchArgsDict(TypedDict):
        """
        A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        key is the label key that the selector applies to.
        """
        operator: NotRequired[pulumi.Input[builtins.str]]
        """
        operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        """
elif False:
    LabelSelectorRequirementPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LabelSelectorRequirementPatchArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 operator: Optional[pulumi.Input[builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
        :param pulumi.Input[builtins.str] key: key is the label key that the selector applies to.
        :param pulumi.Input[builtins.str] operator: operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        key is the label key that the selector applies to.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class LabelSelectorRequirementArgsDict(TypedDict):
        """
        A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
        """
        key: pulumi.Input[builtins.str]
        """
        key is the label key that the selector applies to.
        """
        operator: pulumi.Input[builtins.str]
        """
        operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        """
elif False:
    LabelSelectorRequirementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LabelSelectorRequirementArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 operator: pulumi.Input[builtins.str],
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
        :param pulumi.Input[builtins.str] key: key is the label key that the selector applies to.
        :param pulumi.Input[builtins.str] operator: operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        key is the label key that the selector applies to.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[builtins.str]:
        """
        operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class LabelSelectorArgsDict(TypedDict):
        """
        A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.
        """
        match_expressions: NotRequired[pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementArgsDict']]]]
        """
        matchExpressions is a list of label selector requirements. The requirements are ANDed.
        """
        match_labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
        """
elif False:
    LabelSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LabelSelectorArgs:
    def __init__(__self__, *,
                 match_expressions: Optional[pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementArgs']]]] = None,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.
        :param pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementArgs']]] match_expressions: matchExpressions is a list of label selector requirements. The requirements are ANDed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] match_labels: matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
        """
        if match_expressions is not None:
            pulumi.set(__self__, "match_expressions", match_expressions)
        if match_labels is not None:
            pulumi.set(__self__, "match_labels", match_labels)

    @property
    @pulumi.getter(name="matchExpressions")
    def match_expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementArgs']]]]:
        """
        matchExpressions is a list of label selector requirements. The requirements are ANDed.
        """
        return pulumi.get(self, "match_expressions")

    @match_expressions.setter
    def match_expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LabelSelectorRequirementArgs']]]]):
        pulumi.set(self, "match_expressions", value)

    @property
    @pulumi.getter(name="matchLabels")
    def match_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
        """
        return pulumi.get(self, "match_labels")

    @match_labels.setter
    def match_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "match_labels", value)


if not MYPY:
    class ListMetaPatchArgsDict(TypedDict):
        """
        ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.
        """
        continue_: NotRequired[pulumi.Input[builtins.str]]
        """
        continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.
        """
        remaining_item_count: NotRequired[pulumi.Input[builtins.int]]
        """
        remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.
        """
        resource_version: NotRequired[pulumi.Input[builtins.str]]
        """
        String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        self_link: NotRequired[pulumi.Input[builtins.str]]
        """
        Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
elif False:
    ListMetaPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListMetaPatchArgs:
    def __init__(__self__, *,
                 continue_: Optional[pulumi.Input[builtins.str]] = None,
                 remaining_item_count: Optional[pulumi.Input[builtins.int]] = None,
                 resource_version: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None):
        """
        ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.
        :param pulumi.Input[builtins.str] continue_: continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.
        :param pulumi.Input[builtins.int] remaining_item_count: remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.
        :param pulumi.Input[builtins.str] resource_version: String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        :param pulumi.Input[builtins.str] self_link: Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if remaining_item_count is not None:
            pulumi.set(__self__, "remaining_item_count", remaining_item_count)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.
        """
        return pulumi.get(self, "continue_")

    @continue_.setter
    def continue_(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "continue_", value)

    @property
    @pulumi.getter(name="remainingItemCount")
    def remaining_item_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.
        """
        return pulumi.get(self, "remaining_item_count")

    @remaining_item_count.setter
    def remaining_item_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "remaining_item_count", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)


if not MYPY:
    class ListMetaArgsDict(TypedDict):
        """
        ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.
        """
        continue_: NotRequired[pulumi.Input[builtins.str]]
        """
        continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.
        """
        remaining_item_count: NotRequired[pulumi.Input[builtins.int]]
        """
        remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.
        """
        resource_version: NotRequired[pulumi.Input[builtins.str]]
        """
        String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        self_link: NotRequired[pulumi.Input[builtins.str]]
        """
        Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
elif False:
    ListMetaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListMetaArgs:
    def __init__(__self__, *,
                 continue_: Optional[pulumi.Input[builtins.str]] = None,
                 remaining_item_count: Optional[pulumi.Input[builtins.int]] = None,
                 resource_version: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None):
        """
        ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.
        :param pulumi.Input[builtins.str] continue_: continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.
        :param pulumi.Input[builtins.int] remaining_item_count: remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.
        :param pulumi.Input[builtins.str] resource_version: String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        :param pulumi.Input[builtins.str] self_link: Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
        if continue_ is not None:
            pulumi.set(__self__, "continue_", continue_)
        if remaining_item_count is not None:
            pulumi.set(__self__, "remaining_item_count", remaining_item_count)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter(name="continue")
    def continue_(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.
        """
        return pulumi.get(self, "continue_")

    @continue_.setter
    def continue_(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "continue_", value)

    @property
    @pulumi.getter(name="remainingItemCount")
    def remaining_item_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.
        """
        return pulumi.get(self, "remaining_item_count")

    @remaining_item_count.setter
    def remaining_item_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "remaining_item_count", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)


if not MYPY:
    class ManagedFieldsEntryPatchArgsDict(TypedDict):
        """
        ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.
        """
        fields_type: NotRequired[pulumi.Input[builtins.str]]
        """
        FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"
        """
        fields_v1: NotRequired[Any]
        """
        FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.
        """
        manager: NotRequired[pulumi.Input[builtins.str]]
        """
        Manager is an identifier of the workflow managing these fields.
        """
        operation: NotRequired[pulumi.Input[builtins.str]]
        """
        Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.
        """
        subresource: NotRequired[pulumi.Input[builtins.str]]
        """
        Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.
        """
        time: NotRequired[pulumi.Input[builtins.str]]
        """
        Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.
        """
elif False:
    ManagedFieldsEntryPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedFieldsEntryPatchArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 fields_type: Optional[pulumi.Input[builtins.str]] = None,
                 fields_v1: Optional[Any] = None,
                 manager: Optional[pulumi.Input[builtins.str]] = None,
                 operation: Optional[pulumi.Input[builtins.str]] = None,
                 subresource: Optional[pulumi.Input[builtins.str]] = None,
                 time: Optional[pulumi.Input[builtins.str]] = None):
        """
        ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.
        :param pulumi.Input[builtins.str] fields_type: FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"
        :param Any fields_v1: FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.
        :param pulumi.Input[builtins.str] manager: Manager is an identifier of the workflow managing these fields.
        :param pulumi.Input[builtins.str] operation: Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.
        :param pulumi.Input[builtins.str] subresource: Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.
        :param pulumi.Input[builtins.str] time: Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if fields_type is not None:
            pulumi.set(__self__, "fields_type", fields_type)
        if fields_v1 is not None:
            pulumi.set(__self__, "fields_v1", fields_v1)
        if manager is not None:
            pulumi.set(__self__, "manager", manager)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if subresource is not None:
            pulumi.set(__self__, "subresource", subresource)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter(name="fieldsType")
    def fields_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"
        """
        return pulumi.get(self, "fields_type")

    @fields_type.setter
    def fields_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fields_type", value)

    @property
    @pulumi.getter(name="fieldsV1")
    def fields_v1(self) -> Optional[Any]:
        """
        FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.
        """
        return pulumi.get(self, "fields_v1")

    @fields_v1.setter
    def fields_v1(self, value: Optional[Any]):
        pulumi.set(self, "fields_v1", value)

    @property
    @pulumi.getter
    def manager(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Manager is an identifier of the workflow managing these fields.
        """
        return pulumi.get(self, "manager")

    @manager.setter
    def manager(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "manager", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def subresource(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.
        """
        return pulumi.get(self, "subresource")

    @subresource.setter
    def subresource(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subresource", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time", value)


if not MYPY:
    class ManagedFieldsEntryArgsDict(TypedDict):
        """
        ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.
        """
        fields_type: NotRequired[pulumi.Input[builtins.str]]
        """
        FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"
        """
        fields_v1: NotRequired[Any]
        """
        FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.
        """
        manager: NotRequired[pulumi.Input[builtins.str]]
        """
        Manager is an identifier of the workflow managing these fields.
        """
        operation: NotRequired[pulumi.Input[builtins.str]]
        """
        Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.
        """
        subresource: NotRequired[pulumi.Input[builtins.str]]
        """
        Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.
        """
        time: NotRequired[pulumi.Input[builtins.str]]
        """
        Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.
        """
elif False:
    ManagedFieldsEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ManagedFieldsEntryArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 fields_type: Optional[pulumi.Input[builtins.str]] = None,
                 fields_v1: Optional[Any] = None,
                 manager: Optional[pulumi.Input[builtins.str]] = None,
                 operation: Optional[pulumi.Input[builtins.str]] = None,
                 subresource: Optional[pulumi.Input[builtins.str]] = None,
                 time: Optional[pulumi.Input[builtins.str]] = None):
        """
        ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.
        :param pulumi.Input[builtins.str] fields_type: FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"
        :param Any fields_v1: FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.
        :param pulumi.Input[builtins.str] manager: Manager is an identifier of the workflow managing these fields.
        :param pulumi.Input[builtins.str] operation: Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.
        :param pulumi.Input[builtins.str] subresource: Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.
        :param pulumi.Input[builtins.str] time: Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if fields_type is not None:
            pulumi.set(__self__, "fields_type", fields_type)
        if fields_v1 is not None:
            pulumi.set(__self__, "fields_v1", fields_v1)
        if manager is not None:
            pulumi.set(__self__, "manager", manager)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if subresource is not None:
            pulumi.set(__self__, "subresource", subresource)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter(name="fieldsType")
    def fields_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"
        """
        return pulumi.get(self, "fields_type")

    @fields_type.setter
    def fields_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fields_type", value)

    @property
    @pulumi.getter(name="fieldsV1")
    def fields_v1(self) -> Optional[Any]:
        """
        FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.
        """
        return pulumi.get(self, "fields_v1")

    @fields_v1.setter
    def fields_v1(self, value: Optional[Any]):
        pulumi.set(self, "fields_v1", value)

    @property
    @pulumi.getter
    def manager(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Manager is an identifier of the workflow managing these fields.
        """
        return pulumi.get(self, "manager")

    @manager.setter
    def manager(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "manager", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def subresource(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.
        """
        return pulumi.get(self, "subresource")

    @subresource.setter
    def subresource(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subresource", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time", value)


if not MYPY:
    class ObjectMetaPatchArgsDict(TypedDict):
        """
        ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
        """
        annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
        """
        cluster_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
        """
        creation_timestamp: NotRequired[pulumi.Input[builtins.str]]
        """
        CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.

        Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        deletion_grace_period_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.
        """
        deletion_timestamp: NotRequired[pulumi.Input[builtins.str]]
        """
        DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.

        Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        finalizers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.
        """
        generate_name: NotRequired[pulumi.Input[builtins.str]]
        """
        GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.

        If this field is specified and the generated name exists, the server will return a 409.

        Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
        """
        generation: NotRequired[pulumi.Input[builtins.int]]
        """
        A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
        """
        managed_fields: NotRequired[pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryPatchArgsDict']]]]
        """
        ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.

        Must be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces
        """
        owner_references: NotRequired[pulumi.Input[Sequence[pulumi.Input['OwnerReferencePatchArgsDict']]]]
        """
        List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.
        """
        resource_version: NotRequired[pulumi.Input[builtins.str]]
        """
        An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.

        Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        self_link: NotRequired[pulumi.Input[builtins.str]]
        """
        Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
        uid: NotRequired[pulumi.Input[builtins.str]]
        """
        UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.

        Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
elif False:
    ObjectMetaPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObjectMetaPatchArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_grace_period_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 deletion_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 finalizers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 generate_name: Optional[pulumi.Input[builtins.str]] = None,
                 generation: Optional[pulumi.Input[builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 managed_fields: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryPatchArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 owner_references: Optional[pulumi.Input[Sequence[pulumi.Input['OwnerReferencePatchArgs']]]] = None,
                 resource_version: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
        :param pulumi.Input[builtins.str] cluster_name: The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
        :param pulumi.Input[builtins.str] creation_timestamp: CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.
               
               Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[builtins.int] deletion_grace_period_seconds: Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.
        :param pulumi.Input[builtins.str] deletion_timestamp: DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.
               
               Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] finalizers: Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.
        :param pulumi.Input[builtins.str] generate_name: GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.
               
               If this field is specified and the generated name exists, the server will return a 409.
               
               Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
        :param pulumi.Input[builtins.int] generation: A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
        :param pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryPatchArgs']]] managed_fields: ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.
        :param pulumi.Input[builtins.str] name: Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        :param pulumi.Input[builtins.str] namespace: Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.
               
               Must be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces
        :param pulumi.Input[Sequence[pulumi.Input['OwnerReferencePatchArgs']]] owner_references: List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.
        :param pulumi.Input[builtins.str] resource_version: An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.
               
               Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        :param pulumi.Input[builtins.str] self_link: Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        :param pulumi.Input[builtins.str] uid: UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.
               
               Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if deletion_grace_period_seconds is not None:
            pulumi.set(__self__, "deletion_grace_period_seconds", deletion_grace_period_seconds)
        if deletion_timestamp is not None:
            pulumi.set(__self__, "deletion_timestamp", deletion_timestamp)
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)
        if generate_name is not None:
            pulumi.set(__self__, "generate_name", generate_name)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if managed_fields is not None:
            pulumi.set(__self__, "managed_fields", managed_fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if owner_references is not None:
            pulumi.set(__self__, "owner_references", owner_references)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.

        Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="deletionGracePeriodSeconds")
    def deletion_grace_period_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.
        """
        return pulumi.get(self, "deletion_grace_period_seconds")

    @deletion_grace_period_seconds.setter
    def deletion_grace_period_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "deletion_grace_period_seconds", value)

    @property
    @pulumi.getter(name="deletionTimestamp")
    def deletion_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.

        Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "deletion_timestamp")

    @deletion_timestamp.setter
    def deletion_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_timestamp", value)

    @property
    @pulumi.getter
    def finalizers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.
        """
        return pulumi.get(self, "finalizers")

    @finalizers.setter
    def finalizers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "finalizers", value)

    @property
    @pulumi.getter(name="generateName")
    def generate_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.

        If this field is specified and the generated name exists, the server will return a 409.

        Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
        """
        return pulumi.get(self, "generate_name")

    @generate_name.setter
    def generate_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "generate_name", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="managedFields")
    def managed_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryPatchArgs']]]]:
        """
        ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.
        """
        return pulumi.get(self, "managed_fields")

    @managed_fields.setter
    def managed_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryPatchArgs']]]]):
        pulumi.set(self, "managed_fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.

        Must be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="ownerReferences")
    def owner_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OwnerReferencePatchArgs']]]]:
        """
        List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.
        """
        return pulumi.get(self, "owner_references")

    @owner_references.setter
    def owner_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OwnerReferencePatchArgs']]]]):
        pulumi.set(self, "owner_references", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.

        Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.

        Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


if not MYPY:
    class ObjectMetaArgsDict(TypedDict):
        """
        ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
        """
        annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
        """
        cluster_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
        """
        creation_timestamp: NotRequired[pulumi.Input[builtins.str]]
        """
        CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.

        Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        deletion_grace_period_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.
        """
        deletion_timestamp: NotRequired[pulumi.Input[builtins.str]]
        """
        DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.

        Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        finalizers: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.
        """
        generate_name: NotRequired[pulumi.Input[builtins.str]]
        """
        GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.

        If this field is specified and the generated name exists, the server will return a 409.

        Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
        """
        generation: NotRequired[pulumi.Input[builtins.int]]
        """
        A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
        """
        managed_fields: NotRequired[pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryArgsDict']]]]
        """
        ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.

        Must be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces
        """
        owner_references: NotRequired[pulumi.Input[Sequence[pulumi.Input['OwnerReferenceArgsDict']]]]
        """
        List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.
        """
        resource_version: NotRequired[pulumi.Input[builtins.str]]
        """
        An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.

        Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        self_link: NotRequired[pulumi.Input[builtins.str]]
        """
        Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
        uid: NotRequired[pulumi.Input[builtins.str]]
        """
        UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.

        Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
elif False:
    ObjectMetaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObjectMetaArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_grace_period_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 deletion_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 finalizers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 generate_name: Optional[pulumi.Input[builtins.str]] = None,
                 generation: Optional[pulumi.Input[builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 managed_fields: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 owner_references: Optional[pulumi.Input[Sequence[pulumi.Input['OwnerReferenceArgs']]]] = None,
                 resource_version: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
        :param pulumi.Input[builtins.str] cluster_name: The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
        :param pulumi.Input[builtins.str] creation_timestamp: CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.
               
               Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[builtins.int] deletion_grace_period_seconds: Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.
        :param pulumi.Input[builtins.str] deletion_timestamp: DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.
               
               Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] finalizers: Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.
        :param pulumi.Input[builtins.str] generate_name: GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.
               
               If this field is specified and the generated name exists, the server will return a 409.
               
               Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
        :param pulumi.Input[builtins.int] generation: A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
        :param pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryArgs']]] managed_fields: ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.
        :param pulumi.Input[builtins.str] name: Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        :param pulumi.Input[builtins.str] namespace: Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.
               
               Must be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces
        :param pulumi.Input[Sequence[pulumi.Input['OwnerReferenceArgs']]] owner_references: List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.
        :param pulumi.Input[builtins.str] resource_version: An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.
               
               Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        :param pulumi.Input[builtins.str] self_link: Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        :param pulumi.Input[builtins.str] uid: UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.
               
               Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if deletion_grace_period_seconds is not None:
            pulumi.set(__self__, "deletion_grace_period_seconds", deletion_grace_period_seconds)
        if deletion_timestamp is not None:
            pulumi.set(__self__, "deletion_timestamp", deletion_timestamp)
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)
        if generate_name is not None:
            pulumi.set(__self__, "generate_name", generate_name)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if managed_fields is not None:
            pulumi.set(__self__, "managed_fields", managed_fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if owner_references is not None:
            pulumi.set(__self__, "owner_references", owner_references)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.

        Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="deletionGracePeriodSeconds")
    def deletion_grace_period_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.
        """
        return pulumi.get(self, "deletion_grace_period_seconds")

    @deletion_grace_period_seconds.setter
    def deletion_grace_period_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "deletion_grace_period_seconds", value)

    @property
    @pulumi.getter(name="deletionTimestamp")
    def deletion_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.

        Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "deletion_timestamp")

    @deletion_timestamp.setter
    def deletion_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_timestamp", value)

    @property
    @pulumi.getter
    def finalizers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.
        """
        return pulumi.get(self, "finalizers")

    @finalizers.setter
    def finalizers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "finalizers", value)

    @property
    @pulumi.getter(name="generateName")
    def generate_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.

        If this field is specified and the generated name exists, the server will return a 409.

        Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
        """
        return pulumi.get(self, "generate_name")

    @generate_name.setter
    def generate_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "generate_name", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="managedFields")
    def managed_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryArgs']]]]:
        """
        ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.
        """
        return pulumi.get(self, "managed_fields")

    @managed_fields.setter
    def managed_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedFieldsEntryArgs']]]]):
        pulumi.set(self, "managed_fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.

        Must be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="ownerReferences")
    def owner_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OwnerReferenceArgs']]]]:
        """
        List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.
        """
        return pulumi.get(self, "owner_references")

    @owner_references.setter
    def owner_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OwnerReferenceArgs']]]]):
        pulumi.set(self, "owner_references", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.

        Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.

        Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


if not MYPY:
    class OwnerReferencePatchArgsDict(TypedDict):
        """
        OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        API version of the referent.
        """
        block_owner_deletion: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.
        """
        controller: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, this reference points to the managing controller.
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        """
        uid: NotRequired[pulumi.Input[builtins.str]]
        """
        UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
elif False:
    OwnerReferencePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OwnerReferencePatchArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 block_owner_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 controller: Optional[pulumi.Input[builtins.bool]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.
        :param pulumi.Input[builtins.str] api_version: API version of the referent.
        :param pulumi.Input[builtins.bool] block_owner_deletion: If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.
        :param pulumi.Input[builtins.bool] controller: If true, this reference points to the managing controller.
        :param pulumi.Input[builtins.str] kind: Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[builtins.str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        :param pulumi.Input[builtins.str] uid: UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if block_owner_deletion is not None:
            pulumi.set(__self__, "block_owner_deletion", block_owner_deletion)
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API version of the referent.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter(name="blockOwnerDeletion")
    def block_owner_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.
        """
        return pulumi.get(self, "block_owner_deletion")

    @block_owner_deletion.setter
    def block_owner_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "block_owner_deletion", value)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, this reference points to the managing controller.
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


if not MYPY:
    class OwnerReferenceArgsDict(TypedDict):
        """
        OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.
        """
        api_version: pulumi.Input[builtins.str]
        """
        API version of the referent.
        """
        kind: pulumi.Input[builtins.str]
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        name: pulumi.Input[builtins.str]
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        """
        uid: pulumi.Input[builtins.str]
        """
        UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        block_owner_deletion: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.
        """
        controller: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, this reference points to the managing controller.
        """
elif False:
    OwnerReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OwnerReferenceArgs:
    def __init__(__self__, *,
                 api_version: pulumi.Input[builtins.str],
                 kind: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 uid: pulumi.Input[builtins.str],
                 block_owner_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 controller: Optional[pulumi.Input[builtins.bool]] = None):
        """
        OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.
        :param pulumi.Input[builtins.str] api_version: API version of the referent.
        :param pulumi.Input[builtins.str] kind: Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[builtins.str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        :param pulumi.Input[builtins.str] uid: UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        :param pulumi.Input[builtins.bool] block_owner_deletion: If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.
        :param pulumi.Input[builtins.bool] controller: If true, this reference points to the managing controller.
        """
        pulumi.set(__self__, "api_version", api_version)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uid", uid)
        if block_owner_deletion is not None:
            pulumi.set(__self__, "block_owner_deletion", block_owner_deletion)
        if controller is not None:
            pulumi.set(__self__, "controller", controller)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Input[builtins.str]:
        """
        API version of the referent.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[builtins.str]:
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[builtins.str]:
        """
        UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="blockOwnerDeletion")
    def block_owner_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.
        """
        return pulumi.get(self, "block_owner_deletion")

    @block_owner_deletion.setter
    def block_owner_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "block_owner_deletion", value)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, this reference points to the managing controller.
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "controller", value)


if not MYPY:
    class StatusCausePatchArgsDict(TypedDict):
        """
        StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.
        """
        field: NotRequired[pulumi.Input[builtins.str]]
        """
        The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.

        Examples:
          "name" - the field "name" on the current resource
          "items[0].name" - the field "name" on the first array entry in "items"
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        A human-readable description of the cause of the error.  This field may be presented as-is to a reader.
        """
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        A machine-readable description of the cause of the error. If this value is empty there is no information available.
        """
elif False:
    StatusCausePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatusCausePatchArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.
        :param pulumi.Input[builtins.str] field: The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.
               
               Examples:
                 "name" - the field "name" on the current resource
                 "items[0].name" - the field "name" on the first array entry in "items"
        :param pulumi.Input[builtins.str] message: A human-readable description of the cause of the error.  This field may be presented as-is to a reader.
        :param pulumi.Input[builtins.str] reason: A machine-readable description of the cause of the error. If this value is empty there is no information available.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.

        Examples:
          "name" - the field "name" on the current resource
          "items[0].name" - the field "name" on the first array entry in "items"
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the cause of the error.  This field may be presented as-is to a reader.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A machine-readable description of the cause of the error. If this value is empty there is no information available.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)


if not MYPY:
    class StatusCauseArgsDict(TypedDict):
        """
        StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.
        """
        field: NotRequired[pulumi.Input[builtins.str]]
        """
        The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.

        Examples:
          "name" - the field "name" on the current resource
          "items[0].name" - the field "name" on the first array entry in "items"
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        A human-readable description of the cause of the error.  This field may be presented as-is to a reader.
        """
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        A machine-readable description of the cause of the error. If this value is empty there is no information available.
        """
elif False:
    StatusCauseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatusCauseArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.
        :param pulumi.Input[builtins.str] field: The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.
               
               Examples:
                 "name" - the field "name" on the current resource
                 "items[0].name" - the field "name" on the first array entry in "items"
        :param pulumi.Input[builtins.str] message: A human-readable description of the cause of the error.  This field may be presented as-is to a reader.
        :param pulumi.Input[builtins.str] reason: A machine-readable description of the cause of the error. If this value is empty there is no information available.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.

        Examples:
          "name" - the field "name" on the current resource
          "items[0].name" - the field "name" on the first array entry in "items"
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the cause of the error.  This field may be presented as-is to a reader.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A machine-readable description of the cause of the error. If this value is empty there is no information available.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)


if not MYPY:
    class StatusDetailsPatchArgsDict(TypedDict):
        """
        StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.
        """
        causes: NotRequired[pulumi.Input[Sequence[pulumi.Input['StatusCausePatchArgsDict']]]]
        """
        The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.
        """
        group: NotRequired[pulumi.Input[builtins.str]]
        """
        The group attribute of the resource associated with the status StatusReason.
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).
        """
        retry_after_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.
        """
        uid: NotRequired[pulumi.Input[builtins.str]]
        """
        UID of the resource. (when there is a single resource which can be described). More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
elif False:
    StatusDetailsPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatusDetailsPatchArgs:
    def __init__(__self__, *,
                 causes: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCausePatchArgs']]]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retry_after_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.
        :param pulumi.Input[Sequence[pulumi.Input['StatusCausePatchArgs']]] causes: The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.
        :param pulumi.Input[builtins.str] group: The group attribute of the resource associated with the status StatusReason.
        :param pulumi.Input[builtins.str] kind: The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[builtins.str] name: The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).
        :param pulumi.Input[builtins.int] retry_after_seconds: If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.
        :param pulumi.Input[builtins.str] uid: UID of the resource. (when there is a single resource which can be described). More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        if causes is not None:
            pulumi.set(__self__, "causes", causes)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retry_after_seconds is not None:
            pulumi.set(__self__, "retry_after_seconds", retry_after_seconds)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def causes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StatusCausePatchArgs']]]]:
        """
        The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.
        """
        return pulumi.get(self, "causes")

    @causes.setter
    def causes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCausePatchArgs']]]]):
        pulumi.set(self, "causes", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The group attribute of the resource associated with the status StatusReason.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retryAfterSeconds")
    def retry_after_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.
        """
        return pulumi.get(self, "retry_after_seconds")

    @retry_after_seconds.setter
    def retry_after_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retry_after_seconds", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UID of the resource. (when there is a single resource which can be described). More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


if not MYPY:
    class StatusDetailsArgsDict(TypedDict):
        """
        StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.
        """
        causes: NotRequired[pulumi.Input[Sequence[pulumi.Input['StatusCauseArgsDict']]]]
        """
        The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.
        """
        group: NotRequired[pulumi.Input[builtins.str]]
        """
        The group attribute of the resource associated with the status StatusReason.
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).
        """
        retry_after_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.
        """
        uid: NotRequired[pulumi.Input[builtins.str]]
        """
        UID of the resource. (when there is a single resource which can be described). More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
elif False:
    StatusDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StatusDetailsArgs:
    def __init__(__self__, *,
                 causes: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCauseArgs']]]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retry_after_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.
        :param pulumi.Input[Sequence[pulumi.Input['StatusCauseArgs']]] causes: The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.
        :param pulumi.Input[builtins.str] group: The group attribute of the resource associated with the status StatusReason.
        :param pulumi.Input[builtins.str] kind: The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[builtins.str] name: The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).
        :param pulumi.Input[builtins.int] retry_after_seconds: If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.
        :param pulumi.Input[builtins.str] uid: UID of the resource. (when there is a single resource which can be described). More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        if causes is not None:
            pulumi.set(__self__, "causes", causes)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retry_after_seconds is not None:
            pulumi.set(__self__, "retry_after_seconds", retry_after_seconds)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def causes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StatusCauseArgs']]]]:
        """
        The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.
        """
        return pulumi.get(self, "causes")

    @causes.setter
    def causes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StatusCauseArgs']]]]):
        pulumi.set(self, "causes", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The group attribute of the resource associated with the status StatusReason.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="retryAfterSeconds")
    def retry_after_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.
        """
        return pulumi.get(self, "retry_after_seconds")

    @retry_after_seconds.setter
    def retry_after_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retry_after_seconds", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UID of the resource. (when there is a single resource which can be described). More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


