# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'HTTPIngressPath',
    'HTTPIngressPathPatch',
    'HTTPIngressRuleValue',
    'HTTPIngressRuleValuePatch',
    'IPAddress',
    'IPAddressSpec',
    'IPAddressSpecPatch',
    'IPBlock',
    'IPBlockPatch',
    'Ingress',
    'IngressBackend',
    'IngressBackendPatch',
    'IngressClass',
    'IngressClassParametersReference',
    'IngressClassParametersReferencePatch',
    'IngressClassSpec',
    'IngressClassSpecPatch',
    'IngressLoadBalancerIngress',
    'IngressLoadBalancerIngressPatch',
    'IngressLoadBalancerStatus',
    'IngressLoadBalancerStatusPatch',
    'IngressPortStatus',
    'IngressPortStatusPatch',
    'IngressRule',
    'IngressRulePatch',
    'IngressServiceBackend',
    'IngressServiceBackendPatch',
    'IngressSpec',
    'IngressSpecPatch',
    'IngressStatus',
    'IngressStatusPatch',
    'IngressTLS',
    'IngressTLSPatch',
    'NetworkPolicy',
    'NetworkPolicyEgressRule',
    'NetworkPolicyEgressRulePatch',
    'NetworkPolicyIngressRule',
    'NetworkPolicyIngressRulePatch',
    'NetworkPolicyPeer',
    'NetworkPolicyPeerPatch',
    'NetworkPolicyPort',
    'NetworkPolicyPortPatch',
    'NetworkPolicySpec',
    'NetworkPolicySpecPatch',
    'NetworkPolicyStatus',
    'NetworkPolicyStatusPatch',
    'ParentReference',
    'ParentReferencePatch',
    'ServiceBackendPort',
    'ServiceBackendPortPatch',
    'ServiceCIDR',
    'ServiceCIDRSpec',
    'ServiceCIDRSpecPatch',
    'ServiceCIDRStatus',
    'ServiceCIDRStatusPatch',
]

@pulumi.output_type
class HTTPIngressPath(dict):
    """
    HTTPIngressPath associates a path with a backend. Incoming urls matching the path are forwarded to the backend.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathType":
            suggest = "path_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPIngressPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPIngressPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPIngressPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend: 'outputs.IngressBackend',
                 path_type: builtins.str,
                 path: Optional[builtins.str] = None):
        """
        HTTPIngressPath associates a path with a backend. Incoming urls matching the path are forwarded to the backend.
        :param 'IngressBackendArgs' backend: backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param builtins.str path_type: pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
                 done on a path element by element basis. A path element refers is the
                 list of labels in the path split by the '/' separator. A request is a
                 match for path p if every p is an element-wise prefix of p of the
                 request path. Note that if the last element of the path is a substring
                 of the last element in request path, it is not a match (e.g. /foo/bar
                 matches /foo/bar/baz, but does not match /foo/barbaz).
               * ImplementationSpecific: Interpretation of the Path matching is up to
                 the IngressClass. Implementations can treat this as a separate PathType
                 or treat it identically to Prefix or Exact path types.
               Implementations are required to support all path types.
        :param builtins.str path: path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "path_type", path_type)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def backend(self) -> 'outputs.IngressBackend':
        """
        backend defines the referenced service endpoint to which the traffic will be forwarded to.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="pathType")
    def path_type(self) -> builtins.str:
        """
        pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
          done on a path element by element basis. A path element refers is the
          list of labels in the path split by the '/' separator. A request is a
          match for path p if every p is an element-wise prefix of p of the
          request path. Note that if the last element of the path is a substring
          of the last element in request path, it is not a match (e.g. /foo/bar
          matches /foo/bar/baz, but does not match /foo/barbaz).
        * ImplementationSpecific: Interpretation of the Path matching is up to
          the IngressClass. Implementations can treat this as a separate PathType
          or treat it identically to Prefix or Exact path types.
        Implementations are required to support all path types.
        """
        return pulumi.get(self, "path_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class HTTPIngressPathPatch(dict):
    """
    HTTPIngressPath associates a path with a backend. Incoming urls matching the path are forwarded to the backend.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathType":
            suggest = "path_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPIngressPathPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPIngressPathPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPIngressPathPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend: Optional['outputs.IngressBackendPatch'] = None,
                 path: Optional[builtins.str] = None,
                 path_type: Optional[builtins.str] = None):
        """
        HTTPIngressPath associates a path with a backend. Incoming urls matching the path are forwarded to the backend.
        :param 'IngressBackendPatchArgs' backend: backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param builtins.str path: path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
        :param builtins.str path_type: pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
                 done on a path element by element basis. A path element refers is the
                 list of labels in the path split by the '/' separator. A request is a
                 match for path p if every p is an element-wise prefix of p of the
                 request path. Note that if the last element of the path is a substring
                 of the last element in request path, it is not a match (e.g. /foo/bar
                 matches /foo/bar/baz, but does not match /foo/barbaz).
               * ImplementationSpecific: Interpretation of the Path matching is up to
                 the IngressClass. Implementations can treat this as a separate PathType
                 or treat it identically to Prefix or Exact path types.
               Implementations are required to support all path types.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_type is not None:
            pulumi.set(__self__, "path_type", path_type)

    @property
    @pulumi.getter
    def backend(self) -> Optional['outputs.IngressBackendPatch']:
        """
        backend defines the referenced service endpoint to which the traffic will be forwarded to.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathType")
    def path_type(self) -> Optional[builtins.str]:
        """
        pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
          done on a path element by element basis. A path element refers is the
          list of labels in the path split by the '/' separator. A request is a
          match for path p if every p is an element-wise prefix of p of the
          request path. Note that if the last element of the path is a substring
          of the last element in request path, it is not a match (e.g. /foo/bar
          matches /foo/bar/baz, but does not match /foo/barbaz).
        * ImplementationSpecific: Interpretation of the Path matching is up to
          the IngressClass. Implementations can treat this as a separate PathType
          or treat it identically to Prefix or Exact path types.
        Implementations are required to support all path types.
        """
        return pulumi.get(self, "path_type")


@pulumi.output_type
class HTTPIngressRuleValue(dict):
    """
    HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
    """
    def __init__(__self__, *,
                 paths: Sequence['outputs.HTTPIngressPath']):
        """
        HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
        :param Sequence['HTTPIngressPathArgs'] paths: paths is a collection of paths that map requests to backends.
        """
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Sequence['outputs.HTTPIngressPath']:
        """
        paths is a collection of paths that map requests to backends.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class HTTPIngressRuleValuePatch(dict):
    """
    HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
    """
    def __init__(__self__, *,
                 paths: Optional[Sequence['outputs.HTTPIngressPathPatch']] = None):
        """
        HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
        :param Sequence['HTTPIngressPathPatchArgs'] paths: paths is a collection of paths that map requests to backends.
        """
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence['outputs.HTTPIngressPathPatch']]:
        """
        paths is a collection of paths that map requests to backends.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class IPAddress(dict):
    """
    IPAddress represents a single IP of a single IP Family. The object is designed to be used by APIs that operate on IP addresses. The object is used by the Service core API for allocation of IP addresses. An IP address can be represented in different formats, to guarantee the uniqueness of the IP, the name of the object is the IP address in canonical format, four decimal digits separated by dots suppressing leading zeros for IPv4 and the representation defined by RFC 5952 for IPv6. Valid: 192.168.1.5 or 2001:db8::1 or 2001:db8:aaaa:bbbb:cccc:dddd:eeee:1 Invalid: 10.01.2.3 or 2001:db8:0:0:0::1
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.IPAddressSpec'] = None):
        """
        IPAddress represents a single IP of a single IP Family. The object is designed to be used by APIs that operate on IP addresses. The object is used by the Service core API for allocation of IP addresses. An IP address can be represented in different formats, to guarantee the uniqueness of the IP, the name of the object is the IP address in canonical format, four decimal digits separated by dots suppressing leading zeros for IPv4 and the representation defined by RFC 5952 for IPv6. Valid: 192.168.1.5 or 2001:db8::1 or 2001:db8:aaaa:bbbb:cccc:dddd:eeee:1 Invalid: 10.01.2.3 or 2001:db8:0:0:0::1
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'IPAddressSpecArgs' spec: spec is the desired state of the IPAddress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'networking.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'IPAddress')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.IPAddressSpec']:
        """
        spec is the desired state of the IPAddress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class IPAddressSpec(dict):
    """
    IPAddressSpec describe the attributes in an IP Address.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parentRef":
            suggest = "parent_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPAddressSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPAddressSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPAddressSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parent_ref: 'outputs.ParentReference'):
        """
        IPAddressSpec describe the attributes in an IP Address.
        :param 'ParentReferenceArgs' parent_ref: ParentRef references the resource that an IPAddress is attached to. An IPAddress must reference a parent object.
        """
        pulumi.set(__self__, "parent_ref", parent_ref)

    @property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> 'outputs.ParentReference':
        """
        ParentRef references the resource that an IPAddress is attached to. An IPAddress must reference a parent object.
        """
        return pulumi.get(self, "parent_ref")


@pulumi.output_type
class IPAddressSpecPatch(dict):
    """
    IPAddressSpec describe the attributes in an IP Address.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parentRef":
            suggest = "parent_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPAddressSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPAddressSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPAddressSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parent_ref: Optional['outputs.ParentReferencePatch'] = None):
        """
        IPAddressSpec describe the attributes in an IP Address.
        :param 'ParentReferencePatchArgs' parent_ref: ParentRef references the resource that an IPAddress is attached to. An IPAddress must reference a parent object.
        """
        if parent_ref is not None:
            pulumi.set(__self__, "parent_ref", parent_ref)

    @property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional['outputs.ParentReferencePatch']:
        """
        ParentRef references the resource that an IPAddress is attached to. An IPAddress must reference a parent object.
        """
        return pulumi.get(self, "parent_ref")


@pulumi.output_type
class IPBlock(dict):
    """
    IPBlock describes a particular CIDR (Ex. "192.168.1.0/24","2001:db8::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "except":
            suggest = "except_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPBlock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPBlock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPBlock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr: builtins.str,
                 except_: Optional[Sequence[builtins.str]] = None):
        """
        IPBlock describes a particular CIDR (Ex. "192.168.1.0/24","2001:db8::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
        :param builtins.str cidr: cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
        :param Sequence[builtins.str] except_: except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
        """
        pulumi.set(__self__, "cidr", cidr)
        if except_ is not None:
            pulumi.set(__self__, "except_", except_)

    @property
    @pulumi.getter
    def cidr(self) -> builtins.str:
        """
        cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="except")
    def except_(self) -> Optional[Sequence[builtins.str]]:
        """
        except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
        """
        return pulumi.get(self, "except_")


@pulumi.output_type
class IPBlockPatch(dict):
    """
    IPBlock describes a particular CIDR (Ex. "192.168.1.0/24","2001:db8::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "except":
            suggest = "except_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPBlockPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPBlockPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPBlockPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr: Optional[builtins.str] = None,
                 except_: Optional[Sequence[builtins.str]] = None):
        """
        IPBlock describes a particular CIDR (Ex. "192.168.1.0/24","2001:db8::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
        :param builtins.str cidr: cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
        :param Sequence[builtins.str] except_: except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if except_ is not None:
            pulumi.set(__self__, "except_", except_)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[builtins.str]:
        """
        cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="except")
    def except_(self) -> Optional[Sequence[builtins.str]]:
        """
        except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
        """
        return pulumi.get(self, "except_")


@pulumi.output_type
class Ingress(dict):
    """
    Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.

    This resource waits until its status is ready before registering success
    for create/update, and populating output properties from the current state of the resource.
    The following conditions are used to determine whether the resource creation has
    succeeded or failed:

    1.  Ingress object exists.
    2.  Endpoint objects exist with matching names for each Ingress path (except when Service
        type is ExternalName).
    3.  Ingress entry exists for '.status.loadBalancer.ingress'.

    If the Ingress has not reached a Ready state after 10 minutes, it will
    time out and mark the resource update as Failed. You can override the default timeout value
    by setting the 'customTimeouts' option on the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Ingress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Ingress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Ingress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.IngressSpec'] = None,
                 status: Optional['outputs.IngressStatus'] = None):
        """
        Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1.  Ingress object exists.
        2.  Endpoint objects exist with matching names for each Ingress path (except when Service
            type is ExternalName).
        3.  Ingress entry exists for '.status.loadBalancer.ingress'.

        If the Ingress has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'IngressSpecArgs' spec: spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'IngressStatusArgs' status: status is the current state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'networking.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Ingress')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.IngressSpec']:
        """
        spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.IngressStatus']:
        """
        status is the current state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class IngressBackend(dict):
    """
    IngressBackend describes all endpoints for a given service and port.
    """
    def __init__(__self__, *,
                 resource: Optional['_core.v1.outputs.TypedLocalObjectReference'] = None,
                 service: Optional['outputs.IngressServiceBackend'] = None):
        """
        IngressBackend describes all endpoints for a given service and port.
        :param '_core.v1.TypedLocalObjectReferenceArgs' resource: resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        :param 'IngressServiceBackendArgs' service: service references a service as a backend. This is a mutually exclusive setting with "Resource".
        """
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def resource(self) -> Optional['_core.v1.outputs.TypedLocalObjectReference']:
        """
        resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def service(self) -> Optional['outputs.IngressServiceBackend']:
        """
        service references a service as a backend. This is a mutually exclusive setting with "Resource".
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class IngressBackendPatch(dict):
    """
    IngressBackend describes all endpoints for a given service and port.
    """
    def __init__(__self__, *,
                 resource: Optional['_core.v1.outputs.TypedLocalObjectReferencePatch'] = None,
                 service: Optional['outputs.IngressServiceBackendPatch'] = None):
        """
        IngressBackend describes all endpoints for a given service and port.
        :param '_core.v1.TypedLocalObjectReferencePatchArgs' resource: resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        :param 'IngressServiceBackendPatchArgs' service: service references a service as a backend. This is a mutually exclusive setting with "Resource".
        """
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def resource(self) -> Optional['_core.v1.outputs.TypedLocalObjectReferencePatch']:
        """
        resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def service(self) -> Optional['outputs.IngressServiceBackendPatch']:
        """
        service references a service as a backend. This is a mutually exclusive setting with "Resource".
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class IngressClass(dict):
    """
    IngressClass represents the class of the Ingress, referenced by the Ingress Spec. The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressClass. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressClass.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressClass.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.IngressClassSpec'] = None):
        """
        IngressClass represents the class of the Ingress, referenced by the Ingress Spec. The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'IngressClassSpecArgs' spec: spec is the desired state of the IngressClass. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'networking.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'IngressClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.IngressClassSpec']:
        """
        spec is the desired state of the IngressClass. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class IngressClassParametersReference(dict):
    """
    IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressClassParametersReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressClassParametersReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressClassParametersReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: builtins.str,
                 name: builtins.str,
                 api_group: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 scope: Optional[builtins.str] = None):
        """
        IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource.
        :param builtins.str kind: kind is the type of resource being referenced.
        :param builtins.str name: name is the name of resource being referenced.
        :param builtins.str api_group: apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        :param builtins.str namespace: namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        :param builtins.str scope: scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        kind is the type of resource being referenced.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class IngressClassParametersReferencePatch(dict):
    """
    IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressClassParametersReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressClassParametersReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressClassParametersReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_group: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 scope: Optional[builtins.str] = None):
        """
        IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource.
        :param builtins.str api_group: apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        :param builtins.str kind: kind is the type of resource being referenced.
        :param builtins.str name: name is the name of resource being referenced.
        :param builtins.str namespace: namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        :param builtins.str scope: scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        kind is the type of resource being referenced.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class IngressClassSpec(dict):
    """
    IngressClassSpec provides information about the class of an Ingress.
    """
    def __init__(__self__, *,
                 controller: Optional[builtins.str] = None,
                 parameters: Optional['outputs.IngressClassParametersReference'] = None):
        """
        IngressClassSpec provides information about the class of an Ingress.
        :param builtins.str controller: controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        :param 'IngressClassParametersReferenceArgs' parameters: parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def controller(self) -> Optional[builtins.str]:
        """
        controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.IngressClassParametersReference']:
        """
        parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class IngressClassSpecPatch(dict):
    """
    IngressClassSpec provides information about the class of an Ingress.
    """
    def __init__(__self__, *,
                 controller: Optional[builtins.str] = None,
                 parameters: Optional['outputs.IngressClassParametersReferencePatch'] = None):
        """
        IngressClassSpec provides information about the class of an Ingress.
        :param builtins.str controller: controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        :param 'IngressClassParametersReferencePatchArgs' parameters: parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def controller(self) -> Optional[builtins.str]:
        """
        controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.IngressClassParametersReferencePatch']:
        """
        parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class IngressLoadBalancerIngress(dict):
    """
    IngressLoadBalancerIngress represents the status of a load-balancer ingress point.
    """
    def __init__(__self__, *,
                 hostname: Optional[builtins.str] = None,
                 ip: Optional[builtins.str] = None,
                 ports: Optional[Sequence['outputs.IngressPortStatus']] = None):
        """
        IngressLoadBalancerIngress represents the status of a load-balancer ingress point.
        :param builtins.str hostname: hostname is set for load-balancer ingress points that are DNS based.
        :param builtins.str ip: ip is set for load-balancer ingress points that are IP based.
        :param Sequence['IngressPortStatusArgs'] ports: ports provides information about the ports exposed by this LoadBalancer.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        hostname is set for load-balancer ingress points that are DNS based.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        ip is set for load-balancer ingress points that are IP based.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.IngressPortStatus']]:
        """
        ports provides information about the ports exposed by this LoadBalancer.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class IngressLoadBalancerIngressPatch(dict):
    """
    IngressLoadBalancerIngress represents the status of a load-balancer ingress point.
    """
    def __init__(__self__, *,
                 hostname: Optional[builtins.str] = None,
                 ip: Optional[builtins.str] = None,
                 ports: Optional[Sequence['outputs.IngressPortStatusPatch']] = None):
        """
        IngressLoadBalancerIngress represents the status of a load-balancer ingress point.
        :param builtins.str hostname: hostname is set for load-balancer ingress points that are DNS based.
        :param builtins.str ip: ip is set for load-balancer ingress points that are IP based.
        :param Sequence['IngressPortStatusPatchArgs'] ports: ports provides information about the ports exposed by this LoadBalancer.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        hostname is set for load-balancer ingress points that are DNS based.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        ip is set for load-balancer ingress points that are IP based.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.IngressPortStatusPatch']]:
        """
        ports provides information about the ports exposed by this LoadBalancer.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class IngressLoadBalancerStatus(dict):
    """
    IngressLoadBalancerStatus represents the status of a load-balancer.
    """
    def __init__(__self__, *,
                 ingress: Optional[Sequence['outputs.IngressLoadBalancerIngress']] = None):
        """
        IngressLoadBalancerStatus represents the status of a load-balancer.
        :param Sequence['IngressLoadBalancerIngressArgs'] ingress: ingress is a list containing ingress points for the load-balancer.
        """
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[Sequence['outputs.IngressLoadBalancerIngress']]:
        """
        ingress is a list containing ingress points for the load-balancer.
        """
        return pulumi.get(self, "ingress")


@pulumi.output_type
class IngressLoadBalancerStatusPatch(dict):
    """
    IngressLoadBalancerStatus represents the status of a load-balancer.
    """
    def __init__(__self__, *,
                 ingress: Optional[Sequence['outputs.IngressLoadBalancerIngressPatch']] = None):
        """
        IngressLoadBalancerStatus represents the status of a load-balancer.
        :param Sequence['IngressLoadBalancerIngressPatchArgs'] ingress: ingress is a list containing ingress points for the load-balancer.
        """
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[Sequence['outputs.IngressLoadBalancerIngressPatch']]:
        """
        ingress is a list containing ingress points for the load-balancer.
        """
        return pulumi.get(self, "ingress")


@pulumi.output_type
class IngressPortStatus(dict):
    """
    IngressPortStatus represents the error condition of a service port
    """
    def __init__(__self__, *,
                 port: builtins.int,
                 protocol: builtins.str,
                 error: Optional[builtins.str] = None):
        """
        IngressPortStatus represents the error condition of a service port
        :param builtins.int port: port is the port number of the ingress port.
        :param builtins.str protocol: protocol is the protocol of the ingress port. The supported values are: "TCP", "UDP", "SCTP"
        :param builtins.str error: error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
                 CamelCase names
               - cloud provider specific error values must have names that comply with the
                 format foo.example.com/CamelCase.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        port is the port number of the ingress port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        protocol is the protocol of the ingress port. The supported values are: "TCP", "UDP", "SCTP"
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def error(self) -> Optional[builtins.str]:
        """
        error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
          CamelCase names
        - cloud provider specific error values must have names that comply with the
          format foo.example.com/CamelCase.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class IngressPortStatusPatch(dict):
    """
    IngressPortStatus represents the error condition of a service port
    """
    def __init__(__self__, *,
                 error: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 protocol: Optional[builtins.str] = None):
        """
        IngressPortStatus represents the error condition of a service port
        :param builtins.str error: error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
                 CamelCase names
               - cloud provider specific error values must have names that comply with the
                 format foo.example.com/CamelCase.
        :param builtins.int port: port is the port number of the ingress port.
        :param builtins.str protocol: protocol is the protocol of the ingress port. The supported values are: "TCP", "UDP", "SCTP"
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def error(self) -> Optional[builtins.str]:
        """
        error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
          CamelCase names
        - cloud provider specific error values must have names that comply with the
          format foo.example.com/CamelCase.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        port is the port number of the ingress port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        protocol is the protocol of the ingress port. The supported values are: "TCP", "UDP", "SCTP"
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class IngressRule(dict):
    """
    IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
    """
    def __init__(__self__, *,
                 host: Optional[builtins.str] = None,
                 http: Optional['outputs.HTTPIngressRuleValue'] = None):
        """
        IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
        :param builtins.str host: host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
                  the IP in the Spec of the parent Ingress.
               2. The `:` delimiter is not respected because ports are not allowed.
               	  Currently the port of an Ingress is implicitly :80 for http and
               	  :443 for https.
               Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
               
               host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.str]:
        """
        host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
           the IP in the Spec of the parent Ingress.
        2. The `:` delimiter is not respected because ports are not allowed.
        	  Currently the port of an Ingress is implicitly :80 for http and
        	  :443 for https.
        Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.

        host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.HTTPIngressRuleValue']:
        return pulumi.get(self, "http")


@pulumi.output_type
class IngressRulePatch(dict):
    """
    IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
    """
    def __init__(__self__, *,
                 host: Optional[builtins.str] = None,
                 http: Optional['outputs.HTTPIngressRuleValuePatch'] = None):
        """
        IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
        :param builtins.str host: host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
                  the IP in the Spec of the parent Ingress.
               2. The `:` delimiter is not respected because ports are not allowed.
               	  Currently the port of an Ingress is implicitly :80 for http and
               	  :443 for https.
               Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
               
               host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.str]:
        """
        host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
           the IP in the Spec of the parent Ingress.
        2. The `:` delimiter is not respected because ports are not allowed.
        	  Currently the port of an Ingress is implicitly :80 for http and
        	  :443 for https.
        Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.

        host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.HTTPIngressRuleValuePatch']:
        return pulumi.get(self, "http")


@pulumi.output_type
class IngressServiceBackend(dict):
    """
    IngressServiceBackend references a Kubernetes Service as a Backend.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 port: Optional['outputs.ServiceBackendPort'] = None):
        """
        IngressServiceBackend references a Kubernetes Service as a Backend.
        :param builtins.str name: name is the referenced service. The service must exist in the same namespace as the Ingress object.
        :param 'ServiceBackendPortArgs' port: port of the referenced service. A port name or port number is required for a IngressServiceBackend.
        """
        pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        name is the referenced service. The service must exist in the same namespace as the Ingress object.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional['outputs.ServiceBackendPort']:
        """
        port of the referenced service. A port name or port number is required for a IngressServiceBackend.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class IngressServiceBackendPatch(dict):
    """
    IngressServiceBackend references a Kubernetes Service as a Backend.
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 port: Optional['outputs.ServiceBackendPortPatch'] = None):
        """
        IngressServiceBackend references a Kubernetes Service as a Backend.
        :param builtins.str name: name is the referenced service. The service must exist in the same namespace as the Ingress object.
        :param 'ServiceBackendPortPatchArgs' port: port of the referenced service. A port name or port number is required for a IngressServiceBackend.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        name is the referenced service. The service must exist in the same namespace as the Ingress object.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional['outputs.ServiceBackendPortPatch']:
        """
        port of the referenced service. A port name or port number is required for a IngressServiceBackend.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class IngressSpec(dict):
    """
    IngressSpec describes the Ingress the user wishes to exist.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBackend":
            suggest = "default_backend"
        elif key == "ingressClassName":
            suggest = "ingress_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_backend: Optional['outputs.IngressBackend'] = None,
                 ingress_class_name: Optional[builtins.str] = None,
                 rules: Optional[Sequence['outputs.IngressRule']] = None,
                 tls: Optional[Sequence['outputs.IngressTLS']] = None):
        """
        IngressSpec describes the Ingress the user wishes to exist.
        :param 'IngressBackendArgs' default_backend: defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        :param builtins.str ingress_class_name: ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
        :param Sequence['IngressRuleArgs'] rules: rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        :param Sequence['IngressTLSArgs'] tls: tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        if default_backend is not None:
            pulumi.set(__self__, "default_backend", default_backend)
        if ingress_class_name is not None:
            pulumi.set(__self__, "ingress_class_name", ingress_class_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter(name="defaultBackend")
    def default_backend(self) -> Optional['outputs.IngressBackend']:
        """
        defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        """
        return pulumi.get(self, "default_backend")

    @property
    @pulumi.getter(name="ingressClassName")
    def ingress_class_name(self) -> Optional[builtins.str]:
        """
        ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
        """
        return pulumi.get(self, "ingress_class_name")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.IngressRule']]:
        """
        rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tls(self) -> Optional[Sequence['outputs.IngressTLS']]:
        """
        tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class IngressSpecPatch(dict):
    """
    IngressSpec describes the Ingress the user wishes to exist.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBackend":
            suggest = "default_backend"
        elif key == "ingressClassName":
            suggest = "ingress_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_backend: Optional['outputs.IngressBackendPatch'] = None,
                 ingress_class_name: Optional[builtins.str] = None,
                 rules: Optional[Sequence['outputs.IngressRulePatch']] = None,
                 tls: Optional[Sequence['outputs.IngressTLSPatch']] = None):
        """
        IngressSpec describes the Ingress the user wishes to exist.
        :param 'IngressBackendPatchArgs' default_backend: defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        :param builtins.str ingress_class_name: ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
        :param Sequence['IngressRulePatchArgs'] rules: rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        :param Sequence['IngressTLSPatchArgs'] tls: tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        if default_backend is not None:
            pulumi.set(__self__, "default_backend", default_backend)
        if ingress_class_name is not None:
            pulumi.set(__self__, "ingress_class_name", ingress_class_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter(name="defaultBackend")
    def default_backend(self) -> Optional['outputs.IngressBackendPatch']:
        """
        defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        """
        return pulumi.get(self, "default_backend")

    @property
    @pulumi.getter(name="ingressClassName")
    def ingress_class_name(self) -> Optional[builtins.str]:
        """
        ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
        """
        return pulumi.get(self, "ingress_class_name")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.IngressRulePatch']]:
        """
        rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tls(self) -> Optional[Sequence['outputs.IngressTLSPatch']]:
        """
        tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class IngressStatus(dict):
    """
    IngressStatus describe the current state of the Ingress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancer":
            suggest = "load_balancer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancer: Optional['outputs.IngressLoadBalancerStatus'] = None):
        """
        IngressStatus describe the current state of the Ingress.
        :param 'IngressLoadBalancerStatusArgs' load_balancer: loadBalancer contains the current status of the load-balancer.
        """
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['outputs.IngressLoadBalancerStatus']:
        """
        loadBalancer contains the current status of the load-balancer.
        """
        return pulumi.get(self, "load_balancer")


@pulumi.output_type
class IngressStatusPatch(dict):
    """
    IngressStatus describe the current state of the Ingress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancer":
            suggest = "load_balancer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancer: Optional['outputs.IngressLoadBalancerStatusPatch'] = None):
        """
        IngressStatus describe the current state of the Ingress.
        :param 'IngressLoadBalancerStatusPatchArgs' load_balancer: loadBalancer contains the current status of the load-balancer.
        """
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['outputs.IngressLoadBalancerStatusPatch']:
        """
        loadBalancer contains the current status of the load-balancer.
        """
        return pulumi.get(self, "load_balancer")


@pulumi.output_type
class IngressTLS(dict):
    """
    IngressTLS describes the transport layer security associated with an ingress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressTLS. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressTLS.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressTLS.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Optional[Sequence[builtins.str]] = None,
                 secret_name: Optional[builtins.str] = None):
        """
        IngressTLS describes the transport layer security associated with an ingress.
        :param Sequence[builtins.str] hosts: hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        :param builtins.str secret_name: secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
        """
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[builtins.str]]:
        """
        hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[builtins.str]:
        """
        secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class IngressTLSPatch(dict):
    """
    IngressTLS describes the transport layer security associated with an ingress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressTLSPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressTLSPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressTLSPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Optional[Sequence[builtins.str]] = None,
                 secret_name: Optional[builtins.str] = None):
        """
        IngressTLS describes the transport layer security associated with an ingress.
        :param Sequence[builtins.str] hosts: hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        :param builtins.str secret_name: secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
        """
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[builtins.str]]:
        """
        hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[builtins.str]:
        """
        secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class NetworkPolicy(dict):
    """
    NetworkPolicy describes what network traffic is allowed for a set of Pods
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.NetworkPolicySpec'] = None,
                 status: Optional['outputs.NetworkPolicyStatus'] = None):
        """
        NetworkPolicy describes what network traffic is allowed for a set of Pods
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'NetworkPolicySpecArgs' spec: spec represents the specification of the desired behavior for this NetworkPolicy.
        :param 'NetworkPolicyStatusArgs' status: Status is the current state of the NetworkPolicy. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'networking.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'NetworkPolicy')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.NetworkPolicySpec']:
        """
        spec represents the specification of the desired behavior for this NetworkPolicy.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.NetworkPolicyStatus']:
        """
        Status is the current state of the NetworkPolicy. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkPolicyEgressRule(dict):
    """
    NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
    """
    def __init__(__self__, *,
                 ports: Optional[Sequence['outputs.NetworkPolicyPort']] = None,
                 to: Optional[Sequence['outputs.NetworkPolicyPeer']] = None):
        """
        NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
        :param Sequence['NetworkPolicyPortArgs'] ports: ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        :param Sequence['NetworkPolicyPeerArgs'] to: to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.NetworkPolicyPort']]:
        """
        ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def to(self) -> Optional[Sequence['outputs.NetworkPolicyPeer']]:
        """
        to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class NetworkPolicyEgressRulePatch(dict):
    """
    NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
    """
    def __init__(__self__, *,
                 ports: Optional[Sequence['outputs.NetworkPolicyPortPatch']] = None,
                 to: Optional[Sequence['outputs.NetworkPolicyPeerPatch']] = None):
        """
        NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
        :param Sequence['NetworkPolicyPortPatchArgs'] ports: ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        :param Sequence['NetworkPolicyPeerPatchArgs'] to: to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.NetworkPolicyPortPatch']]:
        """
        ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def to(self) -> Optional[Sequence['outputs.NetworkPolicyPeerPatch']]:
        """
        to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class NetworkPolicyIngressRule(dict):
    """
    NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyIngressRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyIngressRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyIngressRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: Optional[Sequence['outputs.NetworkPolicyPeer']] = None,
                 ports: Optional[Sequence['outputs.NetworkPolicyPort']] = None):
        """
        NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.
        :param Sequence['NetworkPolicyPeerArgs'] from_: from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        :param Sequence['NetworkPolicyPortArgs'] ports: ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[Sequence['outputs.NetworkPolicyPeer']]:
        """
        from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.NetworkPolicyPort']]:
        """
        ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class NetworkPolicyIngressRulePatch(dict):
    """
    NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyIngressRulePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyIngressRulePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyIngressRulePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: Optional[Sequence['outputs.NetworkPolicyPeerPatch']] = None,
                 ports: Optional[Sequence['outputs.NetworkPolicyPortPatch']] = None):
        """
        NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.
        :param Sequence['NetworkPolicyPeerPatchArgs'] from_: from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        :param Sequence['NetworkPolicyPortPatchArgs'] ports: ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[Sequence['outputs.NetworkPolicyPeerPatch']]:
        """
        from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.NetworkPolicyPortPatch']]:
        """
        ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class NetworkPolicyPeer(dict):
    """
    NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipBlock":
            suggest = "ip_block"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "podSelector":
            suggest = "pod_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyPeer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyPeer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyPeer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_block: Optional['outputs.IPBlock'] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 pod_selector: Optional['_meta.v1.outputs.LabelSelector'] = None):
        """
        NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed
        :param 'IPBlockArgs' ip_block: ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        :param '_meta.v1.LabelSelectorArgs' namespace_selector: namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.
               
               If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
        :param '_meta.v1.LabelSelectorArgs' pod_selector: podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.
               
               If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
        """
        if ip_block is not None:
            pulumi.set(__self__, "ip_block", ip_block)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if pod_selector is not None:
            pulumi.set(__self__, "pod_selector", pod_selector)

    @property
    @pulumi.getter(name="ipBlock")
    def ip_block(self) -> Optional['outputs.IPBlock']:
        """
        ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        """
        return pulumi.get(self, "ip_block")

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.

        If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
        """
        return pulumi.get(self, "namespace_selector")

    @property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.

        If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
        """
        return pulumi.get(self, "pod_selector")


@pulumi.output_type
class NetworkPolicyPeerPatch(dict):
    """
    NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipBlock":
            suggest = "ip_block"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "podSelector":
            suggest = "pod_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyPeerPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyPeerPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyPeerPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_block: Optional['outputs.IPBlockPatch'] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 pod_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None):
        """
        NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed
        :param 'IPBlockPatchArgs' ip_block: ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        :param '_meta.v1.LabelSelectorPatchArgs' namespace_selector: namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.
               
               If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
        :param '_meta.v1.LabelSelectorPatchArgs' pod_selector: podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.
               
               If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
        """
        if ip_block is not None:
            pulumi.set(__self__, "ip_block", ip_block)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if pod_selector is not None:
            pulumi.set(__self__, "pod_selector", pod_selector)

    @property
    @pulumi.getter(name="ipBlock")
    def ip_block(self) -> Optional['outputs.IPBlockPatch']:
        """
        ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        """
        return pulumi.get(self, "ip_block")

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.

        If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
        """
        return pulumi.get(self, "namespace_selector")

    @property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.

        If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
        """
        return pulumi.get(self, "pod_selector")


@pulumi.output_type
class NetworkPolicyPort(dict):
    """
    NetworkPolicyPort describes a port to allow traffic on
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPort":
            suggest = "end_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_port: Optional[builtins.int] = None,
                 port: Optional[Any] = None,
                 protocol: Optional[builtins.str] = None):
        """
        NetworkPolicyPort describes a port to allow traffic on
        :param builtins.int end_port: endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
        :param Union[builtins.int, builtins.str] port: port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        :param builtins.str protocol: protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[builtins.int]:
        """
        endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class NetworkPolicyPortPatch(dict):
    """
    NetworkPolicyPort describes a port to allow traffic on
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPort":
            suggest = "end_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyPortPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyPortPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyPortPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_port: Optional[builtins.int] = None,
                 port: Optional[Any] = None,
                 protocol: Optional[builtins.str] = None):
        """
        NetworkPolicyPort describes a port to allow traffic on
        :param builtins.int end_port: endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
        :param Union[builtins.int, builtins.str] port: port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        :param builtins.str protocol: protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[builtins.int]:
        """
        endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class NetworkPolicySpec(dict):
    """
    NetworkPolicySpec provides the specification of a NetworkPolicy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "podSelector":
            suggest = "pod_selector"
        elif key == "policyTypes":
            suggest = "policy_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pod_selector: '_meta.v1.outputs.LabelSelector',
                 egress: Optional[Sequence['outputs.NetworkPolicyEgressRule']] = None,
                 ingress: Optional[Sequence['outputs.NetworkPolicyIngressRule']] = None,
                 policy_types: Optional[Sequence[builtins.str]] = None):
        """
        NetworkPolicySpec provides the specification of a NetworkPolicy
        :param '_meta.v1.LabelSelectorArgs' pod_selector: podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        :param Sequence['NetworkPolicyEgressRuleArgs'] egress: egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        :param Sequence['NetworkPolicyIngressRuleArgs'] ingress: ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
        :param Sequence[builtins.str] policy_types: policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        pulumi.set(__self__, "pod_selector", pod_selector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if policy_types is not None:
            pulumi.set(__self__, "policy_types", policy_types)

    @property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        """
        return pulumi.get(self, "pod_selector")

    @property
    @pulumi.getter
    def egress(self) -> Optional[Sequence['outputs.NetworkPolicyEgressRule']]:
        """
        egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        """
        return pulumi.get(self, "egress")

    @property
    @pulumi.getter
    def ingress(self) -> Optional[Sequence['outputs.NetworkPolicyIngressRule']]:
        """
        ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter(name="policyTypes")
    def policy_types(self) -> Optional[Sequence[builtins.str]]:
        """
        policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        return pulumi.get(self, "policy_types")


@pulumi.output_type
class NetworkPolicySpecPatch(dict):
    """
    NetworkPolicySpec provides the specification of a NetworkPolicy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "podSelector":
            suggest = "pod_selector"
        elif key == "policyTypes":
            suggest = "policy_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicySpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicySpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicySpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress: Optional[Sequence['outputs.NetworkPolicyEgressRulePatch']] = None,
                 ingress: Optional[Sequence['outputs.NetworkPolicyIngressRulePatch']] = None,
                 pod_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 policy_types: Optional[Sequence[builtins.str]] = None):
        """
        NetworkPolicySpec provides the specification of a NetworkPolicy
        :param Sequence['NetworkPolicyEgressRulePatchArgs'] egress: egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        :param Sequence['NetworkPolicyIngressRulePatchArgs'] ingress: ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
        :param '_meta.v1.LabelSelectorPatchArgs' pod_selector: podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        :param Sequence[builtins.str] policy_types: policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if pod_selector is not None:
            pulumi.set(__self__, "pod_selector", pod_selector)
        if policy_types is not None:
            pulumi.set(__self__, "policy_types", policy_types)

    @property
    @pulumi.getter
    def egress(self) -> Optional[Sequence['outputs.NetworkPolicyEgressRulePatch']]:
        """
        egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        """
        return pulumi.get(self, "egress")

    @property
    @pulumi.getter
    def ingress(self) -> Optional[Sequence['outputs.NetworkPolicyIngressRulePatch']]:
        """
        ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        """
        return pulumi.get(self, "pod_selector")

    @property
    @pulumi.getter(name="policyTypes")
    def policy_types(self) -> Optional[Sequence[builtins.str]]:
        """
        policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        return pulumi.get(self, "policy_types")


@pulumi.output_type
class NetworkPolicyStatus(dict):
    """
    NetworkPolicyStatus describe the current state of the NetworkPolicy.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.Condition']] = None):
        """
        NetworkPolicyStatus describe the current state of the NetworkPolicy.
        :param Sequence['_meta.v1.ConditionArgs'] conditions: Conditions holds an array of metav1.Condition that describe the state of the NetworkPolicy. Current service state
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.Condition']]:
        """
        Conditions holds an array of metav1.Condition that describe the state of the NetworkPolicy. Current service state
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class NetworkPolicyStatusPatch(dict):
    """
    NetworkPolicyStatus describe the current state of the NetworkPolicy.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.ConditionPatch']] = None):
        """
        NetworkPolicyStatus describe the current state of the NetworkPolicy.
        :param Sequence['_meta.v1.ConditionPatchArgs'] conditions: Conditions holds an array of metav1.Condition that describe the state of the NetworkPolicy. Current service state
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.ConditionPatch']]:
        """
        Conditions holds an array of metav1.Condition that describe the state of the NetworkPolicy. Current service state
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class ParentReference(dict):
    """
    ParentReference describes a reference to a parent object.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 resource: builtins.str,
                 group: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None):
        """
        ParentReference describes a reference to a parent object.
        :param builtins.str name: Name is the name of the object being referenced.
        :param builtins.str resource: Resource is the resource of the object being referenced.
        :param builtins.str group: Group is the group of the object being referenced.
        :param builtins.str namespace: Namespace is the namespace of the object being referenced.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource", resource)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is the name of the object being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        """
        Resource is the resource of the object being referenced.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def group(self) -> Optional[builtins.str]:
        """
        Group is the group of the object being referenced.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        Namespace is the namespace of the object being referenced.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ParentReferencePatch(dict):
    """
    ParentReference describes a reference to a parent object.
    """
    def __init__(__self__, *,
                 group: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 resource: Optional[builtins.str] = None):
        """
        ParentReference describes a reference to a parent object.
        :param builtins.str group: Group is the group of the object being referenced.
        :param builtins.str name: Name is the name of the object being referenced.
        :param builtins.str namespace: Namespace is the namespace of the object being referenced.
        :param builtins.str resource: Resource is the resource of the object being referenced.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def group(self) -> Optional[builtins.str]:
        """
        Group is the group of the object being referenced.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is the name of the object being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        Namespace is the namespace of the object being referenced.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def resource(self) -> Optional[builtins.str]:
        """
        Resource is the resource of the object being referenced.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class ServiceBackendPort(dict):
    """
    ServiceBackendPort is the service port being referenced.
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 number: Optional[builtins.int] = None):
        """
        ServiceBackendPort is the service port being referenced.
        :param builtins.str name: name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
        :param builtins.int number: number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number is not None:
            pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def number(self) -> Optional[builtins.int]:
        """
        number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class ServiceBackendPortPatch(dict):
    """
    ServiceBackendPort is the service port being referenced.
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 number: Optional[builtins.int] = None):
        """
        ServiceBackendPort is the service port being referenced.
        :param builtins.str name: name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
        :param builtins.int number: number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number is not None:
            pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def number(self) -> Optional[builtins.int]:
        """
        number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class ServiceCIDR(dict):
    """
    ServiceCIDR defines a range of IP addresses using CIDR format (e.g. 192.168.0.0/24 or 2001:db2::/64). This range is used to allocate ClusterIPs to Service objects.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCIDR. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCIDR.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCIDR.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.ServiceCIDRSpec'] = None,
                 status: Optional['outputs.ServiceCIDRStatus'] = None):
        """
        ServiceCIDR defines a range of IP addresses using CIDR format (e.g. 192.168.0.0/24 or 2001:db2::/64). This range is used to allocate ClusterIPs to Service objects.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'ServiceCIDRSpecArgs' spec: spec is the desired state of the ServiceCIDR. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'ServiceCIDRStatusArgs' status: status represents the current state of the ServiceCIDR. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'networking.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ServiceCIDR')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ServiceCIDRSpec']:
        """
        spec is the desired state of the ServiceCIDR. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ServiceCIDRStatus']:
        """
        status represents the current state of the ServiceCIDR. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceCIDRSpec(dict):
    """
    ServiceCIDRSpec define the CIDRs the user wants to use for allocating ClusterIPs for Services.
    """
    def __init__(__self__, *,
                 cidrs: Optional[Sequence[builtins.str]] = None):
        """
        ServiceCIDRSpec define the CIDRs the user wants to use for allocating ClusterIPs for Services.
        :param Sequence[builtins.str] cidrs: CIDRs defines the IP blocks in CIDR notation (e.g. "192.168.0.0/24" or "2001:db8::/64") from which to assign service cluster IPs. Max of two CIDRs is allowed, one of each IP family. This field is immutable.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        CIDRs defines the IP blocks in CIDR notation (e.g. "192.168.0.0/24" or "2001:db8::/64") from which to assign service cluster IPs. Max of two CIDRs is allowed, one of each IP family. This field is immutable.
        """
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class ServiceCIDRSpecPatch(dict):
    """
    ServiceCIDRSpec define the CIDRs the user wants to use for allocating ClusterIPs for Services.
    """
    def __init__(__self__, *,
                 cidrs: Optional[Sequence[builtins.str]] = None):
        """
        ServiceCIDRSpec define the CIDRs the user wants to use for allocating ClusterIPs for Services.
        :param Sequence[builtins.str] cidrs: CIDRs defines the IP blocks in CIDR notation (e.g. "192.168.0.0/24" or "2001:db8::/64") from which to assign service cluster IPs. Max of two CIDRs is allowed, one of each IP family. This field is immutable.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        CIDRs defines the IP blocks in CIDR notation (e.g. "192.168.0.0/24" or "2001:db8::/64") from which to assign service cluster IPs. Max of two CIDRs is allowed, one of each IP family. This field is immutable.
        """
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class ServiceCIDRStatus(dict):
    """
    ServiceCIDRStatus describes the current state of the ServiceCIDR.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.Condition']] = None):
        """
        ServiceCIDRStatus describes the current state of the ServiceCIDR.
        :param Sequence['_meta.v1.ConditionArgs'] conditions: conditions holds an array of metav1.Condition that describe the state of the ServiceCIDR. Current service state
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.Condition']]:
        """
        conditions holds an array of metav1.Condition that describe the state of the ServiceCIDR. Current service state
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class ServiceCIDRStatusPatch(dict):
    """
    ServiceCIDRStatus describes the current state of the ServiceCIDR.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.ConditionPatch']] = None):
        """
        ServiceCIDRStatus describes the current state of the ServiceCIDR.
        :param Sequence['_meta.v1.ConditionPatchArgs'] conditions: conditions holds an array of metav1.Condition that describe the state of the ServiceCIDR. Current service state
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.ConditionPatch']]:
        """
        conditions holds an array of metav1.Condition that describe the state of the ServiceCIDR. Current service state
        """
        return pulumi.get(self, "conditions")


