# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'AllocationResultArgs',
    'AllocationResultArgsDict',
    'PodSchedulingSpecPatchArgs',
    'PodSchedulingSpecPatchArgsDict',
    'PodSchedulingSpecArgs',
    'PodSchedulingSpecArgsDict',
    'PodSchedulingStatusArgs',
    'PodSchedulingStatusArgsDict',
    'PodSchedulingArgs',
    'PodSchedulingArgsDict',
    'ResourceClaimConsumerReferenceArgs',
    'ResourceClaimConsumerReferenceArgsDict',
    'ResourceClaimParametersReferencePatchArgs',
    'ResourceClaimParametersReferencePatchArgsDict',
    'ResourceClaimParametersReferenceArgs',
    'ResourceClaimParametersReferenceArgsDict',
    'ResourceClaimSchedulingStatusArgs',
    'ResourceClaimSchedulingStatusArgsDict',
    'ResourceClaimSpecPatchArgs',
    'ResourceClaimSpecPatchArgsDict',
    'ResourceClaimSpecArgs',
    'ResourceClaimSpecArgsDict',
    'ResourceClaimStatusArgs',
    'ResourceClaimStatusArgsDict',
    'ResourceClaimTemplateSpecPatchArgs',
    'ResourceClaimTemplateSpecPatchArgsDict',
    'ResourceClaimTemplateSpecArgs',
    'ResourceClaimTemplateSpecArgsDict',
    'ResourceClaimTemplateArgs',
    'ResourceClaimTemplateArgsDict',
    'ResourceClaimArgs',
    'ResourceClaimArgsDict',
    'ResourceClassParametersReferencePatchArgs',
    'ResourceClassParametersReferencePatchArgsDict',
    'ResourceClassParametersReferenceArgs',
    'ResourceClassParametersReferenceArgsDict',
    'ResourceClassArgs',
    'ResourceClassArgsDict',
]

MYPY = False

if not MYPY:
    class AllocationResultArgsDict(TypedDict):
        """
        AllocationResult contains attributed of an allocated resource.
        """
        available_on_nodes: NotRequired[pulumi.Input['_core.v1.NodeSelectorArgsDict']]
        """
        This field will get set by the resource driver after it has allocated the resource driver to inform the scheduler where it can schedule Pods using the ResourceClaim.

        Setting this field is optional. If null, the resource is available everywhere.
        """
        resource_handle: NotRequired[pulumi.Input[builtins.str]]
        """
        ResourceHandle contains arbitrary data returned by the driver after a successful allocation. This is opaque for Kubernetes. Driver documentation may explain to users how to interpret this data if needed.

        The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        """
        shareable: NotRequired[pulumi.Input[builtins.bool]]
        """
        Shareable determines whether the resource supports more than one consumer at a time.
        """
elif False:
    AllocationResultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AllocationResultArgs:
    def __init__(__self__, *,
                 available_on_nodes: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']] = None,
                 resource_handle: Optional[pulumi.Input[builtins.str]] = None,
                 shareable: Optional[pulumi.Input[builtins.bool]] = None):
        """
        AllocationResult contains attributed of an allocated resource.
        :param pulumi.Input['_core.v1.NodeSelectorArgs'] available_on_nodes: This field will get set by the resource driver after it has allocated the resource driver to inform the scheduler where it can schedule Pods using the ResourceClaim.
               
               Setting this field is optional. If null, the resource is available everywhere.
        :param pulumi.Input[builtins.str] resource_handle: ResourceHandle contains arbitrary data returned by the driver after a successful allocation. This is opaque for Kubernetes. Driver documentation may explain to users how to interpret this data if needed.
               
               The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        :param pulumi.Input[builtins.bool] shareable: Shareable determines whether the resource supports more than one consumer at a time.
        """
        if available_on_nodes is not None:
            pulumi.set(__self__, "available_on_nodes", available_on_nodes)
        if resource_handle is not None:
            pulumi.set(__self__, "resource_handle", resource_handle)
        if shareable is not None:
            pulumi.set(__self__, "shareable", shareable)

    @property
    @pulumi.getter(name="availableOnNodes")
    def available_on_nodes(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]:
        """
        This field will get set by the resource driver after it has allocated the resource driver to inform the scheduler where it can schedule Pods using the ResourceClaim.

        Setting this field is optional. If null, the resource is available everywhere.
        """
        return pulumi.get(self, "available_on_nodes")

    @available_on_nodes.setter
    def available_on_nodes(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]):
        pulumi.set(self, "available_on_nodes", value)

    @property
    @pulumi.getter(name="resourceHandle")
    def resource_handle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ResourceHandle contains arbitrary data returned by the driver after a successful allocation. This is opaque for Kubernetes. Driver documentation may explain to users how to interpret this data if needed.

        The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "resource_handle")

    @resource_handle.setter
    def resource_handle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_handle", value)

    @property
    @pulumi.getter
    def shareable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Shareable determines whether the resource supports more than one consumer at a time.
        """
        return pulumi.get(self, "shareable")

    @shareable.setter
    def shareable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shareable", value)


if not MYPY:
    class PodSchedulingSpecPatchArgsDict(TypedDict):
        """
        PodSchedulingSpec describes where resources for the Pod are needed.
        """
        potential_nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        selected_node: NotRequired[pulumi.Input[builtins.str]]
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
elif False:
    PodSchedulingSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PodSchedulingSpecPatchArgs:
    def __init__(__self__, *,
                 potential_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 selected_node: Optional[pulumi.Input[builtins.str]] = None):
        """
        PodSchedulingSpec describes where resources for the Pod are needed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param pulumi.Input[builtins.str] selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @potential_nodes.setter
    def potential_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "potential_nodes", value)

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")

    @selected_node.setter
    def selected_node(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "selected_node", value)


if not MYPY:
    class PodSchedulingSpecArgsDict(TypedDict):
        """
        PodSchedulingSpec describes where resources for the Pod are needed.
        """
        potential_nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        selected_node: NotRequired[pulumi.Input[builtins.str]]
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
elif False:
    PodSchedulingSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PodSchedulingSpecArgs:
    def __init__(__self__, *,
                 potential_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 selected_node: Optional[pulumi.Input[builtins.str]] = None):
        """
        PodSchedulingSpec describes where resources for the Pod are needed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param pulumi.Input[builtins.str] selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @potential_nodes.setter
    def potential_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "potential_nodes", value)

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")

    @selected_node.setter
    def selected_node(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "selected_node", value)


if not MYPY:
    class PodSchedulingStatusArgsDict(TypedDict):
        """
        PodSchedulingStatus describes where resources for the Pod can be allocated.
        """
        resource_claims: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgsDict']]]]
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
elif False:
    PodSchedulingStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PodSchedulingStatusArgs:
    def __init__(__self__, *,
                 resource_claims: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgs']]]] = None):
        """
        PodSchedulingStatus describes where resources for the Pod can be allocated.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgs']]] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgs']]]]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")

    @resource_claims.setter
    def resource_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimSchedulingStatusArgs']]]]):
        pulumi.set(self, "resource_claims", value)


if not MYPY:
    class PodSchedulingArgsDict(TypedDict):
        """
        PodScheduling objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        spec: pulumi.Input['PodSchedulingSpecArgsDict']
        """
        Spec describes where resources for the Pod are needed.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
        status: NotRequired[pulumi.Input['PodSchedulingStatusArgsDict']]
        """
        Status describes where resources for the Pod can be allocated.
        """
elif False:
    PodSchedulingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PodSchedulingArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['PodSchedulingSpecArgs'],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 status: Optional[pulumi.Input['PodSchedulingStatusArgs']] = None):
        """
        PodScheduling objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input['PodSchedulingSpecArgs'] spec: Spec describes where resources for the Pod are needed.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        :param pulumi.Input['PodSchedulingStatusArgs'] status: Status describes where resources for the Pod can be allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PodScheduling')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['PodSchedulingSpecArgs']:
        """
        Spec describes where resources for the Pod are needed.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['PodSchedulingSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['PodSchedulingStatusArgs']]:
        """
        Status describes where resources for the Pod can be allocated.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['PodSchedulingStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ResourceClaimConsumerReferenceArgsDict(TypedDict):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        """
        name: pulumi.Input[builtins.str]
        """
        Name is the name of resource being referenced.
        """
        resource: pulumi.Input[builtins.str]
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        uid: pulumi.Input[builtins.str]
        """
        UID identifies exactly one incarnation of the resource.
        """
        api_group: NotRequired[pulumi.Input[builtins.str]]
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
elif False:
    ResourceClaimConsumerReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimConsumerReferenceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 resource: pulumi.Input[builtins.str],
                 uid: pulumi.Input[builtins.str],
                 api_group: Optional[pulumi.Input[builtins.str]] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param pulumi.Input[builtins.str] name: Name is the name of resource being referenced.
        :param pulumi.Input[builtins.str] resource: Resource is the type of resource being referenced, for example "pods".
        :param pulumi.Input[builtins.str] uid: UID identifies exactly one incarnation of the resource.
        :param pulumi.Input[builtins.str] api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "uid", uid)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[builtins.str]:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[builtins.str]:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_group", value)


if not MYPY:
    class ResourceClaimParametersReferencePatchArgsDict(TypedDict):
        """
        ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
        """
        api_group: NotRequired[pulumi.Input[builtins.str]]
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name is the name of resource being referenced.
        """
elif False:
    ResourceClaimParametersReferencePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimParametersReferencePatchArgs:
    def __init__(__self__, *,
                 api_group: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
        :param pulumi.Input[builtins.str] api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param pulumi.Input[builtins.str] kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        :param pulumi.Input[builtins.str] name: Name is the name of resource being referenced.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_group", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class ResourceClaimParametersReferenceArgsDict(TypedDict):
        """
        ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
        """
        kind: pulumi.Input[builtins.str]
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        """
        name: pulumi.Input[builtins.str]
        """
        Name is the name of resource being referenced.
        """
        api_group: NotRequired[pulumi.Input[builtins.str]]
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
elif False:
    ResourceClaimParametersReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimParametersReferenceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 api_group: Optional[pulumi.Input[builtins.str]] = None):
        """
        ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
        :param pulumi.Input[builtins.str] kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        :param pulumi.Input[builtins.str] name: Name is the name of resource being referenced.
        :param pulumi.Input[builtins.str] api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[builtins.str]:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_group", value)


if not MYPY:
    class ResourceClaimSchedulingStatusArgsDict(TypedDict):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        unsuitable_nodes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
elif False:
    ResourceClaimSchedulingStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimSchedulingStatusArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 unsuitable_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param pulumi.Input[builtins.str] name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")

    @unsuitable_nodes.setter
    def unsuitable_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "unsuitable_nodes", value)


if not MYPY:
    class ResourceClaimSpecPatchArgsDict(TypedDict):
        """
        ResourceClaimSpec defines how a resource is to be allocated.
        """
        allocation_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        """
        parameters_ref: NotRequired[pulumi.Input['ResourceClaimParametersReferencePatchArgsDict']]
        """
        ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.

        The object must be in the same namespace as the ResourceClaim.
        """
        resource_class_name: NotRequired[pulumi.Input[builtins.str]]
        """
        ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
elif False:
    ResourceClaimSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimSpecPatchArgs:
    def __init__(__self__, *,
                 allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 parameters_ref: Optional[pulumi.Input['ResourceClaimParametersReferencePatchArgs']] = None,
                 resource_class_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        ResourceClaimSpec defines how a resource is to be allocated.
        :param pulumi.Input[builtins.str] allocation_mode: Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        :param pulumi.Input['ResourceClaimParametersReferencePatchArgs'] parameters_ref: ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
               
               The object must be in the same namespace as the ResourceClaim.
        :param pulumi.Input[builtins.str] resource_class_name: ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if parameters_ref is not None:
            pulumi.set(__self__, "parameters_ref", parameters_ref)
        if resource_class_name is not None:
            pulumi.set(__self__, "resource_class_name", resource_class_name)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        """
        return pulumi.get(self, "allocation_mode")

    @allocation_mode.setter
    def allocation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_mode", value)

    @property
    @pulumi.getter(name="parametersRef")
    def parameters_ref(self) -> Optional[pulumi.Input['ResourceClaimParametersReferencePatchArgs']]:
        """
        ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.

        The object must be in the same namespace as the ResourceClaim.
        """
        return pulumi.get(self, "parameters_ref")

    @parameters_ref.setter
    def parameters_ref(self, value: Optional[pulumi.Input['ResourceClaimParametersReferencePatchArgs']]):
        pulumi.set(self, "parameters_ref", value)

    @property
    @pulumi.getter(name="resourceClassName")
    def resource_class_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        return pulumi.get(self, "resource_class_name")

    @resource_class_name.setter
    def resource_class_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_class_name", value)


if not MYPY:
    class ResourceClaimSpecArgsDict(TypedDict):
        """
        ResourceClaimSpec defines how a resource is to be allocated.
        """
        resource_class_name: pulumi.Input[builtins.str]
        """
        ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        allocation_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        """
        parameters_ref: NotRequired[pulumi.Input['ResourceClaimParametersReferenceArgsDict']]
        """
        ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.

        The object must be in the same namespace as the ResourceClaim.
        """
elif False:
    ResourceClaimSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimSpecArgs:
    def __init__(__self__, *,
                 resource_class_name: pulumi.Input[builtins.str],
                 allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 parameters_ref: Optional[pulumi.Input['ResourceClaimParametersReferenceArgs']] = None):
        """
        ResourceClaimSpec defines how a resource is to be allocated.
        :param pulumi.Input[builtins.str] resource_class_name: ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        :param pulumi.Input[builtins.str] allocation_mode: Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        :param pulumi.Input['ResourceClaimParametersReferenceArgs'] parameters_ref: ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
               
               The object must be in the same namespace as the ResourceClaim.
        """
        pulumi.set(__self__, "resource_class_name", resource_class_name)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if parameters_ref is not None:
            pulumi.set(__self__, "parameters_ref", parameters_ref)

    @property
    @pulumi.getter(name="resourceClassName")
    def resource_class_name(self) -> pulumi.Input[builtins.str]:
        """
        ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        return pulumi.get(self, "resource_class_name")

    @resource_class_name.setter
    def resource_class_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_class_name", value)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        """
        return pulumi.get(self, "allocation_mode")

    @allocation_mode.setter
    def allocation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_mode", value)

    @property
    @pulumi.getter(name="parametersRef")
    def parameters_ref(self) -> Optional[pulumi.Input['ResourceClaimParametersReferenceArgs']]:
        """
        ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.

        The object must be in the same namespace as the ResourceClaim.
        """
        return pulumi.get(self, "parameters_ref")

    @parameters_ref.setter
    def parameters_ref(self, value: Optional[pulumi.Input['ResourceClaimParametersReferenceArgs']]):
        pulumi.set(self, "parameters_ref", value)


if not MYPY:
    class ResourceClaimStatusArgsDict(TypedDict):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
        """
        allocation: NotRequired[pulumi.Input['AllocationResultArgsDict']]
        """
        Allocation is set by the resource driver once a resource has been allocated successfully. If this is not specified, the resource is not yet allocated.
        """
        deallocation_requested: NotRequired[pulumi.Input[builtins.bool]]
        """
        DeallocationRequested indicates that a ResourceClaim is to be deallocated.

        The driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        """
        driver_name: NotRequired[pulumi.Input[builtins.str]]
        """
        DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        """
        reserved_for: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgsDict']]]]
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
elif False:
    ResourceClaimStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimStatusArgs:
    def __init__(__self__, *,
                 allocation: Optional[pulumi.Input['AllocationResultArgs']] = None,
                 deallocation_requested: Optional[pulumi.Input[builtins.bool]] = None,
                 driver_name: Optional[pulumi.Input[builtins.str]] = None,
                 reserved_for: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]]] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
        :param pulumi.Input['AllocationResultArgs'] allocation: Allocation is set by the resource driver once a resource has been allocated successfully. If this is not specified, the resource is not yet allocated.
        :param pulumi.Input[builtins.bool] deallocation_requested: DeallocationRequested indicates that a ResourceClaim is to be deallocated.
               
               The driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        :param pulumi.Input[builtins.str] driver_name: DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.
               
               There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional[pulumi.Input['AllocationResultArgs']]:
        """
        Allocation is set by the resource driver once a resource has been allocated successfully. If this is not specified, the resource is not yet allocated.
        """
        return pulumi.get(self, "allocation")

    @allocation.setter
    def allocation(self, value: Optional[pulumi.Input['AllocationResultArgs']]):
        pulumi.set(self, "allocation", value)

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        DeallocationRequested indicates that a ResourceClaim is to be deallocated.

        The driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        """
        return pulumi.get(self, "deallocation_requested")

    @deallocation_requested.setter
    def deallocation_requested(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deallocation_requested", value)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        """
        return pulumi.get(self, "driver_name")

    @driver_name.setter
    def driver_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "driver_name", value)

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]]]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")

    @reserved_for.setter
    def reserved_for(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]]]):
        pulumi.set(self, "reserved_for", value)


if not MYPY:
    class ResourceClaimTemplateSpecPatchArgsDict(TypedDict):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaPatchArgsDict']]
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        spec: NotRequired[pulumi.Input['ResourceClaimSpecPatchArgsDict']]
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
elif False:
    ResourceClaimTemplateSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimTemplateSpecPatchArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']] = None,
                 spec: Optional[pulumi.Input['ResourceClaimSpecPatchArgs']] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param pulumi.Input['_meta.v1.ObjectMetaPatchArgs'] metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        :param pulumi.Input['ResourceClaimSpecPatchArgs'] spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']]:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['ResourceClaimSpecPatchArgs']]:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['ResourceClaimSpecPatchArgs']]):
        pulumi.set(self, "spec", value)


if not MYPY:
    class ResourceClaimTemplateSpecArgsDict(TypedDict):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        """
        spec: pulumi.Input['ResourceClaimSpecArgsDict']
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
elif False:
    ResourceClaimTemplateSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimTemplateSpecArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceClaimSpecArgs'],
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param pulumi.Input['ResourceClaimSpecArgs'] spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceClaimSpecArgs']:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceClaimSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class ResourceClaimTemplateArgsDict(TypedDict):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.
        """
        spec: pulumi.Input['ResourceClaimTemplateSpecArgsDict']
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
elif False:
    ResourceClaimTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimTemplateArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceClaimTemplateSpecArgs'],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.
        :param pulumi.Input['ResourceClaimTemplateSpecArgs'] spec: Describes the ResourceClaim that is to be generated.
               
               This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaimTemplate')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceClaimTemplateSpecArgs']:
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceClaimTemplateSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class ResourceClaimArgsDict(TypedDict):
        """
        ResourceClaim describes which resources are needed by a resource consumer. Its status tracks whether the resource has been allocated and what the resulting attributes are.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        spec: pulumi.Input['ResourceClaimSpecArgsDict']
        """
        Spec describes the desired attributes of a resource that then needs to be allocated. It can only be set once when creating the ResourceClaim.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
        status: NotRequired[pulumi.Input['ResourceClaimStatusArgsDict']]
        """
        Status describes whether the resource is available and with which attributes.
        """
elif False:
    ResourceClaimArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceClaimSpecArgs'],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 status: Optional[pulumi.Input['ResourceClaimStatusArgs']] = None):
        """
        ResourceClaim describes which resources are needed by a resource consumer. Its status tracks whether the resource has been allocated and what the resulting attributes are.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input['ResourceClaimSpecArgs'] spec: Spec describes the desired attributes of a resource that then needs to be allocated. It can only be set once when creating the ResourceClaim.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        :param pulumi.Input['ResourceClaimStatusArgs'] status: Status describes whether the resource is available and with which attributes.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceClaimSpecArgs']:
        """
        Spec describes the desired attributes of a resource that then needs to be allocated. It can only be set once when creating the ResourceClaim.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceClaimSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ResourceClaimStatusArgs']]:
        """
        Status describes whether the resource is available and with which attributes.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ResourceClaimStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ResourceClassParametersReferencePatchArgsDict(TypedDict):
        """
        ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
        """
        api_group: NotRequired[pulumi.Input[builtins.str]]
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name is the name of resource being referenced.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
elif False:
    ResourceClassParametersReferencePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClassParametersReferencePatchArgs:
    def __init__(__self__, *,
                 api_group: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None):
        """
        ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
        :param pulumi.Input[builtins.str] api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param pulumi.Input[builtins.str] kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        :param pulumi.Input[builtins.str] name: Name is the name of resource being referenced.
        :param pulumi.Input[builtins.str] namespace: Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_group", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class ResourceClassParametersReferenceArgsDict(TypedDict):
        """
        ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
        """
        kind: pulumi.Input[builtins.str]
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        """
        name: pulumi.Input[builtins.str]
        """
        Name is the name of resource being referenced.
        """
        api_group: NotRequired[pulumi.Input[builtins.str]]
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
elif False:
    ResourceClassParametersReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClassParametersReferenceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 api_group: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None):
        """
        ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
        :param pulumi.Input[builtins.str] kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        :param pulumi.Input[builtins.str] name: Name is the name of resource being referenced.
        :param pulumi.Input[builtins.str] api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param pulumi.Input[builtins.str] namespace: Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[builtins.str]:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_group", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)


if not MYPY:
    class ResourceClassArgsDict(TypedDict):
        """
        ResourceClass is used by administrators to influence how resources are allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        driver_name: pulumi.Input[builtins.str]
        """
        DriverName defines the name of the dynamic resource driver that is used for allocation of a ResourceClaim that uses this class.

        Resource drivers have a unique name in forward domain order (acme.example.com).
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
        parameters_ref: NotRequired[pulumi.Input['ResourceClassParametersReferenceArgsDict']]
        """
        ParametersRef references an arbitrary separate object that may hold parameters that will be used by the driver when allocating a resource that uses this class. A dynamic resource driver can distinguish between parameters stored here and and those stored in ResourceClaimSpec.
        """
        suitable_nodes: NotRequired[pulumi.Input['_core.v1.NodeSelectorArgsDict']]
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a ResourceClaim that has not been allocated yet.

        Setting this field is optional. If null, all nodes are candidates.
        """
elif False:
    ResourceClassArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClassArgs:
    def __init__(__self__, *,
                 driver_name: pulumi.Input[builtins.str],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 parameters_ref: Optional[pulumi.Input['ResourceClassParametersReferenceArgs']] = None,
                 suitable_nodes: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']] = None):
        """
        ResourceClass is used by administrators to influence how resources are allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input[builtins.str] driver_name: DriverName defines the name of the dynamic resource driver that is used for allocation of a ResourceClaim that uses this class.
               
               Resource drivers have a unique name in forward domain order (acme.example.com).
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        :param pulumi.Input['ResourceClassParametersReferenceArgs'] parameters_ref: ParametersRef references an arbitrary separate object that may hold parameters that will be used by the driver when allocating a resource that uses this class. A dynamic resource driver can distinguish between parameters stored here and and those stored in ResourceClaimSpec.
        :param pulumi.Input['_core.v1.NodeSelectorArgs'] suitable_nodes: Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a ResourceClaim that has not been allocated yet.
               
               Setting this field is optional. If null, all nodes are candidates.
        """
        pulumi.set(__self__, "driver_name", driver_name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if parameters_ref is not None:
            pulumi.set(__self__, "parameters_ref", parameters_ref)
        if suitable_nodes is not None:
            pulumi.set(__self__, "suitable_nodes", suitable_nodes)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> pulumi.Input[builtins.str]:
        """
        DriverName defines the name of the dynamic resource driver that is used for allocation of a ResourceClaim that uses this class.

        Resource drivers have a unique name in forward domain order (acme.example.com).
        """
        return pulumi.get(self, "driver_name")

    @driver_name.setter
    def driver_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "driver_name", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="parametersRef")
    def parameters_ref(self) -> Optional[pulumi.Input['ResourceClassParametersReferenceArgs']]:
        """
        ParametersRef references an arbitrary separate object that may hold parameters that will be used by the driver when allocating a resource that uses this class. A dynamic resource driver can distinguish between parameters stored here and and those stored in ResourceClaimSpec.
        """
        return pulumi.get(self, "parameters_ref")

    @parameters_ref.setter
    def parameters_ref(self, value: Optional[pulumi.Input['ResourceClassParametersReferenceArgs']]):
        pulumi.set(self, "parameters_ref", value)

    @property
    @pulumi.getter(name="suitableNodes")
    def suitable_nodes(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]:
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a ResourceClaim that has not been allocated yet.

        Setting this field is optional. If null, all nodes are candidates.
        """
        return pulumi.get(self, "suitable_nodes")

    @suitable_nodes.setter
    def suitable_nodes(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]):
        pulumi.set(self, "suitable_nodes", value)


