# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'AllocationResult',
    'AllocationResultPatch',
    'DriverAllocationResult',
    'DriverAllocationResultPatch',
    'DriverRequests',
    'DriverRequestsPatch',
    'NamedResourcesAllocationResult',
    'NamedResourcesAllocationResultPatch',
    'NamedResourcesAttribute',
    'NamedResourcesAttributePatch',
    'NamedResourcesFilter',
    'NamedResourcesFilterPatch',
    'NamedResourcesInstance',
    'NamedResourcesInstancePatch',
    'NamedResourcesIntSlice',
    'NamedResourcesIntSlicePatch',
    'NamedResourcesRequest',
    'NamedResourcesRequestPatch',
    'NamedResourcesResources',
    'NamedResourcesResourcesPatch',
    'NamedResourcesStringSlice',
    'NamedResourcesStringSlicePatch',
    'PodSchedulingContext',
    'PodSchedulingContextSpec',
    'PodSchedulingContextSpecPatch',
    'PodSchedulingContextStatus',
    'PodSchedulingContextStatusPatch',
    'ResourceClaim',
    'ResourceClaimConsumerReference',
    'ResourceClaimConsumerReferencePatch',
    'ResourceClaimParameters',
    'ResourceClaimParametersReference',
    'ResourceClaimParametersReferencePatch',
    'ResourceClaimSchedulingStatus',
    'ResourceClaimSchedulingStatusPatch',
    'ResourceClaimSpec',
    'ResourceClaimSpecPatch',
    'ResourceClaimStatus',
    'ResourceClaimStatusPatch',
    'ResourceClaimTemplate',
    'ResourceClaimTemplateSpec',
    'ResourceClaimTemplateSpecPatch',
    'ResourceClass',
    'ResourceClassParameters',
    'ResourceClassParametersReference',
    'ResourceClassParametersReferencePatch',
    'ResourceFilter',
    'ResourceFilterPatch',
    'ResourceHandle',
    'ResourceHandlePatch',
    'ResourceRequest',
    'ResourceRequestPatch',
    'ResourceSlice',
    'StructuredResourceHandle',
    'StructuredResourceHandlePatch',
    'VendorParameters',
    'VendorParametersPatch',
]

@pulumi.output_type
class AllocationResult(dict):
    """
    AllocationResult contains attributes of an allocated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableOnNodes":
            suggest = "available_on_nodes"
        elif key == "resourceHandles":
            suggest = "resource_handles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_on_nodes: Optional['_core.v1.outputs.NodeSelector'] = None,
                 resource_handles: Optional[Sequence['outputs.ResourceHandle']] = None,
                 shareable: Optional[builtins.bool] = None):
        """
        AllocationResult contains attributes of an allocated resource.
        :param '_core.v1.NodeSelectorArgs' available_on_nodes: This field will get set by the resource driver after it has allocated the resource to inform the scheduler where it can schedule Pods using the ResourceClaim.
               
               Setting this field is optional. If null, the resource is available everywhere.
        :param Sequence['ResourceHandleArgs'] resource_handles: ResourceHandles contain the state associated with an allocation that should be maintained throughout the lifetime of a claim. Each ResourceHandle contains data that should be passed to a specific kubelet plugin once it lands on a node. This data is returned by the driver after a successful allocation and is opaque to Kubernetes. Driver documentation may explain to users how to interpret this data if needed.
               
               Setting this field is optional. It has a maximum size of 32 entries. If null (or empty), it is assumed this allocation will be processed by a single kubelet plugin with no ResourceHandle data attached. The name of the kubelet plugin invoked will match the DriverName set in the ResourceClaimStatus this AllocationResult is embedded in.
        :param builtins.bool shareable: Shareable determines whether the resource supports more than one consumer at a time.
        """
        if available_on_nodes is not None:
            pulumi.set(__self__, "available_on_nodes", available_on_nodes)
        if resource_handles is not None:
            pulumi.set(__self__, "resource_handles", resource_handles)
        if shareable is not None:
            pulumi.set(__self__, "shareable", shareable)

    @property
    @pulumi.getter(name="availableOnNodes")
    def available_on_nodes(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        This field will get set by the resource driver after it has allocated the resource to inform the scheduler where it can schedule Pods using the ResourceClaim.

        Setting this field is optional. If null, the resource is available everywhere.
        """
        return pulumi.get(self, "available_on_nodes")

    @property
    @pulumi.getter(name="resourceHandles")
    def resource_handles(self) -> Optional[Sequence['outputs.ResourceHandle']]:
        """
        ResourceHandles contain the state associated with an allocation that should be maintained throughout the lifetime of a claim. Each ResourceHandle contains data that should be passed to a specific kubelet plugin once it lands on a node. This data is returned by the driver after a successful allocation and is opaque to Kubernetes. Driver documentation may explain to users how to interpret this data if needed.

        Setting this field is optional. It has a maximum size of 32 entries. If null (or empty), it is assumed this allocation will be processed by a single kubelet plugin with no ResourceHandle data attached. The name of the kubelet plugin invoked will match the DriverName set in the ResourceClaimStatus this AllocationResult is embedded in.
        """
        return pulumi.get(self, "resource_handles")

    @property
    @pulumi.getter
    def shareable(self) -> Optional[builtins.bool]:
        """
        Shareable determines whether the resource supports more than one consumer at a time.
        """
        return pulumi.get(self, "shareable")


@pulumi.output_type
class AllocationResultPatch(dict):
    """
    AllocationResult contains attributes of an allocated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableOnNodes":
            suggest = "available_on_nodes"
        elif key == "resourceHandles":
            suggest = "resource_handles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationResultPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationResultPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationResultPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_on_nodes: Optional['_core.v1.outputs.NodeSelectorPatch'] = None,
                 resource_handles: Optional[Sequence['outputs.ResourceHandlePatch']] = None,
                 shareable: Optional[builtins.bool] = None):
        """
        AllocationResult contains attributes of an allocated resource.
        :param '_core.v1.NodeSelectorPatchArgs' available_on_nodes: This field will get set by the resource driver after it has allocated the resource to inform the scheduler where it can schedule Pods using the ResourceClaim.
               
               Setting this field is optional. If null, the resource is available everywhere.
        :param Sequence['ResourceHandlePatchArgs'] resource_handles: ResourceHandles contain the state associated with an allocation that should be maintained throughout the lifetime of a claim. Each ResourceHandle contains data that should be passed to a specific kubelet plugin once it lands on a node. This data is returned by the driver after a successful allocation and is opaque to Kubernetes. Driver documentation may explain to users how to interpret this data if needed.
               
               Setting this field is optional. It has a maximum size of 32 entries. If null (or empty), it is assumed this allocation will be processed by a single kubelet plugin with no ResourceHandle data attached. The name of the kubelet plugin invoked will match the DriverName set in the ResourceClaimStatus this AllocationResult is embedded in.
        :param builtins.bool shareable: Shareable determines whether the resource supports more than one consumer at a time.
        """
        if available_on_nodes is not None:
            pulumi.set(__self__, "available_on_nodes", available_on_nodes)
        if resource_handles is not None:
            pulumi.set(__self__, "resource_handles", resource_handles)
        if shareable is not None:
            pulumi.set(__self__, "shareable", shareable)

    @property
    @pulumi.getter(name="availableOnNodes")
    def available_on_nodes(self) -> Optional['_core.v1.outputs.NodeSelectorPatch']:
        """
        This field will get set by the resource driver after it has allocated the resource to inform the scheduler where it can schedule Pods using the ResourceClaim.

        Setting this field is optional. If null, the resource is available everywhere.
        """
        return pulumi.get(self, "available_on_nodes")

    @property
    @pulumi.getter(name="resourceHandles")
    def resource_handles(self) -> Optional[Sequence['outputs.ResourceHandlePatch']]:
        """
        ResourceHandles contain the state associated with an allocation that should be maintained throughout the lifetime of a claim. Each ResourceHandle contains data that should be passed to a specific kubelet plugin once it lands on a node. This data is returned by the driver after a successful allocation and is opaque to Kubernetes. Driver documentation may explain to users how to interpret this data if needed.

        Setting this field is optional. It has a maximum size of 32 entries. If null (or empty), it is assumed this allocation will be processed by a single kubelet plugin with no ResourceHandle data attached. The name of the kubelet plugin invoked will match the DriverName set in the ResourceClaimStatus this AllocationResult is embedded in.
        """
        return pulumi.get(self, "resource_handles")

    @property
    @pulumi.getter
    def shareable(self) -> Optional[builtins.bool]:
        """
        Shareable determines whether the resource supports more than one consumer at a time.
        """
        return pulumi.get(self, "shareable")


@pulumi.output_type
class DriverAllocationResult(dict):
    """
    DriverAllocationResult contains vendor parameters and the allocation result for one request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namedResources":
            suggest = "named_resources"
        elif key == "vendorRequestParameters":
            suggest = "vendor_request_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DriverAllocationResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DriverAllocationResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DriverAllocationResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 named_resources: Optional['outputs.NamedResourcesAllocationResult'] = None,
                 vendor_request_parameters: Optional[Any] = None):
        """
        DriverAllocationResult contains vendor parameters and the allocation result for one request.
        :param 'NamedResourcesAllocationResultArgs' named_resources: NamedResources describes the allocation result when using the named resources model.
        :param Any vendor_request_parameters: VendorRequestParameters are the per-request configuration parameters from the time that the claim was allocated.
        """
        if named_resources is not None:
            pulumi.set(__self__, "named_resources", named_resources)
        if vendor_request_parameters is not None:
            pulumi.set(__self__, "vendor_request_parameters", vendor_request_parameters)

    @property
    @pulumi.getter(name="namedResources")
    def named_resources(self) -> Optional['outputs.NamedResourcesAllocationResult']:
        """
        NamedResources describes the allocation result when using the named resources model.
        """
        return pulumi.get(self, "named_resources")

    @property
    @pulumi.getter(name="vendorRequestParameters")
    def vendor_request_parameters(self) -> Optional[Any]:
        """
        VendorRequestParameters are the per-request configuration parameters from the time that the claim was allocated.
        """
        return pulumi.get(self, "vendor_request_parameters")


@pulumi.output_type
class DriverAllocationResultPatch(dict):
    """
    DriverAllocationResult contains vendor parameters and the allocation result for one request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namedResources":
            suggest = "named_resources"
        elif key == "vendorRequestParameters":
            suggest = "vendor_request_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DriverAllocationResultPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DriverAllocationResultPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DriverAllocationResultPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 named_resources: Optional['outputs.NamedResourcesAllocationResultPatch'] = None,
                 vendor_request_parameters: Optional[Any] = None):
        """
        DriverAllocationResult contains vendor parameters and the allocation result for one request.
        :param 'NamedResourcesAllocationResultPatchArgs' named_resources: NamedResources describes the allocation result when using the named resources model.
        :param Any vendor_request_parameters: VendorRequestParameters are the per-request configuration parameters from the time that the claim was allocated.
        """
        if named_resources is not None:
            pulumi.set(__self__, "named_resources", named_resources)
        if vendor_request_parameters is not None:
            pulumi.set(__self__, "vendor_request_parameters", vendor_request_parameters)

    @property
    @pulumi.getter(name="namedResources")
    def named_resources(self) -> Optional['outputs.NamedResourcesAllocationResultPatch']:
        """
        NamedResources describes the allocation result when using the named resources model.
        """
        return pulumi.get(self, "named_resources")

    @property
    @pulumi.getter(name="vendorRequestParameters")
    def vendor_request_parameters(self) -> Optional[Any]:
        """
        VendorRequestParameters are the per-request configuration parameters from the time that the claim was allocated.
        """
        return pulumi.get(self, "vendor_request_parameters")


@pulumi.output_type
class DriverRequests(dict):
    """
    DriverRequests describes all resources that are needed from one particular driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "vendorParameters":
            suggest = "vendor_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DriverRequests. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DriverRequests.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DriverRequests.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[builtins.str] = None,
                 requests: Optional[Sequence['outputs.ResourceRequest']] = None,
                 vendor_parameters: Optional[Any] = None):
        """
        DriverRequests describes all resources that are needed from one particular driver.
        :param builtins.str driver_name: DriverName is the name used by the DRA driver kubelet plugin.
        :param Sequence['ResourceRequestArgs'] requests: Requests describes all resources that are needed from the driver.
        :param Any vendor_parameters: VendorParameters are arbitrary setup parameters for all requests of the claim. They are ignored while allocating the claim.
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if vendor_parameters is not None:
            pulumi.set(__self__, "vendor_parameters", vendor_parameters)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName is the name used by the DRA driver kubelet plugin.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence['outputs.ResourceRequest']]:
        """
        Requests describes all resources that are needed from the driver.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="vendorParameters")
    def vendor_parameters(self) -> Optional[Any]:
        """
        VendorParameters are arbitrary setup parameters for all requests of the claim. They are ignored while allocating the claim.
        """
        return pulumi.get(self, "vendor_parameters")


@pulumi.output_type
class DriverRequestsPatch(dict):
    """
    DriverRequests describes all resources that are needed from one particular driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "vendorParameters":
            suggest = "vendor_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DriverRequestsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DriverRequestsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DriverRequestsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[builtins.str] = None,
                 requests: Optional[Sequence['outputs.ResourceRequestPatch']] = None,
                 vendor_parameters: Optional[Any] = None):
        """
        DriverRequests describes all resources that are needed from one particular driver.
        :param builtins.str driver_name: DriverName is the name used by the DRA driver kubelet plugin.
        :param Sequence['ResourceRequestPatchArgs'] requests: Requests describes all resources that are needed from the driver.
        :param Any vendor_parameters: VendorParameters are arbitrary setup parameters for all requests of the claim. They are ignored while allocating the claim.
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if vendor_parameters is not None:
            pulumi.set(__self__, "vendor_parameters", vendor_parameters)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName is the name used by the DRA driver kubelet plugin.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence['outputs.ResourceRequestPatch']]:
        """
        Requests describes all resources that are needed from the driver.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="vendorParameters")
    def vendor_parameters(self) -> Optional[Any]:
        """
        VendorParameters are arbitrary setup parameters for all requests of the claim. They are ignored while allocating the claim.
        """
        return pulumi.get(self, "vendor_parameters")


@pulumi.output_type
class NamedResourcesAllocationResult(dict):
    """
    NamedResourcesAllocationResult is used in AllocationResultModel.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        NamedResourcesAllocationResult is used in AllocationResultModel.
        :param builtins.str name: Name is the name of the selected resource instance.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is the name of the selected resource instance.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NamedResourcesAllocationResultPatch(dict):
    """
    NamedResourcesAllocationResult is used in AllocationResultModel.
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        NamedResourcesAllocationResult is used in AllocationResultModel.
        :param builtins.str name: Name is the name of the selected resource instance.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is the name of the selected resource instance.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NamedResourcesAttribute(dict):
    """
    NamedResourcesAttribute is a combination of an attribute name and its value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intSlice":
            suggest = "int_slice"
        elif key == "stringSlice":
            suggest = "string_slice"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamedResourcesAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamedResourcesAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamedResourcesAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 bool: Optional[builtins.bool] = None,
                 int: Optional[builtins.int] = None,
                 int_slice: Optional['outputs.NamedResourcesIntSlice'] = None,
                 quantity: Optional[builtins.str] = None,
                 string: Optional[builtins.str] = None,
                 string_slice: Optional['outputs.NamedResourcesStringSlice'] = None,
                 version: Optional[builtins.str] = None):
        """
        NamedResourcesAttribute is a combination of an attribute name and its value.
        :param builtins.str name: Name is unique identifier among all resource instances managed by the driver on the node. It must be a DNS subdomain.
        :param builtins.bool bool: BoolValue is a true/false value.
        :param builtins.int int: IntValue is a 64-bit integer.
        :param 'NamedResourcesIntSliceArgs' int_slice: IntSliceValue is an array of 64-bit integers.
        :param builtins.str quantity: QuantityValue is a quantity.
        :param builtins.str string: StringValue is a string.
        :param 'NamedResourcesStringSliceArgs' string_slice: StringSliceValue is an array of strings.
        :param builtins.str version: VersionValue is a semantic version according to semver.org spec 2.0.0.
        """
        pulumi.set(__self__, "name", name)
        if bool is not None:
            pulumi.set(__self__, "bool", bool)
        if int is not None:
            pulumi.set(__self__, "int", int)
        if int_slice is not None:
            pulumi.set(__self__, "int_slice", int_slice)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)
        if string is not None:
            pulumi.set(__self__, "string", string)
        if string_slice is not None:
            pulumi.set(__self__, "string_slice", string_slice)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is unique identifier among all resource instances managed by the driver on the node. It must be a DNS subdomain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def bool(self) -> Optional[builtins.bool]:
        """
        BoolValue is a true/false value.
        """
        return pulumi.get(self, "bool")

    @property
    @pulumi.getter
    def int(self) -> Optional[builtins.int]:
        """
        IntValue is a 64-bit integer.
        """
        return pulumi.get(self, "int")

    @property
    @pulumi.getter(name="intSlice")
    def int_slice(self) -> Optional['outputs.NamedResourcesIntSlice']:
        """
        IntSliceValue is an array of 64-bit integers.
        """
        return pulumi.get(self, "int_slice")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[builtins.str]:
        """
        QuantityValue is a quantity.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def string(self) -> Optional[builtins.str]:
        """
        StringValue is a string.
        """
        return pulumi.get(self, "string")

    @property
    @pulumi.getter(name="stringSlice")
    def string_slice(self) -> Optional['outputs.NamedResourcesStringSlice']:
        """
        StringSliceValue is an array of strings.
        """
        return pulumi.get(self, "string_slice")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        VersionValue is a semantic version according to semver.org spec 2.0.0.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class NamedResourcesAttributePatch(dict):
    """
    NamedResourcesAttribute is a combination of an attribute name and its value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intSlice":
            suggest = "int_slice"
        elif key == "stringSlice":
            suggest = "string_slice"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamedResourcesAttributePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamedResourcesAttributePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamedResourcesAttributePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool: Optional[builtins.bool] = None,
                 int: Optional[builtins.int] = None,
                 int_slice: Optional['outputs.NamedResourcesIntSlicePatch'] = None,
                 name: Optional[builtins.str] = None,
                 quantity: Optional[builtins.str] = None,
                 string: Optional[builtins.str] = None,
                 string_slice: Optional['outputs.NamedResourcesStringSlicePatch'] = None,
                 version: Optional[builtins.str] = None):
        """
        NamedResourcesAttribute is a combination of an attribute name and its value.
        :param builtins.bool bool: BoolValue is a true/false value.
        :param builtins.int int: IntValue is a 64-bit integer.
        :param 'NamedResourcesIntSlicePatchArgs' int_slice: IntSliceValue is an array of 64-bit integers.
        :param builtins.str name: Name is unique identifier among all resource instances managed by the driver on the node. It must be a DNS subdomain.
        :param builtins.str quantity: QuantityValue is a quantity.
        :param builtins.str string: StringValue is a string.
        :param 'NamedResourcesStringSlicePatchArgs' string_slice: StringSliceValue is an array of strings.
        :param builtins.str version: VersionValue is a semantic version according to semver.org spec 2.0.0.
        """
        if bool is not None:
            pulumi.set(__self__, "bool", bool)
        if int is not None:
            pulumi.set(__self__, "int", int)
        if int_slice is not None:
            pulumi.set(__self__, "int_slice", int_slice)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)
        if string is not None:
            pulumi.set(__self__, "string", string)
        if string_slice is not None:
            pulumi.set(__self__, "string_slice", string_slice)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bool(self) -> Optional[builtins.bool]:
        """
        BoolValue is a true/false value.
        """
        return pulumi.get(self, "bool")

    @property
    @pulumi.getter
    def int(self) -> Optional[builtins.int]:
        """
        IntValue is a 64-bit integer.
        """
        return pulumi.get(self, "int")

    @property
    @pulumi.getter(name="intSlice")
    def int_slice(self) -> Optional['outputs.NamedResourcesIntSlicePatch']:
        """
        IntSliceValue is an array of 64-bit integers.
        """
        return pulumi.get(self, "int_slice")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is unique identifier among all resource instances managed by the driver on the node. It must be a DNS subdomain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[builtins.str]:
        """
        QuantityValue is a quantity.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def string(self) -> Optional[builtins.str]:
        """
        StringValue is a string.
        """
        return pulumi.get(self, "string")

    @property
    @pulumi.getter(name="stringSlice")
    def string_slice(self) -> Optional['outputs.NamedResourcesStringSlicePatch']:
        """
        StringSliceValue is an array of strings.
        """
        return pulumi.get(self, "string_slice")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        VersionValue is a semantic version according to semver.org spec 2.0.0.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class NamedResourcesFilter(dict):
    """
    NamedResourcesFilter is used in ResourceFilterModel.
    """
    def __init__(__self__, *,
                 selector: builtins.str):
        """
        NamedResourcesFilter is used in ResourceFilterModel.
        :param builtins.str selector: Selector is a CEL expression which must evaluate to true if a resource instance is suitable. The language is as defined in https://kubernetes.io/docs/reference/using-api/cel/
               
               In addition, for each type NamedResourcesin AttributeValue there is a map that resolves to the corresponding value of the instance under evaluation. For example:
               
                  attributes.quantity["a"].isGreaterThan(quantity("0")) &&
                  attributes.stringslice["b"].isSorted()
        """
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def selector(self) -> builtins.str:
        """
        Selector is a CEL expression which must evaluate to true if a resource instance is suitable. The language is as defined in https://kubernetes.io/docs/reference/using-api/cel/

        In addition, for each type NamedResourcesin AttributeValue there is a map that resolves to the corresponding value of the instance under evaluation. For example:

           attributes.quantity["a"].isGreaterThan(quantity("0")) &&
           attributes.stringslice["b"].isSorted()
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class NamedResourcesFilterPatch(dict):
    """
    NamedResourcesFilter is used in ResourceFilterModel.
    """
    def __init__(__self__, *,
                 selector: Optional[builtins.str] = None):
        """
        NamedResourcesFilter is used in ResourceFilterModel.
        :param builtins.str selector: Selector is a CEL expression which must evaluate to true if a resource instance is suitable. The language is as defined in https://kubernetes.io/docs/reference/using-api/cel/
               
               In addition, for each type NamedResourcesin AttributeValue there is a map that resolves to the corresponding value of the instance under evaluation. For example:
               
                  attributes.quantity["a"].isGreaterThan(quantity("0")) &&
                  attributes.stringslice["b"].isSorted()
        """
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def selector(self) -> Optional[builtins.str]:
        """
        Selector is a CEL expression which must evaluate to true if a resource instance is suitable. The language is as defined in https://kubernetes.io/docs/reference/using-api/cel/

        In addition, for each type NamedResourcesin AttributeValue there is a map that resolves to the corresponding value of the instance under evaluation. For example:

           attributes.quantity["a"].isGreaterThan(quantity("0")) &&
           attributes.stringslice["b"].isSorted()
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class NamedResourcesInstance(dict):
    """
    NamedResourcesInstance represents one individual hardware instance that can be selected based on its attributes.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 attributes: Optional[Sequence['outputs.NamedResourcesAttribute']] = None):
        """
        NamedResourcesInstance represents one individual hardware instance that can be selected based on its attributes.
        :param builtins.str name: Name is unique identifier among all resource instances managed by the driver on the node. It must be a DNS subdomain.
        :param Sequence['NamedResourcesAttributeArgs'] attributes: Attributes defines the attributes of this resource instance. The name of each attribute must be unique.
        """
        pulumi.set(__self__, "name", name)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is unique identifier among all resource instances managed by the driver on the node. It must be a DNS subdomain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Sequence['outputs.NamedResourcesAttribute']]:
        """
        Attributes defines the attributes of this resource instance. The name of each attribute must be unique.
        """
        return pulumi.get(self, "attributes")


@pulumi.output_type
class NamedResourcesInstancePatch(dict):
    """
    NamedResourcesInstance represents one individual hardware instance that can be selected based on its attributes.
    """
    def __init__(__self__, *,
                 attributes: Optional[Sequence['outputs.NamedResourcesAttributePatch']] = None,
                 name: Optional[builtins.str] = None):
        """
        NamedResourcesInstance represents one individual hardware instance that can be selected based on its attributes.
        :param Sequence['NamedResourcesAttributePatchArgs'] attributes: Attributes defines the attributes of this resource instance. The name of each attribute must be unique.
        :param builtins.str name: Name is unique identifier among all resource instances managed by the driver on the node. It must be a DNS subdomain.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Sequence['outputs.NamedResourcesAttributePatch']]:
        """
        Attributes defines the attributes of this resource instance. The name of each attribute must be unique.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is unique identifier among all resource instances managed by the driver on the node. It must be a DNS subdomain.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NamedResourcesIntSlice(dict):
    """
    NamedResourcesIntSlice contains a slice of 64-bit integers.
    """
    def __init__(__self__, *,
                 ints: Sequence[builtins.int]):
        """
        NamedResourcesIntSlice contains a slice of 64-bit integers.
        :param Sequence[builtins.int] ints: Ints is the slice of 64-bit integers.
        """
        pulumi.set(__self__, "ints", ints)

    @property
    @pulumi.getter
    def ints(self) -> Sequence[builtins.int]:
        """
        Ints is the slice of 64-bit integers.
        """
        return pulumi.get(self, "ints")


@pulumi.output_type
class NamedResourcesIntSlicePatch(dict):
    """
    NamedResourcesIntSlice contains a slice of 64-bit integers.
    """
    def __init__(__self__, *,
                 ints: Optional[Sequence[builtins.int]] = None):
        """
        NamedResourcesIntSlice contains a slice of 64-bit integers.
        :param Sequence[builtins.int] ints: Ints is the slice of 64-bit integers.
        """
        if ints is not None:
            pulumi.set(__self__, "ints", ints)

    @property
    @pulumi.getter
    def ints(self) -> Optional[Sequence[builtins.int]]:
        """
        Ints is the slice of 64-bit integers.
        """
        return pulumi.get(self, "ints")


@pulumi.output_type
class NamedResourcesRequest(dict):
    """
    NamedResourcesRequest is used in ResourceRequestModel.
    """
    def __init__(__self__, *,
                 selector: builtins.str):
        """
        NamedResourcesRequest is used in ResourceRequestModel.
        :param builtins.str selector: Selector is a CEL expression which must evaluate to true if a resource instance is suitable. The language is as defined in https://kubernetes.io/docs/reference/using-api/cel/
               
               In addition, for each type NamedResourcesin AttributeValue there is a map that resolves to the corresponding value of the instance under evaluation. For example:
               
                  attributes.quantity["a"].isGreaterThan(quantity("0")) &&
                  attributes.stringslice["b"].isSorted()
        """
        pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def selector(self) -> builtins.str:
        """
        Selector is a CEL expression which must evaluate to true if a resource instance is suitable. The language is as defined in https://kubernetes.io/docs/reference/using-api/cel/

        In addition, for each type NamedResourcesin AttributeValue there is a map that resolves to the corresponding value of the instance under evaluation. For example:

           attributes.quantity["a"].isGreaterThan(quantity("0")) &&
           attributes.stringslice["b"].isSorted()
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class NamedResourcesRequestPatch(dict):
    """
    NamedResourcesRequest is used in ResourceRequestModel.
    """
    def __init__(__self__, *,
                 selector: Optional[builtins.str] = None):
        """
        NamedResourcesRequest is used in ResourceRequestModel.
        :param builtins.str selector: Selector is a CEL expression which must evaluate to true if a resource instance is suitable. The language is as defined in https://kubernetes.io/docs/reference/using-api/cel/
               
               In addition, for each type NamedResourcesin AttributeValue there is a map that resolves to the corresponding value of the instance under evaluation. For example:
               
                  attributes.quantity["a"].isGreaterThan(quantity("0")) &&
                  attributes.stringslice["b"].isSorted()
        """
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def selector(self) -> Optional[builtins.str]:
        """
        Selector is a CEL expression which must evaluate to true if a resource instance is suitable. The language is as defined in https://kubernetes.io/docs/reference/using-api/cel/

        In addition, for each type NamedResourcesin AttributeValue there is a map that resolves to the corresponding value of the instance under evaluation. For example:

           attributes.quantity["a"].isGreaterThan(quantity("0")) &&
           attributes.stringslice["b"].isSorted()
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class NamedResourcesResources(dict):
    """
    NamedResourcesResources is used in ResourceModel.
    """
    def __init__(__self__, *,
                 instances: Sequence['outputs.NamedResourcesInstance']):
        """
        NamedResourcesResources is used in ResourceModel.
        :param Sequence['NamedResourcesInstanceArgs'] instances: The list of all individual resources instances currently available.
        """
        pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.NamedResourcesInstance']:
        """
        The list of all individual resources instances currently available.
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class NamedResourcesResourcesPatch(dict):
    """
    NamedResourcesResources is used in ResourceModel.
    """
    def __init__(__self__, *,
                 instances: Optional[Sequence['outputs.NamedResourcesInstancePatch']] = None):
        """
        NamedResourcesResources is used in ResourceModel.
        :param Sequence['NamedResourcesInstancePatchArgs'] instances: The list of all individual resources instances currently available.
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Optional[Sequence['outputs.NamedResourcesInstancePatch']]:
        """
        The list of all individual resources instances currently available.
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class NamedResourcesStringSlice(dict):
    """
    NamedResourcesStringSlice contains a slice of strings.
    """
    def __init__(__self__, *,
                 strings: Sequence[builtins.str]):
        """
        NamedResourcesStringSlice contains a slice of strings.
        :param Sequence[builtins.str] strings: Strings is the slice of strings.
        """
        pulumi.set(__self__, "strings", strings)

    @property
    @pulumi.getter
    def strings(self) -> Sequence[builtins.str]:
        """
        Strings is the slice of strings.
        """
        return pulumi.get(self, "strings")


@pulumi.output_type
class NamedResourcesStringSlicePatch(dict):
    """
    NamedResourcesStringSlice contains a slice of strings.
    """
    def __init__(__self__, *,
                 strings: Optional[Sequence[builtins.str]] = None):
        """
        NamedResourcesStringSlice contains a slice of strings.
        :param Sequence[builtins.str] strings: Strings is the slice of strings.
        """
        if strings is not None:
            pulumi.set(__self__, "strings", strings)

    @property
    @pulumi.getter
    def strings(self) -> Optional[Sequence[builtins.str]]:
        """
        Strings is the slice of strings.
        """
        return pulumi.get(self, "strings")


@pulumi.output_type
class PodSchedulingContext(dict):
    """
    PodSchedulingContext objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.PodSchedulingContextSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.PodSchedulingContextStatus'] = None):
        """
        PodSchedulingContext objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'PodSchedulingContextSpecArgs' spec: Spec describes where resources for the Pod are needed.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'PodSchedulingContextStatusArgs' status: Status describes where resources for the Pod can be allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha2')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PodSchedulingContext')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.PodSchedulingContextSpec':
        """
        Spec describes where resources for the Pod are needed.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.PodSchedulingContextStatus']:
        """
        Status describes where resources for the Pod can be allocated.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PodSchedulingContextSpec(dict):
    """
    PodSchedulingContextSpec describes where resources for the Pod are needed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "potentialNodes":
            suggest = "potential_nodes"
        elif key == "selectedNode":
            suggest = "selected_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 potential_nodes: Optional[Sequence[builtins.str]] = None,
                 selected_node: Optional[builtins.str] = None):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        :param Sequence[builtins.str] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param builtins.str selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[builtins.str]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")


@pulumi.output_type
class PodSchedulingContextSpecPatch(dict):
    """
    PodSchedulingContextSpec describes where resources for the Pod are needed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "potentialNodes":
            suggest = "potential_nodes"
        elif key == "selectedNode":
            suggest = "selected_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 potential_nodes: Optional[Sequence[builtins.str]] = None,
                 selected_node: Optional[builtins.str] = None):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        :param Sequence[builtins.str] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param builtins.str selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[builtins.str]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")


@pulumi.output_type
class PodSchedulingContextStatus(dict):
    """
    PodSchedulingContextStatus describes where resources for the Pod can be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaims":
            suggest = "resource_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claims: Optional[Sequence['outputs.ResourceClaimSchedulingStatus']] = None):
        """
        PodSchedulingContextStatus describes where resources for the Pod can be allocated.
        :param Sequence['ResourceClaimSchedulingStatusArgs'] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[Sequence['outputs.ResourceClaimSchedulingStatus']]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")


@pulumi.output_type
class PodSchedulingContextStatusPatch(dict):
    """
    PodSchedulingContextStatus describes where resources for the Pod can be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaims":
            suggest = "resource_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claims: Optional[Sequence['outputs.ResourceClaimSchedulingStatusPatch']] = None):
        """
        PodSchedulingContextStatus describes where resources for the Pod can be allocated.
        :param Sequence['ResourceClaimSchedulingStatusPatchArgs'] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[Sequence['outputs.ResourceClaimSchedulingStatusPatch']]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")


@pulumi.output_type
class ResourceClaim(dict):
    """
    ResourceClaim describes which resources are needed by a resource consumer. Its status tracks whether the resource has been allocated and what the resulting attributes are.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaim. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaim.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaim.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.ResourceClaimStatus'] = None):
        """
        ResourceClaim describes which resources are needed by a resource consumer. Its status tracks whether the resource has been allocated and what the resulting attributes are.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'ResourceClaimSpecArgs' spec: Spec describes the desired attributes of a resource that then needs to be allocated. It can only be set once when creating the ResourceClaim.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'ResourceClaimStatusArgs' status: Status describes whether the resource is available and with which attributes.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha2')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimSpec':
        """
        Spec describes the desired attributes of a resource that then needs to be allocated. It can only be set once when creating the ResourceClaim.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ResourceClaimStatus']:
        """
        Status describes whether the resource is available and with which attributes.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceClaimConsumerReference(dict):
    """
    ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimConsumerReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimConsumerReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimConsumerReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 resource: builtins.str,
                 uid: builtins.str,
                 api_group: Optional[builtins.str] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param builtins.str name: Name is the name of resource being referenced.
        :param builtins.str resource: Resource is the type of resource being referenced, for example "pods".
        :param builtins.str uid: UID identifies exactly one incarnation of the resource.
        :param builtins.str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "uid", uid)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")


@pulumi.output_type
class ResourceClaimConsumerReferencePatch(dict):
    """
    ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimConsumerReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimConsumerReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimConsumerReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_group: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 resource: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param builtins.str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param builtins.str name: Name is the name of resource being referenced.
        :param builtins.str resource: Resource is the type of resource being referenced, for example "pods".
        :param builtins.str uid: UID identifies exactly one incarnation of the resource.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> Optional[builtins.str]:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ResourceClaimParameters(dict):
    """
    ResourceClaimParameters defines resource requests for a ResourceClaim in an in-tree format understood by Kubernetes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "driverRequests":
            suggest = "driver_requests"
        elif key == "generatedFrom":
            suggest = "generated_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 driver_requests: Optional[Sequence['outputs.DriverRequests']] = None,
                 generated_from: Optional['outputs.ResourceClaimParametersReference'] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 shareable: Optional[builtins.bool] = None):
        """
        ResourceClaimParameters defines resource requests for a ResourceClaim in an in-tree format understood by Kubernetes.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param Sequence['DriverRequestsArgs'] driver_requests: DriverRequests describes all resources that are needed for the allocated claim. A single claim may use resources coming from different drivers. For each driver, this array has at most one entry which then may have one or more per-driver requests.
               
               May be empty, in which case the claim can always be allocated.
        :param 'ResourceClaimParametersReferenceArgs' generated_from: If this object was created from some other resource, then this links back to that resource. This field is used to find the in-tree representation of the claim parameters when the parameter reference of the claim refers to some unknown type.
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param builtins.bool shareable: Shareable indicates whether the allocated claim is meant to be shareable by multiple consumers at the same time.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha2')
        if driver_requests is not None:
            pulumi.set(__self__, "driver_requests", driver_requests)
        if generated_from is not None:
            pulumi.set(__self__, "generated_from", generated_from)
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaimParameters')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if shareable is not None:
            pulumi.set(__self__, "shareable", shareable)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="driverRequests")
    def driver_requests(self) -> Optional[Sequence['outputs.DriverRequests']]:
        """
        DriverRequests describes all resources that are needed for the allocated claim. A single claim may use resources coming from different drivers. For each driver, this array has at most one entry which then may have one or more per-driver requests.

        May be empty, in which case the claim can always be allocated.
        """
        return pulumi.get(self, "driver_requests")

    @property
    @pulumi.getter(name="generatedFrom")
    def generated_from(self) -> Optional['outputs.ResourceClaimParametersReference']:
        """
        If this object was created from some other resource, then this links back to that resource. This field is used to find the in-tree representation of the claim parameters when the parameter reference of the claim refers to some unknown type.
        """
        return pulumi.get(self, "generated_from")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def shareable(self) -> Optional[builtins.bool]:
        """
        Shareable indicates whether the allocated claim is meant to be shareable by multiple consumers at the same time.
        """
        return pulumi.get(self, "shareable")


@pulumi.output_type
class ResourceClaimParametersReference(dict):
    """
    ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimParametersReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimParametersReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimParametersReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: builtins.str,
                 name: builtins.str,
                 api_group: Optional[builtins.str] = None):
        """
        ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
        :param builtins.str kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        :param builtins.str name: Name is the name of resource being referenced.
        :param builtins.str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")


@pulumi.output_type
class ResourceClaimParametersReferencePatch(dict):
    """
    ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimParametersReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimParametersReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimParametersReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_group: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
        :param builtins.str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param builtins.str kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        :param builtins.str name: Name is the name of resource being referenced.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ResourceClaimSchedulingStatus(dict):
    """
    ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unsuitableNodes":
            suggest = "unsuitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSchedulingStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSchedulingStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSchedulingStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 unsuitable_nodes: Optional[Sequence[builtins.str]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param builtins.str name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param Sequence[builtins.str] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")


@pulumi.output_type
class ResourceClaimSchedulingStatusPatch(dict):
    """
    ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unsuitableNodes":
            suggest = "unsuitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSchedulingStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSchedulingStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSchedulingStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 unsuitable_nodes: Optional[Sequence[builtins.str]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param builtins.str name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param Sequence[builtins.str] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")


@pulumi.output_type
class ResourceClaimSpec(dict):
    """
    ResourceClaimSpec defines how a resource is to be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClassName":
            suggest = "resource_class_name"
        elif key == "allocationMode":
            suggest = "allocation_mode"
        elif key == "parametersRef":
            suggest = "parameters_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_class_name: builtins.str,
                 allocation_mode: Optional[builtins.str] = None,
                 parameters_ref: Optional['outputs.ResourceClaimParametersReference'] = None):
        """
        ResourceClaimSpec defines how a resource is to be allocated.
        :param builtins.str resource_class_name: ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        :param builtins.str allocation_mode: Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        :param 'ResourceClaimParametersReferenceArgs' parameters_ref: ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
               
               The object must be in the same namespace as the ResourceClaim.
        """
        pulumi.set(__self__, "resource_class_name", resource_class_name)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if parameters_ref is not None:
            pulumi.set(__self__, "parameters_ref", parameters_ref)

    @property
    @pulumi.getter(name="resourceClassName")
    def resource_class_name(self) -> builtins.str:
        """
        ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        return pulumi.get(self, "resource_class_name")

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[builtins.str]:
        """
        Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter(name="parametersRef")
    def parameters_ref(self) -> Optional['outputs.ResourceClaimParametersReference']:
        """
        ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.

        The object must be in the same namespace as the ResourceClaim.
        """
        return pulumi.get(self, "parameters_ref")


@pulumi.output_type
class ResourceClaimSpecPatch(dict):
    """
    ResourceClaimSpec defines how a resource is to be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationMode":
            suggest = "allocation_mode"
        elif key == "parametersRef":
            suggest = "parameters_ref"
        elif key == "resourceClassName":
            suggest = "resource_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_mode: Optional[builtins.str] = None,
                 parameters_ref: Optional['outputs.ResourceClaimParametersReferencePatch'] = None,
                 resource_class_name: Optional[builtins.str] = None):
        """
        ResourceClaimSpec defines how a resource is to be allocated.
        :param builtins.str allocation_mode: Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        :param 'ResourceClaimParametersReferencePatchArgs' parameters_ref: ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
               
               The object must be in the same namespace as the ResourceClaim.
        :param builtins.str resource_class_name: ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if parameters_ref is not None:
            pulumi.set(__self__, "parameters_ref", parameters_ref)
        if resource_class_name is not None:
            pulumi.set(__self__, "resource_class_name", resource_class_name)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[builtins.str]:
        """
        Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter(name="parametersRef")
    def parameters_ref(self) -> Optional['outputs.ResourceClaimParametersReferencePatch']:
        """
        ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.

        The object must be in the same namespace as the ResourceClaim.
        """
        return pulumi.get(self, "parameters_ref")

    @property
    @pulumi.getter(name="resourceClassName")
    def resource_class_name(self) -> Optional[builtins.str]:
        """
        ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        return pulumi.get(self, "resource_class_name")


@pulumi.output_type
class ResourceClaimStatus(dict):
    """
    ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deallocationRequested":
            suggest = "deallocation_requested"
        elif key == "driverName":
            suggest = "driver_name"
        elif key == "reservedFor":
            suggest = "reserved_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation: Optional['outputs.AllocationResult'] = None,
                 deallocation_requested: Optional[builtins.bool] = None,
                 driver_name: Optional[builtins.str] = None,
                 reserved_for: Optional[Sequence['outputs.ResourceClaimConsumerReference']] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
        :param 'AllocationResultArgs' allocation: Allocation is set by the resource driver once a resource or set of resources has been allocated successfully. If this is not specified, the resources have not been allocated yet.
        :param builtins.bool deallocation_requested: DeallocationRequested indicates that a ResourceClaim is to be deallocated.
               
               The driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        :param builtins.str driver_name: DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        :param Sequence['ResourceClaimConsumerReferenceArgs'] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.
               
               There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional['outputs.AllocationResult']:
        """
        Allocation is set by the resource driver once a resource or set of resources has been allocated successfully. If this is not specified, the resources have not been allocated yet.
        """
        return pulumi.get(self, "allocation")

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[builtins.bool]:
        """
        DeallocationRequested indicates that a ResourceClaim is to be deallocated.

        The driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        """
        return pulumi.get(self, "deallocation_requested")

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[Sequence['outputs.ResourceClaimConsumerReference']]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")


@pulumi.output_type
class ResourceClaimStatusPatch(dict):
    """
    ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deallocationRequested":
            suggest = "deallocation_requested"
        elif key == "driverName":
            suggest = "driver_name"
        elif key == "reservedFor":
            suggest = "reserved_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation: Optional['outputs.AllocationResultPatch'] = None,
                 deallocation_requested: Optional[builtins.bool] = None,
                 driver_name: Optional[builtins.str] = None,
                 reserved_for: Optional[Sequence['outputs.ResourceClaimConsumerReferencePatch']] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
        :param 'AllocationResultPatchArgs' allocation: Allocation is set by the resource driver once a resource or set of resources has been allocated successfully. If this is not specified, the resources have not been allocated yet.
        :param builtins.bool deallocation_requested: DeallocationRequested indicates that a ResourceClaim is to be deallocated.
               
               The driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        :param builtins.str driver_name: DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        :param Sequence['ResourceClaimConsumerReferencePatchArgs'] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.
               
               There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional['outputs.AllocationResultPatch']:
        """
        Allocation is set by the resource driver once a resource or set of resources has been allocated successfully. If this is not specified, the resources have not been allocated yet.
        """
        return pulumi.get(self, "allocation")

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[builtins.bool]:
        """
        DeallocationRequested indicates that a ResourceClaim is to be deallocated.

        The driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        """
        return pulumi.get(self, "deallocation_requested")

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[Sequence['outputs.ResourceClaimConsumerReferencePatch']]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")


@pulumi.output_type
class ResourceClaimTemplate(dict):
    """
    ResourceClaimTemplate is used to produce ResourceClaim objects.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimTemplateSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.
        :param 'ResourceClaimTemplateSpecArgs' spec: Describes the ResourceClaim that is to be generated.
               
               This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha2')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaimTemplate')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimTemplateSpec':
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ResourceClaimTemplateSpec(dict):
    """
    ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
    """
    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimSpec',
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param 'ResourceClaimSpecArgs' spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        :param '_meta.v1.ObjectMetaArgs' metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimSpec':
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ResourceClaimTemplateSpecPatch(dict):
    """
    ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
    """
    def __init__(__self__, *,
                 metadata: Optional['_meta.v1.outputs.ObjectMetaPatch'] = None,
                 spec: Optional['outputs.ResourceClaimSpecPatch'] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param '_meta.v1.ObjectMetaPatchArgs' metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        :param 'ResourceClaimSpecPatchArgs' spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMetaPatch']:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ResourceClaimSpecPatch']:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class ResourceClass(dict):
    """
    ResourceClass is used by administrators to influence how resources are allocated.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "apiVersion":
            suggest = "api_version"
        elif key == "parametersRef":
            suggest = "parameters_ref"
        elif key == "structuredParameters":
            suggest = "structured_parameters"
        elif key == "suitableNodes":
            suggest = "suitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClass. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClass.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClass.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: builtins.str,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 parameters_ref: Optional['outputs.ResourceClassParametersReference'] = None,
                 structured_parameters: Optional[builtins.bool] = None,
                 suitable_nodes: Optional['_core.v1.outputs.NodeSelector'] = None):
        """
        ResourceClass is used by administrators to influence how resources are allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param builtins.str driver_name: DriverName defines the name of the dynamic resource driver that is used for allocation of a ResourceClaim that uses this class.
               
               Resource drivers have a unique name in forward domain order (acme.example.com).
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'ResourceClassParametersReferenceArgs' parameters_ref: ParametersRef references an arbitrary separate object that may hold parameters that will be used by the driver when allocating a resource that uses this class. A dynamic resource driver can distinguish between parameters stored here and and those stored in ResourceClaimSpec.
        :param builtins.bool structured_parameters: If and only if allocation of claims using this class is handled via structured parameters, then StructuredParameters must be set to true.
        :param '_core.v1.NodeSelectorArgs' suitable_nodes: Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a ResourceClaim that has not been allocated yet.
               
               Setting this field is optional. If null, all nodes are candidates.
        """
        pulumi.set(__self__, "driver_name", driver_name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha2')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if parameters_ref is not None:
            pulumi.set(__self__, "parameters_ref", parameters_ref)
        if structured_parameters is not None:
            pulumi.set(__self__, "structured_parameters", structured_parameters)
        if suitable_nodes is not None:
            pulumi.set(__self__, "suitable_nodes", suitable_nodes)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> builtins.str:
        """
        DriverName defines the name of the dynamic resource driver that is used for allocation of a ResourceClaim that uses this class.

        Resource drivers have a unique name in forward domain order (acme.example.com).
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="parametersRef")
    def parameters_ref(self) -> Optional['outputs.ResourceClassParametersReference']:
        """
        ParametersRef references an arbitrary separate object that may hold parameters that will be used by the driver when allocating a resource that uses this class. A dynamic resource driver can distinguish between parameters stored here and and those stored in ResourceClaimSpec.
        """
        return pulumi.get(self, "parameters_ref")

    @property
    @pulumi.getter(name="structuredParameters")
    def structured_parameters(self) -> Optional[builtins.bool]:
        """
        If and only if allocation of claims using this class is handled via structured parameters, then StructuredParameters must be set to true.
        """
        return pulumi.get(self, "structured_parameters")

    @property
    @pulumi.getter(name="suitableNodes")
    def suitable_nodes(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a ResourceClaim that has not been allocated yet.

        Setting this field is optional. If null, all nodes are candidates.
        """
        return pulumi.get(self, "suitable_nodes")


@pulumi.output_type
class ResourceClassParameters(dict):
    """
    ResourceClassParameters defines resource requests for a ResourceClass in an in-tree format understood by Kubernetes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "generatedFrom":
            suggest = "generated_from"
        elif key == "vendorParameters":
            suggest = "vendor_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClassParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClassParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClassParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[builtins.str] = None,
                 filters: Optional[Sequence['outputs.ResourceFilter']] = None,
                 generated_from: Optional['outputs.ResourceClassParametersReference'] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 vendor_parameters: Optional[Sequence['outputs.VendorParameters']] = None):
        """
        ResourceClassParameters defines resource requests for a ResourceClass in an in-tree format understood by Kubernetes.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param Sequence['ResourceFilterArgs'] filters: Filters describes additional contraints that must be met when using the class.
        :param 'ResourceClassParametersReferenceArgs' generated_from: If this object was created from some other resource, then this links back to that resource. This field is used to find the in-tree representation of the class parameters when the parameter reference of the class refers to some unknown type.
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param Sequence['VendorParametersArgs'] vendor_parameters: VendorParameters are arbitrary setup parameters for all claims using this class. They are ignored while allocating the claim. There must not be more than one entry per driver.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha2')
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if generated_from is not None:
            pulumi.set(__self__, "generated_from", generated_from)
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClassParameters')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if vendor_parameters is not None:
            pulumi.set(__self__, "vendor_parameters", vendor_parameters)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.ResourceFilter']]:
        """
        Filters describes additional contraints that must be met when using the class.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="generatedFrom")
    def generated_from(self) -> Optional['outputs.ResourceClassParametersReference']:
        """
        If this object was created from some other resource, then this links back to that resource. This field is used to find the in-tree representation of the class parameters when the parameter reference of the class refers to some unknown type.
        """
        return pulumi.get(self, "generated_from")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="vendorParameters")
    def vendor_parameters(self) -> Optional[Sequence['outputs.VendorParameters']]:
        """
        VendorParameters are arbitrary setup parameters for all claims using this class. They are ignored while allocating the claim. There must not be more than one entry per driver.
        """
        return pulumi.get(self, "vendor_parameters")


@pulumi.output_type
class ResourceClassParametersReference(dict):
    """
    ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClassParametersReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClassParametersReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClassParametersReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: builtins.str,
                 name: builtins.str,
                 api_group: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None):
        """
        ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
        :param builtins.str kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        :param builtins.str name: Name is the name of resource being referenced.
        :param builtins.str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param builtins.str namespace: Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ResourceClassParametersReferencePatch(dict):
    """
    ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClassParametersReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClassParametersReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClassParametersReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_group: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None):
        """
        ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
        :param builtins.str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param builtins.str kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        :param builtins.str name: Name is the name of resource being referenced.
        :param builtins.str namespace: Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ResourceFilter(dict):
    """
    ResourceFilter is a filter for resources from one particular driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "namedResources":
            suggest = "named_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[builtins.str] = None,
                 named_resources: Optional['outputs.NamedResourcesFilter'] = None):
        """
        ResourceFilter is a filter for resources from one particular driver.
        :param builtins.str driver_name: DriverName is the name used by the DRA driver kubelet plugin.
        :param 'NamedResourcesFilterArgs' named_resources: NamedResources describes a resource filter using the named resources model.
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if named_resources is not None:
            pulumi.set(__self__, "named_resources", named_resources)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName is the name used by the DRA driver kubelet plugin.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="namedResources")
    def named_resources(self) -> Optional['outputs.NamedResourcesFilter']:
        """
        NamedResources describes a resource filter using the named resources model.
        """
        return pulumi.get(self, "named_resources")


@pulumi.output_type
class ResourceFilterPatch(dict):
    """
    ResourceFilter is a filter for resources from one particular driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "namedResources":
            suggest = "named_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceFilterPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceFilterPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceFilterPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[builtins.str] = None,
                 named_resources: Optional['outputs.NamedResourcesFilterPatch'] = None):
        """
        ResourceFilter is a filter for resources from one particular driver.
        :param builtins.str driver_name: DriverName is the name used by the DRA driver kubelet plugin.
        :param 'NamedResourcesFilterPatchArgs' named_resources: NamedResources describes a resource filter using the named resources model.
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if named_resources is not None:
            pulumi.set(__self__, "named_resources", named_resources)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName is the name used by the DRA driver kubelet plugin.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="namedResources")
    def named_resources(self) -> Optional['outputs.NamedResourcesFilterPatch']:
        """
        NamedResources describes a resource filter using the named resources model.
        """
        return pulumi.get(self, "named_resources")


@pulumi.output_type
class ResourceHandle(dict):
    """
    ResourceHandle holds opaque resource data for processing by a specific kubelet plugin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "structuredData":
            suggest = "structured_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceHandle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceHandle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceHandle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[builtins.str] = None,
                 driver_name: Optional[builtins.str] = None,
                 structured_data: Optional['outputs.StructuredResourceHandle'] = None):
        """
        ResourceHandle holds opaque resource data for processing by a specific kubelet plugin.
        :param builtins.str data: Data contains the opaque data associated with this ResourceHandle. It is set by the controller component of the resource driver whose name matches the DriverName set in the ResourceClaimStatus this ResourceHandle is embedded in. It is set at allocation time and is intended for processing by the kubelet plugin whose name matches the DriverName set in this ResourceHandle.
               
               The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        :param builtins.str driver_name: DriverName specifies the name of the resource driver whose kubelet plugin should be invoked to process this ResourceHandle's data once it lands on a node. This may differ from the DriverName set in ResourceClaimStatus this ResourceHandle is embedded in.
        :param 'StructuredResourceHandleArgs' structured_data: If StructuredData is set, then it needs to be used instead of Data.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if structured_data is not None:
            pulumi.set(__self__, "structured_data", structured_data)

    @property
    @pulumi.getter
    def data(self) -> Optional[builtins.str]:
        """
        Data contains the opaque data associated with this ResourceHandle. It is set by the controller component of the resource driver whose name matches the DriverName set in the ResourceClaimStatus this ResourceHandle is embedded in. It is set at allocation time and is intended for processing by the kubelet plugin whose name matches the DriverName set in this ResourceHandle.

        The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName specifies the name of the resource driver whose kubelet plugin should be invoked to process this ResourceHandle's data once it lands on a node. This may differ from the DriverName set in ResourceClaimStatus this ResourceHandle is embedded in.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="structuredData")
    def structured_data(self) -> Optional['outputs.StructuredResourceHandle']:
        """
        If StructuredData is set, then it needs to be used instead of Data.
        """
        return pulumi.get(self, "structured_data")


@pulumi.output_type
class ResourceHandlePatch(dict):
    """
    ResourceHandle holds opaque resource data for processing by a specific kubelet plugin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "structuredData":
            suggest = "structured_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceHandlePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceHandlePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceHandlePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[builtins.str] = None,
                 driver_name: Optional[builtins.str] = None,
                 structured_data: Optional['outputs.StructuredResourceHandlePatch'] = None):
        """
        ResourceHandle holds opaque resource data for processing by a specific kubelet plugin.
        :param builtins.str data: Data contains the opaque data associated with this ResourceHandle. It is set by the controller component of the resource driver whose name matches the DriverName set in the ResourceClaimStatus this ResourceHandle is embedded in. It is set at allocation time and is intended for processing by the kubelet plugin whose name matches the DriverName set in this ResourceHandle.
               
               The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        :param builtins.str driver_name: DriverName specifies the name of the resource driver whose kubelet plugin should be invoked to process this ResourceHandle's data once it lands on a node. This may differ from the DriverName set in ResourceClaimStatus this ResourceHandle is embedded in.
        :param 'StructuredResourceHandlePatchArgs' structured_data: If StructuredData is set, then it needs to be used instead of Data.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if structured_data is not None:
            pulumi.set(__self__, "structured_data", structured_data)

    @property
    @pulumi.getter
    def data(self) -> Optional[builtins.str]:
        """
        Data contains the opaque data associated with this ResourceHandle. It is set by the controller component of the resource driver whose name matches the DriverName set in the ResourceClaimStatus this ResourceHandle is embedded in. It is set at allocation time and is intended for processing by the kubelet plugin whose name matches the DriverName set in this ResourceHandle.

        The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName specifies the name of the resource driver whose kubelet plugin should be invoked to process this ResourceHandle's data once it lands on a node. This may differ from the DriverName set in ResourceClaimStatus this ResourceHandle is embedded in.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="structuredData")
    def structured_data(self) -> Optional['outputs.StructuredResourceHandlePatch']:
        """
        If StructuredData is set, then it needs to be used instead of Data.
        """
        return pulumi.get(self, "structured_data")


@pulumi.output_type
class ResourceRequest(dict):
    """
    ResourceRequest is a request for resources from one particular driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namedResources":
            suggest = "named_resources"
        elif key == "vendorParameters":
            suggest = "vendor_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 named_resources: Optional['outputs.NamedResourcesRequest'] = None,
                 vendor_parameters: Optional[Any] = None):
        """
        ResourceRequest is a request for resources from one particular driver.
        :param 'NamedResourcesRequestArgs' named_resources: NamedResources describes a request for resources with the named resources model.
        :param Any vendor_parameters: VendorParameters are arbitrary setup parameters for the requested resource. They are ignored while allocating a claim.
        """
        if named_resources is not None:
            pulumi.set(__self__, "named_resources", named_resources)
        if vendor_parameters is not None:
            pulumi.set(__self__, "vendor_parameters", vendor_parameters)

    @property
    @pulumi.getter(name="namedResources")
    def named_resources(self) -> Optional['outputs.NamedResourcesRequest']:
        """
        NamedResources describes a request for resources with the named resources model.
        """
        return pulumi.get(self, "named_resources")

    @property
    @pulumi.getter(name="vendorParameters")
    def vendor_parameters(self) -> Optional[Any]:
        """
        VendorParameters are arbitrary setup parameters for the requested resource. They are ignored while allocating a claim.
        """
        return pulumi.get(self, "vendor_parameters")


@pulumi.output_type
class ResourceRequestPatch(dict):
    """
    ResourceRequest is a request for resources from one particular driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namedResources":
            suggest = "named_resources"
        elif key == "vendorParameters":
            suggest = "vendor_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceRequestPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceRequestPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceRequestPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 named_resources: Optional['outputs.NamedResourcesRequestPatch'] = None,
                 vendor_parameters: Optional[Any] = None):
        """
        ResourceRequest is a request for resources from one particular driver.
        :param 'NamedResourcesRequestPatchArgs' named_resources: NamedResources describes a request for resources with the named resources model.
        :param Any vendor_parameters: VendorParameters are arbitrary setup parameters for the requested resource. They are ignored while allocating a claim.
        """
        if named_resources is not None:
            pulumi.set(__self__, "named_resources", named_resources)
        if vendor_parameters is not None:
            pulumi.set(__self__, "vendor_parameters", vendor_parameters)

    @property
    @pulumi.getter(name="namedResources")
    def named_resources(self) -> Optional['outputs.NamedResourcesRequestPatch']:
        """
        NamedResources describes a request for resources with the named resources model.
        """
        return pulumi.get(self, "named_resources")

    @property
    @pulumi.getter(name="vendorParameters")
    def vendor_parameters(self) -> Optional[Any]:
        """
        VendorParameters are arbitrary setup parameters for the requested resource. They are ignored while allocating a claim.
        """
        return pulumi.get(self, "vendor_parameters")


@pulumi.output_type
class ResourceSlice(dict):
    """
    ResourceSlice provides information about available resources on individual nodes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "apiVersion":
            suggest = "api_version"
        elif key == "namedResources":
            suggest = "named_resources"
        elif key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSlice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSlice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSlice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: builtins.str,
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 named_resources: Optional['outputs.NamedResourcesResources'] = None,
                 node_name: Optional[builtins.str] = None):
        """
        ResourceSlice provides information about available resources on individual nodes.
        :param builtins.str driver_name: DriverName identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'NamedResourcesResourcesArgs' named_resources: NamedResources describes available resources using the named resources model.
        :param builtins.str node_name: NodeName identifies the node which provides the resources if they are local to a node.
               
               A field selector can be used to list only ResourceSlice objects with a certain node name.
        """
        pulumi.set(__self__, "driver_name", driver_name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha2')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceSlice')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if named_resources is not None:
            pulumi.set(__self__, "named_resources", named_resources)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> builtins.str:
        """
        DriverName identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="namedResources")
    def named_resources(self) -> Optional['outputs.NamedResourcesResources']:
        """
        NamedResources describes available resources using the named resources model.
        """
        return pulumi.get(self, "named_resources")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[builtins.str]:
        """
        NodeName identifies the node which provides the resources if they are local to a node.

        A field selector can be used to list only ResourceSlice objects with a certain node name.
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class StructuredResourceHandle(dict):
    """
    StructuredResourceHandle is the in-tree representation of the allocation result.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"
        elif key == "vendorClaimParameters":
            suggest = "vendor_claim_parameters"
        elif key == "vendorClassParameters":
            suggest = "vendor_class_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StructuredResourceHandle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StructuredResourceHandle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StructuredResourceHandle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 results: Sequence['outputs.DriverAllocationResult'],
                 node_name: Optional[builtins.str] = None,
                 vendor_claim_parameters: Optional[Any] = None,
                 vendor_class_parameters: Optional[Any] = None):
        """
        StructuredResourceHandle is the in-tree representation of the allocation result.
        :param Sequence['DriverAllocationResultArgs'] results: Results lists all allocated driver resources.
        :param builtins.str node_name: NodeName is the name of the node providing the necessary resources if the resources are local to a node.
        :param Any vendor_claim_parameters: VendorClaimParameters are the per-claim configuration parameters from the resource claim parameters at the time that the claim was allocated.
        :param Any vendor_class_parameters: VendorClassParameters are the per-claim configuration parameters from the resource class at the time that the claim was allocated.
        """
        pulumi.set(__self__, "results", results)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if vendor_claim_parameters is not None:
            pulumi.set(__self__, "vendor_claim_parameters", vendor_claim_parameters)
        if vendor_class_parameters is not None:
            pulumi.set(__self__, "vendor_class_parameters", vendor_class_parameters)

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.DriverAllocationResult']:
        """
        Results lists all allocated driver resources.
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[builtins.str]:
        """
        NodeName is the name of the node providing the necessary resources if the resources are local to a node.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="vendorClaimParameters")
    def vendor_claim_parameters(self) -> Optional[Any]:
        """
        VendorClaimParameters are the per-claim configuration parameters from the resource claim parameters at the time that the claim was allocated.
        """
        return pulumi.get(self, "vendor_claim_parameters")

    @property
    @pulumi.getter(name="vendorClassParameters")
    def vendor_class_parameters(self) -> Optional[Any]:
        """
        VendorClassParameters are the per-claim configuration parameters from the resource class at the time that the claim was allocated.
        """
        return pulumi.get(self, "vendor_class_parameters")


@pulumi.output_type
class StructuredResourceHandlePatch(dict):
    """
    StructuredResourceHandle is the in-tree representation of the allocation result.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"
        elif key == "vendorClaimParameters":
            suggest = "vendor_claim_parameters"
        elif key == "vendorClassParameters":
            suggest = "vendor_class_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StructuredResourceHandlePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StructuredResourceHandlePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StructuredResourceHandlePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_name: Optional[builtins.str] = None,
                 results: Optional[Sequence['outputs.DriverAllocationResultPatch']] = None,
                 vendor_claim_parameters: Optional[Any] = None,
                 vendor_class_parameters: Optional[Any] = None):
        """
        StructuredResourceHandle is the in-tree representation of the allocation result.
        :param builtins.str node_name: NodeName is the name of the node providing the necessary resources if the resources are local to a node.
        :param Sequence['DriverAllocationResultPatchArgs'] results: Results lists all allocated driver resources.
        :param Any vendor_claim_parameters: VendorClaimParameters are the per-claim configuration parameters from the resource claim parameters at the time that the claim was allocated.
        :param Any vendor_class_parameters: VendorClassParameters are the per-claim configuration parameters from the resource class at the time that the claim was allocated.
        """
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if results is not None:
            pulumi.set(__self__, "results", results)
        if vendor_claim_parameters is not None:
            pulumi.set(__self__, "vendor_claim_parameters", vendor_claim_parameters)
        if vendor_class_parameters is not None:
            pulumi.set(__self__, "vendor_class_parameters", vendor_class_parameters)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[builtins.str]:
        """
        NodeName is the name of the node providing the necessary resources if the resources are local to a node.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter
    def results(self) -> Optional[Sequence['outputs.DriverAllocationResultPatch']]:
        """
        Results lists all allocated driver resources.
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="vendorClaimParameters")
    def vendor_claim_parameters(self) -> Optional[Any]:
        """
        VendorClaimParameters are the per-claim configuration parameters from the resource claim parameters at the time that the claim was allocated.
        """
        return pulumi.get(self, "vendor_claim_parameters")

    @property
    @pulumi.getter(name="vendorClassParameters")
    def vendor_class_parameters(self) -> Optional[Any]:
        """
        VendorClassParameters are the per-claim configuration parameters from the resource class at the time that the claim was allocated.
        """
        return pulumi.get(self, "vendor_class_parameters")


@pulumi.output_type
class VendorParameters(dict):
    """
    VendorParameters are opaque parameters for one particular driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VendorParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VendorParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VendorParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[builtins.str] = None,
                 parameters: Optional[Any] = None):
        """
        VendorParameters are opaque parameters for one particular driver.
        :param builtins.str driver_name: DriverName is the name used by the DRA driver kubelet plugin.
        :param Any parameters: Parameters can be arbitrary setup parameters. They are ignored while allocating a claim.
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName is the name used by the DRA driver kubelet plugin.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Parameters can be arbitrary setup parameters. They are ignored while allocating a claim.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class VendorParametersPatch(dict):
    """
    VendorParameters are opaque parameters for one particular driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VendorParametersPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VendorParametersPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VendorParametersPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[builtins.str] = None,
                 parameters: Optional[Any] = None):
        """
        VendorParameters are opaque parameters for one particular driver.
        :param builtins.str driver_name: DriverName is the name used by the DRA driver kubelet plugin.
        :param Any parameters: Parameters can be arbitrary setup parameters. They are ignored while allocating a claim.
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[builtins.str]:
        """
        DriverName is the name used by the DRA driver kubelet plugin.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Parameters can be arbitrary setup parameters. They are ignored while allocating a claim.
        """
        return pulumi.get(self, "parameters")


