# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'AllocatedDeviceStatus',
    'AllocatedDeviceStatusPatch',
    'AllocationResult',
    'AllocationResultPatch',
    'BasicDevice',
    'BasicDevicePatch',
    'CELDeviceSelector',
    'CELDeviceSelectorPatch',
    'Counter',
    'CounterSet',
    'CounterSetPatch',
    'Device',
    'DeviceAllocationConfiguration',
    'DeviceAllocationConfigurationPatch',
    'DeviceAllocationResult',
    'DeviceAllocationResultPatch',
    'DeviceAttribute',
    'DeviceClaim',
    'DeviceClaimConfiguration',
    'DeviceClaimConfigurationPatch',
    'DeviceClaimPatch',
    'DeviceClass',
    'DeviceClassConfiguration',
    'DeviceClassConfigurationPatch',
    'DeviceClassSpec',
    'DeviceClassSpecPatch',
    'DeviceConstraint',
    'DeviceConstraintPatch',
    'DeviceCounterConsumption',
    'DeviceCounterConsumptionPatch',
    'DevicePatch',
    'DeviceRequest',
    'DeviceRequestAllocationResult',
    'DeviceRequestAllocationResultPatch',
    'DeviceRequestPatch',
    'DeviceSelector',
    'DeviceSelectorPatch',
    'DeviceSubRequest',
    'DeviceSubRequestPatch',
    'DeviceTaint',
    'DeviceTaintPatch',
    'DeviceTaintRule',
    'DeviceTaintRuleSpec',
    'DeviceTaintRuleSpecPatch',
    'DeviceTaintSelector',
    'DeviceTaintSelectorPatch',
    'DeviceToleration',
    'DeviceTolerationPatch',
    'NetworkDeviceData',
    'NetworkDeviceDataPatch',
    'OpaqueDeviceConfiguration',
    'OpaqueDeviceConfigurationPatch',
    'PodSchedulingContext',
    'PodSchedulingContextSpec',
    'PodSchedulingContextSpecPatch',
    'PodSchedulingContextStatus',
    'PodSchedulingContextStatusPatch',
    'ResourceClaim',
    'ResourceClaimConsumerReference',
    'ResourceClaimConsumerReferencePatch',
    'ResourceClaimSchedulingStatus',
    'ResourceClaimSchedulingStatusPatch',
    'ResourceClaimSpec',
    'ResourceClaimSpecPatch',
    'ResourceClaimStatus',
    'ResourceClaimStatusPatch',
    'ResourceClaimTemplate',
    'ResourceClaimTemplateSpec',
    'ResourceClaimTemplateSpecPatch',
    'ResourcePool',
    'ResourcePoolPatch',
    'ResourceSlice',
    'ResourceSliceSpec',
    'ResourceSliceSpecPatch',
]

@pulumi.output_type
class AllocatedDeviceStatus(dict):
    """
    AllocatedDeviceStatus contains the status of an allocated device, if the driver chooses to report it. This may include driver-specific information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkData":
            suggest = "network_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocatedDeviceStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocatedDeviceStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocatedDeviceStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device: builtins.str,
                 driver: builtins.str,
                 pool: builtins.str,
                 conditions: Optional[Sequence['_meta.v1.outputs.Condition']] = None,
                 data: Optional[Any] = None,
                 network_data: Optional['outputs.NetworkDeviceData'] = None):
        """
        AllocatedDeviceStatus contains the status of an allocated device, if the driver chooses to report it. This may include driver-specific information.
        :param builtins.str device: Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        :param builtins.str driver: Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param builtins.str pool: This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).
               
               Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        :param Sequence['_meta.v1.ConditionArgs'] conditions: Conditions contains the latest observation of the device's state. If the device has been configured according to the class and claim config references, the `Ready` condition should be True.
               
               Must not contain more than 8 entries.
        :param Any data: Data contains arbitrary driver-specific data.
               
               The length of the raw data must be smaller or equal to 10 Ki.
        :param 'NetworkDeviceDataArgs' network_data: NetworkData contains network-related information specific to the device.
        """
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if network_data is not None:
            pulumi.set(__self__, "network_data", network_data)

    @property
    @pulumi.getter
    def device(self) -> builtins.str:
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def driver(self) -> builtins.str:
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def pool(self) -> builtins.str:
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.Condition']]:
        """
        Conditions contains the latest observation of the device's state. If the device has been configured according to the class and claim config references, the `Ready` condition should be True.

        Must not contain more than 8 entries.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def data(self) -> Optional[Any]:
        """
        Data contains arbitrary driver-specific data.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="networkData")
    def network_data(self) -> Optional['outputs.NetworkDeviceData']:
        """
        NetworkData contains network-related information specific to the device.
        """
        return pulumi.get(self, "network_data")


@pulumi.output_type
class AllocatedDeviceStatusPatch(dict):
    """
    AllocatedDeviceStatus contains the status of an allocated device, if the driver chooses to report it. This may include driver-specific information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkData":
            suggest = "network_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocatedDeviceStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocatedDeviceStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocatedDeviceStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.ConditionPatch']] = None,
                 data: Optional[Any] = None,
                 device: Optional[builtins.str] = None,
                 driver: Optional[builtins.str] = None,
                 network_data: Optional['outputs.NetworkDeviceDataPatch'] = None,
                 pool: Optional[builtins.str] = None):
        """
        AllocatedDeviceStatus contains the status of an allocated device, if the driver chooses to report it. This may include driver-specific information.
        :param Sequence['_meta.v1.ConditionPatchArgs'] conditions: Conditions contains the latest observation of the device's state. If the device has been configured according to the class and claim config references, the `Ready` condition should be True.
               
               Must not contain more than 8 entries.
        :param Any data: Data contains arbitrary driver-specific data.
               
               The length of the raw data must be smaller or equal to 10 Ki.
        :param builtins.str device: Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        :param builtins.str driver: Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param 'NetworkDeviceDataPatchArgs' network_data: NetworkData contains network-related information specific to the device.
        :param builtins.str pool: This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).
               
               Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if network_data is not None:
            pulumi.set(__self__, "network_data", network_data)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.ConditionPatch']]:
        """
        Conditions contains the latest observation of the device's state. If the device has been configured according to the class and claim config references, the `Ready` condition should be True.

        Must not contain more than 8 entries.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def data(self) -> Optional[Any]:
        """
        Data contains arbitrary driver-specific data.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def device(self) -> Optional[builtins.str]:
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def driver(self) -> Optional[builtins.str]:
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter(name="networkData")
    def network_data(self) -> Optional['outputs.NetworkDeviceDataPatch']:
        """
        NetworkData contains network-related information specific to the device.
        """
        return pulumi.get(self, "network_data")

    @property
    @pulumi.getter
    def pool(self) -> Optional[builtins.str]:
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        return pulumi.get(self, "pool")


@pulumi.output_type
class AllocationResult(dict):
    """
    AllocationResult contains attributes of an allocated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 controller: Optional[builtins.str] = None,
                 devices: Optional['outputs.DeviceAllocationResult'] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelector'] = None):
        """
        AllocationResult contains attributes of an allocated resource.
        :param builtins.str controller: Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.
               
               A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param 'DeviceAllocationResultArgs' devices: Devices is the result of allocating devices.
        :param '_core.v1.NodeSelectorArgs' node_selector: NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)

    @property
    @pulumi.getter
    def controller(self) -> Optional[builtins.str]:
        """
        Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.

        A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def devices(self) -> Optional['outputs.DeviceAllocationResult']:
        """
        Devices is the result of allocating devices.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        return pulumi.get(self, "node_selector")


@pulumi.output_type
class AllocationResultPatch(dict):
    """
    AllocationResult contains attributes of an allocated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationResultPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationResultPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationResultPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 controller: Optional[builtins.str] = None,
                 devices: Optional['outputs.DeviceAllocationResultPatch'] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelectorPatch'] = None):
        """
        AllocationResult contains attributes of an allocated resource.
        :param builtins.str controller: Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.
               
               A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param 'DeviceAllocationResultPatchArgs' devices: Devices is the result of allocating devices.
        :param '_core.v1.NodeSelectorPatchArgs' node_selector: NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)

    @property
    @pulumi.getter
    def controller(self) -> Optional[builtins.str]:
        """
        Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.

        A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def devices(self) -> Optional['outputs.DeviceAllocationResultPatch']:
        """
        Devices is the result of allocating devices.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelectorPatch']:
        """
        NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        return pulumi.get(self, "node_selector")


@pulumi.output_type
class BasicDevice(dict):
    """
    BasicDevice defines one device instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNodes":
            suggest = "all_nodes"
        elif key == "consumesCounters":
            suggest = "consumes_counters"
        elif key == "nodeName":
            suggest = "node_name"
        elif key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BasicDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BasicDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BasicDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_nodes: Optional[builtins.bool] = None,
                 attributes: Optional[Mapping[str, 'outputs.DeviceAttribute']] = None,
                 capacity: Optional[Mapping[str, builtins.str]] = None,
                 consumes_counters: Optional[Sequence['outputs.DeviceCounterConsumption']] = None,
                 node_name: Optional[builtins.str] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelector'] = None,
                 taints: Optional[Sequence['outputs.DeviceTaint']] = None):
        """
        BasicDevice defines one device instance.
        :param builtins.bool all_nodes: AllNodes indicates that all nodes have access to the device.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param Mapping[str, 'DeviceAttributeArgs'] attributes: Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param Mapping[str, builtins.str] capacity: Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param Sequence['DeviceCounterConsumptionArgs'] consumes_counters: ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.
               
               There can only be a single entry per counterSet.
               
               The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        :param builtins.str node_name: NodeName identifies the node where the device is available.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param '_core.v1.NodeSelectorArgs' node_selector: NodeSelector defines the nodes where the device is available.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param Sequence['DeviceTaintArgs'] taints: If specified, these are the driver-defined taints.
               
               The maximum number of taints is 4.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if consumes_counters is not None:
            pulumi.set(__self__, "consumes_counters", consumes_counters)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[builtins.bool]:
        """
        AllNodes indicates that all nodes have access to the device.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "all_nodes")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, 'outputs.DeviceAttribute']]:
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="consumesCounters")
    def consumes_counters(self) -> Optional[Sequence['outputs.DeviceCounterConsumption']]:
        """
        ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.

        There can only be a single entry per counterSet.

        The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        """
        return pulumi.get(self, "consumes_counters")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[builtins.str]:
        """
        NodeName identifies the node where the device is available.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        NodeSelector defines the nodes where the device is available.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.DeviceTaint']]:
        """
        If specified, these are the driver-defined taints.

        The maximum number of taints is 4.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class BasicDevicePatch(dict):
    """
    BasicDevice defines one device instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNodes":
            suggest = "all_nodes"
        elif key == "consumesCounters":
            suggest = "consumes_counters"
        elif key == "nodeName":
            suggest = "node_name"
        elif key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BasicDevicePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BasicDevicePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BasicDevicePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_nodes: Optional[builtins.bool] = None,
                 attributes: Optional[Mapping[str, 'outputs.DeviceAttribute']] = None,
                 capacity: Optional[Mapping[str, builtins.str]] = None,
                 consumes_counters: Optional[Sequence['outputs.DeviceCounterConsumptionPatch']] = None,
                 node_name: Optional[builtins.str] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelectorPatch'] = None,
                 taints: Optional[Sequence['outputs.DeviceTaintPatch']] = None):
        """
        BasicDevice defines one device instance.
        :param builtins.bool all_nodes: AllNodes indicates that all nodes have access to the device.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param Mapping[str, 'DeviceAttributeArgs'] attributes: Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param Mapping[str, builtins.str] capacity: Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param Sequence['DeviceCounterConsumptionPatchArgs'] consumes_counters: ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.
               
               There can only be a single entry per counterSet.
               
               The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        :param builtins.str node_name: NodeName identifies the node where the device is available.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param '_core.v1.NodeSelectorPatchArgs' node_selector: NodeSelector defines the nodes where the device is available.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param Sequence['DeviceTaintPatchArgs'] taints: If specified, these are the driver-defined taints.
               
               The maximum number of taints is 4.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if consumes_counters is not None:
            pulumi.set(__self__, "consumes_counters", consumes_counters)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[builtins.bool]:
        """
        AllNodes indicates that all nodes have access to the device.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "all_nodes")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, 'outputs.DeviceAttribute']]:
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="consumesCounters")
    def consumes_counters(self) -> Optional[Sequence['outputs.DeviceCounterConsumptionPatch']]:
        """
        ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.

        There can only be a single entry per counterSet.

        The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        """
        return pulumi.get(self, "consumes_counters")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[builtins.str]:
        """
        NodeName identifies the node where the device is available.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelectorPatch']:
        """
        NodeSelector defines the nodes where the device is available.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.DeviceTaintPatch']]:
        """
        If specified, these are the driver-defined taints.

        The maximum number of taints is 4.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class CELDeviceSelector(dict):
    """
    CELDeviceSelector contains a CEL expression for selecting a device.
    """
    def __init__(__self__, *,
                 expression: builtins.str):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        :param builtins.str expression: Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.
               
               The expression's input is an object named "device", which carries the following properties:
                - driver (string): the name of the driver which defines this device.
                - attributes (map[string]object): the device's attributes, grouped by prefix
                  (e.g. device.attributes["dra.example.com"] evaluates to an object with all
                  of the attributes which were prefixed by "dra.example.com".
                - capacity (map[string]object): the device's capacities, grouped by prefix.
               
               Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:
               
                   device.driver
                   device.attributes["dra.example.com"].model
                   device.attributes["ext.example.com"].family
                   device.capacity["dra.example.com"].modules
               
               The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.
               
               The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.
               
               If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.
               
               A robust expression should check for the existence of attributes before referencing them.
               
               For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:
               
                   cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
               
               The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)

        The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class CELDeviceSelectorPatch(dict):
    """
    CELDeviceSelector contains a CEL expression for selecting a device.
    """
    def __init__(__self__, *,
                 expression: Optional[builtins.str] = None):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        :param builtins.str expression: Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.
               
               The expression's input is an object named "device", which carries the following properties:
                - driver (string): the name of the driver which defines this device.
                - attributes (map[string]object): the device's attributes, grouped by prefix
                  (e.g. device.attributes["dra.example.com"] evaluates to an object with all
                  of the attributes which were prefixed by "dra.example.com".
                - capacity (map[string]object): the device's capacities, grouped by prefix.
               
               Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:
               
                   device.driver
                   device.attributes["dra.example.com"].model
                   device.attributes["ext.example.com"].family
                   device.capacity["dra.example.com"].modules
               
               The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.
               
               The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.
               
               If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.
               
               A robust expression should check for the existence of attributes before referencing them.
               
               For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:
               
                   cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
               
               The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)

        The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class Counter(dict):
    """
    Counter describes a quantity associated with a device.
    """
    def __init__(__self__, *,
                 value: builtins.str):
        """
        Counter describes a quantity associated with a device.
        :param builtins.str value: Value defines how much of a certain device counter is available.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value defines how much of a certain device counter is available.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CounterSet(dict):
    """
    CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.

    The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.
    """
    def __init__(__self__, *,
                 counters: Mapping[str, 'outputs.Counter'],
                 name: builtins.str):
        """
        CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.

        The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.
        :param Mapping[str, 'CounterArgs'] counters: Counters defines the counters that will be consumed by the device. The name of each counter must be unique in that set and must be a DNS label.
               
               To ensure this uniqueness, capacities defined by the vendor must be listed without the driver name as domain prefix in their name. All others must be listed with their domain prefix.
               
               The maximum number of counters is 32.
        :param builtins.str name: CounterSet is the name of the set from which the counters defined will be consumed.
        """
        pulumi.set(__self__, "counters", counters)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def counters(self) -> Mapping[str, 'outputs.Counter']:
        """
        Counters defines the counters that will be consumed by the device. The name of each counter must be unique in that set and must be a DNS label.

        To ensure this uniqueness, capacities defined by the vendor must be listed without the driver name as domain prefix in their name. All others must be listed with their domain prefix.

        The maximum number of counters is 32.
        """
        return pulumi.get(self, "counters")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        CounterSet is the name of the set from which the counters defined will be consumed.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CounterSetPatch(dict):
    """
    CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.

    The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.
    """
    def __init__(__self__, *,
                 counters: Optional[Mapping[str, 'outputs.Counter']] = None,
                 name: Optional[builtins.str] = None):
        """
        CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.

        The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.
        :param Mapping[str, 'CounterArgs'] counters: Counters defines the counters that will be consumed by the device. The name of each counter must be unique in that set and must be a DNS label.
               
               To ensure this uniqueness, capacities defined by the vendor must be listed without the driver name as domain prefix in their name. All others must be listed with their domain prefix.
               
               The maximum number of counters is 32.
        :param builtins.str name: CounterSet is the name of the set from which the counters defined will be consumed.
        """
        if counters is not None:
            pulumi.set(__self__, "counters", counters)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def counters(self) -> Optional[Mapping[str, 'outputs.Counter']]:
        """
        Counters defines the counters that will be consumed by the device. The name of each counter must be unique in that set and must be a DNS label.

        To ensure this uniqueness, capacities defined by the vendor must be listed without the driver name as domain prefix in their name. All others must be listed with their domain prefix.

        The maximum number of counters is 32.
        """
        return pulumi.get(self, "counters")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        CounterSet is the name of the set from which the counters defined will be consumed.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class Device(dict):
    """
    Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 basic: Optional['outputs.BasicDevice'] = None):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        :param builtins.str name: Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        :param 'BasicDeviceArgs' basic: Basic defines one device instance.
        """
        pulumi.set(__self__, "name", name)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.BasicDevice']:
        """
        Basic defines one device instance.
        """
        return pulumi.get(self, "basic")


@pulumi.output_type
class DeviceAllocationConfiguration(dict):
    """
    DeviceAllocationConfiguration gets embedded in an AllocationResult.
    """
    def __init__(__self__, *,
                 source: builtins.str,
                 opaque: Optional['outputs.OpaqueDeviceConfiguration'] = None,
                 requests: Optional[Sequence[builtins.str]] = None):
        """
        DeviceAllocationConfiguration gets embedded in an AllocationResult.
        :param builtins.str source: Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        :param 'OpaqueDeviceConfigurationArgs' opaque: Opaque provides driver-specific configuration parameters.
        :param Sequence[builtins.str] requests: Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        pulumi.set(__self__, "source", source)
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfiguration']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[builtins.str]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceAllocationConfigurationPatch(dict):
    """
    DeviceAllocationConfiguration gets embedded in an AllocationResult.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfigurationPatch'] = None,
                 requests: Optional[Sequence[builtins.str]] = None,
                 source: Optional[builtins.str] = None):
        """
        DeviceAllocationConfiguration gets embedded in an AllocationResult.
        :param 'OpaqueDeviceConfigurationPatchArgs' opaque: Opaque provides driver-specific configuration parameters.
        :param Sequence[builtins.str] requests: Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        :param builtins.str source: Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfigurationPatch']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[builtins.str]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class DeviceAllocationResult(dict):
    """
    DeviceAllocationResult is the result of allocating devices.
    """
    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceAllocationConfiguration']] = None,
                 results: Optional[Sequence['outputs.DeviceRequestAllocationResult']] = None):
        """
        DeviceAllocationResult is the result of allocating devices.
        :param Sequence['DeviceAllocationConfigurationArgs'] config: This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.
               
               This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        :param Sequence['DeviceRequestAllocationResultArgs'] results: Results lists all allocated devices.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if results is not None:
            pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceAllocationConfiguration']]:
        """
        This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

        This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def results(self) -> Optional[Sequence['outputs.DeviceRequestAllocationResult']]:
        """
        Results lists all allocated devices.
        """
        return pulumi.get(self, "results")


@pulumi.output_type
class DeviceAllocationResultPatch(dict):
    """
    DeviceAllocationResult is the result of allocating devices.
    """
    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceAllocationConfigurationPatch']] = None,
                 results: Optional[Sequence['outputs.DeviceRequestAllocationResultPatch']] = None):
        """
        DeviceAllocationResult is the result of allocating devices.
        :param Sequence['DeviceAllocationConfigurationPatchArgs'] config: This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.
               
               This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        :param Sequence['DeviceRequestAllocationResultPatchArgs'] results: Results lists all allocated devices.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if results is not None:
            pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceAllocationConfigurationPatch']]:
        """
        This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

        This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def results(self) -> Optional[Sequence['outputs.DeviceRequestAllocationResultPatch']]:
        """
        Results lists all allocated devices.
        """
        return pulumi.get(self, "results")


@pulumi.output_type
class DeviceAttribute(dict):
    """
    DeviceAttribute must have exactly one field set.
    """
    def __init__(__self__, *,
                 bool: Optional[builtins.bool] = None,
                 int: Optional[builtins.int] = None,
                 string: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        DeviceAttribute must have exactly one field set.
        :param builtins.bool bool: BoolValue is a true/false value.
        :param builtins.int int: IntValue is a number.
        :param builtins.str string: StringValue is a string. Must not be longer than 64 characters.
        :param builtins.str version: VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
        if bool is not None:
            pulumi.set(__self__, "bool", bool)
        if int is not None:
            pulumi.set(__self__, "int", int)
        if string is not None:
            pulumi.set(__self__, "string", string)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bool(self) -> Optional[builtins.bool]:
        """
        BoolValue is a true/false value.
        """
        return pulumi.get(self, "bool")

    @property
    @pulumi.getter
    def int(self) -> Optional[builtins.int]:
        """
        IntValue is a number.
        """
        return pulumi.get(self, "int")

    @property
    @pulumi.getter
    def string(self) -> Optional[builtins.str]:
        """
        StringValue is a string. Must not be longer than 64 characters.
        """
        return pulumi.get(self, "string")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DeviceClaim(dict):
    """
    DeviceClaim defines how to request devices with a ResourceClaim.
    """
    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceClaimConfiguration']] = None,
                 constraints: Optional[Sequence['outputs.DeviceConstraint']] = None,
                 requests: Optional[Sequence['outputs.DeviceRequest']] = None):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        :param Sequence['DeviceClaimConfigurationArgs'] config: This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        :param Sequence['DeviceConstraintArgs'] constraints: These constraints must be satisfied by the set of devices that get allocated for the claim.
        :param Sequence['DeviceRequestArgs'] requests: Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceClaimConfiguration']]:
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def constraints(self) -> Optional[Sequence['outputs.DeviceConstraint']]:
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence['outputs.DeviceRequest']]:
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceClaimConfiguration(dict):
    """
    DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfiguration'] = None,
                 requests: Optional[Sequence[builtins.str]] = None):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        :param 'OpaqueDeviceConfigurationArgs' opaque: Opaque provides driver-specific configuration parameters.
        :param Sequence[builtins.str] requests: Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfiguration']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[builtins.str]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceClaimConfigurationPatch(dict):
    """
    DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfigurationPatch'] = None,
                 requests: Optional[Sequence[builtins.str]] = None):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        :param 'OpaqueDeviceConfigurationPatchArgs' opaque: Opaque provides driver-specific configuration parameters.
        :param Sequence[builtins.str] requests: Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfigurationPatch']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[builtins.str]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceClaimPatch(dict):
    """
    DeviceClaim defines how to request devices with a ResourceClaim.
    """
    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceClaimConfigurationPatch']] = None,
                 constraints: Optional[Sequence['outputs.DeviceConstraintPatch']] = None,
                 requests: Optional[Sequence['outputs.DeviceRequestPatch']] = None):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        :param Sequence['DeviceClaimConfigurationPatchArgs'] config: This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        :param Sequence['DeviceConstraintPatchArgs'] constraints: These constraints must be satisfied by the set of devices that get allocated for the claim.
        :param Sequence['DeviceRequestPatchArgs'] requests: Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceClaimConfigurationPatch']]:
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def constraints(self) -> Optional[Sequence['outputs.DeviceConstraintPatch']]:
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence['outputs.DeviceRequestPatch']]:
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceClass(dict):
    """
    DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceClass. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceClass.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceClass.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.DeviceClassSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'DeviceClassSpecArgs' spec: Spec defines what can be allocated and how to configure it.
               
               This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.
               
               Changing the spec automatically increments the metadata.generation number.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'DeviceClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.DeviceClassSpec':
        """
        Spec defines what can be allocated and how to configure it.

        This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.

        Changing the spec automatically increments the metadata.generation number.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class DeviceClassConfiguration(dict):
    """
    DeviceClassConfiguration is used in DeviceClass.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfiguration'] = None):
        """
        DeviceClassConfiguration is used in DeviceClass.
        :param 'OpaqueDeviceConfigurationArgs' opaque: Opaque provides driver-specific configuration parameters.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfiguration']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")


@pulumi.output_type
class DeviceClassConfigurationPatch(dict):
    """
    DeviceClassConfiguration is used in DeviceClass.
    """
    def __init__(__self__, *,
                 opaque: Optional['outputs.OpaqueDeviceConfigurationPatch'] = None):
        """
        DeviceClassConfiguration is used in DeviceClass.
        :param 'OpaqueDeviceConfigurationPatchArgs' opaque: Opaque provides driver-specific configuration parameters.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)

    @property
    @pulumi.getter
    def opaque(self) -> Optional['outputs.OpaqueDeviceConfigurationPatch']:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")


@pulumi.output_type
class DeviceClassSpec(dict):
    """
    DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "suitableNodes":
            suggest = "suitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceClassSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceClassSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceClassSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceClassConfiguration']] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelector']] = None,
                 suitable_nodes: Optional['_core.v1.outputs.NodeSelector'] = None):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        :param Sequence['DeviceClassConfigurationArgs'] config: Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
               
               They are passed to the driver, but are not considered while allocating the claim.
        :param Sequence['DeviceSelectorArgs'] selectors: Each selector must be satisfied by a device which is claimed via this class.
        :param '_core.v1.NodeSelectorArgs' suitable_nodes: Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
               
               Setting this field is optional. If unset, all Nodes are candidates.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if suitable_nodes is not None:
            pulumi.set(__self__, "suitable_nodes", suitable_nodes)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceClassConfiguration']]:
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelector']]:
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter(name="suitableNodes")
    def suitable_nodes(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

        Setting this field is optional. If unset, all Nodes are candidates.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "suitable_nodes")


@pulumi.output_type
class DeviceClassSpecPatch(dict):
    """
    DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "suitableNodes":
            suggest = "suitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceClassSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceClassSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceClassSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional[Sequence['outputs.DeviceClassConfigurationPatch']] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelectorPatch']] = None,
                 suitable_nodes: Optional['_core.v1.outputs.NodeSelectorPatch'] = None):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        :param Sequence['DeviceClassConfigurationPatchArgs'] config: Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
               
               They are passed to the driver, but are not considered while allocating the claim.
        :param Sequence['DeviceSelectorPatchArgs'] selectors: Each selector must be satisfied by a device which is claimed via this class.
        :param '_core.v1.NodeSelectorPatchArgs' suitable_nodes: Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
               
               Setting this field is optional. If unset, all Nodes are candidates.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if suitable_nodes is not None:
            pulumi.set(__self__, "suitable_nodes", suitable_nodes)

    @property
    @pulumi.getter
    def config(self) -> Optional[Sequence['outputs.DeviceClassConfigurationPatch']]:
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelectorPatch']]:
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter(name="suitableNodes")
    def suitable_nodes(self) -> Optional['_core.v1.outputs.NodeSelectorPatch']:
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.

        Setting this field is optional. If unset, all Nodes are candidates.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "suitable_nodes")


@pulumi.output_type
class DeviceConstraint(dict):
    """
    DeviceConstraint must have exactly one field set besides Requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchAttribute":
            suggest = "match_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_attribute: Optional[builtins.str] = None,
                 requests: Optional[Sequence[builtins.str]] = None):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        :param builtins.str match_attribute: MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.
               
               For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.
               
               Must include the domain qualifier.
        :param Sequence[builtins.str] requests: Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[builtins.str]:
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        return pulumi.get(self, "match_attribute")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[builtins.str]]:
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceConstraintPatch(dict):
    """
    DeviceConstraint must have exactly one field set besides Requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchAttribute":
            suggest = "match_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceConstraintPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceConstraintPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceConstraintPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_attribute: Optional[builtins.str] = None,
                 requests: Optional[Sequence[builtins.str]] = None):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        :param builtins.str match_attribute: MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.
               
               For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.
               
               Must include the domain qualifier.
        :param Sequence[builtins.str] requests: Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[builtins.str]:
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        return pulumi.get(self, "match_attribute")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Sequence[builtins.str]]:
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class DeviceCounterConsumption(dict):
    """
    DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "counterSet":
            suggest = "counter_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceCounterConsumption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceCounterConsumption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceCounterConsumption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 counter_set: builtins.str,
                 counters: Mapping[str, 'outputs.Counter']):
        """
        DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.
        :param builtins.str counter_set: CounterSet defines the set from which the counters defined will be consumed.
        :param Mapping[str, 'CounterArgs'] counters: Counters defines the Counter that will be consumed by the device.
               
               The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
        pulumi.set(__self__, "counter_set", counter_set)
        pulumi.set(__self__, "counters", counters)

    @property
    @pulumi.getter(name="counterSet")
    def counter_set(self) -> builtins.str:
        """
        CounterSet defines the set from which the counters defined will be consumed.
        """
        return pulumi.get(self, "counter_set")

    @property
    @pulumi.getter
    def counters(self) -> Mapping[str, 'outputs.Counter']:
        """
        Counters defines the Counter that will be consumed by the device.

        The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
        return pulumi.get(self, "counters")


@pulumi.output_type
class DeviceCounterConsumptionPatch(dict):
    """
    DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "counterSet":
            suggest = "counter_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceCounterConsumptionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceCounterConsumptionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceCounterConsumptionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 counter_set: Optional[builtins.str] = None,
                 counters: Optional[Mapping[str, 'outputs.Counter']] = None):
        """
        DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.
        :param builtins.str counter_set: CounterSet defines the set from which the counters defined will be consumed.
        :param Mapping[str, 'CounterArgs'] counters: Counters defines the Counter that will be consumed by the device.
               
               The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
        if counter_set is not None:
            pulumi.set(__self__, "counter_set", counter_set)
        if counters is not None:
            pulumi.set(__self__, "counters", counters)

    @property
    @pulumi.getter(name="counterSet")
    def counter_set(self) -> Optional[builtins.str]:
        """
        CounterSet defines the set from which the counters defined will be consumed.
        """
        return pulumi.get(self, "counter_set")

    @property
    @pulumi.getter
    def counters(self) -> Optional[Mapping[str, 'outputs.Counter']]:
        """
        Counters defines the Counter that will be consumed by the device.

        The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
        return pulumi.get(self, "counters")


@pulumi.output_type
class DevicePatch(dict):
    """
    Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
    """
    def __init__(__self__, *,
                 basic: Optional['outputs.BasicDevicePatch'] = None,
                 name: Optional[builtins.str] = None):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        :param 'BasicDevicePatchArgs' basic: Basic defines one device instance.
        :param builtins.str name: Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def basic(self) -> Optional['outputs.BasicDevicePatch']:
        """
        Basic defines one device instance.
        """
        return pulumi.get(self, "basic")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DeviceRequest(dict):
    """
    DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminAccess":
            suggest = "admin_access"
        elif key == "allocationMode":
            suggest = "allocation_mode"
        elif key == "deviceClassName":
            suggest = "device_class_name"
        elif key == "firstAvailable":
            suggest = "first_available"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 admin_access: Optional[builtins.bool] = None,
                 allocation_mode: Optional[builtins.str] = None,
                 count: Optional[builtins.int] = None,
                 device_class_name: Optional[builtins.str] = None,
                 first_available: Optional[Sequence['outputs.DeviceSubRequest']] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelector']] = None,
                 tolerations: Optional[Sequence['outputs.DeviceToleration']] = None):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.
        :param builtins.str name: Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
               
               Must be a DNS label.
        :param builtins.bool admin_access: AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        :param builtins.str allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 At least one device must exist on the node for the allocation to succeed.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param builtins.int count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        :param builtins.str device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
               
               A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param Sequence['DeviceSubRequestArgs'] first_available: FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.
               
               This field may only be set in the entries of DeviceClaim.Requests.
               
               DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        :param Sequence['DeviceSelectorArgs'] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        :param Sequence['DeviceTolerationArgs'] tolerations: If specified, the request's tolerations.
               
               Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.
               
               In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.
               
               The maximum number of tolerations is 16.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        pulumi.set(__self__, "name", name)
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if first_available is not None:
            pulumi.set(__self__, "first_available", first_available)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[builtins.bool]:
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        return pulumi.get(self, "admin_access")

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[builtins.str]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          At least one device must exist on the node for the allocation to succeed.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter
    def count(self) -> Optional[builtins.int]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[builtins.str]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @property
    @pulumi.getter(name="firstAvailable")
    def first_available(self) -> Optional[Sequence['outputs.DeviceSubRequest']]:
        """
        FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.

        This field may only be set in the entries of DeviceClaim.Requests.

        DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        """
        return pulumi.get(self, "first_available")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelector']]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[Sequence['outputs.DeviceToleration']]:
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")


@pulumi.output_type
class DeviceRequestAllocationResult(dict):
    """
    DeviceRequestAllocationResult contains the allocation result for one request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminAccess":
            suggest = "admin_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceRequestAllocationResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceRequestAllocationResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceRequestAllocationResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device: builtins.str,
                 driver: builtins.str,
                 pool: builtins.str,
                 request: builtins.str,
                 admin_access: Optional[builtins.bool] = None,
                 tolerations: Optional[Sequence['outputs.DeviceToleration']] = None):
        """
        DeviceRequestAllocationResult contains the allocation result for one request.
        :param builtins.str device: Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        :param builtins.str driver: Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param builtins.str pool: This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).
               
               Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        :param builtins.str request: Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.
               
               Multiple devices may have been allocated per request.
        :param builtins.bool admin_access: AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.
               
               This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        :param Sequence['DeviceTolerationArgs'] tolerations: A copy of all tolerations specified in the request at the time when the device got allocated.
               
               The maximum number of tolerations is 16.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        pulumi.set(__self__, "request", request)
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter
    def device(self) -> builtins.str:
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def driver(self) -> builtins.str:
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def pool(self) -> builtins.str:
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def request(self) -> builtins.str:
        """
        Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.

        Multiple devices may have been allocated per request.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[builtins.bool]:
        """
        AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        return pulumi.get(self, "admin_access")

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[Sequence['outputs.DeviceToleration']]:
        """
        A copy of all tolerations specified in the request at the time when the device got allocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")


@pulumi.output_type
class DeviceRequestAllocationResultPatch(dict):
    """
    DeviceRequestAllocationResult contains the allocation result for one request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminAccess":
            suggest = "admin_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceRequestAllocationResultPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceRequestAllocationResultPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceRequestAllocationResultPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_access: Optional[builtins.bool] = None,
                 device: Optional[builtins.str] = None,
                 driver: Optional[builtins.str] = None,
                 pool: Optional[builtins.str] = None,
                 request: Optional[builtins.str] = None,
                 tolerations: Optional[Sequence['outputs.DeviceTolerationPatch']] = None):
        """
        DeviceRequestAllocationResult contains the allocation result for one request.
        :param builtins.bool admin_access: AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.
               
               This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        :param builtins.str device: Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        :param builtins.str driver: Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param builtins.str pool: This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).
               
               Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        :param builtins.str request: Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.
               
               Multiple devices may have been allocated per request.
        :param Sequence['DeviceTolerationPatchArgs'] tolerations: A copy of all tolerations specified in the request at the time when the device got allocated.
               
               The maximum number of tolerations is 16.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[builtins.bool]:
        """
        AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        return pulumi.get(self, "admin_access")

    @property
    @pulumi.getter
    def device(self) -> Optional[builtins.str]:
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def driver(self) -> Optional[builtins.str]:
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def pool(self) -> Optional[builtins.str]:
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def request(self) -> Optional[builtins.str]:
        """
        Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.

        Multiple devices may have been allocated per request.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[Sequence['outputs.DeviceTolerationPatch']]:
        """
        A copy of all tolerations specified in the request at the time when the device got allocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")


@pulumi.output_type
class DeviceRequestPatch(dict):
    """
    DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminAccess":
            suggest = "admin_access"
        elif key == "allocationMode":
            suggest = "allocation_mode"
        elif key == "deviceClassName":
            suggest = "device_class_name"
        elif key == "firstAvailable":
            suggest = "first_available"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceRequestPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceRequestPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceRequestPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_access: Optional[builtins.bool] = None,
                 allocation_mode: Optional[builtins.str] = None,
                 count: Optional[builtins.int] = None,
                 device_class_name: Optional[builtins.str] = None,
                 first_available: Optional[Sequence['outputs.DeviceSubRequestPatch']] = None,
                 name: Optional[builtins.str] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelectorPatch']] = None,
                 tolerations: Optional[Sequence['outputs.DeviceTolerationPatch']] = None):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.
        :param builtins.bool admin_access: AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        :param builtins.str allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 At least one device must exist on the node for the allocation to succeed.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param builtins.int count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        :param builtins.str device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
               
               A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param Sequence['DeviceSubRequestPatchArgs'] first_available: FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.
               
               This field may only be set in the entries of DeviceClaim.Requests.
               
               DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        :param builtins.str name: Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
               
               Must be a DNS label.
        :param Sequence['DeviceSelectorPatchArgs'] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        :param Sequence['DeviceTolerationPatchArgs'] tolerations: If specified, the request's tolerations.
               
               Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.
               
               In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.
               
               The maximum number of tolerations is 16.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if first_available is not None:
            pulumi.set(__self__, "first_available", first_available)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[builtins.bool]:
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        return pulumi.get(self, "admin_access")

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[builtins.str]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          At least one device must exist on the node for the allocation to succeed.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter
    def count(self) -> Optional[builtins.int]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[builtins.str]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @property
    @pulumi.getter(name="firstAvailable")
    def first_available(self) -> Optional[Sequence['outputs.DeviceSubRequestPatch']]:
        """
        FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.

        This field may only be set in the entries of DeviceClaim.Requests.

        DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        """
        return pulumi.get(self, "first_available")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelectorPatch']]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[Sequence['outputs.DeviceTolerationPatch']]:
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")


@pulumi.output_type
class DeviceSelector(dict):
    """
    DeviceSelector must have exactly one field set.
    """
    def __init__(__self__, *,
                 cel: Optional['outputs.CELDeviceSelector'] = None):
        """
        DeviceSelector must have exactly one field set.
        :param 'CELDeviceSelectorArgs' cel: CEL contains a CEL expression for selecting a device.
        """
        if cel is not None:
            pulumi.set(__self__, "cel", cel)

    @property
    @pulumi.getter
    def cel(self) -> Optional['outputs.CELDeviceSelector']:
        """
        CEL contains a CEL expression for selecting a device.
        """
        return pulumi.get(self, "cel")


@pulumi.output_type
class DeviceSelectorPatch(dict):
    """
    DeviceSelector must have exactly one field set.
    """
    def __init__(__self__, *,
                 cel: Optional['outputs.CELDeviceSelectorPatch'] = None):
        """
        DeviceSelector must have exactly one field set.
        :param 'CELDeviceSelectorPatchArgs' cel: CEL contains a CEL expression for selecting a device.
        """
        if cel is not None:
            pulumi.set(__self__, "cel", cel)

    @property
    @pulumi.getter
    def cel(self) -> Optional['outputs.CELDeviceSelectorPatch']:
        """
        CEL contains a CEL expression for selecting a device.
        """
        return pulumi.get(self, "cel")


@pulumi.output_type
class DeviceSubRequest(dict):
    """
    DeviceSubRequest describes a request for device provided in the claim.spec.devices.requests[].firstAvailable array. Each is typically a request for a single resource like a device, but can also ask for several identical devices.

    DeviceSubRequest is similar to Request, but doesn't expose the AdminAccess or FirstAvailable fields, as those can only be set on the top-level request. AdminAccess is not supported for requests with a prioritized list, and recursive FirstAvailable fields are not supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceClassName":
            suggest = "device_class_name"
        elif key == "allocationMode":
            suggest = "allocation_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceSubRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceSubRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceSubRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_class_name: builtins.str,
                 name: builtins.str,
                 allocation_mode: Optional[builtins.str] = None,
                 count: Optional[builtins.int] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelector']] = None,
                 tolerations: Optional[Sequence['outputs.DeviceToleration']] = None):
        """
        DeviceSubRequest describes a request for device provided in the claim.spec.devices.requests[].firstAvailable array. Each is typically a request for a single resource like a device, but can also ask for several identical devices.

        DeviceSubRequest is similar to Request, but doesn't expose the AdminAccess or FirstAvailable fields, as those can only be set on the top-level request. AdminAccess is not supported for requests with a prioritized list, and recursive FirstAvailable fields are not supported.
        :param builtins.str device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.
               
               A class is required. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param builtins.str name: Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.
               
               Must be a DNS label.
        :param builtins.str allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param builtins.int count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        :param Sequence['DeviceSelectorArgs'] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        :param Sequence['DeviceTolerationArgs'] tolerations: If specified, the request's tolerations.
               
               Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.
               
               In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.
               
               The maximum number of tolerations is 16.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        pulumi.set(__self__, "device_class_name", device_class_name)
        pulumi.set(__self__, "name", name)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> builtins.str:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[builtins.str]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter
    def count(self) -> Optional[builtins.int]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelector']]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[Sequence['outputs.DeviceToleration']]:
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")


@pulumi.output_type
class DeviceSubRequestPatch(dict):
    """
    DeviceSubRequest describes a request for device provided in the claim.spec.devices.requests[].firstAvailable array. Each is typically a request for a single resource like a device, but can also ask for several identical devices.

    DeviceSubRequest is similar to Request, but doesn't expose the AdminAccess or FirstAvailable fields, as those can only be set on the top-level request. AdminAccess is not supported for requests with a prioritized list, and recursive FirstAvailable fields are not supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationMode":
            suggest = "allocation_mode"
        elif key == "deviceClassName":
            suggest = "device_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceSubRequestPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceSubRequestPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceSubRequestPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_mode: Optional[builtins.str] = None,
                 count: Optional[builtins.int] = None,
                 device_class_name: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelectorPatch']] = None,
                 tolerations: Optional[Sequence['outputs.DeviceTolerationPatch']] = None):
        """
        DeviceSubRequest describes a request for device provided in the claim.spec.devices.requests[].firstAvailable array. Each is typically a request for a single resource like a device, but can also ask for several identical devices.

        DeviceSubRequest is similar to Request, but doesn't expose the AdminAccess or FirstAvailable fields, as those can only be set on the top-level request. AdminAccess is not supported for requests with a prioritized list, and recursive FirstAvailable fields are not supported.
        :param builtins.str allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param builtins.int count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        :param builtins.str device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.
               
               A class is required. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param builtins.str name: Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.
               
               Must be a DNS label.
        :param Sequence['DeviceSelectorPatchArgs'] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        :param Sequence['DeviceTolerationPatchArgs'] tolerations: If specified, the request's tolerations.
               
               Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.
               
               In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.
               
               The maximum number of tolerations is 16.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[builtins.str]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter
    def count(self) -> Optional[builtins.int]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[builtins.str]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelectorPatch']]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[Sequence['outputs.DeviceTolerationPatch']]:
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")


@pulumi.output_type
class DeviceTaint(dict):
    """
    The device this taint is attached to has the "effect" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAdded":
            suggest = "time_added"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceTaint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceTaint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceTaint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: builtins.str,
                 key: builtins.str,
                 time_added: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        The device this taint is attached to has the "effect" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.
        :param builtins.str effect: The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        :param builtins.str key: The taint key to be applied to a device. Must be a label name.
        :param builtins.str time_added: TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        :param builtins.str value: The taint value corresponding to the taint key. Must be a label value.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        if time_added is not None:
            pulumi.set(__self__, "time_added", time_added)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> builtins.str:
        """
        The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The taint key to be applied to a device. Must be a label name.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="timeAdded")
    def time_added(self) -> Optional[builtins.str]:
        """
        TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        """
        return pulumi.get(self, "time_added")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The taint value corresponding to the taint key. Must be a label value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DeviceTaintPatch(dict):
    """
    The device this taint is attached to has the "effect" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAdded":
            suggest = "time_added"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceTaintPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceTaintPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceTaintPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 time_added: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        The device this taint is attached to has the "effect" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.
        :param builtins.str effect: The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        :param builtins.str key: The taint key to be applied to a device. Must be a label name.
        :param builtins.str time_added: TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        :param builtins.str value: The taint value corresponding to the taint key. Must be a label value.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if time_added is not None:
            pulumi.set(__self__, "time_added", time_added)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        """
        The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The taint key to be applied to a device. Must be a label name.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="timeAdded")
    def time_added(self) -> Optional[builtins.str]:
        """
        TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        """
        return pulumi.get(self, "time_added")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The taint value corresponding to the taint key. Must be a label value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DeviceTaintRule(dict):
    """
    DeviceTaintRule adds one taint to all devices which match the selector. This has the same effect as if the taint was specified directly in the ResourceSlice by the DRA driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceTaintRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceTaintRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceTaintRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.DeviceTaintRuleSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        DeviceTaintRule adds one taint to all devices which match the selector. This has the same effect as if the taint was specified directly in the ResourceSlice by the DRA driver.
        :param 'DeviceTaintRuleSpecArgs' spec: Spec specifies the selector and one taint.
               
               Changing the spec automatically increments the metadata.generation number.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'DeviceTaintRule')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.DeviceTaintRuleSpec':
        """
        Spec specifies the selector and one taint.

        Changing the spec automatically increments the metadata.generation number.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class DeviceTaintRuleSpec(dict):
    """
    DeviceTaintRuleSpec specifies the selector and one taint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceSelector":
            suggest = "device_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceTaintRuleSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceTaintRuleSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceTaintRuleSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 taint: 'outputs.DeviceTaint',
                 device_selector: Optional['outputs.DeviceTaintSelector'] = None):
        """
        DeviceTaintRuleSpec specifies the selector and one taint.
        :param 'DeviceTaintArgs' taint: The taint that gets applied to matching devices.
        :param 'DeviceTaintSelectorArgs' device_selector: DeviceSelector defines which device(s) the taint is applied to. All selector criteria must be satified for a device to match. The empty selector matches all devices. Without a selector, no devices are matches.
        """
        pulumi.set(__self__, "taint", taint)
        if device_selector is not None:
            pulumi.set(__self__, "device_selector", device_selector)

    @property
    @pulumi.getter
    def taint(self) -> 'outputs.DeviceTaint':
        """
        The taint that gets applied to matching devices.
        """
        return pulumi.get(self, "taint")

    @property
    @pulumi.getter(name="deviceSelector")
    def device_selector(self) -> Optional['outputs.DeviceTaintSelector']:
        """
        DeviceSelector defines which device(s) the taint is applied to. All selector criteria must be satified for a device to match. The empty selector matches all devices. Without a selector, no devices are matches.
        """
        return pulumi.get(self, "device_selector")


@pulumi.output_type
class DeviceTaintRuleSpecPatch(dict):
    """
    DeviceTaintRuleSpec specifies the selector and one taint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceSelector":
            suggest = "device_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceTaintRuleSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceTaintRuleSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceTaintRuleSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_selector: Optional['outputs.DeviceTaintSelectorPatch'] = None,
                 taint: Optional['outputs.DeviceTaintPatch'] = None):
        """
        DeviceTaintRuleSpec specifies the selector and one taint.
        :param 'DeviceTaintSelectorPatchArgs' device_selector: DeviceSelector defines which device(s) the taint is applied to. All selector criteria must be satified for a device to match. The empty selector matches all devices. Without a selector, no devices are matches.
        :param 'DeviceTaintPatchArgs' taint: The taint that gets applied to matching devices.
        """
        if device_selector is not None:
            pulumi.set(__self__, "device_selector", device_selector)
        if taint is not None:
            pulumi.set(__self__, "taint", taint)

    @property
    @pulumi.getter(name="deviceSelector")
    def device_selector(self) -> Optional['outputs.DeviceTaintSelectorPatch']:
        """
        DeviceSelector defines which device(s) the taint is applied to. All selector criteria must be satified for a device to match. The empty selector matches all devices. Without a selector, no devices are matches.
        """
        return pulumi.get(self, "device_selector")

    @property
    @pulumi.getter
    def taint(self) -> Optional['outputs.DeviceTaintPatch']:
        """
        The taint that gets applied to matching devices.
        """
        return pulumi.get(self, "taint")


@pulumi.output_type
class DeviceTaintSelector(dict):
    """
    DeviceTaintSelector defines which device(s) a DeviceTaintRule applies to. The empty selector matches all devices. Without a selector, no devices are matched.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceClassName":
            suggest = "device_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceTaintSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceTaintSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceTaintSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device: Optional[builtins.str] = None,
                 device_class_name: Optional[builtins.str] = None,
                 driver: Optional[builtins.str] = None,
                 pool: Optional[builtins.str] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelector']] = None):
        """
        DeviceTaintSelector defines which device(s) a DeviceTaintRule applies to. The empty selector matches all devices. Without a selector, no devices are matched.
        :param builtins.str device: If device is set, only devices with that name are selected. This field corresponds to slice.spec.devices[].name.
               
               Setting also driver and pool may be required to avoid ambiguity, but is not required.
        :param builtins.str device_class_name: If DeviceClassName is set, the selectors defined there must be satisfied by a device to be selected. This field corresponds to class.metadata.name.
        :param builtins.str driver: If driver is set, only devices from that driver are selected. This fields corresponds to slice.spec.driver.
        :param builtins.str pool: If pool is set, only devices in that pool are selected.
               
               Also setting the driver name may be useful to avoid ambiguity when different drivers use the same pool name, but this is not required because selecting pools from different drivers may also be useful, for example when drivers with node-local devices use the node name as their pool name.
        :param Sequence['DeviceSelectorArgs'] selectors: Selectors contains the same selection criteria as a ResourceClaim. Currently, CEL expressions are supported. All of these selectors must be satisfied.
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def device(self) -> Optional[builtins.str]:
        """
        If device is set, only devices with that name are selected. This field corresponds to slice.spec.devices[].name.

        Setting also driver and pool may be required to avoid ambiguity, but is not required.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[builtins.str]:
        """
        If DeviceClassName is set, the selectors defined there must be satisfied by a device to be selected. This field corresponds to class.metadata.name.
        """
        return pulumi.get(self, "device_class_name")

    @property
    @pulumi.getter
    def driver(self) -> Optional[builtins.str]:
        """
        If driver is set, only devices from that driver are selected. This fields corresponds to slice.spec.driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def pool(self) -> Optional[builtins.str]:
        """
        If pool is set, only devices in that pool are selected.

        Also setting the driver name may be useful to avoid ambiguity when different drivers use the same pool name, but this is not required because selecting pools from different drivers may also be useful, for example when drivers with node-local devices use the node name as their pool name.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelector']]:
        """
        Selectors contains the same selection criteria as a ResourceClaim. Currently, CEL expressions are supported. All of these selectors must be satisfied.
        """
        return pulumi.get(self, "selectors")


@pulumi.output_type
class DeviceTaintSelectorPatch(dict):
    """
    DeviceTaintSelector defines which device(s) a DeviceTaintRule applies to. The empty selector matches all devices. Without a selector, no devices are matched.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceClassName":
            suggest = "device_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceTaintSelectorPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceTaintSelectorPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceTaintSelectorPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device: Optional[builtins.str] = None,
                 device_class_name: Optional[builtins.str] = None,
                 driver: Optional[builtins.str] = None,
                 pool: Optional[builtins.str] = None,
                 selectors: Optional[Sequence['outputs.DeviceSelectorPatch']] = None):
        """
        DeviceTaintSelector defines which device(s) a DeviceTaintRule applies to. The empty selector matches all devices. Without a selector, no devices are matched.
        :param builtins.str device: If device is set, only devices with that name are selected. This field corresponds to slice.spec.devices[].name.
               
               Setting also driver and pool may be required to avoid ambiguity, but is not required.
        :param builtins.str device_class_name: If DeviceClassName is set, the selectors defined there must be satisfied by a device to be selected. This field corresponds to class.metadata.name.
        :param builtins.str driver: If driver is set, only devices from that driver are selected. This fields corresponds to slice.spec.driver.
        :param builtins.str pool: If pool is set, only devices in that pool are selected.
               
               Also setting the driver name may be useful to avoid ambiguity when different drivers use the same pool name, but this is not required because selecting pools from different drivers may also be useful, for example when drivers with node-local devices use the node name as their pool name.
        :param Sequence['DeviceSelectorPatchArgs'] selectors: Selectors contains the same selection criteria as a ResourceClaim. Currently, CEL expressions are supported. All of these selectors must be satisfied.
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def device(self) -> Optional[builtins.str]:
        """
        If device is set, only devices with that name are selected. This field corresponds to slice.spec.devices[].name.

        Setting also driver and pool may be required to avoid ambiguity, but is not required.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[builtins.str]:
        """
        If DeviceClassName is set, the selectors defined there must be satisfied by a device to be selected. This field corresponds to class.metadata.name.
        """
        return pulumi.get(self, "device_class_name")

    @property
    @pulumi.getter
    def driver(self) -> Optional[builtins.str]:
        """
        If driver is set, only devices from that driver are selected. This fields corresponds to slice.spec.driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def pool(self) -> Optional[builtins.str]:
        """
        If pool is set, only devices in that pool are selected.

        Also setting the driver name may be useful to avoid ambiguity when different drivers use the same pool name, but this is not required because selecting pools from different drivers may also be useful, for example when drivers with node-local devices use the node name as their pool name.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def selectors(self) -> Optional[Sequence['outputs.DeviceSelectorPatch']]:
        """
        Selectors contains the same selection criteria as a ResourceClaim. Currently, CEL expressions are supported. All of these selectors must be satisfied.
        """
        return pulumi.get(self, "selectors")


@pulumi.output_type
class DeviceToleration(dict):
    """
    The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tolerationSeconds":
            suggest = "toleration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceToleration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceToleration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceToleration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 operator: Optional[builtins.str] = None,
                 toleration_seconds: Optional[builtins.int] = None,
                 value: Optional[builtins.str] = None):
        """
        The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
        :param builtins.str effect: Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        :param builtins.str key: Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        :param builtins.str operator: Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        :param builtins.int toleration_seconds: TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        :param builtins.str value: Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if toleration_seconds is not None:
            pulumi.set(__self__, "toleration_seconds", toleration_seconds)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        """
        Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> Optional[builtins.str]:
        """
        Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="tolerationSeconds")
    def toleration_seconds(self) -> Optional[builtins.int]:
        """
        TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        """
        return pulumi.get(self, "toleration_seconds")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DeviceTolerationPatch(dict):
    """
    The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tolerationSeconds":
            suggest = "toleration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceTolerationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceTolerationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceTolerationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 operator: Optional[builtins.str] = None,
                 toleration_seconds: Optional[builtins.int] = None,
                 value: Optional[builtins.str] = None):
        """
        The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
        :param builtins.str effect: Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        :param builtins.str key: Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        :param builtins.str operator: Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        :param builtins.int toleration_seconds: TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        :param builtins.str value: Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if toleration_seconds is not None:
            pulumi.set(__self__, "toleration_seconds", toleration_seconds)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        """
        Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def operator(self) -> Optional[builtins.str]:
        """
        Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="tolerationSeconds")
    def toleration_seconds(self) -> Optional[builtins.int]:
        """
        TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        """
        return pulumi.get(self, "toleration_seconds")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NetworkDeviceData(dict):
    """
    NetworkDeviceData provides network-related details for the allocated device. This information may be filled by drivers or other components to configure or identify the device within a network context.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hardwareAddress":
            suggest = "hardware_address"
        elif key == "interfaceName":
            suggest = "interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hardware_address: Optional[builtins.str] = None,
                 interface_name: Optional[builtins.str] = None,
                 ips: Optional[Sequence[builtins.str]] = None):
        """
        NetworkDeviceData provides network-related details for the allocated device. This information may be filled by drivers or other components to configure or identify the device within a network context.
        :param builtins.str hardware_address: HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.
               
               Must not be longer than 128 characters.
        :param builtins.str interface_name: InterfaceName specifies the name of the network interface associated with the allocated device. This might be the name of a physical or virtual network interface being configured in the pod.
               
               Must not be longer than 256 characters.
        :param Sequence[builtins.str] ips: IPs lists the network addresses assigned to the device's network interface. This can include both IPv4 and IPv6 addresses. The IPs are in the CIDR notation, which includes both the address and the associated subnet mask. e.g.: "192.0.2.5/24" for IPv4 and "2001:db8::5/64" for IPv6.
               
               Must not contain more than 16 entries.
        """
        if hardware_address is not None:
            pulumi.set(__self__, "hardware_address", hardware_address)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)

    @property
    @pulumi.getter(name="hardwareAddress")
    def hardware_address(self) -> Optional[builtins.str]:
        """
        HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.

        Must not be longer than 128 characters.
        """
        return pulumi.get(self, "hardware_address")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[builtins.str]:
        """
        InterfaceName specifies the name of the network interface associated with the allocated device. This might be the name of a physical or virtual network interface being configured in the pod.

        Must not be longer than 256 characters.
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[builtins.str]]:
        """
        IPs lists the network addresses assigned to the device's network interface. This can include both IPv4 and IPv6 addresses. The IPs are in the CIDR notation, which includes both the address and the associated subnet mask. e.g.: "192.0.2.5/24" for IPv4 and "2001:db8::5/64" for IPv6.

        Must not contain more than 16 entries.
        """
        return pulumi.get(self, "ips")


@pulumi.output_type
class NetworkDeviceDataPatch(dict):
    """
    NetworkDeviceData provides network-related details for the allocated device. This information may be filled by drivers or other components to configure or identify the device within a network context.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hardwareAddress":
            suggest = "hardware_address"
        elif key == "interfaceName":
            suggest = "interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkDeviceDataPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkDeviceDataPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkDeviceDataPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hardware_address: Optional[builtins.str] = None,
                 interface_name: Optional[builtins.str] = None,
                 ips: Optional[Sequence[builtins.str]] = None):
        """
        NetworkDeviceData provides network-related details for the allocated device. This information may be filled by drivers or other components to configure or identify the device within a network context.
        :param builtins.str hardware_address: HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.
               
               Must not be longer than 128 characters.
        :param builtins.str interface_name: InterfaceName specifies the name of the network interface associated with the allocated device. This might be the name of a physical or virtual network interface being configured in the pod.
               
               Must not be longer than 256 characters.
        :param Sequence[builtins.str] ips: IPs lists the network addresses assigned to the device's network interface. This can include both IPv4 and IPv6 addresses. The IPs are in the CIDR notation, which includes both the address and the associated subnet mask. e.g.: "192.0.2.5/24" for IPv4 and "2001:db8::5/64" for IPv6.
               
               Must not contain more than 16 entries.
        """
        if hardware_address is not None:
            pulumi.set(__self__, "hardware_address", hardware_address)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)

    @property
    @pulumi.getter(name="hardwareAddress")
    def hardware_address(self) -> Optional[builtins.str]:
        """
        HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.

        Must not be longer than 128 characters.
        """
        return pulumi.get(self, "hardware_address")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[builtins.str]:
        """
        InterfaceName specifies the name of the network interface associated with the allocated device. This might be the name of a physical or virtual network interface being configured in the pod.

        Must not be longer than 256 characters.
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[builtins.str]]:
        """
        IPs lists the network addresses assigned to the device's network interface. This can include both IPv4 and IPv6 addresses. The IPs are in the CIDR notation, which includes both the address and the associated subnet mask. e.g.: "192.0.2.5/24" for IPv4 and "2001:db8::5/64" for IPv6.

        Must not contain more than 16 entries.
        """
        return pulumi.get(self, "ips")


@pulumi.output_type
class OpaqueDeviceConfiguration(dict):
    """
    OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
    """
    def __init__(__self__, *,
                 driver: builtins.str,
                 parameters: Any):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        :param builtins.str driver: Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
               
               An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param Any parameters: Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
               
               The length of the raw data must be smaller or equal to 10 Ki.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def driver(self) -> builtins.str:
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def parameters(self) -> Any:
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class OpaqueDeviceConfigurationPatch(dict):
    """
    OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
    """
    def __init__(__self__, *,
                 driver: Optional[builtins.str] = None,
                 parameters: Optional[Any] = None):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        :param builtins.str driver: Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
               
               An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param Any parameters: Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
               
               The length of the raw data must be smaller or equal to 10 Ki.
        """
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def driver(self) -> Optional[builtins.str]:
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class PodSchedulingContext(dict):
    """
    PodSchedulingContext objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

    This is an alpha type and requires enabling the DRAControlPlaneController feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.PodSchedulingContextSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.PodSchedulingContextStatus'] = None):
        """
        PodSchedulingContext objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

        This is an alpha type and requires enabling the DRAControlPlaneController feature gate.
        :param 'PodSchedulingContextSpecArgs' spec: Spec describes where resources for the Pod are needed.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'PodSchedulingContextStatusArgs' status: Status describes where resources for the Pod can be allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PodSchedulingContext')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.PodSchedulingContextSpec':
        """
        Spec describes where resources for the Pod are needed.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.PodSchedulingContextStatus']:
        """
        Status describes where resources for the Pod can be allocated.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PodSchedulingContextSpec(dict):
    """
    PodSchedulingContextSpec describes where resources for the Pod are needed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "potentialNodes":
            suggest = "potential_nodes"
        elif key == "selectedNode":
            suggest = "selected_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 potential_nodes: Optional[Sequence[builtins.str]] = None,
                 selected_node: Optional[builtins.str] = None):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        :param Sequence[builtins.str] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param builtins.str selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[builtins.str]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")


@pulumi.output_type
class PodSchedulingContextSpecPatch(dict):
    """
    PodSchedulingContextSpec describes where resources for the Pod are needed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "potentialNodes":
            suggest = "potential_nodes"
        elif key == "selectedNode":
            suggest = "selected_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 potential_nodes: Optional[Sequence[builtins.str]] = None,
                 selected_node: Optional[builtins.str] = None):
        """
        PodSchedulingContextSpec describes where resources for the Pod are needed.
        :param Sequence[builtins.str] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param builtins.str selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[builtins.str]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")


@pulumi.output_type
class PodSchedulingContextStatus(dict):
    """
    PodSchedulingContextStatus describes where resources for the Pod can be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaims":
            suggest = "resource_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claims: Optional[Sequence['outputs.ResourceClaimSchedulingStatus']] = None):
        """
        PodSchedulingContextStatus describes where resources for the Pod can be allocated.
        :param Sequence['ResourceClaimSchedulingStatusArgs'] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[Sequence['outputs.ResourceClaimSchedulingStatus']]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")


@pulumi.output_type
class PodSchedulingContextStatusPatch(dict):
    """
    PodSchedulingContextStatus describes where resources for the Pod can be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaims":
            suggest = "resource_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingContextStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingContextStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingContextStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claims: Optional[Sequence['outputs.ResourceClaimSchedulingStatusPatch']] = None):
        """
        PodSchedulingContextStatus describes where resources for the Pod can be allocated.
        :param Sequence['ResourceClaimSchedulingStatusPatchArgs'] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[Sequence['outputs.ResourceClaimSchedulingStatusPatch']]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")


@pulumi.output_type
class ResourceClaim(dict):
    """
    ResourceClaim describes a request for access to resources in the cluster, for use by workloads. For example, if a workload needs an accelerator device with specific properties, this is how that request is expressed. The status stanza tracks whether this claim has been satisfied and what specific resources have been allocated.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaim. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaim.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaim.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.ResourceClaimStatus'] = None):
        """
        ResourceClaim describes a request for access to resources in the cluster, for use by workloads. For example, if a workload needs an accelerator device with specific properties, this is how that request is expressed. The status stanza tracks whether this claim has been satisfied and what specific resources have been allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'ResourceClaimSpecArgs' spec: Spec describes what is being requested and how to configure it. The spec is immutable.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'ResourceClaimStatusArgs' status: Status describes whether the claim is ready to use and what has been allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimSpec':
        """
        Spec describes what is being requested and how to configure it. The spec is immutable.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ResourceClaimStatus']:
        """
        Status describes whether the claim is ready to use and what has been allocated.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceClaimConsumerReference(dict):
    """
    ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimConsumerReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimConsumerReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimConsumerReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 resource: builtins.str,
                 uid: builtins.str,
                 api_group: Optional[builtins.str] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param builtins.str name: Name is the name of resource being referenced.
        :param builtins.str resource: Resource is the type of resource being referenced, for example "pods".
        :param builtins.str uid: UID identifies exactly one incarnation of the resource.
        :param builtins.str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "uid", uid)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")


@pulumi.output_type
class ResourceClaimConsumerReferencePatch(dict):
    """
    ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimConsumerReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimConsumerReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimConsumerReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_group: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 resource: Optional[builtins.str] = None,
                 uid: Optional[builtins.str] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param builtins.str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param builtins.str name: Name is the name of resource being referenced.
        :param builtins.str resource: Resource is the type of resource being referenced, for example "pods".
        :param builtins.str uid: UID identifies exactly one incarnation of the resource.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[builtins.str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> Optional[builtins.str]:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def uid(self) -> Optional[builtins.str]:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ResourceClaimSchedulingStatus(dict):
    """
    ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unsuitableNodes":
            suggest = "unsuitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSchedulingStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSchedulingStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSchedulingStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 unsuitable_nodes: Optional[Sequence[builtins.str]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param builtins.str name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param Sequence[builtins.str] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")


@pulumi.output_type
class ResourceClaimSchedulingStatusPatch(dict):
    """
    ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unsuitableNodes":
            suggest = "unsuitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSchedulingStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSchedulingStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSchedulingStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 unsuitable_nodes: Optional[Sequence[builtins.str]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param builtins.str name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param Sequence[builtins.str] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[Sequence[builtins.str]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")


@pulumi.output_type
class ResourceClaimSpec(dict):
    """
    ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
    """
    def __init__(__self__, *,
                 controller: Optional[builtins.str] = None,
                 devices: Optional['outputs.DeviceClaim'] = None):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        :param builtins.str controller: Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param 'DeviceClaimArgs' devices: Devices defines how to request devices.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter
    def controller(self) -> Optional[builtins.str]:
        """
        Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def devices(self) -> Optional['outputs.DeviceClaim']:
        """
        Devices defines how to request devices.
        """
        return pulumi.get(self, "devices")


@pulumi.output_type
class ResourceClaimSpecPatch(dict):
    """
    ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
    """
    def __init__(__self__, *,
                 controller: Optional[builtins.str] = None,
                 devices: Optional['outputs.DeviceClaimPatch'] = None):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        :param builtins.str controller: Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param 'DeviceClaimPatchArgs' devices: Devices defines how to request devices.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter
    def controller(self) -> Optional[builtins.str]:
        """
        Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def devices(self) -> Optional['outputs.DeviceClaimPatch']:
        """
        Devices defines how to request devices.
        """
        return pulumi.get(self, "devices")


@pulumi.output_type
class ResourceClaimStatus(dict):
    """
    ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deallocationRequested":
            suggest = "deallocation_requested"
        elif key == "reservedFor":
            suggest = "reserved_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation: Optional['outputs.AllocationResult'] = None,
                 deallocation_requested: Optional[builtins.bool] = None,
                 devices: Optional[Sequence['outputs.AllocatedDeviceStatus']] = None,
                 reserved_for: Optional[Sequence['outputs.ResourceClaimConsumerReference']] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
        :param 'AllocationResultArgs' allocation: Allocation is set once the claim has been allocated successfully.
        :param builtins.bool deallocation_requested: Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
               
               This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param Sequence['AllocatedDeviceStatusArgs'] devices: Devices contains the status of each device allocated for this claim, as reported by the driver. This can include driver-specific information. Entries are owned by their respective drivers.
        :param Sequence['ResourceClaimConsumerReferenceArgs'] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
               
               In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
               
               Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
               
               There can be at most 256 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional['outputs.AllocationResult']:
        """
        Allocation is set once the claim has been allocated successfully.
        """
        return pulumi.get(self, "allocation")

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[builtins.bool]:
        """
        Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.

        This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "deallocation_requested")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.AllocatedDeviceStatus']]:
        """
        Devices contains the status of each device allocated for this claim, as reported by the driver. This can include driver-specific information. Entries are owned by their respective drivers.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[Sequence['outputs.ResourceClaimConsumerReference']]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

        In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

        Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

        There can be at most 256 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")


@pulumi.output_type
class ResourceClaimStatusPatch(dict):
    """
    ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deallocationRequested":
            suggest = "deallocation_requested"
        elif key == "reservedFor":
            suggest = "reserved_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation: Optional['outputs.AllocationResultPatch'] = None,
                 deallocation_requested: Optional[builtins.bool] = None,
                 devices: Optional[Sequence['outputs.AllocatedDeviceStatusPatch']] = None,
                 reserved_for: Optional[Sequence['outputs.ResourceClaimConsumerReferencePatch']] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
        :param 'AllocationResultPatchArgs' allocation: Allocation is set once the claim has been allocated successfully.
        :param builtins.bool deallocation_requested: Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
               
               This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        :param Sequence['AllocatedDeviceStatusPatchArgs'] devices: Devices contains the status of each device allocated for this claim, as reported by the driver. This can include driver-specific information. Entries are owned by their respective drivers.
        :param Sequence['ResourceClaimConsumerReferencePatchArgs'] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
               
               In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
               
               Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
               
               There can be at most 256 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional['outputs.AllocationResultPatch']:
        """
        Allocation is set once the claim has been allocated successfully.
        """
        return pulumi.get(self, "allocation")

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[builtins.bool]:
        """
        Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.

        This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
        """
        return pulumi.get(self, "deallocation_requested")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.AllocatedDeviceStatusPatch']]:
        """
        Devices contains the status of each device allocated for this claim, as reported by the driver. This can include driver-specific information. Entries are owned by their respective drivers.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[Sequence['outputs.ResourceClaimConsumerReferencePatch']]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

        In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

        Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

        There can be at most 256 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")


@pulumi.output_type
class ResourceClaimTemplate(dict):
    """
    ResourceClaimTemplate is used to produce ResourceClaim objects.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimTemplateSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'ResourceClaimTemplateSpecArgs' spec: Describes the ResourceClaim that is to be generated.
               
               This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaimTemplate')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimTemplateSpec':
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ResourceClaimTemplateSpec(dict):
    """
    ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
    """
    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimSpec',
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param 'ResourceClaimSpecArgs' spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        :param '_meta.v1.ObjectMetaArgs' metadata: ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        """
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimSpec':
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ResourceClaimTemplateSpecPatch(dict):
    """
    ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
    """
    def __init__(__self__, *,
                 metadata: Optional['_meta.v1.outputs.ObjectMetaPatch'] = None,
                 spec: Optional['outputs.ResourceClaimSpecPatch'] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param '_meta.v1.ObjectMetaPatchArgs' metadata: ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        :param 'ResourceClaimSpecPatchArgs' spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMetaPatch']:
        """
        ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ResourceClaimSpecPatch']:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class ResourcePool(dict):
    """
    ResourcePool describes the pool that ResourceSlices belong to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceSliceCount":
            suggest = "resource_slice_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generation: builtins.int,
                 name: builtins.str,
                 resource_slice_count: builtins.int):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        :param builtins.int generation: Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
               
               Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        :param builtins.str name: Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
               
               It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        :param builtins.int resource_slice_count: ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
               
               Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_slice_count", resource_slice_count)

    @property
    @pulumi.getter
    def generation(self) -> builtins.int:
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceSliceCount")
    def resource_slice_count(self) -> builtins.int:
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        return pulumi.get(self, "resource_slice_count")


@pulumi.output_type
class ResourcePoolPatch(dict):
    """
    ResourcePool describes the pool that ResourceSlices belong to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceSliceCount":
            suggest = "resource_slice_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcePoolPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcePoolPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcePoolPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generation: Optional[builtins.int] = None,
                 name: Optional[builtins.str] = None,
                 resource_slice_count: Optional[builtins.int] = None):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        :param builtins.int generation: Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
               
               Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        :param builtins.str name: Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
               
               It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        :param builtins.int resource_slice_count: ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
               
               Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_slice_count is not None:
            pulumi.set(__self__, "resource_slice_count", resource_slice_count)

    @property
    @pulumi.getter
    def generation(self) -> Optional[builtins.int]:
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceSliceCount")
    def resource_slice_count(self) -> Optional[builtins.int]:
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        return pulumi.get(self, "resource_slice_count")


@pulumi.output_type
class ResourceSlice(dict):
    """
    ResourceSlice represents one or more resources in a pool of similar resources, managed by a common driver. A pool may span more than one ResourceSlice, and exactly how many ResourceSlices comprise a pool is determined by the driver.

    At the moment, the only supported resources are devices with attributes and capacities. Each device in a given pool, regardless of how many ResourceSlices, must have a unique name. The ResourceSlice in which a device gets published may change over time. The unique identifier for a device is the tuple <driver name>, <pool name>, <device name>.

    Whenever a driver needs to update a pool, it increments the pool.Spec.Pool.Generation number and updates all ResourceSlices with that new number and new resource definitions. A consumer must only use ResourceSlices with the highest generation number and ignore all others.

    When allocating all resources in a pool matching certain criteria or when looking for the best solution among several different alternatives, a consumer should check the number of ResourceSlices in a pool (included in each ResourceSlice) to determine whether its view of a pool is complete and if not, should wait until the driver has completed updating the pool.

    For resources that are not local to a node, the node name is not set. Instead, the driver may use a node selector to specify where the devices are available.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSlice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSlice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSlice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ResourceSliceSpec',
                 api_version: Optional[builtins.str] = None,
                 kind: Optional[builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ResourceSlice represents one or more resources in a pool of similar resources, managed by a common driver. A pool may span more than one ResourceSlice, and exactly how many ResourceSlices comprise a pool is determined by the driver.

        At the moment, the only supported resources are devices with attributes and capacities. Each device in a given pool, regardless of how many ResourceSlices, must have a unique name. The ResourceSlice in which a device gets published may change over time. The unique identifier for a device is the tuple <driver name>, <pool name>, <device name>.

        Whenever a driver needs to update a pool, it increments the pool.Spec.Pool.Generation number and updates all ResourceSlices with that new number and new resource definitions. A consumer must only use ResourceSlices with the highest generation number and ignore all others.

        When allocating all resources in a pool matching certain criteria or when looking for the best solution among several different alternatives, a consumer should check the number of ResourceSlices in a pool (included in each ResourceSlice) to determine whether its view of a pool is complete and if not, should wait until the driver has completed updating the pool.

        For resources that are not local to a node, the node name is not set. Instead, the driver may use a node selector to specify where the devices are available.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'ResourceSliceSpecArgs' spec: Contains the information published by the driver.
               
               Changing the spec automatically increments the metadata.generation number.
        :param builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha3')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceSlice')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceSliceSpec':
        """
        Contains the information published by the driver.

        Changing the spec automatically increments the metadata.generation number.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ResourceSliceSpec(dict):
    """
    ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNodes":
            suggest = "all_nodes"
        elif key == "nodeName":
            suggest = "node_name"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "perDeviceNodeSelection":
            suggest = "per_device_node_selection"
        elif key == "sharedCounters":
            suggest = "shared_counters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSliceSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSliceSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSliceSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: builtins.str,
                 pool: 'outputs.ResourcePool',
                 all_nodes: Optional[builtins.bool] = None,
                 devices: Optional[Sequence['outputs.Device']] = None,
                 node_name: Optional[builtins.str] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelector'] = None,
                 per_device_node_selection: Optional[builtins.bool] = None,
                 shared_counters: Optional[Sequence['outputs.CounterSet']] = None):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        :param builtins.str driver: Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        :param 'ResourcePoolArgs' pool: Pool describes the pool that this ResourceSlice belongs to.
        :param builtins.bool all_nodes: AllNodes indicates that all nodes have access to the resources in the pool.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param Sequence['DeviceArgs'] devices: Devices lists some or all of the devices in this pool.
               
               Must not have more than 128 entries.
        :param builtins.str node_name: NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
               
               This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        :param '_core.v1.NodeSelectorArgs' node_selector: NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
               
               Must use exactly one term.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param builtins.bool per_device_node_selection: PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param Sequence['CounterSetArgs'] shared_counters: SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.
               
               The names of the SharedCounters must be unique in the ResourceSlice.
               
               The maximum number of SharedCounters is 32.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if per_device_node_selection is not None:
            pulumi.set(__self__, "per_device_node_selection", per_device_node_selection)
        if shared_counters is not None:
            pulumi.set(__self__, "shared_counters", shared_counters)

    @property
    @pulumi.getter
    def driver(self) -> builtins.str:
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def pool(self) -> 'outputs.ResourcePool':
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[builtins.bool]:
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "all_nodes")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.Device']]:
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[builtins.str]:
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter(name="perDeviceNodeSelection")
    def per_device_node_selection(self) -> Optional[builtins.bool]:
        """
        PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "per_device_node_selection")

    @property
    @pulumi.getter(name="sharedCounters")
    def shared_counters(self) -> Optional[Sequence['outputs.CounterSet']]:
        """
        SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.

        The names of the SharedCounters must be unique in the ResourceSlice.

        The maximum number of SharedCounters is 32.
        """
        return pulumi.get(self, "shared_counters")


@pulumi.output_type
class ResourceSliceSpecPatch(dict):
    """
    ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNodes":
            suggest = "all_nodes"
        elif key == "nodeName":
            suggest = "node_name"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "perDeviceNodeSelection":
            suggest = "per_device_node_selection"
        elif key == "sharedCounters":
            suggest = "shared_counters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceSliceSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceSliceSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceSliceSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_nodes: Optional[builtins.bool] = None,
                 devices: Optional[Sequence['outputs.DevicePatch']] = None,
                 driver: Optional[builtins.str] = None,
                 node_name: Optional[builtins.str] = None,
                 node_selector: Optional['_core.v1.outputs.NodeSelectorPatch'] = None,
                 per_device_node_selection: Optional[builtins.bool] = None,
                 pool: Optional['outputs.ResourcePoolPatch'] = None,
                 shared_counters: Optional[Sequence['outputs.CounterSetPatch']] = None):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        :param builtins.bool all_nodes: AllNodes indicates that all nodes have access to the resources in the pool.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param Sequence['DevicePatchArgs'] devices: Devices lists some or all of the devices in this pool.
               
               Must not have more than 128 entries.
        :param builtins.str driver: Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        :param builtins.str node_name: NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
               
               This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        :param '_core.v1.NodeSelectorPatchArgs' node_selector: NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
               
               Must use exactly one term.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param builtins.bool per_device_node_selection: PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param 'ResourcePoolPatchArgs' pool: Pool describes the pool that this ResourceSlice belongs to.
        :param Sequence['CounterSetPatchArgs'] shared_counters: SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.
               
               The names of the SharedCounters must be unique in the ResourceSlice.
               
               The maximum number of SharedCounters is 32.
        """
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if per_device_node_selection is not None:
            pulumi.set(__self__, "per_device_node_selection", per_device_node_selection)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if shared_counters is not None:
            pulumi.set(__self__, "shared_counters", shared_counters)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[builtins.bool]:
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "all_nodes")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.DevicePatch']]:
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter
    def driver(self) -> Optional[builtins.str]:
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[builtins.str]:
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['_core.v1.outputs.NodeSelectorPatch']:
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter(name="perDeviceNodeSelection")
    def per_device_node_selection(self) -> Optional[builtins.bool]:
        """
        PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "per_device_node_selection")

    @property
    @pulumi.getter
    def pool(self) -> Optional['outputs.ResourcePoolPatch']:
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter(name="sharedCounters")
    def shared_counters(self) -> Optional[Sequence['outputs.CounterSetPatch']]:
        """
        SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.

        The names of the SharedCounters must be unique in the ResourceSlice.

        The maximum number of SharedCounters is 32.
        """
        return pulumi.get(self, "shared_counters")


