# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'AllocatedDeviceStatusArgs',
    'AllocatedDeviceStatusArgsDict',
    'AllocationResultArgs',
    'AllocationResultArgsDict',
    'BasicDevicePatchArgs',
    'BasicDevicePatchArgsDict',
    'BasicDeviceArgs',
    'BasicDeviceArgsDict',
    'CELDeviceSelectorPatchArgs',
    'CELDeviceSelectorPatchArgsDict',
    'CELDeviceSelectorArgs',
    'CELDeviceSelectorArgsDict',
    'CounterSetPatchArgs',
    'CounterSetPatchArgsDict',
    'CounterSetArgs',
    'CounterSetArgsDict',
    'CounterArgs',
    'CounterArgsDict',
    'DeviceAllocationConfigurationArgs',
    'DeviceAllocationConfigurationArgsDict',
    'DeviceAllocationResultArgs',
    'DeviceAllocationResultArgsDict',
    'DeviceAttributeArgs',
    'DeviceAttributeArgsDict',
    'DeviceCapacityArgs',
    'DeviceCapacityArgsDict',
    'DeviceClaimConfigurationPatchArgs',
    'DeviceClaimConfigurationPatchArgsDict',
    'DeviceClaimConfigurationArgs',
    'DeviceClaimConfigurationArgsDict',
    'DeviceClaimPatchArgs',
    'DeviceClaimPatchArgsDict',
    'DeviceClaimArgs',
    'DeviceClaimArgsDict',
    'DeviceClassConfigurationPatchArgs',
    'DeviceClassConfigurationPatchArgsDict',
    'DeviceClassConfigurationArgs',
    'DeviceClassConfigurationArgsDict',
    'DeviceClassSpecPatchArgs',
    'DeviceClassSpecPatchArgsDict',
    'DeviceClassSpecArgs',
    'DeviceClassSpecArgsDict',
    'DeviceClassArgs',
    'DeviceClassArgsDict',
    'DeviceConstraintPatchArgs',
    'DeviceConstraintPatchArgsDict',
    'DeviceConstraintArgs',
    'DeviceConstraintArgsDict',
    'DeviceCounterConsumptionPatchArgs',
    'DeviceCounterConsumptionPatchArgsDict',
    'DeviceCounterConsumptionArgs',
    'DeviceCounterConsumptionArgsDict',
    'DevicePatchArgs',
    'DevicePatchArgsDict',
    'DeviceRequestAllocationResultArgs',
    'DeviceRequestAllocationResultArgsDict',
    'DeviceRequestPatchArgs',
    'DeviceRequestPatchArgsDict',
    'DeviceRequestArgs',
    'DeviceRequestArgsDict',
    'DeviceSelectorPatchArgs',
    'DeviceSelectorPatchArgsDict',
    'DeviceSelectorArgs',
    'DeviceSelectorArgsDict',
    'DeviceSubRequestPatchArgs',
    'DeviceSubRequestPatchArgsDict',
    'DeviceSubRequestArgs',
    'DeviceSubRequestArgsDict',
    'DeviceTaintPatchArgs',
    'DeviceTaintPatchArgsDict',
    'DeviceTaintArgs',
    'DeviceTaintArgsDict',
    'DeviceTolerationPatchArgs',
    'DeviceTolerationPatchArgsDict',
    'DeviceTolerationArgs',
    'DeviceTolerationArgsDict',
    'DeviceArgs',
    'DeviceArgsDict',
    'NetworkDeviceDataArgs',
    'NetworkDeviceDataArgsDict',
    'OpaqueDeviceConfigurationPatchArgs',
    'OpaqueDeviceConfigurationPatchArgsDict',
    'OpaqueDeviceConfigurationArgs',
    'OpaqueDeviceConfigurationArgsDict',
    'ResourceClaimConsumerReferenceArgs',
    'ResourceClaimConsumerReferenceArgsDict',
    'ResourceClaimSpecPatchArgs',
    'ResourceClaimSpecPatchArgsDict',
    'ResourceClaimSpecArgs',
    'ResourceClaimSpecArgsDict',
    'ResourceClaimStatusArgs',
    'ResourceClaimStatusArgsDict',
    'ResourceClaimTemplateSpecPatchArgs',
    'ResourceClaimTemplateSpecPatchArgsDict',
    'ResourceClaimTemplateSpecArgs',
    'ResourceClaimTemplateSpecArgsDict',
    'ResourceClaimTemplateArgs',
    'ResourceClaimTemplateArgsDict',
    'ResourceClaimArgs',
    'ResourceClaimArgsDict',
    'ResourcePoolPatchArgs',
    'ResourcePoolPatchArgsDict',
    'ResourcePoolArgs',
    'ResourcePoolArgsDict',
    'ResourceSliceSpecPatchArgs',
    'ResourceSliceSpecPatchArgsDict',
    'ResourceSliceSpecArgs',
    'ResourceSliceSpecArgsDict',
    'ResourceSliceArgs',
    'ResourceSliceArgsDict',
]

MYPY = False

if not MYPY:
    class AllocatedDeviceStatusArgsDict(TypedDict):
        """
        AllocatedDeviceStatus contains the status of an allocated device, if the driver chooses to report it. This may include driver-specific information.
        """
        device: pulumi.Input[builtins.str]
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        driver: pulumi.Input[builtins.str]
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        pool: pulumi.Input[builtins.str]
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgsDict']]]]
        """
        Conditions contains the latest observation of the device's state. If the device has been configured according to the class and claim config references, the `Ready` condition should be True.

        Must not contain more than 8 entries.
        """
        data: NotRequired[Any]
        """
        Data contains arbitrary driver-specific data.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
        network_data: NotRequired[pulumi.Input['NetworkDeviceDataArgsDict']]
        """
        NetworkData contains network-related information specific to the device.
        """
elif False:
    AllocatedDeviceStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AllocatedDeviceStatusArgs:
    def __init__(__self__, *,
                 device: pulumi.Input[builtins.str],
                 driver: pulumi.Input[builtins.str],
                 pool: pulumi.Input[builtins.str],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]]] = None,
                 data: Optional[Any] = None,
                 network_data: Optional[pulumi.Input['NetworkDeviceDataArgs']] = None):
        """
        AllocatedDeviceStatus contains the status of an allocated device, if the driver chooses to report it. This may include driver-specific information.
        :param pulumi.Input[builtins.str] device: Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        :param pulumi.Input[builtins.str] driver: Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param pulumi.Input[builtins.str] pool: This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).
               
               Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        :param pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]] conditions: Conditions contains the latest observation of the device's state. If the device has been configured according to the class and claim config references, the `Ready` condition should be True.
               
               Must not contain more than 8 entries.
        :param Any data: Data contains arbitrary driver-specific data.
               
               The length of the raw data must be smaller or equal to 10 Ki.
        :param pulumi.Input['NetworkDeviceDataArgs'] network_data: NetworkData contains network-related information specific to the device.
        """
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if network_data is not None:
            pulumi.set(__self__, "network_data", network_data)

    @property
    @pulumi.getter
    def device(self) -> pulumi.Input[builtins.str]:
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[builtins.str]:
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Input[builtins.str]:
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]]]:
        """
        Conditions contains the latest observation of the device's state. If the device has been configured according to the class and claim config references, the `Ready` condition should be True.

        Must not contain more than 8 entries.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[Any]:
        """
        Data contains arbitrary driver-specific data.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[Any]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="networkData")
    def network_data(self) -> Optional[pulumi.Input['NetworkDeviceDataArgs']]:
        """
        NetworkData contains network-related information specific to the device.
        """
        return pulumi.get(self, "network_data")

    @network_data.setter
    def network_data(self, value: Optional[pulumi.Input['NetworkDeviceDataArgs']]):
        pulumi.set(self, "network_data", value)


if not MYPY:
    class AllocationResultArgsDict(TypedDict):
        """
        AllocationResult contains attributes of an allocated resource.
        """
        devices: NotRequired[pulumi.Input['DeviceAllocationResultArgsDict']]
        """
        Devices is the result of allocating devices.
        """
        node_selector: NotRequired[pulumi.Input['_core.v1.NodeSelectorArgsDict']]
        """
        NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
elif False:
    AllocationResultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AllocationResultArgs:
    def __init__(__self__, *,
                 devices: Optional[pulumi.Input['DeviceAllocationResultArgs']] = None,
                 node_selector: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']] = None):
        """
        AllocationResult contains attributes of an allocated resource.
        :param pulumi.Input['DeviceAllocationResultArgs'] devices: Devices is the result of allocating devices.
        :param pulumi.Input['_core.v1.NodeSelectorArgs'] node_selector: NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input['DeviceAllocationResultArgs']]:
        """
        Devices is the result of allocating devices.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input['DeviceAllocationResultArgs']]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]:
        """
        NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]):
        pulumi.set(self, "node_selector", value)


if not MYPY:
    class BasicDevicePatchArgsDict(TypedDict):
        """
        BasicDevice defines one device instance.
        """
        all_nodes: NotRequired[pulumi.Input[builtins.bool]]
        """
        AllNodes indicates that all nodes have access to the device.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        attributes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgsDict']]]]
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        capacity: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgsDict']]]]
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        consumes_counters: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionPatchArgsDict']]]]
        """
        ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.

        There can only be a single entry per counterSet.

        The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        """
        node_name: NotRequired[pulumi.Input[builtins.str]]
        """
        NodeName identifies the node where the device is available.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        node_selector: NotRequired[pulumi.Input['_core.v1.NodeSelectorPatchArgsDict']]
        """
        NodeSelector defines the nodes where the device is available.

        Must use exactly one term.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        taints: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceTaintPatchArgsDict']]]]
        """
        If specified, these are the driver-defined taints.

        The maximum number of taints is 4.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
elif False:
    BasicDevicePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BasicDevicePatchArgs:
    def __init__(__self__, *,
                 all_nodes: Optional[pulumi.Input[builtins.bool]] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]] = None,
                 capacity: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgs']]]] = None,
                 consumes_counters: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionPatchArgs']]]] = None,
                 node_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_selector: Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTaintPatchArgs']]]] = None):
        """
        BasicDevice defines one device instance.
        :param pulumi.Input[builtins.bool] all_nodes: AllNodes indicates that all nodes have access to the device.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]] attributes: Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgs']]] capacity: Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionPatchArgs']]] consumes_counters: ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.
               
               There can only be a single entry per counterSet.
               
               The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        :param pulumi.Input[builtins.str] node_name: NodeName identifies the node where the device is available.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param pulumi.Input['_core.v1.NodeSelectorPatchArgs'] node_selector: NodeSelector defines the nodes where the device is available.
               
               Must use exactly one term.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceTaintPatchArgs']]] taints: If specified, these are the driver-defined taints.
               
               The maximum number of taints is 4.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if consumes_counters is not None:
            pulumi.set(__self__, "consumes_counters", consumes_counters)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        AllNodes indicates that all nodes have access to the device.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "all_nodes")

    @all_nodes.setter
    def all_nodes(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "all_nodes", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]]:
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgs']]]]:
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgs']]]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="consumesCounters")
    def consumes_counters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionPatchArgs']]]]:
        """
        ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.

        There can only be a single entry per counterSet.

        The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        """
        return pulumi.get(self, "consumes_counters")

    @consumes_counters.setter
    def consumes_counters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionPatchArgs']]]]):
        pulumi.set(self, "consumes_counters", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        NodeName identifies the node where the device is available.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']]:
        """
        NodeSelector defines the nodes where the device is available.

        Must use exactly one term.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']]):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTaintPatchArgs']]]]:
        """
        If specified, these are the driver-defined taints.

        The maximum number of taints is 4.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTaintPatchArgs']]]]):
        pulumi.set(self, "taints", value)


if not MYPY:
    class BasicDeviceArgsDict(TypedDict):
        """
        BasicDevice defines one device instance.
        """
        all_nodes: NotRequired[pulumi.Input[builtins.bool]]
        """
        AllNodes indicates that all nodes have access to the device.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        attributes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgsDict']]]]
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        capacity: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgsDict']]]]
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        consumes_counters: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionArgsDict']]]]
        """
        ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.

        There can only be a single entry per counterSet.

        The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        """
        node_name: NotRequired[pulumi.Input[builtins.str]]
        """
        NodeName identifies the node where the device is available.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        node_selector: NotRequired[pulumi.Input['_core.v1.NodeSelectorArgsDict']]
        """
        NodeSelector defines the nodes where the device is available.

        Must use exactly one term.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        taints: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceTaintArgsDict']]]]
        """
        If specified, these are the driver-defined taints.

        The maximum number of taints is 4.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
elif False:
    BasicDeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BasicDeviceArgs:
    def __init__(__self__, *,
                 all_nodes: Optional[pulumi.Input[builtins.bool]] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]] = None,
                 capacity: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgs']]]] = None,
                 consumes_counters: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionArgs']]]] = None,
                 node_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_selector: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTaintArgs']]]] = None):
        """
        BasicDevice defines one device instance.
        :param pulumi.Input[builtins.bool] all_nodes: AllNodes indicates that all nodes have access to the device.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]] attributes: Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgs']]] capacity: Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.
               
               The maximum number of attributes and capacities combined is 32.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionArgs']]] consumes_counters: ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.
               
               There can only be a single entry per counterSet.
               
               The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        :param pulumi.Input[builtins.str] node_name: NodeName identifies the node where the device is available.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param pulumi.Input['_core.v1.NodeSelectorArgs'] node_selector: NodeSelector defines the nodes where the device is available.
               
               Must use exactly one term.
               
               Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceTaintArgs']]] taints: If specified, these are the driver-defined taints.
               
               The maximum number of taints is 4.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if consumes_counters is not None:
            pulumi.set(__self__, "consumes_counters", consumes_counters)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        AllNodes indicates that all nodes have access to the device.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "all_nodes")

    @all_nodes.setter
    def all_nodes(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "all_nodes", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]]:
        """
        Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgs']]]]:
        """
        Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.

        The maximum number of attributes and capacities combined is 32.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeviceCapacityArgs']]]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="consumesCounters")
    def consumes_counters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionArgs']]]]:
        """
        ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.

        There can only be a single entry per counterSet.

        The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).
        """
        return pulumi.get(self, "consumes_counters")

    @consumes_counters.setter
    def consumes_counters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceCounterConsumptionArgs']]]]):
        pulumi.set(self, "consumes_counters", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        NodeName identifies the node where the device is available.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]:
        """
        NodeSelector defines the nodes where the device is available.

        Must use exactly one term.

        Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTaintArgs']]]]:
        """
        If specified, these are the driver-defined taints.

        The maximum number of taints is 4.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTaintArgs']]]]):
        pulumi.set(self, "taints", value)


if not MYPY:
    class CELDeviceSelectorPatchArgsDict(TypedDict):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        """
        expression: NotRequired[pulumi.Input[builtins.str]]
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)

        The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
elif False:
    CELDeviceSelectorPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CELDeviceSelectorPatchArgs:
    def __init__(__self__, *,
                 expression: Optional[pulumi.Input[builtins.str]] = None):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        :param pulumi.Input[builtins.str] expression: Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.
               
               The expression's input is an object named "device", which carries the following properties:
                - driver (string): the name of the driver which defines this device.
                - attributes (map[string]object): the device's attributes, grouped by prefix
                  (e.g. device.attributes["dra.example.com"] evaluates to an object with all
                  of the attributes which were prefixed by "dra.example.com".
                - capacity (map[string]object): the device's capacities, grouped by prefix.
               
               Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:
               
                   device.driver
                   device.attributes["dra.example.com"].model
                   device.attributes["ext.example.com"].family
                   device.capacity["dra.example.com"].modules
               
               The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.
               
               The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.
               
               If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.
               
               A robust expression should check for the existence of attributes before referencing them.
               
               For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:
               
                   cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
               
               The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)

        The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expression", value)


if not MYPY:
    class CELDeviceSelectorArgsDict(TypedDict):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        """
        expression: pulumi.Input[builtins.str]
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)

        The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
elif False:
    CELDeviceSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CELDeviceSelectorArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str]):
        """
        CELDeviceSelector contains a CEL expression for selecting a device.
        :param pulumi.Input[builtins.str] expression: Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.
               
               The expression's input is an object named "device", which carries the following properties:
                - driver (string): the name of the driver which defines this device.
                - attributes (map[string]object): the device's attributes, grouped by prefix
                  (e.g. device.attributes["dra.example.com"] evaluates to an object with all
                  of the attributes which were prefixed by "dra.example.com".
                - capacity (map[string]object): the device's capacities, grouped by prefix.
               
               Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:
               
                   device.driver
                   device.attributes["dra.example.com"].model
                   device.attributes["ext.example.com"].family
                   device.capacity["dra.example.com"].modules
               
               The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.
               
               The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.
               
               If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.
               
               A robust expression should check for the existence of attributes before referencing them.
               
               For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:
               
                   cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)
               
               The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        Expression is a CEL expression which evaluates a single device. It must evaluate to true when the device under consideration satisfies the desired criteria, and false when it does not. Any other result is an error and causes allocation of devices to abort.

        The expression's input is an object named "device", which carries the following properties:
         - driver (string): the name of the driver which defines this device.
         - attributes (map[string]object): the device's attributes, grouped by prefix
           (e.g. device.attributes["dra.example.com"] evaluates to an object with all
           of the attributes which were prefixed by "dra.example.com".
         - capacity (map[string]object): the device's capacities, grouped by prefix.

        Example: Consider a device with driver="dra.example.com", which exposes two attributes named "model" and "ext.example.com/family" and which exposes one capacity named "modules". This input to this expression would have the following fields:

            device.driver
            device.attributes["dra.example.com"].model
            device.attributes["ext.example.com"].family
            device.capacity["dra.example.com"].modules

        The device.driver field can be used to check for a specific driver, either as a high-level precondition (i.e. you only want to consider devices from this driver) or as part of a multi-clause expression that is meant to consider devices from different drivers.

        The value type of each attribute is defined by the device definition, and users who write these expressions must consult the documentation for their specific drivers. The value type of each capacity is Quantity.

        If an unknown prefix is used as a lookup in either device.attributes or device.capacity, an empty map will be returned. Any reference to an unknown field will cause an evaluation error and allocation to abort.

        A robust expression should check for the existence of attributes before referencing them.

        For ease of use, the cel.bind() function is enabled, and can be used to simplify expressions that access multiple attributes with the same domain. For example:

            cel.bind(dra, device.attributes["dra.example.com"], dra.someBool && dra.anotherBool)

        The length of the expression must be smaller or equal to 10 Ki. The cost of evaluating it is also limited based on the estimated number of logical steps.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)


if not MYPY:
    class CounterSetPatchArgsDict(TypedDict):
        """
        CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.

        The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.
        """
        counters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['CounterArgsDict']]]]
        """
        Counters defines the set of counters for this CounterSet The name of each counter must be unique in that set and must be a DNS label.

        The maximum number of counters is 32.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name defines the name of the counter set. It must be a DNS label.
        """
elif False:
    CounterSetPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CounterSetPatchArgs:
    def __init__(__self__, *,
                 counters: Optional[pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.

        The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.
        :param pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]] counters: Counters defines the set of counters for this CounterSet The name of each counter must be unique in that set and must be a DNS label.
               
               The maximum number of counters is 32.
        :param pulumi.Input[builtins.str] name: Name defines the name of the counter set. It must be a DNS label.
        """
        if counters is not None:
            pulumi.set(__self__, "counters", counters)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def counters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]]:
        """
        Counters defines the set of counters for this CounterSet The name of each counter must be unique in that set and must be a DNS label.

        The maximum number of counters is 32.
        """
        return pulumi.get(self, "counters")

    @counters.setter
    def counters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]]):
        pulumi.set(self, "counters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name defines the name of the counter set. It must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class CounterSetArgsDict(TypedDict):
        """
        CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.

        The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.
        """
        counters: pulumi.Input[Mapping[str, pulumi.Input['CounterArgsDict']]]
        """
        Counters defines the set of counters for this CounterSet The name of each counter must be unique in that set and must be a DNS label.

        The maximum number of counters is 32.
        """
        name: pulumi.Input[builtins.str]
        """
        Name defines the name of the counter set. It must be a DNS label.
        """
elif False:
    CounterSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CounterSetArgs:
    def __init__(__self__, *,
                 counters: pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]],
                 name: pulumi.Input[builtins.str]):
        """
        CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.

        The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.
        :param pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]] counters: Counters defines the set of counters for this CounterSet The name of each counter must be unique in that set and must be a DNS label.
               
               The maximum number of counters is 32.
        :param pulumi.Input[builtins.str] name: Name defines the name of the counter set. It must be a DNS label.
        """
        pulumi.set(__self__, "counters", counters)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def counters(self) -> pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]:
        """
        Counters defines the set of counters for this CounterSet The name of each counter must be unique in that set and must be a DNS label.

        The maximum number of counters is 32.
        """
        return pulumi.get(self, "counters")

    @counters.setter
    def counters(self, value: pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]):
        pulumi.set(self, "counters", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name defines the name of the counter set. It must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class CounterArgsDict(TypedDict):
        """
        Counter describes a quantity associated with a device.
        """
        value: pulumi.Input[builtins.str]
        """
        Value defines how much of a certain device counter is available.
        """
elif False:
    CounterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CounterArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[builtins.str]):
        """
        Counter describes a quantity associated with a device.
        :param pulumi.Input[builtins.str] value: Value defines how much of a certain device counter is available.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Value defines how much of a certain device counter is available.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DeviceAllocationConfigurationArgsDict(TypedDict):
        """
        DeviceAllocationConfiguration gets embedded in an AllocationResult.
        """
        source: pulumi.Input[builtins.str]
        """
        Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
elif False:
    DeviceAllocationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceAllocationConfigurationArgs:
    def __init__(__self__, *,
                 source: pulumi.Input[builtins.str],
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        DeviceAllocationConfiguration gets embedded in an AllocationResult.
        :param pulumi.Input[builtins.str] source: Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        :param pulumi.Input['OpaqueDeviceConfigurationArgs'] opaque: Opaque provides driver-specific configuration parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requests: Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        pulumi.set(__self__, "source", source)
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[builtins.str]:
        """
        Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]):
        pulumi.set(self, "opaque", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceAllocationResultArgsDict(TypedDict):
        """
        DeviceAllocationResult is the result of allocating devices.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgsDict']]]]
        """
        This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

        This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        """
        results: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgsDict']]]]
        """
        Results lists all allocated devices.
        """
elif False:
    DeviceAllocationResultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceAllocationResultArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgs']]]] = None,
                 results: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgs']]]] = None):
        """
        DeviceAllocationResult is the result of allocating devices.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgs']]] config: This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.
               
               This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgs']]] results: Results lists all allocated devices.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if results is not None:
            pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgs']]]]:
        """
        This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.

        This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceAllocationConfigurationArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgs']]]]:
        """
        Results lists all allocated devices.
        """
        return pulumi.get(self, "results")

    @results.setter
    def results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestAllocationResultArgs']]]]):
        pulumi.set(self, "results", value)


if not MYPY:
    class DeviceAttributeArgsDict(TypedDict):
        """
        DeviceAttribute must have exactly one field set.
        """
        bool: NotRequired[pulumi.Input[builtins.bool]]
        """
        BoolValue is a true/false value.
        """
        int: NotRequired[pulumi.Input[builtins.int]]
        """
        IntValue is a number.
        """
        string: NotRequired[pulumi.Input[builtins.str]]
        """
        StringValue is a string. Must not be longer than 64 characters.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
elif False:
    DeviceAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceAttributeArgs:
    def __init__(__self__, *,
                 bool: Optional[pulumi.Input[builtins.bool]] = None,
                 int: Optional[pulumi.Input[builtins.int]] = None,
                 string: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        DeviceAttribute must have exactly one field set.
        :param pulumi.Input[builtins.bool] bool: BoolValue is a true/false value.
        :param pulumi.Input[builtins.int] int: IntValue is a number.
        :param pulumi.Input[builtins.str] string: StringValue is a string. Must not be longer than 64 characters.
        :param pulumi.Input[builtins.str] version: VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
        if bool is not None:
            pulumi.set(__self__, "bool", bool)
        if int is not None:
            pulumi.set(__self__, "int", int)
        if string is not None:
            pulumi.set(__self__, "string", string)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bool(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        BoolValue is a true/false value.
        """
        return pulumi.get(self, "bool")

    @bool.setter
    def bool(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "bool", value)

    @property
    @pulumi.getter
    def int(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IntValue is a number.
        """
        return pulumi.get(self, "int")

    @int.setter
    def int(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "int", value)

    @property
    @pulumi.getter
    def string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        StringValue is a string. Must not be longer than 64 characters.
        """
        return pulumi.get(self, "string")

    @string.setter
    def string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "string", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class DeviceCapacityArgsDict(TypedDict):
        """
        DeviceCapacity describes a quantity associated with a device.
        """
        value: pulumi.Input[builtins.str]
        """
        Value defines how much of a certain device capacity is available.
        """
elif False:
    DeviceCapacityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceCapacityArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[builtins.str]):
        """
        DeviceCapacity describes a quantity associated with a device.
        :param pulumi.Input[builtins.str] value: Value defines how much of a certain device capacity is available.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Value defines how much of a certain device capacity is available.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DeviceClaimConfigurationPatchArgsDict(TypedDict):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationPatchArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
elif False:
    DeviceClaimConfigurationPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClaimConfigurationPatchArgs:
    def __init__(__self__, *,
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        :param pulumi.Input['OpaqueDeviceConfigurationPatchArgs'] opaque: Opaque provides driver-specific configuration parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requests: Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']]):
        pulumi.set(self, "opaque", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceClaimConfigurationArgsDict(TypedDict):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
elif False:
    DeviceClaimConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClaimConfigurationArgs:
    def __init__(__self__, *,
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        DeviceClaimConfiguration is used for configuration parameters in DeviceClaim.
        :param pulumi.Input['OpaqueDeviceConfigurationArgs'] opaque: Opaque provides driver-specific configuration parameters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requests: Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]):
        pulumi.set(self, "opaque", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Requests lists the names of requests where the configuration applies. If empty, it applies to all requests.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the configuration applies to all subrequests.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceClaimPatchArgsDict(TypedDict):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgsDict']]]]
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        constraints: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgsDict']]]]
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgsDict']]]]
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
elif False:
    DeviceClaimPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClaimPatchArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgs']]]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgs']]]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgs']]]] = None):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgs']]] config: This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgs']]] constraints: These constraints must be satisfied by the set of devices that get allocated for the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgs']]] requests: Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgs']]]]:
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationPatchArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgs']]]]:
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintPatchArgs']]]]):
        pulumi.set(self, "constraints", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgs']]]]:
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestPatchArgs']]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceClaimArgsDict(TypedDict):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgsDict']]]]
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        constraints: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgsDict']]]]
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgsDict']]]]
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
elif False:
    DeviceClaimArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClaimArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgs']]]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgs']]]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgs']]]] = None):
        """
        DeviceClaim defines how to request devices with a ResourceClaim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgs']]] config: This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgs']]] constraints: These constraints must be satisfied by the set of devices that get allocated for the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgs']]] requests: Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgs']]]]:
        """
        This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClaimConfigurationArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgs']]]]:
        """
        These constraints must be satisfied by the set of devices that get allocated for the claim.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceConstraintArgs']]]]):
        pulumi.set(self, "constraints", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgs']]]]:
        """
        Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceRequestArgs']]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceClassConfigurationPatchArgsDict(TypedDict):
        """
        DeviceClassConfiguration is used in DeviceClass.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationPatchArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
elif False:
    DeviceClassConfigurationPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassConfigurationPatchArgs:
    def __init__(__self__, *,
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']] = None):
        """
        DeviceClassConfiguration is used in DeviceClass.
        :param pulumi.Input['OpaqueDeviceConfigurationPatchArgs'] opaque: Opaque provides driver-specific configuration parameters.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationPatchArgs']]):
        pulumi.set(self, "opaque", value)


if not MYPY:
    class DeviceClassConfigurationArgsDict(TypedDict):
        """
        DeviceClassConfiguration is used in DeviceClass.
        """
        opaque: NotRequired[pulumi.Input['OpaqueDeviceConfigurationArgsDict']]
        """
        Opaque provides driver-specific configuration parameters.
        """
elif False:
    DeviceClassConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassConfigurationArgs:
    def __init__(__self__, *,
                 opaque: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']] = None):
        """
        DeviceClassConfiguration is used in DeviceClass.
        :param pulumi.Input['OpaqueDeviceConfigurationArgs'] opaque: Opaque provides driver-specific configuration parameters.
        """
        if opaque is not None:
            pulumi.set(__self__, "opaque", opaque)

    @property
    @pulumi.getter
    def opaque(self) -> Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]:
        """
        Opaque provides driver-specific configuration parameters.
        """
        return pulumi.get(self, "opaque")

    @opaque.setter
    def opaque(self, value: Optional[pulumi.Input['OpaqueDeviceConfigurationArgs']]):
        pulumi.set(self, "opaque", value)


if not MYPY:
    class DeviceClassSpecPatchArgsDict(TypedDict):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgsDict']]]]
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgsDict']]]]
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
elif False:
    DeviceClassSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassSpecPatchArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgs']]]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]] = None):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgs']]] config: Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
               
               They are passed to the driver, but are not considered while allocating the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]] selectors: Each selector must be satisfied by a device which is claimed via this class.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgs']]]]:
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationPatchArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]:
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]):
        pulumi.set(self, "selectors", value)


if not MYPY:
    class DeviceClassSpecArgsDict(TypedDict):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        """
        config: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgsDict']]]]
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgsDict']]]]
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
elif False:
    DeviceClassSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassSpecArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgs']]]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]] = None):
        """
        DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgs']]] config: Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
               
               They are passed to the driver, but are not considered while allocating the claim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]] selectors: Each selector must be satisfied by a device which is claimed via this class.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgs']]]]:
        """
        Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.

        They are passed to the driver, but are not considered while allocating the claim.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceClassConfigurationArgs']]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]:
        """
        Each selector must be satisfied by a device which is claimed via this class.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)


if not MYPY:
    class DeviceClassArgsDict(TypedDict):
        """
        DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        spec: pulumi.Input['DeviceClassSpecArgsDict']
        """
        Spec defines what can be allocated and how to configure it.

        This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.

        Changing the spec automatically increments the metadata.generation number.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
elif False:
    DeviceClassArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceClassArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['DeviceClassSpecArgs'],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        DeviceClass is a vendor- or admin-provided resource that contains device configuration and selectors. It can be referenced in the device requests of a claim to apply these presets. Cluster scoped.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input['DeviceClassSpecArgs'] spec: Spec defines what can be allocated and how to configure it.
               
               This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.
               
               Changing the spec automatically increments the metadata.generation number.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'DeviceClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['DeviceClassSpecArgs']:
        """
        Spec defines what can be allocated and how to configure it.

        This is mutable. Consumers have to be prepared for classes changing at any time, either because they get updated or replaced. Claim allocations are done once based on whatever was set in classes at the time of allocation.

        Changing the spec automatically increments the metadata.generation number.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['DeviceClassSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class DeviceConstraintPatchArgsDict(TypedDict):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        """
        match_attribute: NotRequired[pulumi.Input[builtins.str]]
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
elif False:
    DeviceConstraintPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceConstraintPatchArgs:
    def __init__(__self__, *,
                 match_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        :param pulumi.Input[builtins.str] match_attribute: MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.
               
               For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.
               
               Must include the domain qualifier.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requests: Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        return pulumi.get(self, "match_attribute")

    @match_attribute.setter
    def match_attribute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match_attribute", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceConstraintArgsDict(TypedDict):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        """
        match_attribute: NotRequired[pulumi.Input[builtins.str]]
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        requests: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
elif False:
    DeviceConstraintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceConstraintArgs:
    def __init__(__self__, *,
                 match_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 requests: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        DeviceConstraint must have exactly one field set besides Requests.
        :param pulumi.Input[builtins.str] match_attribute: MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.
               
               For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.
               
               Must include the domain qualifier.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requests: Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.
               
               References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
        if match_attribute is not None:
            pulumi.set(__self__, "match_attribute", match_attribute)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter(name="matchAttribute")
    def match_attribute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.

        For example, if you specified "dra.example.com/numa" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.

        Must include the domain qualifier.
        """
        return pulumi.get(self, "match_attribute")

    @match_attribute.setter
    def match_attribute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match_attribute", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.

        References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class DeviceCounterConsumptionPatchArgsDict(TypedDict):
        """
        DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.
        """
        counter_set: NotRequired[pulumi.Input[builtins.str]]
        """
        CounterSet is the name of the set from which the counters defined will be consumed.
        """
        counters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['CounterArgsDict']]]]
        """
        Counters defines the counters that will be consumed by the device.

        The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
elif False:
    DeviceCounterConsumptionPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceCounterConsumptionPatchArgs:
    def __init__(__self__, *,
                 counter_set: Optional[pulumi.Input[builtins.str]] = None,
                 counters: Optional[pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]] = None):
        """
        DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.
        :param pulumi.Input[builtins.str] counter_set: CounterSet is the name of the set from which the counters defined will be consumed.
        :param pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]] counters: Counters defines the counters that will be consumed by the device.
               
               The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
        if counter_set is not None:
            pulumi.set(__self__, "counter_set", counter_set)
        if counters is not None:
            pulumi.set(__self__, "counters", counters)

    @property
    @pulumi.getter(name="counterSet")
    def counter_set(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CounterSet is the name of the set from which the counters defined will be consumed.
        """
        return pulumi.get(self, "counter_set")

    @counter_set.setter
    def counter_set(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "counter_set", value)

    @property
    @pulumi.getter
    def counters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]]:
        """
        Counters defines the counters that will be consumed by the device.

        The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
        return pulumi.get(self, "counters")

    @counters.setter
    def counters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]]):
        pulumi.set(self, "counters", value)


if not MYPY:
    class DeviceCounterConsumptionArgsDict(TypedDict):
        """
        DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.
        """
        counter_set: pulumi.Input[builtins.str]
        """
        CounterSet is the name of the set from which the counters defined will be consumed.
        """
        counters: pulumi.Input[Mapping[str, pulumi.Input['CounterArgsDict']]]
        """
        Counters defines the counters that will be consumed by the device.

        The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
elif False:
    DeviceCounterConsumptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceCounterConsumptionArgs:
    def __init__(__self__, *,
                 counter_set: pulumi.Input[builtins.str],
                 counters: pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]):
        """
        DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.
        :param pulumi.Input[builtins.str] counter_set: CounterSet is the name of the set from which the counters defined will be consumed.
        :param pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]] counters: Counters defines the counters that will be consumed by the device.
               
               The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
        pulumi.set(__self__, "counter_set", counter_set)
        pulumi.set(__self__, "counters", counters)

    @property
    @pulumi.getter(name="counterSet")
    def counter_set(self) -> pulumi.Input[builtins.str]:
        """
        CounterSet is the name of the set from which the counters defined will be consumed.
        """
        return pulumi.get(self, "counter_set")

    @counter_set.setter
    def counter_set(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "counter_set", value)

    @property
    @pulumi.getter
    def counters(self) -> pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]:
        """
        Counters defines the counters that will be consumed by the device.

        The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).
        """
        return pulumi.get(self, "counters")

    @counters.setter
    def counters(self, value: pulumi.Input[Mapping[str, pulumi.Input['CounterArgs']]]):
        pulumi.set(self, "counters", value)


if not MYPY:
    class DevicePatchArgsDict(TypedDict):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        """
        basic: NotRequired[pulumi.Input['BasicDevicePatchArgsDict']]
        """
        Basic defines one device instance.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
elif False:
    DevicePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DevicePatchArgs:
    def __init__(__self__, *,
                 basic: Optional[pulumi.Input['BasicDevicePatchArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        :param pulumi.Input['BasicDevicePatchArgs'] basic: Basic defines one device instance.
        :param pulumi.Input[builtins.str] name: Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def basic(self) -> Optional[pulumi.Input['BasicDevicePatchArgs']]:
        """
        Basic defines one device instance.
        """
        return pulumi.get(self, "basic")

    @basic.setter
    def basic(self, value: Optional[pulumi.Input['BasicDevicePatchArgs']]):
        pulumi.set(self, "basic", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DeviceRequestAllocationResultArgsDict(TypedDict):
        """
        DeviceRequestAllocationResult contains the allocation result for one request.
        """
        device: pulumi.Input[builtins.str]
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        driver: pulumi.Input[builtins.str]
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        pool: pulumi.Input[builtins.str]
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        request: pulumi.Input[builtins.str]
        """
        Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.

        Multiple devices may have been allocated per request.
        """
        admin_access: NotRequired[pulumi.Input[builtins.bool]]
        """
        AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        tolerations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgsDict']]]]
        """
        A copy of all tolerations specified in the request at the time when the device got allocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
elif False:
    DeviceRequestAllocationResultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceRequestAllocationResultArgs:
    def __init__(__self__, *,
                 device: pulumi.Input[builtins.str],
                 driver: pulumi.Input[builtins.str],
                 pool: pulumi.Input[builtins.str],
                 request: pulumi.Input[builtins.str],
                 admin_access: Optional[pulumi.Input[builtins.bool]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]]] = None):
        """
        DeviceRequestAllocationResult contains the allocation result for one request.
        :param pulumi.Input[builtins.str] device: Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        :param pulumi.Input[builtins.str] driver: Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param pulumi.Input[builtins.str] pool: This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).
               
               Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        :param pulumi.Input[builtins.str] request: Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.
               
               Multiple devices may have been allocated per request.
        :param pulumi.Input[builtins.bool] admin_access: AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.
               
               This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]] tolerations: A copy of all tolerations specified in the request at the time when the device got allocated.
               
               The maximum number of tolerations is 16.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        pulumi.set(__self__, "request", request)
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter
    def device(self) -> pulumi.Input[builtins.str]:
        """
        Device references one device instance via its name in the driver's resource pool. It must be a DNS label.
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[builtins.str]:
        """
        Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Input[builtins.str]:
        """
        This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).

        Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter
    def request(self) -> pulumi.Input[builtins.str]:
        """
        Request is the name of the request in the claim which caused this device to be allocated. If it references a subrequest in the firstAvailable list on a DeviceRequest, this field must include both the name of the main request and the subrequest using the format <main request>/<subrequest>.

        Multiple devices may have been allocated per request.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        AdminAccess indicates that this device was allocated for administrative access. See the corresponding request field for a definition of mode.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        return pulumi.get(self, "admin_access")

    @admin_access.setter
    def admin_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "admin_access", value)

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]]]:
        """
        A copy of all tolerations specified in the request at the time when the device got allocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]]]):
        pulumi.set(self, "tolerations", value)


if not MYPY:
    class DeviceRequestPatchArgsDict(TypedDict):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.
        """
        admin_access: NotRequired[pulumi.Input[builtins.bool]]
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        allocation_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          At least one device must exist on the node for the allocation to succeed.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        count: NotRequired[pulumi.Input[builtins.int]]
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        device_class_name: NotRequired[pulumi.Input[builtins.str]]
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        first_available: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestPatchArgsDict']]]]
        """
        FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.

        This field may only be set in the entries of DeviceClaim.Requests.

        DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label and unique among all DeviceRequests in a ResourceClaim.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgsDict']]]]
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        tolerations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgsDict']]]]
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
elif False:
    DeviceRequestPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceRequestPatchArgs:
    def __init__(__self__, *,
                 admin_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 count: Optional[pulumi.Input[builtins.int]] = None,
                 device_class_name: Optional[pulumi.Input[builtins.str]] = None,
                 first_available: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestPatchArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgs']]]] = None):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.
        :param pulumi.Input[builtins.bool] admin_access: AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        :param pulumi.Input[builtins.str] allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 At least one device must exist on the node for the allocation to succeed.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param pulumi.Input[builtins.int] count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        :param pulumi.Input[builtins.str] device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
               
               A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestPatchArgs']]] first_available: FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.
               
               This field may only be set in the entries of DeviceClaim.Requests.
               
               DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        :param pulumi.Input[builtins.str] name: Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
               
               Must be a DNS label and unique among all DeviceRequests in a ResourceClaim.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgs']]] tolerations: If specified, the request's tolerations.
               
               Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.
               
               In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.
               
               The maximum number of tolerations is 16.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if first_available is not None:
            pulumi.set(__self__, "first_available", first_available)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        return pulumi.get(self, "admin_access")

    @admin_access.setter
    def admin_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "admin_access", value)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          At least one device must exist on the node for the allocation to succeed.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @allocation_mode.setter
    def allocation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_mode", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @device_class_name.setter
    def device_class_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_class_name", value)

    @property
    @pulumi.getter(name="firstAvailable")
    def first_available(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestPatchArgs']]]]:
        """
        FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.

        This field may only be set in the entries of DeviceClaim.Requests.

        DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        """
        return pulumi.get(self, "first_available")

    @first_available.setter
    def first_available(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestPatchArgs']]]]):
        pulumi.set(self, "first_available", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label and unique among all DeviceRequests in a ResourceClaim.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgs']]]]:
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgs']]]]):
        pulumi.set(self, "tolerations", value)


if not MYPY:
    class DeviceRequestArgsDict(TypedDict):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.
        """
        name: pulumi.Input[builtins.str]
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label and unique among all DeviceRequests in a ResourceClaim.
        """
        admin_access: NotRequired[pulumi.Input[builtins.bool]]
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        allocation_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          At least one device must exist on the node for the allocation to succeed.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        count: NotRequired[pulumi.Input[builtins.int]]
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        device_class_name: NotRequired[pulumi.Input[builtins.str]]
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        first_available: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestArgsDict']]]]
        """
        FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.

        This field may only be set in the entries of DeviceClaim.Requests.

        DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgsDict']]]]
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        tolerations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgsDict']]]]
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
elif False:
    DeviceRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceRequestArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 admin_access: Optional[pulumi.Input[builtins.bool]] = None,
                 allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 count: Optional[pulumi.Input[builtins.int]] = None,
                 device_class_name: Optional[pulumi.Input[builtins.str]] = None,
                 first_available: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestArgs']]]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]]] = None):
        """
        DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.
        :param pulumi.Input[builtins.str] name: Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
               
               Must be a DNS label and unique among all DeviceRequests in a ResourceClaim.
        :param pulumi.Input[builtins.bool] admin_access: AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        :param pulumi.Input[builtins.str] allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This request is for all of the matching devices in a pool.
                 At least one device must exist on the node for the allocation to succeed.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param pulumi.Input[builtins.int] count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        :param pulumi.Input[builtins.str] device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
               
               A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestArgs']]] first_available: FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.
               
               This field may only be set in the entries of DeviceClaim.Requests.
               
               DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]] tolerations: If specified, the request's tolerations.
               
               Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.
               
               In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.
               
               The maximum number of tolerations is 16.
               
               This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        pulumi.set(__self__, "name", name)
        if admin_access is not None:
            pulumi.set(__self__, "admin_access", admin_access)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if first_available is not None:
            pulumi.set(__self__, "first_available", first_available)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.

        Must be a DNS label and unique among all DeviceRequests in a ResourceClaim.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="adminAccess")
    def admin_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.
        """
        return pulumi.get(self, "admin_access")

    @admin_access.setter
    def admin_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "admin_access", value)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This request is for all of the matching devices in a pool.
          At least one device must exist on the node for the allocation to succeed.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @allocation_mode.setter
    def allocation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_mode", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.

        A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @device_class_name.setter
    def device_class_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_class_name", value)

    @property
    @pulumi.getter(name="firstAvailable")
    def first_available(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestArgs']]]]:
        """
        FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.

        This field may only be set in the entries of DeviceClaim.Requests.

        DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.
        """
        return pulumi.get(self, "first_available")

    @first_available.setter
    def first_available(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSubRequestArgs']]]]):
        pulumi.set(self, "first_available", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]]]:
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]]]):
        pulumi.set(self, "tolerations", value)


if not MYPY:
    class DeviceSelectorPatchArgsDict(TypedDict):
        """
        DeviceSelector must have exactly one field set.
        """
        cel: NotRequired[pulumi.Input['CELDeviceSelectorPatchArgsDict']]
        """
        CEL contains a CEL expression for selecting a device.
        """
elif False:
    DeviceSelectorPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceSelectorPatchArgs:
    def __init__(__self__, *,
                 cel: Optional[pulumi.Input['CELDeviceSelectorPatchArgs']] = None):
        """
        DeviceSelector must have exactly one field set.
        :param pulumi.Input['CELDeviceSelectorPatchArgs'] cel: CEL contains a CEL expression for selecting a device.
        """
        if cel is not None:
            pulumi.set(__self__, "cel", cel)

    @property
    @pulumi.getter
    def cel(self) -> Optional[pulumi.Input['CELDeviceSelectorPatchArgs']]:
        """
        CEL contains a CEL expression for selecting a device.
        """
        return pulumi.get(self, "cel")

    @cel.setter
    def cel(self, value: Optional[pulumi.Input['CELDeviceSelectorPatchArgs']]):
        pulumi.set(self, "cel", value)


if not MYPY:
    class DeviceSelectorArgsDict(TypedDict):
        """
        DeviceSelector must have exactly one field set.
        """
        cel: NotRequired[pulumi.Input['CELDeviceSelectorArgsDict']]
        """
        CEL contains a CEL expression for selecting a device.
        """
elif False:
    DeviceSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceSelectorArgs:
    def __init__(__self__, *,
                 cel: Optional[pulumi.Input['CELDeviceSelectorArgs']] = None):
        """
        DeviceSelector must have exactly one field set.
        :param pulumi.Input['CELDeviceSelectorArgs'] cel: CEL contains a CEL expression for selecting a device.
        """
        if cel is not None:
            pulumi.set(__self__, "cel", cel)

    @property
    @pulumi.getter
    def cel(self) -> Optional[pulumi.Input['CELDeviceSelectorArgs']]:
        """
        CEL contains a CEL expression for selecting a device.
        """
        return pulumi.get(self, "cel")

    @cel.setter
    def cel(self, value: Optional[pulumi.Input['CELDeviceSelectorArgs']]):
        pulumi.set(self, "cel", value)


if not MYPY:
    class DeviceSubRequestPatchArgsDict(TypedDict):
        """
        DeviceSubRequest describes a request for device provided in the claim.spec.devices.requests[].firstAvailable array. Each is typically a request for a single resource like a device, but can also ask for several identical devices.

        DeviceSubRequest is similar to Request, but doesn't expose the AdminAccess or FirstAvailable fields, as those can only be set on the top-level request. AdminAccess is not supported for requests with a prioritized list, and recursive FirstAvailable fields are not supported.
        """
        allocation_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this subrequest. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This subrequest is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other subrequests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        count: NotRequired[pulumi.Input[builtins.int]]
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        device_class_name: NotRequired[pulumi.Input[builtins.str]]
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.

        Must be a DNS label.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgsDict']]]]
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this subrequest. All selectors must be satisfied for a device to be considered.
        """
        tolerations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgsDict']]]]
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
elif False:
    DeviceSubRequestPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceSubRequestPatchArgs:
    def __init__(__self__, *,
                 allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 count: Optional[pulumi.Input[builtins.int]] = None,
                 device_class_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgs']]]] = None):
        """
        DeviceSubRequest describes a request for device provided in the claim.spec.devices.requests[].firstAvailable array. Each is typically a request for a single resource like a device, but can also ask for several identical devices.

        DeviceSubRequest is similar to Request, but doesn't expose the AdminAccess or FirstAvailable fields, as those can only be set on the top-level request. AdminAccess is not supported for requests with a prioritized list, and recursive FirstAvailable fields are not supported.
        :param pulumi.Input[builtins.str] allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this subrequest. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This subrequest is for all of the matching devices in a pool.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other subrequests must specify this field.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param pulumi.Input[builtins.int] count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        :param pulumi.Input[builtins.str] device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.
               
               A class is required. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param pulumi.Input[builtins.str] name: Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.
               
               Must be a DNS label.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this subrequest. All selectors must be satisfied for a device to be considered.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgs']]] tolerations: If specified, the request's tolerations.
               
               Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.
               
               In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.
               
               The maximum number of tolerations is 16.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if device_class_name is not None:
            pulumi.set(__self__, "device_class_name", device_class_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this subrequest. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This subrequest is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other subrequests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @allocation_mode.setter
    def allocation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_mode", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @device_class_name.setter
    def device_class_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "device_class_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this subrequest. All selectors must be satisfied for a device to be considered.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorPatchArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgs']]]]:
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationPatchArgs']]]]):
        pulumi.set(self, "tolerations", value)


if not MYPY:
    class DeviceSubRequestArgsDict(TypedDict):
        """
        DeviceSubRequest describes a request for device provided in the claim.spec.devices.requests[].firstAvailable array. Each is typically a request for a single resource like a device, but can also ask for several identical devices.

        DeviceSubRequest is similar to Request, but doesn't expose the AdminAccess or FirstAvailable fields, as those can only be set on the top-level request. AdminAccess is not supported for requests with a prioritized list, and recursive FirstAvailable fields are not supported.
        """
        device_class_name: pulumi.Input[builtins.str]
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        name: pulumi.Input[builtins.str]
        """
        Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.

        Must be a DNS label.
        """
        allocation_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this subrequest. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This subrequest is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other subrequests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        count: NotRequired[pulumi.Input[builtins.int]]
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgsDict']]]]
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this subrequest. All selectors must be satisfied for a device to be considered.
        """
        tolerations: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgsDict']]]]
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
elif False:
    DeviceSubRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceSubRequestArgs:
    def __init__(__self__, *,
                 device_class_name: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 count: Optional[pulumi.Input[builtins.int]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]] = None,
                 tolerations: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]]] = None):
        """
        DeviceSubRequest describes a request for device provided in the claim.spec.devices.requests[].firstAvailable array. Each is typically a request for a single resource like a device, but can also ask for several identical devices.

        DeviceSubRequest is similar to Request, but doesn't expose the AdminAccess or FirstAvailable fields, as those can only be set on the top-level request. AdminAccess is not supported for requests with a prioritized list, and recursive FirstAvailable fields are not supported.
        :param pulumi.Input[builtins.str] device_class_name: DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.
               
               A class is required. Which classes are available depends on the cluster.
               
               Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        :param pulumi.Input[builtins.str] name: Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.
               
               Must be a DNS label.
        :param pulumi.Input[builtins.str] allocation_mode: AllocationMode and its related fields define how devices are allocated to satisfy this subrequest. Supported values are:
               
               - ExactCount: This request is for a specific number of devices.
                 This is the default. The exact number is provided in the
                 count field.
               
               - All: This subrequest is for all of the matching devices in a pool.
                 Allocation will fail if some devices are already allocated,
                 unless adminAccess is requested.
               
               If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other subrequests must specify this field.
               
               More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        :param pulumi.Input[builtins.int] count: Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]] selectors: Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this subrequest. All selectors must be satisfied for a device to be considered.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]] tolerations: If specified, the request's tolerations.
               
               Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.
               
               In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.
               
               The maximum number of tolerations is 16.
               
               This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        pulumi.set(__self__, "device_class_name", device_class_name)
        pulumi.set(__self__, "name", name)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @property
    @pulumi.getter(name="deviceClassName")
    def device_class_name(self) -> pulumi.Input[builtins.str]:
        """
        DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this subrequest.

        A class is required. Which classes are available depends on the cluster.

        Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
        """
        return pulumi.get(self, "device_class_name")

    @device_class_name.setter
    def device_class_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "device_class_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name can be used to reference this subrequest in the list of constraints or the list of configurations for the claim. References must use the format <main request>/<subrequest>.

        Must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AllocationMode and its related fields define how devices are allocated to satisfy this subrequest. Supported values are:

        - ExactCount: This request is for a specific number of devices.
          This is the default. The exact number is provided in the
          count field.

        - All: This subrequest is for all of the matching devices in a pool.
          Allocation will fail if some devices are already allocated,
          unless adminAccess is requested.

        If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other subrequests must specify this field.

        More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
        """
        return pulumi.get(self, "allocation_mode")

    @allocation_mode.setter
    def allocation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_mode", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count is used only when the count mode is "ExactCount". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]:
        """
        Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this subrequest. All selectors must be satisfied for a device to be considered.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter
    def tolerations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]]]:
        """
        If specified, the request's tolerations.

        Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.

        In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.

        The maximum number of tolerations is 16.

        This is an alpha field and requires enabling the DRADeviceTaints feature gate.
        """
        return pulumi.get(self, "tolerations")

    @tolerations.setter
    def tolerations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTolerationArgs']]]]):
        pulumi.set(self, "tolerations", value)


if not MYPY:
    class DeviceTaintPatchArgsDict(TypedDict):
        """
        The device this taint is attached to has the "effect" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.
        """
        effect: NotRequired[pulumi.Input[builtins.str]]
        """
        The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The taint key to be applied to a device. Must be a label name.
        """
        time_added: NotRequired[pulumi.Input[builtins.str]]
        """
        TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The taint value corresponding to the taint key. Must be a label value.
        """
elif False:
    DeviceTaintPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceTaintPatchArgs:
    def __init__(__self__, *,
                 effect: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 time_added: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        The device this taint is attached to has the "effect" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.
        :param pulumi.Input[builtins.str] effect: The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        :param pulumi.Input[builtins.str] key: The taint key to be applied to a device. Must be a label name.
        :param pulumi.Input[builtins.str] time_added: TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        :param pulumi.Input[builtins.str] value: The taint value corresponding to the taint key. Must be a label value.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if time_added is not None:
            pulumi.set(__self__, "time_added", time_added)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The taint key to be applied to a device. Must be a label name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="timeAdded")
    def time_added(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        """
        return pulumi.get(self, "time_added")

    @time_added.setter
    def time_added(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_added", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The taint value corresponding to the taint key. Must be a label value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DeviceTaintArgsDict(TypedDict):
        """
        The device this taint is attached to has the "effect" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.
        """
        effect: pulumi.Input[builtins.str]
        """
        The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        """
        key: pulumi.Input[builtins.str]
        """
        The taint key to be applied to a device. Must be a label name.
        """
        time_added: NotRequired[pulumi.Input[builtins.str]]
        """
        TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The taint value corresponding to the taint key. Must be a label value.
        """
elif False:
    DeviceTaintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceTaintArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str],
                 time_added: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        The device this taint is attached to has the "effect" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.
        :param pulumi.Input[builtins.str] effect: The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        :param pulumi.Input[builtins.str] key: The taint key to be applied to a device. Must be a label name.
        :param pulumi.Input[builtins.str] time_added: TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        :param pulumi.Input[builtins.str] value: The taint value corresponding to the taint key. Must be a label value.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        if time_added is not None:
            pulumi.set(__self__, "time_added", time_added)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[builtins.str]:
        """
        The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The taint key to be applied to a device. Must be a label name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="timeAdded")
    def time_added(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.
        """
        return pulumi.get(self, "time_added")

    @time_added.setter
    def time_added(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_added", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The taint value corresponding to the taint key. Must be a label value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DeviceTolerationPatchArgsDict(TypedDict):
        """
        The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
        """
        effect: NotRequired[pulumi.Input[builtins.str]]
        """
        Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        """
        operator: NotRequired[pulumi.Input[builtins.str]]
        """
        Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        """
        toleration_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
elif False:
    DeviceTolerationPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceTolerationPatchArgs:
    def __init__(__self__, *,
                 effect: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 operator: Optional[pulumi.Input[builtins.str]] = None,
                 toleration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
        :param pulumi.Input[builtins.str] effect: Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        :param pulumi.Input[builtins.str] key: Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        :param pulumi.Input[builtins.str] operator: Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        :param pulumi.Input[builtins.int] toleration_seconds: TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        :param pulumi.Input[builtins.str] value: Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if toleration_seconds is not None:
            pulumi.set(__self__, "toleration_seconds", toleration_seconds)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="tolerationSeconds")
    def toleration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        """
        return pulumi.get(self, "toleration_seconds")

    @toleration_seconds.setter
    def toleration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "toleration_seconds", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DeviceTolerationArgsDict(TypedDict):
        """
        The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
        """
        effect: NotRequired[pulumi.Input[builtins.str]]
        """
        Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        """
        operator: NotRequired[pulumi.Input[builtins.str]]
        """
        Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        """
        toleration_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
elif False:
    DeviceTolerationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceTolerationArgs:
    def __init__(__self__, *,
                 effect: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 operator: Optional[pulumi.Input[builtins.str]] = None,
                 toleration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
        :param pulumi.Input[builtins.str] effect: Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        :param pulumi.Input[builtins.str] key: Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        :param pulumi.Input[builtins.str] operator: Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        :param pulumi.Input[builtins.int] toleration_seconds: TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        :param pulumi.Input[builtins.str] value: Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if toleration_seconds is not None:
            pulumi.set(__self__, "toleration_seconds", toleration_seconds)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="tolerationSeconds")
    def toleration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.
        """
        return pulumi.get(self, "toleration_seconds")

    @toleration_seconds.setter
    def toleration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "toleration_seconds", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DeviceArgsDict(TypedDict):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        """
        name: pulumi.Input[builtins.str]
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        basic: NotRequired[pulumi.Input['BasicDeviceArgsDict']]
        """
        Basic defines one device instance.
        """
elif False:
    DeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 basic: Optional[pulumi.Input['BasicDeviceArgs']] = None):
        """
        Device represents one individual hardware instance that can be selected based on its attributes. Besides the name, exactly one field must be set.
        :param pulumi.Input[builtins.str] name: Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        :param pulumi.Input['BasicDeviceArgs'] basic: Basic defines one device instance.
        """
        pulumi.set(__self__, "name", name)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name is unique identifier among all devices managed by the driver in the pool. It must be a DNS label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def basic(self) -> Optional[pulumi.Input['BasicDeviceArgs']]:
        """
        Basic defines one device instance.
        """
        return pulumi.get(self, "basic")

    @basic.setter
    def basic(self, value: Optional[pulumi.Input['BasicDeviceArgs']]):
        pulumi.set(self, "basic", value)


if not MYPY:
    class NetworkDeviceDataArgsDict(TypedDict):
        """
        NetworkDeviceData provides network-related details for the allocated device. This information may be filled by drivers or other components to configure or identify the device within a network context.
        """
        hardware_address: NotRequired[pulumi.Input[builtins.str]]
        """
        HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.

        Must not be longer than 128 characters.
        """
        interface_name: NotRequired[pulumi.Input[builtins.str]]
        """
        InterfaceName specifies the name of the network interface associated with the allocated device. This might be the name of a physical or virtual network interface being configured in the pod.

        Must not be longer than 256 characters.
        """
        ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        IPs lists the network addresses assigned to the device's network interface. This can include both IPv4 and IPv6 addresses. The IPs are in the CIDR notation, which includes both the address and the associated subnet mask. e.g.: "192.0.2.5/24" for IPv4 and "2001:db8::5/64" for IPv6.

        Must not contain more than 16 entries.
        """
elif False:
    NetworkDeviceDataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkDeviceDataArgs:
    def __init__(__self__, *,
                 hardware_address: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        NetworkDeviceData provides network-related details for the allocated device. This information may be filled by drivers or other components to configure or identify the device within a network context.
        :param pulumi.Input[builtins.str] hardware_address: HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.
               
               Must not be longer than 128 characters.
        :param pulumi.Input[builtins.str] interface_name: InterfaceName specifies the name of the network interface associated with the allocated device. This might be the name of a physical or virtual network interface being configured in the pod.
               
               Must not be longer than 256 characters.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ips: IPs lists the network addresses assigned to the device's network interface. This can include both IPv4 and IPv6 addresses. The IPs are in the CIDR notation, which includes both the address and the associated subnet mask. e.g.: "192.0.2.5/24" for IPv4 and "2001:db8::5/64" for IPv6.
               
               Must not contain more than 16 entries.
        """
        if hardware_address is not None:
            pulumi.set(__self__, "hardware_address", hardware_address)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)

    @property
    @pulumi.getter(name="hardwareAddress")
    def hardware_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.

        Must not be longer than 128 characters.
        """
        return pulumi.get(self, "hardware_address")

    @hardware_address.setter
    def hardware_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hardware_address", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        InterfaceName specifies the name of the network interface associated with the allocated device. This might be the name of a physical or virtual network interface being configured in the pod.

        Must not be longer than 256 characters.
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        IPs lists the network addresses assigned to the device's network interface. This can include both IPv4 and IPv6 addresses. The IPs are in the CIDR notation, which includes both the address and the associated subnet mask. e.g.: "192.0.2.5/24" for IPv4 and "2001:db8::5/64" for IPv6.

        Must not contain more than 16 entries.
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ips", value)


if not MYPY:
    class OpaqueDeviceConfigurationPatchArgsDict(TypedDict):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        """
        driver: NotRequired[pulumi.Input[builtins.str]]
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        parameters: NotRequired[Any]
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
elif False:
    OpaqueDeviceConfigurationPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OpaqueDeviceConfigurationPatchArgs:
    def __init__(__self__, *,
                 driver: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[Any] = None):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        :param pulumi.Input[builtins.str] driver: Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
               
               An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param Any parameters: Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
               
               The length of the raw data must be smaller or equal to 10 Ki.
        """
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[Any]):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class OpaqueDeviceConfigurationArgsDict(TypedDict):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        """
        driver: pulumi.Input[builtins.str]
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        parameters: Any
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
elif False:
    OpaqueDeviceConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OpaqueDeviceConfigurationArgs:
    def __init__(__self__, *,
                 driver: pulumi.Input[builtins.str],
                 parameters: Any):
        """
        OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
        :param pulumi.Input[builtins.str] driver: Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
               
               An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        :param Any parameters: Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.
               
               The length of the raw data must be smaller or equal to 10 Ki.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[builtins.str]:
        """
        Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.

        An admission policy provided by the driver developer could use this to decide whether it needs to validate them.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter
    def parameters(self) -> Any:
        """
        Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version ("kind" + "apiVersion" for Kubernetes types), with conversion between different versions.

        The length of the raw data must be smaller or equal to 10 Ki.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Any):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class ResourceClaimConsumerReferenceArgsDict(TypedDict):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        """
        name: pulumi.Input[builtins.str]
        """
        Name is the name of resource being referenced.
        """
        resource: pulumi.Input[builtins.str]
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        uid: pulumi.Input[builtins.str]
        """
        UID identifies exactly one incarnation of the resource.
        """
        api_group: NotRequired[pulumi.Input[builtins.str]]
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
elif False:
    ResourceClaimConsumerReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimConsumerReferenceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 resource: pulumi.Input[builtins.str],
                 uid: pulumi.Input[builtins.str],
                 api_group: Optional[pulumi.Input[builtins.str]] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param pulumi.Input[builtins.str] name: Name is the name of resource being referenced.
        :param pulumi.Input[builtins.str] resource: Resource is the type of resource being referenced, for example "pods".
        :param pulumi.Input[builtins.str] uid: UID identifies exactly one incarnation of the resource.
        :param pulumi.Input[builtins.str] api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "uid", uid)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[builtins.str]:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[builtins.str]:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_group", value)


if not MYPY:
    class ResourceClaimSpecPatchArgsDict(TypedDict):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        """
        devices: NotRequired[pulumi.Input['DeviceClaimPatchArgsDict']]
        """
        Devices defines how to request devices.
        """
elif False:
    ResourceClaimSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimSpecPatchArgs:
    def __init__(__self__, *,
                 devices: Optional[pulumi.Input['DeviceClaimPatchArgs']] = None):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        :param pulumi.Input['DeviceClaimPatchArgs'] devices: Devices defines how to request devices.
        """
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input['DeviceClaimPatchArgs']]:
        """
        Devices defines how to request devices.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input['DeviceClaimPatchArgs']]):
        pulumi.set(self, "devices", value)


if not MYPY:
    class ResourceClaimSpecArgsDict(TypedDict):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        """
        devices: NotRequired[pulumi.Input['DeviceClaimArgsDict']]
        """
        Devices defines how to request devices.
        """
elif False:
    ResourceClaimSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimSpecArgs:
    def __init__(__self__, *,
                 devices: Optional[pulumi.Input['DeviceClaimArgs']] = None):
        """
        ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.
        :param pulumi.Input['DeviceClaimArgs'] devices: Devices defines how to request devices.
        """
        if devices is not None:
            pulumi.set(__self__, "devices", devices)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input['DeviceClaimArgs']]:
        """
        Devices defines how to request devices.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input['DeviceClaimArgs']]):
        pulumi.set(self, "devices", value)


if not MYPY:
    class ResourceClaimStatusArgsDict(TypedDict):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
        """
        allocation: NotRequired[pulumi.Input['AllocationResultArgsDict']]
        """
        Allocation is set once the claim has been allocated successfully.
        """
        devices: NotRequired[pulumi.Input[Sequence[pulumi.Input['AllocatedDeviceStatusArgsDict']]]]
        """
        Devices contains the status of each device allocated for this claim, as reported by the driver. This can include driver-specific information. Entries are owned by their respective drivers.
        """
        reserved_for: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgsDict']]]]
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

        In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

        Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

        There can be at most 256 such reservations. This may get increased in the future, but not reduced.
        """
elif False:
    ResourceClaimStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimStatusArgs:
    def __init__(__self__, *,
                 allocation: Optional[pulumi.Input['AllocationResultArgs']] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['AllocatedDeviceStatusArgs']]]] = None,
                 reserved_for: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]]] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
        :param pulumi.Input['AllocationResultArgs'] allocation: Allocation is set once the claim has been allocated successfully.
        :param pulumi.Input[Sequence[pulumi.Input['AllocatedDeviceStatusArgs']]] devices: Devices contains the status of each device allocated for this claim, as reported by the driver. This can include driver-specific information. Entries are owned by their respective drivers.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
               
               In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
               
               Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
               
               There can be at most 256 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional[pulumi.Input['AllocationResultArgs']]:
        """
        Allocation is set once the claim has been allocated successfully.
        """
        return pulumi.get(self, "allocation")

    @allocation.setter
    def allocation(self, value: Optional[pulumi.Input['AllocationResultArgs']]):
        pulumi.set(self, "allocation", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AllocatedDeviceStatusArgs']]]]:
        """
        Devices contains the status of each device allocated for this claim, as reported by the driver. This can include driver-specific information. Entries are owned by their respective drivers.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AllocatedDeviceStatusArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]]]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.

        In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.

        Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.

        There can be at most 256 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")

    @reserved_for.setter
    def reserved_for(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceClaimConsumerReferenceArgs']]]]):
        pulumi.set(self, "reserved_for", value)


if not MYPY:
    class ResourceClaimTemplateSpecPatchArgsDict(TypedDict):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaPatchArgsDict']]
        """
        ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        """
        spec: NotRequired[pulumi.Input['ResourceClaimSpecPatchArgsDict']]
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
elif False:
    ResourceClaimTemplateSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimTemplateSpecPatchArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']] = None,
                 spec: Optional[pulumi.Input['ResourceClaimSpecPatchArgs']] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param pulumi.Input['_meta.v1.ObjectMetaPatchArgs'] metadata: ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        :param pulumi.Input['ResourceClaimSpecPatchArgs'] spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']]:
        """
        ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaPatchArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['ResourceClaimSpecPatchArgs']]:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['ResourceClaimSpecPatchArgs']]):
        pulumi.set(self, "spec", value)


if not MYPY:
    class ResourceClaimTemplateSpecArgsDict(TypedDict):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        """
        spec: pulumi.Input['ResourceClaimSpecArgsDict']
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        """
elif False:
    ResourceClaimTemplateSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimTemplateSpecArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceClaimSpecArgs'],
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param pulumi.Input['ResourceClaimSpecArgs'] spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        """
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceClaimSpecArgs']:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceClaimSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        ObjectMeta may contain labels and annotations that will be copied into the ResourceClaim when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class ResourceClaimTemplateArgsDict(TypedDict):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        spec: pulumi.Input['ResourceClaimTemplateSpecArgsDict']
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
elif False:
    ResourceClaimTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimTemplateArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceClaimTemplateSpecArgs'],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input['ResourceClaimTemplateSpecArgs'] spec: Describes the ResourceClaim that is to be generated.
               
               This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaimTemplate')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceClaimTemplateSpecArgs']:
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceClaimTemplateSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class ResourceClaimArgsDict(TypedDict):
        """
        ResourceClaim describes a request for access to resources in the cluster, for use by workloads. For example, if a workload needs an accelerator device with specific properties, this is how that request is expressed. The status stanza tracks whether this claim has been satisfied and what specific resources have been allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        spec: pulumi.Input['ResourceClaimSpecArgsDict']
        """
        Spec describes what is being requested and how to configure it. The spec is immutable.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
        status: NotRequired[pulumi.Input['ResourceClaimStatusArgsDict']]
        """
        Status describes whether the claim is ready to use and what has been allocated.
        """
elif False:
    ResourceClaimArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceClaimArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceClaimSpecArgs'],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 status: Optional[pulumi.Input['ResourceClaimStatusArgs']] = None):
        """
        ResourceClaim describes a request for access to resources in the cluster, for use by workloads. For example, if a workload needs an accelerator device with specific properties, this is how that request is expressed. The status stanza tracks whether this claim has been satisfied and what specific resources have been allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input['ResourceClaimSpecArgs'] spec: Spec describes what is being requested and how to configure it. The spec is immutable.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        :param pulumi.Input['ResourceClaimStatusArgs'] status: Status describes whether the claim is ready to use and what has been allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceClaimSpecArgs']:
        """
        Spec describes what is being requested and how to configure it. The spec is immutable.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceClaimSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['ResourceClaimStatusArgs']]:
        """
        Status describes whether the claim is ready to use and what has been allocated.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['ResourceClaimStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ResourcePoolPatchArgsDict(TypedDict):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        """
        generation: NotRequired[pulumi.Input[builtins.int]]
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        resource_slice_count: NotRequired[pulumi.Input[builtins.int]]
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
elif False:
    ResourcePoolPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourcePoolPatchArgs:
    def __init__(__self__, *,
                 generation: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_slice_count: Optional[pulumi.Input[builtins.int]] = None):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        :param pulumi.Input[builtins.int] generation: Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
               
               Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        :param pulumi.Input[builtins.str] name: Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
               
               It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        :param pulumi.Input[builtins.int] resource_slice_count: ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
               
               Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_slice_count is not None:
            pulumi.set(__self__, "resource_slice_count", resource_slice_count)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceSliceCount")
    def resource_slice_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        return pulumi.get(self, "resource_slice_count")

    @resource_slice_count.setter
    def resource_slice_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "resource_slice_count", value)


if not MYPY:
    class ResourcePoolArgsDict(TypedDict):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        """
        generation: pulumi.Input[builtins.int]
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        name: pulumi.Input[builtins.str]
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        resource_slice_count: pulumi.Input[builtins.int]
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
elif False:
    ResourcePoolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourcePoolArgs:
    def __init__(__self__, *,
                 generation: pulumi.Input[builtins.int],
                 name: pulumi.Input[builtins.str],
                 resource_slice_count: pulumi.Input[builtins.int]):
        """
        ResourcePool describes the pool that ResourceSlices belong to.
        :param pulumi.Input[builtins.int] generation: Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
               
               Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        :param pulumi.Input[builtins.str] name: Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
               
               It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        :param pulumi.Input[builtins.int] resource_slice_count: ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
               
               Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_slice_count", resource_slice_count)

    @property
    @pulumi.getter
    def generation(self) -> pulumi.Input[builtins.int]:
        """
        Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.

        Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.

        It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceSliceCount")
    def resource_slice_count(self) -> pulumi.Input[builtins.int]:
        """
        ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.

        Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
        """
        return pulumi.get(self, "resource_slice_count")

    @resource_slice_count.setter
    def resource_slice_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "resource_slice_count", value)


if not MYPY:
    class ResourceSliceSpecPatchArgsDict(TypedDict):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        """
        all_nodes: NotRequired[pulumi.Input[builtins.bool]]
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        devices: NotRequired[pulumi.Input[Sequence[pulumi.Input['DevicePatchArgsDict']]]]
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        driver: NotRequired[pulumi.Input[builtins.str]]
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        node_name: NotRequired[pulumi.Input[builtins.str]]
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        """
        node_selector: NotRequired[pulumi.Input['_core.v1.NodeSelectorPatchArgsDict']]
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        per_device_node_selection: NotRequired[pulumi.Input[builtins.bool]]
        """
        PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        pool: NotRequired[pulumi.Input['ResourcePoolPatchArgsDict']]
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        shared_counters: NotRequired[pulumi.Input[Sequence[pulumi.Input['CounterSetPatchArgsDict']]]]
        """
        SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.

        The names of the SharedCounters must be unique in the ResourceSlice.

        The maximum number of SharedCounters is 32.
        """
elif False:
    ResourceSliceSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSliceSpecPatchArgs:
    def __init__(__self__, *,
                 all_nodes: Optional[pulumi.Input[builtins.bool]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['DevicePatchArgs']]]] = None,
                 driver: Optional[pulumi.Input[builtins.str]] = None,
                 node_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_selector: Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']] = None,
                 per_device_node_selection: Optional[pulumi.Input[builtins.bool]] = None,
                 pool: Optional[pulumi.Input['ResourcePoolPatchArgs']] = None,
                 shared_counters: Optional[pulumi.Input[Sequence[pulumi.Input['CounterSetPatchArgs']]]] = None):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        :param pulumi.Input[builtins.bool] all_nodes: AllNodes indicates that all nodes have access to the resources in the pool.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param pulumi.Input[Sequence[pulumi.Input['DevicePatchArgs']]] devices: Devices lists some or all of the devices in this pool.
               
               Must not have more than 128 entries.
        :param pulumi.Input[builtins.str] driver: Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        :param pulumi.Input[builtins.str] node_name: NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
               
               This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        :param pulumi.Input['_core.v1.NodeSelectorPatchArgs'] node_selector: NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
               
               Must use exactly one term.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param pulumi.Input[builtins.bool] per_device_node_selection: PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param pulumi.Input['ResourcePoolPatchArgs'] pool: Pool describes the pool that this ResourceSlice belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['CounterSetPatchArgs']]] shared_counters: SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.
               
               The names of the SharedCounters must be unique in the ResourceSlice.
               
               The maximum number of SharedCounters is 32.
        """
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if per_device_node_selection is not None:
            pulumi.set(__self__, "per_device_node_selection", per_device_node_selection)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if shared_counters is not None:
            pulumi.set(__self__, "shared_counters", shared_counters)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "all_nodes")

    @all_nodes.setter
    def all_nodes(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "all_nodes", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DevicePatchArgs']]]]:
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DevicePatchArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']]:
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorPatchArgs']]):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter(name="perDeviceNodeSelection")
    def per_device_node_selection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "per_device_node_selection")

    @per_device_node_selection.setter
    def per_device_node_selection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "per_device_node_selection", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input['ResourcePoolPatchArgs']]:
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input['ResourcePoolPatchArgs']]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter(name="sharedCounters")
    def shared_counters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CounterSetPatchArgs']]]]:
        """
        SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.

        The names of the SharedCounters must be unique in the ResourceSlice.

        The maximum number of SharedCounters is 32.
        """
        return pulumi.get(self, "shared_counters")

    @shared_counters.setter
    def shared_counters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CounterSetPatchArgs']]]]):
        pulumi.set(self, "shared_counters", value)


if not MYPY:
    class ResourceSliceSpecArgsDict(TypedDict):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        """
        driver: pulumi.Input[builtins.str]
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        pool: pulumi.Input['ResourcePoolArgsDict']
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        all_nodes: NotRequired[pulumi.Input[builtins.bool]]
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        devices: NotRequired[pulumi.Input[Sequence[pulumi.Input['DeviceArgsDict']]]]
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        node_name: NotRequired[pulumi.Input[builtins.str]]
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        """
        node_selector: NotRequired[pulumi.Input['_core.v1.NodeSelectorArgsDict']]
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        per_device_node_selection: NotRequired[pulumi.Input[builtins.bool]]
        """
        PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        shared_counters: NotRequired[pulumi.Input[Sequence[pulumi.Input['CounterSetArgsDict']]]]
        """
        SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.

        The names of the SharedCounters must be unique in the ResourceSlice.

        The maximum number of SharedCounters is 32.
        """
elif False:
    ResourceSliceSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSliceSpecArgs:
    def __init__(__self__, *,
                 driver: pulumi.Input[builtins.str],
                 pool: pulumi.Input['ResourcePoolArgs'],
                 all_nodes: Optional[pulumi.Input[builtins.bool]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceArgs']]]] = None,
                 node_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_selector: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']] = None,
                 per_device_node_selection: Optional[pulumi.Input[builtins.bool]] = None,
                 shared_counters: Optional[pulumi.Input[Sequence[pulumi.Input['CounterSetArgs']]]] = None):
        """
        ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
        :param pulumi.Input[builtins.str] driver: Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
               
               Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        :param pulumi.Input['ResourcePoolArgs'] pool: Pool describes the pool that this ResourceSlice belongs to.
        :param pulumi.Input[builtins.bool] all_nodes: AllNodes indicates that all nodes have access to the resources in the pool.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceArgs']]] devices: Devices lists some or all of the devices in this pool.
               
               Must not have more than 128 entries.
        :param pulumi.Input[builtins.str] node_name: NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
               
               This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        :param pulumi.Input['_core.v1.NodeSelectorArgs'] node_selector: NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
               
               Must use exactly one term.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param pulumi.Input[builtins.bool] per_device_node_selection: PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.
               
               Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        :param pulumi.Input[Sequence[pulumi.Input['CounterSetArgs']]] shared_counters: SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.
               
               The names of the SharedCounters must be unique in the ResourceSlice.
               
               The maximum number of SharedCounters is 32.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "pool", pool)
        if all_nodes is not None:
            pulumi.set(__self__, "all_nodes", all_nodes)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if per_device_node_selection is not None:
            pulumi.set(__self__, "per_device_node_selection", per_device_node_selection)
        if shared_counters is not None:
            pulumi.set(__self__, "shared_counters", shared_counters)

    @property
    @pulumi.getter
    def driver(self) -> pulumi.Input[builtins.str]:
        """
        Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.

        Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "driver", value)

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Input['ResourcePoolArgs']:
        """
        Pool describes the pool that this ResourceSlice belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: pulumi.Input['ResourcePoolArgs']):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter(name="allNodes")
    def all_nodes(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        AllNodes indicates that all nodes have access to the resources in the pool.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "all_nodes")

    @all_nodes.setter
    def all_nodes(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "all_nodes", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceArgs']]]]:
        """
        Devices lists some or all of the devices in this pool.

        Must not have more than 128 entries.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.

        This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]:
        """
        NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.

        Must use exactly one term.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input['_core.v1.NodeSelectorArgs']]):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter(name="perDeviceNodeSelection")
    def per_device_node_selection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.

        Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.
        """
        return pulumi.get(self, "per_device_node_selection")

    @per_device_node_selection.setter
    def per_device_node_selection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "per_device_node_selection", value)

    @property
    @pulumi.getter(name="sharedCounters")
    def shared_counters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CounterSetArgs']]]]:
        """
        SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.

        The names of the SharedCounters must be unique in the ResourceSlice.

        The maximum number of SharedCounters is 32.
        """
        return pulumi.get(self, "shared_counters")

    @shared_counters.setter
    def shared_counters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CounterSetArgs']]]]):
        pulumi.set(self, "shared_counters", value)


if not MYPY:
    class ResourceSliceArgsDict(TypedDict):
        """
        ResourceSlice represents one or more resources in a pool of similar resources, managed by a common driver. A pool may span more than one ResourceSlice, and exactly how many ResourceSlices comprise a pool is determined by the driver.

        At the moment, the only supported resources are devices with attributes and capacities. Each device in a given pool, regardless of how many ResourceSlices, must have a unique name. The ResourceSlice in which a device gets published may change over time. The unique identifier for a device is the tuple <driver name>, <pool name>, <device name>.

        Whenever a driver needs to update a pool, it increments the pool.Spec.Pool.Generation number and updates all ResourceSlices with that new number and new resource definitions. A consumer must only use ResourceSlices with the highest generation number and ignore all others.

        When allocating all resources in a pool matching certain criteria or when looking for the best solution among several different alternatives, a consumer should check the number of ResourceSlices in a pool (included in each ResourceSlice) to determine whether its view of a pool is complete and if not, should wait until the driver has completed updating the pool.

        For resources that are not local to a node, the node name is not set. Instead, the driver may use a node selector to specify where the devices are available.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        """
        spec: pulumi.Input['ResourceSliceSpecArgsDict']
        """
        Contains the information published by the driver.

        Changing the spec automatically increments the metadata.generation number.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata
        """
elif False:
    ResourceSliceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSliceArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['ResourceSliceSpecArgs'],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None):
        """
        ResourceSlice represents one or more resources in a pool of similar resources, managed by a common driver. A pool may span more than one ResourceSlice, and exactly how many ResourceSlices comprise a pool is determined by the driver.

        At the moment, the only supported resources are devices with attributes and capacities. Each device in a given pool, regardless of how many ResourceSlices, must have a unique name. The ResourceSlice in which a device gets published may change over time. The unique identifier for a device is the tuple <driver name>, <pool name>, <device name>.

        Whenever a driver needs to update a pool, it increments the pool.Spec.Pool.Generation number and updates all ResourceSlices with that new number and new resource definitions. A consumer must only use ResourceSlices with the highest generation number and ignore all others.

        When allocating all resources in a pool matching certain criteria or when looking for the best solution among several different alternatives, a consumer should check the number of ResourceSlices in a pool (included in each ResourceSlice) to determine whether its view of a pool is complete and if not, should wait until the driver has completed updating the pool.

        For resources that are not local to a node, the node name is not set. Instead, the driver may use a node selector to specify where the devices are available.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param pulumi.Input['ResourceSliceSpecArgs'] spec: Contains the information published by the driver.
               
               Changing the spec automatically increments the metadata.generation number.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceSlice')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['ResourceSliceSpecArgs']:
        """
        Contains the information published by the driver.

        Changing the spec automatically increments the metadata.generation number.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['ResourceSliceSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)


