# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'VolumeAttachmentSourcePatchArgs',
    'VolumeAttachmentSourcePatchArgsDict',
    'VolumeAttachmentSourceArgs',
    'VolumeAttachmentSourceArgsDict',
    'VolumeAttachmentSpecPatchArgs',
    'VolumeAttachmentSpecPatchArgsDict',
    'VolumeAttachmentSpecArgs',
    'VolumeAttachmentSpecArgsDict',
    'VolumeAttachmentStatusArgs',
    'VolumeAttachmentStatusArgsDict',
    'VolumeAttachmentArgs',
    'VolumeAttachmentArgsDict',
    'VolumeAttributesClassArgs',
    'VolumeAttributesClassArgsDict',
    'VolumeErrorArgs',
    'VolumeErrorArgsDict',
]

MYPY = False

if not MYPY:
    class VolumeAttachmentSourcePatchArgsDict(TypedDict):
        """
        VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
        """
        inline_volume_spec: NotRequired[pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgsDict']]
        """
        inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is alpha-level and is only honored by servers that enabled the CSIMigration feature.
        """
        persistent_volume_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the persistent volume to attach.
        """
elif False:
    VolumeAttachmentSourcePatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentSourcePatchArgs:
    def __init__(__self__, *,
                 inline_volume_spec: Optional[pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgs']] = None,
                 persistent_volume_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
        :param pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgs'] inline_volume_spec: inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is alpha-level and is only honored by servers that enabled the CSIMigration feature.
        :param pulumi.Input[builtins.str] persistent_volume_name: Name of the persistent volume to attach.
        """
        if inline_volume_spec is not None:
            pulumi.set(__self__, "inline_volume_spec", inline_volume_spec)
        if persistent_volume_name is not None:
            pulumi.set(__self__, "persistent_volume_name", persistent_volume_name)

    @property
    @pulumi.getter(name="inlineVolumeSpec")
    def inline_volume_spec(self) -> Optional[pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgs']]:
        """
        inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is alpha-level and is only honored by servers that enabled the CSIMigration feature.
        """
        return pulumi.get(self, "inline_volume_spec")

    @inline_volume_spec.setter
    def inline_volume_spec(self, value: Optional[pulumi.Input['_core.v1.PersistentVolumeSpecPatchArgs']]):
        pulumi.set(self, "inline_volume_spec", value)

    @property
    @pulumi.getter(name="persistentVolumeName")
    def persistent_volume_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the persistent volume to attach.
        """
        return pulumi.get(self, "persistent_volume_name")

    @persistent_volume_name.setter
    def persistent_volume_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "persistent_volume_name", value)


if not MYPY:
    class VolumeAttachmentSourceArgsDict(TypedDict):
        """
        VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
        """
        inline_volume_spec: NotRequired[pulumi.Input['_core.v1.PersistentVolumeSpecArgsDict']]
        """
        inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is alpha-level and is only honored by servers that enabled the CSIMigration feature.
        """
        persistent_volume_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the persistent volume to attach.
        """
elif False:
    VolumeAttachmentSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentSourceArgs:
    def __init__(__self__, *,
                 inline_volume_spec: Optional[pulumi.Input['_core.v1.PersistentVolumeSpecArgs']] = None,
                 persistent_volume_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
        :param pulumi.Input['_core.v1.PersistentVolumeSpecArgs'] inline_volume_spec: inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is alpha-level and is only honored by servers that enabled the CSIMigration feature.
        :param pulumi.Input[builtins.str] persistent_volume_name: Name of the persistent volume to attach.
        """
        if inline_volume_spec is not None:
            pulumi.set(__self__, "inline_volume_spec", inline_volume_spec)
        if persistent_volume_name is not None:
            pulumi.set(__self__, "persistent_volume_name", persistent_volume_name)

    @property
    @pulumi.getter(name="inlineVolumeSpec")
    def inline_volume_spec(self) -> Optional[pulumi.Input['_core.v1.PersistentVolumeSpecArgs']]:
        """
        inlineVolumeSpec contains all the information necessary to attach a persistent volume defined by a pod's inline VolumeSource. This field is populated only for the CSIMigration feature. It contains translated fields from a pod's inline VolumeSource to a PersistentVolumeSpec. This field is alpha-level and is only honored by servers that enabled the CSIMigration feature.
        """
        return pulumi.get(self, "inline_volume_spec")

    @inline_volume_spec.setter
    def inline_volume_spec(self, value: Optional[pulumi.Input['_core.v1.PersistentVolumeSpecArgs']]):
        pulumi.set(self, "inline_volume_spec", value)

    @property
    @pulumi.getter(name="persistentVolumeName")
    def persistent_volume_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the persistent volume to attach.
        """
        return pulumi.get(self, "persistent_volume_name")

    @persistent_volume_name.setter
    def persistent_volume_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "persistent_volume_name", value)


if not MYPY:
    class VolumeAttachmentSpecPatchArgsDict(TypedDict):
        """
        VolumeAttachmentSpec is the specification of a VolumeAttachment request.
        """
        attacher: NotRequired[pulumi.Input[builtins.str]]
        """
        Attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        """
        node_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The node that the volume should be attached to.
        """
        source: NotRequired[pulumi.Input['VolumeAttachmentSourcePatchArgsDict']]
        """
        Source represents the volume that should be attached.
        """
elif False:
    VolumeAttachmentSpecPatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentSpecPatchArgs:
    def __init__(__self__, *,
                 attacher: Optional[pulumi.Input[builtins.str]] = None,
                 node_name: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input['VolumeAttachmentSourcePatchArgs']] = None):
        """
        VolumeAttachmentSpec is the specification of a VolumeAttachment request.
        :param pulumi.Input[builtins.str] attacher: Attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        :param pulumi.Input[builtins.str] node_name: The node that the volume should be attached to.
        :param pulumi.Input['VolumeAttachmentSourcePatchArgs'] source: Source represents the volume that should be attached.
        """
        if attacher is not None:
            pulumi.set(__self__, "attacher", attacher)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def attacher(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        """
        return pulumi.get(self, "attacher")

    @attacher.setter
    def attacher(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attacher", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The node that the volume should be attached to.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['VolumeAttachmentSourcePatchArgs']]:
        """
        Source represents the volume that should be attached.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['VolumeAttachmentSourcePatchArgs']]):
        pulumi.set(self, "source", value)


if not MYPY:
    class VolumeAttachmentSpecArgsDict(TypedDict):
        """
        VolumeAttachmentSpec is the specification of a VolumeAttachment request.
        """
        attacher: pulumi.Input[builtins.str]
        """
        Attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        """
        node_name: pulumi.Input[builtins.str]
        """
        The node that the volume should be attached to.
        """
        source: pulumi.Input['VolumeAttachmentSourceArgsDict']
        """
        Source represents the volume that should be attached.
        """
elif False:
    VolumeAttachmentSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentSpecArgs:
    def __init__(__self__, *,
                 attacher: pulumi.Input[builtins.str],
                 node_name: pulumi.Input[builtins.str],
                 source: pulumi.Input['VolumeAttachmentSourceArgs']):
        """
        VolumeAttachmentSpec is the specification of a VolumeAttachment request.
        :param pulumi.Input[builtins.str] attacher: Attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        :param pulumi.Input[builtins.str] node_name: The node that the volume should be attached to.
        :param pulumi.Input['VolumeAttachmentSourceArgs'] source: Source represents the volume that should be attached.
        """
        pulumi.set(__self__, "attacher", attacher)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def attacher(self) -> pulumi.Input[builtins.str]:
        """
        Attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName().
        """
        return pulumi.get(self, "attacher")

    @attacher.setter
    def attacher(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attacher", value)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> pulumi.Input[builtins.str]:
        """
        The node that the volume should be attached to.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['VolumeAttachmentSourceArgs']:
        """
        Source represents the volume that should be attached.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['VolumeAttachmentSourceArgs']):
        pulumi.set(self, "source", value)


if not MYPY:
    class VolumeAttachmentStatusArgsDict(TypedDict):
        """
        VolumeAttachmentStatus is the status of a VolumeAttachment request.
        """
        attached: pulumi.Input[builtins.bool]
        """
        Indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        attach_error: NotRequired[pulumi.Input['VolumeErrorArgsDict']]
        """
        The last error encountered during attach operation, if any. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        attachment_metadata: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Upon successful attach, this field is populated with any information returned by the attach operation that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        detach_error: NotRequired[pulumi.Input['VolumeErrorArgsDict']]
        """
        The last error encountered during detach operation, if any. This field must only be set by the entity completing the detach operation, i.e. the external-attacher.
        """
elif False:
    VolumeAttachmentStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentStatusArgs:
    def __init__(__self__, *,
                 attached: pulumi.Input[builtins.bool],
                 attach_error: Optional[pulumi.Input['VolumeErrorArgs']] = None,
                 attachment_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 detach_error: Optional[pulumi.Input['VolumeErrorArgs']] = None):
        """
        VolumeAttachmentStatus is the status of a VolumeAttachment request.
        :param pulumi.Input[builtins.bool] attached: Indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        :param pulumi.Input['VolumeErrorArgs'] attach_error: The last error encountered during attach operation, if any. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attachment_metadata: Upon successful attach, this field is populated with any information returned by the attach operation that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        :param pulumi.Input['VolumeErrorArgs'] detach_error: The last error encountered during detach operation, if any. This field must only be set by the entity completing the detach operation, i.e. the external-attacher.
        """
        pulumi.set(__self__, "attached", attached)
        if attach_error is not None:
            pulumi.set(__self__, "attach_error", attach_error)
        if attachment_metadata is not None:
            pulumi.set(__self__, "attachment_metadata", attachment_metadata)
        if detach_error is not None:
            pulumi.set(__self__, "detach_error", detach_error)

    @property
    @pulumi.getter
    def attached(self) -> pulumi.Input[builtins.bool]:
        """
        Indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "attached")

    @attached.setter
    def attached(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "attached", value)

    @property
    @pulumi.getter(name="attachError")
    def attach_error(self) -> Optional[pulumi.Input['VolumeErrorArgs']]:
        """
        The last error encountered during attach operation, if any. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "attach_error")

    @attach_error.setter
    def attach_error(self, value: Optional[pulumi.Input['VolumeErrorArgs']]):
        pulumi.set(self, "attach_error", value)

    @property
    @pulumi.getter(name="attachmentMetadata")
    def attachment_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Upon successful attach, this field is populated with any information returned by the attach operation that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "attachment_metadata")

    @attachment_metadata.setter
    def attachment_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attachment_metadata", value)

    @property
    @pulumi.getter(name="detachError")
    def detach_error(self) -> Optional[pulumi.Input['VolumeErrorArgs']]:
        """
        The last error encountered during detach operation, if any. This field must only be set by the entity completing the detach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "detach_error")

    @detach_error.setter
    def detach_error(self, value: Optional[pulumi.Input['VolumeErrorArgs']]):
        pulumi.set(self, "detach_error", value)


if not MYPY:
    class VolumeAttachmentArgsDict(TypedDict):
        """
        VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

        VolumeAttachment objects are non-namespaced.
        """
        spec: pulumi.Input['VolumeAttachmentSpecArgsDict']
        """
        Specification of the desired attach/detach volume behavior. Populated by the Kubernetes system.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        status: NotRequired[pulumi.Input['VolumeAttachmentStatusArgsDict']]
        """
        Status of the VolumeAttachment request. Populated by the entity completing the attach or detach operation, i.e. the external-attacher.
        """
elif False:
    VolumeAttachmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttachmentArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input['VolumeAttachmentSpecArgs'],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 status: Optional[pulumi.Input['VolumeAttachmentStatusArgs']] = None):
        """
        VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

        VolumeAttachment objects are non-namespaced.
        :param pulumi.Input['VolumeAttachmentSpecArgs'] spec: Specification of the desired attach/detach volume behavior. Populated by the Kubernetes system.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['VolumeAttachmentStatusArgs'] status: Status of the VolumeAttachment request. Populated by the entity completing the attach or detach operation, i.e. the external-attacher.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'storage.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'VolumeAttachment')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input['VolumeAttachmentSpecArgs']:
        """
        Specification of the desired attach/detach volume behavior. Populated by the Kubernetes system.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input['VolumeAttachmentSpecArgs']):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['VolumeAttachmentStatusArgs']]:
        """
        Status of the VolumeAttachment request. Populated by the entity completing the attach or detach operation, i.e. the external-attacher.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['VolumeAttachmentStatusArgs']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class VolumeAttributesClassArgsDict(TypedDict):
        """
        VolumeAttributesClass represents a specification of mutable volume attributes defined by the CSI driver. The class can be specified during dynamic provisioning of PersistentVolumeClaims, and changed in the PersistentVolumeClaim spec after provisioning.
        """
        driver_name: pulumi.Input[builtins.str]
        """
        Name of the CSI driver This field is immutable.
        """
        api_version: NotRequired[pulumi.Input[builtins.str]]
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        kind: NotRequired[pulumi.Input[builtins.str]]
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        metadata: NotRequired[pulumi.Input['_meta.v1.ObjectMetaArgsDict']]
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        parameters hold volume attributes defined by the CSI driver. These values are opaque to the Kubernetes and are passed directly to the CSI driver. The underlying storage provider supports changing these attributes on an existing volume, however the parameters field itself is immutable. To invoke a volume update, a new VolumeAttributesClass should be created with new parameters, and the PersistentVolumeClaim should be updated to reference the new VolumeAttributesClass.

        This field is required and must contain at least one key/value pair. The keys cannot be empty, and the maximum number of parameters is 512, with a cumulative max size of 256K. If the CSI driver rejects invalid parameters, the target PersistentVolumeClaim will be set to an "Infeasible" state in the modifyVolumeStatus field.
        """
elif False:
    VolumeAttributesClassArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeAttributesClassArgs:
    def __init__(__self__, *,
                 driver_name: pulumi.Input[builtins.str],
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        VolumeAttributesClass represents a specification of mutable volume attributes defined by the CSI driver. The class can be specified during dynamic provisioning of PersistentVolumeClaims, and changed in the PersistentVolumeClaim spec after provisioning.
        :param pulumi.Input[builtins.str] driver_name: Name of the CSI driver This field is immutable.
        :param pulumi.Input[builtins.str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[builtins.str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: parameters hold volume attributes defined by the CSI driver. These values are opaque to the Kubernetes and are passed directly to the CSI driver. The underlying storage provider supports changing these attributes on an existing volume, however the parameters field itself is immutable. To invoke a volume update, a new VolumeAttributesClass should be created with new parameters, and the PersistentVolumeClaim should be updated to reference the new VolumeAttributesClass.
               
               This field is required and must contain at least one key/value pair. The keys cannot be empty, and the maximum number of parameters is 512, with a cumulative max size of 256K. If the CSI driver rejects invalid parameters, the target PersistentVolumeClaim will be set to an "Infeasible" state in the modifyVolumeStatus field.
        """
        pulumi.set(__self__, "driver_name", driver_name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'storage.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'VolumeAttributesClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the CSI driver This field is immutable.
        """
        return pulumi.get(self, "driver_name")

    @driver_name.setter
    def driver_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "driver_name", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        parameters hold volume attributes defined by the CSI driver. These values are opaque to the Kubernetes and are passed directly to the CSI driver. The underlying storage provider supports changing these attributes on an existing volume, however the parameters field itself is immutable. To invoke a volume update, a new VolumeAttributesClass should be created with new parameters, and the PersistentVolumeClaim should be updated to reference the new VolumeAttributesClass.

        This field is required and must contain at least one key/value pair. The keys cannot be empty, and the maximum number of parameters is 512, with a cumulative max size of 256K. If the CSI driver rejects invalid parameters, the target PersistentVolumeClaim will be set to an "Infeasible" state in the modifyVolumeStatus field.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)


if not MYPY:
    class VolumeErrorArgsDict(TypedDict):
        """
        VolumeError captures an error encountered during a volume operation.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        String detailing the error encountered during Attach or Detach operation. This string maybe logged, so it should not contain sensitive information.
        """
        time: NotRequired[pulumi.Input[builtins.str]]
        """
        Time the error was encountered.
        """
elif False:
    VolumeErrorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeErrorArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 time: Optional[pulumi.Input[builtins.str]] = None):
        """
        VolumeError captures an error encountered during a volume operation.
        :param pulumi.Input[builtins.str] message: String detailing the error encountered during Attach or Detach operation. This string maybe logged, so it should not contain sensitive information.
        :param pulumi.Input[builtins.str] time: Time the error was encountered.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String detailing the error encountered during Attach or Detach operation. This string maybe logged, so it should not contain sensitive information.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the error was encountered.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time", value)


